# Contributing to talkd.ai/Dialog

Thank you for your interest in contributing to the talkdai/Dialog project! We appreciate your support and welcome all contributions, whether they are bug reports, feature suggestions, code improvements, documentation enhancements, or anything else that helps improve the project.

## Table of Contents

1. [Code of Conduct](#code-of-conduct)
2. [Getting Started](#getting-started)
3. [How to Contribute](#how-to-contribute)
    - [Reporting Bugs](#reporting-bugs)
    - [Suggesting Features](#suggesting-features)
    - [Contributing Code](#contributing-code)
    - [Improving Documentation](#improving-documentation)
4. [Style Guides](#style-guides)
5. [Community](#community)
6. [License](#license)
7. [Maintainer Merge Policy](#maintainer-merge-policy)

## Code of Conduct

Please read and adhere to our [Code of Conduct](CODE_OF_CONDUCT.md) to ensure a welcoming and friendly environment for everyone involved.

## Getting Started

To start contributing, follow these steps:

1. **Fork the repository**: Click the "Fork" button on the top right of the repository page.
2. **Clone your fork**: Clone your forked repository to your local machine.
    ```sh
    git clone https://github.com/your-username/dialog.git
    ```
3. **Create a new branch**: Create a new branch for your work.
    ```sh
    git checkout -b my-new-feature
    ```
4. **Set up the development environment**: Follow the instructions in the [README](README.md) to set up the project on your local machine.

## How to Contribute

### Reporting Bugs

If you find a bug, please report it by [opening an issue](https://github.com/talkdai/dialog/issues) with the following information:
- A clear and descriptive title.
- Steps to reproduce the issue.
- Expected and actual behavior.
- Screenshots, if applicable.
- Any additional information that might help us diagnose the problem.

### Suggesting Features

We are always looking to improve talkdai/Dialog! To suggest a new feature:
- [Open an issue](https://github.com/talkdai/dialog/issues) with a descriptive title.
- Explain why this feature would be useful.
- Describe the feature in detail.
- Include any relevant examples or mockups.

### Contributing Code

1. **Check existing issues**: Look for existing issues that might cover your changes. If there isn't one, create a new issue to discuss the change.
2. **Fork and clone the repository**: See [Getting Started](#getting-started).
3. **Create a branch**: Make your changes in a new branch.
4. **Write tests**: Ensure that your changes are covered by tests.
5. **Commit your changes**: Write clear and concise commit messages.
6. **Push your branch**: Push your branch to your forked repository.
    ```sh
    git push origin my-new-feature
    ```
7. **Create a Pull Request**: Go to the original repository and [create a pull request](https://github.com/talkdai/dialog/pulls). Please provide a detailed description of your changes and link any related issues.

### Improving Documentation

Good documentation helps others understand and use the project effectively. To contribute to documentation:
- Improve existing documentation in the `docs` folder.
- Add new documentation for new features.
- Ensure examples are clear and helpful.
- Fix any typos or grammatical errors.

## Style Guides

### Code Style

- Follow the existing code style and conventions.
- Use meaningful variable and function names.
- Keep your code clean and well-commented.

### Commit Messages

- Use clear, descriptive commit messages.
- Follow the format: `Short summary (max 50 characters)` followed by an optional detailed explanation.

### Documentation

- Write in clear, concise English.
- Use appropriate formatting for headings, lists, code blocks, etc.
- Provide examples where necessary.

## Community

Join the conversation and connect with other contributors:
- Follow us on [Twitter](https://twitter.com/talkdai).
- Join our [Discord](https://discord.gg/talkdai) community.
- Subscribe to our [newsletter](https://talkdai.com/newsletter) for updates.

## License

By contributing to talkdai/Dialog, you agree that your contributions will be licensed under the [MIT License](LICENSE).

## Maintainer Merge Policy

Maintainers play a crucial role in keeping the project moving forward. To streamline the process, maintainers have the discretion to merge a pull request without a review if it has been open for at least 3 days and has not received any reviews or comments. This helps ensure timely progress while still allowing ample opportunity for community feedback.

---

Thank you for contributing to talkdai/Dialog! Your support and contributions are invaluable in helping us build and improve this project. We look forward to collaborating with you!
