# Security Policy

## Supported Versions

We take security seriously and aim to ensure the talkdai/Dialog project is secure for all users. We support the following versions with security updates:

| Version | Supported          |
| ------- | ------------------ |
| 1.x     | :white_check_mark: |
| < 1.0   | :x:                |

## Reporting a Vulnerability

If you discover a security vulnerability, we encourage you to report it as soon as possible. Please follow the steps below to report a vulnerability:

1. **Do not open an issue on GitHub**: Security issues should not be publicly disclosed until they have been addressed. Avoid discussing potential vulnerabilities in public forums such as GitHub issues, forums, or social media.

2. **Send an email to the security team**: Report the vulnerability to our security team by sending an email to [foss@talkdai.com](mailto:foss@talkdai.com). Please include as much information as possible to help us understand the nature and scope of the issue:
    - A detailed description of the vulnerability.
    - Steps to reproduce the vulnerability.
    - Any relevant screenshots or code snippets.
    - Potential impact of the vulnerability.
    - Any other relevant information.

3. **Acknowledgement**: We will acknowledge the receipt of your vulnerability report within 72 hours and will provide you with a plan for addressing the issue, including an estimated timeline for a fix.

4. **Coordinate disclosure**: Once the vulnerability is fixed, we will coordinate with you to disclose the issue responsibly. We aim to disclose security vulnerabilities in a timely manner while ensuring that users have had adequate time to apply the fix.

## Security Updates

We regularly review our codebase for potential security issues and apply patches as necessary. Users are encouraged to keep their installations up-to-date to benefit from the latest security fixes. 

## Security Best Practices

To help keep your deployment of talkdai/Dialog secure, please consider the following best practices:

- **Keep dependencies up-to-date**: Regularly update your dependencies to ensure you are using the latest versions with security patches.
- **Use strong passwords**: Ensure that all user accounts, especially those with administrative privileges, use strong, unique passwords.
- **Monitor your deployment**: Regularly monitor your deployment for any unusual activity or potential security issues.
- **Backup your data**: Regularly backup your data to prevent data loss in the event of a security breach.

## Contact

If you have any questions or concerns regarding the security of talkdai/Dialog, please contact our team of maintainers at [foss@talkdai.com](mailto:foss@talkdai.com).

Thank you for helping us keep talkdai/Dialog secure!
