package compress

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestNewFileInfoPngImage(t *testing.T) {
	fi, err := newFileInfo("./testdata/image.png")

	assert.NoError(t, err)

	assert.Equal(t, uint64(3836), fi.Size())
	assert.Equal(t, "image/png", fi.Type())
}

func TestNewFileInfoEmptyFile(t *testing.T) {
	fi, err := newFileInfo("./testdata/empty")

	assert.NoError(t, err)

	assert.Equal(t, uint64(0), fi.Size())
	assert.Equal(t, "application/octet-stream", fi.Type())
}
