# Changelog

## 1.0.0

### Breaking

- Change `parse_datetime` to no longer assume time. Previously, it
    would assume `00:00:00` if it could not be parsed. This is replaced with an
    opt-in option `assume_time`. See next point. If you relied on this, to
    upgrade add the option; eg: `DateTimeParser.parse_datetime(string,
    assume_time: true)`
- Change `parse_datetime` to no longer convert DateTime to UTC
    timezone. If you relied on this, to upgrade add the option; eg:
    `DateTimeParser.parse_datetime(string, to_utc: true)`
- Change `parse_date` to no longer assume a date. Previously, it
    would assume the current date, and replace the found information from the
    string. This is replaced with an opt-in option of `assume_date`. If you
    relied on this, to upgrade add the option; eg:
    `DateTimeParser.parse_date(string, assume_date: true)`

### Bugs

- Fix a UTC conversion bug between Daylight/Standard time (#20). If you're
    using an earlier version and converting to UTC, please upgrade to >=
    1.0.0-rc2 immediately.
- Fix an epoch subsecond parsing bug (#16) (thanks @tmr08c)
- Updated for compatibility with Elixir 1.10.0

### Features

- Add `parse/2` that will respond with the best match. This function accepts all
    options introduced below.
- Change `parse_datetime/1` to `parse_datetime/2` to accept options:
  - `assume_time: true | %Time{} | false` with the default of false.
- Change `parse_date/1` to `parse_date/2` to accept options:
  - `assume_date: true | %Date{} | false` with the default of false.
- Add support for parsing negative epoch times. (#24) (thanks @tmr08c)
- Add bang variants, `parse!/2`, `parse_datetime!/2`, `parse_time!/2`, and
    `parse_date!/2`
- Added `parsers: []` option to add or disable parsers. This is helpful if you
    are don't want to consider Serial or Epoch timestamps.

## 0.2.0

- Add Serial time support

## 0.1.4

- Refactor
- Support subsecond parsing to 24 digits (yoctoseconds) [thanks @myfreeweb]

## 0.1.3

- Support parsing Unix epoch times from strings
- Fix microsecond parsing

## 0.1.2

- Validate days of month. Previously it would allow invalid days such as Feb 30.
  Now it will check if the year is a leap year and allow up to 29, and otherwise
  28 for Feb. It will also reject day 31 on months without 31 days.

## 0.1.1

- Fix PM 12-hr conversion. The bug would convert 12:34PM to 24:34 which is
  not valid

## 0.1.0

- Add DateTimeParser.parse_datetime/2
- Add DateTimeParser.parse_date/1
- Add DateTimeParser.parse_time/1
