# Release Notes

## Microsoft.Data.SqlClient 1.0.19189.1-Preview released 8 July 2019

This update does not add any major features over the previous preview release but includes the below fixes and changes.

### Target Platform Support

* .NET Framework 4.6+
* .NET Core 2.1+ (Windows x86, Windows x64, Linux, macOS)
* .NET Standard 2.0+ (Windows x86, Windows x64, Linux, macOS)

### Dependencies

#### .NET Framework

* System.Data.Common 4.3.0
* Microsoft.Data.SqlClient.SNI 1.0.19178.1-Preview

#### .NET Core

* Microsoft.Win32.Registry 4.5.0
* runtime.native.System.Data.SqlClient.sni 4.4.0
* System.Security.Principal.Windows 4.5.0
* System.Text.Encoding.CodePages 4.5.0
* System.Configuration.ConfigurationManager 4.5.0

#### .NET Standard

* Microsoft.Win32.Registry 4.5.0
* runtime.native.System.Data.SqlClient.sni 4.4.0
* System.Buffers 4.4.0
* System.Diagnostics.DiagnosticSource 4.5.0
* System.Memory 4.5.1
* System.Security.Principal.Windows 4.5.0
* System.Text.Encoding.CodePages 4.5.0
* System.Configuration.ConfigurationManager 4.5.0

### Fixed

* Microsoft.SqlServer.Server conflicts between System.Data.SqlClient and Microsoft.Data.SqlClient [SqlClient Issue #4](https://github.com/dotnet/SqlClient/issues/4)
  SqlDataRecord, SqlMetaData, and UDT related classes were moved into Microsoft.Data.SqlClient.Server to avoid namespace conflicts. While UDT related classes are there, UDTs do not currently work in Microsoft.Data.SqlClient.
* Committing certain data results in an infinite loop inside System.Data.SqlClient.TdsParserStateObject.cs. Ported from [CoreFx PR 34709](https://github.com/dotnet/corefx/pull/34709)
* When targeting **.NET Framework** and platform **AnyCPU** or **x86**, you may see a build warning about processor architecture mismatch: *"Warning: There was a mismatch between the processor architecture of the project being built "MSIL" and the processor architecture of the reference "Microsoft.Data.SqlClient...*"

#### .NET Framework

* Fixed an issue when a pooled connection was switched between databases supporting UTF-8 which resulted in a mismatch between encoding and code page.

#### .NET Core

* When doing a hard copy of a sql parameter, the MetaType was not copied if the value of the parameter was not defined. This resulted in the wrong SqlType of the parameter.

### Changes

* On .NET Framework, the native code portion of Microsoft.Data.SqlClient has been split into its own package, Microsoft.Data.SqlClient.SNI, which is a dependency of Microsoft.Data.SqlClient when targeting .NET Framework. This fixes the x64-only issue and adds x86 support on .NET Framework. Functionally, Microsoft.Data.SqlClient.dll is now AnyCPU (it was previously mixed-mode) and it will dynamically load x86\SNI.dll or x64\SNI.dll at runtime depending on the architecture of the underlying process. Applications targeting .NET Framework will need to ensure the SNI.dll files in their respective subfolders are deployed with the application.
* Fixed various typos in code comments and changed ".Net" to ".NET" in comments and error messages for consistency.
* Updated SqlClient manual test feature detection from [CoreFx PR 34040](https://github.com/dotnet/corefx/pull/34040)
* Reduced metadata memory size in SqlClient from [CoreFx PR 34393](https://github.com/dotnet/corefx/pull/34393)
* SqlClient add TestPacketNumberWraparound fix and test from [CoreFx PR 34709](https://github.com/dotnet/corefx/pull/34709)
* SqlClient enhancement: enable GetFieldValue\<XmlReader\> from [CoreFx PR 34880](https://github.com/dotnet/corefx/pull/34880)
* Allow specifying a UDT SqlParameter value as bytes from [CoreFx PR 36678](https://github.com/dotnet/corefx/pull/36678)

#### .NET Core changes

* Enable BeginExecuteReader methods on SqlCommand from [CoreFx PR 33660](https://github.com/dotnet/corefx/pull/33660)

#### .NET Core performance improvements

* Avoid unnecessary Span to ReadOnlySpan casts from [CoreFx PR 34646](https://github.com/dotnet/corefx/pull/34646)
* SqlClient environment change optimization from [CoreFx PR 34573](https://github.com/dotnet/corefx/pull/34573)

### New Features

#### New features over .NET Framework 4.7.2 System.Data.SqlClient.

* [Data Classification](#data-classification) - Available in Azure SQL Database and Microsoft SQL Server 2019 since CTP 2.0.
* [UTF-8 support](#utf-8-support) - Available in Microsoft SQL Server SQL Server 2019 since CTP 2.3.

#### New features over .NET Core 2.2 System.Data.SqlClient.

* [Data Classification](#data-classification) - Available in Azure SQL Database and Microsoft SQL Server 2019 since CTP 2.0.
* [UTF-8 support](#utf-8-support) - Available in Microsoft SQL Server SQL Server 2019 since CTP 2.3.
* [Always Encrypted](#always-encrypted) - Always Encrypted is available in Microsoft SQL Server 2016 and higher.

### Known Issues

* User Data Types (UDTs) do not work with Microsoft.Data.SqlClient.

### Data Classification

Data Classification brings a new set of APIs exposing read-only Data Sensitivity and Classification information about objects retrieved via SqlDataReader when the underlying source supports the feature and contains metadata about [data sensitivity and classification](https://docs.microsoft.com/sql/relational-databases/security/sql-data-discovery-and-classification?view=sql-server-2017):

```C#
public class SqlDataReader
{
    public Microsoft.Data.SqlClient.DataClassification.SensitivityClassification SensitivityClassification
}

namespace Microsoft.Data.SqlClient.DataClassification
{
    public class ColumnSensitivity
    {
        public System.Collections.ObjectModel.ReadOnlyCollection<Microsoft.Data.SqlClient.DataClassification.SensitivityProperty> SensitivityProperties
    }
    public class InformationType
    {
        public string Id
        public string Name
    }
    public class Label
    {
        public string Id
        public string Name
    }
    public class SensitivityClassification
    {
        public System.Collections.ObjectModel.ReadOnlyCollection<Microsoft.Data.SqlClient.DataClassification.ColumnSensitivity> ColumnSensitivities
        public System.Collections.ObjectModel.ReadOnlyCollection<Microsoft.Data.SqlClient.DataClassification.InformationType> InformationTypes
        public System.Collections.ObjectModel.ReadOnlyCollection<Microsoft.Data.SqlClient.DataClassification.Label> Labels
    }
    public class SensitivityProperty
    {
        public Microsoft.Data.SqlClient.DataClassification.InformationType InformationType
        public Microsoft.Data.SqlClient.DataClassification.Label Label
    }
}
```

### UTF-8 Support

UTF-8 support does not require any application code changes. These SqlClient changes simply optimize the communication between the client and server when the server supports UTF-8 and the underlying column collation is UTF-8. See the UTF-8 section under [What's new in SQL Server 2019 preview](https://docs.microsoft.com/sql/sql-server/what-s-new-in-sql-server-ver15?view=sqlallproducts-allversions#utf-8-support-ctp-23).

### Always Encrypted

In general, existing documentation which uses System.Data.SqlClient on .NET Framework **and built-in column master key store providers** should now work with .NET Core, too.

* [Develop using Always Encrypted with .NET Framework Data Provider](https://docs.microsoft.com/sql/relational-databases/security/encryption/develop-using-always-encrypted-with-net-framework-data-provider?view=sql-server-2017)
* [Always Encrypted: Protect sensitive data and store encryption keys in the Windows certificate store](https://docs.microsoft.com/azure/sql-database/sql-database-always-encrypted)

**Notes:**

* There is no key store provider for Azure Key Vault and Microsoft.Data.SqlClient at this time.
* Always Encrypted with secure enclaves is not supported with Microsoft.Data.SqlClient.
* Always Encrypted is only supported against .NET Framework and .NET Core targets. It is not supported against .NET Standard since .NET Standard is missing certain encryption dependencies.
