# Release Notes

## Microsoft.Data.SqlClient 1.1.0-preview2.19309.1 released 4 November 2019

This update brings the below changes over the previous release:

### Added

- Add support for secure enclaves with Always Encrypted [#293](https://github.com/dotnet/SqlClient/pull/293)

### Fixed

- Setting the value DbParameter.DbType to DbType.Time property fails after setting the Value property [#5](https://github.com/dotnet/SqlClient/issues/5)
- SQLDataAdapter.FillSchema doesn't mark computed columns as readonly [#275](https://github.com/dotnet/SqlClient/issues/275)
- SqlDependency.Start throws FileNotFoundException [#260](https://github.com/dotnet/SqlClient/issues/260)
- Misleading ADP_OpenReaderExists exception message on MARS-disabled Sql Connection when incorrectly doing parallel requests [#82](https://github.com/dotnet/SqlClient/issues/82)
- SqlClient ManualTest MARSSyncTimeoutTest fails in managed mode [#108](https://github.com/dotnet/SqlClient/issues/108)
- System.Data.SqlClient.SqlInternalConnectionTds constructor purges original call stack when re-throwing an exception [#100](https://github.com/dotnet/SqlClient/issues/100)
- InvalidOperationException(SqlException) on SqlBulkCopy [#221](https://github.com/dotnet/SqlClient/issues/221)
- Exception message grammar: "An SqlParameter [...] is not contained by this SqlParameterCollection" [#159](https://github.com/dotnet/SqlClient/issues/159)
- Fixing incorrect event id and opcode for the SqlEventSource [#241](https://github.com/dotnet/SqlClient/pull/241)

### Changes

- Update dependency to Microsoft.Data.SqlClient.SNI v1.1.0 [#276](https://github.com/dotnet/SqlClient/pull/276)
- Correct timeout remarks for async command methods [#264](https://github.com/dotnet/SqlClient/pull/264)
- Improve SqlBulkCopy truncation error message [#256](https://github.com/dotnet/SqlClient/issues/256)
- Intellisense tooltip for SqlCommand's CommandTimeout doesn't describe units [#33](https://github.com/dotnet/SqlClient/issues/33)
- Enable SQL Command text for non-stored procs in EventSource events for .NET Framework [242](https://github.com/dotnet/SqlClient/pull/242)
- Many test changes to support a public CI

### New Features

New features over the 1.0 release of Microsoft.Data.SqlClient.

- [Always Encrypted with secure enclaves](#always-encrypted-with-secure-enclaves) - Always Encrypted is available starting in Microsoft SQL Server 2016. Secure enclaves are available starting in Microsoft SQL Server 2019.

## Target Platform Support

- .NET Framework 4.6+
- .NET Core 2.1+ (Windows x86, Windows x64, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Linux, macOS)

### Dependencies

#### .NET Framework

- System.Data.Common 4.3.0
- Microsoft.Data.SqlClient.SNI 1.1.0
- Microsoft.Identity.Client 3.0.8
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.5.0
- Microsoft.IdentityModel.JsonWebTokens 5.5.0

#### .NET Core

- Microsoft.Win32.Registry 4.5.0
- runtime.native.System.Data.SqlClient.sni 4.4.0
- System.Security.Principal.Windows 4.5.0
- System.Text.Encoding.CodePages 4.5.0
- System.Configuration.ConfigurationManager 4.5.0
- Microsoft.Identity.Client 3.0.8
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.5.0
- Microsoft.IdentityModel.JsonWebTokens 5.5.0

#### .NET Standard

- Microsoft.Win32.Registry 4.5.0
- runtime.native.System.Data.SqlClient.sni 4.4.0
- System.Buffers 4.4.0
- System.Diagnostics.DiagnosticSource 4.5.0
- System.Memory 4.5.1
- System.Security.Principal.Windows 4.5.0
- System.Text.Encoding.CodePages 4.5.0
- System.Configuration.ConfigurationManager 4.5.0
- Microsoft.Identity.Client 3.0.8

### Always Encrypted with secure enclaves

In general, existing documentation which uses System.Data.SqlClient on .NET Framework should now work with .NET Core, too.

- [Develop using Always Encrypted with .NET Framework Data Provider](https://docs.microsoft.com/sql/relational-databases/security/encryption/develop-using-always-encrypted-with-net-framework-data-provider)
- [Always Encrypted: Protect sensitive data and store encryption keys in the Windows certificate store](https://docs.microsoft.com/azure/sql-database/sql-database-always-encrypted)

In order to use the enclave feature, connection strings should include the required attestation protocol and attestation URL. Examples:

- `Attestation Protocol=HGS;Enclave Attestation Url=<attestation_url_for_HGS>`
