# Release Notes

## General Availability of Microsoft.Data.SqlClient 1.1.4 released 10 March 2021

This update brings the below changes over the previous release:

### Fixed
- Fixed wrong results issues by changing the timeout timer to ensure a correct execution state [#950](https://github.com/dotnet/SqlClient/pull/950)
- Fixed MARS header contains errors issue against .NET Framework 4.8+ [#959](https://github.com/dotnet/SqlClient/pull/959)


## Target Platform Support

- .NET Framework 4.6+
- .NET Core 2.1+ (Windows x86, Windows x64, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Linux, macOS)

### Dependencies

#### .NET Framework

- System.Data.Common 4.3.0
- Microsoft.Data.SqlClient.SNI [1.1.0,1.2.0)
- Microsoft.Identity.Client 3.0.8
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.5.0
- Microsoft.IdentityModel.JsonWebTokens 5.5.0

#### .NET Core

- Microsoft.Win32.Registry 4.5.0
- runtime.native.System.Data.SqlClient.sni 4.4.0
- System.Security.Principal.Windows 4.5.0
- System.Text.Encoding.CodePages 4.5.0
- System.Configuration.ConfigurationManager 4.5.0
- Microsoft.Identity.Client 3.0.8
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.5.0
- Microsoft.IdentityModel.JsonWebTokens 5.5.0

#### .NET Standard

- Microsoft.Win32.Registry 4.5.0
- runtime.native.System.Data.SqlClient.sni 4.4.0
- System.Buffers 4.4.0
- System.Diagnostics.DiagnosticSource 4.5.0
- System.Memory 4.5.1
- System.Security.Principal.Windows 4.5.0
- System.Text.Encoding.CodePages 4.5.0
- System.Configuration.ConfigurationManager 4.5.0
- Microsoft.Identity.Client 3.0.8

### Always Encrypted with secure enclaves

In general, existing documentation that uses System.Data.SqlClient on .NET Framework should now work with .NET Core, too.

- [Develop using Always Encrypted with .NET Framework Data Provider](https://docs.microsoft.com/sql/relational-databases/security/encryption/develop-using-always-encrypted-with-net-framework-data-provider)
- [Always Encrypted: Protect sensitive data and store encryption keys in the Windows certificate store](https://docs.microsoft.com/azure/sql-database/sql-database-always-encrypted)

In order to use the enclave feature, the connection string should include the required attestation protocol and attestation URL.

Example:

- `Attestation Protocol=HGS;Enclave Attestation Url=<attestation_url_for_HGS>`
