# Release Notes

## Microsoft.Data.SqlClient 2.0.0-preview1.20021.1 released 21 January 2020

This update brings the below changes over the previous release:

### Added
- Added support to allow large UDT buffer size (_upto_ `Int.MaxValue`) as supported by SQL Server starting TDS 7.3 [#340](https://github.com/dotnet/SqlClient/pull/340)

### Fixed
- Fixed issues with `SqlCommandSet` not working with Byte Array parameters [#360](https://github.com/dotnet/SqlClient/pull/360)
- Fixed Statement command cancellation in Managed SNI [#248](https://github.com/dotnet/SqlClient/pull/248) - Ported [dotnet/corefx#38271](https://github.com/dotnet/corefx/pull/38271)
- Fixed zero connection timeout issue in Managed SNI [#332](https://github.com/dotnet/SqlClient/pull/332)
- Fixed "DataType" metadata information for TinyInt datatype to be `System.Byte` [#338](https://github.com/dotnet/SqlClient/pull/338)
- Fixed driver behavior to use `CancellationTokenResource` only for non-infinite timeout and cleanup after usage [#339](https://github.com/dotnet/SqlClient/pull/339)
- Fixed `ConnectionTime` and `ClientConnectionId` reported by `SqlStatistics` when connection is closed [#341](https://github.com/dotnet/SqlClient/pull/341)
- Fixed deadlock issues by reverting async changes to `SNIPacket` [#349](https://github.com/dotnet/SqlClient/pull/349)

### Changes
- Improved performance of Managed SNI by removing double fetch of domain name [#366](https://github.com/dotnet/SqlClient/pull/366)
- Improved performance of Async Method Allocations in Managed SNI [#328](https://github.com/dotnet/SqlClient/pull/328)
- Improved performance of Managed SNI by enhancing utilization of resources [#173](https://github.com/dotnet/SqlClient/pull/173) - Ported [dotnet/corefx#35363](https://github.com/dotnet/corefx/pull/35363) and [dotnet/corefx#40732](https://github.com/dotnet/corefx/pull/40732)
- Improved performance of Managed SNI RPC Parameter Usage [#209](https://github.com/dotnet/SqlClient/pull/209) - Ported [dotnet/corefx#34049](https://github.com/dotnet/corefx/pull/34049)
- Changed enclave key map to be lazy initialized [#372](https://github.com/dotnet/SqlClient/pull/372)
- Changed `Recieve()` and `ReceiveAsync()` implementation to receive null packets on failure [#350](https://github.com/dotnet/SqlClient/pull/350)
- Changed `EnclaveProviderBase` caching implementation to support Async Scenarios _(Introduces breaking changes)_ [#346](https://github.com/dotnet/SqlClient/pull/346)

### Breaking Changes
- Public APIs in `SqlColumnEncryptionEnclaveProvider` have been modified in PR [#346](https://github.com/dotnet/SqlClient/pull/346) as under:

    _[Applies to both .NET Framework and .NET Core targeting applications]_

    #### `CreateEnclaveSession()`

    ```cs
    // Old Definition
    public abstract void CreateEnclaveSession(byte[] enclaveAttestationInfo, System.Security.Cryptography.ECDiffieHellmanCng clientDiffieHellmanKey, string attestationUrl, string servername, out Microsoft.Data.SqlClient.SqlEnclaveSession sqlEnclaveSession, out long counter);

    // New Definition
    public abstract void CreateEnclaveSession(byte[] enclaveAttestationInfo, System.Security.Cryptography.ECDiffieHellmanCng clientDiffieHellmanKey, string attestationUrl, string servername, byte[] customData, int customDataLength, out Microsoft.Data.SqlClient.SqlEnclaveSession sqlEnclaveSession, out long counter);
    ```

    #### `GetAttestationParameters()`

    ```cs
    // Old Definition
    public abstract Microsoft.Data.SqlClient.SqlEnclaveAttestationParameters GetAttestationParameters();
    
    // New Definition
    public abstract Microsoft.Data.SqlClient.SqlEnclaveAttestationParameters GetAttestationParameters(string attestationUrl, byte[] customData, int customDataLength);
    ```

    #### `GetEnclaveSession()`

    ```cs
    // Old Definition
    public abstract void GetEnclaveSession(string serverName, string attestationUrl, out Microsoft.Data.SqlClient.SqlEnclaveSession sqlEnclaveSession, out long counter);

    // New Definition
    public abstract void GetEnclaveSession(string serverName, string attestationUrl, bool generateCustomData, out Microsoft.Data.SqlClient.SqlEnclaveSession sqlEnclaveSession, out long counter, out byte[] customData, out int customDataLength);
    ```

## Target Platform Support

- .NET Framework 4.6+
- .NET Core 2.1+ (Windows x86, Windows x64, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Linux, macOS)

### Dependencies

#### .NET Framework

- System.Data.Common 4.3.0
- Microsoft.Data.SqlClient.SNI 1.1.0
- Microsoft.Identity.Client 3.0.8

#### .NET Core

- Microsoft.Win32.Registry 4.5.0
- runtime.native.System.Data.SqlClient.sni 4.4.0
- System.Security.Principal.Windows 4.5.0
- System.Text.Encoding.CodePages 4.5.0
- System.Configuration.ConfigurationManager 4.5.0
- Microsoft.Identity.Client 3.0.8

#### .NET Standard

- Microsoft.Win32.Registry 4.5.0
- runtime.native.System.Data.SqlClient.sni 4.4.0
- System.Buffers 4.4.0
- System.Diagnostics.DiagnosticSource 4.5.0
- System.Memory 4.5.1
- System.Security.Principal.Windows 4.5.0
- System.Text.Encoding.CodePages 4.5.0
- System.Configuration.ConfigurationManager 4.5.0
- Microsoft.Identity.Client 3.0.8
