# Release Notes

## Microsoft.Data.SqlClient 2.0.0-preview3.20122.2 released 1 May 2020

This update brings the below changes over the previous release:

### Added
- Allow passing username with Active Directory Interactive Authentication in .NET Framework [#492](https://github.com/dotnet/SqlClient/pull/492)
- Allow large UDT buffers for .NET Framework [#456](https://github.com/dotnet/SqlClient/pull/456) 
- Added "Transaction Id" and "Client Version" in Diagnostic Source traces [#515](https://github.com/dotnet/SqlClient/pull/515)
- Added new `SqlConnectionOverrides` APIs to perform `SqlConnection.Open()` with fail fast option [#463](https://github.com/dotnet/SqlClient/pull/463)

### Fixed
- Addressed MARS TDS Header errors by reverting changes to make `SqlDataReader.ReadAsync()` non-blocking [#547](https://github.com/dotnet/SqlClient/pull/547)
- Fixed driver behavior to not perform enlistment of pooled connection in aborted transaction [#543](https://github.com/dotnet/SqlClient/pull/543)
- Fixed wrong application domain selected when starting `SqlDependencyListener` [#410](https://github.com/dotnet/SqlClient/pull/410)
- Added missing refs for `RowCopied` property in `SqlBulkCopy` [#508](https://github.com/dotnet/SqlClient/pull/508)

### Changes
- Improved performance by removing unwanted method calls in Event Source tracing [#506](https://github.com/dotnet/SqlClient/pull/506)
- Removed Diagnostic Source and Configuration Manager dependencies from .NET Standard implementation [#535](https://github.com/dotnet/SqlClient/pull/535)
- Removed redundant calls to `DbConnectionPoolKey.GetType()` [#512](https://github.com/dotnet/SqlClient/pull/512)

### Breaking Changes
- Updated driver to perform decimal scale rounding to match SQL Server behavior [#470](https://github.com/dotnet/SqlClient/pull/470)
- Standardized App Context switch that enables Managed SNI on Windows for .NET Core and .NET Standard (break only applies to 2.0 preview releases that introduced the switch) [#548](https://github.com/dotnet/SqlClient/pull/548)


### Enabling decimal truncation behavior conditionally
Starting with v2.0.0-preview3, the decimal data scale will be rounded by the driver by default as is done by SQL Server.
For backwards compatibility, you can set the [AppContext](https://docs.microsoft.com/en-us/dotnet/api/system.appcontext?view=netframework-4.8) switch "Switch.Microsoft.Data.SqlClient.TruncateScaledDecimal" to "true".

To set the switch at application startup, specify:

```cs
AppContext.SetSwitch("Switch.Microsoft.Data.SqlClient.TruncateScaledDecimal", true);
```

### Enabling Managed networking on Windows
This release introduces the renamed AppContext switch "Switch.Microsoft.Data.SqlClient.UseManagedNetworkingOnWindows" that enables the use of Managed SNI instead of native SNI on Windows for testing and debugging purposes. This switch will toggle the driver's behavior to use Managed SNI in .NET Core 2.1+ and .NET Standard 2.0+ projects on Windows.

To set the switch at application startup, specify:

```cs
AppContext.SetSwitch("Switch.Microsoft.Data.SqlClient.UseManagedNetworkingOnWindows", true);
```

## Target Platform Support

- .NET Framework 4.6+
- .NET Core 2.1+ (Windows x86, Windows x64, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Data.SqlClient.SNI 1.1.0+
- Microsoft.Identity.Client 3.0.8
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.6.0
- Microsoft.IdentityModel.JsonWebTokens 5.6.0

#### .NET Core 2.1

- runtime.native.System.Data.SqlClient.sni 4.4.0 
- Microsoft.Win32.Registry 4.7.0 
- System.Security.Principal.Windows 4.7.0 
- System.Text.Encoding.CodePages 4.7.0 
- System.Diagnostics.DiagnosticSource 4.7.0 
- System.Configuration.ConfigurationManager 4.7.0 
- System.Runtime.Caching 4.7.0 
- Microsoft.Identity.Client 4.7.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.6.0
- Microsoft.IdentityModel.JsonWebTokens 5.6.0

#### .NET Core 3.1

- runtime.native.System.Data.SqlClient.sni 4.4.0 
- Microsoft.Win32.Registry 4.7.0 
- System.Security.Principal.Windows 4.7.0 
- System.Text.Encoding.CodePages 4.7.0 
- System.Diagnostics.DiagnosticSource 4.7.0 
- System.Configuration.ConfigurationManager 4.7.0 
- System.Runtime.Caching 4.7.0 
- Microsoft.Identity.Client 4.7.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.6.0
- Microsoft.IdentityModel.JsonWebTokens 5.6.0

#### .NET Standard

- runtime.native.System.Data.SqlClient.sni 4.4.0
- Microsoft.Win32.Registry 4.7.0
- System.Buffers 4.5.0
- System.Memory 4.5.3
- System.Security.Principal.Windows 4.7.0
- System.Text.Encoding.CodePages 4.7.0
- Microsoft.Identity.Client 4.7.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.6.0
- Microsoft.IdentityModel.JsonWebTokens 5.6.0
