# Release Notes

## Microsoft.Data.SqlClient 2.0.0-preview4.20142.4 released 21 May 2020

This update brings the below changes over the previous release:

### Added
- Microsoft.Data.SqlClient (.NET Core and .NET Standard) on Windows is now dependent on **Microsoft.Data.SqlClient.SNI.runtime**, replacing the previous dependency on **runtime.native.System.Data.SqlClient.SNI** [#570](https://github.com/dotnet/SqlClient/pull/570)
- The new **Microsoft.Data.SqlClient.SNI.runtime** dependency adds support for the *ARM* platform along with the already supported platforms *ARM64*, *x64* and *x86* on Windows [#570](https://github.com/dotnet/SqlClient/pull/570)
- Improved driver performance by introducing managed packet recycling [#389](https://github.com/dotnet/SqlClient/pull/389)

### Fixed
- Fixed `SqlBulkCopy` to work with database columns containing metadata about data classification [#568](https://github.com/dotnet/SqlClient/pull/568)
- Fixed unsafe cast in `SqlException` for `SerializationEntry.Value` 
- Fixed null reference exceptions in `SqlDelegatedTransaction` methods [#563](https://github.com/dotnet/SqlClient/pull/563)

### Changes
- Standardized connection string properties for enhanced user experience [#534](https://github.com/dotnet/SqlClient/pull/534)
- Improved performance by reducing eventsource tracing related to allocations from TVP write methods [#557](https://github.com/dotnet/SqlClient/pull/557) [#564](https://github.com/dotnet/SqlClient/pull/564)

### Breaking Changes
- For .NET Framework applications consuming **Microsoft.Data.SqlClient**, the `SNI.dll` files previously downloaded to the `bin\x64` and `bin\x86` folders are now named `Microsoft.Data.SqlClient.SNI.x64.dll` and `Microsoft.Data.SqlClient.SNI.x86.dll` and will be downloaded to the `bin` directory, to support auto-loading in the application process [#570](https://github.com/dotnet/SqlClient/pull/570). This change is not going to impact client applications unless a direct reference has been made to `SNI.dll` or the x86 and x64 folders.
- New connection string property synonyms will replace old properties when fetching connection string from `SqlConnectionStringBuilder` for consistency. [Read More](#new-connection-string-property-synonyms)

## New Connection string property synonyms

The below connection properties can be interchangeably used with the new synonyms to avoid spacing confusion and for an enhanced user experience.

|Existing connection string property|New Synonym|
|-----------------------------------|-----------|
| ApplicationIntent | Application Intent |
| ConnectRetryCount | Connect Retry Count |
| ConnectRetryInterval | Connect Retry Interval |
| PoolBlockingPeriod | Pool Blocking Period |
| MultipleActiveResultSets | Multiple Active Result Sets |
| MultiSubnetFailover | Multi Subnet Failover |
| TransparentNetworkIPResolution | Transparent Network IP Resolution |
| TrustServerCertificate | Trust Server Certificate |

> Old properties will continue to be supported for backwards compatibility, but the new connection string properties will now be included when fetching connection string from [SqlConnectionStringBuilder](https://docs.microsoft.com/dotnet/api/microsoft.data.sqlclient.sqlconnectionstringbuilder).

## Target Platform Support

- .NET Framework 4.6+
- .NET Core 2.1+ (Windows x86, Windows x64, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Data.SqlClient.SNI 2.0.0-preview1.20141.10
- Microsoft.Identity.Client 4.7.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.6.0
- Microsoft.IdentityModel.JsonWebTokens 5.6.0

#### .NET Core 2.1

- Microsoft.Data.SqlClient.SNI.runtime 2.0.0-preview1.20141.10
- Microsoft.Win32.Registry 4.7.0 
- System.Security.Principal.Windows 4.7.0 
- System.Text.Encoding.CodePages 4.7.0 
- System.Diagnostics.DiagnosticSource 4.7.0 
- System.Configuration.ConfigurationManager 4.7.0 
- System.Runtime.Caching 4.7.0 
- Microsoft.Identity.Client 4.7.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.6.0
- Microsoft.IdentityModel.JsonWebTokens 5.6.0

#### .NET Core 3.1

- Microsoft.Data.SqlClient.SNI.runtime 2.0.0-preview1.20141.10
- Microsoft.Win32.Registry 4.7.0 
- System.Security.Principal.Windows 4.7.0 
- System.Text.Encoding.CodePages 4.7.0 
- System.Diagnostics.DiagnosticSource 4.7.0 
- System.Configuration.ConfigurationManager 4.7.0 
- System.Runtime.Caching 4.7.0 
- Microsoft.Identity.Client 4.7.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.6.0
- Microsoft.IdentityModel.JsonWebTokens 5.6.0

#### .NET Standard

- Microsoft.Data.SqlClient.SNI.runtime 2.0.0-preview1.20141.10
- Microsoft.Win32.Registry 4.7.0
- System.Buffers 4.5.0
- System.Memory 4.5.3
- System.Security.Principal.Windows 4.7.0
- System.Text.Encoding.CodePages 4.7.0
- Microsoft.Identity.Client 4.7.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.6.0
- Microsoft.IdentityModel.JsonWebTokens 5.6.0
