# Release Notes

## Microsoft.Data.SqlClient 2.1.5 released 30 August 2022

This update brings the below changes over the previous stable release:

### Fixed

- Added CommandText length validation when using stored procedure command types. [#1726](https://github.com/dotnet/SqlClient/pull/1726)
- Fixed Kerberos authentication failure when using .NET 6. [#1727](https://github.com/dotnet/SqlClient/pull/1727)
- Removed union overlay design and used reflection in `SqlTypeWorkarounds`. [#1729](https://github.com/dotnet/SqlClient/pull/1729)

### Target Platform Support

- .NET Framework 4.6+ (Windows x86, Windows x64)
- .NET Core 2.1+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)

### Ensure connections fail when encryption is required

In scenarios where client encryption libraries were disabled or unavailable, it was possible for unencrypted connections to be made when Encrypt was set to true or the server required encryption.

### Dependencies

#### .NET Framework

- Microsoft.Data.SqlClient.SNI 2.1.1
- Microsoft.Identity.Client 4.21.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0

#### .NET Core 2.1

- Microsoft.Data.SqlClient.SNI.runtime 2.1.1
- Microsoft.Win32.Registry 4.7.0
- System.Security.Principal.Windows 4.7.0
- System.Text.Encoding.CodePages 4.7.0
- System.Diagnostics.DiagnosticSource 4.7.0
- System.Configuration.ConfigurationManager 4.7.0
- System.Runtime.Caching 4.7.0
- Microsoft.Identity.Client 4.21.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0

#### .NET Core 3.1

- Microsoft.Data.SqlClient.SNI.runtime 2.1.1
- Microsoft.Win32.Registry 4.7.0
- System.Security.Principal.Windows 4.7.0
- System.Text.Encoding.CodePages 4.7.0
- System.Diagnostics.DiagnosticSource 4.7.0
- System.Configuration.ConfigurationManager 4.7.0
- System.Runtime.Caching 4.7.0
- Microsoft.Identity.Client 4.21.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0

#### .NET Standard 2.0

- Microsoft.Data.SqlClient.SNI.runtime 2.1.1
- Microsoft.Win32.Registry 4.7.0
- System.Buffers 4.5.1
- System.Memory 4.5.4
- System.Security.Principal.Windows 4.7.0
- System.Text.Encoding.CodePages 4.7.0
- System.Runtime.Caching 4.7.0
- Microsoft.Identity.Client 4.21.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0

#### .NET Standard 2.1

- Microsoft.Data.SqlClient.SNI.runtime 2.1.1
- Microsoft.Win32.Registry 4.7.0
- System.Buffers 4.5.1
- System.Memory 4.5.4
- System.Security.Principal.Windows 4.7.0
- System.Text.Encoding.CodePages 4.7.0
- System.Runtime.Caching 4.7.0
- Microsoft.Identity.Client 4.21.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0
