# Release Notes

## Microsoft.Data.SqlClient 4.0.2 released 13 September 2022

This update brings the below changes over the previous preview release:

### Fixed

- Fixed connection failure by not requiring Certificate Revocation List (CRL) check during authentication. [#1718](https://github.com/dotnet/SqlClient/pull/1718)
- Parallelize SSRP requests on Linux and macOS when MultiSubNetFailover is specified. [#1720](https://github.com/dotnet/SqlClient/pull/1720), [#1747](https://github.com/dotnet/SqlClient/pull/1747)
- Added CommandText length validation when using stored procedure command types. [#1721](https://github.com/dotnet/SqlClient/pull/1721)
- Fixed NullReferenceException during Azure Active Directory authentication. [#1722](https://github.com/dotnet/SqlClient/pull/1722)
- Fixed null SqlBinary as rowversion. [#1724](https://github.com/dotnet/SqlClient/pull/1724)
- Fixed table's collation overriding with default UTF8 collation. [#1750](https://github.com/dotnet/SqlClient/pull/1750)

## Changed

- Updated `Microsoft.Data.SqlClient.SNI` (.NET Framework dependency) and `Microsoft.Data.SqlClient.SNI.runtime` (.NET Core/Standard dependency) version to `v4.0.1` [#1754](https://github.com/dotnet/SqlClient/pull/1754), which includes the fix for AppDomain crash introducing in issue [#1418](https://github.com/dotnet/SqlClient/issues/1418)
- Various code improvements: [#1723](https://github.com/dotnet/SqlClient/pull/1723)

## Target Platform Support

- .NET Framework 4.6.1+ (Windows x86, Windows x64)
- .NET Core 3.1+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Data.SqlClient.SNI 4.0.1
- Azure.Identity 1.3.0
- Microsoft.Identity.Client 4.22.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.IO 4.3.0
- System.Runtime.InteropServices.RuntimeInformation 4.3.0
- System.Security.Cryptography.Algorithms 4.3.1
- System.Security.Cryptography.Primitives 4.3.0
- System.Text.Encodings.Web 4.7.2

#### .NET Core

- Microsoft.Data.SqlClient.SNI.runtime 4.0.1
- Azure.Identity 1.3.0
- Microsoft.Identity.Client 4.22.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0
- Microsoft.Win32.Registry 5.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.Diagnostics.DiagnosticSource 5.0.0
- System.IO 4.3.0
- System.Runtime.Caching 5.0.0
- System.Text.Encoding.CodePages 5.0.0
- System.Text.Encodings.Web 4.7.2
- System.Resources.ResourceManager 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0

#### .NET Standard

- Microsoft.Data.SqlClient.SNI.runtime 4.0.1
- Azure.Identity 1.3.0
- Microsoft.Identity.Client 4.22.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0
- Microsoft.Win32.Registry 5.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.IO 4.3.0
- System.Runtime.Caching 5.0.0
- System.Text.Encoding.CodePages 5.0.0
- System.Text.Encodings.Web 4.7.2
- System.Resources.ResourceManager 4.3.0
- System.Runtime.Loader 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0
