# Release Notes

## Microsoft.Data.SqlClient 5.1.0-preview1.22279.3 released 19 October 2022

This update brings the below changes over the previous release:

### Fixed

- Fixed `ReadAsync()` behavior to register Cancellation token action before streaming results. [#1781](https://github.com/dotnet/SqlClient/pull/1781)
- Fixed `NullReferenceException` when assigning `null` to `SqlConnectionStringBuilder.Encrypt`. [#1778](https://github.com/dotnet/SqlClient/pull/1778)
- Fixed missing `HostNameInCertificate` property in .NET Framework Reference Project. [#1776](https://github.com/dotnet/SqlClient/pull/1776)
- Fixed async deadlock issue when sending attention fails due to network failure. [#1766](https://github.com/dotnet/SqlClient/pull/1766)
- Fixed failed connection requests in ConnectionPool in case of PoolBlock. [#1768](https://github.com/dotnet/SqlClient/pull/1768)
- Fixed hang on infinite timeout and managed SNI. [#1742](https://github.com/dotnet/SqlClient/pull/1742)
- Fixed Default UTF8 collation conflict. [#1739](https://github.com/dotnet/SqlClient/pull/1739)

### Changed

- Updated `Microsoft.Data.SqlClient.SNI` (.NET Framework dependency) and `Microsoft.Data.SqlClient.SNI.runtime` (.NET Core/Standard dependency) version to `5.1.0-preview1.22278.1`. [#1787](https://github.com/dotnet/SqlClient/pull/1787) which includes TLS 1.3 Support and fix for AppDomain crash in issue [#1418](https://github.com/dotnet/SqlClient/issues/1418)
- Changed the `SqlConnectionEncryptOption` string parser to public. [#1771](https://github.com/dotnet/SqlClient/pull/1771)
- Converted `ExecuteNonQueryAsync` to use async context object. [#1692](https://github.com/dotnet/SqlClient/pull/1692)
- Code health improvements [#1604](https://github.com/dotnet/SqlClient/pull/1604) [#1598](https://github.com/dotnet/SqlClient/pull/1598) [#1595](https://github.com/dotnet/SqlClient/pull/1595) [#1443](https://github.com/dotnet/SqlClient/pull/1443) 

### Known issues

- When using `Encrypt=Strict` with TLS v1.3, the TLS handshake occurs twice on initial connection on .NET Framework due to a timeout during the TLS handshake and a retry helper re-establishes the connection; however, on .NET Core, it will throw a `System.ComponentModel.Win32Exception (258): The wait operation timed out.` and is being investigated. If you're using Microsoft.Data.SqlClient with .NET Core on Windows 11, you will need to enable the managed SNI on Windows context switch using following statement `AppContext.SetSwitch("Switch.Microsoft.Data.SqlClient.UseManagedNetworkingOnWindows", true);` to use TLS v1.3 or disabling TLS 1.3 from the registry by assigning `0` to the following `HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\SecurityProviders\SCHANNEL\Protocols\TLS 1.3\Client\Enabled` registry key and it'll use TLS v1.2 for the connection. This will be fixed in a future release.

## Target Platform Support

- .NET Framework 4.6.2+ (Windows x86, Windows x64)
- .NET Core 3.1+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Data.SqlClient.SNI 5.1.0.preview1.22278.1
- Azure.Identity 1.6.0
- Microsoft.Identity.Client 4.45.0
- Microsoft.IdentityModel.JsonWebTokens 6.21.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.21.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.IO 4.3.0
- System.Runtime.InteropServices.RuntimeInformation 4.3.0
- System.Security.Cryptography.Algorithms 4.3.1
- System.Security.Cryptography.Primitives 4.3.0
- System.Text.Encoding.Web 4.7.2

#### .NET Core

- Microsoft.Data.SqlClient.SNI 5.1.0.preview1.22278.1
- Azure.Identity 1.6.0
- Microsoft.Identity.Client 4.45.0
- Microsoft.IdentityModel.JsonWebTokens 6.21.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.21.0
- Microsoft.SqlServer.Server 1.0.0
- Microsoft.Win32.Registry 5.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.Diagnostics.DiagnosticSource 5.0.0
- System.IO 4.3.0
- System.Runtime.Caching 5.0.0
- System.Text.Encoding.CodePages 5.0.0
- System.Text.Encodings.Web 4.7.2
- System.Resources.ResourceManager 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0

#### .NET Standard

- Microsoft.Data.SqlClient.SNI 5.1.0.preview1.22278.1
- Azure.Identity 1.6.0
- Microsoft.Identity.Client 4.45.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.21.0
- Microsoft.IdentityModel.JsonWebTokens 6.21.0
- Microsoft.SqlServer.Server 1.0.0
- Microsoft.Win32.Registry 5.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.IO 4.3.0
- System.Runtime.Caching 5.0.0
- System.Text.Encoding.CodePages 5.0.0
- System.Text.Encodings.Web 4.7.2
- System.Runtime.Loader 4.3.0
- System.Resources.ResourceManager 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0
