# Release Notes

## Microsoft.Data.SqlClient 5.1.2 released 26 October 2023

This update includes the following changes over the previous release:

### Fixed

- Fixed access violation when using SQL Express user instance. [#2101](https://github.com/dotnet/SqlClient/pull/2101)
- Fixed Always Encrypted secure enclave retry logic for async queries. [#1988](https://github.com/dotnet/SqlClient/pull/1988)
- Fixed LocalDb and managed SNI by improving the error messages and avoid falling back to the local service. [#2129](https://github.com/dotnet/SqlClient/pull/2129)
- Fixed .NET and .NET Standard file version. [2093](https://github.com/dotnet/SqlClient/pull/2093)
- Fixed non-string values and `SqlConnectionStringBuilder` property indexer issue. [#2018](https://github.com/dotnet/SqlClient/pull/2018)
- Fixed `SqlConnectionEncryptOption` type conversion by introducing the `SqlConnectionEncryptOptionConverter` attribute when using **appsettings.json** files. [#2057](https://github.com/dotnet/SqlClient/pull/2057)
- Fixed Transient fault handling issue with `OpenAsync`. [#1983](https://github.com/dotnet/SqlClient/pull/1983)
- Fixed activity correlator to continue use of same GUID for connection activity. [#1997](https://github.com/dotnet/SqlClient/pull/1997)

### Changed

- Updated `Microsoft.Data.SqlClient.SNI` (.NET Framework dependency) and `Microsoft.Data.SqlClient.SNI.runtime` (.NET Core/Standard dependency) version to `5.1.1`. [#2123](https://github.com/dotnet/SqlClient/pull/2123)

## Target Platform Support

- .NET Framework 4.6.2+ (Windows x86, Windows x64)
- .NET 6.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Data.SqlClient.SNI 5.1.1
- Azure.Identity 1.7.0
- Microsoft.Identity.Client 4.47.2
- Microsoft.IdentityModel.JsonWebTokens 6.24.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.24.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 6.0.1
- System.Runtime.InteropServices.RuntimeInformation 4.3.0
- System.Text.Encoding.Web 6.0.0

#### .NET

- Microsoft.Data.SqlClient.SNI 5.1.1
- Azure.Identity 1.7.0
- Microsoft.Identity.Client 4.47.2
- Microsoft.IdentityModel.JsonWebTokens 6.24.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.24.0
- Microsoft.SqlServer.Server 1.0.0
- System.Configuration.ConfigurationManager 6.0.1
- System.Diagnostics.DiagnosticSource 6.0.0
- System.Runtime.Caching 6.0.0
- System.Text.Encoding.CodePages 6.0.0
- System.Text.Encodings.Web 6.0.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0

#### .NET Standard

- Microsoft.Data.SqlClient.SNI 5.1.1
- Azure.Identity 1.7.0
- Microsoft.Identity.Client 4.47.2
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.24.0
- Microsoft.IdentityModel.JsonWebTokens 6.24.0
- Microsoft.SqlServer.Server 1.0.0
- Microsoft.Win32.Registry 5.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 6.0.1
- System.Runtime.Caching 6.0.0
- System.Text.Encoding.CodePages 6.0.0
- System.Text.Encodings.Web 6.0.0
- System.Runtime.Loader 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0
