# Release Notes

## [Preview Release 5.2.0-preview2.23159.1] - 2023-06-08

This update brings the below changes over the previous release:

### Added

- Added new property `RowsCopied64` to `SqlBulkCopy`. [#2004](https://github.com/dotnet/SqlClient/pull/2004) [Read more](#added-new-property-rowscopied64-to-sqlbulkcopy)

### Fixed

- Fixed socket synchronization issue during connect in managed SNI. [#1029](https://github.com/dotnet/SqlClient/pull/1029)
- Fixed issue with `SqlConnectionStringBuilder` property indexer not supporting non-string values. [#2018](https://github.com/dotnet/SqlClient/pull/2018)

### Changed

- Moved to new System.Data.SqlTypes APIs in **.NET 7** and upper. [1934](https://github.com/dotnet/SqlClient/pull/1934) and [#1981](https://github.com/dotnet/SqlClient/pull/1981)
- Changed **[UseOneSecFloorInTimeoutCalculationDuringLogin](https://learn.microsoft.com/sql/connect/ado-net/appcontext-switches#enable-a-minimum-timeout-during-login)** App Context switch default to **true** and extended its effect to .NET and .NET Standard. [#2012](https://github.com/dotnet/SqlClient/pull/2012)
- Updated `Microsoft.Identity.Client` version from 4.47.2 to 4.53.0. [#2031](https://github.com/dotnet/SqlClient/pull/2031), [#2055](https://github.com/dotnet/SqlClient/pull/2055) 
- Code health improvement: [#1985](https://github.com/dotnet/SqlClient/pull/1985)

## New features over preview release v5.2.0-preview1

### Added new property `RowsCopied64` to SqlBulkCopy

SqlBulkCopy has a new property `RowsCopied64` which supports `long` value types.

**Note that the existing `SqlBulkCopy.RowsCopied` behavior is unchanged. When the value exceeds `int.MaxValue`, `RowsCopied` can return a negative number.**

Example usage:

```C#
    using (SqlConnection srcConn = new SqlConnection(srcConstr))
    using (SqlCommand srcCmd = new SqlCommand("select top 5 * from employees", srcConn))
    {
        srcConn.Open();
        using (DbDataReader reader = srcCmd.ExecuteReader())
        {
            using (SqlBulkCopy bulkcopy = new SqlBulkCopy(dstConn))
            {
                bulkcopy.DestinationTableName = dstTable;
                SqlBulkCopyColumnMappingCollection ColumnMappings = bulkcopy.ColumnMappings;

                ColumnMappings.Add("EmployeeID", "col1");
                ColumnMappings.Add("LastName", "col2");
                ColumnMappings.Add("FirstName", "col3");

                bulkcopy.WriteToServer(reader);
                long rowsCopied = bulkcopy.RowsCopied64;
            }
        }
    }
```

## Target Platform Support

- .NET Framework 4.6.2+ (Windows x86, Windows x64)
- .NET 6.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Data.SqlClient.SNI 5.1.0
- Azure.Identity 1.8.0
- Microsoft.Identity.Client 4.53.0
- Microsoft.IdentityModel.JsonWebTokens 6.24.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.24.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 6.0.1
- System.IO 4.3.0
- System.Runtime.InteropServices.RuntimeInformation 4.3.0
- System.Security.Cryptography.Algorithms 4.3.1
- System.Security.Cryptography.Primitives 4.3.0
- System.Text.Encoding.Web 6.0.0

#### .NET

- Microsoft.Data.SqlClient.SNI 5.1.0
- Azure.Identity 1.8.0
- Microsoft.Identity.Client 4.53.0
- Microsoft.IdentityModel.JsonWebTokens 6.24.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.24.0
- Microsoft.SqlServer.Server 1.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 6.0.1
- System.Diagnostics.DiagnosticSource 6.0.0
- System.IO 4.3.0
- System.Runtime.Caching 6.0.0
- System.Text.Encoding.CodePages 6.0.0
- System.Text.Encodings.Web 6.0.0
- System.Resources.ResourceManager 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0

#### .NET Standard

- Microsoft.Data.SqlClient.SNI 5.1.0
- Azure.Identity 1.6.0
- Microsoft.Identity.Client 4.53.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.24.0
- Microsoft.IdentityModel.JsonWebTokens 6.24.0
- Microsoft.SqlServer.Server 1.0.0
- Microsoft.Win32.Registry 5.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 6.0.1
- System.IO 4.3.0
- System.Runtime.Caching 6.0.0
- System.Text.Encoding.CodePages 6.0.0
- System.Text.Encodings.Web 6.0.0
- System.Runtime.Loader 4.3.0
- System.Resources.ResourceManager 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0
