# Release Notes

## [Preview Release 5.2.0-preview3.23201.1] - 2023-07-20

This update brings the below changes over the previous release:

### Added

- Added a new `AccessTokenCallBack` API to `SqlConnection`. [#1260](https://github.com/dotnet/SqlClient/pull/1260)
- Added support for the `SuperSocketNetLib` registry option for Encrypt on .NET on Windows. [#2047](https://github.com/dotnet/SqlClient/pull/2047)

### Fixed

- Fixed `SqlDataAdapter.Fill` and configurable retry logic issue on .NET Framework. [#2084](https://github.com/dotnet/SqlClient/pull/2084)
- Fixed `SqlConnectionEncryptOption` type conversion by introducing the `SqlConnectionEncryptOptionConverter` attribute when using **appsettings.json** files. [#2057](https://github.com/dotnet/SqlClient/pull/2057)
- Fixed th-TH culture info issue on Managed SNI. [#2066](https://github.com/dotnet/SqlClient/pull/2066)

### Changed

- Switched to the new .NET [NegotiateAuthentication](https://learn.microsoft.com/en-us/dotnet/api/system.net.security.negotiateauthentication?view=net-7.0) API on .NET 7.0 and above for SSPI token negotiation using Managed SNI. [#2063](https://github.com/dotnet/SqlClient/pull/2063)
- Removed `ignoreSniOpenTimeout` in open connection process on Windows. [#2067](https://github.com/dotnet/SqlClient/pull/2067)
- Enforce explicit ordinal for internal `StringComparison` operations. [#2068](https://github.com/dotnet/SqlClient/pull/2068)
- Code health improvements: [#1959](https://github.com/dotnet/SqlClient/pull/1959), [#2071](https://github.com/dotnet/SqlClient/pull/2071), [#2073](https://github.com/dotnet/SqlClient/pull/2073), [#2088](https://github.com/dotnet/SqlClient/pull/2088)

## New features over preview release v5.2.0-preview2

### Added new property `AccessTokenCallBack` to SqlConnection

SqlConnection supports `TokenCredential` authentication by introducing a new `AccessTokenCallBack` porperty as a `Func<SqlAuthenticationParameters, CancellationToken,Task<SqlAuthenticationToken>>` delegate to return a federated authentication access token.

Example usage:

```C#
    using Microsoft.Data.SqlClient;
    using Azure.Identity;

    const string defaultScopeSuffix = "/.default";
    string connectionString = GetConnectionString();
    using SqlConnection connection = new SqlConnection(connectionString);
    
    connection.AccessTokenCallback = async (authParams, cancellationToken) =>
    {
        var cred = new DefaultAzureCredential();
        string scope = authParams.Resource.EndsWith(defaultScopeSuffix) ? authParams.Resource : authParams.Resource + defaultScopeSuffix;
        AccessToken token = await cred.GetTokenAsync(new TokenRequestContext(new[] { scope }), cancellationToken);
        return new SqlAuthenticationToken(token.Token, token.ExpiresOn);
    }
    
    connection.Open();
    Console.WriteLine("ServerVersion: {0}", connection.ServerVersion);
    Console.WriteLine("State: {0}", connection.State);
```

## Target Platform Support

- .NET Framework 4.6.2+ (Windows x86, Windows x64)
- .NET 6.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Data.SqlClient.SNI 5.1.0
- Azure.Identity 1.8.0
- Microsoft.Identity.Client 4.53.0
- Microsoft.IdentityModel.JsonWebTokens 6.24.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.24.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 6.0.1
- System.IO 4.3.0
- System.Runtime.InteropServices.RuntimeInformation 4.3.0
- System.Security.Cryptography.Algorithms 4.3.1
- System.Security.Cryptography.Primitives 4.3.0
- System.Text.Encoding.Web 6.0.0

#### .NET

- Microsoft.Data.SqlClient.SNI 5.1.0
- Azure.Identity 1.8.0
- Microsoft.Identity.Client 4.53.0
- Microsoft.IdentityModel.JsonWebTokens 6.24.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.24.0
- Microsoft.SqlServer.Server 1.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 6.0.1
- System.Diagnostics.DiagnosticSource 6.0.0
- System.IO 4.3.0
- System.Runtime.Caching 6.0.0
- System.Text.Encoding.CodePages 6.0.0
- System.Text.Encodings.Web 6.0.0
- System.Resources.ResourceManager 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0

#### .NET Standard

- Microsoft.Data.SqlClient.SNI 5.1.0
- Azure.Identity 1.6.0
- Microsoft.Identity.Client 4.53.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.24.0
- Microsoft.IdentityModel.JsonWebTokens 6.24.0
- Microsoft.SqlServer.Server 1.0.0
- Microsoft.Win32.Registry 5.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 6.0.1
- System.IO 4.3.0
- System.Runtime.Caching 6.0.0
- System.Text.Encoding.CodePages 6.0.0
- System.Text.Encodings.Web 6.0.0
- System.Runtime.Loader 4.3.0
- System.Resources.ResourceManager 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0
