# Release Notes

## General Availability of Microsoft.Data.SqlClient.AlwaysEncrypted.AzureKeyVaultProvider

_**5.1.0 released 01 February 2024**_

This library contains the implementation of `Microsoft.Data.SqlClient.SqlColumnEncryptionKeyStoreProvider` for accessing Azure Key Vault, and the provider class is named `SqlColumnEncryptionAzureKeyVaultProvider`.

### Changed

- Changed Microsoft.Data.SqlClient version 3.0.0 to 5.1.5 [#2330](https://github.com/dotnet/SqlClient/pull/2330)
- Changed Azure.Core version 1.6.0 to 1.35.0 [#2330](https://github.com/dotnet/SqlClient/pull/2330)
- Changed Azure.Security.KeyVault.Keys 4.0.3 to 4.5.0 [#2330](https://github.com/dotnet/SqlClient/pull/2330)
- Changed Microsoft.Extensions.Caching.Memory 5.0.0 to 8.0.0 for .Net 8.0 and 6.0.1 for other Target frameworks [#2330](https://github.com/dotnet/SqlClient/pull/2330)

### Working with SQLColumnEncryptionAzureKeyVaultProvider

`SqlColumnEncryptionAzureKeyVaultProvider` **v5.1** is implemented against `Microsoft.Data.SqlClient` **v5.1** and supports .NET Framework 4.6.2+, .NET Core 6.0+, and .NET Standard 2.0+. The provider name identifier for this library is "**AZURE_KEY_VAULT**" and it is not registered in the driver by default. Client applications may initialize this provider by providing an `Azure.Core.TokenCredential` and registering it with the driver using any of the below APIs:

- [SqlConnection.RegisterColumnEncryptionKeyStoreProviders](https://docs.microsoft.com/dotnet/api/microsoft.data.sqlclient.sqlconnection.registercolumnencryptionkeystoreproviders?view=sqlclient-dotnet-5.1)
- [SqlConnection.RegisterColumnEncryptionKeyStoreProvidersOnConnection](https://docs.microsoft.com/dotnet/api/microsoft.data.sqlclient.sqlconnection.registercolumnencryptionkeystoreprovidersonconnection?view=sqlclient-dotnet-5.1) (Added in version 3.0.0)
- [SqlCommand.RegisterColumnEncryptionKeyStoreProvidersOnCommand](https://docs.microsoft.com/dotnet/api/microsoft.data.sqlclient.sqlcommand.registercolumnencryptionkeystoreprovidersoncommand?view=sqlclient-dotnet-5.1) (Added in version 3.0.0)

Once the provider is registered, it can be used to perform Always Encrypted operations by creating a Column Master Key using the Azure Key Vault Key Identifier URL.

The linked C# samples below demonstrate using Always Encrypted with secure enclaves with Azure Key Vault:

- Legacy API support (Always Encrypted): [AzureKeyVaultProviderExample.cs](https://github.com/dotnet/SqlClient/blob/main/doc/samples/AzureKeyVaultProviderLegacyExample_2_0.cs)
- New API support (Always Encrypted): [AzureKeyVaultProviderExample.cs](https://github.com/dotnet/SqlClient/blob/main/doc/samples/AzureKeyVaultProviderExample_2_0.cs)
- Legacy API support (Always Encrypted with secure enclaves): [AzureKeyVaultProviderExample.cs](https://github.com/dotnet/SqlClient/blob/main/doc/samples/doc\samples\AzureKeyVaultProviderWithEnclaveProviderExample.cs)
- New API support (Always Encrypted with secure enclaves): [AzureKeyVaultProviderExample.cs](https://github.com/dotnet/SqlClient/blob/main/doc/samples/doc\samples\AzureKeyVaultProviderWithEnclaveProviderExample_2_0.cs)
- Column Encryption Key cache scope example: [AzureKeyVaultProvider_ColumnEncryptionKeyCacheScope.cs](https://github.com/dotnet/SqlClient/blob/main/doc/samples/AzureKeyVaultProvider_ColumnEncryptionKeyCacheScope.cs)
- Registering custom key store provider - Connection Precedence: [RegisterCustomKeyStoreProvider_ConnectionPrecedence.cs](https://github.com/dotnet/SqlClient/blob/main/doc/samples/RegisterCustomKeyStoreProvider_ConnectionPrecedence.cs)
- Registering custom key store provider - Command Precedence: [RegisterCustomKeyStoreProvider_CommandPrecedence.cs](https://github.com/dotnet/SqlClient/blob/main/doc/samples/RegisterCustomKeyStoreProvider_CommandPrecedence.cs)

For further details, refer to [Using the Azure Key Vault provider](https://docs.microsoft.com/sql/connect/ado-net/sql/sqlclient-support-always-encrypted#using-the-azure-key-vault-provider)

## Target Platform Support

- .NET Framework 4.6.2+
- .NET Core 6.0+ (Windows x86, Windows x64, Linux, macOS)
- .NET Standard 2.0+

### Dependencies

#### .NET Framework

- Azure.Core 1.35.0
- Azure.Security.KeyVault.Keys 4.5.0
- Microsoft.Data.SqlClient 5.1.5
- Microsoft.Extensions.Caching.Memory 6.0.1

##### .NET 6

- Azure.Core 1.35.0
- Azure.Security.KeyVault.Keys 4.5.0
- Microsoft.Data.SqlClient 5.1.5
- Microsoft.Extensions.Caching.Memory 6.0.1

#### .NET 8

- Azure.Core 1.35.0
- Azure.Security.KeyVault.Keys 4.5.0
- Microsoft.Data.SqlClient 5.1.5
- Microsoft.Extensions.Caching.Memory 8.0.0

#### .NET Standard

- Azure.Core 1.35.0
- Azure.Security.KeyVault.Keys 4.5.0
- Microsoft.Data.SqlClient 5.1.5
- Microsoft.Extensions.Caching.Memory 6.0.1
