﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace Microsoft.Data.SqlClient.PerformanceTests
{
    // !!! DO NOT MODIFY THIS CLASS !!!
    [System.Diagnostics.CodeAnalysis.SuppressMessage("Style", "IDE1006:Naming Styles", Justification = "Naming as per design")]
    public static class Constants
    {
        public const int n_bit = 0;
        public const int n_int = 1;
        public const int n_tinyint = 2;
        public const int n_smallint = 3;
        public const int n_bigint = 4;
        public const int n_money = 5;
        public const int n_smallmoney = 6;

        public const int d_decimal = 0;
        public const int d_numeric = 1;
        public const int d_float = 2;
        public const int d_real = 3;

        public const int t_date = 0;
        public const int t_datetime = 1;
        public const int t_datetime2 = 2;
        public const int t_time = 3;
        public const int t_smalldatetime = 4;
        public const int t_datetimeoffset = 5;

        public const int c_char = 0;
        public const int c_nchar = 1;

        public const int b_binary = 0;

        public const int m_varchar = 0;
        public const int m_nvarchar = 1;
        public const int m_varbinary = 2;

        public const int o_uniqueidentifier = 0;
        public const int o_xml = 1;

        public const string Bit = "bit";
        public const string Int = "int";
        public const string TinyInt = "tinyint";
        public const string SmallInt = "smallint";
        public const string BigInt = "bigint";
        public const string Money = "money";
        public const string SmallMoney = "smallmoney";
        public const string Decimal = "decimal";
        public const string Numeric = "numeric";
        public const string Float = "float";
        public const string Real = "real";
        public const string Date = "date";
        public const string Datetime = "datetime";
        public const string Datetime2 = "datetime2";
        public const string Time = "time";
        public const string SmallDateTime = "smalldatetime";
        public const string DatetimeOffset = "datetimeoffset";
        public const string Char = "char";
        public const string NChar = "nchar";
        public const string Binary = "binary";
        public const string VarChar = "varchar";
        public const string NVarChar = "nvarchar";
        public const string VarBinary = "varbinary";
        public const string UniqueIdentifier = "uniqueidentifier";
        public const string Xml = "xml";
    }
}
