# Release Notes

## Microsoft.Data.SqlClient 1.0.19221.1-Preview released 8 August 2019

This update brings the below changes over the previous preview release:

### Added
* Localization Support for NetFx resources.
* Added `buildTransitive\` folder to `SNI.dll` library to define build assets transitive behavior - Fixes [#137](https://github.com/dotnet/SqlClient/issues/137).

#### .Net Framework
* Added support for **Active Directory Interactive** (Multi-Factor Authentication) and replaced the dependency on _ADAL_ to _MSAL (Microsoft.Identity.Client)_. The NetFx driver now supports the below modes of Azure Active Directory authentication:
  - Active Directory Password
  - Active Directory Integrated
  - Active Directory Interactive

#### .Net Core
* Added support for **Active Directory Password** Authentication with _MSAL (Microsoft.Identity.Client)_ as a dependency. The NetCore driver now supports the below modes of Azure Active Directory authentication:
  - Active Directory Password

### Fixed
* Fixed `ExecuteReaderAsync` API behavior that did not close the connection with `CommandBehavior.CloseConnection` - Fixes [#18](https://github.com/dotnet/SqlClient/issues/18), [#129](https://github.com/dotnet/SqlClient/issues/129) and related issues.
* Fixed Broken Pipe IO Exception errors - Fixes [#20](https://github.com/dotnet/SqlClient/issues/20).
* Fixed Bulk Copy behavior with Always Encrypted columns - Fixes [#121](https://github.com/dotnet/SqlClient/issues/121).
* Modified `SqlClientDiagnosticListenerExtensions` to include Timestamp in `WriteCommandBefore` API - Fixes [#101](https://github.com/dotnet/SqlClient/issues/101) and [#59](https://github.com/dotnet/SqlClient/issues/59).
* Fixed `SqlEnvChangePool` thread safety bug - Ported [CoreFx#36735](https://github.com/dotnet/corefx/pull/36735).

### Changes
#### .NET Core
* Removed remaining _System.Data.SqlClient_ references.
* Updated Tests to better clean up resources and fixed a few failing tests.
* Changed to using Rent Buffers instead of transient ones when streaming data to the database - Ported [CoreFx#35927](https://github.com/dotnet/corefx/pull/35927).
* Cleaned up `string.Format` / `SR.Format` usage - Ported [CoreFx#35777](https://github.com/dotnet/corefx/pull/35777).
* Removed primitive boxing in `SqlDataReader.GetFieldValue` - Ported [CoreFx#34999](https://github.com/dotnet/corefx/pull/34999).
* Removed stale warning 420 pragmas - Ported [CoreFx#35023](https://github.com/dotnet/corefx/pull/35023).
* Manual Test fixes and documentation updates - Ported [CoreFx#34546](https://github.com/dotnet/corefx/pull/34546).

#### .NET Framework
* Replaced calls from ADAL to MSAL (Microsoft.Identity.Client) for Azure Active Directory Authentication.
* Source file headers changed for open sourcing code.
* Cleaned up `string.Format` / `SR.Format` usage.

### Target Platform Support

* .NET Framework 4.6+
* .NET Core 2.1+ (Windows x86, Windows x64, Linux, macOS)
* .NET Standard 2.0+ (Windows x86, Windows x64, Linux, macOS)

### Dependencies

#### .NET Framework

* System.Data.Common 4.3.0
* Microsoft.Data.SqlClient.SNI 1.0.19221.2-Preview
* Microsoft.Identity.Client 3.0.8

#### .NET Core

* Microsoft.Win32.Registry 4.5.0
* runtime.native.System.Data.SqlClient.sni 4.4.0
* System.Security.Principal.Windows 4.5.0
* System.Text.Encoding.CodePages 4.5.0
* System.Configuration.ConfigurationManager 4.5.0
* Microsoft.Identity.Client 3.0.8

#### .NET Standard

* Microsoft.Win32.Registry 4.5.0
* runtime.native.System.Data.SqlClient.sni 4.4.0
* System.Buffers 4.4.0
* System.Diagnostics.DiagnosticSource 4.5.0
* System.Memory 4.5.1
* System.Security.Principal.Windows 4.5.0
* System.Text.Encoding.CodePages 4.5.0
* System.Configuration.ConfigurationManager 4.5.0
* Microsoft.Identity.Client 3.0.8

### New Features

#### New features over .NET Framework 4.7.2 System.Data.SqlClient.

* [Data Classification](#data-classification) - Available in Azure SQL Database and Microsoft SQL Server 2019 since CTP 2.0.
* [UTF-8 support](#utf-8-support) - Available in Microsoft SQL Server SQL Server 2019 since CTP 2.3.

#### New features over .NET Core 2.2 System.Data.SqlClient.

* [Data Classification](#data-classification) - Available in Azure SQL Database and Microsoft SQL Server 2019 since CTP 2.0.
* [UTF-8 support](#utf-8-support) - Available in Microsoft SQL Server SQL Server 2019 since CTP 2.3.
* [Always Encrypted](#always-encrypted) - Always Encrypted is available in Microsoft SQL Server 2016 and higher.
* [Authentication](#authentication): Active Directory Password authentication mode.

### Known Issues

* User Data Types (UDTs) may not work with Microsoft.Data.SqlClient.

### Data Classification

Data Classification brings a new set of APIs exposing read-only Data Sensitivity and Classification information about objects retrieved via SqlDataReader when the underlying source supports the feature and contains metadata about [data sensitivity and classification](https://docs.microsoft.com/sql/relational-databases/security/sql-data-discovery-and-classification?view=sql-server-2017):

```C#
public class SqlDataReader
{
    public Microsoft.Data.SqlClient.DataClassification.SensitivityClassification SensitivityClassification
}

namespace Microsoft.Data.SqlClient.DataClassification
{
    public class ColumnSensitivity
    {
        public System.Collections.ObjectModel.ReadOnlyCollection<Microsoft.Data.SqlClient.DataClassification.SensitivityProperty> SensitivityProperties
    }
    public class InformationType
    {
        public string Id
        public string Name
    }
    public class Label
    {
        public string Id
        public string Name
    }
    public class SensitivityClassification
    {
        public System.Collections.ObjectModel.ReadOnlyCollection<Microsoft.Data.SqlClient.DataClassification.ColumnSensitivity> ColumnSensitivities
        public System.Collections.ObjectModel.ReadOnlyCollection<Microsoft.Data.SqlClient.DataClassification.InformationType> InformationTypes
        public System.Collections.ObjectModel.ReadOnlyCollection<Microsoft.Data.SqlClient.DataClassification.Label> Labels
    }
    public class SensitivityProperty
    {
        public Microsoft.Data.SqlClient.DataClassification.InformationType InformationType
        public Microsoft.Data.SqlClient.DataClassification.Label Label
    }
}
```

### UTF-8 Support

UTF-8 support does not require any application code changes. These SqlClient changes simply optimize the communication between the client and server when the server supports UTF-8 and the underlying column collation is UTF-8. See the UTF-8 section under [What's new in SQL Server 2019 preview](https://docs.microsoft.com/sql/sql-server/what-s-new-in-sql-server-ver15?view=sqlallproducts-allversions#utf-8-support-ctp-23).

### Always Encrypted

In general, existing documentation which uses System.Data.SqlClient on .NET Framework **and built-in column master key store providers** should now work with .NET Core, too.

* [Develop using Always Encrypted with .NET Framework Data Provider](https://docs.microsoft.com/sql/relational-databases/security/encryption/develop-using-always-encrypted-with-net-framework-data-provider?view=sql-server-2017)
* [Always Encrypted: Protect sensitive data and store encryption keys in the Windows certificate store](https://docs.microsoft.com/azure/sql-database/sql-database-always-encrypted)

### Authentication

Different authentication modes can be specified by using the _Authentication_ connnection string option. For more information, see the [documentation for SqlAuthenticationMethod](https://docs.microsoft.com/en-us/dotnet/api/system.data.sqlclient.sqlauthenticationmethod?view=netframework-4.7.2).

**Notes:**

* There is no key store provider for Azure Key Vault and Microsoft.Data.SqlClient at this time.
* Always Encrypted with secure enclaves is not supported with Microsoft.Data.SqlClient.
* Always Encrypted is only supported against .NET Framework and .NET Core targets. It is not supported against .NET Standard since .NET Standard is missing certain encryption dependencies.
