# Release Notes

## Microsoft.Data.SqlClient 3.0.0-preview3.21140.5 released 20 May 2021

This update brings the below changes over the previous release:

### Added

- Added support for "Active Directory Default" authentication mode [#1043](https://github.com/dotnet/SqlClient/pull/1043) [Read more](#active-directory-default-authentication-support)
- Added support for connection-level and command-level registration of custom key store providers to enable multi-tenant applications to control key store access [#1045](https://github.com/dotnet/SqlClient/pull/1045) [#1056](https://github.com/dotnet/SqlClient/pull/1056) [#1078](https://github.com/dotnet/SqlClient/pull/1078) [Read more](#custom-master-key-store-provider-registration-enhancements)
- Added IP address preference support for TCP connections [#1015](https://github.com/dotnet/SqlClient/pull/1015) [Read more](#ip-address-preference)

### Fixed

- Fixed corrupted connection issue when an exception occurs during RPC execution with TVP types [#1068](https://github.com/dotnet/SqlClient/pull/1068)
- Fixed race condition issues between SinglePhaseCommit and TransactionEnded events [#1042](https://github.com/dotnet/SqlClient/pull/1042)

### Changed

- Updated error messages for enclave exceptions to include a link to a troubleshooting guide. [#994](https://github.com/dotnet/SqlClient/pull/994)
- Changes to share common files between projects [#1022](https://github.com/dotnet/SqlClient/pull/1022) [#1038](https://github.com/dotnet/SqlClient/pull/1038) [#1040](https://github.com/dotnet/SqlClient/pull/1040) [#1033](https://github.com/dotnet/SqlClient/pull/1033) [#1028](https://github.com/dotnet/SqlClient/pull/1028) [#1039](https://github.com/dotnet/SqlClient/pull/1039)

### Active Directory Default authentication support

This PR introduces a new SQL Authentication method, **Active Directory Default**. This authentication mode widens the possibilities of user authentication, extending login solutions to the client environment, Visual Studio Code, Visual Studio, Azure CLI etc.

With this authentication mode, the driver acquires a token by passing "[DefaultAzureCredential](https://docs.microsoft.com/dotnet/api/azure.identity.defaultazurecredential)" from the Azure Identity library to acquire an access token. This mode attempts to use these credential types to acquire an access token in the following order:

- **EnvironmentCredential**
  - Enables authentication to Azure Active Directory using client and secret, or username and password, details configured in the following environment variables: AZURE_TENANT_ID, AZURE_CLIENT_ID, AZURE_CLIENT_SECRET, AZURE_CLIENT_CERTIFICATE_PATH, AZURE_USERNAME, AZURE_PASSWORD ([More details](https://docs.microsoft.com/dotnet/api/azure.identity.environmentcredential))
- **ManagedIdentityCredential**
  - Attempts authentication to Azure Active Directory using a managed identity that has been assigned to the deployment environment. **"Client Id" of "User Assigned Managed Identity"** is read from the **"User Id" connection property**.
- **SharedTokenCacheCredential**
  - Authenticates using tokens in the local cache shared between Microsoft applications.
- **VisualStudioCredential**
  - Enables authentication to Azure Active Directory using data from Visual Studio
- **VisualStudioCodeCredential**
  - Enables authentication to Azure Active Directory using data from Visual Studio Code.
- **AzureCliCredential**
  - Enables authentication to Azure Active Directory using Azure CLI to obtain an access token.

> InteractiveBrowserCredential is disabled in the driver implementation of "Active Directory Default", and "Active Directory Interactive" is the only option available to acquire a token using MFA/Interactive authentication.*

> Further customization options are not available at the moment.

### Custom master key store provider registration enhancements

Microsoft.Data.SqlClient now offers more control of where master key store providers are accessible in an application in order to better support multi-tenant applications and their use of column encryption/decryption. The following APIs are introduced to allow registration of custom master key store providers on instances of `SqlConnection` and `SqlCommand`:

```cs
public class SqlConnection
{
        public void RegisterColumnEncryptionKeyStoreProvidersOnConnection(IDictionary<string, SqlColumnEncryptionKeyStoreProvider> customProviders)
}
public class SqlCommand 
{
        public void RegisterColumnEncryptionKeyStoreProvidersOnCommand(IDictionary<string, SqlColumnEncryptionKeyStoreProvider> customProviders)
}
```

The static API on `SqlConnection`, i.e. `SqlConnection.RegisterColumnEncryptionKeyStoreProviders` to register custom master key store providers globally continues to be supported. The column encryption key cache maintained globally only applies to globally registered providers.

#### Column master key store provider registration precedence

The built-in column master key store providers that are available for the Windows Certificate Store, CNG Store and CSP are pre-registered. No providers should be registered on the connection or command instances if one of the built-in column master key store providers is needed.

Custom master key store providers can be registered with the driver at three different layers. The global level is as it currently is. The new per-connection and per-command level registrations will be empty initially and can be set more than once.

The precedence of the three registrations are as follows:

- The per-command registration will be checked if it is not empty.
- If the per-command registration is empty, the per-connection registration will be checked if it is not empty.
- If the per-connection registration is empty, the global registration will be checked.

Once any key store provider is found at a registration level, the driver will **NOT** fall back to the other registrations to search for a provider. If providers are registered but the proper provider is not found at a level, an exception will be thrown containing only the registered providers in the registration that was checked.

#### Column encryption key cache precedence

The column encryption keys (CEKs) for custom key store providers registered using the new instance-level APIs will not be cached by the driver. The key store providers need to implement their own cache to gain performance. This local cache of column encryption keys implemented by custom key store providers will be disabled by the driver if the key store provider instance is registered in the driver at the global level.

A new API has also been introduced on the `SqlColumnEncryptionKeyStoreProvider` base class to set the cache time to live:

```cs
public abstract class SqlColumnEncryptionKeyStoreProvider
{
    // The default value of Column Encryption Key Cache Time to Live is 0.
    // Provider's local cache is disabled for globally registered providers.
    // Custom key store provider implementation must include column encryption key cache to provide caching support to locally registered providers.
    public virtual TimeSpan? ColumnEncryptionKeyCacheTtl { get; set; } = new TimeSpan(0);
}
```

### IP Address preference

A new connection property `IPAddressPreference` is introduced to specify the IP address family preference to the driver when establishing TCP connections. If `Transparent Network IP Resolution` (in .NET Framework) or `Multi Subnet Failover` is set to `true`, this setting has no effect. Below are the three accepted values for this property:

- **IPv4First**
  - This is the default preference value. The driver will use resolved IPv4 addresses first. If none of them can be connected to successfully, it will try resolved IPv6 addresses.

- **IPv6First**
  - The driver will use resolved IPv6 addresses first. If none of them can be connected to successfully, it will try resolved IPv4 addresses.

- **UsePlatformDefault**
  - The driver will try IP addresses in the order received from the DNS resolution response.

## Target Platform Support

- .NET Framework 4.6.1+ (Windows x86, Windows x64)
- .NET Core 2.1+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)

### Dependencies

#### .NET Framework 4.6.1

- Microsoft.Data.SqlClient.SNI 3.0.0-preview1.21104.2
- Azure.Identity 1.3.0
- Microsoft.Identity.Client 4.22.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0

#### .NET Core 2.1

- Microsoft.Data.SqlClient.SNI.runtime 3.0.0-preview1.21104.2
- Microsoft.Win32.Registry 4.7.0
- System.Security.Principal.Windows 4.7.0
- System.Text.Encoding.CodePages 4.7.0
- System.Diagnostics.DiagnosticSource 4.7.0
- System.Configuration.ConfigurationManager 4.7.0
- System.Runtime.Caching 4.7.0
- Azure.Identity 1.3.0
- Microsoft.Identity.Client 4.22.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0

#### .NET Core 3.1

- Microsoft.Data.SqlClient.SNI.runtime 3.0.0-preview1.21104.2
- Microsoft.Win32.Registry 4.7.0
- System.Security.Principal.Windows 4.7.0
- System.Text.Encoding.CodePages 4.7.0
- System.Diagnostics.DiagnosticSource 4.7.0
- System.Configuration.ConfigurationManager 4.7.0
- System.Runtime.Caching 4.7.0
- Azure.Identity 1.3.0
- Microsoft.Identity.Client 4.22.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0

#### .NET Standard 2.0

- Microsoft.Data.SqlClient.SNI.runtime 3.0.0-preview1.21104.2
- Microsoft.Win32.Registry 4.7.0
- System.Buffers 4.5.1
- System.Memory 4.5.4
- System.Security.Principal.Windows 4.7.0
- System.Text.Encoding.CodePages 4.7.0
- System.Runtime.Caching 4.7.0
- Azure.Identity 1.3.0
- Microsoft.Identity.Client 4.22.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0

#### .NET Standard 2.1

- Microsoft.Data.SqlClient.SNI.runtime 3.0.0-preview1.21104.2
- Microsoft.Win32.Registry 4.7.0
- System.Buffers 4.5.1
- System.Memory 4.5.4
- System.Security.Principal.Windows 4.7.0
- System.Text.Encoding.CodePages 4.7.0
- System.Runtime.Caching 4.7.0
- Azure.Identity 1.3.0
- Microsoft.Identity.Client 4.22.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0
