# Release Notes

## General Availability of Microsoft.Data.SqlClient.AlwaysEncrypted.AzureKeyVaultProvider
_**2.0.0 released 03 March 2021**_

This library contains the implementation of `Microsoft.Data.SqlClient.SqlColumnEncryptionKeyStoreProvider` for accessing Azure Key Vault, and the provider class is named `SqlColumnEncryptionAzureKeyVaultProvider`.

### Added
- Upgraded Azure Key Vault Provider to use new Azure Key Vault libraries [#630](https://github.com/dotnet/SqlClient/pull/630)

### Breaking Changes
- Drops support for .NET Framework 4.6. The new minimum supported .NET Framework version is v4.6.1 [#630](https://github.com/dotnet/SqlClient/pull/630)
- Updated dependency of Microsoft.Data.SqlClient on .NET Framework and .NET Core to LTS stable version v1.1.3+ [#946](https://github.com/dotnet/SqlClient/pull/946)


### Working with SQLColumnEncryptionAzureKeyVaultProvider
`SqlColumnEncryptionAzureKeyVaultProvider` is implemented against `Microsoft.Data.SqlClient` and supports .NET Framework 4.6.1+, .NET Core 2.1+, and .NET Standard 2.0+. The provider name identifier for this library is "**AZURE_KEY_VAULT**" and it is not registered in the driver by default. Client applications may now initialize this provider by providing an instance of `Azure.Core.TokenCredential` implementation and register it with the driver.

Once the provider is registered, it can be used to perform Always Encrypted operations by creating a Column Master Key using the Azure Key Vault Key Identifier URL.

The linked C# samples below demonstrate using Always Encrypted with secure enclaves with Azure Key Vault:
- Legacy API support (Always Encrypted): [AzureKeyVaultProviderExample.cs](https://github.com/dotnet/SqlClient/blob/master/doc/samples/AzureKeyVaultProviderLegacyExample_2_0.cs)
- New API support (Always Encrypted): [AzureKeyVaultProviderExample.cs](https://github.com/dotnet/SqlClient/blob/master/doc/samples/AzureKeyVaultProviderExample_2_0.cs)
- Legacy API support (Always Encrypted with secure enclaves): [AzureKeyVaultProviderExample.cs](https://github.com/dotnet/SqlClient/blob/master/doc/samples/doc\samples\AzureKeyVaultProviderWithEnclaveProviderExample.cs)
- New API support (Always Encrypted with secure snclaves): [AzureKeyVaultProviderExample.cs](https://github.com/dotnet/SqlClient/blob/master/doc/samples/doc\samples\AzureKeyVaultProviderWithEnclaveProviderExample_2_0.cs)


## Target Platform Support

- .NET Framework 4.6.1+
- .NET Core 2.1+ (Windows x86, Windows x64, Linux, macOS)
- .NET Standard 2.0+

### Dependencies

#### .NET Framework

- Azure.Core 1.2.2
- Azure.Security.KeyVault.Keys 4.0.3
- Microsoft.Data.SqlClient 1.1.3

#### .NET Core

- Azure.Core 1.2.2
- Azure.Security.KeyVault.Keys 4.0.3
- Microsoft.Data.SqlClient 1.1.3

#### .NET Standard

- Azure.Core 1.2.2
- Azure.Security.KeyVault.Keys 4.0.3
- Microsoft.Data.SqlClient 2.1.0
