// Generated by CoffeeScript 1.3.1
(function() {
  var example, fs, keys, oauth, read, rem, tw;

  rem = require('../rem');

  fs = require('fs');

  read = require('read');

  keys = JSON.parse(fs.readFileSync(__dirname + '/keys.json'));

  tw = rem.load('twitter', '1', {
    key: keys.twitter.key,
    secret: keys.twitter.secret
  });

  oauth = rem.oauth(tw);

  oauth.start(function(url, token, secret) {
    console.log("Visit:", url);
    return read({
      prompt: "Type in the verification code: "
    }, function(err, verifier) {
      return oauth.complete(verifier, token, secret, example);
    });
  });

  example = function(err, user) {
    if (err) {
      console.error(err);
      return;
    }
    console.log('Latest tweets from your timeline:');
    return user('statuses/home_timeline').get(function(err, json) {
      var twt, _i, _len;
      for (_i = 0, _len = json.length; _i < _len; _i++) {
        twt = json[_i];
        console.log(' -', twt.text);
      }
      return read({
        prompt: "Enter a status to tweet: "
      }, function(err, txt) {
        return user('statuses/update').post({
          status: txt
        }, function(err, json) {
          return console.log(err, json);
        });
      });
    });
  };

}).call(this);
