// Generated by CoffeeScript 1.3.1
(function() {
  var app, dbox, express, fs, keys, oauth, read, rem;

  rem = require('../rem');

  fs = require('fs');

  read = require('read');

  express = require('express');

  keys = JSON.parse(fs.readFileSync(__dirname + '/keys.json'));

  dbox = rem.load('dropbox', '1', {
    key: keys.dropbox.key,
    secret: keys.dropbox.secret
  });

  app = express.createServer();

  app.use(express.cookieParser());

  app.use(express.session({
    secret: "some arbitrary secret"
  }));

  app.listen(3000);

  oauth = rem.oauth(dbox, "http://localhost:3000/oauth/callback/");

  app.use(oauth.middleware(function(req, res, next) {
    console.log("Authenticated user.");
    return res.redirect('/');
  }));

  app.get('/login/', function(req, res) {
    return oauth.startSession(req, function(url) {
      return res.redirect(url);
    });
  });

  app.get('/', function(req, res) {
    if (!req.user) {
      res.write("<h1>Unauthenticated.</h1>");
      return res.end("<a href='/login/'>Log in with OAuth</a>");
    } else {
      res.write('<h1>Authenticated.</h1>');
      return req.user('metadata/sandbox/').get(function(err, json) {
        var f, _i, _len, _ref;
        res.write('<pre>');
        res.write('Sandbox contents: (error ' + err + ')\n');
        _ref = json != null ? json.contents : void 0;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          f = _ref[_i];
          res.write(' - ' + f.path + '\n');
        }
        return res.end();
      });
    }
  });

  console.log('Visit:', "http://localhost:3000/");

}).call(this);
