// Generated by CoffeeScript 1.3.1
(function() {
  var app, express, fb, fs, keys, oauth, read, rem;

  rem = require('../rem');

  fs = require('fs');

  read = require('read');

  express = require('express');

  keys = JSON.parse(fs.readFileSync(__dirname + '/keys.json'));

  fb = rem.load('facebook', '1', {
    key: keys.facebook.key,
    secret: keys.facebook.secret
  });

  app = express.createServer();

  app.use(express.cookieParser());

  app.use(express.session({
    secret: "some arbitrary secret"
  }));

  app.listen(3000);

  oauth = rem.oauth(fb, "http://localhost:3000/oauth/callback/");

  app.use(oauth.middleware(function(req, res, next) {
    console.log("Authenticated user.");
    return res.redirect('/');
  }));

  app.get('/login/', function(req, res) {
    return oauth.startSession(req, function(url) {
      return res.redirect(url);
    });
  });

  app.get('/', function(req, res) {
    if (!req.user) {
      res.write("<h1>Unauthenticated.</h1>");
      return res.end("<a href='/login/'>Log in with OAuth</a>");
    } else {
      res.write('<h1>Authenticated.</h1>');
      return req.user('me').get(function(err, json) {
        res.write('<pre>');
        res.write('Your profile: (error ' + err + ')\n');
        res.write(JSON.stringify(json, null, '\t'));
        return res.end();
      });
    }
  });

  console.log('Visit:', "http://localhost:3000/");

}).call(this);
