# SPDX-License-Identifier: GPL-2.0
# Copyright (C) 2024-present JELOS (https://github.com/JustEnoughLinuxOS)

PKG_NAME="nvtop"
PKG_VERSION="eb56ee86ae0836872ee182fa2a15b1f1434d8efe"
PKG_ARCH="arm aarch64"
PKG_LICENSE="GPLv3"
PKG_SITE="https://github.com/Syllo/nvtop"
PKG_URL="${PKG_SITE}.git"
PKG_DEPENDS_TARGET=" libdrm mesa"
PKG_SHORTDESC="NVTOP stands for Neat Videocard TOP, a (h)top like task monitor for AMD, Intel and NVIDIA GPUs."
PKG_TOOLCHAIN="cmake"

case ${TARGET_ARCH} in
  x86_64)
    PKG_CMAKE_OPTS_TARGET+=" -DNVIDIA_SUPPORT_DEFAULT=ON -DAMDGPU_SUPPORT_DEFAULT=ON -DINTEL_SUPPORT_DEFAULT=ON -DPANFROST_SUPPORT_DEFAULT=OFF -DPANTHOR_SUPPORT_DEFAULT=OFF -DMSM_SUPPORT_DEFAULT=OF"
  ;;
  aarch64|arm)
      PKG_CMAKE_OPTS_TARGET+=" -DPANFROST_SUPPORT_DEFAULT=ON -DPANTHOR_SUPPORT_DEFAULT=OFF -DMSM_SUPPORT_DEFAULT=OFF -DNVIDIA_SUPPORT_DEFAULT=OFF -DAMDGPU_SUPPORT_DEFAULT=OFF -DINTEL_SUPPORT_DEFAULT=OFF"
  ;;
esac
