#pragma once
/*
 *      Copyright (C) 2010-2013 Team XBMC
 *      http://kodi.tv
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XBMC; see the file COPYING.  If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

#include <string>
#include "cores/AudioEngine/Utils/AEAudioFormat.h"

class IAESound
{
protected:
  friend class IAE;
  explicit IAESound(const std::string &filename) {}
  virtual ~IAESound() = default;

public:
  /* play the sound this object represents */
  virtual void Play() = 0;

  /* stop playing the sound this object represents */
  virtual void Stop() = 0;

  /* return true if the sound is currently playing */
  virtual bool IsPlaying() = 0;

  /* set the playback channel of this sound, AE_CH_NULL for all */
  virtual void SetChannel(AEChannel channel) = 0;

  /* get the current playback channel of this sound, AE_CH_NULL for all */
  virtual AEChannel GetChannel() = 0;

  /* set the playback volume of this sound */
  virtual void SetVolume(float volume) = 0;

  /* get the current playback volume of this sound */
  virtual float GetVolume() = 0;
};

