// Code generated by protoc-gen-go. DO NOT EDIT.
// plugins:
// 	protoc-gen-go
// 	protoc
// source: temporal/server/api/deployment/v1/message.proto

package deployment

import (
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"

	v12 "go.temporal.io/api/common/v1"
	v11 "go.temporal.io/api/deployment/v1"
	v1 "go.temporal.io/api/enums/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Identifies a Worker Deployment Version. The combination of `deployment_name` and `build_id`
// serve as the identifier.
type WorkerDeploymentVersion struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name of the Deployment this version belongs too.
	DeploymentName string `protobuf:"bytes,1,opt,name=deployment_name,json=deploymentName,proto3" json:"deployment_name,omitempty"`
	// Build ID uniquely identifies the Deployment Version within a Deployment, but the same Build
	// ID can be used in multiple Deployments.
	BuildId       string `protobuf:"bytes,2,opt,name=build_id,json=buildId,proto3" json:"build_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WorkerDeploymentVersion) Reset() {
	*x = WorkerDeploymentVersion{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkerDeploymentVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerDeploymentVersion) ProtoMessage() {}

func (x *WorkerDeploymentVersion) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerDeploymentVersion.ProtoReflect.Descriptor instead.
func (*WorkerDeploymentVersion) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{0}
}

func (x *WorkerDeploymentVersion) GetDeploymentName() string {
	if x != nil {
		return x.DeploymentName
	}
	return ""
}

func (x *WorkerDeploymentVersion) GetBuildId() string {
	if x != nil {
		return x.BuildId
	}
	return ""
}

// The source of truth for this data is in the WorkerDeployment entity workflows, which is
// synced to all TQs whenever the source changes.
// Deprecated.
type DeploymentVersionData struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Nil means unversioned.
	Version *WorkerDeploymentVersion `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Last time `current_since_time`, `ramping_since_time, or `ramp_percentage` of this version changed.
	RoutingUpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=routing_update_time,json=routingUpdateTime,proto3" json:"routing_update_time,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//
	//	aip.dev/not-precedent: 'Since' captures the field semantics despite being a preposition. --)
	//
	// Nil if not current.
	CurrentSinceTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=current_since_time,json=currentSinceTime,proto3" json:"current_since_time,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//
	//	aip.dev/not-precedent: 'Since' captures the field semantics despite being a preposition. --)
	//
	// Nil if not ramping. Updated when the version first starts ramping, not on each ramp change.
	RampingSinceTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=ramping_since_time,json=rampingSinceTime,proto3" json:"ramping_since_time,omitempty"`
	// Range: [0, 100]. Must be zero if the version is not ramping (i.e. `ramping_since_time` is nil).
	// Can be in the range [0, 100] if the version is ramping.
	RampPercentage float32 `protobuf:"fixed32,5,opt,name=ramp_percentage,json=rampPercentage,proto3" json:"ramp_percentage,omitempty"`
	// Status of the Worker Deployment Version.
	Status        v1.WorkerDeploymentVersionStatus `protobuf:"varint,6,opt,name=status,proto3,enum=temporal.api.enums.v1.WorkerDeploymentVersionStatus" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeploymentVersionData) Reset() {
	*x = DeploymentVersionData{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeploymentVersionData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeploymentVersionData) ProtoMessage() {}

func (x *DeploymentVersionData) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeploymentVersionData.ProtoReflect.Descriptor instead.
func (*DeploymentVersionData) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{1}
}

func (x *DeploymentVersionData) GetVersion() *WorkerDeploymentVersion {
	if x != nil {
		return x.Version
	}
	return nil
}

func (x *DeploymentVersionData) GetRoutingUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RoutingUpdateTime
	}
	return nil
}

func (x *DeploymentVersionData) GetCurrentSinceTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CurrentSinceTime
	}
	return nil
}

func (x *DeploymentVersionData) GetRampingSinceTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RampingSinceTime
	}
	return nil
}

func (x *DeploymentVersionData) GetRampPercentage() float32 {
	if x != nil {
		return x.RampPercentage
	}
	return 0
}

func (x *DeploymentVersionData) GetStatus() v1.WorkerDeploymentVersionStatus {
	if x != nil {
		return x.Status
	}
	return v1.WorkerDeploymentVersionStatus(0)
}

// Information that a TQ should know about a particular Deployment Version. This info is not part of
// RoutingConfig and hence not protected by the revision number.
type WorkerDeploymentVersionData struct {
	state         protoimpl.MessageState           `protogen:"open.v1"`
	Status        v1.WorkerDeploymentVersionStatus `protobuf:"varint,6,opt,name=status,proto3,enum=temporal.api.enums.v1.WorkerDeploymentVersionStatus" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WorkerDeploymentVersionData) Reset() {
	*x = WorkerDeploymentVersionData{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkerDeploymentVersionData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerDeploymentVersionData) ProtoMessage() {}

func (x *WorkerDeploymentVersionData) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerDeploymentVersionData.ProtoReflect.Descriptor instead.
func (*WorkerDeploymentVersionData) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{2}
}

func (x *WorkerDeploymentVersionData) GetStatus() v1.WorkerDeploymentVersionStatus {
	if x != nil {
		return x.Status
	}
	return v1.WorkerDeploymentVersionStatus(0)
}

// Local state for Worker Deployment Version
type VersionLocalState struct {
	state      protoimpl.MessageState   `protogen:"open.v1"`
	Version    *WorkerDeploymentVersion `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	CreateTime *timestamppb.Timestamp   `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Last time `current_since_time`, `ramping_since_time, or `ramp_percentage` of this version changed.
	RoutingUpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=routing_update_time,json=routingUpdateTime,proto3" json:"routing_update_time,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//
	//	aip.dev/not-precedent: 'Since' captures the field semantics despite being a preposition. --)
	//
	// Nil if not current.
	CurrentSinceTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=current_since_time,json=currentSinceTime,proto3" json:"current_since_time,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//
	//	aip.dev/not-precedent: 'Since' captures the field semantics despite being a preposition. --)
	//
	// Nil if not ramping. Updated when the version first starts ramping, not on each ramp change.
	RampingSinceTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=ramping_since_time,json=rampingSinceTime,proto3" json:"ramping_since_time,omitempty"`
	// Range: [0, 100]. Must be zero if the version is not ramping (i.e. `ramping_since_time` is nil).
	// Can be in the range [0, 100] if the version is ramping.
	RampPercentage float32 `protobuf:"fixed32,6,opt,name=ramp_percentage,json=rampPercentage,proto3" json:"ramp_percentage,omitempty"`
	// Timestamp when this version first became current or ramping.
	FirstActivationTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=first_activation_time,json=firstActivationTime,proto3" json:"first_activation_time,omitempty"`
	// Timestamp when this version last stopped being current or ramping.
	LastDeactivationTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=last_deactivation_time,json=lastDeactivationTime,proto3" json:"last_deactivation_time,omitempty"`
	// Helps user determine when it is safe to decommission the workers of this
	// Version. Not present when version is current or ramping.
	// Current limitations:
	//   - Not supported for Unversioned mode.
	//   - Periodically refreshed, may have delays up to few minutes (consult the
	//     last_checked_time value).
	//   - Refreshed only when version is not current or ramping AND the status is not
	//     "drained" yet.
	//   - Once the status is changed to "drained", it is not changed until the Version
	//     becomes Current or Ramping again, at which time the drainage info is cleared.
	//     This means if the Version is "drained" but new workflows are sent to it via
	//     Pinned Versioning Override, the status does not account for those Pinned-override
	//     executions and remains "drained".
	DrainageInfo *v11.VersionDrainageInfo `protobuf:"bytes,7,opt,name=drainage_info,json=drainageInfo,proto3" json:"drainage_info,omitempty"`
	// Arbitrary user-provided metadata attached to this version.
	Metadata                  *v11.VersionMetadata `protobuf:"bytes,8,opt,name=metadata,proto3" json:"metadata,omitempty"`
	StartedDeploymentWorkflow bool                 `protobuf:"varint,9,opt,name=started_deployment_workflow,json=startedDeploymentWorkflow,proto3" json:"started_deployment_workflow,omitempty"`
	// Key: Task Queue Name
	TaskQueueFamilies map[string]*VersionLocalState_TaskQueueFamilyData `protobuf:"bytes,10,rep,name=task_queue_families,json=taskQueueFamilies,proto3" json:"task_queue_families,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Number of task queues which will be synced in a single batch.
	SyncBatchSize int32 `protobuf:"varint,11,opt,name=sync_batch_size,json=syncBatchSize,proto3" json:"sync_batch_size,omitempty"`
	// Status of the Worker Deployment Version.
	Status        v1.WorkerDeploymentVersionStatus `protobuf:"varint,14,opt,name=status,proto3,enum=temporal.api.enums.v1.WorkerDeploymentVersionStatus" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VersionLocalState) Reset() {
	*x = VersionLocalState{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VersionLocalState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionLocalState) ProtoMessage() {}

func (x *VersionLocalState) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionLocalState.ProtoReflect.Descriptor instead.
func (*VersionLocalState) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{3}
}

func (x *VersionLocalState) GetVersion() *WorkerDeploymentVersion {
	if x != nil {
		return x.Version
	}
	return nil
}

func (x *VersionLocalState) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *VersionLocalState) GetRoutingUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RoutingUpdateTime
	}
	return nil
}

func (x *VersionLocalState) GetCurrentSinceTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CurrentSinceTime
	}
	return nil
}

func (x *VersionLocalState) GetRampingSinceTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RampingSinceTime
	}
	return nil
}

func (x *VersionLocalState) GetRampPercentage() float32 {
	if x != nil {
		return x.RampPercentage
	}
	return 0
}

func (x *VersionLocalState) GetFirstActivationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.FirstActivationTime
	}
	return nil
}

func (x *VersionLocalState) GetLastDeactivationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastDeactivationTime
	}
	return nil
}

func (x *VersionLocalState) GetDrainageInfo() *v11.VersionDrainageInfo {
	if x != nil {
		return x.DrainageInfo
	}
	return nil
}

func (x *VersionLocalState) GetMetadata() *v11.VersionMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *VersionLocalState) GetStartedDeploymentWorkflow() bool {
	if x != nil {
		return x.StartedDeploymentWorkflow
	}
	return false
}

func (x *VersionLocalState) GetTaskQueueFamilies() map[string]*VersionLocalState_TaskQueueFamilyData {
	if x != nil {
		return x.TaskQueueFamilies
	}
	return nil
}

func (x *VersionLocalState) GetSyncBatchSize() int32 {
	if x != nil {
		return x.SyncBatchSize
	}
	return 0
}

func (x *VersionLocalState) GetStatus() v1.WorkerDeploymentVersionStatus {
	if x != nil {
		return x.Status
	}
	return v1.WorkerDeploymentVersionStatus(0)
}

// Data specific to a task queue, from the perspective of a worker deployment version.
type TaskQueueVersionData struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TaskQueueVersionData) Reset() {
	*x = TaskQueueVersionData{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TaskQueueVersionData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskQueueVersionData) ProtoMessage() {}

func (x *TaskQueueVersionData) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskQueueVersionData.ProtoReflect.Descriptor instead.
func (*TaskQueueVersionData) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{4}
}

// used as Worker Deployment Version workflow input:
type WorkerDeploymentVersionWorkflowArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	NamespaceName string                 `protobuf:"bytes,1,opt,name=namespace_name,json=namespaceName,proto3" json:"namespace_name,omitempty"`
	NamespaceId   string                 `protobuf:"bytes,2,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	VersionState  *VersionLocalState     `protobuf:"bytes,3,opt,name=version_state,json=versionState,proto3" json:"version_state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WorkerDeploymentVersionWorkflowArgs) Reset() {
	*x = WorkerDeploymentVersionWorkflowArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkerDeploymentVersionWorkflowArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerDeploymentVersionWorkflowArgs) ProtoMessage() {}

func (x *WorkerDeploymentVersionWorkflowArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerDeploymentVersionWorkflowArgs.ProtoReflect.Descriptor instead.
func (*WorkerDeploymentVersionWorkflowArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{5}
}

func (x *WorkerDeploymentVersionWorkflowArgs) GetNamespaceName() string {
	if x != nil {
		return x.NamespaceName
	}
	return ""
}

func (x *WorkerDeploymentVersionWorkflowArgs) GetNamespaceId() string {
	if x != nil {
		return x.NamespaceId
	}
	return ""
}

func (x *WorkerDeploymentVersionWorkflowArgs) GetVersionState() *VersionLocalState {
	if x != nil {
		return x.VersionState
	}
	return nil
}

// used as Worker Deployment workflow input:
type WorkerDeploymentWorkflowArgs struct {
	state          protoimpl.MessageState      `protogen:"open.v1"`
	NamespaceName  string                      `protobuf:"bytes,1,opt,name=namespace_name,json=namespaceName,proto3" json:"namespace_name,omitempty"`
	NamespaceId    string                      `protobuf:"bytes,2,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	DeploymentName string                      `protobuf:"bytes,3,opt,name=deployment_name,json=deploymentName,proto3" json:"deployment_name,omitempty"`
	State          *WorkerDeploymentLocalState `protobuf:"bytes,4,opt,name=state,proto3" json:"state,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *WorkerDeploymentWorkflowArgs) Reset() {
	*x = WorkerDeploymentWorkflowArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkerDeploymentWorkflowArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerDeploymentWorkflowArgs) ProtoMessage() {}

func (x *WorkerDeploymentWorkflowArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerDeploymentWorkflowArgs.ProtoReflect.Descriptor instead.
func (*WorkerDeploymentWorkflowArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{6}
}

func (x *WorkerDeploymentWorkflowArgs) GetNamespaceName() string {
	if x != nil {
		return x.NamespaceName
	}
	return ""
}

func (x *WorkerDeploymentWorkflowArgs) GetNamespaceId() string {
	if x != nil {
		return x.NamespaceId
	}
	return ""
}

func (x *WorkerDeploymentWorkflowArgs) GetDeploymentName() string {
	if x != nil {
		return x.DeploymentName
	}
	return ""
}

func (x *WorkerDeploymentWorkflowArgs) GetState() *WorkerDeploymentLocalState {
	if x != nil {
		return x.State
	}
	return nil
}

// Local state for Worker Deployment
type WorkerDeploymentLocalState struct {
	state      protoimpl.MessageState `protogen:"open.v1"`
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Encapsulates task routing information for this deployment.
	RoutingConfig        *v11.RoutingConfig                         `protobuf:"bytes,2,opt,name=routing_config,json=routingConfig,proto3" json:"routing_config,omitempty"`
	Versions             map[string]*WorkerDeploymentVersionSummary `protobuf:"bytes,3,rep,name=versions,proto3" json:"versions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	ConflictToken        []byte                                     `protobuf:"bytes,4,opt,name=conflict_token,json=conflictToken,proto3" json:"conflict_token,omitempty"`
	LastModifierIdentity string                                     `protobuf:"bytes,5,opt,name=last_modifier_identity,json=lastModifierIdentity,proto3" json:"last_modifier_identity,omitempty"`
	// Number of task queues which will be synced in a single batch.
	SyncBatchSize   int32  `protobuf:"varint,6,opt,name=sync_batch_size,json=syncBatchSize,proto3" json:"sync_batch_size,omitempty"`
	ManagerIdentity string `protobuf:"bytes,7,opt,name=manager_identity,json=managerIdentity,proto3" json:"manager_identity,omitempty"`
	// Track async propagations in progress per build ID. Map: build_id -> revision numbers.
	// Used to track which propagations are still pending across continue-as-new.
	PropagatingRevisions map[string]*PropagatingRevisions `protobuf:"bytes,8,rep,name=propagating_revisions,json=propagatingRevisions,proto3" json:"propagating_revisions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *WorkerDeploymentLocalState) Reset() {
	*x = WorkerDeploymentLocalState{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkerDeploymentLocalState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerDeploymentLocalState) ProtoMessage() {}

func (x *WorkerDeploymentLocalState) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerDeploymentLocalState.ProtoReflect.Descriptor instead.
func (*WorkerDeploymentLocalState) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{7}
}

func (x *WorkerDeploymentLocalState) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *WorkerDeploymentLocalState) GetRoutingConfig() *v11.RoutingConfig {
	if x != nil {
		return x.RoutingConfig
	}
	return nil
}

func (x *WorkerDeploymentLocalState) GetVersions() map[string]*WorkerDeploymentVersionSummary {
	if x != nil {
		return x.Versions
	}
	return nil
}

func (x *WorkerDeploymentLocalState) GetConflictToken() []byte {
	if x != nil {
		return x.ConflictToken
	}
	return nil
}

func (x *WorkerDeploymentLocalState) GetLastModifierIdentity() string {
	if x != nil {
		return x.LastModifierIdentity
	}
	return ""
}

func (x *WorkerDeploymentLocalState) GetSyncBatchSize() int32 {
	if x != nil {
		return x.SyncBatchSize
	}
	return 0
}

func (x *WorkerDeploymentLocalState) GetManagerIdentity() string {
	if x != nil {
		return x.ManagerIdentity
	}
	return ""
}

func (x *WorkerDeploymentLocalState) GetPropagatingRevisions() map[string]*PropagatingRevisions {
	if x != nil {
		return x.PropagatingRevisions
	}
	return nil
}

// Tracks revision numbers that are currently propagating for a specific build ID
type PropagatingRevisions struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	RevisionNumbers []int64                `protobuf:"varint,1,rep,packed,name=revision_numbers,json=revisionNumbers,proto3" json:"revision_numbers,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *PropagatingRevisions) Reset() {
	*x = PropagatingRevisions{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PropagatingRevisions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PropagatingRevisions) ProtoMessage() {}

func (x *PropagatingRevisions) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PropagatingRevisions.ProtoReflect.Descriptor instead.
func (*PropagatingRevisions) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{8}
}

func (x *PropagatingRevisions) GetRevisionNumbers() []int64 {
	if x != nil {
		return x.RevisionNumbers
	}
	return nil
}

type WorkerDeploymentVersionSummary struct {
	state      protoimpl.MessageState `protogen:"open.v1"`
	Version    string                 `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Deprecated: Marked as deprecated in temporal/server/api/deployment/v1/message.proto.
	DrainageStatus v1.VersionDrainageStatus `protobuf:"varint,3,opt,name=drainage_status,json=drainageStatus,proto3,enum=temporal.api.enums.v1.VersionDrainageStatus" json:"drainage_status,omitempty"`
	// Information about workflow drainage to help the user determine when it is safe
	// to decommission a Version. Not present while version is current or ramping.
	DrainageInfo *v11.VersionDrainageInfo `protobuf:"bytes,4,opt,name=drainage_info,json=drainageInfo,proto3" json:"drainage_info,omitempty"`
	// Last time `current_since_time`, `ramping_since_time, or `ramp_percentage` of this version changed.
	RoutingUpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=routing_update_time,json=routingUpdateTime,proto3" json:"routing_update_time,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//
	//	aip.dev/not-precedent: 'Since' captures the field semantics despite being a preposition. --)
	//
	// Nil if not current.
	CurrentSinceTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=current_since_time,json=currentSinceTime,proto3" json:"current_since_time,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//
	//	aip.dev/not-precedent: 'Since' captures the field semantics despite being a preposition. --)
	//
	// Nil if not ramping. Updated when the version first starts ramping, not on each ramp change.
	RampingSinceTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=ramping_since_time,json=rampingSinceTime,proto3" json:"ramping_since_time,omitempty"`
	// Timestamp when this version first became current or ramping.
	FirstActivationTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=first_activation_time,json=firstActivationTime,proto3" json:"first_activation_time,omitempty"`
	// Timestamp when this version last stopped being current or ramping.
	LastDeactivationTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=last_deactivation_time,json=lastDeactivationTime,proto3" json:"last_deactivation_time,omitempty"`
	// Status of the Worker Deployment Version.
	Status        v1.WorkerDeploymentVersionStatus `protobuf:"varint,10,opt,name=status,proto3,enum=temporal.api.enums.v1.WorkerDeploymentVersionStatus" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WorkerDeploymentVersionSummary) Reset() {
	*x = WorkerDeploymentVersionSummary{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkerDeploymentVersionSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerDeploymentVersionSummary) ProtoMessage() {}

func (x *WorkerDeploymentVersionSummary) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerDeploymentVersionSummary.ProtoReflect.Descriptor instead.
func (*WorkerDeploymentVersionSummary) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{9}
}

func (x *WorkerDeploymentVersionSummary) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *WorkerDeploymentVersionSummary) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Deprecated: Marked as deprecated in temporal/server/api/deployment/v1/message.proto.
func (x *WorkerDeploymentVersionSummary) GetDrainageStatus() v1.VersionDrainageStatus {
	if x != nil {
		return x.DrainageStatus
	}
	return v1.VersionDrainageStatus(0)
}

func (x *WorkerDeploymentVersionSummary) GetDrainageInfo() *v11.VersionDrainageInfo {
	if x != nil {
		return x.DrainageInfo
	}
	return nil
}

func (x *WorkerDeploymentVersionSummary) GetRoutingUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RoutingUpdateTime
	}
	return nil
}

func (x *WorkerDeploymentVersionSummary) GetCurrentSinceTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CurrentSinceTime
	}
	return nil
}

func (x *WorkerDeploymentVersionSummary) GetRampingSinceTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RampingSinceTime
	}
	return nil
}

func (x *WorkerDeploymentVersionSummary) GetFirstActivationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.FirstActivationTime
	}
	return nil
}

func (x *WorkerDeploymentVersionSummary) GetLastDeactivationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastDeactivationTime
	}
	return nil
}

func (x *WorkerDeploymentVersionSummary) GetStatus() v1.WorkerDeploymentVersionStatus {
	if x != nil {
		return x.Status
	}
	return v1.WorkerDeploymentVersionStatus(0)
}

// used as Worker Deployment Version workflow update input:
type RegisterWorkerInVersionArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TaskQueueName string                 `protobuf:"bytes,1,opt,name=task_queue_name,json=taskQueueName,proto3" json:"task_queue_name,omitempty"`
	TaskQueueType v1.TaskQueueType       `protobuf:"varint,2,opt,name=task_queue_type,json=taskQueueType,proto3,enum=temporal.api.enums.v1.TaskQueueType" json:"task_queue_type,omitempty"`
	MaxTaskQueues int32                  `protobuf:"varint,3,opt,name=max_task_queues,json=maxTaskQueues,proto3" json:"max_task_queues,omitempty"`
	Version       string                 `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	RoutingConfig *v11.RoutingConfig     `protobuf:"bytes,5,opt,name=routing_config,json=routingConfig,proto3" json:"routing_config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RegisterWorkerInVersionArgs) Reset() {
	*x = RegisterWorkerInVersionArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RegisterWorkerInVersionArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterWorkerInVersionArgs) ProtoMessage() {}

func (x *RegisterWorkerInVersionArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterWorkerInVersionArgs.ProtoReflect.Descriptor instead.
func (*RegisterWorkerInVersionArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{10}
}

func (x *RegisterWorkerInVersionArgs) GetTaskQueueName() string {
	if x != nil {
		return x.TaskQueueName
	}
	return ""
}

func (x *RegisterWorkerInVersionArgs) GetTaskQueueType() v1.TaskQueueType {
	if x != nil {
		return x.TaskQueueType
	}
	return v1.TaskQueueType(0)
}

func (x *RegisterWorkerInVersionArgs) GetMaxTaskQueues() int32 {
	if x != nil {
		return x.MaxTaskQueues
	}
	return 0
}

func (x *RegisterWorkerInVersionArgs) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *RegisterWorkerInVersionArgs) GetRoutingConfig() *v11.RoutingConfig {
	if x != nil {
		return x.RoutingConfig
	}
	return nil
}

// used as Worker Deployment workflow update input:
type RegisterWorkerInWorkerDeploymentArgs struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	TaskQueueName string                   `protobuf:"bytes,1,opt,name=task_queue_name,json=taskQueueName,proto3" json:"task_queue_name,omitempty"`
	TaskQueueType v1.TaskQueueType         `protobuf:"varint,2,opt,name=task_queue_type,json=taskQueueType,proto3,enum=temporal.api.enums.v1.TaskQueueType" json:"task_queue_type,omitempty"`
	MaxTaskQueues int32                    `protobuf:"varint,3,opt,name=max_task_queues,json=maxTaskQueues,proto3" json:"max_task_queues,omitempty"`
	Version       *WorkerDeploymentVersion `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RegisterWorkerInWorkerDeploymentArgs) Reset() {
	*x = RegisterWorkerInWorkerDeploymentArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RegisterWorkerInWorkerDeploymentArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterWorkerInWorkerDeploymentArgs) ProtoMessage() {}

func (x *RegisterWorkerInWorkerDeploymentArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterWorkerInWorkerDeploymentArgs.ProtoReflect.Descriptor instead.
func (*RegisterWorkerInWorkerDeploymentArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{11}
}

func (x *RegisterWorkerInWorkerDeploymentArgs) GetTaskQueueName() string {
	if x != nil {
		return x.TaskQueueName
	}
	return ""
}

func (x *RegisterWorkerInWorkerDeploymentArgs) GetTaskQueueType() v1.TaskQueueType {
	if x != nil {
		return x.TaskQueueType
	}
	return v1.TaskQueueType(0)
}

func (x *RegisterWorkerInWorkerDeploymentArgs) GetMaxTaskQueues() int32 {
	if x != nil {
		return x.MaxTaskQueues
	}
	return 0
}

func (x *RegisterWorkerInWorkerDeploymentArgs) GetVersion() *WorkerDeploymentVersion {
	if x != nil {
		return x.Version
	}
	return nil
}

// used as Worker Deployment workflow activity input:
type DescribeVersionFromWorkerDeploymentActivityArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Version       string                 `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DescribeVersionFromWorkerDeploymentActivityArgs) Reset() {
	*x = DescribeVersionFromWorkerDeploymentActivityArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DescribeVersionFromWorkerDeploymentActivityArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DescribeVersionFromWorkerDeploymentActivityArgs) ProtoMessage() {}

func (x *DescribeVersionFromWorkerDeploymentActivityArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DescribeVersionFromWorkerDeploymentActivityArgs.ProtoReflect.Descriptor instead.
func (*DescribeVersionFromWorkerDeploymentActivityArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{12}
}

func (x *DescribeVersionFromWorkerDeploymentActivityArgs) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type DescribeVersionFromWorkerDeploymentActivityResult struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// All the Task Queues that have ever polled from this Deployment version.
	TaskQueueInfos []*v11.WorkerDeploymentVersionInfo_VersionTaskQueueInfo `protobuf:"bytes,1,rep,name=task_queue_infos,json=taskQueueInfos,proto3" json:"task_queue_infos,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *DescribeVersionFromWorkerDeploymentActivityResult) Reset() {
	*x = DescribeVersionFromWorkerDeploymentActivityResult{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DescribeVersionFromWorkerDeploymentActivityResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DescribeVersionFromWorkerDeploymentActivityResult) ProtoMessage() {}

func (x *DescribeVersionFromWorkerDeploymentActivityResult) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DescribeVersionFromWorkerDeploymentActivityResult.ProtoReflect.Descriptor instead.
func (*DescribeVersionFromWorkerDeploymentActivityResult) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{13}
}

func (x *DescribeVersionFromWorkerDeploymentActivityResult) GetTaskQueueInfos() []*v11.WorkerDeploymentVersionInfo_VersionTaskQueueInfo {
	if x != nil {
		return x.TaskQueueInfos
	}
	return nil
}

// used as Worker Deployment workflow update input (sent from Worker Deployment workflow):
type SyncVersionStateUpdateArgs struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Last time `current_since_time`, `ramping_since_time, or `ramp_percentage` of this version changed.
	//
	// Deprecated: Marked as deprecated in temporal/server/api/deployment/v1/message.proto.
	RoutingUpdateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=routing_update_time,json=routingUpdateTime,proto3" json:"routing_update_time,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//
	//	aip.dev/not-precedent: 'Since' captures the field semantics despite being a preposition. --)
	//
	// Nil if not current.
	//
	// Deprecated: Marked as deprecated in temporal/server/api/deployment/v1/message.proto.
	CurrentSinceTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=current_since_time,json=currentSinceTime,proto3" json:"current_since_time,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//
	//	aip.dev/not-precedent: 'Since' captures the field semantics despite being a preposition. --)
	//
	// Nil if not ramping. Updated when the version first starts ramping, not on each ramp change.
	//
	// Deprecated: Marked as deprecated in temporal/server/api/deployment/v1/message.proto.
	RampingSinceTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=ramping_since_time,json=rampingSinceTime,proto3" json:"ramping_since_time,omitempty"`
	// Range: [0, 100]. Must be zero if the version is not ramping (i.e. `ramping_since_time` is nil).
	// Can be in the range [0, 100] if the version is ramping.
	//
	// Deprecated: Marked as deprecated in temporal/server/api/deployment/v1/message.proto.
	RampPercentage float32 `protobuf:"fixed32,4,opt,name=ramp_percentage,json=rampPercentage,proto3" json:"ramp_percentage,omitempty"`
	// Full routing config for async propagation mode. When present, the version workflow
	// will propagate the entire routing config asynchronously. When absent, sync mode is used.
	RoutingConfig *v11.RoutingConfig `protobuf:"bytes,5,opt,name=routing_config,json=routingConfig,proto3" json:"routing_config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyncVersionStateUpdateArgs) Reset() {
	*x = SyncVersionStateUpdateArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncVersionStateUpdateArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncVersionStateUpdateArgs) ProtoMessage() {}

func (x *SyncVersionStateUpdateArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncVersionStateUpdateArgs.ProtoReflect.Descriptor instead.
func (*SyncVersionStateUpdateArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{14}
}

// Deprecated: Marked as deprecated in temporal/server/api/deployment/v1/message.proto.
func (x *SyncVersionStateUpdateArgs) GetRoutingUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RoutingUpdateTime
	}
	return nil
}

// Deprecated: Marked as deprecated in temporal/server/api/deployment/v1/message.proto.
func (x *SyncVersionStateUpdateArgs) GetCurrentSinceTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CurrentSinceTime
	}
	return nil
}

// Deprecated: Marked as deprecated in temporal/server/api/deployment/v1/message.proto.
func (x *SyncVersionStateUpdateArgs) GetRampingSinceTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RampingSinceTime
	}
	return nil
}

// Deprecated: Marked as deprecated in temporal/server/api/deployment/v1/message.proto.
func (x *SyncVersionStateUpdateArgs) GetRampPercentage() float32 {
	if x != nil {
		return x.RampPercentage
	}
	return 0
}

func (x *SyncVersionStateUpdateArgs) GetRoutingConfig() *v11.RoutingConfig {
	if x != nil {
		return x.RoutingConfig
	}
	return nil
}

// used as Worker Deployment workflow update response (sent from Worker Deployment workflow):
type SyncVersionStateResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Deprecated. State could be so large, no need to send it to the deployment workflow.
	//
	// Deprecated: Marked as deprecated in temporal/server/api/deployment/v1/message.proto.
	VersionState  *VersionLocalState              `protobuf:"bytes,1,opt,name=version_state,json=versionState,proto3" json:"version_state,omitempty"`
	Summary       *WorkerDeploymentVersionSummary `protobuf:"bytes,2,opt,name=summary,proto3" json:"summary,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyncVersionStateResponse) Reset() {
	*x = SyncVersionStateResponse{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncVersionStateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncVersionStateResponse) ProtoMessage() {}

func (x *SyncVersionStateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncVersionStateResponse.ProtoReflect.Descriptor instead.
func (*SyncVersionStateResponse) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{15}
}

// Deprecated: Marked as deprecated in temporal/server/api/deployment/v1/message.proto.
func (x *SyncVersionStateResponse) GetVersionState() *VersionLocalState {
	if x != nil {
		return x.VersionState
	}
	return nil
}

func (x *SyncVersionStateResponse) GetSummary() *WorkerDeploymentVersionSummary {
	if x != nil {
		return x.Summary
	}
	return nil
}

// Sent from Version workflow to Worker Deployment workflow
type AddVersionUpdateArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Version       string                 `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	CreateTime    *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AddVersionUpdateArgs) Reset() {
	*x = AddVersionUpdateArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddVersionUpdateArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddVersionUpdateArgs) ProtoMessage() {}

func (x *AddVersionUpdateArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddVersionUpdateArgs.ProtoReflect.Descriptor instead.
func (*AddVersionUpdateArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{16}
}

func (x *AddVersionUpdateArgs) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *AddVersionUpdateArgs) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Sent from Drainage child workflow to Version parent
type SyncDrainageInfoSignalArgs struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	DrainageInfo  *v11.VersionDrainageInfo `protobuf:"bytes,1,opt,name=drainage_info,json=drainageInfo,proto3" json:"drainage_info,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyncDrainageInfoSignalArgs) Reset() {
	*x = SyncDrainageInfoSignalArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncDrainageInfoSignalArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncDrainageInfoSignalArgs) ProtoMessage() {}

func (x *SyncDrainageInfoSignalArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncDrainageInfoSignalArgs.ProtoReflect.Descriptor instead.
func (*SyncDrainageInfoSignalArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{17}
}

func (x *SyncDrainageInfoSignalArgs) GetDrainageInfo() *v11.VersionDrainageInfo {
	if x != nil {
		return x.DrainageInfo
	}
	return nil
}

// Sent from Version workflow to Worker Deployment workflow
type SyncDrainageStatusSignalArgs struct {
	state          protoimpl.MessageState   `protogen:"open.v1"`
	Version        string                   `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	DrainageStatus v1.VersionDrainageStatus `protobuf:"varint,2,opt,name=drainage_status,json=drainageStatus,proto3,enum=temporal.api.enums.v1.VersionDrainageStatus" json:"drainage_status,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *SyncDrainageStatusSignalArgs) Reset() {
	*x = SyncDrainageStatusSignalArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncDrainageStatusSignalArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncDrainageStatusSignalArgs) ProtoMessage() {}

func (x *SyncDrainageStatusSignalArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncDrainageStatusSignalArgs.ProtoReflect.Descriptor instead.
func (*SyncDrainageStatusSignalArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{18}
}

func (x *SyncDrainageStatusSignalArgs) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *SyncDrainageStatusSignalArgs) GetDrainageStatus() v1.VersionDrainageStatus {
	if x != nil {
		return x.DrainageStatus
	}
	return v1.VersionDrainageStatus(0)
}

// Sent from Version workflow to Worker Deployment workflow when async propagation completes
type PropagationCompletionInfo struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	RevisionNumber int64                  `protobuf:"varint,1,opt,name=revision_number,json=revisionNumber,proto3" json:"revision_number,omitempty"`
	BuildId        string                 `protobuf:"bytes,2,opt,name=build_id,json=buildId,proto3" json:"build_id,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *PropagationCompletionInfo) Reset() {
	*x = PropagationCompletionInfo{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PropagationCompletionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PropagationCompletionInfo) ProtoMessage() {}

func (x *PropagationCompletionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PropagationCompletionInfo.ProtoReflect.Descriptor instead.
func (*PropagationCompletionInfo) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{19}
}

func (x *PropagationCompletionInfo) GetRevisionNumber() int64 {
	if x != nil {
		return x.RevisionNumber
	}
	return 0
}

func (x *PropagationCompletionInfo) GetBuildId() string {
	if x != nil {
		return x.BuildId
	}
	return ""
}

// used as Worker Deployment Version workflow query response:
type QueryDescribeVersionResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	VersionState  *VersionLocalState     `protobuf:"bytes,1,opt,name=version_state,json=versionState,proto3" json:"version_state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *QueryDescribeVersionResponse) Reset() {
	*x = QueryDescribeVersionResponse{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryDescribeVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryDescribeVersionResponse) ProtoMessage() {}

func (x *QueryDescribeVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryDescribeVersionResponse.ProtoReflect.Descriptor instead.
func (*QueryDescribeVersionResponse) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{20}
}

func (x *QueryDescribeVersionResponse) GetVersionState() *VersionLocalState {
	if x != nil {
		return x.VersionState
	}
	return nil
}

// used as Worker Deployment Version workflow query response:
type QueryDescribeWorkerDeploymentResponse struct {
	state         protoimpl.MessageState      `protogen:"open.v1"`
	State         *WorkerDeploymentLocalState `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *QueryDescribeWorkerDeploymentResponse) Reset() {
	*x = QueryDescribeWorkerDeploymentResponse{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryDescribeWorkerDeploymentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryDescribeWorkerDeploymentResponse) ProtoMessage() {}

func (x *QueryDescribeWorkerDeploymentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryDescribeWorkerDeploymentResponse.ProtoReflect.Descriptor instead.
func (*QueryDescribeWorkerDeploymentResponse) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{21}
}

func (x *QueryDescribeWorkerDeploymentResponse) GetState() *WorkerDeploymentLocalState {
	if x != nil {
		return x.State
	}
	return nil
}

// used as Worker Deployment Version workflow activity input:
type StartWorkerDeploymentRequest struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	DeploymentName string                 `protobuf:"bytes,1,opt,name=deployment_name,json=deploymentName,proto3" json:"deployment_name,omitempty"`
	RequestId      string                 `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *StartWorkerDeploymentRequest) Reset() {
	*x = StartWorkerDeploymentRequest{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartWorkerDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartWorkerDeploymentRequest) ProtoMessage() {}

func (x *StartWorkerDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartWorkerDeploymentRequest.ProtoReflect.Descriptor instead.
func (*StartWorkerDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{22}
}

func (x *StartWorkerDeploymentRequest) GetDeploymentName() string {
	if x != nil {
		return x.DeploymentName
	}
	return ""
}

func (x *StartWorkerDeploymentRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// used as Worker Deployment workflow activity input:
type StartWorkerDeploymentVersionRequest struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	DeploymentName string                 `protobuf:"bytes,1,opt,name=deployment_name,json=deploymentName,proto3" json:"deployment_name,omitempty"`
	BuildId        string                 `protobuf:"bytes,2,opt,name=build_id,json=buildId,proto3" json:"build_id,omitempty"`
	RequestId      string                 `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *StartWorkerDeploymentVersionRequest) Reset() {
	*x = StartWorkerDeploymentVersionRequest{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartWorkerDeploymentVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartWorkerDeploymentVersionRequest) ProtoMessage() {}

func (x *StartWorkerDeploymentVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartWorkerDeploymentVersionRequest.ProtoReflect.Descriptor instead.
func (*StartWorkerDeploymentVersionRequest) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{23}
}

func (x *StartWorkerDeploymentVersionRequest) GetDeploymentName() string {
	if x != nil {
		return x.DeploymentName
	}
	return ""
}

func (x *StartWorkerDeploymentVersionRequest) GetBuildId() string {
	if x != nil {
		return x.BuildId
	}
	return ""
}

func (x *StartWorkerDeploymentVersionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// used as Worker Deployment Version workflow activity input:
type SyncDeploymentVersionUserDataRequest struct {
	state          protoimpl.MessageState                               `protogen:"open.v1"`
	DeploymentName string                                               `protobuf:"bytes,4,opt,name=deployment_name,json=deploymentName,proto3" json:"deployment_name,omitempty"`
	Version        *WorkerDeploymentVersion                             `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	Sync           []*SyncDeploymentVersionUserDataRequest_SyncUserData `protobuf:"bytes,2,rep,name=sync,proto3" json:"sync,omitempty"`
	// if true, the version will be forgotten from the task queue user data.
	ForgetVersion bool `protobuf:"varint,3,opt,name=forget_version,json=forgetVersion,proto3" json:"forget_version,omitempty"`
	// Async mode: full routing config to propagate (includes revision_number)
	UpdateRoutingConfig *v11.RoutingConfig `protobuf:"bytes,5,opt,name=update_routing_config,json=updateRoutingConfig,proto3" json:"update_routing_config,omitempty"`
	// Async mode: version-specific data to upsert
	UpsertVersionData *WorkerDeploymentVersionData `protobuf:"bytes,6,opt,name=upsert_version_data,json=upsertVersionData,proto3" json:"upsert_version_data,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *SyncDeploymentVersionUserDataRequest) Reset() {
	*x = SyncDeploymentVersionUserDataRequest{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncDeploymentVersionUserDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncDeploymentVersionUserDataRequest) ProtoMessage() {}

func (x *SyncDeploymentVersionUserDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncDeploymentVersionUserDataRequest.ProtoReflect.Descriptor instead.
func (*SyncDeploymentVersionUserDataRequest) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{24}
}

func (x *SyncDeploymentVersionUserDataRequest) GetDeploymentName() string {
	if x != nil {
		return x.DeploymentName
	}
	return ""
}

func (x *SyncDeploymentVersionUserDataRequest) GetVersion() *WorkerDeploymentVersion {
	if x != nil {
		return x.Version
	}
	return nil
}

func (x *SyncDeploymentVersionUserDataRequest) GetSync() []*SyncDeploymentVersionUserDataRequest_SyncUserData {
	if x != nil {
		return x.Sync
	}
	return nil
}

func (x *SyncDeploymentVersionUserDataRequest) GetForgetVersion() bool {
	if x != nil {
		return x.ForgetVersion
	}
	return false
}

func (x *SyncDeploymentVersionUserDataRequest) GetUpdateRoutingConfig() *v11.RoutingConfig {
	if x != nil {
		return x.UpdateRoutingConfig
	}
	return nil
}

func (x *SyncDeploymentVersionUserDataRequest) GetUpsertVersionData() *WorkerDeploymentVersionData {
	if x != nil {
		return x.UpsertVersionData
	}
	return nil
}

// used as Worker Deployment Version workflow activity output:
type SyncDeploymentVersionUserDataResponse struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	TaskQueueMaxVersions map[string]int64       `protobuf:"bytes,1,rep,name=task_queue_max_versions,json=taskQueueMaxVersions,proto3" json:"task_queue_max_versions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *SyncDeploymentVersionUserDataResponse) Reset() {
	*x = SyncDeploymentVersionUserDataResponse{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncDeploymentVersionUserDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncDeploymentVersionUserDataResponse) ProtoMessage() {}

func (x *SyncDeploymentVersionUserDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncDeploymentVersionUserDataResponse.ProtoReflect.Descriptor instead.
func (*SyncDeploymentVersionUserDataResponse) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{25}
}

func (x *SyncDeploymentVersionUserDataResponse) GetTaskQueueMaxVersions() map[string]int64 {
	if x != nil {
		return x.TaskQueueMaxVersions
	}
	return nil
}

// used as Worker Deployment Version workflow activity input:
type CheckWorkerDeploymentUserDataPropagationRequest struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	TaskQueueMaxVersions map[string]int64       `protobuf:"bytes,1,rep,name=task_queue_max_versions,json=taskQueueMaxVersions,proto3" json:"task_queue_max_versions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *CheckWorkerDeploymentUserDataPropagationRequest) Reset() {
	*x = CheckWorkerDeploymentUserDataPropagationRequest{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckWorkerDeploymentUserDataPropagationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckWorkerDeploymentUserDataPropagationRequest) ProtoMessage() {}

func (x *CheckWorkerDeploymentUserDataPropagationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckWorkerDeploymentUserDataPropagationRequest.ProtoReflect.Descriptor instead.
func (*CheckWorkerDeploymentUserDataPropagationRequest) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{26}
}

func (x *CheckWorkerDeploymentUserDataPropagationRequest) GetTaskQueueMaxVersions() map[string]int64 {
	if x != nil {
		return x.TaskQueueMaxVersions
	}
	return nil
}

// used as Worker Deployment workflow activity input:
type SyncUnversionedRampActivityArgs struct {
	state          protoimpl.MessageState      `protogen:"open.v1"`
	CurrentVersion string                      `protobuf:"bytes,1,opt,name=current_version,json=currentVersion,proto3" json:"current_version,omitempty"`
	UpdateArgs     *SyncVersionStateUpdateArgs `protobuf:"bytes,2,opt,name=update_args,json=updateArgs,proto3" json:"update_args,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *SyncUnversionedRampActivityArgs) Reset() {
	*x = SyncUnversionedRampActivityArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncUnversionedRampActivityArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncUnversionedRampActivityArgs) ProtoMessage() {}

func (x *SyncUnversionedRampActivityArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncUnversionedRampActivityArgs.ProtoReflect.Descriptor instead.
func (*SyncUnversionedRampActivityArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{27}
}

func (x *SyncUnversionedRampActivityArgs) GetCurrentVersion() string {
	if x != nil {
		return x.CurrentVersion
	}
	return ""
}

func (x *SyncUnversionedRampActivityArgs) GetUpdateArgs() *SyncVersionStateUpdateArgs {
	if x != nil {
		return x.UpdateArgs
	}
	return nil
}

// used as Worker Deployment workflow activity output:
type SyncUnversionedRampActivityResponse struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	TaskQueueMaxVersions map[string]int64       `protobuf:"bytes,1,rep,name=task_queue_max_versions,json=taskQueueMaxVersions,proto3" json:"task_queue_max_versions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *SyncUnversionedRampActivityResponse) Reset() {
	*x = SyncUnversionedRampActivityResponse{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncUnversionedRampActivityResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncUnversionedRampActivityResponse) ProtoMessage() {}

func (x *SyncUnversionedRampActivityResponse) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncUnversionedRampActivityResponse.ProtoReflect.Descriptor instead.
func (*SyncUnversionedRampActivityResponse) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{28}
}

func (x *SyncUnversionedRampActivityResponse) GetTaskQueueMaxVersions() map[string]int64 {
	if x != nil {
		return x.TaskQueueMaxVersions
	}
	return nil
}

// used as Worker Deployment Version workflow update input:
type UpdateVersionMetadataArgs struct {
	state         protoimpl.MessageState  `protogen:"open.v1"`
	UpsertEntries map[string]*v12.Payload `protobuf:"bytes,1,rep,name=upsert_entries,json=upsertEntries,proto3" json:"upsert_entries,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	RemoveEntries []string                `protobuf:"bytes,2,rep,name=remove_entries,json=removeEntries,proto3" json:"remove_entries,omitempty"`
	Identity      string                  `protobuf:"bytes,3,opt,name=identity,proto3" json:"identity,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateVersionMetadataArgs) Reset() {
	*x = UpdateVersionMetadataArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateVersionMetadataArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateVersionMetadataArgs) ProtoMessage() {}

func (x *UpdateVersionMetadataArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateVersionMetadataArgs.ProtoReflect.Descriptor instead.
func (*UpdateVersionMetadataArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{29}
}

func (x *UpdateVersionMetadataArgs) GetUpsertEntries() map[string]*v12.Payload {
	if x != nil {
		return x.UpsertEntries
	}
	return nil
}

func (x *UpdateVersionMetadataArgs) GetRemoveEntries() []string {
	if x != nil {
		return x.RemoveEntries
	}
	return nil
}

func (x *UpdateVersionMetadataArgs) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

// used as Worker Deployment Version workflow update response:
type UpdateVersionMetadataResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Metadata      *v11.VersionMetadata   `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateVersionMetadataResponse) Reset() {
	*x = UpdateVersionMetadataResponse{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateVersionMetadataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateVersionMetadataResponse) ProtoMessage() {}

func (x *UpdateVersionMetadataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateVersionMetadataResponse.ProtoReflect.Descriptor instead.
func (*UpdateVersionMetadataResponse) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{30}
}

func (x *UpdateVersionMetadataResponse) GetMetadata() *v11.VersionMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// used as Worker Deployment workflow update input:
type SetCurrentVersionArgs struct {
	state                   protoimpl.MessageState `protogen:"open.v1"`
	Identity                string                 `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
	Version                 string                 `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	IgnoreMissingTaskQueues bool                   `protobuf:"varint,3,opt,name=ignore_missing_task_queues,json=ignoreMissingTaskQueues,proto3" json:"ignore_missing_task_queues,omitempty"`
	ConflictToken           []byte                 `protobuf:"bytes,4,opt,name=conflict_token,json=conflictToken,proto3" json:"conflict_token,omitempty"`
	AllowNoPollers          bool                   `protobuf:"varint,5,opt,name=allow_no_pollers,json=allowNoPollers,proto3" json:"allow_no_pollers,omitempty"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *SetCurrentVersionArgs) Reset() {
	*x = SetCurrentVersionArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetCurrentVersionArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetCurrentVersionArgs) ProtoMessage() {}

func (x *SetCurrentVersionArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetCurrentVersionArgs.ProtoReflect.Descriptor instead.
func (*SetCurrentVersionArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{31}
}

func (x *SetCurrentVersionArgs) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

func (x *SetCurrentVersionArgs) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *SetCurrentVersionArgs) GetIgnoreMissingTaskQueues() bool {
	if x != nil {
		return x.IgnoreMissingTaskQueues
	}
	return false
}

func (x *SetCurrentVersionArgs) GetConflictToken() []byte {
	if x != nil {
		return x.ConflictToken
	}
	return nil
}

func (x *SetCurrentVersionArgs) GetAllowNoPollers() bool {
	if x != nil {
		return x.AllowNoPollers
	}
	return false
}

// used as Worker Deployment update response:
type SetCurrentVersionResponse struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	PreviousVersion string                 `protobuf:"bytes,1,opt,name=previous_version,json=previousVersion,proto3" json:"previous_version,omitempty"`
	ConflictToken   []byte                 `protobuf:"bytes,2,opt,name=conflict_token,json=conflictToken,proto3" json:"conflict_token,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *SetCurrentVersionResponse) Reset() {
	*x = SetCurrentVersionResponse{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetCurrentVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetCurrentVersionResponse) ProtoMessage() {}

func (x *SetCurrentVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetCurrentVersionResponse.ProtoReflect.Descriptor instead.
func (*SetCurrentVersionResponse) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{32}
}

func (x *SetCurrentVersionResponse) GetPreviousVersion() string {
	if x != nil {
		return x.PreviousVersion
	}
	return ""
}

func (x *SetCurrentVersionResponse) GetConflictToken() []byte {
	if x != nil {
		return x.ConflictToken
	}
	return nil
}

// used as Worker Deployment workflow update input:
type DeleteVersionArgs struct {
	state        protoimpl.MessageState `protogen:"open.v1"`
	Identity     string                 `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
	Version      string                 `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	SkipDrainage bool                   `protobuf:"varint,3,opt,name=skip_drainage,json=skipDrainage,proto3" json:"skip_drainage,omitempty"`
	// If true, it would mean that the delete operation is initiated by the server internally. This is done on the
	// event that the addition of a version exceeds the max number of versions allowed in a worker-deployment (defaultMaxVersions).
	// False elsewhere.
	ServerDelete bool `protobuf:"varint,4,opt,name=server_delete,json=serverDelete,proto3" json:"server_delete,omitempty"`
	// version workflow does not block the update for tq propagation
	AsyncPropagation bool `protobuf:"varint,5,opt,name=async_propagation,json=asyncPropagation,proto3" json:"async_propagation,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *DeleteVersionArgs) Reset() {
	*x = DeleteVersionArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteVersionArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteVersionArgs) ProtoMessage() {}

func (x *DeleteVersionArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteVersionArgs.ProtoReflect.Descriptor instead.
func (*DeleteVersionArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{33}
}

func (x *DeleteVersionArgs) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

func (x *DeleteVersionArgs) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *DeleteVersionArgs) GetSkipDrainage() bool {
	if x != nil {
		return x.SkipDrainage
	}
	return false
}

func (x *DeleteVersionArgs) GetServerDelete() bool {
	if x != nil {
		return x.ServerDelete
	}
	return false
}

func (x *DeleteVersionArgs) GetAsyncPropagation() bool {
	if x != nil {
		return x.AsyncPropagation
	}
	return false
}

// used as Worker Deployment Activity input:
type DeleteVersionActivityArgs struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	Identity         string                 `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
	DeploymentName   string                 `protobuf:"bytes,2,opt,name=deployment_name,json=deploymentName,proto3" json:"deployment_name,omitempty"`
	Version          string                 `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	RequestId        string                 `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	SkipDrainage     bool                   `protobuf:"varint,5,opt,name=skip_drainage,json=skipDrainage,proto3" json:"skip_drainage,omitempty"`
	AsyncPropagation bool                   `protobuf:"varint,6,opt,name=async_propagation,json=asyncPropagation,proto3" json:"async_propagation,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *DeleteVersionActivityArgs) Reset() {
	*x = DeleteVersionActivityArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteVersionActivityArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteVersionActivityArgs) ProtoMessage() {}

func (x *DeleteVersionActivityArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteVersionActivityArgs.ProtoReflect.Descriptor instead.
func (*DeleteVersionActivityArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{34}
}

func (x *DeleteVersionActivityArgs) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

func (x *DeleteVersionActivityArgs) GetDeploymentName() string {
	if x != nil {
		return x.DeploymentName
	}
	return ""
}

func (x *DeleteVersionActivityArgs) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *DeleteVersionActivityArgs) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteVersionActivityArgs) GetSkipDrainage() bool {
	if x != nil {
		return x.SkipDrainage
	}
	return false
}

func (x *DeleteVersionActivityArgs) GetAsyncPropagation() bool {
	if x != nil {
		return x.AsyncPropagation
	}
	return false
}

// used as Worker Deployment Activity input:
type CheckTaskQueuesHavePollersActivityArgs struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Key: Task Queue Name
	TaskQueuesAndTypes      map[string]*CheckTaskQueuesHavePollersActivityArgs_TaskQueueTypes `protobuf:"bytes,1,rep,name=task_queues_and_types,json=taskQueuesAndTypes,proto3" json:"task_queues_and_types,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	WorkerDeploymentVersion *WorkerDeploymentVersion                                          `protobuf:"bytes,2,opt,name=worker_deployment_version,json=workerDeploymentVersion,proto3" json:"worker_deployment_version,omitempty"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *CheckTaskQueuesHavePollersActivityArgs) Reset() {
	*x = CheckTaskQueuesHavePollersActivityArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckTaskQueuesHavePollersActivityArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckTaskQueuesHavePollersActivityArgs) ProtoMessage() {}

func (x *CheckTaskQueuesHavePollersActivityArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckTaskQueuesHavePollersActivityArgs.ProtoReflect.Descriptor instead.
func (*CheckTaskQueuesHavePollersActivityArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{35}
}

func (x *CheckTaskQueuesHavePollersActivityArgs) GetTaskQueuesAndTypes() map[string]*CheckTaskQueuesHavePollersActivityArgs_TaskQueueTypes {
	if x != nil {
		return x.TaskQueuesAndTypes
	}
	return nil
}

func (x *CheckTaskQueuesHavePollersActivityArgs) GetWorkerDeploymentVersion() *WorkerDeploymentVersion {
	if x != nil {
		return x.WorkerDeploymentVersion
	}
	return nil
}

// used as Worker Deployment workflow update input:
type DeleteDeploymentArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Identity      string                 `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteDeploymentArgs) Reset() {
	*x = DeleteDeploymentArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteDeploymentArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDeploymentArgs) ProtoMessage() {}

func (x *DeleteDeploymentArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDeploymentArgs.ProtoReflect.Descriptor instead.
func (*DeleteDeploymentArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{36}
}

func (x *DeleteDeploymentArgs) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

// used as Worker Deployment update response:
type SetRampingVersionResponse struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	PreviousVersion    string                 `protobuf:"bytes,1,opt,name=previous_version,json=previousVersion,proto3" json:"previous_version,omitempty"`
	PreviousPercentage float32                `protobuf:"fixed32,2,opt,name=previous_percentage,json=previousPercentage,proto3" json:"previous_percentage,omitempty"`
	ConflictToken      []byte                 `protobuf:"bytes,3,opt,name=conflict_token,json=conflictToken,proto3" json:"conflict_token,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *SetRampingVersionResponse) Reset() {
	*x = SetRampingVersionResponse{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetRampingVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetRampingVersionResponse) ProtoMessage() {}

func (x *SetRampingVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetRampingVersionResponse.ProtoReflect.Descriptor instead.
func (*SetRampingVersionResponse) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{37}
}

func (x *SetRampingVersionResponse) GetPreviousVersion() string {
	if x != nil {
		return x.PreviousVersion
	}
	return ""
}

func (x *SetRampingVersionResponse) GetPreviousPercentage() float32 {
	if x != nil {
		return x.PreviousPercentage
	}
	return 0
}

func (x *SetRampingVersionResponse) GetConflictToken() []byte {
	if x != nil {
		return x.ConflictToken
	}
	return nil
}

// used as Worker Deployment workflow update input:
type SetRampingVersionArgs struct {
	state                   protoimpl.MessageState `protogen:"open.v1"`
	Identity                string                 `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
	Version                 string                 `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	Percentage              float32                `protobuf:"fixed32,3,opt,name=percentage,proto3" json:"percentage,omitempty"`
	IgnoreMissingTaskQueues bool                   `protobuf:"varint,4,opt,name=ignore_missing_task_queues,json=ignoreMissingTaskQueues,proto3" json:"ignore_missing_task_queues,omitempty"`
	ConflictToken           []byte                 `protobuf:"bytes,5,opt,name=conflict_token,json=conflictToken,proto3" json:"conflict_token,omitempty"`
	AllowNoPollers          bool                   `protobuf:"varint,6,opt,name=allow_no_pollers,json=allowNoPollers,proto3" json:"allow_no_pollers,omitempty"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *SetRampingVersionArgs) Reset() {
	*x = SetRampingVersionArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetRampingVersionArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetRampingVersionArgs) ProtoMessage() {}

func (x *SetRampingVersionArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetRampingVersionArgs.ProtoReflect.Descriptor instead.
func (*SetRampingVersionArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{38}
}

func (x *SetRampingVersionArgs) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

func (x *SetRampingVersionArgs) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *SetRampingVersionArgs) GetPercentage() float32 {
	if x != nil {
		return x.Percentage
	}
	return 0
}

func (x *SetRampingVersionArgs) GetIgnoreMissingTaskQueues() bool {
	if x != nil {
		return x.IgnoreMissingTaskQueues
	}
	return false
}

func (x *SetRampingVersionArgs) GetConflictToken() []byte {
	if x != nil {
		return x.ConflictToken
	}
	return nil
}

func (x *SetRampingVersionArgs) GetAllowNoPollers() bool {
	if x != nil {
		return x.AllowNoPollers
	}
	return false
}

// used as Worker Deployment workflow update input:
type SetManagerIdentityArgs struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// identity is the client's identity, as usual
	Identity string `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
	// manager_identity is the new manager_identity.
	ManagerIdentity string `protobuf:"bytes,2,opt,name=manager_identity,json=managerIdentity,proto3" json:"manager_identity,omitempty"`
	ConflictToken   []byte `protobuf:"bytes,5,opt,name=conflict_token,json=conflictToken,proto3" json:"conflict_token,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *SetManagerIdentityArgs) Reset() {
	*x = SetManagerIdentityArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetManagerIdentityArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetManagerIdentityArgs) ProtoMessage() {}

func (x *SetManagerIdentityArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetManagerIdentityArgs.ProtoReflect.Descriptor instead.
func (*SetManagerIdentityArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{39}
}

func (x *SetManagerIdentityArgs) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

func (x *SetManagerIdentityArgs) GetManagerIdentity() string {
	if x != nil {
		return x.ManagerIdentity
	}
	return ""
}

func (x *SetManagerIdentityArgs) GetConflictToken() []byte {
	if x != nil {
		return x.ConflictToken
	}
	return nil
}

// used as Worker Deployment update response:
type SetManagerIdentityResponse struct {
	state                   protoimpl.MessageState `protogen:"open.v1"`
	PreviousManagerIdentity string                 `protobuf:"bytes,1,opt,name=previous_manager_identity,json=previousManagerIdentity,proto3" json:"previous_manager_identity,omitempty"`
	ConflictToken           []byte                 `protobuf:"bytes,2,opt,name=conflict_token,json=conflictToken,proto3" json:"conflict_token,omitempty"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *SetManagerIdentityResponse) Reset() {
	*x = SetManagerIdentityResponse{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetManagerIdentityResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetManagerIdentityResponse) ProtoMessage() {}

func (x *SetManagerIdentityResponse) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetManagerIdentityResponse.ProtoReflect.Descriptor instead.
func (*SetManagerIdentityResponse) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{40}
}

func (x *SetManagerIdentityResponse) GetPreviousManagerIdentity() string {
	if x != nil {
		return x.PreviousManagerIdentity
	}
	return ""
}

func (x *SetManagerIdentityResponse) GetConflictToken() []byte {
	if x != nil {
		return x.ConflictToken
	}
	return nil
}

// used as Worker Deployment activity input:
type SyncVersionStateActivityArgs struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	DeploymentName string                 `protobuf:"bytes,1,opt,name=deployment_name,json=deploymentName,proto3" json:"deployment_name,omitempty"`
	// <deployment_name>.<build_id> or possibly just <version_id> in the future
	Version       string                      `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	UpdateArgs    *SyncVersionStateUpdateArgs `protobuf:"bytes,3,opt,name=update_args,json=updateArgs,proto3" json:"update_args,omitempty"`
	RequestId     string                      `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyncVersionStateActivityArgs) Reset() {
	*x = SyncVersionStateActivityArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncVersionStateActivityArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncVersionStateActivityArgs) ProtoMessage() {}

func (x *SyncVersionStateActivityArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncVersionStateActivityArgs.ProtoReflect.Descriptor instead.
func (*SyncVersionStateActivityArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{41}
}

func (x *SyncVersionStateActivityArgs) GetDeploymentName() string {
	if x != nil {
		return x.DeploymentName
	}
	return ""
}

func (x *SyncVersionStateActivityArgs) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *SyncVersionStateActivityArgs) GetUpdateArgs() *SyncVersionStateUpdateArgs {
	if x != nil {
		return x.UpdateArgs
	}
	return nil
}

func (x *SyncVersionStateActivityArgs) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// used as Worker Deployment activity result:
type SyncVersionStateActivityResult struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Deprecated: Marked as deprecated in temporal/server/api/deployment/v1/message.proto.
	VersionState  *VersionLocalState              `protobuf:"bytes,1,opt,name=version_state,json=versionState,proto3" json:"version_state,omitempty"`
	Summary       *WorkerDeploymentVersionSummary `protobuf:"bytes,2,opt,name=summary,proto3" json:"summary,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyncVersionStateActivityResult) Reset() {
	*x = SyncVersionStateActivityResult{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncVersionStateActivityResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncVersionStateActivityResult) ProtoMessage() {}

func (x *SyncVersionStateActivityResult) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncVersionStateActivityResult.ProtoReflect.Descriptor instead.
func (*SyncVersionStateActivityResult) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{42}
}

// Deprecated: Marked as deprecated in temporal/server/api/deployment/v1/message.proto.
func (x *SyncVersionStateActivityResult) GetVersionState() *VersionLocalState {
	if x != nil {
		return x.VersionState
	}
	return nil
}

func (x *SyncVersionStateActivityResult) GetSummary() *WorkerDeploymentVersionSummary {
	if x != nil {
		return x.Summary
	}
	return nil
}

// used as Worker Deployment activity input:
type IsVersionMissingTaskQueuesArgs struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	PrevCurrentVersion string                 `protobuf:"bytes,1,opt,name=prev_current_version,json=prevCurrentVersion,proto3" json:"prev_current_version,omitempty"`
	NewCurrentVersion  string                 `protobuf:"bytes,2,opt,name=new_current_version,json=newCurrentVersion,proto3" json:"new_current_version,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *IsVersionMissingTaskQueuesArgs) Reset() {
	*x = IsVersionMissingTaskQueuesArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IsVersionMissingTaskQueuesArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IsVersionMissingTaskQueuesArgs) ProtoMessage() {}

func (x *IsVersionMissingTaskQueuesArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IsVersionMissingTaskQueuesArgs.ProtoReflect.Descriptor instead.
func (*IsVersionMissingTaskQueuesArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{43}
}

func (x *IsVersionMissingTaskQueuesArgs) GetPrevCurrentVersion() string {
	if x != nil {
		return x.PrevCurrentVersion
	}
	return ""
}

func (x *IsVersionMissingTaskQueuesArgs) GetNewCurrentVersion() string {
	if x != nil {
		return x.NewCurrentVersion
	}
	return ""
}

// used as Worker Deployment activity output:
type IsVersionMissingTaskQueuesResult struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	IsMissingTaskQueues bool                   `protobuf:"varint,1,opt,name=is_missing_task_queues,json=isMissingTaskQueues,proto3" json:"is_missing_task_queues,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *IsVersionMissingTaskQueuesResult) Reset() {
	*x = IsVersionMissingTaskQueuesResult{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IsVersionMissingTaskQueuesResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IsVersionMissingTaskQueuesResult) ProtoMessage() {}

func (x *IsVersionMissingTaskQueuesResult) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IsVersionMissingTaskQueuesResult.ProtoReflect.Descriptor instead.
func (*IsVersionMissingTaskQueuesResult) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{44}
}

func (x *IsVersionMissingTaskQueuesResult) GetIsMissingTaskQueues() bool {
	if x != nil {
		return x.IsMissingTaskQueues
	}
	return false
}

// used as Worker Deployment workflow memo:
type WorkerDeploymentWorkflowMemo struct {
	state                 protoimpl.MessageState                                   `protogen:"open.v1"`
	DeploymentName        string                                                   `protobuf:"bytes,1,opt,name=deployment_name,json=deploymentName,proto3" json:"deployment_name,omitempty"`
	CreateTime            *timestamppb.Timestamp                                   `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	RoutingConfig         *v11.RoutingConfig                                       `protobuf:"bytes,3,opt,name=routing_config,json=routingConfig,proto3" json:"routing_config,omitempty"`
	LatestVersionSummary  *v11.WorkerDeploymentInfo_WorkerDeploymentVersionSummary `protobuf:"bytes,4,opt,name=latest_version_summary,json=latestVersionSummary,proto3" json:"latest_version_summary,omitempty"`
	CurrentVersionSummary *v11.WorkerDeploymentInfo_WorkerDeploymentVersionSummary `protobuf:"bytes,5,opt,name=current_version_summary,json=currentVersionSummary,proto3" json:"current_version_summary,omitempty"`
	RampingVersionSummary *v11.WorkerDeploymentInfo_WorkerDeploymentVersionSummary `protobuf:"bytes,6,opt,name=ramping_version_summary,json=rampingVersionSummary,proto3" json:"ramping_version_summary,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *WorkerDeploymentWorkflowMemo) Reset() {
	*x = WorkerDeploymentWorkflowMemo{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkerDeploymentWorkflowMemo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerDeploymentWorkflowMemo) ProtoMessage() {}

func (x *WorkerDeploymentWorkflowMemo) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerDeploymentWorkflowMemo.ProtoReflect.Descriptor instead.
func (*WorkerDeploymentWorkflowMemo) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{45}
}

func (x *WorkerDeploymentWorkflowMemo) GetDeploymentName() string {
	if x != nil {
		return x.DeploymentName
	}
	return ""
}

func (x *WorkerDeploymentWorkflowMemo) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *WorkerDeploymentWorkflowMemo) GetRoutingConfig() *v11.RoutingConfig {
	if x != nil {
		return x.RoutingConfig
	}
	return nil
}

func (x *WorkerDeploymentWorkflowMemo) GetLatestVersionSummary() *v11.WorkerDeploymentInfo_WorkerDeploymentVersionSummary {
	if x != nil {
		return x.LatestVersionSummary
	}
	return nil
}

func (x *WorkerDeploymentWorkflowMemo) GetCurrentVersionSummary() *v11.WorkerDeploymentInfo_WorkerDeploymentVersionSummary {
	if x != nil {
		return x.CurrentVersionSummary
	}
	return nil
}

func (x *WorkerDeploymentWorkflowMemo) GetRampingVersionSummary() *v11.WorkerDeploymentInfo_WorkerDeploymentVersionSummary {
	if x != nil {
		return x.RampingVersionSummary
	}
	return nil
}

// Subset of fields of WorkerDeploymentInfo returned in ListWorkerDeploymentsResponse
type WorkerDeploymentSummary struct {
	state                 protoimpl.MessageState                                   `protogen:"open.v1"`
	Name                  string                                                   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	CreateTime            *timestamppb.Timestamp                                   `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	RoutingConfig         *v11.RoutingConfig                                       `protobuf:"bytes,3,opt,name=routing_config,json=routingConfig,proto3" json:"routing_config,omitempty"`
	LatestVersionSummary  *v11.WorkerDeploymentInfo_WorkerDeploymentVersionSummary `protobuf:"bytes,4,opt,name=latest_version_summary,json=latestVersionSummary,proto3" json:"latest_version_summary,omitempty"`
	CurrentVersionSummary *v11.WorkerDeploymentInfo_WorkerDeploymentVersionSummary `protobuf:"bytes,5,opt,name=current_version_summary,json=currentVersionSummary,proto3" json:"current_version_summary,omitempty"`
	RampingVersionSummary *v11.WorkerDeploymentInfo_WorkerDeploymentVersionSummary `protobuf:"bytes,6,opt,name=ramping_version_summary,json=rampingVersionSummary,proto3" json:"ramping_version_summary,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *WorkerDeploymentSummary) Reset() {
	*x = WorkerDeploymentSummary{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkerDeploymentSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerDeploymentSummary) ProtoMessage() {}

func (x *WorkerDeploymentSummary) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerDeploymentSummary.ProtoReflect.Descriptor instead.
func (*WorkerDeploymentSummary) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{46}
}

func (x *WorkerDeploymentSummary) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *WorkerDeploymentSummary) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *WorkerDeploymentSummary) GetRoutingConfig() *v11.RoutingConfig {
	if x != nil {
		return x.RoutingConfig
	}
	return nil
}

func (x *WorkerDeploymentSummary) GetLatestVersionSummary() *v11.WorkerDeploymentInfo_WorkerDeploymentVersionSummary {
	if x != nil {
		return x.LatestVersionSummary
	}
	return nil
}

func (x *WorkerDeploymentSummary) GetCurrentVersionSummary() *v11.WorkerDeploymentInfo_WorkerDeploymentVersionSummary {
	if x != nil {
		return x.CurrentVersionSummary
	}
	return nil
}

func (x *WorkerDeploymentSummary) GetRampingVersionSummary() *v11.WorkerDeploymentInfo_WorkerDeploymentVersionSummary {
	if x != nil {
		return x.RampingVersionSummary
	}
	return nil
}

// Used as Worker Deployment Version workflow activity input:
type AddVersionToWorkerDeploymentRequest struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	DeploymentName string                 `protobuf:"bytes,1,opt,name=deployment_name,json=deploymentName,proto3" json:"deployment_name,omitempty"`
	UpdateArgs     *AddVersionUpdateArgs  `protobuf:"bytes,2,opt,name=update_args,json=updateArgs,proto3" json:"update_args,omitempty"`
	RequestId      string                 `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *AddVersionToWorkerDeploymentRequest) Reset() {
	*x = AddVersionToWorkerDeploymentRequest{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddVersionToWorkerDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddVersionToWorkerDeploymentRequest) ProtoMessage() {}

func (x *AddVersionToWorkerDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddVersionToWorkerDeploymentRequest.ProtoReflect.Descriptor instead.
func (*AddVersionToWorkerDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{47}
}

func (x *AddVersionToWorkerDeploymentRequest) GetDeploymentName() string {
	if x != nil {
		return x.DeploymentName
	}
	return ""
}

func (x *AddVersionToWorkerDeploymentRequest) GetUpdateArgs() *AddVersionUpdateArgs {
	if x != nil {
		return x.UpdateArgs
	}
	return nil
}

func (x *AddVersionToWorkerDeploymentRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Used as Worker Deployment Version workflow activity output:
type AddVersionToWorkerDeploymentResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AddVersionToWorkerDeploymentResponse) Reset() {
	*x = AddVersionToWorkerDeploymentResponse{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddVersionToWorkerDeploymentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddVersionToWorkerDeploymentResponse) ProtoMessage() {}

func (x *AddVersionToWorkerDeploymentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddVersionToWorkerDeploymentResponse.ProtoReflect.Descriptor instead.
func (*AddVersionToWorkerDeploymentResponse) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{48}
}

// ////////////////////////////////////////////////////////////////////////
// Below this line are the messages for the pre-release Deployment APIs //
// ////////////////////////////////////////////////////////////////////////
// Data for each deployment+task queue pair. This is stored in each deployment (for each task
// queue), and synced to task queue user data (for each deployment).
type TaskQueueData struct {
	state                 protoimpl.MessageState `protogen:"open.v1"`
	FirstPollerTime       *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=first_poller_time,json=firstPollerTime,proto3" json:"first_poller_time,omitempty"`
	LastBecameCurrentTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=last_became_current_time,json=lastBecameCurrentTime,proto3" json:"last_became_current_time,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *TaskQueueData) Reset() {
	*x = TaskQueueData{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TaskQueueData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskQueueData) ProtoMessage() {}

func (x *TaskQueueData) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskQueueData.ProtoReflect.Descriptor instead.
func (*TaskQueueData) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{49}
}

func (x *TaskQueueData) GetFirstPollerTime() *timestamppb.Timestamp {
	if x != nil {
		return x.FirstPollerTime
	}
	return nil
}

func (x *TaskQueueData) GetLastBecameCurrentTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastBecameCurrentTime
	}
	return nil
}

type DeploymentLocalState struct {
	state                 protoimpl.MessageState                               `protogen:"open.v1"`
	Deployment            *v11.Deployment                                      `protobuf:"bytes,1,opt,name=deployment,proto3" json:"deployment,omitempty"`
	TaskQueueFamilies     map[string]*DeploymentLocalState_TaskQueueFamilyData `protobuf:"bytes,2,rep,name=task_queue_families,json=taskQueueFamilies,proto3" json:"task_queue_families,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	IsCurrent             bool                                                 `protobuf:"varint,3,opt,name=is_current,json=isCurrent,proto3" json:"is_current,omitempty"`
	LastBecameCurrentTime *timestamppb.Timestamp                               `protobuf:"bytes,6,opt,name=last_became_current_time,json=lastBecameCurrentTime,proto3" json:"last_became_current_time,omitempty"`
	CreateTime            *timestamppb.Timestamp                               `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	Metadata              map[string]*v12.Payload                              `protobuf:"bytes,5,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	StartedSeriesWorkflow bool                                                 `protobuf:"varint,7,opt,name=started_series_workflow,json=startedSeriesWorkflow,proto3" json:"started_series_workflow,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *DeploymentLocalState) Reset() {
	*x = DeploymentLocalState{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeploymentLocalState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeploymentLocalState) ProtoMessage() {}

func (x *DeploymentLocalState) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeploymentLocalState.ProtoReflect.Descriptor instead.
func (*DeploymentLocalState) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{50}
}

func (x *DeploymentLocalState) GetDeployment() *v11.Deployment {
	if x != nil {
		return x.Deployment
	}
	return nil
}

func (x *DeploymentLocalState) GetTaskQueueFamilies() map[string]*DeploymentLocalState_TaskQueueFamilyData {
	if x != nil {
		return x.TaskQueueFamilies
	}
	return nil
}

func (x *DeploymentLocalState) GetIsCurrent() bool {
	if x != nil {
		return x.IsCurrent
	}
	return false
}

func (x *DeploymentLocalState) GetLastBecameCurrentTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastBecameCurrentTime
	}
	return nil
}

func (x *DeploymentLocalState) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DeploymentLocalState) GetMetadata() map[string]*v12.Payload {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *DeploymentLocalState) GetStartedSeriesWorkflow() bool {
	if x != nil {
		return x.StartedSeriesWorkflow
	}
	return false
}

// used as deployment workflow input:
type DeploymentWorkflowArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	NamespaceName string                 `protobuf:"bytes,1,opt,name=namespace_name,json=namespaceName,proto3" json:"namespace_name,omitempty"`
	NamespaceId   string                 `protobuf:"bytes,2,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	State         *DeploymentLocalState  `protobuf:"bytes,3,opt,name=state,proto3" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeploymentWorkflowArgs) Reset() {
	*x = DeploymentWorkflowArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeploymentWorkflowArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeploymentWorkflowArgs) ProtoMessage() {}

func (x *DeploymentWorkflowArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeploymentWorkflowArgs.ProtoReflect.Descriptor instead.
func (*DeploymentWorkflowArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{51}
}

func (x *DeploymentWorkflowArgs) GetNamespaceName() string {
	if x != nil {
		return x.NamespaceName
	}
	return ""
}

func (x *DeploymentWorkflowArgs) GetNamespaceId() string {
	if x != nil {
		return x.NamespaceId
	}
	return ""
}

func (x *DeploymentWorkflowArgs) GetState() *DeploymentLocalState {
	if x != nil {
		return x.State
	}
	return nil
}

// used as deployment series workflow input:
type DeploymentSeriesWorkflowArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	NamespaceName string                 `protobuf:"bytes,1,opt,name=namespace_name,json=namespaceName,proto3" json:"namespace_name,omitempty"`
	NamespaceId   string                 `protobuf:"bytes,2,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	SeriesName    string                 `protobuf:"bytes,3,opt,name=series_name,json=seriesName,proto3" json:"series_name,omitempty"`
	State         *SeriesLocalState      `protobuf:"bytes,4,opt,name=state,proto3" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeploymentSeriesWorkflowArgs) Reset() {
	*x = DeploymentSeriesWorkflowArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeploymentSeriesWorkflowArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeploymentSeriesWorkflowArgs) ProtoMessage() {}

func (x *DeploymentSeriesWorkflowArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeploymentSeriesWorkflowArgs.ProtoReflect.Descriptor instead.
func (*DeploymentSeriesWorkflowArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{52}
}

func (x *DeploymentSeriesWorkflowArgs) GetNamespaceName() string {
	if x != nil {
		return x.NamespaceName
	}
	return ""
}

func (x *DeploymentSeriesWorkflowArgs) GetNamespaceId() string {
	if x != nil {
		return x.NamespaceId
	}
	return ""
}

func (x *DeploymentSeriesWorkflowArgs) GetSeriesName() string {
	if x != nil {
		return x.SeriesName
	}
	return ""
}

func (x *DeploymentSeriesWorkflowArgs) GetState() *SeriesLocalState {
	if x != nil {
		return x.State
	}
	return nil
}

type SeriesLocalState struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	CurrentBuildId     string                 `protobuf:"bytes,1,opt,name=current_build_id,json=currentBuildId,proto3" json:"current_build_id,omitempty"`
	CurrentChangedTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=current_changed_time,json=currentChangedTime,proto3" json:"current_changed_time,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *SeriesLocalState) Reset() {
	*x = SeriesLocalState{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SeriesLocalState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SeriesLocalState) ProtoMessage() {}

func (x *SeriesLocalState) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SeriesLocalState.ProtoReflect.Descriptor instead.
func (*SeriesLocalState) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{53}
}

func (x *SeriesLocalState) GetCurrentBuildId() string {
	if x != nil {
		return x.CurrentBuildId
	}
	return ""
}

func (x *SeriesLocalState) GetCurrentChangedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CurrentChangedTime
	}
	return nil
}

// used as deployment workflow update input:
type RegisterWorkerInDeploymentArgs struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	TaskQueueName   string                 `protobuf:"bytes,1,opt,name=task_queue_name,json=taskQueueName,proto3" json:"task_queue_name,omitempty"`
	TaskQueueType   v1.TaskQueueType       `protobuf:"varint,2,opt,name=task_queue_type,json=taskQueueType,proto3,enum=temporal.api.enums.v1.TaskQueueType" json:"task_queue_type,omitempty"`
	FirstPollerTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=first_poller_time,json=firstPollerTime,proto3" json:"first_poller_time,omitempty"`
	MaxTaskQueues   int32                  `protobuf:"varint,4,opt,name=max_task_queues,json=maxTaskQueues,proto3" json:"max_task_queues,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *RegisterWorkerInDeploymentArgs) Reset() {
	*x = RegisterWorkerInDeploymentArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RegisterWorkerInDeploymentArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterWorkerInDeploymentArgs) ProtoMessage() {}

func (x *RegisterWorkerInDeploymentArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterWorkerInDeploymentArgs.ProtoReflect.Descriptor instead.
func (*RegisterWorkerInDeploymentArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{54}
}

func (x *RegisterWorkerInDeploymentArgs) GetTaskQueueName() string {
	if x != nil {
		return x.TaskQueueName
	}
	return ""
}

func (x *RegisterWorkerInDeploymentArgs) GetTaskQueueType() v1.TaskQueueType {
	if x != nil {
		return x.TaskQueueType
	}
	return v1.TaskQueueType(0)
}

func (x *RegisterWorkerInDeploymentArgs) GetFirstPollerTime() *timestamppb.Timestamp {
	if x != nil {
		return x.FirstPollerTime
	}
	return nil
}

func (x *RegisterWorkerInDeploymentArgs) GetMaxTaskQueues() int32 {
	if x != nil {
		return x.MaxTaskQueues
	}
	return 0
}

// used as deployment series workflow update input (sent from series workflow):
type SyncDeploymentStateArgs struct {
	state      protoimpl.MessageState              `protogen:"open.v1"`
	SetCurrent *SyncDeploymentStateArgs_SetCurrent `protobuf:"bytes,1,opt,name=set_current,json=setCurrent,proto3" json:"set_current,omitempty"`
	// currently, update_metadata will only be set if set_current.last_became_current_time is
	// present. this could change in the future.
	UpdateMetadata *v11.UpdateDeploymentMetadata `protobuf:"bytes,2,opt,name=update_metadata,json=updateMetadata,proto3" json:"update_metadata,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *SyncDeploymentStateArgs) Reset() {
	*x = SyncDeploymentStateArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncDeploymentStateArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncDeploymentStateArgs) ProtoMessage() {}

func (x *SyncDeploymentStateArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncDeploymentStateArgs.ProtoReflect.Descriptor instead.
func (*SyncDeploymentStateArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{55}
}

func (x *SyncDeploymentStateArgs) GetSetCurrent() *SyncDeploymentStateArgs_SetCurrent {
	if x != nil {
		return x.SetCurrent
	}
	return nil
}

func (x *SyncDeploymentStateArgs) GetUpdateMetadata() *v11.UpdateDeploymentMetadata {
	if x != nil {
		return x.UpdateMetadata
	}
	return nil
}

// used as deployment series workflow update response (sent from series workflow):
type SyncDeploymentStateResponse struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	DeploymentLocalState *DeploymentLocalState  `protobuf:"bytes,1,opt,name=deployment_local_state,json=deploymentLocalState,proto3" json:"deployment_local_state,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *SyncDeploymentStateResponse) Reset() {
	*x = SyncDeploymentStateResponse{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncDeploymentStateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncDeploymentStateResponse) ProtoMessage() {}

func (x *SyncDeploymentStateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncDeploymentStateResponse.ProtoReflect.Descriptor instead.
func (*SyncDeploymentStateResponse) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{56}
}

func (x *SyncDeploymentStateResponse) GetDeploymentLocalState() *DeploymentLocalState {
	if x != nil {
		return x.DeploymentLocalState
	}
	return nil
}

// used as deployment workflow query response:
type QueryDescribeDeploymentResponse struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	DeploymentLocalState *DeploymentLocalState  `protobuf:"bytes,1,opt,name=deployment_local_state,json=deploymentLocalState,proto3" json:"deployment_local_state,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *QueryDescribeDeploymentResponse) Reset() {
	*x = QueryDescribeDeploymentResponse{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryDescribeDeploymentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryDescribeDeploymentResponse) ProtoMessage() {}

func (x *QueryDescribeDeploymentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryDescribeDeploymentResponse.ProtoReflect.Descriptor instead.
func (*QueryDescribeDeploymentResponse) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{57}
}

func (x *QueryDescribeDeploymentResponse) GetDeploymentLocalState() *DeploymentLocalState {
	if x != nil {
		return x.DeploymentLocalState
	}
	return nil
}

// used as deployment workflow memo:
type DeploymentWorkflowMemo struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	Deployment          *v11.Deployment        `protobuf:"bytes,1,opt,name=deployment,proto3" json:"deployment,omitempty"`
	CreateTime          *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	IsCurrentDeployment bool                   `protobuf:"varint,3,opt,name=is_current_deployment,json=isCurrentDeployment,proto3" json:"is_current_deployment,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *DeploymentWorkflowMemo) Reset() {
	*x = DeploymentWorkflowMemo{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeploymentWorkflowMemo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeploymentWorkflowMemo) ProtoMessage() {}

func (x *DeploymentWorkflowMemo) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeploymentWorkflowMemo.ProtoReflect.Descriptor instead.
func (*DeploymentWorkflowMemo) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{58}
}

func (x *DeploymentWorkflowMemo) GetDeployment() *v11.Deployment {
	if x != nil {
		return x.Deployment
	}
	return nil
}

func (x *DeploymentWorkflowMemo) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DeploymentWorkflowMemo) GetIsCurrentDeployment() bool {
	if x != nil {
		return x.IsCurrentDeployment
	}
	return false
}

// used as deployment workflow activity input:
type StartDeploymentSeriesRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	SeriesName    string                 `protobuf:"bytes,1,opt,name=series_name,json=seriesName,proto3" json:"series_name,omitempty"`
	RequestId     string                 `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StartDeploymentSeriesRequest) Reset() {
	*x = StartDeploymentSeriesRequest{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartDeploymentSeriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartDeploymentSeriesRequest) ProtoMessage() {}

func (x *StartDeploymentSeriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartDeploymentSeriesRequest.ProtoReflect.Descriptor instead.
func (*StartDeploymentSeriesRequest) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{59}
}

func (x *StartDeploymentSeriesRequest) GetSeriesName() string {
	if x != nil {
		return x.SeriesName
	}
	return ""
}

func (x *StartDeploymentSeriesRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// used as deployment workflow activity input:
type SyncUserDataRequest struct {
	state         protoimpl.MessageState              `protogen:"open.v1"`
	Deployment    *v11.Deployment                     `protobuf:"bytes,1,opt,name=deployment,proto3" json:"deployment,omitempty"`
	Sync          []*SyncUserDataRequest_SyncUserData `protobuf:"bytes,2,rep,name=sync,proto3" json:"sync,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyncUserDataRequest) Reset() {
	*x = SyncUserDataRequest{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncUserDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncUserDataRequest) ProtoMessage() {}

func (x *SyncUserDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncUserDataRequest.ProtoReflect.Descriptor instead.
func (*SyncUserDataRequest) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{60}
}

func (x *SyncUserDataRequest) GetDeployment() *v11.Deployment {
	if x != nil {
		return x.Deployment
	}
	return nil
}

func (x *SyncUserDataRequest) GetSync() []*SyncUserDataRequest_SyncUserData {
	if x != nil {
		return x.Sync
	}
	return nil
}

// used as deployment workflow activity output:
type SyncUserDataResponse struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	TaskQueueMaxVersions map[string]int64       `protobuf:"bytes,1,rep,name=task_queue_max_versions,json=taskQueueMaxVersions,proto3" json:"task_queue_max_versions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *SyncUserDataResponse) Reset() {
	*x = SyncUserDataResponse{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncUserDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncUserDataResponse) ProtoMessage() {}

func (x *SyncUserDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncUserDataResponse.ProtoReflect.Descriptor instead.
func (*SyncUserDataResponse) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{61}
}

func (x *SyncUserDataResponse) GetTaskQueueMaxVersions() map[string]int64 {
	if x != nil {
		return x.TaskQueueMaxVersions
	}
	return nil
}

// used as deployment workflow activity input:
type CheckUserDataPropagationRequest struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	TaskQueueMaxVersions map[string]int64       `protobuf:"bytes,1,rep,name=task_queue_max_versions,json=taskQueueMaxVersions,proto3" json:"task_queue_max_versions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *CheckUserDataPropagationRequest) Reset() {
	*x = CheckUserDataPropagationRequest{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckUserDataPropagationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckUserDataPropagationRequest) ProtoMessage() {}

func (x *CheckUserDataPropagationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckUserDataPropagationRequest.ProtoReflect.Descriptor instead.
func (*CheckUserDataPropagationRequest) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{62}
}

func (x *CheckUserDataPropagationRequest) GetTaskQueueMaxVersions() map[string]int64 {
	if x != nil {
		return x.TaskQueueMaxVersions
	}
	return nil
}

// used as deployment series workflow update input:
type SetCurrentDeploymentArgs struct {
	state          protoimpl.MessageState        `protogen:"open.v1"`
	Identity       string                        `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
	BuildId        string                        `protobuf:"bytes,2,opt,name=build_id,json=buildId,proto3" json:"build_id,omitempty"`
	UpdateMetadata *v11.UpdateDeploymentMetadata `protobuf:"bytes,3,opt,name=update_metadata,json=updateMetadata,proto3" json:"update_metadata,omitempty"`
	RequestId      string                        `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *SetCurrentDeploymentArgs) Reset() {
	*x = SetCurrentDeploymentArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetCurrentDeploymentArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetCurrentDeploymentArgs) ProtoMessage() {}

func (x *SetCurrentDeploymentArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetCurrentDeploymentArgs.ProtoReflect.Descriptor instead.
func (*SetCurrentDeploymentArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{63}
}

func (x *SetCurrentDeploymentArgs) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

func (x *SetCurrentDeploymentArgs) GetBuildId() string {
	if x != nil {
		return x.BuildId
	}
	return ""
}

func (x *SetCurrentDeploymentArgs) GetUpdateMetadata() *v11.UpdateDeploymentMetadata {
	if x != nil {
		return x.UpdateMetadata
	}
	return nil
}

func (x *SetCurrentDeploymentArgs) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// used as deployment series update response:
type SetCurrentDeploymentResponse struct {
	state                   protoimpl.MessageState `protogen:"open.v1"`
	CurrentDeploymentState  *DeploymentLocalState  `protobuf:"bytes,1,opt,name=current_deployment_state,json=currentDeploymentState,proto3" json:"current_deployment_state,omitempty"`
	PreviousDeploymentState *DeploymentLocalState  `protobuf:"bytes,2,opt,name=previous_deployment_state,json=previousDeploymentState,proto3" json:"previous_deployment_state,omitempty"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *SetCurrentDeploymentResponse) Reset() {
	*x = SetCurrentDeploymentResponse{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetCurrentDeploymentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetCurrentDeploymentResponse) ProtoMessage() {}

func (x *SetCurrentDeploymentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetCurrentDeploymentResponse.ProtoReflect.Descriptor instead.
func (*SetCurrentDeploymentResponse) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{64}
}

func (x *SetCurrentDeploymentResponse) GetCurrentDeploymentState() *DeploymentLocalState {
	if x != nil {
		return x.CurrentDeploymentState
	}
	return nil
}

func (x *SetCurrentDeploymentResponse) GetPreviousDeploymentState() *DeploymentLocalState {
	if x != nil {
		return x.PreviousDeploymentState
	}
	return nil
}

// used as deployment series activity input:
type SyncDeploymentStateActivityArgs struct {
	state         protoimpl.MessageState   `protogen:"open.v1"`
	Deployment    *v11.Deployment          `protobuf:"bytes,1,opt,name=deployment,proto3" json:"deployment,omitempty"`
	Args          *SyncDeploymentStateArgs `protobuf:"bytes,2,opt,name=args,proto3" json:"args,omitempty"`
	RequestId     string                   `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyncDeploymentStateActivityArgs) Reset() {
	*x = SyncDeploymentStateActivityArgs{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncDeploymentStateActivityArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncDeploymentStateActivityArgs) ProtoMessage() {}

func (x *SyncDeploymentStateActivityArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncDeploymentStateActivityArgs.ProtoReflect.Descriptor instead.
func (*SyncDeploymentStateActivityArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{65}
}

func (x *SyncDeploymentStateActivityArgs) GetDeployment() *v11.Deployment {
	if x != nil {
		return x.Deployment
	}
	return nil
}

func (x *SyncDeploymentStateActivityArgs) GetArgs() *SyncDeploymentStateArgs {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *SyncDeploymentStateActivityArgs) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// used as deployment series activity result:
type SyncDeploymentStateActivityResult struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	State         *DeploymentLocalState  `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyncDeploymentStateActivityResult) Reset() {
	*x = SyncDeploymentStateActivityResult{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncDeploymentStateActivityResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncDeploymentStateActivityResult) ProtoMessage() {}

func (x *SyncDeploymentStateActivityResult) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncDeploymentStateActivityResult.ProtoReflect.Descriptor instead.
func (*SyncDeploymentStateActivityResult) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{66}
}

func (x *SyncDeploymentStateActivityResult) GetState() *DeploymentLocalState {
	if x != nil {
		return x.State
	}
	return nil
}

// used as deployment series workflow memo:
type DeploymentSeriesWorkflowMemo struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	SeriesName         string                 `protobuf:"bytes,1,opt,name=series_name,json=seriesName,proto3" json:"series_name,omitempty"`
	CurrentBuildId     string                 `protobuf:"bytes,2,opt,name=current_build_id,json=currentBuildId,proto3" json:"current_build_id,omitempty"`
	CurrentChangedTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=current_changed_time,json=currentChangedTime,proto3" json:"current_changed_time,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *DeploymentSeriesWorkflowMemo) Reset() {
	*x = DeploymentSeriesWorkflowMemo{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeploymentSeriesWorkflowMemo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeploymentSeriesWorkflowMemo) ProtoMessage() {}

func (x *DeploymentSeriesWorkflowMemo) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeploymentSeriesWorkflowMemo.ProtoReflect.Descriptor instead.
func (*DeploymentSeriesWorkflowMemo) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{67}
}

func (x *DeploymentSeriesWorkflowMemo) GetSeriesName() string {
	if x != nil {
		return x.SeriesName
	}
	return ""
}

func (x *DeploymentSeriesWorkflowMemo) GetCurrentBuildId() string {
	if x != nil {
		return x.CurrentBuildId
	}
	return ""
}

func (x *DeploymentSeriesWorkflowMemo) GetCurrentChangedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CurrentChangedTime
	}
	return nil
}

type VersionLocalState_TaskQueueFamilyData struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Key: Task Queue Type
	TaskQueues    map[int32]*TaskQueueVersionData `protobuf:"bytes,1,rep,name=task_queues,json=taskQueues,proto3" json:"task_queues,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VersionLocalState_TaskQueueFamilyData) Reset() {
	*x = VersionLocalState_TaskQueueFamilyData{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[69]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VersionLocalState_TaskQueueFamilyData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionLocalState_TaskQueueFamilyData) ProtoMessage() {}

func (x *VersionLocalState_TaskQueueFamilyData) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[69]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionLocalState_TaskQueueFamilyData.ProtoReflect.Descriptor instead.
func (*VersionLocalState_TaskQueueFamilyData) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{3, 1}
}

func (x *VersionLocalState_TaskQueueFamilyData) GetTaskQueues() map[int32]*TaskQueueVersionData {
	if x != nil {
		return x.TaskQueues
	}
	return nil
}

type SyncDeploymentVersionUserDataRequest_SyncUserData struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Types         []v1.TaskQueueType     `protobuf:"varint,2,rep,packed,name=types,proto3,enum=temporal.api.enums.v1.TaskQueueType" json:"types,omitempty"`
	Data          *DeploymentVersionData `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyncDeploymentVersionUserDataRequest_SyncUserData) Reset() {
	*x = SyncDeploymentVersionUserDataRequest_SyncUserData{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[73]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncDeploymentVersionUserDataRequest_SyncUserData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncDeploymentVersionUserDataRequest_SyncUserData) ProtoMessage() {}

func (x *SyncDeploymentVersionUserDataRequest_SyncUserData) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[73]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncDeploymentVersionUserDataRequest_SyncUserData.ProtoReflect.Descriptor instead.
func (*SyncDeploymentVersionUserDataRequest_SyncUserData) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{24, 0}
}

func (x *SyncDeploymentVersionUserDataRequest_SyncUserData) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SyncDeploymentVersionUserDataRequest_SyncUserData) GetTypes() []v1.TaskQueueType {
	if x != nil {
		return x.Types
	}
	return nil
}

func (x *SyncDeploymentVersionUserDataRequest_SyncUserData) GetData() *DeploymentVersionData {
	if x != nil {
		return x.Data
	}
	return nil
}

type CheckTaskQueuesHavePollersActivityArgs_TaskQueueTypes struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Types         []v1.TaskQueueType     `protobuf:"varint,1,rep,packed,name=types,proto3,enum=temporal.api.enums.v1.TaskQueueType" json:"types,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CheckTaskQueuesHavePollersActivityArgs_TaskQueueTypes) Reset() {
	*x = CheckTaskQueuesHavePollersActivityArgs_TaskQueueTypes{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[79]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckTaskQueuesHavePollersActivityArgs_TaskQueueTypes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckTaskQueuesHavePollersActivityArgs_TaskQueueTypes) ProtoMessage() {}

func (x *CheckTaskQueuesHavePollersActivityArgs_TaskQueueTypes) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[79]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckTaskQueuesHavePollersActivityArgs_TaskQueueTypes.ProtoReflect.Descriptor instead.
func (*CheckTaskQueuesHavePollersActivityArgs_TaskQueueTypes) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{35, 1}
}

func (x *CheckTaskQueuesHavePollersActivityArgs_TaskQueueTypes) GetTypes() []v1.TaskQueueType {
	if x != nil {
		return x.Types
	}
	return nil
}

type DeploymentLocalState_TaskQueueFamilyData struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Key: enums.TaskQueueType, Value: TaskQueueData
	// All fields in TaskQueueData are valid except last_became_current_time, the source of
	// truth for that is the value at the root of DeploymentLocalState.
	TaskQueues    map[int32]*TaskQueueData `protobuf:"bytes,1,rep,name=task_queues,json=taskQueues,proto3" json:"task_queues,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeploymentLocalState_TaskQueueFamilyData) Reset() {
	*x = DeploymentLocalState_TaskQueueFamilyData{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[82]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeploymentLocalState_TaskQueueFamilyData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeploymentLocalState_TaskQueueFamilyData) ProtoMessage() {}

func (x *DeploymentLocalState_TaskQueueFamilyData) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[82]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeploymentLocalState_TaskQueueFamilyData.ProtoReflect.Descriptor instead.
func (*DeploymentLocalState_TaskQueueFamilyData) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{50, 2}
}

func (x *DeploymentLocalState_TaskQueueFamilyData) GetTaskQueues() map[int32]*TaskQueueData {
	if x != nil {
		return x.TaskQueues
	}
	return nil
}

type SyncDeploymentStateArgs_SetCurrent struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// If last_became_current_time is present, then set the deployment's
	// last_became_current_time to it and set is_current true. If it's missing,
	// set is_current false.
	LastBecameCurrentTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=last_became_current_time,json=lastBecameCurrentTime,proto3" json:"last_became_current_time,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *SyncDeploymentStateArgs_SetCurrent) Reset() {
	*x = SyncDeploymentStateArgs_SetCurrent{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[84]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncDeploymentStateArgs_SetCurrent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncDeploymentStateArgs_SetCurrent) ProtoMessage() {}

func (x *SyncDeploymentStateArgs_SetCurrent) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[84]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncDeploymentStateArgs_SetCurrent.ProtoReflect.Descriptor instead.
func (*SyncDeploymentStateArgs_SetCurrent) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{55, 0}
}

func (x *SyncDeploymentStateArgs_SetCurrent) GetLastBecameCurrentTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastBecameCurrentTime
	}
	return nil
}

type SyncUserDataRequest_SyncUserData struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Type          v1.TaskQueueType       `protobuf:"varint,2,opt,name=type,proto3,enum=temporal.api.enums.v1.TaskQueueType" json:"type,omitempty"`
	Data          *TaskQueueData         `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyncUserDataRequest_SyncUserData) Reset() {
	*x = SyncUserDataRequest_SyncUserData{}
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[85]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncUserDataRequest_SyncUserData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncUserDataRequest_SyncUserData) ProtoMessage() {}

func (x *SyncUserDataRequest_SyncUserData) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_deployment_v1_message_proto_msgTypes[85]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncUserDataRequest_SyncUserData.ProtoReflect.Descriptor instead.
func (*SyncUserDataRequest_SyncUserData) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP(), []int{60, 0}
}

func (x *SyncUserDataRequest_SyncUserData) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SyncUserDataRequest_SyncUserData) GetType() v1.TaskQueueType {
	if x != nil {
		return x.Type
	}
	return v1.TaskQueueType(0)
}

func (x *SyncUserDataRequest_SyncUserData) GetData() *TaskQueueData {
	if x != nil {
		return x.Data
	}
	return nil
}

var File_temporal_server_api_deployment_v1_message_proto protoreflect.FileDescriptor

const file_temporal_server_api_deployment_v1_message_proto_rawDesc = "" +
	"\n" +
	"/temporal/server/api/deployment/v1/message.proto\x12!temporal.server.api.deployment.v1\x1a&temporal/api/enums/v1/task_queue.proto\x1a&temporal/api/enums/v1/deployment.proto\x1a\x1fgoogle/protobuf/timestamp.proto\x1a(temporal/api/deployment/v1/message.proto\x1a$temporal/api/common/v1/message.proto\"]\n" +
	"\x17WorkerDeploymentVersion\x12'\n" +
	"\x0fdeployment_name\x18\x01 \x01(\tR\x0edeploymentName\x12\x19\n" +
	"\bbuild_id\x18\x02 \x01(\tR\abuildId\"\xc4\x03\n" +
	"\x15DeploymentVersionData\x12T\n" +
	"\aversion\x18\x01 \x01(\v2:.temporal.server.api.deployment.v1.WorkerDeploymentVersionR\aversion\x12J\n" +
	"\x13routing_update_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\x11routingUpdateTime\x12H\n" +
	"\x12current_since_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\x10currentSinceTime\x12H\n" +
	"\x12ramping_since_time\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampR\x10rampingSinceTime\x12'\n" +
	"\x0framp_percentage\x18\x05 \x01(\x02R\x0erampPercentage\x12L\n" +
	"\x06status\x18\x06 \x01(\x0e24.temporal.api.enums.v1.WorkerDeploymentVersionStatusR\x06status\"k\n" +
	"\x1bWorkerDeploymentVersionData\x12L\n" +
	"\x06status\x18\x06 \x01(\x0e24.temporal.api.enums.v1.WorkerDeploymentVersionStatusR\x06status\"\xbf\v\n" +
	"\x11VersionLocalState\x12T\n" +
	"\aversion\x18\x01 \x01(\v2:.temporal.server.api.deployment.v1.WorkerDeploymentVersionR\aversion\x12;\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\x12J\n" +
	"\x13routing_update_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\x11routingUpdateTime\x12H\n" +
	"\x12current_since_time\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampR\x10currentSinceTime\x12H\n" +
	"\x12ramping_since_time\x18\x05 \x01(\v2\x1a.google.protobuf.TimestampR\x10rampingSinceTime\x12'\n" +
	"\x0framp_percentage\x18\x06 \x01(\x02R\x0erampPercentage\x12N\n" +
	"\x15first_activation_time\x18\f \x01(\v2\x1a.google.protobuf.TimestampR\x13firstActivationTime\x12P\n" +
	"\x16last_deactivation_time\x18\r \x01(\v2\x1a.google.protobuf.TimestampR\x14lastDeactivationTime\x12T\n" +
	"\rdrainage_info\x18\a \x01(\v2/.temporal.api.deployment.v1.VersionDrainageInfoR\fdrainageInfo\x12G\n" +
	"\bmetadata\x18\b \x01(\v2+.temporal.api.deployment.v1.VersionMetadataR\bmetadata\x12>\n" +
	"\x1bstarted_deployment_workflow\x18\t \x01(\bR\x19startedDeploymentWorkflow\x12{\n" +
	"\x13task_queue_families\x18\n" +
	" \x03(\v2K.temporal.server.api.deployment.v1.VersionLocalState.TaskQueueFamiliesEntryR\x11taskQueueFamilies\x12&\n" +
	"\x0fsync_batch_size\x18\v \x01(\x05R\rsyncBatchSize\x12L\n" +
	"\x06status\x18\x0e \x01(\x0e24.temporal.api.enums.v1.WorkerDeploymentVersionStatusR\x06status\x1a\x8e\x01\n" +
	"\x16TaskQueueFamiliesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12^\n" +
	"\x05value\x18\x02 \x01(\v2H.temporal.server.api.deployment.v1.VersionLocalState.TaskQueueFamilyDataR\x05value:\x028\x01\x1a\x88\x02\n" +
	"\x13TaskQueueFamilyData\x12y\n" +
	"\vtask_queues\x18\x01 \x03(\v2X.temporal.server.api.deployment.v1.VersionLocalState.TaskQueueFamilyData.TaskQueuesEntryR\n" +
	"taskQueues\x1av\n" +
	"\x0fTaskQueuesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\x05R\x03key\x12M\n" +
	"\x05value\x18\x02 \x01(\v27.temporal.server.api.deployment.v1.TaskQueueVersionDataR\x05value:\x028\x01\"\x16\n" +
	"\x14TaskQueueVersionData\"\xca\x01\n" +
	"#WorkerDeploymentVersionWorkflowArgs\x12%\n" +
	"\x0enamespace_name\x18\x01 \x01(\tR\rnamespaceName\x12!\n" +
	"\fnamespace_id\x18\x02 \x01(\tR\vnamespaceId\x12Y\n" +
	"\rversion_state\x18\x03 \x01(\v24.temporal.server.api.deployment.v1.VersionLocalStateR\fversionState\"\xe6\x01\n" +
	"\x1cWorkerDeploymentWorkflowArgs\x12%\n" +
	"\x0enamespace_name\x18\x01 \x01(\tR\rnamespaceName\x12!\n" +
	"\fnamespace_id\x18\x02 \x01(\tR\vnamespaceId\x12'\n" +
	"\x0fdeployment_name\x18\x03 \x01(\tR\x0edeploymentName\x12S\n" +
	"\x05state\x18\x04 \x01(\v2=.temporal.server.api.deployment.v1.WorkerDeploymentLocalStateR\x05state\"\xd6\x06\n" +
	"\x1aWorkerDeploymentLocalState\x12;\n" +
	"\vcreate_time\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\x12P\n" +
	"\x0erouting_config\x18\x02 \x01(\v2).temporal.api.deployment.v1.RoutingConfigR\rroutingConfig\x12g\n" +
	"\bversions\x18\x03 \x03(\v2K.temporal.server.api.deployment.v1.WorkerDeploymentLocalState.VersionsEntryR\bversions\x12%\n" +
	"\x0econflict_token\x18\x04 \x01(\fR\rconflictToken\x124\n" +
	"\x16last_modifier_identity\x18\x05 \x01(\tR\x14lastModifierIdentity\x12&\n" +
	"\x0fsync_batch_size\x18\x06 \x01(\x05R\rsyncBatchSize\x12)\n" +
	"\x10manager_identity\x18\a \x01(\tR\x0fmanagerIdentity\x12\x8c\x01\n" +
	"\x15propagating_revisions\x18\b \x03(\v2W.temporal.server.api.deployment.v1.WorkerDeploymentLocalState.PropagatingRevisionsEntryR\x14propagatingRevisions\x1a~\n" +
	"\rVersionsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12W\n" +
	"\x05value\x18\x02 \x01(\v2A.temporal.server.api.deployment.v1.WorkerDeploymentVersionSummaryR\x05value:\x028\x01\x1a\x80\x01\n" +
	"\x19PropagatingRevisionsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12M\n" +
	"\x05value\x18\x02 \x01(\v27.temporal.server.api.deployment.v1.PropagatingRevisionsR\x05value:\x028\x01\"A\n" +
	"\x14PropagatingRevisions\x12)\n" +
	"\x10revision_numbers\x18\x01 \x03(\x03R\x0frevisionNumbers\"\xf8\x05\n" +
	"\x1eWorkerDeploymentVersionSummary\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\x12;\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\x12Y\n" +
	"\x0fdrainage_status\x18\x03 \x01(\x0e2,.temporal.api.enums.v1.VersionDrainageStatusB\x02\x18\x01R\x0edrainageStatus\x12T\n" +
	"\rdrainage_info\x18\x04 \x01(\v2/.temporal.api.deployment.v1.VersionDrainageInfoR\fdrainageInfo\x12J\n" +
	"\x13routing_update_time\x18\x05 \x01(\v2\x1a.google.protobuf.TimestampR\x11routingUpdateTime\x12H\n" +
	"\x12current_since_time\x18\x06 \x01(\v2\x1a.google.protobuf.TimestampR\x10currentSinceTime\x12H\n" +
	"\x12ramping_since_time\x18\a \x01(\v2\x1a.google.protobuf.TimestampR\x10rampingSinceTime\x12N\n" +
	"\x15first_activation_time\x18\b \x01(\v2\x1a.google.protobuf.TimestampR\x13firstActivationTime\x12P\n" +
	"\x16last_deactivation_time\x18\t \x01(\v2\x1a.google.protobuf.TimestampR\x14lastDeactivationTime\x12L\n" +
	"\x06status\x18\n" +
	" \x01(\x0e24.temporal.api.enums.v1.WorkerDeploymentVersionStatusR\x06status\"\xa7\x02\n" +
	"\x1bRegisterWorkerInVersionArgs\x12&\n" +
	"\x0ftask_queue_name\x18\x01 \x01(\tR\rtaskQueueName\x12L\n" +
	"\x0ftask_queue_type\x18\x02 \x01(\x0e2$.temporal.api.enums.v1.TaskQueueTypeR\rtaskQueueType\x12&\n" +
	"\x0fmax_task_queues\x18\x03 \x01(\x05R\rmaxTaskQueues\x12\x18\n" +
	"\aversion\x18\x04 \x01(\tR\aversion\x12P\n" +
	"\x0erouting_config\x18\x05 \x01(\v2).temporal.api.deployment.v1.RoutingConfigR\rroutingConfig\"\x9a\x02\n" +
	"$RegisterWorkerInWorkerDeploymentArgs\x12&\n" +
	"\x0ftask_queue_name\x18\x01 \x01(\tR\rtaskQueueName\x12L\n" +
	"\x0ftask_queue_type\x18\x02 \x01(\x0e2$.temporal.api.enums.v1.TaskQueueTypeR\rtaskQueueType\x12&\n" +
	"\x0fmax_task_queues\x18\x03 \x01(\x05R\rmaxTaskQueues\x12T\n" +
	"\aversion\x18\x04 \x01(\v2:.temporal.server.api.deployment.v1.WorkerDeploymentVersionR\aversion\"K\n" +
	"/DescribeVersionFromWorkerDeploymentActivityArgs\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\"\xab\x01\n" +
	"1DescribeVersionFromWorkerDeploymentActivityResult\x12v\n" +
	"\x10task_queue_infos\x18\x01 \x03(\v2L.temporal.api.deployment.v1.WorkerDeploymentVersionInfo.VersionTaskQueueInfoR\x0etaskQueueInfos\"\x87\x03\n" +
	"\x1aSyncVersionStateUpdateArgs\x12N\n" +
	"\x13routing_update_time\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampB\x02\x18\x01R\x11routingUpdateTime\x12L\n" +
	"\x12current_since_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampB\x02\x18\x01R\x10currentSinceTime\x12L\n" +
	"\x12ramping_since_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampB\x02\x18\x01R\x10rampingSinceTime\x12+\n" +
	"\x0framp_percentage\x18\x04 \x01(\x02B\x02\x18\x01R\x0erampPercentage\x12P\n" +
	"\x0erouting_config\x18\x05 \x01(\v2).temporal.api.deployment.v1.RoutingConfigR\rroutingConfig\"\xd6\x01\n" +
	"\x18SyncVersionStateResponse\x12]\n" +
	"\rversion_state\x18\x01 \x01(\v24.temporal.server.api.deployment.v1.VersionLocalStateB\x02\x18\x01R\fversionState\x12[\n" +
	"\asummary\x18\x02 \x01(\v2A.temporal.server.api.deployment.v1.WorkerDeploymentVersionSummaryR\asummary\"m\n" +
	"\x14AddVersionUpdateArgs\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\x12;\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\"r\n" +
	"\x1aSyncDrainageInfoSignalArgs\x12T\n" +
	"\rdrainage_info\x18\x01 \x01(\v2/.temporal.api.deployment.v1.VersionDrainageInfoR\fdrainageInfo\"\x8f\x01\n" +
	"\x1cSyncDrainageStatusSignalArgs\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\x12U\n" +
	"\x0fdrainage_status\x18\x02 \x01(\x0e2,.temporal.api.enums.v1.VersionDrainageStatusR\x0edrainageStatus\"_\n" +
	"\x19PropagationCompletionInfo\x12'\n" +
	"\x0frevision_number\x18\x01 \x01(\x03R\x0erevisionNumber\x12\x19\n" +
	"\bbuild_id\x18\x02 \x01(\tR\abuildId\"y\n" +
	"\x1cQueryDescribeVersionResponse\x12Y\n" +
	"\rversion_state\x18\x01 \x01(\v24.temporal.server.api.deployment.v1.VersionLocalStateR\fversionState\"|\n" +
	"%QueryDescribeWorkerDeploymentResponse\x12S\n" +
	"\x05state\x18\x01 \x01(\v2=.temporal.server.api.deployment.v1.WorkerDeploymentLocalStateR\x05state\"f\n" +
	"\x1cStartWorkerDeploymentRequest\x12'\n" +
	"\x0fdeployment_name\x18\x01 \x01(\tR\x0edeploymentName\x12\x1d\n" +
	"\n" +
	"request_id\x18\x02 \x01(\tR\trequestId\"\x88\x01\n" +
	"#StartWorkerDeploymentVersionRequest\x12'\n" +
	"\x0fdeployment_name\x18\x01 \x01(\tR\x0edeploymentName\x12\x19\n" +
	"\bbuild_id\x18\x02 \x01(\tR\abuildId\x12\x1d\n" +
	"\n" +
	"request_id\x18\x03 \x01(\tR\trequestId\"\xb4\x05\n" +
	"$SyncDeploymentVersionUserDataRequest\x12'\n" +
	"\x0fdeployment_name\x18\x04 \x01(\tR\x0edeploymentName\x12T\n" +
	"\aversion\x18\x01 \x01(\v2:.temporal.server.api.deployment.v1.WorkerDeploymentVersionR\aversion\x12h\n" +
	"\x04sync\x18\x02 \x03(\v2T.temporal.server.api.deployment.v1.SyncDeploymentVersionUserDataRequest.SyncUserDataR\x04sync\x12%\n" +
	"\x0eforget_version\x18\x03 \x01(\bR\rforgetVersion\x12]\n" +
	"\x15update_routing_config\x18\x05 \x01(\v2).temporal.api.deployment.v1.RoutingConfigR\x13updateRoutingConfig\x12n\n" +
	"\x13upsert_version_data\x18\x06 \x01(\v2>.temporal.server.api.deployment.v1.WorkerDeploymentVersionDataR\x11upsertVersionData\x1a\xac\x01\n" +
	"\fSyncUserData\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12:\n" +
	"\x05types\x18\x02 \x03(\x0e2$.temporal.api.enums.v1.TaskQueueTypeR\x05types\x12L\n" +
	"\x04data\x18\x03 \x01(\v28.temporal.server.api.deployment.v1.DeploymentVersionDataR\x04data\"\x8c\x02\n" +
	"%SyncDeploymentVersionUserDataResponse\x12\x99\x01\n" +
	"\x17task_queue_max_versions\x18\x01 \x03(\v2b.temporal.server.api.deployment.v1.SyncDeploymentVersionUserDataResponse.TaskQueueMaxVersionsEntryR\x14taskQueueMaxVersions\x1aG\n" +
	"\x19TaskQueueMaxVersionsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x03R\x05value:\x028\x01\"\xa0\x02\n" +
	"/CheckWorkerDeploymentUserDataPropagationRequest\x12\xa3\x01\n" +
	"\x17task_queue_max_versions\x18\x01 \x03(\v2l.temporal.server.api.deployment.v1.CheckWorkerDeploymentUserDataPropagationRequest.TaskQueueMaxVersionsEntryR\x14taskQueueMaxVersions\x1aG\n" +
	"\x19TaskQueueMaxVersionsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x03R\x05value:\x028\x01\"\xaa\x01\n" +
	"\x1fSyncUnversionedRampActivityArgs\x12'\n" +
	"\x0fcurrent_version\x18\x01 \x01(\tR\x0ecurrentVersion\x12^\n" +
	"\vupdate_args\x18\x02 \x01(\v2=.temporal.server.api.deployment.v1.SyncVersionStateUpdateArgsR\n" +
	"updateArgs\"\x88\x02\n" +
	"#SyncUnversionedRampActivityResponse\x12\x97\x01\n" +
	"\x17task_queue_max_versions\x18\x01 \x03(\v2`.temporal.server.api.deployment.v1.SyncUnversionedRampActivityResponse.TaskQueueMaxVersionsEntryR\x14taskQueueMaxVersions\x1aG\n" +
	"\x19TaskQueueMaxVersionsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x03R\x05value:\x028\x01\"\xb9\x02\n" +
	"\x19UpdateVersionMetadataArgs\x12v\n" +
	"\x0eupsert_entries\x18\x01 \x03(\v2O.temporal.server.api.deployment.v1.UpdateVersionMetadataArgs.UpsertEntriesEntryR\rupsertEntries\x12%\n" +
	"\x0eremove_entries\x18\x02 \x03(\tR\rremoveEntries\x12\x1a\n" +
	"\bidentity\x18\x03 \x01(\tR\bidentity\x1aa\n" +
	"\x12UpsertEntriesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x125\n" +
	"\x05value\x18\x02 \x01(\v2\x1f.temporal.api.common.v1.PayloadR\x05value:\x028\x01\"h\n" +
	"\x1dUpdateVersionMetadataResponse\x12G\n" +
	"\bmetadata\x18\x01 \x01(\v2+.temporal.api.deployment.v1.VersionMetadataR\bmetadata\"\xdb\x01\n" +
	"\x15SetCurrentVersionArgs\x12\x1a\n" +
	"\bidentity\x18\x01 \x01(\tR\bidentity\x12\x18\n" +
	"\aversion\x18\x02 \x01(\tR\aversion\x12;\n" +
	"\x1aignore_missing_task_queues\x18\x03 \x01(\bR\x17ignoreMissingTaskQueues\x12%\n" +
	"\x0econflict_token\x18\x04 \x01(\fR\rconflictToken\x12(\n" +
	"\x10allow_no_pollers\x18\x05 \x01(\bR\x0eallowNoPollers\"m\n" +
	"\x19SetCurrentVersionResponse\x12)\n" +
	"\x10previous_version\x18\x01 \x01(\tR\x0fpreviousVersion\x12%\n" +
	"\x0econflict_token\x18\x02 \x01(\fR\rconflictToken\"\xc0\x01\n" +
	"\x11DeleteVersionArgs\x12\x1a\n" +
	"\bidentity\x18\x01 \x01(\tR\bidentity\x12\x18\n" +
	"\aversion\x18\x02 \x01(\tR\aversion\x12#\n" +
	"\rskip_drainage\x18\x03 \x01(\bR\fskipDrainage\x12#\n" +
	"\rserver_delete\x18\x04 \x01(\bR\fserverDelete\x12+\n" +
	"\x11async_propagation\x18\x05 \x01(\bR\x10asyncPropagation\"\xeb\x01\n" +
	"\x19DeleteVersionActivityArgs\x12\x1a\n" +
	"\bidentity\x18\x01 \x01(\tR\bidentity\x12'\n" +
	"\x0fdeployment_name\x18\x02 \x01(\tR\x0edeploymentName\x12\x18\n" +
	"\aversion\x18\x03 \x01(\tR\aversion\x12\x1d\n" +
	"\n" +
	"request_id\x18\x04 \x01(\tR\trequestId\x12#\n" +
	"\rskip_drainage\x18\x05 \x01(\bR\fskipDrainage\x12+\n" +
	"\x11async_propagation\x18\x06 \x01(\bR\x10asyncPropagation\"\xa7\x04\n" +
	"&CheckTaskQueuesHavePollersActivityArgs\x12\x94\x01\n" +
	"\x15task_queues_and_types\x18\x01 \x03(\v2a.temporal.server.api.deployment.v1.CheckTaskQueuesHavePollersActivityArgs.TaskQueuesAndTypesEntryR\x12taskQueuesAndTypes\x12v\n" +
	"\x19worker_deployment_version\x18\x02 \x01(\v2:.temporal.server.api.deployment.v1.WorkerDeploymentVersionR\x17workerDeploymentVersion\x1a\x9f\x01\n" +
	"\x17TaskQueuesAndTypesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12n\n" +
	"\x05value\x18\x02 \x01(\v2X.temporal.server.api.deployment.v1.CheckTaskQueuesHavePollersActivityArgs.TaskQueueTypesR\x05value:\x028\x01\x1aL\n" +
	"\x0eTaskQueueTypes\x12:\n" +
	"\x05types\x18\x01 \x03(\x0e2$.temporal.api.enums.v1.TaskQueueTypeR\x05types\"2\n" +
	"\x14DeleteDeploymentArgs\x12\x1a\n" +
	"\bidentity\x18\x01 \x01(\tR\bidentity\"\x9e\x01\n" +
	"\x19SetRampingVersionResponse\x12)\n" +
	"\x10previous_version\x18\x01 \x01(\tR\x0fpreviousVersion\x12/\n" +
	"\x13previous_percentage\x18\x02 \x01(\x02R\x12previousPercentage\x12%\n" +
	"\x0econflict_token\x18\x03 \x01(\fR\rconflictToken\"\xfb\x01\n" +
	"\x15SetRampingVersionArgs\x12\x1a\n" +
	"\bidentity\x18\x01 \x01(\tR\bidentity\x12\x18\n" +
	"\aversion\x18\x02 \x01(\tR\aversion\x12\x1e\n" +
	"\n" +
	"percentage\x18\x03 \x01(\x02R\n" +
	"percentage\x12;\n" +
	"\x1aignore_missing_task_queues\x18\x04 \x01(\bR\x17ignoreMissingTaskQueues\x12%\n" +
	"\x0econflict_token\x18\x05 \x01(\fR\rconflictToken\x12(\n" +
	"\x10allow_no_pollers\x18\x06 \x01(\bR\x0eallowNoPollers\"\x86\x01\n" +
	"\x16SetManagerIdentityArgs\x12\x1a\n" +
	"\bidentity\x18\x01 \x01(\tR\bidentity\x12)\n" +
	"\x10manager_identity\x18\x02 \x01(\tR\x0fmanagerIdentity\x12%\n" +
	"\x0econflict_token\x18\x05 \x01(\fR\rconflictToken\"\x7f\n" +
	"\x1aSetManagerIdentityResponse\x12:\n" +
	"\x19previous_manager_identity\x18\x01 \x01(\tR\x17previousManagerIdentity\x12%\n" +
	"\x0econflict_token\x18\x02 \x01(\fR\rconflictToken\"\xe0\x01\n" +
	"\x1cSyncVersionStateActivityArgs\x12'\n" +
	"\x0fdeployment_name\x18\x01 \x01(\tR\x0edeploymentName\x12\x18\n" +
	"\aversion\x18\x02 \x01(\tR\aversion\x12^\n" +
	"\vupdate_args\x18\x03 \x01(\v2=.temporal.server.api.deployment.v1.SyncVersionStateUpdateArgsR\n" +
	"updateArgs\x12\x1d\n" +
	"\n" +
	"request_id\x18\x04 \x01(\tR\trequestId\"\xdc\x01\n" +
	"\x1eSyncVersionStateActivityResult\x12]\n" +
	"\rversion_state\x18\x01 \x01(\v24.temporal.server.api.deployment.v1.VersionLocalStateB\x02\x18\x01R\fversionState\x12[\n" +
	"\asummary\x18\x02 \x01(\v2A.temporal.server.api.deployment.v1.WorkerDeploymentVersionSummaryR\asummary\"\x82\x01\n" +
	"\x1eIsVersionMissingTaskQueuesArgs\x120\n" +
	"\x14prev_current_version\x18\x01 \x01(\tR\x12prevCurrentVersion\x12.\n" +
	"\x13new_current_version\x18\x02 \x01(\tR\x11newCurrentVersion\"W\n" +
	" IsVersionMissingTaskQueuesResult\x123\n" +
	"\x16is_missing_task_queues\x18\x01 \x01(\bR\x13isMissingTaskQueues\"\xf2\x04\n" +
	"\x1cWorkerDeploymentWorkflowMemo\x12'\n" +
	"\x0fdeployment_name\x18\x01 \x01(\tR\x0edeploymentName\x12;\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\x12P\n" +
	"\x0erouting_config\x18\x03 \x01(\v2).temporal.api.deployment.v1.RoutingConfigR\rroutingConfig\x12\x85\x01\n" +
	"\x16latest_version_summary\x18\x04 \x01(\v2O.temporal.api.deployment.v1.WorkerDeploymentInfo.WorkerDeploymentVersionSummaryR\x14latestVersionSummary\x12\x87\x01\n" +
	"\x17current_version_summary\x18\x05 \x01(\v2O.temporal.api.deployment.v1.WorkerDeploymentInfo.WorkerDeploymentVersionSummaryR\x15currentVersionSummary\x12\x87\x01\n" +
	"\x17ramping_version_summary\x18\x06 \x01(\v2O.temporal.api.deployment.v1.WorkerDeploymentInfo.WorkerDeploymentVersionSummaryR\x15rampingVersionSummary\"\xd8\x04\n" +
	"\x17WorkerDeploymentSummary\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12;\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\x12P\n" +
	"\x0erouting_config\x18\x03 \x01(\v2).temporal.api.deployment.v1.RoutingConfigR\rroutingConfig\x12\x85\x01\n" +
	"\x16latest_version_summary\x18\x04 \x01(\v2O.temporal.api.deployment.v1.WorkerDeploymentInfo.WorkerDeploymentVersionSummaryR\x14latestVersionSummary\x12\x87\x01\n" +
	"\x17current_version_summary\x18\x05 \x01(\v2O.temporal.api.deployment.v1.WorkerDeploymentInfo.WorkerDeploymentVersionSummaryR\x15currentVersionSummary\x12\x87\x01\n" +
	"\x17ramping_version_summary\x18\x06 \x01(\v2O.temporal.api.deployment.v1.WorkerDeploymentInfo.WorkerDeploymentVersionSummaryR\x15rampingVersionSummary\"\xc7\x01\n" +
	"#AddVersionToWorkerDeploymentRequest\x12'\n" +
	"\x0fdeployment_name\x18\x01 \x01(\tR\x0edeploymentName\x12X\n" +
	"\vupdate_args\x18\x02 \x01(\v27.temporal.server.api.deployment.v1.AddVersionUpdateArgsR\n" +
	"updateArgs\x12\x1d\n" +
	"\n" +
	"request_id\x18\x03 \x01(\tR\trequestId\"&\n" +
	"$AddVersionToWorkerDeploymentResponse\"\xac\x01\n" +
	"\rTaskQueueData\x12F\n" +
	"\x11first_poller_time\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\x0ffirstPollerTime\x12S\n" +
	"\x18last_became_current_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\x15lastBecameCurrentTime\"\xa3\b\n" +
	"\x14DeploymentLocalState\x12F\n" +
	"\n" +
	"deployment\x18\x01 \x01(\v2&.temporal.api.deployment.v1.DeploymentR\n" +
	"deployment\x12~\n" +
	"\x13task_queue_families\x18\x02 \x03(\v2N.temporal.server.api.deployment.v1.DeploymentLocalState.TaskQueueFamiliesEntryR\x11taskQueueFamilies\x12\x1d\n" +
	"\n" +
	"is_current\x18\x03 \x01(\bR\tisCurrent\x12S\n" +
	"\x18last_became_current_time\x18\x06 \x01(\v2\x1a.google.protobuf.TimestampR\x15lastBecameCurrentTime\x12;\n" +
	"\vcreate_time\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\x12a\n" +
	"\bmetadata\x18\x05 \x03(\v2E.temporal.server.api.deployment.v1.DeploymentLocalState.MetadataEntryR\bmetadata\x126\n" +
	"\x17started_series_workflow\x18\a \x01(\bR\x15startedSeriesWorkflow\x1a\x91\x01\n" +
	"\x16TaskQueueFamiliesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12a\n" +
	"\x05value\x18\x02 \x01(\v2K.temporal.server.api.deployment.v1.DeploymentLocalState.TaskQueueFamilyDataR\x05value:\x028\x01\x1a\\\n" +
	"\rMetadataEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x125\n" +
	"\x05value\x18\x02 \x01(\v2\x1f.temporal.api.common.v1.PayloadR\x05value:\x028\x01\x1a\x84\x02\n" +
	"\x13TaskQueueFamilyData\x12|\n" +
	"\vtask_queues\x18\x01 \x03(\v2[.temporal.server.api.deployment.v1.DeploymentLocalState.TaskQueueFamilyData.TaskQueuesEntryR\n" +
	"taskQueues\x1ao\n" +
	"\x0fTaskQueuesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\x05R\x03key\x12F\n" +
	"\x05value\x18\x02 \x01(\v20.temporal.server.api.deployment.v1.TaskQueueDataR\x05value:\x028\x01\"\xb1\x01\n" +
	"\x16DeploymentWorkflowArgs\x12%\n" +
	"\x0enamespace_name\x18\x01 \x01(\tR\rnamespaceName\x12!\n" +
	"\fnamespace_id\x18\x02 \x01(\tR\vnamespaceId\x12M\n" +
	"\x05state\x18\x03 \x01(\v27.temporal.server.api.deployment.v1.DeploymentLocalStateR\x05state\"\xd4\x01\n" +
	"\x1cDeploymentSeriesWorkflowArgs\x12%\n" +
	"\x0enamespace_name\x18\x01 \x01(\tR\rnamespaceName\x12!\n" +
	"\fnamespace_id\x18\x02 \x01(\tR\vnamespaceId\x12\x1f\n" +
	"\vseries_name\x18\x03 \x01(\tR\n" +
	"seriesName\x12I\n" +
	"\x05state\x18\x04 \x01(\v23.temporal.server.api.deployment.v1.SeriesLocalStateR\x05state\"\x8a\x01\n" +
	"\x10SeriesLocalState\x12(\n" +
	"\x10current_build_id\x18\x01 \x01(\tR\x0ecurrentBuildId\x12L\n" +
	"\x14current_changed_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\x12currentChangedTime\"\x86\x02\n" +
	"\x1eRegisterWorkerInDeploymentArgs\x12&\n" +
	"\x0ftask_queue_name\x18\x01 \x01(\tR\rtaskQueueName\x12L\n" +
	"\x0ftask_queue_type\x18\x02 \x01(\x0e2$.temporal.api.enums.v1.TaskQueueTypeR\rtaskQueueType\x12F\n" +
	"\x11first_poller_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\x0ffirstPollerTime\x12&\n" +
	"\x0fmax_task_queues\x18\x04 \x01(\x05R\rmaxTaskQueues\"\xc3\x02\n" +
	"\x17SyncDeploymentStateArgs\x12f\n" +
	"\vset_current\x18\x01 \x01(\v2E.temporal.server.api.deployment.v1.SyncDeploymentStateArgs.SetCurrentR\n" +
	"setCurrent\x12]\n" +
	"\x0fupdate_metadata\x18\x02 \x01(\v24.temporal.api.deployment.v1.UpdateDeploymentMetadataR\x0eupdateMetadata\x1aa\n" +
	"\n" +
	"SetCurrent\x12S\n" +
	"\x18last_became_current_time\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\x15lastBecameCurrentTime\"\x8c\x01\n" +
	"\x1bSyncDeploymentStateResponse\x12m\n" +
	"\x16deployment_local_state\x18\x01 \x01(\v27.temporal.server.api.deployment.v1.DeploymentLocalStateR\x14deploymentLocalState\"\x90\x01\n" +
	"\x1fQueryDescribeDeploymentResponse\x12m\n" +
	"\x16deployment_local_state\x18\x01 \x01(\v27.temporal.server.api.deployment.v1.DeploymentLocalStateR\x14deploymentLocalState\"\xd1\x01\n" +
	"\x16DeploymentWorkflowMemo\x12F\n" +
	"\n" +
	"deployment\x18\x01 \x01(\v2&.temporal.api.deployment.v1.DeploymentR\n" +
	"deployment\x12;\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\x122\n" +
	"\x15is_current_deployment\x18\x03 \x01(\bR\x13isCurrentDeployment\"^\n" +
	"\x1cStartDeploymentSeriesRequest\x12\x1f\n" +
	"\vseries_name\x18\x01 \x01(\tR\n" +
	"seriesName\x12\x1d\n" +
	"\n" +
	"request_id\x18\x02 \x01(\tR\trequestId\"\xdb\x02\n" +
	"\x13SyncUserDataRequest\x12F\n" +
	"\n" +
	"deployment\x18\x01 \x01(\v2&.temporal.api.deployment.v1.DeploymentR\n" +
	"deployment\x12W\n" +
	"\x04sync\x18\x02 \x03(\v2C.temporal.server.api.deployment.v1.SyncUserDataRequest.SyncUserDataR\x04sync\x1a\xa2\x01\n" +
	"\fSyncUserData\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x128\n" +
	"\x04type\x18\x02 \x01(\x0e2$.temporal.api.enums.v1.TaskQueueTypeR\x04type\x12D\n" +
	"\x04data\x18\x03 \x01(\v20.temporal.server.api.deployment.v1.TaskQueueDataR\x04data\"\xea\x01\n" +
	"\x14SyncUserDataResponse\x12\x88\x01\n" +
	"\x17task_queue_max_versions\x18\x01 \x03(\v2Q.temporal.server.api.deployment.v1.SyncUserDataResponse.TaskQueueMaxVersionsEntryR\x14taskQueueMaxVersions\x1aG\n" +
	"\x19TaskQueueMaxVersionsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x03R\x05value:\x028\x01\"\x80\x02\n" +
	"\x1fCheckUserDataPropagationRequest\x12\x93\x01\n" +
	"\x17task_queue_max_versions\x18\x01 \x03(\v2\\.temporal.server.api.deployment.v1.CheckUserDataPropagationRequest.TaskQueueMaxVersionsEntryR\x14taskQueueMaxVersions\x1aG\n" +
	"\x19TaskQueueMaxVersionsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x03R\x05value:\x028\x01\"\xcf\x01\n" +
	"\x18SetCurrentDeploymentArgs\x12\x1a\n" +
	"\bidentity\x18\x01 \x01(\tR\bidentity\x12\x19\n" +
	"\bbuild_id\x18\x02 \x01(\tR\abuildId\x12]\n" +
	"\x0fupdate_metadata\x18\x03 \x01(\v24.temporal.api.deployment.v1.UpdateDeploymentMetadataR\x0eupdateMetadata\x12\x1d\n" +
	"\n" +
	"request_id\x18\x04 \x01(\tR\trequestId\"\x86\x02\n" +
	"\x1cSetCurrentDeploymentResponse\x12q\n" +
	"\x18current_deployment_state\x18\x01 \x01(\v27.temporal.server.api.deployment.v1.DeploymentLocalStateR\x16currentDeploymentState\x12s\n" +
	"\x19previous_deployment_state\x18\x02 \x01(\v27.temporal.server.api.deployment.v1.DeploymentLocalStateR\x17previousDeploymentState\"\xd8\x01\n" +
	"\x1fSyncDeploymentStateActivityArgs\x12F\n" +
	"\n" +
	"deployment\x18\x01 \x01(\v2&.temporal.api.deployment.v1.DeploymentR\n" +
	"deployment\x12N\n" +
	"\x04args\x18\x02 \x01(\v2:.temporal.server.api.deployment.v1.SyncDeploymentStateArgsR\x04args\x12\x1d\n" +
	"\n" +
	"request_id\x18\x03 \x01(\tR\trequestId\"r\n" +
	"!SyncDeploymentStateActivityResult\x12M\n" +
	"\x05state\x18\x01 \x01(\v27.temporal.server.api.deployment.v1.DeploymentLocalStateR\x05state\"\xb7\x01\n" +
	"\x1cDeploymentSeriesWorkflowMemo\x12\x1f\n" +
	"\vseries_name\x18\x01 \x01(\tR\n" +
	"seriesName\x12(\n" +
	"\x10current_build_id\x18\x02 \x01(\tR\x0ecurrentBuildId\x12L\n" +
	"\x14current_changed_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\x12currentChangedTimeB4Z2go.temporal.io/server/api/deployment/v1;deploymentb\x06proto3"

var (
	file_temporal_server_api_deployment_v1_message_proto_rawDescOnce sync.Once
	file_temporal_server_api_deployment_v1_message_proto_rawDescData []byte
)

func file_temporal_server_api_deployment_v1_message_proto_rawDescGZIP() []byte {
	file_temporal_server_api_deployment_v1_message_proto_rawDescOnce.Do(func() {
		file_temporal_server_api_deployment_v1_message_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_temporal_server_api_deployment_v1_message_proto_rawDesc), len(file_temporal_server_api_deployment_v1_message_proto_rawDesc)))
	})
	return file_temporal_server_api_deployment_v1_message_proto_rawDescData
}

var file_temporal_server_api_deployment_v1_message_proto_msgTypes = make([]protoimpl.MessageInfo, 88)
var file_temporal_server_api_deployment_v1_message_proto_goTypes = []any{
	(*WorkerDeploymentVersion)(nil),                           // 0: temporal.server.api.deployment.v1.WorkerDeploymentVersion
	(*DeploymentVersionData)(nil),                             // 1: temporal.server.api.deployment.v1.DeploymentVersionData
	(*WorkerDeploymentVersionData)(nil),                       // 2: temporal.server.api.deployment.v1.WorkerDeploymentVersionData
	(*VersionLocalState)(nil),                                 // 3: temporal.server.api.deployment.v1.VersionLocalState
	(*TaskQueueVersionData)(nil),                              // 4: temporal.server.api.deployment.v1.TaskQueueVersionData
	(*WorkerDeploymentVersionWorkflowArgs)(nil),               // 5: temporal.server.api.deployment.v1.WorkerDeploymentVersionWorkflowArgs
	(*WorkerDeploymentWorkflowArgs)(nil),                      // 6: temporal.server.api.deployment.v1.WorkerDeploymentWorkflowArgs
	(*WorkerDeploymentLocalState)(nil),                        // 7: temporal.server.api.deployment.v1.WorkerDeploymentLocalState
	(*PropagatingRevisions)(nil),                              // 8: temporal.server.api.deployment.v1.PropagatingRevisions
	(*WorkerDeploymentVersionSummary)(nil),                    // 9: temporal.server.api.deployment.v1.WorkerDeploymentVersionSummary
	(*RegisterWorkerInVersionArgs)(nil),                       // 10: temporal.server.api.deployment.v1.RegisterWorkerInVersionArgs
	(*RegisterWorkerInWorkerDeploymentArgs)(nil),              // 11: temporal.server.api.deployment.v1.RegisterWorkerInWorkerDeploymentArgs
	(*DescribeVersionFromWorkerDeploymentActivityArgs)(nil),   // 12: temporal.server.api.deployment.v1.DescribeVersionFromWorkerDeploymentActivityArgs
	(*DescribeVersionFromWorkerDeploymentActivityResult)(nil), // 13: temporal.server.api.deployment.v1.DescribeVersionFromWorkerDeploymentActivityResult
	(*SyncVersionStateUpdateArgs)(nil),                        // 14: temporal.server.api.deployment.v1.SyncVersionStateUpdateArgs
	(*SyncVersionStateResponse)(nil),                          // 15: temporal.server.api.deployment.v1.SyncVersionStateResponse
	(*AddVersionUpdateArgs)(nil),                              // 16: temporal.server.api.deployment.v1.AddVersionUpdateArgs
	(*SyncDrainageInfoSignalArgs)(nil),                        // 17: temporal.server.api.deployment.v1.SyncDrainageInfoSignalArgs
	(*SyncDrainageStatusSignalArgs)(nil),                      // 18: temporal.server.api.deployment.v1.SyncDrainageStatusSignalArgs
	(*PropagationCompletionInfo)(nil),                         // 19: temporal.server.api.deployment.v1.PropagationCompletionInfo
	(*QueryDescribeVersionResponse)(nil),                      // 20: temporal.server.api.deployment.v1.QueryDescribeVersionResponse
	(*QueryDescribeWorkerDeploymentResponse)(nil),             // 21: temporal.server.api.deployment.v1.QueryDescribeWorkerDeploymentResponse
	(*StartWorkerDeploymentRequest)(nil),                      // 22: temporal.server.api.deployment.v1.StartWorkerDeploymentRequest
	(*StartWorkerDeploymentVersionRequest)(nil),               // 23: temporal.server.api.deployment.v1.StartWorkerDeploymentVersionRequest
	(*SyncDeploymentVersionUserDataRequest)(nil),              // 24: temporal.server.api.deployment.v1.SyncDeploymentVersionUserDataRequest
	(*SyncDeploymentVersionUserDataResponse)(nil),             // 25: temporal.server.api.deployment.v1.SyncDeploymentVersionUserDataResponse
	(*CheckWorkerDeploymentUserDataPropagationRequest)(nil),   // 26: temporal.server.api.deployment.v1.CheckWorkerDeploymentUserDataPropagationRequest
	(*SyncUnversionedRampActivityArgs)(nil),                   // 27: temporal.server.api.deployment.v1.SyncUnversionedRampActivityArgs
	(*SyncUnversionedRampActivityResponse)(nil),               // 28: temporal.server.api.deployment.v1.SyncUnversionedRampActivityResponse
	(*UpdateVersionMetadataArgs)(nil),                         // 29: temporal.server.api.deployment.v1.UpdateVersionMetadataArgs
	(*UpdateVersionMetadataResponse)(nil),                     // 30: temporal.server.api.deployment.v1.UpdateVersionMetadataResponse
	(*SetCurrentVersionArgs)(nil),                             // 31: temporal.server.api.deployment.v1.SetCurrentVersionArgs
	(*SetCurrentVersionResponse)(nil),                         // 32: temporal.server.api.deployment.v1.SetCurrentVersionResponse
	(*DeleteVersionArgs)(nil),                                 // 33: temporal.server.api.deployment.v1.DeleteVersionArgs
	(*DeleteVersionActivityArgs)(nil),                         // 34: temporal.server.api.deployment.v1.DeleteVersionActivityArgs
	(*CheckTaskQueuesHavePollersActivityArgs)(nil),            // 35: temporal.server.api.deployment.v1.CheckTaskQueuesHavePollersActivityArgs
	(*DeleteDeploymentArgs)(nil),                              // 36: temporal.server.api.deployment.v1.DeleteDeploymentArgs
	(*SetRampingVersionResponse)(nil),                         // 37: temporal.server.api.deployment.v1.SetRampingVersionResponse
	(*SetRampingVersionArgs)(nil),                             // 38: temporal.server.api.deployment.v1.SetRampingVersionArgs
	(*SetManagerIdentityArgs)(nil),                            // 39: temporal.server.api.deployment.v1.SetManagerIdentityArgs
	(*SetManagerIdentityResponse)(nil),                        // 40: temporal.server.api.deployment.v1.SetManagerIdentityResponse
	(*SyncVersionStateActivityArgs)(nil),                      // 41: temporal.server.api.deployment.v1.SyncVersionStateActivityArgs
	(*SyncVersionStateActivityResult)(nil),                    // 42: temporal.server.api.deployment.v1.SyncVersionStateActivityResult
	(*IsVersionMissingTaskQueuesArgs)(nil),                    // 43: temporal.server.api.deployment.v1.IsVersionMissingTaskQueuesArgs
	(*IsVersionMissingTaskQueuesResult)(nil),                  // 44: temporal.server.api.deployment.v1.IsVersionMissingTaskQueuesResult
	(*WorkerDeploymentWorkflowMemo)(nil),                      // 45: temporal.server.api.deployment.v1.WorkerDeploymentWorkflowMemo
	(*WorkerDeploymentSummary)(nil),                           // 46: temporal.server.api.deployment.v1.WorkerDeploymentSummary
	(*AddVersionToWorkerDeploymentRequest)(nil),               // 47: temporal.server.api.deployment.v1.AddVersionToWorkerDeploymentRequest
	(*AddVersionToWorkerDeploymentResponse)(nil),              // 48: temporal.server.api.deployment.v1.AddVersionToWorkerDeploymentResponse
	(*TaskQueueData)(nil),                                     // 49: temporal.server.api.deployment.v1.TaskQueueData
	(*DeploymentLocalState)(nil),                              // 50: temporal.server.api.deployment.v1.DeploymentLocalState
	(*DeploymentWorkflowArgs)(nil),                            // 51: temporal.server.api.deployment.v1.DeploymentWorkflowArgs
	(*DeploymentSeriesWorkflowArgs)(nil),                      // 52: temporal.server.api.deployment.v1.DeploymentSeriesWorkflowArgs
	(*SeriesLocalState)(nil),                                  // 53: temporal.server.api.deployment.v1.SeriesLocalState
	(*RegisterWorkerInDeploymentArgs)(nil),                    // 54: temporal.server.api.deployment.v1.RegisterWorkerInDeploymentArgs
	(*SyncDeploymentStateArgs)(nil),                           // 55: temporal.server.api.deployment.v1.SyncDeploymentStateArgs
	(*SyncDeploymentStateResponse)(nil),                       // 56: temporal.server.api.deployment.v1.SyncDeploymentStateResponse
	(*QueryDescribeDeploymentResponse)(nil),                   // 57: temporal.server.api.deployment.v1.QueryDescribeDeploymentResponse
	(*DeploymentWorkflowMemo)(nil),                            // 58: temporal.server.api.deployment.v1.DeploymentWorkflowMemo
	(*StartDeploymentSeriesRequest)(nil),                      // 59: temporal.server.api.deployment.v1.StartDeploymentSeriesRequest
	(*SyncUserDataRequest)(nil),                               // 60: temporal.server.api.deployment.v1.SyncUserDataRequest
	(*SyncUserDataResponse)(nil),                              // 61: temporal.server.api.deployment.v1.SyncUserDataResponse
	(*CheckUserDataPropagationRequest)(nil),                   // 62: temporal.server.api.deployment.v1.CheckUserDataPropagationRequest
	(*SetCurrentDeploymentArgs)(nil),                          // 63: temporal.server.api.deployment.v1.SetCurrentDeploymentArgs
	(*SetCurrentDeploymentResponse)(nil),                      // 64: temporal.server.api.deployment.v1.SetCurrentDeploymentResponse
	(*SyncDeploymentStateActivityArgs)(nil),                   // 65: temporal.server.api.deployment.v1.SyncDeploymentStateActivityArgs
	(*SyncDeploymentStateActivityResult)(nil),                 // 66: temporal.server.api.deployment.v1.SyncDeploymentStateActivityResult
	(*DeploymentSeriesWorkflowMemo)(nil),                      // 67: temporal.server.api.deployment.v1.DeploymentSeriesWorkflowMemo
	nil,                                                       // 68: temporal.server.api.deployment.v1.VersionLocalState.TaskQueueFamiliesEntry
	(*VersionLocalState_TaskQueueFamilyData)(nil),             // 69: temporal.server.api.deployment.v1.VersionLocalState.TaskQueueFamilyData
	nil, // 70: temporal.server.api.deployment.v1.VersionLocalState.TaskQueueFamilyData.TaskQueuesEntry
	nil, // 71: temporal.server.api.deployment.v1.WorkerDeploymentLocalState.VersionsEntry
	nil, // 72: temporal.server.api.deployment.v1.WorkerDeploymentLocalState.PropagatingRevisionsEntry
	(*SyncDeploymentVersionUserDataRequest_SyncUserData)(nil), // 73: temporal.server.api.deployment.v1.SyncDeploymentVersionUserDataRequest.SyncUserData
	nil, // 74: temporal.server.api.deployment.v1.SyncDeploymentVersionUserDataResponse.TaskQueueMaxVersionsEntry
	nil, // 75: temporal.server.api.deployment.v1.CheckWorkerDeploymentUserDataPropagationRequest.TaskQueueMaxVersionsEntry
	nil, // 76: temporal.server.api.deployment.v1.SyncUnversionedRampActivityResponse.TaskQueueMaxVersionsEntry
	nil, // 77: temporal.server.api.deployment.v1.UpdateVersionMetadataArgs.UpsertEntriesEntry
	nil, // 78: temporal.server.api.deployment.v1.CheckTaskQueuesHavePollersActivityArgs.TaskQueuesAndTypesEntry
	(*CheckTaskQueuesHavePollersActivityArgs_TaskQueueTypes)(nil), // 79: temporal.server.api.deployment.v1.CheckTaskQueuesHavePollersActivityArgs.TaskQueueTypes
	nil, // 80: temporal.server.api.deployment.v1.DeploymentLocalState.TaskQueueFamiliesEntry
	nil, // 81: temporal.server.api.deployment.v1.DeploymentLocalState.MetadataEntry
	(*DeploymentLocalState_TaskQueueFamilyData)(nil), // 82: temporal.server.api.deployment.v1.DeploymentLocalState.TaskQueueFamilyData
	nil, // 83: temporal.server.api.deployment.v1.DeploymentLocalState.TaskQueueFamilyData.TaskQueuesEntry
	(*SyncDeploymentStateArgs_SetCurrent)(nil), // 84: temporal.server.api.deployment.v1.SyncDeploymentStateArgs.SetCurrent
	(*SyncUserDataRequest_SyncUserData)(nil),   // 85: temporal.server.api.deployment.v1.SyncUserDataRequest.SyncUserData
	nil,                                        // 86: temporal.server.api.deployment.v1.SyncUserDataResponse.TaskQueueMaxVersionsEntry
	nil,                                        // 87: temporal.server.api.deployment.v1.CheckUserDataPropagationRequest.TaskQueueMaxVersionsEntry
	(*timestamppb.Timestamp)(nil),              // 88: google.protobuf.Timestamp
	(v1.WorkerDeploymentVersionStatus)(0),      // 89: temporal.api.enums.v1.WorkerDeploymentVersionStatus
	(*v11.VersionDrainageInfo)(nil),            // 90: temporal.api.deployment.v1.VersionDrainageInfo
	(*v11.VersionMetadata)(nil),                // 91: temporal.api.deployment.v1.VersionMetadata
	(*v11.RoutingConfig)(nil),                  // 92: temporal.api.deployment.v1.RoutingConfig
	(v1.VersionDrainageStatus)(0),              // 93: temporal.api.enums.v1.VersionDrainageStatus
	(v1.TaskQueueType)(0),                      // 94: temporal.api.enums.v1.TaskQueueType
	(*v11.WorkerDeploymentVersionInfo_VersionTaskQueueInfo)(nil),    // 95: temporal.api.deployment.v1.WorkerDeploymentVersionInfo.VersionTaskQueueInfo
	(*v11.WorkerDeploymentInfo_WorkerDeploymentVersionSummary)(nil), // 96: temporal.api.deployment.v1.WorkerDeploymentInfo.WorkerDeploymentVersionSummary
	(*v11.Deployment)(nil),               // 97: temporal.api.deployment.v1.Deployment
	(*v11.UpdateDeploymentMetadata)(nil), // 98: temporal.api.deployment.v1.UpdateDeploymentMetadata
	(*v12.Payload)(nil),                  // 99: temporal.api.common.v1.Payload
}
var file_temporal_server_api_deployment_v1_message_proto_depIdxs = []int32{
	0,   // 0: temporal.server.api.deployment.v1.DeploymentVersionData.version:type_name -> temporal.server.api.deployment.v1.WorkerDeploymentVersion
	88,  // 1: temporal.server.api.deployment.v1.DeploymentVersionData.routing_update_time:type_name -> google.protobuf.Timestamp
	88,  // 2: temporal.server.api.deployment.v1.DeploymentVersionData.current_since_time:type_name -> google.protobuf.Timestamp
	88,  // 3: temporal.server.api.deployment.v1.DeploymentVersionData.ramping_since_time:type_name -> google.protobuf.Timestamp
	89,  // 4: temporal.server.api.deployment.v1.DeploymentVersionData.status:type_name -> temporal.api.enums.v1.WorkerDeploymentVersionStatus
	89,  // 5: temporal.server.api.deployment.v1.WorkerDeploymentVersionData.status:type_name -> temporal.api.enums.v1.WorkerDeploymentVersionStatus
	0,   // 6: temporal.server.api.deployment.v1.VersionLocalState.version:type_name -> temporal.server.api.deployment.v1.WorkerDeploymentVersion
	88,  // 7: temporal.server.api.deployment.v1.VersionLocalState.create_time:type_name -> google.protobuf.Timestamp
	88,  // 8: temporal.server.api.deployment.v1.VersionLocalState.routing_update_time:type_name -> google.protobuf.Timestamp
	88,  // 9: temporal.server.api.deployment.v1.VersionLocalState.current_since_time:type_name -> google.protobuf.Timestamp
	88,  // 10: temporal.server.api.deployment.v1.VersionLocalState.ramping_since_time:type_name -> google.protobuf.Timestamp
	88,  // 11: temporal.server.api.deployment.v1.VersionLocalState.first_activation_time:type_name -> google.protobuf.Timestamp
	88,  // 12: temporal.server.api.deployment.v1.VersionLocalState.last_deactivation_time:type_name -> google.protobuf.Timestamp
	90,  // 13: temporal.server.api.deployment.v1.VersionLocalState.drainage_info:type_name -> temporal.api.deployment.v1.VersionDrainageInfo
	91,  // 14: temporal.server.api.deployment.v1.VersionLocalState.metadata:type_name -> temporal.api.deployment.v1.VersionMetadata
	68,  // 15: temporal.server.api.deployment.v1.VersionLocalState.task_queue_families:type_name -> temporal.server.api.deployment.v1.VersionLocalState.TaskQueueFamiliesEntry
	89,  // 16: temporal.server.api.deployment.v1.VersionLocalState.status:type_name -> temporal.api.enums.v1.WorkerDeploymentVersionStatus
	3,   // 17: temporal.server.api.deployment.v1.WorkerDeploymentVersionWorkflowArgs.version_state:type_name -> temporal.server.api.deployment.v1.VersionLocalState
	7,   // 18: temporal.server.api.deployment.v1.WorkerDeploymentWorkflowArgs.state:type_name -> temporal.server.api.deployment.v1.WorkerDeploymentLocalState
	88,  // 19: temporal.server.api.deployment.v1.WorkerDeploymentLocalState.create_time:type_name -> google.protobuf.Timestamp
	92,  // 20: temporal.server.api.deployment.v1.WorkerDeploymentLocalState.routing_config:type_name -> temporal.api.deployment.v1.RoutingConfig
	71,  // 21: temporal.server.api.deployment.v1.WorkerDeploymentLocalState.versions:type_name -> temporal.server.api.deployment.v1.WorkerDeploymentLocalState.VersionsEntry
	72,  // 22: temporal.server.api.deployment.v1.WorkerDeploymentLocalState.propagating_revisions:type_name -> temporal.server.api.deployment.v1.WorkerDeploymentLocalState.PropagatingRevisionsEntry
	88,  // 23: temporal.server.api.deployment.v1.WorkerDeploymentVersionSummary.create_time:type_name -> google.protobuf.Timestamp
	93,  // 24: temporal.server.api.deployment.v1.WorkerDeploymentVersionSummary.drainage_status:type_name -> temporal.api.enums.v1.VersionDrainageStatus
	90,  // 25: temporal.server.api.deployment.v1.WorkerDeploymentVersionSummary.drainage_info:type_name -> temporal.api.deployment.v1.VersionDrainageInfo
	88,  // 26: temporal.server.api.deployment.v1.WorkerDeploymentVersionSummary.routing_update_time:type_name -> google.protobuf.Timestamp
	88,  // 27: temporal.server.api.deployment.v1.WorkerDeploymentVersionSummary.current_since_time:type_name -> google.protobuf.Timestamp
	88,  // 28: temporal.server.api.deployment.v1.WorkerDeploymentVersionSummary.ramping_since_time:type_name -> google.protobuf.Timestamp
	88,  // 29: temporal.server.api.deployment.v1.WorkerDeploymentVersionSummary.first_activation_time:type_name -> google.protobuf.Timestamp
	88,  // 30: temporal.server.api.deployment.v1.WorkerDeploymentVersionSummary.last_deactivation_time:type_name -> google.protobuf.Timestamp
	89,  // 31: temporal.server.api.deployment.v1.WorkerDeploymentVersionSummary.status:type_name -> temporal.api.enums.v1.WorkerDeploymentVersionStatus
	94,  // 32: temporal.server.api.deployment.v1.RegisterWorkerInVersionArgs.task_queue_type:type_name -> temporal.api.enums.v1.TaskQueueType
	92,  // 33: temporal.server.api.deployment.v1.RegisterWorkerInVersionArgs.routing_config:type_name -> temporal.api.deployment.v1.RoutingConfig
	94,  // 34: temporal.server.api.deployment.v1.RegisterWorkerInWorkerDeploymentArgs.task_queue_type:type_name -> temporal.api.enums.v1.TaskQueueType
	0,   // 35: temporal.server.api.deployment.v1.RegisterWorkerInWorkerDeploymentArgs.version:type_name -> temporal.server.api.deployment.v1.WorkerDeploymentVersion
	95,  // 36: temporal.server.api.deployment.v1.DescribeVersionFromWorkerDeploymentActivityResult.task_queue_infos:type_name -> temporal.api.deployment.v1.WorkerDeploymentVersionInfo.VersionTaskQueueInfo
	88,  // 37: temporal.server.api.deployment.v1.SyncVersionStateUpdateArgs.routing_update_time:type_name -> google.protobuf.Timestamp
	88,  // 38: temporal.server.api.deployment.v1.SyncVersionStateUpdateArgs.current_since_time:type_name -> google.protobuf.Timestamp
	88,  // 39: temporal.server.api.deployment.v1.SyncVersionStateUpdateArgs.ramping_since_time:type_name -> google.protobuf.Timestamp
	92,  // 40: temporal.server.api.deployment.v1.SyncVersionStateUpdateArgs.routing_config:type_name -> temporal.api.deployment.v1.RoutingConfig
	3,   // 41: temporal.server.api.deployment.v1.SyncVersionStateResponse.version_state:type_name -> temporal.server.api.deployment.v1.VersionLocalState
	9,   // 42: temporal.server.api.deployment.v1.SyncVersionStateResponse.summary:type_name -> temporal.server.api.deployment.v1.WorkerDeploymentVersionSummary
	88,  // 43: temporal.server.api.deployment.v1.AddVersionUpdateArgs.create_time:type_name -> google.protobuf.Timestamp
	90,  // 44: temporal.server.api.deployment.v1.SyncDrainageInfoSignalArgs.drainage_info:type_name -> temporal.api.deployment.v1.VersionDrainageInfo
	93,  // 45: temporal.server.api.deployment.v1.SyncDrainageStatusSignalArgs.drainage_status:type_name -> temporal.api.enums.v1.VersionDrainageStatus
	3,   // 46: temporal.server.api.deployment.v1.QueryDescribeVersionResponse.version_state:type_name -> temporal.server.api.deployment.v1.VersionLocalState
	7,   // 47: temporal.server.api.deployment.v1.QueryDescribeWorkerDeploymentResponse.state:type_name -> temporal.server.api.deployment.v1.WorkerDeploymentLocalState
	0,   // 48: temporal.server.api.deployment.v1.SyncDeploymentVersionUserDataRequest.version:type_name -> temporal.server.api.deployment.v1.WorkerDeploymentVersion
	73,  // 49: temporal.server.api.deployment.v1.SyncDeploymentVersionUserDataRequest.sync:type_name -> temporal.server.api.deployment.v1.SyncDeploymentVersionUserDataRequest.SyncUserData
	92,  // 50: temporal.server.api.deployment.v1.SyncDeploymentVersionUserDataRequest.update_routing_config:type_name -> temporal.api.deployment.v1.RoutingConfig
	2,   // 51: temporal.server.api.deployment.v1.SyncDeploymentVersionUserDataRequest.upsert_version_data:type_name -> temporal.server.api.deployment.v1.WorkerDeploymentVersionData
	74,  // 52: temporal.server.api.deployment.v1.SyncDeploymentVersionUserDataResponse.task_queue_max_versions:type_name -> temporal.server.api.deployment.v1.SyncDeploymentVersionUserDataResponse.TaskQueueMaxVersionsEntry
	75,  // 53: temporal.server.api.deployment.v1.CheckWorkerDeploymentUserDataPropagationRequest.task_queue_max_versions:type_name -> temporal.server.api.deployment.v1.CheckWorkerDeploymentUserDataPropagationRequest.TaskQueueMaxVersionsEntry
	14,  // 54: temporal.server.api.deployment.v1.SyncUnversionedRampActivityArgs.update_args:type_name -> temporal.server.api.deployment.v1.SyncVersionStateUpdateArgs
	76,  // 55: temporal.server.api.deployment.v1.SyncUnversionedRampActivityResponse.task_queue_max_versions:type_name -> temporal.server.api.deployment.v1.SyncUnversionedRampActivityResponse.TaskQueueMaxVersionsEntry
	77,  // 56: temporal.server.api.deployment.v1.UpdateVersionMetadataArgs.upsert_entries:type_name -> temporal.server.api.deployment.v1.UpdateVersionMetadataArgs.UpsertEntriesEntry
	91,  // 57: temporal.server.api.deployment.v1.UpdateVersionMetadataResponse.metadata:type_name -> temporal.api.deployment.v1.VersionMetadata
	78,  // 58: temporal.server.api.deployment.v1.CheckTaskQueuesHavePollersActivityArgs.task_queues_and_types:type_name -> temporal.server.api.deployment.v1.CheckTaskQueuesHavePollersActivityArgs.TaskQueuesAndTypesEntry
	0,   // 59: temporal.server.api.deployment.v1.CheckTaskQueuesHavePollersActivityArgs.worker_deployment_version:type_name -> temporal.server.api.deployment.v1.WorkerDeploymentVersion
	14,  // 60: temporal.server.api.deployment.v1.SyncVersionStateActivityArgs.update_args:type_name -> temporal.server.api.deployment.v1.SyncVersionStateUpdateArgs
	3,   // 61: temporal.server.api.deployment.v1.SyncVersionStateActivityResult.version_state:type_name -> temporal.server.api.deployment.v1.VersionLocalState
	9,   // 62: temporal.server.api.deployment.v1.SyncVersionStateActivityResult.summary:type_name -> temporal.server.api.deployment.v1.WorkerDeploymentVersionSummary
	88,  // 63: temporal.server.api.deployment.v1.WorkerDeploymentWorkflowMemo.create_time:type_name -> google.protobuf.Timestamp
	92,  // 64: temporal.server.api.deployment.v1.WorkerDeploymentWorkflowMemo.routing_config:type_name -> temporal.api.deployment.v1.RoutingConfig
	96,  // 65: temporal.server.api.deployment.v1.WorkerDeploymentWorkflowMemo.latest_version_summary:type_name -> temporal.api.deployment.v1.WorkerDeploymentInfo.WorkerDeploymentVersionSummary
	96,  // 66: temporal.server.api.deployment.v1.WorkerDeploymentWorkflowMemo.current_version_summary:type_name -> temporal.api.deployment.v1.WorkerDeploymentInfo.WorkerDeploymentVersionSummary
	96,  // 67: temporal.server.api.deployment.v1.WorkerDeploymentWorkflowMemo.ramping_version_summary:type_name -> temporal.api.deployment.v1.WorkerDeploymentInfo.WorkerDeploymentVersionSummary
	88,  // 68: temporal.server.api.deployment.v1.WorkerDeploymentSummary.create_time:type_name -> google.protobuf.Timestamp
	92,  // 69: temporal.server.api.deployment.v1.WorkerDeploymentSummary.routing_config:type_name -> temporal.api.deployment.v1.RoutingConfig
	96,  // 70: temporal.server.api.deployment.v1.WorkerDeploymentSummary.latest_version_summary:type_name -> temporal.api.deployment.v1.WorkerDeploymentInfo.WorkerDeploymentVersionSummary
	96,  // 71: temporal.server.api.deployment.v1.WorkerDeploymentSummary.current_version_summary:type_name -> temporal.api.deployment.v1.WorkerDeploymentInfo.WorkerDeploymentVersionSummary
	96,  // 72: temporal.server.api.deployment.v1.WorkerDeploymentSummary.ramping_version_summary:type_name -> temporal.api.deployment.v1.WorkerDeploymentInfo.WorkerDeploymentVersionSummary
	16,  // 73: temporal.server.api.deployment.v1.AddVersionToWorkerDeploymentRequest.update_args:type_name -> temporal.server.api.deployment.v1.AddVersionUpdateArgs
	88,  // 74: temporal.server.api.deployment.v1.TaskQueueData.first_poller_time:type_name -> google.protobuf.Timestamp
	88,  // 75: temporal.server.api.deployment.v1.TaskQueueData.last_became_current_time:type_name -> google.protobuf.Timestamp
	97,  // 76: temporal.server.api.deployment.v1.DeploymentLocalState.deployment:type_name -> temporal.api.deployment.v1.Deployment
	80,  // 77: temporal.server.api.deployment.v1.DeploymentLocalState.task_queue_families:type_name -> temporal.server.api.deployment.v1.DeploymentLocalState.TaskQueueFamiliesEntry
	88,  // 78: temporal.server.api.deployment.v1.DeploymentLocalState.last_became_current_time:type_name -> google.protobuf.Timestamp
	88,  // 79: temporal.server.api.deployment.v1.DeploymentLocalState.create_time:type_name -> google.protobuf.Timestamp
	81,  // 80: temporal.server.api.deployment.v1.DeploymentLocalState.metadata:type_name -> temporal.server.api.deployment.v1.DeploymentLocalState.MetadataEntry
	50,  // 81: temporal.server.api.deployment.v1.DeploymentWorkflowArgs.state:type_name -> temporal.server.api.deployment.v1.DeploymentLocalState
	53,  // 82: temporal.server.api.deployment.v1.DeploymentSeriesWorkflowArgs.state:type_name -> temporal.server.api.deployment.v1.SeriesLocalState
	88,  // 83: temporal.server.api.deployment.v1.SeriesLocalState.current_changed_time:type_name -> google.protobuf.Timestamp
	94,  // 84: temporal.server.api.deployment.v1.RegisterWorkerInDeploymentArgs.task_queue_type:type_name -> temporal.api.enums.v1.TaskQueueType
	88,  // 85: temporal.server.api.deployment.v1.RegisterWorkerInDeploymentArgs.first_poller_time:type_name -> google.protobuf.Timestamp
	84,  // 86: temporal.server.api.deployment.v1.SyncDeploymentStateArgs.set_current:type_name -> temporal.server.api.deployment.v1.SyncDeploymentStateArgs.SetCurrent
	98,  // 87: temporal.server.api.deployment.v1.SyncDeploymentStateArgs.update_metadata:type_name -> temporal.api.deployment.v1.UpdateDeploymentMetadata
	50,  // 88: temporal.server.api.deployment.v1.SyncDeploymentStateResponse.deployment_local_state:type_name -> temporal.server.api.deployment.v1.DeploymentLocalState
	50,  // 89: temporal.server.api.deployment.v1.QueryDescribeDeploymentResponse.deployment_local_state:type_name -> temporal.server.api.deployment.v1.DeploymentLocalState
	97,  // 90: temporal.server.api.deployment.v1.DeploymentWorkflowMemo.deployment:type_name -> temporal.api.deployment.v1.Deployment
	88,  // 91: temporal.server.api.deployment.v1.DeploymentWorkflowMemo.create_time:type_name -> google.protobuf.Timestamp
	97,  // 92: temporal.server.api.deployment.v1.SyncUserDataRequest.deployment:type_name -> temporal.api.deployment.v1.Deployment
	85,  // 93: temporal.server.api.deployment.v1.SyncUserDataRequest.sync:type_name -> temporal.server.api.deployment.v1.SyncUserDataRequest.SyncUserData
	86,  // 94: temporal.server.api.deployment.v1.SyncUserDataResponse.task_queue_max_versions:type_name -> temporal.server.api.deployment.v1.SyncUserDataResponse.TaskQueueMaxVersionsEntry
	87,  // 95: temporal.server.api.deployment.v1.CheckUserDataPropagationRequest.task_queue_max_versions:type_name -> temporal.server.api.deployment.v1.CheckUserDataPropagationRequest.TaskQueueMaxVersionsEntry
	98,  // 96: temporal.server.api.deployment.v1.SetCurrentDeploymentArgs.update_metadata:type_name -> temporal.api.deployment.v1.UpdateDeploymentMetadata
	50,  // 97: temporal.server.api.deployment.v1.SetCurrentDeploymentResponse.current_deployment_state:type_name -> temporal.server.api.deployment.v1.DeploymentLocalState
	50,  // 98: temporal.server.api.deployment.v1.SetCurrentDeploymentResponse.previous_deployment_state:type_name -> temporal.server.api.deployment.v1.DeploymentLocalState
	97,  // 99: temporal.server.api.deployment.v1.SyncDeploymentStateActivityArgs.deployment:type_name -> temporal.api.deployment.v1.Deployment
	55,  // 100: temporal.server.api.deployment.v1.SyncDeploymentStateActivityArgs.args:type_name -> temporal.server.api.deployment.v1.SyncDeploymentStateArgs
	50,  // 101: temporal.server.api.deployment.v1.SyncDeploymentStateActivityResult.state:type_name -> temporal.server.api.deployment.v1.DeploymentLocalState
	88,  // 102: temporal.server.api.deployment.v1.DeploymentSeriesWorkflowMemo.current_changed_time:type_name -> google.protobuf.Timestamp
	69,  // 103: temporal.server.api.deployment.v1.VersionLocalState.TaskQueueFamiliesEntry.value:type_name -> temporal.server.api.deployment.v1.VersionLocalState.TaskQueueFamilyData
	70,  // 104: temporal.server.api.deployment.v1.VersionLocalState.TaskQueueFamilyData.task_queues:type_name -> temporal.server.api.deployment.v1.VersionLocalState.TaskQueueFamilyData.TaskQueuesEntry
	4,   // 105: temporal.server.api.deployment.v1.VersionLocalState.TaskQueueFamilyData.TaskQueuesEntry.value:type_name -> temporal.server.api.deployment.v1.TaskQueueVersionData
	9,   // 106: temporal.server.api.deployment.v1.WorkerDeploymentLocalState.VersionsEntry.value:type_name -> temporal.server.api.deployment.v1.WorkerDeploymentVersionSummary
	8,   // 107: temporal.server.api.deployment.v1.WorkerDeploymentLocalState.PropagatingRevisionsEntry.value:type_name -> temporal.server.api.deployment.v1.PropagatingRevisions
	94,  // 108: temporal.server.api.deployment.v1.SyncDeploymentVersionUserDataRequest.SyncUserData.types:type_name -> temporal.api.enums.v1.TaskQueueType
	1,   // 109: temporal.server.api.deployment.v1.SyncDeploymentVersionUserDataRequest.SyncUserData.data:type_name -> temporal.server.api.deployment.v1.DeploymentVersionData
	99,  // 110: temporal.server.api.deployment.v1.UpdateVersionMetadataArgs.UpsertEntriesEntry.value:type_name -> temporal.api.common.v1.Payload
	79,  // 111: temporal.server.api.deployment.v1.CheckTaskQueuesHavePollersActivityArgs.TaskQueuesAndTypesEntry.value:type_name -> temporal.server.api.deployment.v1.CheckTaskQueuesHavePollersActivityArgs.TaskQueueTypes
	94,  // 112: temporal.server.api.deployment.v1.CheckTaskQueuesHavePollersActivityArgs.TaskQueueTypes.types:type_name -> temporal.api.enums.v1.TaskQueueType
	82,  // 113: temporal.server.api.deployment.v1.DeploymentLocalState.TaskQueueFamiliesEntry.value:type_name -> temporal.server.api.deployment.v1.DeploymentLocalState.TaskQueueFamilyData
	99,  // 114: temporal.server.api.deployment.v1.DeploymentLocalState.MetadataEntry.value:type_name -> temporal.api.common.v1.Payload
	83,  // 115: temporal.server.api.deployment.v1.DeploymentLocalState.TaskQueueFamilyData.task_queues:type_name -> temporal.server.api.deployment.v1.DeploymentLocalState.TaskQueueFamilyData.TaskQueuesEntry
	49,  // 116: temporal.server.api.deployment.v1.DeploymentLocalState.TaskQueueFamilyData.TaskQueuesEntry.value:type_name -> temporal.server.api.deployment.v1.TaskQueueData
	88,  // 117: temporal.server.api.deployment.v1.SyncDeploymentStateArgs.SetCurrent.last_became_current_time:type_name -> google.protobuf.Timestamp
	94,  // 118: temporal.server.api.deployment.v1.SyncUserDataRequest.SyncUserData.type:type_name -> temporal.api.enums.v1.TaskQueueType
	49,  // 119: temporal.server.api.deployment.v1.SyncUserDataRequest.SyncUserData.data:type_name -> temporal.server.api.deployment.v1.TaskQueueData
	120, // [120:120] is the sub-list for method output_type
	120, // [120:120] is the sub-list for method input_type
	120, // [120:120] is the sub-list for extension type_name
	120, // [120:120] is the sub-list for extension extendee
	0,   // [0:120] is the sub-list for field type_name
}

func init() { file_temporal_server_api_deployment_v1_message_proto_init() }
func file_temporal_server_api_deployment_v1_message_proto_init() {
	if File_temporal_server_api_deployment_v1_message_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_temporal_server_api_deployment_v1_message_proto_rawDesc), len(file_temporal_server_api_deployment_v1_message_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   88,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_temporal_server_api_deployment_v1_message_proto_goTypes,
		DependencyIndexes: file_temporal_server_api_deployment_v1_message_proto_depIdxs,
		MessageInfos:      file_temporal_server_api_deployment_v1_message_proto_msgTypes,
	}.Build()
	File_temporal_server_api_deployment_v1_message_proto = out.File
	file_temporal_server_api_deployment_v1_message_proto_goTypes = nil
	file_temporal_server_api_deployment_v1_message_proto_depIdxs = nil
}
