// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// plugins:
// - protoc-gen-go-grpc
// - protoc
// source: temporal/server/api/historyservice/v1/service.proto

package historyservice

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	HistoryService_StartWorkflowExecution_FullMethodName                 = "/temporal.server.api.historyservice.v1.HistoryService/StartWorkflowExecution"
	HistoryService_GetMutableState_FullMethodName                        = "/temporal.server.api.historyservice.v1.HistoryService/GetMutableState"
	HistoryService_PollMutableState_FullMethodName                       = "/temporal.server.api.historyservice.v1.HistoryService/PollMutableState"
	HistoryService_ResetStickyTaskQueue_FullMethodName                   = "/temporal.server.api.historyservice.v1.HistoryService/ResetStickyTaskQueue"
	HistoryService_RecordWorkflowTaskStarted_FullMethodName              = "/temporal.server.api.historyservice.v1.HistoryService/RecordWorkflowTaskStarted"
	HistoryService_RecordActivityTaskStarted_FullMethodName              = "/temporal.server.api.historyservice.v1.HistoryService/RecordActivityTaskStarted"
	HistoryService_RespondWorkflowTaskCompleted_FullMethodName           = "/temporal.server.api.historyservice.v1.HistoryService/RespondWorkflowTaskCompleted"
	HistoryService_RespondWorkflowTaskFailed_FullMethodName              = "/temporal.server.api.historyservice.v1.HistoryService/RespondWorkflowTaskFailed"
	HistoryService_IsWorkflowTaskValid_FullMethodName                    = "/temporal.server.api.historyservice.v1.HistoryService/IsWorkflowTaskValid"
	HistoryService_RecordActivityTaskHeartbeat_FullMethodName            = "/temporal.server.api.historyservice.v1.HistoryService/RecordActivityTaskHeartbeat"
	HistoryService_RespondActivityTaskCompleted_FullMethodName           = "/temporal.server.api.historyservice.v1.HistoryService/RespondActivityTaskCompleted"
	HistoryService_RespondActivityTaskFailed_FullMethodName              = "/temporal.server.api.historyservice.v1.HistoryService/RespondActivityTaskFailed"
	HistoryService_RespondActivityTaskCanceled_FullMethodName            = "/temporal.server.api.historyservice.v1.HistoryService/RespondActivityTaskCanceled"
	HistoryService_IsActivityTaskValid_FullMethodName                    = "/temporal.server.api.historyservice.v1.HistoryService/IsActivityTaskValid"
	HistoryService_SignalWorkflowExecution_FullMethodName                = "/temporal.server.api.historyservice.v1.HistoryService/SignalWorkflowExecution"
	HistoryService_SignalWithStartWorkflowExecution_FullMethodName       = "/temporal.server.api.historyservice.v1.HistoryService/SignalWithStartWorkflowExecution"
	HistoryService_ExecuteMultiOperation_FullMethodName                  = "/temporal.server.api.historyservice.v1.HistoryService/ExecuteMultiOperation"
	HistoryService_RemoveSignalMutableState_FullMethodName               = "/temporal.server.api.historyservice.v1.HistoryService/RemoveSignalMutableState"
	HistoryService_TerminateWorkflowExecution_FullMethodName             = "/temporal.server.api.historyservice.v1.HistoryService/TerminateWorkflowExecution"
	HistoryService_DeleteWorkflowExecution_FullMethodName                = "/temporal.server.api.historyservice.v1.HistoryService/DeleteWorkflowExecution"
	HistoryService_ResetWorkflowExecution_FullMethodName                 = "/temporal.server.api.historyservice.v1.HistoryService/ResetWorkflowExecution"
	HistoryService_UpdateWorkflowExecutionOptions_FullMethodName         = "/temporal.server.api.historyservice.v1.HistoryService/UpdateWorkflowExecutionOptions"
	HistoryService_RequestCancelWorkflowExecution_FullMethodName         = "/temporal.server.api.historyservice.v1.HistoryService/RequestCancelWorkflowExecution"
	HistoryService_ScheduleWorkflowTask_FullMethodName                   = "/temporal.server.api.historyservice.v1.HistoryService/ScheduleWorkflowTask"
	HistoryService_VerifyFirstWorkflowTaskScheduled_FullMethodName       = "/temporal.server.api.historyservice.v1.HistoryService/VerifyFirstWorkflowTaskScheduled"
	HistoryService_RecordChildExecutionCompleted_FullMethodName          = "/temporal.server.api.historyservice.v1.HistoryService/RecordChildExecutionCompleted"
	HistoryService_VerifyChildExecutionCompletionRecorded_FullMethodName = "/temporal.server.api.historyservice.v1.HistoryService/VerifyChildExecutionCompletionRecorded"
	HistoryService_DescribeWorkflowExecution_FullMethodName              = "/temporal.server.api.historyservice.v1.HistoryService/DescribeWorkflowExecution"
	HistoryService_ReplicateEventsV2_FullMethodName                      = "/temporal.server.api.historyservice.v1.HistoryService/ReplicateEventsV2"
	HistoryService_ReplicateWorkflowState_FullMethodName                 = "/temporal.server.api.historyservice.v1.HistoryService/ReplicateWorkflowState"
	HistoryService_SyncShardStatus_FullMethodName                        = "/temporal.server.api.historyservice.v1.HistoryService/SyncShardStatus"
	HistoryService_SyncActivity_FullMethodName                           = "/temporal.server.api.historyservice.v1.HistoryService/SyncActivity"
	HistoryService_DescribeMutableState_FullMethodName                   = "/temporal.server.api.historyservice.v1.HistoryService/DescribeMutableState"
	HistoryService_DescribeHistoryHost_FullMethodName                    = "/temporal.server.api.historyservice.v1.HistoryService/DescribeHistoryHost"
	HistoryService_CloseShard_FullMethodName                             = "/temporal.server.api.historyservice.v1.HistoryService/CloseShard"
	HistoryService_GetShard_FullMethodName                               = "/temporal.server.api.historyservice.v1.HistoryService/GetShard"
	HistoryService_RemoveTask_FullMethodName                             = "/temporal.server.api.historyservice.v1.HistoryService/RemoveTask"
	HistoryService_GetReplicationMessages_FullMethodName                 = "/temporal.server.api.historyservice.v1.HistoryService/GetReplicationMessages"
	HistoryService_GetDLQReplicationMessages_FullMethodName              = "/temporal.server.api.historyservice.v1.HistoryService/GetDLQReplicationMessages"
	HistoryService_QueryWorkflow_FullMethodName                          = "/temporal.server.api.historyservice.v1.HistoryService/QueryWorkflow"
	HistoryService_ReapplyEvents_FullMethodName                          = "/temporal.server.api.historyservice.v1.HistoryService/ReapplyEvents"
	HistoryService_GetDLQMessages_FullMethodName                         = "/temporal.server.api.historyservice.v1.HistoryService/GetDLQMessages"
	HistoryService_PurgeDLQMessages_FullMethodName                       = "/temporal.server.api.historyservice.v1.HistoryService/PurgeDLQMessages"
	HistoryService_MergeDLQMessages_FullMethodName                       = "/temporal.server.api.historyservice.v1.HistoryService/MergeDLQMessages"
	HistoryService_RefreshWorkflowTasks_FullMethodName                   = "/temporal.server.api.historyservice.v1.HistoryService/RefreshWorkflowTasks"
	HistoryService_GenerateLastHistoryReplicationTasks_FullMethodName    = "/temporal.server.api.historyservice.v1.HistoryService/GenerateLastHistoryReplicationTasks"
	HistoryService_GetReplicationStatus_FullMethodName                   = "/temporal.server.api.historyservice.v1.HistoryService/GetReplicationStatus"
	HistoryService_RebuildMutableState_FullMethodName                    = "/temporal.server.api.historyservice.v1.HistoryService/RebuildMutableState"
	HistoryService_ImportWorkflowExecution_FullMethodName                = "/temporal.server.api.historyservice.v1.HistoryService/ImportWorkflowExecution"
	HistoryService_DeleteWorkflowVisibilityRecord_FullMethodName         = "/temporal.server.api.historyservice.v1.HistoryService/DeleteWorkflowVisibilityRecord"
	HistoryService_UpdateWorkflowExecution_FullMethodName                = "/temporal.server.api.historyservice.v1.HistoryService/UpdateWorkflowExecution"
	HistoryService_PollWorkflowExecutionUpdate_FullMethodName            = "/temporal.server.api.historyservice.v1.HistoryService/PollWorkflowExecutionUpdate"
	HistoryService_StreamWorkflowReplicationMessages_FullMethodName      = "/temporal.server.api.historyservice.v1.HistoryService/StreamWorkflowReplicationMessages"
	HistoryService_GetWorkflowExecutionHistory_FullMethodName            = "/temporal.server.api.historyservice.v1.HistoryService/GetWorkflowExecutionHistory"
	HistoryService_GetWorkflowExecutionHistoryReverse_FullMethodName     = "/temporal.server.api.historyservice.v1.HistoryService/GetWorkflowExecutionHistoryReverse"
	HistoryService_GetWorkflowExecutionRawHistoryV2_FullMethodName       = "/temporal.server.api.historyservice.v1.HistoryService/GetWorkflowExecutionRawHistoryV2"
	HistoryService_GetWorkflowExecutionRawHistory_FullMethodName         = "/temporal.server.api.historyservice.v1.HistoryService/GetWorkflowExecutionRawHistory"
	HistoryService_ForceDeleteWorkflowExecution_FullMethodName           = "/temporal.server.api.historyservice.v1.HistoryService/ForceDeleteWorkflowExecution"
	HistoryService_GetDLQTasks_FullMethodName                            = "/temporal.server.api.historyservice.v1.HistoryService/GetDLQTasks"
	HistoryService_DeleteDLQTasks_FullMethodName                         = "/temporal.server.api.historyservice.v1.HistoryService/DeleteDLQTasks"
	HistoryService_ListQueues_FullMethodName                             = "/temporal.server.api.historyservice.v1.HistoryService/ListQueues"
	HistoryService_AddTasks_FullMethodName                               = "/temporal.server.api.historyservice.v1.HistoryService/AddTasks"
	HistoryService_ListTasks_FullMethodName                              = "/temporal.server.api.historyservice.v1.HistoryService/ListTasks"
	HistoryService_CompleteNexusOperation_FullMethodName                 = "/temporal.server.api.historyservice.v1.HistoryService/CompleteNexusOperation"
	HistoryService_CompleteNexusOperationChasm_FullMethodName            = "/temporal.server.api.historyservice.v1.HistoryService/CompleteNexusOperationChasm"
	HistoryService_InvokeStateMachineMethod_FullMethodName               = "/temporal.server.api.historyservice.v1.HistoryService/InvokeStateMachineMethod"
	HistoryService_DeepHealthCheck_FullMethodName                        = "/temporal.server.api.historyservice.v1.HistoryService/DeepHealthCheck"
	HistoryService_SyncWorkflowState_FullMethodName                      = "/temporal.server.api.historyservice.v1.HistoryService/SyncWorkflowState"
	HistoryService_UpdateActivityOptions_FullMethodName                  = "/temporal.server.api.historyservice.v1.HistoryService/UpdateActivityOptions"
	HistoryService_PauseActivity_FullMethodName                          = "/temporal.server.api.historyservice.v1.HistoryService/PauseActivity"
	HistoryService_UnpauseActivity_FullMethodName                        = "/temporal.server.api.historyservice.v1.HistoryService/UnpauseActivity"
	HistoryService_ResetActivity_FullMethodName                          = "/temporal.server.api.historyservice.v1.HistoryService/ResetActivity"
	HistoryService_PauseWorkflowExecution_FullMethodName                 = "/temporal.server.api.historyservice.v1.HistoryService/PauseWorkflowExecution"
	HistoryService_UnpauseWorkflowExecution_FullMethodName               = "/temporal.server.api.historyservice.v1.HistoryService/UnpauseWorkflowExecution"
)

// HistoryServiceClient is the client API for HistoryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type HistoryServiceClient interface {
	// StartWorkflowExecution starts a new long running workflow instance.  It will create the instance with
	// 'WorkflowExecutionStarted' event in history and also schedule the first WorkflowTask for the worker to produce the
	// initial list of commands for this instance.  It will return 'WorkflowExecutionAlreadyStartedError', if an instance already
	// exists with same workflowId.
	StartWorkflowExecution(ctx context.Context, in *StartWorkflowExecutionRequest, opts ...grpc.CallOption) (*StartWorkflowExecutionResponse, error)
	// Returns the information from mutable state of workflow execution.
	// It fails with 'EntityNotExistError' if specified workflow execution in unknown to the service.
	// It returns CurrentBranchChangedError if the workflow version branch has changed.
	GetMutableState(ctx context.Context, in *GetMutableStateRequest, opts ...grpc.CallOption) (*GetMutableStateResponse, error)
	// Returns the information from mutable state of workflow execution.
	// It fails with 'EntityNotExistError' if specified workflow execution in unknown to the service.
	// It returns CurrentBranchChangedError if the workflow version branch has changed.
	PollMutableState(ctx context.Context, in *PollMutableStateRequest, opts ...grpc.CallOption) (*PollMutableStateResponse, error)
	// Reset the sticky task queue related information in mutable state of a given workflow.
	// Things cleared are:
	// 1. StickyTaskQueue
	// 2. StickyScheduleToStartTimeout
	ResetStickyTaskQueue(ctx context.Context, in *ResetStickyTaskQueueRequest, opts ...grpc.CallOption) (*ResetStickyTaskQueueResponse, error)
	// RecordWorkflowTaskStarted is called by the Matchingservice before it hands a workflow task to the application worker in response to
	// a PollWorkflowTaskQueue call. It records in the history the event that the workflow task has started. It will return 'TaskAlreadyStartedError',
	// if the workflow's execution history already includes a record of the event starting.
	RecordWorkflowTaskStarted(ctx context.Context, in *RecordWorkflowTaskStartedRequest, opts ...grpc.CallOption) (*RecordWorkflowTaskStartedResponse, error)
	// RecordActivityTaskStarted is called by the Matchingservice before it hands a workflow task to the application worker in response to
	// a PollActivityTaskQueue call. It records in the history the event that the workflow task has started. It will return 'TaskAlreadyStartedError',
	// if the workflow's execution history already includes a record of the event starting.
	RecordActivityTaskStarted(ctx context.Context, in *RecordActivityTaskStartedRequest, opts ...grpc.CallOption) (*RecordActivityTaskStartedResponse, error)
	// RespondWorkflowTaskCompleted is called by application worker to complete a WorkflowTask handed as a result of
	// 'PollWorkflowTaskQueue' API call.  Completing a WorkflowTask will result in new result in new commands for the
	// workflow execution and potentially new ActivityTasks created for correspondent commands. It will also create a
	// WorkflowTaskCompleted event in the history for that session.  Use the 'taskToken' provided as response of
	// PollWorkflowTaskQueue API call for completing the WorkflowTask.
	RespondWorkflowTaskCompleted(ctx context.Context, in *RespondWorkflowTaskCompletedRequest, opts ...grpc.CallOption) (*RespondWorkflowTaskCompletedResponse, error)
	// RespondWorkflowTaskFailed is called by application worker to indicate failure.  This results in
	// WorkflowTaskFailedEvent written to the history and a new WorkflowTask created.  This API can be used by client to
	// either clear sticky task queue or report ny panics during WorkflowTask processing.
	RespondWorkflowTaskFailed(ctx context.Context, in *RespondWorkflowTaskFailedRequest, opts ...grpc.CallOption) (*RespondWorkflowTaskFailedResponse, error)
	// IsWorkflowTaskValid is called by matching service checking whether the workflow task is valid.
	IsWorkflowTaskValid(ctx context.Context, in *IsWorkflowTaskValidRequest, opts ...grpc.CallOption) (*IsWorkflowTaskValidResponse, error)
	// RecordActivityTaskHeartbeat is called by application worker while it is processing an ActivityTask.  If worker fails
	// to heartbeat within 'heartbeatTimeoutSeconds' interval for the ActivityTask, then it will be marked as timedout and
	// 'ActivityTaskTimedOut' event will be written to the workflow history.  Calling 'RecordActivityTaskHeartbeat' will
	// fail with 'EntityNotExistsError' in such situations.  Use the 'taskToken' provided as response of
	// PollActivityTaskQueue API call for heartbeating.
	RecordActivityTaskHeartbeat(ctx context.Context, in *RecordActivityTaskHeartbeatRequest, opts ...grpc.CallOption) (*RecordActivityTaskHeartbeatResponse, error)
	// RespondActivityTaskCompleted is called by application worker when it is done processing an ActivityTask.  It will
	// result in a new 'ActivityTaskCompleted' event being written to the workflow history and a new WorkflowTask
	// created for the workflow so new commands could be made.  Use the 'taskToken' provided as response of
	// PollActivityTaskQueue API call for completion. It fails with 'EntityNotExistsError' if the taskToken is not valid
	// anymore due to activity timeout.
	RespondActivityTaskCompleted(ctx context.Context, in *RespondActivityTaskCompletedRequest, opts ...grpc.CallOption) (*RespondActivityTaskCompletedResponse, error)
	// RespondActivityTaskFailed is called by application worker when it is done processing an ActivityTask.  It will
	// result in a new 'ActivityTaskFailed' event being written to the workflow history and a new WorkflowTask
	// created for the workflow instance so new commands could be made.  Use the 'taskToken' provided as response of
	// PollActivityTaskQueue API call for completion. It fails with 'EntityNotExistsError' if the taskToken is not valid
	// anymore due to activity timeout.
	RespondActivityTaskFailed(ctx context.Context, in *RespondActivityTaskFailedRequest, opts ...grpc.CallOption) (*RespondActivityTaskFailedResponse, error)
	// RespondActivityTaskCanceled is called by application worker when it is successfully canceled an ActivityTask.  It will
	// result in a new 'ActivityTaskCanceled' event being written to the workflow history and a new WorkflowTask
	// created for the workflow instance so new commands could be made.  Use the 'taskToken' provided as response of
	// PollActivityTaskQueue API call for completion. It fails with 'EntityNotExistsError' if the taskToken is not valid
	// anymore due to activity timeout.
	RespondActivityTaskCanceled(ctx context.Context, in *RespondActivityTaskCanceledRequest, opts ...grpc.CallOption) (*RespondActivityTaskCanceledResponse, error)
	// IsActivityTaskValid is called by matching service checking whether the workflow task is valid.
	IsActivityTaskValid(ctx context.Context, in *IsActivityTaskValidRequest, opts ...grpc.CallOption) (*IsActivityTaskValidResponse, error)
	// SignalWorkflowExecution is used to send a signal event to running workflow execution.  This results in
	// WorkflowExecutionSignaled event recorded in the history and a workflow task being created for the execution.
	SignalWorkflowExecution(ctx context.Context, in *SignalWorkflowExecutionRequest, opts ...grpc.CallOption) (*SignalWorkflowExecutionResponse, error)
	// (-- api-linter: core::0136::prepositions=disabled
	//
	//	aip.dev/not-precedent: "With" is needed here. --)
	//
	// SignalWithStartWorkflowExecution is used to ensure sending a signal event to a workflow execution.
	// If workflow is running, this results in WorkflowExecutionSignaled event recorded in the history
	// and a workflow task being created for the execution.
	// If workflow is not running or not found, it will first try start workflow with given WorkflowIdResuePolicy,
	// and record WorkflowExecutionStarted and WorkflowExecutionSignaled event in case of success.
	// It will return `WorkflowExecutionAlreadyStartedError` if start workflow failed with given policy.
	SignalWithStartWorkflowExecution(ctx context.Context, in *SignalWithStartWorkflowExecutionRequest, opts ...grpc.CallOption) (*SignalWithStartWorkflowExecutionResponse, error)
	// ExecuteMultiOperation executes multiple operations within a single workflow.
	ExecuteMultiOperation(ctx context.Context, in *ExecuteMultiOperationRequest, opts ...grpc.CallOption) (*ExecuteMultiOperationResponse, error)
	// RemoveSignalMutableState is used to remove a signal request Id that was previously recorded.  This is currently
	// used to clean execution info when signal workflow task finished.
	RemoveSignalMutableState(ctx context.Context, in *RemoveSignalMutableStateRequest, opts ...grpc.CallOption) (*RemoveSignalMutableStateResponse, error)
	// TerminateWorkflowExecution terminates an existing workflow execution by recording WorkflowExecutionTerminated event
	// in the history and immediately terminating the execution instance.
	TerminateWorkflowExecution(ctx context.Context, in *TerminateWorkflowExecutionRequest, opts ...grpc.CallOption) (*TerminateWorkflowExecutionResponse, error)
	// DeleteWorkflowExecution asynchronously deletes a specific Workflow Execution (when WorkflowExecution.run_id is
	// provided) or the latest Workflow Execution (when WorkflowExecution.run_id is not provided). If the Workflow
	// Execution is Running, it will be terminated before deletion.
	DeleteWorkflowExecution(ctx context.Context, in *DeleteWorkflowExecutionRequest, opts ...grpc.CallOption) (*DeleteWorkflowExecutionResponse, error)
	// ResetWorkflowExecution reset an existing workflow execution by a firstEventId of a existing event batch
	// in the history and immediately terminating the current execution instance.
	// After reset, the history will grow from nextFirstEventId.
	ResetWorkflowExecution(ctx context.Context, in *ResetWorkflowExecutionRequest, opts ...grpc.CallOption) (*ResetWorkflowExecutionResponse, error)
	// UpdateWorkflowExecutionOptions modifies the options of an existing workflow execution.
	// Currently the option that can be updated is setting and unsetting a versioning behavior override.
	// (-- api-linter: core::0134::method-signature=disabled
	// (-- api-linter: core::0134::response-message-name=disabled
	UpdateWorkflowExecutionOptions(ctx context.Context, in *UpdateWorkflowExecutionOptionsRequest, opts ...grpc.CallOption) (*UpdateWorkflowExecutionOptionsResponse, error)
	// RequestCancelWorkflowExecution is called by application worker when it wants to request cancellation of a workflow instance.
	// It will result in a new 'WorkflowExecutionCancelRequested' event being written to the workflow history and a new WorkflowTask
	// created for the workflow instance so new commands could be made. It fails with 'EntityNotExistsError' if the workflow is not valid
	// anymore due to completion or doesn't exist.
	RequestCancelWorkflowExecution(ctx context.Context, in *RequestCancelWorkflowExecutionRequest, opts ...grpc.CallOption) (*RequestCancelWorkflowExecutionResponse, error)
	// ScheduleWorkflowTask is used for creating a workflow task for already started workflow execution.  This is mainly
	// used by transfer queue processor during the processing of StartChildWorkflowExecution task, where it first starts
	// child execution without creating the workflow task and then calls this API after updating the mutable state of
	// parent execution.
	ScheduleWorkflowTask(ctx context.Context, in *ScheduleWorkflowTaskRequest, opts ...grpc.CallOption) (*ScheduleWorkflowTaskResponse, error)
	// VerifyFirstWorkflowTaskScheduled checks if workflow has its first workflow task scheduled.
	// This is only used by standby transfer start child workflow task logic to make sure parent workflow has
	// scheduled first workflow task in child after recording child started in its mutable state; otherwise,
	// during namespace failover, it's possible that none of the clusters will schedule the first workflow task.
	// NOTE: This is an experimental API. If later we found there are more verification API and there's a clear pattern
	// of how verification is done, we may unify them into one generic verfication API.
	VerifyFirstWorkflowTaskScheduled(ctx context.Context, in *VerifyFirstWorkflowTaskScheduledRequest, opts ...grpc.CallOption) (*VerifyFirstWorkflowTaskScheduledResponse, error)
	// RecordChildExecutionCompleted is used for reporting the completion of child workflow execution to parent.
	// This is mainly called by transfer queue processor during the processing of DeleteExecution task.
	RecordChildExecutionCompleted(ctx context.Context, in *RecordChildExecutionCompletedRequest, opts ...grpc.CallOption) (*RecordChildExecutionCompletedResponse, error)
	// VerifyChildExecutionCompletionRecorded checks if child completion result is recorded in parent workflow.
	// This is only used by standby transfer close execution logic to make sure parent workflow has the result
	// recorded before completing the task, otherwise during namespace failover, it's possible that none of the
	// clusters will record the child result in parent workflow.
	// NOTE: This is an experimental API. If later we found there are more verification API and there's a clear pattern
	// of how verification is done, we may unify them into one generic verfication API.
	VerifyChildExecutionCompletionRecorded(ctx context.Context, in *VerifyChildExecutionCompletionRecordedRequest, opts ...grpc.CallOption) (*VerifyChildExecutionCompletionRecordedResponse, error)
	// DescribeWorkflowExecution returns information about the specified workflow execution.
	DescribeWorkflowExecution(ctx context.Context, in *DescribeWorkflowExecutionRequest, opts ...grpc.CallOption) (*DescribeWorkflowExecutionResponse, error)
	// ReplicateEventsV2 replicates workflow history events
	ReplicateEventsV2(ctx context.Context, in *ReplicateEventsV2Request, opts ...grpc.CallOption) (*ReplicateEventsV2Response, error)
	// ReplicateWorkflowState replicates workflow state
	ReplicateWorkflowState(ctx context.Context, in *ReplicateWorkflowStateRequest, opts ...grpc.CallOption) (*ReplicateWorkflowStateResponse, error)
	// SyncShardStatus sync the status between shards.
	SyncShardStatus(ctx context.Context, in *SyncShardStatusRequest, opts ...grpc.CallOption) (*SyncShardStatusResponse, error)
	// SyncActivity sync the activity status.
	SyncActivity(ctx context.Context, in *SyncActivityRequest, opts ...grpc.CallOption) (*SyncActivityResponse, error)
	// DescribeMutableState returns information about the internal states of workflow mutable state.
	DescribeMutableState(ctx context.Context, in *DescribeMutableStateRequest, opts ...grpc.CallOption) (*DescribeMutableStateResponse, error)
	// DescribeHistoryHost returns information about the internal states of a history host.
	DescribeHistoryHost(ctx context.Context, in *DescribeHistoryHostRequest, opts ...grpc.CallOption) (*DescribeHistoryHostResponse, error)
	// CloseShard close the shard.
	CloseShard(ctx context.Context, in *CloseShardRequest, opts ...grpc.CallOption) (*CloseShardResponse, error)
	// GetShard gets the ShardInfo
	GetShard(ctx context.Context, in *GetShardRequest, opts ...grpc.CallOption) (*GetShardResponse, error)
	// RemoveTask remove task based on type, taskid, shardid.
	RemoveTask(ctx context.Context, in *RemoveTaskRequest, opts ...grpc.CallOption) (*RemoveTaskResponse, error)
	// GetReplicationMessages return replication messages based on the read level
	GetReplicationMessages(ctx context.Context, in *GetReplicationMessagesRequest, opts ...grpc.CallOption) (*GetReplicationMessagesResponse, error)
	// GetDLQReplicationMessages return replication messages based on dlq info
	GetDLQReplicationMessages(ctx context.Context, in *GetDLQReplicationMessagesRequest, opts ...grpc.CallOption) (*GetDLQReplicationMessagesResponse, error)
	// QueryWorkflow returns query result for a specified workflow execution.
	QueryWorkflow(ctx context.Context, in *QueryWorkflowRequest, opts ...grpc.CallOption) (*QueryWorkflowResponse, error)
	// ReapplyEvents applies stale events to the current workflow and current run.
	ReapplyEvents(ctx context.Context, in *ReapplyEventsRequest, opts ...grpc.CallOption) (*ReapplyEventsResponse, error)
	// GetDLQMessages returns messages from DLQ.
	GetDLQMessages(ctx context.Context, in *GetDLQMessagesRequest, opts ...grpc.CallOption) (*GetDLQMessagesResponse, error)
	// (-- api-linter: core::0165::response-message-name=disabled
	//
	//	aip.dev/not-precedent:  --)
	//
	// PurgeDLQMessages purges messages from DLQ.
	PurgeDLQMessages(ctx context.Context, in *PurgeDLQMessagesRequest, opts ...grpc.CallOption) (*PurgeDLQMessagesResponse, error)
	// MergeDLQMessages merges messages from DLQ.
	MergeDLQMessages(ctx context.Context, in *MergeDLQMessagesRequest, opts ...grpc.CallOption) (*MergeDLQMessagesResponse, error)
	// RefreshWorkflowTasks refreshes all tasks of a workflow.
	RefreshWorkflowTasks(ctx context.Context, in *RefreshWorkflowTasksRequest, opts ...grpc.CallOption) (*RefreshWorkflowTasksResponse, error)
	// GenerateLastHistoryReplicationTasks generate a replication task for last history event for requested workflow execution
	GenerateLastHistoryReplicationTasks(ctx context.Context, in *GenerateLastHistoryReplicationTasksRequest, opts ...grpc.CallOption) (*GenerateLastHistoryReplicationTasksResponse, error)
	GetReplicationStatus(ctx context.Context, in *GetReplicationStatusRequest, opts ...grpc.CallOption) (*GetReplicationStatusResponse, error)
	// RebuildMutableState attempts to rebuild mutable state according to persisted history events.
	// NOTE: this is experimental API
	RebuildMutableState(ctx context.Context, in *RebuildMutableStateRequest, opts ...grpc.CallOption) (*RebuildMutableStateResponse, error)
	// ImportWorkflowExecution attempts to import workflow according to persisted history events.
	// NOTE: this is experimental API
	ImportWorkflowExecution(ctx context.Context, in *ImportWorkflowExecutionRequest, opts ...grpc.CallOption) (*ImportWorkflowExecutionResponse, error)
	// DeleteWorkflowVisibilityRecord force delete a workflow's visibility record.
	// This is used by admin delete workflow execution API to delete visibility record as frontend
	// visibility manager doesn't support write operations
	DeleteWorkflowVisibilityRecord(ctx context.Context, in *DeleteWorkflowVisibilityRecordRequest, opts ...grpc.CallOption) (*DeleteWorkflowVisibilityRecordResponse, error)
	// (-- api-linter: core::0134=disabled
	//
	//	aip.dev/not-precedent: This service does not follow the update method API --)
	UpdateWorkflowExecution(ctx context.Context, in *UpdateWorkflowExecutionRequest, opts ...grpc.CallOption) (*UpdateWorkflowExecutionResponse, error)
	// (-- api-linter: core::0134=disabled
	//
	//	aip.dev/not-precedent: This service does not follow the update method API --)
	PollWorkflowExecutionUpdate(ctx context.Context, in *PollWorkflowExecutionUpdateRequest, opts ...grpc.CallOption) (*PollWorkflowExecutionUpdateResponse, error)
	StreamWorkflowReplicationMessages(ctx context.Context, opts ...grpc.CallOption) (HistoryService_StreamWorkflowReplicationMessagesClient, error)
	GetWorkflowExecutionHistory(ctx context.Context, in *GetWorkflowExecutionHistoryRequest, opts ...grpc.CallOption) (*GetWorkflowExecutionHistoryResponse, error)
	GetWorkflowExecutionHistoryReverse(ctx context.Context, in *GetWorkflowExecutionHistoryReverseRequest, opts ...grpc.CallOption) (*GetWorkflowExecutionHistoryReverseResponse, error)
	GetWorkflowExecutionRawHistoryV2(ctx context.Context, in *GetWorkflowExecutionRawHistoryV2Request, opts ...grpc.CallOption) (*GetWorkflowExecutionRawHistoryV2Response, error)
	GetWorkflowExecutionRawHistory(ctx context.Context, in *GetWorkflowExecutionRawHistoryRequest, opts ...grpc.CallOption) (*GetWorkflowExecutionRawHistoryResponse, error)
	ForceDeleteWorkflowExecution(ctx context.Context, in *ForceDeleteWorkflowExecutionRequest, opts ...grpc.CallOption) (*ForceDeleteWorkflowExecutionResponse, error)
	GetDLQTasks(ctx context.Context, in *GetDLQTasksRequest, opts ...grpc.CallOption) (*GetDLQTasksResponse, error)
	DeleteDLQTasks(ctx context.Context, in *DeleteDLQTasksRequest, opts ...grpc.CallOption) (*DeleteDLQTasksResponse, error)
	ListQueues(ctx context.Context, in *ListQueuesRequest, opts ...grpc.CallOption) (*ListQueuesResponse, error)
	// The AddTasks API is used to add history tasks to a shard. The first use-case for this API is the DLQ. When we are
	// unable to process history tasks, we add them to a DLQ. When they need to be retried, we take them out of the DLQ
	// and add them back using this API. We expose this via an API instead of doing this in the history engine because
	// replication tasks, which are DLQ'd on the target cluster need to be added back to the queue on the source
	// cluster, so there is already a network boundary. There is a maximum of 1000 tasks per request. There must be at
	// least one task per request. If any task in the list does not have the same shard ID as the request, the request
	// will fail with an InvalidArgument error. It is ok to have tasks for different workflow runs as long as they are
	// in the same shard. Calls to the persistence API will be batched by workflow run.
	AddTasks(ctx context.Context, in *AddTasksRequest, opts ...grpc.CallOption) (*AddTasksResponse, error)
	ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error)
	// Complete an async Nexus Operation using a completion token. The completion state could be successful, failed, or
	// canceled.
	//
	// Deprecated. Will be renamed to CompleteNexusOperationHsm in a future release.
	CompleteNexusOperation(ctx context.Context, in *CompleteNexusOperationRequest, opts ...grpc.CallOption) (*CompleteNexusOperationResponse, error)
	// Complete an async Nexus Operation using a CHASM reference. The completion
	// state could be successful, failed, or canceled.
	CompleteNexusOperationChasm(ctx context.Context, in *CompleteNexusOperationChasmRequest, opts ...grpc.CallOption) (*CompleteNexusOperationChasmResponse, error)
	InvokeStateMachineMethod(ctx context.Context, in *InvokeStateMachineMethodRequest, opts ...grpc.CallOption) (*InvokeStateMachineMethodResponse, error)
	// Deep health check history service dependencies health status
	DeepHealthCheck(ctx context.Context, in *DeepHealthCheckRequest, opts ...grpc.CallOption) (*DeepHealthCheckResponse, error)
	SyncWorkflowState(ctx context.Context, in *SyncWorkflowStateRequest, opts ...grpc.CallOption) (*SyncWorkflowStateResponse, error)
	// UpdateActivityOptions is called by the client to update the options of an activity
	// (-- api-linter: core::0134::method-signature=disabled
	// (-- api-linter: core::0134::response-message-name=disabled
	UpdateActivityOptions(ctx context.Context, in *UpdateActivityOptionsRequest, opts ...grpc.CallOption) (*UpdateActivityOptionsResponse, error)
	// PauseActivity pauses the execution of an activity specified by its ID.
	// Returns a `NotFound` error if there is no pending activity with the provided ID.
	//
	// Pausing an activity means:
	//   - If the activity is currently waiting for a retry or is running and subsequently fails,
	//     it will not be rescheduled until it is unpause.
	//   - If the activity is already paused, calling this method will have no effect.
	//   - If the activity is running and finishes successfully, the activity will be completed.
	//   - If the activity is running and finishes with failure:
	//   - if there is no retry left - the activity will be completed.
	//   - if there are more retries left - the activity will be paused.
	//
	// For long-running activities:
	// - activities in paused state will send a cancellation with "activity_paused" set to 'true' in response to 'RecordActivityTaskHeartbeat'.
	// - The activity should respond to the cancellation accordingly.
	// For long-running activities:
	// - activity in paused state will send a cancellation with "activity_paused" set to 'true' in response to 'RecordActivityTaskHeartbeat'.
	// - The activity should respond to the cancellation accordingly.
	// (-- api-linter: core::0134::method-signature=disabled
	// (-- api-linter: core::0134::response-message-name=disabled
	PauseActivity(ctx context.Context, in *PauseActivityRequest, opts ...grpc.CallOption) (*PauseActivityResponse, error)
	// UnpauseActivity unpauses the execution of an activity specified by its ID.
	//
	// If activity is not paused, this call will have no effect.
	// If the activity is waiting for retry, it will be scheduled immediately (* see 'jitter' flag).
	// Once the activity is unpause, all timeout timers will be regenerated.
	//
	// Flags:
	// 'jitter': the activity will be scheduled at a random time within the jitter duration.
	// 'reset_attempts': the number of attempts will be reset.
	// 'reset_heartbeat': the activity heartbeat timer and heartbeats will be reset.
	//
	// Returns a `NotFound` error if there is no pending activity with the provided ID.
	// (-- api-linter: core::0134::method-signature=disabled
	// (-- api-linter: core::0134::response-message-name=disabled
	UnpauseActivity(ctx context.Context, in *UnpauseActivityRequest, opts ...grpc.CallOption) (*UnpauseActivityResponse, error)
	// ResetActivity resets the execution of an activity specified by its ID.
	//
	// Resetting an activity means:
	//   - number of attempts will be reset to 0.
	//   - activity timeouts will be reset.
	//   - if the activity is waiting for retry, and it is not paused or 'keep_paused' is not provided:
	//     it will be scheduled immediately (* see 'jitter' flag),
	//
	// Flags:
	//
	// 'jitter': the activity will be scheduled at a random time within the jitter duration.
	// If the activity currently paused it will be unpause, unless 'keep_paused' flag is provided.
	// 'reset_heartbeats': the activity heartbeat timer and heartbeats will be reset.
	// 'keep_paused': if the activity is paused, it will remain paused.
	//
	// Returns a `NotFound` error if there is no pending activity with the provided ID.
	// (-- api-linter: core::0134::method-signature=disabled
	// (-- api-linter: core::0134::response-message-name=disabled
	ResetActivity(ctx context.Context, in *ResetActivityRequest, opts ...grpc.CallOption) (*ResetActivityResponse, error)
	// PauseWorkflowExecution pauses the workflow execution specified in the request.
	PauseWorkflowExecution(ctx context.Context, in *PauseWorkflowExecutionRequest, opts ...grpc.CallOption) (*PauseWorkflowExecutionResponse, error)
	// UnpauseWorkflowExecution unpauses the workflow execution specified in the request.
	UnpauseWorkflowExecution(ctx context.Context, in *UnpauseWorkflowExecutionRequest, opts ...grpc.CallOption) (*UnpauseWorkflowExecutionResponse, error)
}

type historyServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewHistoryServiceClient(cc grpc.ClientConnInterface) HistoryServiceClient {
	return &historyServiceClient{cc}
}

func (c *historyServiceClient) StartWorkflowExecution(ctx context.Context, in *StartWorkflowExecutionRequest, opts ...grpc.CallOption) (*StartWorkflowExecutionResponse, error) {
	out := new(StartWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, HistoryService_StartWorkflowExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) GetMutableState(ctx context.Context, in *GetMutableStateRequest, opts ...grpc.CallOption) (*GetMutableStateResponse, error) {
	out := new(GetMutableStateResponse)
	err := c.cc.Invoke(ctx, HistoryService_GetMutableState_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) PollMutableState(ctx context.Context, in *PollMutableStateRequest, opts ...grpc.CallOption) (*PollMutableStateResponse, error) {
	out := new(PollMutableStateResponse)
	err := c.cc.Invoke(ctx, HistoryService_PollMutableState_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) ResetStickyTaskQueue(ctx context.Context, in *ResetStickyTaskQueueRequest, opts ...grpc.CallOption) (*ResetStickyTaskQueueResponse, error) {
	out := new(ResetStickyTaskQueueResponse)
	err := c.cc.Invoke(ctx, HistoryService_ResetStickyTaskQueue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RecordWorkflowTaskStarted(ctx context.Context, in *RecordWorkflowTaskStartedRequest, opts ...grpc.CallOption) (*RecordWorkflowTaskStartedResponse, error) {
	out := new(RecordWorkflowTaskStartedResponse)
	err := c.cc.Invoke(ctx, HistoryService_RecordWorkflowTaskStarted_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RecordActivityTaskStarted(ctx context.Context, in *RecordActivityTaskStartedRequest, opts ...grpc.CallOption) (*RecordActivityTaskStartedResponse, error) {
	out := new(RecordActivityTaskStartedResponse)
	err := c.cc.Invoke(ctx, HistoryService_RecordActivityTaskStarted_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RespondWorkflowTaskCompleted(ctx context.Context, in *RespondWorkflowTaskCompletedRequest, opts ...grpc.CallOption) (*RespondWorkflowTaskCompletedResponse, error) {
	out := new(RespondWorkflowTaskCompletedResponse)
	err := c.cc.Invoke(ctx, HistoryService_RespondWorkflowTaskCompleted_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RespondWorkflowTaskFailed(ctx context.Context, in *RespondWorkflowTaskFailedRequest, opts ...grpc.CallOption) (*RespondWorkflowTaskFailedResponse, error) {
	out := new(RespondWorkflowTaskFailedResponse)
	err := c.cc.Invoke(ctx, HistoryService_RespondWorkflowTaskFailed_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) IsWorkflowTaskValid(ctx context.Context, in *IsWorkflowTaskValidRequest, opts ...grpc.CallOption) (*IsWorkflowTaskValidResponse, error) {
	out := new(IsWorkflowTaskValidResponse)
	err := c.cc.Invoke(ctx, HistoryService_IsWorkflowTaskValid_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RecordActivityTaskHeartbeat(ctx context.Context, in *RecordActivityTaskHeartbeatRequest, opts ...grpc.CallOption) (*RecordActivityTaskHeartbeatResponse, error) {
	out := new(RecordActivityTaskHeartbeatResponse)
	err := c.cc.Invoke(ctx, HistoryService_RecordActivityTaskHeartbeat_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RespondActivityTaskCompleted(ctx context.Context, in *RespondActivityTaskCompletedRequest, opts ...grpc.CallOption) (*RespondActivityTaskCompletedResponse, error) {
	out := new(RespondActivityTaskCompletedResponse)
	err := c.cc.Invoke(ctx, HistoryService_RespondActivityTaskCompleted_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RespondActivityTaskFailed(ctx context.Context, in *RespondActivityTaskFailedRequest, opts ...grpc.CallOption) (*RespondActivityTaskFailedResponse, error) {
	out := new(RespondActivityTaskFailedResponse)
	err := c.cc.Invoke(ctx, HistoryService_RespondActivityTaskFailed_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RespondActivityTaskCanceled(ctx context.Context, in *RespondActivityTaskCanceledRequest, opts ...grpc.CallOption) (*RespondActivityTaskCanceledResponse, error) {
	out := new(RespondActivityTaskCanceledResponse)
	err := c.cc.Invoke(ctx, HistoryService_RespondActivityTaskCanceled_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) IsActivityTaskValid(ctx context.Context, in *IsActivityTaskValidRequest, opts ...grpc.CallOption) (*IsActivityTaskValidResponse, error) {
	out := new(IsActivityTaskValidResponse)
	err := c.cc.Invoke(ctx, HistoryService_IsActivityTaskValid_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) SignalWorkflowExecution(ctx context.Context, in *SignalWorkflowExecutionRequest, opts ...grpc.CallOption) (*SignalWorkflowExecutionResponse, error) {
	out := new(SignalWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, HistoryService_SignalWorkflowExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) SignalWithStartWorkflowExecution(ctx context.Context, in *SignalWithStartWorkflowExecutionRequest, opts ...grpc.CallOption) (*SignalWithStartWorkflowExecutionResponse, error) {
	out := new(SignalWithStartWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, HistoryService_SignalWithStartWorkflowExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) ExecuteMultiOperation(ctx context.Context, in *ExecuteMultiOperationRequest, opts ...grpc.CallOption) (*ExecuteMultiOperationResponse, error) {
	out := new(ExecuteMultiOperationResponse)
	err := c.cc.Invoke(ctx, HistoryService_ExecuteMultiOperation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RemoveSignalMutableState(ctx context.Context, in *RemoveSignalMutableStateRequest, opts ...grpc.CallOption) (*RemoveSignalMutableStateResponse, error) {
	out := new(RemoveSignalMutableStateResponse)
	err := c.cc.Invoke(ctx, HistoryService_RemoveSignalMutableState_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) TerminateWorkflowExecution(ctx context.Context, in *TerminateWorkflowExecutionRequest, opts ...grpc.CallOption) (*TerminateWorkflowExecutionResponse, error) {
	out := new(TerminateWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, HistoryService_TerminateWorkflowExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) DeleteWorkflowExecution(ctx context.Context, in *DeleteWorkflowExecutionRequest, opts ...grpc.CallOption) (*DeleteWorkflowExecutionResponse, error) {
	out := new(DeleteWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, HistoryService_DeleteWorkflowExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) ResetWorkflowExecution(ctx context.Context, in *ResetWorkflowExecutionRequest, opts ...grpc.CallOption) (*ResetWorkflowExecutionResponse, error) {
	out := new(ResetWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, HistoryService_ResetWorkflowExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) UpdateWorkflowExecutionOptions(ctx context.Context, in *UpdateWorkflowExecutionOptionsRequest, opts ...grpc.CallOption) (*UpdateWorkflowExecutionOptionsResponse, error) {
	out := new(UpdateWorkflowExecutionOptionsResponse)
	err := c.cc.Invoke(ctx, HistoryService_UpdateWorkflowExecutionOptions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RequestCancelWorkflowExecution(ctx context.Context, in *RequestCancelWorkflowExecutionRequest, opts ...grpc.CallOption) (*RequestCancelWorkflowExecutionResponse, error) {
	out := new(RequestCancelWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, HistoryService_RequestCancelWorkflowExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) ScheduleWorkflowTask(ctx context.Context, in *ScheduleWorkflowTaskRequest, opts ...grpc.CallOption) (*ScheduleWorkflowTaskResponse, error) {
	out := new(ScheduleWorkflowTaskResponse)
	err := c.cc.Invoke(ctx, HistoryService_ScheduleWorkflowTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) VerifyFirstWorkflowTaskScheduled(ctx context.Context, in *VerifyFirstWorkflowTaskScheduledRequest, opts ...grpc.CallOption) (*VerifyFirstWorkflowTaskScheduledResponse, error) {
	out := new(VerifyFirstWorkflowTaskScheduledResponse)
	err := c.cc.Invoke(ctx, HistoryService_VerifyFirstWorkflowTaskScheduled_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RecordChildExecutionCompleted(ctx context.Context, in *RecordChildExecutionCompletedRequest, opts ...grpc.CallOption) (*RecordChildExecutionCompletedResponse, error) {
	out := new(RecordChildExecutionCompletedResponse)
	err := c.cc.Invoke(ctx, HistoryService_RecordChildExecutionCompleted_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) VerifyChildExecutionCompletionRecorded(ctx context.Context, in *VerifyChildExecutionCompletionRecordedRequest, opts ...grpc.CallOption) (*VerifyChildExecutionCompletionRecordedResponse, error) {
	out := new(VerifyChildExecutionCompletionRecordedResponse)
	err := c.cc.Invoke(ctx, HistoryService_VerifyChildExecutionCompletionRecorded_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) DescribeWorkflowExecution(ctx context.Context, in *DescribeWorkflowExecutionRequest, opts ...grpc.CallOption) (*DescribeWorkflowExecutionResponse, error) {
	out := new(DescribeWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, HistoryService_DescribeWorkflowExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) ReplicateEventsV2(ctx context.Context, in *ReplicateEventsV2Request, opts ...grpc.CallOption) (*ReplicateEventsV2Response, error) {
	out := new(ReplicateEventsV2Response)
	err := c.cc.Invoke(ctx, HistoryService_ReplicateEventsV2_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) ReplicateWorkflowState(ctx context.Context, in *ReplicateWorkflowStateRequest, opts ...grpc.CallOption) (*ReplicateWorkflowStateResponse, error) {
	out := new(ReplicateWorkflowStateResponse)
	err := c.cc.Invoke(ctx, HistoryService_ReplicateWorkflowState_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) SyncShardStatus(ctx context.Context, in *SyncShardStatusRequest, opts ...grpc.CallOption) (*SyncShardStatusResponse, error) {
	out := new(SyncShardStatusResponse)
	err := c.cc.Invoke(ctx, HistoryService_SyncShardStatus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) SyncActivity(ctx context.Context, in *SyncActivityRequest, opts ...grpc.CallOption) (*SyncActivityResponse, error) {
	out := new(SyncActivityResponse)
	err := c.cc.Invoke(ctx, HistoryService_SyncActivity_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) DescribeMutableState(ctx context.Context, in *DescribeMutableStateRequest, opts ...grpc.CallOption) (*DescribeMutableStateResponse, error) {
	out := new(DescribeMutableStateResponse)
	err := c.cc.Invoke(ctx, HistoryService_DescribeMutableState_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) DescribeHistoryHost(ctx context.Context, in *DescribeHistoryHostRequest, opts ...grpc.CallOption) (*DescribeHistoryHostResponse, error) {
	out := new(DescribeHistoryHostResponse)
	err := c.cc.Invoke(ctx, HistoryService_DescribeHistoryHost_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) CloseShard(ctx context.Context, in *CloseShardRequest, opts ...grpc.CallOption) (*CloseShardResponse, error) {
	out := new(CloseShardResponse)
	err := c.cc.Invoke(ctx, HistoryService_CloseShard_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) GetShard(ctx context.Context, in *GetShardRequest, opts ...grpc.CallOption) (*GetShardResponse, error) {
	out := new(GetShardResponse)
	err := c.cc.Invoke(ctx, HistoryService_GetShard_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RemoveTask(ctx context.Context, in *RemoveTaskRequest, opts ...grpc.CallOption) (*RemoveTaskResponse, error) {
	out := new(RemoveTaskResponse)
	err := c.cc.Invoke(ctx, HistoryService_RemoveTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) GetReplicationMessages(ctx context.Context, in *GetReplicationMessagesRequest, opts ...grpc.CallOption) (*GetReplicationMessagesResponse, error) {
	out := new(GetReplicationMessagesResponse)
	err := c.cc.Invoke(ctx, HistoryService_GetReplicationMessages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) GetDLQReplicationMessages(ctx context.Context, in *GetDLQReplicationMessagesRequest, opts ...grpc.CallOption) (*GetDLQReplicationMessagesResponse, error) {
	out := new(GetDLQReplicationMessagesResponse)
	err := c.cc.Invoke(ctx, HistoryService_GetDLQReplicationMessages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) QueryWorkflow(ctx context.Context, in *QueryWorkflowRequest, opts ...grpc.CallOption) (*QueryWorkflowResponse, error) {
	out := new(QueryWorkflowResponse)
	err := c.cc.Invoke(ctx, HistoryService_QueryWorkflow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) ReapplyEvents(ctx context.Context, in *ReapplyEventsRequest, opts ...grpc.CallOption) (*ReapplyEventsResponse, error) {
	out := new(ReapplyEventsResponse)
	err := c.cc.Invoke(ctx, HistoryService_ReapplyEvents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) GetDLQMessages(ctx context.Context, in *GetDLQMessagesRequest, opts ...grpc.CallOption) (*GetDLQMessagesResponse, error) {
	out := new(GetDLQMessagesResponse)
	err := c.cc.Invoke(ctx, HistoryService_GetDLQMessages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) PurgeDLQMessages(ctx context.Context, in *PurgeDLQMessagesRequest, opts ...grpc.CallOption) (*PurgeDLQMessagesResponse, error) {
	out := new(PurgeDLQMessagesResponse)
	err := c.cc.Invoke(ctx, HistoryService_PurgeDLQMessages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) MergeDLQMessages(ctx context.Context, in *MergeDLQMessagesRequest, opts ...grpc.CallOption) (*MergeDLQMessagesResponse, error) {
	out := new(MergeDLQMessagesResponse)
	err := c.cc.Invoke(ctx, HistoryService_MergeDLQMessages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RefreshWorkflowTasks(ctx context.Context, in *RefreshWorkflowTasksRequest, opts ...grpc.CallOption) (*RefreshWorkflowTasksResponse, error) {
	out := new(RefreshWorkflowTasksResponse)
	err := c.cc.Invoke(ctx, HistoryService_RefreshWorkflowTasks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) GenerateLastHistoryReplicationTasks(ctx context.Context, in *GenerateLastHistoryReplicationTasksRequest, opts ...grpc.CallOption) (*GenerateLastHistoryReplicationTasksResponse, error) {
	out := new(GenerateLastHistoryReplicationTasksResponse)
	err := c.cc.Invoke(ctx, HistoryService_GenerateLastHistoryReplicationTasks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) GetReplicationStatus(ctx context.Context, in *GetReplicationStatusRequest, opts ...grpc.CallOption) (*GetReplicationStatusResponse, error) {
	out := new(GetReplicationStatusResponse)
	err := c.cc.Invoke(ctx, HistoryService_GetReplicationStatus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) RebuildMutableState(ctx context.Context, in *RebuildMutableStateRequest, opts ...grpc.CallOption) (*RebuildMutableStateResponse, error) {
	out := new(RebuildMutableStateResponse)
	err := c.cc.Invoke(ctx, HistoryService_RebuildMutableState_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) ImportWorkflowExecution(ctx context.Context, in *ImportWorkflowExecutionRequest, opts ...grpc.CallOption) (*ImportWorkflowExecutionResponse, error) {
	out := new(ImportWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, HistoryService_ImportWorkflowExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) DeleteWorkflowVisibilityRecord(ctx context.Context, in *DeleteWorkflowVisibilityRecordRequest, opts ...grpc.CallOption) (*DeleteWorkflowVisibilityRecordResponse, error) {
	out := new(DeleteWorkflowVisibilityRecordResponse)
	err := c.cc.Invoke(ctx, HistoryService_DeleteWorkflowVisibilityRecord_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) UpdateWorkflowExecution(ctx context.Context, in *UpdateWorkflowExecutionRequest, opts ...grpc.CallOption) (*UpdateWorkflowExecutionResponse, error) {
	out := new(UpdateWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, HistoryService_UpdateWorkflowExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) PollWorkflowExecutionUpdate(ctx context.Context, in *PollWorkflowExecutionUpdateRequest, opts ...grpc.CallOption) (*PollWorkflowExecutionUpdateResponse, error) {
	out := new(PollWorkflowExecutionUpdateResponse)
	err := c.cc.Invoke(ctx, HistoryService_PollWorkflowExecutionUpdate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) StreamWorkflowReplicationMessages(ctx context.Context, opts ...grpc.CallOption) (HistoryService_StreamWorkflowReplicationMessagesClient, error) {
	stream, err := c.cc.NewStream(ctx, &HistoryService_ServiceDesc.Streams[0], HistoryService_StreamWorkflowReplicationMessages_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &historyServiceStreamWorkflowReplicationMessagesClient{stream}
	return x, nil
}

type HistoryService_StreamWorkflowReplicationMessagesClient interface {
	Send(*StreamWorkflowReplicationMessagesRequest) error
	Recv() (*StreamWorkflowReplicationMessagesResponse, error)
	grpc.ClientStream
}

type historyServiceStreamWorkflowReplicationMessagesClient struct {
	grpc.ClientStream
}

func (x *historyServiceStreamWorkflowReplicationMessagesClient) Send(m *StreamWorkflowReplicationMessagesRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *historyServiceStreamWorkflowReplicationMessagesClient) Recv() (*StreamWorkflowReplicationMessagesResponse, error) {
	m := new(StreamWorkflowReplicationMessagesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *historyServiceClient) GetWorkflowExecutionHistory(ctx context.Context, in *GetWorkflowExecutionHistoryRequest, opts ...grpc.CallOption) (*GetWorkflowExecutionHistoryResponse, error) {
	out := new(GetWorkflowExecutionHistoryResponse)
	err := c.cc.Invoke(ctx, HistoryService_GetWorkflowExecutionHistory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) GetWorkflowExecutionHistoryReverse(ctx context.Context, in *GetWorkflowExecutionHistoryReverseRequest, opts ...grpc.CallOption) (*GetWorkflowExecutionHistoryReverseResponse, error) {
	out := new(GetWorkflowExecutionHistoryReverseResponse)
	err := c.cc.Invoke(ctx, HistoryService_GetWorkflowExecutionHistoryReverse_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) GetWorkflowExecutionRawHistoryV2(ctx context.Context, in *GetWorkflowExecutionRawHistoryV2Request, opts ...grpc.CallOption) (*GetWorkflowExecutionRawHistoryV2Response, error) {
	out := new(GetWorkflowExecutionRawHistoryV2Response)
	err := c.cc.Invoke(ctx, HistoryService_GetWorkflowExecutionRawHistoryV2_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) GetWorkflowExecutionRawHistory(ctx context.Context, in *GetWorkflowExecutionRawHistoryRequest, opts ...grpc.CallOption) (*GetWorkflowExecutionRawHistoryResponse, error) {
	out := new(GetWorkflowExecutionRawHistoryResponse)
	err := c.cc.Invoke(ctx, HistoryService_GetWorkflowExecutionRawHistory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) ForceDeleteWorkflowExecution(ctx context.Context, in *ForceDeleteWorkflowExecutionRequest, opts ...grpc.CallOption) (*ForceDeleteWorkflowExecutionResponse, error) {
	out := new(ForceDeleteWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, HistoryService_ForceDeleteWorkflowExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) GetDLQTasks(ctx context.Context, in *GetDLQTasksRequest, opts ...grpc.CallOption) (*GetDLQTasksResponse, error) {
	out := new(GetDLQTasksResponse)
	err := c.cc.Invoke(ctx, HistoryService_GetDLQTasks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) DeleteDLQTasks(ctx context.Context, in *DeleteDLQTasksRequest, opts ...grpc.CallOption) (*DeleteDLQTasksResponse, error) {
	out := new(DeleteDLQTasksResponse)
	err := c.cc.Invoke(ctx, HistoryService_DeleteDLQTasks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) ListQueues(ctx context.Context, in *ListQueuesRequest, opts ...grpc.CallOption) (*ListQueuesResponse, error) {
	out := new(ListQueuesResponse)
	err := c.cc.Invoke(ctx, HistoryService_ListQueues_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) AddTasks(ctx context.Context, in *AddTasksRequest, opts ...grpc.CallOption) (*AddTasksResponse, error) {
	out := new(AddTasksResponse)
	err := c.cc.Invoke(ctx, HistoryService_AddTasks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error) {
	out := new(ListTasksResponse)
	err := c.cc.Invoke(ctx, HistoryService_ListTasks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) CompleteNexusOperation(ctx context.Context, in *CompleteNexusOperationRequest, opts ...grpc.CallOption) (*CompleteNexusOperationResponse, error) {
	out := new(CompleteNexusOperationResponse)
	err := c.cc.Invoke(ctx, HistoryService_CompleteNexusOperation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) CompleteNexusOperationChasm(ctx context.Context, in *CompleteNexusOperationChasmRequest, opts ...grpc.CallOption) (*CompleteNexusOperationChasmResponse, error) {
	out := new(CompleteNexusOperationChasmResponse)
	err := c.cc.Invoke(ctx, HistoryService_CompleteNexusOperationChasm_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) InvokeStateMachineMethod(ctx context.Context, in *InvokeStateMachineMethodRequest, opts ...grpc.CallOption) (*InvokeStateMachineMethodResponse, error) {
	out := new(InvokeStateMachineMethodResponse)
	err := c.cc.Invoke(ctx, HistoryService_InvokeStateMachineMethod_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) DeepHealthCheck(ctx context.Context, in *DeepHealthCheckRequest, opts ...grpc.CallOption) (*DeepHealthCheckResponse, error) {
	out := new(DeepHealthCheckResponse)
	err := c.cc.Invoke(ctx, HistoryService_DeepHealthCheck_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) SyncWorkflowState(ctx context.Context, in *SyncWorkflowStateRequest, opts ...grpc.CallOption) (*SyncWorkflowStateResponse, error) {
	out := new(SyncWorkflowStateResponse)
	err := c.cc.Invoke(ctx, HistoryService_SyncWorkflowState_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) UpdateActivityOptions(ctx context.Context, in *UpdateActivityOptionsRequest, opts ...grpc.CallOption) (*UpdateActivityOptionsResponse, error) {
	out := new(UpdateActivityOptionsResponse)
	err := c.cc.Invoke(ctx, HistoryService_UpdateActivityOptions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) PauseActivity(ctx context.Context, in *PauseActivityRequest, opts ...grpc.CallOption) (*PauseActivityResponse, error) {
	out := new(PauseActivityResponse)
	err := c.cc.Invoke(ctx, HistoryService_PauseActivity_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) UnpauseActivity(ctx context.Context, in *UnpauseActivityRequest, opts ...grpc.CallOption) (*UnpauseActivityResponse, error) {
	out := new(UnpauseActivityResponse)
	err := c.cc.Invoke(ctx, HistoryService_UnpauseActivity_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) ResetActivity(ctx context.Context, in *ResetActivityRequest, opts ...grpc.CallOption) (*ResetActivityResponse, error) {
	out := new(ResetActivityResponse)
	err := c.cc.Invoke(ctx, HistoryService_ResetActivity_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) PauseWorkflowExecution(ctx context.Context, in *PauseWorkflowExecutionRequest, opts ...grpc.CallOption) (*PauseWorkflowExecutionResponse, error) {
	out := new(PauseWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, HistoryService_PauseWorkflowExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *historyServiceClient) UnpauseWorkflowExecution(ctx context.Context, in *UnpauseWorkflowExecutionRequest, opts ...grpc.CallOption) (*UnpauseWorkflowExecutionResponse, error) {
	out := new(UnpauseWorkflowExecutionResponse)
	err := c.cc.Invoke(ctx, HistoryService_UnpauseWorkflowExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HistoryServiceServer is the server API for HistoryService service.
// All implementations must embed UnimplementedHistoryServiceServer
// for forward compatibility
type HistoryServiceServer interface {
	// StartWorkflowExecution starts a new long running workflow instance.  It will create the instance with
	// 'WorkflowExecutionStarted' event in history and also schedule the first WorkflowTask for the worker to produce the
	// initial list of commands for this instance.  It will return 'WorkflowExecutionAlreadyStartedError', if an instance already
	// exists with same workflowId.
	StartWorkflowExecution(context.Context, *StartWorkflowExecutionRequest) (*StartWorkflowExecutionResponse, error)
	// Returns the information from mutable state of workflow execution.
	// It fails with 'EntityNotExistError' if specified workflow execution in unknown to the service.
	// It returns CurrentBranchChangedError if the workflow version branch has changed.
	GetMutableState(context.Context, *GetMutableStateRequest) (*GetMutableStateResponse, error)
	// Returns the information from mutable state of workflow execution.
	// It fails with 'EntityNotExistError' if specified workflow execution in unknown to the service.
	// It returns CurrentBranchChangedError if the workflow version branch has changed.
	PollMutableState(context.Context, *PollMutableStateRequest) (*PollMutableStateResponse, error)
	// Reset the sticky task queue related information in mutable state of a given workflow.
	// Things cleared are:
	// 1. StickyTaskQueue
	// 2. StickyScheduleToStartTimeout
	ResetStickyTaskQueue(context.Context, *ResetStickyTaskQueueRequest) (*ResetStickyTaskQueueResponse, error)
	// RecordWorkflowTaskStarted is called by the Matchingservice before it hands a workflow task to the application worker in response to
	// a PollWorkflowTaskQueue call. It records in the history the event that the workflow task has started. It will return 'TaskAlreadyStartedError',
	// if the workflow's execution history already includes a record of the event starting.
	RecordWorkflowTaskStarted(context.Context, *RecordWorkflowTaskStartedRequest) (*RecordWorkflowTaskStartedResponseWithRawHistory, error)
	// RecordActivityTaskStarted is called by the Matchingservice before it hands a workflow task to the application worker in response to
	// a PollActivityTaskQueue call. It records in the history the event that the workflow task has started. It will return 'TaskAlreadyStartedError',
	// if the workflow's execution history already includes a record of the event starting.
	RecordActivityTaskStarted(context.Context, *RecordActivityTaskStartedRequest) (*RecordActivityTaskStartedResponse, error)
	// RespondWorkflowTaskCompleted is called by application worker to complete a WorkflowTask handed as a result of
	// 'PollWorkflowTaskQueue' API call.  Completing a WorkflowTask will result in new result in new commands for the
	// workflow execution and potentially new ActivityTasks created for correspondent commands. It will also create a
	// WorkflowTaskCompleted event in the history for that session.  Use the 'taskToken' provided as response of
	// PollWorkflowTaskQueue API call for completing the WorkflowTask.
	RespondWorkflowTaskCompleted(context.Context, *RespondWorkflowTaskCompletedRequest) (*RespondWorkflowTaskCompletedResponse, error)
	// RespondWorkflowTaskFailed is called by application worker to indicate failure.  This results in
	// WorkflowTaskFailedEvent written to the history and a new WorkflowTask created.  This API can be used by client to
	// either clear sticky task queue or report ny panics during WorkflowTask processing.
	RespondWorkflowTaskFailed(context.Context, *RespondWorkflowTaskFailedRequest) (*RespondWorkflowTaskFailedResponse, error)
	// IsWorkflowTaskValid is called by matching service checking whether the workflow task is valid.
	IsWorkflowTaskValid(context.Context, *IsWorkflowTaskValidRequest) (*IsWorkflowTaskValidResponse, error)
	// RecordActivityTaskHeartbeat is called by application worker while it is processing an ActivityTask.  If worker fails
	// to heartbeat within 'heartbeatTimeoutSeconds' interval for the ActivityTask, then it will be marked as timedout and
	// 'ActivityTaskTimedOut' event will be written to the workflow history.  Calling 'RecordActivityTaskHeartbeat' will
	// fail with 'EntityNotExistsError' in such situations.  Use the 'taskToken' provided as response of
	// PollActivityTaskQueue API call for heartbeating.
	RecordActivityTaskHeartbeat(context.Context, *RecordActivityTaskHeartbeatRequest) (*RecordActivityTaskHeartbeatResponse, error)
	// RespondActivityTaskCompleted is called by application worker when it is done processing an ActivityTask.  It will
	// result in a new 'ActivityTaskCompleted' event being written to the workflow history and a new WorkflowTask
	// created for the workflow so new commands could be made.  Use the 'taskToken' provided as response of
	// PollActivityTaskQueue API call for completion. It fails with 'EntityNotExistsError' if the taskToken is not valid
	// anymore due to activity timeout.
	RespondActivityTaskCompleted(context.Context, *RespondActivityTaskCompletedRequest) (*RespondActivityTaskCompletedResponse, error)
	// RespondActivityTaskFailed is called by application worker when it is done processing an ActivityTask.  It will
	// result in a new 'ActivityTaskFailed' event being written to the workflow history and a new WorkflowTask
	// created for the workflow instance so new commands could be made.  Use the 'taskToken' provided as response of
	// PollActivityTaskQueue API call for completion. It fails with 'EntityNotExistsError' if the taskToken is not valid
	// anymore due to activity timeout.
	RespondActivityTaskFailed(context.Context, *RespondActivityTaskFailedRequest) (*RespondActivityTaskFailedResponse, error)
	// RespondActivityTaskCanceled is called by application worker when it is successfully canceled an ActivityTask.  It will
	// result in a new 'ActivityTaskCanceled' event being written to the workflow history and a new WorkflowTask
	// created for the workflow instance so new commands could be made.  Use the 'taskToken' provided as response of
	// PollActivityTaskQueue API call for completion. It fails with 'EntityNotExistsError' if the taskToken is not valid
	// anymore due to activity timeout.
	RespondActivityTaskCanceled(context.Context, *RespondActivityTaskCanceledRequest) (*RespondActivityTaskCanceledResponse, error)
	// IsActivityTaskValid is called by matching service checking whether the workflow task is valid.
	IsActivityTaskValid(context.Context, *IsActivityTaskValidRequest) (*IsActivityTaskValidResponse, error)
	// SignalWorkflowExecution is used to send a signal event to running workflow execution.  This results in
	// WorkflowExecutionSignaled event recorded in the history and a workflow task being created for the execution.
	SignalWorkflowExecution(context.Context, *SignalWorkflowExecutionRequest) (*SignalWorkflowExecutionResponse, error)
	// (-- api-linter: core::0136::prepositions=disabled
	//
	//	aip.dev/not-precedent: "With" is needed here. --)
	//
	// SignalWithStartWorkflowExecution is used to ensure sending a signal event to a workflow execution.
	// If workflow is running, this results in WorkflowExecutionSignaled event recorded in the history
	// and a workflow task being created for the execution.
	// If workflow is not running or not found, it will first try start workflow with given WorkflowIdResuePolicy,
	// and record WorkflowExecutionStarted and WorkflowExecutionSignaled event in case of success.
	// It will return `WorkflowExecutionAlreadyStartedError` if start workflow failed with given policy.
	SignalWithStartWorkflowExecution(context.Context, *SignalWithStartWorkflowExecutionRequest) (*SignalWithStartWorkflowExecutionResponse, error)
	// ExecuteMultiOperation executes multiple operations within a single workflow.
	ExecuteMultiOperation(context.Context, *ExecuteMultiOperationRequest) (*ExecuteMultiOperationResponse, error)
	// RemoveSignalMutableState is used to remove a signal request Id that was previously recorded.  This is currently
	// used to clean execution info when signal workflow task finished.
	RemoveSignalMutableState(context.Context, *RemoveSignalMutableStateRequest) (*RemoveSignalMutableStateResponse, error)
	// TerminateWorkflowExecution terminates an existing workflow execution by recording WorkflowExecutionTerminated event
	// in the history and immediately terminating the execution instance.
	TerminateWorkflowExecution(context.Context, *TerminateWorkflowExecutionRequest) (*TerminateWorkflowExecutionResponse, error)
	// DeleteWorkflowExecution asynchronously deletes a specific Workflow Execution (when WorkflowExecution.run_id is
	// provided) or the latest Workflow Execution (when WorkflowExecution.run_id is not provided). If the Workflow
	// Execution is Running, it will be terminated before deletion.
	DeleteWorkflowExecution(context.Context, *DeleteWorkflowExecutionRequest) (*DeleteWorkflowExecutionResponse, error)
	// ResetWorkflowExecution reset an existing workflow execution by a firstEventId of a existing event batch
	// in the history and immediately terminating the current execution instance.
	// After reset, the history will grow from nextFirstEventId.
	ResetWorkflowExecution(context.Context, *ResetWorkflowExecutionRequest) (*ResetWorkflowExecutionResponse, error)
	// UpdateWorkflowExecutionOptions modifies the options of an existing workflow execution.
	// Currently the option that can be updated is setting and unsetting a versioning behavior override.
	// (-- api-linter: core::0134::method-signature=disabled
	// (-- api-linter: core::0134::response-message-name=disabled
	UpdateWorkflowExecutionOptions(context.Context, *UpdateWorkflowExecutionOptionsRequest) (*UpdateWorkflowExecutionOptionsResponse, error)
	// RequestCancelWorkflowExecution is called by application worker when it wants to request cancellation of a workflow instance.
	// It will result in a new 'WorkflowExecutionCancelRequested' event being written to the workflow history and a new WorkflowTask
	// created for the workflow instance so new commands could be made. It fails with 'EntityNotExistsError' if the workflow is not valid
	// anymore due to completion or doesn't exist.
	RequestCancelWorkflowExecution(context.Context, *RequestCancelWorkflowExecutionRequest) (*RequestCancelWorkflowExecutionResponse, error)
	// ScheduleWorkflowTask is used for creating a workflow task for already started workflow execution.  This is mainly
	// used by transfer queue processor during the processing of StartChildWorkflowExecution task, where it first starts
	// child execution without creating the workflow task and then calls this API after updating the mutable state of
	// parent execution.
	ScheduleWorkflowTask(context.Context, *ScheduleWorkflowTaskRequest) (*ScheduleWorkflowTaskResponse, error)
	// VerifyFirstWorkflowTaskScheduled checks if workflow has its first workflow task scheduled.
	// This is only used by standby transfer start child workflow task logic to make sure parent workflow has
	// scheduled first workflow task in child after recording child started in its mutable state; otherwise,
	// during namespace failover, it's possible that none of the clusters will schedule the first workflow task.
	// NOTE: This is an experimental API. If later we found there are more verification API and there's a clear pattern
	// of how verification is done, we may unify them into one generic verfication API.
	VerifyFirstWorkflowTaskScheduled(context.Context, *VerifyFirstWorkflowTaskScheduledRequest) (*VerifyFirstWorkflowTaskScheduledResponse, error)
	// RecordChildExecutionCompleted is used for reporting the completion of child workflow execution to parent.
	// This is mainly called by transfer queue processor during the processing of DeleteExecution task.
	RecordChildExecutionCompleted(context.Context, *RecordChildExecutionCompletedRequest) (*RecordChildExecutionCompletedResponse, error)
	// VerifyChildExecutionCompletionRecorded checks if child completion result is recorded in parent workflow.
	// This is only used by standby transfer close execution logic to make sure parent workflow has the result
	// recorded before completing the task, otherwise during namespace failover, it's possible that none of the
	// clusters will record the child result in parent workflow.
	// NOTE: This is an experimental API. If later we found there are more verification API and there's a clear pattern
	// of how verification is done, we may unify them into one generic verfication API.
	VerifyChildExecutionCompletionRecorded(context.Context, *VerifyChildExecutionCompletionRecordedRequest) (*VerifyChildExecutionCompletionRecordedResponse, error)
	// DescribeWorkflowExecution returns information about the specified workflow execution.
	DescribeWorkflowExecution(context.Context, *DescribeWorkflowExecutionRequest) (*DescribeWorkflowExecutionResponse, error)
	// ReplicateEventsV2 replicates workflow history events
	ReplicateEventsV2(context.Context, *ReplicateEventsV2Request) (*ReplicateEventsV2Response, error)
	// ReplicateWorkflowState replicates workflow state
	ReplicateWorkflowState(context.Context, *ReplicateWorkflowStateRequest) (*ReplicateWorkflowStateResponse, error)
	// SyncShardStatus sync the status between shards.
	SyncShardStatus(context.Context, *SyncShardStatusRequest) (*SyncShardStatusResponse, error)
	// SyncActivity sync the activity status.
	SyncActivity(context.Context, *SyncActivityRequest) (*SyncActivityResponse, error)
	// DescribeMutableState returns information about the internal states of workflow mutable state.
	DescribeMutableState(context.Context, *DescribeMutableStateRequest) (*DescribeMutableStateResponse, error)
	// DescribeHistoryHost returns information about the internal states of a history host.
	DescribeHistoryHost(context.Context, *DescribeHistoryHostRequest) (*DescribeHistoryHostResponse, error)
	// CloseShard close the shard.
	CloseShard(context.Context, *CloseShardRequest) (*CloseShardResponse, error)
	// GetShard gets the ShardInfo
	GetShard(context.Context, *GetShardRequest) (*GetShardResponse, error)
	// RemoveTask remove task based on type, taskid, shardid.
	RemoveTask(context.Context, *RemoveTaskRequest) (*RemoveTaskResponse, error)
	// GetReplicationMessages return replication messages based on the read level
	GetReplicationMessages(context.Context, *GetReplicationMessagesRequest) (*GetReplicationMessagesResponse, error)
	// GetDLQReplicationMessages return replication messages based on dlq info
	GetDLQReplicationMessages(context.Context, *GetDLQReplicationMessagesRequest) (*GetDLQReplicationMessagesResponse, error)
	// QueryWorkflow returns query result for a specified workflow execution.
	QueryWorkflow(context.Context, *QueryWorkflowRequest) (*QueryWorkflowResponse, error)
	// ReapplyEvents applies stale events to the current workflow and current run.
	ReapplyEvents(context.Context, *ReapplyEventsRequest) (*ReapplyEventsResponse, error)
	// GetDLQMessages returns messages from DLQ.
	GetDLQMessages(context.Context, *GetDLQMessagesRequest) (*GetDLQMessagesResponse, error)
	// (-- api-linter: core::0165::response-message-name=disabled
	//
	//	aip.dev/not-precedent:  --)
	//
	// PurgeDLQMessages purges messages from DLQ.
	PurgeDLQMessages(context.Context, *PurgeDLQMessagesRequest) (*PurgeDLQMessagesResponse, error)
	// MergeDLQMessages merges messages from DLQ.
	MergeDLQMessages(context.Context, *MergeDLQMessagesRequest) (*MergeDLQMessagesResponse, error)
	// RefreshWorkflowTasks refreshes all tasks of a workflow.
	RefreshWorkflowTasks(context.Context, *RefreshWorkflowTasksRequest) (*RefreshWorkflowTasksResponse, error)
	// GenerateLastHistoryReplicationTasks generate a replication task for last history event for requested workflow execution
	GenerateLastHistoryReplicationTasks(context.Context, *GenerateLastHistoryReplicationTasksRequest) (*GenerateLastHistoryReplicationTasksResponse, error)
	GetReplicationStatus(context.Context, *GetReplicationStatusRequest) (*GetReplicationStatusResponse, error)
	// RebuildMutableState attempts to rebuild mutable state according to persisted history events.
	// NOTE: this is experimental API
	RebuildMutableState(context.Context, *RebuildMutableStateRequest) (*RebuildMutableStateResponse, error)
	// ImportWorkflowExecution attempts to import workflow according to persisted history events.
	// NOTE: this is experimental API
	ImportWorkflowExecution(context.Context, *ImportWorkflowExecutionRequest) (*ImportWorkflowExecutionResponse, error)
	// DeleteWorkflowVisibilityRecord force delete a workflow's visibility record.
	// This is used by admin delete workflow execution API to delete visibility record as frontend
	// visibility manager doesn't support write operations
	DeleteWorkflowVisibilityRecord(context.Context, *DeleteWorkflowVisibilityRecordRequest) (*DeleteWorkflowVisibilityRecordResponse, error)
	// (-- api-linter: core::0134=disabled
	//
	//	aip.dev/not-precedent: This service does not follow the update method API --)
	UpdateWorkflowExecution(context.Context, *UpdateWorkflowExecutionRequest) (*UpdateWorkflowExecutionResponse, error)
	// (-- api-linter: core::0134=disabled
	//
	//	aip.dev/not-precedent: This service does not follow the update method API --)
	PollWorkflowExecutionUpdate(context.Context, *PollWorkflowExecutionUpdateRequest) (*PollWorkflowExecutionUpdateResponse, error)
	StreamWorkflowReplicationMessages(HistoryService_StreamWorkflowReplicationMessagesServer) error
	GetWorkflowExecutionHistory(context.Context, *GetWorkflowExecutionHistoryRequest) (*GetWorkflowExecutionHistoryResponseWithRaw, error)
	GetWorkflowExecutionHistoryReverse(context.Context, *GetWorkflowExecutionHistoryReverseRequest) (*GetWorkflowExecutionHistoryReverseResponse, error)
	GetWorkflowExecutionRawHistoryV2(context.Context, *GetWorkflowExecutionRawHistoryV2Request) (*GetWorkflowExecutionRawHistoryV2Response, error)
	GetWorkflowExecutionRawHistory(context.Context, *GetWorkflowExecutionRawHistoryRequest) (*GetWorkflowExecutionRawHistoryResponse, error)
	ForceDeleteWorkflowExecution(context.Context, *ForceDeleteWorkflowExecutionRequest) (*ForceDeleteWorkflowExecutionResponse, error)
	GetDLQTasks(context.Context, *GetDLQTasksRequest) (*GetDLQTasksResponse, error)
	DeleteDLQTasks(context.Context, *DeleteDLQTasksRequest) (*DeleteDLQTasksResponse, error)
	ListQueues(context.Context, *ListQueuesRequest) (*ListQueuesResponse, error)
	// The AddTasks API is used to add history tasks to a shard. The first use-case for this API is the DLQ. When we are
	// unable to process history tasks, we add them to a DLQ. When they need to be retried, we take them out of the DLQ
	// and add them back using this API. We expose this via an API instead of doing this in the history engine because
	// replication tasks, which are DLQ'd on the target cluster need to be added back to the queue on the source
	// cluster, so there is already a network boundary. There is a maximum of 1000 tasks per request. There must be at
	// least one task per request. If any task in the list does not have the same shard ID as the request, the request
	// will fail with an InvalidArgument error. It is ok to have tasks for different workflow runs as long as they are
	// in the same shard. Calls to the persistence API will be batched by workflow run.
	AddTasks(context.Context, *AddTasksRequest) (*AddTasksResponse, error)
	ListTasks(context.Context, *ListTasksRequest) (*ListTasksResponse, error)
	// Complete an async Nexus Operation using a completion token. The completion state could be successful, failed, or
	// canceled.
	//
	// Deprecated. Will be renamed to CompleteNexusOperationHsm in a future release.
	CompleteNexusOperation(context.Context, *CompleteNexusOperationRequest) (*CompleteNexusOperationResponse, error)
	// Complete an async Nexus Operation using a CHASM reference. The completion
	// state could be successful, failed, or canceled.
	CompleteNexusOperationChasm(context.Context, *CompleteNexusOperationChasmRequest) (*CompleteNexusOperationChasmResponse, error)
	InvokeStateMachineMethod(context.Context, *InvokeStateMachineMethodRequest) (*InvokeStateMachineMethodResponse, error)
	// Deep health check history service dependencies health status
	DeepHealthCheck(context.Context, *DeepHealthCheckRequest) (*DeepHealthCheckResponse, error)
	SyncWorkflowState(context.Context, *SyncWorkflowStateRequest) (*SyncWorkflowStateResponse, error)
	// UpdateActivityOptions is called by the client to update the options of an activity
	// (-- api-linter: core::0134::method-signature=disabled
	// (-- api-linter: core::0134::response-message-name=disabled
	UpdateActivityOptions(context.Context, *UpdateActivityOptionsRequest) (*UpdateActivityOptionsResponse, error)
	// PauseActivity pauses the execution of an activity specified by its ID.
	// Returns a `NotFound` error if there is no pending activity with the provided ID.
	//
	// Pausing an activity means:
	//   - If the activity is currently waiting for a retry or is running and subsequently fails,
	//     it will not be rescheduled until it is unpause.
	//   - If the activity is already paused, calling this method will have no effect.
	//   - If the activity is running and finishes successfully, the activity will be completed.
	//   - If the activity is running and finishes with failure:
	//   - if there is no retry left - the activity will be completed.
	//   - if there are more retries left - the activity will be paused.
	//
	// For long-running activities:
	// - activities in paused state will send a cancellation with "activity_paused" set to 'true' in response to 'RecordActivityTaskHeartbeat'.
	// - The activity should respond to the cancellation accordingly.
	// For long-running activities:
	// - activity in paused state will send a cancellation with "activity_paused" set to 'true' in response to 'RecordActivityTaskHeartbeat'.
	// - The activity should respond to the cancellation accordingly.
	// (-- api-linter: core::0134::method-signature=disabled
	// (-- api-linter: core::0134::response-message-name=disabled
	PauseActivity(context.Context, *PauseActivityRequest) (*PauseActivityResponse, error)
	// UnpauseActivity unpauses the execution of an activity specified by its ID.
	//
	// If activity is not paused, this call will have no effect.
	// If the activity is waiting for retry, it will be scheduled immediately (* see 'jitter' flag).
	// Once the activity is unpause, all timeout timers will be regenerated.
	//
	// Flags:
	// 'jitter': the activity will be scheduled at a random time within the jitter duration.
	// 'reset_attempts': the number of attempts will be reset.
	// 'reset_heartbeat': the activity heartbeat timer and heartbeats will be reset.
	//
	// Returns a `NotFound` error if there is no pending activity with the provided ID.
	// (-- api-linter: core::0134::method-signature=disabled
	// (-- api-linter: core::0134::response-message-name=disabled
	UnpauseActivity(context.Context, *UnpauseActivityRequest) (*UnpauseActivityResponse, error)
	// ResetActivity resets the execution of an activity specified by its ID.
	//
	// Resetting an activity means:
	//   - number of attempts will be reset to 0.
	//   - activity timeouts will be reset.
	//   - if the activity is waiting for retry, and it is not paused or 'keep_paused' is not provided:
	//     it will be scheduled immediately (* see 'jitter' flag),
	//
	// Flags:
	//
	// 'jitter': the activity will be scheduled at a random time within the jitter duration.
	// If the activity currently paused it will be unpause, unless 'keep_paused' flag is provided.
	// 'reset_heartbeats': the activity heartbeat timer and heartbeats will be reset.
	// 'keep_paused': if the activity is paused, it will remain paused.
	//
	// Returns a `NotFound` error if there is no pending activity with the provided ID.
	// (-- api-linter: core::0134::method-signature=disabled
	// (-- api-linter: core::0134::response-message-name=disabled
	ResetActivity(context.Context, *ResetActivityRequest) (*ResetActivityResponse, error)
	// PauseWorkflowExecution pauses the workflow execution specified in the request.
	PauseWorkflowExecution(context.Context, *PauseWorkflowExecutionRequest) (*PauseWorkflowExecutionResponse, error)
	// UnpauseWorkflowExecution unpauses the workflow execution specified in the request.
	UnpauseWorkflowExecution(context.Context, *UnpauseWorkflowExecutionRequest) (*UnpauseWorkflowExecutionResponse, error)
	mustEmbedUnimplementedHistoryServiceServer()
}

// UnimplementedHistoryServiceServer must be embedded to have forward compatible implementations.
type UnimplementedHistoryServiceServer struct {
}

func (UnimplementedHistoryServiceServer) StartWorkflowExecution(context.Context, *StartWorkflowExecutionRequest) (*StartWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartWorkflowExecution not implemented")
}
func (UnimplementedHistoryServiceServer) GetMutableState(context.Context, *GetMutableStateRequest) (*GetMutableStateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMutableState not implemented")
}
func (UnimplementedHistoryServiceServer) PollMutableState(context.Context, *PollMutableStateRequest) (*PollMutableStateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PollMutableState not implemented")
}
func (UnimplementedHistoryServiceServer) ResetStickyTaskQueue(context.Context, *ResetStickyTaskQueueRequest) (*ResetStickyTaskQueueResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetStickyTaskQueue not implemented")
}
func (UnimplementedHistoryServiceServer) RecordWorkflowTaskStarted(context.Context, *RecordWorkflowTaskStartedRequest) (*RecordWorkflowTaskStartedResponseWithRawHistory, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RecordWorkflowTaskStarted not implemented")
}
func (UnimplementedHistoryServiceServer) RecordActivityTaskStarted(context.Context, *RecordActivityTaskStartedRequest) (*RecordActivityTaskStartedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RecordActivityTaskStarted not implemented")
}
func (UnimplementedHistoryServiceServer) RespondWorkflowTaskCompleted(context.Context, *RespondWorkflowTaskCompletedRequest) (*RespondWorkflowTaskCompletedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RespondWorkflowTaskCompleted not implemented")
}
func (UnimplementedHistoryServiceServer) RespondWorkflowTaskFailed(context.Context, *RespondWorkflowTaskFailedRequest) (*RespondWorkflowTaskFailedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RespondWorkflowTaskFailed not implemented")
}
func (UnimplementedHistoryServiceServer) IsWorkflowTaskValid(context.Context, *IsWorkflowTaskValidRequest) (*IsWorkflowTaskValidResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsWorkflowTaskValid not implemented")
}
func (UnimplementedHistoryServiceServer) RecordActivityTaskHeartbeat(context.Context, *RecordActivityTaskHeartbeatRequest) (*RecordActivityTaskHeartbeatResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RecordActivityTaskHeartbeat not implemented")
}
func (UnimplementedHistoryServiceServer) RespondActivityTaskCompleted(context.Context, *RespondActivityTaskCompletedRequest) (*RespondActivityTaskCompletedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RespondActivityTaskCompleted not implemented")
}
func (UnimplementedHistoryServiceServer) RespondActivityTaskFailed(context.Context, *RespondActivityTaskFailedRequest) (*RespondActivityTaskFailedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RespondActivityTaskFailed not implemented")
}
func (UnimplementedHistoryServiceServer) RespondActivityTaskCanceled(context.Context, *RespondActivityTaskCanceledRequest) (*RespondActivityTaskCanceledResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RespondActivityTaskCanceled not implemented")
}
func (UnimplementedHistoryServiceServer) IsActivityTaskValid(context.Context, *IsActivityTaskValidRequest) (*IsActivityTaskValidResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsActivityTaskValid not implemented")
}
func (UnimplementedHistoryServiceServer) SignalWorkflowExecution(context.Context, *SignalWorkflowExecutionRequest) (*SignalWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SignalWorkflowExecution not implemented")
}
func (UnimplementedHistoryServiceServer) SignalWithStartWorkflowExecution(context.Context, *SignalWithStartWorkflowExecutionRequest) (*SignalWithStartWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SignalWithStartWorkflowExecution not implemented")
}
func (UnimplementedHistoryServiceServer) ExecuteMultiOperation(context.Context, *ExecuteMultiOperationRequest) (*ExecuteMultiOperationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExecuteMultiOperation not implemented")
}
func (UnimplementedHistoryServiceServer) RemoveSignalMutableState(context.Context, *RemoveSignalMutableStateRequest) (*RemoveSignalMutableStateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveSignalMutableState not implemented")
}
func (UnimplementedHistoryServiceServer) TerminateWorkflowExecution(context.Context, *TerminateWorkflowExecutionRequest) (*TerminateWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TerminateWorkflowExecution not implemented")
}
func (UnimplementedHistoryServiceServer) DeleteWorkflowExecution(context.Context, *DeleteWorkflowExecutionRequest) (*DeleteWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWorkflowExecution not implemented")
}
func (UnimplementedHistoryServiceServer) ResetWorkflowExecution(context.Context, *ResetWorkflowExecutionRequest) (*ResetWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetWorkflowExecution not implemented")
}
func (UnimplementedHistoryServiceServer) UpdateWorkflowExecutionOptions(context.Context, *UpdateWorkflowExecutionOptionsRequest) (*UpdateWorkflowExecutionOptionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWorkflowExecutionOptions not implemented")
}
func (UnimplementedHistoryServiceServer) RequestCancelWorkflowExecution(context.Context, *RequestCancelWorkflowExecutionRequest) (*RequestCancelWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RequestCancelWorkflowExecution not implemented")
}
func (UnimplementedHistoryServiceServer) ScheduleWorkflowTask(context.Context, *ScheduleWorkflowTaskRequest) (*ScheduleWorkflowTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ScheduleWorkflowTask not implemented")
}
func (UnimplementedHistoryServiceServer) VerifyFirstWorkflowTaskScheduled(context.Context, *VerifyFirstWorkflowTaskScheduledRequest) (*VerifyFirstWorkflowTaskScheduledResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method VerifyFirstWorkflowTaskScheduled not implemented")
}
func (UnimplementedHistoryServiceServer) RecordChildExecutionCompleted(context.Context, *RecordChildExecutionCompletedRequest) (*RecordChildExecutionCompletedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RecordChildExecutionCompleted not implemented")
}
func (UnimplementedHistoryServiceServer) VerifyChildExecutionCompletionRecorded(context.Context, *VerifyChildExecutionCompletionRecordedRequest) (*VerifyChildExecutionCompletionRecordedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method VerifyChildExecutionCompletionRecorded not implemented")
}
func (UnimplementedHistoryServiceServer) DescribeWorkflowExecution(context.Context, *DescribeWorkflowExecutionRequest) (*DescribeWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeWorkflowExecution not implemented")
}
func (UnimplementedHistoryServiceServer) ReplicateEventsV2(context.Context, *ReplicateEventsV2Request) (*ReplicateEventsV2Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplicateEventsV2 not implemented")
}
func (UnimplementedHistoryServiceServer) ReplicateWorkflowState(context.Context, *ReplicateWorkflowStateRequest) (*ReplicateWorkflowStateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplicateWorkflowState not implemented")
}
func (UnimplementedHistoryServiceServer) SyncShardStatus(context.Context, *SyncShardStatusRequest) (*SyncShardStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SyncShardStatus not implemented")
}
func (UnimplementedHistoryServiceServer) SyncActivity(context.Context, *SyncActivityRequest) (*SyncActivityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SyncActivity not implemented")
}
func (UnimplementedHistoryServiceServer) DescribeMutableState(context.Context, *DescribeMutableStateRequest) (*DescribeMutableStateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeMutableState not implemented")
}
func (UnimplementedHistoryServiceServer) DescribeHistoryHost(context.Context, *DescribeHistoryHostRequest) (*DescribeHistoryHostResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeHistoryHost not implemented")
}
func (UnimplementedHistoryServiceServer) CloseShard(context.Context, *CloseShardRequest) (*CloseShardResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CloseShard not implemented")
}
func (UnimplementedHistoryServiceServer) GetShard(context.Context, *GetShardRequest) (*GetShardResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetShard not implemented")
}
func (UnimplementedHistoryServiceServer) RemoveTask(context.Context, *RemoveTaskRequest) (*RemoveTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveTask not implemented")
}
func (UnimplementedHistoryServiceServer) GetReplicationMessages(context.Context, *GetReplicationMessagesRequest) (*GetReplicationMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReplicationMessages not implemented")
}
func (UnimplementedHistoryServiceServer) GetDLQReplicationMessages(context.Context, *GetDLQReplicationMessagesRequest) (*GetDLQReplicationMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDLQReplicationMessages not implemented")
}
func (UnimplementedHistoryServiceServer) QueryWorkflow(context.Context, *QueryWorkflowRequest) (*QueryWorkflowResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryWorkflow not implemented")
}
func (UnimplementedHistoryServiceServer) ReapplyEvents(context.Context, *ReapplyEventsRequest) (*ReapplyEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReapplyEvents not implemented")
}
func (UnimplementedHistoryServiceServer) GetDLQMessages(context.Context, *GetDLQMessagesRequest) (*GetDLQMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDLQMessages not implemented")
}
func (UnimplementedHistoryServiceServer) PurgeDLQMessages(context.Context, *PurgeDLQMessagesRequest) (*PurgeDLQMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeDLQMessages not implemented")
}
func (UnimplementedHistoryServiceServer) MergeDLQMessages(context.Context, *MergeDLQMessagesRequest) (*MergeDLQMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MergeDLQMessages not implemented")
}
func (UnimplementedHistoryServiceServer) RefreshWorkflowTasks(context.Context, *RefreshWorkflowTasksRequest) (*RefreshWorkflowTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RefreshWorkflowTasks not implemented")
}
func (UnimplementedHistoryServiceServer) GenerateLastHistoryReplicationTasks(context.Context, *GenerateLastHistoryReplicationTasksRequest) (*GenerateLastHistoryReplicationTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateLastHistoryReplicationTasks not implemented")
}
func (UnimplementedHistoryServiceServer) GetReplicationStatus(context.Context, *GetReplicationStatusRequest) (*GetReplicationStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReplicationStatus not implemented")
}
func (UnimplementedHistoryServiceServer) RebuildMutableState(context.Context, *RebuildMutableStateRequest) (*RebuildMutableStateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RebuildMutableState not implemented")
}
func (UnimplementedHistoryServiceServer) ImportWorkflowExecution(context.Context, *ImportWorkflowExecutionRequest) (*ImportWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportWorkflowExecution not implemented")
}
func (UnimplementedHistoryServiceServer) DeleteWorkflowVisibilityRecord(context.Context, *DeleteWorkflowVisibilityRecordRequest) (*DeleteWorkflowVisibilityRecordResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWorkflowVisibilityRecord not implemented")
}
func (UnimplementedHistoryServiceServer) UpdateWorkflowExecution(context.Context, *UpdateWorkflowExecutionRequest) (*UpdateWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWorkflowExecution not implemented")
}
func (UnimplementedHistoryServiceServer) PollWorkflowExecutionUpdate(context.Context, *PollWorkflowExecutionUpdateRequest) (*PollWorkflowExecutionUpdateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PollWorkflowExecutionUpdate not implemented")
}
func (UnimplementedHistoryServiceServer) StreamWorkflowReplicationMessages(HistoryService_StreamWorkflowReplicationMessagesServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamWorkflowReplicationMessages not implemented")
}
func (UnimplementedHistoryServiceServer) GetWorkflowExecutionHistory(context.Context, *GetWorkflowExecutionHistoryRequest) (*GetWorkflowExecutionHistoryResponseWithRaw, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkflowExecutionHistory not implemented")
}
func (UnimplementedHistoryServiceServer) GetWorkflowExecutionHistoryReverse(context.Context, *GetWorkflowExecutionHistoryReverseRequest) (*GetWorkflowExecutionHistoryReverseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkflowExecutionHistoryReverse not implemented")
}
func (UnimplementedHistoryServiceServer) GetWorkflowExecutionRawHistoryV2(context.Context, *GetWorkflowExecutionRawHistoryV2Request) (*GetWorkflowExecutionRawHistoryV2Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkflowExecutionRawHistoryV2 not implemented")
}
func (UnimplementedHistoryServiceServer) GetWorkflowExecutionRawHistory(context.Context, *GetWorkflowExecutionRawHistoryRequest) (*GetWorkflowExecutionRawHistoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkflowExecutionRawHistory not implemented")
}
func (UnimplementedHistoryServiceServer) ForceDeleteWorkflowExecution(context.Context, *ForceDeleteWorkflowExecutionRequest) (*ForceDeleteWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ForceDeleteWorkflowExecution not implemented")
}
func (UnimplementedHistoryServiceServer) GetDLQTasks(context.Context, *GetDLQTasksRequest) (*GetDLQTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDLQTasks not implemented")
}
func (UnimplementedHistoryServiceServer) DeleteDLQTasks(context.Context, *DeleteDLQTasksRequest) (*DeleteDLQTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDLQTasks not implemented")
}
func (UnimplementedHistoryServiceServer) ListQueues(context.Context, *ListQueuesRequest) (*ListQueuesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListQueues not implemented")
}
func (UnimplementedHistoryServiceServer) AddTasks(context.Context, *AddTasksRequest) (*AddTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddTasks not implemented")
}
func (UnimplementedHistoryServiceServer) ListTasks(context.Context, *ListTasksRequest) (*ListTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTasks not implemented")
}
func (UnimplementedHistoryServiceServer) CompleteNexusOperation(context.Context, *CompleteNexusOperationRequest) (*CompleteNexusOperationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CompleteNexusOperation not implemented")
}
func (UnimplementedHistoryServiceServer) CompleteNexusOperationChasm(context.Context, *CompleteNexusOperationChasmRequest) (*CompleteNexusOperationChasmResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CompleteNexusOperationChasm not implemented")
}
func (UnimplementedHistoryServiceServer) InvokeStateMachineMethod(context.Context, *InvokeStateMachineMethodRequest) (*InvokeStateMachineMethodResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InvokeStateMachineMethod not implemented")
}
func (UnimplementedHistoryServiceServer) DeepHealthCheck(context.Context, *DeepHealthCheckRequest) (*DeepHealthCheckResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeepHealthCheck not implemented")
}
func (UnimplementedHistoryServiceServer) SyncWorkflowState(context.Context, *SyncWorkflowStateRequest) (*SyncWorkflowStateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SyncWorkflowState not implemented")
}
func (UnimplementedHistoryServiceServer) UpdateActivityOptions(context.Context, *UpdateActivityOptionsRequest) (*UpdateActivityOptionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateActivityOptions not implemented")
}
func (UnimplementedHistoryServiceServer) PauseActivity(context.Context, *PauseActivityRequest) (*PauseActivityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PauseActivity not implemented")
}
func (UnimplementedHistoryServiceServer) UnpauseActivity(context.Context, *UnpauseActivityRequest) (*UnpauseActivityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UnpauseActivity not implemented")
}
func (UnimplementedHistoryServiceServer) ResetActivity(context.Context, *ResetActivityRequest) (*ResetActivityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetActivity not implemented")
}
func (UnimplementedHistoryServiceServer) PauseWorkflowExecution(context.Context, *PauseWorkflowExecutionRequest) (*PauseWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PauseWorkflowExecution not implemented")
}
func (UnimplementedHistoryServiceServer) UnpauseWorkflowExecution(context.Context, *UnpauseWorkflowExecutionRequest) (*UnpauseWorkflowExecutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UnpauseWorkflowExecution not implemented")
}
func (UnimplementedHistoryServiceServer) mustEmbedUnimplementedHistoryServiceServer() {}

// UnsafeHistoryServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to HistoryServiceServer will
// result in compilation errors.
type UnsafeHistoryServiceServer interface {
	mustEmbedUnimplementedHistoryServiceServer()
}

func RegisterHistoryServiceServer(s grpc.ServiceRegistrar, srv HistoryServiceServer) {
	s.RegisterService(&HistoryService_ServiceDesc, srv)
}

func _HistoryService_StartWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).StartWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_StartWorkflowExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).StartWorkflowExecution(ctx, req.(*StartWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_GetMutableState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMutableStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).GetMutableState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_GetMutableState_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).GetMutableState(ctx, req.(*GetMutableStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_PollMutableState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PollMutableStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).PollMutableState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_PollMutableState_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).PollMutableState(ctx, req.(*PollMutableStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_ResetStickyTaskQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetStickyTaskQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).ResetStickyTaskQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_ResetStickyTaskQueue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).ResetStickyTaskQueue(ctx, req.(*ResetStickyTaskQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RecordWorkflowTaskStarted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecordWorkflowTaskStartedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RecordWorkflowTaskStarted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_RecordWorkflowTaskStarted_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RecordWorkflowTaskStarted(ctx, req.(*RecordWorkflowTaskStartedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RecordActivityTaskStarted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecordActivityTaskStartedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RecordActivityTaskStarted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_RecordActivityTaskStarted_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RecordActivityTaskStarted(ctx, req.(*RecordActivityTaskStartedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RespondWorkflowTaskCompleted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RespondWorkflowTaskCompletedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RespondWorkflowTaskCompleted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_RespondWorkflowTaskCompleted_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RespondWorkflowTaskCompleted(ctx, req.(*RespondWorkflowTaskCompletedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RespondWorkflowTaskFailed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RespondWorkflowTaskFailedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RespondWorkflowTaskFailed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_RespondWorkflowTaskFailed_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RespondWorkflowTaskFailed(ctx, req.(*RespondWorkflowTaskFailedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_IsWorkflowTaskValid_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IsWorkflowTaskValidRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).IsWorkflowTaskValid(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_IsWorkflowTaskValid_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).IsWorkflowTaskValid(ctx, req.(*IsWorkflowTaskValidRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RecordActivityTaskHeartbeat_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecordActivityTaskHeartbeatRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RecordActivityTaskHeartbeat(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_RecordActivityTaskHeartbeat_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RecordActivityTaskHeartbeat(ctx, req.(*RecordActivityTaskHeartbeatRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RespondActivityTaskCompleted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RespondActivityTaskCompletedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RespondActivityTaskCompleted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_RespondActivityTaskCompleted_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RespondActivityTaskCompleted(ctx, req.(*RespondActivityTaskCompletedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RespondActivityTaskFailed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RespondActivityTaskFailedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RespondActivityTaskFailed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_RespondActivityTaskFailed_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RespondActivityTaskFailed(ctx, req.(*RespondActivityTaskFailedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RespondActivityTaskCanceled_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RespondActivityTaskCanceledRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RespondActivityTaskCanceled(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_RespondActivityTaskCanceled_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RespondActivityTaskCanceled(ctx, req.(*RespondActivityTaskCanceledRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_IsActivityTaskValid_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IsActivityTaskValidRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).IsActivityTaskValid(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_IsActivityTaskValid_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).IsActivityTaskValid(ctx, req.(*IsActivityTaskValidRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_SignalWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignalWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).SignalWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_SignalWorkflowExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).SignalWorkflowExecution(ctx, req.(*SignalWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_SignalWithStartWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignalWithStartWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).SignalWithStartWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_SignalWithStartWorkflowExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).SignalWithStartWorkflowExecution(ctx, req.(*SignalWithStartWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_ExecuteMultiOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteMultiOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).ExecuteMultiOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_ExecuteMultiOperation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).ExecuteMultiOperation(ctx, req.(*ExecuteMultiOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RemoveSignalMutableState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveSignalMutableStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RemoveSignalMutableState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_RemoveSignalMutableState_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RemoveSignalMutableState(ctx, req.(*RemoveSignalMutableStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_TerminateWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TerminateWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).TerminateWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_TerminateWorkflowExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).TerminateWorkflowExecution(ctx, req.(*TerminateWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_DeleteWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).DeleteWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_DeleteWorkflowExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).DeleteWorkflowExecution(ctx, req.(*DeleteWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_ResetWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).ResetWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_ResetWorkflowExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).ResetWorkflowExecution(ctx, req.(*ResetWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_UpdateWorkflowExecutionOptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkflowExecutionOptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).UpdateWorkflowExecutionOptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_UpdateWorkflowExecutionOptions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).UpdateWorkflowExecutionOptions(ctx, req.(*UpdateWorkflowExecutionOptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RequestCancelWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RequestCancelWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RequestCancelWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_RequestCancelWorkflowExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RequestCancelWorkflowExecution(ctx, req.(*RequestCancelWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_ScheduleWorkflowTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ScheduleWorkflowTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).ScheduleWorkflowTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_ScheduleWorkflowTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).ScheduleWorkflowTask(ctx, req.(*ScheduleWorkflowTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_VerifyFirstWorkflowTaskScheduled_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VerifyFirstWorkflowTaskScheduledRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).VerifyFirstWorkflowTaskScheduled(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_VerifyFirstWorkflowTaskScheduled_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).VerifyFirstWorkflowTaskScheduled(ctx, req.(*VerifyFirstWorkflowTaskScheduledRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RecordChildExecutionCompleted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecordChildExecutionCompletedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RecordChildExecutionCompleted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_RecordChildExecutionCompleted_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RecordChildExecutionCompleted(ctx, req.(*RecordChildExecutionCompletedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_VerifyChildExecutionCompletionRecorded_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VerifyChildExecutionCompletionRecordedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).VerifyChildExecutionCompletionRecorded(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_VerifyChildExecutionCompletionRecorded_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).VerifyChildExecutionCompletionRecorded(ctx, req.(*VerifyChildExecutionCompletionRecordedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_DescribeWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).DescribeWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_DescribeWorkflowExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).DescribeWorkflowExecution(ctx, req.(*DescribeWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_ReplicateEventsV2_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplicateEventsV2Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).ReplicateEventsV2(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_ReplicateEventsV2_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).ReplicateEventsV2(ctx, req.(*ReplicateEventsV2Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_ReplicateWorkflowState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplicateWorkflowStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).ReplicateWorkflowState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_ReplicateWorkflowState_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).ReplicateWorkflowState(ctx, req.(*ReplicateWorkflowStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_SyncShardStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SyncShardStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).SyncShardStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_SyncShardStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).SyncShardStatus(ctx, req.(*SyncShardStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_SyncActivity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SyncActivityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).SyncActivity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_SyncActivity_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).SyncActivity(ctx, req.(*SyncActivityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_DescribeMutableState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeMutableStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).DescribeMutableState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_DescribeMutableState_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).DescribeMutableState(ctx, req.(*DescribeMutableStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_DescribeHistoryHost_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeHistoryHostRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).DescribeHistoryHost(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_DescribeHistoryHost_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).DescribeHistoryHost(ctx, req.(*DescribeHistoryHostRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_CloseShard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloseShardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).CloseShard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_CloseShard_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).CloseShard(ctx, req.(*CloseShardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_GetShard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetShardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).GetShard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_GetShard_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).GetShard(ctx, req.(*GetShardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RemoveTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RemoveTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_RemoveTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RemoveTask(ctx, req.(*RemoveTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_GetReplicationMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReplicationMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).GetReplicationMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_GetReplicationMessages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).GetReplicationMessages(ctx, req.(*GetReplicationMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_GetDLQReplicationMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDLQReplicationMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).GetDLQReplicationMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_GetDLQReplicationMessages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).GetDLQReplicationMessages(ctx, req.(*GetDLQReplicationMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_QueryWorkflow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryWorkflowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).QueryWorkflow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_QueryWorkflow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).QueryWorkflow(ctx, req.(*QueryWorkflowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_ReapplyEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReapplyEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).ReapplyEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_ReapplyEvents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).ReapplyEvents(ctx, req.(*ReapplyEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_GetDLQMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDLQMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).GetDLQMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_GetDLQMessages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).GetDLQMessages(ctx, req.(*GetDLQMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_PurgeDLQMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeDLQMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).PurgeDLQMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_PurgeDLQMessages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).PurgeDLQMessages(ctx, req.(*PurgeDLQMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_MergeDLQMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeDLQMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).MergeDLQMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_MergeDLQMessages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).MergeDLQMessages(ctx, req.(*MergeDLQMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RefreshWorkflowTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RefreshWorkflowTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RefreshWorkflowTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_RefreshWorkflowTasks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RefreshWorkflowTasks(ctx, req.(*RefreshWorkflowTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_GenerateLastHistoryReplicationTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateLastHistoryReplicationTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).GenerateLastHistoryReplicationTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_GenerateLastHistoryReplicationTasks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).GenerateLastHistoryReplicationTasks(ctx, req.(*GenerateLastHistoryReplicationTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_GetReplicationStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReplicationStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).GetReplicationStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_GetReplicationStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).GetReplicationStatus(ctx, req.(*GetReplicationStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_RebuildMutableState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RebuildMutableStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).RebuildMutableState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_RebuildMutableState_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).RebuildMutableState(ctx, req.(*RebuildMutableStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_ImportWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).ImportWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_ImportWorkflowExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).ImportWorkflowExecution(ctx, req.(*ImportWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_DeleteWorkflowVisibilityRecord_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkflowVisibilityRecordRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).DeleteWorkflowVisibilityRecord(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_DeleteWorkflowVisibilityRecord_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).DeleteWorkflowVisibilityRecord(ctx, req.(*DeleteWorkflowVisibilityRecordRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_UpdateWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).UpdateWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_UpdateWorkflowExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).UpdateWorkflowExecution(ctx, req.(*UpdateWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_PollWorkflowExecutionUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PollWorkflowExecutionUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).PollWorkflowExecutionUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_PollWorkflowExecutionUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).PollWorkflowExecutionUpdate(ctx, req.(*PollWorkflowExecutionUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_StreamWorkflowReplicationMessages_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(HistoryServiceServer).StreamWorkflowReplicationMessages(&historyServiceStreamWorkflowReplicationMessagesServer{stream})
}

type HistoryService_StreamWorkflowReplicationMessagesServer interface {
	Send(*StreamWorkflowReplicationMessagesResponse) error
	Recv() (*StreamWorkflowReplicationMessagesRequest, error)
	grpc.ServerStream
}

type historyServiceStreamWorkflowReplicationMessagesServer struct {
	grpc.ServerStream
}

func (x *historyServiceStreamWorkflowReplicationMessagesServer) Send(m *StreamWorkflowReplicationMessagesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *historyServiceStreamWorkflowReplicationMessagesServer) Recv() (*StreamWorkflowReplicationMessagesRequest, error) {
	m := new(StreamWorkflowReplicationMessagesRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _HistoryService_GetWorkflowExecutionHistory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkflowExecutionHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).GetWorkflowExecutionHistory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_GetWorkflowExecutionHistory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).GetWorkflowExecutionHistory(ctx, req.(*GetWorkflowExecutionHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_GetWorkflowExecutionHistoryReverse_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkflowExecutionHistoryReverseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).GetWorkflowExecutionHistoryReverse(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_GetWorkflowExecutionHistoryReverse_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).GetWorkflowExecutionHistoryReverse(ctx, req.(*GetWorkflowExecutionHistoryReverseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_GetWorkflowExecutionRawHistoryV2_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkflowExecutionRawHistoryV2Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).GetWorkflowExecutionRawHistoryV2(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_GetWorkflowExecutionRawHistoryV2_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).GetWorkflowExecutionRawHistoryV2(ctx, req.(*GetWorkflowExecutionRawHistoryV2Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_GetWorkflowExecutionRawHistory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkflowExecutionRawHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).GetWorkflowExecutionRawHistory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_GetWorkflowExecutionRawHistory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).GetWorkflowExecutionRawHistory(ctx, req.(*GetWorkflowExecutionRawHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_ForceDeleteWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ForceDeleteWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).ForceDeleteWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_ForceDeleteWorkflowExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).ForceDeleteWorkflowExecution(ctx, req.(*ForceDeleteWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_GetDLQTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDLQTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).GetDLQTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_GetDLQTasks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).GetDLQTasks(ctx, req.(*GetDLQTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_DeleteDLQTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDLQTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).DeleteDLQTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_DeleteDLQTasks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).DeleteDLQTasks(ctx, req.(*DeleteDLQTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_ListQueues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListQueuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).ListQueues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_ListQueues_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).ListQueues(ctx, req.(*ListQueuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_AddTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).AddTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_AddTasks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).AddTasks(ctx, req.(*AddTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_ListTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).ListTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_ListTasks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).ListTasks(ctx, req.(*ListTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_CompleteNexusOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CompleteNexusOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).CompleteNexusOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_CompleteNexusOperation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).CompleteNexusOperation(ctx, req.(*CompleteNexusOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_CompleteNexusOperationChasm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CompleteNexusOperationChasmRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).CompleteNexusOperationChasm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_CompleteNexusOperationChasm_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).CompleteNexusOperationChasm(ctx, req.(*CompleteNexusOperationChasmRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_InvokeStateMachineMethod_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InvokeStateMachineMethodRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).InvokeStateMachineMethod(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_InvokeStateMachineMethod_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).InvokeStateMachineMethod(ctx, req.(*InvokeStateMachineMethodRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_DeepHealthCheck_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeepHealthCheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).DeepHealthCheck(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_DeepHealthCheck_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).DeepHealthCheck(ctx, req.(*DeepHealthCheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_SyncWorkflowState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SyncWorkflowStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).SyncWorkflowState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_SyncWorkflowState_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).SyncWorkflowState(ctx, req.(*SyncWorkflowStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_UpdateActivityOptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateActivityOptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).UpdateActivityOptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_UpdateActivityOptions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).UpdateActivityOptions(ctx, req.(*UpdateActivityOptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_PauseActivity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseActivityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).PauseActivity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_PauseActivity_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).PauseActivity(ctx, req.(*PauseActivityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_UnpauseActivity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UnpauseActivityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).UnpauseActivity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_UnpauseActivity_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).UnpauseActivity(ctx, req.(*UnpauseActivityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_ResetActivity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetActivityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).ResetActivity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_ResetActivity_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).ResetActivity(ctx, req.(*ResetActivityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_PauseWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).PauseWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_PauseWorkflowExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).PauseWorkflowExecution(ctx, req.(*PauseWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HistoryService_UnpauseWorkflowExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UnpauseWorkflowExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HistoryServiceServer).UnpauseWorkflowExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HistoryService_UnpauseWorkflowExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HistoryServiceServer).UnpauseWorkflowExecution(ctx, req.(*UnpauseWorkflowExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// HistoryService_ServiceDesc is the grpc.ServiceDesc for HistoryService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var HistoryService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "temporal.server.api.historyservice.v1.HistoryService",
	HandlerType: (*HistoryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "StartWorkflowExecution",
			Handler:    _HistoryService_StartWorkflowExecution_Handler,
		},
		{
			MethodName: "GetMutableState",
			Handler:    _HistoryService_GetMutableState_Handler,
		},
		{
			MethodName: "PollMutableState",
			Handler:    _HistoryService_PollMutableState_Handler,
		},
		{
			MethodName: "ResetStickyTaskQueue",
			Handler:    _HistoryService_ResetStickyTaskQueue_Handler,
		},
		{
			MethodName: "RecordWorkflowTaskStarted",
			Handler:    _HistoryService_RecordWorkflowTaskStarted_Handler,
		},
		{
			MethodName: "RecordActivityTaskStarted",
			Handler:    _HistoryService_RecordActivityTaskStarted_Handler,
		},
		{
			MethodName: "RespondWorkflowTaskCompleted",
			Handler:    _HistoryService_RespondWorkflowTaskCompleted_Handler,
		},
		{
			MethodName: "RespondWorkflowTaskFailed",
			Handler:    _HistoryService_RespondWorkflowTaskFailed_Handler,
		},
		{
			MethodName: "IsWorkflowTaskValid",
			Handler:    _HistoryService_IsWorkflowTaskValid_Handler,
		},
		{
			MethodName: "RecordActivityTaskHeartbeat",
			Handler:    _HistoryService_RecordActivityTaskHeartbeat_Handler,
		},
		{
			MethodName: "RespondActivityTaskCompleted",
			Handler:    _HistoryService_RespondActivityTaskCompleted_Handler,
		},
		{
			MethodName: "RespondActivityTaskFailed",
			Handler:    _HistoryService_RespondActivityTaskFailed_Handler,
		},
		{
			MethodName: "RespondActivityTaskCanceled",
			Handler:    _HistoryService_RespondActivityTaskCanceled_Handler,
		},
		{
			MethodName: "IsActivityTaskValid",
			Handler:    _HistoryService_IsActivityTaskValid_Handler,
		},
		{
			MethodName: "SignalWorkflowExecution",
			Handler:    _HistoryService_SignalWorkflowExecution_Handler,
		},
		{
			MethodName: "SignalWithStartWorkflowExecution",
			Handler:    _HistoryService_SignalWithStartWorkflowExecution_Handler,
		},
		{
			MethodName: "ExecuteMultiOperation",
			Handler:    _HistoryService_ExecuteMultiOperation_Handler,
		},
		{
			MethodName: "RemoveSignalMutableState",
			Handler:    _HistoryService_RemoveSignalMutableState_Handler,
		},
		{
			MethodName: "TerminateWorkflowExecution",
			Handler:    _HistoryService_TerminateWorkflowExecution_Handler,
		},
		{
			MethodName: "DeleteWorkflowExecution",
			Handler:    _HistoryService_DeleteWorkflowExecution_Handler,
		},
		{
			MethodName: "ResetWorkflowExecution",
			Handler:    _HistoryService_ResetWorkflowExecution_Handler,
		},
		{
			MethodName: "UpdateWorkflowExecutionOptions",
			Handler:    _HistoryService_UpdateWorkflowExecutionOptions_Handler,
		},
		{
			MethodName: "RequestCancelWorkflowExecution",
			Handler:    _HistoryService_RequestCancelWorkflowExecution_Handler,
		},
		{
			MethodName: "ScheduleWorkflowTask",
			Handler:    _HistoryService_ScheduleWorkflowTask_Handler,
		},
		{
			MethodName: "VerifyFirstWorkflowTaskScheduled",
			Handler:    _HistoryService_VerifyFirstWorkflowTaskScheduled_Handler,
		},
		{
			MethodName: "RecordChildExecutionCompleted",
			Handler:    _HistoryService_RecordChildExecutionCompleted_Handler,
		},
		{
			MethodName: "VerifyChildExecutionCompletionRecorded",
			Handler:    _HistoryService_VerifyChildExecutionCompletionRecorded_Handler,
		},
		{
			MethodName: "DescribeWorkflowExecution",
			Handler:    _HistoryService_DescribeWorkflowExecution_Handler,
		},
		{
			MethodName: "ReplicateEventsV2",
			Handler:    _HistoryService_ReplicateEventsV2_Handler,
		},
		{
			MethodName: "ReplicateWorkflowState",
			Handler:    _HistoryService_ReplicateWorkflowState_Handler,
		},
		{
			MethodName: "SyncShardStatus",
			Handler:    _HistoryService_SyncShardStatus_Handler,
		},
		{
			MethodName: "SyncActivity",
			Handler:    _HistoryService_SyncActivity_Handler,
		},
		{
			MethodName: "DescribeMutableState",
			Handler:    _HistoryService_DescribeMutableState_Handler,
		},
		{
			MethodName: "DescribeHistoryHost",
			Handler:    _HistoryService_DescribeHistoryHost_Handler,
		},
		{
			MethodName: "CloseShard",
			Handler:    _HistoryService_CloseShard_Handler,
		},
		{
			MethodName: "GetShard",
			Handler:    _HistoryService_GetShard_Handler,
		},
		{
			MethodName: "RemoveTask",
			Handler:    _HistoryService_RemoveTask_Handler,
		},
		{
			MethodName: "GetReplicationMessages",
			Handler:    _HistoryService_GetReplicationMessages_Handler,
		},
		{
			MethodName: "GetDLQReplicationMessages",
			Handler:    _HistoryService_GetDLQReplicationMessages_Handler,
		},
		{
			MethodName: "QueryWorkflow",
			Handler:    _HistoryService_QueryWorkflow_Handler,
		},
		{
			MethodName: "ReapplyEvents",
			Handler:    _HistoryService_ReapplyEvents_Handler,
		},
		{
			MethodName: "GetDLQMessages",
			Handler:    _HistoryService_GetDLQMessages_Handler,
		},
		{
			MethodName: "PurgeDLQMessages",
			Handler:    _HistoryService_PurgeDLQMessages_Handler,
		},
		{
			MethodName: "MergeDLQMessages",
			Handler:    _HistoryService_MergeDLQMessages_Handler,
		},
		{
			MethodName: "RefreshWorkflowTasks",
			Handler:    _HistoryService_RefreshWorkflowTasks_Handler,
		},
		{
			MethodName: "GenerateLastHistoryReplicationTasks",
			Handler:    _HistoryService_GenerateLastHistoryReplicationTasks_Handler,
		},
		{
			MethodName: "GetReplicationStatus",
			Handler:    _HistoryService_GetReplicationStatus_Handler,
		},
		{
			MethodName: "RebuildMutableState",
			Handler:    _HistoryService_RebuildMutableState_Handler,
		},
		{
			MethodName: "ImportWorkflowExecution",
			Handler:    _HistoryService_ImportWorkflowExecution_Handler,
		},
		{
			MethodName: "DeleteWorkflowVisibilityRecord",
			Handler:    _HistoryService_DeleteWorkflowVisibilityRecord_Handler,
		},
		{
			MethodName: "UpdateWorkflowExecution",
			Handler:    _HistoryService_UpdateWorkflowExecution_Handler,
		},
		{
			MethodName: "PollWorkflowExecutionUpdate",
			Handler:    _HistoryService_PollWorkflowExecutionUpdate_Handler,
		},
		{
			MethodName: "GetWorkflowExecutionHistory",
			Handler:    _HistoryService_GetWorkflowExecutionHistory_Handler,
		},
		{
			MethodName: "GetWorkflowExecutionHistoryReverse",
			Handler:    _HistoryService_GetWorkflowExecutionHistoryReverse_Handler,
		},
		{
			MethodName: "GetWorkflowExecutionRawHistoryV2",
			Handler:    _HistoryService_GetWorkflowExecutionRawHistoryV2_Handler,
		},
		{
			MethodName: "GetWorkflowExecutionRawHistory",
			Handler:    _HistoryService_GetWorkflowExecutionRawHistory_Handler,
		},
		{
			MethodName: "ForceDeleteWorkflowExecution",
			Handler:    _HistoryService_ForceDeleteWorkflowExecution_Handler,
		},
		{
			MethodName: "GetDLQTasks",
			Handler:    _HistoryService_GetDLQTasks_Handler,
		},
		{
			MethodName: "DeleteDLQTasks",
			Handler:    _HistoryService_DeleteDLQTasks_Handler,
		},
		{
			MethodName: "ListQueues",
			Handler:    _HistoryService_ListQueues_Handler,
		},
		{
			MethodName: "AddTasks",
			Handler:    _HistoryService_AddTasks_Handler,
		},
		{
			MethodName: "ListTasks",
			Handler:    _HistoryService_ListTasks_Handler,
		},
		{
			MethodName: "CompleteNexusOperation",
			Handler:    _HistoryService_CompleteNexusOperation_Handler,
		},
		{
			MethodName: "CompleteNexusOperationChasm",
			Handler:    _HistoryService_CompleteNexusOperationChasm_Handler,
		},
		{
			MethodName: "InvokeStateMachineMethod",
			Handler:    _HistoryService_InvokeStateMachineMethod_Handler,
		},
		{
			MethodName: "DeepHealthCheck",
			Handler:    _HistoryService_DeepHealthCheck_Handler,
		},
		{
			MethodName: "SyncWorkflowState",
			Handler:    _HistoryService_SyncWorkflowState_Handler,
		},
		{
			MethodName: "UpdateActivityOptions",
			Handler:    _HistoryService_UpdateActivityOptions_Handler,
		},
		{
			MethodName: "PauseActivity",
			Handler:    _HistoryService_PauseActivity_Handler,
		},
		{
			MethodName: "UnpauseActivity",
			Handler:    _HistoryService_UnpauseActivity_Handler,
		},
		{
			MethodName: "ResetActivity",
			Handler:    _HistoryService_ResetActivity_Handler,
		},
		{
			MethodName: "PauseWorkflowExecution",
			Handler:    _HistoryService_PauseWorkflowExecution_Handler,
		},
		{
			MethodName: "UnpauseWorkflowExecution",
			Handler:    _HistoryService_UnpauseWorkflowExecution_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamWorkflowReplicationMessages",
			Handler:       _HistoryService_StreamWorkflowReplicationMessages_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "temporal/server/api/historyservice/v1/service.proto",
}
