// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// plugins:
// - protoc-gen-go-grpc
// - protoc
// source: temporal/server/api/matchingservice/v1/service.proto

package matchingservice

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	MatchingService_PollWorkflowTaskQueue_FullMethodName                  = "/temporal.server.api.matchingservice.v1.MatchingService/PollWorkflowTaskQueue"
	MatchingService_PollActivityTaskQueue_FullMethodName                  = "/temporal.server.api.matchingservice.v1.MatchingService/PollActivityTaskQueue"
	MatchingService_AddWorkflowTask_FullMethodName                        = "/temporal.server.api.matchingservice.v1.MatchingService/AddWorkflowTask"
	MatchingService_AddActivityTask_FullMethodName                        = "/temporal.server.api.matchingservice.v1.MatchingService/AddActivityTask"
	MatchingService_QueryWorkflow_FullMethodName                          = "/temporal.server.api.matchingservice.v1.MatchingService/QueryWorkflow"
	MatchingService_RespondQueryTaskCompleted_FullMethodName              = "/temporal.server.api.matchingservice.v1.MatchingService/RespondQueryTaskCompleted"
	MatchingService_DispatchNexusTask_FullMethodName                      = "/temporal.server.api.matchingservice.v1.MatchingService/DispatchNexusTask"
	MatchingService_PollNexusTaskQueue_FullMethodName                     = "/temporal.server.api.matchingservice.v1.MatchingService/PollNexusTaskQueue"
	MatchingService_RespondNexusTaskCompleted_FullMethodName              = "/temporal.server.api.matchingservice.v1.MatchingService/RespondNexusTaskCompleted"
	MatchingService_RespondNexusTaskFailed_FullMethodName                 = "/temporal.server.api.matchingservice.v1.MatchingService/RespondNexusTaskFailed"
	MatchingService_CancelOutstandingPoll_FullMethodName                  = "/temporal.server.api.matchingservice.v1.MatchingService/CancelOutstandingPoll"
	MatchingService_DescribeTaskQueue_FullMethodName                      = "/temporal.server.api.matchingservice.v1.MatchingService/DescribeTaskQueue"
	MatchingService_DescribeTaskQueuePartition_FullMethodName             = "/temporal.server.api.matchingservice.v1.MatchingService/DescribeTaskQueuePartition"
	MatchingService_DescribeVersionedTaskQueues_FullMethodName            = "/temporal.server.api.matchingservice.v1.MatchingService/DescribeVersionedTaskQueues"
	MatchingService_ListTaskQueuePartitions_FullMethodName                = "/temporal.server.api.matchingservice.v1.MatchingService/ListTaskQueuePartitions"
	MatchingService_UpdateWorkerBuildIdCompatibility_FullMethodName       = "/temporal.server.api.matchingservice.v1.MatchingService/UpdateWorkerBuildIdCompatibility"
	MatchingService_GetWorkerBuildIdCompatibility_FullMethodName          = "/temporal.server.api.matchingservice.v1.MatchingService/GetWorkerBuildIdCompatibility"
	MatchingService_GetTaskQueueUserData_FullMethodName                   = "/temporal.server.api.matchingservice.v1.MatchingService/GetTaskQueueUserData"
	MatchingService_UpdateWorkerVersioningRules_FullMethodName            = "/temporal.server.api.matchingservice.v1.MatchingService/UpdateWorkerVersioningRules"
	MatchingService_GetWorkerVersioningRules_FullMethodName               = "/temporal.server.api.matchingservice.v1.MatchingService/GetWorkerVersioningRules"
	MatchingService_SyncDeploymentUserData_FullMethodName                 = "/temporal.server.api.matchingservice.v1.MatchingService/SyncDeploymentUserData"
	MatchingService_ApplyTaskQueueUserDataReplicationEvent_FullMethodName = "/temporal.server.api.matchingservice.v1.MatchingService/ApplyTaskQueueUserDataReplicationEvent"
	MatchingService_GetBuildIdTaskQueueMapping_FullMethodName             = "/temporal.server.api.matchingservice.v1.MatchingService/GetBuildIdTaskQueueMapping"
	MatchingService_ForceLoadTaskQueuePartition_FullMethodName            = "/temporal.server.api.matchingservice.v1.MatchingService/ForceLoadTaskQueuePartition"
	MatchingService_ForceUnloadTaskQueue_FullMethodName                   = "/temporal.server.api.matchingservice.v1.MatchingService/ForceUnloadTaskQueue"
	MatchingService_ForceUnloadTaskQueuePartition_FullMethodName          = "/temporal.server.api.matchingservice.v1.MatchingService/ForceUnloadTaskQueuePartition"
	MatchingService_UpdateTaskQueueUserData_FullMethodName                = "/temporal.server.api.matchingservice.v1.MatchingService/UpdateTaskQueueUserData"
	MatchingService_ReplicateTaskQueueUserData_FullMethodName             = "/temporal.server.api.matchingservice.v1.MatchingService/ReplicateTaskQueueUserData"
	MatchingService_CheckTaskQueueUserDataPropagation_FullMethodName      = "/temporal.server.api.matchingservice.v1.MatchingService/CheckTaskQueueUserDataPropagation"
	MatchingService_CreateNexusEndpoint_FullMethodName                    = "/temporal.server.api.matchingservice.v1.MatchingService/CreateNexusEndpoint"
	MatchingService_UpdateNexusEndpoint_FullMethodName                    = "/temporal.server.api.matchingservice.v1.MatchingService/UpdateNexusEndpoint"
	MatchingService_DeleteNexusEndpoint_FullMethodName                    = "/temporal.server.api.matchingservice.v1.MatchingService/DeleteNexusEndpoint"
	MatchingService_ListNexusEndpoints_FullMethodName                     = "/temporal.server.api.matchingservice.v1.MatchingService/ListNexusEndpoints"
	MatchingService_RecordWorkerHeartbeat_FullMethodName                  = "/temporal.server.api.matchingservice.v1.MatchingService/RecordWorkerHeartbeat"
	MatchingService_ListWorkers_FullMethodName                            = "/temporal.server.api.matchingservice.v1.MatchingService/ListWorkers"
	MatchingService_UpdateTaskQueueConfig_FullMethodName                  = "/temporal.server.api.matchingservice.v1.MatchingService/UpdateTaskQueueConfig"
	MatchingService_DescribeWorker_FullMethodName                         = "/temporal.server.api.matchingservice.v1.MatchingService/DescribeWorker"
)

// MatchingServiceClient is the client API for MatchingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MatchingServiceClient interface {
	// PollWorkflowTaskQueue is called by frontend to process WorkflowTask from a specific task queue.  A
	// WorkflowTask is dispatched to callers for active workflow executions, with pending workflow tasks.
	PollWorkflowTaskQueue(ctx context.Context, in *PollWorkflowTaskQueueRequest, opts ...grpc.CallOption) (*PollWorkflowTaskQueueResponse, error)
	// PollActivityTaskQueue is called by frontend to process ActivityTask from a specific task queue.  ActivityTask
	// is dispatched to callers whenever a ScheduleTask command is made for a workflow execution.
	PollActivityTaskQueue(ctx context.Context, in *PollActivityTaskQueueRequest, opts ...grpc.CallOption) (*PollActivityTaskQueueResponse, error)
	// AddWorkflowTask is called by the history service when a workflow task is scheduled, so that it can be dispatched
	// by the MatchingEngine.
	AddWorkflowTask(ctx context.Context, in *AddWorkflowTaskRequest, opts ...grpc.CallOption) (*AddWorkflowTaskResponse, error)
	// AddActivityTask is called by the history service when a workflow task is scheduled, so that it can be dispatched
	// by the MatchingEngine.
	AddActivityTask(ctx context.Context, in *AddActivityTaskRequest, opts ...grpc.CallOption) (*AddActivityTaskResponse, error)
	// QueryWorkflow is called by frontend to query a workflow.
	QueryWorkflow(ctx context.Context, in *QueryWorkflowRequest, opts ...grpc.CallOption) (*QueryWorkflowResponse, error)
	// RespondQueryTaskCompleted is called by frontend to respond query completed.
	RespondQueryTaskCompleted(ctx context.Context, in *RespondQueryTaskCompletedRequest, opts ...grpc.CallOption) (*RespondQueryTaskCompletedResponse, error)
	// Request from frontend to synchronously dispatch a nexus task to a worker.
	DispatchNexusTask(ctx context.Context, in *DispatchNexusTaskRequest, opts ...grpc.CallOption) (*DispatchNexusTaskResponse, error)
	// Request from worker (via frontend) to long poll on nexus tasks.
	PollNexusTaskQueue(ctx context.Context, in *PollNexusTaskQueueRequest, opts ...grpc.CallOption) (*PollNexusTaskQueueResponse, error)
	// Response from a worker (via frontend) to a Nexus task, unblocks the corresponding DispatchNexusTask request.
	RespondNexusTaskCompleted(ctx context.Context, in *RespondNexusTaskCompletedRequest, opts ...grpc.CallOption) (*RespondNexusTaskCompletedResponse, error)
	// Response from a worker (via frontend) to a Nexus task, unblocks the corresponding DispatchNexusTask request.
	RespondNexusTaskFailed(ctx context.Context, in *RespondNexusTaskFailedRequest, opts ...grpc.CallOption) (*RespondNexusTaskFailedResponse, error)
	// CancelOutstandingPoll is called by frontend to unblock long polls on matching for zombie pollers.
	// Our rpc stack does not support context propagation, so when a client connection goes away frontend sees
	// cancellation of context for that handler, but any corresponding calls (long-poll) to matching service does not
	// see the cancellation propagated so it can unblock corresponding long-polls on its end.  This results is tasks
	// being dispatched to zombie pollers in this situation.  This API is added so every time frontend makes a long-poll
	// api call to matching it passes in a pollerId and then calls this API when it detects client connection is closed
	// to unblock long polls for this poller and prevent tasks being sent to these zombie pollers.
	CancelOutstandingPoll(ctx context.Context, in *CancelOutstandingPollRequest, opts ...grpc.CallOption) (*CancelOutstandingPollResponse, error)
	// DescribeTaskQueue returns information about the target task queue, right now this API returns the
	// pollers which polled this task queue in last few minutes.
	DescribeTaskQueue(ctx context.Context, in *DescribeTaskQueueRequest, opts ...grpc.CallOption) (*DescribeTaskQueueResponse, error)
	// DescribeTaskQueuePartition returns information about the target task queue partition.
	DescribeTaskQueuePartition(ctx context.Context, in *DescribeTaskQueuePartitionRequest, opts ...grpc.CallOption) (*DescribeTaskQueuePartitionResponse, error)
	// DescribeVersionedTaskQueues returns details about the requested versioned task queues.
	// It is an internal API; there is no direct user-facing equivalent.
	DescribeVersionedTaskQueues(ctx context.Context, in *DescribeVersionedTaskQueuesRequest, opts ...grpc.CallOption) (*DescribeVersionedTaskQueuesResponse, error)
	// ListTaskQueuePartitions returns a map of partitionKey and hostAddress for a task queue.
	ListTaskQueuePartitions(ctx context.Context, in *ListTaskQueuePartitionsRequest, opts ...grpc.CallOption) (*ListTaskQueuePartitionsResponse, error)
	// (-- api-linter: core::0134::response-message-name=disabled
	//
	//	aip.dev/not-precedent: UpdateWorkerBuildIdCompatibility RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0134::method-signature=disabled
	//
	//	aip.dev/not-precedent: UpdateWorkerBuildIdCompatibility RPC doesn't follow Google API format. --)
	UpdateWorkerBuildIdCompatibility(ctx context.Context, in *UpdateWorkerBuildIdCompatibilityRequest, opts ...grpc.CallOption) (*UpdateWorkerBuildIdCompatibilityResponse, error)
	GetWorkerBuildIdCompatibility(ctx context.Context, in *GetWorkerBuildIdCompatibilityRequest, opts ...grpc.CallOption) (*GetWorkerBuildIdCompatibilityResponse, error)
	// Fetch user data for a task queue, this request should always be routed to the node holding the root partition of the workflow task queue.
	GetTaskQueueUserData(ctx context.Context, in *GetTaskQueueUserDataRequest, opts ...grpc.CallOption) (*GetTaskQueueUserDataResponse, error)
	// Allows updating the Build ID assignment and redirect rules for a given Task Queue.
	// (-- api-linter: core::0134::method-signature=disabled
	//
	//	aip.dev/not-precedent: UpdateWorkerVersioningRulesRequest RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0134::response-message-name=disabled
	//
	//	aip.dev/not-precedent: UpdateWorkerVersioningRulesRequest RPC doesn't follow Google API format. --)
	UpdateWorkerVersioningRules(ctx context.Context, in *UpdateWorkerVersioningRulesRequest, opts ...grpc.CallOption) (*UpdateWorkerVersioningRulesResponse, error)
	// Fetches the Build ID assignment and redirect rules for a Task Queue
	// (-- api-linter: core::0127::resource-name-extraction=disabled
	//
	//	aip.dev/not-precedent: GetWorkerVersioningRulesRequest RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0131::http-uri-name=disabled
	//
	//	aip.dev/not-precedent: GetWorkerVersioningRulesRequest RPC doesn't follow Google API format. --)
	GetWorkerVersioningRules(ctx context.Context, in *GetWorkerVersioningRulesRequest, opts ...grpc.CallOption) (*GetWorkerVersioningRulesResponse, error)
	// This request should always be routed to the node holding the root partition of the workflow task queue.
	SyncDeploymentUserData(ctx context.Context, in *SyncDeploymentUserDataRequest, opts ...grpc.CallOption) (*SyncDeploymentUserDataResponse, error)
	// Apply a user data replication event.
	ApplyTaskQueueUserDataReplicationEvent(ctx context.Context, in *ApplyTaskQueueUserDataReplicationEventRequest, opts ...grpc.CallOption) (*ApplyTaskQueueUserDataReplicationEventResponse, error)
	// Gets all task queue names mapped to a given build ID
	GetBuildIdTaskQueueMapping(ctx context.Context, in *GetBuildIdTaskQueueMappingRequest, opts ...grpc.CallOption) (*GetBuildIdTaskQueueMappingResponse, error)
	// Force loading a task queue partition. Used by matching node owning root partition.
	// When root partition is loaded this is called for all child partitions.
	// This addresses the posibility of unloaded child partitions having backlog,
	// but not being forwarded/synced to the root partition to find the polling
	// worker which triggered the root partition being loaded in the first place.
	ForceLoadTaskQueuePartition(ctx context.Context, in *ForceLoadTaskQueuePartitionRequest, opts ...grpc.CallOption) (*ForceLoadTaskQueuePartitionResponse, error)
	// TODO Shivam - remove this in 123. Present for backwards compatibility.
	ForceUnloadTaskQueue(ctx context.Context, in *ForceUnloadTaskQueueRequest, opts ...grpc.CallOption) (*ForceUnloadTaskQueueResponse, error)
	// Force unloading a task queue partition.
	ForceUnloadTaskQueuePartition(ctx context.Context, in *ForceUnloadTaskQueuePartitionRequest, opts ...grpc.CallOption) (*ForceUnloadTaskQueuePartitionResponse, error)
	// Update task queue user data in owning node for all updates in namespace.
	// All user data updates must first go through the task queue owner using the `UpdateWorkerBuildIdCompatibility`
	// API.
	// (-- api-linter: core::0134::response-message-name=disabled
	//
	//	aip.dev/not-precedent: UpdateTaskQueueUserData RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0134::method-signature=disabled
	//
	//	aip.dev/not-precedent: UpdateTaskQueueUserData RPC doesn't follow Google API format. --)
	UpdateTaskQueueUserData(ctx context.Context, in *UpdateTaskQueueUserDataRequest, opts ...grpc.CallOption) (*UpdateTaskQueueUserDataResponse, error)
	// Replicate task queue user data across clusters, must be done via the owning node for updates in namespace.
	ReplicateTaskQueueUserData(ctx context.Context, in *ReplicateTaskQueueUserDataRequest, opts ...grpc.CallOption) (*ReplicateTaskQueueUserDataResponse, error)
	// Blocks on user data propagation to all loaded partitions. If successful, all loaded
	// workflow + activity partitions have the requested version or higher.
	// Routed to user data owner (root partition of workflow task queue).
	CheckTaskQueueUserDataPropagation(ctx context.Context, in *CheckTaskQueueUserDataPropagationRequest, opts ...grpc.CallOption) (*CheckTaskQueueUserDataPropagationResponse, error)
	// Create a Nexus endpoint.
	// (-- api-linter: core::0133::method-signature=disabled
	//
	//	aip.dev/not-precedent: CreateNexusEndpoint RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0133::response-message-name=disabled
	//
	//	aip.dev/not-precedent: CreateNexusEndpoint RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0133::http-uri-parent=disabled
	//
	//	aip.dev/not-precedent: CreateNexusEndpoint RPC doesn't follow Google API format. --)
	CreateNexusEndpoint(ctx context.Context, in *CreateNexusEndpointRequest, opts ...grpc.CallOption) (*CreateNexusEndpointResponse, error)
	// Optimistically update a Nexus endpoint based on provided version.
	// If this request is accepted, the input is considered the "current" state of this service at the time it was
	// persisted and the updated version is returned.
	// (-- api-linter: core::0134::method-signature=disabled
	//
	//	aip.dev/not-precedent: UpdateNexusEndpoint RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0134::response-message-name=disabled
	//
	//	aip.dev/not-precedent: UpdateNexusEndpoint RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0134::request-resource-required=disabled
	//
	//	aip.dev/not-precedent: UpdateNexusEndpoint RPC doesn't follow Google API format. --)
	UpdateNexusEndpoint(ctx context.Context, in *UpdateNexusEndpointRequest, opts ...grpc.CallOption) (*UpdateNexusEndpointResponse, error)
	// Delete a service by its name.
	DeleteNexusEndpoint(ctx context.Context, in *DeleteNexusEndpointRequest, opts ...grpc.CallOption) (*DeleteNexusEndpointResponse, error)
	// List all registered services.
	ListNexusEndpoints(ctx context.Context, in *ListNexusEndpointsRequest, opts ...grpc.CallOption) (*ListNexusEndpointsResponse, error)
	// RecordWorkerHeartbeat receive heartbeat request from the worker.
	RecordWorkerHeartbeat(ctx context.Context, in *RecordWorkerHeartbeatRequest, opts ...grpc.CallOption) (*RecordWorkerHeartbeatResponse, error)
	// ListWorkers retrieves a list of workers in the specified namespace that match the provided filters.
	// Supports pagination for large result sets. Returns an empty list if no workers match the criteria.
	// Returns an error if the namespace doesn't exist.
	ListWorkers(ctx context.Context, in *ListWorkersRequest, opts ...grpc.CallOption) (*ListWorkersResponse, error)
	// Set the persisted task queue configuration.
	// (-- api-linter: core::0134::method-signature=disabled
	//
	//	aip.dev/not-precedent: UpdateTaskQueueConfig RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0134::response-message-name=disabled
	//
	//	aip.dev/not-precedent: UpdateTaskQueueConfig RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0134::request-resource-required=disabled
	//
	//	aip.dev/not-precedent: UpdateTaskQueueConfig RPC doesn't follow Google API format. --)
	UpdateTaskQueueConfig(ctx context.Context, in *UpdateTaskQueueConfigRequest, opts ...grpc.CallOption) (*UpdateTaskQueueConfigResponse, error)
	// DescribeWorker retrieves a worker information in the specified namespace that match the provided instance key.
	// Returns an error if the namespace or worker doesn't exist.
	DescribeWorker(ctx context.Context, in *DescribeWorkerRequest, opts ...grpc.CallOption) (*DescribeWorkerResponse, error)
}

type matchingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMatchingServiceClient(cc grpc.ClientConnInterface) MatchingServiceClient {
	return &matchingServiceClient{cc}
}

func (c *matchingServiceClient) PollWorkflowTaskQueue(ctx context.Context, in *PollWorkflowTaskQueueRequest, opts ...grpc.CallOption) (*PollWorkflowTaskQueueResponse, error) {
	out := new(PollWorkflowTaskQueueResponse)
	err := c.cc.Invoke(ctx, MatchingService_PollWorkflowTaskQueue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) PollActivityTaskQueue(ctx context.Context, in *PollActivityTaskQueueRequest, opts ...grpc.CallOption) (*PollActivityTaskQueueResponse, error) {
	out := new(PollActivityTaskQueueResponse)
	err := c.cc.Invoke(ctx, MatchingService_PollActivityTaskQueue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) AddWorkflowTask(ctx context.Context, in *AddWorkflowTaskRequest, opts ...grpc.CallOption) (*AddWorkflowTaskResponse, error) {
	out := new(AddWorkflowTaskResponse)
	err := c.cc.Invoke(ctx, MatchingService_AddWorkflowTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) AddActivityTask(ctx context.Context, in *AddActivityTaskRequest, opts ...grpc.CallOption) (*AddActivityTaskResponse, error) {
	out := new(AddActivityTaskResponse)
	err := c.cc.Invoke(ctx, MatchingService_AddActivityTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) QueryWorkflow(ctx context.Context, in *QueryWorkflowRequest, opts ...grpc.CallOption) (*QueryWorkflowResponse, error) {
	out := new(QueryWorkflowResponse)
	err := c.cc.Invoke(ctx, MatchingService_QueryWorkflow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) RespondQueryTaskCompleted(ctx context.Context, in *RespondQueryTaskCompletedRequest, opts ...grpc.CallOption) (*RespondQueryTaskCompletedResponse, error) {
	out := new(RespondQueryTaskCompletedResponse)
	err := c.cc.Invoke(ctx, MatchingService_RespondQueryTaskCompleted_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) DispatchNexusTask(ctx context.Context, in *DispatchNexusTaskRequest, opts ...grpc.CallOption) (*DispatchNexusTaskResponse, error) {
	out := new(DispatchNexusTaskResponse)
	err := c.cc.Invoke(ctx, MatchingService_DispatchNexusTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) PollNexusTaskQueue(ctx context.Context, in *PollNexusTaskQueueRequest, opts ...grpc.CallOption) (*PollNexusTaskQueueResponse, error) {
	out := new(PollNexusTaskQueueResponse)
	err := c.cc.Invoke(ctx, MatchingService_PollNexusTaskQueue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) RespondNexusTaskCompleted(ctx context.Context, in *RespondNexusTaskCompletedRequest, opts ...grpc.CallOption) (*RespondNexusTaskCompletedResponse, error) {
	out := new(RespondNexusTaskCompletedResponse)
	err := c.cc.Invoke(ctx, MatchingService_RespondNexusTaskCompleted_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) RespondNexusTaskFailed(ctx context.Context, in *RespondNexusTaskFailedRequest, opts ...grpc.CallOption) (*RespondNexusTaskFailedResponse, error) {
	out := new(RespondNexusTaskFailedResponse)
	err := c.cc.Invoke(ctx, MatchingService_RespondNexusTaskFailed_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) CancelOutstandingPoll(ctx context.Context, in *CancelOutstandingPollRequest, opts ...grpc.CallOption) (*CancelOutstandingPollResponse, error) {
	out := new(CancelOutstandingPollResponse)
	err := c.cc.Invoke(ctx, MatchingService_CancelOutstandingPoll_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) DescribeTaskQueue(ctx context.Context, in *DescribeTaskQueueRequest, opts ...grpc.CallOption) (*DescribeTaskQueueResponse, error) {
	out := new(DescribeTaskQueueResponse)
	err := c.cc.Invoke(ctx, MatchingService_DescribeTaskQueue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) DescribeTaskQueuePartition(ctx context.Context, in *DescribeTaskQueuePartitionRequest, opts ...grpc.CallOption) (*DescribeTaskQueuePartitionResponse, error) {
	out := new(DescribeTaskQueuePartitionResponse)
	err := c.cc.Invoke(ctx, MatchingService_DescribeTaskQueuePartition_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) DescribeVersionedTaskQueues(ctx context.Context, in *DescribeVersionedTaskQueuesRequest, opts ...grpc.CallOption) (*DescribeVersionedTaskQueuesResponse, error) {
	out := new(DescribeVersionedTaskQueuesResponse)
	err := c.cc.Invoke(ctx, MatchingService_DescribeVersionedTaskQueues_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) ListTaskQueuePartitions(ctx context.Context, in *ListTaskQueuePartitionsRequest, opts ...grpc.CallOption) (*ListTaskQueuePartitionsResponse, error) {
	out := new(ListTaskQueuePartitionsResponse)
	err := c.cc.Invoke(ctx, MatchingService_ListTaskQueuePartitions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) UpdateWorkerBuildIdCompatibility(ctx context.Context, in *UpdateWorkerBuildIdCompatibilityRequest, opts ...grpc.CallOption) (*UpdateWorkerBuildIdCompatibilityResponse, error) {
	out := new(UpdateWorkerBuildIdCompatibilityResponse)
	err := c.cc.Invoke(ctx, MatchingService_UpdateWorkerBuildIdCompatibility_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) GetWorkerBuildIdCompatibility(ctx context.Context, in *GetWorkerBuildIdCompatibilityRequest, opts ...grpc.CallOption) (*GetWorkerBuildIdCompatibilityResponse, error) {
	out := new(GetWorkerBuildIdCompatibilityResponse)
	err := c.cc.Invoke(ctx, MatchingService_GetWorkerBuildIdCompatibility_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) GetTaskQueueUserData(ctx context.Context, in *GetTaskQueueUserDataRequest, opts ...grpc.CallOption) (*GetTaskQueueUserDataResponse, error) {
	out := new(GetTaskQueueUserDataResponse)
	err := c.cc.Invoke(ctx, MatchingService_GetTaskQueueUserData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) UpdateWorkerVersioningRules(ctx context.Context, in *UpdateWorkerVersioningRulesRequest, opts ...grpc.CallOption) (*UpdateWorkerVersioningRulesResponse, error) {
	out := new(UpdateWorkerVersioningRulesResponse)
	err := c.cc.Invoke(ctx, MatchingService_UpdateWorkerVersioningRules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) GetWorkerVersioningRules(ctx context.Context, in *GetWorkerVersioningRulesRequest, opts ...grpc.CallOption) (*GetWorkerVersioningRulesResponse, error) {
	out := new(GetWorkerVersioningRulesResponse)
	err := c.cc.Invoke(ctx, MatchingService_GetWorkerVersioningRules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) SyncDeploymentUserData(ctx context.Context, in *SyncDeploymentUserDataRequest, opts ...grpc.CallOption) (*SyncDeploymentUserDataResponse, error) {
	out := new(SyncDeploymentUserDataResponse)
	err := c.cc.Invoke(ctx, MatchingService_SyncDeploymentUserData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) ApplyTaskQueueUserDataReplicationEvent(ctx context.Context, in *ApplyTaskQueueUserDataReplicationEventRequest, opts ...grpc.CallOption) (*ApplyTaskQueueUserDataReplicationEventResponse, error) {
	out := new(ApplyTaskQueueUserDataReplicationEventResponse)
	err := c.cc.Invoke(ctx, MatchingService_ApplyTaskQueueUserDataReplicationEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) GetBuildIdTaskQueueMapping(ctx context.Context, in *GetBuildIdTaskQueueMappingRequest, opts ...grpc.CallOption) (*GetBuildIdTaskQueueMappingResponse, error) {
	out := new(GetBuildIdTaskQueueMappingResponse)
	err := c.cc.Invoke(ctx, MatchingService_GetBuildIdTaskQueueMapping_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) ForceLoadTaskQueuePartition(ctx context.Context, in *ForceLoadTaskQueuePartitionRequest, opts ...grpc.CallOption) (*ForceLoadTaskQueuePartitionResponse, error) {
	out := new(ForceLoadTaskQueuePartitionResponse)
	err := c.cc.Invoke(ctx, MatchingService_ForceLoadTaskQueuePartition_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) ForceUnloadTaskQueue(ctx context.Context, in *ForceUnloadTaskQueueRequest, opts ...grpc.CallOption) (*ForceUnloadTaskQueueResponse, error) {
	out := new(ForceUnloadTaskQueueResponse)
	err := c.cc.Invoke(ctx, MatchingService_ForceUnloadTaskQueue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) ForceUnloadTaskQueuePartition(ctx context.Context, in *ForceUnloadTaskQueuePartitionRequest, opts ...grpc.CallOption) (*ForceUnloadTaskQueuePartitionResponse, error) {
	out := new(ForceUnloadTaskQueuePartitionResponse)
	err := c.cc.Invoke(ctx, MatchingService_ForceUnloadTaskQueuePartition_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) UpdateTaskQueueUserData(ctx context.Context, in *UpdateTaskQueueUserDataRequest, opts ...grpc.CallOption) (*UpdateTaskQueueUserDataResponse, error) {
	out := new(UpdateTaskQueueUserDataResponse)
	err := c.cc.Invoke(ctx, MatchingService_UpdateTaskQueueUserData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) ReplicateTaskQueueUserData(ctx context.Context, in *ReplicateTaskQueueUserDataRequest, opts ...grpc.CallOption) (*ReplicateTaskQueueUserDataResponse, error) {
	out := new(ReplicateTaskQueueUserDataResponse)
	err := c.cc.Invoke(ctx, MatchingService_ReplicateTaskQueueUserData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) CheckTaskQueueUserDataPropagation(ctx context.Context, in *CheckTaskQueueUserDataPropagationRequest, opts ...grpc.CallOption) (*CheckTaskQueueUserDataPropagationResponse, error) {
	out := new(CheckTaskQueueUserDataPropagationResponse)
	err := c.cc.Invoke(ctx, MatchingService_CheckTaskQueueUserDataPropagation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) CreateNexusEndpoint(ctx context.Context, in *CreateNexusEndpointRequest, opts ...grpc.CallOption) (*CreateNexusEndpointResponse, error) {
	out := new(CreateNexusEndpointResponse)
	err := c.cc.Invoke(ctx, MatchingService_CreateNexusEndpoint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) UpdateNexusEndpoint(ctx context.Context, in *UpdateNexusEndpointRequest, opts ...grpc.CallOption) (*UpdateNexusEndpointResponse, error) {
	out := new(UpdateNexusEndpointResponse)
	err := c.cc.Invoke(ctx, MatchingService_UpdateNexusEndpoint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) DeleteNexusEndpoint(ctx context.Context, in *DeleteNexusEndpointRequest, opts ...grpc.CallOption) (*DeleteNexusEndpointResponse, error) {
	out := new(DeleteNexusEndpointResponse)
	err := c.cc.Invoke(ctx, MatchingService_DeleteNexusEndpoint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) ListNexusEndpoints(ctx context.Context, in *ListNexusEndpointsRequest, opts ...grpc.CallOption) (*ListNexusEndpointsResponse, error) {
	out := new(ListNexusEndpointsResponse)
	err := c.cc.Invoke(ctx, MatchingService_ListNexusEndpoints_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) RecordWorkerHeartbeat(ctx context.Context, in *RecordWorkerHeartbeatRequest, opts ...grpc.CallOption) (*RecordWorkerHeartbeatResponse, error) {
	out := new(RecordWorkerHeartbeatResponse)
	err := c.cc.Invoke(ctx, MatchingService_RecordWorkerHeartbeat_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) ListWorkers(ctx context.Context, in *ListWorkersRequest, opts ...grpc.CallOption) (*ListWorkersResponse, error) {
	out := new(ListWorkersResponse)
	err := c.cc.Invoke(ctx, MatchingService_ListWorkers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) UpdateTaskQueueConfig(ctx context.Context, in *UpdateTaskQueueConfigRequest, opts ...grpc.CallOption) (*UpdateTaskQueueConfigResponse, error) {
	out := new(UpdateTaskQueueConfigResponse)
	err := c.cc.Invoke(ctx, MatchingService_UpdateTaskQueueConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *matchingServiceClient) DescribeWorker(ctx context.Context, in *DescribeWorkerRequest, opts ...grpc.CallOption) (*DescribeWorkerResponse, error) {
	out := new(DescribeWorkerResponse)
	err := c.cc.Invoke(ctx, MatchingService_DescribeWorker_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MatchingServiceServer is the server API for MatchingService service.
// All implementations must embed UnimplementedMatchingServiceServer
// for forward compatibility
type MatchingServiceServer interface {
	// PollWorkflowTaskQueue is called by frontend to process WorkflowTask from a specific task queue.  A
	// WorkflowTask is dispatched to callers for active workflow executions, with pending workflow tasks.
	PollWorkflowTaskQueue(context.Context, *PollWorkflowTaskQueueRequest) (*PollWorkflowTaskQueueResponse, error)
	// PollActivityTaskQueue is called by frontend to process ActivityTask from a specific task queue.  ActivityTask
	// is dispatched to callers whenever a ScheduleTask command is made for a workflow execution.
	PollActivityTaskQueue(context.Context, *PollActivityTaskQueueRequest) (*PollActivityTaskQueueResponse, error)
	// AddWorkflowTask is called by the history service when a workflow task is scheduled, so that it can be dispatched
	// by the MatchingEngine.
	AddWorkflowTask(context.Context, *AddWorkflowTaskRequest) (*AddWorkflowTaskResponse, error)
	// AddActivityTask is called by the history service when a workflow task is scheduled, so that it can be dispatched
	// by the MatchingEngine.
	AddActivityTask(context.Context, *AddActivityTaskRequest) (*AddActivityTaskResponse, error)
	// QueryWorkflow is called by frontend to query a workflow.
	QueryWorkflow(context.Context, *QueryWorkflowRequest) (*QueryWorkflowResponse, error)
	// RespondQueryTaskCompleted is called by frontend to respond query completed.
	RespondQueryTaskCompleted(context.Context, *RespondQueryTaskCompletedRequest) (*RespondQueryTaskCompletedResponse, error)
	// Request from frontend to synchronously dispatch a nexus task to a worker.
	DispatchNexusTask(context.Context, *DispatchNexusTaskRequest) (*DispatchNexusTaskResponse, error)
	// Request from worker (via frontend) to long poll on nexus tasks.
	PollNexusTaskQueue(context.Context, *PollNexusTaskQueueRequest) (*PollNexusTaskQueueResponse, error)
	// Response from a worker (via frontend) to a Nexus task, unblocks the corresponding DispatchNexusTask request.
	RespondNexusTaskCompleted(context.Context, *RespondNexusTaskCompletedRequest) (*RespondNexusTaskCompletedResponse, error)
	// Response from a worker (via frontend) to a Nexus task, unblocks the corresponding DispatchNexusTask request.
	RespondNexusTaskFailed(context.Context, *RespondNexusTaskFailedRequest) (*RespondNexusTaskFailedResponse, error)
	// CancelOutstandingPoll is called by frontend to unblock long polls on matching for zombie pollers.
	// Our rpc stack does not support context propagation, so when a client connection goes away frontend sees
	// cancellation of context for that handler, but any corresponding calls (long-poll) to matching service does not
	// see the cancellation propagated so it can unblock corresponding long-polls on its end.  This results is tasks
	// being dispatched to zombie pollers in this situation.  This API is added so every time frontend makes a long-poll
	// api call to matching it passes in a pollerId and then calls this API when it detects client connection is closed
	// to unblock long polls for this poller and prevent tasks being sent to these zombie pollers.
	CancelOutstandingPoll(context.Context, *CancelOutstandingPollRequest) (*CancelOutstandingPollResponse, error)
	// DescribeTaskQueue returns information about the target task queue, right now this API returns the
	// pollers which polled this task queue in last few minutes.
	DescribeTaskQueue(context.Context, *DescribeTaskQueueRequest) (*DescribeTaskQueueResponse, error)
	// DescribeTaskQueuePartition returns information about the target task queue partition.
	DescribeTaskQueuePartition(context.Context, *DescribeTaskQueuePartitionRequest) (*DescribeTaskQueuePartitionResponse, error)
	// DescribeVersionedTaskQueues returns details about the requested versioned task queues.
	// It is an internal API; there is no direct user-facing equivalent.
	DescribeVersionedTaskQueues(context.Context, *DescribeVersionedTaskQueuesRequest) (*DescribeVersionedTaskQueuesResponse, error)
	// ListTaskQueuePartitions returns a map of partitionKey and hostAddress for a task queue.
	ListTaskQueuePartitions(context.Context, *ListTaskQueuePartitionsRequest) (*ListTaskQueuePartitionsResponse, error)
	// (-- api-linter: core::0134::response-message-name=disabled
	//
	//	aip.dev/not-precedent: UpdateWorkerBuildIdCompatibility RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0134::method-signature=disabled
	//
	//	aip.dev/not-precedent: UpdateWorkerBuildIdCompatibility RPC doesn't follow Google API format. --)
	UpdateWorkerBuildIdCompatibility(context.Context, *UpdateWorkerBuildIdCompatibilityRequest) (*UpdateWorkerBuildIdCompatibilityResponse, error)
	GetWorkerBuildIdCompatibility(context.Context, *GetWorkerBuildIdCompatibilityRequest) (*GetWorkerBuildIdCompatibilityResponse, error)
	// Fetch user data for a task queue, this request should always be routed to the node holding the root partition of the workflow task queue.
	GetTaskQueueUserData(context.Context, *GetTaskQueueUserDataRequest) (*GetTaskQueueUserDataResponse, error)
	// Allows updating the Build ID assignment and redirect rules for a given Task Queue.
	// (-- api-linter: core::0134::method-signature=disabled
	//
	//	aip.dev/not-precedent: UpdateWorkerVersioningRulesRequest RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0134::response-message-name=disabled
	//
	//	aip.dev/not-precedent: UpdateWorkerVersioningRulesRequest RPC doesn't follow Google API format. --)
	UpdateWorkerVersioningRules(context.Context, *UpdateWorkerVersioningRulesRequest) (*UpdateWorkerVersioningRulesResponse, error)
	// Fetches the Build ID assignment and redirect rules for a Task Queue
	// (-- api-linter: core::0127::resource-name-extraction=disabled
	//
	//	aip.dev/not-precedent: GetWorkerVersioningRulesRequest RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0131::http-uri-name=disabled
	//
	//	aip.dev/not-precedent: GetWorkerVersioningRulesRequest RPC doesn't follow Google API format. --)
	GetWorkerVersioningRules(context.Context, *GetWorkerVersioningRulesRequest) (*GetWorkerVersioningRulesResponse, error)
	// This request should always be routed to the node holding the root partition of the workflow task queue.
	SyncDeploymentUserData(context.Context, *SyncDeploymentUserDataRequest) (*SyncDeploymentUserDataResponse, error)
	// Apply a user data replication event.
	ApplyTaskQueueUserDataReplicationEvent(context.Context, *ApplyTaskQueueUserDataReplicationEventRequest) (*ApplyTaskQueueUserDataReplicationEventResponse, error)
	// Gets all task queue names mapped to a given build ID
	GetBuildIdTaskQueueMapping(context.Context, *GetBuildIdTaskQueueMappingRequest) (*GetBuildIdTaskQueueMappingResponse, error)
	// Force loading a task queue partition. Used by matching node owning root partition.
	// When root partition is loaded this is called for all child partitions.
	// This addresses the posibility of unloaded child partitions having backlog,
	// but not being forwarded/synced to the root partition to find the polling
	// worker which triggered the root partition being loaded in the first place.
	ForceLoadTaskQueuePartition(context.Context, *ForceLoadTaskQueuePartitionRequest) (*ForceLoadTaskQueuePartitionResponse, error)
	// TODO Shivam - remove this in 123. Present for backwards compatibility.
	ForceUnloadTaskQueue(context.Context, *ForceUnloadTaskQueueRequest) (*ForceUnloadTaskQueueResponse, error)
	// Force unloading a task queue partition.
	ForceUnloadTaskQueuePartition(context.Context, *ForceUnloadTaskQueuePartitionRequest) (*ForceUnloadTaskQueuePartitionResponse, error)
	// Update task queue user data in owning node for all updates in namespace.
	// All user data updates must first go through the task queue owner using the `UpdateWorkerBuildIdCompatibility`
	// API.
	// (-- api-linter: core::0134::response-message-name=disabled
	//
	//	aip.dev/not-precedent: UpdateTaskQueueUserData RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0134::method-signature=disabled
	//
	//	aip.dev/not-precedent: UpdateTaskQueueUserData RPC doesn't follow Google API format. --)
	UpdateTaskQueueUserData(context.Context, *UpdateTaskQueueUserDataRequest) (*UpdateTaskQueueUserDataResponse, error)
	// Replicate task queue user data across clusters, must be done via the owning node for updates in namespace.
	ReplicateTaskQueueUserData(context.Context, *ReplicateTaskQueueUserDataRequest) (*ReplicateTaskQueueUserDataResponse, error)
	// Blocks on user data propagation to all loaded partitions. If successful, all loaded
	// workflow + activity partitions have the requested version or higher.
	// Routed to user data owner (root partition of workflow task queue).
	CheckTaskQueueUserDataPropagation(context.Context, *CheckTaskQueueUserDataPropagationRequest) (*CheckTaskQueueUserDataPropagationResponse, error)
	// Create a Nexus endpoint.
	// (-- api-linter: core::0133::method-signature=disabled
	//
	//	aip.dev/not-precedent: CreateNexusEndpoint RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0133::response-message-name=disabled
	//
	//	aip.dev/not-precedent: CreateNexusEndpoint RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0133::http-uri-parent=disabled
	//
	//	aip.dev/not-precedent: CreateNexusEndpoint RPC doesn't follow Google API format. --)
	CreateNexusEndpoint(context.Context, *CreateNexusEndpointRequest) (*CreateNexusEndpointResponse, error)
	// Optimistically update a Nexus endpoint based on provided version.
	// If this request is accepted, the input is considered the "current" state of this service at the time it was
	// persisted and the updated version is returned.
	// (-- api-linter: core::0134::method-signature=disabled
	//
	//	aip.dev/not-precedent: UpdateNexusEndpoint RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0134::response-message-name=disabled
	//
	//	aip.dev/not-precedent: UpdateNexusEndpoint RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0134::request-resource-required=disabled
	//
	//	aip.dev/not-precedent: UpdateNexusEndpoint RPC doesn't follow Google API format. --)
	UpdateNexusEndpoint(context.Context, *UpdateNexusEndpointRequest) (*UpdateNexusEndpointResponse, error)
	// Delete a service by its name.
	DeleteNexusEndpoint(context.Context, *DeleteNexusEndpointRequest) (*DeleteNexusEndpointResponse, error)
	// List all registered services.
	ListNexusEndpoints(context.Context, *ListNexusEndpointsRequest) (*ListNexusEndpointsResponse, error)
	// RecordWorkerHeartbeat receive heartbeat request from the worker.
	RecordWorkerHeartbeat(context.Context, *RecordWorkerHeartbeatRequest) (*RecordWorkerHeartbeatResponse, error)
	// ListWorkers retrieves a list of workers in the specified namespace that match the provided filters.
	// Supports pagination for large result sets. Returns an empty list if no workers match the criteria.
	// Returns an error if the namespace doesn't exist.
	ListWorkers(context.Context, *ListWorkersRequest) (*ListWorkersResponse, error)
	// Set the persisted task queue configuration.
	// (-- api-linter: core::0134::method-signature=disabled
	//
	//	aip.dev/not-precedent: UpdateTaskQueueConfig RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0134::response-message-name=disabled
	//
	//	aip.dev/not-precedent: UpdateTaskQueueConfig RPC doesn't follow Google API format. --)
	//
	// (-- api-linter: core::0134::request-resource-required=disabled
	//
	//	aip.dev/not-precedent: UpdateTaskQueueConfig RPC doesn't follow Google API format. --)
	UpdateTaskQueueConfig(context.Context, *UpdateTaskQueueConfigRequest) (*UpdateTaskQueueConfigResponse, error)
	// DescribeWorker retrieves a worker information in the specified namespace that match the provided instance key.
	// Returns an error if the namespace or worker doesn't exist.
	DescribeWorker(context.Context, *DescribeWorkerRequest) (*DescribeWorkerResponse, error)
	mustEmbedUnimplementedMatchingServiceServer()
}

// UnimplementedMatchingServiceServer must be embedded to have forward compatible implementations.
type UnimplementedMatchingServiceServer struct {
}

func (UnimplementedMatchingServiceServer) PollWorkflowTaskQueue(context.Context, *PollWorkflowTaskQueueRequest) (*PollWorkflowTaskQueueResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PollWorkflowTaskQueue not implemented")
}
func (UnimplementedMatchingServiceServer) PollActivityTaskQueue(context.Context, *PollActivityTaskQueueRequest) (*PollActivityTaskQueueResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PollActivityTaskQueue not implemented")
}
func (UnimplementedMatchingServiceServer) AddWorkflowTask(context.Context, *AddWorkflowTaskRequest) (*AddWorkflowTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddWorkflowTask not implemented")
}
func (UnimplementedMatchingServiceServer) AddActivityTask(context.Context, *AddActivityTaskRequest) (*AddActivityTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddActivityTask not implemented")
}
func (UnimplementedMatchingServiceServer) QueryWorkflow(context.Context, *QueryWorkflowRequest) (*QueryWorkflowResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryWorkflow not implemented")
}
func (UnimplementedMatchingServiceServer) RespondQueryTaskCompleted(context.Context, *RespondQueryTaskCompletedRequest) (*RespondQueryTaskCompletedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RespondQueryTaskCompleted not implemented")
}
func (UnimplementedMatchingServiceServer) DispatchNexusTask(context.Context, *DispatchNexusTaskRequest) (*DispatchNexusTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DispatchNexusTask not implemented")
}
func (UnimplementedMatchingServiceServer) PollNexusTaskQueue(context.Context, *PollNexusTaskQueueRequest) (*PollNexusTaskQueueResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PollNexusTaskQueue not implemented")
}
func (UnimplementedMatchingServiceServer) RespondNexusTaskCompleted(context.Context, *RespondNexusTaskCompletedRequest) (*RespondNexusTaskCompletedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RespondNexusTaskCompleted not implemented")
}
func (UnimplementedMatchingServiceServer) RespondNexusTaskFailed(context.Context, *RespondNexusTaskFailedRequest) (*RespondNexusTaskFailedResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RespondNexusTaskFailed not implemented")
}
func (UnimplementedMatchingServiceServer) CancelOutstandingPoll(context.Context, *CancelOutstandingPollRequest) (*CancelOutstandingPollResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelOutstandingPoll not implemented")
}
func (UnimplementedMatchingServiceServer) DescribeTaskQueue(context.Context, *DescribeTaskQueueRequest) (*DescribeTaskQueueResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeTaskQueue not implemented")
}
func (UnimplementedMatchingServiceServer) DescribeTaskQueuePartition(context.Context, *DescribeTaskQueuePartitionRequest) (*DescribeTaskQueuePartitionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeTaskQueuePartition not implemented")
}
func (UnimplementedMatchingServiceServer) DescribeVersionedTaskQueues(context.Context, *DescribeVersionedTaskQueuesRequest) (*DescribeVersionedTaskQueuesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeVersionedTaskQueues not implemented")
}
func (UnimplementedMatchingServiceServer) ListTaskQueuePartitions(context.Context, *ListTaskQueuePartitionsRequest) (*ListTaskQueuePartitionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTaskQueuePartitions not implemented")
}
func (UnimplementedMatchingServiceServer) UpdateWorkerBuildIdCompatibility(context.Context, *UpdateWorkerBuildIdCompatibilityRequest) (*UpdateWorkerBuildIdCompatibilityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWorkerBuildIdCompatibility not implemented")
}
func (UnimplementedMatchingServiceServer) GetWorkerBuildIdCompatibility(context.Context, *GetWorkerBuildIdCompatibilityRequest) (*GetWorkerBuildIdCompatibilityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkerBuildIdCompatibility not implemented")
}
func (UnimplementedMatchingServiceServer) GetTaskQueueUserData(context.Context, *GetTaskQueueUserDataRequest) (*GetTaskQueueUserDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTaskQueueUserData not implemented")
}
func (UnimplementedMatchingServiceServer) UpdateWorkerVersioningRules(context.Context, *UpdateWorkerVersioningRulesRequest) (*UpdateWorkerVersioningRulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWorkerVersioningRules not implemented")
}
func (UnimplementedMatchingServiceServer) GetWorkerVersioningRules(context.Context, *GetWorkerVersioningRulesRequest) (*GetWorkerVersioningRulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkerVersioningRules not implemented")
}
func (UnimplementedMatchingServiceServer) SyncDeploymentUserData(context.Context, *SyncDeploymentUserDataRequest) (*SyncDeploymentUserDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SyncDeploymentUserData not implemented")
}
func (UnimplementedMatchingServiceServer) ApplyTaskQueueUserDataReplicationEvent(context.Context, *ApplyTaskQueueUserDataReplicationEventRequest) (*ApplyTaskQueueUserDataReplicationEventResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApplyTaskQueueUserDataReplicationEvent not implemented")
}
func (UnimplementedMatchingServiceServer) GetBuildIdTaskQueueMapping(context.Context, *GetBuildIdTaskQueueMappingRequest) (*GetBuildIdTaskQueueMappingResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBuildIdTaskQueueMapping not implemented")
}
func (UnimplementedMatchingServiceServer) ForceLoadTaskQueuePartition(context.Context, *ForceLoadTaskQueuePartitionRequest) (*ForceLoadTaskQueuePartitionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ForceLoadTaskQueuePartition not implemented")
}
func (UnimplementedMatchingServiceServer) ForceUnloadTaskQueue(context.Context, *ForceUnloadTaskQueueRequest) (*ForceUnloadTaskQueueResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ForceUnloadTaskQueue not implemented")
}
func (UnimplementedMatchingServiceServer) ForceUnloadTaskQueuePartition(context.Context, *ForceUnloadTaskQueuePartitionRequest) (*ForceUnloadTaskQueuePartitionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ForceUnloadTaskQueuePartition not implemented")
}
func (UnimplementedMatchingServiceServer) UpdateTaskQueueUserData(context.Context, *UpdateTaskQueueUserDataRequest) (*UpdateTaskQueueUserDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTaskQueueUserData not implemented")
}
func (UnimplementedMatchingServiceServer) ReplicateTaskQueueUserData(context.Context, *ReplicateTaskQueueUserDataRequest) (*ReplicateTaskQueueUserDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplicateTaskQueueUserData not implemented")
}
func (UnimplementedMatchingServiceServer) CheckTaskQueueUserDataPropagation(context.Context, *CheckTaskQueueUserDataPropagationRequest) (*CheckTaskQueueUserDataPropagationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckTaskQueueUserDataPropagation not implemented")
}
func (UnimplementedMatchingServiceServer) CreateNexusEndpoint(context.Context, *CreateNexusEndpointRequest) (*CreateNexusEndpointResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNexusEndpoint not implemented")
}
func (UnimplementedMatchingServiceServer) UpdateNexusEndpoint(context.Context, *UpdateNexusEndpointRequest) (*UpdateNexusEndpointResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNexusEndpoint not implemented")
}
func (UnimplementedMatchingServiceServer) DeleteNexusEndpoint(context.Context, *DeleteNexusEndpointRequest) (*DeleteNexusEndpointResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNexusEndpoint not implemented")
}
func (UnimplementedMatchingServiceServer) ListNexusEndpoints(context.Context, *ListNexusEndpointsRequest) (*ListNexusEndpointsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNexusEndpoints not implemented")
}
func (UnimplementedMatchingServiceServer) RecordWorkerHeartbeat(context.Context, *RecordWorkerHeartbeatRequest) (*RecordWorkerHeartbeatResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RecordWorkerHeartbeat not implemented")
}
func (UnimplementedMatchingServiceServer) ListWorkers(context.Context, *ListWorkersRequest) (*ListWorkersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkers not implemented")
}
func (UnimplementedMatchingServiceServer) UpdateTaskQueueConfig(context.Context, *UpdateTaskQueueConfigRequest) (*UpdateTaskQueueConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTaskQueueConfig not implemented")
}
func (UnimplementedMatchingServiceServer) DescribeWorker(context.Context, *DescribeWorkerRequest) (*DescribeWorkerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeWorker not implemented")
}
func (UnimplementedMatchingServiceServer) mustEmbedUnimplementedMatchingServiceServer() {}

// UnsafeMatchingServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MatchingServiceServer will
// result in compilation errors.
type UnsafeMatchingServiceServer interface {
	mustEmbedUnimplementedMatchingServiceServer()
}

func RegisterMatchingServiceServer(s grpc.ServiceRegistrar, srv MatchingServiceServer) {
	s.RegisterService(&MatchingService_ServiceDesc, srv)
}

func _MatchingService_PollWorkflowTaskQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PollWorkflowTaskQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).PollWorkflowTaskQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_PollWorkflowTaskQueue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).PollWorkflowTaskQueue(ctx, req.(*PollWorkflowTaskQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_PollActivityTaskQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PollActivityTaskQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).PollActivityTaskQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_PollActivityTaskQueue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).PollActivityTaskQueue(ctx, req.(*PollActivityTaskQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_AddWorkflowTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddWorkflowTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).AddWorkflowTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_AddWorkflowTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).AddWorkflowTask(ctx, req.(*AddWorkflowTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_AddActivityTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddActivityTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).AddActivityTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_AddActivityTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).AddActivityTask(ctx, req.(*AddActivityTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_QueryWorkflow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryWorkflowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).QueryWorkflow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_QueryWorkflow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).QueryWorkflow(ctx, req.(*QueryWorkflowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_RespondQueryTaskCompleted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RespondQueryTaskCompletedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).RespondQueryTaskCompleted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_RespondQueryTaskCompleted_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).RespondQueryTaskCompleted(ctx, req.(*RespondQueryTaskCompletedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_DispatchNexusTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DispatchNexusTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).DispatchNexusTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_DispatchNexusTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).DispatchNexusTask(ctx, req.(*DispatchNexusTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_PollNexusTaskQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PollNexusTaskQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).PollNexusTaskQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_PollNexusTaskQueue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).PollNexusTaskQueue(ctx, req.(*PollNexusTaskQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_RespondNexusTaskCompleted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RespondNexusTaskCompletedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).RespondNexusTaskCompleted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_RespondNexusTaskCompleted_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).RespondNexusTaskCompleted(ctx, req.(*RespondNexusTaskCompletedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_RespondNexusTaskFailed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RespondNexusTaskFailedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).RespondNexusTaskFailed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_RespondNexusTaskFailed_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).RespondNexusTaskFailed(ctx, req.(*RespondNexusTaskFailedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_CancelOutstandingPoll_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelOutstandingPollRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).CancelOutstandingPoll(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_CancelOutstandingPoll_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).CancelOutstandingPoll(ctx, req.(*CancelOutstandingPollRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_DescribeTaskQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeTaskQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).DescribeTaskQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_DescribeTaskQueue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).DescribeTaskQueue(ctx, req.(*DescribeTaskQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_DescribeTaskQueuePartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeTaskQueuePartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).DescribeTaskQueuePartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_DescribeTaskQueuePartition_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).DescribeTaskQueuePartition(ctx, req.(*DescribeTaskQueuePartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_DescribeVersionedTaskQueues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeVersionedTaskQueuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).DescribeVersionedTaskQueues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_DescribeVersionedTaskQueues_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).DescribeVersionedTaskQueues(ctx, req.(*DescribeVersionedTaskQueuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_ListTaskQueuePartitions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTaskQueuePartitionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).ListTaskQueuePartitions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_ListTaskQueuePartitions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).ListTaskQueuePartitions(ctx, req.(*ListTaskQueuePartitionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_UpdateWorkerBuildIdCompatibility_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkerBuildIdCompatibilityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).UpdateWorkerBuildIdCompatibility(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_UpdateWorkerBuildIdCompatibility_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).UpdateWorkerBuildIdCompatibility(ctx, req.(*UpdateWorkerBuildIdCompatibilityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_GetWorkerBuildIdCompatibility_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkerBuildIdCompatibilityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).GetWorkerBuildIdCompatibility(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_GetWorkerBuildIdCompatibility_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).GetWorkerBuildIdCompatibility(ctx, req.(*GetWorkerBuildIdCompatibilityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_GetTaskQueueUserData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTaskQueueUserDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).GetTaskQueueUserData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_GetTaskQueueUserData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).GetTaskQueueUserData(ctx, req.(*GetTaskQueueUserDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_UpdateWorkerVersioningRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkerVersioningRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).UpdateWorkerVersioningRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_UpdateWorkerVersioningRules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).UpdateWorkerVersioningRules(ctx, req.(*UpdateWorkerVersioningRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_GetWorkerVersioningRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkerVersioningRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).GetWorkerVersioningRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_GetWorkerVersioningRules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).GetWorkerVersioningRules(ctx, req.(*GetWorkerVersioningRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_SyncDeploymentUserData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SyncDeploymentUserDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).SyncDeploymentUserData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_SyncDeploymentUserData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).SyncDeploymentUserData(ctx, req.(*SyncDeploymentUserDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_ApplyTaskQueueUserDataReplicationEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyTaskQueueUserDataReplicationEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).ApplyTaskQueueUserDataReplicationEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_ApplyTaskQueueUserDataReplicationEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).ApplyTaskQueueUserDataReplicationEvent(ctx, req.(*ApplyTaskQueueUserDataReplicationEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_GetBuildIdTaskQueueMapping_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBuildIdTaskQueueMappingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).GetBuildIdTaskQueueMapping(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_GetBuildIdTaskQueueMapping_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).GetBuildIdTaskQueueMapping(ctx, req.(*GetBuildIdTaskQueueMappingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_ForceLoadTaskQueuePartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ForceLoadTaskQueuePartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).ForceLoadTaskQueuePartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_ForceLoadTaskQueuePartition_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).ForceLoadTaskQueuePartition(ctx, req.(*ForceLoadTaskQueuePartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_ForceUnloadTaskQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ForceUnloadTaskQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).ForceUnloadTaskQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_ForceUnloadTaskQueue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).ForceUnloadTaskQueue(ctx, req.(*ForceUnloadTaskQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_ForceUnloadTaskQueuePartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ForceUnloadTaskQueuePartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).ForceUnloadTaskQueuePartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_ForceUnloadTaskQueuePartition_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).ForceUnloadTaskQueuePartition(ctx, req.(*ForceUnloadTaskQueuePartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_UpdateTaskQueueUserData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTaskQueueUserDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).UpdateTaskQueueUserData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_UpdateTaskQueueUserData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).UpdateTaskQueueUserData(ctx, req.(*UpdateTaskQueueUserDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_ReplicateTaskQueueUserData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplicateTaskQueueUserDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).ReplicateTaskQueueUserData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_ReplicateTaskQueueUserData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).ReplicateTaskQueueUserData(ctx, req.(*ReplicateTaskQueueUserDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_CheckTaskQueueUserDataPropagation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckTaskQueueUserDataPropagationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).CheckTaskQueueUserDataPropagation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_CheckTaskQueueUserDataPropagation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).CheckTaskQueueUserDataPropagation(ctx, req.(*CheckTaskQueueUserDataPropagationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_CreateNexusEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNexusEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).CreateNexusEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_CreateNexusEndpoint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).CreateNexusEndpoint(ctx, req.(*CreateNexusEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_UpdateNexusEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNexusEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).UpdateNexusEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_UpdateNexusEndpoint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).UpdateNexusEndpoint(ctx, req.(*UpdateNexusEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_DeleteNexusEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNexusEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).DeleteNexusEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_DeleteNexusEndpoint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).DeleteNexusEndpoint(ctx, req.(*DeleteNexusEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_ListNexusEndpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNexusEndpointsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).ListNexusEndpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_ListNexusEndpoints_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).ListNexusEndpoints(ctx, req.(*ListNexusEndpointsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_RecordWorkerHeartbeat_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecordWorkerHeartbeatRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).RecordWorkerHeartbeat(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_RecordWorkerHeartbeat_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).RecordWorkerHeartbeat(ctx, req.(*RecordWorkerHeartbeatRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_ListWorkers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).ListWorkers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_ListWorkers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).ListWorkers(ctx, req.(*ListWorkersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_UpdateTaskQueueConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTaskQueueConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).UpdateTaskQueueConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_UpdateTaskQueueConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).UpdateTaskQueueConfig(ctx, req.(*UpdateTaskQueueConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MatchingService_DescribeWorker_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeWorkerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MatchingServiceServer).DescribeWorker(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MatchingService_DescribeWorker_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MatchingServiceServer).DescribeWorker(ctx, req.(*DescribeWorkerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// MatchingService_ServiceDesc is the grpc.ServiceDesc for MatchingService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var MatchingService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "temporal.server.api.matchingservice.v1.MatchingService",
	HandlerType: (*MatchingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "PollWorkflowTaskQueue",
			Handler:    _MatchingService_PollWorkflowTaskQueue_Handler,
		},
		{
			MethodName: "PollActivityTaskQueue",
			Handler:    _MatchingService_PollActivityTaskQueue_Handler,
		},
		{
			MethodName: "AddWorkflowTask",
			Handler:    _MatchingService_AddWorkflowTask_Handler,
		},
		{
			MethodName: "AddActivityTask",
			Handler:    _MatchingService_AddActivityTask_Handler,
		},
		{
			MethodName: "QueryWorkflow",
			Handler:    _MatchingService_QueryWorkflow_Handler,
		},
		{
			MethodName: "RespondQueryTaskCompleted",
			Handler:    _MatchingService_RespondQueryTaskCompleted_Handler,
		},
		{
			MethodName: "DispatchNexusTask",
			Handler:    _MatchingService_DispatchNexusTask_Handler,
		},
		{
			MethodName: "PollNexusTaskQueue",
			Handler:    _MatchingService_PollNexusTaskQueue_Handler,
		},
		{
			MethodName: "RespondNexusTaskCompleted",
			Handler:    _MatchingService_RespondNexusTaskCompleted_Handler,
		},
		{
			MethodName: "RespondNexusTaskFailed",
			Handler:    _MatchingService_RespondNexusTaskFailed_Handler,
		},
		{
			MethodName: "CancelOutstandingPoll",
			Handler:    _MatchingService_CancelOutstandingPoll_Handler,
		},
		{
			MethodName: "DescribeTaskQueue",
			Handler:    _MatchingService_DescribeTaskQueue_Handler,
		},
		{
			MethodName: "DescribeTaskQueuePartition",
			Handler:    _MatchingService_DescribeTaskQueuePartition_Handler,
		},
		{
			MethodName: "DescribeVersionedTaskQueues",
			Handler:    _MatchingService_DescribeVersionedTaskQueues_Handler,
		},
		{
			MethodName: "ListTaskQueuePartitions",
			Handler:    _MatchingService_ListTaskQueuePartitions_Handler,
		},
		{
			MethodName: "UpdateWorkerBuildIdCompatibility",
			Handler:    _MatchingService_UpdateWorkerBuildIdCompatibility_Handler,
		},
		{
			MethodName: "GetWorkerBuildIdCompatibility",
			Handler:    _MatchingService_GetWorkerBuildIdCompatibility_Handler,
		},
		{
			MethodName: "GetTaskQueueUserData",
			Handler:    _MatchingService_GetTaskQueueUserData_Handler,
		},
		{
			MethodName: "UpdateWorkerVersioningRules",
			Handler:    _MatchingService_UpdateWorkerVersioningRules_Handler,
		},
		{
			MethodName: "GetWorkerVersioningRules",
			Handler:    _MatchingService_GetWorkerVersioningRules_Handler,
		},
		{
			MethodName: "SyncDeploymentUserData",
			Handler:    _MatchingService_SyncDeploymentUserData_Handler,
		},
		{
			MethodName: "ApplyTaskQueueUserDataReplicationEvent",
			Handler:    _MatchingService_ApplyTaskQueueUserDataReplicationEvent_Handler,
		},
		{
			MethodName: "GetBuildIdTaskQueueMapping",
			Handler:    _MatchingService_GetBuildIdTaskQueueMapping_Handler,
		},
		{
			MethodName: "ForceLoadTaskQueuePartition",
			Handler:    _MatchingService_ForceLoadTaskQueuePartition_Handler,
		},
		{
			MethodName: "ForceUnloadTaskQueue",
			Handler:    _MatchingService_ForceUnloadTaskQueue_Handler,
		},
		{
			MethodName: "ForceUnloadTaskQueuePartition",
			Handler:    _MatchingService_ForceUnloadTaskQueuePartition_Handler,
		},
		{
			MethodName: "UpdateTaskQueueUserData",
			Handler:    _MatchingService_UpdateTaskQueueUserData_Handler,
		},
		{
			MethodName: "ReplicateTaskQueueUserData",
			Handler:    _MatchingService_ReplicateTaskQueueUserData_Handler,
		},
		{
			MethodName: "CheckTaskQueueUserDataPropagation",
			Handler:    _MatchingService_CheckTaskQueueUserDataPropagation_Handler,
		},
		{
			MethodName: "CreateNexusEndpoint",
			Handler:    _MatchingService_CreateNexusEndpoint_Handler,
		},
		{
			MethodName: "UpdateNexusEndpoint",
			Handler:    _MatchingService_UpdateNexusEndpoint_Handler,
		},
		{
			MethodName: "DeleteNexusEndpoint",
			Handler:    _MatchingService_DeleteNexusEndpoint_Handler,
		},
		{
			MethodName: "ListNexusEndpoints",
			Handler:    _MatchingService_ListNexusEndpoints_Handler,
		},
		{
			MethodName: "RecordWorkerHeartbeat",
			Handler:    _MatchingService_RecordWorkerHeartbeat_Handler,
		},
		{
			MethodName: "ListWorkers",
			Handler:    _MatchingService_ListWorkers_Handler,
		},
		{
			MethodName: "UpdateTaskQueueConfig",
			Handler:    _MatchingService_UpdateTaskQueueConfig_Handler,
		},
		{
			MethodName: "DescribeWorker",
			Handler:    _MatchingService_DescribeWorker_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "temporal/server/api/matchingservice/v1/service.proto",
}
