// Code generated by protoc-gen-go. DO NOT EDIT.
// plugins:
// 	protoc-gen-go
// 	protoc
// source: temporal/server/api/persistence/v1/hsm.proto

package persistence

import (
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A node in a hierarchical state machine tree.
type StateMachineNode struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Serialized data of the underlying state machine.
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// Map of state machine type to a map of machines by ID.
	Children map[string]*StateMachineMap `protobuf:"bytes,2,rep,name=children,proto3" json:"children,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Versioned transition when the node was instantiated.
	// This field, plus node path uniquely identifies a state machine node in a mutable state instance.
	// This field will always be set even when transition history is disabled.
	// NOTE: If transition history is disabled, the transition_count field will be 0 and
	// cannot be used to uniquely identify a node.
	// NOTE: Node deletion is not yet implemented at the time of writing so we can still uniquely identify a node just
	// with the initial namespace failover version.
	InitialVersionedTransition *VersionedTransition `protobuf:"bytes,3,opt,name=initial_versioned_transition,json=initialVersionedTransition,proto3" json:"initial_versioned_transition,omitempty"`
	// Versioned transition when the node was last updated.
	// This field will always be set even when transition history is disabled.
	// NOTE: If transition history is disabled, the transition_count field will be 0 and
	// cannot be used for non-concurrent task staleness check or to determine whether this node should be synced
	// during state replication.
	LastUpdateVersionedTransition *VersionedTransition `protobuf:"bytes,4,opt,name=last_update_versioned_transition,json=lastUpdateVersionedTransition,proto3" json:"last_update_versioned_transition,omitempty"`
	// Number of transitions on this state machine object.
	// Used to verify that a task is not stale if the state machine does not allow concurrent task execution.
	// The transition count monotonically increases with each state transition and only resets when the entire
	// mutable state was rebuilt. This case is handled by the task_generation_shard_clock_timestamp field in
	// WorkflowExecutionInfo.
	// NOTE: This field is cluster specific and cannot be replicated.
	// NOTE: This field will be made obsolete when transition history is enabled in favor of
	// last_update_versioned_transition.
	TransitionCount int64 `protobuf:"varint,100,opt,name=transition_count,json=transitionCount,proto3" json:"transition_count,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *StateMachineNode) Reset() {
	*x = StateMachineNode{}
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StateMachineNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateMachineNode) ProtoMessage() {}

func (x *StateMachineNode) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateMachineNode.ProtoReflect.Descriptor instead.
func (*StateMachineNode) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_persistence_v1_hsm_proto_rawDescGZIP(), []int{0}
}

func (x *StateMachineNode) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *StateMachineNode) GetChildren() map[string]*StateMachineMap {
	if x != nil {
		return x.Children
	}
	return nil
}

func (x *StateMachineNode) GetInitialVersionedTransition() *VersionedTransition {
	if x != nil {
		return x.InitialVersionedTransition
	}
	return nil
}

func (x *StateMachineNode) GetLastUpdateVersionedTransition() *VersionedTransition {
	if x != nil {
		return x.LastUpdateVersionedTransition
	}
	return nil
}

func (x *StateMachineNode) GetTransitionCount() int64 {
	if x != nil {
		return x.TransitionCount
	}
	return 0
}

// Map of state machine ID to StateMachineNode.
type StateMachineMap struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// (-- api-linter: core::0140::prepositions=disabled
	//
	//	aip.dev/not-precedent: "by" is used to clarify the keys and values. --)
	MachinesById  map[string]*StateMachineNode `protobuf:"bytes,1,rep,name=machines_by_id,json=machinesById,proto3" json:"machines_by_id,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StateMachineMap) Reset() {
	*x = StateMachineMap{}
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StateMachineMap) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateMachineMap) ProtoMessage() {}

func (x *StateMachineMap) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateMachineMap.ProtoReflect.Descriptor instead.
func (*StateMachineMap) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_persistence_v1_hsm_proto_rawDescGZIP(), []int{1}
}

func (x *StateMachineMap) GetMachinesById() map[string]*StateMachineNode {
	if x != nil {
		return x.MachinesById
	}
	return nil
}

type StateMachineKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Addressable type of the corresponding state machine in a single tree level.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Addressable ID of the corresponding state machine in a single tree level.
	Id            string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StateMachineKey) Reset() {
	*x = StateMachineKey{}
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StateMachineKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateMachineKey) ProtoMessage() {}

func (x *StateMachineKey) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateMachineKey.ProtoReflect.Descriptor instead.
func (*StateMachineKey) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_persistence_v1_hsm_proto_rawDescGZIP(), []int{2}
}

func (x *StateMachineKey) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *StateMachineKey) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// A reference to a state machine at a point in time.
type StateMachineRef struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Nested path to a state machine.
	Path []*StateMachineKey `protobuf:"bytes,1,rep,name=path,proto3" json:"path,omitempty"`
	// Versioned transition of the ref was instantiated.
	// Used to verify that the ref is not referencing a stale state or, in some situations,
	// that the ref itself is not stale.
	// NOTE: If transition history is disabled, the field will not be specified and
	// cannot be used for staleness check.
	MutableStateVersionedTransition *VersionedTransition `protobuf:"bytes,2,opt,name=mutable_state_versioned_transition,json=mutableStateVersionedTransition,proto3" json:"mutable_state_versioned_transition,omitempty"`
	// Versioned transition when the state machine node was instantiated.
	// This field, plus node path uniquely identifies a state machine node in a mutable state instance.
	// This field will always be set even when transition history is disabled.
	// NOTE: If transition history is disabled, the transition_count field will be 0 and
	// cannot be used to uniquely identify a node.
	// NOTE: Node deletion is not yet implemented at the time of writing so we can still uniquely identify a node just
	// with the initial namespace failover version.
	MachineInitialVersionedTransition *VersionedTransition `protobuf:"bytes,3,opt,name=machine_initial_versioned_transition,json=machineInitialVersionedTransition,proto3" json:"machine_initial_versioned_transition,omitempty"`
	// Versioned transition when the state machine node was last updated.
	// If not specified, this reference is considered non-concurrent,
	// and should match the last_update_versioned_transition on the corresponding state machine node.
	// NOTE: If transition history is disabled, the transition_count field will be 0 and
	// cannot be used for non-concurrent task staleness check.
	MachineLastUpdateVersionedTransition *VersionedTransition `protobuf:"bytes,4,opt,name=machine_last_update_versioned_transition,json=machineLastUpdateVersionedTransition,proto3" json:"machine_last_update_versioned_transition,omitempty"`
	// Number of transitions executed on the referenced state machine node at the time this Ref is instantiated.
	// If non-zero, this reference is considered non-concurrent and this number should match the number of state
	// transitions on the corresponding state machine node.
	// This field will be obsolete once mutable state transition history is productionized.
	MachineTransitionCount int64 `protobuf:"varint,100,opt,name=machine_transition_count,json=machineTransitionCount,proto3" json:"machine_transition_count,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *StateMachineRef) Reset() {
	*x = StateMachineRef{}
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StateMachineRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateMachineRef) ProtoMessage() {}

func (x *StateMachineRef) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateMachineRef.ProtoReflect.Descriptor instead.
func (*StateMachineRef) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_persistence_v1_hsm_proto_rawDescGZIP(), []int{3}
}

func (x *StateMachineRef) GetPath() []*StateMachineKey {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *StateMachineRef) GetMutableStateVersionedTransition() *VersionedTransition {
	if x != nil {
		return x.MutableStateVersionedTransition
	}
	return nil
}

func (x *StateMachineRef) GetMachineInitialVersionedTransition() *VersionedTransition {
	if x != nil {
		return x.MachineInitialVersionedTransition
	}
	return nil
}

func (x *StateMachineRef) GetMachineLastUpdateVersionedTransition() *VersionedTransition {
	if x != nil {
		return x.MachineLastUpdateVersionedTransition
	}
	return nil
}

func (x *StateMachineRef) GetMachineTransitionCount() int64 {
	if x != nil {
		return x.MachineTransitionCount
	}
	return 0
}

type StateMachineTaskInfo struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Reference to a state machine.
	Ref *StateMachineRef `protobuf:"bytes,1,opt,name=ref,proto3" json:"ref,omitempty"`
	// Task type. Not to be confused with the state machine's type in the `ref` field.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Opaque data attached to this task. May be nil. Deserialized by a registered TaskSerializer for this type.
	Data          []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StateMachineTaskInfo) Reset() {
	*x = StateMachineTaskInfo{}
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StateMachineTaskInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateMachineTaskInfo) ProtoMessage() {}

func (x *StateMachineTaskInfo) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateMachineTaskInfo.ProtoReflect.Descriptor instead.
func (*StateMachineTaskInfo) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_persistence_v1_hsm_proto_rawDescGZIP(), []int{4}
}

func (x *StateMachineTaskInfo) GetRef() *StateMachineRef {
	if x != nil {
		return x.Ref
	}
	return nil
}

func (x *StateMachineTaskInfo) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *StateMachineTaskInfo) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// A group of state machine timer tasks for a given deadline, used for collapsing state machine timer tasks.
type StateMachineTimerGroup struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Task information.
	Infos []*StateMachineTaskInfo `protobuf:"bytes,1,rep,name=infos,proto3" json:"infos,omitempty"`
	// When this timer should be fired.
	// (-- api-linter: core::0142::time-field-names=disabled
	//
	//	aip.dev/not-precedent: Ignoring lint rules. --)
	Deadline *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=deadline,proto3" json:"deadline,omitempty"`
	// Whether or not a task was put in the queue for this group's deadline.
	Scheduled     bool `protobuf:"varint,3,opt,name=scheduled,proto3" json:"scheduled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StateMachineTimerGroup) Reset() {
	*x = StateMachineTimerGroup{}
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StateMachineTimerGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateMachineTimerGroup) ProtoMessage() {}

func (x *StateMachineTimerGroup) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateMachineTimerGroup.ProtoReflect.Descriptor instead.
func (*StateMachineTimerGroup) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_persistence_v1_hsm_proto_rawDescGZIP(), []int{5}
}

func (x *StateMachineTimerGroup) GetInfos() []*StateMachineTaskInfo {
	if x != nil {
		return x.Infos
	}
	return nil
}

func (x *StateMachineTimerGroup) GetDeadline() *timestamppb.Timestamp {
	if x != nil {
		return x.Deadline
	}
	return nil
}

func (x *StateMachineTimerGroup) GetScheduled() bool {
	if x != nil {
		return x.Scheduled
	}
	return false
}

// VersionedTransition is a unique identifier for a specific mutable state transition.
type VersionedTransition struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The namespace failover version at transition time.
	NamespaceFailoverVersion int64 `protobuf:"varint,1,opt,name=namespace_failover_version,json=namespaceFailoverVersion,proto3" json:"namespace_failover_version,omitempty"`
	// State transition count perceived during the specified namespace_failover_version.
	TransitionCount int64 `protobuf:"varint,2,opt,name=transition_count,json=transitionCount,proto3" json:"transition_count,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *VersionedTransition) Reset() {
	*x = VersionedTransition{}
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VersionedTransition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionedTransition) ProtoMessage() {}

func (x *VersionedTransition) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionedTransition.ProtoReflect.Descriptor instead.
func (*VersionedTransition) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_persistence_v1_hsm_proto_rawDescGZIP(), []int{6}
}

func (x *VersionedTransition) GetNamespaceFailoverVersion() int64 {
	if x != nil {
		return x.NamespaceFailoverVersion
	}
	return 0
}

func (x *VersionedTransition) GetTransitionCount() int64 {
	if x != nil {
		return x.TransitionCount
	}
	return 0
}

type StateMachineTombstoneBatch struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The versioned transition in which the tombstones were created.
	VersionedTransition    *VersionedTransition     `protobuf:"bytes,1,opt,name=versioned_transition,json=versionedTransition,proto3" json:"versioned_transition,omitempty"`
	StateMachineTombstones []*StateMachineTombstone `protobuf:"bytes,2,rep,name=state_machine_tombstones,json=stateMachineTombstones,proto3" json:"state_machine_tombstones,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *StateMachineTombstoneBatch) Reset() {
	*x = StateMachineTombstoneBatch{}
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StateMachineTombstoneBatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateMachineTombstoneBatch) ProtoMessage() {}

func (x *StateMachineTombstoneBatch) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateMachineTombstoneBatch.ProtoReflect.Descriptor instead.
func (*StateMachineTombstoneBatch) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_persistence_v1_hsm_proto_rawDescGZIP(), []int{7}
}

func (x *StateMachineTombstoneBatch) GetVersionedTransition() *VersionedTransition {
	if x != nil {
		return x.VersionedTransition
	}
	return nil
}

func (x *StateMachineTombstoneBatch) GetStateMachineTombstones() []*StateMachineTombstone {
	if x != nil {
		return x.StateMachineTombstones
	}
	return nil
}

type StateMachineTombstone struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to StateMachineKey:
	//
	//	*StateMachineTombstone_ActivityScheduledEventId
	//	*StateMachineTombstone_TimerId
	//	*StateMachineTombstone_ChildExecutionInitiatedEventId
	//	*StateMachineTombstone_RequestCancelInitiatedEventId
	//	*StateMachineTombstone_SignalExternalInitiatedEventId
	//	*StateMachineTombstone_UpdateId
	//	*StateMachineTombstone_StateMachinePath
	//	*StateMachineTombstone_ChasmNodePath
	StateMachineKey isStateMachineTombstone_StateMachineKey `protobuf_oneof:"state_machine_key"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *StateMachineTombstone) Reset() {
	*x = StateMachineTombstone{}
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StateMachineTombstone) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateMachineTombstone) ProtoMessage() {}

func (x *StateMachineTombstone) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateMachineTombstone.ProtoReflect.Descriptor instead.
func (*StateMachineTombstone) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_persistence_v1_hsm_proto_rawDescGZIP(), []int{8}
}

func (x *StateMachineTombstone) GetStateMachineKey() isStateMachineTombstone_StateMachineKey {
	if x != nil {
		return x.StateMachineKey
	}
	return nil
}

func (x *StateMachineTombstone) GetActivityScheduledEventId() int64 {
	if x != nil {
		if x, ok := x.StateMachineKey.(*StateMachineTombstone_ActivityScheduledEventId); ok {
			return x.ActivityScheduledEventId
		}
	}
	return 0
}

func (x *StateMachineTombstone) GetTimerId() string {
	if x != nil {
		if x, ok := x.StateMachineKey.(*StateMachineTombstone_TimerId); ok {
			return x.TimerId
		}
	}
	return ""
}

func (x *StateMachineTombstone) GetChildExecutionInitiatedEventId() int64 {
	if x != nil {
		if x, ok := x.StateMachineKey.(*StateMachineTombstone_ChildExecutionInitiatedEventId); ok {
			return x.ChildExecutionInitiatedEventId
		}
	}
	return 0
}

func (x *StateMachineTombstone) GetRequestCancelInitiatedEventId() int64 {
	if x != nil {
		if x, ok := x.StateMachineKey.(*StateMachineTombstone_RequestCancelInitiatedEventId); ok {
			return x.RequestCancelInitiatedEventId
		}
	}
	return 0
}

func (x *StateMachineTombstone) GetSignalExternalInitiatedEventId() int64 {
	if x != nil {
		if x, ok := x.StateMachineKey.(*StateMachineTombstone_SignalExternalInitiatedEventId); ok {
			return x.SignalExternalInitiatedEventId
		}
	}
	return 0
}

func (x *StateMachineTombstone) GetUpdateId() string {
	if x != nil {
		if x, ok := x.StateMachineKey.(*StateMachineTombstone_UpdateId); ok {
			return x.UpdateId
		}
	}
	return ""
}

func (x *StateMachineTombstone) GetStateMachinePath() *StateMachinePath {
	if x != nil {
		if x, ok := x.StateMachineKey.(*StateMachineTombstone_StateMachinePath); ok {
			return x.StateMachinePath
		}
	}
	return nil
}

func (x *StateMachineTombstone) GetChasmNodePath() string {
	if x != nil {
		if x, ok := x.StateMachineKey.(*StateMachineTombstone_ChasmNodePath); ok {
			return x.ChasmNodePath
		}
	}
	return ""
}

type isStateMachineTombstone_StateMachineKey interface {
	isStateMachineTombstone_StateMachineKey()
}

type StateMachineTombstone_ActivityScheduledEventId struct {
	ActivityScheduledEventId int64 `protobuf:"varint,1,opt,name=activity_scheduled_event_id,json=activityScheduledEventId,proto3,oneof"`
}

type StateMachineTombstone_TimerId struct {
	TimerId string `protobuf:"bytes,2,opt,name=timer_id,json=timerId,proto3,oneof"`
}

type StateMachineTombstone_ChildExecutionInitiatedEventId struct {
	ChildExecutionInitiatedEventId int64 `protobuf:"varint,3,opt,name=child_execution_initiated_event_id,json=childExecutionInitiatedEventId,proto3,oneof"`
}

type StateMachineTombstone_RequestCancelInitiatedEventId struct {
	RequestCancelInitiatedEventId int64 `protobuf:"varint,4,opt,name=request_cancel_initiated_event_id,json=requestCancelInitiatedEventId,proto3,oneof"`
}

type StateMachineTombstone_SignalExternalInitiatedEventId struct {
	SignalExternalInitiatedEventId int64 `protobuf:"varint,5,opt,name=signal_external_initiated_event_id,json=signalExternalInitiatedEventId,proto3,oneof"`
}

type StateMachineTombstone_UpdateId struct {
	UpdateId string `protobuf:"bytes,6,opt,name=update_id,json=updateId,proto3,oneof"`
}

type StateMachineTombstone_StateMachinePath struct {
	StateMachinePath *StateMachinePath `protobuf:"bytes,7,opt,name=state_machine_path,json=stateMachinePath,proto3,oneof"`
}

type StateMachineTombstone_ChasmNodePath struct {
	ChasmNodePath string `protobuf:"bytes,8,opt,name=chasm_node_path,json=chasmNodePath,proto3,oneof"`
}

func (*StateMachineTombstone_ActivityScheduledEventId) isStateMachineTombstone_StateMachineKey() {}

func (*StateMachineTombstone_TimerId) isStateMachineTombstone_StateMachineKey() {}

func (*StateMachineTombstone_ChildExecutionInitiatedEventId) isStateMachineTombstone_StateMachineKey() {
}

func (*StateMachineTombstone_RequestCancelInitiatedEventId) isStateMachineTombstone_StateMachineKey() {
}

func (*StateMachineTombstone_SignalExternalInitiatedEventId) isStateMachineTombstone_StateMachineKey() {
}

func (*StateMachineTombstone_UpdateId) isStateMachineTombstone_StateMachineKey() {}

func (*StateMachineTombstone_StateMachinePath) isStateMachineTombstone_StateMachineKey() {}

func (*StateMachineTombstone_ChasmNodePath) isStateMachineTombstone_StateMachineKey() {}

type StateMachinePath struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Path          []*StateMachineKey     `protobuf:"bytes,1,rep,name=path,proto3" json:"path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StateMachinePath) Reset() {
	*x = StateMachinePath{}
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StateMachinePath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateMachinePath) ProtoMessage() {}

func (x *StateMachinePath) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateMachinePath.ProtoReflect.Descriptor instead.
func (*StateMachinePath) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_persistence_v1_hsm_proto_rawDescGZIP(), []int{9}
}

func (x *StateMachinePath) GetPath() []*StateMachineKey {
	if x != nil {
		return x.Path
	}
	return nil
}

var File_temporal_server_api_persistence_v1_hsm_proto protoreflect.FileDescriptor

const file_temporal_server_api_persistence_v1_hsm_proto_rawDesc = "" +
	"\n" +
	",temporal/server/api/persistence/v1/hsm.proto\x12\"temporal.server.api.persistence.v1\x1a\x1fgoogle/protobuf/timestamp.proto\"\xa1\x04\n" +
	"\x10StateMachineNode\x12\x12\n" +
	"\x04data\x18\x01 \x01(\fR\x04data\x12^\n" +
	"\bchildren\x18\x02 \x03(\v2B.temporal.server.api.persistence.v1.StateMachineNode.ChildrenEntryR\bchildren\x12y\n" +
	"\x1cinitial_versioned_transition\x18\x03 \x01(\v27.temporal.server.api.persistence.v1.VersionedTransitionR\x1ainitialVersionedTransition\x12\x80\x01\n" +
	" last_update_versioned_transition\x18\x04 \x01(\v27.temporal.server.api.persistence.v1.VersionedTransitionR\x1dlastUpdateVersionedTransition\x12)\n" +
	"\x10transition_count\x18d \x01(\x03R\x0ftransitionCount\x1ap\n" +
	"\rChildrenEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12I\n" +
	"\x05value\x18\x02 \x01(\v23.temporal.server.api.persistence.v1.StateMachineMapR\x05value:\x028\x01\"\xf5\x01\n" +
	"\x0fStateMachineMap\x12k\n" +
	"\x0emachines_by_id\x18\x01 \x03(\v2E.temporal.server.api.persistence.v1.StateMachineMap.MachinesByIdEntryR\fmachinesById\x1au\n" +
	"\x11MachinesByIdEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12J\n" +
	"\x05value\x18\x02 \x01(\v24.temporal.server.api.persistence.v1.StateMachineNodeR\x05value:\x028\x01\"5\n" +
	"\x0fStateMachineKey\x12\x12\n" +
	"\x04type\x18\x01 \x01(\tR\x04type\x12\x0e\n" +
	"\x02id\x18\x02 \x01(\tR\x02id\"\xb8\x04\n" +
	"\x0fStateMachineRef\x12G\n" +
	"\x04path\x18\x01 \x03(\v23.temporal.server.api.persistence.v1.StateMachineKeyR\x04path\x12\x84\x01\n" +
	"\"mutable_state_versioned_transition\x18\x02 \x01(\v27.temporal.server.api.persistence.v1.VersionedTransitionR\x1fmutableStateVersionedTransition\x12\x88\x01\n" +
	"$machine_initial_versioned_transition\x18\x03 \x01(\v27.temporal.server.api.persistence.v1.VersionedTransitionR!machineInitialVersionedTransition\x12\x8f\x01\n" +
	"(machine_last_update_versioned_transition\x18\x04 \x01(\v27.temporal.server.api.persistence.v1.VersionedTransitionR$machineLastUpdateVersionedTransition\x128\n" +
	"\x18machine_transition_count\x18d \x01(\x03R\x16machineTransitionCount\"\x85\x01\n" +
	"\x14StateMachineTaskInfo\x12E\n" +
	"\x03ref\x18\x01 \x01(\v23.temporal.server.api.persistence.v1.StateMachineRefR\x03ref\x12\x12\n" +
	"\x04type\x18\x02 \x01(\tR\x04type\x12\x12\n" +
	"\x04data\x18\x03 \x01(\fR\x04data\"\xbe\x01\n" +
	"\x16StateMachineTimerGroup\x12N\n" +
	"\x05infos\x18\x01 \x03(\v28.temporal.server.api.persistence.v1.StateMachineTaskInfoR\x05infos\x126\n" +
	"\bdeadline\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\bdeadline\x12\x1c\n" +
	"\tscheduled\x18\x03 \x01(\bR\tscheduled\"~\n" +
	"\x13VersionedTransition\x12<\n" +
	"\x1anamespace_failover_version\x18\x01 \x01(\x03R\x18namespaceFailoverVersion\x12)\n" +
	"\x10transition_count\x18\x02 \x01(\x03R\x0ftransitionCount\"\xfd\x01\n" +
	"\x1aStateMachineTombstoneBatch\x12j\n" +
	"\x14versioned_transition\x18\x01 \x01(\v27.temporal.server.api.persistence.v1.VersionedTransitionR\x13versionedTransition\x12s\n" +
	"\x18state_machine_tombstones\x18\x02 \x03(\v29.temporal.server.api.persistence.v1.StateMachineTombstoneR\x16stateMachineTombstones\"\xa1\x04\n" +
	"\x15StateMachineTombstone\x12?\n" +
	"\x1bactivity_scheduled_event_id\x18\x01 \x01(\x03H\x00R\x18activityScheduledEventId\x12\x1b\n" +
	"\btimer_id\x18\x02 \x01(\tH\x00R\atimerId\x12L\n" +
	"\"child_execution_initiated_event_id\x18\x03 \x01(\x03H\x00R\x1echildExecutionInitiatedEventId\x12J\n" +
	"!request_cancel_initiated_event_id\x18\x04 \x01(\x03H\x00R\x1drequestCancelInitiatedEventId\x12L\n" +
	"\"signal_external_initiated_event_id\x18\x05 \x01(\x03H\x00R\x1esignalExternalInitiatedEventId\x12\x1d\n" +
	"\tupdate_id\x18\x06 \x01(\tH\x00R\bupdateId\x12d\n" +
	"\x12state_machine_path\x18\a \x01(\v24.temporal.server.api.persistence.v1.StateMachinePathH\x00R\x10stateMachinePath\x12(\n" +
	"\x0fchasm_node_path\x18\b \x01(\tH\x00R\rchasmNodePathB\x13\n" +
	"\x11state_machine_key\"[\n" +
	"\x10StateMachinePath\x12G\n" +
	"\x04path\x18\x01 \x03(\v23.temporal.server.api.persistence.v1.StateMachineKeyR\x04pathB6Z4go.temporal.io/server/api/persistence/v1;persistenceb\x06proto3"

var (
	file_temporal_server_api_persistence_v1_hsm_proto_rawDescOnce sync.Once
	file_temporal_server_api_persistence_v1_hsm_proto_rawDescData []byte
)

func file_temporal_server_api_persistence_v1_hsm_proto_rawDescGZIP() []byte {
	file_temporal_server_api_persistence_v1_hsm_proto_rawDescOnce.Do(func() {
		file_temporal_server_api_persistence_v1_hsm_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_temporal_server_api_persistence_v1_hsm_proto_rawDesc), len(file_temporal_server_api_persistence_v1_hsm_proto_rawDesc)))
	})
	return file_temporal_server_api_persistence_v1_hsm_proto_rawDescData
}

var file_temporal_server_api_persistence_v1_hsm_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_temporal_server_api_persistence_v1_hsm_proto_goTypes = []any{
	(*StateMachineNode)(nil),           // 0: temporal.server.api.persistence.v1.StateMachineNode
	(*StateMachineMap)(nil),            // 1: temporal.server.api.persistence.v1.StateMachineMap
	(*StateMachineKey)(nil),            // 2: temporal.server.api.persistence.v1.StateMachineKey
	(*StateMachineRef)(nil),            // 3: temporal.server.api.persistence.v1.StateMachineRef
	(*StateMachineTaskInfo)(nil),       // 4: temporal.server.api.persistence.v1.StateMachineTaskInfo
	(*StateMachineTimerGroup)(nil),     // 5: temporal.server.api.persistence.v1.StateMachineTimerGroup
	(*VersionedTransition)(nil),        // 6: temporal.server.api.persistence.v1.VersionedTransition
	(*StateMachineTombstoneBatch)(nil), // 7: temporal.server.api.persistence.v1.StateMachineTombstoneBatch
	(*StateMachineTombstone)(nil),      // 8: temporal.server.api.persistence.v1.StateMachineTombstone
	(*StateMachinePath)(nil),           // 9: temporal.server.api.persistence.v1.StateMachinePath
	nil,                                // 10: temporal.server.api.persistence.v1.StateMachineNode.ChildrenEntry
	nil,                                // 11: temporal.server.api.persistence.v1.StateMachineMap.MachinesByIdEntry
	(*timestamppb.Timestamp)(nil),      // 12: google.protobuf.Timestamp
}
var file_temporal_server_api_persistence_v1_hsm_proto_depIdxs = []int32{
	10, // 0: temporal.server.api.persistence.v1.StateMachineNode.children:type_name -> temporal.server.api.persistence.v1.StateMachineNode.ChildrenEntry
	6,  // 1: temporal.server.api.persistence.v1.StateMachineNode.initial_versioned_transition:type_name -> temporal.server.api.persistence.v1.VersionedTransition
	6,  // 2: temporal.server.api.persistence.v1.StateMachineNode.last_update_versioned_transition:type_name -> temporal.server.api.persistence.v1.VersionedTransition
	11, // 3: temporal.server.api.persistence.v1.StateMachineMap.machines_by_id:type_name -> temporal.server.api.persistence.v1.StateMachineMap.MachinesByIdEntry
	2,  // 4: temporal.server.api.persistence.v1.StateMachineRef.path:type_name -> temporal.server.api.persistence.v1.StateMachineKey
	6,  // 5: temporal.server.api.persistence.v1.StateMachineRef.mutable_state_versioned_transition:type_name -> temporal.server.api.persistence.v1.VersionedTransition
	6,  // 6: temporal.server.api.persistence.v1.StateMachineRef.machine_initial_versioned_transition:type_name -> temporal.server.api.persistence.v1.VersionedTransition
	6,  // 7: temporal.server.api.persistence.v1.StateMachineRef.machine_last_update_versioned_transition:type_name -> temporal.server.api.persistence.v1.VersionedTransition
	3,  // 8: temporal.server.api.persistence.v1.StateMachineTaskInfo.ref:type_name -> temporal.server.api.persistence.v1.StateMachineRef
	4,  // 9: temporal.server.api.persistence.v1.StateMachineTimerGroup.infos:type_name -> temporal.server.api.persistence.v1.StateMachineTaskInfo
	12, // 10: temporal.server.api.persistence.v1.StateMachineTimerGroup.deadline:type_name -> google.protobuf.Timestamp
	6,  // 11: temporal.server.api.persistence.v1.StateMachineTombstoneBatch.versioned_transition:type_name -> temporal.server.api.persistence.v1.VersionedTransition
	8,  // 12: temporal.server.api.persistence.v1.StateMachineTombstoneBatch.state_machine_tombstones:type_name -> temporal.server.api.persistence.v1.StateMachineTombstone
	9,  // 13: temporal.server.api.persistence.v1.StateMachineTombstone.state_machine_path:type_name -> temporal.server.api.persistence.v1.StateMachinePath
	2,  // 14: temporal.server.api.persistence.v1.StateMachinePath.path:type_name -> temporal.server.api.persistence.v1.StateMachineKey
	1,  // 15: temporal.server.api.persistence.v1.StateMachineNode.ChildrenEntry.value:type_name -> temporal.server.api.persistence.v1.StateMachineMap
	0,  // 16: temporal.server.api.persistence.v1.StateMachineMap.MachinesByIdEntry.value:type_name -> temporal.server.api.persistence.v1.StateMachineNode
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_temporal_server_api_persistence_v1_hsm_proto_init() }
func file_temporal_server_api_persistence_v1_hsm_proto_init() {
	if File_temporal_server_api_persistence_v1_hsm_proto != nil {
		return
	}
	file_temporal_server_api_persistence_v1_hsm_proto_msgTypes[8].OneofWrappers = []any{
		(*StateMachineTombstone_ActivityScheduledEventId)(nil),
		(*StateMachineTombstone_TimerId)(nil),
		(*StateMachineTombstone_ChildExecutionInitiatedEventId)(nil),
		(*StateMachineTombstone_RequestCancelInitiatedEventId)(nil),
		(*StateMachineTombstone_SignalExternalInitiatedEventId)(nil),
		(*StateMachineTombstone_UpdateId)(nil),
		(*StateMachineTombstone_StateMachinePath)(nil),
		(*StateMachineTombstone_ChasmNodePath)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_temporal_server_api_persistence_v1_hsm_proto_rawDesc), len(file_temporal_server_api_persistence_v1_hsm_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_temporal_server_api_persistence_v1_hsm_proto_goTypes,
		DependencyIndexes: file_temporal_server_api_persistence_v1_hsm_proto_depIdxs,
		MessageInfos:      file_temporal_server_api_persistence_v1_hsm_proto_msgTypes,
	}.Build()
	File_temporal_server_api_persistence_v1_hsm_proto = out.File
	file_temporal_server_api_persistence_v1_hsm_proto_goTypes = nil
	file_temporal_server_api_persistence_v1_hsm_proto_depIdxs = nil
}
