// Code generated by protoc-gen-go. DO NOT EDIT.
// plugins:
// 	protoc-gen-go
// 	protoc
// source: temporal/server/api/replication/v1/message.proto

package repication

import (
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"

	v11 "go.temporal.io/api/common/v1"
	v15 "go.temporal.io/api/failure/v1"
	v13 "go.temporal.io/api/namespace/v1"
	v14 "go.temporal.io/api/replication/v1"
	v1 "go.temporal.io/server/api/enums/v1"
	v16 "go.temporal.io/server/api/history/v1"
	v12 "go.temporal.io/server/api/persistence/v1"
	v17 "go.temporal.io/server/api/workflow/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ReplicationTask struct {
	state        protoimpl.MessageState `protogen:"open.v1"`
	TaskType     v1.ReplicationTaskType `protobuf:"varint,1,opt,name=task_type,json=taskType,proto3,enum=temporal.server.api.enums.v1.ReplicationTaskType" json:"task_type,omitempty"`
	SourceTaskId int64                  `protobuf:"varint,2,opt,name=source_task_id,json=sourceTaskId,proto3" json:"source_task_id,omitempty"`
	// Types that are valid to be assigned to Attributes:
	//
	//	*ReplicationTask_NamespaceTaskAttributes
	//	*ReplicationTask_SyncShardStatusTaskAttributes
	//	*ReplicationTask_SyncActivityTaskAttributes
	//	*ReplicationTask_HistoryTaskAttributes
	//	*ReplicationTask_SyncWorkflowStateTaskAttributes
	//	*ReplicationTask_TaskQueueUserDataAttributes
	//	*ReplicationTask_SyncHsmAttributes
	//	*ReplicationTask_BackfillHistoryTaskAttributes
	//	*ReplicationTask_VerifyVersionedTransitionTaskAttributes
	//	*ReplicationTask_SyncVersionedTransitionTaskAttributes
	Attributes isReplicationTask_Attributes `protobuf_oneof:"attributes"`
	// All attributes should be deprecated and replaced by this field.
	// The task_type + data provide more flexibility in future use cases.
	Data                *v11.DataBlob            `protobuf:"bytes,12,opt,name=data,proto3" json:"data,omitempty"`
	VisibilityTime      *timestamppb.Timestamp   `protobuf:"bytes,9,opt,name=visibility_time,json=visibilityTime,proto3" json:"visibility_time,omitempty"`
	Priority            v1.TaskPriority          `protobuf:"varint,13,opt,name=priority,proto3,enum=temporal.server.api.enums.v1.TaskPriority" json:"priority,omitempty"`
	VersionedTransition *v12.VersionedTransition `protobuf:"bytes,15,opt,name=versioned_transition,json=versionedTransition,proto3" json:"versioned_transition,omitempty"`
	RawTaskInfo         *v12.ReplicationTaskInfo `protobuf:"bytes,17,opt,name=raw_task_info,json=rawTaskInfo,proto3" json:"raw_task_info,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *ReplicationTask) Reset() {
	*x = ReplicationTask{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicationTask) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationTask) ProtoMessage() {}

func (x *ReplicationTask) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationTask.ProtoReflect.Descriptor instead.
func (*ReplicationTask) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{0}
}

func (x *ReplicationTask) GetTaskType() v1.ReplicationTaskType {
	if x != nil {
		return x.TaskType
	}
	return v1.ReplicationTaskType(0)
}

func (x *ReplicationTask) GetSourceTaskId() int64 {
	if x != nil {
		return x.SourceTaskId
	}
	return 0
}

func (x *ReplicationTask) GetAttributes() isReplicationTask_Attributes {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *ReplicationTask) GetNamespaceTaskAttributes() *NamespaceTaskAttributes {
	if x != nil {
		if x, ok := x.Attributes.(*ReplicationTask_NamespaceTaskAttributes); ok {
			return x.NamespaceTaskAttributes
		}
	}
	return nil
}

func (x *ReplicationTask) GetSyncShardStatusTaskAttributes() *SyncShardStatusTaskAttributes {
	if x != nil {
		if x, ok := x.Attributes.(*ReplicationTask_SyncShardStatusTaskAttributes); ok {
			return x.SyncShardStatusTaskAttributes
		}
	}
	return nil
}

func (x *ReplicationTask) GetSyncActivityTaskAttributes() *SyncActivityTaskAttributes {
	if x != nil {
		if x, ok := x.Attributes.(*ReplicationTask_SyncActivityTaskAttributes); ok {
			return x.SyncActivityTaskAttributes
		}
	}
	return nil
}

func (x *ReplicationTask) GetHistoryTaskAttributes() *HistoryTaskAttributes {
	if x != nil {
		if x, ok := x.Attributes.(*ReplicationTask_HistoryTaskAttributes); ok {
			return x.HistoryTaskAttributes
		}
	}
	return nil
}

func (x *ReplicationTask) GetSyncWorkflowStateTaskAttributes() *SyncWorkflowStateTaskAttributes {
	if x != nil {
		if x, ok := x.Attributes.(*ReplicationTask_SyncWorkflowStateTaskAttributes); ok {
			return x.SyncWorkflowStateTaskAttributes
		}
	}
	return nil
}

func (x *ReplicationTask) GetTaskQueueUserDataAttributes() *TaskQueueUserDataAttributes {
	if x != nil {
		if x, ok := x.Attributes.(*ReplicationTask_TaskQueueUserDataAttributes); ok {
			return x.TaskQueueUserDataAttributes
		}
	}
	return nil
}

func (x *ReplicationTask) GetSyncHsmAttributes() *SyncHSMAttributes {
	if x != nil {
		if x, ok := x.Attributes.(*ReplicationTask_SyncHsmAttributes); ok {
			return x.SyncHsmAttributes
		}
	}
	return nil
}

func (x *ReplicationTask) GetBackfillHistoryTaskAttributes() *BackfillHistoryTaskAttributes {
	if x != nil {
		if x, ok := x.Attributes.(*ReplicationTask_BackfillHistoryTaskAttributes); ok {
			return x.BackfillHistoryTaskAttributes
		}
	}
	return nil
}

func (x *ReplicationTask) GetVerifyVersionedTransitionTaskAttributes() *VerifyVersionedTransitionTaskAttributes {
	if x != nil {
		if x, ok := x.Attributes.(*ReplicationTask_VerifyVersionedTransitionTaskAttributes); ok {
			return x.VerifyVersionedTransitionTaskAttributes
		}
	}
	return nil
}

func (x *ReplicationTask) GetSyncVersionedTransitionTaskAttributes() *SyncVersionedTransitionTaskAttributes {
	if x != nil {
		if x, ok := x.Attributes.(*ReplicationTask_SyncVersionedTransitionTaskAttributes); ok {
			return x.SyncVersionedTransitionTaskAttributes
		}
	}
	return nil
}

func (x *ReplicationTask) GetData() *v11.DataBlob {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *ReplicationTask) GetVisibilityTime() *timestamppb.Timestamp {
	if x != nil {
		return x.VisibilityTime
	}
	return nil
}

func (x *ReplicationTask) GetPriority() v1.TaskPriority {
	if x != nil {
		return x.Priority
	}
	return v1.TaskPriority(0)
}

func (x *ReplicationTask) GetVersionedTransition() *v12.VersionedTransition {
	if x != nil {
		return x.VersionedTransition
	}
	return nil
}

func (x *ReplicationTask) GetRawTaskInfo() *v12.ReplicationTaskInfo {
	if x != nil {
		return x.RawTaskInfo
	}
	return nil
}

type isReplicationTask_Attributes interface {
	isReplicationTask_Attributes()
}

type ReplicationTask_NamespaceTaskAttributes struct {
	NamespaceTaskAttributes *NamespaceTaskAttributes `protobuf:"bytes,3,opt,name=namespace_task_attributes,json=namespaceTaskAttributes,proto3,oneof"`
}

type ReplicationTask_SyncShardStatusTaskAttributes struct {
	SyncShardStatusTaskAttributes *SyncShardStatusTaskAttributes `protobuf:"bytes,5,opt,name=sync_shard_status_task_attributes,json=syncShardStatusTaskAttributes,proto3,oneof"`
}

type ReplicationTask_SyncActivityTaskAttributes struct {
	SyncActivityTaskAttributes *SyncActivityTaskAttributes `protobuf:"bytes,6,opt,name=sync_activity_task_attributes,json=syncActivityTaskAttributes,proto3,oneof"`
}

type ReplicationTask_HistoryTaskAttributes struct {
	HistoryTaskAttributes *HistoryTaskAttributes `protobuf:"bytes,8,opt,name=history_task_attributes,json=historyTaskAttributes,proto3,oneof"`
}

type ReplicationTask_SyncWorkflowStateTaskAttributes struct {
	SyncWorkflowStateTaskAttributes *SyncWorkflowStateTaskAttributes `protobuf:"bytes,10,opt,name=sync_workflow_state_task_attributes,json=syncWorkflowStateTaskAttributes,proto3,oneof"`
}

type ReplicationTask_TaskQueueUserDataAttributes struct {
	TaskQueueUserDataAttributes *TaskQueueUserDataAttributes `protobuf:"bytes,11,opt,name=task_queue_user_data_attributes,json=taskQueueUserDataAttributes,proto3,oneof"`
}

type ReplicationTask_SyncHsmAttributes struct {
	SyncHsmAttributes *SyncHSMAttributes `protobuf:"bytes,14,opt,name=sync_hsm_attributes,json=syncHsmAttributes,proto3,oneof"`
}

type ReplicationTask_BackfillHistoryTaskAttributes struct {
	BackfillHistoryTaskAttributes *BackfillHistoryTaskAttributes `protobuf:"bytes,16,opt,name=backfill_history_task_attributes,json=backfillHistoryTaskAttributes,proto3,oneof"`
}

type ReplicationTask_VerifyVersionedTransitionTaskAttributes struct {
	VerifyVersionedTransitionTaskAttributes *VerifyVersionedTransitionTaskAttributes `protobuf:"bytes,18,opt,name=verify_versioned_transition_task_attributes,json=verifyVersionedTransitionTaskAttributes,proto3,oneof"`
}

type ReplicationTask_SyncVersionedTransitionTaskAttributes struct {
	SyncVersionedTransitionTaskAttributes *SyncVersionedTransitionTaskAttributes `protobuf:"bytes,19,opt,name=sync_versioned_transition_task_attributes,json=syncVersionedTransitionTaskAttributes,proto3,oneof"`
}

func (*ReplicationTask_NamespaceTaskAttributes) isReplicationTask_Attributes() {}

func (*ReplicationTask_SyncShardStatusTaskAttributes) isReplicationTask_Attributes() {}

func (*ReplicationTask_SyncActivityTaskAttributes) isReplicationTask_Attributes() {}

func (*ReplicationTask_HistoryTaskAttributes) isReplicationTask_Attributes() {}

func (*ReplicationTask_SyncWorkflowStateTaskAttributes) isReplicationTask_Attributes() {}

func (*ReplicationTask_TaskQueueUserDataAttributes) isReplicationTask_Attributes() {}

func (*ReplicationTask_SyncHsmAttributes) isReplicationTask_Attributes() {}

func (*ReplicationTask_BackfillHistoryTaskAttributes) isReplicationTask_Attributes() {}

func (*ReplicationTask_VerifyVersionedTransitionTaskAttributes) isReplicationTask_Attributes() {}

func (*ReplicationTask_SyncVersionedTransitionTaskAttributes) isReplicationTask_Attributes() {}

type ReplicationToken struct {
	state   protoimpl.MessageState `protogen:"open.v1"`
	ShardId int32                  `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	// lastRetrievedMessageId is where the next fetch should begin with.
	LastRetrievedMessageId int64 `protobuf:"varint,2,opt,name=last_retrieved_message_id,json=lastRetrievedMessageId,proto3" json:"last_retrieved_message_id,omitempty"`
	// lastProcessedMessageId is the last messageId that is processed on the passive side.
	// This can be different than lastRetrievedMessageId if passive side supports prefetching messages.
	LastProcessedMessageId int64 `protobuf:"varint,3,opt,name=last_processed_message_id,json=lastProcessedMessageId,proto3" json:"last_processed_message_id,omitempty"`
	// The VisibilityTime of last processed ReplicationTask
	LastProcessedVisibilityTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=last_processed_visibility_time,json=lastProcessedVisibilityTime,proto3" json:"last_processed_visibility_time,omitempty"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *ReplicationToken) Reset() {
	*x = ReplicationToken{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicationToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationToken) ProtoMessage() {}

func (x *ReplicationToken) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationToken.ProtoReflect.Descriptor instead.
func (*ReplicationToken) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{1}
}

func (x *ReplicationToken) GetShardId() int32 {
	if x != nil {
		return x.ShardId
	}
	return 0
}

func (x *ReplicationToken) GetLastRetrievedMessageId() int64 {
	if x != nil {
		return x.LastRetrievedMessageId
	}
	return 0
}

func (x *ReplicationToken) GetLastProcessedMessageId() int64 {
	if x != nil {
		return x.LastProcessedMessageId
	}
	return 0
}

func (x *ReplicationToken) GetLastProcessedVisibilityTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastProcessedVisibilityTime
	}
	return nil
}

type SyncShardStatus struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	StatusTime    *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=status_time,json=statusTime,proto3" json:"status_time,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyncShardStatus) Reset() {
	*x = SyncShardStatus{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncShardStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncShardStatus) ProtoMessage() {}

func (x *SyncShardStatus) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncShardStatus.ProtoReflect.Descriptor instead.
func (*SyncShardStatus) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{2}
}

func (x *SyncShardStatus) GetStatusTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StatusTime
	}
	return nil
}

type SyncReplicationState struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// deprecated in favor of using ReplicationState object
	InclusiveLowWatermark int64 `protobuf:"varint,1,opt,name=inclusive_low_watermark,json=inclusiveLowWatermark,proto3" json:"inclusive_low_watermark,omitempty"`
	// deprecated in favor of using ReplicationState object
	InclusiveLowWatermarkTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=inclusive_low_watermark_time,json=inclusiveLowWatermarkTime,proto3" json:"inclusive_low_watermark_time,omitempty"`
	HighPriorityState         *ReplicationState      `protobuf:"bytes,3,opt,name=high_priority_state,json=highPriorityState,proto3" json:"high_priority_state,omitempty"`
	LowPriorityState          *ReplicationState      `protobuf:"bytes,4,opt,name=low_priority_state,json=lowPriorityState,proto3" json:"low_priority_state,omitempty"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *SyncReplicationState) Reset() {
	*x = SyncReplicationState{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncReplicationState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncReplicationState) ProtoMessage() {}

func (x *SyncReplicationState) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncReplicationState.ProtoReflect.Descriptor instead.
func (*SyncReplicationState) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{3}
}

func (x *SyncReplicationState) GetInclusiveLowWatermark() int64 {
	if x != nil {
		return x.InclusiveLowWatermark
	}
	return 0
}

func (x *SyncReplicationState) GetInclusiveLowWatermarkTime() *timestamppb.Timestamp {
	if x != nil {
		return x.InclusiveLowWatermarkTime
	}
	return nil
}

func (x *SyncReplicationState) GetHighPriorityState() *ReplicationState {
	if x != nil {
		return x.HighPriorityState
	}
	return nil
}

func (x *SyncReplicationState) GetLowPriorityState() *ReplicationState {
	if x != nil {
		return x.LowPriorityState
	}
	return nil
}

type ReplicationState struct {
	state                     protoimpl.MessageState           `protogen:"open.v1"`
	InclusiveLowWatermark     int64                            `protobuf:"varint,1,opt,name=inclusive_low_watermark,json=inclusiveLowWatermark,proto3" json:"inclusive_low_watermark,omitempty"`
	InclusiveLowWatermarkTime *timestamppb.Timestamp           `protobuf:"bytes,2,opt,name=inclusive_low_watermark_time,json=inclusiveLowWatermarkTime,proto3" json:"inclusive_low_watermark_time,omitempty"`
	FlowControlCommand        v1.ReplicationFlowControlCommand `protobuf:"varint,3,opt,name=flow_control_command,json=flowControlCommand,proto3,enum=temporal.server.api.enums.v1.ReplicationFlowControlCommand" json:"flow_control_command,omitempty"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *ReplicationState) Reset() {
	*x = ReplicationState{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicationState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationState) ProtoMessage() {}

func (x *ReplicationState) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationState.ProtoReflect.Descriptor instead.
func (*ReplicationState) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{4}
}

func (x *ReplicationState) GetInclusiveLowWatermark() int64 {
	if x != nil {
		return x.InclusiveLowWatermark
	}
	return 0
}

func (x *ReplicationState) GetInclusiveLowWatermarkTime() *timestamppb.Timestamp {
	if x != nil {
		return x.InclusiveLowWatermarkTime
	}
	return nil
}

func (x *ReplicationState) GetFlowControlCommand() v1.ReplicationFlowControlCommand {
	if x != nil {
		return x.FlowControlCommand
	}
	return v1.ReplicationFlowControlCommand(0)
}

type ReplicationMessages struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	ReplicationTasks []*ReplicationTask     `protobuf:"bytes,1,rep,name=replication_tasks,json=replicationTasks,proto3" json:"replication_tasks,omitempty"`
	// This can be different than the last taskId in the above list, because sender can decide to skip tasks (e.g. for completed workflows).
	LastRetrievedMessageId int64 `protobuf:"varint,2,opt,name=last_retrieved_message_id,json=lastRetrievedMessageId,proto3" json:"last_retrieved_message_id,omitempty"`
	// Hint for flow control.
	HasMore         bool             `protobuf:"varint,3,opt,name=has_more,json=hasMore,proto3" json:"has_more,omitempty"`
	SyncShardStatus *SyncShardStatus `protobuf:"bytes,4,opt,name=sync_shard_status,json=syncShardStatus,proto3" json:"sync_shard_status,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *ReplicationMessages) Reset() {
	*x = ReplicationMessages{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicationMessages) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationMessages) ProtoMessage() {}

func (x *ReplicationMessages) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationMessages.ProtoReflect.Descriptor instead.
func (*ReplicationMessages) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{5}
}

func (x *ReplicationMessages) GetReplicationTasks() []*ReplicationTask {
	if x != nil {
		return x.ReplicationTasks
	}
	return nil
}

func (x *ReplicationMessages) GetLastRetrievedMessageId() int64 {
	if x != nil {
		return x.LastRetrievedMessageId
	}
	return 0
}

func (x *ReplicationMessages) GetHasMore() bool {
	if x != nil {
		return x.HasMore
	}
	return false
}

func (x *ReplicationMessages) GetSyncShardStatus() *SyncShardStatus {
	if x != nil {
		return x.SyncShardStatus
	}
	return nil
}

type WorkflowReplicationMessages struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	ReplicationTasks []*ReplicationTask     `protobuf:"bytes,1,rep,name=replication_tasks,json=replicationTasks,proto3" json:"replication_tasks,omitempty"`
	// This can be different than the last taskId in the above list, because sender can decide to skip tasks (e.g. for completed workflows).
	ExclusiveHighWatermark     int64                  `protobuf:"varint,2,opt,name=exclusive_high_watermark,json=exclusiveHighWatermark,proto3" json:"exclusive_high_watermark,omitempty"`
	ExclusiveHighWatermarkTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=exclusive_high_watermark_time,json=exclusiveHighWatermarkTime,proto3" json:"exclusive_high_watermark_time,omitempty"`
	Priority                   v1.TaskPriority        `protobuf:"varint,4,opt,name=priority,proto3,enum=temporal.server.api.enums.v1.TaskPriority" json:"priority,omitempty"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *WorkflowReplicationMessages) Reset() {
	*x = WorkflowReplicationMessages{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkflowReplicationMessages) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowReplicationMessages) ProtoMessage() {}

func (x *WorkflowReplicationMessages) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowReplicationMessages.ProtoReflect.Descriptor instead.
func (*WorkflowReplicationMessages) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{6}
}

func (x *WorkflowReplicationMessages) GetReplicationTasks() []*ReplicationTask {
	if x != nil {
		return x.ReplicationTasks
	}
	return nil
}

func (x *WorkflowReplicationMessages) GetExclusiveHighWatermark() int64 {
	if x != nil {
		return x.ExclusiveHighWatermark
	}
	return 0
}

func (x *WorkflowReplicationMessages) GetExclusiveHighWatermarkTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExclusiveHighWatermarkTime
	}
	return nil
}

func (x *WorkflowReplicationMessages) GetPriority() v1.TaskPriority {
	if x != nil {
		return x.Priority
	}
	return v1.TaskPriority(0)
}

// TODO: Deprecate this definition, it only used by the deprecated replication DLQ v1 logic
type ReplicationTaskInfo struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	NamespaceId      string                 `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId       string                 `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId            string                 `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	TaskType         v1.TaskType            `protobuf:"varint,4,opt,name=task_type,json=taskType,proto3,enum=temporal.server.api.enums.v1.TaskType" json:"task_type,omitempty"`
	TaskId           int64                  `protobuf:"varint,5,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	Version          int64                  `protobuf:"varint,6,opt,name=version,proto3" json:"version,omitempty"`
	FirstEventId     int64                  `protobuf:"varint,7,opt,name=first_event_id,json=firstEventId,proto3" json:"first_event_id,omitempty"`
	NextEventId      int64                  `protobuf:"varint,8,opt,name=next_event_id,json=nextEventId,proto3" json:"next_event_id,omitempty"`
	ScheduledEventId int64                  `protobuf:"varint,9,opt,name=scheduled_event_id,json=scheduledEventId,proto3" json:"scheduled_event_id,omitempty"`
	Priority         v1.TaskPriority        `protobuf:"varint,10,opt,name=priority,proto3,enum=temporal.server.api.enums.v1.TaskPriority" json:"priority,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *ReplicationTaskInfo) Reset() {
	*x = ReplicationTaskInfo{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicationTaskInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationTaskInfo) ProtoMessage() {}

func (x *ReplicationTaskInfo) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationTaskInfo.ProtoReflect.Descriptor instead.
func (*ReplicationTaskInfo) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{7}
}

func (x *ReplicationTaskInfo) GetNamespaceId() string {
	if x != nil {
		return x.NamespaceId
	}
	return ""
}

func (x *ReplicationTaskInfo) GetWorkflowId() string {
	if x != nil {
		return x.WorkflowId
	}
	return ""
}

func (x *ReplicationTaskInfo) GetRunId() string {
	if x != nil {
		return x.RunId
	}
	return ""
}

func (x *ReplicationTaskInfo) GetTaskType() v1.TaskType {
	if x != nil {
		return x.TaskType
	}
	return v1.TaskType(0)
}

func (x *ReplicationTaskInfo) GetTaskId() int64 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

func (x *ReplicationTaskInfo) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *ReplicationTaskInfo) GetFirstEventId() int64 {
	if x != nil {
		return x.FirstEventId
	}
	return 0
}

func (x *ReplicationTaskInfo) GetNextEventId() int64 {
	if x != nil {
		return x.NextEventId
	}
	return 0
}

func (x *ReplicationTaskInfo) GetScheduledEventId() int64 {
	if x != nil {
		return x.ScheduledEventId
	}
	return 0
}

func (x *ReplicationTaskInfo) GetPriority() v1.TaskPriority {
	if x != nil {
		return x.Priority
	}
	return v1.TaskPriority(0)
}

type NamespaceTaskAttributes struct {
	state              protoimpl.MessageState          `protogen:"open.v1"`
	NamespaceOperation v1.NamespaceOperation           `protobuf:"varint,1,opt,name=namespace_operation,json=namespaceOperation,proto3,enum=temporal.server.api.enums.v1.NamespaceOperation" json:"namespace_operation,omitempty"`
	Id                 string                          `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	Info               *v13.NamespaceInfo              `protobuf:"bytes,3,opt,name=info,proto3" json:"info,omitempty"`
	Config             *v13.NamespaceConfig            `protobuf:"bytes,4,opt,name=config,proto3" json:"config,omitempty"`
	ReplicationConfig  *v14.NamespaceReplicationConfig `protobuf:"bytes,5,opt,name=replication_config,json=replicationConfig,proto3" json:"replication_config,omitempty"`
	ConfigVersion      int64                           `protobuf:"varint,6,opt,name=config_version,json=configVersion,proto3" json:"config_version,omitempty"`
	FailoverVersion    int64                           `protobuf:"varint,7,opt,name=failover_version,json=failoverVersion,proto3" json:"failover_version,omitempty"`
	FailoverHistory    []*v14.FailoverStatus           `protobuf:"bytes,8,rep,name=failover_history,json=failoverHistory,proto3" json:"failover_history,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *NamespaceTaskAttributes) Reset() {
	*x = NamespaceTaskAttributes{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NamespaceTaskAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceTaskAttributes) ProtoMessage() {}

func (x *NamespaceTaskAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceTaskAttributes.ProtoReflect.Descriptor instead.
func (*NamespaceTaskAttributes) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{8}
}

func (x *NamespaceTaskAttributes) GetNamespaceOperation() v1.NamespaceOperation {
	if x != nil {
		return x.NamespaceOperation
	}
	return v1.NamespaceOperation(0)
}

func (x *NamespaceTaskAttributes) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *NamespaceTaskAttributes) GetInfo() *v13.NamespaceInfo {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *NamespaceTaskAttributes) GetConfig() *v13.NamespaceConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *NamespaceTaskAttributes) GetReplicationConfig() *v14.NamespaceReplicationConfig {
	if x != nil {
		return x.ReplicationConfig
	}
	return nil
}

func (x *NamespaceTaskAttributes) GetConfigVersion() int64 {
	if x != nil {
		return x.ConfigVersion
	}
	return 0
}

func (x *NamespaceTaskAttributes) GetFailoverVersion() int64 {
	if x != nil {
		return x.FailoverVersion
	}
	return 0
}

func (x *NamespaceTaskAttributes) GetFailoverHistory() []*v14.FailoverStatus {
	if x != nil {
		return x.FailoverHistory
	}
	return nil
}

type SyncShardStatusTaskAttributes struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	SourceCluster string                 `protobuf:"bytes,1,opt,name=source_cluster,json=sourceCluster,proto3" json:"source_cluster,omitempty"`
	ShardId       int32                  `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	StatusTime    *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=status_time,json=statusTime,proto3" json:"status_time,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyncShardStatusTaskAttributes) Reset() {
	*x = SyncShardStatusTaskAttributes{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncShardStatusTaskAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncShardStatusTaskAttributes) ProtoMessage() {}

func (x *SyncShardStatusTaskAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncShardStatusTaskAttributes.ProtoReflect.Descriptor instead.
func (*SyncShardStatusTaskAttributes) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{9}
}

func (x *SyncShardStatusTaskAttributes) GetSourceCluster() string {
	if x != nil {
		return x.SourceCluster
	}
	return ""
}

func (x *SyncShardStatusTaskAttributes) GetShardId() int32 {
	if x != nil {
		return x.ShardId
	}
	return 0
}

func (x *SyncShardStatusTaskAttributes) GetStatusTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StatusTime
	}
	return nil
}

type SyncActivityTaskAttributes struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	NamespaceId        string                 `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId         string                 `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId              string                 `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	Version            int64                  `protobuf:"varint,4,opt,name=version,proto3" json:"version,omitempty"`
	ScheduledEventId   int64                  `protobuf:"varint,5,opt,name=scheduled_event_id,json=scheduledEventId,proto3" json:"scheduled_event_id,omitempty"`
	ScheduledTime      *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=scheduled_time,json=scheduledTime,proto3" json:"scheduled_time,omitempty"`
	StartedEventId     int64                  `protobuf:"varint,7,opt,name=started_event_id,json=startedEventId,proto3" json:"started_event_id,omitempty"`
	StartedTime        *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=started_time,json=startedTime,proto3" json:"started_time,omitempty"`
	LastHeartbeatTime  *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=last_heartbeat_time,json=lastHeartbeatTime,proto3" json:"last_heartbeat_time,omitempty"`
	Details            *v11.Payloads          `protobuf:"bytes,10,opt,name=details,proto3" json:"details,omitempty"`
	Attempt            int32                  `protobuf:"varint,11,opt,name=attempt,proto3" json:"attempt,omitempty"`
	LastFailure        *v15.Failure           `protobuf:"bytes,12,opt,name=last_failure,json=lastFailure,proto3" json:"last_failure,omitempty"`
	LastWorkerIdentity string                 `protobuf:"bytes,13,opt,name=last_worker_identity,json=lastWorkerIdentity,proto3" json:"last_worker_identity,omitempty"`
	VersionHistory     *v16.VersionHistory    `protobuf:"bytes,14,opt,name=version_history,json=versionHistory,proto3" json:"version_history,omitempty"`
	BaseExecutionInfo  *v17.BaseExecutionInfo `protobuf:"bytes,15,opt,name=base_execution_info,json=baseExecutionInfo,proto3" json:"base_execution_info,omitempty"`
	// build ID of the worker who received this activity last time
	LastStartedBuildId string `protobuf:"bytes,16,opt,name=last_started_build_id,json=lastStartedBuildId,proto3" json:"last_started_build_id,omitempty"`
	// workflows redirect_counter value when this activity started last time
	LastStartedRedirectCounter int64 `protobuf:"varint,17,opt,name=last_started_redirect_counter,json=lastStartedRedirectCounter,proto3" json:"last_started_redirect_counter,omitempty"`
	// The first time the activity was scheduled.
	FirstScheduledTime *timestamppb.Timestamp `protobuf:"bytes,18,opt,name=first_scheduled_time,json=firstScheduledTime,proto3" json:"first_scheduled_time,omitempty"`
	// The last time an activity attempt completion was recorded by the server.
	LastAttemptCompleteTime *timestamppb.Timestamp `protobuf:"bytes,19,opt,name=last_attempt_complete_time,json=lastAttemptCompleteTime,proto3" json:"last_attempt_complete_time,omitempty"`
	// Stamp represents the internal “version” of the activity options and can/will be changed with Activity API.
	// It monotonically increments when the activity options are changed.
	Stamp int32 `protobuf:"varint,20,opt,name=stamp,proto3" json:"stamp,omitempty"`
	// Flag indicating whether the activity is currently paused.
	Paused bool `protobuf:"varint,21,opt,name=paused,proto3" json:"paused,omitempty"`
	// Retry policy for the activity. It needs to be replicated now, since the activity properties can be updated.
	RetryInitialInterval    *durationpb.Duration `protobuf:"bytes,22,opt,name=retry_initial_interval,json=retryInitialInterval,proto3" json:"retry_initial_interval,omitempty"`
	RetryMaximumInterval    *durationpb.Duration `protobuf:"bytes,23,opt,name=retry_maximum_interval,json=retryMaximumInterval,proto3" json:"retry_maximum_interval,omitempty"`
	RetryMaximumAttempts    int32                `protobuf:"varint,24,opt,name=retry_maximum_attempts,json=retryMaximumAttempts,proto3" json:"retry_maximum_attempts,omitempty"`
	RetryBackoffCoefficient float64              `protobuf:"fixed64,25,opt,name=retry_backoff_coefficient,json=retryBackoffCoefficient,proto3" json:"retry_backoff_coefficient,omitempty"`
	StartVersion            int64                `protobuf:"varint,26,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *SyncActivityTaskAttributes) Reset() {
	*x = SyncActivityTaskAttributes{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncActivityTaskAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncActivityTaskAttributes) ProtoMessage() {}

func (x *SyncActivityTaskAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncActivityTaskAttributes.ProtoReflect.Descriptor instead.
func (*SyncActivityTaskAttributes) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{10}
}

func (x *SyncActivityTaskAttributes) GetNamespaceId() string {
	if x != nil {
		return x.NamespaceId
	}
	return ""
}

func (x *SyncActivityTaskAttributes) GetWorkflowId() string {
	if x != nil {
		return x.WorkflowId
	}
	return ""
}

func (x *SyncActivityTaskAttributes) GetRunId() string {
	if x != nil {
		return x.RunId
	}
	return ""
}

func (x *SyncActivityTaskAttributes) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *SyncActivityTaskAttributes) GetScheduledEventId() int64 {
	if x != nil {
		return x.ScheduledEventId
	}
	return 0
}

func (x *SyncActivityTaskAttributes) GetScheduledTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ScheduledTime
	}
	return nil
}

func (x *SyncActivityTaskAttributes) GetStartedEventId() int64 {
	if x != nil {
		return x.StartedEventId
	}
	return 0
}

func (x *SyncActivityTaskAttributes) GetStartedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartedTime
	}
	return nil
}

func (x *SyncActivityTaskAttributes) GetLastHeartbeatTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastHeartbeatTime
	}
	return nil
}

func (x *SyncActivityTaskAttributes) GetDetails() *v11.Payloads {
	if x != nil {
		return x.Details
	}
	return nil
}

func (x *SyncActivityTaskAttributes) GetAttempt() int32 {
	if x != nil {
		return x.Attempt
	}
	return 0
}

func (x *SyncActivityTaskAttributes) GetLastFailure() *v15.Failure {
	if x != nil {
		return x.LastFailure
	}
	return nil
}

func (x *SyncActivityTaskAttributes) GetLastWorkerIdentity() string {
	if x != nil {
		return x.LastWorkerIdentity
	}
	return ""
}

func (x *SyncActivityTaskAttributes) GetVersionHistory() *v16.VersionHistory {
	if x != nil {
		return x.VersionHistory
	}
	return nil
}

func (x *SyncActivityTaskAttributes) GetBaseExecutionInfo() *v17.BaseExecutionInfo {
	if x != nil {
		return x.BaseExecutionInfo
	}
	return nil
}

func (x *SyncActivityTaskAttributes) GetLastStartedBuildId() string {
	if x != nil {
		return x.LastStartedBuildId
	}
	return ""
}

func (x *SyncActivityTaskAttributes) GetLastStartedRedirectCounter() int64 {
	if x != nil {
		return x.LastStartedRedirectCounter
	}
	return 0
}

func (x *SyncActivityTaskAttributes) GetFirstScheduledTime() *timestamppb.Timestamp {
	if x != nil {
		return x.FirstScheduledTime
	}
	return nil
}

func (x *SyncActivityTaskAttributes) GetLastAttemptCompleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastAttemptCompleteTime
	}
	return nil
}

func (x *SyncActivityTaskAttributes) GetStamp() int32 {
	if x != nil {
		return x.Stamp
	}
	return 0
}

func (x *SyncActivityTaskAttributes) GetPaused() bool {
	if x != nil {
		return x.Paused
	}
	return false
}

func (x *SyncActivityTaskAttributes) GetRetryInitialInterval() *durationpb.Duration {
	if x != nil {
		return x.RetryInitialInterval
	}
	return nil
}

func (x *SyncActivityTaskAttributes) GetRetryMaximumInterval() *durationpb.Duration {
	if x != nil {
		return x.RetryMaximumInterval
	}
	return nil
}

func (x *SyncActivityTaskAttributes) GetRetryMaximumAttempts() int32 {
	if x != nil {
		return x.RetryMaximumAttempts
	}
	return 0
}

func (x *SyncActivityTaskAttributes) GetRetryBackoffCoefficient() float64 {
	if x != nil {
		return x.RetryBackoffCoefficient
	}
	return 0
}

func (x *SyncActivityTaskAttributes) GetStartVersion() int64 {
	if x != nil {
		return x.StartVersion
	}
	return 0
}

type HistoryTaskAttributes struct {
	state               protoimpl.MessageState    `protogen:"open.v1"`
	NamespaceId         string                    `protobuf:"bytes,2,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId          string                    `protobuf:"bytes,3,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId               string                    `protobuf:"bytes,4,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	VersionHistoryItems []*v16.VersionHistoryItem `protobuf:"bytes,5,rep,name=version_history_items,json=versionHistoryItems,proto3" json:"version_history_items,omitempty"`
	// to be deprecated in favor of using events_batches
	Events *v11.DataBlob `protobuf:"bytes,6,opt,name=events,proto3" json:"events,omitempty"`
	// New run events does not need version history since there is no prior events.
	NewRunEvents      *v11.DataBlob          `protobuf:"bytes,7,opt,name=new_run_events,json=newRunEvents,proto3" json:"new_run_events,omitempty"`
	BaseExecutionInfo *v17.BaseExecutionInfo `protobuf:"bytes,8,opt,name=base_execution_info,json=baseExecutionInfo,proto3" json:"base_execution_info,omitempty"`
	NewRunId          string                 `protobuf:"bytes,9,opt,name=new_run_id,json=newRunId,proto3" json:"new_run_id,omitempty"`
	EventsBatches     []*v11.DataBlob        `protobuf:"bytes,10,rep,name=events_batches,json=eventsBatches,proto3" json:"events_batches,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *HistoryTaskAttributes) Reset() {
	*x = HistoryTaskAttributes{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HistoryTaskAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HistoryTaskAttributes) ProtoMessage() {}

func (x *HistoryTaskAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HistoryTaskAttributes.ProtoReflect.Descriptor instead.
func (*HistoryTaskAttributes) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{11}
}

func (x *HistoryTaskAttributes) GetNamespaceId() string {
	if x != nil {
		return x.NamespaceId
	}
	return ""
}

func (x *HistoryTaskAttributes) GetWorkflowId() string {
	if x != nil {
		return x.WorkflowId
	}
	return ""
}

func (x *HistoryTaskAttributes) GetRunId() string {
	if x != nil {
		return x.RunId
	}
	return ""
}

func (x *HistoryTaskAttributes) GetVersionHistoryItems() []*v16.VersionHistoryItem {
	if x != nil {
		return x.VersionHistoryItems
	}
	return nil
}

func (x *HistoryTaskAttributes) GetEvents() *v11.DataBlob {
	if x != nil {
		return x.Events
	}
	return nil
}

func (x *HistoryTaskAttributes) GetNewRunEvents() *v11.DataBlob {
	if x != nil {
		return x.NewRunEvents
	}
	return nil
}

func (x *HistoryTaskAttributes) GetBaseExecutionInfo() *v17.BaseExecutionInfo {
	if x != nil {
		return x.BaseExecutionInfo
	}
	return nil
}

func (x *HistoryTaskAttributes) GetNewRunId() string {
	if x != nil {
		return x.NewRunId
	}
	return ""
}

func (x *HistoryTaskAttributes) GetEventsBatches() []*v11.DataBlob {
	if x != nil {
		return x.EventsBatches
	}
	return nil
}

type SyncWorkflowStateTaskAttributes struct {
	state                    protoimpl.MessageState    `protogen:"open.v1"`
	WorkflowState            *v12.WorkflowMutableState `protobuf:"bytes,1,opt,name=workflow_state,json=workflowState,proto3" json:"workflow_state,omitempty"`
	IsForceReplication       bool                      `protobuf:"varint,2,opt,name=is_force_replication,json=isForceReplication,proto3" json:"is_force_replication,omitempty"`
	IsCloseTransferTaskAcked bool                      `protobuf:"varint,3,opt,name=is_close_transfer_task_acked,json=isCloseTransferTaskAcked,proto3" json:"is_close_transfer_task_acked,omitempty"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *SyncWorkflowStateTaskAttributes) Reset() {
	*x = SyncWorkflowStateTaskAttributes{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncWorkflowStateTaskAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncWorkflowStateTaskAttributes) ProtoMessage() {}

func (x *SyncWorkflowStateTaskAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncWorkflowStateTaskAttributes.ProtoReflect.Descriptor instead.
func (*SyncWorkflowStateTaskAttributes) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{12}
}

func (x *SyncWorkflowStateTaskAttributes) GetWorkflowState() *v12.WorkflowMutableState {
	if x != nil {
		return x.WorkflowState
	}
	return nil
}

func (x *SyncWorkflowStateTaskAttributes) GetIsForceReplication() bool {
	if x != nil {
		return x.IsForceReplication
	}
	return false
}

func (x *SyncWorkflowStateTaskAttributes) GetIsCloseTransferTaskAcked() bool {
	if x != nil {
		return x.IsCloseTransferTaskAcked
	}
	return false
}

type TaskQueueUserDataAttributes struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	NamespaceId   string                 `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	TaskQueueName string                 `protobuf:"bytes,2,opt,name=task_queue_name,json=taskQueueName,proto3" json:"task_queue_name,omitempty"`
	UserData      *v12.TaskQueueUserData `protobuf:"bytes,3,opt,name=user_data,json=userData,proto3" json:"user_data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TaskQueueUserDataAttributes) Reset() {
	*x = TaskQueueUserDataAttributes{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TaskQueueUserDataAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskQueueUserDataAttributes) ProtoMessage() {}

func (x *TaskQueueUserDataAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskQueueUserDataAttributes.ProtoReflect.Descriptor instead.
func (*TaskQueueUserDataAttributes) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{13}
}

func (x *TaskQueueUserDataAttributes) GetNamespaceId() string {
	if x != nil {
		return x.NamespaceId
	}
	return ""
}

func (x *TaskQueueUserDataAttributes) GetTaskQueueName() string {
	if x != nil {
		return x.TaskQueueName
	}
	return ""
}

func (x *TaskQueueUserDataAttributes) GetUserData() *v12.TaskQueueUserData {
	if x != nil {
		return x.UserData
	}
	return nil
}

type SyncHSMAttributes struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	NamespaceId      string                 `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId       string                 `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId            string                 `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	VersionHistory   *v16.VersionHistory    `protobuf:"bytes,4,opt,name=version_history,json=versionHistory,proto3" json:"version_history,omitempty"`
	StateMachineNode *v12.StateMachineNode  `protobuf:"bytes,5,opt,name=state_machine_node,json=stateMachineNode,proto3" json:"state_machine_node,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *SyncHSMAttributes) Reset() {
	*x = SyncHSMAttributes{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncHSMAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncHSMAttributes) ProtoMessage() {}

func (x *SyncHSMAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncHSMAttributes.ProtoReflect.Descriptor instead.
func (*SyncHSMAttributes) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{14}
}

func (x *SyncHSMAttributes) GetNamespaceId() string {
	if x != nil {
		return x.NamespaceId
	}
	return ""
}

func (x *SyncHSMAttributes) GetWorkflowId() string {
	if x != nil {
		return x.WorkflowId
	}
	return ""
}

func (x *SyncHSMAttributes) GetRunId() string {
	if x != nil {
		return x.RunId
	}
	return ""
}

func (x *SyncHSMAttributes) GetVersionHistory() *v16.VersionHistory {
	if x != nil {
		return x.VersionHistory
	}
	return nil
}

func (x *SyncHSMAttributes) GetStateMachineNode() *v12.StateMachineNode {
	if x != nil {
		return x.StateMachineNode
	}
	return nil
}

type BackfillHistoryTaskAttributes struct {
	state               protoimpl.MessageState    `protogen:"open.v1"`
	NamespaceId         string                    `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId          string                    `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId               string                    `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	EventVersionHistory []*v16.VersionHistoryItem `protobuf:"bytes,5,rep,name=event_version_history,json=eventVersionHistory,proto3" json:"event_version_history,omitempty"`
	EventBatches        []*v11.DataBlob           `protobuf:"bytes,6,rep,name=event_batches,json=eventBatches,proto3" json:"event_batches,omitempty"`
	NewRunInfo          *NewRunInfo               `protobuf:"bytes,7,opt,name=new_run_info,json=newRunInfo,proto3" json:"new_run_info,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *BackfillHistoryTaskAttributes) Reset() {
	*x = BackfillHistoryTaskAttributes{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackfillHistoryTaskAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackfillHistoryTaskAttributes) ProtoMessage() {}

func (x *BackfillHistoryTaskAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackfillHistoryTaskAttributes.ProtoReflect.Descriptor instead.
func (*BackfillHistoryTaskAttributes) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{15}
}

func (x *BackfillHistoryTaskAttributes) GetNamespaceId() string {
	if x != nil {
		return x.NamespaceId
	}
	return ""
}

func (x *BackfillHistoryTaskAttributes) GetWorkflowId() string {
	if x != nil {
		return x.WorkflowId
	}
	return ""
}

func (x *BackfillHistoryTaskAttributes) GetRunId() string {
	if x != nil {
		return x.RunId
	}
	return ""
}

func (x *BackfillHistoryTaskAttributes) GetEventVersionHistory() []*v16.VersionHistoryItem {
	if x != nil {
		return x.EventVersionHistory
	}
	return nil
}

func (x *BackfillHistoryTaskAttributes) GetEventBatches() []*v11.DataBlob {
	if x != nil {
		return x.EventBatches
	}
	return nil
}

func (x *BackfillHistoryTaskAttributes) GetNewRunInfo() *NewRunInfo {
	if x != nil {
		return x.NewRunInfo
	}
	return nil
}

type NewRunInfo struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	RunId         string                 `protobuf:"bytes,1,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	EventBatch    *v11.DataBlob          `protobuf:"bytes,2,opt,name=event_batch,json=eventBatch,proto3" json:"event_batch,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NewRunInfo) Reset() {
	*x = NewRunInfo{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NewRunInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NewRunInfo) ProtoMessage() {}

func (x *NewRunInfo) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NewRunInfo.ProtoReflect.Descriptor instead.
func (*NewRunInfo) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{16}
}

func (x *NewRunInfo) GetRunId() string {
	if x != nil {
		return x.RunId
	}
	return ""
}

func (x *NewRunInfo) GetEventBatch() *v11.DataBlob {
	if x != nil {
		return x.EventBatch
	}
	return nil
}

type SyncWorkflowStateMutationAttributes struct {
	state                             protoimpl.MessageState            `protogen:"open.v1"`
	ExclusiveStartVersionedTransition *v12.VersionedTransition          `protobuf:"bytes,1,opt,name=exclusive_start_versioned_transition,json=exclusiveStartVersionedTransition,proto3" json:"exclusive_start_versioned_transition,omitempty"`
	StateMutation                     *v12.WorkflowMutableStateMutation `protobuf:"bytes,2,opt,name=state_mutation,json=stateMutation,proto3" json:"state_mutation,omitempty"`
	unknownFields                     protoimpl.UnknownFields
	sizeCache                         protoimpl.SizeCache
}

func (x *SyncWorkflowStateMutationAttributes) Reset() {
	*x = SyncWorkflowStateMutationAttributes{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncWorkflowStateMutationAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncWorkflowStateMutationAttributes) ProtoMessage() {}

func (x *SyncWorkflowStateMutationAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncWorkflowStateMutationAttributes.ProtoReflect.Descriptor instead.
func (*SyncWorkflowStateMutationAttributes) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{17}
}

func (x *SyncWorkflowStateMutationAttributes) GetExclusiveStartVersionedTransition() *v12.VersionedTransition {
	if x != nil {
		return x.ExclusiveStartVersionedTransition
	}
	return nil
}

func (x *SyncWorkflowStateMutationAttributes) GetStateMutation() *v12.WorkflowMutableStateMutation {
	if x != nil {
		return x.StateMutation
	}
	return nil
}

type SyncWorkflowStateSnapshotAttributes struct {
	state         protoimpl.MessageState    `protogen:"open.v1"`
	State         *v12.WorkflowMutableState `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyncWorkflowStateSnapshotAttributes) Reset() {
	*x = SyncWorkflowStateSnapshotAttributes{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncWorkflowStateSnapshotAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncWorkflowStateSnapshotAttributes) ProtoMessage() {}

func (x *SyncWorkflowStateSnapshotAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncWorkflowStateSnapshotAttributes.ProtoReflect.Descriptor instead.
func (*SyncWorkflowStateSnapshotAttributes) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{18}
}

func (x *SyncWorkflowStateSnapshotAttributes) GetState() *v12.WorkflowMutableState {
	if x != nil {
		return x.State
	}
	return nil
}

type VerifyVersionedTransitionTaskAttributes struct {
	state               protoimpl.MessageState    `protogen:"open.v1"`
	NamespaceId         string                    `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId          string                    `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId               string                    `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	NextEventId         int64                     `protobuf:"varint,4,opt,name=next_event_id,json=nextEventId,proto3" json:"next_event_id,omitempty"`
	EventVersionHistory []*v16.VersionHistoryItem `protobuf:"bytes,5,rep,name=event_version_history,json=eventVersionHistory,proto3" json:"event_version_history,omitempty"`
	NewRunId            string                    `protobuf:"bytes,6,opt,name=new_run_id,json=newRunId,proto3" json:"new_run_id,omitempty"`
	// (-- api-linter: core::0141::forbidden-types=disabled --)
	ArchetypeId   uint32 `protobuf:"varint,7,opt,name=archetype_id,json=archetypeId,proto3" json:"archetype_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VerifyVersionedTransitionTaskAttributes) Reset() {
	*x = VerifyVersionedTransitionTaskAttributes{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VerifyVersionedTransitionTaskAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyVersionedTransitionTaskAttributes) ProtoMessage() {}

func (x *VerifyVersionedTransitionTaskAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyVersionedTransitionTaskAttributes.ProtoReflect.Descriptor instead.
func (*VerifyVersionedTransitionTaskAttributes) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{19}
}

func (x *VerifyVersionedTransitionTaskAttributes) GetNamespaceId() string {
	if x != nil {
		return x.NamespaceId
	}
	return ""
}

func (x *VerifyVersionedTransitionTaskAttributes) GetWorkflowId() string {
	if x != nil {
		return x.WorkflowId
	}
	return ""
}

func (x *VerifyVersionedTransitionTaskAttributes) GetRunId() string {
	if x != nil {
		return x.RunId
	}
	return ""
}

func (x *VerifyVersionedTransitionTaskAttributes) GetNextEventId() int64 {
	if x != nil {
		return x.NextEventId
	}
	return 0
}

func (x *VerifyVersionedTransitionTaskAttributes) GetEventVersionHistory() []*v16.VersionHistoryItem {
	if x != nil {
		return x.EventVersionHistory
	}
	return nil
}

func (x *VerifyVersionedTransitionTaskAttributes) GetNewRunId() string {
	if x != nil {
		return x.NewRunId
	}
	return ""
}

func (x *VerifyVersionedTransitionTaskAttributes) GetArchetypeId() uint32 {
	if x != nil {
		return x.ArchetypeId
	}
	return 0
}

type SyncVersionedTransitionTaskAttributes struct {
	state                       protoimpl.MessageState       `protogen:"open.v1"`
	VersionedTransitionArtifact *VersionedTransitionArtifact `protobuf:"bytes,5,opt,name=versioned_transition_artifact,json=versionedTransitionArtifact,proto3" json:"versioned_transition_artifact,omitempty"`
	NamespaceId                 string                       `protobuf:"bytes,6,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId                  string                       `protobuf:"bytes,7,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId                       string                       `protobuf:"bytes,8,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	// (-- api-linter: core::0141::forbidden-types=disabled --)
	ArchetypeId   uint32 `protobuf:"varint,9,opt,name=archetype_id,json=archetypeId,proto3" json:"archetype_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyncVersionedTransitionTaskAttributes) Reset() {
	*x = SyncVersionedTransitionTaskAttributes{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyncVersionedTransitionTaskAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncVersionedTransitionTaskAttributes) ProtoMessage() {}

func (x *SyncVersionedTransitionTaskAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncVersionedTransitionTaskAttributes.ProtoReflect.Descriptor instead.
func (*SyncVersionedTransitionTaskAttributes) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{20}
}

func (x *SyncVersionedTransitionTaskAttributes) GetVersionedTransitionArtifact() *VersionedTransitionArtifact {
	if x != nil {
		return x.VersionedTransitionArtifact
	}
	return nil
}

func (x *SyncVersionedTransitionTaskAttributes) GetNamespaceId() string {
	if x != nil {
		return x.NamespaceId
	}
	return ""
}

func (x *SyncVersionedTransitionTaskAttributes) GetWorkflowId() string {
	if x != nil {
		return x.WorkflowId
	}
	return ""
}

func (x *SyncVersionedTransitionTaskAttributes) GetRunId() string {
	if x != nil {
		return x.RunId
	}
	return ""
}

func (x *SyncVersionedTransitionTaskAttributes) GetArchetypeId() uint32 {
	if x != nil {
		return x.ArchetypeId
	}
	return 0
}

type VersionedTransitionArtifact struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to StateAttributes:
	//
	//	*VersionedTransitionArtifact_SyncWorkflowStateMutationAttributes
	//	*VersionedTransitionArtifact_SyncWorkflowStateSnapshotAttributes
	StateAttributes          isVersionedTransitionArtifact_StateAttributes `protobuf_oneof:"state_attributes"`
	EventBatches             []*v11.DataBlob                               `protobuf:"bytes,3,rep,name=event_batches,json=eventBatches,proto3" json:"event_batches,omitempty"`
	NewRunInfo               *NewRunInfo                                   `protobuf:"bytes,4,opt,name=new_run_info,json=newRunInfo,proto3" json:"new_run_info,omitempty"`
	IsFirstSync              bool                                          `protobuf:"varint,5,opt,name=is_first_sync,json=isFirstSync,proto3" json:"is_first_sync,omitempty"`
	IsCloseTransferTaskAcked bool                                          `protobuf:"varint,6,opt,name=is_close_transfer_task_acked,json=isCloseTransferTaskAcked,proto3" json:"is_close_transfer_task_acked,omitempty"`
	IsForceReplication       bool                                          `protobuf:"varint,7,opt,name=is_force_replication,json=isForceReplication,proto3" json:"is_force_replication,omitempty"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *VersionedTransitionArtifact) Reset() {
	*x = VersionedTransitionArtifact{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VersionedTransitionArtifact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionedTransitionArtifact) ProtoMessage() {}

func (x *VersionedTransitionArtifact) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionedTransitionArtifact.ProtoReflect.Descriptor instead.
func (*VersionedTransitionArtifact) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{21}
}

func (x *VersionedTransitionArtifact) GetStateAttributes() isVersionedTransitionArtifact_StateAttributes {
	if x != nil {
		return x.StateAttributes
	}
	return nil
}

func (x *VersionedTransitionArtifact) GetSyncWorkflowStateMutationAttributes() *SyncWorkflowStateMutationAttributes {
	if x != nil {
		if x, ok := x.StateAttributes.(*VersionedTransitionArtifact_SyncWorkflowStateMutationAttributes); ok {
			return x.SyncWorkflowStateMutationAttributes
		}
	}
	return nil
}

func (x *VersionedTransitionArtifact) GetSyncWorkflowStateSnapshotAttributes() *SyncWorkflowStateSnapshotAttributes {
	if x != nil {
		if x, ok := x.StateAttributes.(*VersionedTransitionArtifact_SyncWorkflowStateSnapshotAttributes); ok {
			return x.SyncWorkflowStateSnapshotAttributes
		}
	}
	return nil
}

func (x *VersionedTransitionArtifact) GetEventBatches() []*v11.DataBlob {
	if x != nil {
		return x.EventBatches
	}
	return nil
}

func (x *VersionedTransitionArtifact) GetNewRunInfo() *NewRunInfo {
	if x != nil {
		return x.NewRunInfo
	}
	return nil
}

func (x *VersionedTransitionArtifact) GetIsFirstSync() bool {
	if x != nil {
		return x.IsFirstSync
	}
	return false
}

func (x *VersionedTransitionArtifact) GetIsCloseTransferTaskAcked() bool {
	if x != nil {
		return x.IsCloseTransferTaskAcked
	}
	return false
}

func (x *VersionedTransitionArtifact) GetIsForceReplication() bool {
	if x != nil {
		return x.IsForceReplication
	}
	return false
}

type isVersionedTransitionArtifact_StateAttributes interface {
	isVersionedTransitionArtifact_StateAttributes()
}

type VersionedTransitionArtifact_SyncWorkflowStateMutationAttributes struct {
	SyncWorkflowStateMutationAttributes *SyncWorkflowStateMutationAttributes `protobuf:"bytes,1,opt,name=sync_workflow_state_mutation_attributes,json=syncWorkflowStateMutationAttributes,proto3,oneof"`
}

type VersionedTransitionArtifact_SyncWorkflowStateSnapshotAttributes struct {
	SyncWorkflowStateSnapshotAttributes *SyncWorkflowStateSnapshotAttributes `protobuf:"bytes,2,opt,name=sync_workflow_state_snapshot_attributes,json=syncWorkflowStateSnapshotAttributes,proto3,oneof"`
}

func (*VersionedTransitionArtifact_SyncWorkflowStateMutationAttributes) isVersionedTransitionArtifact_StateAttributes() {
}

func (*VersionedTransitionArtifact_SyncWorkflowStateSnapshotAttributes) isVersionedTransitionArtifact_StateAttributes() {
}

type MigrationExecutionInfo struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The proto json name of this field needs to be "workflowId",
	// to be backward compatibility with commonpb.WorkflowExecution,
	// which is what used to be used in migration workflow's activity
	// input/output.
	BusinessId string `protobuf:"bytes,1,opt,name=business_id,json=workflowId,proto3" json:"business_id,omitempty"`
	RunId      string `protobuf:"bytes,2,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	// (-- api-linter: core::0141::forbidden-types=disabled --)
	ArchetypeId   uint32 `protobuf:"varint,3,opt,name=archetype_id,json=archetypeId,proto3" json:"archetype_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MigrationExecutionInfo) Reset() {
	*x = MigrationExecutionInfo{}
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MigrationExecutionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrationExecutionInfo) ProtoMessage() {}

func (x *MigrationExecutionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_replication_v1_message_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrationExecutionInfo.ProtoReflect.Descriptor instead.
func (*MigrationExecutionInfo) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_replication_v1_message_proto_rawDescGZIP(), []int{22}
}

func (x *MigrationExecutionInfo) GetBusinessId() string {
	if x != nil {
		return x.BusinessId
	}
	return ""
}

func (x *MigrationExecutionInfo) GetRunId() string {
	if x != nil {
		return x.RunId
	}
	return ""
}

func (x *MigrationExecutionInfo) GetArchetypeId() uint32 {
	if x != nil {
		return x.ArchetypeId
	}
	return 0
}

var File_temporal_server_api_replication_v1_message_proto protoreflect.FileDescriptor

const file_temporal_server_api_replication_v1_message_proto_rawDesc = "" +
	"\n" +
	"0temporal/server/api/replication/v1/message.proto\x12\"temporal.server.api.replication.v1\x1a\x1fgoogle/protobuf/timestamp.proto\x1a\x1egoogle/protobuf/duration.proto\x1a.temporal/server/api/enums/v1/replication.proto\x1a'temporal/server/api/enums/v1/task.proto\x1a,temporal/server/api/history/v1/message.proto\x1a3temporal/server/api/persistence/v1/executions.proto\x1a,temporal/server/api/persistence/v1/hsm.proto\x1a4temporal/server/api/persistence/v1/task_queues.proto\x1a?temporal/server/api/persistence/v1/workflow_mutable_state.proto\x1a$temporal/api/common/v1/message.proto\x1a'temporal/api/namespace/v1/message.proto\x1a)temporal/api/replication/v1/message.proto\x1a%temporal/api/failure/v1/message.proto\x1a-temporal/server/api/workflow/v1/message.proto\"\xa1\x0f\n" +
	"\x0fReplicationTask\x12N\n" +
	"\ttask_type\x18\x01 \x01(\x0e21.temporal.server.api.enums.v1.ReplicationTaskTypeR\btaskType\x12$\n" +
	"\x0esource_task_id\x18\x02 \x01(\x03R\fsourceTaskId\x12y\n" +
	"\x19namespace_task_attributes\x18\x03 \x01(\v2;.temporal.server.api.replication.v1.NamespaceTaskAttributesH\x00R\x17namespaceTaskAttributes\x12\x8d\x01\n" +
	"!sync_shard_status_task_attributes\x18\x05 \x01(\v2A.temporal.server.api.replication.v1.SyncShardStatusTaskAttributesH\x00R\x1dsyncShardStatusTaskAttributes\x12\x83\x01\n" +
	"\x1dsync_activity_task_attributes\x18\x06 \x01(\v2>.temporal.server.api.replication.v1.SyncActivityTaskAttributesH\x00R\x1asyncActivityTaskAttributes\x12s\n" +
	"\x17history_task_attributes\x18\b \x01(\v29.temporal.server.api.replication.v1.HistoryTaskAttributesH\x00R\x15historyTaskAttributes\x12\x93\x01\n" +
	"#sync_workflow_state_task_attributes\x18\n" +
	" \x01(\v2C.temporal.server.api.replication.v1.SyncWorkflowStateTaskAttributesH\x00R\x1fsyncWorkflowStateTaskAttributes\x12\x87\x01\n" +
	"\x1ftask_queue_user_data_attributes\x18\v \x01(\v2?.temporal.server.api.replication.v1.TaskQueueUserDataAttributesH\x00R\x1btaskQueueUserDataAttributes\x12g\n" +
	"\x13sync_hsm_attributes\x18\x0e \x01(\v25.temporal.server.api.replication.v1.SyncHSMAttributesH\x00R\x11syncHsmAttributes\x12\x8c\x01\n" +
	" backfill_history_task_attributes\x18\x10 \x01(\v2A.temporal.server.api.replication.v1.BackfillHistoryTaskAttributesH\x00R\x1dbackfillHistoryTaskAttributes\x12\xab\x01\n" +
	"+verify_versioned_transition_task_attributes\x18\x12 \x01(\v2K.temporal.server.api.replication.v1.VerifyVersionedTransitionTaskAttributesH\x00R'verifyVersionedTransitionTaskAttributes\x12\xa5\x01\n" +
	")sync_versioned_transition_task_attributes\x18\x13 \x01(\v2I.temporal.server.api.replication.v1.SyncVersionedTransitionTaskAttributesH\x00R%syncVersionedTransitionTaskAttributes\x124\n" +
	"\x04data\x18\f \x01(\v2 .temporal.api.common.v1.DataBlobR\x04data\x12C\n" +
	"\x0fvisibility_time\x18\t \x01(\v2\x1a.google.protobuf.TimestampR\x0evisibilityTime\x12F\n" +
	"\bpriority\x18\r \x01(\x0e2*.temporal.server.api.enums.v1.TaskPriorityR\bpriority\x12j\n" +
	"\x14versioned_transition\x18\x0f \x01(\v27.temporal.server.api.persistence.v1.VersionedTransitionR\x13versionedTransition\x12[\n" +
	"\rraw_task_info\x18\x11 \x01(\v27.temporal.server.api.persistence.v1.ReplicationTaskInfoR\vrawTaskInfoB\f\n" +
	"\n" +
	"attributesJ\x04\b\x04\x10\x05J\x04\b\a\x10\b\"\x84\x02\n" +
	"\x10ReplicationToken\x12\x19\n" +
	"\bshard_id\x18\x01 \x01(\x05R\ashardId\x129\n" +
	"\x19last_retrieved_message_id\x18\x02 \x01(\x03R\x16lastRetrievedMessageId\x129\n" +
	"\x19last_processed_message_id\x18\x03 \x01(\x03R\x16lastProcessedMessageId\x12_\n" +
	"\x1elast_processed_visibility_time\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampR\x1blastProcessedVisibilityTime\"N\n" +
	"\x0fSyncShardStatus\x12;\n" +
	"\vstatus_time\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"statusTime\"\xf5\x02\n" +
	"\x14SyncReplicationState\x126\n" +
	"\x17inclusive_low_watermark\x18\x01 \x01(\x03R\x15inclusiveLowWatermark\x12[\n" +
	"\x1cinclusive_low_watermark_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\x19inclusiveLowWatermarkTime\x12d\n" +
	"\x13high_priority_state\x18\x03 \x01(\v24.temporal.server.api.replication.v1.ReplicationStateR\x11highPriorityState\x12b\n" +
	"\x12low_priority_state\x18\x04 \x01(\v24.temporal.server.api.replication.v1.ReplicationStateR\x10lowPriorityState\"\x96\x02\n" +
	"\x10ReplicationState\x126\n" +
	"\x17inclusive_low_watermark\x18\x01 \x01(\x03R\x15inclusiveLowWatermark\x12[\n" +
	"\x1cinclusive_low_watermark_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\x19inclusiveLowWatermarkTime\x12m\n" +
	"\x14flow_control_command\x18\x03 \x01(\x0e2;.temporal.server.api.enums.v1.ReplicationFlowControlCommandR\x12flowControlCommand\"\xae\x02\n" +
	"\x13ReplicationMessages\x12`\n" +
	"\x11replication_tasks\x18\x01 \x03(\v23.temporal.server.api.replication.v1.ReplicationTaskR\x10replicationTasks\x129\n" +
	"\x19last_retrieved_message_id\x18\x02 \x01(\x03R\x16lastRetrievedMessageId\x12\x19\n" +
	"\bhas_more\x18\x03 \x01(\bR\ahasMore\x12_\n" +
	"\x11sync_shard_status\x18\x04 \x01(\v23.temporal.server.api.replication.v1.SyncShardStatusR\x0fsyncShardStatus\"\xe0\x02\n" +
	"\x1bWorkflowReplicationMessages\x12`\n" +
	"\x11replication_tasks\x18\x01 \x03(\v23.temporal.server.api.replication.v1.ReplicationTaskR\x10replicationTasks\x128\n" +
	"\x18exclusive_high_watermark\x18\x02 \x01(\x03R\x16exclusiveHighWatermark\x12]\n" +
	"\x1dexclusive_high_watermark_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\x1aexclusiveHighWatermarkTime\x12F\n" +
	"\bpriority\x18\x04 \x01(\x0e2*.temporal.server.api.enums.v1.TaskPriorityR\bpriority\"\xa8\x03\n" +
	"\x13ReplicationTaskInfo\x12!\n" +
	"\fnamespace_id\x18\x01 \x01(\tR\vnamespaceId\x12\x1f\n" +
	"\vworkflow_id\x18\x02 \x01(\tR\n" +
	"workflowId\x12\x15\n" +
	"\x06run_id\x18\x03 \x01(\tR\x05runId\x12C\n" +
	"\ttask_type\x18\x04 \x01(\x0e2&.temporal.server.api.enums.v1.TaskTypeR\btaskType\x12\x17\n" +
	"\atask_id\x18\x05 \x01(\x03R\x06taskId\x12\x18\n" +
	"\aversion\x18\x06 \x01(\x03R\aversion\x12$\n" +
	"\x0efirst_event_id\x18\a \x01(\x03R\ffirstEventId\x12\"\n" +
	"\rnext_event_id\x18\b \x01(\x03R\vnextEventId\x12,\n" +
	"\x12scheduled_event_id\x18\t \x01(\x03R\x10scheduledEventId\x12F\n" +
	"\bpriority\x18\n" +
	" \x01(\x0e2*.temporal.server.api.enums.v1.TaskPriorityR\bpriority\"\xa0\x04\n" +
	"\x17NamespaceTaskAttributes\x12a\n" +
	"\x13namespace_operation\x18\x01 \x01(\x0e20.temporal.server.api.enums.v1.NamespaceOperationR\x12namespaceOperation\x12\x0e\n" +
	"\x02id\x18\x02 \x01(\tR\x02id\x12<\n" +
	"\x04info\x18\x03 \x01(\v2(.temporal.api.namespace.v1.NamespaceInfoR\x04info\x12B\n" +
	"\x06config\x18\x04 \x01(\v2*.temporal.api.namespace.v1.NamespaceConfigR\x06config\x12f\n" +
	"\x12replication_config\x18\x05 \x01(\v27.temporal.api.replication.v1.NamespaceReplicationConfigR\x11replicationConfig\x12%\n" +
	"\x0econfig_version\x18\x06 \x01(\x03R\rconfigVersion\x12)\n" +
	"\x10failover_version\x18\a \x01(\x03R\x0ffailoverVersion\x12V\n" +
	"\x10failover_history\x18\b \x03(\v2+.temporal.api.replication.v1.FailoverStatusR\x0ffailoverHistory\"\x9e\x01\n" +
	"\x1dSyncShardStatusTaskAttributes\x12%\n" +
	"\x0esource_cluster\x18\x01 \x01(\tR\rsourceCluster\x12\x19\n" +
	"\bshard_id\x18\x02 \x01(\x05R\ashardId\x12;\n" +
	"\vstatus_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"statusTime\"\xc5\v\n" +
	"\x1aSyncActivityTaskAttributes\x12!\n" +
	"\fnamespace_id\x18\x01 \x01(\tR\vnamespaceId\x12\x1f\n" +
	"\vworkflow_id\x18\x02 \x01(\tR\n" +
	"workflowId\x12\x15\n" +
	"\x06run_id\x18\x03 \x01(\tR\x05runId\x12\x18\n" +
	"\aversion\x18\x04 \x01(\x03R\aversion\x12,\n" +
	"\x12scheduled_event_id\x18\x05 \x01(\x03R\x10scheduledEventId\x12A\n" +
	"\x0escheduled_time\x18\x06 \x01(\v2\x1a.google.protobuf.TimestampR\rscheduledTime\x12(\n" +
	"\x10started_event_id\x18\a \x01(\x03R\x0estartedEventId\x12=\n" +
	"\fstarted_time\x18\b \x01(\v2\x1a.google.protobuf.TimestampR\vstartedTime\x12J\n" +
	"\x13last_heartbeat_time\x18\t \x01(\v2\x1a.google.protobuf.TimestampR\x11lastHeartbeatTime\x12:\n" +
	"\adetails\x18\n" +
	" \x01(\v2 .temporal.api.common.v1.PayloadsR\adetails\x12\x18\n" +
	"\aattempt\x18\v \x01(\x05R\aattempt\x12C\n" +
	"\flast_failure\x18\f \x01(\v2 .temporal.api.failure.v1.FailureR\vlastFailure\x120\n" +
	"\x14last_worker_identity\x18\r \x01(\tR\x12lastWorkerIdentity\x12W\n" +
	"\x0fversion_history\x18\x0e \x01(\v2..temporal.server.api.history.v1.VersionHistoryR\x0eversionHistory\x12b\n" +
	"\x13base_execution_info\x18\x0f \x01(\v22.temporal.server.api.workflow.v1.BaseExecutionInfoR\x11baseExecutionInfo\x121\n" +
	"\x15last_started_build_id\x18\x10 \x01(\tR\x12lastStartedBuildId\x12A\n" +
	"\x1dlast_started_redirect_counter\x18\x11 \x01(\x03R\x1alastStartedRedirectCounter\x12L\n" +
	"\x14first_scheduled_time\x18\x12 \x01(\v2\x1a.google.protobuf.TimestampR\x12firstScheduledTime\x12W\n" +
	"\x1alast_attempt_complete_time\x18\x13 \x01(\v2\x1a.google.protobuf.TimestampR\x17lastAttemptCompleteTime\x12\x14\n" +
	"\x05stamp\x18\x14 \x01(\x05R\x05stamp\x12\x16\n" +
	"\x06paused\x18\x15 \x01(\bR\x06paused\x12O\n" +
	"\x16retry_initial_interval\x18\x16 \x01(\v2\x19.google.protobuf.DurationR\x14retryInitialInterval\x12O\n" +
	"\x16retry_maximum_interval\x18\x17 \x01(\v2\x19.google.protobuf.DurationR\x14retryMaximumInterval\x124\n" +
	"\x16retry_maximum_attempts\x18\x18 \x01(\x05R\x14retryMaximumAttempts\x12:\n" +
	"\x19retry_backoff_coefficient\x18\x19 \x01(\x01R\x17retryBackoffCoefficient\x12#\n" +
	"\rstart_version\x18\x1a \x01(\x03R\fstartVersion\"\xad\x04\n" +
	"\x15HistoryTaskAttributes\x12!\n" +
	"\fnamespace_id\x18\x02 \x01(\tR\vnamespaceId\x12\x1f\n" +
	"\vworkflow_id\x18\x03 \x01(\tR\n" +
	"workflowId\x12\x15\n" +
	"\x06run_id\x18\x04 \x01(\tR\x05runId\x12f\n" +
	"\x15version_history_items\x18\x05 \x03(\v22.temporal.server.api.history.v1.VersionHistoryItemR\x13versionHistoryItems\x128\n" +
	"\x06events\x18\x06 \x01(\v2 .temporal.api.common.v1.DataBlobR\x06events\x12F\n" +
	"\x0enew_run_events\x18\a \x01(\v2 .temporal.api.common.v1.DataBlobR\fnewRunEvents\x12b\n" +
	"\x13base_execution_info\x18\b \x01(\v22.temporal.server.api.workflow.v1.BaseExecutionInfoR\x11baseExecutionInfo\x12\x1c\n" +
	"\n" +
	"new_run_id\x18\t \x01(\tR\bnewRunId\x12G\n" +
	"\x0eevents_batches\x18\n" +
	" \x03(\v2 .temporal.api.common.v1.DataBlobR\reventsBatchesJ\x04\b\x01\x10\x02\"\xf4\x01\n" +
	"\x1fSyncWorkflowStateTaskAttributes\x12_\n" +
	"\x0eworkflow_state\x18\x01 \x01(\v28.temporal.server.api.persistence.v1.WorkflowMutableStateR\rworkflowState\x120\n" +
	"\x14is_force_replication\x18\x02 \x01(\bR\x12isForceReplication\x12>\n" +
	"\x1cis_close_transfer_task_acked\x18\x03 \x01(\bR\x18isCloseTransferTaskAcked\"\xbc\x01\n" +
	"\x1bTaskQueueUserDataAttributes\x12!\n" +
	"\fnamespace_id\x18\x01 \x01(\tR\vnamespaceId\x12&\n" +
	"\x0ftask_queue_name\x18\x02 \x01(\tR\rtaskQueueName\x12R\n" +
	"\tuser_data\x18\x03 \x01(\v25.temporal.server.api.persistence.v1.TaskQueueUserDataR\buserData\"\xab\x02\n" +
	"\x11SyncHSMAttributes\x12!\n" +
	"\fnamespace_id\x18\x01 \x01(\tR\vnamespaceId\x12\x1f\n" +
	"\vworkflow_id\x18\x02 \x01(\tR\n" +
	"workflowId\x12\x15\n" +
	"\x06run_id\x18\x03 \x01(\tR\x05runId\x12W\n" +
	"\x0fversion_history\x18\x04 \x01(\v2..temporal.server.api.history.v1.VersionHistoryR\x0eversionHistory\x12b\n" +
	"\x12state_machine_node\x18\x05 \x01(\v24.temporal.server.api.persistence.v1.StateMachineNodeR\x10stateMachineNode\"\xfb\x02\n" +
	"\x1dBackfillHistoryTaskAttributes\x12!\n" +
	"\fnamespace_id\x18\x01 \x01(\tR\vnamespaceId\x12\x1f\n" +
	"\vworkflow_id\x18\x02 \x01(\tR\n" +
	"workflowId\x12\x15\n" +
	"\x06run_id\x18\x03 \x01(\tR\x05runId\x12f\n" +
	"\x15event_version_history\x18\x05 \x03(\v22.temporal.server.api.history.v1.VersionHistoryItemR\x13eventVersionHistory\x12E\n" +
	"\revent_batches\x18\x06 \x03(\v2 .temporal.api.common.v1.DataBlobR\feventBatches\x12P\n" +
	"\fnew_run_info\x18\a \x01(\v2..temporal.server.api.replication.v1.NewRunInfoR\n" +
	"newRunInfo\"f\n" +
	"\n" +
	"NewRunInfo\x12\x15\n" +
	"\x06run_id\x18\x01 \x01(\tR\x05runId\x12A\n" +
	"\vevent_batch\x18\x02 \x01(\v2 .temporal.api.common.v1.DataBlobR\n" +
	"eventBatch\"\x99\x02\n" +
	"#SyncWorkflowStateMutationAttributes\x12\x88\x01\n" +
	"$exclusive_start_versioned_transition\x18\x01 \x01(\v27.temporal.server.api.persistence.v1.VersionedTransitionR!exclusiveStartVersionedTransition\x12g\n" +
	"\x0estate_mutation\x18\x02 \x01(\v2@.temporal.server.api.persistence.v1.WorkflowMutableStateMutationR\rstateMutation\"u\n" +
	"#SyncWorkflowStateSnapshotAttributes\x12N\n" +
	"\x05state\x18\x01 \x01(\v28.temporal.server.api.persistence.v1.WorkflowMutableStateR\x05state\"\xd1\x02\n" +
	"'VerifyVersionedTransitionTaskAttributes\x12!\n" +
	"\fnamespace_id\x18\x01 \x01(\tR\vnamespaceId\x12\x1f\n" +
	"\vworkflow_id\x18\x02 \x01(\tR\n" +
	"workflowId\x12\x15\n" +
	"\x06run_id\x18\x03 \x01(\tR\x05runId\x12\"\n" +
	"\rnext_event_id\x18\x04 \x01(\x03R\vnextEventId\x12f\n" +
	"\x15event_version_history\x18\x05 \x03(\v22.temporal.server.api.history.v1.VersionHistoryItemR\x13eventVersionHistory\x12\x1c\n" +
	"\n" +
	"new_run_id\x18\x06 \x01(\tR\bnewRunId\x12!\n" +
	"\farchetype_id\x18\a \x01(\rR\varchetypeId\"\xc3\x02\n" +
	"%SyncVersionedTransitionTaskAttributes\x12\x83\x01\n" +
	"\x1dversioned_transition_artifact\x18\x05 \x01(\v2?.temporal.server.api.replication.v1.VersionedTransitionArtifactR\x1bversionedTransitionArtifact\x12!\n" +
	"\fnamespace_id\x18\x06 \x01(\tR\vnamespaceId\x12\x1f\n" +
	"\vworkflow_id\x18\a \x01(\tR\n" +
	"workflowId\x12\x15\n" +
	"\x06run_id\x18\b \x01(\tR\x05runId\x12!\n" +
	"\farchetype_id\x18\t \x01(\rR\varchetypeIdJ\x04\b\x01\x10\x02J\x04\b\x02\x10\x03J\x04\b\x03\x10\x04J\x04\b\x04\x10\x05\"\xa4\x05\n" +
	"\x1bVersionedTransitionArtifact\x12\x9f\x01\n" +
	"'sync_workflow_state_mutation_attributes\x18\x01 \x01(\v2G.temporal.server.api.replication.v1.SyncWorkflowStateMutationAttributesH\x00R#syncWorkflowStateMutationAttributes\x12\x9f\x01\n" +
	"'sync_workflow_state_snapshot_attributes\x18\x02 \x01(\v2G.temporal.server.api.replication.v1.SyncWorkflowStateSnapshotAttributesH\x00R#syncWorkflowStateSnapshotAttributes\x12E\n" +
	"\revent_batches\x18\x03 \x03(\v2 .temporal.api.common.v1.DataBlobR\feventBatches\x12P\n" +
	"\fnew_run_info\x18\x04 \x01(\v2..temporal.server.api.replication.v1.NewRunInfoR\n" +
	"newRunInfo\x12\"\n" +
	"\ris_first_sync\x18\x05 \x01(\bR\visFirstSync\x12>\n" +
	"\x1cis_close_transfer_task_acked\x18\x06 \x01(\bR\x18isCloseTransferTaskAcked\x120\n" +
	"\x14is_force_replication\x18\a \x01(\bR\x12isForceReplicationB\x12\n" +
	"\x10state_attributes\"s\n" +
	"\x16MigrationExecutionInfo\x12\x1f\n" +
	"\vbusiness_id\x18\x01 \x01(\tR\n" +
	"workflowId\x12\x15\n" +
	"\x06run_id\x18\x02 \x01(\tR\x05runId\x12!\n" +
	"\farchetype_id\x18\x03 \x01(\rR\varchetypeIdB5Z3go.temporal.io/server/api/replication/v1;repicationb\x06proto3"

var (
	file_temporal_server_api_replication_v1_message_proto_rawDescOnce sync.Once
	file_temporal_server_api_replication_v1_message_proto_rawDescData []byte
)

func file_temporal_server_api_replication_v1_message_proto_rawDescGZIP() []byte {
	file_temporal_server_api_replication_v1_message_proto_rawDescOnce.Do(func() {
		file_temporal_server_api_replication_v1_message_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_temporal_server_api_replication_v1_message_proto_rawDesc), len(file_temporal_server_api_replication_v1_message_proto_rawDesc)))
	})
	return file_temporal_server_api_replication_v1_message_proto_rawDescData
}

var file_temporal_server_api_replication_v1_message_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_temporal_server_api_replication_v1_message_proto_goTypes = []any{
	(*ReplicationTask)(nil),                         // 0: temporal.server.api.replication.v1.ReplicationTask
	(*ReplicationToken)(nil),                        // 1: temporal.server.api.replication.v1.ReplicationToken
	(*SyncShardStatus)(nil),                         // 2: temporal.server.api.replication.v1.SyncShardStatus
	(*SyncReplicationState)(nil),                    // 3: temporal.server.api.replication.v1.SyncReplicationState
	(*ReplicationState)(nil),                        // 4: temporal.server.api.replication.v1.ReplicationState
	(*ReplicationMessages)(nil),                     // 5: temporal.server.api.replication.v1.ReplicationMessages
	(*WorkflowReplicationMessages)(nil),             // 6: temporal.server.api.replication.v1.WorkflowReplicationMessages
	(*ReplicationTaskInfo)(nil),                     // 7: temporal.server.api.replication.v1.ReplicationTaskInfo
	(*NamespaceTaskAttributes)(nil),                 // 8: temporal.server.api.replication.v1.NamespaceTaskAttributes
	(*SyncShardStatusTaskAttributes)(nil),           // 9: temporal.server.api.replication.v1.SyncShardStatusTaskAttributes
	(*SyncActivityTaskAttributes)(nil),              // 10: temporal.server.api.replication.v1.SyncActivityTaskAttributes
	(*HistoryTaskAttributes)(nil),                   // 11: temporal.server.api.replication.v1.HistoryTaskAttributes
	(*SyncWorkflowStateTaskAttributes)(nil),         // 12: temporal.server.api.replication.v1.SyncWorkflowStateTaskAttributes
	(*TaskQueueUserDataAttributes)(nil),             // 13: temporal.server.api.replication.v1.TaskQueueUserDataAttributes
	(*SyncHSMAttributes)(nil),                       // 14: temporal.server.api.replication.v1.SyncHSMAttributes
	(*BackfillHistoryTaskAttributes)(nil),           // 15: temporal.server.api.replication.v1.BackfillHistoryTaskAttributes
	(*NewRunInfo)(nil),                              // 16: temporal.server.api.replication.v1.NewRunInfo
	(*SyncWorkflowStateMutationAttributes)(nil),     // 17: temporal.server.api.replication.v1.SyncWorkflowStateMutationAttributes
	(*SyncWorkflowStateSnapshotAttributes)(nil),     // 18: temporal.server.api.replication.v1.SyncWorkflowStateSnapshotAttributes
	(*VerifyVersionedTransitionTaskAttributes)(nil), // 19: temporal.server.api.replication.v1.VerifyVersionedTransitionTaskAttributes
	(*SyncVersionedTransitionTaskAttributes)(nil),   // 20: temporal.server.api.replication.v1.SyncVersionedTransitionTaskAttributes
	(*VersionedTransitionArtifact)(nil),             // 21: temporal.server.api.replication.v1.VersionedTransitionArtifact
	(*MigrationExecutionInfo)(nil),                  // 22: temporal.server.api.replication.v1.MigrationExecutionInfo
	(v1.ReplicationTaskType)(0),                     // 23: temporal.server.api.enums.v1.ReplicationTaskType
	(*v11.DataBlob)(nil),                            // 24: temporal.api.common.v1.DataBlob
	(*timestamppb.Timestamp)(nil),                   // 25: google.protobuf.Timestamp
	(v1.TaskPriority)(0),                            // 26: temporal.server.api.enums.v1.TaskPriority
	(*v12.VersionedTransition)(nil),                 // 27: temporal.server.api.persistence.v1.VersionedTransition
	(*v12.ReplicationTaskInfo)(nil),                 // 28: temporal.server.api.persistence.v1.ReplicationTaskInfo
	(v1.ReplicationFlowControlCommand)(0),           // 29: temporal.server.api.enums.v1.ReplicationFlowControlCommand
	(v1.TaskType)(0),                                // 30: temporal.server.api.enums.v1.TaskType
	(v1.NamespaceOperation)(0),                      // 31: temporal.server.api.enums.v1.NamespaceOperation
	(*v13.NamespaceInfo)(nil),                       // 32: temporal.api.namespace.v1.NamespaceInfo
	(*v13.NamespaceConfig)(nil),                     // 33: temporal.api.namespace.v1.NamespaceConfig
	(*v14.NamespaceReplicationConfig)(nil),          // 34: temporal.api.replication.v1.NamespaceReplicationConfig
	(*v14.FailoverStatus)(nil),                      // 35: temporal.api.replication.v1.FailoverStatus
	(*v11.Payloads)(nil),                            // 36: temporal.api.common.v1.Payloads
	(*v15.Failure)(nil),                             // 37: temporal.api.failure.v1.Failure
	(*v16.VersionHistory)(nil),                      // 38: temporal.server.api.history.v1.VersionHistory
	(*v17.BaseExecutionInfo)(nil),                   // 39: temporal.server.api.workflow.v1.BaseExecutionInfo
	(*durationpb.Duration)(nil),                     // 40: google.protobuf.Duration
	(*v16.VersionHistoryItem)(nil),                  // 41: temporal.server.api.history.v1.VersionHistoryItem
	(*v12.WorkflowMutableState)(nil),                // 42: temporal.server.api.persistence.v1.WorkflowMutableState
	(*v12.TaskQueueUserData)(nil),                   // 43: temporal.server.api.persistence.v1.TaskQueueUserData
	(*v12.StateMachineNode)(nil),                    // 44: temporal.server.api.persistence.v1.StateMachineNode
	(*v12.WorkflowMutableStateMutation)(nil),        // 45: temporal.server.api.persistence.v1.WorkflowMutableStateMutation
}
var file_temporal_server_api_replication_v1_message_proto_depIdxs = []int32{
	23, // 0: temporal.server.api.replication.v1.ReplicationTask.task_type:type_name -> temporal.server.api.enums.v1.ReplicationTaskType
	8,  // 1: temporal.server.api.replication.v1.ReplicationTask.namespace_task_attributes:type_name -> temporal.server.api.replication.v1.NamespaceTaskAttributes
	9,  // 2: temporal.server.api.replication.v1.ReplicationTask.sync_shard_status_task_attributes:type_name -> temporal.server.api.replication.v1.SyncShardStatusTaskAttributes
	10, // 3: temporal.server.api.replication.v1.ReplicationTask.sync_activity_task_attributes:type_name -> temporal.server.api.replication.v1.SyncActivityTaskAttributes
	11, // 4: temporal.server.api.replication.v1.ReplicationTask.history_task_attributes:type_name -> temporal.server.api.replication.v1.HistoryTaskAttributes
	12, // 5: temporal.server.api.replication.v1.ReplicationTask.sync_workflow_state_task_attributes:type_name -> temporal.server.api.replication.v1.SyncWorkflowStateTaskAttributes
	13, // 6: temporal.server.api.replication.v1.ReplicationTask.task_queue_user_data_attributes:type_name -> temporal.server.api.replication.v1.TaskQueueUserDataAttributes
	14, // 7: temporal.server.api.replication.v1.ReplicationTask.sync_hsm_attributes:type_name -> temporal.server.api.replication.v1.SyncHSMAttributes
	15, // 8: temporal.server.api.replication.v1.ReplicationTask.backfill_history_task_attributes:type_name -> temporal.server.api.replication.v1.BackfillHistoryTaskAttributes
	19, // 9: temporal.server.api.replication.v1.ReplicationTask.verify_versioned_transition_task_attributes:type_name -> temporal.server.api.replication.v1.VerifyVersionedTransitionTaskAttributes
	20, // 10: temporal.server.api.replication.v1.ReplicationTask.sync_versioned_transition_task_attributes:type_name -> temporal.server.api.replication.v1.SyncVersionedTransitionTaskAttributes
	24, // 11: temporal.server.api.replication.v1.ReplicationTask.data:type_name -> temporal.api.common.v1.DataBlob
	25, // 12: temporal.server.api.replication.v1.ReplicationTask.visibility_time:type_name -> google.protobuf.Timestamp
	26, // 13: temporal.server.api.replication.v1.ReplicationTask.priority:type_name -> temporal.server.api.enums.v1.TaskPriority
	27, // 14: temporal.server.api.replication.v1.ReplicationTask.versioned_transition:type_name -> temporal.server.api.persistence.v1.VersionedTransition
	28, // 15: temporal.server.api.replication.v1.ReplicationTask.raw_task_info:type_name -> temporal.server.api.persistence.v1.ReplicationTaskInfo
	25, // 16: temporal.server.api.replication.v1.ReplicationToken.last_processed_visibility_time:type_name -> google.protobuf.Timestamp
	25, // 17: temporal.server.api.replication.v1.SyncShardStatus.status_time:type_name -> google.protobuf.Timestamp
	25, // 18: temporal.server.api.replication.v1.SyncReplicationState.inclusive_low_watermark_time:type_name -> google.protobuf.Timestamp
	4,  // 19: temporal.server.api.replication.v1.SyncReplicationState.high_priority_state:type_name -> temporal.server.api.replication.v1.ReplicationState
	4,  // 20: temporal.server.api.replication.v1.SyncReplicationState.low_priority_state:type_name -> temporal.server.api.replication.v1.ReplicationState
	25, // 21: temporal.server.api.replication.v1.ReplicationState.inclusive_low_watermark_time:type_name -> google.protobuf.Timestamp
	29, // 22: temporal.server.api.replication.v1.ReplicationState.flow_control_command:type_name -> temporal.server.api.enums.v1.ReplicationFlowControlCommand
	0,  // 23: temporal.server.api.replication.v1.ReplicationMessages.replication_tasks:type_name -> temporal.server.api.replication.v1.ReplicationTask
	2,  // 24: temporal.server.api.replication.v1.ReplicationMessages.sync_shard_status:type_name -> temporal.server.api.replication.v1.SyncShardStatus
	0,  // 25: temporal.server.api.replication.v1.WorkflowReplicationMessages.replication_tasks:type_name -> temporal.server.api.replication.v1.ReplicationTask
	25, // 26: temporal.server.api.replication.v1.WorkflowReplicationMessages.exclusive_high_watermark_time:type_name -> google.protobuf.Timestamp
	26, // 27: temporal.server.api.replication.v1.WorkflowReplicationMessages.priority:type_name -> temporal.server.api.enums.v1.TaskPriority
	30, // 28: temporal.server.api.replication.v1.ReplicationTaskInfo.task_type:type_name -> temporal.server.api.enums.v1.TaskType
	26, // 29: temporal.server.api.replication.v1.ReplicationTaskInfo.priority:type_name -> temporal.server.api.enums.v1.TaskPriority
	31, // 30: temporal.server.api.replication.v1.NamespaceTaskAttributes.namespace_operation:type_name -> temporal.server.api.enums.v1.NamespaceOperation
	32, // 31: temporal.server.api.replication.v1.NamespaceTaskAttributes.info:type_name -> temporal.api.namespace.v1.NamespaceInfo
	33, // 32: temporal.server.api.replication.v1.NamespaceTaskAttributes.config:type_name -> temporal.api.namespace.v1.NamespaceConfig
	34, // 33: temporal.server.api.replication.v1.NamespaceTaskAttributes.replication_config:type_name -> temporal.api.replication.v1.NamespaceReplicationConfig
	35, // 34: temporal.server.api.replication.v1.NamespaceTaskAttributes.failover_history:type_name -> temporal.api.replication.v1.FailoverStatus
	25, // 35: temporal.server.api.replication.v1.SyncShardStatusTaskAttributes.status_time:type_name -> google.protobuf.Timestamp
	25, // 36: temporal.server.api.replication.v1.SyncActivityTaskAttributes.scheduled_time:type_name -> google.protobuf.Timestamp
	25, // 37: temporal.server.api.replication.v1.SyncActivityTaskAttributes.started_time:type_name -> google.protobuf.Timestamp
	25, // 38: temporal.server.api.replication.v1.SyncActivityTaskAttributes.last_heartbeat_time:type_name -> google.protobuf.Timestamp
	36, // 39: temporal.server.api.replication.v1.SyncActivityTaskAttributes.details:type_name -> temporal.api.common.v1.Payloads
	37, // 40: temporal.server.api.replication.v1.SyncActivityTaskAttributes.last_failure:type_name -> temporal.api.failure.v1.Failure
	38, // 41: temporal.server.api.replication.v1.SyncActivityTaskAttributes.version_history:type_name -> temporal.server.api.history.v1.VersionHistory
	39, // 42: temporal.server.api.replication.v1.SyncActivityTaskAttributes.base_execution_info:type_name -> temporal.server.api.workflow.v1.BaseExecutionInfo
	25, // 43: temporal.server.api.replication.v1.SyncActivityTaskAttributes.first_scheduled_time:type_name -> google.protobuf.Timestamp
	25, // 44: temporal.server.api.replication.v1.SyncActivityTaskAttributes.last_attempt_complete_time:type_name -> google.protobuf.Timestamp
	40, // 45: temporal.server.api.replication.v1.SyncActivityTaskAttributes.retry_initial_interval:type_name -> google.protobuf.Duration
	40, // 46: temporal.server.api.replication.v1.SyncActivityTaskAttributes.retry_maximum_interval:type_name -> google.protobuf.Duration
	41, // 47: temporal.server.api.replication.v1.HistoryTaskAttributes.version_history_items:type_name -> temporal.server.api.history.v1.VersionHistoryItem
	24, // 48: temporal.server.api.replication.v1.HistoryTaskAttributes.events:type_name -> temporal.api.common.v1.DataBlob
	24, // 49: temporal.server.api.replication.v1.HistoryTaskAttributes.new_run_events:type_name -> temporal.api.common.v1.DataBlob
	39, // 50: temporal.server.api.replication.v1.HistoryTaskAttributes.base_execution_info:type_name -> temporal.server.api.workflow.v1.BaseExecutionInfo
	24, // 51: temporal.server.api.replication.v1.HistoryTaskAttributes.events_batches:type_name -> temporal.api.common.v1.DataBlob
	42, // 52: temporal.server.api.replication.v1.SyncWorkflowStateTaskAttributes.workflow_state:type_name -> temporal.server.api.persistence.v1.WorkflowMutableState
	43, // 53: temporal.server.api.replication.v1.TaskQueueUserDataAttributes.user_data:type_name -> temporal.server.api.persistence.v1.TaskQueueUserData
	38, // 54: temporal.server.api.replication.v1.SyncHSMAttributes.version_history:type_name -> temporal.server.api.history.v1.VersionHistory
	44, // 55: temporal.server.api.replication.v1.SyncHSMAttributes.state_machine_node:type_name -> temporal.server.api.persistence.v1.StateMachineNode
	41, // 56: temporal.server.api.replication.v1.BackfillHistoryTaskAttributes.event_version_history:type_name -> temporal.server.api.history.v1.VersionHistoryItem
	24, // 57: temporal.server.api.replication.v1.BackfillHistoryTaskAttributes.event_batches:type_name -> temporal.api.common.v1.DataBlob
	16, // 58: temporal.server.api.replication.v1.BackfillHistoryTaskAttributes.new_run_info:type_name -> temporal.server.api.replication.v1.NewRunInfo
	24, // 59: temporal.server.api.replication.v1.NewRunInfo.event_batch:type_name -> temporal.api.common.v1.DataBlob
	27, // 60: temporal.server.api.replication.v1.SyncWorkflowStateMutationAttributes.exclusive_start_versioned_transition:type_name -> temporal.server.api.persistence.v1.VersionedTransition
	45, // 61: temporal.server.api.replication.v1.SyncWorkflowStateMutationAttributes.state_mutation:type_name -> temporal.server.api.persistence.v1.WorkflowMutableStateMutation
	42, // 62: temporal.server.api.replication.v1.SyncWorkflowStateSnapshotAttributes.state:type_name -> temporal.server.api.persistence.v1.WorkflowMutableState
	41, // 63: temporal.server.api.replication.v1.VerifyVersionedTransitionTaskAttributes.event_version_history:type_name -> temporal.server.api.history.v1.VersionHistoryItem
	21, // 64: temporal.server.api.replication.v1.SyncVersionedTransitionTaskAttributes.versioned_transition_artifact:type_name -> temporal.server.api.replication.v1.VersionedTransitionArtifact
	17, // 65: temporal.server.api.replication.v1.VersionedTransitionArtifact.sync_workflow_state_mutation_attributes:type_name -> temporal.server.api.replication.v1.SyncWorkflowStateMutationAttributes
	18, // 66: temporal.server.api.replication.v1.VersionedTransitionArtifact.sync_workflow_state_snapshot_attributes:type_name -> temporal.server.api.replication.v1.SyncWorkflowStateSnapshotAttributes
	24, // 67: temporal.server.api.replication.v1.VersionedTransitionArtifact.event_batches:type_name -> temporal.api.common.v1.DataBlob
	16, // 68: temporal.server.api.replication.v1.VersionedTransitionArtifact.new_run_info:type_name -> temporal.server.api.replication.v1.NewRunInfo
	69, // [69:69] is the sub-list for method output_type
	69, // [69:69] is the sub-list for method input_type
	69, // [69:69] is the sub-list for extension type_name
	69, // [69:69] is the sub-list for extension extendee
	0,  // [0:69] is the sub-list for field type_name
}

func init() { file_temporal_server_api_replication_v1_message_proto_init() }
func file_temporal_server_api_replication_v1_message_proto_init() {
	if File_temporal_server_api_replication_v1_message_proto != nil {
		return
	}
	file_temporal_server_api_replication_v1_message_proto_msgTypes[0].OneofWrappers = []any{
		(*ReplicationTask_NamespaceTaskAttributes)(nil),
		(*ReplicationTask_SyncShardStatusTaskAttributes)(nil),
		(*ReplicationTask_SyncActivityTaskAttributes)(nil),
		(*ReplicationTask_HistoryTaskAttributes)(nil),
		(*ReplicationTask_SyncWorkflowStateTaskAttributes)(nil),
		(*ReplicationTask_TaskQueueUserDataAttributes)(nil),
		(*ReplicationTask_SyncHsmAttributes)(nil),
		(*ReplicationTask_BackfillHistoryTaskAttributes)(nil),
		(*ReplicationTask_VerifyVersionedTransitionTaskAttributes)(nil),
		(*ReplicationTask_SyncVersionedTransitionTaskAttributes)(nil),
	}
	file_temporal_server_api_replication_v1_message_proto_msgTypes[21].OneofWrappers = []any{
		(*VersionedTransitionArtifact_SyncWorkflowStateMutationAttributes)(nil),
		(*VersionedTransitionArtifact_SyncWorkflowStateSnapshotAttributes)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_temporal_server_api_replication_v1_message_proto_rawDesc), len(file_temporal_server_api_replication_v1_message_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_temporal_server_api_replication_v1_message_proto_goTypes,
		DependencyIndexes: file_temporal_server_api_replication_v1_message_proto_depIdxs,
		MessageInfos:      file_temporal_server_api_replication_v1_message_proto_msgTypes,
	}.Build()
	File_temporal_server_api_replication_v1_message_proto = out.File
	file_temporal_server_api_replication_v1_message_proto_goTypes = nil
	file_temporal_server_api_replication_v1_message_proto_depIdxs = nil
}
