// Code generated by protoc-gen-go. DO NOT EDIT.
// plugins:
// 	protoc-gen-go
// 	protoc
// source: temporal/server/api/schedule/v1/message.proto

package schedule

import (
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"

	v12 "go.temporal.io/api/common/v1"
	v1 "go.temporal.io/api/enums/v1"
	v13 "go.temporal.io/api/failure/v1"
	v11 "go.temporal.io/api/schedule/v1"
	v14 "go.temporal.io/api/workflowservice/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type BufferedStart struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Nominal (pre-jitter) and Actual (post-jitter) time of action
	NominalTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=nominal_time,json=nominalTime,proto3" json:"nominal_time,omitempty"`
	ActualTime  *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=actual_time,json=actualTime,proto3" json:"actual_time,omitempty"`
	// Desired time is usually nil, which should be interpreted as == actual time, but for starts
	// that are blocked behind another action, it is set to the close time of the previous action
	// for more meaningful metrics.
	DesiredTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=desired_time,json=desiredTime,proto3" json:"desired_time,omitempty"`
	// Overridden overlap policy
	OverlapPolicy v1.ScheduleOverlapPolicy `protobuf:"varint,3,opt,name=overlap_policy,json=overlapPolicy,proto3,enum=temporal.api.enums.v1.ScheduleOverlapPolicy" json:"overlap_policy,omitempty"`
	// Trigger-immediately or backfill
	Manual bool `protobuf:"varint,4,opt,name=manual,proto3" json:"manual,omitempty"`
	// An ID generated when the action is buffered for deduplication during
	// execution. Only used by the CHASM scheduler (otherwise left empty).
	RequestId string `protobuf:"bytes,6,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Initially 0. Once a BufferedStart is ready to execute (overlap policies
	// are resolved), its attempt count is set to 1. If a BufferedStart fails
	// execution, its attempt count here is incremented. Only used by the CHASM
	// scheduler (otherwise left empty).
	Attempt int64 `protobuf:"varint,7,opt,name=attempt,proto3" json:"attempt,omitempty"`
	// If a BufferedStart is rate limited or needs to backoff while retrying,
	// this time will be set, and the start will be held in the buffer until
	// the backoff time has passed. Only used by the CHASM scheduler (otherwise
	// ignored).
	BackoffTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=backoff_time,json=backoffTime,proto3" json:"backoff_time,omitempty"`
	// The precomputed workflow ID that should be used (as-is) when executing
	// this start. Only used by the CHASM scheduler (otherwise ignored).
	WorkflowId    string `protobuf:"bytes,9,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *BufferedStart) Reset() {
	*x = BufferedStart{}
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BufferedStart) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BufferedStart) ProtoMessage() {}

func (x *BufferedStart) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BufferedStart.ProtoReflect.Descriptor instead.
func (*BufferedStart) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_schedule_v1_message_proto_rawDescGZIP(), []int{0}
}

func (x *BufferedStart) GetNominalTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NominalTime
	}
	return nil
}

func (x *BufferedStart) GetActualTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ActualTime
	}
	return nil
}

func (x *BufferedStart) GetDesiredTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DesiredTime
	}
	return nil
}

func (x *BufferedStart) GetOverlapPolicy() v1.ScheduleOverlapPolicy {
	if x != nil {
		return x.OverlapPolicy
	}
	return v1.ScheduleOverlapPolicy(0)
}

func (x *BufferedStart) GetManual() bool {
	if x != nil {
		return x.Manual
	}
	return false
}

func (x *BufferedStart) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *BufferedStart) GetAttempt() int64 {
	if x != nil {
		return x.Attempt
	}
	return 0
}

func (x *BufferedStart) GetBackoffTime() *timestamppb.Timestamp {
	if x != nil {
		return x.BackoffTime
	}
	return nil
}

func (x *BufferedStart) GetWorkflowId() string {
	if x != nil {
		return x.WorkflowId
	}
	return ""
}

type InternalState struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	Namespace         string                 `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	NamespaceId       string                 `protobuf:"bytes,2,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	ScheduleId        string                 `protobuf:"bytes,8,opt,name=schedule_id,json=scheduleId,proto3" json:"schedule_id,omitempty"`
	LastProcessedTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=last_processed_time,json=lastProcessedTime,proto3" json:"last_processed_time,omitempty"`
	BufferedStarts    []*BufferedStart       `protobuf:"bytes,4,rep,name=buffered_starts,json=bufferedStarts,proto3" json:"buffered_starts,omitempty"`
	OngoingBackfills  []*v11.BackfillRequest `protobuf:"bytes,10,rep,name=ongoing_backfills,json=ongoingBackfills,proto3" json:"ongoing_backfills,omitempty"`
	// last completion/failure
	LastCompletionResult *v12.Payloads `protobuf:"bytes,5,opt,name=last_completion_result,json=lastCompletionResult,proto3" json:"last_completion_result,omitempty"`
	ContinuedFailure     *v13.Failure  `protobuf:"bytes,6,opt,name=continued_failure,json=continuedFailure,proto3" json:"continued_failure,omitempty"`
	// conflict token is implemented as simple sequence number
	ConflictToken int64 `protobuf:"varint,7,opt,name=conflict_token,json=conflictToken,proto3" json:"conflict_token,omitempty"`
	NeedRefresh   bool  `protobuf:"varint,9,opt,name=need_refresh,json=needRefresh,proto3" json:"need_refresh,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InternalState) Reset() {
	*x = InternalState{}
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InternalState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InternalState) ProtoMessage() {}

func (x *InternalState) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InternalState.ProtoReflect.Descriptor instead.
func (*InternalState) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_schedule_v1_message_proto_rawDescGZIP(), []int{1}
}

func (x *InternalState) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *InternalState) GetNamespaceId() string {
	if x != nil {
		return x.NamespaceId
	}
	return ""
}

func (x *InternalState) GetScheduleId() string {
	if x != nil {
		return x.ScheduleId
	}
	return ""
}

func (x *InternalState) GetLastProcessedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastProcessedTime
	}
	return nil
}

func (x *InternalState) GetBufferedStarts() []*BufferedStart {
	if x != nil {
		return x.BufferedStarts
	}
	return nil
}

func (x *InternalState) GetOngoingBackfills() []*v11.BackfillRequest {
	if x != nil {
		return x.OngoingBackfills
	}
	return nil
}

func (x *InternalState) GetLastCompletionResult() *v12.Payloads {
	if x != nil {
		return x.LastCompletionResult
	}
	return nil
}

func (x *InternalState) GetContinuedFailure() *v13.Failure {
	if x != nil {
		return x.ContinuedFailure
	}
	return nil
}

func (x *InternalState) GetConflictToken() int64 {
	if x != nil {
		return x.ConflictToken
	}
	return 0
}

func (x *InternalState) GetNeedRefresh() bool {
	if x != nil {
		return x.NeedRefresh
	}
	return false
}

type StartScheduleArgs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Schedule      *v11.Schedule          `protobuf:"bytes,1,opt,name=schedule,proto3" json:"schedule,omitempty"`
	Info          *v11.ScheduleInfo      `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
	InitialPatch  *v11.SchedulePatch     `protobuf:"bytes,3,opt,name=initial_patch,json=initialPatch,proto3" json:"initial_patch,omitempty"`
	State         *InternalState         `protobuf:"bytes,4,opt,name=state,proto3" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StartScheduleArgs) Reset() {
	*x = StartScheduleArgs{}
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartScheduleArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartScheduleArgs) ProtoMessage() {}

func (x *StartScheduleArgs) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartScheduleArgs.ProtoReflect.Descriptor instead.
func (*StartScheduleArgs) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_schedule_v1_message_proto_rawDescGZIP(), []int{2}
}

func (x *StartScheduleArgs) GetSchedule() *v11.Schedule {
	if x != nil {
		return x.Schedule
	}
	return nil
}

func (x *StartScheduleArgs) GetInfo() *v11.ScheduleInfo {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *StartScheduleArgs) GetInitialPatch() *v11.SchedulePatch {
	if x != nil {
		return x.InitialPatch
	}
	return nil
}

func (x *StartScheduleArgs) GetState() *InternalState {
	if x != nil {
		return x.State
	}
	return nil
}

type FullUpdateRequest struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	Schedule         *v11.Schedule          `protobuf:"bytes,1,opt,name=schedule,proto3" json:"schedule,omitempty"`
	ConflictToken    int64                  `protobuf:"varint,2,opt,name=conflict_token,json=conflictToken,proto3" json:"conflict_token,omitempty"`
	SearchAttributes *v12.SearchAttributes  `protobuf:"bytes,3,opt,name=search_attributes,json=searchAttributes,proto3" json:"search_attributes,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *FullUpdateRequest) Reset() {
	*x = FullUpdateRequest{}
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FullUpdateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FullUpdateRequest) ProtoMessage() {}

func (x *FullUpdateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FullUpdateRequest.ProtoReflect.Descriptor instead.
func (*FullUpdateRequest) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_schedule_v1_message_proto_rawDescGZIP(), []int{3}
}

func (x *FullUpdateRequest) GetSchedule() *v11.Schedule {
	if x != nil {
		return x.Schedule
	}
	return nil
}

func (x *FullUpdateRequest) GetConflictToken() int64 {
	if x != nil {
		return x.ConflictToken
	}
	return 0
}

func (x *FullUpdateRequest) GetSearchAttributes() *v12.SearchAttributes {
	if x != nil {
		return x.SearchAttributes
	}
	return nil
}

type DescribeResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Schedule      *v11.Schedule          `protobuf:"bytes,1,opt,name=schedule,proto3" json:"schedule,omitempty"`
	Info          *v11.ScheduleInfo      `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
	ConflictToken int64                  `protobuf:"varint,3,opt,name=conflict_token,json=conflictToken,proto3" json:"conflict_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DescribeResponse) Reset() {
	*x = DescribeResponse{}
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DescribeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DescribeResponse) ProtoMessage() {}

func (x *DescribeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DescribeResponse.ProtoReflect.Descriptor instead.
func (*DescribeResponse) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_schedule_v1_message_proto_rawDescGZIP(), []int{4}
}

func (x *DescribeResponse) GetSchedule() *v11.Schedule {
	if x != nil {
		return x.Schedule
	}
	return nil
}

func (x *DescribeResponse) GetInfo() *v11.ScheduleInfo {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *DescribeResponse) GetConflictToken() int64 {
	if x != nil {
		return x.ConflictToken
	}
	return 0
}

type WatchWorkflowRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Note: this will be sent to the activity with empty execution.run_id, and
	// the run id that we started in first_execution_run_id.
	Execution           *v12.WorkflowExecution `protobuf:"bytes,3,opt,name=execution,proto3" json:"execution,omitempty"`
	FirstExecutionRunId string                 `protobuf:"bytes,4,opt,name=first_execution_run_id,json=firstExecutionRunId,proto3" json:"first_execution_run_id,omitempty"`
	LongPoll            bool                   `protobuf:"varint,5,opt,name=long_poll,json=longPoll,proto3" json:"long_poll,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *WatchWorkflowRequest) Reset() {
	*x = WatchWorkflowRequest{}
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WatchWorkflowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WatchWorkflowRequest) ProtoMessage() {}

func (x *WatchWorkflowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WatchWorkflowRequest.ProtoReflect.Descriptor instead.
func (*WatchWorkflowRequest) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_schedule_v1_message_proto_rawDescGZIP(), []int{5}
}

func (x *WatchWorkflowRequest) GetExecution() *v12.WorkflowExecution {
	if x != nil {
		return x.Execution
	}
	return nil
}

func (x *WatchWorkflowRequest) GetFirstExecutionRunId() string {
	if x != nil {
		return x.FirstExecutionRunId
	}
	return ""
}

func (x *WatchWorkflowRequest) GetLongPoll() bool {
	if x != nil {
		return x.LongPoll
	}
	return false
}

type WatchWorkflowResponse struct {
	state  protoimpl.MessageState     `protogen:"open.v1"`
	Status v1.WorkflowExecutionStatus `protobuf:"varint,1,opt,name=status,proto3,enum=temporal.api.enums.v1.WorkflowExecutionStatus" json:"status,omitempty"`
	// Types that are valid to be assigned to ResultFailure:
	//
	//	*WatchWorkflowResponse_Result
	//	*WatchWorkflowResponse_Failure
	ResultFailure isWatchWorkflowResponse_ResultFailure `protobuf_oneof:"result_failure"`
	// Timestamp of close event
	CloseTime     *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=close_time,json=closeTime,proto3" json:"close_time,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WatchWorkflowResponse) Reset() {
	*x = WatchWorkflowResponse{}
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WatchWorkflowResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WatchWorkflowResponse) ProtoMessage() {}

func (x *WatchWorkflowResponse) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WatchWorkflowResponse.ProtoReflect.Descriptor instead.
func (*WatchWorkflowResponse) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_schedule_v1_message_proto_rawDescGZIP(), []int{6}
}

func (x *WatchWorkflowResponse) GetStatus() v1.WorkflowExecutionStatus {
	if x != nil {
		return x.Status
	}
	return v1.WorkflowExecutionStatus(0)
}

func (x *WatchWorkflowResponse) GetResultFailure() isWatchWorkflowResponse_ResultFailure {
	if x != nil {
		return x.ResultFailure
	}
	return nil
}

func (x *WatchWorkflowResponse) GetResult() *v12.Payloads {
	if x != nil {
		if x, ok := x.ResultFailure.(*WatchWorkflowResponse_Result); ok {
			return x.Result
		}
	}
	return nil
}

func (x *WatchWorkflowResponse) GetFailure() *v13.Failure {
	if x != nil {
		if x, ok := x.ResultFailure.(*WatchWorkflowResponse_Failure); ok {
			return x.Failure
		}
	}
	return nil
}

func (x *WatchWorkflowResponse) GetCloseTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CloseTime
	}
	return nil
}

type isWatchWorkflowResponse_ResultFailure interface {
	isWatchWorkflowResponse_ResultFailure()
}

type WatchWorkflowResponse_Result struct {
	Result *v12.Payloads `protobuf:"bytes,2,opt,name=result,proto3,oneof"`
}

type WatchWorkflowResponse_Failure struct {
	Failure *v13.Failure `protobuf:"bytes,3,opt,name=failure,proto3,oneof"`
}

func (*WatchWorkflowResponse_Result) isWatchWorkflowResponse_ResultFailure() {}

func (*WatchWorkflowResponse_Failure) isWatchWorkflowResponse_ResultFailure() {}

type StartWorkflowRequest struct {
	state                   protoimpl.MessageState             `protogen:"open.v1"`
	Request                 *v14.StartWorkflowExecutionRequest `protobuf:"bytes,2,opt,name=request,proto3" json:"request,omitempty"`
	CompletedRateLimitSleep bool                               `protobuf:"varint,6,opt,name=completed_rate_limit_sleep,json=completedRateLimitSleep,proto3" json:"completed_rate_limit_sleep,omitempty"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *StartWorkflowRequest) Reset() {
	*x = StartWorkflowRequest{}
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartWorkflowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartWorkflowRequest) ProtoMessage() {}

func (x *StartWorkflowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartWorkflowRequest.ProtoReflect.Descriptor instead.
func (*StartWorkflowRequest) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_schedule_v1_message_proto_rawDescGZIP(), []int{7}
}

func (x *StartWorkflowRequest) GetRequest() *v14.StartWorkflowExecutionRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *StartWorkflowRequest) GetCompletedRateLimitSleep() bool {
	if x != nil {
		return x.CompletedRateLimitSleep
	}
	return false
}

type StartWorkflowResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	RunId         string                 `protobuf:"bytes,1,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	RealStartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=real_start_time,json=realStartTime,proto3" json:"real_start_time,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StartWorkflowResponse) Reset() {
	*x = StartWorkflowResponse{}
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartWorkflowResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartWorkflowResponse) ProtoMessage() {}

func (x *StartWorkflowResponse) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartWorkflowResponse.ProtoReflect.Descriptor instead.
func (*StartWorkflowResponse) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_schedule_v1_message_proto_rawDescGZIP(), []int{8}
}

func (x *StartWorkflowResponse) GetRunId() string {
	if x != nil {
		return x.RunId
	}
	return ""
}

func (x *StartWorkflowResponse) GetRealStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RealStartTime
	}
	return nil
}

type CancelWorkflowRequest struct {
	state     protoimpl.MessageState `protogen:"open.v1"`
	RequestId string                 `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	Identity  string                 `protobuf:"bytes,4,opt,name=identity,proto3" json:"identity,omitempty"`
	// Note: run id in execution is first execution run id
	Execution     *v12.WorkflowExecution `protobuf:"bytes,5,opt,name=execution,proto3" json:"execution,omitempty"`
	Reason        string                 `protobuf:"bytes,6,opt,name=reason,proto3" json:"reason,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CancelWorkflowRequest) Reset() {
	*x = CancelWorkflowRequest{}
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelWorkflowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelWorkflowRequest) ProtoMessage() {}

func (x *CancelWorkflowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelWorkflowRequest.ProtoReflect.Descriptor instead.
func (*CancelWorkflowRequest) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_schedule_v1_message_proto_rawDescGZIP(), []int{9}
}

func (x *CancelWorkflowRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CancelWorkflowRequest) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

func (x *CancelWorkflowRequest) GetExecution() *v12.WorkflowExecution {
	if x != nil {
		return x.Execution
	}
	return nil
}

func (x *CancelWorkflowRequest) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

type TerminateWorkflowRequest struct {
	state     protoimpl.MessageState `protogen:"open.v1"`
	RequestId string                 `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	Identity  string                 `protobuf:"bytes,4,opt,name=identity,proto3" json:"identity,omitempty"`
	// Note: run id in execution is first execution run id
	Execution     *v12.WorkflowExecution `protobuf:"bytes,5,opt,name=execution,proto3" json:"execution,omitempty"`
	Reason        string                 `protobuf:"bytes,6,opt,name=reason,proto3" json:"reason,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TerminateWorkflowRequest) Reset() {
	*x = TerminateWorkflowRequest{}
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TerminateWorkflowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TerminateWorkflowRequest) ProtoMessage() {}

func (x *TerminateWorkflowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TerminateWorkflowRequest.ProtoReflect.Descriptor instead.
func (*TerminateWorkflowRequest) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_schedule_v1_message_proto_rawDescGZIP(), []int{10}
}

func (x *TerminateWorkflowRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *TerminateWorkflowRequest) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

func (x *TerminateWorkflowRequest) GetExecution() *v12.WorkflowExecution {
	if x != nil {
		return x.Execution
	}
	return nil
}

func (x *TerminateWorkflowRequest) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

type NextTimeCache struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// workflow logic version (invalidate when changed)
	Version int64 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// start time that the results were calculated from
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// next_times and nominal_times are a series of timestamp pairs, encoded as a nanosecond
	// offset from start_time. next_times has one value for each time in the cache.
	// nominal_times may have up to the same number of values, but it may also be shorter (or
	// empty), if the corresponding nominal time is equal to the next time.
	NextTimes     []int64 `protobuf:"varint,3,rep,packed,name=next_times,json=nextTimes,proto3" json:"next_times,omitempty"`
	NominalTimes  []int64 `protobuf:"varint,4,rep,packed,name=nominal_times,json=nominalTimes,proto3" json:"nominal_times,omitempty"`
	Completed     bool    `protobuf:"varint,5,opt,name=completed,proto3" json:"completed,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NextTimeCache) Reset() {
	*x = NextTimeCache{}
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NextTimeCache) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NextTimeCache) ProtoMessage() {}

func (x *NextTimeCache) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_api_schedule_v1_message_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NextTimeCache.ProtoReflect.Descriptor instead.
func (*NextTimeCache) Descriptor() ([]byte, []int) {
	return file_temporal_server_api_schedule_v1_message_proto_rawDescGZIP(), []int{11}
}

func (x *NextTimeCache) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *NextTimeCache) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *NextTimeCache) GetNextTimes() []int64 {
	if x != nil {
		return x.NextTimes
	}
	return nil
}

func (x *NextTimeCache) GetNominalTimes() []int64 {
	if x != nil {
		return x.NominalTimes
	}
	return nil
}

func (x *NextTimeCache) GetCompleted() bool {
	if x != nil {
		return x.Completed
	}
	return false
}

var File_temporal_server_api_schedule_v1_message_proto protoreflect.FileDescriptor

const file_temporal_server_api_schedule_v1_message_proto_rawDesc = "" +
	"\n" +
	"-temporal/server/api/schedule/v1/message.proto\x12\x1ftemporal.server.api.schedule.v1\x1a$temporal/api/common/v1/message.proto\x1a$temporal/api/enums/v1/schedule.proto\x1a$temporal/api/enums/v1/workflow.proto\x1a%temporal/api/failure/v1/message.proto\x1a&temporal/api/schedule/v1/message.proto\x1a6temporal/api/workflowservice/v1/request_response.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xd0\x03\n" +
	"\rBufferedStart\x12=\n" +
	"\fnominal_time\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\vnominalTime\x12;\n" +
	"\vactual_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"actualTime\x12=\n" +
	"\fdesired_time\x18\x05 \x01(\v2\x1a.google.protobuf.TimestampR\vdesiredTime\x12S\n" +
	"\x0eoverlap_policy\x18\x03 \x01(\x0e2,.temporal.api.enums.v1.ScheduleOverlapPolicyR\roverlapPolicy\x12\x16\n" +
	"\x06manual\x18\x04 \x01(\bR\x06manual\x12\x1d\n" +
	"\n" +
	"request_id\x18\x06 \x01(\tR\trequestId\x12\x18\n" +
	"\aattempt\x18\a \x01(\x03R\aattempt\x12=\n" +
	"\fbackoff_time\x18\b \x01(\v2\x1a.google.protobuf.TimestampR\vbackoffTime\x12\x1f\n" +
	"\vworkflow_id\x18\t \x01(\tR\n" +
	"workflowId\"\xdf\x04\n" +
	"\rInternalState\x12\x1c\n" +
	"\tnamespace\x18\x01 \x01(\tR\tnamespace\x12!\n" +
	"\fnamespace_id\x18\x02 \x01(\tR\vnamespaceId\x12\x1f\n" +
	"\vschedule_id\x18\b \x01(\tR\n" +
	"scheduleId\x12J\n" +
	"\x13last_processed_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\x11lastProcessedTime\x12W\n" +
	"\x0fbuffered_starts\x18\x04 \x03(\v2..temporal.server.api.schedule.v1.BufferedStartR\x0ebufferedStarts\x12V\n" +
	"\x11ongoing_backfills\x18\n" +
	" \x03(\v2).temporal.api.schedule.v1.BackfillRequestR\x10ongoingBackfills\x12V\n" +
	"\x16last_completion_result\x18\x05 \x01(\v2 .temporal.api.common.v1.PayloadsR\x14lastCompletionResult\x12M\n" +
	"\x11continued_failure\x18\x06 \x01(\v2 .temporal.api.failure.v1.FailureR\x10continuedFailure\x12%\n" +
	"\x0econflict_token\x18\a \x01(\x03R\rconflictToken\x12!\n" +
	"\fneed_refresh\x18\t \x01(\bR\vneedRefresh\"\xa3\x02\n" +
	"\x11StartScheduleArgs\x12>\n" +
	"\bschedule\x18\x01 \x01(\v2\".temporal.api.schedule.v1.ScheduleR\bschedule\x12:\n" +
	"\x04info\x18\x02 \x01(\v2&.temporal.api.schedule.v1.ScheduleInfoR\x04info\x12L\n" +
	"\rinitial_patch\x18\x03 \x01(\v2'.temporal.api.schedule.v1.SchedulePatchR\finitialPatch\x12D\n" +
	"\x05state\x18\x04 \x01(\v2..temporal.server.api.schedule.v1.InternalStateR\x05state\"\xd1\x01\n" +
	"\x11FullUpdateRequest\x12>\n" +
	"\bschedule\x18\x01 \x01(\v2\".temporal.api.schedule.v1.ScheduleR\bschedule\x12%\n" +
	"\x0econflict_token\x18\x02 \x01(\x03R\rconflictToken\x12U\n" +
	"\x11search_attributes\x18\x03 \x01(\v2(.temporal.api.common.v1.SearchAttributesR\x10searchAttributes\"\xb5\x01\n" +
	"\x10DescribeResponse\x12>\n" +
	"\bschedule\x18\x01 \x01(\v2\".temporal.api.schedule.v1.ScheduleR\bschedule\x12:\n" +
	"\x04info\x18\x02 \x01(\v2&.temporal.api.schedule.v1.ScheduleInfoR\x04info\x12%\n" +
	"\x0econflict_token\x18\x03 \x01(\x03R\rconflictToken\"\xb1\x01\n" +
	"\x14WatchWorkflowRequest\x12G\n" +
	"\texecution\x18\x03 \x01(\v2).temporal.api.common.v1.WorkflowExecutionR\texecution\x123\n" +
	"\x16first_execution_run_id\x18\x04 \x01(\tR\x13firstExecutionRunId\x12\x1b\n" +
	"\tlong_poll\x18\x05 \x01(\bR\blongPoll\"\xa6\x02\n" +
	"\x15WatchWorkflowResponse\x12F\n" +
	"\x06status\x18\x01 \x01(\x0e2..temporal.api.enums.v1.WorkflowExecutionStatusR\x06status\x12:\n" +
	"\x06result\x18\x02 \x01(\v2 .temporal.api.common.v1.PayloadsH\x00R\x06result\x12<\n" +
	"\afailure\x18\x03 \x01(\v2 .temporal.api.failure.v1.FailureH\x00R\afailure\x129\n" +
	"\n" +
	"close_time\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampR\tcloseTimeB\x10\n" +
	"\x0eresult_failure\"\xbf\x01\n" +
	"\x14StartWorkflowRequest\x12X\n" +
	"\arequest\x18\x02 \x01(\v2>.temporal.api.workflowservice.v1.StartWorkflowExecutionRequestR\arequest\x12;\n" +
	"\x1acompleted_rate_limit_sleep\x18\x06 \x01(\bR\x17completedRateLimitSleepJ\x04\b\x03\x10\x04J\x04\b\x04\x10\x05J\x04\b\x05\x10\x06\"r\n" +
	"\x15StartWorkflowResponse\x12\x15\n" +
	"\x06run_id\x18\x01 \x01(\tR\x05runId\x12B\n" +
	"\x0freal_start_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\rrealStartTime\"\xb3\x01\n" +
	"\x15CancelWorkflowRequest\x12\x1d\n" +
	"\n" +
	"request_id\x18\x03 \x01(\tR\trequestId\x12\x1a\n" +
	"\bidentity\x18\x04 \x01(\tR\bidentity\x12G\n" +
	"\texecution\x18\x05 \x01(\v2).temporal.api.common.v1.WorkflowExecutionR\texecution\x12\x16\n" +
	"\x06reason\x18\x06 \x01(\tR\x06reason\"\xb6\x01\n" +
	"\x18TerminateWorkflowRequest\x12\x1d\n" +
	"\n" +
	"request_id\x18\x03 \x01(\tR\trequestId\x12\x1a\n" +
	"\bidentity\x18\x04 \x01(\tR\bidentity\x12G\n" +
	"\texecution\x18\x05 \x01(\v2).temporal.api.common.v1.WorkflowExecutionR\texecution\x12\x16\n" +
	"\x06reason\x18\x06 \x01(\tR\x06reason\"\xc6\x01\n" +
	"\rNextTimeCache\x12\x18\n" +
	"\aversion\x18\x01 \x01(\x03R\aversion\x129\n" +
	"\n" +
	"start_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\tstartTime\x12\x1d\n" +
	"\n" +
	"next_times\x18\x03 \x03(\x03R\tnextTimes\x12#\n" +
	"\rnominal_times\x18\x04 \x03(\x03R\fnominalTimes\x12\x1c\n" +
	"\tcompleted\x18\x05 \x01(\bR\tcompletedB0Z.go.temporal.io/server/api/schedule/v1;scheduleb\x06proto3"

var (
	file_temporal_server_api_schedule_v1_message_proto_rawDescOnce sync.Once
	file_temporal_server_api_schedule_v1_message_proto_rawDescData []byte
)

func file_temporal_server_api_schedule_v1_message_proto_rawDescGZIP() []byte {
	file_temporal_server_api_schedule_v1_message_proto_rawDescOnce.Do(func() {
		file_temporal_server_api_schedule_v1_message_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_temporal_server_api_schedule_v1_message_proto_rawDesc), len(file_temporal_server_api_schedule_v1_message_proto_rawDesc)))
	})
	return file_temporal_server_api_schedule_v1_message_proto_rawDescData
}

var file_temporal_server_api_schedule_v1_message_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_temporal_server_api_schedule_v1_message_proto_goTypes = []any{
	(*BufferedStart)(nil),                     // 0: temporal.server.api.schedule.v1.BufferedStart
	(*InternalState)(nil),                     // 1: temporal.server.api.schedule.v1.InternalState
	(*StartScheduleArgs)(nil),                 // 2: temporal.server.api.schedule.v1.StartScheduleArgs
	(*FullUpdateRequest)(nil),                 // 3: temporal.server.api.schedule.v1.FullUpdateRequest
	(*DescribeResponse)(nil),                  // 4: temporal.server.api.schedule.v1.DescribeResponse
	(*WatchWorkflowRequest)(nil),              // 5: temporal.server.api.schedule.v1.WatchWorkflowRequest
	(*WatchWorkflowResponse)(nil),             // 6: temporal.server.api.schedule.v1.WatchWorkflowResponse
	(*StartWorkflowRequest)(nil),              // 7: temporal.server.api.schedule.v1.StartWorkflowRequest
	(*StartWorkflowResponse)(nil),             // 8: temporal.server.api.schedule.v1.StartWorkflowResponse
	(*CancelWorkflowRequest)(nil),             // 9: temporal.server.api.schedule.v1.CancelWorkflowRequest
	(*TerminateWorkflowRequest)(nil),          // 10: temporal.server.api.schedule.v1.TerminateWorkflowRequest
	(*NextTimeCache)(nil),                     // 11: temporal.server.api.schedule.v1.NextTimeCache
	(*timestamppb.Timestamp)(nil),             // 12: google.protobuf.Timestamp
	(v1.ScheduleOverlapPolicy)(0),             // 13: temporal.api.enums.v1.ScheduleOverlapPolicy
	(*v11.BackfillRequest)(nil),               // 14: temporal.api.schedule.v1.BackfillRequest
	(*v12.Payloads)(nil),                      // 15: temporal.api.common.v1.Payloads
	(*v13.Failure)(nil),                       // 16: temporal.api.failure.v1.Failure
	(*v11.Schedule)(nil),                      // 17: temporal.api.schedule.v1.Schedule
	(*v11.ScheduleInfo)(nil),                  // 18: temporal.api.schedule.v1.ScheduleInfo
	(*v11.SchedulePatch)(nil),                 // 19: temporal.api.schedule.v1.SchedulePatch
	(*v12.SearchAttributes)(nil),              // 20: temporal.api.common.v1.SearchAttributes
	(*v12.WorkflowExecution)(nil),             // 21: temporal.api.common.v1.WorkflowExecution
	(v1.WorkflowExecutionStatus)(0),           // 22: temporal.api.enums.v1.WorkflowExecutionStatus
	(*v14.StartWorkflowExecutionRequest)(nil), // 23: temporal.api.workflowservice.v1.StartWorkflowExecutionRequest
}
var file_temporal_server_api_schedule_v1_message_proto_depIdxs = []int32{
	12, // 0: temporal.server.api.schedule.v1.BufferedStart.nominal_time:type_name -> google.protobuf.Timestamp
	12, // 1: temporal.server.api.schedule.v1.BufferedStart.actual_time:type_name -> google.protobuf.Timestamp
	12, // 2: temporal.server.api.schedule.v1.BufferedStart.desired_time:type_name -> google.protobuf.Timestamp
	13, // 3: temporal.server.api.schedule.v1.BufferedStart.overlap_policy:type_name -> temporal.api.enums.v1.ScheduleOverlapPolicy
	12, // 4: temporal.server.api.schedule.v1.BufferedStart.backoff_time:type_name -> google.protobuf.Timestamp
	12, // 5: temporal.server.api.schedule.v1.InternalState.last_processed_time:type_name -> google.protobuf.Timestamp
	0,  // 6: temporal.server.api.schedule.v1.InternalState.buffered_starts:type_name -> temporal.server.api.schedule.v1.BufferedStart
	14, // 7: temporal.server.api.schedule.v1.InternalState.ongoing_backfills:type_name -> temporal.api.schedule.v1.BackfillRequest
	15, // 8: temporal.server.api.schedule.v1.InternalState.last_completion_result:type_name -> temporal.api.common.v1.Payloads
	16, // 9: temporal.server.api.schedule.v1.InternalState.continued_failure:type_name -> temporal.api.failure.v1.Failure
	17, // 10: temporal.server.api.schedule.v1.StartScheduleArgs.schedule:type_name -> temporal.api.schedule.v1.Schedule
	18, // 11: temporal.server.api.schedule.v1.StartScheduleArgs.info:type_name -> temporal.api.schedule.v1.ScheduleInfo
	19, // 12: temporal.server.api.schedule.v1.StartScheduleArgs.initial_patch:type_name -> temporal.api.schedule.v1.SchedulePatch
	1,  // 13: temporal.server.api.schedule.v1.StartScheduleArgs.state:type_name -> temporal.server.api.schedule.v1.InternalState
	17, // 14: temporal.server.api.schedule.v1.FullUpdateRequest.schedule:type_name -> temporal.api.schedule.v1.Schedule
	20, // 15: temporal.server.api.schedule.v1.FullUpdateRequest.search_attributes:type_name -> temporal.api.common.v1.SearchAttributes
	17, // 16: temporal.server.api.schedule.v1.DescribeResponse.schedule:type_name -> temporal.api.schedule.v1.Schedule
	18, // 17: temporal.server.api.schedule.v1.DescribeResponse.info:type_name -> temporal.api.schedule.v1.ScheduleInfo
	21, // 18: temporal.server.api.schedule.v1.WatchWorkflowRequest.execution:type_name -> temporal.api.common.v1.WorkflowExecution
	22, // 19: temporal.server.api.schedule.v1.WatchWorkflowResponse.status:type_name -> temporal.api.enums.v1.WorkflowExecutionStatus
	15, // 20: temporal.server.api.schedule.v1.WatchWorkflowResponse.result:type_name -> temporal.api.common.v1.Payloads
	16, // 21: temporal.server.api.schedule.v1.WatchWorkflowResponse.failure:type_name -> temporal.api.failure.v1.Failure
	12, // 22: temporal.server.api.schedule.v1.WatchWorkflowResponse.close_time:type_name -> google.protobuf.Timestamp
	23, // 23: temporal.server.api.schedule.v1.StartWorkflowRequest.request:type_name -> temporal.api.workflowservice.v1.StartWorkflowExecutionRequest
	12, // 24: temporal.server.api.schedule.v1.StartWorkflowResponse.real_start_time:type_name -> google.protobuf.Timestamp
	21, // 25: temporal.server.api.schedule.v1.CancelWorkflowRequest.execution:type_name -> temporal.api.common.v1.WorkflowExecution
	21, // 26: temporal.server.api.schedule.v1.TerminateWorkflowRequest.execution:type_name -> temporal.api.common.v1.WorkflowExecution
	12, // 27: temporal.server.api.schedule.v1.NextTimeCache.start_time:type_name -> google.protobuf.Timestamp
	28, // [28:28] is the sub-list for method output_type
	28, // [28:28] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_temporal_server_api_schedule_v1_message_proto_init() }
func file_temporal_server_api_schedule_v1_message_proto_init() {
	if File_temporal_server_api_schedule_v1_message_proto != nil {
		return
	}
	file_temporal_server_api_schedule_v1_message_proto_msgTypes[6].OneofWrappers = []any{
		(*WatchWorkflowResponse_Result)(nil),
		(*WatchWorkflowResponse_Failure)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_temporal_server_api_schedule_v1_message_proto_rawDesc), len(file_temporal_server_api_schedule_v1_message_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_temporal_server_api_schedule_v1_message_proto_goTypes,
		DependencyIndexes: file_temporal_server_api_schedule_v1_message_proto_depIdxs,
		MessageInfos:      file_temporal_server_api_schedule_v1_message_proto_msgTypes,
	}.Build()
	File_temporal_server_api_schedule_v1_message_proto = out.File
	file_temporal_server_api_schedule_v1_message_proto_goTypes = nil
	file_temporal_server_api_schedule_v1_message_proto_depIdxs = nil
}
