// Code generated by protoc-gen-go. DO NOT EDIT.
// plugins:
// 	protoc-gen-go
// 	protoc
// source: temporal/server/chasm/lib/callback/proto/v1/message.proto

package callbackspb

import (
	reflect "reflect"
	"strconv"
	sync "sync"
	unsafe "unsafe"

	v11 "go.temporal.io/api/common/v1"
	v1 "go.temporal.io/api/failure/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Status of a callback.
type CallbackStatus int32

const (
	// Default value, unspecified state.
	CALLBACK_STATUS_UNSPECIFIED CallbackStatus = 0
	// Callback is standing by, waiting to be triggered.
	CALLBACK_STATUS_STANDBY CallbackStatus = 1
	// Callback is in the queue waiting to be executed or is currently executing.
	CALLBACK_STATUS_SCHEDULED CallbackStatus = 2
	// Callback has failed with a retryable error and is backing off before the next attempt.
	CALLBACK_STATUS_BACKING_OFF CallbackStatus = 3
	// Callback has failed.
	CALLBACK_STATUS_FAILED CallbackStatus = 4
	// Callback has succeeded.
	CALLBACK_STATUS_SUCCEEDED CallbackStatus = 5
)

// Enum value maps for CallbackStatus.
var (
	CallbackStatus_name = map[int32]string{
		0: "CALLBACK_STATUS_UNSPECIFIED",
		1: "CALLBACK_STATUS_STANDBY",
		2: "CALLBACK_STATUS_SCHEDULED",
		3: "CALLBACK_STATUS_BACKING_OFF",
		4: "CALLBACK_STATUS_FAILED",
		5: "CALLBACK_STATUS_SUCCEEDED",
	}
	CallbackStatus_value = map[string]int32{
		"CALLBACK_STATUS_UNSPECIFIED": 0,
		"CALLBACK_STATUS_STANDBY":     1,
		"CALLBACK_STATUS_SCHEDULED":   2,
		"CALLBACK_STATUS_BACKING_OFF": 3,
		"CALLBACK_STATUS_FAILED":      4,
		"CALLBACK_STATUS_SUCCEEDED":   5,
	}
)

func (x CallbackStatus) Enum() *CallbackStatus {
	p := new(CallbackStatus)
	*p = x
	return p
}

func (x CallbackStatus) String() string {
	switch x {
	case CALLBACK_STATUS_UNSPECIFIED:
		return "Unspecified"
	case CALLBACK_STATUS_STANDBY:
		return "Standby"
	case CALLBACK_STATUS_SCHEDULED:
		return "Scheduled"
	case CALLBACK_STATUS_BACKING_OFF:
		return "BackingOff"
	case CALLBACK_STATUS_FAILED:
		return "Failed"
	case CALLBACK_STATUS_SUCCEEDED:
		return "Succeeded"
	default:
		return strconv.Itoa(int(x))
	}

}

func (CallbackStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_temporal_server_chasm_lib_callback_proto_v1_message_proto_enumTypes[0].Descriptor()
}

func (CallbackStatus) Type() protoreflect.EnumType {
	return &file_temporal_server_chasm_lib_callback_proto_v1_message_proto_enumTypes[0]
}

func (x CallbackStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CallbackStatus.Descriptor instead.
func (CallbackStatus) EnumDescriptor() ([]byte, []int) {
	return file_temporal_server_chasm_lib_callback_proto_v1_message_proto_rawDescGZIP(), []int{0}
}

type CallbackState struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Information on how this callback should be invoked (e.g. its URL and type).
	Callback *Callback `protobuf:"bytes,1,opt,name=callback,proto3" json:"callback,omitempty"`
	// The time when the callback was registered.
	RegistrationTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=registration_time,json=registrationTime,proto3" json:"registration_time,omitempty"`
	Status           CallbackStatus         `protobuf:"varint,4,opt,name=status,proto3,enum=temporal.server.chasm.lib.callbacks.proto.v1.CallbackStatus" json:"status,omitempty"`
	// The number of attempts made to deliver the callback.
	// This number represents a minimum bound since the attempt is incremented after the callback request completes.
	Attempt int32 `protobuf:"varint,5,opt,name=attempt,proto3" json:"attempt,omitempty"`
	// The time when the last attempt completed.
	LastAttemptCompleteTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=last_attempt_complete_time,json=lastAttemptCompleteTime,proto3" json:"last_attempt_complete_time,omitempty"`
	// The last attempt's failure, if any.
	LastAttemptFailure *v1.Failure `protobuf:"bytes,7,opt,name=last_attempt_failure,json=lastAttemptFailure,proto3" json:"last_attempt_failure,omitempty"`
	// The time when the next attempt is scheduled.
	// NOTE (seankane): this field might go away in the future, discussion:
	// https://github.com/temporalio/temporal/pull/8473#discussion_r2427348436
	NextAttemptScheduleTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=next_attempt_schedule_time,json=nextAttemptScheduleTime,proto3" json:"next_attempt_schedule_time,omitempty"`
	// Request ID that added the callback.
	RequestId     string `protobuf:"bytes,9,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CallbackState) Reset() {
	*x = CallbackState{}
	mi := &file_temporal_server_chasm_lib_callback_proto_v1_message_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CallbackState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallbackState) ProtoMessage() {}

func (x *CallbackState) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_chasm_lib_callback_proto_v1_message_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallbackState.ProtoReflect.Descriptor instead.
func (*CallbackState) Descriptor() ([]byte, []int) {
	return file_temporal_server_chasm_lib_callback_proto_v1_message_proto_rawDescGZIP(), []int{0}
}

func (x *CallbackState) GetCallback() *Callback {
	if x != nil {
		return x.Callback
	}
	return nil
}

func (x *CallbackState) GetRegistrationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RegistrationTime
	}
	return nil
}

func (x *CallbackState) GetStatus() CallbackStatus {
	if x != nil {
		return x.Status
	}
	return CALLBACK_STATUS_UNSPECIFIED
}

func (x *CallbackState) GetAttempt() int32 {
	if x != nil {
		return x.Attempt
	}
	return 0
}

func (x *CallbackState) GetLastAttemptCompleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastAttemptCompleteTime
	}
	return nil
}

func (x *CallbackState) GetLastAttemptFailure() *v1.Failure {
	if x != nil {
		return x.LastAttemptFailure
	}
	return nil
}

func (x *CallbackState) GetNextAttemptScheduleTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NextAttemptScheduleTime
	}
	return nil
}

func (x *CallbackState) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

type Callback struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Variant:
	//
	//	*Callback_Nexus_
	Variant       isCallback_Variant `protobuf_oneof:"variant"`
	Links         []*v11.Link        `protobuf:"bytes,100,rep,name=links,proto3" json:"links,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Callback) Reset() {
	*x = Callback{}
	mi := &file_temporal_server_chasm_lib_callback_proto_v1_message_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Callback) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Callback) ProtoMessage() {}

func (x *Callback) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_chasm_lib_callback_proto_v1_message_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Callback.ProtoReflect.Descriptor instead.
func (*Callback) Descriptor() ([]byte, []int) {
	return file_temporal_server_chasm_lib_callback_proto_v1_message_proto_rawDescGZIP(), []int{1}
}

func (x *Callback) GetVariant() isCallback_Variant {
	if x != nil {
		return x.Variant
	}
	return nil
}

func (x *Callback) GetNexus() *Callback_Nexus {
	if x != nil {
		if x, ok := x.Variant.(*Callback_Nexus_); ok {
			return x.Nexus
		}
	}
	return nil
}

func (x *Callback) GetLinks() []*v11.Link {
	if x != nil {
		return x.Links
	}
	return nil
}

type isCallback_Variant interface {
	isCallback_Variant()
}

type Callback_Nexus_ struct {
	Nexus *Callback_Nexus `protobuf:"bytes,2,opt,name=nexus,proto3,oneof"`
}

func (*Callback_Nexus_) isCallback_Variant() {}

// Trigger for when the workflow is closed.
type CallbackState_WorkflowClosed struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CallbackState_WorkflowClosed) Reset() {
	*x = CallbackState_WorkflowClosed{}
	mi := &file_temporal_server_chasm_lib_callback_proto_v1_message_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CallbackState_WorkflowClosed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallbackState_WorkflowClosed) ProtoMessage() {}

func (x *CallbackState_WorkflowClosed) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_chasm_lib_callback_proto_v1_message_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallbackState_WorkflowClosed.ProtoReflect.Descriptor instead.
func (*CallbackState_WorkflowClosed) Descriptor() ([]byte, []int) {
	return file_temporal_server_chasm_lib_callback_proto_v1_message_proto_rawDescGZIP(), []int{0, 0}
}

type Callback_Nexus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Callback URL.
	// (-- api-linter: core::0140::uri=disabled
	//
	//	aip.dev/not-precedent: Not respecting aip here. --)
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// Header to attach to callback request.
	Header        map[string]string `protobuf:"bytes,2,rep,name=header,proto3" json:"header,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Callback_Nexus) Reset() {
	*x = Callback_Nexus{}
	mi := &file_temporal_server_chasm_lib_callback_proto_v1_message_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Callback_Nexus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Callback_Nexus) ProtoMessage() {}

func (x *Callback_Nexus) ProtoReflect() protoreflect.Message {
	mi := &file_temporal_server_chasm_lib_callback_proto_v1_message_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Callback_Nexus.ProtoReflect.Descriptor instead.
func (*Callback_Nexus) Descriptor() ([]byte, []int) {
	return file_temporal_server_chasm_lib_callback_proto_v1_message_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Callback_Nexus) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *Callback_Nexus) GetHeader() map[string]string {
	if x != nil {
		return x.Header
	}
	return nil
}

var File_temporal_server_chasm_lib_callback_proto_v1_message_proto protoreflect.FileDescriptor

const file_temporal_server_chasm_lib_callback_proto_v1_message_proto_rawDesc = "" +
	"\n" +
	"9temporal/server/chasm/lib/callback/proto/v1/message.proto\x12,temporal.server.chasm.lib.callbacks.proto.v1\x1a\x1fgoogle/protobuf/timestamp.proto\x1a$temporal/api/common/v1/message.proto\x1a%temporal/api/failure/v1/message.proto\"\xd3\x04\n" +
	"\rCallbackState\x12R\n" +
	"\bcallback\x18\x01 \x01(\v26.temporal.server.chasm.lib.callbacks.proto.v1.CallbackR\bcallback\x12G\n" +
	"\x11registration_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\x10registrationTime\x12T\n" +
	"\x06status\x18\x04 \x01(\x0e2<.temporal.server.chasm.lib.callbacks.proto.v1.CallbackStatusR\x06status\x12\x18\n" +
	"\aattempt\x18\x05 \x01(\x05R\aattempt\x12W\n" +
	"\x1alast_attempt_complete_time\x18\x06 \x01(\v2\x1a.google.protobuf.TimestampR\x17lastAttemptCompleteTime\x12R\n" +
	"\x14last_attempt_failure\x18\a \x01(\v2 .temporal.api.failure.v1.FailureR\x12lastAttemptFailure\x12W\n" +
	"\x1anext_attempt_schedule_time\x18\b \x01(\v2\x1a.google.protobuf.TimestampR\x17nextAttemptScheduleTime\x12\x1d\n" +
	"\n" +
	"request_id\x18\t \x01(\tR\trequestId\x1a\x10\n" +
	"\x0eWorkflowClosed\"\xde\x02\n" +
	"\bCallback\x12T\n" +
	"\x05nexus\x18\x02 \x01(\v2<.temporal.server.chasm.lib.callbacks.proto.v1.Callback.NexusH\x00R\x05nexus\x122\n" +
	"\x05links\x18d \x03(\v2\x1c.temporal.api.common.v1.LinkR\x05links\x1a\xb6\x01\n" +
	"\x05Nexus\x12\x10\n" +
	"\x03url\x18\x01 \x01(\tR\x03url\x12`\n" +
	"\x06header\x18\x02 \x03(\v2H.temporal.server.chasm.lib.callbacks.proto.v1.Callback.Nexus.HeaderEntryR\x06header\x1a9\n" +
	"\vHeaderEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01B\t\n" +
	"\avariantJ\x04\b\x01\x10\x02*\xc9\x01\n" +
	"\x0eCallbackStatus\x12\x1f\n" +
	"\x1bCALLBACK_STATUS_UNSPECIFIED\x10\x00\x12\x1b\n" +
	"\x17CALLBACK_STATUS_STANDBY\x10\x01\x12\x1d\n" +
	"\x19CALLBACK_STATUS_SCHEDULED\x10\x02\x12\x1f\n" +
	"\x1bCALLBACK_STATUS_BACKING_OFF\x10\x03\x12\x1a\n" +
	"\x16CALLBACK_STATUS_FAILED\x10\x04\x12\x1d\n" +
	"\x19CALLBACK_STATUS_SUCCEEDED\x10\x05BGZEgo.temporal.io/server/chasm/lib/callbacks/gen/callbackspb;callbackspbb\x06proto3"

var (
	file_temporal_server_chasm_lib_callback_proto_v1_message_proto_rawDescOnce sync.Once
	file_temporal_server_chasm_lib_callback_proto_v1_message_proto_rawDescData []byte
)

func file_temporal_server_chasm_lib_callback_proto_v1_message_proto_rawDescGZIP() []byte {
	file_temporal_server_chasm_lib_callback_proto_v1_message_proto_rawDescOnce.Do(func() {
		file_temporal_server_chasm_lib_callback_proto_v1_message_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_temporal_server_chasm_lib_callback_proto_v1_message_proto_rawDesc), len(file_temporal_server_chasm_lib_callback_proto_v1_message_proto_rawDesc)))
	})
	return file_temporal_server_chasm_lib_callback_proto_v1_message_proto_rawDescData
}

var file_temporal_server_chasm_lib_callback_proto_v1_message_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_temporal_server_chasm_lib_callback_proto_v1_message_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_temporal_server_chasm_lib_callback_proto_v1_message_proto_goTypes = []any{
	(CallbackStatus)(0),                  // 0: temporal.server.chasm.lib.callbacks.proto.v1.CallbackStatus
	(*CallbackState)(nil),                // 1: temporal.server.chasm.lib.callbacks.proto.v1.CallbackState
	(*Callback)(nil),                     // 2: temporal.server.chasm.lib.callbacks.proto.v1.Callback
	(*CallbackState_WorkflowClosed)(nil), // 3: temporal.server.chasm.lib.callbacks.proto.v1.CallbackState.WorkflowClosed
	(*Callback_Nexus)(nil),               // 4: temporal.server.chasm.lib.callbacks.proto.v1.Callback.Nexus
	nil,                                  // 5: temporal.server.chasm.lib.callbacks.proto.v1.Callback.Nexus.HeaderEntry
	(*timestamppb.Timestamp)(nil),        // 6: google.protobuf.Timestamp
	(*v1.Failure)(nil),                   // 7: temporal.api.failure.v1.Failure
	(*v11.Link)(nil),                     // 8: temporal.api.common.v1.Link
}
var file_temporal_server_chasm_lib_callback_proto_v1_message_proto_depIdxs = []int32{
	2, // 0: temporal.server.chasm.lib.callbacks.proto.v1.CallbackState.callback:type_name -> temporal.server.chasm.lib.callbacks.proto.v1.Callback
	6, // 1: temporal.server.chasm.lib.callbacks.proto.v1.CallbackState.registration_time:type_name -> google.protobuf.Timestamp
	0, // 2: temporal.server.chasm.lib.callbacks.proto.v1.CallbackState.status:type_name -> temporal.server.chasm.lib.callbacks.proto.v1.CallbackStatus
	6, // 3: temporal.server.chasm.lib.callbacks.proto.v1.CallbackState.last_attempt_complete_time:type_name -> google.protobuf.Timestamp
	7, // 4: temporal.server.chasm.lib.callbacks.proto.v1.CallbackState.last_attempt_failure:type_name -> temporal.api.failure.v1.Failure
	6, // 5: temporal.server.chasm.lib.callbacks.proto.v1.CallbackState.next_attempt_schedule_time:type_name -> google.protobuf.Timestamp
	4, // 6: temporal.server.chasm.lib.callbacks.proto.v1.Callback.nexus:type_name -> temporal.server.chasm.lib.callbacks.proto.v1.Callback.Nexus
	8, // 7: temporal.server.chasm.lib.callbacks.proto.v1.Callback.links:type_name -> temporal.api.common.v1.Link
	5, // 8: temporal.server.chasm.lib.callbacks.proto.v1.Callback.Nexus.header:type_name -> temporal.server.chasm.lib.callbacks.proto.v1.Callback.Nexus.HeaderEntry
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_temporal_server_chasm_lib_callback_proto_v1_message_proto_init() }
func file_temporal_server_chasm_lib_callback_proto_v1_message_proto_init() {
	if File_temporal_server_chasm_lib_callback_proto_v1_message_proto != nil {
		return
	}
	file_temporal_server_chasm_lib_callback_proto_v1_message_proto_msgTypes[1].OneofWrappers = []any{
		(*Callback_Nexus_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_temporal_server_chasm_lib_callback_proto_v1_message_proto_rawDesc), len(file_temporal_server_chasm_lib_callback_proto_v1_message_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_temporal_server_chasm_lib_callback_proto_v1_message_proto_goTypes,
		DependencyIndexes: file_temporal_server_chasm_lib_callback_proto_v1_message_proto_depIdxs,
		EnumInfos:         file_temporal_server_chasm_lib_callback_proto_v1_message_proto_enumTypes,
		MessageInfos:      file_temporal_server_chasm_lib_callback_proto_v1_message_proto_msgTypes,
	}.Build()
	File_temporal_server_chasm_lib_callback_proto_v1_message_proto = out.File
	file_temporal_server_chasm_lib_callback_proto_v1_message_proto_goTypes = nil
	file_temporal_server_chasm_lib_callback_proto_v1_message_proto_depIdxs = nil
}
