// Code generated by cmd/tools/genrpcwrappers. DO NOT EDIT.

package matching

import (
	"context"
	"fmt"
	"math/rand"

	enumspb "go.temporal.io/api/enums/v1"
	"go.temporal.io/server/api/matchingservice/v1"
	"go.temporal.io/server/common/tqid"
	"google.golang.org/grpc"
)

func (c *clientImpl) ApplyTaskQueueUserDataReplicationEvent(
	ctx context.Context,
	request *matchingservice.ApplyTaskQueueUserDataReplicationEventRequest,
	opts ...grpc.CallOption,
) (*matchingservice.ApplyTaskQueueUserDataReplicationEventResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName(request.GetTaskQueue(), request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_WORKFLOW)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.ApplyTaskQueueUserDataReplicationEvent(ctx, request, opts...)
}

func (c *clientImpl) CancelOutstandingPoll(
	ctx context.Context,
	request *matchingservice.CancelOutstandingPollRequest,
	opts ...grpc.CallOption,
) (*matchingservice.CancelOutstandingPollResponse, error) {

	p, err := tqid.PartitionFromProto(request.GetTaskQueue(), request.GetNamespaceId(), request.GetTaskQueueType())
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.CancelOutstandingPoll(ctx, request, opts...)
}

func (c *clientImpl) CheckTaskQueueUserDataPropagation(
	ctx context.Context,
	request *matchingservice.CheckTaskQueueUserDataPropagationRequest,
	opts ...grpc.CallOption,
) (*matchingservice.CheckTaskQueueUserDataPropagationResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName(request.GetTaskQueue(), request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_WORKFLOW)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.CheckTaskQueueUserDataPropagation(ctx, request, opts...)
}

func (c *clientImpl) CreateNexusEndpoint(
	ctx context.Context,
	request *matchingservice.CreateNexusEndpointRequest,
	opts ...grpc.CallOption,
) (*matchingservice.CreateNexusEndpointResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName("not-applicable", "not-applicable", enumspb.TASK_QUEUE_TYPE_UNSPECIFIED)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.CreateNexusEndpoint(ctx, request, opts...)
}

func (c *clientImpl) DeleteNexusEndpoint(
	ctx context.Context,
	request *matchingservice.DeleteNexusEndpointRequest,
	opts ...grpc.CallOption,
) (*matchingservice.DeleteNexusEndpointResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName("not-applicable", "not-applicable", enumspb.TASK_QUEUE_TYPE_UNSPECIFIED)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.DeleteNexusEndpoint(ctx, request, opts...)
}

func (c *clientImpl) DescribeTaskQueue(
	ctx context.Context,
	request *matchingservice.DescribeTaskQueueRequest,
	opts ...grpc.CallOption,
) (*matchingservice.DescribeTaskQueueResponse, error) {

	p, err := tqid.PartitionFromProto(request.GetDescRequest().GetTaskQueue(), request.GetNamespaceId(), request.GetDescRequest().GetTaskQueueType())
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.DescribeTaskQueue(ctx, request, opts...)
}

func (c *clientImpl) DescribeTaskQueuePartition(
	ctx context.Context,
	request *matchingservice.DescribeTaskQueuePartitionRequest,
	opts ...grpc.CallOption,
) (*matchingservice.DescribeTaskQueuePartitionResponse, error) {

	p := tqid.PartitionFromPartitionProto(request.GetTaskQueuePartition(), request.GetNamespaceId())

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.DescribeTaskQueuePartition(ctx, request, opts...)
}

func (c *clientImpl) DescribeVersionedTaskQueues(
	ctx context.Context,
	request *matchingservice.DescribeVersionedTaskQueuesRequest,
	opts ...grpc.CallOption,
) (*matchingservice.DescribeVersionedTaskQueuesResponse, error) {

	p, err := tqid.PartitionFromProto(request.GetTaskQueue(), request.GetNamespaceId(), request.GetTaskQueueType())
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.DescribeVersionedTaskQueues(ctx, request, opts...)
}

func (c *clientImpl) DescribeWorker(
	ctx context.Context,
	request *matchingservice.DescribeWorkerRequest,
	opts ...grpc.CallOption,
) (*matchingservice.DescribeWorkerResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName("not-applicable", request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_UNSPECIFIED)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.DescribeWorker(ctx, request, opts...)
}

func (c *clientImpl) DispatchNexusTask(
	ctx context.Context,
	request *matchingservice.DispatchNexusTaskRequest,
	opts ...grpc.CallOption,
) (*matchingservice.DispatchNexusTaskResponse, error) {

	p, err := tqid.PartitionFromProto(request.GetTaskQueue(), request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_NEXUS)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.DispatchNexusTask(ctx, request, opts...)
}

func (c *clientImpl) ForceLoadTaskQueuePartition(
	ctx context.Context,
	request *matchingservice.ForceLoadTaskQueuePartitionRequest,
	opts ...grpc.CallOption,
) (*matchingservice.ForceLoadTaskQueuePartitionResponse, error) {

	p := tqid.PartitionFromPartitionProto(request.GetTaskQueuePartition(), request.GetNamespaceId())

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.ForceLoadTaskQueuePartition(ctx, request, opts...)
}

func (c *clientImpl) ForceUnloadTaskQueue(
	ctx context.Context,
	request *matchingservice.ForceUnloadTaskQueueRequest,
	opts ...grpc.CallOption,
) (*matchingservice.ForceUnloadTaskQueueResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName(request.GetTaskQueue(), request.GetNamespaceId(), request.GetTaskQueueType())
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.ForceUnloadTaskQueue(ctx, request, opts...)
}

func (c *clientImpl) ForceUnloadTaskQueuePartition(
	ctx context.Context,
	request *matchingservice.ForceUnloadTaskQueuePartitionRequest,
	opts ...grpc.CallOption,
) (*matchingservice.ForceUnloadTaskQueuePartitionResponse, error) {

	p := tqid.PartitionFromPartitionProto(request.GetTaskQueuePartition(), request.GetNamespaceId())

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.ForceUnloadTaskQueuePartition(ctx, request, opts...)
}

func (c *clientImpl) GetBuildIdTaskQueueMapping(
	ctx context.Context,
	request *matchingservice.GetBuildIdTaskQueueMappingRequest,
	opts ...grpc.CallOption,
) (*matchingservice.GetBuildIdTaskQueueMappingResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName(fmt.Sprintf("not-applicable-%d", rand.Int()), request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_UNSPECIFIED)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.GetBuildIdTaskQueueMapping(ctx, request, opts...)
}

func (c *clientImpl) GetTaskQueueUserData(
	ctx context.Context,
	request *matchingservice.GetTaskQueueUserDataRequest,
	opts ...grpc.CallOption,
) (*matchingservice.GetTaskQueueUserDataResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName(request.GetTaskQueue(), request.GetNamespaceId(), request.GetTaskQueueType())
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createLongPollContext(ctx)
	defer cancel()
	return client.GetTaskQueueUserData(ctx, request, opts...)
}

func (c *clientImpl) GetWorkerBuildIdCompatibility(
	ctx context.Context,
	request *matchingservice.GetWorkerBuildIdCompatibilityRequest,
	opts ...grpc.CallOption,
) (*matchingservice.GetWorkerBuildIdCompatibilityResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName(request.GetRequest().GetTaskQueue(), request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_WORKFLOW)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.GetWorkerBuildIdCompatibility(ctx, request, opts...)
}

func (c *clientImpl) GetWorkerVersioningRules(
	ctx context.Context,
	request *matchingservice.GetWorkerVersioningRulesRequest,
	opts ...grpc.CallOption,
) (*matchingservice.GetWorkerVersioningRulesResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName(request.GetTaskQueue(), request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_WORKFLOW)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.GetWorkerVersioningRules(ctx, request, opts...)
}

func (c *clientImpl) ListNexusEndpoints(
	ctx context.Context,
	request *matchingservice.ListNexusEndpointsRequest,
	opts ...grpc.CallOption,
) (*matchingservice.ListNexusEndpointsResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName("not-applicable", "not-applicable", enumspb.TASK_QUEUE_TYPE_UNSPECIFIED)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createLongPollContext(ctx)
	defer cancel()
	return client.ListNexusEndpoints(ctx, request, opts...)
}

func (c *clientImpl) ListTaskQueuePartitions(
	ctx context.Context,
	request *matchingservice.ListTaskQueuePartitionsRequest,
	opts ...grpc.CallOption,
) (*matchingservice.ListTaskQueuePartitionsResponse, error) {

	p, err := tqid.PartitionFromProto(request.GetTaskQueue(), request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_WORKFLOW)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.ListTaskQueuePartitions(ctx, request, opts...)
}

func (c *clientImpl) ListWorkers(
	ctx context.Context,
	request *matchingservice.ListWorkersRequest,
	opts ...grpc.CallOption,
) (*matchingservice.ListWorkersResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName("not-applicable", request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_UNSPECIFIED)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.ListWorkers(ctx, request, opts...)
}

func (c *clientImpl) PollNexusTaskQueue(
	ctx context.Context,
	request *matchingservice.PollNexusTaskQueueRequest,
	opts ...grpc.CallOption,
) (*matchingservice.PollNexusTaskQueueResponse, error) {

	p, err := tqid.PartitionFromProto(request.GetRequest().GetTaskQueue(), request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_NEXUS)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.PollNexusTaskQueue(ctx, request, opts...)
}

func (c *clientImpl) RecordWorkerHeartbeat(
	ctx context.Context,
	request *matchingservice.RecordWorkerHeartbeatRequest,
	opts ...grpc.CallOption,
) (*matchingservice.RecordWorkerHeartbeatResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName("not-applicable", request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_UNSPECIFIED)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.RecordWorkerHeartbeat(ctx, request, opts...)
}

func (c *clientImpl) ReplicateTaskQueueUserData(
	ctx context.Context,
	request *matchingservice.ReplicateTaskQueueUserDataRequest,
	opts ...grpc.CallOption,
) (*matchingservice.ReplicateTaskQueueUserDataResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName("not-applicable", request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_UNSPECIFIED)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.ReplicateTaskQueueUserData(ctx, request, opts...)
}

func (c *clientImpl) RespondNexusTaskCompleted(
	ctx context.Context,
	request *matchingservice.RespondNexusTaskCompletedRequest,
	opts ...grpc.CallOption,
) (*matchingservice.RespondNexusTaskCompletedResponse, error) {

	p, err := tqid.PartitionFromProto(request.GetTaskQueue(), request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_NEXUS)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.RespondNexusTaskCompleted(ctx, request, opts...)
}

func (c *clientImpl) RespondNexusTaskFailed(
	ctx context.Context,
	request *matchingservice.RespondNexusTaskFailedRequest,
	opts ...grpc.CallOption,
) (*matchingservice.RespondNexusTaskFailedResponse, error) {

	p, err := tqid.PartitionFromProto(request.GetTaskQueue(), request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_NEXUS)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.RespondNexusTaskFailed(ctx, request, opts...)
}

func (c *clientImpl) RespondQueryTaskCompleted(
	ctx context.Context,
	request *matchingservice.RespondQueryTaskCompletedRequest,
	opts ...grpc.CallOption,
) (*matchingservice.RespondQueryTaskCompletedResponse, error) {

	p, err := tqid.PartitionFromProto(request.GetTaskQueue(), request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_WORKFLOW)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.RespondQueryTaskCompleted(ctx, request, opts...)
}

func (c *clientImpl) SyncDeploymentUserData(
	ctx context.Context,
	request *matchingservice.SyncDeploymentUserDataRequest,
	opts ...grpc.CallOption,
) (*matchingservice.SyncDeploymentUserDataResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName(request.GetTaskQueue(), request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_WORKFLOW)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.SyncDeploymentUserData(ctx, request, opts...)
}

func (c *clientImpl) UpdateNexusEndpoint(
	ctx context.Context,
	request *matchingservice.UpdateNexusEndpointRequest,
	opts ...grpc.CallOption,
) (*matchingservice.UpdateNexusEndpointResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName("not-applicable", "not-applicable", enumspb.TASK_QUEUE_TYPE_UNSPECIFIED)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.UpdateNexusEndpoint(ctx, request, opts...)
}

func (c *clientImpl) UpdateTaskQueueConfig(
	ctx context.Context,
	request *matchingservice.UpdateTaskQueueConfigRequest,
	opts ...grpc.CallOption,
) (*matchingservice.UpdateTaskQueueConfigResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName(request.GetUpdateTaskqueueConfig().GetTaskQueue(), request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_WORKFLOW)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.UpdateTaskQueueConfig(ctx, request, opts...)
}

func (c *clientImpl) UpdateTaskQueueUserData(
	ctx context.Context,
	request *matchingservice.UpdateTaskQueueUserDataRequest,
	opts ...grpc.CallOption,
) (*matchingservice.UpdateTaskQueueUserDataResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName("not-applicable", request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_UNSPECIFIED)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.UpdateTaskQueueUserData(ctx, request, opts...)
}

func (c *clientImpl) UpdateWorkerBuildIdCompatibility(
	ctx context.Context,
	request *matchingservice.UpdateWorkerBuildIdCompatibilityRequest,
	opts ...grpc.CallOption,
) (*matchingservice.UpdateWorkerBuildIdCompatibilityResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName(request.GetTaskQueue(), request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_WORKFLOW)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.UpdateWorkerBuildIdCompatibility(ctx, request, opts...)
}

func (c *clientImpl) UpdateWorkerVersioningRules(
	ctx context.Context,
	request *matchingservice.UpdateWorkerVersioningRulesRequest,
	opts ...grpc.CallOption,
) (*matchingservice.UpdateWorkerVersioningRulesResponse, error) {

	p, err := tqid.NormalPartitionFromRpcName(request.GetTaskQueue(), request.GetNamespaceId(), enumspb.TASK_QUEUE_TYPE_WORKFLOW)
	if err != nil {
		return nil, err
	}

	client, err := c.getClientForTaskQueuePartition(p)
	if err != nil {
		return nil, err
	}
	ctx, cancel := c.createContext(ctx)
	defer cancel()
	return client.UpdateWorkerVersioningRules(ctx, request, opts...)
}
