// Code generated by gowrap. DO NOT EDIT.
// template: gowrap_template
// gowrap: http://github.com/hexdigest/gowrap

package telemetry

//go:generate gowrap gen -p go.temporal.io/server/common/persistence -i ExecutionStore -t gowrap_template -o execution_store_gen.go -l ""

import (
	"context"
	"encoding/json"
	"time"

	"go.opentelemetry.io/otel/attribute"
	"go.opentelemetry.io/otel/trace"
	"go.temporal.io/server/common/log"
	"go.temporal.io/server/common/log/tag"
	_sourcePersistence "go.temporal.io/server/common/persistence"
	"go.temporal.io/server/common/telemetry"
)

// telemetryExecutionStore implements ExecutionStore interface instrumented with OpenTelemetry.
type telemetryExecutionStore struct {
	_sourcePersistence.ExecutionStore
	tracer    trace.Tracer
	logger    log.Logger
	debugMode bool
}

// newTelemetryExecutionStore returns telemetryExecutionStore.
func newTelemetryExecutionStore(
	base _sourcePersistence.ExecutionStore,
	logger log.Logger,
	tracer trace.Tracer,
) telemetryExecutionStore {
	return telemetryExecutionStore{
		ExecutionStore: base,
		tracer:         tracer,
		debugMode:      telemetry.DebugMode(),
	}
}

// AddHistoryTasks wraps ExecutionStore.AddHistoryTasks.
func (d telemetryExecutionStore) AddHistoryTasks(ctx context.Context, request *_sourcePersistence.InternalAddHistoryTasksRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/AddHistoryTasks",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("AddHistoryTasks"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.ExecutionStore.AddHistoryTasks(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalAddHistoryTasksRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// AppendHistoryNodes wraps ExecutionStore.AppendHistoryNodes.
func (d telemetryExecutionStore) AppendHistoryNodes(ctx context.Context, request *_sourcePersistence.InternalAppendHistoryNodesRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/AppendHistoryNodes",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("AppendHistoryNodes"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.ExecutionStore.AppendHistoryNodes(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalAppendHistoryNodesRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// CompleteHistoryTask wraps ExecutionStore.CompleteHistoryTask.
func (d telemetryExecutionStore) CompleteHistoryTask(ctx context.Context, request *_sourcePersistence.CompleteHistoryTaskRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/CompleteHistoryTask",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("CompleteHistoryTask"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.ExecutionStore.CompleteHistoryTask(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.CompleteHistoryTaskRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// ConflictResolveWorkflowExecution wraps ExecutionStore.ConflictResolveWorkflowExecution.
func (d telemetryExecutionStore) ConflictResolveWorkflowExecution(ctx context.Context, request *_sourcePersistence.InternalConflictResolveWorkflowExecutionRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/ConflictResolveWorkflowExecution",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("ConflictResolveWorkflowExecution"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.ExecutionStore.ConflictResolveWorkflowExecution(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalConflictResolveWorkflowExecutionRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// CreateWorkflowExecution wraps ExecutionStore.CreateWorkflowExecution.
func (d telemetryExecutionStore) CreateWorkflowExecution(ctx context.Context, request *_sourcePersistence.InternalCreateWorkflowExecutionRequest) (ip1 *_sourcePersistence.InternalCreateWorkflowExecutionResponse, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/CreateWorkflowExecution",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("CreateWorkflowExecution"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	ip1, err = d.ExecutionStore.CreateWorkflowExecution(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalCreateWorkflowExecutionRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(ip1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalCreateWorkflowExecutionResponse for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// DeleteCurrentWorkflowExecution wraps ExecutionStore.DeleteCurrentWorkflowExecution.
func (d telemetryExecutionStore) DeleteCurrentWorkflowExecution(ctx context.Context, request *_sourcePersistence.DeleteCurrentWorkflowExecutionRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/DeleteCurrentWorkflowExecution",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("DeleteCurrentWorkflowExecution"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.ExecutionStore.DeleteCurrentWorkflowExecution(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.DeleteCurrentWorkflowExecutionRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// DeleteHistoryBranch wraps ExecutionStore.DeleteHistoryBranch.
func (d telemetryExecutionStore) DeleteHistoryBranch(ctx context.Context, request *_sourcePersistence.InternalDeleteHistoryBranchRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/DeleteHistoryBranch",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("DeleteHistoryBranch"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.ExecutionStore.DeleteHistoryBranch(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalDeleteHistoryBranchRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// DeleteHistoryNodes wraps ExecutionStore.DeleteHistoryNodes.
func (d telemetryExecutionStore) DeleteHistoryNodes(ctx context.Context, request *_sourcePersistence.InternalDeleteHistoryNodesRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/DeleteHistoryNodes",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("DeleteHistoryNodes"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.ExecutionStore.DeleteHistoryNodes(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalDeleteHistoryNodesRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// DeleteReplicationTaskFromDLQ wraps ExecutionStore.DeleteReplicationTaskFromDLQ.
func (d telemetryExecutionStore) DeleteReplicationTaskFromDLQ(ctx context.Context, request *_sourcePersistence.DeleteReplicationTaskFromDLQRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/DeleteReplicationTaskFromDLQ",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("DeleteReplicationTaskFromDLQ"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.ExecutionStore.DeleteReplicationTaskFromDLQ(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.DeleteReplicationTaskFromDLQRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// DeleteWorkflowExecution wraps ExecutionStore.DeleteWorkflowExecution.
func (d telemetryExecutionStore) DeleteWorkflowExecution(ctx context.Context, request *_sourcePersistence.DeleteWorkflowExecutionRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/DeleteWorkflowExecution",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("DeleteWorkflowExecution"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.ExecutionStore.DeleteWorkflowExecution(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.DeleteWorkflowExecutionRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// ForkHistoryBranch wraps ExecutionStore.ForkHistoryBranch.
func (d telemetryExecutionStore) ForkHistoryBranch(ctx context.Context, request *_sourcePersistence.InternalForkHistoryBranchRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/ForkHistoryBranch",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("ForkHistoryBranch"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.ExecutionStore.ForkHistoryBranch(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalForkHistoryBranchRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// GetAllHistoryTreeBranches wraps ExecutionStore.GetAllHistoryTreeBranches.
func (d telemetryExecutionStore) GetAllHistoryTreeBranches(ctx context.Context, request *_sourcePersistence.GetAllHistoryTreeBranchesRequest) (ip1 *_sourcePersistence.InternalGetAllHistoryTreeBranchesResponse, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/GetAllHistoryTreeBranches",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("GetAllHistoryTreeBranches"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	ip1, err = d.ExecutionStore.GetAllHistoryTreeBranches(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.GetAllHistoryTreeBranchesRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(ip1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalGetAllHistoryTreeBranchesResponse for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// GetCurrentExecution wraps ExecutionStore.GetCurrentExecution.
func (d telemetryExecutionStore) GetCurrentExecution(ctx context.Context, request *_sourcePersistence.GetCurrentExecutionRequest) (ip1 *_sourcePersistence.InternalGetCurrentExecutionResponse, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/GetCurrentExecution",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("GetCurrentExecution"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	ip1, err = d.ExecutionStore.GetCurrentExecution(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.GetCurrentExecutionRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(ip1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalGetCurrentExecutionResponse for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// GetHistoryTasks wraps ExecutionStore.GetHistoryTasks.
func (d telemetryExecutionStore) GetHistoryTasks(ctx context.Context, request *_sourcePersistence.GetHistoryTasksRequest) (ip1 *_sourcePersistence.InternalGetHistoryTasksResponse, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/GetHistoryTasks",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("GetHistoryTasks"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	ip1, err = d.ExecutionStore.GetHistoryTasks(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.GetHistoryTasksRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(ip1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalGetHistoryTasksResponse for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// GetHistoryTreeContainingBranch wraps ExecutionStore.GetHistoryTreeContainingBranch.
func (d telemetryExecutionStore) GetHistoryTreeContainingBranch(ctx context.Context, request *_sourcePersistence.InternalGetHistoryTreeContainingBranchRequest) (ip1 *_sourcePersistence.InternalGetHistoryTreeContainingBranchResponse, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/GetHistoryTreeContainingBranch",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("GetHistoryTreeContainingBranch"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	ip1, err = d.ExecutionStore.GetHistoryTreeContainingBranch(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalGetHistoryTreeContainingBranchRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(ip1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalGetHistoryTreeContainingBranchResponse for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// GetReplicationTasksFromDLQ wraps ExecutionStore.GetReplicationTasksFromDLQ.
func (d telemetryExecutionStore) GetReplicationTasksFromDLQ(ctx context.Context, request *_sourcePersistence.GetReplicationTasksFromDLQRequest) (ip1 *_sourcePersistence.InternalGetReplicationTasksFromDLQResponse, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/GetReplicationTasksFromDLQ",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("GetReplicationTasksFromDLQ"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	ip1, err = d.ExecutionStore.GetReplicationTasksFromDLQ(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.GetReplicationTasksFromDLQRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(ip1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalGetReplicationTasksFromDLQResponse for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// GetWorkflowExecution wraps ExecutionStore.GetWorkflowExecution.
func (d telemetryExecutionStore) GetWorkflowExecution(ctx context.Context, request *_sourcePersistence.GetWorkflowExecutionRequest) (ip1 *_sourcePersistence.InternalGetWorkflowExecutionResponse, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/GetWorkflowExecution",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("GetWorkflowExecution"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	ip1, err = d.ExecutionStore.GetWorkflowExecution(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.GetWorkflowExecutionRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(ip1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalGetWorkflowExecutionResponse for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// IsReplicationDLQEmpty wraps ExecutionStore.IsReplicationDLQEmpty.
func (d telemetryExecutionStore) IsReplicationDLQEmpty(ctx context.Context, request *_sourcePersistence.GetReplicationTasksFromDLQRequest) (b1 bool, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/IsReplicationDLQEmpty",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("IsReplicationDLQEmpty"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	b1, err = d.ExecutionStore.IsReplicationDLQEmpty(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.GetReplicationTasksFromDLQRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(b1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize bool for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// ListConcreteExecutions wraps ExecutionStore.ListConcreteExecutions.
func (d telemetryExecutionStore) ListConcreteExecutions(ctx context.Context, request *_sourcePersistence.ListConcreteExecutionsRequest) (ip1 *_sourcePersistence.InternalListConcreteExecutionsResponse, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/ListConcreteExecutions",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("ListConcreteExecutions"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	ip1, err = d.ExecutionStore.ListConcreteExecutions(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.ListConcreteExecutionsRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(ip1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalListConcreteExecutionsResponse for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// PutReplicationTaskToDLQ wraps ExecutionStore.PutReplicationTaskToDLQ.
func (d telemetryExecutionStore) PutReplicationTaskToDLQ(ctx context.Context, request *_sourcePersistence.PutReplicationTaskToDLQRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/PutReplicationTaskToDLQ",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("PutReplicationTaskToDLQ"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.ExecutionStore.PutReplicationTaskToDLQ(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.PutReplicationTaskToDLQRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// RangeCompleteHistoryTasks wraps ExecutionStore.RangeCompleteHistoryTasks.
func (d telemetryExecutionStore) RangeCompleteHistoryTasks(ctx context.Context, request *_sourcePersistence.RangeCompleteHistoryTasksRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/RangeCompleteHistoryTasks",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("RangeCompleteHistoryTasks"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.ExecutionStore.RangeCompleteHistoryTasks(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.RangeCompleteHistoryTasksRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// RangeDeleteReplicationTaskFromDLQ wraps ExecutionStore.RangeDeleteReplicationTaskFromDLQ.
func (d telemetryExecutionStore) RangeDeleteReplicationTaskFromDLQ(ctx context.Context, request *_sourcePersistence.RangeDeleteReplicationTaskFromDLQRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/RangeDeleteReplicationTaskFromDLQ",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("RangeDeleteReplicationTaskFromDLQ"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.ExecutionStore.RangeDeleteReplicationTaskFromDLQ(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.RangeDeleteReplicationTaskFromDLQRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// ReadHistoryBranch wraps ExecutionStore.ReadHistoryBranch.
func (d telemetryExecutionStore) ReadHistoryBranch(ctx context.Context, request *_sourcePersistence.InternalReadHistoryBranchRequest) (ip1 *_sourcePersistence.InternalReadHistoryBranchResponse, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/ReadHistoryBranch",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("ReadHistoryBranch"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	ip1, err = d.ExecutionStore.ReadHistoryBranch(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalReadHistoryBranchRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(ip1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalReadHistoryBranchResponse for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// SetWorkflowExecution wraps ExecutionStore.SetWorkflowExecution.
func (d telemetryExecutionStore) SetWorkflowExecution(ctx context.Context, request *_sourcePersistence.InternalSetWorkflowExecutionRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/SetWorkflowExecution",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("SetWorkflowExecution"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.ExecutionStore.SetWorkflowExecution(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalSetWorkflowExecutionRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// UpdateWorkflowExecution wraps ExecutionStore.UpdateWorkflowExecution.
func (d telemetryExecutionStore) UpdateWorkflowExecution(ctx context.Context, request *_sourcePersistence.InternalUpdateWorkflowExecutionRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ExecutionStore/UpdateWorkflowExecution",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ExecutionStore"),
			attribute.Key("persistence.method").String("UpdateWorkflowExecution"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.ExecutionStore.UpdateWorkflowExecution(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalUpdateWorkflowExecutionRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}
