// Code generated by gowrap. DO NOT EDIT.
// template: gowrap_template
// gowrap: http://github.com/hexdigest/gowrap

package telemetry

//go:generate gowrap gen -p go.temporal.io/server/common/persistence -i Queue -t gowrap_template -o queue_gen.go -l ""

import (
	"context"
	"encoding/json"
	"time"

	"go.opentelemetry.io/otel/attribute"
	"go.opentelemetry.io/otel/trace"
	commonpb "go.temporal.io/api/common/v1"
	"go.temporal.io/server/common/log"
	"go.temporal.io/server/common/log/tag"
	_sourcePersistence "go.temporal.io/server/common/persistence"
	"go.temporal.io/server/common/telemetry"
)

// telemetryQueue implements Queue interface instrumented with OpenTelemetry.
type telemetryQueue struct {
	_sourcePersistence.Queue
	tracer    trace.Tracer
	logger    log.Logger
	debugMode bool
}

// newTelemetryQueue returns telemetryQueue.
func newTelemetryQueue(
	base _sourcePersistence.Queue,
	logger log.Logger,
	tracer trace.Tracer,
) telemetryQueue {
	return telemetryQueue{
		Queue:     base,
		tracer:    tracer,
		debugMode: telemetry.DebugMode(),
	}
}

// DeleteMessageFromDLQ wraps Queue.DeleteMessageFromDLQ.
func (d telemetryQueue) DeleteMessageFromDLQ(ctx context.Context, messageID int64) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.Queue/DeleteMessageFromDLQ",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("Queue"),
			attribute.Key("persistence.method").String("DeleteMessageFromDLQ"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.Queue.DeleteMessageFromDLQ(ctx, messageID)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(messageID, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize int64 for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// DeleteMessagesBefore wraps Queue.DeleteMessagesBefore.
func (d telemetryQueue) DeleteMessagesBefore(ctx context.Context, messageID int64) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.Queue/DeleteMessagesBefore",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("Queue"),
			attribute.Key("persistence.method").String("DeleteMessagesBefore"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.Queue.DeleteMessagesBefore(ctx, messageID)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(messageID, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize int64 for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// EnqueueMessage wraps Queue.EnqueueMessage.
func (d telemetryQueue) EnqueueMessage(ctx context.Context, blob *commonpb.DataBlob) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.Queue/EnqueueMessage",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("Queue"),
			attribute.Key("persistence.method").String("EnqueueMessage"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.Queue.EnqueueMessage(ctx, blob)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(blob, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *commonpb.DataBlob for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// EnqueueMessageToDLQ wraps Queue.EnqueueMessageToDLQ.
func (d telemetryQueue) EnqueueMessageToDLQ(ctx context.Context, blob *commonpb.DataBlob) (i1 int64, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.Queue/EnqueueMessageToDLQ",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("Queue"),
			attribute.Key("persistence.method").String("EnqueueMessageToDLQ"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	i1, err = d.Queue.EnqueueMessageToDLQ(ctx, blob)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(blob, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *commonpb.DataBlob for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(i1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize int64 for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// GetAckLevels wraps Queue.GetAckLevels.
func (d telemetryQueue) GetAckLevels(ctx context.Context) (ip1 *_sourcePersistence.InternalQueueMetadata, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.Queue/GetAckLevels",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("Queue"),
			attribute.Key("persistence.method").String("GetAckLevels"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	ip1, err = d.Queue.GetAckLevels(ctx)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		responsePayload, err := json.MarshalIndent(ip1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalQueueMetadata for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// GetDLQAckLevels wraps Queue.GetDLQAckLevels.
func (d telemetryQueue) GetDLQAckLevels(ctx context.Context) (ip1 *_sourcePersistence.InternalQueueMetadata, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.Queue/GetDLQAckLevels",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("Queue"),
			attribute.Key("persistence.method").String("GetDLQAckLevels"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	ip1, err = d.Queue.GetDLQAckLevels(ctx)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		responsePayload, err := json.MarshalIndent(ip1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalQueueMetadata for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// Init wraps Queue.Init.
func (d telemetryQueue) Init(ctx context.Context, blob *commonpb.DataBlob) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.Queue/Init",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("Queue"),
			attribute.Key("persistence.method").String("Init"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.Queue.Init(ctx, blob)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(blob, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *commonpb.DataBlob for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// RangeDeleteMessagesFromDLQ wraps Queue.RangeDeleteMessagesFromDLQ.
func (d telemetryQueue) RangeDeleteMessagesFromDLQ(ctx context.Context, firstMessageID int64, lastMessageID int64) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.Queue/RangeDeleteMessagesFromDLQ",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("Queue"),
			attribute.Key("persistence.method").String("RangeDeleteMessagesFromDLQ"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.Queue.RangeDeleteMessagesFromDLQ(ctx, firstMessageID, lastMessageID)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(firstMessageID, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize int64 for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// ReadMessages wraps Queue.ReadMessages.
func (d telemetryQueue) ReadMessages(ctx context.Context, lastMessageID int64, maxCount int) (qpa1 []*_sourcePersistence.QueueMessage, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.Queue/ReadMessages",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("Queue"),
			attribute.Key("persistence.method").String("ReadMessages"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	qpa1, err = d.Queue.ReadMessages(ctx, lastMessageID, maxCount)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(lastMessageID, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize int64 for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(qpa1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize []*_sourcePersistence.QueueMessage for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// ReadMessagesFromDLQ wraps Queue.ReadMessagesFromDLQ.
func (d telemetryQueue) ReadMessagesFromDLQ(ctx context.Context, firstMessageID int64, lastMessageID int64, pageSize int, pageToken []byte) (qpa1 []*_sourcePersistence.QueueMessage, ba1 []byte, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.Queue/ReadMessagesFromDLQ",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("Queue"),
			attribute.Key("persistence.method").String("ReadMessagesFromDLQ"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	qpa1, ba1, err = d.Queue.ReadMessagesFromDLQ(ctx, firstMessageID, lastMessageID, pageSize, pageToken)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(firstMessageID, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize int64 for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(qpa1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize []*_sourcePersistence.QueueMessage for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// UpdateAckLevel wraps Queue.UpdateAckLevel.
func (d telemetryQueue) UpdateAckLevel(ctx context.Context, metadata *_sourcePersistence.InternalQueueMetadata) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.Queue/UpdateAckLevel",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("Queue"),
			attribute.Key("persistence.method").String("UpdateAckLevel"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.Queue.UpdateAckLevel(ctx, metadata)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(metadata, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalQueueMetadata for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// UpdateDLQAckLevel wraps Queue.UpdateDLQAckLevel.
func (d telemetryQueue) UpdateDLQAckLevel(ctx context.Context, metadata *_sourcePersistence.InternalQueueMetadata) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.Queue/UpdateDLQAckLevel",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("Queue"),
			attribute.Key("persistence.method").String("UpdateDLQAckLevel"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.Queue.UpdateDLQAckLevel(ctx, metadata)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(metadata, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalQueueMetadata for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}
