// Code generated by gowrap. DO NOT EDIT.
// template: gowrap_template
// gowrap: http://github.com/hexdigest/gowrap

package telemetry

//go:generate gowrap gen -p go.temporal.io/server/common/persistence -i ShardStore -t gowrap_template -o shared_store_gen.go -l ""

import (
	"context"
	"encoding/json"
	"time"

	"go.opentelemetry.io/otel/attribute"
	"go.opentelemetry.io/otel/trace"
	"go.temporal.io/server/common/log"
	"go.temporal.io/server/common/log/tag"
	_sourcePersistence "go.temporal.io/server/common/persistence"
	"go.temporal.io/server/common/telemetry"
)

// telemetryShardStore implements ShardStore interface instrumented with OpenTelemetry.
type telemetryShardStore struct {
	_sourcePersistence.ShardStore
	tracer    trace.Tracer
	logger    log.Logger
	debugMode bool
}

// newTelemetryShardStore returns telemetryShardStore.
func newTelemetryShardStore(
	base _sourcePersistence.ShardStore,
	logger log.Logger,
	tracer trace.Tracer,
) telemetryShardStore {
	return telemetryShardStore{
		ShardStore: base,
		tracer:     tracer,
		debugMode:  telemetry.DebugMode(),
	}
}

// AssertShardOwnership wraps ShardStore.AssertShardOwnership.
func (d telemetryShardStore) AssertShardOwnership(ctx context.Context, request *_sourcePersistence.AssertShardOwnershipRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ShardStore/AssertShardOwnership",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ShardStore"),
			attribute.Key("persistence.method").String("AssertShardOwnership"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.ShardStore.AssertShardOwnership(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.AssertShardOwnershipRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// GetOrCreateShard wraps ShardStore.GetOrCreateShard.
func (d telemetryShardStore) GetOrCreateShard(ctx context.Context, request *_sourcePersistence.InternalGetOrCreateShardRequest) (ip1 *_sourcePersistence.InternalGetOrCreateShardResponse, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ShardStore/GetOrCreateShard",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ShardStore"),
			attribute.Key("persistence.method").String("GetOrCreateShard"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	ip1, err = d.ShardStore.GetOrCreateShard(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalGetOrCreateShardRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(ip1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalGetOrCreateShardResponse for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// UpdateShard wraps ShardStore.UpdateShard.
func (d telemetryShardStore) UpdateShard(ctx context.Context, request *_sourcePersistence.InternalUpdateShardRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.ShardStore/UpdateShard",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("ShardStore"),
			attribute.Key("persistence.method").String("UpdateShard"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.ShardStore.UpdateShard(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalUpdateShardRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}
