// Code generated by gowrap. DO NOT EDIT.
// template: gowrap_template
// gowrap: http://github.com/hexdigest/gowrap

package telemetry

//go:generate gowrap gen -p go.temporal.io/server/common/persistence -i TaskStore -t gowrap_template -o task_store_gen.go -l ""

import (
	"context"
	"encoding/json"
	"time"

	"go.opentelemetry.io/otel/attribute"
	"go.opentelemetry.io/otel/trace"
	"go.temporal.io/server/common/log"
	"go.temporal.io/server/common/log/tag"
	_sourcePersistence "go.temporal.io/server/common/persistence"
	"go.temporal.io/server/common/telemetry"
)

// telemetryTaskStore implements TaskStore interface instrumented with OpenTelemetry.
type telemetryTaskStore struct {
	_sourcePersistence.TaskStore
	tracer    trace.Tracer
	logger    log.Logger
	debugMode bool
}

// newTelemetryTaskStore returns telemetryTaskStore.
func newTelemetryTaskStore(
	base _sourcePersistence.TaskStore,
	logger log.Logger,
	tracer trace.Tracer,
) telemetryTaskStore {
	return telemetryTaskStore{
		TaskStore: base,
		tracer:    tracer,
		debugMode: telemetry.DebugMode(),
	}
}

// CompleteTasksLessThan wraps TaskStore.CompleteTasksLessThan.
func (d telemetryTaskStore) CompleteTasksLessThan(ctx context.Context, request *_sourcePersistence.CompleteTasksLessThanRequest) (i1 int, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.TaskStore/CompleteTasksLessThan",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("TaskStore"),
			attribute.Key("persistence.method").String("CompleteTasksLessThan"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	i1, err = d.TaskStore.CompleteTasksLessThan(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.CompleteTasksLessThanRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(i1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize int for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// CountTaskQueuesByBuildId wraps TaskStore.CountTaskQueuesByBuildId.
func (d telemetryTaskStore) CountTaskQueuesByBuildId(ctx context.Context, request *_sourcePersistence.CountTaskQueuesByBuildIdRequest) (i1 int, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.TaskStore/CountTaskQueuesByBuildId",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("TaskStore"),
			attribute.Key("persistence.method").String("CountTaskQueuesByBuildId"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	i1, err = d.TaskStore.CountTaskQueuesByBuildId(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.CountTaskQueuesByBuildIdRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(i1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize int for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// CreateTaskQueue wraps TaskStore.CreateTaskQueue.
func (d telemetryTaskStore) CreateTaskQueue(ctx context.Context, request *_sourcePersistence.InternalCreateTaskQueueRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.TaskStore/CreateTaskQueue",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("TaskStore"),
			attribute.Key("persistence.method").String("CreateTaskQueue"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.TaskStore.CreateTaskQueue(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalCreateTaskQueueRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// CreateTasks wraps TaskStore.CreateTasks.
func (d telemetryTaskStore) CreateTasks(ctx context.Context, request *_sourcePersistence.InternalCreateTasksRequest) (cp1 *_sourcePersistence.CreateTasksResponse, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.TaskStore/CreateTasks",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("TaskStore"),
			attribute.Key("persistence.method").String("CreateTasks"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	cp1, err = d.TaskStore.CreateTasks(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalCreateTasksRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(cp1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.CreateTasksResponse for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// DeleteTaskQueue wraps TaskStore.DeleteTaskQueue.
func (d telemetryTaskStore) DeleteTaskQueue(ctx context.Context, request *_sourcePersistence.DeleteTaskQueueRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.TaskStore/DeleteTaskQueue",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("TaskStore"),
			attribute.Key("persistence.method").String("DeleteTaskQueue"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.TaskStore.DeleteTaskQueue(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.DeleteTaskQueueRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}

// GetTaskQueue wraps TaskStore.GetTaskQueue.
func (d telemetryTaskStore) GetTaskQueue(ctx context.Context, request *_sourcePersistence.InternalGetTaskQueueRequest) (ip1 *_sourcePersistence.InternalGetTaskQueueResponse, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.TaskStore/GetTaskQueue",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("TaskStore"),
			attribute.Key("persistence.method").String("GetTaskQueue"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	ip1, err = d.TaskStore.GetTaskQueue(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalGetTaskQueueRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(ip1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalGetTaskQueueResponse for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// GetTaskQueueUserData wraps TaskStore.GetTaskQueueUserData.
func (d telemetryTaskStore) GetTaskQueueUserData(ctx context.Context, request *_sourcePersistence.GetTaskQueueUserDataRequest) (ip1 *_sourcePersistence.InternalGetTaskQueueUserDataResponse, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.TaskStore/GetTaskQueueUserData",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("TaskStore"),
			attribute.Key("persistence.method").String("GetTaskQueueUserData"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	ip1, err = d.TaskStore.GetTaskQueueUserData(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.GetTaskQueueUserDataRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(ip1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalGetTaskQueueUserDataResponse for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// GetTaskQueuesByBuildId wraps TaskStore.GetTaskQueuesByBuildId.
func (d telemetryTaskStore) GetTaskQueuesByBuildId(ctx context.Context, request *_sourcePersistence.GetTaskQueuesByBuildIdRequest) (sa1 []string, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.TaskStore/GetTaskQueuesByBuildId",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("TaskStore"),
			attribute.Key("persistence.method").String("GetTaskQueuesByBuildId"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	sa1, err = d.TaskStore.GetTaskQueuesByBuildId(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.GetTaskQueuesByBuildIdRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(sa1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize []string for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// GetTasks wraps TaskStore.GetTasks.
func (d telemetryTaskStore) GetTasks(ctx context.Context, request *_sourcePersistence.GetTasksRequest) (ip1 *_sourcePersistence.InternalGetTasksResponse, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.TaskStore/GetTasks",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("TaskStore"),
			attribute.Key("persistence.method").String("GetTasks"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	ip1, err = d.TaskStore.GetTasks(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.GetTasksRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(ip1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalGetTasksResponse for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// ListTaskQueue wraps TaskStore.ListTaskQueue.
func (d telemetryTaskStore) ListTaskQueue(ctx context.Context, request *_sourcePersistence.ListTaskQueueRequest) (ip1 *_sourcePersistence.InternalListTaskQueueResponse, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.TaskStore/ListTaskQueue",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("TaskStore"),
			attribute.Key("persistence.method").String("ListTaskQueue"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	ip1, err = d.TaskStore.ListTaskQueue(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.ListTaskQueueRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(ip1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalListTaskQueueResponse for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// ListTaskQueueUserDataEntries wraps TaskStore.ListTaskQueueUserDataEntries.
func (d telemetryTaskStore) ListTaskQueueUserDataEntries(ctx context.Context, request *_sourcePersistence.ListTaskQueueUserDataEntriesRequest) (ip1 *_sourcePersistence.InternalListTaskQueueUserDataEntriesResponse, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.TaskStore/ListTaskQueueUserDataEntries",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("TaskStore"),
			attribute.Key("persistence.method").String("ListTaskQueueUserDataEntries"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	ip1, err = d.TaskStore.ListTaskQueueUserDataEntries(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.ListTaskQueueUserDataEntriesRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(ip1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalListTaskQueueUserDataEntriesResponse for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// UpdateTaskQueue wraps TaskStore.UpdateTaskQueue.
func (d telemetryTaskStore) UpdateTaskQueue(ctx context.Context, request *_sourcePersistence.InternalUpdateTaskQueueRequest) (up1 *_sourcePersistence.UpdateTaskQueueResponse, err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.TaskStore/UpdateTaskQueue",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("TaskStore"),
			attribute.Key("persistence.method").String("UpdateTaskQueue"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	up1, err = d.TaskStore.UpdateTaskQueue(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalUpdateTaskQueueRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

		responsePayload, err := json.MarshalIndent(up1, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.UpdateTaskQueueResponse for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.response.payload").String(string(responsePayload)))
		}

	}

	return
}

// UpdateTaskQueueUserData wraps TaskStore.UpdateTaskQueueUserData.
func (d telemetryTaskStore) UpdateTaskQueueUserData(ctx context.Context, request *_sourcePersistence.InternalUpdateTaskQueueUserDataRequest) (err error) {
	ctx, span := d.tracer.Start(
		ctx,
		"persistence.TaskStore/UpdateTaskQueueUserData",
		trace.WithAttributes(
			attribute.Key("persistence.store").String("TaskStore"),
			attribute.Key("persistence.method").String("UpdateTaskQueueUserData"),
		))
	defer span.End()

	if deadline, ok := ctx.Deadline(); ok {
		span.SetAttributes(attribute.String("deadline", deadline.Format(time.RFC3339Nano)))
		span.SetAttributes(attribute.String("timeout", time.Until(deadline).String()))
	}

	err = d.TaskStore.UpdateTaskQueueUserData(ctx, request)
	if err != nil {
		span.RecordError(err)
	}

	if d.debugMode {

		requestPayload, err := json.MarshalIndent(request, "", "    ")
		if err != nil {
			d.logger.Error("failed to serialize *_sourcePersistence.InternalUpdateTaskQueueUserDataRequest for OTEL span", tag.Error(err))
		} else {
			span.SetAttributes(attribute.Key("persistence.request.payload").String(string(requestPayload)))
		}

	}

	return
}
