# Temporal Server Documentation

This folder contains docs for those working closely with the Temporal server. 
If you are more interested in just authoring workflows, see our [Getting Started Guide](../README.md#getting-started).

## Core Documentation Sections

### Architectural Diagrams (`/architecture`)
This section contains high-level explanations of Temporal's architecture and core concepts. 
It is designed to be useful for both server developers and those interested in understanding the technological underpinnings of Temporal. 
Detailed diagrams and descriptions can be found there.

### Development Instructions (`/development`)
Here, you'll find guides to setting up a local development environment, along with potentially more advanced topics such as adding migrations or new Remote Procedure Calls (RPCs). 
This section is essential for developers looking to contribute to the Temporal codebase or understand its inner workings.

### Operational Guides (`/admin`)
This section provides reference materials for administrators responsible for deploying Temporal in a production environment. 
It is pretty bare for now, but it is intended to covers topics like spinning up a production environment, configuring it, and monitoring it with metrics and dynamic configurations.
For now, you can find this info on the Temporal docs website at https://docs.temporal.io/self-hosted-guide.