function codeFrame() {
  return require('@babel/code-frame');
}

function core() {
  return require('@babel/core');
}

function parser() {
  return require('@babel/parser');
}

function template() {
  return require('@babel/template');
}

function generator() {
  return require('@babel/generator');
}

function register() {
  return require('@babel/register');
}

function traverse() {
  return require('@babel/traverse');
}

function types() {
  return require('@babel/types');
}

function pluginProposalClassProperties() {
  return require('@babel/plugin-proposal-class-properties');
}

function pluginProposalDecorators() {
  return require('@babel/plugin-proposal-decorators');
}

function pluginProposalDoExpressions() {
  return require('@babel/plugin-proposal-do-expressions');
}

function pluginProposalExportDefaultFrom() {
  return require('@babel/plugin-proposal-export-default-from');
}

function pluginProposalFunctionBind() {
  return require('@babel/plugin-proposal-function-bind');
}

function pluginProposalLogicalAssignmentOperators() {
  return require('@babel/plugin-proposal-logical-assignment-operators');
}

function pluginProposalNullishCoalescingOperator() {
  return require('@babel/plugin-proposal-nullish-coalescing-operator');
}

function pluginProposalOptionalChaining() {
  return require('@babel/plugin-proposal-optional-chaining');
}

function pluginProposalPipelineOperator() {
  return require('@babel/plugin-proposal-pipeline-operator');
}

function pluginSyntaxTopLevelAwait() {
  return require('@babel/plugin-syntax-top-level-await');
}

function pluginTransformReactRemovePropTypes() {
  return require('babel-plugin-transform-react-remove-prop-types');
}

function pluginTransformDestructuring() {
  return require('@babel/plugin-transform-destructuring');
}

function pluginTransformRuntime() {
  return require('@babel/plugin-transform-runtime');
}

function pluginSvgrWebpack() {
  return require('@svgr/webpack');
}

function pluginAutoCSSModules() {
  return require('@umijs/babel-plugin-auto-css-modules');
}

function pluginImportToAwaitRequire() {
  return require('@umijs/babel-plugin-import-to-await-require');
}

function pluginDynamicImportNode() {
  return require('babel-plugin-dynamic-import-node');
}

function pluginImport() {
  return require('babel-plugin-import');
}

function pluginNamedAssetImport() {
  return require('babel-plugin-named-asset-import');
}

function pluginReactRequire() {
  return require('babel-plugin-react-require');
}

function pluginTransformTypescriptMetadata() {
  return require('babel-plugin-transform-typescript-metadata');
}

function presetEnv() {
  return require('@babel/preset-env');
}

function presetReact() {
  return require('@babel/preset-react');
}

function presetTypescript() {
  return require('@babel/preset-typescript');
}

function pluginProposalRecordAndTuple() {
  return require('@babel/plugin-proposal-record-and-tuple');
}

module.exports = {
  codeFrame,
  core,
  parser,
  template,
  generator,
  parser,
  register,
  traverse,
  types,
  pluginProposalClassProperties,
  pluginProposalDecorators,
  pluginProposalDoExpressions,
  pluginProposalExportDefaultFrom,
  pluginProposalFunctionBind,
  pluginProposalLogicalAssignmentOperators,
  pluginProposalNullishCoalescingOperator,
  pluginProposalOptionalChaining,
  pluginProposalPipelineOperator,
  pluginSyntaxTopLevelAwait,
  pluginTransformReactRemovePropTypes,
  pluginTransformDestructuring,
  pluginTransformRuntime,
  presetEnv,
  presetReact,
  presetTypescript,
  pluginSvgrWebpack,
  pluginAutoCSSModules,
  pluginImportToAwaitRequire,
  pluginDynamicImportNode,
  pluginImport,
  pluginNamedAssetImport,
  pluginReactRequire,
  pluginTransformTypescriptMetadata,
  pluginProposalRecordAndTuple,
};
