import PageHeader from '../components/PageHeader.js';
import RuntimeErrorStack from '../components/RuntimeErrorStack.js';
import Spacer from '../components/Spacer.js';

/**
 * @typedef {Object} RuntimeErrorContainerProps
 * @property {Error} currentError
 */

/**
 * A container to render runtime error messages with stack trace.
 * @param {Document} document
 * @param {HTMLElement} root
 * @param {RuntimeErrorContainerProps} props
 * @returns {void}
 */
function RuntimeErrorContainer(document, root, props) {
  PageHeader(document, root, {
    message: props.currentError.message,
    title: props.currentError.name,
    topOffset: '2.5rem',
  });
  RuntimeErrorStack(document, root, {
    error: props.currentError,
  });
  Spacer(document, root, { space: '1rem' });
}

export default RuntimeErrorContainer;
