#!/bin/bash

echo "Clean up all the compiled/autogenerated stuff in the tenpy repository, and possibly more."
read -p "Are you sure? Type 'y' to confirm: " -n 1
echo
if [ "$REPLY" != "y" ]; then
    echo "Abort"
    exit 1
fi
echo "The following files and folders got removed"

rm_dir() {
	test -d "$1" && echo "$1/" && rm -r "$1"
}

rm_files() {
	for file in "$@"
	do
		test -f "$file" && echo "$file" && rm "$file"
	done
}
# clean up *all* the auto-generated stuff, i.e. compiled code, generated documentation, python cached files, test data...

# remove compiled stuff
rm_files tenpy/linalg/{*.c,*.cpp,*.so,*.html}
rm_dir "build"
rm_dir "dist"
rm_dir "physics_tenpy.egg-info"

# remove egg files
rm_dir ".eggs"
rm_dir ".pytest_cache"
rm_dir "tests/.pytest_cache"


# hard-coded version generated by setup.py
rm_files tenpy/_version.py

# clean-up generated documentation
rm_dir "doc/examples"
rm_dir "doc/toycode_stubs"
rm_dir "doc/reference"
rm_dir "doc/sphinx_build"

# clean-up data generated by tests
rm_dir "tests/export_import_test/data"

# clean-up benchmark results
rm_files tests/benchmark/{*.txt,*.png}

# remove python cached files. They might give problems if you modified some files and the date of the file wasn't updated.
find . -name "*.pyc" -delete
find . -name "__pycache__" -print -delete
