(function(scope){
'use strict';

function F(arity, fun, wrapper) {
  wrapper.a = arity;
  wrapper.f = fun;
  return wrapper;
}

function F2(fun) {
  return F(2, fun, function(a) { return function(b) { return fun(a,b); }; })
}
function F3(fun) {
  return F(3, fun, function(a) {
    return function(b) { return function(c) { return fun(a, b, c); }; };
  });
}
function F4(fun) {
  return F(4, fun, function(a) { return function(b) { return function(c) {
    return function(d) { return fun(a, b, c, d); }; }; };
  });
}
function F5(fun) {
  return F(5, fun, function(a) { return function(b) { return function(c) {
    return function(d) { return function(e) { return fun(a, b, c, d, e); }; }; }; };
  });
}
function F6(fun) {
  return F(6, fun, function(a) { return function(b) { return function(c) {
    return function(d) { return function(e) { return function(f) {
    return fun(a, b, c, d, e, f); }; }; }; }; };
  });
}
function F7(fun) {
  return F(7, fun, function(a) { return function(b) { return function(c) {
    return function(d) { return function(e) { return function(f) {
    return function(g) { return fun(a, b, c, d, e, f, g); }; }; }; }; }; };
  });
}
function F8(fun) {
  return F(8, fun, function(a) { return function(b) { return function(c) {
    return function(d) { return function(e) { return function(f) {
    return function(g) { return function(h) {
    return fun(a, b, c, d, e, f, g, h); }; }; }; }; }; }; };
  });
}
function F9(fun) {
  return F(9, fun, function(a) { return function(b) { return function(c) {
    return function(d) { return function(e) { return function(f) {
    return function(g) { return function(h) { return function(i) {
    return fun(a, b, c, d, e, f, g, h, i); }; }; }; }; }; }; }; };
  });
}

function A2(fun, a, b) {
  return fun.a === 2 ? fun.f(a, b) : fun(a)(b);
}
function A3(fun, a, b, c) {
  return fun.a === 3 ? fun.f(a, b, c) : fun(a)(b)(c);
}
function A4(fun, a, b, c, d) {
  return fun.a === 4 ? fun.f(a, b, c, d) : fun(a)(b)(c)(d);
}
function A5(fun, a, b, c, d, e) {
  return fun.a === 5 ? fun.f(a, b, c, d, e) : fun(a)(b)(c)(d)(e);
}
function A6(fun, a, b, c, d, e, f) {
  return fun.a === 6 ? fun.f(a, b, c, d, e, f) : fun(a)(b)(c)(d)(e)(f);
}
function A7(fun, a, b, c, d, e, f, g) {
  return fun.a === 7 ? fun.f(a, b, c, d, e, f, g) : fun(a)(b)(c)(d)(e)(f)(g);
}
function A8(fun, a, b, c, d, e, f, g, h) {
  return fun.a === 8 ? fun.f(a, b, c, d, e, f, g, h) : fun(a)(b)(c)(d)(e)(f)(g)(h);
}
function A9(fun, a, b, c, d, e, f, g, h, i) {
  return fun.a === 9 ? fun.f(a, b, c, d, e, f, g, h, i) : fun(a)(b)(c)(d)(e)(f)(g)(h)(i);
}

console.warn('Compiled in DEV mode. Follow the advice at https://elm-lang.org/0.19.1/optimize for better performance and smaller assets.');


// EQUALITY

function _Utils_eq(x, y)
{
	for (
		var pair, stack = [], isEqual = _Utils_eqHelp(x, y, 0, stack);
		isEqual && (pair = stack.pop());
		isEqual = _Utils_eqHelp(pair.a, pair.b, 0, stack)
		)
	{}

	return isEqual;
}

function _Utils_eqHelp(x, y, depth, stack)
{
	if (x === y)
	{
		return true;
	}

	if (typeof x !== 'object' || x === null || y === null)
	{
		typeof x === 'function' && _Debug_crash(5);
		return false;
	}

	if (depth > 100)
	{
		stack.push(_Utils_Tuple2(x,y));
		return true;
	}

	/**/
	if (x.$ === 'Set_elm_builtin')
	{
		x = $elm$core$Set$toList(x);
		y = $elm$core$Set$toList(y);
	}
	if (x.$ === 'RBNode_elm_builtin' || x.$ === 'RBEmpty_elm_builtin')
	{
		x = $elm$core$Dict$toList(x);
		y = $elm$core$Dict$toList(y);
	}
	//*/

	/**_UNUSED/
	if (x.$ < 0)
	{
		x = $elm$core$Dict$toList(x);
		y = $elm$core$Dict$toList(y);
	}
	//*/

	for (var key in x)
	{
		if (!_Utils_eqHelp(x[key], y[key], depth + 1, stack))
		{
			return false;
		}
	}
	return true;
}

var _Utils_equal = F2(_Utils_eq);
var _Utils_notEqual = F2(function(a, b) { return !_Utils_eq(a,b); });



// COMPARISONS

// Code in Generate/JavaScript.hs, Basics.js, and List.js depends on
// the particular integer values assigned to LT, EQ, and GT.

function _Utils_cmp(x, y, ord)
{
	if (typeof x !== 'object')
	{
		return x === y ? /*EQ*/ 0 : x < y ? /*LT*/ -1 : /*GT*/ 1;
	}

	/**/
	if (x instanceof String)
	{
		var a = x.valueOf();
		var b = y.valueOf();
		return a === b ? 0 : a < b ? -1 : 1;
	}
	//*/

	/**_UNUSED/
	if (typeof x.$ === 'undefined')
	//*/
	/**/
	if (x.$[0] === '#')
	//*/
	{
		return (ord = _Utils_cmp(x.a, y.a))
			? ord
			: (ord = _Utils_cmp(x.b, y.b))
				? ord
				: _Utils_cmp(x.c, y.c);
	}

	// traverse conses until end of a list or a mismatch
	for (; x.b && y.b && !(ord = _Utils_cmp(x.a, y.a)); x = x.b, y = y.b) {} // WHILE_CONSES
	return ord || (x.b ? /*GT*/ 1 : y.b ? /*LT*/ -1 : /*EQ*/ 0);
}

var _Utils_lt = F2(function(a, b) { return _Utils_cmp(a, b) < 0; });
var _Utils_le = F2(function(a, b) { return _Utils_cmp(a, b) < 1; });
var _Utils_gt = F2(function(a, b) { return _Utils_cmp(a, b) > 0; });
var _Utils_ge = F2(function(a, b) { return _Utils_cmp(a, b) >= 0; });

var _Utils_compare = F2(function(x, y)
{
	var n = _Utils_cmp(x, y);
	return n < 0 ? $elm$core$Basics$LT : n ? $elm$core$Basics$GT : $elm$core$Basics$EQ;
});


// COMMON VALUES

var _Utils_Tuple0_UNUSED = 0;
var _Utils_Tuple0 = { $: '#0' };

function _Utils_Tuple2_UNUSED(a, b) { return { a: a, b: b }; }
function _Utils_Tuple2(a, b) { return { $: '#2', a: a, b: b }; }

function _Utils_Tuple3_UNUSED(a, b, c) { return { a: a, b: b, c: c }; }
function _Utils_Tuple3(a, b, c) { return { $: '#3', a: a, b: b, c: c }; }

function _Utils_chr_UNUSED(c) { return c; }
function _Utils_chr(c) { return new String(c); }


// RECORDS

function _Utils_update(oldRecord, updatedFields)
{
	var newRecord = {};

	for (var key in oldRecord)
	{
		newRecord[key] = oldRecord[key];
	}

	for (var key in updatedFields)
	{
		newRecord[key] = updatedFields[key];
	}

	return newRecord;
}


// APPEND

var _Utils_append = F2(_Utils_ap);

function _Utils_ap(xs, ys)
{
	// append Strings
	if (typeof xs === 'string')
	{
		return xs + ys;
	}

	// append Lists
	if (!xs.b)
	{
		return ys;
	}
	var root = _List_Cons(xs.a, ys);
	xs = xs.b
	for (var curr = root; xs.b; xs = xs.b) // WHILE_CONS
	{
		curr = curr.b = _List_Cons(xs.a, ys);
	}
	return root;
}



var _List_Nil_UNUSED = { $: 0 };
var _List_Nil = { $: '[]' };

function _List_Cons_UNUSED(hd, tl) { return { $: 1, a: hd, b: tl }; }
function _List_Cons(hd, tl) { return { $: '::', a: hd, b: tl }; }


var _List_cons = F2(_List_Cons);

function _List_fromArray(arr)
{
	var out = _List_Nil;
	for (var i = arr.length; i--; )
	{
		out = _List_Cons(arr[i], out);
	}
	return out;
}

function _List_toArray(xs)
{
	for (var out = []; xs.b; xs = xs.b) // WHILE_CONS
	{
		out.push(xs.a);
	}
	return out;
}

var _List_map2 = F3(function(f, xs, ys)
{
	for (var arr = []; xs.b && ys.b; xs = xs.b, ys = ys.b) // WHILE_CONSES
	{
		arr.push(A2(f, xs.a, ys.a));
	}
	return _List_fromArray(arr);
});

var _List_map3 = F4(function(f, xs, ys, zs)
{
	for (var arr = []; xs.b && ys.b && zs.b; xs = xs.b, ys = ys.b, zs = zs.b) // WHILE_CONSES
	{
		arr.push(A3(f, xs.a, ys.a, zs.a));
	}
	return _List_fromArray(arr);
});

var _List_map4 = F5(function(f, ws, xs, ys, zs)
{
	for (var arr = []; ws.b && xs.b && ys.b && zs.b; ws = ws.b, xs = xs.b, ys = ys.b, zs = zs.b) // WHILE_CONSES
	{
		arr.push(A4(f, ws.a, xs.a, ys.a, zs.a));
	}
	return _List_fromArray(arr);
});

var _List_map5 = F6(function(f, vs, ws, xs, ys, zs)
{
	for (var arr = []; vs.b && ws.b && xs.b && ys.b && zs.b; vs = vs.b, ws = ws.b, xs = xs.b, ys = ys.b, zs = zs.b) // WHILE_CONSES
	{
		arr.push(A5(f, vs.a, ws.a, xs.a, ys.a, zs.a));
	}
	return _List_fromArray(arr);
});

var _List_sortBy = F2(function(f, xs)
{
	return _List_fromArray(_List_toArray(xs).sort(function(a, b) {
		return _Utils_cmp(f(a), f(b));
	}));
});

var _List_sortWith = F2(function(f, xs)
{
	return _List_fromArray(_List_toArray(xs).sort(function(a, b) {
		var ord = A2(f, a, b);
		return ord === $elm$core$Basics$EQ ? 0 : ord === $elm$core$Basics$LT ? -1 : 1;
	}));
});



var _JsArray_empty = [];

function _JsArray_singleton(value)
{
    return [value];
}

function _JsArray_length(array)
{
    return array.length;
}

var _JsArray_initialize = F3(function(size, offset, func)
{
    var result = new Array(size);

    for (var i = 0; i < size; i++)
    {
        result[i] = func(offset + i);
    }

    return result;
});

var _JsArray_initializeFromList = F2(function (max, ls)
{
    var result = new Array(max);

    for (var i = 0; i < max && ls.b; i++)
    {
        result[i] = ls.a;
        ls = ls.b;
    }

    result.length = i;
    return _Utils_Tuple2(result, ls);
});

var _JsArray_unsafeGet = F2(function(index, array)
{
    return array[index];
});

var _JsArray_unsafeSet = F3(function(index, value, array)
{
    var length = array.length;
    var result = new Array(length);

    for (var i = 0; i < length; i++)
    {
        result[i] = array[i];
    }

    result[index] = value;
    return result;
});

var _JsArray_push = F2(function(value, array)
{
    var length = array.length;
    var result = new Array(length + 1);

    for (var i = 0; i < length; i++)
    {
        result[i] = array[i];
    }

    result[length] = value;
    return result;
});

var _JsArray_foldl = F3(function(func, acc, array)
{
    var length = array.length;

    for (var i = 0; i < length; i++)
    {
        acc = A2(func, array[i], acc);
    }

    return acc;
});

var _JsArray_foldr = F3(function(func, acc, array)
{
    for (var i = array.length - 1; i >= 0; i--)
    {
        acc = A2(func, array[i], acc);
    }

    return acc;
});

var _JsArray_map = F2(function(func, array)
{
    var length = array.length;
    var result = new Array(length);

    for (var i = 0; i < length; i++)
    {
        result[i] = func(array[i]);
    }

    return result;
});

var _JsArray_indexedMap = F3(function(func, offset, array)
{
    var length = array.length;
    var result = new Array(length);

    for (var i = 0; i < length; i++)
    {
        result[i] = A2(func, offset + i, array[i]);
    }

    return result;
});

var _JsArray_slice = F3(function(from, to, array)
{
    return array.slice(from, to);
});

var _JsArray_appendN = F3(function(n, dest, source)
{
    var destLen = dest.length;
    var itemsToCopy = n - destLen;

    if (itemsToCopy > source.length)
    {
        itemsToCopy = source.length;
    }

    var size = destLen + itemsToCopy;
    var result = new Array(size);

    for (var i = 0; i < destLen; i++)
    {
        result[i] = dest[i];
    }

    for (var i = 0; i < itemsToCopy; i++)
    {
        result[i + destLen] = source[i];
    }

    return result;
});



// LOG

var _Debug_log_UNUSED = F2(function(tag, value)
{
	return value;
});

var _Debug_log = F2(function(tag, value)
{
	console.log(tag + ': ' + _Debug_toString(value));
	return value;
});


// TODOS

function _Debug_todo(moduleName, region)
{
	return function(message) {
		_Debug_crash(8, moduleName, region, message);
	};
}

function _Debug_todoCase(moduleName, region, value)
{
	return function(message) {
		_Debug_crash(9, moduleName, region, value, message);
	};
}


// TO STRING

function _Debug_toString_UNUSED(value)
{
	return '<internals>';
}

function _Debug_toString(value)
{
	return _Debug_toAnsiString(false, value);
}

function _Debug_toAnsiString(ansi, value)
{
	if (typeof value === 'function')
	{
		return _Debug_internalColor(ansi, '<function>');
	}

	if (typeof value === 'boolean')
	{
		return _Debug_ctorColor(ansi, value ? 'True' : 'False');
	}

	if (typeof value === 'number')
	{
		return _Debug_numberColor(ansi, value + '');
	}

	if (value instanceof String)
	{
		return _Debug_charColor(ansi, "'" + _Debug_addSlashes(value, true) + "'");
	}

	if (typeof value === 'string')
	{
		return _Debug_stringColor(ansi, '"' + _Debug_addSlashes(value, false) + '"');
	}

	if (typeof value === 'object' && '$' in value)
	{
		var tag = value.$;

		if (typeof tag === 'number')
		{
			return _Debug_internalColor(ansi, '<internals>');
		}

		if (tag[0] === '#')
		{
			var output = [];
			for (var k in value)
			{
				if (k === '$') continue;
				output.push(_Debug_toAnsiString(ansi, value[k]));
			}
			return '(' + output.join(',') + ')';
		}

		if (tag === 'Set_elm_builtin')
		{
			return _Debug_ctorColor(ansi, 'Set')
				+ _Debug_fadeColor(ansi, '.fromList') + ' '
				+ _Debug_toAnsiString(ansi, $elm$core$Set$toList(value));
		}

		if (tag === 'RBNode_elm_builtin' || tag === 'RBEmpty_elm_builtin')
		{
			return _Debug_ctorColor(ansi, 'Dict')
				+ _Debug_fadeColor(ansi, '.fromList') + ' '
				+ _Debug_toAnsiString(ansi, $elm$core$Dict$toList(value));
		}

		if (tag === 'Array_elm_builtin')
		{
			return _Debug_ctorColor(ansi, 'Array')
				+ _Debug_fadeColor(ansi, '.fromList') + ' '
				+ _Debug_toAnsiString(ansi, $elm$core$Array$toList(value));
		}

		if (tag === '::' || tag === '[]')
		{
			var output = '[';

			value.b && (output += _Debug_toAnsiString(ansi, value.a), value = value.b)

			for (; value.b; value = value.b) // WHILE_CONS
			{
				output += ',' + _Debug_toAnsiString(ansi, value.a);
			}
			return output + ']';
		}

		var output = '';
		for (var i in value)
		{
			if (i === '$') continue;
			var str = _Debug_toAnsiString(ansi, value[i]);
			var c0 = str[0];
			var parenless = c0 === '{' || c0 === '(' || c0 === '[' || c0 === '<' || c0 === '"' || str.indexOf(' ') < 0;
			output += ' ' + (parenless ? str : '(' + str + ')');
		}
		return _Debug_ctorColor(ansi, tag) + output;
	}

	if (typeof DataView === 'function' && value instanceof DataView)
	{
		return _Debug_stringColor(ansi, '<' + value.byteLength + ' bytes>');
	}

	if (typeof File !== 'undefined' && value instanceof File)
	{
		return _Debug_internalColor(ansi, '<' + value.name + '>');
	}

	if (typeof value === 'object')
	{
		var output = [];
		for (var key in value)
		{
			var field = key[0] === '_' ? key.slice(1) : key;
			output.push(_Debug_fadeColor(ansi, field) + ' = ' + _Debug_toAnsiString(ansi, value[key]));
		}
		if (output.length === 0)
		{
			return '{}';
		}
		return '{ ' + output.join(', ') + ' }';
	}

	return _Debug_internalColor(ansi, '<internals>');
}

function _Debug_addSlashes(str, isChar)
{
	var s = str
		.replace(/\\/g, '\\\\')
		.replace(/\n/g, '\\n')
		.replace(/\t/g, '\\t')
		.replace(/\r/g, '\\r')
		.replace(/\v/g, '\\v')
		.replace(/\0/g, '\\0');

	if (isChar)
	{
		return s.replace(/\'/g, '\\\'');
	}
	else
	{
		return s.replace(/\"/g, '\\"');
	}
}

function _Debug_ctorColor(ansi, string)
{
	return ansi ? '\x1b[96m' + string + '\x1b[0m' : string;
}

function _Debug_numberColor(ansi, string)
{
	return ansi ? '\x1b[95m' + string + '\x1b[0m' : string;
}

function _Debug_stringColor(ansi, string)
{
	return ansi ? '\x1b[93m' + string + '\x1b[0m' : string;
}

function _Debug_charColor(ansi, string)
{
	return ansi ? '\x1b[92m' + string + '\x1b[0m' : string;
}

function _Debug_fadeColor(ansi, string)
{
	return ansi ? '\x1b[37m' + string + '\x1b[0m' : string;
}

function _Debug_internalColor(ansi, string)
{
	return ansi ? '\x1b[36m' + string + '\x1b[0m' : string;
}

function _Debug_toHexDigit(n)
{
	return String.fromCharCode(n < 10 ? 48 + n : 55 + n);
}


// CRASH


function _Debug_crash_UNUSED(identifier)
{
	throw new Error('https://github.com/elm/core/blob/1.0.0/hints/' + identifier + '.md');
}


function _Debug_crash(identifier, fact1, fact2, fact3, fact4)
{
	switch(identifier)
	{
		case 0:
			throw new Error('What node should I take over? In JavaScript I need something like:\n\n    Elm.Main.init({\n        node: document.getElementById("elm-node")\n    })\n\nYou need to do this with any Browser.sandbox or Browser.element program.');

		case 1:
			throw new Error('Browser.application programs cannot handle URLs like this:\n\n    ' + document.location.href + '\n\nWhat is the root? The root of your file system? Try looking at this program with `elm reactor` or some other server.');

		case 2:
			var jsonErrorString = fact1;
			throw new Error('Problem with the flags given to your Elm program on initialization.\n\n' + jsonErrorString);

		case 3:
			var portName = fact1;
			throw new Error('There can only be one port named `' + portName + '`, but your program has multiple.');

		case 4:
			var portName = fact1;
			var problem = fact2;
			throw new Error('Trying to send an unexpected type of value through port `' + portName + '`:\n' + problem);

		case 5:
			throw new Error('Trying to use `(==)` on functions.\nThere is no way to know if functions are "the same" in the Elm sense.\nRead more about this at https://package.elm-lang.org/packages/elm/core/latest/Basics#== which describes why it is this way and what the better version will look like.');

		case 6:
			var moduleName = fact1;
			throw new Error('Your page is loading multiple Elm scripts with a module named ' + moduleName + '. Maybe a duplicate script is getting loaded accidentally? If not, rename one of them so I know which is which!');

		case 8:
			var moduleName = fact1;
			var region = fact2;
			var message = fact3;
			throw new Error('TODO in module `' + moduleName + '` ' + _Debug_regionToString(region) + '\n\n' + message);

		case 9:
			var moduleName = fact1;
			var region = fact2;
			var value = fact3;
			var message = fact4;
			throw new Error(
				'TODO in module `' + moduleName + '` from the `case` expression '
				+ _Debug_regionToString(region) + '\n\nIt received the following value:\n\n    '
				+ _Debug_toString(value).replace('\n', '\n    ')
				+ '\n\nBut the branch that handles it says:\n\n    ' + message.replace('\n', '\n    ')
			);

		case 10:
			throw new Error('Bug in https://github.com/elm/virtual-dom/issues');

		case 11:
			throw new Error('Cannot perform mod 0. Division by zero error.');
	}
}

function _Debug_regionToString(region)
{
	if (region.start.line === region.end.line)
	{
		return 'on line ' + region.start.line;
	}
	return 'on lines ' + region.start.line + ' through ' + region.end.line;
}



// MATH

var _Basics_add = F2(function(a, b) { return a + b; });
var _Basics_sub = F2(function(a, b) { return a - b; });
var _Basics_mul = F2(function(a, b) { return a * b; });
var _Basics_fdiv = F2(function(a, b) { return a / b; });
var _Basics_idiv = F2(function(a, b) { return (a / b) | 0; });
var _Basics_pow = F2(Math.pow);

var _Basics_remainderBy = F2(function(b, a) { return a % b; });

// https://www.microsoft.com/en-us/research/wp-content/uploads/2016/02/divmodnote-letter.pdf
var _Basics_modBy = F2(function(modulus, x)
{
	var answer = x % modulus;
	return modulus === 0
		? _Debug_crash(11)
		:
	((answer > 0 && modulus < 0) || (answer < 0 && modulus > 0))
		? answer + modulus
		: answer;
});


// TRIGONOMETRY

var _Basics_pi = Math.PI;
var _Basics_e = Math.E;
var _Basics_cos = Math.cos;
var _Basics_sin = Math.sin;
var _Basics_tan = Math.tan;
var _Basics_acos = Math.acos;
var _Basics_asin = Math.asin;
var _Basics_atan = Math.atan;
var _Basics_atan2 = F2(Math.atan2);


// MORE MATH

function _Basics_toFloat(x) { return x; }
function _Basics_truncate(n) { return n | 0; }
function _Basics_isInfinite(n) { return n === Infinity || n === -Infinity; }

var _Basics_ceiling = Math.ceil;
var _Basics_floor = Math.floor;
var _Basics_round = Math.round;
var _Basics_sqrt = Math.sqrt;
var _Basics_log = Math.log;
var _Basics_isNaN = isNaN;


// BOOLEANS

function _Basics_not(bool) { return !bool; }
var _Basics_and = F2(function(a, b) { return a && b; });
var _Basics_or  = F2(function(a, b) { return a || b; });
var _Basics_xor = F2(function(a, b) { return a !== b; });



var _String_cons = F2(function(chr, str)
{
	return chr + str;
});

function _String_uncons(string)
{
	var word = string.charCodeAt(0);
	return !isNaN(word)
		? $elm$core$Maybe$Just(
			0xD800 <= word && word <= 0xDBFF
				? _Utils_Tuple2(_Utils_chr(string[0] + string[1]), string.slice(2))
				: _Utils_Tuple2(_Utils_chr(string[0]), string.slice(1))
		)
		: $elm$core$Maybe$Nothing;
}

var _String_append = F2(function(a, b)
{
	return a + b;
});

function _String_length(str)
{
	return str.length;
}

var _String_map = F2(function(func, string)
{
	var len = string.length;
	var array = new Array(len);
	var i = 0;
	while (i < len)
	{
		var word = string.charCodeAt(i);
		if (0xD800 <= word && word <= 0xDBFF)
		{
			array[i] = func(_Utils_chr(string[i] + string[i+1]));
			i += 2;
			continue;
		}
		array[i] = func(_Utils_chr(string[i]));
		i++;
	}
	return array.join('');
});

var _String_filter = F2(function(isGood, str)
{
	var arr = [];
	var len = str.length;
	var i = 0;
	while (i < len)
	{
		var char = str[i];
		var word = str.charCodeAt(i);
		i++;
		if (0xD800 <= word && word <= 0xDBFF)
		{
			char += str[i];
			i++;
		}

		if (isGood(_Utils_chr(char)))
		{
			arr.push(char);
		}
	}
	return arr.join('');
});

function _String_reverse(str)
{
	var len = str.length;
	var arr = new Array(len);
	var i = 0;
	while (i < len)
	{
		var word = str.charCodeAt(i);
		if (0xD800 <= word && word <= 0xDBFF)
		{
			arr[len - i] = str[i + 1];
			i++;
			arr[len - i] = str[i - 1];
			i++;
		}
		else
		{
			arr[len - i] = str[i];
			i++;
		}
	}
	return arr.join('');
}

var _String_foldl = F3(function(func, state, string)
{
	var len = string.length;
	var i = 0;
	while (i < len)
	{
		var char = string[i];
		var word = string.charCodeAt(i);
		i++;
		if (0xD800 <= word && word <= 0xDBFF)
		{
			char += string[i];
			i++;
		}
		state = A2(func, _Utils_chr(char), state);
	}
	return state;
});

var _String_foldr = F3(function(func, state, string)
{
	var i = string.length;
	while (i--)
	{
		var char = string[i];
		var word = string.charCodeAt(i);
		if (0xDC00 <= word && word <= 0xDFFF)
		{
			i--;
			char = string[i] + char;
		}
		state = A2(func, _Utils_chr(char), state);
	}
	return state;
});

var _String_split = F2(function(sep, str)
{
	return str.split(sep);
});

var _String_join = F2(function(sep, strs)
{
	return strs.join(sep);
});

var _String_slice = F3(function(start, end, str) {
	return str.slice(start, end);
});

function _String_trim(str)
{
	return str.trim();
}

function _String_trimLeft(str)
{
	return str.replace(/^\s+/, '');
}

function _String_trimRight(str)
{
	return str.replace(/\s+$/, '');
}

function _String_words(str)
{
	return _List_fromArray(str.trim().split(/\s+/g));
}

function _String_lines(str)
{
	return _List_fromArray(str.split(/\r\n|\r|\n/g));
}

function _String_toUpper(str)
{
	return str.toUpperCase();
}

function _String_toLower(str)
{
	return str.toLowerCase();
}

var _String_any = F2(function(isGood, string)
{
	var i = string.length;
	while (i--)
	{
		var char = string[i];
		var word = string.charCodeAt(i);
		if (0xDC00 <= word && word <= 0xDFFF)
		{
			i--;
			char = string[i] + char;
		}
		if (isGood(_Utils_chr(char)))
		{
			return true;
		}
	}
	return false;
});

var _String_all = F2(function(isGood, string)
{
	var i = string.length;
	while (i--)
	{
		var char = string[i];
		var word = string.charCodeAt(i);
		if (0xDC00 <= word && word <= 0xDFFF)
		{
			i--;
			char = string[i] + char;
		}
		if (!isGood(_Utils_chr(char)))
		{
			return false;
		}
	}
	return true;
});

var _String_contains = F2(function(sub, str)
{
	return str.indexOf(sub) > -1;
});

var _String_startsWith = F2(function(sub, str)
{
	return str.indexOf(sub) === 0;
});

var _String_endsWith = F2(function(sub, str)
{
	return str.length >= sub.length &&
		str.lastIndexOf(sub) === str.length - sub.length;
});

var _String_indexes = F2(function(sub, str)
{
	var subLen = sub.length;

	if (subLen < 1)
	{
		return _List_Nil;
	}

	var i = 0;
	var is = [];

	while ((i = str.indexOf(sub, i)) > -1)
	{
		is.push(i);
		i = i + subLen;
	}

	return _List_fromArray(is);
});


// TO STRING

function _String_fromNumber(number)
{
	return number + '';
}


// INT CONVERSIONS

function _String_toInt(str)
{
	var total = 0;
	var code0 = str.charCodeAt(0);
	var start = code0 == 0x2B /* + */ || code0 == 0x2D /* - */ ? 1 : 0;

	for (var i = start; i < str.length; ++i)
	{
		var code = str.charCodeAt(i);
		if (code < 0x30 || 0x39 < code)
		{
			return $elm$core$Maybe$Nothing;
		}
		total = 10 * total + code - 0x30;
	}

	return i == start
		? $elm$core$Maybe$Nothing
		: $elm$core$Maybe$Just(code0 == 0x2D ? -total : total);
}


// FLOAT CONVERSIONS

function _String_toFloat(s)
{
	// check if it is a hex, octal, or binary number
	if (s.length === 0 || /[\sxbo]/.test(s))
	{
		return $elm$core$Maybe$Nothing;
	}
	var n = +s;
	// faster isNaN check
	return n === n ? $elm$core$Maybe$Just(n) : $elm$core$Maybe$Nothing;
}

function _String_fromList(chars)
{
	return _List_toArray(chars).join('');
}




function _Char_toCode(char)
{
	var code = char.charCodeAt(0);
	if (0xD800 <= code && code <= 0xDBFF)
	{
		return (code - 0xD800) * 0x400 + char.charCodeAt(1) - 0xDC00 + 0x10000
	}
	return code;
}

function _Char_fromCode(code)
{
	return _Utils_chr(
		(code < 0 || 0x10FFFF < code)
			? '\uFFFD'
			:
		(code <= 0xFFFF)
			? String.fromCharCode(code)
			:
		(code -= 0x10000,
			String.fromCharCode(Math.floor(code / 0x400) + 0xD800, code % 0x400 + 0xDC00)
		)
	);
}

function _Char_toUpper(char)
{
	return _Utils_chr(char.toUpperCase());
}

function _Char_toLower(char)
{
	return _Utils_chr(char.toLowerCase());
}

function _Char_toLocaleUpper(char)
{
	return _Utils_chr(char.toLocaleUpperCase());
}

function _Char_toLocaleLower(char)
{
	return _Utils_chr(char.toLocaleLowerCase());
}



/**/
function _Json_errorToString(error)
{
	return $elm$json$Json$Decode$errorToString(error);
}
//*/


// CORE DECODERS

function _Json_succeed(msg)
{
	return {
		$: 0,
		a: msg
	};
}

function _Json_fail(msg)
{
	return {
		$: 1,
		a: msg
	};
}

function _Json_decodePrim(decoder)
{
	return { $: 2, b: decoder };
}

var _Json_decodeInt = _Json_decodePrim(function(value) {
	return (typeof value !== 'number')
		? _Json_expecting('an INT', value)
		:
	(-2147483647 < value && value < 2147483647 && (value | 0) === value)
		? $elm$core$Result$Ok(value)
		:
	(isFinite(value) && !(value % 1))
		? $elm$core$Result$Ok(value)
		: _Json_expecting('an INT', value);
});

var _Json_decodeBool = _Json_decodePrim(function(value) {
	return (typeof value === 'boolean')
		? $elm$core$Result$Ok(value)
		: _Json_expecting('a BOOL', value);
});

var _Json_decodeFloat = _Json_decodePrim(function(value) {
	return (typeof value === 'number')
		? $elm$core$Result$Ok(value)
		: _Json_expecting('a FLOAT', value);
});

var _Json_decodeValue = _Json_decodePrim(function(value) {
	return $elm$core$Result$Ok(_Json_wrap(value));
});

var _Json_decodeString = _Json_decodePrim(function(value) {
	return (typeof value === 'string')
		? $elm$core$Result$Ok(value)
		: (value instanceof String)
			? $elm$core$Result$Ok(value + '')
			: _Json_expecting('a STRING', value);
});

function _Json_decodeList(decoder) { return { $: 3, b: decoder }; }
function _Json_decodeArray(decoder) { return { $: 4, b: decoder }; }

function _Json_decodeNull(value) { return { $: 5, c: value }; }

var _Json_decodeField = F2(function(field, decoder)
{
	return {
		$: 6,
		d: field,
		b: decoder
	};
});

var _Json_decodeIndex = F2(function(index, decoder)
{
	return {
		$: 7,
		e: index,
		b: decoder
	};
});

function _Json_decodeKeyValuePairs(decoder)
{
	return {
		$: 8,
		b: decoder
	};
}

function _Json_mapMany(f, decoders)
{
	return {
		$: 9,
		f: f,
		g: decoders
	};
}

var _Json_andThen = F2(function(callback, decoder)
{
	return {
		$: 10,
		b: decoder,
		h: callback
	};
});

function _Json_oneOf(decoders)
{
	return {
		$: 11,
		g: decoders
	};
}


// DECODING OBJECTS

var _Json_map1 = F2(function(f, d1)
{
	return _Json_mapMany(f, [d1]);
});

var _Json_map2 = F3(function(f, d1, d2)
{
	return _Json_mapMany(f, [d1, d2]);
});

var _Json_map3 = F4(function(f, d1, d2, d3)
{
	return _Json_mapMany(f, [d1, d2, d3]);
});

var _Json_map4 = F5(function(f, d1, d2, d3, d4)
{
	return _Json_mapMany(f, [d1, d2, d3, d4]);
});

var _Json_map5 = F6(function(f, d1, d2, d3, d4, d5)
{
	return _Json_mapMany(f, [d1, d2, d3, d4, d5]);
});

var _Json_map6 = F7(function(f, d1, d2, d3, d4, d5, d6)
{
	return _Json_mapMany(f, [d1, d2, d3, d4, d5, d6]);
});

var _Json_map7 = F8(function(f, d1, d2, d3, d4, d5, d6, d7)
{
	return _Json_mapMany(f, [d1, d2, d3, d4, d5, d6, d7]);
});

var _Json_map8 = F9(function(f, d1, d2, d3, d4, d5, d6, d7, d8)
{
	return _Json_mapMany(f, [d1, d2, d3, d4, d5, d6, d7, d8]);
});


// DECODE

var _Json_runOnString = F2(function(decoder, string)
{
	try
	{
		var value = JSON.parse(string);
		return _Json_runHelp(decoder, value);
	}
	catch (e)
	{
		return $elm$core$Result$Err(A2($elm$json$Json$Decode$Failure, 'This is not valid JSON! ' + e.message, _Json_wrap(string)));
	}
});

var _Json_run = F2(function(decoder, value)
{
	return _Json_runHelp(decoder, _Json_unwrap(value));
});

function _Json_runHelp(decoder, value)
{
	switch (decoder.$)
	{
		case 2:
			return decoder.b(value);

		case 5:
			return (value === null)
				? $elm$core$Result$Ok(decoder.c)
				: _Json_expecting('null', value);

		case 3:
			if (!_Json_isArray(value))
			{
				return _Json_expecting('a LIST', value);
			}
			return _Json_runArrayDecoder(decoder.b, value, _List_fromArray);

		case 4:
			if (!_Json_isArray(value))
			{
				return _Json_expecting('an ARRAY', value);
			}
			return _Json_runArrayDecoder(decoder.b, value, _Json_toElmArray);

		case 6:
			var field = decoder.d;
			if (typeof value !== 'object' || value === null || !(field in value))
			{
				return _Json_expecting('an OBJECT with a field named `' + field + '`', value);
			}
			var result = _Json_runHelp(decoder.b, value[field]);
			return ($elm$core$Result$isOk(result)) ? result : $elm$core$Result$Err(A2($elm$json$Json$Decode$Field, field, result.a));

		case 7:
			var index = decoder.e;
			if (!_Json_isArray(value))
			{
				return _Json_expecting('an ARRAY', value);
			}
			if (index >= value.length)
			{
				return _Json_expecting('a LONGER array. Need index ' + index + ' but only see ' + value.length + ' entries', value);
			}
			var result = _Json_runHelp(decoder.b, value[index]);
			return ($elm$core$Result$isOk(result)) ? result : $elm$core$Result$Err(A2($elm$json$Json$Decode$Index, index, result.a));

		case 8:
			if (typeof value !== 'object' || value === null || _Json_isArray(value))
			{
				return _Json_expecting('an OBJECT', value);
			}

			var keyValuePairs = _List_Nil;
			// TODO test perf of Object.keys and switch when support is good enough
			for (var key in value)
			{
				if (value.hasOwnProperty(key))
				{
					var result = _Json_runHelp(decoder.b, value[key]);
					if (!$elm$core$Result$isOk(result))
					{
						return $elm$core$Result$Err(A2($elm$json$Json$Decode$Field, key, result.a));
					}
					keyValuePairs = _List_Cons(_Utils_Tuple2(key, result.a), keyValuePairs);
				}
			}
			return $elm$core$Result$Ok($elm$core$List$reverse(keyValuePairs));

		case 9:
			var answer = decoder.f;
			var decoders = decoder.g;
			for (var i = 0; i < decoders.length; i++)
			{
				var result = _Json_runHelp(decoders[i], value);
				if (!$elm$core$Result$isOk(result))
				{
					return result;
				}
				answer = answer(result.a);
			}
			return $elm$core$Result$Ok(answer);

		case 10:
			var result = _Json_runHelp(decoder.b, value);
			return (!$elm$core$Result$isOk(result))
				? result
				: _Json_runHelp(decoder.h(result.a), value);

		case 11:
			var errors = _List_Nil;
			for (var temp = decoder.g; temp.b; temp = temp.b) // WHILE_CONS
			{
				var result = _Json_runHelp(temp.a, value);
				if ($elm$core$Result$isOk(result))
				{
					return result;
				}
				errors = _List_Cons(result.a, errors);
			}
			return $elm$core$Result$Err($elm$json$Json$Decode$OneOf($elm$core$List$reverse(errors)));

		case 1:
			return $elm$core$Result$Err(A2($elm$json$Json$Decode$Failure, decoder.a, _Json_wrap(value)));

		case 0:
			return $elm$core$Result$Ok(decoder.a);
	}
}

function _Json_runArrayDecoder(decoder, value, toElmValue)
{
	var len = value.length;
	var array = new Array(len);
	for (var i = 0; i < len; i++)
	{
		var result = _Json_runHelp(decoder, value[i]);
		if (!$elm$core$Result$isOk(result))
		{
			return $elm$core$Result$Err(A2($elm$json$Json$Decode$Index, i, result.a));
		}
		array[i] = result.a;
	}
	return $elm$core$Result$Ok(toElmValue(array));
}

function _Json_isArray(value)
{
	return Array.isArray(value) || (typeof FileList !== 'undefined' && value instanceof FileList);
}

function _Json_toElmArray(array)
{
	return A2($elm$core$Array$initialize, array.length, function(i) { return array[i]; });
}

function _Json_expecting(type, value)
{
	return $elm$core$Result$Err(A2($elm$json$Json$Decode$Failure, 'Expecting ' + type, _Json_wrap(value)));
}


// EQUALITY

function _Json_equality(x, y)
{
	if (x === y)
	{
		return true;
	}

	if (x.$ !== y.$)
	{
		return false;
	}

	switch (x.$)
	{
		case 0:
		case 1:
			return x.a === y.a;

		case 2:
			return x.b === y.b;

		case 5:
			return x.c === y.c;

		case 3:
		case 4:
		case 8:
			return _Json_equality(x.b, y.b);

		case 6:
			return x.d === y.d && _Json_equality(x.b, y.b);

		case 7:
			return x.e === y.e && _Json_equality(x.b, y.b);

		case 9:
			return x.f === y.f && _Json_listEquality(x.g, y.g);

		case 10:
			return x.h === y.h && _Json_equality(x.b, y.b);

		case 11:
			return _Json_listEquality(x.g, y.g);
	}
}

function _Json_listEquality(aDecoders, bDecoders)
{
	var len = aDecoders.length;
	if (len !== bDecoders.length)
	{
		return false;
	}
	for (var i = 0; i < len; i++)
	{
		if (!_Json_equality(aDecoders[i], bDecoders[i]))
		{
			return false;
		}
	}
	return true;
}


// ENCODE

var _Json_encode = F2(function(indentLevel, value)
{
	return JSON.stringify(_Json_unwrap(value), null, indentLevel) + '';
});

function _Json_wrap(value) { return { $: 0, a: value }; }
function _Json_unwrap(value) { return value.a; }

function _Json_wrap_UNUSED(value) { return value; }
function _Json_unwrap_UNUSED(value) { return value; }

function _Json_emptyArray() { return []; }
function _Json_emptyObject() { return {}; }

var _Json_addField = F3(function(key, value, object)
{
	object[key] = _Json_unwrap(value);
	return object;
});

function _Json_addEntry(func)
{
	return F2(function(entry, array)
	{
		array.push(_Json_unwrap(func(entry)));
		return array;
	});
}

var _Json_encodeNull = _Json_wrap(null);



// TASKS

function _Scheduler_succeed(value)
{
	return {
		$: 0,
		a: value
	};
}

function _Scheduler_fail(error)
{
	return {
		$: 1,
		a: error
	};
}

function _Scheduler_binding(callback)
{
	return {
		$: 2,
		b: callback,
		c: null
	};
}

var _Scheduler_andThen = F2(function(callback, task)
{
	return {
		$: 3,
		b: callback,
		d: task
	};
});

var _Scheduler_onError = F2(function(callback, task)
{
	return {
		$: 4,
		b: callback,
		d: task
	};
});

function _Scheduler_receive(callback)
{
	return {
		$: 5,
		b: callback
	};
}


// PROCESSES

var _Scheduler_guid = 0;

function _Scheduler_rawSpawn(task)
{
	var proc = {
		$: 0,
		e: _Scheduler_guid++,
		f: task,
		g: null,
		h: []
	};

	_Scheduler_enqueue(proc);

	return proc;
}

function _Scheduler_spawn(task)
{
	return _Scheduler_binding(function(callback) {
		callback(_Scheduler_succeed(_Scheduler_rawSpawn(task)));
	});
}

function _Scheduler_rawSend(proc, msg)
{
	proc.h.push(msg);
	_Scheduler_enqueue(proc);
}

var _Scheduler_send = F2(function(proc, msg)
{
	return _Scheduler_binding(function(callback) {
		_Scheduler_rawSend(proc, msg);
		callback(_Scheduler_succeed(_Utils_Tuple0));
	});
});

function _Scheduler_kill(proc)
{
	return _Scheduler_binding(function(callback) {
		var task = proc.f;
		if (task.$ === 2 && task.c)
		{
			task.c();
		}

		proc.f = null;

		callback(_Scheduler_succeed(_Utils_Tuple0));
	});
}


/* STEP PROCESSES

type alias Process =
  { $ : tag
  , id : unique_id
  , root : Task
  , stack : null | { $: SUCCEED | FAIL, a: callback, b: stack }
  , mailbox : [msg]
  }

*/


var _Scheduler_working = false;
var _Scheduler_queue = [];


function _Scheduler_enqueue(proc)
{
	_Scheduler_queue.push(proc);
	if (_Scheduler_working)
	{
		return;
	}
	_Scheduler_working = true;
	while (proc = _Scheduler_queue.shift())
	{
		_Scheduler_step(proc);
	}
	_Scheduler_working = false;
}


function _Scheduler_step(proc)
{
	while (proc.f)
	{
		var rootTag = proc.f.$;
		if (rootTag === 0 || rootTag === 1)
		{
			while (proc.g && proc.g.$ !== rootTag)
			{
				proc.g = proc.g.i;
			}
			if (!proc.g)
			{
				return;
			}
			proc.f = proc.g.b(proc.f.a);
			proc.g = proc.g.i;
		}
		else if (rootTag === 2)
		{
			proc.f.c = proc.f.b(function(newRoot) {
				proc.f = newRoot;
				_Scheduler_enqueue(proc);
			});
			return;
		}
		else if (rootTag === 5)
		{
			if (proc.h.length === 0)
			{
				return;
			}
			proc.f = proc.f.b(proc.h.shift());
		}
		else // if (rootTag === 3 || rootTag === 4)
		{
			proc.g = {
				$: rootTag === 3 ? 0 : 1,
				b: proc.f.b,
				i: proc.g
			};
			proc.f = proc.f.d;
		}
	}
}



function _Process_sleep(time)
{
	return _Scheduler_binding(function(callback) {
		var id = setTimeout(function() {
			callback(_Scheduler_succeed(_Utils_Tuple0));
		}, time);

		return function() { clearTimeout(id); };
	});
}




// PROGRAMS


var _Platform_worker = F4(function(impl, flagDecoder, debugMetadata, args)
{
	return _Platform_initialize(
		flagDecoder,
		args,
		impl.init,
		impl.update,
		impl.subscriptions,
		function() { return function() {} }
	);
});



// INITIALIZE A PROGRAM


function _Platform_initialize(flagDecoder, args, init, update, subscriptions, stepperBuilder)
{
	var result = A2(_Json_run, flagDecoder, _Json_wrap(args ? args['flags'] : undefined));
	$elm$core$Result$isOk(result) || _Debug_crash(2 /**/, _Json_errorToString(result.a) /**/);
	var managers = {};
	var initPair = init(result.a);
	var model = initPair.a;
	var stepper = stepperBuilder(sendToApp, model);
	var ports = _Platform_setupEffects(managers, sendToApp);

	function sendToApp(msg, viewMetadata)
	{
		var pair = A2(update, msg, model);
		stepper(model = pair.a, viewMetadata);
		_Platform_enqueueEffects(managers, pair.b, subscriptions(model));
	}

	_Platform_enqueueEffects(managers, initPair.b, subscriptions(model));

	return ports ? { ports: ports } : {};
}



// TRACK PRELOADS
//
// This is used by code in elm/browser and elm/http
// to register any HTTP requests that are triggered by init.
//


var _Platform_preload;


function _Platform_registerPreload(url)
{
	_Platform_preload.add(url);
}



// EFFECT MANAGERS


var _Platform_effectManagers = {};


function _Platform_setupEffects(managers, sendToApp)
{
	var ports;

	// setup all necessary effect managers
	for (var key in _Platform_effectManagers)
	{
		var manager = _Platform_effectManagers[key];

		if (manager.a)
		{
			ports = ports || {};
			ports[key] = manager.a(key, sendToApp);
		}

		managers[key] = _Platform_instantiateManager(manager, sendToApp);
	}

	return ports;
}


function _Platform_createManager(init, onEffects, onSelfMsg, cmdMap, subMap)
{
	return {
		b: init,
		c: onEffects,
		d: onSelfMsg,
		e: cmdMap,
		f: subMap
	};
}


function _Platform_instantiateManager(info, sendToApp)
{
	var router = {
		g: sendToApp,
		h: undefined
	};

	var onEffects = info.c;
	var onSelfMsg = info.d;
	var cmdMap = info.e;
	var subMap = info.f;

	function loop(state)
	{
		return A2(_Scheduler_andThen, loop, _Scheduler_receive(function(msg)
		{
			var value = msg.a;

			if (msg.$ === 0)
			{
				return A3(onSelfMsg, router, value, state);
			}

			return cmdMap && subMap
				? A4(onEffects, router, value.i, value.j, state)
				: A3(onEffects, router, cmdMap ? value.i : value.j, state);
		}));
	}

	return router.h = _Scheduler_rawSpawn(A2(_Scheduler_andThen, loop, info.b));
}



// ROUTING


var _Platform_sendToApp = F2(function(router, msg)
{
	return _Scheduler_binding(function(callback)
	{
		router.g(msg);
		callback(_Scheduler_succeed(_Utils_Tuple0));
	});
});


var _Platform_sendToSelf = F2(function(router, msg)
{
	return A2(_Scheduler_send, router.h, {
		$: 0,
		a: msg
	});
});



// BAGS


function _Platform_leaf(home)
{
	return function(value)
	{
		return {
			$: 1,
			k: home,
			l: value
		};
	};
}


function _Platform_batch(list)
{
	return {
		$: 2,
		m: list
	};
}


var _Platform_map = F2(function(tagger, bag)
{
	return {
		$: 3,
		n: tagger,
		o: bag
	}
});



// PIPE BAGS INTO EFFECT MANAGERS
//
// Effects must be queued!
//
// Say your init contains a synchronous command, like Time.now or Time.here
//
//   - This will produce a batch of effects (FX_1)
//   - The synchronous task triggers the subsequent `update` call
//   - This will produce a batch of effects (FX_2)
//
// If we just start dispatching FX_2, subscriptions from FX_2 can be processed
// before subscriptions from FX_1. No good! Earlier versions of this code had
// this problem, leading to these reports:
//
//   https://github.com/elm/core/issues/980
//   https://github.com/elm/core/pull/981
//   https://github.com/elm/compiler/issues/1776
//
// The queue is necessary to avoid ordering issues for synchronous commands.


// Why use true/false here? Why not just check the length of the queue?
// The goal is to detect "are we currently dispatching effects?" If we
// are, we need to bail and let the ongoing while loop handle things.
//
// Now say the queue has 1 element. When we dequeue the final element,
// the queue will be empty, but we are still actively dispatching effects.
// So you could get queue jumping in a really tricky category of cases.
//
var _Platform_effectsQueue = [];
var _Platform_effectsActive = false;


function _Platform_enqueueEffects(managers, cmdBag, subBag)
{
	_Platform_effectsQueue.push({ p: managers, q: cmdBag, r: subBag });

	if (_Platform_effectsActive) return;

	_Platform_effectsActive = true;
	for (var fx; fx = _Platform_effectsQueue.shift(); )
	{
		_Platform_dispatchEffects(fx.p, fx.q, fx.r);
	}
	_Platform_effectsActive = false;
}


function _Platform_dispatchEffects(managers, cmdBag, subBag)
{
	var effectsDict = {};
	_Platform_gatherEffects(true, cmdBag, effectsDict, null);
	_Platform_gatherEffects(false, subBag, effectsDict, null);

	for (var home in managers)
	{
		_Scheduler_rawSend(managers[home], {
			$: 'fx',
			a: effectsDict[home] || { i: _List_Nil, j: _List_Nil }
		});
	}
}


function _Platform_gatherEffects(isCmd, bag, effectsDict, taggers)
{
	switch (bag.$)
	{
		case 1:
			var home = bag.k;
			var effect = _Platform_toEffect(isCmd, home, taggers, bag.l);
			effectsDict[home] = _Platform_insert(isCmd, effect, effectsDict[home]);
			return;

		case 2:
			for (var list = bag.m; list.b; list = list.b) // WHILE_CONS
			{
				_Platform_gatherEffects(isCmd, list.a, effectsDict, taggers);
			}
			return;

		case 3:
			_Platform_gatherEffects(isCmd, bag.o, effectsDict, {
				s: bag.n,
				t: taggers
			});
			return;
	}
}


function _Platform_toEffect(isCmd, home, taggers, value)
{
	function applyTaggers(x)
	{
		for (var temp = taggers; temp; temp = temp.t)
		{
			x = temp.s(x);
		}
		return x;
	}

	var map = isCmd
		? _Platform_effectManagers[home].e
		: _Platform_effectManagers[home].f;

	return A2(map, applyTaggers, value)
}


function _Platform_insert(isCmd, newEffect, effects)
{
	effects = effects || { i: _List_Nil, j: _List_Nil };

	isCmd
		? (effects.i = _List_Cons(newEffect, effects.i))
		: (effects.j = _List_Cons(newEffect, effects.j));

	return effects;
}



// PORTS


function _Platform_checkPortName(name)
{
	if (_Platform_effectManagers[name])
	{
		_Debug_crash(3, name)
	}
}



// OUTGOING PORTS


function _Platform_outgoingPort(name, converter)
{
	_Platform_checkPortName(name);
	_Platform_effectManagers[name] = {
		e: _Platform_outgoingPortMap,
		u: converter,
		a: _Platform_setupOutgoingPort
	};
	return _Platform_leaf(name);
}


var _Platform_outgoingPortMap = F2(function(tagger, value) { return value; });


function _Platform_setupOutgoingPort(name)
{
	var subs = [];
	var converter = _Platform_effectManagers[name].u;

	// CREATE MANAGER

	var init = _Process_sleep(0);

	_Platform_effectManagers[name].b = init;
	_Platform_effectManagers[name].c = F3(function(router, cmdList, state)
	{
		for ( ; cmdList.b; cmdList = cmdList.b) // WHILE_CONS
		{
			// grab a separate reference to subs in case unsubscribe is called
			var currentSubs = subs;
			var value = _Json_unwrap(converter(cmdList.a));
			for (var i = 0; i < currentSubs.length; i++)
			{
				currentSubs[i](value);
			}
		}
		return init;
	});

	// PUBLIC API

	function subscribe(callback)
	{
		subs.push(callback);
	}

	function unsubscribe(callback)
	{
		// copy subs into a new array in case unsubscribe is called within a
		// subscribed callback
		subs = subs.slice();
		var index = subs.indexOf(callback);
		if (index >= 0)
		{
			subs.splice(index, 1);
		}
	}

	return {
		subscribe: subscribe,
		unsubscribe: unsubscribe
	};
}



// INCOMING PORTS


function _Platform_incomingPort(name, converter)
{
	_Platform_checkPortName(name);
	_Platform_effectManagers[name] = {
		f: _Platform_incomingPortMap,
		u: converter,
		a: _Platform_setupIncomingPort
	};
	return _Platform_leaf(name);
}


var _Platform_incomingPortMap = F2(function(tagger, finalTagger)
{
	return function(value)
	{
		return tagger(finalTagger(value));
	};
});


function _Platform_setupIncomingPort(name, sendToApp)
{
	var subs = _List_Nil;
	var converter = _Platform_effectManagers[name].u;

	// CREATE MANAGER

	var init = _Scheduler_succeed(null);

	_Platform_effectManagers[name].b = init;
	_Platform_effectManagers[name].c = F3(function(router, subList, state)
	{
		subs = subList;
		return init;
	});

	// PUBLIC API

	function send(incomingValue)
	{
		var result = A2(_Json_run, converter, _Json_wrap(incomingValue));

		$elm$core$Result$isOk(result) || _Debug_crash(4, name, result.a);

		var value = result.a;
		for (var temp = subs; temp.b; temp = temp.b) // WHILE_CONS
		{
			sendToApp(temp.a(value));
		}
	}

	return { send: send };
}



// EXPORT ELM MODULES
//
// Have DEBUG and PROD versions so that we can (1) give nicer errors in
// debug mode and (2) not pay for the bits needed for that in prod mode.
//


function _Platform_export_UNUSED(exports)
{
	scope['Elm']
		? _Platform_mergeExportsProd(scope['Elm'], exports)
		: scope['Elm'] = exports;
}


function _Platform_mergeExportsProd(obj, exports)
{
	for (var name in exports)
	{
		(name in obj)
			? (name == 'init')
				? _Debug_crash(6)
				: _Platform_mergeExportsProd(obj[name], exports[name])
			: (obj[name] = exports[name]);
	}
}


function _Platform_export(exports)
{
	scope['Elm']
		? _Platform_mergeExportsDebug('Elm', scope['Elm'], exports)
		: scope['Elm'] = exports;
}


function _Platform_mergeExportsDebug(moduleName, obj, exports)
{
	for (var name in exports)
	{
		(name in obj)
			? (name == 'init')
				? _Debug_crash(6, moduleName)
				: _Platform_mergeExportsDebug(moduleName + '.' + name, obj[name], exports[name])
			: (obj[name] = exports[name]);
	}
}




// HELPERS


var _VirtualDom_divertHrefToApp;

var _VirtualDom_doc = typeof document !== 'undefined' ? document : {};


function _VirtualDom_appendChild(parent, child)
{
	parent.appendChild(child);
}

var _VirtualDom_init = F4(function(virtualNode, flagDecoder, debugMetadata, args)
{
	// NOTE: this function needs _Platform_export available to work

	/**_UNUSED/
	var node = args['node'];
	//*/
	/**/
	var node = args && args['node'] ? args['node'] : _Debug_crash(0);
	//*/

	node.parentNode.replaceChild(
		_VirtualDom_render(virtualNode, function() {}),
		node
	);

	return {};
});



// TEXT


function _VirtualDom_text(string)
{
	return {
		$: 0,
		a: string
	};
}



// NODE


var _VirtualDom_nodeNS = F2(function(namespace, tag)
{
	return F2(function(factList, kidList)
	{
		for (var kids = [], descendantsCount = 0; kidList.b; kidList = kidList.b) // WHILE_CONS
		{
			var kid = kidList.a;
			descendantsCount += (kid.b || 0);
			kids.push(kid);
		}
		descendantsCount += kids.length;

		return {
			$: 1,
			c: tag,
			d: _VirtualDom_organizeFacts(factList),
			e: kids,
			f: namespace,
			b: descendantsCount
		};
	});
});


var _VirtualDom_node = _VirtualDom_nodeNS(undefined);



// KEYED NODE


var _VirtualDom_keyedNodeNS = F2(function(namespace, tag)
{
	return F2(function(factList, kidList)
	{
		for (var kids = [], descendantsCount = 0; kidList.b; kidList = kidList.b) // WHILE_CONS
		{
			var kid = kidList.a;
			descendantsCount += (kid.b.b || 0);
			kids.push(kid);
		}
		descendantsCount += kids.length;

		return {
			$: 2,
			c: tag,
			d: _VirtualDom_organizeFacts(factList),
			e: kids,
			f: namespace,
			b: descendantsCount
		};
	});
});


var _VirtualDom_keyedNode = _VirtualDom_keyedNodeNS(undefined);



// CUSTOM


function _VirtualDom_custom(factList, model, render, diff)
{
	return {
		$: 3,
		d: _VirtualDom_organizeFacts(factList),
		g: model,
		h: render,
		i: diff
	};
}



// MAP


var _VirtualDom_map = F2(function(tagger, node)
{
	return {
		$: 4,
		j: tagger,
		k: node,
		b: 1 + (node.b || 0)
	};
});



// LAZY


function _VirtualDom_thunk(refs, thunk)
{
	return {
		$: 5,
		l: refs,
		m: thunk,
		k: undefined
	};
}

var _VirtualDom_lazy = F2(function(func, a)
{
	return _VirtualDom_thunk([func, a], function() {
		return func(a);
	});
});

var _VirtualDom_lazy2 = F3(function(func, a, b)
{
	return _VirtualDom_thunk([func, a, b], function() {
		return A2(func, a, b);
	});
});

var _VirtualDom_lazy3 = F4(function(func, a, b, c)
{
	return _VirtualDom_thunk([func, a, b, c], function() {
		return A3(func, a, b, c);
	});
});

var _VirtualDom_lazy4 = F5(function(func, a, b, c, d)
{
	return _VirtualDom_thunk([func, a, b, c, d], function() {
		return A4(func, a, b, c, d);
	});
});

var _VirtualDom_lazy5 = F6(function(func, a, b, c, d, e)
{
	return _VirtualDom_thunk([func, a, b, c, d, e], function() {
		return A5(func, a, b, c, d, e);
	});
});

var _VirtualDom_lazy6 = F7(function(func, a, b, c, d, e, f)
{
	return _VirtualDom_thunk([func, a, b, c, d, e, f], function() {
		return A6(func, a, b, c, d, e, f);
	});
});

var _VirtualDom_lazy7 = F8(function(func, a, b, c, d, e, f, g)
{
	return _VirtualDom_thunk([func, a, b, c, d, e, f, g], function() {
		return A7(func, a, b, c, d, e, f, g);
	});
});

var _VirtualDom_lazy8 = F9(function(func, a, b, c, d, e, f, g, h)
{
	return _VirtualDom_thunk([func, a, b, c, d, e, f, g, h], function() {
		return A8(func, a, b, c, d, e, f, g, h);
	});
});



// FACTS


var _VirtualDom_on = F2(function(key, handler)
{
	return {
		$: 'a0',
		n: key,
		o: handler
	};
});
var _VirtualDom_style = F2(function(key, value)
{
	return {
		$: 'a1',
		n: key,
		o: value
	};
});
var _VirtualDom_property = F2(function(key, value)
{
	return {
		$: 'a2',
		n: key,
		o: value
	};
});
var _VirtualDom_attribute = F2(function(key, value)
{
	return {
		$: 'a3',
		n: key,
		o: value
	};
});
var _VirtualDom_attributeNS = F3(function(namespace, key, value)
{
	return {
		$: 'a4',
		n: key,
		o: { f: namespace, o: value }
	};
});



// XSS ATTACK VECTOR CHECKS


function _VirtualDom_noScript(tag)
{
	return tag == 'script' ? 'p' : tag;
}

function _VirtualDom_noOnOrFormAction(key)
{
	return /^(on|formAction$)/i.test(key) ? 'data-' + key : key;
}

function _VirtualDom_noInnerHtmlOrFormAction(key)
{
	return key == 'innerHTML' || key == 'formAction' ? 'data-' + key : key;
}

function _VirtualDom_noJavaScriptUri_UNUSED(value)
{
	return /^javascript:/i.test(value.replace(/\s/g,'')) ? '' : value;
}

function _VirtualDom_noJavaScriptUri(value)
{
	return /^javascript:/i.test(value.replace(/\s/g,''))
		? 'javascript:alert("This is an XSS vector. Please use ports or web components instead.")'
		: value;
}

function _VirtualDom_noJavaScriptOrHtmlUri_UNUSED(value)
{
	return /^\s*(javascript:|data:text\/html)/i.test(value) ? '' : value;
}

function _VirtualDom_noJavaScriptOrHtmlUri(value)
{
	return /^\s*(javascript:|data:text\/html)/i.test(value)
		? 'javascript:alert("This is an XSS vector. Please use ports or web components instead.")'
		: value;
}



// MAP FACTS


var _VirtualDom_mapAttribute = F2(function(func, attr)
{
	return (attr.$ === 'a0')
		? A2(_VirtualDom_on, attr.n, _VirtualDom_mapHandler(func, attr.o))
		: attr;
});

function _VirtualDom_mapHandler(func, handler)
{
	var tag = $elm$virtual_dom$VirtualDom$toHandlerInt(handler);

	// 0 = Normal
	// 1 = MayStopPropagation
	// 2 = MayPreventDefault
	// 3 = Custom

	return {
		$: handler.$,
		a:
			!tag
				? A2($elm$json$Json$Decode$map, func, handler.a)
				:
			A3($elm$json$Json$Decode$map2,
				tag < 3
					? _VirtualDom_mapEventTuple
					: _VirtualDom_mapEventRecord,
				$elm$json$Json$Decode$succeed(func),
				handler.a
			)
	};
}

var _VirtualDom_mapEventTuple = F2(function(func, tuple)
{
	return _Utils_Tuple2(func(tuple.a), tuple.b);
});

var _VirtualDom_mapEventRecord = F2(function(func, record)
{
	return {
		message: func(record.message),
		stopPropagation: record.stopPropagation,
		preventDefault: record.preventDefault
	}
});



// ORGANIZE FACTS


function _VirtualDom_organizeFacts(factList)
{
	for (var facts = {}; factList.b; factList = factList.b) // WHILE_CONS
	{
		var entry = factList.a;

		var tag = entry.$;
		var key = entry.n;
		var value = entry.o;

		if (tag === 'a2')
		{
			(key === 'className')
				? _VirtualDom_addClass(facts, key, _Json_unwrap(value))
				: facts[key] = _Json_unwrap(value);

			continue;
		}

		var subFacts = facts[tag] || (facts[tag] = {});
		(tag === 'a3' && key === 'class')
			? _VirtualDom_addClass(subFacts, key, value)
			: subFacts[key] = value;
	}

	return facts;
}

function _VirtualDom_addClass(object, key, newClass)
{
	var classes = object[key];
	object[key] = classes ? classes + ' ' + newClass : newClass;
}



// RENDER


function _VirtualDom_render(vNode, eventNode)
{
	var tag = vNode.$;

	if (tag === 5)
	{
		return _VirtualDom_render(vNode.k || (vNode.k = vNode.m()), eventNode);
	}

	if (tag === 0)
	{
		return _VirtualDom_doc.createTextNode(vNode.a);
	}

	if (tag === 4)
	{
		var subNode = vNode.k;
		var tagger = vNode.j;

		while (subNode.$ === 4)
		{
			typeof tagger !== 'object'
				? tagger = [tagger, subNode.j]
				: tagger.push(subNode.j);

			subNode = subNode.k;
		}

		var subEventRoot = { j: tagger, p: eventNode };
		var domNode = _VirtualDom_render(subNode, subEventRoot);
		domNode.elm_event_node_ref = subEventRoot;
		return domNode;
	}

	if (tag === 3)
	{
		var domNode = vNode.h(vNode.g);
		_VirtualDom_applyFacts(domNode, eventNode, vNode.d);
		return domNode;
	}

	// at this point `tag` must be 1 or 2

	var domNode = vNode.f
		? _VirtualDom_doc.createElementNS(vNode.f, vNode.c)
		: _VirtualDom_doc.createElement(vNode.c);

	if (_VirtualDom_divertHrefToApp && vNode.c == 'a')
	{
		domNode.addEventListener('click', _VirtualDom_divertHrefToApp(domNode));
	}

	_VirtualDom_applyFacts(domNode, eventNode, vNode.d);

	for (var kids = vNode.e, i = 0; i < kids.length; i++)
	{
		_VirtualDom_appendChild(domNode, _VirtualDom_render(tag === 1 ? kids[i] : kids[i].b, eventNode));
	}

	return domNode;
}



// APPLY FACTS


function _VirtualDom_applyFacts(domNode, eventNode, facts)
{
	for (var key in facts)
	{
		var value = facts[key];

		key === 'a1'
			? _VirtualDom_applyStyles(domNode, value)
			:
		key === 'a0'
			? _VirtualDom_applyEvents(domNode, eventNode, value)
			:
		key === 'a3'
			? _VirtualDom_applyAttrs(domNode, value)
			:
		key === 'a4'
			? _VirtualDom_applyAttrsNS(domNode, value)
			:
		((key !== 'value' && key !== 'checked') || domNode[key] !== value) && (domNode[key] = value);
	}
}



// APPLY STYLES


function _VirtualDom_applyStyles(domNode, styles)
{
	var domNodeStyle = domNode.style;

	for (var key in styles)
	{
		domNodeStyle[key] = styles[key];
	}
}



// APPLY ATTRS


function _VirtualDom_applyAttrs(domNode, attrs)
{
	for (var key in attrs)
	{
		var value = attrs[key];
		typeof value !== 'undefined'
			? domNode.setAttribute(key, value)
			: domNode.removeAttribute(key);
	}
}



// APPLY NAMESPACED ATTRS


function _VirtualDom_applyAttrsNS(domNode, nsAttrs)
{
	for (var key in nsAttrs)
	{
		var pair = nsAttrs[key];
		var namespace = pair.f;
		var value = pair.o;

		typeof value !== 'undefined'
			? domNode.setAttributeNS(namespace, key, value)
			: domNode.removeAttributeNS(namespace, key);
	}
}



// APPLY EVENTS


function _VirtualDom_applyEvents(domNode, eventNode, events)
{
	var allCallbacks = domNode.elmFs || (domNode.elmFs = {});

	for (var key in events)
	{
		var newHandler = events[key];
		var oldCallback = allCallbacks[key];

		if (!newHandler)
		{
			domNode.removeEventListener(key, oldCallback);
			allCallbacks[key] = undefined;
			continue;
		}

		if (oldCallback)
		{
			var oldHandler = oldCallback.q;
			if (oldHandler.$ === newHandler.$)
			{
				oldCallback.q = newHandler;
				continue;
			}
			domNode.removeEventListener(key, oldCallback);
		}

		oldCallback = _VirtualDom_makeCallback(eventNode, newHandler);
		domNode.addEventListener(key, oldCallback,
			_VirtualDom_passiveSupported
			&& { passive: $elm$virtual_dom$VirtualDom$toHandlerInt(newHandler) < 2 }
		);
		allCallbacks[key] = oldCallback;
	}
}



// PASSIVE EVENTS


var _VirtualDom_passiveSupported;

try
{
	window.addEventListener('t', null, Object.defineProperty({}, 'passive', {
		get: function() { _VirtualDom_passiveSupported = true; }
	}));
}
catch(e) {}



// EVENT HANDLERS


function _VirtualDom_makeCallback(eventNode, initialHandler)
{
	function callback(event)
	{
		var handler = callback.q;
		var result = _Json_runHelp(handler.a, event);

		if (!$elm$core$Result$isOk(result))
		{
			return;
		}

		var tag = $elm$virtual_dom$VirtualDom$toHandlerInt(handler);

		// 0 = Normal
		// 1 = MayStopPropagation
		// 2 = MayPreventDefault
		// 3 = Custom

		var value = result.a;
		var message = !tag ? value : tag < 3 ? value.a : value.message;
		var stopPropagation = tag == 1 ? value.b : tag == 3 && value.stopPropagation;
		var currentEventNode = (
			stopPropagation && event.stopPropagation(),
			(tag == 2 ? value.b : tag == 3 && value.preventDefault) && event.preventDefault(),
			eventNode
		);
		var tagger;
		var i;
		while (tagger = currentEventNode.j)
		{
			if (typeof tagger == 'function')
			{
				message = tagger(message);
			}
			else
			{
				for (var i = tagger.length; i--; )
				{
					message = tagger[i](message);
				}
			}
			currentEventNode = currentEventNode.p;
		}
		currentEventNode(message, stopPropagation); // stopPropagation implies isSync
	}

	callback.q = initialHandler;

	return callback;
}

function _VirtualDom_equalEvents(x, y)
{
	return x.$ == y.$ && _Json_equality(x.a, y.a);
}



// DIFF


// TODO: Should we do patches like in iOS?
//
// type Patch
//   = At Int Patch
//   | Batch (List Patch)
//   | Change ...
//
// How could it not be better?
//
function _VirtualDom_diff(x, y)
{
	var patches = [];
	_VirtualDom_diffHelp(x, y, patches, 0);
	return patches;
}


function _VirtualDom_pushPatch(patches, type, index, data)
{
	var patch = {
		$: type,
		r: index,
		s: data,
		t: undefined,
		u: undefined
	};
	patches.push(patch);
	return patch;
}


function _VirtualDom_diffHelp(x, y, patches, index)
{
	if (x === y)
	{
		return;
	}

	var xType = x.$;
	var yType = y.$;

	// Bail if you run into different types of nodes. Implies that the
	// structure has changed significantly and it's not worth a diff.
	if (xType !== yType)
	{
		if (xType === 1 && yType === 2)
		{
			y = _VirtualDom_dekey(y);
			yType = 1;
		}
		else
		{
			_VirtualDom_pushPatch(patches, 0, index, y);
			return;
		}
	}

	// Now we know that both nodes are the same $.
	switch (yType)
	{
		case 5:
			var xRefs = x.l;
			var yRefs = y.l;
			var i = xRefs.length;
			var same = i === yRefs.length;
			while (same && i--)
			{
				same = xRefs[i] === yRefs[i];
			}
			if (same)
			{
				y.k = x.k;
				return;
			}
			y.k = y.m();
			var subPatches = [];
			_VirtualDom_diffHelp(x.k, y.k, subPatches, 0);
			subPatches.length > 0 && _VirtualDom_pushPatch(patches, 1, index, subPatches);
			return;

		case 4:
			// gather nested taggers
			var xTaggers = x.j;
			var yTaggers = y.j;
			var nesting = false;

			var xSubNode = x.k;
			while (xSubNode.$ === 4)
			{
				nesting = true;

				typeof xTaggers !== 'object'
					? xTaggers = [xTaggers, xSubNode.j]
					: xTaggers.push(xSubNode.j);

				xSubNode = xSubNode.k;
			}

			var ySubNode = y.k;
			while (ySubNode.$ === 4)
			{
				nesting = true;

				typeof yTaggers !== 'object'
					? yTaggers = [yTaggers, ySubNode.j]
					: yTaggers.push(ySubNode.j);

				ySubNode = ySubNode.k;
			}

			// Just bail if different numbers of taggers. This implies the
			// structure of the virtual DOM has changed.
			if (nesting && xTaggers.length !== yTaggers.length)
			{
				_VirtualDom_pushPatch(patches, 0, index, y);
				return;
			}

			// check if taggers are "the same"
			if (nesting ? !_VirtualDom_pairwiseRefEqual(xTaggers, yTaggers) : xTaggers !== yTaggers)
			{
				_VirtualDom_pushPatch(patches, 2, index, yTaggers);
			}

			// diff everything below the taggers
			_VirtualDom_diffHelp(xSubNode, ySubNode, patches, index + 1);
			return;

		case 0:
			if (x.a !== y.a)
			{
				_VirtualDom_pushPatch(patches, 3, index, y.a);
			}
			return;

		case 1:
			_VirtualDom_diffNodes(x, y, patches, index, _VirtualDom_diffKids);
			return;

		case 2:
			_VirtualDom_diffNodes(x, y, patches, index, _VirtualDom_diffKeyedKids);
			return;

		case 3:
			if (x.h !== y.h)
			{
				_VirtualDom_pushPatch(patches, 0, index, y);
				return;
			}

			var factsDiff = _VirtualDom_diffFacts(x.d, y.d);
			factsDiff && _VirtualDom_pushPatch(patches, 4, index, factsDiff);

			var patch = y.i(x.g, y.g);
			patch && _VirtualDom_pushPatch(patches, 5, index, patch);

			return;
	}
}

// assumes the incoming arrays are the same length
function _VirtualDom_pairwiseRefEqual(as, bs)
{
	for (var i = 0; i < as.length; i++)
	{
		if (as[i] !== bs[i])
		{
			return false;
		}
	}

	return true;
}

function _VirtualDom_diffNodes(x, y, patches, index, diffKids)
{
	// Bail if obvious indicators have changed. Implies more serious
	// structural changes such that it's not worth it to diff.
	if (x.c !== y.c || x.f !== y.f)
	{
		_VirtualDom_pushPatch(patches, 0, index, y);
		return;
	}

	var factsDiff = _VirtualDom_diffFacts(x.d, y.d);
	factsDiff && _VirtualDom_pushPatch(patches, 4, index, factsDiff);

	diffKids(x, y, patches, index);
}



// DIFF FACTS


// TODO Instead of creating a new diff object, it's possible to just test if
// there *is* a diff. During the actual patch, do the diff again and make the
// modifications directly. This way, there's no new allocations. Worth it?
function _VirtualDom_diffFacts(x, y, category)
{
	var diff;

	// look for changes and removals
	for (var xKey in x)
	{
		if (xKey === 'a1' || xKey === 'a0' || xKey === 'a3' || xKey === 'a4')
		{
			var subDiff = _VirtualDom_diffFacts(x[xKey], y[xKey] || {}, xKey);
			if (subDiff)
			{
				diff = diff || {};
				diff[xKey] = subDiff;
			}
			continue;
		}

		// remove if not in the new facts
		if (!(xKey in y))
		{
			diff = diff || {};
			diff[xKey] =
				!category
					? (typeof x[xKey] === 'string' ? '' : null)
					:
				(category === 'a1')
					? ''
					:
				(category === 'a0' || category === 'a3')
					? undefined
					:
				{ f: x[xKey].f, o: undefined };

			continue;
		}

		var xValue = x[xKey];
		var yValue = y[xKey];

		// reference equal, so don't worry about it
		if (xValue === yValue && xKey !== 'value' && xKey !== 'checked'
			|| category === 'a0' && _VirtualDom_equalEvents(xValue, yValue))
		{
			continue;
		}

		diff = diff || {};
		diff[xKey] = yValue;
	}

	// add new stuff
	for (var yKey in y)
	{
		if (!(yKey in x))
		{
			diff = diff || {};
			diff[yKey] = y[yKey];
		}
	}

	return diff;
}



// DIFF KIDS


function _VirtualDom_diffKids(xParent, yParent, patches, index)
{
	var xKids = xParent.e;
	var yKids = yParent.e;

	var xLen = xKids.length;
	var yLen = yKids.length;

	// FIGURE OUT IF THERE ARE INSERTS OR REMOVALS

	if (xLen > yLen)
	{
		_VirtualDom_pushPatch(patches, 6, index, {
			v: yLen,
			i: xLen - yLen
		});
	}
	else if (xLen < yLen)
	{
		_VirtualDom_pushPatch(patches, 7, index, {
			v: xLen,
			e: yKids
		});
	}

	// PAIRWISE DIFF EVERYTHING ELSE

	for (var minLen = xLen < yLen ? xLen : yLen, i = 0; i < minLen; i++)
	{
		var xKid = xKids[i];
		_VirtualDom_diffHelp(xKid, yKids[i], patches, ++index);
		index += xKid.b || 0;
	}
}



// KEYED DIFF


function _VirtualDom_diffKeyedKids(xParent, yParent, patches, rootIndex)
{
	var localPatches = [];

	var changes = {}; // Dict String Entry
	var inserts = []; // Array { index : Int, entry : Entry }
	// type Entry = { tag : String, vnode : VNode, index : Int, data : _ }

	var xKids = xParent.e;
	var yKids = yParent.e;
	var xLen = xKids.length;
	var yLen = yKids.length;
	var xIndex = 0;
	var yIndex = 0;

	var index = rootIndex;

	while (xIndex < xLen && yIndex < yLen)
	{
		var x = xKids[xIndex];
		var y = yKids[yIndex];

		var xKey = x.a;
		var yKey = y.a;
		var xNode = x.b;
		var yNode = y.b;

		var newMatch = undefined;
		var oldMatch = undefined;

		// check if keys match

		if (xKey === yKey)
		{
			index++;
			_VirtualDom_diffHelp(xNode, yNode, localPatches, index);
			index += xNode.b || 0;

			xIndex++;
			yIndex++;
			continue;
		}

		// look ahead 1 to detect insertions and removals.

		var xNext = xKids[xIndex + 1];
		var yNext = yKids[yIndex + 1];

		if (xNext)
		{
			var xNextKey = xNext.a;
			var xNextNode = xNext.b;
			oldMatch = yKey === xNextKey;
		}

		if (yNext)
		{
			var yNextKey = yNext.a;
			var yNextNode = yNext.b;
			newMatch = xKey === yNextKey;
		}


		// swap x and y
		if (newMatch && oldMatch)
		{
			index++;
			_VirtualDom_diffHelp(xNode, yNextNode, localPatches, index);
			_VirtualDom_insertNode(changes, localPatches, xKey, yNode, yIndex, inserts);
			index += xNode.b || 0;

			index++;
			_VirtualDom_removeNode(changes, localPatches, xKey, xNextNode, index);
			index += xNextNode.b || 0;

			xIndex += 2;
			yIndex += 2;
			continue;
		}

		// insert y
		if (newMatch)
		{
			index++;
			_VirtualDom_insertNode(changes, localPatches, yKey, yNode, yIndex, inserts);
			_VirtualDom_diffHelp(xNode, yNextNode, localPatches, index);
			index += xNode.b || 0;

			xIndex += 1;
			yIndex += 2;
			continue;
		}

		// remove x
		if (oldMatch)
		{
			index++;
			_VirtualDom_removeNode(changes, localPatches, xKey, xNode, index);
			index += xNode.b || 0;

			index++;
			_VirtualDom_diffHelp(xNextNode, yNode, localPatches, index);
			index += xNextNode.b || 0;

			xIndex += 2;
			yIndex += 1;
			continue;
		}

		// remove x, insert y
		if (xNext && xNextKey === yNextKey)
		{
			index++;
			_VirtualDom_removeNode(changes, localPatches, xKey, xNode, index);
			_VirtualDom_insertNode(changes, localPatches, yKey, yNode, yIndex, inserts);
			index += xNode.b || 0;

			index++;
			_VirtualDom_diffHelp(xNextNode, yNextNode, localPatches, index);
			index += xNextNode.b || 0;

			xIndex += 2;
			yIndex += 2;
			continue;
		}

		break;
	}

	// eat up any remaining nodes with removeNode and insertNode

	while (xIndex < xLen)
	{
		index++;
		var x = xKids[xIndex];
		var xNode = x.b;
		_VirtualDom_removeNode(changes, localPatches, x.a, xNode, index);
		index += xNode.b || 0;
		xIndex++;
	}

	while (yIndex < yLen)
	{
		var endInserts = endInserts || [];
		var y = yKids[yIndex];
		_VirtualDom_insertNode(changes, localPatches, y.a, y.b, undefined, endInserts);
		yIndex++;
	}

	if (localPatches.length > 0 || inserts.length > 0 || endInserts)
	{
		_VirtualDom_pushPatch(patches, 8, rootIndex, {
			w: localPatches,
			x: inserts,
			y: endInserts
		});
	}
}



// CHANGES FROM KEYED DIFF


var _VirtualDom_POSTFIX = '_elmW6BL';


function _VirtualDom_insertNode(changes, localPatches, key, vnode, yIndex, inserts)
{
	var entry = changes[key];

	// never seen this key before
	if (!entry)
	{
		entry = {
			c: 0,
			z: vnode,
			r: yIndex,
			s: undefined
		};

		inserts.push({ r: yIndex, A: entry });
		changes[key] = entry;

		return;
	}

	// this key was removed earlier, a match!
	if (entry.c === 1)
	{
		inserts.push({ r: yIndex, A: entry });

		entry.c = 2;
		var subPatches = [];
		_VirtualDom_diffHelp(entry.z, vnode, subPatches, entry.r);
		entry.r = yIndex;
		entry.s.s = {
			w: subPatches,
			A: entry
		};

		return;
	}

	// this key has already been inserted or moved, a duplicate!
	_VirtualDom_insertNode(changes, localPatches, key + _VirtualDom_POSTFIX, vnode, yIndex, inserts);
}


function _VirtualDom_removeNode(changes, localPatches, key, vnode, index)
{
	var entry = changes[key];

	// never seen this key before
	if (!entry)
	{
		var patch = _VirtualDom_pushPatch(localPatches, 9, index, undefined);

		changes[key] = {
			c: 1,
			z: vnode,
			r: index,
			s: patch
		};

		return;
	}

	// this key was inserted earlier, a match!
	if (entry.c === 0)
	{
		entry.c = 2;
		var subPatches = [];
		_VirtualDom_diffHelp(vnode, entry.z, subPatches, index);

		_VirtualDom_pushPatch(localPatches, 9, index, {
			w: subPatches,
			A: entry
		});

		return;
	}

	// this key has already been removed or moved, a duplicate!
	_VirtualDom_removeNode(changes, localPatches, key + _VirtualDom_POSTFIX, vnode, index);
}



// ADD DOM NODES
//
// Each DOM node has an "index" assigned in order of traversal. It is important
// to minimize our crawl over the actual DOM, so these indexes (along with the
// descendantsCount of virtual nodes) let us skip touching entire subtrees of
// the DOM if we know there are no patches there.


function _VirtualDom_addDomNodes(domNode, vNode, patches, eventNode)
{
	_VirtualDom_addDomNodesHelp(domNode, vNode, patches, 0, 0, vNode.b, eventNode);
}


// assumes `patches` is non-empty and indexes increase monotonically.
function _VirtualDom_addDomNodesHelp(domNode, vNode, patches, i, low, high, eventNode)
{
	var patch = patches[i];
	var index = patch.r;

	while (index === low)
	{
		var patchType = patch.$;

		if (patchType === 1)
		{
			_VirtualDom_addDomNodes(domNode, vNode.k, patch.s, eventNode);
		}
		else if (patchType === 8)
		{
			patch.t = domNode;
			patch.u = eventNode;

			var subPatches = patch.s.w;
			if (subPatches.length > 0)
			{
				_VirtualDom_addDomNodesHelp(domNode, vNode, subPatches, 0, low, high, eventNode);
			}
		}
		else if (patchType === 9)
		{
			patch.t = domNode;
			patch.u = eventNode;

			var data = patch.s;
			if (data)
			{
				data.A.s = domNode;
				var subPatches = data.w;
				if (subPatches.length > 0)
				{
					_VirtualDom_addDomNodesHelp(domNode, vNode, subPatches, 0, low, high, eventNode);
				}
			}
		}
		else
		{
			patch.t = domNode;
			patch.u = eventNode;
		}

		i++;

		if (!(patch = patches[i]) || (index = patch.r) > high)
		{
			return i;
		}
	}

	var tag = vNode.$;

	if (tag === 4)
	{
		var subNode = vNode.k;

		while (subNode.$ === 4)
		{
			subNode = subNode.k;
		}

		return _VirtualDom_addDomNodesHelp(domNode, subNode, patches, i, low + 1, high, domNode.elm_event_node_ref);
	}

	// tag must be 1 or 2 at this point

	var vKids = vNode.e;
	var childNodes = domNode.childNodes;
	for (var j = 0; j < vKids.length; j++)
	{
		low++;
		var vKid = tag === 1 ? vKids[j] : vKids[j].b;
		var nextLow = low + (vKid.b || 0);
		if (low <= index && index <= nextLow)
		{
			i = _VirtualDom_addDomNodesHelp(childNodes[j], vKid, patches, i, low, nextLow, eventNode);
			if (!(patch = patches[i]) || (index = patch.r) > high)
			{
				return i;
			}
		}
		low = nextLow;
	}
	return i;
}



// APPLY PATCHES


function _VirtualDom_applyPatches(rootDomNode, oldVirtualNode, patches, eventNode)
{
	if (patches.length === 0)
	{
		return rootDomNode;
	}

	_VirtualDom_addDomNodes(rootDomNode, oldVirtualNode, patches, eventNode);
	return _VirtualDom_applyPatchesHelp(rootDomNode, patches);
}

function _VirtualDom_applyPatchesHelp(rootDomNode, patches)
{
	for (var i = 0; i < patches.length; i++)
	{
		var patch = patches[i];
		var localDomNode = patch.t
		var newNode = _VirtualDom_applyPatch(localDomNode, patch);
		if (localDomNode === rootDomNode)
		{
			rootDomNode = newNode;
		}
	}
	return rootDomNode;
}

function _VirtualDom_applyPatch(domNode, patch)
{
	switch (patch.$)
	{
		case 0:
			return _VirtualDom_applyPatchRedraw(domNode, patch.s, patch.u);

		case 4:
			_VirtualDom_applyFacts(domNode, patch.u, patch.s);
			return domNode;

		case 3:
			domNode.replaceData(0, domNode.length, patch.s);
			return domNode;

		case 1:
			return _VirtualDom_applyPatchesHelp(domNode, patch.s);

		case 2:
			if (domNode.elm_event_node_ref)
			{
				domNode.elm_event_node_ref.j = patch.s;
			}
			else
			{
				domNode.elm_event_node_ref = { j: patch.s, p: patch.u };
			}
			return domNode;

		case 6:
			var data = patch.s;
			for (var i = 0; i < data.i; i++)
			{
				domNode.removeChild(domNode.childNodes[data.v]);
			}
			return domNode;

		case 7:
			var data = patch.s;
			var kids = data.e;
			var i = data.v;
			var theEnd = domNode.childNodes[i];
			for (; i < kids.length; i++)
			{
				domNode.insertBefore(_VirtualDom_render(kids[i], patch.u), theEnd);
			}
			return domNode;

		case 9:
			var data = patch.s;
			if (!data)
			{
				domNode.parentNode.removeChild(domNode);
				return domNode;
			}
			var entry = data.A;
			if (typeof entry.r !== 'undefined')
			{
				domNode.parentNode.removeChild(domNode);
			}
			entry.s = _VirtualDom_applyPatchesHelp(domNode, data.w);
			return domNode;

		case 8:
			return _VirtualDom_applyPatchReorder(domNode, patch);

		case 5:
			return patch.s(domNode);

		default:
			_Debug_crash(10); // 'Ran into an unknown patch!'
	}
}


function _VirtualDom_applyPatchRedraw(domNode, vNode, eventNode)
{
	var parentNode = domNode.parentNode;
	var newNode = _VirtualDom_render(vNode, eventNode);

	if (!newNode.elm_event_node_ref)
	{
		newNode.elm_event_node_ref = domNode.elm_event_node_ref;
	}

	if (parentNode && newNode !== domNode)
	{
		parentNode.replaceChild(newNode, domNode);
	}
	return newNode;
}


function _VirtualDom_applyPatchReorder(domNode, patch)
{
	var data = patch.s;

	// remove end inserts
	var frag = _VirtualDom_applyPatchReorderEndInsertsHelp(data.y, patch);

	// removals
	domNode = _VirtualDom_applyPatchesHelp(domNode, data.w);

	// inserts
	var inserts = data.x;
	for (var i = 0; i < inserts.length; i++)
	{
		var insert = inserts[i];
		var entry = insert.A;
		var node = entry.c === 2
			? entry.s
			: _VirtualDom_render(entry.z, patch.u);
		domNode.insertBefore(node, domNode.childNodes[insert.r]);
	}

	// add end inserts
	if (frag)
	{
		_VirtualDom_appendChild(domNode, frag);
	}

	return domNode;
}


function _VirtualDom_applyPatchReorderEndInsertsHelp(endInserts, patch)
{
	if (!endInserts)
	{
		return;
	}

	var frag = _VirtualDom_doc.createDocumentFragment();
	for (var i = 0; i < endInserts.length; i++)
	{
		var insert = endInserts[i];
		var entry = insert.A;
		_VirtualDom_appendChild(frag, entry.c === 2
			? entry.s
			: _VirtualDom_render(entry.z, patch.u)
		);
	}
	return frag;
}


function _VirtualDom_virtualize(node)
{
	// TEXT NODES

	if (node.nodeType === 3)
	{
		return _VirtualDom_text(node.textContent);
	}


	// WEIRD NODES

	if (node.nodeType !== 1)
	{
		return _VirtualDom_text('');
	}


	// ELEMENT NODES

	var attrList = _List_Nil;
	var attrs = node.attributes;
	for (var i = attrs.length; i--; )
	{
		var attr = attrs[i];
		var name = attr.name;
		var value = attr.value;
		attrList = _List_Cons( A2(_VirtualDom_attribute, name, value), attrList );
	}

	var tag = node.tagName.toLowerCase();
	var kidList = _List_Nil;
	var kids = node.childNodes;

	for (var i = kids.length; i--; )
	{
		kidList = _List_Cons(_VirtualDom_virtualize(kids[i]), kidList);
	}
	return A3(_VirtualDom_node, tag, attrList, kidList);
}

function _VirtualDom_dekey(keyedNode)
{
	var keyedKids = keyedNode.e;
	var len = keyedKids.length;
	var kids = new Array(len);
	for (var i = 0; i < len; i++)
	{
		kids[i] = keyedKids[i].b;
	}

	return {
		$: 1,
		c: keyedNode.c,
		d: keyedNode.d,
		e: kids,
		f: keyedNode.f,
		b: keyedNode.b
	};
}




// ELEMENT


var _Debugger_element;

var _Browser_element = _Debugger_element || F4(function(impl, flagDecoder, debugMetadata, args)
{
	return _Platform_initialize(
		flagDecoder,
		args,
		impl.init,
		impl.update,
		impl.subscriptions,
		function(sendToApp, initialModel) {
			var view = impl.view;
			/**_UNUSED/
			var domNode = args['node'];
			//*/
			/**/
			var domNode = args && args['node'] ? args['node'] : _Debug_crash(0);
			//*/
			var currNode = _VirtualDom_virtualize(domNode);

			return _Browser_makeAnimator(initialModel, function(model)
			{
				var nextNode = view(model);
				var patches = _VirtualDom_diff(currNode, nextNode);
				domNode = _VirtualDom_applyPatches(domNode, currNode, patches, sendToApp);
				currNode = nextNode;
			});
		}
	);
});



// DOCUMENT


var _Debugger_document;

var _Browser_document = _Debugger_document || F4(function(impl, flagDecoder, debugMetadata, args)
{
	return _Platform_initialize(
		flagDecoder,
		args,
		impl.init,
		impl.update,
		impl.subscriptions,
		function(sendToApp, initialModel) {
			var divertHrefToApp = impl.setup && impl.setup(sendToApp)
			var view = impl.view;
			var title = _VirtualDom_doc.title;
			var bodyNode = _VirtualDom_doc.body;
			var currNode = _VirtualDom_virtualize(bodyNode);
			return _Browser_makeAnimator(initialModel, function(model)
			{
				_VirtualDom_divertHrefToApp = divertHrefToApp;
				var doc = view(model);
				var nextNode = _VirtualDom_node('body')(_List_Nil)(doc.body);
				var patches = _VirtualDom_diff(currNode, nextNode);
				bodyNode = _VirtualDom_applyPatches(bodyNode, currNode, patches, sendToApp);
				currNode = nextNode;
				_VirtualDom_divertHrefToApp = 0;
				(title !== doc.title) && (_VirtualDom_doc.title = title = doc.title);
			});
		}
	);
});



// ANIMATION


var _Browser_cancelAnimationFrame =
	typeof cancelAnimationFrame !== 'undefined'
		? cancelAnimationFrame
		: function(id) { clearTimeout(id); };

var _Browser_requestAnimationFrame =
	typeof requestAnimationFrame !== 'undefined'
		? requestAnimationFrame
		: function(callback) { return setTimeout(callback, 1000 / 60); };


function _Browser_makeAnimator(model, draw)
{
	draw(model);

	var state = 0;

	function updateIfNeeded()
	{
		state = state === 1
			? 0
			: ( _Browser_requestAnimationFrame(updateIfNeeded), draw(model), 1 );
	}

	return function(nextModel, isSync)
	{
		model = nextModel;

		isSync
			? ( draw(model),
				state === 2 && (state = 1)
				)
			: ( state === 0 && _Browser_requestAnimationFrame(updateIfNeeded),
				state = 2
				);
	};
}



// APPLICATION


function _Browser_application(impl)
{
	var onUrlChange = impl.onUrlChange;
	var onUrlRequest = impl.onUrlRequest;
	var key = function() { key.a(onUrlChange(_Browser_getUrl())); };

	return _Browser_document({
		setup: function(sendToApp)
		{
			key.a = sendToApp;
			_Browser_window.addEventListener('popstate', key);
			_Browser_window.navigator.userAgent.indexOf('Trident') < 0 || _Browser_window.addEventListener('hashchange', key);

			return F2(function(domNode, event)
			{
				if (!event.ctrlKey && !event.metaKey && !event.shiftKey && event.button < 1 && !domNode.target && !domNode.hasAttribute('download'))
				{
					event.preventDefault();
					var href = domNode.href;
					var curr = _Browser_getUrl();
					var next = $elm$url$Url$fromString(href).a;
					sendToApp(onUrlRequest(
						(next
							&& curr.protocol === next.protocol
							&& curr.host === next.host
							&& curr.port_.a === next.port_.a
						)
							? $elm$browser$Browser$Internal(next)
							: $elm$browser$Browser$External(href)
					));
				}
			});
		},
		init: function(flags)
		{
			return A3(impl.init, flags, _Browser_getUrl(), key);
		},
		view: impl.view,
		update: impl.update,
		subscriptions: impl.subscriptions
	});
}

function _Browser_getUrl()
{
	return $elm$url$Url$fromString(_VirtualDom_doc.location.href).a || _Debug_crash(1);
}

var _Browser_go = F2(function(key, n)
{
	return A2($elm$core$Task$perform, $elm$core$Basics$never, _Scheduler_binding(function() {
		n && history.go(n);
		key();
	}));
});

var _Browser_pushUrl = F2(function(key, url)
{
	return A2($elm$core$Task$perform, $elm$core$Basics$never, _Scheduler_binding(function() {
		history.pushState({}, '', url);
		key();
	}));
});

var _Browser_replaceUrl = F2(function(key, url)
{
	return A2($elm$core$Task$perform, $elm$core$Basics$never, _Scheduler_binding(function() {
		history.replaceState({}, '', url);
		key();
	}));
});



// GLOBAL EVENTS


var _Browser_fakeNode = { addEventListener: function() {}, removeEventListener: function() {} };
var _Browser_doc = typeof document !== 'undefined' ? document : _Browser_fakeNode;
var _Browser_window = typeof window !== 'undefined' ? window : _Browser_fakeNode;

var _Browser_on = F3(function(node, eventName, sendToSelf)
{
	return _Scheduler_spawn(_Scheduler_binding(function(callback)
	{
		function handler(event)	{ _Scheduler_rawSpawn(sendToSelf(event)); }
		node.addEventListener(eventName, handler, _VirtualDom_passiveSupported && { passive: true });
		return function() { node.removeEventListener(eventName, handler); };
	}));
});

var _Browser_decodeEvent = F2(function(decoder, event)
{
	var result = _Json_runHelp(decoder, event);
	return $elm$core$Result$isOk(result) ? $elm$core$Maybe$Just(result.a) : $elm$core$Maybe$Nothing;
});



// PAGE VISIBILITY


function _Browser_visibilityInfo()
{
	return (typeof _VirtualDom_doc.hidden !== 'undefined')
		? { hidden: 'hidden', change: 'visibilitychange' }
		:
	(typeof _VirtualDom_doc.mozHidden !== 'undefined')
		? { hidden: 'mozHidden', change: 'mozvisibilitychange' }
		:
	(typeof _VirtualDom_doc.msHidden !== 'undefined')
		? { hidden: 'msHidden', change: 'msvisibilitychange' }
		:
	(typeof _VirtualDom_doc.webkitHidden !== 'undefined')
		? { hidden: 'webkitHidden', change: 'webkitvisibilitychange' }
		: { hidden: 'hidden', change: 'visibilitychange' };
}



// ANIMATION FRAMES


function _Browser_rAF()
{
	return _Scheduler_binding(function(callback)
	{
		var id = _Browser_requestAnimationFrame(function() {
			callback(_Scheduler_succeed(Date.now()));
		});

		return function() {
			_Browser_cancelAnimationFrame(id);
		};
	});
}


function _Browser_now()
{
	return _Scheduler_binding(function(callback)
	{
		callback(_Scheduler_succeed(Date.now()));
	});
}



// DOM STUFF


function _Browser_withNode(id, doStuff)
{
	return _Scheduler_binding(function(callback)
	{
		_Browser_requestAnimationFrame(function() {
			var node = document.getElementById(id);
			callback(node
				? _Scheduler_succeed(doStuff(node))
				: _Scheduler_fail($elm$browser$Browser$Dom$NotFound(id))
			);
		});
	});
}


function _Browser_withWindow(doStuff)
{
	return _Scheduler_binding(function(callback)
	{
		_Browser_requestAnimationFrame(function() {
			callback(_Scheduler_succeed(doStuff()));
		});
	});
}


// FOCUS and BLUR


var _Browser_call = F2(function(functionName, id)
{
	return _Browser_withNode(id, function(node) {
		node[functionName]();
		return _Utils_Tuple0;
	});
});



// WINDOW VIEWPORT


function _Browser_getViewport()
{
	return {
		scene: _Browser_getScene(),
		viewport: {
			x: _Browser_window.pageXOffset,
			y: _Browser_window.pageYOffset,
			width: _Browser_doc.documentElement.clientWidth,
			height: _Browser_doc.documentElement.clientHeight
		}
	};
}

function _Browser_getScene()
{
	var body = _Browser_doc.body;
	var elem = _Browser_doc.documentElement;
	return {
		width: Math.max(body.scrollWidth, body.offsetWidth, elem.scrollWidth, elem.offsetWidth, elem.clientWidth),
		height: Math.max(body.scrollHeight, body.offsetHeight, elem.scrollHeight, elem.offsetHeight, elem.clientHeight)
	};
}

var _Browser_setViewport = F2(function(x, y)
{
	return _Browser_withWindow(function()
	{
		_Browser_window.scroll(x, y);
		return _Utils_Tuple0;
	});
});



// ELEMENT VIEWPORT


function _Browser_getViewportOf(id)
{
	return _Browser_withNode(id, function(node)
	{
		return {
			scene: {
				width: node.scrollWidth,
				height: node.scrollHeight
			},
			viewport: {
				x: node.scrollLeft,
				y: node.scrollTop,
				width: node.clientWidth,
				height: node.clientHeight
			}
		};
	});
}


var _Browser_setViewportOf = F3(function(id, x, y)
{
	return _Browser_withNode(id, function(node)
	{
		node.scrollLeft = x;
		node.scrollTop = y;
		return _Utils_Tuple0;
	});
});



// ELEMENT


function _Browser_getElement(id)
{
	return _Browser_withNode(id, function(node)
	{
		var rect = node.getBoundingClientRect();
		var x = _Browser_window.pageXOffset;
		var y = _Browser_window.pageYOffset;
		return {
			scene: _Browser_getScene(),
			viewport: {
				x: x,
				y: y,
				width: _Browser_doc.documentElement.clientWidth,
				height: _Browser_doc.documentElement.clientHeight
			},
			element: {
				x: x + rect.left,
				y: y + rect.top,
				width: rect.width,
				height: rect.height
			}
		};
	});
}



// LOAD and RELOAD


function _Browser_reload(skipCache)
{
	return A2($elm$core$Task$perform, $elm$core$Basics$never, _Scheduler_binding(function(callback)
	{
		_VirtualDom_doc.location.reload(skipCache);
	}));
}

function _Browser_load(url)
{
	return A2($elm$core$Task$perform, $elm$core$Basics$never, _Scheduler_binding(function(callback)
	{
		try
		{
			_Browser_window.location = url;
		}
		catch(err)
		{
			// Only Firefox can throw a NS_ERROR_MALFORMED_URI exception here.
			// Other browsers reload the page, so let's be consistent about that.
			_VirtualDom_doc.location.reload(false);
		}
	}));
}


function _Url_percentEncode(string)
{
	return encodeURIComponent(string);
}

function _Url_percentDecode(string)
{
	try
	{
		return $elm$core$Maybe$Just(decodeURIComponent(string));
	}
	catch (e)
	{
		return $elm$core$Maybe$Nothing;
	}
}


var _Bitwise_and = F2(function(a, b)
{
	return a & b;
});

var _Bitwise_or = F2(function(a, b)
{
	return a | b;
});

var _Bitwise_xor = F2(function(a, b)
{
	return a ^ b;
});

function _Bitwise_complement(a)
{
	return ~a;
};

var _Bitwise_shiftLeftBy = F2(function(offset, a)
{
	return a << offset;
});

var _Bitwise_shiftRightBy = F2(function(offset, a)
{
	return a >> offset;
});

var _Bitwise_shiftRightZfBy = F2(function(offset, a)
{
	return a >>> offset;
});




// STRINGS


var _Parser_isSubString = F5(function(smallString, offset, row, col, bigString)
{
	var smallLength = smallString.length;
	var isGood = offset + smallLength <= bigString.length;

	for (var i = 0; isGood && i < smallLength; )
	{
		var code = bigString.charCodeAt(offset);
		isGood =
			smallString[i++] === bigString[offset++]
			&& (
				code === 0x000A /* \n */
					? ( row++, col=1 )
					: ( col++, (code & 0xF800) === 0xD800 ? smallString[i++] === bigString[offset++] : 1 )
			)
	}

	return _Utils_Tuple3(isGood ? offset : -1, row, col);
});



// CHARS


var _Parser_isSubChar = F3(function(predicate, offset, string)
{
	return (
		string.length <= offset
			? -1
			:
		(string.charCodeAt(offset) & 0xF800) === 0xD800
			? (predicate(_Utils_chr(string.substr(offset, 2))) ? offset + 2 : -1)
			:
		(predicate(_Utils_chr(string[offset]))
			? ((string[offset] === '\n') ? -2 : (offset + 1))
			: -1
		)
	);
});


var _Parser_isAsciiCode = F3(function(code, offset, string)
{
	return string.charCodeAt(offset) === code;
});



// NUMBERS


var _Parser_chompBase10 = F2(function(offset, string)
{
	for (; offset < string.length; offset++)
	{
		var code = string.charCodeAt(offset);
		if (code < 0x30 || 0x39 < code)
		{
			return offset;
		}
	}
	return offset;
});


var _Parser_consumeBase = F3(function(base, offset, string)
{
	for (var total = 0; offset < string.length; offset++)
	{
		var digit = string.charCodeAt(offset) - 0x30;
		if (digit < 0 || base <= digit) break;
		total = base * total + digit;
	}
	return _Utils_Tuple2(offset, total);
});


var _Parser_consumeBase16 = F2(function(offset, string)
{
	for (var total = 0; offset < string.length; offset++)
	{
		var code = string.charCodeAt(offset);
		if (0x30 <= code && code <= 0x39)
		{
			total = 16 * total + code - 0x30;
		}
		else if (0x41 <= code && code <= 0x46)
		{
			total = 16 * total + code - 55;
		}
		else if (0x61 <= code && code <= 0x66)
		{
			total = 16 * total + code - 87;
		}
		else
		{
			break;
		}
	}
	return _Utils_Tuple2(offset, total);
});



// FIND STRING


var _Parser_findSubString = F5(function(smallString, offset, row, col, bigString)
{
	var newOffset = bigString.indexOf(smallString, offset);
	var target = newOffset < 0 ? bigString.length : newOffset + smallString.length;

	while (offset < target)
	{
		var code = bigString.charCodeAt(offset++);
		code === 0x000A /* \n */
			? ( col=1, row++ )
			: ( col++, (code & 0xF800) === 0xD800 && offset++ )
	}

	return _Utils_Tuple3(newOffset, row, col);
});
var $author$project$Main$ChangedUrl = function (a) {
	return {$: 'ChangedUrl', a: a};
};
var $author$project$Main$ClickedLink = function (a) {
	return {$: 'ClickedLink', a: a};
};
var $elm$core$Basics$EQ = {$: 'EQ'};
var $elm$core$Basics$GT = {$: 'GT'};
var $elm$core$Basics$LT = {$: 'LT'};
var $elm$core$List$cons = _List_cons;
var $elm$core$Dict$foldr = F3(
	function (func, acc, t) {
		foldr:
		while (true) {
			if (t.$ === 'RBEmpty_elm_builtin') {
				return acc;
			} else {
				var key = t.b;
				var value = t.c;
				var left = t.d;
				var right = t.e;
				var $temp$func = func,
					$temp$acc = A3(
					func,
					key,
					value,
					A3($elm$core$Dict$foldr, func, acc, right)),
					$temp$t = left;
				func = $temp$func;
				acc = $temp$acc;
				t = $temp$t;
				continue foldr;
			}
		}
	});
var $elm$core$Dict$toList = function (dict) {
	return A3(
		$elm$core$Dict$foldr,
		F3(
			function (key, value, list) {
				return A2(
					$elm$core$List$cons,
					_Utils_Tuple2(key, value),
					list);
			}),
		_List_Nil,
		dict);
};
var $elm$core$Dict$keys = function (dict) {
	return A3(
		$elm$core$Dict$foldr,
		F3(
			function (key, value, keyList) {
				return A2($elm$core$List$cons, key, keyList);
			}),
		_List_Nil,
		dict);
};
var $elm$core$Set$toList = function (_v0) {
	var dict = _v0.a;
	return $elm$core$Dict$keys(dict);
};
var $elm$core$Elm$JsArray$foldr = _JsArray_foldr;
var $elm$core$Array$foldr = F3(
	function (func, baseCase, _v0) {
		var tree = _v0.c;
		var tail = _v0.d;
		var helper = F2(
			function (node, acc) {
				if (node.$ === 'SubTree') {
					var subTree = node.a;
					return A3($elm$core$Elm$JsArray$foldr, helper, acc, subTree);
				} else {
					var values = node.a;
					return A3($elm$core$Elm$JsArray$foldr, func, acc, values);
				}
			});
		return A3(
			$elm$core$Elm$JsArray$foldr,
			helper,
			A3($elm$core$Elm$JsArray$foldr, func, baseCase, tail),
			tree);
	});
var $elm$core$Array$toList = function (array) {
	return A3($elm$core$Array$foldr, $elm$core$List$cons, _List_Nil, array);
};
var $elm$core$Result$Err = function (a) {
	return {$: 'Err', a: a};
};
var $elm$json$Json$Decode$Failure = F2(
	function (a, b) {
		return {$: 'Failure', a: a, b: b};
	});
var $elm$json$Json$Decode$Field = F2(
	function (a, b) {
		return {$: 'Field', a: a, b: b};
	});
var $elm$json$Json$Decode$Index = F2(
	function (a, b) {
		return {$: 'Index', a: a, b: b};
	});
var $elm$core$Result$Ok = function (a) {
	return {$: 'Ok', a: a};
};
var $elm$json$Json$Decode$OneOf = function (a) {
	return {$: 'OneOf', a: a};
};
var $elm$core$Basics$False = {$: 'False'};
var $elm$core$Basics$add = _Basics_add;
var $elm$core$Maybe$Just = function (a) {
	return {$: 'Just', a: a};
};
var $elm$core$Maybe$Nothing = {$: 'Nothing'};
var $elm$core$String$all = _String_all;
var $elm$core$Basics$and = _Basics_and;
var $elm$core$Basics$append = _Utils_append;
var $elm$json$Json$Encode$encode = _Json_encode;
var $elm$core$String$fromInt = _String_fromNumber;
var $elm$core$String$join = F2(
	function (sep, chunks) {
		return A2(
			_String_join,
			sep,
			_List_toArray(chunks));
	});
var $elm$core$String$split = F2(
	function (sep, string) {
		return _List_fromArray(
			A2(_String_split, sep, string));
	});
var $elm$json$Json$Decode$indent = function (str) {
	return A2(
		$elm$core$String$join,
		'\n    ',
		A2($elm$core$String$split, '\n', str));
};
var $elm$core$List$foldl = F3(
	function (func, acc, list) {
		foldl:
		while (true) {
			if (!list.b) {
				return acc;
			} else {
				var x = list.a;
				var xs = list.b;
				var $temp$func = func,
					$temp$acc = A2(func, x, acc),
					$temp$list = xs;
				func = $temp$func;
				acc = $temp$acc;
				list = $temp$list;
				continue foldl;
			}
		}
	});
var $elm$core$List$length = function (xs) {
	return A3(
		$elm$core$List$foldl,
		F2(
			function (_v0, i) {
				return i + 1;
			}),
		0,
		xs);
};
var $elm$core$List$map2 = _List_map2;
var $elm$core$Basics$le = _Utils_le;
var $elm$core$Basics$sub = _Basics_sub;
var $elm$core$List$rangeHelp = F3(
	function (lo, hi, list) {
		rangeHelp:
		while (true) {
			if (_Utils_cmp(lo, hi) < 1) {
				var $temp$lo = lo,
					$temp$hi = hi - 1,
					$temp$list = A2($elm$core$List$cons, hi, list);
				lo = $temp$lo;
				hi = $temp$hi;
				list = $temp$list;
				continue rangeHelp;
			} else {
				return list;
			}
		}
	});
var $elm$core$List$range = F2(
	function (lo, hi) {
		return A3($elm$core$List$rangeHelp, lo, hi, _List_Nil);
	});
var $elm$core$List$indexedMap = F2(
	function (f, xs) {
		return A3(
			$elm$core$List$map2,
			f,
			A2(
				$elm$core$List$range,
				0,
				$elm$core$List$length(xs) - 1),
			xs);
	});
var $elm$core$Char$toCode = _Char_toCode;
var $elm$core$Char$isLower = function (_char) {
	var code = $elm$core$Char$toCode(_char);
	return (97 <= code) && (code <= 122);
};
var $elm$core$Char$isUpper = function (_char) {
	var code = $elm$core$Char$toCode(_char);
	return (code <= 90) && (65 <= code);
};
var $elm$core$Basics$or = _Basics_or;
var $elm$core$Char$isAlpha = function (_char) {
	return $elm$core$Char$isLower(_char) || $elm$core$Char$isUpper(_char);
};
var $elm$core$Char$isDigit = function (_char) {
	var code = $elm$core$Char$toCode(_char);
	return (code <= 57) && (48 <= code);
};
var $elm$core$Char$isAlphaNum = function (_char) {
	return $elm$core$Char$isLower(_char) || ($elm$core$Char$isUpper(_char) || $elm$core$Char$isDigit(_char));
};
var $elm$core$List$reverse = function (list) {
	return A3($elm$core$List$foldl, $elm$core$List$cons, _List_Nil, list);
};
var $elm$core$String$uncons = _String_uncons;
var $elm$json$Json$Decode$errorOneOf = F2(
	function (i, error) {
		return '\n\n(' + ($elm$core$String$fromInt(i + 1) + (') ' + $elm$json$Json$Decode$indent(
			$elm$json$Json$Decode$errorToString(error))));
	});
var $elm$json$Json$Decode$errorToString = function (error) {
	return A2($elm$json$Json$Decode$errorToStringHelp, error, _List_Nil);
};
var $elm$json$Json$Decode$errorToStringHelp = F2(
	function (error, context) {
		errorToStringHelp:
		while (true) {
			switch (error.$) {
				case 'Field':
					var f = error.a;
					var err = error.b;
					var isSimple = function () {
						var _v1 = $elm$core$String$uncons(f);
						if (_v1.$ === 'Nothing') {
							return false;
						} else {
							var _v2 = _v1.a;
							var _char = _v2.a;
							var rest = _v2.b;
							return $elm$core$Char$isAlpha(_char) && A2($elm$core$String$all, $elm$core$Char$isAlphaNum, rest);
						}
					}();
					var fieldName = isSimple ? ('.' + f) : ('[\'' + (f + '\']'));
					var $temp$error = err,
						$temp$context = A2($elm$core$List$cons, fieldName, context);
					error = $temp$error;
					context = $temp$context;
					continue errorToStringHelp;
				case 'Index':
					var i = error.a;
					var err = error.b;
					var indexName = '[' + ($elm$core$String$fromInt(i) + ']');
					var $temp$error = err,
						$temp$context = A2($elm$core$List$cons, indexName, context);
					error = $temp$error;
					context = $temp$context;
					continue errorToStringHelp;
				case 'OneOf':
					var errors = error.a;
					if (!errors.b) {
						return 'Ran into a Json.Decode.oneOf with no possibilities' + function () {
							if (!context.b) {
								return '!';
							} else {
								return ' at json' + A2(
									$elm$core$String$join,
									'',
									$elm$core$List$reverse(context));
							}
						}();
					} else {
						if (!errors.b.b) {
							var err = errors.a;
							var $temp$error = err,
								$temp$context = context;
							error = $temp$error;
							context = $temp$context;
							continue errorToStringHelp;
						} else {
							var starter = function () {
								if (!context.b) {
									return 'Json.Decode.oneOf';
								} else {
									return 'The Json.Decode.oneOf at json' + A2(
										$elm$core$String$join,
										'',
										$elm$core$List$reverse(context));
								}
							}();
							var introduction = starter + (' failed in the following ' + ($elm$core$String$fromInt(
								$elm$core$List$length(errors)) + ' ways:'));
							return A2(
								$elm$core$String$join,
								'\n\n',
								A2(
									$elm$core$List$cons,
									introduction,
									A2($elm$core$List$indexedMap, $elm$json$Json$Decode$errorOneOf, errors)));
						}
					}
				default:
					var msg = error.a;
					var json = error.b;
					var introduction = function () {
						if (!context.b) {
							return 'Problem with the given value:\n\n';
						} else {
							return 'Problem with the value at json' + (A2(
								$elm$core$String$join,
								'',
								$elm$core$List$reverse(context)) + ':\n\n    ');
						}
					}();
					return introduction + ($elm$json$Json$Decode$indent(
						A2($elm$json$Json$Encode$encode, 4, json)) + ('\n\n' + msg));
			}
		}
	});
var $elm$core$Array$branchFactor = 32;
var $elm$core$Array$Array_elm_builtin = F4(
	function (a, b, c, d) {
		return {$: 'Array_elm_builtin', a: a, b: b, c: c, d: d};
	});
var $elm$core$Elm$JsArray$empty = _JsArray_empty;
var $elm$core$Basics$ceiling = _Basics_ceiling;
var $elm$core$Basics$fdiv = _Basics_fdiv;
var $elm$core$Basics$logBase = F2(
	function (base, number) {
		return _Basics_log(number) / _Basics_log(base);
	});
var $elm$core$Basics$toFloat = _Basics_toFloat;
var $elm$core$Array$shiftStep = $elm$core$Basics$ceiling(
	A2($elm$core$Basics$logBase, 2, $elm$core$Array$branchFactor));
var $elm$core$Array$empty = A4($elm$core$Array$Array_elm_builtin, 0, $elm$core$Array$shiftStep, $elm$core$Elm$JsArray$empty, $elm$core$Elm$JsArray$empty);
var $elm$core$Elm$JsArray$initialize = _JsArray_initialize;
var $elm$core$Array$Leaf = function (a) {
	return {$: 'Leaf', a: a};
};
var $elm$core$Basics$apL = F2(
	function (f, x) {
		return f(x);
	});
var $elm$core$Basics$apR = F2(
	function (x, f) {
		return f(x);
	});
var $elm$core$Basics$eq = _Utils_equal;
var $elm$core$Basics$floor = _Basics_floor;
var $elm$core$Elm$JsArray$length = _JsArray_length;
var $elm$core$Basics$gt = _Utils_gt;
var $elm$core$Basics$max = F2(
	function (x, y) {
		return (_Utils_cmp(x, y) > 0) ? x : y;
	});
var $elm$core$Basics$mul = _Basics_mul;
var $elm$core$Array$SubTree = function (a) {
	return {$: 'SubTree', a: a};
};
var $elm$core$Elm$JsArray$initializeFromList = _JsArray_initializeFromList;
var $elm$core$Array$compressNodes = F2(
	function (nodes, acc) {
		compressNodes:
		while (true) {
			var _v0 = A2($elm$core$Elm$JsArray$initializeFromList, $elm$core$Array$branchFactor, nodes);
			var node = _v0.a;
			var remainingNodes = _v0.b;
			var newAcc = A2(
				$elm$core$List$cons,
				$elm$core$Array$SubTree(node),
				acc);
			if (!remainingNodes.b) {
				return $elm$core$List$reverse(newAcc);
			} else {
				var $temp$nodes = remainingNodes,
					$temp$acc = newAcc;
				nodes = $temp$nodes;
				acc = $temp$acc;
				continue compressNodes;
			}
		}
	});
var $elm$core$Tuple$first = function (_v0) {
	var x = _v0.a;
	return x;
};
var $elm$core$Array$treeFromBuilder = F2(
	function (nodeList, nodeListSize) {
		treeFromBuilder:
		while (true) {
			var newNodeSize = $elm$core$Basics$ceiling(nodeListSize / $elm$core$Array$branchFactor);
			if (newNodeSize === 1) {
				return A2($elm$core$Elm$JsArray$initializeFromList, $elm$core$Array$branchFactor, nodeList).a;
			} else {
				var $temp$nodeList = A2($elm$core$Array$compressNodes, nodeList, _List_Nil),
					$temp$nodeListSize = newNodeSize;
				nodeList = $temp$nodeList;
				nodeListSize = $temp$nodeListSize;
				continue treeFromBuilder;
			}
		}
	});
var $elm$core$Array$builderToArray = F2(
	function (reverseNodeList, builder) {
		if (!builder.nodeListSize) {
			return A4(
				$elm$core$Array$Array_elm_builtin,
				$elm$core$Elm$JsArray$length(builder.tail),
				$elm$core$Array$shiftStep,
				$elm$core$Elm$JsArray$empty,
				builder.tail);
		} else {
			var treeLen = builder.nodeListSize * $elm$core$Array$branchFactor;
			var depth = $elm$core$Basics$floor(
				A2($elm$core$Basics$logBase, $elm$core$Array$branchFactor, treeLen - 1));
			var correctNodeList = reverseNodeList ? $elm$core$List$reverse(builder.nodeList) : builder.nodeList;
			var tree = A2($elm$core$Array$treeFromBuilder, correctNodeList, builder.nodeListSize);
			return A4(
				$elm$core$Array$Array_elm_builtin,
				$elm$core$Elm$JsArray$length(builder.tail) + treeLen,
				A2($elm$core$Basics$max, 5, depth * $elm$core$Array$shiftStep),
				tree,
				builder.tail);
		}
	});
var $elm$core$Basics$idiv = _Basics_idiv;
var $elm$core$Basics$lt = _Utils_lt;
var $elm$core$Array$initializeHelp = F5(
	function (fn, fromIndex, len, nodeList, tail) {
		initializeHelp:
		while (true) {
			if (fromIndex < 0) {
				return A2(
					$elm$core$Array$builderToArray,
					false,
					{nodeList: nodeList, nodeListSize: (len / $elm$core$Array$branchFactor) | 0, tail: tail});
			} else {
				var leaf = $elm$core$Array$Leaf(
					A3($elm$core$Elm$JsArray$initialize, $elm$core$Array$branchFactor, fromIndex, fn));
				var $temp$fn = fn,
					$temp$fromIndex = fromIndex - $elm$core$Array$branchFactor,
					$temp$len = len,
					$temp$nodeList = A2($elm$core$List$cons, leaf, nodeList),
					$temp$tail = tail;
				fn = $temp$fn;
				fromIndex = $temp$fromIndex;
				len = $temp$len;
				nodeList = $temp$nodeList;
				tail = $temp$tail;
				continue initializeHelp;
			}
		}
	});
var $elm$core$Basics$remainderBy = _Basics_remainderBy;
var $elm$core$Array$initialize = F2(
	function (len, fn) {
		if (len <= 0) {
			return $elm$core$Array$empty;
		} else {
			var tailLen = len % $elm$core$Array$branchFactor;
			var tail = A3($elm$core$Elm$JsArray$initialize, tailLen, len - tailLen, fn);
			var initialFromIndex = (len - tailLen) - $elm$core$Array$branchFactor;
			return A5($elm$core$Array$initializeHelp, fn, initialFromIndex, len, _List_Nil, tail);
		}
	});
var $elm$core$Basics$True = {$: 'True'};
var $elm$core$Result$isOk = function (result) {
	if (result.$ === 'Ok') {
		return true;
	} else {
		return false;
	}
};
var $elm$json$Json$Decode$map = _Json_map1;
var $elm$json$Json$Decode$map2 = _Json_map2;
var $elm$json$Json$Decode$succeed = _Json_succeed;
var $elm$virtual_dom$VirtualDom$toHandlerInt = function (handler) {
	switch (handler.$) {
		case 'Normal':
			return 0;
		case 'MayStopPropagation':
			return 1;
		case 'MayPreventDefault':
			return 2;
		default:
			return 3;
	}
};
var $elm$browser$Browser$External = function (a) {
	return {$: 'External', a: a};
};
var $elm$browser$Browser$Internal = function (a) {
	return {$: 'Internal', a: a};
};
var $elm$core$Basics$identity = function (x) {
	return x;
};
var $elm$browser$Browser$Dom$NotFound = function (a) {
	return {$: 'NotFound', a: a};
};
var $elm$url$Url$Http = {$: 'Http'};
var $elm$url$Url$Https = {$: 'Https'};
var $elm$url$Url$Url = F6(
	function (protocol, host, port_, path, query, fragment) {
		return {fragment: fragment, host: host, path: path, port_: port_, protocol: protocol, query: query};
	});
var $elm$core$String$contains = _String_contains;
var $elm$core$String$length = _String_length;
var $elm$core$String$slice = _String_slice;
var $elm$core$String$dropLeft = F2(
	function (n, string) {
		return (n < 1) ? string : A3(
			$elm$core$String$slice,
			n,
			$elm$core$String$length(string),
			string);
	});
var $elm$core$String$indexes = _String_indexes;
var $elm$core$String$isEmpty = function (string) {
	return string === '';
};
var $elm$core$String$left = F2(
	function (n, string) {
		return (n < 1) ? '' : A3($elm$core$String$slice, 0, n, string);
	});
var $elm$core$String$toInt = _String_toInt;
var $elm$url$Url$chompBeforePath = F5(
	function (protocol, path, params, frag, str) {
		if ($elm$core$String$isEmpty(str) || A2($elm$core$String$contains, '@', str)) {
			return $elm$core$Maybe$Nothing;
		} else {
			var _v0 = A2($elm$core$String$indexes, ':', str);
			if (!_v0.b) {
				return $elm$core$Maybe$Just(
					A6($elm$url$Url$Url, protocol, str, $elm$core$Maybe$Nothing, path, params, frag));
			} else {
				if (!_v0.b.b) {
					var i = _v0.a;
					var _v1 = $elm$core$String$toInt(
						A2($elm$core$String$dropLeft, i + 1, str));
					if (_v1.$ === 'Nothing') {
						return $elm$core$Maybe$Nothing;
					} else {
						var port_ = _v1;
						return $elm$core$Maybe$Just(
							A6(
								$elm$url$Url$Url,
								protocol,
								A2($elm$core$String$left, i, str),
								port_,
								path,
								params,
								frag));
					}
				} else {
					return $elm$core$Maybe$Nothing;
				}
			}
		}
	});
var $elm$url$Url$chompBeforeQuery = F4(
	function (protocol, params, frag, str) {
		if ($elm$core$String$isEmpty(str)) {
			return $elm$core$Maybe$Nothing;
		} else {
			var _v0 = A2($elm$core$String$indexes, '/', str);
			if (!_v0.b) {
				return A5($elm$url$Url$chompBeforePath, protocol, '/', params, frag, str);
			} else {
				var i = _v0.a;
				return A5(
					$elm$url$Url$chompBeforePath,
					protocol,
					A2($elm$core$String$dropLeft, i, str),
					params,
					frag,
					A2($elm$core$String$left, i, str));
			}
		}
	});
var $elm$url$Url$chompBeforeFragment = F3(
	function (protocol, frag, str) {
		if ($elm$core$String$isEmpty(str)) {
			return $elm$core$Maybe$Nothing;
		} else {
			var _v0 = A2($elm$core$String$indexes, '?', str);
			if (!_v0.b) {
				return A4($elm$url$Url$chompBeforeQuery, protocol, $elm$core$Maybe$Nothing, frag, str);
			} else {
				var i = _v0.a;
				return A4(
					$elm$url$Url$chompBeforeQuery,
					protocol,
					$elm$core$Maybe$Just(
						A2($elm$core$String$dropLeft, i + 1, str)),
					frag,
					A2($elm$core$String$left, i, str));
			}
		}
	});
var $elm$url$Url$chompAfterProtocol = F2(
	function (protocol, str) {
		if ($elm$core$String$isEmpty(str)) {
			return $elm$core$Maybe$Nothing;
		} else {
			var _v0 = A2($elm$core$String$indexes, '#', str);
			if (!_v0.b) {
				return A3($elm$url$Url$chompBeforeFragment, protocol, $elm$core$Maybe$Nothing, str);
			} else {
				var i = _v0.a;
				return A3(
					$elm$url$Url$chompBeforeFragment,
					protocol,
					$elm$core$Maybe$Just(
						A2($elm$core$String$dropLeft, i + 1, str)),
					A2($elm$core$String$left, i, str));
			}
		}
	});
var $elm$core$String$startsWith = _String_startsWith;
var $elm$url$Url$fromString = function (str) {
	return A2($elm$core$String$startsWith, 'http://', str) ? A2(
		$elm$url$Url$chompAfterProtocol,
		$elm$url$Url$Http,
		A2($elm$core$String$dropLeft, 7, str)) : (A2($elm$core$String$startsWith, 'https://', str) ? A2(
		$elm$url$Url$chompAfterProtocol,
		$elm$url$Url$Https,
		A2($elm$core$String$dropLeft, 8, str)) : $elm$core$Maybe$Nothing);
};
var $elm$core$Basics$never = function (_v0) {
	never:
	while (true) {
		var nvr = _v0.a;
		var $temp$_v0 = nvr;
		_v0 = $temp$_v0;
		continue never;
	}
};
var $elm$core$Task$Perform = function (a) {
	return {$: 'Perform', a: a};
};
var $elm$core$Task$succeed = _Scheduler_succeed;
var $elm$core$Task$init = $elm$core$Task$succeed(_Utils_Tuple0);
var $elm$core$List$foldrHelper = F4(
	function (fn, acc, ctr, ls) {
		if (!ls.b) {
			return acc;
		} else {
			var a = ls.a;
			var r1 = ls.b;
			if (!r1.b) {
				return A2(fn, a, acc);
			} else {
				var b = r1.a;
				var r2 = r1.b;
				if (!r2.b) {
					return A2(
						fn,
						a,
						A2(fn, b, acc));
				} else {
					var c = r2.a;
					var r3 = r2.b;
					if (!r3.b) {
						return A2(
							fn,
							a,
							A2(
								fn,
								b,
								A2(fn, c, acc)));
					} else {
						var d = r3.a;
						var r4 = r3.b;
						var res = (ctr > 500) ? A3(
							$elm$core$List$foldl,
							fn,
							acc,
							$elm$core$List$reverse(r4)) : A4($elm$core$List$foldrHelper, fn, acc, ctr + 1, r4);
						return A2(
							fn,
							a,
							A2(
								fn,
								b,
								A2(
									fn,
									c,
									A2(fn, d, res))));
					}
				}
			}
		}
	});
var $elm$core$List$foldr = F3(
	function (fn, acc, ls) {
		return A4($elm$core$List$foldrHelper, fn, acc, 0, ls);
	});
var $elm$core$List$map = F2(
	function (f, xs) {
		return A3(
			$elm$core$List$foldr,
			F2(
				function (x, acc) {
					return A2(
						$elm$core$List$cons,
						f(x),
						acc);
				}),
			_List_Nil,
			xs);
	});
var $elm$core$Task$andThen = _Scheduler_andThen;
var $elm$core$Task$map = F2(
	function (func, taskA) {
		return A2(
			$elm$core$Task$andThen,
			function (a) {
				return $elm$core$Task$succeed(
					func(a));
			},
			taskA);
	});
var $elm$core$Task$map2 = F3(
	function (func, taskA, taskB) {
		return A2(
			$elm$core$Task$andThen,
			function (a) {
				return A2(
					$elm$core$Task$andThen,
					function (b) {
						return $elm$core$Task$succeed(
							A2(func, a, b));
					},
					taskB);
			},
			taskA);
	});
var $elm$core$Task$sequence = function (tasks) {
	return A3(
		$elm$core$List$foldr,
		$elm$core$Task$map2($elm$core$List$cons),
		$elm$core$Task$succeed(_List_Nil),
		tasks);
};
var $elm$core$Platform$sendToApp = _Platform_sendToApp;
var $elm$core$Task$spawnCmd = F2(
	function (router, _v0) {
		var task = _v0.a;
		return _Scheduler_spawn(
			A2(
				$elm$core$Task$andThen,
				$elm$core$Platform$sendToApp(router),
				task));
	});
var $elm$core$Task$onEffects = F3(
	function (router, commands, state) {
		return A2(
			$elm$core$Task$map,
			function (_v0) {
				return _Utils_Tuple0;
			},
			$elm$core$Task$sequence(
				A2(
					$elm$core$List$map,
					$elm$core$Task$spawnCmd(router),
					commands)));
	});
var $elm$core$Task$onSelfMsg = F3(
	function (_v0, _v1, _v2) {
		return $elm$core$Task$succeed(_Utils_Tuple0);
	});
var $elm$core$Task$cmdMap = F2(
	function (tagger, _v0) {
		var task = _v0.a;
		return $elm$core$Task$Perform(
			A2($elm$core$Task$map, tagger, task));
	});
_Platform_effectManagers['Task'] = _Platform_createManager($elm$core$Task$init, $elm$core$Task$onEffects, $elm$core$Task$onSelfMsg, $elm$core$Task$cmdMap);
var $elm$core$Task$command = _Platform_leaf('Task');
var $elm$core$Task$perform = F2(
	function (toMessage, task) {
		return $elm$core$Task$command(
			$elm$core$Task$Perform(
				A2($elm$core$Task$map, toMessage, task)));
	});
var $elm$browser$Browser$application = _Browser_application;
var $author$project$Main$Model = F3(
	function (navigation, session, page) {
		return {navigation: navigation, page: page, session: session};
	});
var $author$project$Main$Redirect = {$: 'Redirect'};
var $author$project$Main$Page_Administration = function (a) {
	return {$: 'Page_Administration', a: a};
};
var $author$project$Main$Page_Administration_Msg = function (a) {
	return {$: 'Page_Administration_Msg', a: a};
};
var $author$project$Main$Page_Documentation = function (a) {
	return {$: 'Page_Documentation', a: a};
};
var $author$project$Main$Page_Documentation_Msg = function (a) {
	return {$: 'Page_Documentation_Msg', a: a};
};
var $author$project$Main$Page_Example = function (a) {
	return {$: 'Page_Example', a: a};
};
var $author$project$Main$Page_Example_Msg = function (a) {
	return {$: 'Page_Example_Msg', a: a};
};
var $author$project$Main$Page_GettingStarted = function (a) {
	return {$: 'Page_GettingStarted', a: a};
};
var $author$project$Main$Page_GettingStarted_Msg = function (a) {
	return {$: 'Page_GettingStarted_Msg', a: a};
};
var $author$project$Main$Page_Home = function (a) {
	return {$: 'Page_Home', a: a};
};
var $author$project$Main$Page_Home_Msg = function (a) {
	return {$: 'Page_Home_Msg', a: a};
};
var $author$project$Main$Page_Section = function (a) {
	return {$: 'Page_Section', a: a};
};
var $author$project$Main$Page_Section_Msg = function (a) {
	return {$: 'Page_Section_Msg', a: a};
};
var $author$project$Page$Administration$exit = F2(
	function (model, session) {
		return session;
	});
var $author$project$Page$Documentation$exit = F2(
	function (model, session) {
		return session;
	});
var $author$project$Page$Example$exit = F2(
	function (model, session) {
		return session;
	});
var $author$project$Page$GettingStarted$exit = F2(
	function (model, session) {
		return session;
	});
var $author$project$Page$Home$exit = F2(
	function (model, session) {
		return _Utils_update(
			session,
			{window: model.window});
	});
var $author$project$Page$Section$exit = F2(
	function (model, session) {
		return session;
	});
var $author$project$Main$exit = function (model) {
	var _v0 = model.page;
	switch (_v0.$) {
		case 'Redirect':
			return model.session;
		case 'NotFound':
			return model.session;
		case 'Page_Home':
			var subModel = _v0.a;
			return A2($author$project$Page$Home$exit, subModel, model.session);
		case 'Page_Administration':
			var subModel = _v0.a;
			return A2($author$project$Page$Administration$exit, subModel, model.session);
		case 'Page_Documentation':
			var subModel = _v0.a;
			return A2($author$project$Page$Documentation$exit, subModel, model.session);
		case 'Page_Section':
			var subModel = _v0.a;
			return A2($author$project$Page$Section$exit, subModel, model.session);
		case 'Page_Example':
			var subModel = _v0.a;
			return A2($author$project$Page$Example$exit, subModel, model.session);
		default:
			var subModel = _v0.a;
			return A2($author$project$Page$GettingStarted$exit, subModel, model.session);
	}
};
var $author$project$Ui$Menu$init = {isOpen: false};
var $elm$core$Platform$Cmd$batch = _Platform_batch;
var $elm$core$Platform$Cmd$none = $elm$core$Platform$Cmd$batch(_List_Nil);
var $author$project$Page$Administration$init = F3(
	function (key, session, params) {
		return _Utils_Tuple2(
			{menu: $author$project$Ui$Menu$init, window: session.window},
			$elm$core$Platform$Cmd$none);
	});
var $author$project$Ui$Thumbnail$Group = F3(
	function (title, order, ids) {
		return {ids: ids, order: order, title: title};
	});
var $author$project$Examples$BarCharts__BarLabels = {$: 'BarCharts__BarLabels'};
var $author$project$Examples$BarCharts__Basic = {$: 'BarCharts__Basic'};
var $author$project$Examples$BarCharts__BinLabels = {$: 'BarCharts__BinLabels'};
var $author$project$Examples$BarCharts__BinLabelsAdvanced = {$: 'BarCharts__BinLabelsAdvanced'};
var $author$project$Examples$BarCharts__Borders = {$: 'BarCharts__Borders'};
var $author$project$Examples$BarCharts__Color = {$: 'BarCharts__Color'};
var $author$project$Examples$BarCharts__Corners = {$: 'BarCharts__Corners'};
var $author$project$Examples$BarCharts__DataDependent = {$: 'BarCharts__DataDependent'};
var $author$project$Examples$BarCharts__Gradient = {$: 'BarCharts__Gradient'};
var $author$project$Examples$BarCharts__Highlight = {$: 'BarCharts__Highlight'};
var $author$project$Examples$BarCharts__Histogram = {$: 'BarCharts__Histogram'};
var $author$project$Examples$BarCharts__Legends = {$: 'BarCharts__Legends'};
var $author$project$Examples$BarCharts__Margin = {$: 'BarCharts__Margin'};
var $author$project$Examples$BarCharts__Opacity = {$: 'BarCharts__Opacity'};
var $author$project$Examples$BarCharts__Pattern = {$: 'BarCharts__Pattern'};
var $author$project$Examples$BarCharts__Spacing = {$: 'BarCharts__Spacing'};
var $author$project$Examples$BarCharts__Stacked = {$: 'BarCharts__Stacked'};
var $author$project$Examples$BarCharts__Title = {$: 'BarCharts__Title'};
var $author$project$Examples$BarCharts__Tooltip = {$: 'BarCharts__Tooltip'};
var $author$project$Examples$BarCharts__TooltipBin = {$: 'BarCharts__TooltipBin'};
var $author$project$Examples$BarCharts__TooltipStack = {$: 'BarCharts__TooltipStack'};
var $author$project$Examples$BarCharts__Ungroup = {$: 'BarCharts__Ungroup'};
var $author$project$Examples$BarCharts__VariableWidth = {$: 'BarCharts__VariableWidth'};
var $author$project$Examples$Frame__Amount = {$: 'Frame__Amount'};
var $author$project$Examples$Frame__Arbitrary = {$: 'Frame__Arbitrary'};
var $author$project$Examples$Frame__AxisLength = {$: 'Frame__AxisLength'};
var $author$project$Examples$Frame__Background = {$: 'Frame__Background'};
var $author$project$Examples$Frame__Basic = {$: 'Frame__Basic'};
var $author$project$Examples$Frame__Color = {$: 'Frame__Color'};
var $author$project$Examples$Frame__Coordinates = {$: 'Frame__Coordinates'};
var $author$project$Examples$Frame__CustomElements = {$: 'Frame__CustomElements'};
var $author$project$Examples$Frame__CustomFormat = {$: 'Frame__CustomFormat'};
var $author$project$Examples$Frame__CustomLabels = {$: 'Frame__CustomLabels'};
var $author$project$Examples$Frame__Dimensions = {$: 'Frame__Dimensions'};
var $author$project$Examples$Frame__DotGrid = {$: 'Frame__DotGrid'};
var $author$project$Examples$Frame__Ellipsis = {$: 'Frame__Ellipsis'};
var $author$project$Examples$Frame__GridColor = {$: 'Frame__GridColor'};
var $author$project$Examples$Frame__GridFilter = {$: 'Frame__GridFilter'};
var $author$project$Examples$Frame__LabelWithLine = {$: 'Frame__LabelWithLine'};
var $author$project$Examples$Frame__Legends = {$: 'Frame__Legends'};
var $author$project$Examples$Frame__Lines = {$: 'Frame__Lines'};
var $author$project$Examples$Frame__Margin = {$: 'Frame__Margin'};
var $author$project$Examples$Frame__NoArrow = {$: 'Frame__NoArrow'};
var $author$project$Examples$Frame__Offset = {$: 'Frame__Offset'};
var $author$project$Examples$Frame__OnlyInts = {$: 'Frame__OnlyInts'};
var $author$project$Examples$Frame__Padding = {$: 'Frame__Padding'};
var $author$project$Examples$Frame__Position = {$: 'Frame__Position'};
var $author$project$Examples$Frame__Rect = {$: 'Frame__Rect'};
var $author$project$Examples$Frame__Times = {$: 'Frame__Times'};
var $author$project$Examples$Frame__Titles = {$: 'Frame__Titles'};
var $author$project$Examples$Frontpage__BasicArea = {$: 'Frontpage__BasicArea'};
var $author$project$Examples$Frontpage__BasicBar = {$: 'Frontpage__BasicBar'};
var $author$project$Examples$Frontpage__BasicBubble = {$: 'Frontpage__BasicBubble'};
var $author$project$Examples$Frontpage__BasicLine = {$: 'Frontpage__BasicLine'};
var $author$project$Examples$Frontpage__BasicNavigation = {$: 'Frontpage__BasicNavigation'};
var $author$project$Examples$Frontpage__BasicScatter = {$: 'Frontpage__BasicScatter'};
var $author$project$Examples$Frontpage__Concise = {$: 'Frontpage__Concise'};
var $author$project$Examples$Frontpage__Familiar = {$: 'Frontpage__Familiar'};
var $author$project$Examples$Interactivity__Background = {$: 'Interactivity__Background'};
var $author$project$Examples$Interactivity__BasicArea = {$: 'Interactivity__BasicArea'};
var $author$project$Examples$Interactivity__BasicBar = {$: 'Interactivity__BasicBar'};
var $author$project$Examples$Interactivity__BasicBin = {$: 'Interactivity__BasicBin'};
var $author$project$Examples$Interactivity__BasicLine = {$: 'Interactivity__BasicLine'};
var $author$project$Examples$Interactivity__BasicStack = {$: 'Interactivity__BasicStack'};
var $author$project$Examples$Interactivity__Border = {$: 'Interactivity__Border'};
var $author$project$Examples$Interactivity__ChangeContent = {$: 'Interactivity__ChangeContent'};
var $author$project$Examples$Interactivity__ChangeDot = {$: 'Interactivity__ChangeDot'};
var $author$project$Examples$Interactivity__ChangeName = {$: 'Interactivity__ChangeName'};
var $author$project$Examples$Interactivity__ChangeUnit = {$: 'Interactivity__ChangeUnit'};
var $author$project$Examples$Interactivity__Coordinates = {$: 'Interactivity__Coordinates'};
var $author$project$Examples$Interactivity__Direction = {$: 'Interactivity__Direction'};
var $author$project$Examples$Interactivity__DoubleSearch = {$: 'Interactivity__DoubleSearch'};
var $author$project$Examples$Interactivity__FilterSearch = {$: 'Interactivity__FilterSearch'};
var $author$project$Examples$Interactivity__Focal = {$: 'Interactivity__Focal'};
var $author$project$Examples$Interactivity__Multiple = {$: 'Interactivity__Multiple'};
var $author$project$Examples$Interactivity__NoArrow = {$: 'Interactivity__NoArrow'};
var $author$project$Examples$Interactivity__Offset = {$: 'Interactivity__Offset'};
var $author$project$Examples$Interactivity__TrickyTooltip = {$: 'Interactivity__TrickyTooltip'};
var $author$project$Examples$Interactivity__Zoom = {$: 'Interactivity__Zoom'};
var $author$project$Examples$Interactivity__ZoomAlt = {$: 'Interactivity__ZoomAlt'};
var $author$project$Examples$LineCharts__Area = {$: 'LineCharts__Area'};
var $author$project$Examples$LineCharts__Basic = {$: 'LineCharts__Basic'};
var $author$project$Examples$LineCharts__Color = {$: 'LineCharts__Color'};
var $author$project$Examples$LineCharts__Dashed = {$: 'LineCharts__Dashed'};
var $author$project$Examples$LineCharts__Dots = {$: 'LineCharts__Dots'};
var $author$project$Examples$LineCharts__Gradient = {$: 'LineCharts__Gradient'};
var $author$project$Examples$LineCharts__Labels = {$: 'LineCharts__Labels'};
var $author$project$Examples$LineCharts__Legends = {$: 'LineCharts__Legends'};
var $author$project$Examples$LineCharts__Missing = {$: 'LineCharts__Missing'};
var $author$project$Examples$LineCharts__Montone = {$: 'LineCharts__Montone'};
var $author$project$Examples$LineCharts__Pattern = {$: 'LineCharts__Pattern'};
var $author$project$Examples$LineCharts__Stacked = {$: 'LineCharts__Stacked'};
var $author$project$Examples$LineCharts__Stepped = {$: 'LineCharts__Stepped'};
var $author$project$Examples$LineCharts__Tooltip = {$: 'LineCharts__Tooltip'};
var $author$project$Examples$LineCharts__TooltipStack = {$: 'LineCharts__TooltipStack'};
var $author$project$Examples$LineCharts__Width = {$: 'LineCharts__Width'};
var $author$project$Examples$ScatterCharts__Basic = {$: 'ScatterCharts__Basic'};
var $author$project$Examples$ScatterCharts__Borders = {$: 'ScatterCharts__Borders'};
var $author$project$Examples$ScatterCharts__Colors = {$: 'ScatterCharts__Colors'};
var $author$project$Examples$ScatterCharts__DataDependent = {$: 'ScatterCharts__DataDependent'};
var $author$project$Examples$ScatterCharts__Highlight = {$: 'ScatterCharts__Highlight'};
var $author$project$Examples$ScatterCharts__Labels = {$: 'ScatterCharts__Labels'};
var $author$project$Examples$ScatterCharts__Legends = {$: 'ScatterCharts__Legends'};
var $author$project$Examples$ScatterCharts__Opacity = {$: 'ScatterCharts__Opacity'};
var $author$project$Examples$ScatterCharts__Shapes = {$: 'ScatterCharts__Shapes'};
var $author$project$Examples$ScatterCharts__Sizes = {$: 'ScatterCharts__Sizes'};
var $author$project$Examples$ScatterCharts__Tooltip = {$: 'ScatterCharts__Tooltip'};
var $author$project$Examples$all = _List_fromArray(
	[$author$project$Examples$BarCharts__Gradient, $author$project$Examples$BarCharts__VariableWidth, $author$project$Examples$BarCharts__Title, $author$project$Examples$BarCharts__TooltipStack, $author$project$Examples$BarCharts__Tooltip, $author$project$Examples$BarCharts__BarLabels, $author$project$Examples$BarCharts__Pattern, $author$project$Examples$BarCharts__Histogram, $author$project$Examples$BarCharts__BinLabelsAdvanced, $author$project$Examples$BarCharts__Spacing, $author$project$Examples$BarCharts__Highlight, $author$project$Examples$BarCharts__DataDependent, $author$project$Examples$BarCharts__Color, $author$project$Examples$BarCharts__TooltipBin, $author$project$Examples$BarCharts__Corners, $author$project$Examples$BarCharts__Ungroup, $author$project$Examples$BarCharts__BinLabels, $author$project$Examples$BarCharts__Stacked, $author$project$Examples$BarCharts__Margin, $author$project$Examples$BarCharts__Borders, $author$project$Examples$BarCharts__Opacity, $author$project$Examples$BarCharts__Legends, $author$project$Examples$BarCharts__Basic, $author$project$Examples$Frame__Lines, $author$project$Examples$Frame__Position, $author$project$Examples$Frame__Coordinates, $author$project$Examples$Frame__GridFilter, $author$project$Examples$Frame__Dimensions, $author$project$Examples$Frame__CustomElements, $author$project$Examples$Frame__NoArrow, $author$project$Examples$Frame__Background, $author$project$Examples$Frame__Rect, $author$project$Examples$Frame__Padding, $author$project$Examples$Frame__Times, $author$project$Examples$Frame__OnlyInts, $author$project$Examples$Frame__GridColor, $author$project$Examples$Frame__Offset, $author$project$Examples$Frame__Ellipsis, $author$project$Examples$Frame__Color, $author$project$Examples$Frame__Amount, $author$project$Examples$Frame__Titles, $author$project$Examples$Frame__CustomLabels, $author$project$Examples$Frame__Margin, $author$project$Examples$Frame__LabelWithLine, $author$project$Examples$Frame__DotGrid, $author$project$Examples$Frame__CustomFormat, $author$project$Examples$Frame__AxisLength, $author$project$Examples$Frame__Arbitrary, $author$project$Examples$Frame__Legends, $author$project$Examples$Frame__Basic, $author$project$Examples$Interactivity__ChangeContent, $author$project$Examples$Interactivity__Direction, $author$project$Examples$Interactivity__ChangeDot, $author$project$Examples$Interactivity__Border, $author$project$Examples$Interactivity__Zoom, $author$project$Examples$Interactivity__BasicBin, $author$project$Examples$Interactivity__BasicStack, $author$project$Examples$Interactivity__Coordinates, $author$project$Examples$Interactivity__ChangeName, $author$project$Examples$Interactivity__NoArrow, $author$project$Examples$Interactivity__FilterSearch, $author$project$Examples$Interactivity__Background, $author$project$Examples$Interactivity__BasicBar, $author$project$Examples$Interactivity__BasicArea, $author$project$Examples$Interactivity__ZoomAlt, $author$project$Examples$Interactivity__TrickyTooltip, $author$project$Examples$Interactivity__Multiple, $author$project$Examples$Interactivity__BasicLine, $author$project$Examples$Interactivity__Offset, $author$project$Examples$Interactivity__DoubleSearch, $author$project$Examples$Interactivity__ChangeUnit, $author$project$Examples$Interactivity__Focal, $author$project$Examples$LineCharts__Area, $author$project$Examples$LineCharts__Gradient, $author$project$Examples$LineCharts__Width, $author$project$Examples$LineCharts__TooltipStack, $author$project$Examples$LineCharts__Tooltip, $author$project$Examples$LineCharts__Montone, $author$project$Examples$LineCharts__Pattern, $author$project$Examples$LineCharts__Dots, $author$project$Examples$LineCharts__Dashed, $author$project$Examples$LineCharts__Color, $author$project$Examples$LineCharts__Stepped, $author$project$Examples$LineCharts__Stacked, $author$project$Examples$LineCharts__Labels, $author$project$Examples$LineCharts__Missing, $author$project$Examples$LineCharts__Legends, $author$project$Examples$LineCharts__Basic, $author$project$Examples$Frontpage__BasicBubble, $author$project$Examples$Frontpage__BasicNavigation, $author$project$Examples$Frontpage__BasicBar, $author$project$Examples$Frontpage__BasicArea, $author$project$Examples$Frontpage__Concise, $author$project$Examples$Frontpage__BasicLine, $author$project$Examples$Frontpage__BasicScatter, $author$project$Examples$Frontpage__Familiar, $author$project$Examples$ScatterCharts__Colors, $author$project$Examples$ScatterCharts__Shapes, $author$project$Examples$ScatterCharts__Tooltip, $author$project$Examples$ScatterCharts__Highlight, $author$project$Examples$ScatterCharts__DataDependent, $author$project$Examples$ScatterCharts__Borders, $author$project$Examples$ScatterCharts__Labels, $author$project$Examples$ScatterCharts__Opacity, $author$project$Examples$ScatterCharts__Sizes, $author$project$Examples$ScatterCharts__Legends, $author$project$Examples$ScatterCharts__Basic]);
var $elm$core$Dict$RBEmpty_elm_builtin = {$: 'RBEmpty_elm_builtin'};
var $elm$core$Dict$empty = $elm$core$Dict$RBEmpty_elm_builtin;
var $author$project$Examples$BarCharts$BarLabels$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Add custom bar labels.', name: 'Labels for bars', order: 15};
var $author$project$Examples$BarCharts$Basic$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Make a basic bar chart.', name: 'Basic', order: 1};
var $author$project$Examples$BarCharts$BinLabels$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Add bin labels.', name: 'Labels for bins', order: 15};
var $author$project$Examples$BarCharts$BinLabelsAdvanced$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Add custom bin labels.', name: 'Advanced labels for bins', order: 15};
var $author$project$Examples$BarCharts$Borders$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Add border to bar.', name: 'Borders', order: 8};
var $author$project$Examples$BarCharts$Color$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Change bar color.', name: 'Color', order: 7};
var $author$project$Examples$BarCharts$Corners$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Add rounded corners to bar.', name: 'Corners', order: 9};
var $author$project$Examples$BarCharts$DataDependent$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Change bar based on data.', name: 'Data dependent styling', order: 12};
var $author$project$Examples$BarCharts$Gradient$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Add gradient to bar.', name: 'Gradient', order: 10};
var $author$project$Examples$BarCharts$Highlight$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Add highlight to bar.', name: 'Highlight', order: 20};
var $author$project$Examples$BarCharts$Histogram$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Make a histogram (control x value).', name: 'Histogram', order: 2};
var $author$project$Examples$BarCharts$Legends$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Add legends to bar chart.', name: 'Legends', order: 16};
var $author$project$Examples$BarCharts$Margin$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Change margins around bin.', name: 'Margin', order: 6};
var $author$project$Examples$BarCharts$Opacity$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Change opacity of bar.', name: 'Opacity', order: 10};
var $author$project$Examples$BarCharts$Pattern$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Change pattern of bar.', name: 'Pattern', order: 11};
var $author$project$Examples$BarCharts$Spacing$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Remove or add spacing between bars.', name: 'Spacing', order: 5};
var $author$project$Examples$BarCharts$Stacked$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Stack bars.', name: 'Stacked', order: 3};
var $author$project$Examples$BarCharts$Title$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Add labels to bar chart.', name: 'Titles', order: 16};
var $author$project$Examples$BarCharts$Tooltip$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Add a basic tooltip for nearest bar.', name: 'Tooltip', order: 12};
var $author$project$Examples$BarCharts$TooltipBin$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Add a tooltip for nearest bin.', name: 'Bin tooltip', order: 13};
var $author$project$Examples$BarCharts$TooltipStack$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Add a tooltip for nearest stack.', name: 'Stack tooltip', order: 14};
var $author$project$Examples$BarCharts$Ungroup$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Have bars overlap rather than be side-by-side.', name: 'Ungroup', order: 4};
var $author$project$Examples$BarCharts$VariableWidth$meta = {category: 'Bar charts', categoryOrder: 1, description: 'Bars with varying widths.', name: 'Variable width', order: 2};
var $author$project$Examples$Frame$Amount$meta = {category: 'Navigation', categoryOrder: 4, description: 'Change the number of labels or ticks.', name: 'Amount of labels/ticks', order: 6};
var $author$project$Examples$Frame$Arbitrary$meta = {category: 'Navigation', categoryOrder: 4, description: 'Add custom SVG/HTML to your chart.', name: 'Arbitrary SVG and HTML', order: 35};
var $author$project$Examples$Frame$AxisLength$meta = {category: 'Navigation', categoryOrder: 4, description: 'Change the length of your axis line.', name: 'Adjust axis line', order: 12};
var $author$project$Examples$Frame$Background$meta = {category: 'Navigation', categoryOrder: 4, description: 'Color the frame.', name: 'Background', order: 18};
var $author$project$Examples$Frame$Basic$meta = {category: 'Navigation', categoryOrder: 4, description: 'Add grid, axes, ticks, and labels.', name: 'Basic', order: 1};
var $author$project$Examples$Frame$Color$meta = {category: 'Navigation', categoryOrder: 4, description: 'Change color of items.', name: 'Color', order: 2};
var $author$project$Examples$Frame$Coordinates$meta = {category: 'Navigation', categoryOrder: 4, description: 'Using the low level coordinate system.', name: 'Coordinates', order: 39};
var $author$project$Examples$Frame$CustomElements$meta = {category: 'Navigation', categoryOrder: 4, description: 'Add custom tracked elements', name: 'Custom chart elements', order: 100};
var $author$project$Examples$Frame$CustomFormat$meta = {category: 'Navigation', categoryOrder: 4, description: 'Change how your labels are formatted.', name: 'Custom formatting', order: 9};
var $author$project$Examples$Frame$CustomLabels$meta = {category: 'Navigation', categoryOrder: 4, description: 'Control labels entirely.', name: 'Custom labels', order: 9};
var $author$project$Examples$Frame$Dimensions$meta = {category: 'Navigation', categoryOrder: 4, description: 'Limit or extend your range and domain.', name: 'Control dimensions', order: 11};
var $author$project$Examples$Frame$DotGrid$meta = {category: 'Navigation', categoryOrder: 4, description: 'Use dots instead of grid lines.', name: 'Dotted grid', order: 13};
var $author$project$Examples$Frame$Ellipsis$meta = {category: 'Navigation', categoryOrder: 4, description: 'Add ellipsis to labels (Note: uses HTML labels).', name: 'Ellipsis', order: 8};
var $author$project$Examples$Frame$GridColor$meta = {category: 'Navigation', categoryOrder: 4, description: 'Change color of grid.', name: 'Color of grid', order: 14};
var $author$project$Examples$Frame$GridFilter$meta = {category: 'Navigation', categoryOrder: 4, description: 'Prevent automatically added gridlines.', name: 'Remove grid lines', order: 15};
var $author$project$Examples$Frame$LabelWithLine$meta = {category: 'Navigation', categoryOrder: 4, description: 'Add a label and line to chart.', name: 'Label with line', order: 20};
var $author$project$Examples$Frame$Legends$meta = {category: 'Navigation', categoryOrder: 4, description: 'Add legends to chart.', name: 'Legends', order: 21};
var $author$project$Examples$Frame$Lines$meta = {category: 'Navigation', categoryOrder: 4, description: 'Add a guidence line.', name: 'Lines', order: 30};
var $author$project$Examples$Frame$Margin$meta = {category: 'Navigation', categoryOrder: 4, description: 'Add margin to frame.', name: 'Margin', order: 17};
var $author$project$Examples$Frame$NoArrow$meta = {category: 'Navigation', categoryOrder: 4, description: 'Remove arrow from axis line.', name: 'Remove arrow', order: 5};
var $author$project$Examples$Frame$Offset$meta = {category: 'Navigation', categoryOrder: 4, description: 'Change position of labels.', name: 'Move labels', order: 4};
var $author$project$Examples$Frame$OnlyInts$meta = {category: 'Navigation', categoryOrder: 4, description: 'Only show integer labels.', name: 'Only integers', order: 7};
var $author$project$Examples$Frame$Padding$meta = {category: 'Navigation', categoryOrder: 4, description: 'Add padding to frame.', name: 'Padding', order: 16};
var $author$project$Examples$Frame$Position$meta = {category: 'Navigation', categoryOrder: 4, description: 'Change color of position.', name: 'Position', order: 3};
var $author$project$Examples$Frame$Rect$meta = {category: 'Navigation', categoryOrder: 4, description: 'Add a rectangle.', name: 'Rectangle', order: 31};
var $author$project$Examples$Frame$Times$meta = {category: 'Navigation', categoryOrder: 4, description: 'Use dates as labels.', name: 'Timeline', order: 7};
var $author$project$Examples$Frame$Titles$meta = {category: 'Navigation', categoryOrder: 4, description: 'Add titles to chart.', name: 'Titles', order: 20};
var $author$project$Examples$Frontpage$BasicArea$meta = {category: 'Basic', categoryOrder: 2, description: 'Make a basic area chart.', name: 'Area chart', order: 1};
var $author$project$Examples$Frontpage$BasicBar$meta = {category: 'Basic', categoryOrder: 1, description: 'Make a basic bar chart.', name: 'Bar chart', order: 1};
var $author$project$Examples$Frontpage$BasicBubble$meta = {category: 'Basic', categoryOrder: 3, description: 'Make a basic bubble chart.', name: 'Bubble chart', order: 1};
var $author$project$Examples$Frontpage$BasicLine$meta = {category: 'Basic', categoryOrder: 3, description: 'Make a basic line chart.', name: 'Line chart', order: 1};
var $author$project$Examples$Frontpage$BasicNavigation$meta = {category: 'Basic', categoryOrder: 1, description: 'Add basic navigation items to chart.', name: 'Basic navigation', order: 1};
var $author$project$Examples$Frontpage$BasicScatter$meta = {category: 'Basic', categoryOrder: 2, description: 'Make a basic scatter chart.', name: 'Scatter chart', order: 1};
var $author$project$Examples$Frontpage$Concise$meta = {category: 'Front page', categoryOrder: 1, description: 'Add custom bar labels.', name: 'Labels for bars', order: 15};
var $author$project$Examples$Frontpage$Familiar$meta = {category: 'Front page', categoryOrder: 2, description: 'Make a basic scatter chart.', name: 'Basic', order: 1};
var $author$project$Examples$Interactivity$Background$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Change background of tooltip.', name: 'Edit background', order: 12};
var $author$project$Examples$Interactivity$BasicArea$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Add tooltip for nearest stack in line or scatter chart.', name: 'Basic tooltip for area charts', order: 5};
var $author$project$Examples$Interactivity$BasicBar$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Add a tooltip for nearest bar.', name: 'Basic bar tooltip', order: 1};
var $author$project$Examples$Interactivity$BasicBin$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Add a tooltip for nearest bin.', name: 'Basic bin tooltip', order: 3};
var $author$project$Examples$Interactivity$BasicLine$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Add basic tooltip for line or scatter charts.', name: 'Basic tooltip for dots', order: 4};
var $author$project$Examples$Interactivity$BasicStack$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Add a tooltip for nearest stack.', name: 'Basic stack tooltip', order: 2};
var $author$project$Examples$Interactivity$Border$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Change border of tooltip.', name: 'Edit border', order: 11};
var $author$project$Examples$Interactivity$ChangeContent$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Change the content of the tooltip.', name: 'Change content', order: 7};
var $author$project$Examples$Interactivity$ChangeDot$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Change styling if hovered.', name: 'Change style based on events', order: 7};
var $author$project$Examples$Interactivity$ChangeName$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Change the default series name in tooltip.', name: 'Change name', order: 6};
var $author$project$Examples$Interactivity$ChangeUnit$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Change the value print in the tooltip.', name: 'Change value formatting', order: 7};
var $elm$core$Basics$negate = function (n) {
	return -n;
};
var $author$project$Examples$Interactivity$Coordinates$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Get the hovered coordinates.', name: 'Basic coordinates', order: -1};
var $author$project$Examples$Interactivity$Direction$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Change direction of tooltip.', name: 'Direction', order: 8};
var $author$project$Examples$Interactivity$DoubleSearch$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Add more than one search.', name: 'Multiple tooltips', order: 17};
var $author$project$Examples$Interactivity$FilterSearch$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Narrow down tooltip item search.', name: 'Filter item search', order: 15};
var $author$project$Examples$Interactivity$Focal$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Determine where tooltip is placed in relation to item.', name: 'Set focal point', order: 11};
var $author$project$Examples$Interactivity$Multiple$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Add a tooltip for bars and series.', name: 'Mixed chart types', order: 13};
var $author$project$Examples$Interactivity$NoArrow$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Don\'t add pointer to tooltip.', name: 'Remove pointer', order: 8};
var $author$project$Examples$Interactivity$Offset$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Change distance of tooltip to item.', name: 'Edit offset', order: 9};
var $author$project$Examples$Interactivity$TrickyTooltip$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Add tooltip for each stack in hovered bin.', name: 'Multiple tooltips for single group', order: 20};
var $author$project$Examples$Interactivity$Zoom$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Add zoom effect.', name: 'Zoom box', order: 21};
var $author$project$Examples$Interactivity$ZoomAlt$meta = {category: 'Interactivity', categoryOrder: 5, description: 'Add zoom effect.', name: 'Zoom', order: 20};
var $author$project$Examples$LineCharts$Area$meta = {category: 'Line charts', categoryOrder: 3, description: 'Set opacity of the area under curve.', name: 'Area under curve', order: 9};
var $author$project$Examples$LineCharts$Basic$meta = {category: 'Line charts', categoryOrder: 3, description: 'Use a linear interpolation.', name: 'Linear', order: 1};
var $author$project$Examples$LineCharts$Color$meta = {category: 'Line charts', categoryOrder: 3, description: 'Change color of line.', name: 'Color', order: 4};
var $author$project$Examples$LineCharts$Dashed$meta = {category: 'Line charts', categoryOrder: 3, description: 'Make a line dashed.', name: 'Dashed', order: 6};
var $author$project$Examples$LineCharts$Dots$meta = {category: 'Line charts', categoryOrder: 3, description: 'Add dots to a line.', name: 'Dots', order: 7};
var $author$project$Examples$LineCharts$Gradient$meta = {category: 'Line charts', categoryOrder: 3, description: 'Add a gradient to your area under the curve.', name: 'Gradient', order: 10};
var $author$project$Examples$LineCharts$Labels$meta = {category: 'Line charts', categoryOrder: 3, description: 'Add custom labels on each data point.', name: 'Labels for each point', order: 12};
var $author$project$Examples$LineCharts$Legends$meta = {category: 'Line charts', categoryOrder: 3, description: 'Add legends to your chart.', name: 'Legends', order: 12};
var $author$project$Examples$LineCharts$Missing$meta = {category: 'Line charts', categoryOrder: 3, description: 'Handle missing data.', name: 'Missing data', order: 4};
var $author$project$Examples$LineCharts$Montone$meta = {category: 'Line charts', categoryOrder: 3, description: 'Use a monotone interpolation.', name: 'Monotone', order: 2};
var $author$project$Examples$LineCharts$Pattern$meta = {category: 'Line charts', categoryOrder: 3, description: 'Add a pattern to the area under the curve.', name: 'Pattern', order: 11};
var $author$project$Examples$LineCharts$Stacked$meta = {category: 'Line charts', categoryOrder: 3, description: 'Stack lines.', name: 'Stacked', order: 8};
var $author$project$Examples$LineCharts$Stepped$meta = {category: 'Line charts', categoryOrder: 3, description: 'Use a stepped interpolation.', name: 'Stepped', order: 3};
var $author$project$Examples$LineCharts$Tooltip$meta = {category: 'Line charts', categoryOrder: 3, description: 'Add basic tooltip.', name: 'Tooltip', order: 13};
var $author$project$Examples$LineCharts$TooltipStack$meta = {category: 'Line charts', categoryOrder: 3, description: 'Add tooltip for nearest stack.', name: 'Tooltip for stacks', order: 14};
var $author$project$Examples$LineCharts$Width$meta = {category: 'Line charts', categoryOrder: 3, description: 'Change width of line.', name: 'Width', order: 5};
var $author$project$Examples$ScatterCharts$Basic$meta = {category: 'Scatter charts', categoryOrder: 2, description: 'Make a basic scatter chart.', name: 'Basic', order: 1};
var $author$project$Examples$ScatterCharts$Borders$meta = {category: 'Scatter charts', categoryOrder: 2, description: 'Change border of dots.', name: 'Borders', order: 5};
var $author$project$Examples$ScatterCharts$Colors$meta = {category: 'Scatter charts', categoryOrder: 2, description: 'Change color of dots.', name: 'Color', order: 3};
var $author$project$Examples$ScatterCharts$DataDependent$meta = {category: 'Scatter charts', categoryOrder: 2, description: 'Change styling of individual dots.', name: 'Data dependent styling', order: 7};
var $author$project$Examples$ScatterCharts$Highlight$meta = {category: 'Scatter charts', categoryOrder: 2, description: 'Highlight dots.', name: 'Highlight', order: 6};
var $author$project$Examples$ScatterCharts$Labels$meta = {category: 'Scatter charts', categoryOrder: 2, description: 'Add labels to each dot.', name: 'Labels', order: 9};
var $author$project$Examples$ScatterCharts$Legends$meta = {category: 'Scatter charts', categoryOrder: 2, description: 'Add legends to scatter chart.', name: 'Legends', order: 10};
var $author$project$Examples$ScatterCharts$Opacity$meta = {category: 'Scatter charts', categoryOrder: 2, description: 'Change opacity of dots.', name: 'Opacity', order: 6};
var $author$project$Examples$ScatterCharts$Shapes$meta = {category: 'Scatter charts', categoryOrder: 2, description: 'Change shape of dots.', name: 'Shapes', order: 2};
var $author$project$Examples$ScatterCharts$Sizes$meta = {category: 'Scatter charts', categoryOrder: 2, description: 'Change size of dots.', name: 'Sizes', order: 4};
var $author$project$Examples$ScatterCharts$Tooltip$meta = {category: 'Scatter charts', categoryOrder: 2, description: 'Add basic tooltip.', name: 'Tooltip', order: 8};
var $author$project$Examples$meta = function (chosen) {
	switch (chosen.$) {
		case 'BarCharts__Gradient':
			return $author$project$Examples$BarCharts$Gradient$meta;
		case 'BarCharts__VariableWidth':
			return $author$project$Examples$BarCharts$VariableWidth$meta;
		case 'BarCharts__Title':
			return $author$project$Examples$BarCharts$Title$meta;
		case 'BarCharts__TooltipStack':
			return $author$project$Examples$BarCharts$TooltipStack$meta;
		case 'BarCharts__Tooltip':
			return $author$project$Examples$BarCharts$Tooltip$meta;
		case 'BarCharts__BarLabels':
			return $author$project$Examples$BarCharts$BarLabels$meta;
		case 'BarCharts__Pattern':
			return $author$project$Examples$BarCharts$Pattern$meta;
		case 'BarCharts__Histogram':
			return $author$project$Examples$BarCharts$Histogram$meta;
		case 'BarCharts__BinLabelsAdvanced':
			return $author$project$Examples$BarCharts$BinLabelsAdvanced$meta;
		case 'BarCharts__Spacing':
			return $author$project$Examples$BarCharts$Spacing$meta;
		case 'BarCharts__Highlight':
			return $author$project$Examples$BarCharts$Highlight$meta;
		case 'BarCharts__DataDependent':
			return $author$project$Examples$BarCharts$DataDependent$meta;
		case 'BarCharts__Color':
			return $author$project$Examples$BarCharts$Color$meta;
		case 'BarCharts__TooltipBin':
			return $author$project$Examples$BarCharts$TooltipBin$meta;
		case 'BarCharts__Corners':
			return $author$project$Examples$BarCharts$Corners$meta;
		case 'BarCharts__Ungroup':
			return $author$project$Examples$BarCharts$Ungroup$meta;
		case 'BarCharts__BinLabels':
			return $author$project$Examples$BarCharts$BinLabels$meta;
		case 'BarCharts__Stacked':
			return $author$project$Examples$BarCharts$Stacked$meta;
		case 'BarCharts__Margin':
			return $author$project$Examples$BarCharts$Margin$meta;
		case 'BarCharts__Borders':
			return $author$project$Examples$BarCharts$Borders$meta;
		case 'BarCharts__Opacity':
			return $author$project$Examples$BarCharts$Opacity$meta;
		case 'BarCharts__Legends':
			return $author$project$Examples$BarCharts$Legends$meta;
		case 'BarCharts__Basic':
			return $author$project$Examples$BarCharts$Basic$meta;
		case 'Frame__Lines':
			return $author$project$Examples$Frame$Lines$meta;
		case 'Frame__Position':
			return $author$project$Examples$Frame$Position$meta;
		case 'Frame__Coordinates':
			return $author$project$Examples$Frame$Coordinates$meta;
		case 'Frame__GridFilter':
			return $author$project$Examples$Frame$GridFilter$meta;
		case 'Frame__Dimensions':
			return $author$project$Examples$Frame$Dimensions$meta;
		case 'Frame__CustomElements':
			return $author$project$Examples$Frame$CustomElements$meta;
		case 'Frame__NoArrow':
			return $author$project$Examples$Frame$NoArrow$meta;
		case 'Frame__Background':
			return $author$project$Examples$Frame$Background$meta;
		case 'Frame__Rect':
			return $author$project$Examples$Frame$Rect$meta;
		case 'Frame__Padding':
			return $author$project$Examples$Frame$Padding$meta;
		case 'Frame__Times':
			return $author$project$Examples$Frame$Times$meta;
		case 'Frame__OnlyInts':
			return $author$project$Examples$Frame$OnlyInts$meta;
		case 'Frame__GridColor':
			return $author$project$Examples$Frame$GridColor$meta;
		case 'Frame__Offset':
			return $author$project$Examples$Frame$Offset$meta;
		case 'Frame__Ellipsis':
			return $author$project$Examples$Frame$Ellipsis$meta;
		case 'Frame__Color':
			return $author$project$Examples$Frame$Color$meta;
		case 'Frame__Amount':
			return $author$project$Examples$Frame$Amount$meta;
		case 'Frame__Titles':
			return $author$project$Examples$Frame$Titles$meta;
		case 'Frame__CustomLabels':
			return $author$project$Examples$Frame$CustomLabels$meta;
		case 'Frame__Margin':
			return $author$project$Examples$Frame$Margin$meta;
		case 'Frame__LabelWithLine':
			return $author$project$Examples$Frame$LabelWithLine$meta;
		case 'Frame__DotGrid':
			return $author$project$Examples$Frame$DotGrid$meta;
		case 'Frame__CustomFormat':
			return $author$project$Examples$Frame$CustomFormat$meta;
		case 'Frame__AxisLength':
			return $author$project$Examples$Frame$AxisLength$meta;
		case 'Frame__Arbitrary':
			return $author$project$Examples$Frame$Arbitrary$meta;
		case 'Frame__Legends':
			return $author$project$Examples$Frame$Legends$meta;
		case 'Frame__Basic':
			return $author$project$Examples$Frame$Basic$meta;
		case 'Interactivity__ChangeContent':
			return $author$project$Examples$Interactivity$ChangeContent$meta;
		case 'Interactivity__Direction':
			return $author$project$Examples$Interactivity$Direction$meta;
		case 'Interactivity__ChangeDot':
			return $author$project$Examples$Interactivity$ChangeDot$meta;
		case 'Interactivity__Border':
			return $author$project$Examples$Interactivity$Border$meta;
		case 'Interactivity__Zoom':
			return $author$project$Examples$Interactivity$Zoom$meta;
		case 'Interactivity__BasicBin':
			return $author$project$Examples$Interactivity$BasicBin$meta;
		case 'Interactivity__BasicStack':
			return $author$project$Examples$Interactivity$BasicStack$meta;
		case 'Interactivity__Coordinates':
			return $author$project$Examples$Interactivity$Coordinates$meta;
		case 'Interactivity__ChangeName':
			return $author$project$Examples$Interactivity$ChangeName$meta;
		case 'Interactivity__NoArrow':
			return $author$project$Examples$Interactivity$NoArrow$meta;
		case 'Interactivity__FilterSearch':
			return $author$project$Examples$Interactivity$FilterSearch$meta;
		case 'Interactivity__Background':
			return $author$project$Examples$Interactivity$Background$meta;
		case 'Interactivity__BasicBar':
			return $author$project$Examples$Interactivity$BasicBar$meta;
		case 'Interactivity__BasicArea':
			return $author$project$Examples$Interactivity$BasicArea$meta;
		case 'Interactivity__ZoomAlt':
			return $author$project$Examples$Interactivity$ZoomAlt$meta;
		case 'Interactivity__TrickyTooltip':
			return $author$project$Examples$Interactivity$TrickyTooltip$meta;
		case 'Interactivity__Multiple':
			return $author$project$Examples$Interactivity$Multiple$meta;
		case 'Interactivity__BasicLine':
			return $author$project$Examples$Interactivity$BasicLine$meta;
		case 'Interactivity__Offset':
			return $author$project$Examples$Interactivity$Offset$meta;
		case 'Interactivity__DoubleSearch':
			return $author$project$Examples$Interactivity$DoubleSearch$meta;
		case 'Interactivity__ChangeUnit':
			return $author$project$Examples$Interactivity$ChangeUnit$meta;
		case 'Interactivity__Focal':
			return $author$project$Examples$Interactivity$Focal$meta;
		case 'LineCharts__Area':
			return $author$project$Examples$LineCharts$Area$meta;
		case 'LineCharts__Gradient':
			return $author$project$Examples$LineCharts$Gradient$meta;
		case 'LineCharts__Width':
			return $author$project$Examples$LineCharts$Width$meta;
		case 'LineCharts__TooltipStack':
			return $author$project$Examples$LineCharts$TooltipStack$meta;
		case 'LineCharts__Tooltip':
			return $author$project$Examples$LineCharts$Tooltip$meta;
		case 'LineCharts__Montone':
			return $author$project$Examples$LineCharts$Montone$meta;
		case 'LineCharts__Pattern':
			return $author$project$Examples$LineCharts$Pattern$meta;
		case 'LineCharts__Dots':
			return $author$project$Examples$LineCharts$Dots$meta;
		case 'LineCharts__Dashed':
			return $author$project$Examples$LineCharts$Dashed$meta;
		case 'LineCharts__Color':
			return $author$project$Examples$LineCharts$Color$meta;
		case 'LineCharts__Stepped':
			return $author$project$Examples$LineCharts$Stepped$meta;
		case 'LineCharts__Stacked':
			return $author$project$Examples$LineCharts$Stacked$meta;
		case 'LineCharts__Labels':
			return $author$project$Examples$LineCharts$Labels$meta;
		case 'LineCharts__Missing':
			return $author$project$Examples$LineCharts$Missing$meta;
		case 'LineCharts__Legends':
			return $author$project$Examples$LineCharts$Legends$meta;
		case 'LineCharts__Basic':
			return $author$project$Examples$LineCharts$Basic$meta;
		case 'Frontpage__BasicBubble':
			return $author$project$Examples$Frontpage$BasicBubble$meta;
		case 'Frontpage__BasicNavigation':
			return $author$project$Examples$Frontpage$BasicNavigation$meta;
		case 'Frontpage__BasicBar':
			return $author$project$Examples$Frontpage$BasicBar$meta;
		case 'Frontpage__BasicArea':
			return $author$project$Examples$Frontpage$BasicArea$meta;
		case 'Frontpage__Concise':
			return $author$project$Examples$Frontpage$Concise$meta;
		case 'Frontpage__BasicLine':
			return $author$project$Examples$Frontpage$BasicLine$meta;
		case 'Frontpage__BasicScatter':
			return $author$project$Examples$Frontpage$BasicScatter$meta;
		case 'Frontpage__Familiar':
			return $author$project$Examples$Frontpage$Familiar$meta;
		case 'ScatterCharts__Colors':
			return $author$project$Examples$ScatterCharts$Colors$meta;
		case 'ScatterCharts__Shapes':
			return $author$project$Examples$ScatterCharts$Shapes$meta;
		case 'ScatterCharts__Tooltip':
			return $author$project$Examples$ScatterCharts$Tooltip$meta;
		case 'ScatterCharts__Highlight':
			return $author$project$Examples$ScatterCharts$Highlight$meta;
		case 'ScatterCharts__DataDependent':
			return $author$project$Examples$ScatterCharts$DataDependent$meta;
		case 'ScatterCharts__Borders':
			return $author$project$Examples$ScatterCharts$Borders$meta;
		case 'ScatterCharts__Labels':
			return $author$project$Examples$ScatterCharts$Labels$meta;
		case 'ScatterCharts__Opacity':
			return $author$project$Examples$ScatterCharts$Opacity$meta;
		case 'ScatterCharts__Sizes':
			return $author$project$Examples$ScatterCharts$Sizes$meta;
		case 'ScatterCharts__Legends':
			return $author$project$Examples$ScatterCharts$Legends$meta;
		default:
			return $author$project$Examples$ScatterCharts$Basic$meta;
	}
};
var $elm$core$Basics$composeR = F3(
	function (f, g, x) {
		return g(
			f(x));
	});
var $elm$core$String$replace = F3(
	function (before, after, string) {
		return A2(
			$elm$core$String$join,
			after,
			A2($elm$core$String$split, before, string));
	});
var $elm$core$String$toLower = _String_toLower;
var $author$project$Ui$Thumbnail$urlify = A2(
	$elm$core$Basics$composeR,
	A2($elm$core$String$replace, ' ', '-'),
	A2(
		$elm$core$Basics$composeR,
		A2($elm$core$String$replace, '/', '-'),
		$elm$core$String$toLower));
var $author$project$Ui$Thumbnail$toUrlGroup = function (title) {
	return '/documentation/' + $author$project$Ui$Thumbnail$urlify(title);
};
var $elm$core$Basics$compare = _Utils_compare;
var $elm$core$Dict$get = F2(
	function (targetKey, dict) {
		get:
		while (true) {
			if (dict.$ === 'RBEmpty_elm_builtin') {
				return $elm$core$Maybe$Nothing;
			} else {
				var key = dict.b;
				var value = dict.c;
				var left = dict.d;
				var right = dict.e;
				var _v1 = A2($elm$core$Basics$compare, targetKey, key);
				switch (_v1.$) {
					case 'LT':
						var $temp$targetKey = targetKey,
							$temp$dict = left;
						targetKey = $temp$targetKey;
						dict = $temp$dict;
						continue get;
					case 'EQ':
						return $elm$core$Maybe$Just(value);
					default:
						var $temp$targetKey = targetKey,
							$temp$dict = right;
						targetKey = $temp$targetKey;
						dict = $temp$dict;
						continue get;
				}
			}
		}
	});
var $elm$core$Dict$Black = {$: 'Black'};
var $elm$core$Dict$RBNode_elm_builtin = F5(
	function (a, b, c, d, e) {
		return {$: 'RBNode_elm_builtin', a: a, b: b, c: c, d: d, e: e};
	});
var $elm$core$Dict$Red = {$: 'Red'};
var $elm$core$Dict$balance = F5(
	function (color, key, value, left, right) {
		if ((right.$ === 'RBNode_elm_builtin') && (right.a.$ === 'Red')) {
			var _v1 = right.a;
			var rK = right.b;
			var rV = right.c;
			var rLeft = right.d;
			var rRight = right.e;
			if ((left.$ === 'RBNode_elm_builtin') && (left.a.$ === 'Red')) {
				var _v3 = left.a;
				var lK = left.b;
				var lV = left.c;
				var lLeft = left.d;
				var lRight = left.e;
				return A5(
					$elm$core$Dict$RBNode_elm_builtin,
					$elm$core$Dict$Red,
					key,
					value,
					A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Black, lK, lV, lLeft, lRight),
					A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Black, rK, rV, rLeft, rRight));
			} else {
				return A5(
					$elm$core$Dict$RBNode_elm_builtin,
					color,
					rK,
					rV,
					A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Red, key, value, left, rLeft),
					rRight);
			}
		} else {
			if ((((left.$ === 'RBNode_elm_builtin') && (left.a.$ === 'Red')) && (left.d.$ === 'RBNode_elm_builtin')) && (left.d.a.$ === 'Red')) {
				var _v5 = left.a;
				var lK = left.b;
				var lV = left.c;
				var _v6 = left.d;
				var _v7 = _v6.a;
				var llK = _v6.b;
				var llV = _v6.c;
				var llLeft = _v6.d;
				var llRight = _v6.e;
				var lRight = left.e;
				return A5(
					$elm$core$Dict$RBNode_elm_builtin,
					$elm$core$Dict$Red,
					lK,
					lV,
					A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Black, llK, llV, llLeft, llRight),
					A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Black, key, value, lRight, right));
			} else {
				return A5($elm$core$Dict$RBNode_elm_builtin, color, key, value, left, right);
			}
		}
	});
var $elm$core$Dict$insertHelp = F3(
	function (key, value, dict) {
		if (dict.$ === 'RBEmpty_elm_builtin') {
			return A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Red, key, value, $elm$core$Dict$RBEmpty_elm_builtin, $elm$core$Dict$RBEmpty_elm_builtin);
		} else {
			var nColor = dict.a;
			var nKey = dict.b;
			var nValue = dict.c;
			var nLeft = dict.d;
			var nRight = dict.e;
			var _v1 = A2($elm$core$Basics$compare, key, nKey);
			switch (_v1.$) {
				case 'LT':
					return A5(
						$elm$core$Dict$balance,
						nColor,
						nKey,
						nValue,
						A3($elm$core$Dict$insertHelp, key, value, nLeft),
						nRight);
				case 'EQ':
					return A5($elm$core$Dict$RBNode_elm_builtin, nColor, nKey, value, nLeft, nRight);
				default:
					return A5(
						$elm$core$Dict$balance,
						nColor,
						nKey,
						nValue,
						nLeft,
						A3($elm$core$Dict$insertHelp, key, value, nRight));
			}
		}
	});
var $elm$core$Dict$insert = F3(
	function (key, value, dict) {
		var _v0 = A3($elm$core$Dict$insertHelp, key, value, dict);
		if ((_v0.$ === 'RBNode_elm_builtin') && (_v0.a.$ === 'Red')) {
			var _v1 = _v0.a;
			var k = _v0.b;
			var v = _v0.c;
			var l = _v0.d;
			var r = _v0.e;
			return A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Black, k, v, l, r);
		} else {
			var x = _v0;
			return x;
		}
	});
var $elm$core$Dict$getMin = function (dict) {
	getMin:
	while (true) {
		if ((dict.$ === 'RBNode_elm_builtin') && (dict.d.$ === 'RBNode_elm_builtin')) {
			var left = dict.d;
			var $temp$dict = left;
			dict = $temp$dict;
			continue getMin;
		} else {
			return dict;
		}
	}
};
var $elm$core$Dict$moveRedLeft = function (dict) {
	if (((dict.$ === 'RBNode_elm_builtin') && (dict.d.$ === 'RBNode_elm_builtin')) && (dict.e.$ === 'RBNode_elm_builtin')) {
		if ((dict.e.d.$ === 'RBNode_elm_builtin') && (dict.e.d.a.$ === 'Red')) {
			var clr = dict.a;
			var k = dict.b;
			var v = dict.c;
			var _v1 = dict.d;
			var lClr = _v1.a;
			var lK = _v1.b;
			var lV = _v1.c;
			var lLeft = _v1.d;
			var lRight = _v1.e;
			var _v2 = dict.e;
			var rClr = _v2.a;
			var rK = _v2.b;
			var rV = _v2.c;
			var rLeft = _v2.d;
			var _v3 = rLeft.a;
			var rlK = rLeft.b;
			var rlV = rLeft.c;
			var rlL = rLeft.d;
			var rlR = rLeft.e;
			var rRight = _v2.e;
			return A5(
				$elm$core$Dict$RBNode_elm_builtin,
				$elm$core$Dict$Red,
				rlK,
				rlV,
				A5(
					$elm$core$Dict$RBNode_elm_builtin,
					$elm$core$Dict$Black,
					k,
					v,
					A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Red, lK, lV, lLeft, lRight),
					rlL),
				A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Black, rK, rV, rlR, rRight));
		} else {
			var clr = dict.a;
			var k = dict.b;
			var v = dict.c;
			var _v4 = dict.d;
			var lClr = _v4.a;
			var lK = _v4.b;
			var lV = _v4.c;
			var lLeft = _v4.d;
			var lRight = _v4.e;
			var _v5 = dict.e;
			var rClr = _v5.a;
			var rK = _v5.b;
			var rV = _v5.c;
			var rLeft = _v5.d;
			var rRight = _v5.e;
			if (clr.$ === 'Black') {
				return A5(
					$elm$core$Dict$RBNode_elm_builtin,
					$elm$core$Dict$Black,
					k,
					v,
					A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Red, lK, lV, lLeft, lRight),
					A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Red, rK, rV, rLeft, rRight));
			} else {
				return A5(
					$elm$core$Dict$RBNode_elm_builtin,
					$elm$core$Dict$Black,
					k,
					v,
					A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Red, lK, lV, lLeft, lRight),
					A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Red, rK, rV, rLeft, rRight));
			}
		}
	} else {
		return dict;
	}
};
var $elm$core$Dict$moveRedRight = function (dict) {
	if (((dict.$ === 'RBNode_elm_builtin') && (dict.d.$ === 'RBNode_elm_builtin')) && (dict.e.$ === 'RBNode_elm_builtin')) {
		if ((dict.d.d.$ === 'RBNode_elm_builtin') && (dict.d.d.a.$ === 'Red')) {
			var clr = dict.a;
			var k = dict.b;
			var v = dict.c;
			var _v1 = dict.d;
			var lClr = _v1.a;
			var lK = _v1.b;
			var lV = _v1.c;
			var _v2 = _v1.d;
			var _v3 = _v2.a;
			var llK = _v2.b;
			var llV = _v2.c;
			var llLeft = _v2.d;
			var llRight = _v2.e;
			var lRight = _v1.e;
			var _v4 = dict.e;
			var rClr = _v4.a;
			var rK = _v4.b;
			var rV = _v4.c;
			var rLeft = _v4.d;
			var rRight = _v4.e;
			return A5(
				$elm$core$Dict$RBNode_elm_builtin,
				$elm$core$Dict$Red,
				lK,
				lV,
				A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Black, llK, llV, llLeft, llRight),
				A5(
					$elm$core$Dict$RBNode_elm_builtin,
					$elm$core$Dict$Black,
					k,
					v,
					lRight,
					A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Red, rK, rV, rLeft, rRight)));
		} else {
			var clr = dict.a;
			var k = dict.b;
			var v = dict.c;
			var _v5 = dict.d;
			var lClr = _v5.a;
			var lK = _v5.b;
			var lV = _v5.c;
			var lLeft = _v5.d;
			var lRight = _v5.e;
			var _v6 = dict.e;
			var rClr = _v6.a;
			var rK = _v6.b;
			var rV = _v6.c;
			var rLeft = _v6.d;
			var rRight = _v6.e;
			if (clr.$ === 'Black') {
				return A5(
					$elm$core$Dict$RBNode_elm_builtin,
					$elm$core$Dict$Black,
					k,
					v,
					A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Red, lK, lV, lLeft, lRight),
					A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Red, rK, rV, rLeft, rRight));
			} else {
				return A5(
					$elm$core$Dict$RBNode_elm_builtin,
					$elm$core$Dict$Black,
					k,
					v,
					A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Red, lK, lV, lLeft, lRight),
					A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Red, rK, rV, rLeft, rRight));
			}
		}
	} else {
		return dict;
	}
};
var $elm$core$Dict$removeHelpPrepEQGT = F7(
	function (targetKey, dict, color, key, value, left, right) {
		if ((left.$ === 'RBNode_elm_builtin') && (left.a.$ === 'Red')) {
			var _v1 = left.a;
			var lK = left.b;
			var lV = left.c;
			var lLeft = left.d;
			var lRight = left.e;
			return A5(
				$elm$core$Dict$RBNode_elm_builtin,
				color,
				lK,
				lV,
				lLeft,
				A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Red, key, value, lRight, right));
		} else {
			_v2$2:
			while (true) {
				if ((right.$ === 'RBNode_elm_builtin') && (right.a.$ === 'Black')) {
					if (right.d.$ === 'RBNode_elm_builtin') {
						if (right.d.a.$ === 'Black') {
							var _v3 = right.a;
							var _v4 = right.d;
							var _v5 = _v4.a;
							return $elm$core$Dict$moveRedRight(dict);
						} else {
							break _v2$2;
						}
					} else {
						var _v6 = right.a;
						var _v7 = right.d;
						return $elm$core$Dict$moveRedRight(dict);
					}
				} else {
					break _v2$2;
				}
			}
			return dict;
		}
	});
var $elm$core$Dict$removeMin = function (dict) {
	if ((dict.$ === 'RBNode_elm_builtin') && (dict.d.$ === 'RBNode_elm_builtin')) {
		var color = dict.a;
		var key = dict.b;
		var value = dict.c;
		var left = dict.d;
		var lColor = left.a;
		var lLeft = left.d;
		var right = dict.e;
		if (lColor.$ === 'Black') {
			if ((lLeft.$ === 'RBNode_elm_builtin') && (lLeft.a.$ === 'Red')) {
				var _v3 = lLeft.a;
				return A5(
					$elm$core$Dict$RBNode_elm_builtin,
					color,
					key,
					value,
					$elm$core$Dict$removeMin(left),
					right);
			} else {
				var _v4 = $elm$core$Dict$moveRedLeft(dict);
				if (_v4.$ === 'RBNode_elm_builtin') {
					var nColor = _v4.a;
					var nKey = _v4.b;
					var nValue = _v4.c;
					var nLeft = _v4.d;
					var nRight = _v4.e;
					return A5(
						$elm$core$Dict$balance,
						nColor,
						nKey,
						nValue,
						$elm$core$Dict$removeMin(nLeft),
						nRight);
				} else {
					return $elm$core$Dict$RBEmpty_elm_builtin;
				}
			}
		} else {
			return A5(
				$elm$core$Dict$RBNode_elm_builtin,
				color,
				key,
				value,
				$elm$core$Dict$removeMin(left),
				right);
		}
	} else {
		return $elm$core$Dict$RBEmpty_elm_builtin;
	}
};
var $elm$core$Dict$removeHelp = F2(
	function (targetKey, dict) {
		if (dict.$ === 'RBEmpty_elm_builtin') {
			return $elm$core$Dict$RBEmpty_elm_builtin;
		} else {
			var color = dict.a;
			var key = dict.b;
			var value = dict.c;
			var left = dict.d;
			var right = dict.e;
			if (_Utils_cmp(targetKey, key) < 0) {
				if ((left.$ === 'RBNode_elm_builtin') && (left.a.$ === 'Black')) {
					var _v4 = left.a;
					var lLeft = left.d;
					if ((lLeft.$ === 'RBNode_elm_builtin') && (lLeft.a.$ === 'Red')) {
						var _v6 = lLeft.a;
						return A5(
							$elm$core$Dict$RBNode_elm_builtin,
							color,
							key,
							value,
							A2($elm$core$Dict$removeHelp, targetKey, left),
							right);
					} else {
						var _v7 = $elm$core$Dict$moveRedLeft(dict);
						if (_v7.$ === 'RBNode_elm_builtin') {
							var nColor = _v7.a;
							var nKey = _v7.b;
							var nValue = _v7.c;
							var nLeft = _v7.d;
							var nRight = _v7.e;
							return A5(
								$elm$core$Dict$balance,
								nColor,
								nKey,
								nValue,
								A2($elm$core$Dict$removeHelp, targetKey, nLeft),
								nRight);
						} else {
							return $elm$core$Dict$RBEmpty_elm_builtin;
						}
					}
				} else {
					return A5(
						$elm$core$Dict$RBNode_elm_builtin,
						color,
						key,
						value,
						A2($elm$core$Dict$removeHelp, targetKey, left),
						right);
				}
			} else {
				return A2(
					$elm$core$Dict$removeHelpEQGT,
					targetKey,
					A7($elm$core$Dict$removeHelpPrepEQGT, targetKey, dict, color, key, value, left, right));
			}
		}
	});
var $elm$core$Dict$removeHelpEQGT = F2(
	function (targetKey, dict) {
		if (dict.$ === 'RBNode_elm_builtin') {
			var color = dict.a;
			var key = dict.b;
			var value = dict.c;
			var left = dict.d;
			var right = dict.e;
			if (_Utils_eq(targetKey, key)) {
				var _v1 = $elm$core$Dict$getMin(right);
				if (_v1.$ === 'RBNode_elm_builtin') {
					var minKey = _v1.b;
					var minValue = _v1.c;
					return A5(
						$elm$core$Dict$balance,
						color,
						minKey,
						minValue,
						left,
						$elm$core$Dict$removeMin(right));
				} else {
					return $elm$core$Dict$RBEmpty_elm_builtin;
				}
			} else {
				return A5(
					$elm$core$Dict$balance,
					color,
					key,
					value,
					left,
					A2($elm$core$Dict$removeHelp, targetKey, right));
			}
		} else {
			return $elm$core$Dict$RBEmpty_elm_builtin;
		}
	});
var $elm$core$Dict$remove = F2(
	function (key, dict) {
		var _v0 = A2($elm$core$Dict$removeHelp, key, dict);
		if ((_v0.$ === 'RBNode_elm_builtin') && (_v0.a.$ === 'Red')) {
			var _v1 = _v0.a;
			var k = _v0.b;
			var v = _v0.c;
			var l = _v0.d;
			var r = _v0.e;
			return A5($elm$core$Dict$RBNode_elm_builtin, $elm$core$Dict$Black, k, v, l, r);
		} else {
			var x = _v0;
			return x;
		}
	});
var $elm$core$Dict$update = F3(
	function (targetKey, alter, dictionary) {
		var _v0 = alter(
			A2($elm$core$Dict$get, targetKey, dictionary));
		if (_v0.$ === 'Just') {
			var value = _v0.a;
			return A3($elm$core$Dict$insert, targetKey, value, dictionary);
		} else {
			return A2($elm$core$Dict$remove, targetKey, dictionary);
		}
	});
var $author$project$Ui$Thumbnail$dictGroups = function () {
	var updateCat = F3(
		function (meta, id, maybeIds) {
			if (maybeIds.$ === 'Just') {
				var group = maybeIds.a;
				return $elm$core$Maybe$Just(
					_Utils_update(
						group,
						{
							ids: A2($elm$core$List$cons, id, group.ids)
						}));
			} else {
				return $elm$core$Maybe$Just(
					A3(
						$author$project$Ui$Thumbnail$Group,
						meta.category,
						meta.categoryOrder,
						_List_fromArray(
							[id])));
			}
		});
	var groupBy = function (id) {
		var meta = $author$project$Examples$meta(id);
		return A2(
			$elm$core$Dict$update,
			$author$project$Ui$Thumbnail$toUrlGroup(meta.category),
			A2(updateCat, meta, id));
	};
	return A3($elm$core$List$foldl, groupBy, $elm$core$Dict$empty, $author$project$Examples$all);
}();
var $elm$core$List$sortBy = _List_sortBy;
var $elm$core$Dict$values = function (dict) {
	return A3(
		$elm$core$Dict$foldr,
		F3(
			function (key, value, valueList) {
				return A2($elm$core$List$cons, value, valueList);
			}),
		_List_Nil,
		dict);
};
var $author$project$Ui$Thumbnail$groups = A2(
	$elm$core$List$sortBy,
	function ($) {
		return $.order;
	},
	$elm$core$Dict$values($author$project$Ui$Thumbnail$dictGroups));
var $elm$core$List$head = function (list) {
	if (list.b) {
		var x = list.a;
		var xs = list.b;
		return $elm$core$Maybe$Just(x);
	} else {
		return $elm$core$Maybe$Nothing;
	}
};
var $elm$core$Maybe$withDefault = F2(
	function (_default, maybe) {
		if (maybe.$ === 'Just') {
			var value = maybe.a;
			return value;
		} else {
			return _default;
		}
	});
var $author$project$Ui$Thumbnail$firstGroup = A2(
	$elm$core$Maybe$withDefault,
	A3($author$project$Ui$Thumbnail$Group, '', 1, _List_Nil),
	$elm$core$List$head($author$project$Ui$Thumbnail$groups));
var $author$project$Examples$BarCharts$BarLabels$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$Basic$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$BinLabels$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$BinLabelsAdvanced$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$Borders$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$Color$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$Corners$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$DataDependent$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$Gradient$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$Highlight$init = {hovering: _List_Nil};
var $author$project$Examples$BarCharts$Histogram$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$Legends$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$Margin$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$Opacity$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$Pattern$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$Spacing$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$Stacked$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$Title$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$Tooltip$init = {hovering: _List_Nil};
var $author$project$Examples$BarCharts$TooltipBin$init = {hovering: _List_Nil};
var $author$project$Examples$BarCharts$TooltipStack$init = {hovering: _List_Nil};
var $author$project$Examples$BarCharts$Ungroup$init = _Utils_Tuple0;
var $author$project$Examples$BarCharts$VariableWidth$init = _Utils_Tuple0;
var $author$project$Examples$Frame$Amount$init = _Utils_Tuple0;
var $author$project$Examples$Frame$Arbitrary$init = _Utils_Tuple0;
var $author$project$Examples$Frame$AxisLength$init = _Utils_Tuple0;
var $author$project$Examples$Frame$Background$init = _Utils_Tuple0;
var $author$project$Examples$Frame$Basic$init = _Utils_Tuple0;
var $author$project$Examples$Frame$Color$init = _Utils_Tuple0;
var $author$project$Examples$Frame$Coordinates$init = _Utils_Tuple0;
var $author$project$Examples$Frame$CustomElements$init = {hovering: _List_Nil};
var $author$project$Examples$Frame$CustomFormat$init = _Utils_Tuple0;
var $author$project$Examples$Frame$CustomLabels$init = _Utils_Tuple0;
var $author$project$Examples$Frame$Dimensions$init = _Utils_Tuple0;
var $author$project$Examples$Frame$DotGrid$init = _Utils_Tuple0;
var $author$project$Examples$Frame$Ellipsis$init = _Utils_Tuple0;
var $author$project$Examples$Frame$GridColor$init = _Utils_Tuple0;
var $author$project$Examples$Frame$GridFilter$init = _Utils_Tuple0;
var $author$project$Examples$Frame$LabelWithLine$init = _Utils_Tuple0;
var $author$project$Examples$Frame$Legends$init = _Utils_Tuple0;
var $author$project$Examples$Frame$Lines$init = _Utils_Tuple0;
var $author$project$Examples$Frame$Margin$init = _Utils_Tuple0;
var $author$project$Examples$Frame$NoArrow$init = _Utils_Tuple0;
var $author$project$Examples$Frame$Offset$init = _Utils_Tuple0;
var $author$project$Examples$Frame$OnlyInts$init = _Utils_Tuple0;
var $author$project$Examples$Frame$Padding$init = _Utils_Tuple0;
var $author$project$Examples$Frame$Position$init = _Utils_Tuple0;
var $author$project$Examples$Frame$Rect$init = _Utils_Tuple0;
var $author$project$Examples$Frame$Times$init = _Utils_Tuple0;
var $author$project$Examples$Frame$Titles$init = _Utils_Tuple0;
var $author$project$Examples$Frontpage$BasicArea$init = _Utils_Tuple0;
var $author$project$Examples$Frontpage$BasicBar$init = _Utils_Tuple0;
var $author$project$Examples$Frontpage$BasicBubble$init = _Utils_Tuple0;
var $author$project$Examples$Frontpage$BasicLine$init = _Utils_Tuple0;
var $author$project$Examples$Frontpage$BasicNavigation$init = _Utils_Tuple0;
var $author$project$Examples$Frontpage$BasicScatter$init = _Utils_Tuple0;
var $author$project$Examples$Frontpage$Concise$init = {hovering: _List_Nil};
var $author$project$Examples$Frontpage$Familiar$init = _Utils_Tuple0;
var $author$project$Examples$Interactivity$Background$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$BasicArea$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$BasicBar$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$BasicBin$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$BasicLine$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$BasicStack$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$Border$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$ChangeContent$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$ChangeDot$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$ChangeName$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$ChangeUnit$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$Coordinates$init = {hovering: $elm$core$Maybe$Nothing};
var $author$project$Examples$Interactivity$Direction$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$DoubleSearch$init = {hoveringBars: _List_Nil, hoveringDots: _List_Nil};
var $author$project$Examples$Interactivity$FilterSearch$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$Focal$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$Multiple$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$NoArrow$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$Offset$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$TrickyTooltip$init = {hovering: _List_Nil};
var $author$project$Examples$Interactivity$Zoom$NoZoom = {$: 'NoZoom'};
var $author$project$Examples$Interactivity$Zoom$init = $author$project$Examples$Interactivity$Zoom$NoZoom;
var $author$project$Examples$Interactivity$ZoomAlt$None = {$: 'None'};
var $author$project$Examples$Interactivity$ZoomAlt$init = {
	center: {x: 0, y: 0},
	dragging: $author$project$Examples$Interactivity$ZoomAlt$None,
	percentage: 100
};
var $author$project$Examples$LineCharts$Area$init = _Utils_Tuple0;
var $author$project$Examples$LineCharts$Basic$init = _Utils_Tuple0;
var $author$project$Examples$LineCharts$Color$init = _Utils_Tuple0;
var $author$project$Examples$LineCharts$Dashed$init = _Utils_Tuple0;
var $author$project$Examples$LineCharts$Dots$init = _Utils_Tuple0;
var $author$project$Examples$LineCharts$Gradient$init = _Utils_Tuple0;
var $author$project$Examples$LineCharts$Labels$init = _Utils_Tuple0;
var $author$project$Examples$LineCharts$Legends$init = _Utils_Tuple0;
var $author$project$Examples$LineCharts$Missing$init = _Utils_Tuple0;
var $author$project$Examples$LineCharts$Montone$init = _Utils_Tuple0;
var $author$project$Examples$LineCharts$Pattern$init = _Utils_Tuple0;
var $author$project$Examples$LineCharts$Stacked$init = _Utils_Tuple0;
var $author$project$Examples$LineCharts$Stepped$init = _Utils_Tuple0;
var $author$project$Examples$LineCharts$Tooltip$init = {hovering: _List_Nil};
var $author$project$Examples$LineCharts$TooltipStack$init = {hovering: _List_Nil};
var $author$project$Examples$LineCharts$Width$init = _Utils_Tuple0;
var $author$project$Examples$ScatterCharts$Basic$init = _Utils_Tuple0;
var $author$project$Examples$ScatterCharts$Borders$init = _Utils_Tuple0;
var $author$project$Examples$ScatterCharts$Colors$init = _Utils_Tuple0;
var $author$project$Examples$ScatterCharts$DataDependent$init = _Utils_Tuple0;
var $author$project$Examples$ScatterCharts$Highlight$init = _Utils_Tuple0;
var $author$project$Examples$ScatterCharts$Labels$init = _Utils_Tuple0;
var $author$project$Examples$ScatterCharts$Legends$init = _Utils_Tuple0;
var $author$project$Examples$ScatterCharts$Opacity$init = _Utils_Tuple0;
var $author$project$Examples$ScatterCharts$Shapes$init = _Utils_Tuple0;
var $author$project$Examples$ScatterCharts$Sizes$init = _Utils_Tuple0;
var $author$project$Examples$ScatterCharts$Tooltip$init = {hovering: _List_Nil};
var $author$project$Examples$init = {example0: $author$project$Examples$BarCharts$Gradient$init, example1: $author$project$Examples$BarCharts$VariableWidth$init, example10: $author$project$Examples$BarCharts$Highlight$init, example100: $author$project$Examples$ScatterCharts$DataDependent$init, example101: $author$project$Examples$ScatterCharts$Borders$init, example102: $author$project$Examples$ScatterCharts$Labels$init, example103: $author$project$Examples$ScatterCharts$Opacity$init, example104: $author$project$Examples$ScatterCharts$Sizes$init, example105: $author$project$Examples$ScatterCharts$Legends$init, example106: $author$project$Examples$ScatterCharts$Basic$init, example11: $author$project$Examples$BarCharts$DataDependent$init, example12: $author$project$Examples$BarCharts$Color$init, example13: $author$project$Examples$BarCharts$TooltipBin$init, example14: $author$project$Examples$BarCharts$Corners$init, example15: $author$project$Examples$BarCharts$Ungroup$init, example16: $author$project$Examples$BarCharts$BinLabels$init, example17: $author$project$Examples$BarCharts$Stacked$init, example18: $author$project$Examples$BarCharts$Margin$init, example19: $author$project$Examples$BarCharts$Borders$init, example2: $author$project$Examples$BarCharts$Title$init, example20: $author$project$Examples$BarCharts$Opacity$init, example21: $author$project$Examples$BarCharts$Legends$init, example22: $author$project$Examples$BarCharts$Basic$init, example23: $author$project$Examples$Frame$Lines$init, example24: $author$project$Examples$Frame$Position$init, example25: $author$project$Examples$Frame$Coordinates$init, example26: $author$project$Examples$Frame$GridFilter$init, example27: $author$project$Examples$Frame$Dimensions$init, example28: $author$project$Examples$Frame$CustomElements$init, example29: $author$project$Examples$Frame$NoArrow$init, example3: $author$project$Examples$BarCharts$TooltipStack$init, example30: $author$project$Examples$Frame$Background$init, example31: $author$project$Examples$Frame$Rect$init, example32: $author$project$Examples$Frame$Padding$init, example33: $author$project$Examples$Frame$Times$init, example34: $author$project$Examples$Frame$OnlyInts$init, example35: $author$project$Examples$Frame$GridColor$init, example36: $author$project$Examples$Frame$Offset$init, example37: $author$project$Examples$Frame$Ellipsis$init, example38: $author$project$Examples$Frame$Color$init, example39: $author$project$Examples$Frame$Amount$init, example4: $author$project$Examples$BarCharts$Tooltip$init, example40: $author$project$Examples$Frame$Titles$init, example41: $author$project$Examples$Frame$CustomLabels$init, example42: $author$project$Examples$Frame$Margin$init, example43: $author$project$Examples$Frame$LabelWithLine$init, example44: $author$project$Examples$Frame$DotGrid$init, example45: $author$project$Examples$Frame$CustomFormat$init, example46: $author$project$Examples$Frame$AxisLength$init, example47: $author$project$Examples$Frame$Arbitrary$init, example48: $author$project$Examples$Frame$Legends$init, example49: $author$project$Examples$Frame$Basic$init, example5: $author$project$Examples$BarCharts$BarLabels$init, example50: $author$project$Examples$Interactivity$ChangeContent$init, example51: $author$project$Examples$Interactivity$Direction$init, example52: $author$project$Examples$Interactivity$ChangeDot$init, example53: $author$project$Examples$Interactivity$Border$init, example54: $author$project$Examples$Interactivity$Zoom$init, example55: $author$project$Examples$Interactivity$BasicBin$init, example56: $author$project$Examples$Interactivity$BasicStack$init, example57: $author$project$Examples$Interactivity$Coordinates$init, example58: $author$project$Examples$Interactivity$ChangeName$init, example59: $author$project$Examples$Interactivity$NoArrow$init, example6: $author$project$Examples$BarCharts$Pattern$init, example60: $author$project$Examples$Interactivity$FilterSearch$init, example61: $author$project$Examples$Interactivity$Background$init, example62: $author$project$Examples$Interactivity$BasicBar$init, example63: $author$project$Examples$Interactivity$BasicArea$init, example64: $author$project$Examples$Interactivity$ZoomAlt$init, example65: $author$project$Examples$Interactivity$TrickyTooltip$init, example66: $author$project$Examples$Interactivity$Multiple$init, example67: $author$project$Examples$Interactivity$BasicLine$init, example68: $author$project$Examples$Interactivity$Offset$init, example69: $author$project$Examples$Interactivity$DoubleSearch$init, example7: $author$project$Examples$BarCharts$Histogram$init, example70: $author$project$Examples$Interactivity$ChangeUnit$init, example71: $author$project$Examples$Interactivity$Focal$init, example72: $author$project$Examples$LineCharts$Area$init, example73: $author$project$Examples$LineCharts$Gradient$init, example74: $author$project$Examples$LineCharts$Width$init, example75: $author$project$Examples$LineCharts$TooltipStack$init, example76: $author$project$Examples$LineCharts$Tooltip$init, example77: $author$project$Examples$LineCharts$Montone$init, example78: $author$project$Examples$LineCharts$Pattern$init, example79: $author$project$Examples$LineCharts$Dots$init, example8: $author$project$Examples$BarCharts$BinLabelsAdvanced$init, example80: $author$project$Examples$LineCharts$Dashed$init, example81: $author$project$Examples$LineCharts$Color$init, example82: $author$project$Examples$LineCharts$Stepped$init, example83: $author$project$Examples$LineCharts$Stacked$init, example84: $author$project$Examples$LineCharts$Labels$init, example85: $author$project$Examples$LineCharts$Missing$init, example86: $author$project$Examples$LineCharts$Legends$init, example87: $author$project$Examples$LineCharts$Basic$init, example88: $author$project$Examples$Frontpage$BasicBubble$init, example89: $author$project$Examples$Frontpage$BasicNavigation$init, example9: $author$project$Examples$BarCharts$Spacing$init, example90: $author$project$Examples$Frontpage$BasicBar$init, example91: $author$project$Examples$Frontpage$BasicArea$init, example92: $author$project$Examples$Frontpage$Concise$init, example93: $author$project$Examples$Frontpage$BasicLine$init, example94: $author$project$Examples$Frontpage$BasicScatter$init, example95: $author$project$Examples$Frontpage$Familiar$init, example96: $author$project$Examples$ScatterCharts$Colors$init, example97: $author$project$Examples$ScatterCharts$Shapes$init, example98: $author$project$Examples$ScatterCharts$Tooltip$init, example99: $author$project$Examples$ScatterCharts$Highlight$init};
var $author$project$Page$Section$init = F3(
	function (key, session, params) {
		return _Utils_Tuple2(
			{examples: $author$project$Examples$init, menu: $author$project$Ui$Menu$init, selectedTab: params.section, window: session.window},
			$elm$core$Platform$Cmd$none);
	});
var $author$project$Page$Documentation$init = F3(
	function (key, session, params) {
		return A3(
			$author$project$Page$Section$init,
			key,
			session,
			{
				section: $author$project$Ui$Thumbnail$urlify($author$project$Ui$Thumbnail$firstGroup.title)
			});
	});
var $author$project$Page$Example$init = F3(
	function (key, session, params) {
		return _Utils_Tuple2(
			{examples: $author$project$Examples$init, menu: $author$project$Ui$Menu$init, selectedTab: params.section, selectedThumb: params.example, showFullCode: false, window: session.window},
			$elm$core$Platform$Cmd$none);
	});
var $author$project$Page$GettingStarted$init = F3(
	function (key, session, params) {
		return _Utils_Tuple2(
			{menu: $author$project$Ui$Menu$init, window: session.window},
			$elm$core$Platform$Cmd$none);
	});
var $author$project$Charts$Dashboard1$init = {hovering: _List_Nil, hoveringBars: _List_Nil};
var $author$project$Charts$Dashboard2$init = {hovering: _List_Nil};
var $author$project$Charts$Dashboard3$init = {hovering: _List_Nil};
var $author$project$Charts$Dashboard4$init = {hovering: _List_Nil};
var $author$project$Charts$Dashboard5$init = {hovering: _List_Nil};
var $author$project$Charts$Landing$init = {hovering: _List_Nil, hoveringBars: _List_Nil};
var $author$project$Page$Home$init = F3(
	function (key, session, params) {
		return _Utils_Tuple2(
			{concise: $author$project$Examples$Frontpage$Concise$init, dashboard1: $author$project$Charts$Dashboard1$init, dashboard2: $author$project$Charts$Dashboard2$init, dashboard3: $author$project$Charts$Dashboard3$init, dashboard4: $author$project$Charts$Dashboard4$init, dashboard5: $author$project$Charts$Dashboard5$init, familiarToggle: true, hovering: _List_Nil, landing: $author$project$Charts$Landing$init, menu: $author$project$Ui$Menu$init, window: session.window},
			$elm$core$Platform$Cmd$none);
	});
var $elm$browser$Browser$Navigation$pushUrl = _Browser_pushUrl;
var $elm$core$Platform$Cmd$map = _Platform_map;
var $author$project$Main$updateWith = F4(
	function (toModel, toMsg, model, _v0) {
		var subModel = _v0.a;
		var subCmd = _v0.b;
		return _Utils_Tuple2(
			_Utils_update(
				model,
				{
					page: toModel(subModel)
				}),
			A2($elm$core$Platform$Cmd$map, toMsg, subCmd));
	});
var $author$project$Main$changeRouteTo = F2(
	function (maybeRoute, old) {
		var session = $author$project$Main$exit(old);
		var model = _Utils_update(
			old,
			{session: session});
		if (maybeRoute.$ === 'Nothing') {
			return _Utils_Tuple2(
				_Utils_update(
					model,
					{page: $author$project$Main$Redirect}),
				A2($elm$browser$Browser$Navigation$pushUrl, model.navigation, '/'));
		} else {
			switch (maybeRoute.a.$) {
				case 'Top':
					var _v1 = maybeRoute.a;
					return A4(
						$author$project$Main$updateWith,
						$author$project$Main$Page_Home,
						$author$project$Main$Page_Home_Msg,
						model,
						A3($author$project$Page$Home$init, model.navigation, session, _Utils_Tuple0));
				case 'Administration':
					var _v2 = maybeRoute.a;
					return A4(
						$author$project$Main$updateWith,
						$author$project$Main$Page_Administration,
						$author$project$Main$Page_Administration_Msg,
						model,
						A3($author$project$Page$Administration$init, model.navigation, session, _Utils_Tuple0));
				case 'Documentation':
					var _v3 = maybeRoute.a;
					return A4(
						$author$project$Main$updateWith,
						$author$project$Main$Page_Documentation,
						$author$project$Main$Page_Documentation_Msg,
						model,
						A3($author$project$Page$Documentation$init, model.navigation, session, _Utils_Tuple0));
				case 'Documentation_String_':
					var p1 = maybeRoute.a.a;
					return A4(
						$author$project$Main$updateWith,
						$author$project$Main$Page_Section,
						$author$project$Main$Page_Section_Msg,
						model,
						A3(
							$author$project$Page$Section$init,
							model.navigation,
							session,
							{section: p1}));
				case 'Documentation_String__String_':
					var _v4 = maybeRoute.a;
					var p1 = _v4.a;
					var p2 = _v4.b;
					return A4(
						$author$project$Main$updateWith,
						$author$project$Main$Page_Example,
						$author$project$Main$Page_Example_Msg,
						model,
						A3(
							$author$project$Page$Example$init,
							model.navigation,
							session,
							{example: p2, section: p1}));
				default:
					var _v5 = maybeRoute.a;
					return A4(
						$author$project$Main$updateWith,
						$author$project$Main$Page_GettingStarted,
						$author$project$Main$Page_GettingStarted_Msg,
						model,
						A3($author$project$Page$GettingStarted$init, model.navigation, session, _Utils_Tuple0));
			}
		}
	});
var $elm$url$Url$Parser$State = F5(
	function (visited, unvisited, params, frag, value) {
		return {frag: frag, params: params, unvisited: unvisited, value: value, visited: visited};
	});
var $elm$url$Url$Parser$getFirstMatch = function (states) {
	getFirstMatch:
	while (true) {
		if (!states.b) {
			return $elm$core$Maybe$Nothing;
		} else {
			var state = states.a;
			var rest = states.b;
			var _v1 = state.unvisited;
			if (!_v1.b) {
				return $elm$core$Maybe$Just(state.value);
			} else {
				if ((_v1.a === '') && (!_v1.b.b)) {
					return $elm$core$Maybe$Just(state.value);
				} else {
					var $temp$states = rest;
					states = $temp$states;
					continue getFirstMatch;
				}
			}
		}
	}
};
var $elm$url$Url$Parser$removeFinalEmpty = function (segments) {
	if (!segments.b) {
		return _List_Nil;
	} else {
		if ((segments.a === '') && (!segments.b.b)) {
			return _List_Nil;
		} else {
			var segment = segments.a;
			var rest = segments.b;
			return A2(
				$elm$core$List$cons,
				segment,
				$elm$url$Url$Parser$removeFinalEmpty(rest));
		}
	}
};
var $elm$url$Url$Parser$preparePath = function (path) {
	var _v0 = A2($elm$core$String$split, '/', path);
	if (_v0.b && (_v0.a === '')) {
		var segments = _v0.b;
		return $elm$url$Url$Parser$removeFinalEmpty(segments);
	} else {
		var segments = _v0;
		return $elm$url$Url$Parser$removeFinalEmpty(segments);
	}
};
var $elm$url$Url$Parser$addToParametersHelp = F2(
	function (value, maybeList) {
		if (maybeList.$ === 'Nothing') {
			return $elm$core$Maybe$Just(
				_List_fromArray(
					[value]));
		} else {
			var list = maybeList.a;
			return $elm$core$Maybe$Just(
				A2($elm$core$List$cons, value, list));
		}
	});
var $elm$url$Url$percentDecode = _Url_percentDecode;
var $elm$url$Url$Parser$addParam = F2(
	function (segment, dict) {
		var _v0 = A2($elm$core$String$split, '=', segment);
		if ((_v0.b && _v0.b.b) && (!_v0.b.b.b)) {
			var rawKey = _v0.a;
			var _v1 = _v0.b;
			var rawValue = _v1.a;
			var _v2 = $elm$url$Url$percentDecode(rawKey);
			if (_v2.$ === 'Nothing') {
				return dict;
			} else {
				var key = _v2.a;
				var _v3 = $elm$url$Url$percentDecode(rawValue);
				if (_v3.$ === 'Nothing') {
					return dict;
				} else {
					var value = _v3.a;
					return A3(
						$elm$core$Dict$update,
						key,
						$elm$url$Url$Parser$addToParametersHelp(value),
						dict);
				}
			}
		} else {
			return dict;
		}
	});
var $elm$url$Url$Parser$prepareQuery = function (maybeQuery) {
	if (maybeQuery.$ === 'Nothing') {
		return $elm$core$Dict$empty;
	} else {
		var qry = maybeQuery.a;
		return A3(
			$elm$core$List$foldr,
			$elm$url$Url$Parser$addParam,
			$elm$core$Dict$empty,
			A2($elm$core$String$split, '&', qry));
	}
};
var $elm$url$Url$Parser$parse = F2(
	function (_v0, url) {
		var parser = _v0.a;
		return $elm$url$Url$Parser$getFirstMatch(
			parser(
				A5(
					$elm$url$Url$Parser$State,
					_List_Nil,
					$elm$url$Url$Parser$preparePath(url.path),
					$elm$url$Url$Parser$prepareQuery(url.query),
					url.fragment,
					$elm$core$Basics$identity)));
	});
var $author$project$Route$Administration = {$: 'Administration'};
var $author$project$Route$Documentation = {$: 'Documentation'};
var $author$project$Route$Documentation_String_ = function (a) {
	return {$: 'Documentation_String_', a: a};
};
var $author$project$Route$Documentation_String__String_ = F2(
	function (a, b) {
		return {$: 'Documentation_String__String_', a: a, b: b};
	});
var $author$project$Route$Getting_started = {$: 'Getting_started'};
var $author$project$Route$Top = {$: 'Top'};
var $elm$url$Url$Parser$Parser = function (a) {
	return {$: 'Parser', a: a};
};
var $elm$url$Url$Parser$mapState = F2(
	function (func, _v0) {
		var visited = _v0.visited;
		var unvisited = _v0.unvisited;
		var params = _v0.params;
		var frag = _v0.frag;
		var value = _v0.value;
		return A5(
			$elm$url$Url$Parser$State,
			visited,
			unvisited,
			params,
			frag,
			func(value));
	});
var $elm$url$Url$Parser$map = F2(
	function (subValue, _v0) {
		var parseArg = _v0.a;
		return $elm$url$Url$Parser$Parser(
			function (_v1) {
				var visited = _v1.visited;
				var unvisited = _v1.unvisited;
				var params = _v1.params;
				var frag = _v1.frag;
				var value = _v1.value;
				return A2(
					$elm$core$List$map,
					$elm$url$Url$Parser$mapState(value),
					parseArg(
						A5($elm$url$Url$Parser$State, visited, unvisited, params, frag, subValue)));
			});
	});
var $elm$core$List$append = F2(
	function (xs, ys) {
		if (!ys.b) {
			return xs;
		} else {
			return A3($elm$core$List$foldr, $elm$core$List$cons, ys, xs);
		}
	});
var $elm$core$List$concat = function (lists) {
	return A3($elm$core$List$foldr, $elm$core$List$append, _List_Nil, lists);
};
var $elm$core$List$concatMap = F2(
	function (f, list) {
		return $elm$core$List$concat(
			A2($elm$core$List$map, f, list));
	});
var $elm$url$Url$Parser$oneOf = function (parsers) {
	return $elm$url$Url$Parser$Parser(
		function (state) {
			return A2(
				$elm$core$List$concatMap,
				function (_v0) {
					var parser = _v0.a;
					return parser(state);
				},
				parsers);
		});
};
var $elm$url$Url$Parser$s = function (str) {
	return $elm$url$Url$Parser$Parser(
		function (_v0) {
			var visited = _v0.visited;
			var unvisited = _v0.unvisited;
			var params = _v0.params;
			var frag = _v0.frag;
			var value = _v0.value;
			if (!unvisited.b) {
				return _List_Nil;
			} else {
				var next = unvisited.a;
				var rest = unvisited.b;
				return _Utils_eq(next, str) ? _List_fromArray(
					[
						A5(
						$elm$url$Url$Parser$State,
						A2($elm$core$List$cons, next, visited),
						rest,
						params,
						frag,
						value)
					]) : _List_Nil;
			}
		});
};
var $elm$url$Url$Parser$slash = F2(
	function (_v0, _v1) {
		var parseBefore = _v0.a;
		var parseAfter = _v1.a;
		return $elm$url$Url$Parser$Parser(
			function (state) {
				return A2(
					$elm$core$List$concatMap,
					parseAfter,
					parseBefore(state));
			});
	});
var $elm$url$Url$Parser$custom = F2(
	function (tipe, stringToSomething) {
		return $elm$url$Url$Parser$Parser(
			function (_v0) {
				var visited = _v0.visited;
				var unvisited = _v0.unvisited;
				var params = _v0.params;
				var frag = _v0.frag;
				var value = _v0.value;
				if (!unvisited.b) {
					return _List_Nil;
				} else {
					var next = unvisited.a;
					var rest = unvisited.b;
					var _v2 = stringToSomething(next);
					if (_v2.$ === 'Just') {
						var nextValue = _v2.a;
						return _List_fromArray(
							[
								A5(
								$elm$url$Url$Parser$State,
								A2($elm$core$List$cons, next, visited),
								rest,
								params,
								frag,
								value(nextValue))
							]);
					} else {
						return _List_Nil;
					}
				}
			});
	});
var $elm$url$Url$Parser$string = A2($elm$url$Url$Parser$custom, 'STRING', $elm$core$Maybe$Just);
var $elm$url$Url$Parser$top = $elm$url$Url$Parser$Parser(
	function (state) {
		return _List_fromArray(
			[state]);
	});
var $author$project$Route$parser = $elm$url$Url$Parser$oneOf(
	_List_fromArray(
		[
			A2($elm$url$Url$Parser$map, $author$project$Route$Top, $elm$url$Url$Parser$top),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Route$Administration,
			$elm$url$Url$Parser$s('administration')),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Route$Documentation,
			$elm$url$Url$Parser$s('documentation')),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Route$Documentation_String_,
			A2(
				$elm$url$Url$Parser$slash,
				$elm$url$Url$Parser$s('documentation'),
				$elm$url$Url$Parser$string)),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Route$Documentation_String__String_,
			A2(
				$elm$url$Url$Parser$slash,
				$elm$url$Url$Parser$s('documentation'),
				A2($elm$url$Url$Parser$slash, $elm$url$Url$Parser$string, $elm$url$Url$Parser$string))),
			A2(
			$elm$url$Url$Parser$map,
			$author$project$Route$Getting_started,
			$elm$url$Url$Parser$s('getting-started'))
		]));
var $author$project$Route$fromUrl = function (url) {
	return A2($elm$url$Url$Parser$parse, $author$project$Route$parser, url);
};
var $author$project$Session$Session = function (window) {
	return {window: window};
};
var $elm$json$Json$Decode$decodeValue = _Json_run;
var $author$project$Session$Window = F2(
	function (width, height) {
		return {height: height, width: width};
	});
var $elm$json$Json$Decode$field = _Json_decodeField;
var $elm$json$Json$Decode$int = _Json_decodeInt;
var $author$project$Session$decoder = A3(
	$elm$json$Json$Decode$map2,
	$author$project$Session$Window,
	A2($elm$json$Json$Decode$field, 'width', $elm$json$Json$Decode$int),
	A2($elm$json$Json$Decode$field, 'height', $elm$json$Json$Decode$int));
var $author$project$Session$init = function (json) {
	var _v0 = A2($elm$json$Json$Decode$decodeValue, $author$project$Session$decoder, json);
	if (_v0.$ === 'Ok') {
		var flags = _v0.a;
		return $author$project$Session$Session(flags);
	} else {
		return $author$project$Session$Session(
			{height: 800, width: 1000});
	}
};
var $author$project$Main$init = F3(
	function (flags, url, key) {
		return A2(
			$author$project$Main$changeRouteTo,
			$author$project$Route$fromUrl(url),
			A3(
				$author$project$Main$Model,
				key,
				$author$project$Session$init(flags),
				$author$project$Main$Redirect));
	});
var $elm$core$Platform$Sub$map = _Platform_map;
var $elm$core$Platform$Sub$batch = _Platform_batch;
var $elm$core$Platform$Sub$none = $elm$core$Platform$Sub$batch(_List_Nil);
var $author$project$Page$Administration$OnResize = F2(
	function (a, b) {
		return {$: 'OnResize', a: a, b: b};
	});
var $elm$browser$Browser$Events$Window = {$: 'Window'};
var $elm$browser$Browser$Events$MySub = F3(
	function (a, b, c) {
		return {$: 'MySub', a: a, b: b, c: c};
	});
var $elm$browser$Browser$Events$State = F2(
	function (subs, pids) {
		return {pids: pids, subs: subs};
	});
var $elm$browser$Browser$Events$init = $elm$core$Task$succeed(
	A2($elm$browser$Browser$Events$State, _List_Nil, $elm$core$Dict$empty));
var $elm$browser$Browser$Events$nodeToKey = function (node) {
	if (node.$ === 'Document') {
		return 'd_';
	} else {
		return 'w_';
	}
};
var $elm$browser$Browser$Events$addKey = function (sub) {
	var node = sub.a;
	var name = sub.b;
	return _Utils_Tuple2(
		_Utils_ap(
			$elm$browser$Browser$Events$nodeToKey(node),
			name),
		sub);
};
var $elm$core$Dict$fromList = function (assocs) {
	return A3(
		$elm$core$List$foldl,
		F2(
			function (_v0, dict) {
				var key = _v0.a;
				var value = _v0.b;
				return A3($elm$core$Dict$insert, key, value, dict);
			}),
		$elm$core$Dict$empty,
		assocs);
};
var $elm$core$Process$kill = _Scheduler_kill;
var $elm$core$Dict$foldl = F3(
	function (func, acc, dict) {
		foldl:
		while (true) {
			if (dict.$ === 'RBEmpty_elm_builtin') {
				return acc;
			} else {
				var key = dict.b;
				var value = dict.c;
				var left = dict.d;
				var right = dict.e;
				var $temp$func = func,
					$temp$acc = A3(
					func,
					key,
					value,
					A3($elm$core$Dict$foldl, func, acc, left)),
					$temp$dict = right;
				func = $temp$func;
				acc = $temp$acc;
				dict = $temp$dict;
				continue foldl;
			}
		}
	});
var $elm$core$Dict$merge = F6(
	function (leftStep, bothStep, rightStep, leftDict, rightDict, initialResult) {
		var stepState = F3(
			function (rKey, rValue, _v0) {
				stepState:
				while (true) {
					var list = _v0.a;
					var result = _v0.b;
					if (!list.b) {
						return _Utils_Tuple2(
							list,
							A3(rightStep, rKey, rValue, result));
					} else {
						var _v2 = list.a;
						var lKey = _v2.a;
						var lValue = _v2.b;
						var rest = list.b;
						if (_Utils_cmp(lKey, rKey) < 0) {
							var $temp$rKey = rKey,
								$temp$rValue = rValue,
								$temp$_v0 = _Utils_Tuple2(
								rest,
								A3(leftStep, lKey, lValue, result));
							rKey = $temp$rKey;
							rValue = $temp$rValue;
							_v0 = $temp$_v0;
							continue stepState;
						} else {
							if (_Utils_cmp(lKey, rKey) > 0) {
								return _Utils_Tuple2(
									list,
									A3(rightStep, rKey, rValue, result));
							} else {
								return _Utils_Tuple2(
									rest,
									A4(bothStep, lKey, lValue, rValue, result));
							}
						}
					}
				}
			});
		var _v3 = A3(
			$elm$core$Dict$foldl,
			stepState,
			_Utils_Tuple2(
				$elm$core$Dict$toList(leftDict),
				initialResult),
			rightDict);
		var leftovers = _v3.a;
		var intermediateResult = _v3.b;
		return A3(
			$elm$core$List$foldl,
			F2(
				function (_v4, result) {
					var k = _v4.a;
					var v = _v4.b;
					return A3(leftStep, k, v, result);
				}),
			intermediateResult,
			leftovers);
	});
var $elm$browser$Browser$Events$Event = F2(
	function (key, event) {
		return {event: event, key: key};
	});
var $elm$core$Platform$sendToSelf = _Platform_sendToSelf;
var $elm$browser$Browser$Events$spawn = F3(
	function (router, key, _v0) {
		var node = _v0.a;
		var name = _v0.b;
		var actualNode = function () {
			if (node.$ === 'Document') {
				return _Browser_doc;
			} else {
				return _Browser_window;
			}
		}();
		return A2(
			$elm$core$Task$map,
			function (value) {
				return _Utils_Tuple2(key, value);
			},
			A3(
				_Browser_on,
				actualNode,
				name,
				function (event) {
					return A2(
						$elm$core$Platform$sendToSelf,
						router,
						A2($elm$browser$Browser$Events$Event, key, event));
				}));
	});
var $elm$core$Dict$union = F2(
	function (t1, t2) {
		return A3($elm$core$Dict$foldl, $elm$core$Dict$insert, t2, t1);
	});
var $elm$browser$Browser$Events$onEffects = F3(
	function (router, subs, state) {
		var stepRight = F3(
			function (key, sub, _v6) {
				var deads = _v6.a;
				var lives = _v6.b;
				var news = _v6.c;
				return _Utils_Tuple3(
					deads,
					lives,
					A2(
						$elm$core$List$cons,
						A3($elm$browser$Browser$Events$spawn, router, key, sub),
						news));
			});
		var stepLeft = F3(
			function (_v4, pid, _v5) {
				var deads = _v5.a;
				var lives = _v5.b;
				var news = _v5.c;
				return _Utils_Tuple3(
					A2($elm$core$List$cons, pid, deads),
					lives,
					news);
			});
		var stepBoth = F4(
			function (key, pid, _v2, _v3) {
				var deads = _v3.a;
				var lives = _v3.b;
				var news = _v3.c;
				return _Utils_Tuple3(
					deads,
					A3($elm$core$Dict$insert, key, pid, lives),
					news);
			});
		var newSubs = A2($elm$core$List$map, $elm$browser$Browser$Events$addKey, subs);
		var _v0 = A6(
			$elm$core$Dict$merge,
			stepLeft,
			stepBoth,
			stepRight,
			state.pids,
			$elm$core$Dict$fromList(newSubs),
			_Utils_Tuple3(_List_Nil, $elm$core$Dict$empty, _List_Nil));
		var deadPids = _v0.a;
		var livePids = _v0.b;
		var makeNewPids = _v0.c;
		return A2(
			$elm$core$Task$andThen,
			function (pids) {
				return $elm$core$Task$succeed(
					A2(
						$elm$browser$Browser$Events$State,
						newSubs,
						A2(
							$elm$core$Dict$union,
							livePids,
							$elm$core$Dict$fromList(pids))));
			},
			A2(
				$elm$core$Task$andThen,
				function (_v1) {
					return $elm$core$Task$sequence(makeNewPids);
				},
				$elm$core$Task$sequence(
					A2($elm$core$List$map, $elm$core$Process$kill, deadPids))));
	});
var $elm$core$List$maybeCons = F3(
	function (f, mx, xs) {
		var _v0 = f(mx);
		if (_v0.$ === 'Just') {
			var x = _v0.a;
			return A2($elm$core$List$cons, x, xs);
		} else {
			return xs;
		}
	});
var $elm$core$List$filterMap = F2(
	function (f, xs) {
		return A3(
			$elm$core$List$foldr,
			$elm$core$List$maybeCons(f),
			_List_Nil,
			xs);
	});
var $elm$browser$Browser$Events$onSelfMsg = F3(
	function (router, _v0, state) {
		var key = _v0.key;
		var event = _v0.event;
		var toMessage = function (_v2) {
			var subKey = _v2.a;
			var _v3 = _v2.b;
			var node = _v3.a;
			var name = _v3.b;
			var decoder = _v3.c;
			return _Utils_eq(subKey, key) ? A2(_Browser_decodeEvent, decoder, event) : $elm$core$Maybe$Nothing;
		};
		var messages = A2($elm$core$List$filterMap, toMessage, state.subs);
		return A2(
			$elm$core$Task$andThen,
			function (_v1) {
				return $elm$core$Task$succeed(state);
			},
			$elm$core$Task$sequence(
				A2(
					$elm$core$List$map,
					$elm$core$Platform$sendToApp(router),
					messages)));
	});
var $elm$browser$Browser$Events$subMap = F2(
	function (func, _v0) {
		var node = _v0.a;
		var name = _v0.b;
		var decoder = _v0.c;
		return A3(
			$elm$browser$Browser$Events$MySub,
			node,
			name,
			A2($elm$json$Json$Decode$map, func, decoder));
	});
_Platform_effectManagers['Browser.Events'] = _Platform_createManager($elm$browser$Browser$Events$init, $elm$browser$Browser$Events$onEffects, $elm$browser$Browser$Events$onSelfMsg, 0, $elm$browser$Browser$Events$subMap);
var $elm$browser$Browser$Events$subscription = _Platform_leaf('Browser.Events');
var $elm$browser$Browser$Events$on = F3(
	function (node, name, decoder) {
		return $elm$browser$Browser$Events$subscription(
			A3($elm$browser$Browser$Events$MySub, node, name, decoder));
	});
var $elm$browser$Browser$Events$onResize = function (func) {
	return A3(
		$elm$browser$Browser$Events$on,
		$elm$browser$Browser$Events$Window,
		'resize',
		A2(
			$elm$json$Json$Decode$field,
			'target',
			A3(
				$elm$json$Json$Decode$map2,
				func,
				A2($elm$json$Json$Decode$field, 'innerWidth', $elm$json$Json$Decode$int),
				A2($elm$json$Json$Decode$field, 'innerHeight', $elm$json$Json$Decode$int))));
};
var $author$project$Page$Administration$subscriptions = function (model) {
	return $elm$browser$Browser$Events$onResize($author$project$Page$Administration$OnResize);
};
var $author$project$Page$Section$OnResize = F2(
	function (a, b) {
		return {$: 'OnResize', a: a, b: b};
	});
var $author$project$Page$Section$subscriptions = function (model) {
	return $elm$browser$Browser$Events$onResize($author$project$Page$Section$OnResize);
};
var $author$project$Page$Documentation$subscriptions = $author$project$Page$Section$subscriptions;
var $author$project$Page$Example$OnResize = F2(
	function (a, b) {
		return {$: 'OnResize', a: a, b: b};
	});
var $author$project$Page$Example$subscriptions = function (model) {
	return $elm$browser$Browser$Events$onResize($author$project$Page$Example$OnResize);
};
var $author$project$Page$GettingStarted$OnResize = F2(
	function (a, b) {
		return {$: 'OnResize', a: a, b: b};
	});
var $author$project$Page$GettingStarted$subscriptions = function (model) {
	return $elm$browser$Browser$Events$onResize($author$project$Page$GettingStarted$OnResize);
};
var $author$project$Page$Home$OnResize = F2(
	function (a, b) {
		return {$: 'OnResize', a: a, b: b};
	});
var $author$project$Page$Home$subscriptions = function (model) {
	return $elm$browser$Browser$Events$onResize($author$project$Page$Home$OnResize);
};
var $author$project$Main$subscriptions = function (model) {
	var _v0 = model.page;
	switch (_v0.$) {
		case 'NotFound':
			return $elm$core$Platform$Sub$none;
		case 'Redirect':
			return $elm$core$Platform$Sub$none;
		case 'Page_Home':
			var subModel = _v0.a;
			return A2(
				$elm$core$Platform$Sub$map,
				$author$project$Main$Page_Home_Msg,
				$author$project$Page$Home$subscriptions(subModel));
		case 'Page_Administration':
			var subModel = _v0.a;
			return A2(
				$elm$core$Platform$Sub$map,
				$author$project$Main$Page_Administration_Msg,
				$author$project$Page$Administration$subscriptions(subModel));
		case 'Page_Documentation':
			var subModel = _v0.a;
			return A2(
				$elm$core$Platform$Sub$map,
				$author$project$Main$Page_Documentation_Msg,
				$author$project$Page$Documentation$subscriptions(subModel));
		case 'Page_Section':
			var subModel = _v0.a;
			return A2(
				$elm$core$Platform$Sub$map,
				$author$project$Main$Page_Section_Msg,
				$author$project$Page$Section$subscriptions(subModel));
		case 'Page_Example':
			var subModel = _v0.a;
			return A2(
				$elm$core$Platform$Sub$map,
				$author$project$Main$Page_Example_Msg,
				$author$project$Page$Example$subscriptions(subModel));
		default:
			var subModel = _v0.a;
			return A2(
				$elm$core$Platform$Sub$map,
				$author$project$Main$Page_GettingStarted_Msg,
				$author$project$Page$GettingStarted$subscriptions(subModel));
	}
};
var $elm$browser$Browser$Navigation$load = _Browser_load;
var $elm$url$Url$addPort = F2(
	function (maybePort, starter) {
		if (maybePort.$ === 'Nothing') {
			return starter;
		} else {
			var port_ = maybePort.a;
			return starter + (':' + $elm$core$String$fromInt(port_));
		}
	});
var $elm$url$Url$addPrefixed = F3(
	function (prefix, maybeSegment, starter) {
		if (maybeSegment.$ === 'Nothing') {
			return starter;
		} else {
			var segment = maybeSegment.a;
			return _Utils_ap(
				starter,
				_Utils_ap(prefix, segment));
		}
	});
var $elm$url$Url$toString = function (url) {
	var http = function () {
		var _v0 = url.protocol;
		if (_v0.$ === 'Http') {
			return 'http://';
		} else {
			return 'https://';
		}
	}();
	return A3(
		$elm$url$Url$addPrefixed,
		'#',
		url.fragment,
		A3(
			$elm$url$Url$addPrefixed,
			'?',
			url.query,
			_Utils_ap(
				A2(
					$elm$url$Url$addPort,
					url.port_,
					_Utils_ap(http, url.host)),
				url.path)));
};
var $elm$core$Basics$not = _Basics_not;
var $author$project$Ui$Menu$update = F2(
	function (msg, model) {
		return _Utils_update(
			model,
			{isOpen: !model.isOpen});
	});
var $author$project$Page$Administration$update = F3(
	function (key, msg, model) {
		if (msg.$ === 'OnResize') {
			var width = msg.a;
			var height = msg.b;
			return _Utils_Tuple2(
				_Utils_update(
					model,
					{
						window: {height: height, width: width}
					}),
				$elm$core$Platform$Cmd$none);
		} else {
			var subMsg = msg.a;
			return _Utils_Tuple2(
				_Utils_update(
					model,
					{
						menu: A2($author$project$Ui$Menu$update, subMsg, model.menu)
					}),
				$elm$core$Platform$Cmd$none);
		}
	});
var $author$project$Examples$BarCharts$BarLabels$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$Basic$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$BinLabels$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$BinLabelsAdvanced$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$Borders$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$Color$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$Corners$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$DataDependent$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$Gradient$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$Highlight$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$BarCharts$Histogram$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$Legends$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$Margin$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$Opacity$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$Pattern$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$Spacing$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$Stacked$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$Title$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$Tooltip$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$BarCharts$TooltipBin$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$BarCharts$TooltipStack$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$BarCharts$Ungroup$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$BarCharts$VariableWidth$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$Amount$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$Arbitrary$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$AxisLength$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$Background$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$Basic$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$Color$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$Coordinates$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$CustomElements$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Frame$CustomFormat$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$CustomLabels$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$Dimensions$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$DotGrid$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$Ellipsis$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$GridColor$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$GridFilter$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$LabelWithLine$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$Legends$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$Lines$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$Margin$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$NoArrow$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$Offset$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$OnlyInts$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$Padding$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$Position$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$Rect$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$Times$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frame$Titles$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frontpage$BasicArea$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frontpage$BasicBar$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frontpage$BasicBubble$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frontpage$BasicLine$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frontpage$BasicNavigation$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frontpage$BasicScatter$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Frontpage$Concise$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Frontpage$Familiar$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$Interactivity$Background$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$BasicArea$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$BasicBar$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$BasicBin$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$BasicLine$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$BasicStack$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$Border$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$ChangeContent$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$ChangeDot$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$ChangeName$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$ChangeUnit$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$Coordinates$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$Direction$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$DoubleSearch$update = F2(
	function (msg, model) {
		var hoveringDots = msg.a;
		var hoveringBars = msg.b;
		return _Utils_update(
			model,
			{hoveringBars: hoveringBars, hoveringDots: hoveringDots});
	});
var $author$project$Examples$Interactivity$FilterSearch$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$Focal$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$Multiple$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$NoArrow$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$Offset$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$TrickyTooltip$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$Interactivity$Zoom$ReZooming = F4(
	function (a, b, c, d) {
		return {$: 'ReZooming', a: a, b: b, c: c, d: d};
	});
var $author$project$Examples$Interactivity$Zoom$Zoomed = F2(
	function (a, b) {
		return {$: 'Zoomed', a: a, b: b};
	});
var $author$project$Examples$Interactivity$Zoom$Zooming = F2(
	function (a, b) {
		return {$: 'Zooming', a: a, b: b};
	});
var $elm$core$Basics$min = F2(
	function (x, y) {
		return (_Utils_cmp(x, y) < 0) ? x : y;
	});
var $author$project$Examples$Interactivity$Zoom$update = F2(
	function (msg, model) {
		switch (msg.$) {
			case 'OnDown':
				var point = msg.a;
				switch (model.$) {
					case 'NoZoom':
						return A2($author$project$Examples$Interactivity$Zoom$Zooming, point, point);
					case 'Zoomed':
						var start = model.a;
						var end = model.b;
						return A4($author$project$Examples$Interactivity$Zoom$ReZooming, start, end, point, point);
					default:
						return model;
				}
			case 'OnMove':
				var point = msg.a;
				switch (model.$) {
					case 'Zooming':
						var start = model.a;
						return A2($author$project$Examples$Interactivity$Zoom$Zooming, start, point);
					case 'ReZooming':
						var startOld = model.a;
						var endOld = model.b;
						var start = model.c;
						return A4($author$project$Examples$Interactivity$Zoom$ReZooming, startOld, endOld, start, point);
					default:
						return model;
				}
			case 'OnUp':
				var point = msg.a;
				switch (model.$) {
					case 'Zooming':
						var start = model.a;
						return A2(
							$author$project$Examples$Interactivity$Zoom$Zoomed,
							{
								x: A2($elm$core$Basics$min, start.x, point.x),
								y: A2($elm$core$Basics$min, start.y, point.y)
							},
							{
								x: A2($elm$core$Basics$max, start.x, point.x),
								y: A2($elm$core$Basics$max, start.y, point.y)
							});
					case 'ReZooming':
						var start = model.c;
						return A2(
							$author$project$Examples$Interactivity$Zoom$Zoomed,
							{
								x: A2($elm$core$Basics$min, start.x, point.x),
								y: A2($elm$core$Basics$min, start.y, point.y)
							},
							{
								x: A2($elm$core$Basics$max, start.x, point.x),
								y: A2($elm$core$Basics$max, start.y, point.y)
							});
					default:
						return model;
				}
			default:
				return $author$project$Examples$Interactivity$Zoom$NoZoom;
		}
	});
var $author$project$Examples$Interactivity$ZoomAlt$CouldStillBeClick = function (a) {
	return {$: 'CouldStillBeClick', a: a};
};
var $author$project$Examples$Interactivity$ZoomAlt$ForSureDragging = function (a) {
	return {$: 'ForSureDragging', a: a};
};
var $author$project$Examples$Interactivity$ZoomAlt$updateCenter = F3(
	function (center, prevOffset, offset) {
		return {x: center.x + (prevOffset.x - offset.x), y: center.y + (prevOffset.y - offset.y)};
	});
var $author$project$Examples$Interactivity$ZoomAlt$update = F2(
	function (msg, model) {
		switch (msg.$) {
			case 'OnMouseDown':
				var offset = msg.a;
				return _Utils_update(
					model,
					{
						dragging: $author$project$Examples$Interactivity$ZoomAlt$CouldStillBeClick(offset)
					});
			case 'OnMouseMove':
				var offset = msg.a;
				var _v1 = model.dragging;
				switch (_v1.$) {
					case 'CouldStillBeClick':
						var prevOffset = _v1.a;
						return _Utils_eq(prevOffset, offset) ? model : _Utils_update(
							model,
							{
								center: A3($author$project$Examples$Interactivity$ZoomAlt$updateCenter, model.center, prevOffset, offset),
								dragging: $author$project$Examples$Interactivity$ZoomAlt$ForSureDragging(offset)
							});
					case 'ForSureDragging':
						var prevOffset = _v1.a;
						return _Utils_update(
							model,
							{
								center: A3($author$project$Examples$Interactivity$ZoomAlt$updateCenter, model.center, prevOffset, offset),
								dragging: $author$project$Examples$Interactivity$ZoomAlt$ForSureDragging(offset)
							});
					default:
						return model;
				}
			case 'OnMouseUp':
				var offset = msg.a;
				var coord = msg.b;
				var _v2 = model.dragging;
				switch (_v2.$) {
					case 'CouldStillBeClick':
						var prevOffset = _v2.a;
						return _Utils_update(
							model,
							{center: coord, dragging: $author$project$Examples$Interactivity$ZoomAlt$None});
					case 'ForSureDragging':
						var prevOffset = _v2.a;
						return _Utils_update(
							model,
							{
								center: A3($author$project$Examples$Interactivity$ZoomAlt$updateCenter, model.center, prevOffset, offset),
								dragging: $author$project$Examples$Interactivity$ZoomAlt$None
							});
					default:
						return model;
				}
			case 'OnMouseLeave':
				return _Utils_update(
					model,
					{dragging: $author$project$Examples$Interactivity$ZoomAlt$None});
			case 'OnZoomIn':
				return _Utils_update(
					model,
					{percentage: model.percentage + 20});
			case 'OnZoomOut':
				return _Utils_update(
					model,
					{
						percentage: A2($elm$core$Basics$max, 1, model.percentage - 20)
					});
			default:
				return _Utils_update(
					model,
					{
						center: {x: 0, y: 0},
						percentage: 100
					});
		}
	});
var $author$project$Examples$LineCharts$Area$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$LineCharts$Basic$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$LineCharts$Color$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$LineCharts$Dashed$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$LineCharts$Dots$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$LineCharts$Gradient$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$LineCharts$Labels$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$LineCharts$Legends$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$LineCharts$Missing$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$LineCharts$Montone$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$LineCharts$Pattern$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$LineCharts$Stacked$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$LineCharts$Stepped$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$LineCharts$Tooltip$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$LineCharts$TooltipStack$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$LineCharts$Width$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$ScatterCharts$Basic$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$ScatterCharts$Borders$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$ScatterCharts$Colors$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$ScatterCharts$DataDependent$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$ScatterCharts$Highlight$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$ScatterCharts$Labels$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$ScatterCharts$Legends$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$ScatterCharts$Opacity$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$ScatterCharts$Shapes$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$ScatterCharts$Sizes$update = F2(
	function (msg, model) {
		return model;
	});
var $author$project$Examples$ScatterCharts$Tooltip$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Examples$update = F2(
	function (msg, model) {
		switch (msg.$) {
			case 'ExampleMsg0':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example0: A2($author$project$Examples$BarCharts$Gradient$update, sub, model.example0)
					});
			case 'ExampleMsg1':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example1: A2($author$project$Examples$BarCharts$VariableWidth$update, sub, model.example1)
					});
			case 'ExampleMsg2':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example2: A2($author$project$Examples$BarCharts$Title$update, sub, model.example2)
					});
			case 'ExampleMsg3':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example3: A2($author$project$Examples$BarCharts$TooltipStack$update, sub, model.example3)
					});
			case 'ExampleMsg4':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example4: A2($author$project$Examples$BarCharts$Tooltip$update, sub, model.example4)
					});
			case 'ExampleMsg5':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example5: A2($author$project$Examples$BarCharts$BarLabels$update, sub, model.example5)
					});
			case 'ExampleMsg6':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example6: A2($author$project$Examples$BarCharts$Pattern$update, sub, model.example6)
					});
			case 'ExampleMsg7':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example7: A2($author$project$Examples$BarCharts$Histogram$update, sub, model.example7)
					});
			case 'ExampleMsg8':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example8: A2($author$project$Examples$BarCharts$BinLabelsAdvanced$update, sub, model.example8)
					});
			case 'ExampleMsg9':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example9: A2($author$project$Examples$BarCharts$Spacing$update, sub, model.example9)
					});
			case 'ExampleMsg10':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example10: A2($author$project$Examples$BarCharts$Highlight$update, sub, model.example10)
					});
			case 'ExampleMsg11':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example11: A2($author$project$Examples$BarCharts$DataDependent$update, sub, model.example11)
					});
			case 'ExampleMsg12':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example12: A2($author$project$Examples$BarCharts$Color$update, sub, model.example12)
					});
			case 'ExampleMsg13':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example13: A2($author$project$Examples$BarCharts$TooltipBin$update, sub, model.example13)
					});
			case 'ExampleMsg14':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example14: A2($author$project$Examples$BarCharts$Corners$update, sub, model.example14)
					});
			case 'ExampleMsg15':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example15: A2($author$project$Examples$BarCharts$Ungroup$update, sub, model.example15)
					});
			case 'ExampleMsg16':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example16: A2($author$project$Examples$BarCharts$BinLabels$update, sub, model.example16)
					});
			case 'ExampleMsg17':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example17: A2($author$project$Examples$BarCharts$Stacked$update, sub, model.example17)
					});
			case 'ExampleMsg18':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example18: A2($author$project$Examples$BarCharts$Margin$update, sub, model.example18)
					});
			case 'ExampleMsg19':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example19: A2($author$project$Examples$BarCharts$Borders$update, sub, model.example19)
					});
			case 'ExampleMsg20':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example20: A2($author$project$Examples$BarCharts$Opacity$update, sub, model.example20)
					});
			case 'ExampleMsg21':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example21: A2($author$project$Examples$BarCharts$Legends$update, sub, model.example21)
					});
			case 'ExampleMsg22':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example22: A2($author$project$Examples$BarCharts$Basic$update, sub, model.example22)
					});
			case 'ExampleMsg23':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example23: A2($author$project$Examples$Frame$Lines$update, sub, model.example23)
					});
			case 'ExampleMsg24':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example24: A2($author$project$Examples$Frame$Position$update, sub, model.example24)
					});
			case 'ExampleMsg25':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example25: A2($author$project$Examples$Frame$Coordinates$update, sub, model.example25)
					});
			case 'ExampleMsg26':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example26: A2($author$project$Examples$Frame$GridFilter$update, sub, model.example26)
					});
			case 'ExampleMsg27':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example27: A2($author$project$Examples$Frame$Dimensions$update, sub, model.example27)
					});
			case 'ExampleMsg28':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example28: A2($author$project$Examples$Frame$CustomElements$update, sub, model.example28)
					});
			case 'ExampleMsg29':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example29: A2($author$project$Examples$Frame$NoArrow$update, sub, model.example29)
					});
			case 'ExampleMsg30':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example30: A2($author$project$Examples$Frame$Background$update, sub, model.example30)
					});
			case 'ExampleMsg31':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example31: A2($author$project$Examples$Frame$Rect$update, sub, model.example31)
					});
			case 'ExampleMsg32':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example32: A2($author$project$Examples$Frame$Padding$update, sub, model.example32)
					});
			case 'ExampleMsg33':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example33: A2($author$project$Examples$Frame$Times$update, sub, model.example33)
					});
			case 'ExampleMsg34':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example34: A2($author$project$Examples$Frame$OnlyInts$update, sub, model.example34)
					});
			case 'ExampleMsg35':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example35: A2($author$project$Examples$Frame$GridColor$update, sub, model.example35)
					});
			case 'ExampleMsg36':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example36: A2($author$project$Examples$Frame$Offset$update, sub, model.example36)
					});
			case 'ExampleMsg37':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example37: A2($author$project$Examples$Frame$Ellipsis$update, sub, model.example37)
					});
			case 'ExampleMsg38':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example38: A2($author$project$Examples$Frame$Color$update, sub, model.example38)
					});
			case 'ExampleMsg39':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example39: A2($author$project$Examples$Frame$Amount$update, sub, model.example39)
					});
			case 'ExampleMsg40':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example40: A2($author$project$Examples$Frame$Titles$update, sub, model.example40)
					});
			case 'ExampleMsg41':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example41: A2($author$project$Examples$Frame$CustomLabels$update, sub, model.example41)
					});
			case 'ExampleMsg42':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example42: A2($author$project$Examples$Frame$Margin$update, sub, model.example42)
					});
			case 'ExampleMsg43':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example43: A2($author$project$Examples$Frame$LabelWithLine$update, sub, model.example43)
					});
			case 'ExampleMsg44':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example44: A2($author$project$Examples$Frame$DotGrid$update, sub, model.example44)
					});
			case 'ExampleMsg45':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example45: A2($author$project$Examples$Frame$CustomFormat$update, sub, model.example45)
					});
			case 'ExampleMsg46':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example46: A2($author$project$Examples$Frame$AxisLength$update, sub, model.example46)
					});
			case 'ExampleMsg47':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example47: A2($author$project$Examples$Frame$Arbitrary$update, sub, model.example47)
					});
			case 'ExampleMsg48':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example48: A2($author$project$Examples$Frame$Legends$update, sub, model.example48)
					});
			case 'ExampleMsg49':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example49: A2($author$project$Examples$Frame$Basic$update, sub, model.example49)
					});
			case 'ExampleMsg50':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example50: A2($author$project$Examples$Interactivity$ChangeContent$update, sub, model.example50)
					});
			case 'ExampleMsg51':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example51: A2($author$project$Examples$Interactivity$Direction$update, sub, model.example51)
					});
			case 'ExampleMsg52':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example52: A2($author$project$Examples$Interactivity$ChangeDot$update, sub, model.example52)
					});
			case 'ExampleMsg53':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example53: A2($author$project$Examples$Interactivity$Border$update, sub, model.example53)
					});
			case 'ExampleMsg54':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example54: A2($author$project$Examples$Interactivity$Zoom$update, sub, model.example54)
					});
			case 'ExampleMsg55':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example55: A2($author$project$Examples$Interactivity$BasicBin$update, sub, model.example55)
					});
			case 'ExampleMsg56':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example56: A2($author$project$Examples$Interactivity$BasicStack$update, sub, model.example56)
					});
			case 'ExampleMsg57':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example57: A2($author$project$Examples$Interactivity$Coordinates$update, sub, model.example57)
					});
			case 'ExampleMsg58':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example58: A2($author$project$Examples$Interactivity$ChangeName$update, sub, model.example58)
					});
			case 'ExampleMsg59':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example59: A2($author$project$Examples$Interactivity$NoArrow$update, sub, model.example59)
					});
			case 'ExampleMsg60':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example60: A2($author$project$Examples$Interactivity$FilterSearch$update, sub, model.example60)
					});
			case 'ExampleMsg61':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example61: A2($author$project$Examples$Interactivity$Background$update, sub, model.example61)
					});
			case 'ExampleMsg62':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example62: A2($author$project$Examples$Interactivity$BasicBar$update, sub, model.example62)
					});
			case 'ExampleMsg63':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example63: A2($author$project$Examples$Interactivity$BasicArea$update, sub, model.example63)
					});
			case 'ExampleMsg64':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example64: A2($author$project$Examples$Interactivity$ZoomAlt$update, sub, model.example64)
					});
			case 'ExampleMsg65':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example65: A2($author$project$Examples$Interactivity$TrickyTooltip$update, sub, model.example65)
					});
			case 'ExampleMsg66':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example66: A2($author$project$Examples$Interactivity$Multiple$update, sub, model.example66)
					});
			case 'ExampleMsg67':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example67: A2($author$project$Examples$Interactivity$BasicLine$update, sub, model.example67)
					});
			case 'ExampleMsg68':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example68: A2($author$project$Examples$Interactivity$Offset$update, sub, model.example68)
					});
			case 'ExampleMsg69':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example69: A2($author$project$Examples$Interactivity$DoubleSearch$update, sub, model.example69)
					});
			case 'ExampleMsg70':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example70: A2($author$project$Examples$Interactivity$ChangeUnit$update, sub, model.example70)
					});
			case 'ExampleMsg71':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example71: A2($author$project$Examples$Interactivity$Focal$update, sub, model.example71)
					});
			case 'ExampleMsg72':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example72: A2($author$project$Examples$LineCharts$Area$update, sub, model.example72)
					});
			case 'ExampleMsg73':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example73: A2($author$project$Examples$LineCharts$Gradient$update, sub, model.example73)
					});
			case 'ExampleMsg74':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example74: A2($author$project$Examples$LineCharts$Width$update, sub, model.example74)
					});
			case 'ExampleMsg75':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example75: A2($author$project$Examples$LineCharts$TooltipStack$update, sub, model.example75)
					});
			case 'ExampleMsg76':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example76: A2($author$project$Examples$LineCharts$Tooltip$update, sub, model.example76)
					});
			case 'ExampleMsg77':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example77: A2($author$project$Examples$LineCharts$Montone$update, sub, model.example77)
					});
			case 'ExampleMsg78':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example78: A2($author$project$Examples$LineCharts$Pattern$update, sub, model.example78)
					});
			case 'ExampleMsg79':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example79: A2($author$project$Examples$LineCharts$Dots$update, sub, model.example79)
					});
			case 'ExampleMsg80':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example80: A2($author$project$Examples$LineCharts$Dashed$update, sub, model.example80)
					});
			case 'ExampleMsg81':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example81: A2($author$project$Examples$LineCharts$Color$update, sub, model.example81)
					});
			case 'ExampleMsg82':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example82: A2($author$project$Examples$LineCharts$Stepped$update, sub, model.example82)
					});
			case 'ExampleMsg83':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example83: A2($author$project$Examples$LineCharts$Stacked$update, sub, model.example83)
					});
			case 'ExampleMsg84':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example84: A2($author$project$Examples$LineCharts$Labels$update, sub, model.example84)
					});
			case 'ExampleMsg85':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example85: A2($author$project$Examples$LineCharts$Missing$update, sub, model.example85)
					});
			case 'ExampleMsg86':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example86: A2($author$project$Examples$LineCharts$Legends$update, sub, model.example86)
					});
			case 'ExampleMsg87':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example87: A2($author$project$Examples$LineCharts$Basic$update, sub, model.example87)
					});
			case 'ExampleMsg88':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example88: A2($author$project$Examples$Frontpage$BasicBubble$update, sub, model.example88)
					});
			case 'ExampleMsg89':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example89: A2($author$project$Examples$Frontpage$BasicNavigation$update, sub, model.example89)
					});
			case 'ExampleMsg90':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example90: A2($author$project$Examples$Frontpage$BasicBar$update, sub, model.example90)
					});
			case 'ExampleMsg91':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example91: A2($author$project$Examples$Frontpage$BasicArea$update, sub, model.example91)
					});
			case 'ExampleMsg92':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example92: A2($author$project$Examples$Frontpage$Concise$update, sub, model.example92)
					});
			case 'ExampleMsg93':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example93: A2($author$project$Examples$Frontpage$BasicLine$update, sub, model.example93)
					});
			case 'ExampleMsg94':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example94: A2($author$project$Examples$Frontpage$BasicScatter$update, sub, model.example94)
					});
			case 'ExampleMsg95':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example95: A2($author$project$Examples$Frontpage$Familiar$update, sub, model.example95)
					});
			case 'ExampleMsg96':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example96: A2($author$project$Examples$ScatterCharts$Colors$update, sub, model.example96)
					});
			case 'ExampleMsg97':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example97: A2($author$project$Examples$ScatterCharts$Shapes$update, sub, model.example97)
					});
			case 'ExampleMsg98':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example98: A2($author$project$Examples$ScatterCharts$Tooltip$update, sub, model.example98)
					});
			case 'ExampleMsg99':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example99: A2($author$project$Examples$ScatterCharts$Highlight$update, sub, model.example99)
					});
			case 'ExampleMsg100':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example100: A2($author$project$Examples$ScatterCharts$DataDependent$update, sub, model.example100)
					});
			case 'ExampleMsg101':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example101: A2($author$project$Examples$ScatterCharts$Borders$update, sub, model.example101)
					});
			case 'ExampleMsg102':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example102: A2($author$project$Examples$ScatterCharts$Labels$update, sub, model.example102)
					});
			case 'ExampleMsg103':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example103: A2($author$project$Examples$ScatterCharts$Opacity$update, sub, model.example103)
					});
			case 'ExampleMsg104':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example104: A2($author$project$Examples$ScatterCharts$Sizes$update, sub, model.example104)
					});
			case 'ExampleMsg105':
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example105: A2($author$project$Examples$ScatterCharts$Legends$update, sub, model.example105)
					});
			default:
				var sub = msg.a;
				return _Utils_update(
					model,
					{
						example106: A2($author$project$Examples$ScatterCharts$Basic$update, sub, model.example106)
					});
		}
	});
var $author$project$Page$Section$update = F3(
	function (key, msg, model) {
		switch (msg.$) {
			case 'OnResize':
				var width = msg.a;
				var height = msg.b;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							window: {height: height, width: width}
						}),
					$elm$core$Platform$Cmd$none);
			case 'MenuMsg':
				var subMsg = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							menu: A2($author$project$Ui$Menu$update, subMsg, model.menu)
						}),
					$elm$core$Platform$Cmd$none);
			default:
				var sub = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							examples: A2($author$project$Examples$update, sub, model.examples)
						}),
					$elm$core$Platform$Cmd$none);
		}
	});
var $author$project$Page$Documentation$update = $author$project$Page$Section$update;
var $author$project$Page$Example$update = F3(
	function (key, msg, model) {
		switch (msg.$) {
			case 'OnResize':
				var width = msg.a;
				var height = msg.b;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							window: {height: height, width: width}
						}),
					$elm$core$Platform$Cmd$none);
			case 'MenuMsg':
				var subMsg = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							menu: A2($author$project$Ui$Menu$update, subMsg, model.menu)
						}),
					$elm$core$Platform$Cmd$none);
			case 'OnExampleMsg':
				var sub = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							examples: A2($author$project$Examples$update, sub, model.examples)
						}),
					$elm$core$Platform$Cmd$none);
			default:
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{showFullCode: !model.showFullCode}),
					$elm$core$Platform$Cmd$none);
		}
	});
var $author$project$Page$GettingStarted$update = F3(
	function (key, msg, model) {
		switch (msg.$) {
			case 'OnResize':
				var width = msg.a;
				var height = msg.b;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							window: {height: height, width: width}
						}),
					$elm$core$Platform$Cmd$none);
			case 'MenuMsg':
				var subMsg = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							menu: A2($author$project$Ui$Menu$update, subMsg, model.menu)
						}),
					$elm$core$Platform$Cmd$none);
			default:
				return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
		}
	});
var $author$project$Charts$Dashboard1$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		var hoveringBars = msg.b;
		return _Utils_update(
			model,
			{hovering: hovering, hoveringBars: hoveringBars});
	});
var $author$project$Charts$Dashboard2$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Charts$Dashboard3$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Charts$Dashboard4$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Charts$Dashboard5$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		return _Utils_update(
			model,
			{hovering: hovering});
	});
var $author$project$Charts$Landing$update = F2(
	function (msg, model) {
		var hovering = msg.a;
		var hoveringBars = msg.b;
		return _Utils_update(
			model,
			{hovering: hovering, hoveringBars: hoveringBars});
	});
var $author$project$Page$Home$update = F3(
	function (key, msg, model) {
		switch (msg.$) {
			case 'OnResize':
				var width = msg.a;
				var height = msg.b;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							window: {height: height, width: width}
						}),
					$elm$core$Platform$Cmd$none);
			case 'MenuMsg':
				var subMsg = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							menu: A2($author$project$Ui$Menu$update, subMsg, model.menu)
						}),
					$elm$core$Platform$Cmd$none);
			case 'ConciseMsg':
				var subMsg = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							concise: A2($author$project$Examples$Frontpage$Concise$update, subMsg, model.concise)
						}),
					$elm$core$Platform$Cmd$none);
			case 'FamiliarToggle':
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{familiarToggle: !model.familiarToggle}),
					$elm$core$Platform$Cmd$none);
			case 'LandingMsg':
				var subMsg = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							landing: A2($author$project$Charts$Landing$update, subMsg, model.landing)
						}),
					$elm$core$Platform$Cmd$none);
			case 'OnHover':
				var hovering = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{hovering: hovering}),
					$elm$core$Platform$Cmd$none);
			case 'Dashboard1Msg':
				var subMsg = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							dashboard1: A2($author$project$Charts$Dashboard1$update, subMsg, model.dashboard1)
						}),
					$elm$core$Platform$Cmd$none);
			case 'Dashboard2Msg':
				var subMsg = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							dashboard2: A2($author$project$Charts$Dashboard2$update, subMsg, model.dashboard2)
						}),
					$elm$core$Platform$Cmd$none);
			case 'Dashboard3Msg':
				var subMsg = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							dashboard3: A2($author$project$Charts$Dashboard3$update, subMsg, model.dashboard3)
						}),
					$elm$core$Platform$Cmd$none);
			case 'Dashboard4Msg':
				var subMsg = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							dashboard4: A2($author$project$Charts$Dashboard4$update, subMsg, model.dashboard4)
						}),
					$elm$core$Platform$Cmd$none);
			case 'Dashboard5Msg':
				var subMsg = msg.a;
				return _Utils_Tuple2(
					_Utils_update(
						model,
						{
							dashboard5: A2($author$project$Charts$Dashboard5$update, subMsg, model.dashboard5)
						}),
					$elm$core$Platform$Cmd$none);
			default:
				return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
		}
	});
var $author$project$Main$update = F2(
	function (msg, model) {
		var _v0 = _Utils_Tuple2(msg, model.page);
		_v0$8:
		while (true) {
			switch (_v0.a.$) {
				case 'ClickedLink':
					var urlRequest = _v0.a.a;
					if (urlRequest.$ === 'Internal') {
						var url = urlRequest.a;
						return _Utils_Tuple2(
							model,
							A2(
								$elm$browser$Browser$Navigation$pushUrl,
								model.navigation,
								$elm$url$Url$toString(url)));
					} else {
						var href = urlRequest.a;
						return _Utils_Tuple2(
							model,
							$elm$browser$Browser$Navigation$load(href));
					}
				case 'ChangedUrl':
					var url = _v0.a.a;
					return A2(
						$author$project$Main$changeRouteTo,
						$author$project$Route$fromUrl(url),
						model);
				case 'Page_Home_Msg':
					if (_v0.b.$ === 'Page_Home') {
						var subMsg = _v0.a.a;
						var subModel = _v0.b.a;
						return A4(
							$author$project$Main$updateWith,
							$author$project$Main$Page_Home,
							$author$project$Main$Page_Home_Msg,
							model,
							A3($author$project$Page$Home$update, model.navigation, subMsg, subModel));
					} else {
						break _v0$8;
					}
				case 'Page_Administration_Msg':
					if (_v0.b.$ === 'Page_Administration') {
						var subMsg = _v0.a.a;
						var subModel = _v0.b.a;
						return A4(
							$author$project$Main$updateWith,
							$author$project$Main$Page_Administration,
							$author$project$Main$Page_Administration_Msg,
							model,
							A3($author$project$Page$Administration$update, model.navigation, subMsg, subModel));
					} else {
						break _v0$8;
					}
				case 'Page_Documentation_Msg':
					if (_v0.b.$ === 'Page_Documentation') {
						var subMsg = _v0.a.a;
						var subModel = _v0.b.a;
						return A4(
							$author$project$Main$updateWith,
							$author$project$Main$Page_Documentation,
							$author$project$Main$Page_Documentation_Msg,
							model,
							A3($author$project$Page$Documentation$update, model.navigation, subMsg, subModel));
					} else {
						break _v0$8;
					}
				case 'Page_Section_Msg':
					if (_v0.b.$ === 'Page_Section') {
						var subMsg = _v0.a.a;
						var subModel = _v0.b.a;
						return A4(
							$author$project$Main$updateWith,
							$author$project$Main$Page_Section,
							$author$project$Main$Page_Section_Msg,
							model,
							A3($author$project$Page$Section$update, model.navigation, subMsg, subModel));
					} else {
						break _v0$8;
					}
				case 'Page_Example_Msg':
					if (_v0.b.$ === 'Page_Example') {
						var subMsg = _v0.a.a;
						var subModel = _v0.b.a;
						return A4(
							$author$project$Main$updateWith,
							$author$project$Main$Page_Example,
							$author$project$Main$Page_Example_Msg,
							model,
							A3($author$project$Page$Example$update, model.navigation, subMsg, subModel));
					} else {
						break _v0$8;
					}
				default:
					if (_v0.b.$ === 'Page_GettingStarted') {
						var subMsg = _v0.a.a;
						var subModel = _v0.b.a;
						return A4(
							$author$project$Main$updateWith,
							$author$project$Main$Page_GettingStarted,
							$author$project$Main$Page_GettingStarted_Msg,
							model,
							A3($author$project$Page$GettingStarted$update, model.navigation, subMsg, subModel));
					} else {
						break _v0$8;
					}
			}
		}
		return _Utils_Tuple2(model, $elm$core$Platform$Cmd$none);
	});
var $elm$json$Json$Decode$value = _Json_decodeValue;
var $elm$virtual_dom$VirtualDom$map = _VirtualDom_map;
var $elm$html$Html$map = $elm$virtual_dom$VirtualDom$map;
var $elm$virtual_dom$VirtualDom$text = _VirtualDom_text;
var $elm$html$Html$text = $elm$virtual_dom$VirtualDom$text;
var $author$project$Page$Administration$MenuMsg = function (a) {
	return {$: 'MenuMsg', a: a};
};
var $mdgriffith$elm_ui$Internal$Model$Unkeyed = function (a) {
	return {$: 'Unkeyed', a: a};
};
var $mdgriffith$elm_ui$Internal$Model$AsEl = {$: 'AsEl'};
var $mdgriffith$elm_ui$Internal$Model$asEl = $mdgriffith$elm_ui$Internal$Model$AsEl;
var $mdgriffith$elm_ui$Internal$Model$Generic = {$: 'Generic'};
var $mdgriffith$elm_ui$Internal$Model$div = $mdgriffith$elm_ui$Internal$Model$Generic;
var $mdgriffith$elm_ui$Internal$Model$NoNearbyChildren = {$: 'NoNearbyChildren'};
var $mdgriffith$elm_ui$Internal$Style$classes = {above: 'a', active: 'atv', alignBottom: 'ab', alignCenterX: 'cx', alignCenterY: 'cy', alignContainerBottom: 'acb', alignContainerCenterX: 'accx', alignContainerCenterY: 'accy', alignContainerRight: 'acr', alignLeft: 'al', alignRight: 'ar', alignTop: 'at', alignedHorizontally: 'ah', alignedVertically: 'av', any: 's', behind: 'bh', below: 'b', bold: 'w7', borderDashed: 'bd', borderDotted: 'bdt', borderNone: 'bn', borderSolid: 'bs', capturePointerEvents: 'cpe', clip: 'cp', clipX: 'cpx', clipY: 'cpy', column: 'c', container: 'ctr', contentBottom: 'cb', contentCenterX: 'ccx', contentCenterY: 'ccy', contentLeft: 'cl', contentRight: 'cr', contentTop: 'ct', cursorPointer: 'cptr', cursorText: 'ctxt', focus: 'fcs', focusedWithin: 'focus-within', fullSize: 'fs', grid: 'g', hasBehind: 'hbh', heightContent: 'hc', heightExact: 'he', heightFill: 'hf', heightFillPortion: 'hfp', hover: 'hv', imageContainer: 'ic', inFront: 'fr', inputLabel: 'lbl', inputMultiline: 'iml', inputMultilineFiller: 'imlf', inputMultilineParent: 'imlp', inputMultilineWrapper: 'implw', inputText: 'it', italic: 'i', link: 'lnk', nearby: 'nb', noTextSelection: 'notxt', onLeft: 'ol', onRight: 'or', opaque: 'oq', overflowHidden: 'oh', page: 'pg', paragraph: 'p', passPointerEvents: 'ppe', root: 'ui', row: 'r', scrollbars: 'sb', scrollbarsX: 'sbx', scrollbarsY: 'sby', seButton: 'sbt', single: 'e', sizeByCapital: 'cap', spaceEvenly: 'sev', strike: 'sk', text: 't', textCenter: 'tc', textExtraBold: 'w8', textExtraLight: 'w2', textHeavy: 'w9', textJustify: 'tj', textJustifyAll: 'tja', textLeft: 'tl', textLight: 'w3', textMedium: 'w5', textNormalWeight: 'w4', textRight: 'tr', textSemiBold: 'w6', textThin: 'w1', textUnitalicized: 'tun', transition: 'ts', transparent: 'clr', underline: 'u', widthContent: 'wc', widthExact: 'we', widthFill: 'wf', widthFillPortion: 'wfp', wrapped: 'wrp'};
var $mdgriffith$elm_ui$Internal$Model$columnClass = $mdgriffith$elm_ui$Internal$Style$classes.any + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.column);
var $mdgriffith$elm_ui$Internal$Model$gridClass = $mdgriffith$elm_ui$Internal$Style$classes.any + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.grid);
var $mdgriffith$elm_ui$Internal$Model$pageClass = $mdgriffith$elm_ui$Internal$Style$classes.any + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.page);
var $mdgriffith$elm_ui$Internal$Model$paragraphClass = $mdgriffith$elm_ui$Internal$Style$classes.any + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.paragraph);
var $mdgriffith$elm_ui$Internal$Model$rowClass = $mdgriffith$elm_ui$Internal$Style$classes.any + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.row);
var $mdgriffith$elm_ui$Internal$Model$singleClass = $mdgriffith$elm_ui$Internal$Style$classes.any + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.single);
var $mdgriffith$elm_ui$Internal$Model$contextClasses = function (context) {
	switch (context.$) {
		case 'AsRow':
			return $mdgriffith$elm_ui$Internal$Model$rowClass;
		case 'AsColumn':
			return $mdgriffith$elm_ui$Internal$Model$columnClass;
		case 'AsEl':
			return $mdgriffith$elm_ui$Internal$Model$singleClass;
		case 'AsGrid':
			return $mdgriffith$elm_ui$Internal$Model$gridClass;
		case 'AsParagraph':
			return $mdgriffith$elm_ui$Internal$Model$paragraphClass;
		default:
			return $mdgriffith$elm_ui$Internal$Model$pageClass;
	}
};
var $mdgriffith$elm_ui$Internal$Model$Keyed = function (a) {
	return {$: 'Keyed', a: a};
};
var $mdgriffith$elm_ui$Internal$Model$NoStyleSheet = {$: 'NoStyleSheet'};
var $mdgriffith$elm_ui$Internal$Model$Styled = function (a) {
	return {$: 'Styled', a: a};
};
var $mdgriffith$elm_ui$Internal$Model$Unstyled = function (a) {
	return {$: 'Unstyled', a: a};
};
var $mdgriffith$elm_ui$Internal$Model$addChildren = F2(
	function (existing, nearbyChildren) {
		switch (nearbyChildren.$) {
			case 'NoNearbyChildren':
				return existing;
			case 'ChildrenBehind':
				var behind = nearbyChildren.a;
				return _Utils_ap(behind, existing);
			case 'ChildrenInFront':
				var inFront = nearbyChildren.a;
				return _Utils_ap(existing, inFront);
			default:
				var behind = nearbyChildren.a;
				var inFront = nearbyChildren.b;
				return _Utils_ap(
					behind,
					_Utils_ap(existing, inFront));
		}
	});
var $mdgriffith$elm_ui$Internal$Model$addKeyedChildren = F3(
	function (key, existing, nearbyChildren) {
		switch (nearbyChildren.$) {
			case 'NoNearbyChildren':
				return existing;
			case 'ChildrenBehind':
				var behind = nearbyChildren.a;
				return _Utils_ap(
					A2(
						$elm$core$List$map,
						function (x) {
							return _Utils_Tuple2(key, x);
						},
						behind),
					existing);
			case 'ChildrenInFront':
				var inFront = nearbyChildren.a;
				return _Utils_ap(
					existing,
					A2(
						$elm$core$List$map,
						function (x) {
							return _Utils_Tuple2(key, x);
						},
						inFront));
			default:
				var behind = nearbyChildren.a;
				var inFront = nearbyChildren.b;
				return _Utils_ap(
					A2(
						$elm$core$List$map,
						function (x) {
							return _Utils_Tuple2(key, x);
						},
						behind),
					_Utils_ap(
						existing,
						A2(
							$elm$core$List$map,
							function (x) {
								return _Utils_Tuple2(key, x);
							},
							inFront)));
		}
	});
var $mdgriffith$elm_ui$Internal$Model$AsParagraph = {$: 'AsParagraph'};
var $mdgriffith$elm_ui$Internal$Model$asParagraph = $mdgriffith$elm_ui$Internal$Model$AsParagraph;
var $mdgriffith$elm_ui$Internal$Flag$Flag = function (a) {
	return {$: 'Flag', a: a};
};
var $mdgriffith$elm_ui$Internal$Flag$Second = function (a) {
	return {$: 'Second', a: a};
};
var $elm$core$Bitwise$shiftLeftBy = _Bitwise_shiftLeftBy;
var $mdgriffith$elm_ui$Internal$Flag$flag = function (i) {
	return (i > 31) ? $mdgriffith$elm_ui$Internal$Flag$Second(1 << (i - 32)) : $mdgriffith$elm_ui$Internal$Flag$Flag(1 << i);
};
var $mdgriffith$elm_ui$Internal$Flag$alignBottom = $mdgriffith$elm_ui$Internal$Flag$flag(41);
var $mdgriffith$elm_ui$Internal$Flag$alignRight = $mdgriffith$elm_ui$Internal$Flag$flag(40);
var $mdgriffith$elm_ui$Internal$Flag$centerX = $mdgriffith$elm_ui$Internal$Flag$flag(42);
var $mdgriffith$elm_ui$Internal$Flag$centerY = $mdgriffith$elm_ui$Internal$Flag$flag(43);
var $elm$json$Json$Encode$string = _Json_wrap;
var $elm$html$Html$Attributes$stringProperty = F2(
	function (key, string) {
		return A2(
			_VirtualDom_property,
			key,
			$elm$json$Json$Encode$string(string));
	});
var $elm$html$Html$Attributes$class = $elm$html$Html$Attributes$stringProperty('className');
var $elm$html$Html$div = _VirtualDom_node('div');
var $elm$core$Set$Set_elm_builtin = function (a) {
	return {$: 'Set_elm_builtin', a: a};
};
var $elm$core$Set$empty = $elm$core$Set$Set_elm_builtin($elm$core$Dict$empty);
var $mdgriffith$elm_ui$Internal$Model$lengthClassName = function (x) {
	switch (x.$) {
		case 'Px':
			var px = x.a;
			return $elm$core$String$fromInt(px) + 'px';
		case 'Content':
			return 'auto';
		case 'Fill':
			var i = x.a;
			return $elm$core$String$fromInt(i) + 'fr';
		case 'Min':
			var min = x.a;
			var len = x.b;
			return 'min' + ($elm$core$String$fromInt(min) + $mdgriffith$elm_ui$Internal$Model$lengthClassName(len));
		default:
			var max = x.a;
			var len = x.b;
			return 'max' + ($elm$core$String$fromInt(max) + $mdgriffith$elm_ui$Internal$Model$lengthClassName(len));
	}
};
var $elm$core$Tuple$second = function (_v0) {
	var y = _v0.b;
	return y;
};
var $elm$core$Basics$round = _Basics_round;
var $mdgriffith$elm_ui$Internal$Model$floatClass = function (x) {
	return $elm$core$String$fromInt(
		$elm$core$Basics$round(x * 255));
};
var $mdgriffith$elm_ui$Internal$Model$transformClass = function (transform) {
	switch (transform.$) {
		case 'Untransformed':
			return $elm$core$Maybe$Nothing;
		case 'Moved':
			var _v1 = transform.a;
			var x = _v1.a;
			var y = _v1.b;
			var z = _v1.c;
			return $elm$core$Maybe$Just(
				'mv-' + ($mdgriffith$elm_ui$Internal$Model$floatClass(x) + ('-' + ($mdgriffith$elm_ui$Internal$Model$floatClass(y) + ('-' + $mdgriffith$elm_ui$Internal$Model$floatClass(z))))));
		default:
			var _v2 = transform.a;
			var tx = _v2.a;
			var ty = _v2.b;
			var tz = _v2.c;
			var _v3 = transform.b;
			var sx = _v3.a;
			var sy = _v3.b;
			var sz = _v3.c;
			var _v4 = transform.c;
			var ox = _v4.a;
			var oy = _v4.b;
			var oz = _v4.c;
			var angle = transform.d;
			return $elm$core$Maybe$Just(
				'tfrm-' + ($mdgriffith$elm_ui$Internal$Model$floatClass(tx) + ('-' + ($mdgriffith$elm_ui$Internal$Model$floatClass(ty) + ('-' + ($mdgriffith$elm_ui$Internal$Model$floatClass(tz) + ('-' + ($mdgriffith$elm_ui$Internal$Model$floatClass(sx) + ('-' + ($mdgriffith$elm_ui$Internal$Model$floatClass(sy) + ('-' + ($mdgriffith$elm_ui$Internal$Model$floatClass(sz) + ('-' + ($mdgriffith$elm_ui$Internal$Model$floatClass(ox) + ('-' + ($mdgriffith$elm_ui$Internal$Model$floatClass(oy) + ('-' + ($mdgriffith$elm_ui$Internal$Model$floatClass(oz) + ('-' + $mdgriffith$elm_ui$Internal$Model$floatClass(angle))))))))))))))))))));
	}
};
var $mdgriffith$elm_ui$Internal$Model$getStyleName = function (style) {
	switch (style.$) {
		case 'Shadows':
			var name = style.a;
			return name;
		case 'Transparency':
			var name = style.a;
			var o = style.b;
			return name;
		case 'Style':
			var _class = style.a;
			return _class;
		case 'FontFamily':
			var name = style.a;
			return name;
		case 'FontSize':
			var i = style.a;
			return 'font-size-' + $elm$core$String$fromInt(i);
		case 'Single':
			var _class = style.a;
			return _class;
		case 'Colored':
			var _class = style.a;
			return _class;
		case 'SpacingStyle':
			var cls = style.a;
			var x = style.b;
			var y = style.c;
			return cls;
		case 'PaddingStyle':
			var cls = style.a;
			var top = style.b;
			var right = style.c;
			var bottom = style.d;
			var left = style.e;
			return cls;
		case 'BorderWidth':
			var cls = style.a;
			var top = style.b;
			var right = style.c;
			var bottom = style.d;
			var left = style.e;
			return cls;
		case 'GridTemplateStyle':
			var template = style.a;
			return 'grid-rows-' + (A2(
				$elm$core$String$join,
				'-',
				A2($elm$core$List$map, $mdgriffith$elm_ui$Internal$Model$lengthClassName, template.rows)) + ('-cols-' + (A2(
				$elm$core$String$join,
				'-',
				A2($elm$core$List$map, $mdgriffith$elm_ui$Internal$Model$lengthClassName, template.columns)) + ('-space-x-' + ($mdgriffith$elm_ui$Internal$Model$lengthClassName(template.spacing.a) + ('-space-y-' + $mdgriffith$elm_ui$Internal$Model$lengthClassName(template.spacing.b)))))));
		case 'GridPosition':
			var pos = style.a;
			return 'gp grid-pos-' + ($elm$core$String$fromInt(pos.row) + ('-' + ($elm$core$String$fromInt(pos.col) + ('-' + ($elm$core$String$fromInt(pos.width) + ('-' + $elm$core$String$fromInt(pos.height)))))));
		case 'PseudoSelector':
			var selector = style.a;
			var subStyle = style.b;
			var name = function () {
				switch (selector.$) {
					case 'Focus':
						return 'fs';
					case 'Hover':
						return 'hv';
					default:
						return 'act';
				}
			}();
			return A2(
				$elm$core$String$join,
				' ',
				A2(
					$elm$core$List$map,
					function (sty) {
						var _v1 = $mdgriffith$elm_ui$Internal$Model$getStyleName(sty);
						if (_v1 === '') {
							return '';
						} else {
							var styleName = _v1;
							return styleName + ('-' + name);
						}
					},
					subStyle));
		default:
			var x = style.a;
			return A2(
				$elm$core$Maybe$withDefault,
				'',
				$mdgriffith$elm_ui$Internal$Model$transformClass(x));
	}
};
var $elm$core$Set$insert = F2(
	function (key, _v0) {
		var dict = _v0.a;
		return $elm$core$Set$Set_elm_builtin(
			A3($elm$core$Dict$insert, key, _Utils_Tuple0, dict));
	});
var $elm$core$Dict$member = F2(
	function (key, dict) {
		var _v0 = A2($elm$core$Dict$get, key, dict);
		if (_v0.$ === 'Just') {
			return true;
		} else {
			return false;
		}
	});
var $elm$core$Set$member = F2(
	function (key, _v0) {
		var dict = _v0.a;
		return A2($elm$core$Dict$member, key, dict);
	});
var $mdgriffith$elm_ui$Internal$Model$reduceStyles = F2(
	function (style, nevermind) {
		var cache = nevermind.a;
		var existing = nevermind.b;
		var styleName = $mdgriffith$elm_ui$Internal$Model$getStyleName(style);
		return A2($elm$core$Set$member, styleName, cache) ? nevermind : _Utils_Tuple2(
			A2($elm$core$Set$insert, styleName, cache),
			A2($elm$core$List$cons, style, existing));
	});
var $mdgriffith$elm_ui$Internal$Model$Property = F2(
	function (a, b) {
		return {$: 'Property', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Model$Style = F2(
	function (a, b) {
		return {$: 'Style', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Style$dot = function (c) {
	return '.' + c;
};
var $elm$core$String$fromFloat = _String_fromNumber;
var $mdgriffith$elm_ui$Internal$Model$formatColor = function (_v0) {
	var red = _v0.a;
	var green = _v0.b;
	var blue = _v0.c;
	var alpha = _v0.d;
	return 'rgba(' + ($elm$core$String$fromInt(
		$elm$core$Basics$round(red * 255)) + ((',' + $elm$core$String$fromInt(
		$elm$core$Basics$round(green * 255))) + ((',' + $elm$core$String$fromInt(
		$elm$core$Basics$round(blue * 255))) + (',' + ($elm$core$String$fromFloat(alpha) + ')')))));
};
var $mdgriffith$elm_ui$Internal$Model$formatBoxShadow = function (shadow) {
	return A2(
		$elm$core$String$join,
		' ',
		A2(
			$elm$core$List$filterMap,
			$elm$core$Basics$identity,
			_List_fromArray(
				[
					shadow.inset ? $elm$core$Maybe$Just('inset') : $elm$core$Maybe$Nothing,
					$elm$core$Maybe$Just(
					$elm$core$String$fromFloat(shadow.offset.a) + 'px'),
					$elm$core$Maybe$Just(
					$elm$core$String$fromFloat(shadow.offset.b) + 'px'),
					$elm$core$Maybe$Just(
					$elm$core$String$fromFloat(shadow.blur) + 'px'),
					$elm$core$Maybe$Just(
					$elm$core$String$fromFloat(shadow.size) + 'px'),
					$elm$core$Maybe$Just(
					$mdgriffith$elm_ui$Internal$Model$formatColor(shadow.color))
				])));
};
var $elm$core$Maybe$map = F2(
	function (f, maybe) {
		if (maybe.$ === 'Just') {
			var value = maybe.a;
			return $elm$core$Maybe$Just(
				f(value));
		} else {
			return $elm$core$Maybe$Nothing;
		}
	});
var $elm$core$Tuple$mapFirst = F2(
	function (func, _v0) {
		var x = _v0.a;
		var y = _v0.b;
		return _Utils_Tuple2(
			func(x),
			y);
	});
var $elm$core$Tuple$mapSecond = F2(
	function (func, _v0) {
		var x = _v0.a;
		var y = _v0.b;
		return _Utils_Tuple2(
			x,
			func(y));
	});
var $mdgriffith$elm_ui$Internal$Model$renderFocusStyle = function (focus) {
	return _List_fromArray(
		[
			A2(
			$mdgriffith$elm_ui$Internal$Model$Style,
			$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.focusedWithin) + ':focus-within',
			A2(
				$elm$core$List$filterMap,
				$elm$core$Basics$identity,
				_List_fromArray(
					[
						A2(
						$elm$core$Maybe$map,
						function (color) {
							return A2(
								$mdgriffith$elm_ui$Internal$Model$Property,
								'border-color',
								$mdgriffith$elm_ui$Internal$Model$formatColor(color));
						},
						focus.borderColor),
						A2(
						$elm$core$Maybe$map,
						function (color) {
							return A2(
								$mdgriffith$elm_ui$Internal$Model$Property,
								'background-color',
								$mdgriffith$elm_ui$Internal$Model$formatColor(color));
						},
						focus.backgroundColor),
						A2(
						$elm$core$Maybe$map,
						function (shadow) {
							return A2(
								$mdgriffith$elm_ui$Internal$Model$Property,
								'box-shadow',
								$mdgriffith$elm_ui$Internal$Model$formatBoxShadow(
									{
										blur: shadow.blur,
										color: shadow.color,
										inset: false,
										offset: A2(
											$elm$core$Tuple$mapSecond,
											$elm$core$Basics$toFloat,
											A2($elm$core$Tuple$mapFirst, $elm$core$Basics$toFloat, shadow.offset)),
										size: shadow.size
									}));
						},
						focus.shadow),
						$elm$core$Maybe$Just(
						A2($mdgriffith$elm_ui$Internal$Model$Property, 'outline', 'none'))
					]))),
			A2(
			$mdgriffith$elm_ui$Internal$Model$Style,
			($mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any) + ':focus .focusable, ') + (($mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any) + '.focusable:focus, ') + ('.ui-slide-bar:focus + ' + ($mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any) + ' .focusable-thumb'))),
			A2(
				$elm$core$List$filterMap,
				$elm$core$Basics$identity,
				_List_fromArray(
					[
						A2(
						$elm$core$Maybe$map,
						function (color) {
							return A2(
								$mdgriffith$elm_ui$Internal$Model$Property,
								'border-color',
								$mdgriffith$elm_ui$Internal$Model$formatColor(color));
						},
						focus.borderColor),
						A2(
						$elm$core$Maybe$map,
						function (color) {
							return A2(
								$mdgriffith$elm_ui$Internal$Model$Property,
								'background-color',
								$mdgriffith$elm_ui$Internal$Model$formatColor(color));
						},
						focus.backgroundColor),
						A2(
						$elm$core$Maybe$map,
						function (shadow) {
							return A2(
								$mdgriffith$elm_ui$Internal$Model$Property,
								'box-shadow',
								$mdgriffith$elm_ui$Internal$Model$formatBoxShadow(
									{
										blur: shadow.blur,
										color: shadow.color,
										inset: false,
										offset: A2(
											$elm$core$Tuple$mapSecond,
											$elm$core$Basics$toFloat,
											A2($elm$core$Tuple$mapFirst, $elm$core$Basics$toFloat, shadow.offset)),
										size: shadow.size
									}));
						},
						focus.shadow),
						$elm$core$Maybe$Just(
						A2($mdgriffith$elm_ui$Internal$Model$Property, 'outline', 'none'))
					])))
		]);
};
var $elm$virtual_dom$VirtualDom$node = function (tag) {
	return _VirtualDom_node(
		_VirtualDom_noScript(tag));
};
var $elm$virtual_dom$VirtualDom$property = F2(
	function (key, value) {
		return A2(
			_VirtualDom_property,
			_VirtualDom_noInnerHtmlOrFormAction(key),
			_VirtualDom_noJavaScriptOrHtmlUri(value));
	});
var $mdgriffith$elm_ui$Internal$Style$AllChildren = F2(
	function (a, b) {
		return {$: 'AllChildren', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Style$Batch = function (a) {
	return {$: 'Batch', a: a};
};
var $mdgriffith$elm_ui$Internal$Style$Child = F2(
	function (a, b) {
		return {$: 'Child', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Style$Class = F2(
	function (a, b) {
		return {$: 'Class', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Style$Descriptor = F2(
	function (a, b) {
		return {$: 'Descriptor', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Style$Left = {$: 'Left'};
var $mdgriffith$elm_ui$Internal$Style$Prop = F2(
	function (a, b) {
		return {$: 'Prop', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Style$Right = {$: 'Right'};
var $mdgriffith$elm_ui$Internal$Style$Self = function (a) {
	return {$: 'Self', a: a};
};
var $mdgriffith$elm_ui$Internal$Style$Supports = F2(
	function (a, b) {
		return {$: 'Supports', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Style$Content = function (a) {
	return {$: 'Content', a: a};
};
var $mdgriffith$elm_ui$Internal$Style$Bottom = {$: 'Bottom'};
var $mdgriffith$elm_ui$Internal$Style$CenterX = {$: 'CenterX'};
var $mdgriffith$elm_ui$Internal$Style$CenterY = {$: 'CenterY'};
var $mdgriffith$elm_ui$Internal$Style$Top = {$: 'Top'};
var $mdgriffith$elm_ui$Internal$Style$alignments = _List_fromArray(
	[$mdgriffith$elm_ui$Internal$Style$Top, $mdgriffith$elm_ui$Internal$Style$Bottom, $mdgriffith$elm_ui$Internal$Style$Right, $mdgriffith$elm_ui$Internal$Style$Left, $mdgriffith$elm_ui$Internal$Style$CenterX, $mdgriffith$elm_ui$Internal$Style$CenterY]);
var $mdgriffith$elm_ui$Internal$Style$contentName = function (desc) {
	switch (desc.a.$) {
		case 'Top':
			var _v1 = desc.a;
			return $mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.contentTop);
		case 'Bottom':
			var _v2 = desc.a;
			return $mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.contentBottom);
		case 'Right':
			var _v3 = desc.a;
			return $mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.contentRight);
		case 'Left':
			var _v4 = desc.a;
			return $mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.contentLeft);
		case 'CenterX':
			var _v5 = desc.a;
			return $mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.contentCenterX);
		default:
			var _v6 = desc.a;
			return $mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.contentCenterY);
	}
};
var $mdgriffith$elm_ui$Internal$Style$selfName = function (desc) {
	switch (desc.a.$) {
		case 'Top':
			var _v1 = desc.a;
			return $mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.alignTop);
		case 'Bottom':
			var _v2 = desc.a;
			return $mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.alignBottom);
		case 'Right':
			var _v3 = desc.a;
			return $mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.alignRight);
		case 'Left':
			var _v4 = desc.a;
			return $mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.alignLeft);
		case 'CenterX':
			var _v5 = desc.a;
			return $mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.alignCenterX);
		default:
			var _v6 = desc.a;
			return $mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.alignCenterY);
	}
};
var $mdgriffith$elm_ui$Internal$Style$describeAlignment = function (values) {
	var createDescription = function (alignment) {
		var _v0 = values(alignment);
		var content = _v0.a;
		var indiv = _v0.b;
		return _List_fromArray(
			[
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$contentName(
					$mdgriffith$elm_ui$Internal$Style$Content(alignment)),
				content),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Child,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any),
				_List_fromArray(
					[
						A2(
						$mdgriffith$elm_ui$Internal$Style$Descriptor,
						$mdgriffith$elm_ui$Internal$Style$selfName(
							$mdgriffith$elm_ui$Internal$Style$Self(alignment)),
						indiv)
					]))
			]);
	};
	return $mdgriffith$elm_ui$Internal$Style$Batch(
		A2($elm$core$List$concatMap, createDescription, $mdgriffith$elm_ui$Internal$Style$alignments));
};
var $mdgriffith$elm_ui$Internal$Style$elDescription = _List_fromArray(
	[
		A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'flex'),
		A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-direction', 'column'),
		A2($mdgriffith$elm_ui$Internal$Style$Prop, 'white-space', 'pre'),
		A2(
		$mdgriffith$elm_ui$Internal$Style$Descriptor,
		$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.hasBehind),
		_List_fromArray(
			[
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'z-index', '0'),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Child,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.behind),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'z-index', '-1')
					]))
			])),
		A2(
		$mdgriffith$elm_ui$Internal$Style$Descriptor,
		$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.seButton),
		_List_fromArray(
			[
				A2(
				$mdgriffith$elm_ui$Internal$Style$Child,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.text),
				_List_fromArray(
					[
						A2(
						$mdgriffith$elm_ui$Internal$Style$Descriptor,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.heightFill),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '0')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Descriptor,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.widthFill),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-self', 'auto !important')
							]))
					]))
			])),
		A2(
		$mdgriffith$elm_ui$Internal$Style$Child,
		$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.heightContent),
		_List_fromArray(
			[
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'height', 'auto')
			])),
		A2(
		$mdgriffith$elm_ui$Internal$Style$Child,
		$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.heightFill),
		_List_fromArray(
			[
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '100000')
			])),
		A2(
		$mdgriffith$elm_ui$Internal$Style$Child,
		$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.widthFill),
		_List_fromArray(
			[
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'width', '100%')
			])),
		A2(
		$mdgriffith$elm_ui$Internal$Style$Child,
		$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.widthFillPortion),
		_List_fromArray(
			[
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'width', '100%')
			])),
		A2(
		$mdgriffith$elm_ui$Internal$Style$Child,
		$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.widthContent),
		_List_fromArray(
			[
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-self', 'flex-start')
			])),
		$mdgriffith$elm_ui$Internal$Style$describeAlignment(
		function (alignment) {
			switch (alignment.$) {
				case 'Top':
					return _Utils_Tuple2(
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'justify-content', 'flex-start')
							]),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-bottom', 'auto !important'),
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-top', '0 !important')
							]));
				case 'Bottom':
					return _Utils_Tuple2(
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'justify-content', 'flex-end')
							]),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-top', 'auto !important'),
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-bottom', '0 !important')
							]));
				case 'Right':
					return _Utils_Tuple2(
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-items', 'flex-end')
							]),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-self', 'flex-end')
							]));
				case 'Left':
					return _Utils_Tuple2(
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-items', 'flex-start')
							]),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-self', 'flex-start')
							]));
				case 'CenterX':
					return _Utils_Tuple2(
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-items', 'center')
							]),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-self', 'center')
							]));
				default:
					return _Utils_Tuple2(
						_List_fromArray(
							[
								A2(
								$mdgriffith$elm_ui$Internal$Style$Child,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-top', 'auto'),
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-bottom', 'auto')
									]))
							]),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-top', 'auto !important'),
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-bottom', 'auto !important')
							]));
			}
		})
	]);
var $mdgriffith$elm_ui$Internal$Style$gridAlignments = function (values) {
	var createDescription = function (alignment) {
		return _List_fromArray(
			[
				A2(
				$mdgriffith$elm_ui$Internal$Style$Child,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any),
				_List_fromArray(
					[
						A2(
						$mdgriffith$elm_ui$Internal$Style$Descriptor,
						$mdgriffith$elm_ui$Internal$Style$selfName(
							$mdgriffith$elm_ui$Internal$Style$Self(alignment)),
						values(alignment))
					]))
			]);
	};
	return $mdgriffith$elm_ui$Internal$Style$Batch(
		A2($elm$core$List$concatMap, createDescription, $mdgriffith$elm_ui$Internal$Style$alignments));
};
var $mdgriffith$elm_ui$Internal$Style$Above = {$: 'Above'};
var $mdgriffith$elm_ui$Internal$Style$Behind = {$: 'Behind'};
var $mdgriffith$elm_ui$Internal$Style$Below = {$: 'Below'};
var $mdgriffith$elm_ui$Internal$Style$OnLeft = {$: 'OnLeft'};
var $mdgriffith$elm_ui$Internal$Style$OnRight = {$: 'OnRight'};
var $mdgriffith$elm_ui$Internal$Style$Within = {$: 'Within'};
var $mdgriffith$elm_ui$Internal$Style$locations = function () {
	var loc = $mdgriffith$elm_ui$Internal$Style$Above;
	var _v0 = function () {
		switch (loc.$) {
			case 'Above':
				return _Utils_Tuple0;
			case 'Below':
				return _Utils_Tuple0;
			case 'OnRight':
				return _Utils_Tuple0;
			case 'OnLeft':
				return _Utils_Tuple0;
			case 'Within':
				return _Utils_Tuple0;
			default:
				return _Utils_Tuple0;
		}
	}();
	return _List_fromArray(
		[$mdgriffith$elm_ui$Internal$Style$Above, $mdgriffith$elm_ui$Internal$Style$Below, $mdgriffith$elm_ui$Internal$Style$OnRight, $mdgriffith$elm_ui$Internal$Style$OnLeft, $mdgriffith$elm_ui$Internal$Style$Within, $mdgriffith$elm_ui$Internal$Style$Behind]);
}();
var $mdgriffith$elm_ui$Internal$Style$baseSheet = _List_fromArray(
	[
		A2(
		$mdgriffith$elm_ui$Internal$Style$Class,
		'html,body',
		_List_fromArray(
			[
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'height', '100%'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'padding', '0'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin', '0')
			])),
		A2(
		$mdgriffith$elm_ui$Internal$Style$Class,
		_Utils_ap(
			$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any),
			_Utils_ap(
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.single),
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.imageContainer))),
		_List_fromArray(
			[
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'block'),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.heightFill),
				_List_fromArray(
					[
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						'img',
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'max-height', '100%'),
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'object-fit', 'cover')
							]))
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.widthFill),
				_List_fromArray(
					[
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						'img',
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'max-width', '100%'),
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'object-fit', 'cover')
							]))
					]))
			])),
		A2(
		$mdgriffith$elm_ui$Internal$Style$Class,
		$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any) + ':focus',
		_List_fromArray(
			[
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'outline', 'none')
			])),
		A2(
		$mdgriffith$elm_ui$Internal$Style$Class,
		$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.root),
		_List_fromArray(
			[
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'width', '100%'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'height', 'auto'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'min-height', '100%'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'z-index', '0'),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				_Utils_ap(
					$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any),
					$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.heightFill)),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'height', '100%'),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.heightFill),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'height', '100%')
							]))
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Child,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.inFront),
				_List_fromArray(
					[
						A2(
						$mdgriffith$elm_ui$Internal$Style$Descriptor,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.nearby),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'position', 'fixed'),
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'z-index', '20')
							]))
					]))
			])),
		A2(
		$mdgriffith$elm_ui$Internal$Style$Class,
		$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.nearby),
		_List_fromArray(
			[
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'position', 'relative'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'border', 'none'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'flex'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-direction', 'row'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-basis', 'auto'),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.single),
				$mdgriffith$elm_ui$Internal$Style$elDescription),
				$mdgriffith$elm_ui$Internal$Style$Batch(
				function (fn) {
					return A2($elm$core$List$map, fn, $mdgriffith$elm_ui$Internal$Style$locations);
				}(
					function (loc) {
						switch (loc.$) {
							case 'Above':
								return A2(
									$mdgriffith$elm_ui$Internal$Style$Descriptor,
									$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.above),
									_List_fromArray(
										[
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'position', 'absolute'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'bottom', '100%'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'left', '0'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'width', '100%'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'z-index', '20'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin', '0 !important'),
											A2(
											$mdgriffith$elm_ui$Internal$Style$Child,
											$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.heightFill),
											_List_fromArray(
												[
													A2($mdgriffith$elm_ui$Internal$Style$Prop, 'height', 'auto')
												])),
											A2(
											$mdgriffith$elm_ui$Internal$Style$Child,
											$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.widthFill),
											_List_fromArray(
												[
													A2($mdgriffith$elm_ui$Internal$Style$Prop, 'width', '100%')
												])),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'pointer-events', 'none'),
											A2(
											$mdgriffith$elm_ui$Internal$Style$Child,
											'*',
											_List_fromArray(
												[
													A2($mdgriffith$elm_ui$Internal$Style$Prop, 'pointer-events', 'auto')
												]))
										]));
							case 'Below':
								return A2(
									$mdgriffith$elm_ui$Internal$Style$Descriptor,
									$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.below),
									_List_fromArray(
										[
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'position', 'absolute'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'bottom', '0'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'left', '0'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'height', '0'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'width', '100%'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'z-index', '20'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin', '0 !important'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'pointer-events', 'none'),
											A2(
											$mdgriffith$elm_ui$Internal$Style$Child,
											'*',
											_List_fromArray(
												[
													A2($mdgriffith$elm_ui$Internal$Style$Prop, 'pointer-events', 'auto')
												])),
											A2(
											$mdgriffith$elm_ui$Internal$Style$Child,
											$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.heightFill),
											_List_fromArray(
												[
													A2($mdgriffith$elm_ui$Internal$Style$Prop, 'height', 'auto')
												]))
										]));
							case 'OnRight':
								return A2(
									$mdgriffith$elm_ui$Internal$Style$Descriptor,
									$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.onRight),
									_List_fromArray(
										[
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'position', 'absolute'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'left', '100%'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'top', '0'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'height', '100%'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin', '0 !important'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'z-index', '20'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'pointer-events', 'none'),
											A2(
											$mdgriffith$elm_ui$Internal$Style$Child,
											'*',
											_List_fromArray(
												[
													A2($mdgriffith$elm_ui$Internal$Style$Prop, 'pointer-events', 'auto')
												]))
										]));
							case 'OnLeft':
								return A2(
									$mdgriffith$elm_ui$Internal$Style$Descriptor,
									$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.onLeft),
									_List_fromArray(
										[
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'position', 'absolute'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'right', '100%'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'top', '0'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'height', '100%'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin', '0 !important'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'z-index', '20'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'pointer-events', 'none'),
											A2(
											$mdgriffith$elm_ui$Internal$Style$Child,
											'*',
											_List_fromArray(
												[
													A2($mdgriffith$elm_ui$Internal$Style$Prop, 'pointer-events', 'auto')
												]))
										]));
							case 'Within':
								return A2(
									$mdgriffith$elm_ui$Internal$Style$Descriptor,
									$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.inFront),
									_List_fromArray(
										[
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'position', 'absolute'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'width', '100%'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'height', '100%'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'left', '0'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'top', '0'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin', '0 !important'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'pointer-events', 'none'),
											A2(
											$mdgriffith$elm_ui$Internal$Style$Child,
											'*',
											_List_fromArray(
												[
													A2($mdgriffith$elm_ui$Internal$Style$Prop, 'pointer-events', 'auto')
												]))
										]));
							default:
								return A2(
									$mdgriffith$elm_ui$Internal$Style$Descriptor,
									$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.behind),
									_List_fromArray(
										[
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'position', 'absolute'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'width', '100%'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'height', '100%'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'left', '0'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'top', '0'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin', '0 !important'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'z-index', '0'),
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'pointer-events', 'none'),
											A2(
											$mdgriffith$elm_ui$Internal$Style$Child,
											'*',
											_List_fromArray(
												[
													A2($mdgriffith$elm_ui$Internal$Style$Prop, 'pointer-events', 'auto')
												]))
										]));
						}
					}))
			])),
		A2(
		$mdgriffith$elm_ui$Internal$Style$Class,
		$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any),
		_List_fromArray(
			[
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'position', 'relative'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'border', 'none'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-shrink', '0'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'flex'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-direction', 'row'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-basis', 'auto'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'resize', 'none'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-feature-settings', 'inherit'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'box-sizing', 'border-box'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin', '0'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'padding', '0'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'border-width', '0'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'border-style', 'solid'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-size', 'inherit'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'color', 'inherit'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-family', 'inherit'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'line-height', '1'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-weight', 'inherit'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'text-decoration', 'none'),
				A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-style', 'inherit'),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.wrapped),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-wrap', 'wrap')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.noTextSelection),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, '-moz-user-select', 'none'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, '-webkit-user-select', 'none'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, '-ms-user-select', 'none'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'user-select', 'none')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.cursorPointer),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'cursor', 'pointer')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.cursorText),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'cursor', 'text')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.passPointerEvents),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'pointer-events', 'none !important')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.capturePointerEvents),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'pointer-events', 'auto !important')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.transparent),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'opacity', '0')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.opaque),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'opacity', '1')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot(
					_Utils_ap($mdgriffith$elm_ui$Internal$Style$classes.hover, $mdgriffith$elm_ui$Internal$Style$classes.transparent)) + ':hover',
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'opacity', '0')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot(
					_Utils_ap($mdgriffith$elm_ui$Internal$Style$classes.hover, $mdgriffith$elm_ui$Internal$Style$classes.opaque)) + ':hover',
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'opacity', '1')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot(
					_Utils_ap($mdgriffith$elm_ui$Internal$Style$classes.focus, $mdgriffith$elm_ui$Internal$Style$classes.transparent)) + ':focus',
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'opacity', '0')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot(
					_Utils_ap($mdgriffith$elm_ui$Internal$Style$classes.focus, $mdgriffith$elm_ui$Internal$Style$classes.opaque)) + ':focus',
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'opacity', '1')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot(
					_Utils_ap($mdgriffith$elm_ui$Internal$Style$classes.active, $mdgriffith$elm_ui$Internal$Style$classes.transparent)) + ':active',
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'opacity', '0')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot(
					_Utils_ap($mdgriffith$elm_ui$Internal$Style$classes.active, $mdgriffith$elm_ui$Internal$Style$classes.opaque)) + ':active',
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'opacity', '1')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.transition),
				_List_fromArray(
					[
						A2(
						$mdgriffith$elm_ui$Internal$Style$Prop,
						'transition',
						A2(
							$elm$core$String$join,
							', ',
							A2(
								$elm$core$List$map,
								function (x) {
									return x + ' 160ms';
								},
								_List_fromArray(
									['transform', 'opacity', 'filter', 'background-color', 'color', 'font-size']))))
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.scrollbars),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'overflow', 'auto'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-shrink', '1')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.scrollbarsX),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'overflow-x', 'auto'),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Descriptor,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.row),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-shrink', '1')
							]))
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.scrollbarsY),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'overflow-y', 'auto'),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Descriptor,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.column),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-shrink', '1')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Descriptor,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.single),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-shrink', '1')
							]))
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.clip),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'overflow', 'hidden')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.clipX),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'overflow-x', 'hidden')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.clipY),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'overflow-y', 'hidden')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.widthContent),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'width', 'auto')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.borderNone),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'border-width', '0')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.borderDashed),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'border-style', 'dashed')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.borderDotted),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'border-style', 'dotted')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.borderSolid),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'border-style', 'solid')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.text),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'white-space', 'pre'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'inline-block')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.inputText),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'line-height', '1.05'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'background', 'transparent'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'text-align', 'inherit')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.single),
				$mdgriffith$elm_ui$Internal$Style$elDescription),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.row),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'flex'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-direction', 'row'),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-basis', '0%'),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Descriptor,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.widthExact),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-basis', 'auto')
									])),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Descriptor,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.link),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-basis', 'auto')
									]))
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.heightFill),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-self', 'stretch !important')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.heightFillPortion),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-self', 'stretch !important')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.widthFill),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '100000')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.container),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '0'),
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-basis', 'auto'),
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-self', 'stretch')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						'u:first-of-type.' + $mdgriffith$elm_ui$Internal$Style$classes.alignContainerRight,
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '1')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						's:first-of-type.' + $mdgriffith$elm_ui$Internal$Style$classes.alignContainerCenterX,
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '1'),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Child,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.alignCenterX),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-left', 'auto !important')
									]))
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						's:last-of-type.' + $mdgriffith$elm_ui$Internal$Style$classes.alignContainerCenterX,
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '1'),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Child,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.alignCenterX),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-right', 'auto !important')
									]))
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						's:only-of-type.' + $mdgriffith$elm_ui$Internal$Style$classes.alignContainerCenterX,
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '1'),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Child,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.alignCenterY),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-top', 'auto !important'),
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-bottom', 'auto !important')
									]))
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						's:last-of-type.' + ($mdgriffith$elm_ui$Internal$Style$classes.alignContainerCenterX + ' ~ u'),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '0')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						'u:first-of-type.' + ($mdgriffith$elm_ui$Internal$Style$classes.alignContainerRight + (' ~ s.' + $mdgriffith$elm_ui$Internal$Style$classes.alignContainerCenterX)),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '0')
							])),
						$mdgriffith$elm_ui$Internal$Style$describeAlignment(
						function (alignment) {
							switch (alignment.$) {
								case 'Top':
									return _Utils_Tuple2(
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-items', 'flex-start')
											]),
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-self', 'flex-start')
											]));
								case 'Bottom':
									return _Utils_Tuple2(
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-items', 'flex-end')
											]),
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-self', 'flex-end')
											]));
								case 'Right':
									return _Utils_Tuple2(
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'justify-content', 'flex-end')
											]),
										_List_Nil);
								case 'Left':
									return _Utils_Tuple2(
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'justify-content', 'flex-start')
											]),
										_List_Nil);
								case 'CenterX':
									return _Utils_Tuple2(
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'justify-content', 'center')
											]),
										_List_Nil);
								default:
									return _Utils_Tuple2(
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-items', 'center')
											]),
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-self', 'center')
											]));
							}
						}),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Descriptor,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.spaceEvenly),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'justify-content', 'space-between')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Descriptor,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.inputLabel),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-items', 'baseline')
							]))
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.column),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'flex'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-direction', 'column'),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-basis', '0px'),
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'min-height', 'min-content'),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Descriptor,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.heightExact),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-basis', 'auto')
									]))
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.heightFill),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '100000')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.widthFill),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'width', '100%')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.widthFillPortion),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'width', '100%')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.widthContent),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-self', 'flex-start')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						'u:first-of-type.' + $mdgriffith$elm_ui$Internal$Style$classes.alignContainerBottom,
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '1')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						's:first-of-type.' + $mdgriffith$elm_ui$Internal$Style$classes.alignContainerCenterY,
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '1'),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Child,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.alignCenterY),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-top', 'auto !important'),
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-bottom', '0 !important')
									]))
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						's:last-of-type.' + $mdgriffith$elm_ui$Internal$Style$classes.alignContainerCenterY,
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '1'),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Child,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.alignCenterY),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-bottom', 'auto !important'),
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-top', '0 !important')
									]))
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						's:only-of-type.' + $mdgriffith$elm_ui$Internal$Style$classes.alignContainerCenterY,
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '1'),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Child,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.alignCenterY),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-top', 'auto !important'),
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-bottom', 'auto !important')
									]))
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						's:last-of-type.' + ($mdgriffith$elm_ui$Internal$Style$classes.alignContainerCenterY + ' ~ u'),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '0')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						'u:first-of-type.' + ($mdgriffith$elm_ui$Internal$Style$classes.alignContainerBottom + (' ~ s.' + $mdgriffith$elm_ui$Internal$Style$classes.alignContainerCenterY)),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '0')
							])),
						$mdgriffith$elm_ui$Internal$Style$describeAlignment(
						function (alignment) {
							switch (alignment.$) {
								case 'Top':
									return _Utils_Tuple2(
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'justify-content', 'flex-start')
											]),
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-bottom', 'auto')
											]));
								case 'Bottom':
									return _Utils_Tuple2(
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'justify-content', 'flex-end')
											]),
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin-top', 'auto')
											]));
								case 'Right':
									return _Utils_Tuple2(
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-items', 'flex-end')
											]),
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-self', 'flex-end')
											]));
								case 'Left':
									return _Utils_Tuple2(
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-items', 'flex-start')
											]),
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-self', 'flex-start')
											]));
								case 'CenterX':
									return _Utils_Tuple2(
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-items', 'center')
											]),
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-self', 'center')
											]));
								default:
									return _Utils_Tuple2(
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'justify-content', 'center')
											]),
										_List_Nil);
							}
						}),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.container),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-grow', '0'),
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-basis', 'auto'),
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'width', '100%'),
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-self', 'stretch !important')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Descriptor,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.spaceEvenly),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'justify-content', 'space-between')
							]))
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.grid),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', '-ms-grid'),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						'.gp',
						_List_fromArray(
							[
								A2(
								$mdgriffith$elm_ui$Internal$Style$Child,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'width', '100%')
									]))
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Supports,
						_Utils_Tuple2('display', 'grid'),
						_List_fromArray(
							[
								_Utils_Tuple2('display', 'grid')
							])),
						$mdgriffith$elm_ui$Internal$Style$gridAlignments(
						function (alignment) {
							switch (alignment.$) {
								case 'Top':
									return _List_fromArray(
										[
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'justify-content', 'flex-start')
										]);
								case 'Bottom':
									return _List_fromArray(
										[
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'justify-content', 'flex-end')
										]);
								case 'Right':
									return _List_fromArray(
										[
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-items', 'flex-end')
										]);
								case 'Left':
									return _List_fromArray(
										[
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-items', 'flex-start')
										]);
								case 'CenterX':
									return _List_fromArray(
										[
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'align-items', 'center')
										]);
								default:
									return _List_fromArray(
										[
											A2($mdgriffith$elm_ui$Internal$Style$Prop, 'justify-content', 'center')
										]);
							}
						})
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.page),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'block'),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any + ':first-child'),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin', '0 !important')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot(
							$mdgriffith$elm_ui$Internal$Style$classes.any + ($mdgriffith$elm_ui$Internal$Style$selfName(
								$mdgriffith$elm_ui$Internal$Style$Self($mdgriffith$elm_ui$Internal$Style$Left)) + (':first-child + .' + $mdgriffith$elm_ui$Internal$Style$classes.any))),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin', '0 !important')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot(
							$mdgriffith$elm_ui$Internal$Style$classes.any + ($mdgriffith$elm_ui$Internal$Style$selfName(
								$mdgriffith$elm_ui$Internal$Style$Self($mdgriffith$elm_ui$Internal$Style$Right)) + (':first-child + .' + $mdgriffith$elm_ui$Internal$Style$classes.any))),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'margin', '0 !important')
							])),
						$mdgriffith$elm_ui$Internal$Style$describeAlignment(
						function (alignment) {
							switch (alignment.$) {
								case 'Top':
									return _Utils_Tuple2(_List_Nil, _List_Nil);
								case 'Bottom':
									return _Utils_Tuple2(_List_Nil, _List_Nil);
								case 'Right':
									return _Utils_Tuple2(
										_List_Nil,
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'float', 'right'),
												A2(
												$mdgriffith$elm_ui$Internal$Style$Descriptor,
												'::after',
												_List_fromArray(
													[
														A2($mdgriffith$elm_ui$Internal$Style$Prop, 'content', '\"\"'),
														A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'table'),
														A2($mdgriffith$elm_ui$Internal$Style$Prop, 'clear', 'both')
													]))
											]));
								case 'Left':
									return _Utils_Tuple2(
										_List_Nil,
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'float', 'left'),
												A2(
												$mdgriffith$elm_ui$Internal$Style$Descriptor,
												'::after',
												_List_fromArray(
													[
														A2($mdgriffith$elm_ui$Internal$Style$Prop, 'content', '\"\"'),
														A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'table'),
														A2($mdgriffith$elm_ui$Internal$Style$Prop, 'clear', 'both')
													]))
											]));
								case 'CenterX':
									return _Utils_Tuple2(_List_Nil, _List_Nil);
								default:
									return _Utils_Tuple2(_List_Nil, _List_Nil);
							}
						})
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.inputMultiline),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'white-space', 'pre-wrap !important'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'height', '100%'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'width', '100%'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'background-color', 'transparent')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.inputMultilineWrapper),
				_List_fromArray(
					[
						A2(
						$mdgriffith$elm_ui$Internal$Style$Descriptor,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.single),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'flex-basis', 'auto')
							]))
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.inputMultilineParent),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'white-space', 'pre-wrap !important'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'cursor', 'text'),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.inputMultilineFiller),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'white-space', 'pre-wrap !important'),
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'color', 'transparent')
							]))
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.paragraph),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'block'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'white-space', 'normal'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'overflow-wrap', 'break-word'),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Descriptor,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.hasBehind),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'z-index', '0'),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Child,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.behind),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'z-index', '-1')
									]))
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$AllChildren,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.text),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'inline'),
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'white-space', 'normal')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$AllChildren,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.paragraph),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'inline'),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Descriptor,
								'::after',
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'content', 'none')
									])),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Descriptor,
								'::before',
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'content', 'none')
									]))
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$AllChildren,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.single),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'inline'),
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'white-space', 'normal'),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Descriptor,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.widthExact),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'inline-block')
									])),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Descriptor,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.inFront),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'flex')
									])),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Descriptor,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.behind),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'flex')
									])),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Descriptor,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.above),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'flex')
									])),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Descriptor,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.below),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'flex')
									])),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Descriptor,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.onRight),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'flex')
									])),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Descriptor,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.onLeft),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'flex')
									])),
								A2(
								$mdgriffith$elm_ui$Internal$Style$Child,
								$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.text),
								_List_fromArray(
									[
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'inline'),
										A2($mdgriffith$elm_ui$Internal$Style$Prop, 'white-space', 'normal')
									]))
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.row),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'inline')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.column),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'inline-flex')
							])),
						A2(
						$mdgriffith$elm_ui$Internal$Style$Child,
						$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.grid),
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'inline-grid')
							])),
						$mdgriffith$elm_ui$Internal$Style$describeAlignment(
						function (alignment) {
							switch (alignment.$) {
								case 'Top':
									return _Utils_Tuple2(_List_Nil, _List_Nil);
								case 'Bottom':
									return _Utils_Tuple2(_List_Nil, _List_Nil);
								case 'Right':
									return _Utils_Tuple2(
										_List_Nil,
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'float', 'right')
											]));
								case 'Left':
									return _Utils_Tuple2(
										_List_Nil,
										_List_fromArray(
											[
												A2($mdgriffith$elm_ui$Internal$Style$Prop, 'float', 'left')
											]));
								case 'CenterX':
									return _Utils_Tuple2(_List_Nil, _List_Nil);
								default:
									return _Utils_Tuple2(_List_Nil, _List_Nil);
							}
						})
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				'.hidden',
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'display', 'none')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.textThin),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-weight', '100')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.textExtraLight),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-weight', '200')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.textLight),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-weight', '300')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.textNormalWeight),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-weight', '400')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.textMedium),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-weight', '500')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.textSemiBold),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-weight', '600')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.bold),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-weight', '700')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.textExtraBold),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-weight', '800')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.textHeavy),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-weight', '900')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.italic),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-style', 'italic')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.strike),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'text-decoration', 'line-through')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.underline),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'text-decoration', 'underline'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'text-decoration-skip-ink', 'auto'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'text-decoration-skip', 'ink')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				_Utils_ap(
					$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.underline),
					$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.strike)),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'text-decoration', 'line-through underline'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'text-decoration-skip-ink', 'auto'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'text-decoration-skip', 'ink')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.textUnitalicized),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-style', 'normal')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.textJustify),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'text-align', 'justify')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.textJustifyAll),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'text-align', 'justify-all')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.textCenter),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'text-align', 'center')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.textRight),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'text-align', 'right')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				$mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.textLeft),
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'text-align', 'left')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Descriptor,
				'.modal',
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'position', 'fixed'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'left', '0'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'top', '0'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'width', '100%'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'height', '100%'),
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'pointer-events', 'none')
					]))
			]))
	]);
var $mdgriffith$elm_ui$Internal$Style$fontVariant = function (_var) {
	return _List_fromArray(
		[
			A2(
			$mdgriffith$elm_ui$Internal$Style$Class,
			'.v-' + _var,
			_List_fromArray(
				[
					A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-feature-settings', '\"' + (_var + '\"'))
				])),
			A2(
			$mdgriffith$elm_ui$Internal$Style$Class,
			'.v-' + (_var + '-off'),
			_List_fromArray(
				[
					A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-feature-settings', '\"' + (_var + '\" 0'))
				]))
		]);
};
var $mdgriffith$elm_ui$Internal$Style$commonValues = $elm$core$List$concat(
	_List_fromArray(
		[
			A2(
			$elm$core$List$map,
			function (x) {
				return A2(
					$mdgriffith$elm_ui$Internal$Style$Class,
					'.border-' + $elm$core$String$fromInt(x),
					_List_fromArray(
						[
							A2(
							$mdgriffith$elm_ui$Internal$Style$Prop,
							'border-width',
							$elm$core$String$fromInt(x) + 'px')
						]));
			},
			A2($elm$core$List$range, 0, 6)),
			A2(
			$elm$core$List$map,
			function (i) {
				return A2(
					$mdgriffith$elm_ui$Internal$Style$Class,
					'.font-size-' + $elm$core$String$fromInt(i),
					_List_fromArray(
						[
							A2(
							$mdgriffith$elm_ui$Internal$Style$Prop,
							'font-size',
							$elm$core$String$fromInt(i) + 'px')
						]));
			},
			A2($elm$core$List$range, 8, 32)),
			A2(
			$elm$core$List$map,
			function (i) {
				return A2(
					$mdgriffith$elm_ui$Internal$Style$Class,
					'.p-' + $elm$core$String$fromInt(i),
					_List_fromArray(
						[
							A2(
							$mdgriffith$elm_ui$Internal$Style$Prop,
							'padding',
							$elm$core$String$fromInt(i) + 'px')
						]));
			},
			A2($elm$core$List$range, 0, 24)),
			_List_fromArray(
			[
				A2(
				$mdgriffith$elm_ui$Internal$Style$Class,
				'.v-smcp',
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-variant', 'small-caps')
					])),
				A2(
				$mdgriffith$elm_ui$Internal$Style$Class,
				'.v-smcp-off',
				_List_fromArray(
					[
						A2($mdgriffith$elm_ui$Internal$Style$Prop, 'font-variant', 'normal')
					]))
			]),
			$mdgriffith$elm_ui$Internal$Style$fontVariant('zero'),
			$mdgriffith$elm_ui$Internal$Style$fontVariant('onum'),
			$mdgriffith$elm_ui$Internal$Style$fontVariant('liga'),
			$mdgriffith$elm_ui$Internal$Style$fontVariant('dlig'),
			$mdgriffith$elm_ui$Internal$Style$fontVariant('ordn'),
			$mdgriffith$elm_ui$Internal$Style$fontVariant('tnum'),
			$mdgriffith$elm_ui$Internal$Style$fontVariant('afrc'),
			$mdgriffith$elm_ui$Internal$Style$fontVariant('frac')
		]));
var $mdgriffith$elm_ui$Internal$Style$explainer = '\n.explain {\n    border: 6px solid rgb(174, 121, 15) !important;\n}\n.explain > .' + ($mdgriffith$elm_ui$Internal$Style$classes.any + (' {\n    border: 4px dashed rgb(0, 151, 167) !important;\n}\n\n.ctr {\n    border: none !important;\n}\n.explain > .ctr > .' + ($mdgriffith$elm_ui$Internal$Style$classes.any + ' {\n    border: 4px dashed rgb(0, 151, 167) !important;\n}\n\n')));
var $mdgriffith$elm_ui$Internal$Style$inputTextReset = '\ninput[type="search"],\ninput[type="search"]::-webkit-search-decoration,\ninput[type="search"]::-webkit-search-cancel-button,\ninput[type="search"]::-webkit-search-results-button,\ninput[type="search"]::-webkit-search-results-decoration {\n  -webkit-appearance:none;\n}\n';
var $mdgriffith$elm_ui$Internal$Style$sliderReset = '\ninput[type=range] {\n  -webkit-appearance: none; \n  background: transparent;\n  position:absolute;\n  left:0;\n  top:0;\n  z-index:10;\n  width: 100%;\n  outline: dashed 1px;\n  height: 100%;\n  opacity: 0;\n}\n';
var $mdgriffith$elm_ui$Internal$Style$thumbReset = '\ninput[type=range]::-webkit-slider-thumb {\n    -webkit-appearance: none;\n    opacity: 0.5;\n    width: 80px;\n    height: 80px;\n    background-color: black;\n    border:none;\n    border-radius: 5px;\n}\ninput[type=range]::-moz-range-thumb {\n    opacity: 0.5;\n    width: 80px;\n    height: 80px;\n    background-color: black;\n    border:none;\n    border-radius: 5px;\n}\ninput[type=range]::-ms-thumb {\n    opacity: 0.5;\n    width: 80px;\n    height: 80px;\n    background-color: black;\n    border:none;\n    border-radius: 5px;\n}\ninput[type=range][orient=vertical]{\n    writing-mode: bt-lr; /* IE */\n    -webkit-appearance: slider-vertical;  /* WebKit */\n}\n';
var $mdgriffith$elm_ui$Internal$Style$trackReset = '\ninput[type=range]::-moz-range-track {\n    background: transparent;\n    cursor: pointer;\n}\ninput[type=range]::-ms-track {\n    background: transparent;\n    cursor: pointer;\n}\ninput[type=range]::-webkit-slider-runnable-track {\n    background: transparent;\n    cursor: pointer;\n}\n';
var $mdgriffith$elm_ui$Internal$Style$overrides = '@media screen and (-ms-high-contrast: active), (-ms-high-contrast: none) {' + ($mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any) + ($mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.row) + (' > ' + ($mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any) + (' { flex-basis: auto !important; } ' + ($mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any) + ($mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.row) + (' > ' + ($mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any) + ($mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.container) + (' { flex-basis: auto !important; }}' + ($mdgriffith$elm_ui$Internal$Style$inputTextReset + ($mdgriffith$elm_ui$Internal$Style$sliderReset + ($mdgriffith$elm_ui$Internal$Style$trackReset + ($mdgriffith$elm_ui$Internal$Style$thumbReset + $mdgriffith$elm_ui$Internal$Style$explainer)))))))))))))));
var $elm$core$String$concat = function (strings) {
	return A2($elm$core$String$join, '', strings);
};
var $mdgriffith$elm_ui$Internal$Style$Intermediate = function (a) {
	return {$: 'Intermediate', a: a};
};
var $mdgriffith$elm_ui$Internal$Style$emptyIntermediate = F2(
	function (selector, closing) {
		return $mdgriffith$elm_ui$Internal$Style$Intermediate(
			{closing: closing, others: _List_Nil, props: _List_Nil, selector: selector});
	});
var $mdgriffith$elm_ui$Internal$Style$renderRules = F2(
	function (_v0, rulesToRender) {
		var parent = _v0.a;
		var generateIntermediates = F2(
			function (rule, rendered) {
				switch (rule.$) {
					case 'Prop':
						var name = rule.a;
						var val = rule.b;
						return _Utils_update(
							rendered,
							{
								props: A2(
									$elm$core$List$cons,
									_Utils_Tuple2(name, val),
									rendered.props)
							});
					case 'Supports':
						var _v2 = rule.a;
						var prop = _v2.a;
						var value = _v2.b;
						var props = rule.b;
						return _Utils_update(
							rendered,
							{
								others: A2(
									$elm$core$List$cons,
									$mdgriffith$elm_ui$Internal$Style$Intermediate(
										{closing: '\n}', others: _List_Nil, props: props, selector: '@supports (' + (prop + (':' + (value + (') {' + parent.selector))))}),
									rendered.others)
							});
					case 'Adjacent':
						var selector = rule.a;
						var adjRules = rule.b;
						return _Utils_update(
							rendered,
							{
								others: A2(
									$elm$core$List$cons,
									A2(
										$mdgriffith$elm_ui$Internal$Style$renderRules,
										A2($mdgriffith$elm_ui$Internal$Style$emptyIntermediate, parent.selector + (' + ' + selector), ''),
										adjRules),
									rendered.others)
							});
					case 'Child':
						var child = rule.a;
						var childRules = rule.b;
						return _Utils_update(
							rendered,
							{
								others: A2(
									$elm$core$List$cons,
									A2(
										$mdgriffith$elm_ui$Internal$Style$renderRules,
										A2($mdgriffith$elm_ui$Internal$Style$emptyIntermediate, parent.selector + (' > ' + child), ''),
										childRules),
									rendered.others)
							});
					case 'AllChildren':
						var child = rule.a;
						var childRules = rule.b;
						return _Utils_update(
							rendered,
							{
								others: A2(
									$elm$core$List$cons,
									A2(
										$mdgriffith$elm_ui$Internal$Style$renderRules,
										A2($mdgriffith$elm_ui$Internal$Style$emptyIntermediate, parent.selector + (' ' + child), ''),
										childRules),
									rendered.others)
							});
					case 'Descriptor':
						var descriptor = rule.a;
						var descriptorRules = rule.b;
						return _Utils_update(
							rendered,
							{
								others: A2(
									$elm$core$List$cons,
									A2(
										$mdgriffith$elm_ui$Internal$Style$renderRules,
										A2(
											$mdgriffith$elm_ui$Internal$Style$emptyIntermediate,
											_Utils_ap(parent.selector, descriptor),
											''),
										descriptorRules),
									rendered.others)
							});
					default:
						var batched = rule.a;
						return _Utils_update(
							rendered,
							{
								others: A2(
									$elm$core$List$cons,
									A2(
										$mdgriffith$elm_ui$Internal$Style$renderRules,
										A2($mdgriffith$elm_ui$Internal$Style$emptyIntermediate, parent.selector, ''),
										batched),
									rendered.others)
							});
				}
			});
		return $mdgriffith$elm_ui$Internal$Style$Intermediate(
			A3($elm$core$List$foldr, generateIntermediates, parent, rulesToRender));
	});
var $mdgriffith$elm_ui$Internal$Style$renderCompact = function (styleClasses) {
	var renderValues = function (values) {
		return $elm$core$String$concat(
			A2(
				$elm$core$List$map,
				function (_v3) {
					var x = _v3.a;
					var y = _v3.b;
					return x + (':' + (y + ';'));
				},
				values));
	};
	var renderClass = function (rule) {
		var _v2 = rule.props;
		if (!_v2.b) {
			return '';
		} else {
			return rule.selector + ('{' + (renderValues(rule.props) + (rule.closing + '}')));
		}
	};
	var renderIntermediate = function (_v0) {
		var rule = _v0.a;
		return _Utils_ap(
			renderClass(rule),
			$elm$core$String$concat(
				A2($elm$core$List$map, renderIntermediate, rule.others)));
	};
	return $elm$core$String$concat(
		A2(
			$elm$core$List$map,
			renderIntermediate,
			A3(
				$elm$core$List$foldr,
				F2(
					function (_v1, existing) {
						var name = _v1.a;
						var styleRules = _v1.b;
						return A2(
							$elm$core$List$cons,
							A2(
								$mdgriffith$elm_ui$Internal$Style$renderRules,
								A2($mdgriffith$elm_ui$Internal$Style$emptyIntermediate, name, ''),
								styleRules),
							existing);
					}),
				_List_Nil,
				styleClasses)));
};
var $mdgriffith$elm_ui$Internal$Style$rules = _Utils_ap(
	$mdgriffith$elm_ui$Internal$Style$overrides,
	$mdgriffith$elm_ui$Internal$Style$renderCompact(
		_Utils_ap($mdgriffith$elm_ui$Internal$Style$baseSheet, $mdgriffith$elm_ui$Internal$Style$commonValues)));
var $mdgriffith$elm_ui$Internal$Model$staticRoot = function (opts) {
	var _v0 = opts.mode;
	switch (_v0.$) {
		case 'Layout':
			return A3(
				$elm$virtual_dom$VirtualDom$node,
				'div',
				_List_Nil,
				_List_fromArray(
					[
						A3(
						$elm$virtual_dom$VirtualDom$node,
						'style',
						_List_Nil,
						_List_fromArray(
							[
								$elm$virtual_dom$VirtualDom$text($mdgriffith$elm_ui$Internal$Style$rules)
							]))
					]));
		case 'NoStaticStyleSheet':
			return $elm$virtual_dom$VirtualDom$text('');
		default:
			return A3(
				$elm$virtual_dom$VirtualDom$node,
				'elm-ui-static-rules',
				_List_fromArray(
					[
						A2(
						$elm$virtual_dom$VirtualDom$property,
						'rules',
						$elm$json$Json$Encode$string($mdgriffith$elm_ui$Internal$Style$rules))
					]),
				_List_Nil);
	}
};
var $elm$json$Json$Encode$list = F2(
	function (func, entries) {
		return _Json_wrap(
			A3(
				$elm$core$List$foldl,
				_Json_addEntry(func),
				_Json_emptyArray(_Utils_Tuple0),
				entries));
	});
var $elm$json$Json$Encode$object = function (pairs) {
	return _Json_wrap(
		A3(
			$elm$core$List$foldl,
			F2(
				function (_v0, obj) {
					var k = _v0.a;
					var v = _v0.b;
					return A3(_Json_addField, k, v, obj);
				}),
			_Json_emptyObject(_Utils_Tuple0),
			pairs));
};
var $elm$core$List$any = F2(
	function (isOkay, list) {
		any:
		while (true) {
			if (!list.b) {
				return false;
			} else {
				var x = list.a;
				var xs = list.b;
				if (isOkay(x)) {
					return true;
				} else {
					var $temp$isOkay = isOkay,
						$temp$list = xs;
					isOkay = $temp$isOkay;
					list = $temp$list;
					continue any;
				}
			}
		}
	});
var $mdgriffith$elm_ui$Internal$Model$fontName = function (font) {
	switch (font.$) {
		case 'Serif':
			return 'serif';
		case 'SansSerif':
			return 'sans-serif';
		case 'Monospace':
			return 'monospace';
		case 'Typeface':
			var name = font.a;
			return '\"' + (name + '\"');
		case 'ImportFont':
			var name = font.a;
			var url = font.b;
			return '\"' + (name + '\"');
		default:
			var name = font.a.name;
			return '\"' + (name + '\"');
	}
};
var $mdgriffith$elm_ui$Internal$Model$isSmallCaps = function (_var) {
	switch (_var.$) {
		case 'VariantActive':
			var name = _var.a;
			return name === 'smcp';
		case 'VariantOff':
			var name = _var.a;
			return false;
		default:
			var name = _var.a;
			var index = _var.b;
			return (name === 'smcp') && (index === 1);
	}
};
var $mdgriffith$elm_ui$Internal$Model$hasSmallCaps = function (typeface) {
	if (typeface.$ === 'FontWith') {
		var font = typeface.a;
		return A2($elm$core$List$any, $mdgriffith$elm_ui$Internal$Model$isSmallCaps, font.variants);
	} else {
		return false;
	}
};
var $mdgriffith$elm_ui$Internal$Model$renderProps = F3(
	function (force, _v0, existing) {
		var key = _v0.a;
		var val = _v0.b;
		return force ? (existing + ('\n  ' + (key + (': ' + (val + ' !important;'))))) : (existing + ('\n  ' + (key + (': ' + (val + ';')))));
	});
var $mdgriffith$elm_ui$Internal$Model$renderStyle = F4(
	function (options, maybePseudo, selector, props) {
		if (maybePseudo.$ === 'Nothing') {
			return _List_fromArray(
				[
					selector + ('{' + (A3(
					$elm$core$List$foldl,
					$mdgriffith$elm_ui$Internal$Model$renderProps(false),
					'',
					props) + '\n}'))
				]);
		} else {
			var pseudo = maybePseudo.a;
			switch (pseudo.$) {
				case 'Hover':
					var _v2 = options.hover;
					switch (_v2.$) {
						case 'NoHover':
							return _List_Nil;
						case 'ForceHover':
							return _List_fromArray(
								[
									selector + ('-hv {' + (A3(
									$elm$core$List$foldl,
									$mdgriffith$elm_ui$Internal$Model$renderProps(true),
									'',
									props) + '\n}'))
								]);
						default:
							return _List_fromArray(
								[
									selector + ('-hv:hover {' + (A3(
									$elm$core$List$foldl,
									$mdgriffith$elm_ui$Internal$Model$renderProps(false),
									'',
									props) + '\n}'))
								]);
					}
				case 'Focus':
					var renderedProps = A3(
						$elm$core$List$foldl,
						$mdgriffith$elm_ui$Internal$Model$renderProps(false),
						'',
						props);
					return _List_fromArray(
						[
							selector + ('-fs:focus {' + (renderedProps + '\n}')),
							('.' + ($mdgriffith$elm_ui$Internal$Style$classes.any + (':focus ' + (selector + '-fs  {')))) + (renderedProps + '\n}'),
							(selector + '-fs:focus-within {') + (renderedProps + '\n}'),
							('.ui-slide-bar:focus + ' + ($mdgriffith$elm_ui$Internal$Style$dot($mdgriffith$elm_ui$Internal$Style$classes.any) + (' .focusable-thumb' + (selector + '-fs {')))) + (renderedProps + '\n}')
						]);
				default:
					return _List_fromArray(
						[
							selector + ('-act:active {' + (A3(
							$elm$core$List$foldl,
							$mdgriffith$elm_ui$Internal$Model$renderProps(false),
							'',
							props) + '\n}'))
						]);
			}
		}
	});
var $mdgriffith$elm_ui$Internal$Model$renderVariant = function (_var) {
	switch (_var.$) {
		case 'VariantActive':
			var name = _var.a;
			return '\"' + (name + '\"');
		case 'VariantOff':
			var name = _var.a;
			return '\"' + (name + '\" 0');
		default:
			var name = _var.a;
			var index = _var.b;
			return '\"' + (name + ('\" ' + $elm$core$String$fromInt(index)));
	}
};
var $mdgriffith$elm_ui$Internal$Model$renderVariants = function (typeface) {
	if (typeface.$ === 'FontWith') {
		var font = typeface.a;
		return $elm$core$Maybe$Just(
			A2(
				$elm$core$String$join,
				', ',
				A2($elm$core$List$map, $mdgriffith$elm_ui$Internal$Model$renderVariant, font.variants)));
	} else {
		return $elm$core$Maybe$Nothing;
	}
};
var $mdgriffith$elm_ui$Internal$Model$transformValue = function (transform) {
	switch (transform.$) {
		case 'Untransformed':
			return $elm$core$Maybe$Nothing;
		case 'Moved':
			var _v1 = transform.a;
			var x = _v1.a;
			var y = _v1.b;
			var z = _v1.c;
			return $elm$core$Maybe$Just(
				'translate3d(' + ($elm$core$String$fromFloat(x) + ('px, ' + ($elm$core$String$fromFloat(y) + ('px, ' + ($elm$core$String$fromFloat(z) + 'px)'))))));
		default:
			var _v2 = transform.a;
			var tx = _v2.a;
			var ty = _v2.b;
			var tz = _v2.c;
			var _v3 = transform.b;
			var sx = _v3.a;
			var sy = _v3.b;
			var sz = _v3.c;
			var _v4 = transform.c;
			var ox = _v4.a;
			var oy = _v4.b;
			var oz = _v4.c;
			var angle = transform.d;
			var translate = 'translate3d(' + ($elm$core$String$fromFloat(tx) + ('px, ' + ($elm$core$String$fromFloat(ty) + ('px, ' + ($elm$core$String$fromFloat(tz) + 'px)')))));
			var scale = 'scale3d(' + ($elm$core$String$fromFloat(sx) + (', ' + ($elm$core$String$fromFloat(sy) + (', ' + ($elm$core$String$fromFloat(sz) + ')')))));
			var rotate = 'rotate3d(' + ($elm$core$String$fromFloat(ox) + (', ' + ($elm$core$String$fromFloat(oy) + (', ' + ($elm$core$String$fromFloat(oz) + (', ' + ($elm$core$String$fromFloat(angle) + 'rad)')))))));
			return $elm$core$Maybe$Just(translate + (' ' + (scale + (' ' + rotate))));
	}
};
var $mdgriffith$elm_ui$Internal$Model$renderStyleRule = F3(
	function (options, rule, maybePseudo) {
		switch (rule.$) {
			case 'Style':
				var selector = rule.a;
				var props = rule.b;
				return A4($mdgriffith$elm_ui$Internal$Model$renderStyle, options, maybePseudo, selector, props);
			case 'Shadows':
				var name = rule.a;
				var prop = rule.b;
				return A4(
					$mdgriffith$elm_ui$Internal$Model$renderStyle,
					options,
					maybePseudo,
					'.' + name,
					_List_fromArray(
						[
							A2($mdgriffith$elm_ui$Internal$Model$Property, 'box-shadow', prop)
						]));
			case 'Transparency':
				var name = rule.a;
				var transparency = rule.b;
				var opacity = A2(
					$elm$core$Basics$max,
					0,
					A2($elm$core$Basics$min, 1, 1 - transparency));
				return A4(
					$mdgriffith$elm_ui$Internal$Model$renderStyle,
					options,
					maybePseudo,
					'.' + name,
					_List_fromArray(
						[
							A2(
							$mdgriffith$elm_ui$Internal$Model$Property,
							'opacity',
							$elm$core$String$fromFloat(opacity))
						]));
			case 'FontSize':
				var i = rule.a;
				return A4(
					$mdgriffith$elm_ui$Internal$Model$renderStyle,
					options,
					maybePseudo,
					'.font-size-' + $elm$core$String$fromInt(i),
					_List_fromArray(
						[
							A2(
							$mdgriffith$elm_ui$Internal$Model$Property,
							'font-size',
							$elm$core$String$fromInt(i) + 'px')
						]));
			case 'FontFamily':
				var name = rule.a;
				var typefaces = rule.b;
				var features = A2(
					$elm$core$String$join,
					', ',
					A2($elm$core$List$filterMap, $mdgriffith$elm_ui$Internal$Model$renderVariants, typefaces));
				var families = _List_fromArray(
					[
						A2(
						$mdgriffith$elm_ui$Internal$Model$Property,
						'font-family',
						A2(
							$elm$core$String$join,
							', ',
							A2($elm$core$List$map, $mdgriffith$elm_ui$Internal$Model$fontName, typefaces))),
						A2($mdgriffith$elm_ui$Internal$Model$Property, 'font-feature-settings', features),
						A2(
						$mdgriffith$elm_ui$Internal$Model$Property,
						'font-variant',
						A2($elm$core$List$any, $mdgriffith$elm_ui$Internal$Model$hasSmallCaps, typefaces) ? 'small-caps' : 'normal')
					]);
				return A4($mdgriffith$elm_ui$Internal$Model$renderStyle, options, maybePseudo, '.' + name, families);
			case 'Single':
				var _class = rule.a;
				var prop = rule.b;
				var val = rule.c;
				return A4(
					$mdgriffith$elm_ui$Internal$Model$renderStyle,
					options,
					maybePseudo,
					'.' + _class,
					_List_fromArray(
						[
							A2($mdgriffith$elm_ui$Internal$Model$Property, prop, val)
						]));
			case 'Colored':
				var _class = rule.a;
				var prop = rule.b;
				var color = rule.c;
				return A4(
					$mdgriffith$elm_ui$Internal$Model$renderStyle,
					options,
					maybePseudo,
					'.' + _class,
					_List_fromArray(
						[
							A2(
							$mdgriffith$elm_ui$Internal$Model$Property,
							prop,
							$mdgriffith$elm_ui$Internal$Model$formatColor(color))
						]));
			case 'SpacingStyle':
				var cls = rule.a;
				var x = rule.b;
				var y = rule.c;
				var yPx = $elm$core$String$fromInt(y) + 'px';
				var xPx = $elm$core$String$fromInt(x) + 'px';
				var single = '.' + $mdgriffith$elm_ui$Internal$Style$classes.single;
				var row = '.' + $mdgriffith$elm_ui$Internal$Style$classes.row;
				var wrappedRow = '.' + ($mdgriffith$elm_ui$Internal$Style$classes.wrapped + row);
				var right = '.' + $mdgriffith$elm_ui$Internal$Style$classes.alignRight;
				var paragraph = '.' + $mdgriffith$elm_ui$Internal$Style$classes.paragraph;
				var page = '.' + $mdgriffith$elm_ui$Internal$Style$classes.page;
				var left = '.' + $mdgriffith$elm_ui$Internal$Style$classes.alignLeft;
				var halfY = $elm$core$String$fromFloat(y / 2) + 'px';
				var halfX = $elm$core$String$fromFloat(x / 2) + 'px';
				var column = '.' + $mdgriffith$elm_ui$Internal$Style$classes.column;
				var _class = '.' + cls;
				var any = '.' + $mdgriffith$elm_ui$Internal$Style$classes.any;
				return $elm$core$List$concat(
					_List_fromArray(
						[
							A4(
							$mdgriffith$elm_ui$Internal$Model$renderStyle,
							options,
							maybePseudo,
							_class + (row + (' > ' + (any + (' + ' + any)))),
							_List_fromArray(
								[
									A2($mdgriffith$elm_ui$Internal$Model$Property, 'margin-left', xPx)
								])),
							A4(
							$mdgriffith$elm_ui$Internal$Model$renderStyle,
							options,
							maybePseudo,
							_class + (wrappedRow + (' > ' + any)),
							_List_fromArray(
								[
									A2($mdgriffith$elm_ui$Internal$Model$Property, 'margin', halfY + (' ' + halfX))
								])),
							A4(
							$mdgriffith$elm_ui$Internal$Model$renderStyle,
							options,
							maybePseudo,
							_class + (column + (' > ' + (any + (' + ' + any)))),
							_List_fromArray(
								[
									A2($mdgriffith$elm_ui$Internal$Model$Property, 'margin-top', yPx)
								])),
							A4(
							$mdgriffith$elm_ui$Internal$Model$renderStyle,
							options,
							maybePseudo,
							_class + (page + (' > ' + (any + (' + ' + any)))),
							_List_fromArray(
								[
									A2($mdgriffith$elm_ui$Internal$Model$Property, 'margin-top', yPx)
								])),
							A4(
							$mdgriffith$elm_ui$Internal$Model$renderStyle,
							options,
							maybePseudo,
							_class + (page + (' > ' + left)),
							_List_fromArray(
								[
									A2($mdgriffith$elm_ui$Internal$Model$Property, 'margin-right', xPx)
								])),
							A4(
							$mdgriffith$elm_ui$Internal$Model$renderStyle,
							options,
							maybePseudo,
							_class + (page + (' > ' + right)),
							_List_fromArray(
								[
									A2($mdgriffith$elm_ui$Internal$Model$Property, 'margin-left', xPx)
								])),
							A4(
							$mdgriffith$elm_ui$Internal$Model$renderStyle,
							options,
							maybePseudo,
							_Utils_ap(_class, paragraph),
							_List_fromArray(
								[
									A2(
									$mdgriffith$elm_ui$Internal$Model$Property,
									'line-height',
									'calc(1em + ' + ($elm$core$String$fromInt(y) + 'px)'))
								])),
							A4(
							$mdgriffith$elm_ui$Internal$Model$renderStyle,
							options,
							maybePseudo,
							'textarea' + (any + _class),
							_List_fromArray(
								[
									A2(
									$mdgriffith$elm_ui$Internal$Model$Property,
									'line-height',
									'calc(1em + ' + ($elm$core$String$fromInt(y) + 'px)')),
									A2(
									$mdgriffith$elm_ui$Internal$Model$Property,
									'height',
									'calc(100% + ' + ($elm$core$String$fromInt(y) + 'px)'))
								])),
							A4(
							$mdgriffith$elm_ui$Internal$Model$renderStyle,
							options,
							maybePseudo,
							_class + (paragraph + (' > ' + left)),
							_List_fromArray(
								[
									A2($mdgriffith$elm_ui$Internal$Model$Property, 'margin-right', xPx)
								])),
							A4(
							$mdgriffith$elm_ui$Internal$Model$renderStyle,
							options,
							maybePseudo,
							_class + (paragraph + (' > ' + right)),
							_List_fromArray(
								[
									A2($mdgriffith$elm_ui$Internal$Model$Property, 'margin-left', xPx)
								])),
							A4(
							$mdgriffith$elm_ui$Internal$Model$renderStyle,
							options,
							maybePseudo,
							_class + (paragraph + '::after'),
							_List_fromArray(
								[
									A2($mdgriffith$elm_ui$Internal$Model$Property, 'content', '\'\''),
									A2($mdgriffith$elm_ui$Internal$Model$Property, 'display', 'block'),
									A2($mdgriffith$elm_ui$Internal$Model$Property, 'height', '0'),
									A2($mdgriffith$elm_ui$Internal$Model$Property, 'width', '0'),
									A2(
									$mdgriffith$elm_ui$Internal$Model$Property,
									'margin-top',
									$elm$core$String$fromInt((-1) * ((y / 2) | 0)) + 'px')
								])),
							A4(
							$mdgriffith$elm_ui$Internal$Model$renderStyle,
							options,
							maybePseudo,
							_class + (paragraph + '::before'),
							_List_fromArray(
								[
									A2($mdgriffith$elm_ui$Internal$Model$Property, 'content', '\'\''),
									A2($mdgriffith$elm_ui$Internal$Model$Property, 'display', 'block'),
									A2($mdgriffith$elm_ui$Internal$Model$Property, 'height', '0'),
									A2($mdgriffith$elm_ui$Internal$Model$Property, 'width', '0'),
									A2(
									$mdgriffith$elm_ui$Internal$Model$Property,
									'margin-bottom',
									$elm$core$String$fromInt((-1) * ((y / 2) | 0)) + 'px')
								]))
						]));
			case 'PaddingStyle':
				var cls = rule.a;
				var top = rule.b;
				var right = rule.c;
				var bottom = rule.d;
				var left = rule.e;
				var _class = '.' + cls;
				return A4(
					$mdgriffith$elm_ui$Internal$Model$renderStyle,
					options,
					maybePseudo,
					_class,
					_List_fromArray(
						[
							A2(
							$mdgriffith$elm_ui$Internal$Model$Property,
							'padding',
							$elm$core$String$fromFloat(top) + ('px ' + ($elm$core$String$fromFloat(right) + ('px ' + ($elm$core$String$fromFloat(bottom) + ('px ' + ($elm$core$String$fromFloat(left) + 'px')))))))
						]));
			case 'BorderWidth':
				var cls = rule.a;
				var top = rule.b;
				var right = rule.c;
				var bottom = rule.d;
				var left = rule.e;
				var _class = '.' + cls;
				return A4(
					$mdgriffith$elm_ui$Internal$Model$renderStyle,
					options,
					maybePseudo,
					_class,
					_List_fromArray(
						[
							A2(
							$mdgriffith$elm_ui$Internal$Model$Property,
							'border-width',
							$elm$core$String$fromInt(top) + ('px ' + ($elm$core$String$fromInt(right) + ('px ' + ($elm$core$String$fromInt(bottom) + ('px ' + ($elm$core$String$fromInt(left) + 'px')))))))
						]));
			case 'GridTemplateStyle':
				var template = rule.a;
				var toGridLengthHelper = F3(
					function (minimum, maximum, x) {
						toGridLengthHelper:
						while (true) {
							switch (x.$) {
								case 'Px':
									var px = x.a;
									return $elm$core$String$fromInt(px) + 'px';
								case 'Content':
									var _v2 = _Utils_Tuple2(minimum, maximum);
									if (_v2.a.$ === 'Nothing') {
										if (_v2.b.$ === 'Nothing') {
											var _v3 = _v2.a;
											var _v4 = _v2.b;
											return 'max-content';
										} else {
											var _v6 = _v2.a;
											var maxSize = _v2.b.a;
											return 'minmax(max-content, ' + ($elm$core$String$fromInt(maxSize) + 'px)');
										}
									} else {
										if (_v2.b.$ === 'Nothing') {
											var minSize = _v2.a.a;
											var _v5 = _v2.b;
											return 'minmax(' + ($elm$core$String$fromInt(minSize) + ('px, ' + 'max-content)'));
										} else {
											var minSize = _v2.a.a;
											var maxSize = _v2.b.a;
											return 'minmax(' + ($elm$core$String$fromInt(minSize) + ('px, ' + ($elm$core$String$fromInt(maxSize) + 'px)')));
										}
									}
								case 'Fill':
									var i = x.a;
									var _v7 = _Utils_Tuple2(minimum, maximum);
									if (_v7.a.$ === 'Nothing') {
										if (_v7.b.$ === 'Nothing') {
											var _v8 = _v7.a;
											var _v9 = _v7.b;
											return $elm$core$String$fromInt(i) + 'fr';
										} else {
											var _v11 = _v7.a;
											var maxSize = _v7.b.a;
											return 'minmax(max-content, ' + ($elm$core$String$fromInt(maxSize) + 'px)');
										}
									} else {
										if (_v7.b.$ === 'Nothing') {
											var minSize = _v7.a.a;
											var _v10 = _v7.b;
											return 'minmax(' + ($elm$core$String$fromInt(minSize) + ('px, ' + ($elm$core$String$fromInt(i) + ('fr' + 'fr)'))));
										} else {
											var minSize = _v7.a.a;
											var maxSize = _v7.b.a;
											return 'minmax(' + ($elm$core$String$fromInt(minSize) + ('px, ' + ($elm$core$String$fromInt(maxSize) + 'px)')));
										}
									}
								case 'Min':
									var m = x.a;
									var len = x.b;
									var $temp$minimum = $elm$core$Maybe$Just(m),
										$temp$maximum = maximum,
										$temp$x = len;
									minimum = $temp$minimum;
									maximum = $temp$maximum;
									x = $temp$x;
									continue toGridLengthHelper;
								default:
									var m = x.a;
									var len = x.b;
									var $temp$minimum = minimum,
										$temp$maximum = $elm$core$Maybe$Just(m),
										$temp$x = len;
									minimum = $temp$minimum;
									maximum = $temp$maximum;
									x = $temp$x;
									continue toGridLengthHelper;
							}
						}
					});
				var toGridLength = function (x) {
					return A3(toGridLengthHelper, $elm$core$Maybe$Nothing, $elm$core$Maybe$Nothing, x);
				};
				var xSpacing = toGridLength(template.spacing.a);
				var ySpacing = toGridLength(template.spacing.b);
				var rows = function (x) {
					return 'grid-template-rows: ' + (x + ';');
				}(
					A2(
						$elm$core$String$join,
						' ',
						A2($elm$core$List$map, toGridLength, template.rows)));
				var msRows = function (x) {
					return '-ms-grid-rows: ' + (x + ';');
				}(
					A2(
						$elm$core$String$join,
						ySpacing,
						A2($elm$core$List$map, toGridLength, template.columns)));
				var msColumns = function (x) {
					return '-ms-grid-columns: ' + (x + ';');
				}(
					A2(
						$elm$core$String$join,
						ySpacing,
						A2($elm$core$List$map, toGridLength, template.columns)));
				var gapY = 'grid-row-gap:' + (toGridLength(template.spacing.b) + ';');
				var gapX = 'grid-column-gap:' + (toGridLength(template.spacing.a) + ';');
				var columns = function (x) {
					return 'grid-template-columns: ' + (x + ';');
				}(
					A2(
						$elm$core$String$join,
						' ',
						A2($elm$core$List$map, toGridLength, template.columns)));
				var _class = '.grid-rows-' + (A2(
					$elm$core$String$join,
					'-',
					A2($elm$core$List$map, $mdgriffith$elm_ui$Internal$Model$lengthClassName, template.rows)) + ('-cols-' + (A2(
					$elm$core$String$join,
					'-',
					A2($elm$core$List$map, $mdgriffith$elm_ui$Internal$Model$lengthClassName, template.columns)) + ('-space-x-' + ($mdgriffith$elm_ui$Internal$Model$lengthClassName(template.spacing.a) + ('-space-y-' + $mdgriffith$elm_ui$Internal$Model$lengthClassName(template.spacing.b)))))));
				var modernGrid = _class + ('{' + (columns + (rows + (gapX + (gapY + '}')))));
				var supports = '@supports (display:grid) {' + (modernGrid + '}');
				var base = _class + ('{' + (msColumns + (msRows + '}')));
				return _List_fromArray(
					[base, supports]);
			case 'GridPosition':
				var position = rule.a;
				var msPosition = A2(
					$elm$core$String$join,
					' ',
					_List_fromArray(
						[
							'-ms-grid-row: ' + ($elm$core$String$fromInt(position.row) + ';'),
							'-ms-grid-row-span: ' + ($elm$core$String$fromInt(position.height) + ';'),
							'-ms-grid-column: ' + ($elm$core$String$fromInt(position.col) + ';'),
							'-ms-grid-column-span: ' + ($elm$core$String$fromInt(position.width) + ';')
						]));
				var modernPosition = A2(
					$elm$core$String$join,
					' ',
					_List_fromArray(
						[
							'grid-row: ' + ($elm$core$String$fromInt(position.row) + (' / ' + ($elm$core$String$fromInt(position.row + position.height) + ';'))),
							'grid-column: ' + ($elm$core$String$fromInt(position.col) + (' / ' + ($elm$core$String$fromInt(position.col + position.width) + ';')))
						]));
				var _class = '.grid-pos-' + ($elm$core$String$fromInt(position.row) + ('-' + ($elm$core$String$fromInt(position.col) + ('-' + ($elm$core$String$fromInt(position.width) + ('-' + $elm$core$String$fromInt(position.height)))))));
				var modernGrid = _class + ('{' + (modernPosition + '}'));
				var supports = '@supports (display:grid) {' + (modernGrid + '}');
				var base = _class + ('{' + (msPosition + '}'));
				return _List_fromArray(
					[base, supports]);
			case 'PseudoSelector':
				var _class = rule.a;
				var styles = rule.b;
				var renderPseudoRule = function (style) {
					return A3(
						$mdgriffith$elm_ui$Internal$Model$renderStyleRule,
						options,
						style,
						$elm$core$Maybe$Just(_class));
				};
				return A2($elm$core$List$concatMap, renderPseudoRule, styles);
			default:
				var transform = rule.a;
				var val = $mdgriffith$elm_ui$Internal$Model$transformValue(transform);
				var _class = $mdgriffith$elm_ui$Internal$Model$transformClass(transform);
				var _v12 = _Utils_Tuple2(_class, val);
				if ((_v12.a.$ === 'Just') && (_v12.b.$ === 'Just')) {
					var cls = _v12.a.a;
					var v = _v12.b.a;
					return A4(
						$mdgriffith$elm_ui$Internal$Model$renderStyle,
						options,
						maybePseudo,
						'.' + cls,
						_List_fromArray(
							[
								A2($mdgriffith$elm_ui$Internal$Model$Property, 'transform', v)
							]));
				} else {
					return _List_Nil;
				}
		}
	});
var $mdgriffith$elm_ui$Internal$Model$encodeStyles = F2(
	function (options, stylesheet) {
		return $elm$json$Json$Encode$object(
			A2(
				$elm$core$List$map,
				function (style) {
					var styled = A3($mdgriffith$elm_ui$Internal$Model$renderStyleRule, options, style, $elm$core$Maybe$Nothing);
					return _Utils_Tuple2(
						$mdgriffith$elm_ui$Internal$Model$getStyleName(style),
						A2($elm$json$Json$Encode$list, $elm$json$Json$Encode$string, styled));
				},
				stylesheet));
	});
var $mdgriffith$elm_ui$Internal$Model$bracket = F2(
	function (selector, rules) {
		var renderPair = function (_v0) {
			var name = _v0.a;
			var val = _v0.b;
			return name + (': ' + (val + ';'));
		};
		return selector + (' {' + (A2(
			$elm$core$String$join,
			'',
			A2($elm$core$List$map, renderPair, rules)) + '}'));
	});
var $mdgriffith$elm_ui$Internal$Model$fontRule = F3(
	function (name, modifier, _v0) {
		var parentAdj = _v0.a;
		var textAdjustment = _v0.b;
		return _List_fromArray(
			[
				A2($mdgriffith$elm_ui$Internal$Model$bracket, '.' + (name + ('.' + (modifier + (', ' + ('.' + (name + (' .' + modifier))))))), parentAdj),
				A2($mdgriffith$elm_ui$Internal$Model$bracket, '.' + (name + ('.' + (modifier + ('> .' + ($mdgriffith$elm_ui$Internal$Style$classes.text + (', .' + (name + (' .' + (modifier + (' > .' + $mdgriffith$elm_ui$Internal$Style$classes.text)))))))))), textAdjustment)
			]);
	});
var $mdgriffith$elm_ui$Internal$Model$renderFontAdjustmentRule = F3(
	function (fontToAdjust, _v0, otherFontName) {
		var full = _v0.a;
		var capital = _v0.b;
		var name = _Utils_eq(fontToAdjust, otherFontName) ? fontToAdjust : (otherFontName + (' .' + fontToAdjust));
		return A2(
			$elm$core$String$join,
			' ',
			_Utils_ap(
				A3($mdgriffith$elm_ui$Internal$Model$fontRule, name, $mdgriffith$elm_ui$Internal$Style$classes.sizeByCapital, capital),
				A3($mdgriffith$elm_ui$Internal$Model$fontRule, name, $mdgriffith$elm_ui$Internal$Style$classes.fullSize, full)));
	});
var $mdgriffith$elm_ui$Internal$Model$renderNullAdjustmentRule = F2(
	function (fontToAdjust, otherFontName) {
		var name = _Utils_eq(fontToAdjust, otherFontName) ? fontToAdjust : (otherFontName + (' .' + fontToAdjust));
		return A2(
			$elm$core$String$join,
			' ',
			_List_fromArray(
				[
					A2(
					$mdgriffith$elm_ui$Internal$Model$bracket,
					'.' + (name + ('.' + ($mdgriffith$elm_ui$Internal$Style$classes.sizeByCapital + (', ' + ('.' + (name + (' .' + $mdgriffith$elm_ui$Internal$Style$classes.sizeByCapital))))))),
					_List_fromArray(
						[
							_Utils_Tuple2('line-height', '1')
						])),
					A2(
					$mdgriffith$elm_ui$Internal$Model$bracket,
					'.' + (name + ('.' + ($mdgriffith$elm_ui$Internal$Style$classes.sizeByCapital + ('> .' + ($mdgriffith$elm_ui$Internal$Style$classes.text + (', .' + (name + (' .' + ($mdgriffith$elm_ui$Internal$Style$classes.sizeByCapital + (' > .' + $mdgriffith$elm_ui$Internal$Style$classes.text)))))))))),
					_List_fromArray(
						[
							_Utils_Tuple2('vertical-align', '0'),
							_Utils_Tuple2('line-height', '1')
						]))
				]));
	});
var $mdgriffith$elm_ui$Internal$Model$adjust = F3(
	function (size, height, vertical) {
		return {height: height / size, size: size, vertical: vertical};
	});
var $elm$core$List$filter = F2(
	function (isGood, list) {
		return A3(
			$elm$core$List$foldr,
			F2(
				function (x, xs) {
					return isGood(x) ? A2($elm$core$List$cons, x, xs) : xs;
				}),
			_List_Nil,
			list);
	});
var $elm$core$List$maximum = function (list) {
	if (list.b) {
		var x = list.a;
		var xs = list.b;
		return $elm$core$Maybe$Just(
			A3($elm$core$List$foldl, $elm$core$Basics$max, x, xs));
	} else {
		return $elm$core$Maybe$Nothing;
	}
};
var $elm$core$List$minimum = function (list) {
	if (list.b) {
		var x = list.a;
		var xs = list.b;
		return $elm$core$Maybe$Just(
			A3($elm$core$List$foldl, $elm$core$Basics$min, x, xs));
	} else {
		return $elm$core$Maybe$Nothing;
	}
};
var $elm$core$Basics$neq = _Utils_notEqual;
var $mdgriffith$elm_ui$Internal$Model$convertAdjustment = function (adjustment) {
	var lines = _List_fromArray(
		[adjustment.capital, adjustment.baseline, adjustment.descender, adjustment.lowercase]);
	var lineHeight = 1.5;
	var normalDescender = (lineHeight - 1) / 2;
	var oldMiddle = lineHeight / 2;
	var descender = A2(
		$elm$core$Maybe$withDefault,
		adjustment.descender,
		$elm$core$List$minimum(lines));
	var newBaseline = A2(
		$elm$core$Maybe$withDefault,
		adjustment.baseline,
		$elm$core$List$minimum(
			A2(
				$elm$core$List$filter,
				function (x) {
					return !_Utils_eq(x, descender);
				},
				lines)));
	var base = lineHeight;
	var ascender = A2(
		$elm$core$Maybe$withDefault,
		adjustment.capital,
		$elm$core$List$maximum(lines));
	var capitalSize = 1 / (ascender - newBaseline);
	var capitalVertical = 1 - ascender;
	var fullSize = 1 / (ascender - descender);
	var fullVertical = 1 - ascender;
	var newCapitalMiddle = ((ascender - newBaseline) / 2) + newBaseline;
	var newFullMiddle = ((ascender - descender) / 2) + descender;
	return {
		capital: A3($mdgriffith$elm_ui$Internal$Model$adjust, capitalSize, ascender - newBaseline, capitalVertical),
		full: A3($mdgriffith$elm_ui$Internal$Model$adjust, fullSize, ascender - descender, fullVertical)
	};
};
var $mdgriffith$elm_ui$Internal$Model$fontAdjustmentRules = function (converted) {
	return _Utils_Tuple2(
		_List_fromArray(
			[
				_Utils_Tuple2('display', 'block')
			]),
		_List_fromArray(
			[
				_Utils_Tuple2('display', 'inline-block'),
				_Utils_Tuple2(
				'line-height',
				$elm$core$String$fromFloat(converted.height)),
				_Utils_Tuple2(
				'vertical-align',
				$elm$core$String$fromFloat(converted.vertical) + 'em'),
				_Utils_Tuple2(
				'font-size',
				$elm$core$String$fromFloat(converted.size) + 'em')
			]));
};
var $mdgriffith$elm_ui$Internal$Model$typefaceAdjustment = function (typefaces) {
	return A3(
		$elm$core$List$foldl,
		F2(
			function (face, found) {
				if (found.$ === 'Nothing') {
					if (face.$ === 'FontWith') {
						var _with = face.a;
						var _v2 = _with.adjustment;
						if (_v2.$ === 'Nothing') {
							return found;
						} else {
							var adjustment = _v2.a;
							return $elm$core$Maybe$Just(
								_Utils_Tuple2(
									$mdgriffith$elm_ui$Internal$Model$fontAdjustmentRules(
										function ($) {
											return $.full;
										}(
											$mdgriffith$elm_ui$Internal$Model$convertAdjustment(adjustment))),
									$mdgriffith$elm_ui$Internal$Model$fontAdjustmentRules(
										function ($) {
											return $.capital;
										}(
											$mdgriffith$elm_ui$Internal$Model$convertAdjustment(adjustment)))));
						}
					} else {
						return found;
					}
				} else {
					return found;
				}
			}),
		$elm$core$Maybe$Nothing,
		typefaces);
};
var $mdgriffith$elm_ui$Internal$Model$renderTopLevelValues = function (rules) {
	var withImport = function (font) {
		if (font.$ === 'ImportFont') {
			var url = font.b;
			return $elm$core$Maybe$Just('@import url(\'' + (url + '\');'));
		} else {
			return $elm$core$Maybe$Nothing;
		}
	};
	var fontImports = function (_v2) {
		var name = _v2.a;
		var typefaces = _v2.b;
		var imports = A2(
			$elm$core$String$join,
			'\n',
			A2($elm$core$List$filterMap, withImport, typefaces));
		return imports;
	};
	var allNames = A2($elm$core$List$map, $elm$core$Tuple$first, rules);
	var fontAdjustments = function (_v1) {
		var name = _v1.a;
		var typefaces = _v1.b;
		var _v0 = $mdgriffith$elm_ui$Internal$Model$typefaceAdjustment(typefaces);
		if (_v0.$ === 'Nothing') {
			return A2(
				$elm$core$String$join,
				'',
				A2(
					$elm$core$List$map,
					$mdgriffith$elm_ui$Internal$Model$renderNullAdjustmentRule(name),
					allNames));
		} else {
			var adjustment = _v0.a;
			return A2(
				$elm$core$String$join,
				'',
				A2(
					$elm$core$List$map,
					A2($mdgriffith$elm_ui$Internal$Model$renderFontAdjustmentRule, name, adjustment),
					allNames));
		}
	};
	return _Utils_ap(
		A2(
			$elm$core$String$join,
			'\n',
			A2($elm$core$List$map, fontImports, rules)),
		A2(
			$elm$core$String$join,
			'\n',
			A2($elm$core$List$map, fontAdjustments, rules)));
};
var $mdgriffith$elm_ui$Internal$Model$topLevelValue = function (rule) {
	if (rule.$ === 'FontFamily') {
		var name = rule.a;
		var typefaces = rule.b;
		return $elm$core$Maybe$Just(
			_Utils_Tuple2(name, typefaces));
	} else {
		return $elm$core$Maybe$Nothing;
	}
};
var $mdgriffith$elm_ui$Internal$Model$toStyleSheetString = F2(
	function (options, stylesheet) {
		var combine = F2(
			function (style, rendered) {
				return {
					rules: _Utils_ap(
						rendered.rules,
						A3($mdgriffith$elm_ui$Internal$Model$renderStyleRule, options, style, $elm$core$Maybe$Nothing)),
					topLevel: function () {
						var _v1 = $mdgriffith$elm_ui$Internal$Model$topLevelValue(style);
						if (_v1.$ === 'Nothing') {
							return rendered.topLevel;
						} else {
							var topLevel = _v1.a;
							return A2($elm$core$List$cons, topLevel, rendered.topLevel);
						}
					}()
				};
			});
		var _v0 = A3(
			$elm$core$List$foldl,
			combine,
			{rules: _List_Nil, topLevel: _List_Nil},
			stylesheet);
		var topLevel = _v0.topLevel;
		var rules = _v0.rules;
		return _Utils_ap(
			$mdgriffith$elm_ui$Internal$Model$renderTopLevelValues(topLevel),
			$elm$core$String$concat(rules));
	});
var $mdgriffith$elm_ui$Internal$Model$toStyleSheet = F2(
	function (options, styleSheet) {
		var _v0 = options.mode;
		switch (_v0.$) {
			case 'Layout':
				return A3(
					$elm$virtual_dom$VirtualDom$node,
					'div',
					_List_Nil,
					_List_fromArray(
						[
							A3(
							$elm$virtual_dom$VirtualDom$node,
							'style',
							_List_Nil,
							_List_fromArray(
								[
									$elm$virtual_dom$VirtualDom$text(
									A2($mdgriffith$elm_ui$Internal$Model$toStyleSheetString, options, styleSheet))
								]))
						]));
			case 'NoStaticStyleSheet':
				return A3(
					$elm$virtual_dom$VirtualDom$node,
					'div',
					_List_Nil,
					_List_fromArray(
						[
							A3(
							$elm$virtual_dom$VirtualDom$node,
							'style',
							_List_Nil,
							_List_fromArray(
								[
									$elm$virtual_dom$VirtualDom$text(
									A2($mdgriffith$elm_ui$Internal$Model$toStyleSheetString, options, styleSheet))
								]))
						]));
			default:
				return A3(
					$elm$virtual_dom$VirtualDom$node,
					'elm-ui-rules',
					_List_fromArray(
						[
							A2(
							$elm$virtual_dom$VirtualDom$property,
							'rules',
							A2($mdgriffith$elm_ui$Internal$Model$encodeStyles, options, styleSheet))
						]),
					_List_Nil);
		}
	});
var $mdgriffith$elm_ui$Internal$Model$embedKeyed = F4(
	function (_static, opts, styles, children) {
		var dynamicStyleSheet = A2(
			$mdgriffith$elm_ui$Internal$Model$toStyleSheet,
			opts,
			A3(
				$elm$core$List$foldl,
				$mdgriffith$elm_ui$Internal$Model$reduceStyles,
				_Utils_Tuple2(
					$elm$core$Set$empty,
					$mdgriffith$elm_ui$Internal$Model$renderFocusStyle(opts.focus)),
				styles).b);
		return _static ? A2(
			$elm$core$List$cons,
			_Utils_Tuple2(
				'static-stylesheet',
				$mdgriffith$elm_ui$Internal$Model$staticRoot(opts)),
			A2(
				$elm$core$List$cons,
				_Utils_Tuple2('dynamic-stylesheet', dynamicStyleSheet),
				children)) : A2(
			$elm$core$List$cons,
			_Utils_Tuple2('dynamic-stylesheet', dynamicStyleSheet),
			children);
	});
var $mdgriffith$elm_ui$Internal$Model$embedWith = F4(
	function (_static, opts, styles, children) {
		var dynamicStyleSheet = A2(
			$mdgriffith$elm_ui$Internal$Model$toStyleSheet,
			opts,
			A3(
				$elm$core$List$foldl,
				$mdgriffith$elm_ui$Internal$Model$reduceStyles,
				_Utils_Tuple2(
					$elm$core$Set$empty,
					$mdgriffith$elm_ui$Internal$Model$renderFocusStyle(opts.focus)),
				styles).b);
		return _static ? A2(
			$elm$core$List$cons,
			$mdgriffith$elm_ui$Internal$Model$staticRoot(opts),
			A2($elm$core$List$cons, dynamicStyleSheet, children)) : A2($elm$core$List$cons, dynamicStyleSheet, children);
	});
var $mdgriffith$elm_ui$Internal$Flag$heightBetween = $mdgriffith$elm_ui$Internal$Flag$flag(45);
var $mdgriffith$elm_ui$Internal$Flag$heightFill = $mdgriffith$elm_ui$Internal$Flag$flag(37);
var $elm$virtual_dom$VirtualDom$keyedNode = function (tag) {
	return _VirtualDom_keyedNode(
		_VirtualDom_noScript(tag));
};
var $elm$html$Html$p = _VirtualDom_node('p');
var $elm$core$Bitwise$and = _Bitwise_and;
var $mdgriffith$elm_ui$Internal$Flag$present = F2(
	function (myFlag, _v0) {
		var fieldOne = _v0.a;
		var fieldTwo = _v0.b;
		if (myFlag.$ === 'Flag') {
			var first = myFlag.a;
			return _Utils_eq(first & fieldOne, first);
		} else {
			var second = myFlag.a;
			return _Utils_eq(second & fieldTwo, second);
		}
	});
var $elm$html$Html$s = _VirtualDom_node('s');
var $elm$html$Html$u = _VirtualDom_node('u');
var $mdgriffith$elm_ui$Internal$Flag$widthBetween = $mdgriffith$elm_ui$Internal$Flag$flag(44);
var $mdgriffith$elm_ui$Internal$Flag$widthFill = $mdgriffith$elm_ui$Internal$Flag$flag(39);
var $mdgriffith$elm_ui$Internal$Model$finalizeNode = F6(
	function (has, node, attributes, children, embedMode, parentContext) {
		var createNode = F2(
			function (nodeName, attrs) {
				if (children.$ === 'Keyed') {
					var keyed = children.a;
					return A3(
						$elm$virtual_dom$VirtualDom$keyedNode,
						nodeName,
						attrs,
						function () {
							switch (embedMode.$) {
								case 'NoStyleSheet':
									return keyed;
								case 'OnlyDynamic':
									var opts = embedMode.a;
									var styles = embedMode.b;
									return A4($mdgriffith$elm_ui$Internal$Model$embedKeyed, false, opts, styles, keyed);
								default:
									var opts = embedMode.a;
									var styles = embedMode.b;
									return A4($mdgriffith$elm_ui$Internal$Model$embedKeyed, true, opts, styles, keyed);
							}
						}());
				} else {
					var unkeyed = children.a;
					return A2(
						function () {
							switch (nodeName) {
								case 'div':
									return $elm$html$Html$div;
								case 'p':
									return $elm$html$Html$p;
								default:
									return $elm$virtual_dom$VirtualDom$node(nodeName);
							}
						}(),
						attrs,
						function () {
							switch (embedMode.$) {
								case 'NoStyleSheet':
									return unkeyed;
								case 'OnlyDynamic':
									var opts = embedMode.a;
									var styles = embedMode.b;
									return A4($mdgriffith$elm_ui$Internal$Model$embedWith, false, opts, styles, unkeyed);
								default:
									var opts = embedMode.a;
									var styles = embedMode.b;
									return A4($mdgriffith$elm_ui$Internal$Model$embedWith, true, opts, styles, unkeyed);
							}
						}());
				}
			});
		var html = function () {
			switch (node.$) {
				case 'Generic':
					return A2(createNode, 'div', attributes);
				case 'NodeName':
					var nodeName = node.a;
					return A2(createNode, nodeName, attributes);
				default:
					var nodeName = node.a;
					var internal = node.b;
					return A3(
						$elm$virtual_dom$VirtualDom$node,
						nodeName,
						attributes,
						_List_fromArray(
							[
								A2(
								createNode,
								internal,
								_List_fromArray(
									[
										$elm$html$Html$Attributes$class($mdgriffith$elm_ui$Internal$Style$classes.any + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.single))
									]))
							]));
			}
		}();
		switch (parentContext.$) {
			case 'AsRow':
				return (A2($mdgriffith$elm_ui$Internal$Flag$present, $mdgriffith$elm_ui$Internal$Flag$widthFill, has) && (!A2($mdgriffith$elm_ui$Internal$Flag$present, $mdgriffith$elm_ui$Internal$Flag$widthBetween, has))) ? html : (A2($mdgriffith$elm_ui$Internal$Flag$present, $mdgriffith$elm_ui$Internal$Flag$alignRight, has) ? A2(
					$elm$html$Html$u,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class(
							A2(
								$elm$core$String$join,
								' ',
								_List_fromArray(
									[$mdgriffith$elm_ui$Internal$Style$classes.any, $mdgriffith$elm_ui$Internal$Style$classes.single, $mdgriffith$elm_ui$Internal$Style$classes.container, $mdgriffith$elm_ui$Internal$Style$classes.contentCenterY, $mdgriffith$elm_ui$Internal$Style$classes.alignContainerRight])))
						]),
					_List_fromArray(
						[html])) : (A2($mdgriffith$elm_ui$Internal$Flag$present, $mdgriffith$elm_ui$Internal$Flag$centerX, has) ? A2(
					$elm$html$Html$s,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class(
							A2(
								$elm$core$String$join,
								' ',
								_List_fromArray(
									[$mdgriffith$elm_ui$Internal$Style$classes.any, $mdgriffith$elm_ui$Internal$Style$classes.single, $mdgriffith$elm_ui$Internal$Style$classes.container, $mdgriffith$elm_ui$Internal$Style$classes.contentCenterY, $mdgriffith$elm_ui$Internal$Style$classes.alignContainerCenterX])))
						]),
					_List_fromArray(
						[html])) : html));
			case 'AsColumn':
				return (A2($mdgriffith$elm_ui$Internal$Flag$present, $mdgriffith$elm_ui$Internal$Flag$heightFill, has) && (!A2($mdgriffith$elm_ui$Internal$Flag$present, $mdgriffith$elm_ui$Internal$Flag$heightBetween, has))) ? html : (A2($mdgriffith$elm_ui$Internal$Flag$present, $mdgriffith$elm_ui$Internal$Flag$centerY, has) ? A2(
					$elm$html$Html$s,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class(
							A2(
								$elm$core$String$join,
								' ',
								_List_fromArray(
									[$mdgriffith$elm_ui$Internal$Style$classes.any, $mdgriffith$elm_ui$Internal$Style$classes.single, $mdgriffith$elm_ui$Internal$Style$classes.container, $mdgriffith$elm_ui$Internal$Style$classes.alignContainerCenterY])))
						]),
					_List_fromArray(
						[html])) : (A2($mdgriffith$elm_ui$Internal$Flag$present, $mdgriffith$elm_ui$Internal$Flag$alignBottom, has) ? A2(
					$elm$html$Html$u,
					_List_fromArray(
						[
							$elm$html$Html$Attributes$class(
							A2(
								$elm$core$String$join,
								' ',
								_List_fromArray(
									[$mdgriffith$elm_ui$Internal$Style$classes.any, $mdgriffith$elm_ui$Internal$Style$classes.single, $mdgriffith$elm_ui$Internal$Style$classes.container, $mdgriffith$elm_ui$Internal$Style$classes.alignContainerBottom])))
						]),
					_List_fromArray(
						[html])) : html));
			default:
				return html;
		}
	});
var $elm$core$List$isEmpty = function (xs) {
	if (!xs.b) {
		return true;
	} else {
		return false;
	}
};
var $mdgriffith$elm_ui$Internal$Model$textElementClasses = $mdgriffith$elm_ui$Internal$Style$classes.any + (' ' + ($mdgriffith$elm_ui$Internal$Style$classes.text + (' ' + ($mdgriffith$elm_ui$Internal$Style$classes.widthContent + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.heightContent)))));
var $mdgriffith$elm_ui$Internal$Model$textElement = function (str) {
	return A2(
		$elm$html$Html$div,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$class($mdgriffith$elm_ui$Internal$Model$textElementClasses)
			]),
		_List_fromArray(
			[
				$elm$html$Html$text(str)
			]));
};
var $mdgriffith$elm_ui$Internal$Model$textElementFillClasses = $mdgriffith$elm_ui$Internal$Style$classes.any + (' ' + ($mdgriffith$elm_ui$Internal$Style$classes.text + (' ' + ($mdgriffith$elm_ui$Internal$Style$classes.widthFill + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.heightFill)))));
var $mdgriffith$elm_ui$Internal$Model$textElementFill = function (str) {
	return A2(
		$elm$html$Html$div,
		_List_fromArray(
			[
				$elm$html$Html$Attributes$class($mdgriffith$elm_ui$Internal$Model$textElementFillClasses)
			]),
		_List_fromArray(
			[
				$elm$html$Html$text(str)
			]));
};
var $mdgriffith$elm_ui$Internal$Model$createElement = F3(
	function (context, children, rendered) {
		var gatherKeyed = F2(
			function (_v8, _v9) {
				var key = _v8.a;
				var child = _v8.b;
				var htmls = _v9.a;
				var existingStyles = _v9.b;
				switch (child.$) {
					case 'Unstyled':
						var html = child.a;
						return _Utils_eq(context, $mdgriffith$elm_ui$Internal$Model$asParagraph) ? _Utils_Tuple2(
							A2(
								$elm$core$List$cons,
								_Utils_Tuple2(
									key,
									html(context)),
								htmls),
							existingStyles) : _Utils_Tuple2(
							A2(
								$elm$core$List$cons,
								_Utils_Tuple2(
									key,
									html(context)),
								htmls),
							existingStyles);
					case 'Styled':
						var styled = child.a;
						return _Utils_eq(context, $mdgriffith$elm_ui$Internal$Model$asParagraph) ? _Utils_Tuple2(
							A2(
								$elm$core$List$cons,
								_Utils_Tuple2(
									key,
									A2(styled.html, $mdgriffith$elm_ui$Internal$Model$NoStyleSheet, context)),
								htmls),
							$elm$core$List$isEmpty(existingStyles) ? styled.styles : _Utils_ap(styled.styles, existingStyles)) : _Utils_Tuple2(
							A2(
								$elm$core$List$cons,
								_Utils_Tuple2(
									key,
									A2(styled.html, $mdgriffith$elm_ui$Internal$Model$NoStyleSheet, context)),
								htmls),
							$elm$core$List$isEmpty(existingStyles) ? styled.styles : _Utils_ap(styled.styles, existingStyles));
					case 'Text':
						var str = child.a;
						return _Utils_Tuple2(
							A2(
								$elm$core$List$cons,
								_Utils_Tuple2(
									key,
									_Utils_eq(context, $mdgriffith$elm_ui$Internal$Model$asEl) ? $mdgriffith$elm_ui$Internal$Model$textElementFill(str) : $mdgriffith$elm_ui$Internal$Model$textElement(str)),
								htmls),
							existingStyles);
					default:
						return _Utils_Tuple2(htmls, existingStyles);
				}
			});
		var gather = F2(
			function (child, _v6) {
				var htmls = _v6.a;
				var existingStyles = _v6.b;
				switch (child.$) {
					case 'Unstyled':
						var html = child.a;
						return _Utils_eq(context, $mdgriffith$elm_ui$Internal$Model$asParagraph) ? _Utils_Tuple2(
							A2(
								$elm$core$List$cons,
								html(context),
								htmls),
							existingStyles) : _Utils_Tuple2(
							A2(
								$elm$core$List$cons,
								html(context),
								htmls),
							existingStyles);
					case 'Styled':
						var styled = child.a;
						return _Utils_eq(context, $mdgriffith$elm_ui$Internal$Model$asParagraph) ? _Utils_Tuple2(
							A2(
								$elm$core$List$cons,
								A2(styled.html, $mdgriffith$elm_ui$Internal$Model$NoStyleSheet, context),
								htmls),
							$elm$core$List$isEmpty(existingStyles) ? styled.styles : _Utils_ap(styled.styles, existingStyles)) : _Utils_Tuple2(
							A2(
								$elm$core$List$cons,
								A2(styled.html, $mdgriffith$elm_ui$Internal$Model$NoStyleSheet, context),
								htmls),
							$elm$core$List$isEmpty(existingStyles) ? styled.styles : _Utils_ap(styled.styles, existingStyles));
					case 'Text':
						var str = child.a;
						return _Utils_Tuple2(
							A2(
								$elm$core$List$cons,
								_Utils_eq(context, $mdgriffith$elm_ui$Internal$Model$asEl) ? $mdgriffith$elm_ui$Internal$Model$textElementFill(str) : $mdgriffith$elm_ui$Internal$Model$textElement(str),
								htmls),
							existingStyles);
					default:
						return _Utils_Tuple2(htmls, existingStyles);
				}
			});
		if (children.$ === 'Keyed') {
			var keyedChildren = children.a;
			var _v1 = A3(
				$elm$core$List$foldr,
				gatherKeyed,
				_Utils_Tuple2(_List_Nil, _List_Nil),
				keyedChildren);
			var keyed = _v1.a;
			var styles = _v1.b;
			var newStyles = $elm$core$List$isEmpty(styles) ? rendered.styles : _Utils_ap(rendered.styles, styles);
			if (!newStyles.b) {
				return $mdgriffith$elm_ui$Internal$Model$Unstyled(
					A5(
						$mdgriffith$elm_ui$Internal$Model$finalizeNode,
						rendered.has,
						rendered.node,
						rendered.attributes,
						$mdgriffith$elm_ui$Internal$Model$Keyed(
							A3($mdgriffith$elm_ui$Internal$Model$addKeyedChildren, 'nearby-element-pls', keyed, rendered.children)),
						$mdgriffith$elm_ui$Internal$Model$NoStyleSheet));
			} else {
				var allStyles = newStyles;
				return $mdgriffith$elm_ui$Internal$Model$Styled(
					{
						html: A4(
							$mdgriffith$elm_ui$Internal$Model$finalizeNode,
							rendered.has,
							rendered.node,
							rendered.attributes,
							$mdgriffith$elm_ui$Internal$Model$Keyed(
								A3($mdgriffith$elm_ui$Internal$Model$addKeyedChildren, 'nearby-element-pls', keyed, rendered.children))),
						styles: allStyles
					});
			}
		} else {
			var unkeyedChildren = children.a;
			var _v3 = A3(
				$elm$core$List$foldr,
				gather,
				_Utils_Tuple2(_List_Nil, _List_Nil),
				unkeyedChildren);
			var unkeyed = _v3.a;
			var styles = _v3.b;
			var newStyles = $elm$core$List$isEmpty(styles) ? rendered.styles : _Utils_ap(rendered.styles, styles);
			if (!newStyles.b) {
				return $mdgriffith$elm_ui$Internal$Model$Unstyled(
					A5(
						$mdgriffith$elm_ui$Internal$Model$finalizeNode,
						rendered.has,
						rendered.node,
						rendered.attributes,
						$mdgriffith$elm_ui$Internal$Model$Unkeyed(
							A2($mdgriffith$elm_ui$Internal$Model$addChildren, unkeyed, rendered.children)),
						$mdgriffith$elm_ui$Internal$Model$NoStyleSheet));
			} else {
				var allStyles = newStyles;
				return $mdgriffith$elm_ui$Internal$Model$Styled(
					{
						html: A4(
							$mdgriffith$elm_ui$Internal$Model$finalizeNode,
							rendered.has,
							rendered.node,
							rendered.attributes,
							$mdgriffith$elm_ui$Internal$Model$Unkeyed(
								A2($mdgriffith$elm_ui$Internal$Model$addChildren, unkeyed, rendered.children))),
						styles: allStyles
					});
			}
		}
	});
var $mdgriffith$elm_ui$Internal$Model$Single = F3(
	function (a, b, c) {
		return {$: 'Single', a: a, b: b, c: c};
	});
var $mdgriffith$elm_ui$Internal$Model$Transform = function (a) {
	return {$: 'Transform', a: a};
};
var $mdgriffith$elm_ui$Internal$Flag$Field = F2(
	function (a, b) {
		return {$: 'Field', a: a, b: b};
	});
var $elm$core$Bitwise$or = _Bitwise_or;
var $mdgriffith$elm_ui$Internal$Flag$add = F2(
	function (myFlag, _v0) {
		var one = _v0.a;
		var two = _v0.b;
		if (myFlag.$ === 'Flag') {
			var first = myFlag.a;
			return A2($mdgriffith$elm_ui$Internal$Flag$Field, first | one, two);
		} else {
			var second = myFlag.a;
			return A2($mdgriffith$elm_ui$Internal$Flag$Field, one, second | two);
		}
	});
var $mdgriffith$elm_ui$Internal$Model$ChildrenBehind = function (a) {
	return {$: 'ChildrenBehind', a: a};
};
var $mdgriffith$elm_ui$Internal$Model$ChildrenBehindAndInFront = F2(
	function (a, b) {
		return {$: 'ChildrenBehindAndInFront', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Model$ChildrenInFront = function (a) {
	return {$: 'ChildrenInFront', a: a};
};
var $mdgriffith$elm_ui$Internal$Model$nearbyElement = F2(
	function (location, elem) {
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class(
					function () {
						switch (location.$) {
							case 'Above':
								return A2(
									$elm$core$String$join,
									' ',
									_List_fromArray(
										[$mdgriffith$elm_ui$Internal$Style$classes.nearby, $mdgriffith$elm_ui$Internal$Style$classes.single, $mdgriffith$elm_ui$Internal$Style$classes.above]));
							case 'Below':
								return A2(
									$elm$core$String$join,
									' ',
									_List_fromArray(
										[$mdgriffith$elm_ui$Internal$Style$classes.nearby, $mdgriffith$elm_ui$Internal$Style$classes.single, $mdgriffith$elm_ui$Internal$Style$classes.below]));
							case 'OnRight':
								return A2(
									$elm$core$String$join,
									' ',
									_List_fromArray(
										[$mdgriffith$elm_ui$Internal$Style$classes.nearby, $mdgriffith$elm_ui$Internal$Style$classes.single, $mdgriffith$elm_ui$Internal$Style$classes.onRight]));
							case 'OnLeft':
								return A2(
									$elm$core$String$join,
									' ',
									_List_fromArray(
										[$mdgriffith$elm_ui$Internal$Style$classes.nearby, $mdgriffith$elm_ui$Internal$Style$classes.single, $mdgriffith$elm_ui$Internal$Style$classes.onLeft]));
							case 'InFront':
								return A2(
									$elm$core$String$join,
									' ',
									_List_fromArray(
										[$mdgriffith$elm_ui$Internal$Style$classes.nearby, $mdgriffith$elm_ui$Internal$Style$classes.single, $mdgriffith$elm_ui$Internal$Style$classes.inFront]));
							default:
								return A2(
									$elm$core$String$join,
									' ',
									_List_fromArray(
										[$mdgriffith$elm_ui$Internal$Style$classes.nearby, $mdgriffith$elm_ui$Internal$Style$classes.single, $mdgriffith$elm_ui$Internal$Style$classes.behind]));
						}
					}())
				]),
			_List_fromArray(
				[
					function () {
					switch (elem.$) {
						case 'Empty':
							return $elm$virtual_dom$VirtualDom$text('');
						case 'Text':
							var str = elem.a;
							return $mdgriffith$elm_ui$Internal$Model$textElement(str);
						case 'Unstyled':
							var html = elem.a;
							return html($mdgriffith$elm_ui$Internal$Model$asEl);
						default:
							var styled = elem.a;
							return A2(styled.html, $mdgriffith$elm_ui$Internal$Model$NoStyleSheet, $mdgriffith$elm_ui$Internal$Model$asEl);
					}
				}()
				]));
	});
var $mdgriffith$elm_ui$Internal$Model$addNearbyElement = F3(
	function (location, elem, existing) {
		var nearby = A2($mdgriffith$elm_ui$Internal$Model$nearbyElement, location, elem);
		switch (existing.$) {
			case 'NoNearbyChildren':
				if (location.$ === 'Behind') {
					return $mdgriffith$elm_ui$Internal$Model$ChildrenBehind(
						_List_fromArray(
							[nearby]));
				} else {
					return $mdgriffith$elm_ui$Internal$Model$ChildrenInFront(
						_List_fromArray(
							[nearby]));
				}
			case 'ChildrenBehind':
				var existingBehind = existing.a;
				if (location.$ === 'Behind') {
					return $mdgriffith$elm_ui$Internal$Model$ChildrenBehind(
						A2($elm$core$List$cons, nearby, existingBehind));
				} else {
					return A2(
						$mdgriffith$elm_ui$Internal$Model$ChildrenBehindAndInFront,
						existingBehind,
						_List_fromArray(
							[nearby]));
				}
			case 'ChildrenInFront':
				var existingInFront = existing.a;
				if (location.$ === 'Behind') {
					return A2(
						$mdgriffith$elm_ui$Internal$Model$ChildrenBehindAndInFront,
						_List_fromArray(
							[nearby]),
						existingInFront);
				} else {
					return $mdgriffith$elm_ui$Internal$Model$ChildrenInFront(
						A2($elm$core$List$cons, nearby, existingInFront));
				}
			default:
				var existingBehind = existing.a;
				var existingInFront = existing.b;
				if (location.$ === 'Behind') {
					return A2(
						$mdgriffith$elm_ui$Internal$Model$ChildrenBehindAndInFront,
						A2($elm$core$List$cons, nearby, existingBehind),
						existingInFront);
				} else {
					return A2(
						$mdgriffith$elm_ui$Internal$Model$ChildrenBehindAndInFront,
						existingBehind,
						A2($elm$core$List$cons, nearby, existingInFront));
				}
		}
	});
var $mdgriffith$elm_ui$Internal$Model$Embedded = F2(
	function (a, b) {
		return {$: 'Embedded', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Model$NodeName = function (a) {
	return {$: 'NodeName', a: a};
};
var $mdgriffith$elm_ui$Internal$Model$addNodeName = F2(
	function (newNode, old) {
		switch (old.$) {
			case 'Generic':
				return $mdgriffith$elm_ui$Internal$Model$NodeName(newNode);
			case 'NodeName':
				var name = old.a;
				return A2($mdgriffith$elm_ui$Internal$Model$Embedded, name, newNode);
			default:
				var x = old.a;
				var y = old.b;
				return A2($mdgriffith$elm_ui$Internal$Model$Embedded, x, y);
		}
	});
var $mdgriffith$elm_ui$Internal$Model$alignXName = function (align) {
	switch (align.$) {
		case 'Left':
			return $mdgriffith$elm_ui$Internal$Style$classes.alignedHorizontally + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.alignLeft);
		case 'Right':
			return $mdgriffith$elm_ui$Internal$Style$classes.alignedHorizontally + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.alignRight);
		default:
			return $mdgriffith$elm_ui$Internal$Style$classes.alignedHorizontally + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.alignCenterX);
	}
};
var $mdgriffith$elm_ui$Internal$Model$alignYName = function (align) {
	switch (align.$) {
		case 'Top':
			return $mdgriffith$elm_ui$Internal$Style$classes.alignedVertically + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.alignTop);
		case 'Bottom':
			return $mdgriffith$elm_ui$Internal$Style$classes.alignedVertically + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.alignBottom);
		default:
			return $mdgriffith$elm_ui$Internal$Style$classes.alignedVertically + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.alignCenterY);
	}
};
var $elm$virtual_dom$VirtualDom$attribute = F2(
	function (key, value) {
		return A2(
			_VirtualDom_attribute,
			_VirtualDom_noOnOrFormAction(key),
			_VirtualDom_noJavaScriptOrHtmlUri(value));
	});
var $mdgriffith$elm_ui$Internal$Model$FullTransform = F4(
	function (a, b, c, d) {
		return {$: 'FullTransform', a: a, b: b, c: c, d: d};
	});
var $mdgriffith$elm_ui$Internal$Model$Moved = function (a) {
	return {$: 'Moved', a: a};
};
var $mdgriffith$elm_ui$Internal$Model$composeTransformation = F2(
	function (transform, component) {
		switch (transform.$) {
			case 'Untransformed':
				switch (component.$) {
					case 'MoveX':
						var x = component.a;
						return $mdgriffith$elm_ui$Internal$Model$Moved(
							_Utils_Tuple3(x, 0, 0));
					case 'MoveY':
						var y = component.a;
						return $mdgriffith$elm_ui$Internal$Model$Moved(
							_Utils_Tuple3(0, y, 0));
					case 'MoveZ':
						var z = component.a;
						return $mdgriffith$elm_ui$Internal$Model$Moved(
							_Utils_Tuple3(0, 0, z));
					case 'MoveXYZ':
						var xyz = component.a;
						return $mdgriffith$elm_ui$Internal$Model$Moved(xyz);
					case 'Rotate':
						var xyz = component.a;
						var angle = component.b;
						return A4(
							$mdgriffith$elm_ui$Internal$Model$FullTransform,
							_Utils_Tuple3(0, 0, 0),
							_Utils_Tuple3(1, 1, 1),
							xyz,
							angle);
					default:
						var xyz = component.a;
						return A4(
							$mdgriffith$elm_ui$Internal$Model$FullTransform,
							_Utils_Tuple3(0, 0, 0),
							xyz,
							_Utils_Tuple3(0, 0, 1),
							0);
				}
			case 'Moved':
				var moved = transform.a;
				var x = moved.a;
				var y = moved.b;
				var z = moved.c;
				switch (component.$) {
					case 'MoveX':
						var newX = component.a;
						return $mdgriffith$elm_ui$Internal$Model$Moved(
							_Utils_Tuple3(newX, y, z));
					case 'MoveY':
						var newY = component.a;
						return $mdgriffith$elm_ui$Internal$Model$Moved(
							_Utils_Tuple3(x, newY, z));
					case 'MoveZ':
						var newZ = component.a;
						return $mdgriffith$elm_ui$Internal$Model$Moved(
							_Utils_Tuple3(x, y, newZ));
					case 'MoveXYZ':
						var xyz = component.a;
						return $mdgriffith$elm_ui$Internal$Model$Moved(xyz);
					case 'Rotate':
						var xyz = component.a;
						var angle = component.b;
						return A4(
							$mdgriffith$elm_ui$Internal$Model$FullTransform,
							moved,
							_Utils_Tuple3(1, 1, 1),
							xyz,
							angle);
					default:
						var scale = component.a;
						return A4(
							$mdgriffith$elm_ui$Internal$Model$FullTransform,
							moved,
							scale,
							_Utils_Tuple3(0, 0, 1),
							0);
				}
			default:
				var moved = transform.a;
				var x = moved.a;
				var y = moved.b;
				var z = moved.c;
				var scaled = transform.b;
				var origin = transform.c;
				var angle = transform.d;
				switch (component.$) {
					case 'MoveX':
						var newX = component.a;
						return A4(
							$mdgriffith$elm_ui$Internal$Model$FullTransform,
							_Utils_Tuple3(newX, y, z),
							scaled,
							origin,
							angle);
					case 'MoveY':
						var newY = component.a;
						return A4(
							$mdgriffith$elm_ui$Internal$Model$FullTransform,
							_Utils_Tuple3(x, newY, z),
							scaled,
							origin,
							angle);
					case 'MoveZ':
						var newZ = component.a;
						return A4(
							$mdgriffith$elm_ui$Internal$Model$FullTransform,
							_Utils_Tuple3(x, y, newZ),
							scaled,
							origin,
							angle);
					case 'MoveXYZ':
						var newMove = component.a;
						return A4($mdgriffith$elm_ui$Internal$Model$FullTransform, newMove, scaled, origin, angle);
					case 'Rotate':
						var newOrigin = component.a;
						var newAngle = component.b;
						return A4($mdgriffith$elm_ui$Internal$Model$FullTransform, moved, scaled, newOrigin, newAngle);
					default:
						var newScale = component.a;
						return A4($mdgriffith$elm_ui$Internal$Model$FullTransform, moved, newScale, origin, angle);
				}
		}
	});
var $mdgriffith$elm_ui$Internal$Flag$height = $mdgriffith$elm_ui$Internal$Flag$flag(7);
var $mdgriffith$elm_ui$Internal$Flag$heightContent = $mdgriffith$elm_ui$Internal$Flag$flag(36);
var $mdgriffith$elm_ui$Internal$Flag$merge = F2(
	function (_v0, _v1) {
		var one = _v0.a;
		var two = _v0.b;
		var three = _v1.a;
		var four = _v1.b;
		return A2($mdgriffith$elm_ui$Internal$Flag$Field, one | three, two | four);
	});
var $mdgriffith$elm_ui$Internal$Flag$none = A2($mdgriffith$elm_ui$Internal$Flag$Field, 0, 0);
var $mdgriffith$elm_ui$Internal$Model$renderHeight = function (h) {
	switch (h.$) {
		case 'Px':
			var px = h.a;
			var val = $elm$core$String$fromInt(px);
			var name = 'height-px-' + val;
			return _Utils_Tuple3(
				$mdgriffith$elm_ui$Internal$Flag$none,
				$mdgriffith$elm_ui$Internal$Style$classes.heightExact + (' ' + name),
				_List_fromArray(
					[
						A3($mdgriffith$elm_ui$Internal$Model$Single, name, 'height', val + 'px')
					]));
		case 'Content':
			return _Utils_Tuple3(
				A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$heightContent, $mdgriffith$elm_ui$Internal$Flag$none),
				$mdgriffith$elm_ui$Internal$Style$classes.heightContent,
				_List_Nil);
		case 'Fill':
			var portion = h.a;
			return (portion === 1) ? _Utils_Tuple3(
				A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$heightFill, $mdgriffith$elm_ui$Internal$Flag$none),
				$mdgriffith$elm_ui$Internal$Style$classes.heightFill,
				_List_Nil) : _Utils_Tuple3(
				A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$heightFill, $mdgriffith$elm_ui$Internal$Flag$none),
				$mdgriffith$elm_ui$Internal$Style$classes.heightFillPortion + (' height-fill-' + $elm$core$String$fromInt(portion)),
				_List_fromArray(
					[
						A3(
						$mdgriffith$elm_ui$Internal$Model$Single,
						$mdgriffith$elm_ui$Internal$Style$classes.any + ('.' + ($mdgriffith$elm_ui$Internal$Style$classes.column + (' > ' + $mdgriffith$elm_ui$Internal$Style$dot(
							'height-fill-' + $elm$core$String$fromInt(portion))))),
						'flex-grow',
						$elm$core$String$fromInt(portion * 100000))
					]));
		case 'Min':
			var minSize = h.a;
			var len = h.b;
			var cls = 'min-height-' + $elm$core$String$fromInt(minSize);
			var style = A3(
				$mdgriffith$elm_ui$Internal$Model$Single,
				cls,
				'min-height',
				$elm$core$String$fromInt(minSize) + 'px !important');
			var _v1 = $mdgriffith$elm_ui$Internal$Model$renderHeight(len);
			var newFlag = _v1.a;
			var newAttrs = _v1.b;
			var newStyle = _v1.c;
			return _Utils_Tuple3(
				A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$heightBetween, newFlag),
				cls + (' ' + newAttrs),
				A2($elm$core$List$cons, style, newStyle));
		default:
			var maxSize = h.a;
			var len = h.b;
			var cls = 'max-height-' + $elm$core$String$fromInt(maxSize);
			var style = A3(
				$mdgriffith$elm_ui$Internal$Model$Single,
				cls,
				'max-height',
				$elm$core$String$fromInt(maxSize) + 'px');
			var _v2 = $mdgriffith$elm_ui$Internal$Model$renderHeight(len);
			var newFlag = _v2.a;
			var newAttrs = _v2.b;
			var newStyle = _v2.c;
			return _Utils_Tuple3(
				A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$heightBetween, newFlag),
				cls + (' ' + newAttrs),
				A2($elm$core$List$cons, style, newStyle));
	}
};
var $mdgriffith$elm_ui$Internal$Flag$widthContent = $mdgriffith$elm_ui$Internal$Flag$flag(38);
var $mdgriffith$elm_ui$Internal$Model$renderWidth = function (w) {
	switch (w.$) {
		case 'Px':
			var px = w.a;
			return _Utils_Tuple3(
				$mdgriffith$elm_ui$Internal$Flag$none,
				$mdgriffith$elm_ui$Internal$Style$classes.widthExact + (' width-px-' + $elm$core$String$fromInt(px)),
				_List_fromArray(
					[
						A3(
						$mdgriffith$elm_ui$Internal$Model$Single,
						'width-px-' + $elm$core$String$fromInt(px),
						'width',
						$elm$core$String$fromInt(px) + 'px')
					]));
		case 'Content':
			return _Utils_Tuple3(
				A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$widthContent, $mdgriffith$elm_ui$Internal$Flag$none),
				$mdgriffith$elm_ui$Internal$Style$classes.widthContent,
				_List_Nil);
		case 'Fill':
			var portion = w.a;
			return (portion === 1) ? _Utils_Tuple3(
				A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$widthFill, $mdgriffith$elm_ui$Internal$Flag$none),
				$mdgriffith$elm_ui$Internal$Style$classes.widthFill,
				_List_Nil) : _Utils_Tuple3(
				A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$widthFill, $mdgriffith$elm_ui$Internal$Flag$none),
				$mdgriffith$elm_ui$Internal$Style$classes.widthFillPortion + (' width-fill-' + $elm$core$String$fromInt(portion)),
				_List_fromArray(
					[
						A3(
						$mdgriffith$elm_ui$Internal$Model$Single,
						$mdgriffith$elm_ui$Internal$Style$classes.any + ('.' + ($mdgriffith$elm_ui$Internal$Style$classes.row + (' > ' + $mdgriffith$elm_ui$Internal$Style$dot(
							'width-fill-' + $elm$core$String$fromInt(portion))))),
						'flex-grow',
						$elm$core$String$fromInt(portion * 100000))
					]));
		case 'Min':
			var minSize = w.a;
			var len = w.b;
			var cls = 'min-width-' + $elm$core$String$fromInt(minSize);
			var style = A3(
				$mdgriffith$elm_ui$Internal$Model$Single,
				cls,
				'min-width',
				$elm$core$String$fromInt(minSize) + 'px');
			var _v1 = $mdgriffith$elm_ui$Internal$Model$renderWidth(len);
			var newFlag = _v1.a;
			var newAttrs = _v1.b;
			var newStyle = _v1.c;
			return _Utils_Tuple3(
				A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$widthBetween, newFlag),
				cls + (' ' + newAttrs),
				A2($elm$core$List$cons, style, newStyle));
		default:
			var maxSize = w.a;
			var len = w.b;
			var cls = 'max-width-' + $elm$core$String$fromInt(maxSize);
			var style = A3(
				$mdgriffith$elm_ui$Internal$Model$Single,
				cls,
				'max-width',
				$elm$core$String$fromInt(maxSize) + 'px');
			var _v2 = $mdgriffith$elm_ui$Internal$Model$renderWidth(len);
			var newFlag = _v2.a;
			var newAttrs = _v2.b;
			var newStyle = _v2.c;
			return _Utils_Tuple3(
				A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$widthBetween, newFlag),
				cls + (' ' + newAttrs),
				A2($elm$core$List$cons, style, newStyle));
	}
};
var $mdgriffith$elm_ui$Internal$Flag$borderWidth = $mdgriffith$elm_ui$Internal$Flag$flag(27);
var $elm$core$Basics$ge = _Utils_ge;
var $mdgriffith$elm_ui$Internal$Model$skippable = F2(
	function (flag, style) {
		if (_Utils_eq(flag, $mdgriffith$elm_ui$Internal$Flag$borderWidth)) {
			if (style.$ === 'Single') {
				var val = style.c;
				switch (val) {
					case '0px':
						return true;
					case '1px':
						return true;
					case '2px':
						return true;
					case '3px':
						return true;
					case '4px':
						return true;
					case '5px':
						return true;
					case '6px':
						return true;
					default:
						return false;
				}
			} else {
				return false;
			}
		} else {
			switch (style.$) {
				case 'FontSize':
					var i = style.a;
					return (i >= 8) && (i <= 32);
				case 'PaddingStyle':
					var name = style.a;
					var t = style.b;
					var r = style.c;
					var b = style.d;
					var l = style.e;
					return _Utils_eq(t, b) && (_Utils_eq(t, r) && (_Utils_eq(t, l) && ((t >= 0) && (t <= 24))));
				default:
					return false;
			}
		}
	});
var $mdgriffith$elm_ui$Internal$Flag$width = $mdgriffith$elm_ui$Internal$Flag$flag(6);
var $mdgriffith$elm_ui$Internal$Flag$xAlign = $mdgriffith$elm_ui$Internal$Flag$flag(30);
var $mdgriffith$elm_ui$Internal$Flag$yAlign = $mdgriffith$elm_ui$Internal$Flag$flag(29);
var $mdgriffith$elm_ui$Internal$Model$gatherAttrRecursive = F8(
	function (classes, node, has, transform, styles, attrs, children, elementAttrs) {
		gatherAttrRecursive:
		while (true) {
			if (!elementAttrs.b) {
				var _v1 = $mdgriffith$elm_ui$Internal$Model$transformClass(transform);
				if (_v1.$ === 'Nothing') {
					return {
						attributes: A2(
							$elm$core$List$cons,
							$elm$html$Html$Attributes$class(classes),
							attrs),
						children: children,
						has: has,
						node: node,
						styles: styles
					};
				} else {
					var _class = _v1.a;
					return {
						attributes: A2(
							$elm$core$List$cons,
							$elm$html$Html$Attributes$class(classes + (' ' + _class)),
							attrs),
						children: children,
						has: has,
						node: node,
						styles: A2(
							$elm$core$List$cons,
							$mdgriffith$elm_ui$Internal$Model$Transform(transform),
							styles)
					};
				}
			} else {
				var attribute = elementAttrs.a;
				var remaining = elementAttrs.b;
				switch (attribute.$) {
					case 'NoAttribute':
						var $temp$classes = classes,
							$temp$node = node,
							$temp$has = has,
							$temp$transform = transform,
							$temp$styles = styles,
							$temp$attrs = attrs,
							$temp$children = children,
							$temp$elementAttrs = remaining;
						classes = $temp$classes;
						node = $temp$node;
						has = $temp$has;
						transform = $temp$transform;
						styles = $temp$styles;
						attrs = $temp$attrs;
						children = $temp$children;
						elementAttrs = $temp$elementAttrs;
						continue gatherAttrRecursive;
					case 'Class':
						var flag = attribute.a;
						var exactClassName = attribute.b;
						if (A2($mdgriffith$elm_ui$Internal$Flag$present, flag, has)) {
							var $temp$classes = classes,
								$temp$node = node,
								$temp$has = has,
								$temp$transform = transform,
								$temp$styles = styles,
								$temp$attrs = attrs,
								$temp$children = children,
								$temp$elementAttrs = remaining;
							classes = $temp$classes;
							node = $temp$node;
							has = $temp$has;
							transform = $temp$transform;
							styles = $temp$styles;
							attrs = $temp$attrs;
							children = $temp$children;
							elementAttrs = $temp$elementAttrs;
							continue gatherAttrRecursive;
						} else {
							var $temp$classes = exactClassName + (' ' + classes),
								$temp$node = node,
								$temp$has = A2($mdgriffith$elm_ui$Internal$Flag$add, flag, has),
								$temp$transform = transform,
								$temp$styles = styles,
								$temp$attrs = attrs,
								$temp$children = children,
								$temp$elementAttrs = remaining;
							classes = $temp$classes;
							node = $temp$node;
							has = $temp$has;
							transform = $temp$transform;
							styles = $temp$styles;
							attrs = $temp$attrs;
							children = $temp$children;
							elementAttrs = $temp$elementAttrs;
							continue gatherAttrRecursive;
						}
					case 'Attr':
						var actualAttribute = attribute.a;
						var $temp$classes = classes,
							$temp$node = node,
							$temp$has = has,
							$temp$transform = transform,
							$temp$styles = styles,
							$temp$attrs = A2($elm$core$List$cons, actualAttribute, attrs),
							$temp$children = children,
							$temp$elementAttrs = remaining;
						classes = $temp$classes;
						node = $temp$node;
						has = $temp$has;
						transform = $temp$transform;
						styles = $temp$styles;
						attrs = $temp$attrs;
						children = $temp$children;
						elementAttrs = $temp$elementAttrs;
						continue gatherAttrRecursive;
					case 'StyleClass':
						var flag = attribute.a;
						var style = attribute.b;
						if (A2($mdgriffith$elm_ui$Internal$Flag$present, flag, has)) {
							var $temp$classes = classes,
								$temp$node = node,
								$temp$has = has,
								$temp$transform = transform,
								$temp$styles = styles,
								$temp$attrs = attrs,
								$temp$children = children,
								$temp$elementAttrs = remaining;
							classes = $temp$classes;
							node = $temp$node;
							has = $temp$has;
							transform = $temp$transform;
							styles = $temp$styles;
							attrs = $temp$attrs;
							children = $temp$children;
							elementAttrs = $temp$elementAttrs;
							continue gatherAttrRecursive;
						} else {
							if (A2($mdgriffith$elm_ui$Internal$Model$skippable, flag, style)) {
								var $temp$classes = $mdgriffith$elm_ui$Internal$Model$getStyleName(style) + (' ' + classes),
									$temp$node = node,
									$temp$has = A2($mdgriffith$elm_ui$Internal$Flag$add, flag, has),
									$temp$transform = transform,
									$temp$styles = styles,
									$temp$attrs = attrs,
									$temp$children = children,
									$temp$elementAttrs = remaining;
								classes = $temp$classes;
								node = $temp$node;
								has = $temp$has;
								transform = $temp$transform;
								styles = $temp$styles;
								attrs = $temp$attrs;
								children = $temp$children;
								elementAttrs = $temp$elementAttrs;
								continue gatherAttrRecursive;
							} else {
								var $temp$classes = $mdgriffith$elm_ui$Internal$Model$getStyleName(style) + (' ' + classes),
									$temp$node = node,
									$temp$has = A2($mdgriffith$elm_ui$Internal$Flag$add, flag, has),
									$temp$transform = transform,
									$temp$styles = A2($elm$core$List$cons, style, styles),
									$temp$attrs = attrs,
									$temp$children = children,
									$temp$elementAttrs = remaining;
								classes = $temp$classes;
								node = $temp$node;
								has = $temp$has;
								transform = $temp$transform;
								styles = $temp$styles;
								attrs = $temp$attrs;
								children = $temp$children;
								elementAttrs = $temp$elementAttrs;
								continue gatherAttrRecursive;
							}
						}
					case 'TransformComponent':
						var flag = attribute.a;
						var component = attribute.b;
						var $temp$classes = classes,
							$temp$node = node,
							$temp$has = A2($mdgriffith$elm_ui$Internal$Flag$add, flag, has),
							$temp$transform = A2($mdgriffith$elm_ui$Internal$Model$composeTransformation, transform, component),
							$temp$styles = styles,
							$temp$attrs = attrs,
							$temp$children = children,
							$temp$elementAttrs = remaining;
						classes = $temp$classes;
						node = $temp$node;
						has = $temp$has;
						transform = $temp$transform;
						styles = $temp$styles;
						attrs = $temp$attrs;
						children = $temp$children;
						elementAttrs = $temp$elementAttrs;
						continue gatherAttrRecursive;
					case 'Width':
						var width = attribute.a;
						if (A2($mdgriffith$elm_ui$Internal$Flag$present, $mdgriffith$elm_ui$Internal$Flag$width, has)) {
							var $temp$classes = classes,
								$temp$node = node,
								$temp$has = has,
								$temp$transform = transform,
								$temp$styles = styles,
								$temp$attrs = attrs,
								$temp$children = children,
								$temp$elementAttrs = remaining;
							classes = $temp$classes;
							node = $temp$node;
							has = $temp$has;
							transform = $temp$transform;
							styles = $temp$styles;
							attrs = $temp$attrs;
							children = $temp$children;
							elementAttrs = $temp$elementAttrs;
							continue gatherAttrRecursive;
						} else {
							switch (width.$) {
								case 'Px':
									var px = width.a;
									var $temp$classes = ($mdgriffith$elm_ui$Internal$Style$classes.widthExact + (' width-px-' + $elm$core$String$fromInt(px))) + (' ' + classes),
										$temp$node = node,
										$temp$has = A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$width, has),
										$temp$transform = transform,
										$temp$styles = A2(
										$elm$core$List$cons,
										A3(
											$mdgriffith$elm_ui$Internal$Model$Single,
											'width-px-' + $elm$core$String$fromInt(px),
											'width',
											$elm$core$String$fromInt(px) + 'px'),
										styles),
										$temp$attrs = attrs,
										$temp$children = children,
										$temp$elementAttrs = remaining;
									classes = $temp$classes;
									node = $temp$node;
									has = $temp$has;
									transform = $temp$transform;
									styles = $temp$styles;
									attrs = $temp$attrs;
									children = $temp$children;
									elementAttrs = $temp$elementAttrs;
									continue gatherAttrRecursive;
								case 'Content':
									var $temp$classes = classes + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.widthContent),
										$temp$node = node,
										$temp$has = A2(
										$mdgriffith$elm_ui$Internal$Flag$add,
										$mdgriffith$elm_ui$Internal$Flag$widthContent,
										A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$width, has)),
										$temp$transform = transform,
										$temp$styles = styles,
										$temp$attrs = attrs,
										$temp$children = children,
										$temp$elementAttrs = remaining;
									classes = $temp$classes;
									node = $temp$node;
									has = $temp$has;
									transform = $temp$transform;
									styles = $temp$styles;
									attrs = $temp$attrs;
									children = $temp$children;
									elementAttrs = $temp$elementAttrs;
									continue gatherAttrRecursive;
								case 'Fill':
									var portion = width.a;
									if (portion === 1) {
										var $temp$classes = classes + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.widthFill),
											$temp$node = node,
											$temp$has = A2(
											$mdgriffith$elm_ui$Internal$Flag$add,
											$mdgriffith$elm_ui$Internal$Flag$widthFill,
											A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$width, has)),
											$temp$transform = transform,
											$temp$styles = styles,
											$temp$attrs = attrs,
											$temp$children = children,
											$temp$elementAttrs = remaining;
										classes = $temp$classes;
										node = $temp$node;
										has = $temp$has;
										transform = $temp$transform;
										styles = $temp$styles;
										attrs = $temp$attrs;
										children = $temp$children;
										elementAttrs = $temp$elementAttrs;
										continue gatherAttrRecursive;
									} else {
										var $temp$classes = classes + (' ' + ($mdgriffith$elm_ui$Internal$Style$classes.widthFillPortion + (' width-fill-' + $elm$core$String$fromInt(portion)))),
											$temp$node = node,
											$temp$has = A2(
											$mdgriffith$elm_ui$Internal$Flag$add,
											$mdgriffith$elm_ui$Internal$Flag$widthFill,
											A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$width, has)),
											$temp$transform = transform,
											$temp$styles = A2(
											$elm$core$List$cons,
											A3(
												$mdgriffith$elm_ui$Internal$Model$Single,
												$mdgriffith$elm_ui$Internal$Style$classes.any + ('.' + ($mdgriffith$elm_ui$Internal$Style$classes.row + (' > ' + $mdgriffith$elm_ui$Internal$Style$dot(
													'width-fill-' + $elm$core$String$fromInt(portion))))),
												'flex-grow',
												$elm$core$String$fromInt(portion * 100000)),
											styles),
											$temp$attrs = attrs,
											$temp$children = children,
											$temp$elementAttrs = remaining;
										classes = $temp$classes;
										node = $temp$node;
										has = $temp$has;
										transform = $temp$transform;
										styles = $temp$styles;
										attrs = $temp$attrs;
										children = $temp$children;
										elementAttrs = $temp$elementAttrs;
										continue gatherAttrRecursive;
									}
								default:
									var _v4 = $mdgriffith$elm_ui$Internal$Model$renderWidth(width);
									var addToFlags = _v4.a;
									var newClass = _v4.b;
									var newStyles = _v4.c;
									var $temp$classes = classes + (' ' + newClass),
										$temp$node = node,
										$temp$has = A2(
										$mdgriffith$elm_ui$Internal$Flag$merge,
										addToFlags,
										A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$width, has)),
										$temp$transform = transform,
										$temp$styles = _Utils_ap(newStyles, styles),
										$temp$attrs = attrs,
										$temp$children = children,
										$temp$elementAttrs = remaining;
									classes = $temp$classes;
									node = $temp$node;
									has = $temp$has;
									transform = $temp$transform;
									styles = $temp$styles;
									attrs = $temp$attrs;
									children = $temp$children;
									elementAttrs = $temp$elementAttrs;
									continue gatherAttrRecursive;
							}
						}
					case 'Height':
						var height = attribute.a;
						if (A2($mdgriffith$elm_ui$Internal$Flag$present, $mdgriffith$elm_ui$Internal$Flag$height, has)) {
							var $temp$classes = classes,
								$temp$node = node,
								$temp$has = has,
								$temp$transform = transform,
								$temp$styles = styles,
								$temp$attrs = attrs,
								$temp$children = children,
								$temp$elementAttrs = remaining;
							classes = $temp$classes;
							node = $temp$node;
							has = $temp$has;
							transform = $temp$transform;
							styles = $temp$styles;
							attrs = $temp$attrs;
							children = $temp$children;
							elementAttrs = $temp$elementAttrs;
							continue gatherAttrRecursive;
						} else {
							switch (height.$) {
								case 'Px':
									var px = height.a;
									var val = $elm$core$String$fromInt(px) + 'px';
									var name = 'height-px-' + val;
									var $temp$classes = $mdgriffith$elm_ui$Internal$Style$classes.heightExact + (' ' + (name + (' ' + classes))),
										$temp$node = node,
										$temp$has = A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$height, has),
										$temp$transform = transform,
										$temp$styles = A2(
										$elm$core$List$cons,
										A3($mdgriffith$elm_ui$Internal$Model$Single, name, 'height ', val),
										styles),
										$temp$attrs = attrs,
										$temp$children = children,
										$temp$elementAttrs = remaining;
									classes = $temp$classes;
									node = $temp$node;
									has = $temp$has;
									transform = $temp$transform;
									styles = $temp$styles;
									attrs = $temp$attrs;
									children = $temp$children;
									elementAttrs = $temp$elementAttrs;
									continue gatherAttrRecursive;
								case 'Content':
									var $temp$classes = $mdgriffith$elm_ui$Internal$Style$classes.heightContent + (' ' + classes),
										$temp$node = node,
										$temp$has = A2(
										$mdgriffith$elm_ui$Internal$Flag$add,
										$mdgriffith$elm_ui$Internal$Flag$heightContent,
										A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$height, has)),
										$temp$transform = transform,
										$temp$styles = styles,
										$temp$attrs = attrs,
										$temp$children = children,
										$temp$elementAttrs = remaining;
									classes = $temp$classes;
									node = $temp$node;
									has = $temp$has;
									transform = $temp$transform;
									styles = $temp$styles;
									attrs = $temp$attrs;
									children = $temp$children;
									elementAttrs = $temp$elementAttrs;
									continue gatherAttrRecursive;
								case 'Fill':
									var portion = height.a;
									if (portion === 1) {
										var $temp$classes = $mdgriffith$elm_ui$Internal$Style$classes.heightFill + (' ' + classes),
											$temp$node = node,
											$temp$has = A2(
											$mdgriffith$elm_ui$Internal$Flag$add,
											$mdgriffith$elm_ui$Internal$Flag$heightFill,
											A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$height, has)),
											$temp$transform = transform,
											$temp$styles = styles,
											$temp$attrs = attrs,
											$temp$children = children,
											$temp$elementAttrs = remaining;
										classes = $temp$classes;
										node = $temp$node;
										has = $temp$has;
										transform = $temp$transform;
										styles = $temp$styles;
										attrs = $temp$attrs;
										children = $temp$children;
										elementAttrs = $temp$elementAttrs;
										continue gatherAttrRecursive;
									} else {
										var $temp$classes = classes + (' ' + ($mdgriffith$elm_ui$Internal$Style$classes.heightFillPortion + (' height-fill-' + $elm$core$String$fromInt(portion)))),
											$temp$node = node,
											$temp$has = A2(
											$mdgriffith$elm_ui$Internal$Flag$add,
											$mdgriffith$elm_ui$Internal$Flag$heightFill,
											A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$height, has)),
											$temp$transform = transform,
											$temp$styles = A2(
											$elm$core$List$cons,
											A3(
												$mdgriffith$elm_ui$Internal$Model$Single,
												$mdgriffith$elm_ui$Internal$Style$classes.any + ('.' + ($mdgriffith$elm_ui$Internal$Style$classes.column + (' > ' + $mdgriffith$elm_ui$Internal$Style$dot(
													'height-fill-' + $elm$core$String$fromInt(portion))))),
												'flex-grow',
												$elm$core$String$fromInt(portion * 100000)),
											styles),
											$temp$attrs = attrs,
											$temp$children = children,
											$temp$elementAttrs = remaining;
										classes = $temp$classes;
										node = $temp$node;
										has = $temp$has;
										transform = $temp$transform;
										styles = $temp$styles;
										attrs = $temp$attrs;
										children = $temp$children;
										elementAttrs = $temp$elementAttrs;
										continue gatherAttrRecursive;
									}
								default:
									var _v6 = $mdgriffith$elm_ui$Internal$Model$renderHeight(height);
									var addToFlags = _v6.a;
									var newClass = _v6.b;
									var newStyles = _v6.c;
									var $temp$classes = classes + (' ' + newClass),
										$temp$node = node,
										$temp$has = A2(
										$mdgriffith$elm_ui$Internal$Flag$merge,
										addToFlags,
										A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$height, has)),
										$temp$transform = transform,
										$temp$styles = _Utils_ap(newStyles, styles),
										$temp$attrs = attrs,
										$temp$children = children,
										$temp$elementAttrs = remaining;
									classes = $temp$classes;
									node = $temp$node;
									has = $temp$has;
									transform = $temp$transform;
									styles = $temp$styles;
									attrs = $temp$attrs;
									children = $temp$children;
									elementAttrs = $temp$elementAttrs;
									continue gatherAttrRecursive;
							}
						}
					case 'Describe':
						var description = attribute.a;
						switch (description.$) {
							case 'Main':
								var $temp$classes = classes,
									$temp$node = A2($mdgriffith$elm_ui$Internal$Model$addNodeName, 'main', node),
									$temp$has = has,
									$temp$transform = transform,
									$temp$styles = styles,
									$temp$attrs = attrs,
									$temp$children = children,
									$temp$elementAttrs = remaining;
								classes = $temp$classes;
								node = $temp$node;
								has = $temp$has;
								transform = $temp$transform;
								styles = $temp$styles;
								attrs = $temp$attrs;
								children = $temp$children;
								elementAttrs = $temp$elementAttrs;
								continue gatherAttrRecursive;
							case 'Navigation':
								var $temp$classes = classes,
									$temp$node = A2($mdgriffith$elm_ui$Internal$Model$addNodeName, 'nav', node),
									$temp$has = has,
									$temp$transform = transform,
									$temp$styles = styles,
									$temp$attrs = attrs,
									$temp$children = children,
									$temp$elementAttrs = remaining;
								classes = $temp$classes;
								node = $temp$node;
								has = $temp$has;
								transform = $temp$transform;
								styles = $temp$styles;
								attrs = $temp$attrs;
								children = $temp$children;
								elementAttrs = $temp$elementAttrs;
								continue gatherAttrRecursive;
							case 'ContentInfo':
								var $temp$classes = classes,
									$temp$node = A2($mdgriffith$elm_ui$Internal$Model$addNodeName, 'footer', node),
									$temp$has = has,
									$temp$transform = transform,
									$temp$styles = styles,
									$temp$attrs = attrs,
									$temp$children = children,
									$temp$elementAttrs = remaining;
								classes = $temp$classes;
								node = $temp$node;
								has = $temp$has;
								transform = $temp$transform;
								styles = $temp$styles;
								attrs = $temp$attrs;
								children = $temp$children;
								elementAttrs = $temp$elementAttrs;
								continue gatherAttrRecursive;
							case 'Complementary':
								var $temp$classes = classes,
									$temp$node = A2($mdgriffith$elm_ui$Internal$Model$addNodeName, 'aside', node),
									$temp$has = has,
									$temp$transform = transform,
									$temp$styles = styles,
									$temp$attrs = attrs,
									$temp$children = children,
									$temp$elementAttrs = remaining;
								classes = $temp$classes;
								node = $temp$node;
								has = $temp$has;
								transform = $temp$transform;
								styles = $temp$styles;
								attrs = $temp$attrs;
								children = $temp$children;
								elementAttrs = $temp$elementAttrs;
								continue gatherAttrRecursive;
							case 'Heading':
								var i = description.a;
								if (i <= 1) {
									var $temp$classes = classes,
										$temp$node = A2($mdgriffith$elm_ui$Internal$Model$addNodeName, 'h1', node),
										$temp$has = has,
										$temp$transform = transform,
										$temp$styles = styles,
										$temp$attrs = attrs,
										$temp$children = children,
										$temp$elementAttrs = remaining;
									classes = $temp$classes;
									node = $temp$node;
									has = $temp$has;
									transform = $temp$transform;
									styles = $temp$styles;
									attrs = $temp$attrs;
									children = $temp$children;
									elementAttrs = $temp$elementAttrs;
									continue gatherAttrRecursive;
								} else {
									if (i < 7) {
										var $temp$classes = classes,
											$temp$node = A2(
											$mdgriffith$elm_ui$Internal$Model$addNodeName,
											'h' + $elm$core$String$fromInt(i),
											node),
											$temp$has = has,
											$temp$transform = transform,
											$temp$styles = styles,
											$temp$attrs = attrs,
											$temp$children = children,
											$temp$elementAttrs = remaining;
										classes = $temp$classes;
										node = $temp$node;
										has = $temp$has;
										transform = $temp$transform;
										styles = $temp$styles;
										attrs = $temp$attrs;
										children = $temp$children;
										elementAttrs = $temp$elementAttrs;
										continue gatherAttrRecursive;
									} else {
										var $temp$classes = classes,
											$temp$node = A2($mdgriffith$elm_ui$Internal$Model$addNodeName, 'h6', node),
											$temp$has = has,
											$temp$transform = transform,
											$temp$styles = styles,
											$temp$attrs = attrs,
											$temp$children = children,
											$temp$elementAttrs = remaining;
										classes = $temp$classes;
										node = $temp$node;
										has = $temp$has;
										transform = $temp$transform;
										styles = $temp$styles;
										attrs = $temp$attrs;
										children = $temp$children;
										elementAttrs = $temp$elementAttrs;
										continue gatherAttrRecursive;
									}
								}
							case 'Paragraph':
								var $temp$classes = classes,
									$temp$node = node,
									$temp$has = has,
									$temp$transform = transform,
									$temp$styles = styles,
									$temp$attrs = attrs,
									$temp$children = children,
									$temp$elementAttrs = remaining;
								classes = $temp$classes;
								node = $temp$node;
								has = $temp$has;
								transform = $temp$transform;
								styles = $temp$styles;
								attrs = $temp$attrs;
								children = $temp$children;
								elementAttrs = $temp$elementAttrs;
								continue gatherAttrRecursive;
							case 'Button':
								var $temp$classes = classes,
									$temp$node = node,
									$temp$has = has,
									$temp$transform = transform,
									$temp$styles = styles,
									$temp$attrs = A2(
									$elm$core$List$cons,
									A2($elm$virtual_dom$VirtualDom$attribute, 'role', 'button'),
									attrs),
									$temp$children = children,
									$temp$elementAttrs = remaining;
								classes = $temp$classes;
								node = $temp$node;
								has = $temp$has;
								transform = $temp$transform;
								styles = $temp$styles;
								attrs = $temp$attrs;
								children = $temp$children;
								elementAttrs = $temp$elementAttrs;
								continue gatherAttrRecursive;
							case 'Label':
								var label = description.a;
								var $temp$classes = classes,
									$temp$node = node,
									$temp$has = has,
									$temp$transform = transform,
									$temp$styles = styles,
									$temp$attrs = A2(
									$elm$core$List$cons,
									A2($elm$virtual_dom$VirtualDom$attribute, 'aria-label', label),
									attrs),
									$temp$children = children,
									$temp$elementAttrs = remaining;
								classes = $temp$classes;
								node = $temp$node;
								has = $temp$has;
								transform = $temp$transform;
								styles = $temp$styles;
								attrs = $temp$attrs;
								children = $temp$children;
								elementAttrs = $temp$elementAttrs;
								continue gatherAttrRecursive;
							case 'LivePolite':
								var $temp$classes = classes,
									$temp$node = node,
									$temp$has = has,
									$temp$transform = transform,
									$temp$styles = styles,
									$temp$attrs = A2(
									$elm$core$List$cons,
									A2($elm$virtual_dom$VirtualDom$attribute, 'aria-live', 'polite'),
									attrs),
									$temp$children = children,
									$temp$elementAttrs = remaining;
								classes = $temp$classes;
								node = $temp$node;
								has = $temp$has;
								transform = $temp$transform;
								styles = $temp$styles;
								attrs = $temp$attrs;
								children = $temp$children;
								elementAttrs = $temp$elementAttrs;
								continue gatherAttrRecursive;
							default:
								var $temp$classes = classes,
									$temp$node = node,
									$temp$has = has,
									$temp$transform = transform,
									$temp$styles = styles,
									$temp$attrs = A2(
									$elm$core$List$cons,
									A2($elm$virtual_dom$VirtualDom$attribute, 'aria-live', 'assertive'),
									attrs),
									$temp$children = children,
									$temp$elementAttrs = remaining;
								classes = $temp$classes;
								node = $temp$node;
								has = $temp$has;
								transform = $temp$transform;
								styles = $temp$styles;
								attrs = $temp$attrs;
								children = $temp$children;
								elementAttrs = $temp$elementAttrs;
								continue gatherAttrRecursive;
						}
					case 'Nearby':
						var location = attribute.a;
						var elem = attribute.b;
						var newStyles = function () {
							switch (elem.$) {
								case 'Empty':
									return styles;
								case 'Text':
									var str = elem.a;
									return styles;
								case 'Unstyled':
									var html = elem.a;
									return styles;
								default:
									var styled = elem.a;
									return _Utils_ap(styles, styled.styles);
							}
						}();
						var $temp$classes = classes,
							$temp$node = node,
							$temp$has = has,
							$temp$transform = transform,
							$temp$styles = newStyles,
							$temp$attrs = attrs,
							$temp$children = A3($mdgriffith$elm_ui$Internal$Model$addNearbyElement, location, elem, children),
							$temp$elementAttrs = remaining;
						classes = $temp$classes;
						node = $temp$node;
						has = $temp$has;
						transform = $temp$transform;
						styles = $temp$styles;
						attrs = $temp$attrs;
						children = $temp$children;
						elementAttrs = $temp$elementAttrs;
						continue gatherAttrRecursive;
					case 'AlignX':
						var x = attribute.a;
						if (A2($mdgriffith$elm_ui$Internal$Flag$present, $mdgriffith$elm_ui$Internal$Flag$xAlign, has)) {
							var $temp$classes = classes,
								$temp$node = node,
								$temp$has = has,
								$temp$transform = transform,
								$temp$styles = styles,
								$temp$attrs = attrs,
								$temp$children = children,
								$temp$elementAttrs = remaining;
							classes = $temp$classes;
							node = $temp$node;
							has = $temp$has;
							transform = $temp$transform;
							styles = $temp$styles;
							attrs = $temp$attrs;
							children = $temp$children;
							elementAttrs = $temp$elementAttrs;
							continue gatherAttrRecursive;
						} else {
							var $temp$classes = $mdgriffith$elm_ui$Internal$Model$alignXName(x) + (' ' + classes),
								$temp$node = node,
								$temp$has = function (flags) {
								switch (x.$) {
									case 'CenterX':
										return A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$centerX, flags);
									case 'Right':
										return A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$alignRight, flags);
									default:
										return flags;
								}
							}(
								A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$xAlign, has)),
								$temp$transform = transform,
								$temp$styles = styles,
								$temp$attrs = attrs,
								$temp$children = children,
								$temp$elementAttrs = remaining;
							classes = $temp$classes;
							node = $temp$node;
							has = $temp$has;
							transform = $temp$transform;
							styles = $temp$styles;
							attrs = $temp$attrs;
							children = $temp$children;
							elementAttrs = $temp$elementAttrs;
							continue gatherAttrRecursive;
						}
					default:
						var y = attribute.a;
						if (A2($mdgriffith$elm_ui$Internal$Flag$present, $mdgriffith$elm_ui$Internal$Flag$yAlign, has)) {
							var $temp$classes = classes,
								$temp$node = node,
								$temp$has = has,
								$temp$transform = transform,
								$temp$styles = styles,
								$temp$attrs = attrs,
								$temp$children = children,
								$temp$elementAttrs = remaining;
							classes = $temp$classes;
							node = $temp$node;
							has = $temp$has;
							transform = $temp$transform;
							styles = $temp$styles;
							attrs = $temp$attrs;
							children = $temp$children;
							elementAttrs = $temp$elementAttrs;
							continue gatherAttrRecursive;
						} else {
							var $temp$classes = $mdgriffith$elm_ui$Internal$Model$alignYName(y) + (' ' + classes),
								$temp$node = node,
								$temp$has = function (flags) {
								switch (y.$) {
									case 'CenterY':
										return A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$centerY, flags);
									case 'Bottom':
										return A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$alignBottom, flags);
									default:
										return flags;
								}
							}(
								A2($mdgriffith$elm_ui$Internal$Flag$add, $mdgriffith$elm_ui$Internal$Flag$yAlign, has)),
								$temp$transform = transform,
								$temp$styles = styles,
								$temp$attrs = attrs,
								$temp$children = children,
								$temp$elementAttrs = remaining;
							classes = $temp$classes;
							node = $temp$node;
							has = $temp$has;
							transform = $temp$transform;
							styles = $temp$styles;
							attrs = $temp$attrs;
							children = $temp$children;
							elementAttrs = $temp$elementAttrs;
							continue gatherAttrRecursive;
						}
				}
			}
		}
	});
var $mdgriffith$elm_ui$Internal$Model$Untransformed = {$: 'Untransformed'};
var $mdgriffith$elm_ui$Internal$Model$untransformed = $mdgriffith$elm_ui$Internal$Model$Untransformed;
var $mdgriffith$elm_ui$Internal$Model$element = F4(
	function (context, node, attributes, children) {
		return A3(
			$mdgriffith$elm_ui$Internal$Model$createElement,
			context,
			children,
			A8(
				$mdgriffith$elm_ui$Internal$Model$gatherAttrRecursive,
				$mdgriffith$elm_ui$Internal$Model$contextClasses(context),
				node,
				$mdgriffith$elm_ui$Internal$Flag$none,
				$mdgriffith$elm_ui$Internal$Model$untransformed,
				_List_Nil,
				_List_Nil,
				$mdgriffith$elm_ui$Internal$Model$NoNearbyChildren,
				$elm$core$List$reverse(attributes)));
	});
var $mdgriffith$elm_ui$Internal$Model$Height = function (a) {
	return {$: 'Height', a: a};
};
var $mdgriffith$elm_ui$Element$height = $mdgriffith$elm_ui$Internal$Model$Height;
var $mdgriffith$elm_ui$Internal$Model$Content = {$: 'Content'};
var $mdgriffith$elm_ui$Element$shrink = $mdgriffith$elm_ui$Internal$Model$Content;
var $mdgriffith$elm_ui$Internal$Model$Width = function (a) {
	return {$: 'Width', a: a};
};
var $mdgriffith$elm_ui$Element$width = $mdgriffith$elm_ui$Internal$Model$Width;
var $mdgriffith$elm_ui$Element$el = F2(
	function (attrs, child) {
		return A4(
			$mdgriffith$elm_ui$Internal$Model$element,
			$mdgriffith$elm_ui$Internal$Model$asEl,
			$mdgriffith$elm_ui$Internal$Model$div,
			A2(
				$elm$core$List$cons,
				$mdgriffith$elm_ui$Element$width($mdgriffith$elm_ui$Element$shrink),
				A2(
					$elm$core$List$cons,
					$mdgriffith$elm_ui$Element$height($mdgriffith$elm_ui$Element$shrink),
					attrs)),
			$mdgriffith$elm_ui$Internal$Model$Unkeyed(
				_List_fromArray(
					[child])));
	});
var $mdgriffith$elm_ui$Internal$Model$Fill = function (a) {
	return {$: 'Fill', a: a};
};
var $mdgriffith$elm_ui$Element$fill = $mdgriffith$elm_ui$Internal$Model$Fill(1);
var $elm$core$Basics$always = F2(
	function (a, _v0) {
		return a;
	});
var $elm$core$Basics$composeL = F3(
	function (g, f, x) {
		return g(
			f(x));
	});
var $mdgriffith$elm_ui$Internal$Model$unstyled = A2($elm$core$Basics$composeL, $mdgriffith$elm_ui$Internal$Model$Unstyled, $elm$core$Basics$always);
var $mdgriffith$elm_ui$Element$html = $mdgriffith$elm_ui$Internal$Model$unstyled;
var $elm$html$Html$li = _VirtualDom_node('li');
var $mdgriffith$elm_ui$Internal$Model$Attr = function (a) {
	return {$: 'Attr', a: a};
};
var $elm$html$Html$Attributes$href = function (url) {
	return A2(
		$elm$html$Html$Attributes$stringProperty,
		'href',
		_VirtualDom_noJavaScriptUri(url));
};
var $mdgriffith$elm_ui$Internal$Model$htmlClass = function (cls) {
	return $mdgriffith$elm_ui$Internal$Model$Attr(
		$elm$html$Html$Attributes$class(cls));
};
var $elm$html$Html$Attributes$rel = _VirtualDom_attribute('rel');
var $mdgriffith$elm_ui$Element$link = F2(
	function (attrs, _v0) {
		var url = _v0.url;
		var label = _v0.label;
		return A4(
			$mdgriffith$elm_ui$Internal$Model$element,
			$mdgriffith$elm_ui$Internal$Model$asEl,
			$mdgriffith$elm_ui$Internal$Model$NodeName('a'),
			A2(
				$elm$core$List$cons,
				$mdgriffith$elm_ui$Internal$Model$Attr(
					$elm$html$Html$Attributes$href(url)),
				A2(
					$elm$core$List$cons,
					$mdgriffith$elm_ui$Internal$Model$Attr(
						$elm$html$Html$Attributes$rel('noopener noreferrer')),
					A2(
						$elm$core$List$cons,
						$mdgriffith$elm_ui$Element$width($mdgriffith$elm_ui$Element$shrink),
						A2(
							$elm$core$List$cons,
							$mdgriffith$elm_ui$Element$height($mdgriffith$elm_ui$Element$shrink),
							A2(
								$elm$core$List$cons,
								$mdgriffith$elm_ui$Internal$Model$htmlClass($mdgriffith$elm_ui$Internal$Style$classes.contentCenterX + (' ' + ($mdgriffith$elm_ui$Internal$Style$classes.contentCenterY + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.link)))),
								attrs))))),
			$mdgriffith$elm_ui$Internal$Model$Unkeyed(
				_List_fromArray(
					[label])));
	});
var $mdgriffith$elm_ui$Internal$Model$Text = function (a) {
	return {$: 'Text', a: a};
};
var $mdgriffith$elm_ui$Element$text = function (content) {
	return $mdgriffith$elm_ui$Internal$Model$Text(content);
};
var $mdgriffith$elm_ui$Element$Font$underline = $mdgriffith$elm_ui$Internal$Model$htmlClass($mdgriffith$elm_ui$Internal$Style$classes.underline);
var $author$project$Ui$Layout$link = F2(
	function (url, label) {
		return A2(
			$mdgriffith$elm_ui$Element$link,
			_List_fromArray(
				[$mdgriffith$elm_ui$Element$Font$underline]),
			{
				label: $mdgriffith$elm_ui$Element$text(label),
				url: url
			});
	});
var $mdgriffith$elm_ui$Internal$Model$Empty = {$: 'Empty'};
var $mdgriffith$elm_ui$Internal$Model$map = F2(
	function (fn, el) {
		switch (el.$) {
			case 'Styled':
				var styled = el.a;
				return $mdgriffith$elm_ui$Internal$Model$Styled(
					{
						html: F2(
							function (add, context) {
								return A2(
									$elm$virtual_dom$VirtualDom$map,
									fn,
									A2(styled.html, add, context));
							}),
						styles: styled.styles
					});
			case 'Unstyled':
				var html = el.a;
				return $mdgriffith$elm_ui$Internal$Model$Unstyled(
					A2(
						$elm$core$Basics$composeL,
						$elm$virtual_dom$VirtualDom$map(fn),
						html));
			case 'Text':
				var str = el.a;
				return $mdgriffith$elm_ui$Internal$Model$Text(str);
			default:
				return $mdgriffith$elm_ui$Internal$Model$Empty;
		}
	});
var $mdgriffith$elm_ui$Element$map = $mdgriffith$elm_ui$Internal$Model$map;
var $mdgriffith$elm_ui$Internal$Model$Max = F2(
	function (a, b) {
		return {$: 'Max', a: a, b: b};
	});
var $mdgriffith$elm_ui$Element$maximum = F2(
	function (i, l) {
		return A2($mdgriffith$elm_ui$Internal$Model$Max, i, l);
	});
var $mdgriffith$elm_ui$Internal$Model$PaddingStyle = F5(
	function (a, b, c, d, e) {
		return {$: 'PaddingStyle', a: a, b: b, c: c, d: d, e: e};
	});
var $mdgriffith$elm_ui$Internal$Model$StyleClass = F2(
	function (a, b) {
		return {$: 'StyleClass', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Flag$padding = $mdgriffith$elm_ui$Internal$Flag$flag(2);
var $mdgriffith$elm_ui$Internal$Model$paddingName = F4(
	function (top, right, bottom, left) {
		return 'pad-' + ($elm$core$String$fromInt(top) + ('-' + ($elm$core$String$fromInt(right) + ('-' + ($elm$core$String$fromInt(bottom) + ('-' + $elm$core$String$fromInt(left)))))));
	});
var $mdgriffith$elm_ui$Element$paddingEach = function (_v0) {
	var top = _v0.top;
	var right = _v0.right;
	var bottom = _v0.bottom;
	var left = _v0.left;
	if (_Utils_eq(top, right) && (_Utils_eq(top, bottom) && _Utils_eq(top, left))) {
		var topFloat = top;
		return A2(
			$mdgriffith$elm_ui$Internal$Model$StyleClass,
			$mdgriffith$elm_ui$Internal$Flag$padding,
			A5(
				$mdgriffith$elm_ui$Internal$Model$PaddingStyle,
				'p-' + $elm$core$String$fromInt(top),
				topFloat,
				topFloat,
				topFloat,
				topFloat));
	} else {
		return A2(
			$mdgriffith$elm_ui$Internal$Model$StyleClass,
			$mdgriffith$elm_ui$Internal$Flag$padding,
			A5(
				$mdgriffith$elm_ui$Internal$Model$PaddingStyle,
				A4($mdgriffith$elm_ui$Internal$Model$paddingName, top, right, bottom, left),
				top,
				right,
				bottom,
				left));
	}
};
var $mdgriffith$elm_ui$Element$paddingXY = F2(
	function (x, y) {
		if (_Utils_eq(x, y)) {
			var f = x;
			return A2(
				$mdgriffith$elm_ui$Internal$Model$StyleClass,
				$mdgriffith$elm_ui$Internal$Flag$padding,
				A5(
					$mdgriffith$elm_ui$Internal$Model$PaddingStyle,
					'p-' + $elm$core$String$fromInt(x),
					f,
					f,
					f,
					f));
		} else {
			var yFloat = y;
			var xFloat = x;
			return A2(
				$mdgriffith$elm_ui$Internal$Model$StyleClass,
				$mdgriffith$elm_ui$Internal$Flag$padding,
				A5(
					$mdgriffith$elm_ui$Internal$Model$PaddingStyle,
					'p-' + ($elm$core$String$fromInt(x) + ('-' + $elm$core$String$fromInt(y))),
					yFloat,
					xFloat,
					yFloat,
					xFloat));
		}
	});
var $mdgriffith$elm_ui$Internal$Model$Describe = function (a) {
	return {$: 'Describe', a: a};
};
var $mdgriffith$elm_ui$Internal$Model$Paragraph = {$: 'Paragraph'};
var $mdgriffith$elm_ui$Internal$Model$SpacingStyle = F3(
	function (a, b, c) {
		return {$: 'SpacingStyle', a: a, b: b, c: c};
	});
var $mdgriffith$elm_ui$Internal$Flag$spacing = $mdgriffith$elm_ui$Internal$Flag$flag(3);
var $mdgriffith$elm_ui$Internal$Model$spacingName = F2(
	function (x, y) {
		return 'spacing-' + ($elm$core$String$fromInt(x) + ('-' + $elm$core$String$fromInt(y)));
	});
var $mdgriffith$elm_ui$Element$spacing = function (x) {
	return A2(
		$mdgriffith$elm_ui$Internal$Model$StyleClass,
		$mdgriffith$elm_ui$Internal$Flag$spacing,
		A3(
			$mdgriffith$elm_ui$Internal$Model$SpacingStyle,
			A2($mdgriffith$elm_ui$Internal$Model$spacingName, x, x),
			x,
			x));
};
var $mdgriffith$elm_ui$Element$paragraph = F2(
	function (attrs, children) {
		return A4(
			$mdgriffith$elm_ui$Internal$Model$element,
			$mdgriffith$elm_ui$Internal$Model$asParagraph,
			$mdgriffith$elm_ui$Internal$Model$div,
			A2(
				$elm$core$List$cons,
				$mdgriffith$elm_ui$Internal$Model$Describe($mdgriffith$elm_ui$Internal$Model$Paragraph),
				A2(
					$elm$core$List$cons,
					$mdgriffith$elm_ui$Element$width($mdgriffith$elm_ui$Element$fill),
					A2(
						$elm$core$List$cons,
						$mdgriffith$elm_ui$Element$spacing(5),
						attrs))),
			$mdgriffith$elm_ui$Internal$Model$Unkeyed(children));
	});
var $mdgriffith$elm_ui$Internal$Model$AsRow = {$: 'AsRow'};
var $mdgriffith$elm_ui$Internal$Model$asRow = $mdgriffith$elm_ui$Internal$Model$AsRow;
var $mdgriffith$elm_ui$Element$row = F2(
	function (attrs, children) {
		return A4(
			$mdgriffith$elm_ui$Internal$Model$element,
			$mdgriffith$elm_ui$Internal$Model$asRow,
			$mdgriffith$elm_ui$Internal$Model$div,
			A2(
				$elm$core$List$cons,
				$mdgriffith$elm_ui$Internal$Model$htmlClass($mdgriffith$elm_ui$Internal$Style$classes.contentLeft + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.contentCenterY)),
				A2(
					$elm$core$List$cons,
					$mdgriffith$elm_ui$Element$width($mdgriffith$elm_ui$Element$shrink),
					A2(
						$elm$core$List$cons,
						$mdgriffith$elm_ui$Element$height($mdgriffith$elm_ui$Element$shrink),
						attrs))),
			$mdgriffith$elm_ui$Internal$Model$Unkeyed(children));
	});
var $mdgriffith$elm_ui$Internal$Model$FontSize = function (a) {
	return {$: 'FontSize', a: a};
};
var $mdgriffith$elm_ui$Internal$Flag$fontSize = $mdgriffith$elm_ui$Internal$Flag$flag(4);
var $mdgriffith$elm_ui$Element$Font$size = function (i) {
	return A2(
		$mdgriffith$elm_ui$Internal$Model$StyleClass,
		$mdgriffith$elm_ui$Internal$Flag$fontSize,
		$mdgriffith$elm_ui$Internal$Model$FontSize(i));
};
var $author$project$Ui$Menu$OnToggle = {$: 'OnToggle'};
var $mdgriffith$elm_ui$Internal$Model$AlignX = function (a) {
	return {$: 'AlignX', a: a};
};
var $mdgriffith$elm_ui$Internal$Model$Left = {$: 'Left'};
var $mdgriffith$elm_ui$Element$alignLeft = $mdgriffith$elm_ui$Internal$Model$AlignX($mdgriffith$elm_ui$Internal$Model$Left);
var $mdgriffith$elm_ui$Internal$Model$Right = {$: 'Right'};
var $mdgriffith$elm_ui$Element$alignRight = $mdgriffith$elm_ui$Internal$Model$AlignX($mdgriffith$elm_ui$Internal$Model$Right);
var $mdgriffith$elm_ui$Internal$Model$AlignY = function (a) {
	return {$: 'AlignY', a: a};
};
var $mdgriffith$elm_ui$Internal$Model$Top = {$: 'Top'};
var $mdgriffith$elm_ui$Element$alignTop = $mdgriffith$elm_ui$Internal$Model$AlignY($mdgriffith$elm_ui$Internal$Model$Top);
var $mdgriffith$elm_ui$Internal$Model$Button = {$: 'Button'};
var $elm$json$Json$Encode$bool = _Json_wrap;
var $elm$html$Html$Attributes$boolProperty = F2(
	function (key, bool) {
		return A2(
			_VirtualDom_property,
			key,
			$elm$json$Json$Encode$bool(bool));
	});
var $elm$html$Html$Attributes$disabled = $elm$html$Html$Attributes$boolProperty('disabled');
var $mdgriffith$elm_ui$Element$Input$enter = 'Enter';
var $mdgriffith$elm_ui$Internal$Model$NoAttribute = {$: 'NoAttribute'};
var $mdgriffith$elm_ui$Element$Input$hasFocusStyle = function (attr) {
	if (((attr.$ === 'StyleClass') && (attr.b.$ === 'PseudoSelector')) && (attr.b.a.$ === 'Focus')) {
		var _v1 = attr.b;
		var _v2 = _v1.a;
		return true;
	} else {
		return false;
	}
};
var $mdgriffith$elm_ui$Element$Input$focusDefault = function (attrs) {
	return A2($elm$core$List$any, $mdgriffith$elm_ui$Element$Input$hasFocusStyle, attrs) ? $mdgriffith$elm_ui$Internal$Model$NoAttribute : $mdgriffith$elm_ui$Internal$Model$htmlClass('focusable');
};
var $elm$virtual_dom$VirtualDom$Normal = function (a) {
	return {$: 'Normal', a: a};
};
var $elm$virtual_dom$VirtualDom$on = _VirtualDom_on;
var $elm$html$Html$Events$on = F2(
	function (event, decoder) {
		return A2(
			$elm$virtual_dom$VirtualDom$on,
			event,
			$elm$virtual_dom$VirtualDom$Normal(decoder));
	});
var $elm$html$Html$Events$onClick = function (msg) {
	return A2(
		$elm$html$Html$Events$on,
		'click',
		$elm$json$Json$Decode$succeed(msg));
};
var $mdgriffith$elm_ui$Element$Events$onClick = A2($elm$core$Basics$composeL, $mdgriffith$elm_ui$Internal$Model$Attr, $elm$html$Html$Events$onClick);
var $elm$json$Json$Decode$andThen = _Json_andThen;
var $elm$json$Json$Decode$fail = _Json_fail;
var $elm$virtual_dom$VirtualDom$MayPreventDefault = function (a) {
	return {$: 'MayPreventDefault', a: a};
};
var $elm$html$Html$Events$preventDefaultOn = F2(
	function (event, decoder) {
		return A2(
			$elm$virtual_dom$VirtualDom$on,
			event,
			$elm$virtual_dom$VirtualDom$MayPreventDefault(decoder));
	});
var $elm$json$Json$Decode$string = _Json_decodeString;
var $mdgriffith$elm_ui$Element$Input$onKeyLookup = function (lookup) {
	var decode = function (code) {
		var _v0 = lookup(code);
		if (_v0.$ === 'Nothing') {
			return $elm$json$Json$Decode$fail('No key matched');
		} else {
			var msg = _v0.a;
			return $elm$json$Json$Decode$succeed(msg);
		}
	};
	var isKey = A2(
		$elm$json$Json$Decode$andThen,
		decode,
		A2($elm$json$Json$Decode$field, 'key', $elm$json$Json$Decode$string));
	return $mdgriffith$elm_ui$Internal$Model$Attr(
		A2(
			$elm$html$Html$Events$preventDefaultOn,
			'keydown',
			A2(
				$elm$json$Json$Decode$map,
				function (fired) {
					return _Utils_Tuple2(fired, true);
				},
				isKey)));
};
var $mdgriffith$elm_ui$Internal$Model$Class = F2(
	function (a, b) {
		return {$: 'Class', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Flag$cursor = $mdgriffith$elm_ui$Internal$Flag$flag(21);
var $mdgriffith$elm_ui$Element$pointer = A2($mdgriffith$elm_ui$Internal$Model$Class, $mdgriffith$elm_ui$Internal$Flag$cursor, $mdgriffith$elm_ui$Internal$Style$classes.cursorPointer);
var $mdgriffith$elm_ui$Element$Input$space = ' ';
var $elm$html$Html$Attributes$tabindex = function (n) {
	return A2(
		_VirtualDom_attribute,
		'tabIndex',
		$elm$core$String$fromInt(n));
};
var $mdgriffith$elm_ui$Element$Input$button = F2(
	function (attrs, _v0) {
		var onPress = _v0.onPress;
		var label = _v0.label;
		return A4(
			$mdgriffith$elm_ui$Internal$Model$element,
			$mdgriffith$elm_ui$Internal$Model$asEl,
			$mdgriffith$elm_ui$Internal$Model$div,
			A2(
				$elm$core$List$cons,
				$mdgriffith$elm_ui$Element$width($mdgriffith$elm_ui$Element$shrink),
				A2(
					$elm$core$List$cons,
					$mdgriffith$elm_ui$Element$height($mdgriffith$elm_ui$Element$shrink),
					A2(
						$elm$core$List$cons,
						$mdgriffith$elm_ui$Internal$Model$htmlClass($mdgriffith$elm_ui$Internal$Style$classes.contentCenterX + (' ' + ($mdgriffith$elm_ui$Internal$Style$classes.contentCenterY + (' ' + ($mdgriffith$elm_ui$Internal$Style$classes.seButton + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.noTextSelection)))))),
						A2(
							$elm$core$List$cons,
							$mdgriffith$elm_ui$Element$pointer,
							A2(
								$elm$core$List$cons,
								$mdgriffith$elm_ui$Element$Input$focusDefault(attrs),
								A2(
									$elm$core$List$cons,
									$mdgriffith$elm_ui$Internal$Model$Describe($mdgriffith$elm_ui$Internal$Model$Button),
									A2(
										$elm$core$List$cons,
										$mdgriffith$elm_ui$Internal$Model$Attr(
											$elm$html$Html$Attributes$tabindex(0)),
										function () {
											if (onPress.$ === 'Nothing') {
												return A2(
													$elm$core$List$cons,
													$mdgriffith$elm_ui$Internal$Model$Attr(
														$elm$html$Html$Attributes$disabled(true)),
													attrs);
											} else {
												var msg = onPress.a;
												return A2(
													$elm$core$List$cons,
													$mdgriffith$elm_ui$Element$Events$onClick(msg),
													A2(
														$elm$core$List$cons,
														$mdgriffith$elm_ui$Element$Input$onKeyLookup(
															function (code) {
																return _Utils_eq(code, $mdgriffith$elm_ui$Element$Input$enter) ? $elm$core$Maybe$Just(msg) : (_Utils_eq(code, $mdgriffith$elm_ui$Element$Input$space) ? $elm$core$Maybe$Just(msg) : $elm$core$Maybe$Nothing);
															}),
														attrs));
											}
										}()))))))),
			$mdgriffith$elm_ui$Internal$Model$Unkeyed(
				_List_fromArray(
					[label])));
	});
var $mdgriffith$elm_ui$Internal$Model$CenterX = {$: 'CenterX'};
var $mdgriffith$elm_ui$Element$centerX = $mdgriffith$elm_ui$Internal$Model$AlignX($mdgriffith$elm_ui$Internal$Model$CenterX);
var $mdgriffith$elm_ui$Internal$Model$AsColumn = {$: 'AsColumn'};
var $mdgriffith$elm_ui$Internal$Model$asColumn = $mdgriffith$elm_ui$Internal$Model$AsColumn;
var $mdgriffith$elm_ui$Element$column = F2(
	function (attrs, children) {
		return A4(
			$mdgriffith$elm_ui$Internal$Model$element,
			$mdgriffith$elm_ui$Internal$Model$asColumn,
			$mdgriffith$elm_ui$Internal$Model$div,
			A2(
				$elm$core$List$cons,
				$mdgriffith$elm_ui$Internal$Model$htmlClass($mdgriffith$elm_ui$Internal$Style$classes.contentTop + (' ' + $mdgriffith$elm_ui$Internal$Style$classes.contentLeft)),
				A2(
					$elm$core$List$cons,
					$mdgriffith$elm_ui$Element$height($mdgriffith$elm_ui$Element$shrink),
					A2(
						$elm$core$List$cons,
						$mdgriffith$elm_ui$Element$width($mdgriffith$elm_ui$Element$shrink),
						attrs))),
			$mdgriffith$elm_ui$Internal$Model$Unkeyed(children));
	});
var $author$project$Ui$Menu$Link = F2(
	function (url, title) {
		return {title: title, url: url};
	});
var $elm$url$Url$Builder$toQueryPair = function (_v0) {
	var key = _v0.a;
	var value = _v0.b;
	return key + ('=' + value);
};
var $elm$url$Url$Builder$toQuery = function (parameters) {
	if (!parameters.b) {
		return '';
	} else {
		return '?' + A2(
			$elm$core$String$join,
			'&',
			A2($elm$core$List$map, $elm$url$Url$Builder$toQueryPair, parameters));
	}
};
var $elm$url$Url$Builder$absolute = F2(
	function (pathSegments, parameters) {
		return '/' + (A2($elm$core$String$join, '/', pathSegments) + $elm$url$Url$Builder$toQuery(parameters));
	});
var $author$project$Route$toString = function (route) {
	switch (route.$) {
		case 'Top':
			return A2(
				$elm$url$Url$Builder$absolute,
				_List_Nil,
				A2($elm$core$List$filterMap, $elm$core$Basics$identity, _List_Nil));
		case 'Administration':
			return A2(
				$elm$url$Url$Builder$absolute,
				_List_fromArray(
					['administration']),
				A2($elm$core$List$filterMap, $elm$core$Basics$identity, _List_Nil));
		case 'Documentation':
			return A2(
				$elm$url$Url$Builder$absolute,
				_List_fromArray(
					['documentation']),
				A2($elm$core$List$filterMap, $elm$core$Basics$identity, _List_Nil));
		case 'Documentation_String_':
			var p1 = route.a;
			return A2(
				$elm$url$Url$Builder$absolute,
				_List_fromArray(
					['documentation', p1]),
				A2($elm$core$List$filterMap, $elm$core$Basics$identity, _List_Nil));
		case 'Documentation_String__String_':
			var p1 = route.a;
			var p2 = route.b;
			return A2(
				$elm$url$Url$Builder$absolute,
				_List_fromArray(
					['documentation', p1, p2]),
				A2($elm$core$List$filterMap, $elm$core$Basics$identity, _List_Nil));
		default:
			return A2(
				$elm$url$Url$Builder$absolute,
				_List_fromArray(
					['getting-started']),
				A2($elm$core$List$filterMap, $elm$core$Basics$identity, _List_Nil));
	}
};
var $author$project$Route$administration = $author$project$Route$toString($author$project$Route$Administration);
var $author$project$Route$documentation = $author$project$Route$toString($author$project$Route$Documentation);
var $author$project$Route$gettingStarted = $author$project$Route$toString($author$project$Route$Getting_started);
var $author$project$Ui$Menu$viewLink = function (link) {
	return A2(
		$mdgriffith$elm_ui$Element$link,
		_List_Nil,
		{
			label: $mdgriffith$elm_ui$Element$text(link.title),
			url: link.url
		});
};
var $author$project$Ui$Menu$links = A2(
	$elm$core$List$map,
	$author$project$Ui$Menu$viewLink,
	_List_fromArray(
		[
			A2($author$project$Ui$Menu$Link, $author$project$Route$gettingStarted, 'Getting started'),
			A2($author$project$Ui$Menu$Link, $author$project$Route$documentation, 'Documentation'),
			A2($author$project$Ui$Menu$Link, $author$project$Route$administration, 'Administration')
		]));
var $elm$svg$Svg$trustedNode = _VirtualDom_nodeNS('http://www.w3.org/2000/svg');
var $elm$svg$Svg$line = $elm$svg$Svg$trustedNode('line');
var $feathericons$elm_feather$FeatherIcons$Icon = function (a) {
	return {$: 'Icon', a: a};
};
var $feathericons$elm_feather$FeatherIcons$defaultAttributes = function (name) {
	return {
		_class: $elm$core$Maybe$Just('feather feather-' + name),
		size: 24,
		sizeUnit: '',
		strokeWidth: 2,
		viewBox: '0 0 24 24'
	};
};
var $feathericons$elm_feather$FeatherIcons$makeBuilder = F2(
	function (name, src) {
		return $feathericons$elm_feather$FeatherIcons$Icon(
			{
				attrs: $feathericons$elm_feather$FeatherIcons$defaultAttributes(name),
				src: src
			});
	});
var $elm$svg$Svg$Attributes$x1 = _VirtualDom_attribute('x1');
var $elm$svg$Svg$Attributes$x2 = _VirtualDom_attribute('x2');
var $elm$svg$Svg$Attributes$y1 = _VirtualDom_attribute('y1');
var $elm$svg$Svg$Attributes$y2 = _VirtualDom_attribute('y2');
var $feathericons$elm_feather$FeatherIcons$menu = A2(
	$feathericons$elm_feather$FeatherIcons$makeBuilder,
	'menu',
	_List_fromArray(
		[
			A2(
			$elm$svg$Svg$line,
			_List_fromArray(
				[
					$elm$svg$Svg$Attributes$x1('3'),
					$elm$svg$Svg$Attributes$y1('12'),
					$elm$svg$Svg$Attributes$x2('21'),
					$elm$svg$Svg$Attributes$y2('12')
				]),
			_List_Nil),
			A2(
			$elm$svg$Svg$line,
			_List_fromArray(
				[
					$elm$svg$Svg$Attributes$x1('3'),
					$elm$svg$Svg$Attributes$y1('6'),
					$elm$svg$Svg$Attributes$x2('21'),
					$elm$svg$Svg$Attributes$y2('6')
				]),
			_List_Nil),
			A2(
			$elm$svg$Svg$line,
			_List_fromArray(
				[
					$elm$svg$Svg$Attributes$x1('3'),
					$elm$svg$Svg$Attributes$y1('18'),
					$elm$svg$Svg$Attributes$x2('21'),
					$elm$svg$Svg$Attributes$y2('18')
				]),
			_List_Nil)
		]));
var $mdgriffith$elm_ui$Element$none = $mdgriffith$elm_ui$Internal$Model$Empty;
var $elm$svg$Svg$Attributes$class = _VirtualDom_attribute('class');
var $elm$svg$Svg$Attributes$fill = _VirtualDom_attribute('fill');
var $elm$svg$Svg$Attributes$height = _VirtualDom_attribute('height');
var $elm$svg$Svg$map = $elm$virtual_dom$VirtualDom$map;
var $elm$svg$Svg$Attributes$stroke = _VirtualDom_attribute('stroke');
var $elm$svg$Svg$Attributes$strokeLinecap = _VirtualDom_attribute('stroke-linecap');
var $elm$svg$Svg$Attributes$strokeLinejoin = _VirtualDom_attribute('stroke-linejoin');
var $elm$svg$Svg$Attributes$strokeWidth = _VirtualDom_attribute('stroke-width');
var $elm$svg$Svg$svg = $elm$svg$Svg$trustedNode('svg');
var $elm$svg$Svg$Attributes$viewBox = _VirtualDom_attribute('viewBox');
var $elm$svg$Svg$Attributes$width = _VirtualDom_attribute('width');
var $feathericons$elm_feather$FeatherIcons$toHtml = F2(
	function (attributes, _v0) {
		var src = _v0.a.src;
		var attrs = _v0.a.attrs;
		var strSize = $elm$core$String$fromFloat(attrs.size);
		var baseAttributes = _List_fromArray(
			[
				$elm$svg$Svg$Attributes$fill('none'),
				$elm$svg$Svg$Attributes$height(
				_Utils_ap(strSize, attrs.sizeUnit)),
				$elm$svg$Svg$Attributes$width(
				_Utils_ap(strSize, attrs.sizeUnit)),
				$elm$svg$Svg$Attributes$stroke('currentColor'),
				$elm$svg$Svg$Attributes$strokeLinecap('round'),
				$elm$svg$Svg$Attributes$strokeLinejoin('round'),
				$elm$svg$Svg$Attributes$strokeWidth(
				$elm$core$String$fromFloat(attrs.strokeWidth)),
				$elm$svg$Svg$Attributes$viewBox(attrs.viewBox)
			]);
		var combinedAttributes = _Utils_ap(
			function () {
				var _v1 = attrs._class;
				if (_v1.$ === 'Just') {
					var c = _v1.a;
					return A2(
						$elm$core$List$cons,
						$elm$svg$Svg$Attributes$class(c),
						baseAttributes);
				} else {
					return baseAttributes;
				}
			}(),
			attributes);
		return A2(
			$elm$svg$Svg$svg,
			combinedAttributes,
			A2(
				$elm$core$List$map,
				$elm$svg$Svg$map($elm$core$Basics$never),
				src));
	});
var $feathericons$elm_feather$FeatherIcons$x = A2(
	$feathericons$elm_feather$FeatherIcons$makeBuilder,
	'x',
	_List_fromArray(
		[
			A2(
			$elm$svg$Svg$line,
			_List_fromArray(
				[
					$elm$svg$Svg$Attributes$x1('18'),
					$elm$svg$Svg$Attributes$y1('6'),
					$elm$svg$Svg$Attributes$x2('6'),
					$elm$svg$Svg$Attributes$y2('18')
				]),
			_List_Nil),
			A2(
			$elm$svg$Svg$line,
			_List_fromArray(
				[
					$elm$svg$Svg$Attributes$x1('6'),
					$elm$svg$Svg$Attributes$y1('6'),
					$elm$svg$Svg$Attributes$x2('18'),
					$elm$svg$Svg$Attributes$y2('18')
				]),
			_List_Nil)
		]));
var $author$project$Ui$Menu$small = F2(
	function (window, model) {
		return A2(
			$mdgriffith$elm_ui$Element$column,
			_List_fromArray(
				[
					$mdgriffith$elm_ui$Element$width($mdgriffith$elm_ui$Element$fill),
					$mdgriffith$elm_ui$Element$paddingEach(
					{bottom: 40, left: 0, right: 0, top: 0})
				]),
			_List_fromArray(
				[
					A2(
					$mdgriffith$elm_ui$Element$row,
					_List_fromArray(
						[
							$mdgriffith$elm_ui$Element$width($mdgriffith$elm_ui$Element$fill)
						]),
					_List_fromArray(
						[
							A2(
							$mdgriffith$elm_ui$Element$column,
							_List_fromArray(
								[
									$mdgriffith$elm_ui$Element$alignTop,
									$mdgriffith$elm_ui$Element$spacing(5),
									$mdgriffith$elm_ui$Element$alignLeft,
									$mdgriffith$elm_ui$Element$width(
									A2($mdgriffith$elm_ui$Element$maximum, 300, $mdgriffith$elm_ui$Element$fill))
								]),
							_List_fromArray(
								[
									A2(
									$mdgriffith$elm_ui$Element$link,
									_List_Nil,
									{
										label: A2(
											$mdgriffith$elm_ui$Element$row,
											_List_fromArray(
												[
													$mdgriffith$elm_ui$Element$Font$size(20)
												]),
											_List_fromArray(
												[
													$mdgriffith$elm_ui$Element$text('elm-charts')
												])),
										url: '/'
									})
								])),
							A2(
							$mdgriffith$elm_ui$Element$row,
							_List_fromArray(
								[
									$mdgriffith$elm_ui$Element$spacing(40),
									$mdgriffith$elm_ui$Element$alignRight,
									$mdgriffith$elm_ui$Element$Font$size(13)
								]),
							(window.width > 700) ? $author$project$Ui$Menu$links : _List_fromArray(
								[
									A2(
									$mdgriffith$elm_ui$Element$Input$button,
									_List_Nil,
									{
										label: $mdgriffith$elm_ui$Element$html(
											A2(
												$feathericons$elm_feather$FeatherIcons$toHtml,
												_List_Nil,
												model.isOpen ? $feathericons$elm_feather$FeatherIcons$x : $feathericons$elm_feather$FeatherIcons$menu)),
										onPress: $elm$core$Maybe$Just($author$project$Ui$Menu$OnToggle)
									})
								]))
						])),
					model.isOpen ? A2(
					$mdgriffith$elm_ui$Element$column,
					_List_fromArray(
						[
							$mdgriffith$elm_ui$Element$centerX,
							$mdgriffith$elm_ui$Element$spacing(15),
							$mdgriffith$elm_ui$Element$paddingEach(
							{bottom: 20, left: 0, right: 0, top: 30}),
							$mdgriffith$elm_ui$Element$Font$size(16)
						]),
					$author$project$Ui$Menu$links) : $mdgriffith$elm_ui$Element$none
				]));
	});
var $elm$virtual_dom$VirtualDom$style = _VirtualDom_style;
var $elm$html$Html$Attributes$style = $elm$virtual_dom$VirtualDom$style;
var $mdgriffith$elm_ui$Internal$Model$AsTextColumn = {$: 'AsTextColumn'};
var $mdgriffith$elm_ui$Internal$Model$asTextColumn = $mdgriffith$elm_ui$Internal$Model$AsTextColumn;
var $mdgriffith$elm_ui$Internal$Model$Min = F2(
	function (a, b) {
		return {$: 'Min', a: a, b: b};
	});
var $mdgriffith$elm_ui$Element$minimum = F2(
	function (i, l) {
		return A2($mdgriffith$elm_ui$Internal$Model$Min, i, l);
	});
var $mdgriffith$elm_ui$Element$textColumn = F2(
	function (attrs, children) {
		return A4(
			$mdgriffith$elm_ui$Internal$Model$element,
			$mdgriffith$elm_ui$Internal$Model$asTextColumn,
			$mdgriffith$elm_ui$Internal$Model$div,
			A2(
				$elm$core$List$cons,
				$mdgriffith$elm_ui$Element$width(
					A2(
						$mdgriffith$elm_ui$Element$maximum,
						750,
						A2($mdgriffith$elm_ui$Element$minimum, 500, $mdgriffith$elm_ui$Element$fill))),
				attrs),
			$mdgriffith$elm_ui$Internal$Model$Unkeyed(children));
	});
var $elm$html$Html$ul = _VirtualDom_node('ul');
var $mdgriffith$elm_ui$Internal$Model$Colored = F3(
	function (a, b, c) {
		return {$: 'Colored', a: a, b: b, c: c};
	});
var $mdgriffith$elm_ui$Internal$Flag$fontColor = $mdgriffith$elm_ui$Internal$Flag$flag(14);
var $mdgriffith$elm_ui$Internal$Model$formatColorClass = function (_v0) {
	var red = _v0.a;
	var green = _v0.b;
	var blue = _v0.c;
	var alpha = _v0.d;
	return $mdgriffith$elm_ui$Internal$Model$floatClass(red) + ('-' + ($mdgriffith$elm_ui$Internal$Model$floatClass(green) + ('-' + ($mdgriffith$elm_ui$Internal$Model$floatClass(blue) + ('-' + $mdgriffith$elm_ui$Internal$Model$floatClass(alpha))))));
};
var $mdgriffith$elm_ui$Element$Font$color = function (fontColor) {
	return A2(
		$mdgriffith$elm_ui$Internal$Model$StyleClass,
		$mdgriffith$elm_ui$Internal$Flag$fontColor,
		A3(
			$mdgriffith$elm_ui$Internal$Model$Colored,
			'fc-' + $mdgriffith$elm_ui$Internal$Model$formatColorClass(fontColor),
			'color',
			fontColor));
};
var $mdgriffith$elm_ui$Internal$Model$Rgba = F4(
	function (a, b, c, d) {
		return {$: 'Rgba', a: a, b: b, c: c, d: d};
	});
var $mdgriffith$elm_ui$Element$rgb255 = F3(
	function (red, green, blue) {
		return A4($mdgriffith$elm_ui$Internal$Model$Rgba, red / 255, green / 255, blue / 255, 1);
	});
var $author$project$Ui$Layout$Large = {$: 'Large'};
var $author$project$Ui$Layout$Medium = {$: 'Medium'};
var $author$project$Ui$Layout$Small = {$: 'Small'};
var $author$project$Ui$Layout$screen = function (window) {
	return (window.width > 950) ? $author$project$Ui$Layout$Large : ((window.width > 760) ? $author$project$Ui$Layout$Medium : $author$project$Ui$Layout$Small);
};
var $author$project$Ui$Layout$copyright = function (window) {
	return A2(
		$mdgriffith$elm_ui$Element$el,
		_List_fromArray(
			[
				$mdgriffith$elm_ui$Element$Font$size(12),
				$mdgriffith$elm_ui$Element$Font$color(
				A3($mdgriffith$elm_ui$Element$rgb255, 180, 180, 180)),
				$mdgriffith$elm_ui$Element$paddingEach(
				{bottom: 20, left: 0, right: 0, top: 30}),
				function () {
				var _v0 = $author$project$Ui$Layout$screen(window);
				switch (_v0.$) {
					case 'Large':
						return $mdgriffith$elm_ui$Element$alignRight;
					case 'Medium':
						return $mdgriffith$elm_ui$Element$centerX;
					default:
						return $mdgriffith$elm_ui$Element$centerX;
				}
			}()
			]),
		$mdgriffith$elm_ui$Element$text('Designed and developed by Tereza Sokol © 2021'));
};
var $mdgriffith$elm_ui$Internal$Model$FontFamily = F2(
	function (a, b) {
		return {$: 'FontFamily', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Flag$fontFamily = $mdgriffith$elm_ui$Internal$Flag$flag(5);
var $elm$core$String$words = _String_words;
var $mdgriffith$elm_ui$Internal$Model$renderFontClassName = F2(
	function (font, current) {
		return _Utils_ap(
			current,
			function () {
				switch (font.$) {
					case 'Serif':
						return 'serif';
					case 'SansSerif':
						return 'sans-serif';
					case 'Monospace':
						return 'monospace';
					case 'Typeface':
						var name = font.a;
						return A2(
							$elm$core$String$join,
							'-',
							$elm$core$String$words(
								$elm$core$String$toLower(name)));
					case 'ImportFont':
						var name = font.a;
						var url = font.b;
						return A2(
							$elm$core$String$join,
							'-',
							$elm$core$String$words(
								$elm$core$String$toLower(name)));
					default:
						var name = font.a.name;
						return A2(
							$elm$core$String$join,
							'-',
							$elm$core$String$words(
								$elm$core$String$toLower(name)));
				}
			}());
	});
var $mdgriffith$elm_ui$Element$Font$family = function (families) {
	return A2(
		$mdgriffith$elm_ui$Internal$Model$StyleClass,
		$mdgriffith$elm_ui$Internal$Flag$fontFamily,
		A2(
			$mdgriffith$elm_ui$Internal$Model$FontFamily,
			A3($elm$core$List$foldl, $mdgriffith$elm_ui$Internal$Model$renderFontClassName, 'ff-', families),
			families));
};
var $mdgriffith$elm_ui$Internal$Model$OnlyDynamic = F2(
	function (a, b) {
		return {$: 'OnlyDynamic', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Model$StaticRootAndDynamic = F2(
	function (a, b) {
		return {$: 'StaticRootAndDynamic', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Model$AllowHover = {$: 'AllowHover'};
var $mdgriffith$elm_ui$Internal$Model$Layout = {$: 'Layout'};
var $mdgriffith$elm_ui$Internal$Model$focusDefaultStyle = {
	backgroundColor: $elm$core$Maybe$Nothing,
	borderColor: $elm$core$Maybe$Nothing,
	shadow: $elm$core$Maybe$Just(
		{
			blur: 0,
			color: A4($mdgriffith$elm_ui$Internal$Model$Rgba, 155 / 255, 203 / 255, 1, 1),
			offset: _Utils_Tuple2(0, 0),
			size: 3
		})
};
var $mdgriffith$elm_ui$Internal$Model$optionsToRecord = function (options) {
	var combine = F2(
		function (opt, record) {
			switch (opt.$) {
				case 'HoverOption':
					var hoverable = opt.a;
					var _v4 = record.hover;
					if (_v4.$ === 'Nothing') {
						return _Utils_update(
							record,
							{
								hover: $elm$core$Maybe$Just(hoverable)
							});
					} else {
						return record;
					}
				case 'FocusStyleOption':
					var focusStyle = opt.a;
					var _v5 = record.focus;
					if (_v5.$ === 'Nothing') {
						return _Utils_update(
							record,
							{
								focus: $elm$core$Maybe$Just(focusStyle)
							});
					} else {
						return record;
					}
				default:
					var renderMode = opt.a;
					var _v6 = record.mode;
					if (_v6.$ === 'Nothing') {
						return _Utils_update(
							record,
							{
								mode: $elm$core$Maybe$Just(renderMode)
							});
					} else {
						return record;
					}
			}
		});
	var andFinally = function (record) {
		return {
			focus: function () {
				var _v0 = record.focus;
				if (_v0.$ === 'Nothing') {
					return $mdgriffith$elm_ui$Internal$Model$focusDefaultStyle;
				} else {
					var focusable = _v0.a;
					return focusable;
				}
			}(),
			hover: function () {
				var _v1 = record.hover;
				if (_v1.$ === 'Nothing') {
					return $mdgriffith$elm_ui$Internal$Model$AllowHover;
				} else {
					var hoverable = _v1.a;
					return hoverable;
				}
			}(),
			mode: function () {
				var _v2 = record.mode;
				if (_v2.$ === 'Nothing') {
					return $mdgriffith$elm_ui$Internal$Model$Layout;
				} else {
					var actualMode = _v2.a;
					return actualMode;
				}
			}()
		};
	};
	return andFinally(
		A3(
			$elm$core$List$foldr,
			combine,
			{focus: $elm$core$Maybe$Nothing, hover: $elm$core$Maybe$Nothing, mode: $elm$core$Maybe$Nothing},
			options));
};
var $mdgriffith$elm_ui$Internal$Model$toHtml = F2(
	function (mode, el) {
		switch (el.$) {
			case 'Unstyled':
				var html = el.a;
				return html($mdgriffith$elm_ui$Internal$Model$asEl);
			case 'Styled':
				var styles = el.a.styles;
				var html = el.a.html;
				return A2(
					html,
					mode(styles),
					$mdgriffith$elm_ui$Internal$Model$asEl);
			case 'Text':
				var text = el.a;
				return $mdgriffith$elm_ui$Internal$Model$textElement(text);
			default:
				return $mdgriffith$elm_ui$Internal$Model$textElement('');
		}
	});
var $mdgriffith$elm_ui$Internal$Model$renderRoot = F3(
	function (optionList, attributes, child) {
		var options = $mdgriffith$elm_ui$Internal$Model$optionsToRecord(optionList);
		var embedStyle = function () {
			var _v0 = options.mode;
			if (_v0.$ === 'NoStaticStyleSheet') {
				return $mdgriffith$elm_ui$Internal$Model$OnlyDynamic(options);
			} else {
				return $mdgriffith$elm_ui$Internal$Model$StaticRootAndDynamic(options);
			}
		}();
		return A2(
			$mdgriffith$elm_ui$Internal$Model$toHtml,
			embedStyle,
			A4(
				$mdgriffith$elm_ui$Internal$Model$element,
				$mdgriffith$elm_ui$Internal$Model$asEl,
				$mdgriffith$elm_ui$Internal$Model$div,
				attributes,
				$mdgriffith$elm_ui$Internal$Model$Unkeyed(
					_List_fromArray(
						[child]))));
	});
var $mdgriffith$elm_ui$Internal$Model$SansSerif = {$: 'SansSerif'};
var $mdgriffith$elm_ui$Internal$Model$Typeface = function (a) {
	return {$: 'Typeface', a: a};
};
var $mdgriffith$elm_ui$Internal$Flag$bgColor = $mdgriffith$elm_ui$Internal$Flag$flag(8);
var $mdgriffith$elm_ui$Internal$Model$rootStyle = function () {
	var families = _List_fromArray(
		[
			$mdgriffith$elm_ui$Internal$Model$Typeface('Open Sans'),
			$mdgriffith$elm_ui$Internal$Model$Typeface('Helvetica'),
			$mdgriffith$elm_ui$Internal$Model$Typeface('Verdana'),
			$mdgriffith$elm_ui$Internal$Model$SansSerif
		]);
	return _List_fromArray(
		[
			A2(
			$mdgriffith$elm_ui$Internal$Model$StyleClass,
			$mdgriffith$elm_ui$Internal$Flag$bgColor,
			A3(
				$mdgriffith$elm_ui$Internal$Model$Colored,
				'bg-' + $mdgriffith$elm_ui$Internal$Model$formatColorClass(
					A4($mdgriffith$elm_ui$Internal$Model$Rgba, 1, 1, 1, 0)),
				'background-color',
				A4($mdgriffith$elm_ui$Internal$Model$Rgba, 1, 1, 1, 0))),
			A2(
			$mdgriffith$elm_ui$Internal$Model$StyleClass,
			$mdgriffith$elm_ui$Internal$Flag$fontColor,
			A3(
				$mdgriffith$elm_ui$Internal$Model$Colored,
				'fc-' + $mdgriffith$elm_ui$Internal$Model$formatColorClass(
					A4($mdgriffith$elm_ui$Internal$Model$Rgba, 0, 0, 0, 1)),
				'color',
				A4($mdgriffith$elm_ui$Internal$Model$Rgba, 0, 0, 0, 1))),
			A2(
			$mdgriffith$elm_ui$Internal$Model$StyleClass,
			$mdgriffith$elm_ui$Internal$Flag$fontSize,
			$mdgriffith$elm_ui$Internal$Model$FontSize(20)),
			A2(
			$mdgriffith$elm_ui$Internal$Model$StyleClass,
			$mdgriffith$elm_ui$Internal$Flag$fontFamily,
			A2(
				$mdgriffith$elm_ui$Internal$Model$FontFamily,
				A3($elm$core$List$foldl, $mdgriffith$elm_ui$Internal$Model$renderFontClassName, 'font-', families),
				families))
		]);
}();
var $mdgriffith$elm_ui$Element$layoutWith = F3(
	function (_v0, attrs, child) {
		var options = _v0.options;
		return A3(
			$mdgriffith$elm_ui$Internal$Model$renderRoot,
			options,
			A2(
				$elm$core$List$cons,
				$mdgriffith$elm_ui$Internal$Model$htmlClass(
					A2(
						$elm$core$String$join,
						' ',
						_List_fromArray(
							[$mdgriffith$elm_ui$Internal$Style$classes.root, $mdgriffith$elm_ui$Internal$Style$classes.any, $mdgriffith$elm_ui$Internal$Style$classes.single]))),
				_Utils_ap($mdgriffith$elm_ui$Internal$Model$rootStyle, attrs)),
			child);
	});
var $mdgriffith$elm_ui$Element$layout = $mdgriffith$elm_ui$Element$layoutWith(
	{options: _List_Nil});
var $mdgriffith$elm_ui$Element$Font$sansSerif = $mdgriffith$elm_ui$Internal$Model$SansSerif;
var $elm$core$List$singleton = function (value) {
	return _List_fromArray(
		[value]);
};
var $mdgriffith$elm_ui$Element$Font$typeface = $mdgriffith$elm_ui$Internal$Model$Typeface;
var $author$project$Ui$Layout$view = F2(
	function (window, children) {
		return $elm$core$List$singleton(
			A2(
				$mdgriffith$elm_ui$Element$layout,
				_List_fromArray(
					[
						$mdgriffith$elm_ui$Element$width($mdgriffith$elm_ui$Element$fill),
						$mdgriffith$elm_ui$Element$Font$family(
						_List_fromArray(
							[
								$mdgriffith$elm_ui$Element$Font$typeface('IBM Plex Sans'),
								$mdgriffith$elm_ui$Element$Font$sansSerif
							]))
					]),
				A2(
					$mdgriffith$elm_ui$Element$column,
					_List_fromArray(
						[
							$mdgriffith$elm_ui$Element$width(
							A2($mdgriffith$elm_ui$Element$maximum, 1060, $mdgriffith$elm_ui$Element$fill)),
							$mdgriffith$elm_ui$Element$paddingEach(
							{bottom: 20, left: 30, right: 30, top: 30}),
							$mdgriffith$elm_ui$Element$centerX,
							$mdgriffith$elm_ui$Element$Font$size(12),
							$mdgriffith$elm_ui$Element$Font$color(
							A3($mdgriffith$elm_ui$Element$rgb255, 80, 80, 80))
						]),
					_Utils_ap(
						children,
						_List_fromArray(
							[
								$author$project$Ui$Layout$copyright(window)
							])))));
	});
var $author$project$Page$Administration$view = function (model) {
	return {
		body: A2(
			$author$project$Ui$Layout$view,
			model.window,
			_List_fromArray(
				[
					A2(
					$mdgriffith$elm_ui$Element$map,
					$author$project$Page$Administration$MenuMsg,
					A2($author$project$Ui$Menu$small, model.window, model.menu)),
					A2(
					$mdgriffith$elm_ui$Element$textColumn,
					_List_fromArray(
						[
							$mdgriffith$elm_ui$Element$width(
							A2($mdgriffith$elm_ui$Element$maximum, 600, $mdgriffith$elm_ui$Element$fill))
						]),
					_List_fromArray(
						[
							A2(
							$mdgriffith$elm_ui$Element$paragraph,
							_List_fromArray(
								[
									$mdgriffith$elm_ui$Element$Font$size(32),
									A2($mdgriffith$elm_ui$Element$paddingXY, 0, 20)
								]),
							_List_fromArray(
								[
									$mdgriffith$elm_ui$Element$text('Administration')
								])),
							A2(
							$mdgriffith$elm_ui$Element$paragraph,
							_List_fromArray(
								[
									A2($mdgriffith$elm_ui$Element$paddingXY, 0, 10),
									$mdgriffith$elm_ui$Element$Font$size(14)
								]),
							_List_fromArray(
								[
									$mdgriffith$elm_ui$Element$text('This library is managed by '),
									A2($author$project$Ui$Layout$link, 'https://twitter.com/tereza_sokol', 'Tereza Sokol'),
									$mdgriffith$elm_ui$Element$text(', with the support of various other contributors.')
								])),
							A2(
							$mdgriffith$elm_ui$Element$paragraph,
							_List_fromArray(
								[
									$mdgriffith$elm_ui$Element$Font$size(22),
									$mdgriffith$elm_ui$Element$paddingEach(
									{bottom: 5, left: 0, right: 0, top: 30})
								]),
							_List_fromArray(
								[
									$mdgriffith$elm_ui$Element$text('Contracting')
								])),
							A2(
							$mdgriffith$elm_ui$Element$paragraph,
							_List_fromArray(
								[
									A2($mdgriffith$elm_ui$Element$paddingXY, 0, 10),
									$mdgriffith$elm_ui$Element$Font$size(14)
								]),
							_List_fromArray(
								[
									$mdgriffith$elm_ui$Element$text('If you or your company would like me to build you a chart with elm-charts or add '),
									$mdgriffith$elm_ui$Element$text('a specific feature to the library, feel free to contact me at '),
									A2($author$project$Ui$Layout$link, 'mailto:terezasokol@gmail.com', 'terezasokol@gmail.com'),
									$mdgriffith$elm_ui$Element$text(' and we can figure out the details.')
								])),
							A2(
							$mdgriffith$elm_ui$Element$paragraph,
							_List_fromArray(
								[
									$mdgriffith$elm_ui$Element$Font$size(22),
									$mdgriffith$elm_ui$Element$paddingEach(
									{bottom: 5, left: 0, right: 0, top: 30})
								]),
							_List_fromArray(
								[
									$mdgriffith$elm_ui$Element$text('Roadmap')
								])),
							A2(
							$mdgriffith$elm_ui$Element$paragraph,
							_List_fromArray(
								[
									A2($mdgriffith$elm_ui$Element$paddingXY, 0, 10),
									$mdgriffith$elm_ui$Element$Font$size(14)
								]),
							_List_fromArray(
								[
									$mdgriffith$elm_ui$Element$text('Here are some upcoming features and improvements in approximate order of priority. '),
									$mdgriffith$elm_ui$Element$text('If you have more suggestions or have wishes regarding the priority, then '),
									$mdgriffith$elm_ui$Element$text('you\'re welcome to '),
									A2($author$project$Ui$Layout$link, 'https://github.com/terezka/charts/issues', 'open an issue'),
									$mdgriffith$elm_ui$Element$text(' or contact me directly.')
								])),
							A2(
							$mdgriffith$elm_ui$Element$el,
							_List_fromArray(
								[
									$mdgriffith$elm_ui$Element$Font$size(14)
								]),
							$mdgriffith$elm_ui$Element$html(
								function () {
									var item = function (text) {
										return A2(
											$elm$html$Html$li,
											_List_fromArray(
												[
													A2($elm$html$Html$Attributes$style, 'padding', '5px 0')
												]),
											_List_fromArray(
												[
													$elm$html$Html$text(text)
												]));
									};
									return A2(
										$elm$html$Html$ul,
										_List_fromArray(
											[
												A2($elm$html$Html$Attributes$style, 'padding-left', '25px')
											]),
										_List_fromArray(
											[
												item('Heat maps charts'),
												item('Horizontal bar charts'),
												item('Logarithmic scales'),
												item('Multiple scales'),
												item('Relative stacked bars'),
												item('Further improvements of automatic \"nice\" ticks'),
												item('Pie charts'),
												item('Confidence intervals'),
												item('More interpolation options'),
												item('Animations')
											]));
								}()))
						])),
					A2(
					$mdgriffith$elm_ui$Element$row,
					_List_fromArray(
						[
							$mdgriffith$elm_ui$Element$Font$size(14),
							A2($mdgriffith$elm_ui$Element$paddingXY, 0, 30),
							$mdgriffith$elm_ui$Element$spacing(20)
						]),
					_List_fromArray(
						[
							A2($author$project$Ui$Layout$link, 'https://github.com/terezka/charts', 'GitHub'),
							A2($author$project$Ui$Layout$link, 'https://twitter.com/tereza_sokol', 'Twitter'),
							A2($author$project$Ui$Layout$link, 'https://github.com/terezka/charts/issues', 'Report an issue'),
							A2($author$project$Ui$Layout$link, 'mailto:terezasokol@gmail.com', 'Contact')
						]))
				])),
		title: 'elm-charts'
	};
};
var $author$project$Page$Section$MenuMsg = function (a) {
	return {$: 'MenuMsg', a: a};
};
var $author$project$Page$Section$OnExampleMsg = function (a) {
	return {$: 'OnExampleMsg', a: a};
};
var $author$project$Ui$Layout$heading = F2(
	function (window, text) {
		return A2(
			$mdgriffith$elm_ui$Element$paragraph,
			_List_fromArray(
				[
					$mdgriffith$elm_ui$Element$Font$size(
					function () {
						var _v0 = $author$project$Ui$Layout$screen(window);
						switch (_v0.$) {
							case 'Large':
								return 32;
							case 'Medium':
								return 28;
							default:
								return 24;
						}
					}())
				]),
			_List_fromArray(
				[
					$mdgriffith$elm_ui$Element$text(text)
				]));
	});
var $mdgriffith$elm_ui$Internal$Model$Px = function (a) {
	return {$: 'Px', a: a};
};
var $mdgriffith$elm_ui$Element$px = $mdgriffith$elm_ui$Internal$Model$Px;
var $mdgriffith$elm_ui$Element$spacingXY = F2(
	function (x, y) {
		return A2(
			$mdgriffith$elm_ui$Internal$Model$StyleClass,
			$mdgriffith$elm_ui$Internal$Flag$spacing,
			A3(
				$mdgriffith$elm_ui$Internal$Model$SpacingStyle,
				A2($mdgriffith$elm_ui$Internal$Model$spacingName, x, y),
				x,
				y));
	});
var $author$project$Internal$Svg$End = {$: 'End'};
var $author$project$Chart$Attributes$alignRight = function (config) {
	return _Utils_update(
		config,
		{
			anchor: $elm$core$Maybe$Just($author$project$Internal$Svg$End)
		});
};
var $author$project$Internal$Property$Property = function (a) {
	return {$: 'Property', a: a};
};
var $author$project$Internal$Property$property = F3(
	function (value, inter, attrs) {
		return $author$project$Internal$Property$Property(
			{
				attrs: attrs,
				extra: F5(
					function (_v0, _v1, _v2, _v3, _v4) {
						return _List_Nil;
					}),
				format: A2(
					$elm$core$Basics$composeR,
					value,
					A2(
						$elm$core$Basics$composeR,
						$elm$core$Maybe$map($elm$core$String$fromFloat),
						$elm$core$Maybe$withDefault('N/A'))),
				inter: inter,
				meta: $elm$core$Maybe$Nothing,
				value: value,
				visual: value
			});
	});
var $author$project$Chart$bar = function (y) {
	return A2(
		$author$project$Internal$Property$property,
		A2($elm$core$Basics$composeR, y, $elm$core$Maybe$Just),
		_List_Nil);
};
var $author$project$Chart$BarsElement = F5(
	function (a, b, c, d, e) {
		return {$: 'BarsElement', a: a, b: b, c: c, d: d, e: e};
	});
var $author$project$Chart$Indexed = function (a) {
	return {$: 'Indexed', a: a};
};
var $author$project$Internal$Many$apply = F2(
	function (_v0, items) {
		var func = _v0.b;
		return func(items);
	});
var $author$project$Chart$Item$apply = $author$project$Internal$Many$apply;
var $author$project$Internal$Helpers$apply = F2(
	function (funcs, _default) {
		var apply_ = F2(
			function (f, a) {
				return f(a);
			});
		return A3($elm$core$List$foldl, apply_, _default, funcs);
	});
var $author$project$Internal$Many$Remodel = F2(
	function (a, b) {
		return {$: 'Remodel', a: a, b: b};
	});
var $author$project$Internal$Item$Rendered = function (a) {
	return {$: 'Rendered', a: a};
};
var $author$project$Internal$Many$editLimits = F2(
	function (edit, _v0) {
		var group_ = _v0.a;
		return $author$project$Internal$Item$Rendered(
			_Utils_update(
				group_,
				{
					toLimits: function (c) {
						return function (_v1) {
							var x = _v1.a;
							var xs = _v1.b;
							return A2(
								edit,
								x,
								group_.toLimits(c));
						}(c.items);
					}
				}));
	});
var $author$project$Internal$Item$getPosition = F2(
	function (plane, _v0) {
		var item = _v0.a;
		return A2(item.toPosition, plane, item.config);
	});
var $author$project$Internal$Item$getX1 = function (_v0) {
	var item = _v0.a;
	return item.config.values.x1;
};
var $author$project$Internal$Item$getX2 = function (_v0) {
	var item = _v0.a;
	return item.config.values.x2;
};
var $elm$core$List$partition = F2(
	function (pred, list) {
		var step = F2(
			function (x, _v0) {
				var trues = _v0.a;
				var falses = _v0.b;
				return pred(x) ? _Utils_Tuple2(
					A2($elm$core$List$cons, x, trues),
					falses) : _Utils_Tuple2(
					trues,
					A2($elm$core$List$cons, x, falses));
			});
		return A3(
			$elm$core$List$foldr,
			step,
			_Utils_Tuple2(_List_Nil, _List_Nil),
			list);
	});
var $author$project$Internal$Helpers$gatherWith = F2(
	function (testFn, list) {
		var helper = F2(
			function (scattered, gathered) {
				if (!scattered.b) {
					return $elm$core$List$reverse(gathered);
				} else {
					var toGather = scattered.a;
					var population = scattered.b;
					var _v1 = A2(
						$elm$core$List$partition,
						testFn(toGather),
						population);
					var gathering = _v1.a;
					var remaining = _v1.b;
					return A2(
						helper,
						remaining,
						A2(
							$elm$core$List$cons,
							_Utils_Tuple2(toGather, gathering),
							gathered));
				}
			});
		return A2(helper, list, _List_Nil);
	});
var $author$project$Internal$Coordinates$Position = F4(
	function (x1, x2, y1, y2) {
		return {x1: x1, x2: x2, y1: y1, y2: y2};
	});
var $author$project$Internal$Coordinates$foldPosition = F2(
	function (func, data) {
		var fold = F2(
			function (datum, posM) {
				if (posM.$ === 'Just') {
					var pos = posM.a;
					return $elm$core$Maybe$Just(
						{
							x1: A2(
								$elm$core$Basics$min,
								func(datum).x1,
								pos.x1),
							x2: A2(
								$elm$core$Basics$max,
								func(datum).x2,
								pos.x2),
							y1: A2(
								$elm$core$Basics$min,
								func(datum).y1,
								pos.y1),
							y2: A2(
								$elm$core$Basics$max,
								func(datum).y2,
								pos.y2)
						});
				} else {
					return $elm$core$Maybe$Just(
						func(datum));
				}
			});
		return A2(
			$elm$core$Maybe$withDefault,
			A4($author$project$Internal$Coordinates$Position, 0, 0, 0, 0),
			A3($elm$core$List$foldl, fold, $elm$core$Maybe$Nothing, data));
	});
var $elm$svg$Svg$g = $elm$svg$Svg$trustedNode('g');
var $author$project$Internal$Item$getLimits = function (_v0) {
	var item = _v0.a;
	return item.toLimits(item.config);
};
var $elm$html$Html$table = _VirtualDom_node('table');
var $author$project$Internal$Item$toHtml = function (_v0) {
	var item = _v0.a;
	return item.toHtml(item.config);
};
var $author$project$Internal$Item$toSvg = F2(
	function (plane, _v0) {
		var item = _v0.a;
		return A3(
			item.toSvg,
			plane,
			item.config,
			A2(item.toPosition, plane, item.config));
	});
var $author$project$Internal$Many$toGroup = F2(
	function (first, rest) {
		var concatTuple = function (_v1) {
			var x = _v1.a;
			var xs = _v1.b;
			return A2($elm$core$List$cons, x, xs);
		};
		return $author$project$Internal$Item$Rendered(
			{
				config: {
					items: _Utils_Tuple2(first, rest)
				},
				toHtml: function (c) {
					return _List_fromArray(
						[
							A2(
							$elm$html$Html$table,
							_List_Nil,
							A2(
								$elm$core$List$concatMap,
								$author$project$Internal$Item$toHtml,
								concatTuple(c.items)))
						]);
				},
				toLimits: function (c) {
					return A2(
						$author$project$Internal$Coordinates$foldPosition,
						$author$project$Internal$Item$getLimits,
						concatTuple(c.items));
				},
				toPosition: F2(
					function (p, c) {
						return A2(
							$author$project$Internal$Coordinates$foldPosition,
							$author$project$Internal$Item$getPosition(p),
							concatTuple(c.items));
					}),
				toSvg: F3(
					function (p, c, _v0) {
						return A2(
							$elm$svg$Svg$g,
							_List_fromArray(
								[
									$elm$svg$Svg$Attributes$class('elm-charts__group')
								]),
							A2(
								$elm$core$List$map,
								$author$project$Internal$Item$toSvg(p),
								concatTuple(c.items)));
					})
			});
	});
var $author$project$Internal$Many$groupingHelp = F2(
	function (_v0, items) {
		var shared = _v0.shared;
		var equality = _v0.equality;
		var edits = _v0.edits;
		var toShared = function (_v2) {
			var item = _v2.a;
			return shared(item.config);
		};
		var toNewGroup = function (_v1) {
			var i = _v1.a;
			var is = _v1.b;
			return edits(
				A2($author$project$Internal$Many$toGroup, i, is));
		};
		var toEquality = F2(
			function (aO, bO) {
				return A2(
					equality,
					toShared(aO),
					toShared(bO));
			});
		return A2(
			$elm$core$List$map,
			toNewGroup,
			A2($author$project$Internal$Helpers$gatherWith, toEquality, items));
	});
var $author$project$Internal$Many$bins = A2(
	$author$project$Internal$Many$Remodel,
	$author$project$Internal$Item$getPosition,
	$author$project$Internal$Many$groupingHelp(
		{
			edits: $author$project$Internal$Many$editLimits(
				F2(
					function (item, pos) {
						return _Utils_update(
							pos,
							{
								x1: $author$project$Internal$Item$getX1(item),
								x2: $author$project$Internal$Item$getX2(item)
							});
					})),
			equality: F2(
				function (a, b) {
					return _Utils_eq(a.x1, b.x1) && (_Utils_eq(a.x2, b.x2) && (_Utils_eq(a.elIndex, b.elIndex) && _Utils_eq(a.dataIndex, b.dataIndex)));
				}),
			shared: function (config) {
				return {dataIndex: config.tooltipInfo.data, elIndex: config.tooltipInfo.elIndex, x1: config.values.x1, x2: config.values.x2};
			}
		}));
var $author$project$Chart$Item$bins = $author$project$Internal$Many$bins;
var $author$project$Internal$Produce$defaultBars = {grid: false, grouped: true, margin: 0.1, roundBottom: 0, roundTop: 0, spacing: 0.05, x1: $elm$core$Maybe$Nothing, x2: $elm$core$Maybe$Nothing};
var $author$project$Internal$Item$generalize = F2(
	function (toAny, _v0) {
		var item = _v0.a;
		return $author$project$Internal$Item$Rendered(
			{
				config: {
					product: toAny(item.config.product),
					toAny: $elm$core$Basics$identity,
					tooltipInfo: item.config.tooltipInfo,
					values: item.config.values
				},
				toHtml: function (c) {
					return $author$project$Internal$Item$toHtml(
						$author$project$Internal$Item$Rendered(item));
				},
				toLimits: function (_v1) {
					return item.toLimits(item.config);
				},
				toPosition: F2(
					function (plane, _v2) {
						return A2(item.toPosition, plane, item.config);
					}),
				toSvg: F3(
					function (plane, _v3, _v4) {
						return A2(
							$author$project$Internal$Item$toSvg,
							plane,
							$author$project$Internal$Item$Rendered(item));
					})
			});
	});
var $author$project$Internal$Many$getMembers = function (_v0) {
	var group_ = _v0.a;
	return function (_v1) {
		var x = _v1.a;
		var xs = _v1.b;
		return A2($elm$core$List$cons, x, xs);
	}(group_.config.items);
};
var $author$project$Internal$Many$getGenerals = function (group_) {
	var generalize = function (_v0) {
		var item = _v0.a;
		return A2(
			$author$project$Internal$Item$generalize,
			item.config.toAny,
			$author$project$Internal$Item$Rendered(item));
	};
	return A2(
		$elm$core$List$map,
		generalize,
		$author$project$Internal$Many$getMembers(group_));
};
var $author$project$Chart$Item$getLimits = $author$project$Internal$Item$getLimits;
var $author$project$Internal$Item$map = F2(
	function (func, _v0) {
		var item = _v0.a;
		return $author$project$Internal$Item$Rendered(
			{
				config: {
					product: item.config.product,
					toAny: item.config.toAny,
					tooltipInfo: item.config.tooltipInfo,
					values: {
						datum: func(item.config.values.datum),
						isReal: item.config.values.isReal,
						x1: item.config.values.x1,
						x2: item.config.values.x2,
						y: item.config.values.y
					}
				},
				toHtml: function (_v1) {
					return $author$project$Internal$Item$toHtml(
						$author$project$Internal$Item$Rendered(item));
				},
				toLimits: function (_v2) {
					return item.toLimits(item.config);
				},
				toPosition: F2(
					function (plane, _v3) {
						return A2(item.toPosition, plane, item.config);
					}),
				toSvg: F3(
					function (plane, _v4, _v5) {
						return A2(
							$author$project$Internal$Item$toSvg,
							plane,
							$author$project$Internal$Item$Rendered(item));
					})
			});
	});
var $author$project$Internal$Legend$BarLegend = F2(
	function (a, b) {
		return {$: 'BarLegend', a: a, b: b};
	});
var $author$project$Chart$Attributes$border = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{border: v});
	});
var $author$project$Chart$Attributes$color = F2(
	function (v, config) {
		return (v === '') ? config : _Utils_update(
			config,
			{color: v});
	});
var $author$project$Internal$Helpers$pink = '#ea60df';
var $author$project$Internal$Svg$defaultBar = {attrs: _List_Nil, border: 'white', borderWidth: 0, color: $author$project$Internal$Helpers$pink, design: $elm$core$Maybe$Nothing, highlight: 0, highlightColor: '', highlightWidth: 10, opacity: 1, roundBottom: 0, roundTop: 0};
var $author$project$Chart$Attributes$roundBottom = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{roundBottom: v});
	});
var $author$project$Chart$Attributes$roundTop = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{roundTop: v});
	});
var $author$project$Internal$Property$toConfigs = function (prop) {
	if (prop.$ === 'Property') {
		var config = prop.a;
		return _List_fromArray(
			[config]);
	} else {
		var configs = prop.a;
		return configs;
	}
};
var $author$project$Internal$Helpers$blue = '#12A5ED';
var $author$project$Internal$Helpers$brown = '#871c1c';
var $author$project$Internal$Helpers$green = '#71c614';
var $author$project$Internal$Helpers$moss = '#92b42c';
var $author$project$Internal$Helpers$orange = '#FF8400';
var $author$project$Internal$Helpers$purple = '#7b4dff';
var $author$project$Internal$Helpers$red = '#F5325B';
var $elm$core$Tuple$pair = F2(
	function (a, b) {
		return _Utils_Tuple2(a, b);
	});
var $elm$core$Dict$sizeHelp = F2(
	function (n, dict) {
		sizeHelp:
		while (true) {
			if (dict.$ === 'RBEmpty_elm_builtin') {
				return n;
			} else {
				var left = dict.d;
				var right = dict.e;
				var $temp$n = A2($elm$core$Dict$sizeHelp, n + 1, right),
					$temp$dict = left;
				n = $temp$n;
				dict = $temp$dict;
				continue sizeHelp;
			}
		}
	});
var $elm$core$Dict$size = function (dict) {
	return A2($elm$core$Dict$sizeHelp, 0, dict);
};
var $author$project$Internal$Helpers$toDefault = F3(
	function (_default, items, index) {
		var dict = $elm$core$Dict$fromList(
			A2($elm$core$List$indexedMap, $elm$core$Tuple$pair, items));
		var numOfItems = $elm$core$Dict$size(dict);
		var itemIndex = index % numOfItems;
		return A2(
			$elm$core$Maybe$withDefault,
			_default,
			A2($elm$core$Dict$get, itemIndex, dict));
	});
var $author$project$Internal$Helpers$turquoise = '#22d2ba';
var $author$project$Internal$Helpers$yellow = '#FFCA00';
var $author$project$Internal$Helpers$toDefaultColor = A2(
	$author$project$Internal$Helpers$toDefault,
	$author$project$Internal$Helpers$pink,
	_List_fromArray(
		[$author$project$Internal$Helpers$purple, $author$project$Internal$Helpers$pink, $author$project$Internal$Helpers$blue, $author$project$Internal$Helpers$green, $author$project$Internal$Helpers$red, $author$project$Internal$Helpers$yellow, $author$project$Internal$Helpers$turquoise, $author$project$Internal$Helpers$orange, $author$project$Internal$Helpers$moss, $author$project$Internal$Helpers$brown]));
var $author$project$Internal$Legend$toBarLegends = F3(
	function (elIndex, barsAttrs, properties) {
		var toBarConfig = function (attrs) {
			return A2($author$project$Internal$Helpers$apply, attrs, $author$project$Internal$Svg$defaultBar);
		};
		var barsConfig = A2($author$project$Internal$Helpers$apply, barsAttrs, $author$project$Internal$Produce$defaultBars);
		var toBarLegend = F2(
			function (colorIndex, prop) {
				var rounding = A2($elm$core$Basics$max, barsConfig.roundTop, barsConfig.roundBottom);
				var defaultName = 'Property #' + $elm$core$String$fromInt(colorIndex + 1);
				var defaultColor = $author$project$Internal$Helpers$toDefaultColor(colorIndex);
				var defaultAttrs = _List_fromArray(
					[
						$author$project$Chart$Attributes$roundTop(rounding),
						$author$project$Chart$Attributes$roundBottom(rounding),
						$author$project$Chart$Attributes$color(defaultColor),
						$author$project$Chart$Attributes$border(defaultColor)
					]);
				var attrsOrg = _Utils_ap(defaultAttrs, prop.attrs);
				var productOrg = toBarConfig(attrsOrg);
				var attrs = _Utils_eq(productOrg.border, defaultColor) ? _Utils_ap(
					attrsOrg,
					_List_fromArray(
						[
							$author$project$Chart$Attributes$border(productOrg.color)
						])) : attrsOrg;
				return A2(
					$author$project$Internal$Legend$BarLegend,
					A2($elm$core$Maybe$withDefault, defaultName, prop.meta),
					attrs);
			});
		return A2(
			$elm$core$List$indexedMap,
			function (propIndex) {
				return toBarLegend(elIndex + propIndex);
			},
			A2($elm$core$List$concatMap, $author$project$Internal$Property$toConfigs, properties));
	});
var $author$project$Internal$Item$Bar = function (a) {
	return {$: 'Bar', a: a};
};
var $author$project$Internal$Commands$Arc = F7(
	function (a, b, c, d, e, f, g) {
		return {$: 'Arc', a: a, b: b, c: c, d: d, e: e, f: f, g: g};
	});
var $author$project$Internal$Commands$Line = F2(
	function (a, b) {
		return {$: 'Line', a: a, b: b};
	});
var $author$project$Internal$Commands$Move = F2(
	function (a, b) {
		return {$: 'Move', a: a, b: b};
	});
var $elm$core$Basics$abs = function (n) {
	return (n < 0) ? (-n) : n;
};
var $elm$core$Basics$clamp = F3(
	function (low, high, number) {
		return (_Utils_cmp(number, low) < 0) ? low : ((_Utils_cmp(number, high) > 0) ? high : number);
	});
var $author$project$Internal$Svg$clipperStyle = F2(
	function (plane, limits) {
		var topCut = ((plane.y.max - limits.y2) / $elm$core$Basics$abs(limits.y2 - limits.y1)) * 100;
		var rightCut = ((plane.x.max - limits.x2) / $elm$core$Basics$abs(limits.x2 - limits.x1)) * 100;
		var leftCut = ((plane.x.min - limits.x1) / $elm$core$Basics$abs(limits.x2 - limits.x1)) * 100;
		var bottomCut = ((plane.y.min - limits.y1) / $elm$core$Basics$abs(limits.y2 - limits.y1)) * 100;
		var path = A2(
			$elm$core$String$join,
			' ',
			_List_fromArray(
				[
					$elm$core$String$fromFloat(-topCut) + '%',
					$elm$core$String$fromFloat(-rightCut) + '%',
					$elm$core$String$fromFloat(bottomCut) + '%',
					$elm$core$String$fromFloat(leftCut) + '%'
				]));
		return 'clip-path: inset(' + (path + ');');
	});
var $elm$svg$Svg$Attributes$d = _VirtualDom_attribute('d');
var $author$project$Internal$Commands$joinCommands = function (commands) {
	return A2($elm$core$String$join, ' ', commands);
};
var $author$project$Internal$Commands$stringBoolInt = function (bool) {
	return bool ? '1' : '0';
};
var $author$project$Internal$Commands$stringPoint = function (_v0) {
	var x = _v0.a;
	var y = _v0.b;
	return $elm$core$String$fromFloat(x) + (' ' + $elm$core$String$fromFloat(y));
};
var $author$project$Internal$Commands$stringPoints = function (points) {
	return A2(
		$elm$core$String$join,
		',',
		A2($elm$core$List$map, $author$project$Internal$Commands$stringPoint, points));
};
var $author$project$Internal$Commands$stringCommand = function (command) {
	switch (command.$) {
		case 'Move':
			var x = command.a;
			var y = command.b;
			return 'M' + $author$project$Internal$Commands$stringPoint(
				_Utils_Tuple2(x, y));
		case 'Line':
			var x = command.a;
			var y = command.b;
			return 'L' + $author$project$Internal$Commands$stringPoint(
				_Utils_Tuple2(x, y));
		case 'CubicBeziers':
			var cx1 = command.a;
			var cy1 = command.b;
			var cx2 = command.c;
			var cy2 = command.d;
			var x = command.e;
			var y = command.f;
			return 'C' + $author$project$Internal$Commands$stringPoints(
				_List_fromArray(
					[
						_Utils_Tuple2(cx1, cy1),
						_Utils_Tuple2(cx2, cy2),
						_Utils_Tuple2(x, y)
					]));
		case 'CubicBeziersShort':
			var cx1 = command.a;
			var cy1 = command.b;
			var x = command.c;
			var y = command.d;
			return 'Q' + $author$project$Internal$Commands$stringPoints(
				_List_fromArray(
					[
						_Utils_Tuple2(cx1, cy1),
						_Utils_Tuple2(x, y)
					]));
		case 'QuadraticBeziers':
			var cx1 = command.a;
			var cy1 = command.b;
			var x = command.c;
			var y = command.d;
			return 'Q' + $author$project$Internal$Commands$stringPoints(
				_List_fromArray(
					[
						_Utils_Tuple2(cx1, cy1),
						_Utils_Tuple2(x, y)
					]));
		case 'QuadraticBeziersShort':
			var x = command.a;
			var y = command.b;
			return 'T' + $author$project$Internal$Commands$stringPoint(
				_Utils_Tuple2(x, y));
		case 'Arc':
			var rx = command.a;
			var ry = command.b;
			var xAxisRotation = command.c;
			var largeArcFlag = command.d;
			var sweepFlag = command.e;
			var x = command.f;
			var y = command.g;
			return 'A ' + $author$project$Internal$Commands$joinCommands(
				_List_fromArray(
					[
						$author$project$Internal$Commands$stringPoint(
						_Utils_Tuple2(rx, ry)),
						$elm$core$String$fromInt(xAxisRotation),
						$author$project$Internal$Commands$stringBoolInt(largeArcFlag),
						$author$project$Internal$Commands$stringBoolInt(sweepFlag),
						$author$project$Internal$Commands$stringPoint(
						_Utils_Tuple2(x, y))
					]));
		default:
			return 'Z';
	}
};
var $author$project$Internal$Commands$Close = {$: 'Close'};
var $author$project$Internal$Commands$CubicBeziers = F6(
	function (a, b, c, d, e, f) {
		return {$: 'CubicBeziers', a: a, b: b, c: c, d: d, e: e, f: f};
	});
var $author$project$Internal$Commands$CubicBeziersShort = F4(
	function (a, b, c, d) {
		return {$: 'CubicBeziersShort', a: a, b: b, c: c, d: d};
	});
var $author$project$Internal$Commands$QuadraticBeziers = F4(
	function (a, b, c, d) {
		return {$: 'QuadraticBeziers', a: a, b: b, c: c, d: d};
	});
var $author$project$Internal$Commands$QuadraticBeziersShort = F2(
	function (a, b) {
		return {$: 'QuadraticBeziersShort', a: a, b: b};
	});
var $author$project$Internal$Coordinates$innerLength = function (axis) {
	return A2($elm$core$Basics$max, 1, (axis.length - axis.marginMin) - axis.marginMax);
};
var $author$project$Internal$Coordinates$innerWidth = function (plane) {
	return $author$project$Internal$Coordinates$innerLength(plane.x);
};
var $author$project$Internal$Coordinates$range = function (axis) {
	var diff = axis.max - axis.min;
	return (diff > 0) ? diff : 1;
};
var $author$project$Internal$Coordinates$scaleSVGX = F2(
	function (plane, value) {
		return (value * $author$project$Internal$Coordinates$innerWidth(plane)) / $author$project$Internal$Coordinates$range(plane.x);
	});
var $author$project$Internal$Coordinates$toSVGX = F2(
	function (plane, value) {
		return A2($author$project$Internal$Coordinates$scaleSVGX, plane, value - plane.x.min) + plane.x.marginMin;
	});
var $author$project$Internal$Coordinates$innerHeight = function (plane) {
	return $author$project$Internal$Coordinates$innerLength(plane.y);
};
var $author$project$Internal$Coordinates$scaleSVGY = F2(
	function (plane, value) {
		return (value * $author$project$Internal$Coordinates$innerHeight(plane)) / $author$project$Internal$Coordinates$range(plane.y);
	});
var $author$project$Internal$Coordinates$toSVGY = F2(
	function (plane, value) {
		return A2($author$project$Internal$Coordinates$scaleSVGY, plane, plane.y.max - value) + plane.y.marginMin;
	});
var $author$project$Internal$Commands$translate = F2(
	function (plane, command) {
		switch (command.$) {
			case 'Move':
				var x = command.a;
				var y = command.b;
				return A2(
					$author$project$Internal$Commands$Move,
					A2($author$project$Internal$Coordinates$toSVGX, plane, x),
					A2($author$project$Internal$Coordinates$toSVGY, plane, y));
			case 'Line':
				var x = command.a;
				var y = command.b;
				return A2(
					$author$project$Internal$Commands$Line,
					A2($author$project$Internal$Coordinates$toSVGX, plane, x),
					A2($author$project$Internal$Coordinates$toSVGY, plane, y));
			case 'CubicBeziers':
				var cx1 = command.a;
				var cy1 = command.b;
				var cx2 = command.c;
				var cy2 = command.d;
				var x = command.e;
				var y = command.f;
				return A6(
					$author$project$Internal$Commands$CubicBeziers,
					A2($author$project$Internal$Coordinates$toSVGX, plane, cx1),
					A2($author$project$Internal$Coordinates$toSVGY, plane, cy1),
					A2($author$project$Internal$Coordinates$toSVGX, plane, cx2),
					A2($author$project$Internal$Coordinates$toSVGY, plane, cy2),
					A2($author$project$Internal$Coordinates$toSVGX, plane, x),
					A2($author$project$Internal$Coordinates$toSVGY, plane, y));
			case 'CubicBeziersShort':
				var cx1 = command.a;
				var cy1 = command.b;
				var x = command.c;
				var y = command.d;
				return A4(
					$author$project$Internal$Commands$CubicBeziersShort,
					A2($author$project$Internal$Coordinates$toSVGX, plane, cx1),
					A2($author$project$Internal$Coordinates$toSVGY, plane, cy1),
					A2($author$project$Internal$Coordinates$toSVGX, plane, x),
					A2($author$project$Internal$Coordinates$toSVGY, plane, y));
			case 'QuadraticBeziers':
				var cx1 = command.a;
				var cy1 = command.b;
				var x = command.c;
				var y = command.d;
				return A4(
					$author$project$Internal$Commands$QuadraticBeziers,
					A2($author$project$Internal$Coordinates$toSVGX, plane, cx1),
					A2($author$project$Internal$Coordinates$toSVGY, plane, cy1),
					A2($author$project$Internal$Coordinates$toSVGX, plane, x),
					A2($author$project$Internal$Coordinates$toSVGY, plane, y));
			case 'QuadraticBeziersShort':
				var x = command.a;
				var y = command.b;
				return A2(
					$author$project$Internal$Commands$QuadraticBeziersShort,
					A2($author$project$Internal$Coordinates$toSVGX, plane, x),
					A2($author$project$Internal$Coordinates$toSVGY, plane, y));
			case 'Arc':
				var rx = command.a;
				var ry = command.b;
				var xAxisRotation = command.c;
				var largeArcFlag = command.d;
				var sweepFlag = command.e;
				var x = command.f;
				var y = command.g;
				return A7(
					$author$project$Internal$Commands$Arc,
					rx,
					ry,
					xAxisRotation,
					largeArcFlag,
					sweepFlag,
					A2($author$project$Internal$Coordinates$toSVGX, plane, x),
					A2($author$project$Internal$Coordinates$toSVGY, plane, y));
			default:
				return $author$project$Internal$Commands$Close;
		}
	});
var $author$project$Internal$Commands$description = F2(
	function (plane, commands) {
		return $author$project$Internal$Commands$joinCommands(
			A2(
				$elm$core$List$map,
				A2(
					$elm$core$Basics$composeR,
					$author$project$Internal$Commands$translate(plane),
					$author$project$Internal$Commands$stringCommand),
				commands));
	});
var $elm$svg$Svg$Attributes$fillOpacity = _VirtualDom_attribute('fill-opacity');
var $elm$svg$Svg$path = $elm$svg$Svg$trustedNode('path');
var $author$project$Internal$Coordinates$scaleCartesianX = F2(
	function (plane, value) {
		return (value * $author$project$Internal$Coordinates$range(plane.x)) / $author$project$Internal$Coordinates$innerWidth(plane);
	});
var $author$project$Internal$Coordinates$scaleCartesianY = F2(
	function (plane, value) {
		return (value * $author$project$Internal$Coordinates$range(plane.y)) / $author$project$Internal$Coordinates$innerHeight(plane);
	});
var $elm$svg$Svg$Attributes$strokeOpacity = _VirtualDom_attribute('stroke-opacity');
var $elm$svg$Svg$Attributes$style = _VirtualDom_attribute('style');
var $author$project$Internal$Svg$apply = F2(
	function (funcs, _default) {
		var apply_ = F2(
			function (f, a) {
				return f(a);
			});
		return A3($elm$core$List$foldl, apply_, _default, funcs);
	});
var $elm$svg$Svg$circle = $elm$svg$Svg$trustedNode('circle');
var $elm$svg$Svg$Attributes$cx = _VirtualDom_attribute('cx');
var $elm$svg$Svg$Attributes$cy = _VirtualDom_attribute('cy');
var $elm$svg$Svg$defs = $elm$svg$Svg$trustedNode('defs');
var $elm$svg$Svg$Attributes$id = _VirtualDom_attribute('id');
var $elm$svg$Svg$linearGradient = $elm$svg$Svg$trustedNode('linearGradient');
var $elm$svg$Svg$Attributes$offset = _VirtualDom_attribute('offset');
var $elm$svg$Svg$pattern = $elm$svg$Svg$trustedNode('pattern');
var $elm$svg$Svg$Attributes$patternTransform = _VirtualDom_attribute('patternTransform');
var $elm$svg$Svg$Attributes$patternUnits = _VirtualDom_attribute('patternUnits');
var $elm$svg$Svg$Attributes$r = _VirtualDom_attribute('r');
var $elm$svg$Svg$stop = $elm$svg$Svg$trustedNode('stop');
var $elm$svg$Svg$Attributes$stopColor = _VirtualDom_attribute('stop-color');
var $elm$svg$Svg$Attributes$y = _VirtualDom_attribute('y');
var $author$project$Internal$Svg$toPattern = F2(
	function (defaultColor, design) {
		var toPatternId = function (props) {
			return A3(
				$elm$core$String$replace,
				'(',
				'-',
				A3(
					$elm$core$String$replace,
					')',
					'-',
					A3(
						$elm$core$String$replace,
						'.',
						'-',
						A3(
							$elm$core$String$replace,
							',',
							'-',
							A3(
								$elm$core$String$replace,
								' ',
								'-',
								A2(
									$elm$core$String$join,
									'-',
									_Utils_ap(
										_List_fromArray(
											[
												'elm-charts__pattern',
												function () {
												switch (design.$) {
													case 'Striped':
														return 'striped';
													case 'Dotted':
														return 'dotted';
													default:
														return 'gradient';
												}
											}()
											]),
										props)))))));
		};
		var toPatternDefs = F4(
			function (id, spacing, rotate, inside) {
				return A2(
					$elm$svg$Svg$defs,
					_List_Nil,
					_List_fromArray(
						[
							A2(
							$elm$svg$Svg$pattern,
							_List_fromArray(
								[
									$elm$svg$Svg$Attributes$id(id),
									$elm$svg$Svg$Attributes$patternUnits('userSpaceOnUse'),
									$elm$svg$Svg$Attributes$width(
									$elm$core$String$fromFloat(spacing)),
									$elm$svg$Svg$Attributes$height(
									$elm$core$String$fromFloat(spacing)),
									$elm$svg$Svg$Attributes$patternTransform(
									'rotate(' + ($elm$core$String$fromFloat(rotate) + ')'))
								]),
							_List_fromArray(
								[inside]))
						]));
			});
		var _v0 = function () {
			switch (design.$) {
				case 'Striped':
					var edits = design.a;
					var config = A2(
						$author$project$Internal$Svg$apply,
						edits,
						{color: defaultColor, rotate: 45, spacing: 4, width: 3});
					var theId = toPatternId(
						_List_fromArray(
							[
								config.color,
								$elm$core$String$fromFloat(config.width),
								$elm$core$String$fromFloat(config.spacing),
								$elm$core$String$fromFloat(config.rotate)
							]));
					return _Utils_Tuple2(
						A4(
							toPatternDefs,
							theId,
							config.spacing,
							config.rotate,
							A2(
								$elm$svg$Svg$line,
								_List_fromArray(
									[
										$elm$svg$Svg$Attributes$x1('0'),
										$elm$svg$Svg$Attributes$y('0'),
										$elm$svg$Svg$Attributes$x2('0'),
										$elm$svg$Svg$Attributes$y2(
										$elm$core$String$fromFloat(config.spacing)),
										$elm$svg$Svg$Attributes$stroke(config.color),
										$elm$svg$Svg$Attributes$strokeWidth(
										$elm$core$String$fromFloat(config.width))
									]),
								_List_Nil)),
						theId);
				case 'Dotted':
					var edits = design.a;
					var config = A2(
						$author$project$Internal$Svg$apply,
						edits,
						{color: defaultColor, rotate: 45, spacing: 4, width: 3});
					var theId = toPatternId(
						_List_fromArray(
							[
								config.color,
								$elm$core$String$fromFloat(config.width),
								$elm$core$String$fromFloat(config.spacing),
								$elm$core$String$fromFloat(config.rotate)
							]));
					return _Utils_Tuple2(
						A4(
							toPatternDefs,
							theId,
							config.spacing,
							config.rotate,
							A2(
								$elm$svg$Svg$circle,
								_List_fromArray(
									[
										$elm$svg$Svg$Attributes$fill(config.color),
										$elm$svg$Svg$Attributes$cx(
										$elm$core$String$fromFloat(config.width / 3)),
										$elm$svg$Svg$Attributes$cy(
										$elm$core$String$fromFloat(config.width / 3)),
										$elm$svg$Svg$Attributes$r(
										$elm$core$String$fromFloat(config.width / 3))
									]),
								_List_Nil)),
						theId);
				default:
					var edits = design.a;
					var colors = _Utils_eq(edits, _List_Nil) ? _List_fromArray(
						[defaultColor, 'white']) : edits;
					var theId = toPatternId(colors);
					var totalColors = $elm$core$List$length(colors);
					var toPercentage = function (i) {
						return (i * 100) / (totalColors - 1);
					};
					var toStop = F2(
						function (i, c) {
							return A2(
								$elm$svg$Svg$stop,
								_List_fromArray(
									[
										$elm$svg$Svg$Attributes$offset(
										$elm$core$String$fromFloat(
											toPercentage(i)) + '%'),
										$elm$svg$Svg$Attributes$stopColor(c)
									]),
								_List_Nil);
						});
					return _Utils_Tuple2(
						A2(
							$elm$svg$Svg$defs,
							_List_Nil,
							_List_fromArray(
								[
									A2(
									$elm$svg$Svg$linearGradient,
									_List_fromArray(
										[
											$elm$svg$Svg$Attributes$id(theId),
											$elm$svg$Svg$Attributes$x1('0'),
											$elm$svg$Svg$Attributes$x2('0'),
											$elm$svg$Svg$Attributes$y1('0'),
											$elm$svg$Svg$Attributes$y2('1')
										]),
									A2($elm$core$List$indexedMap, toStop, colors))
								])),
						theId);
			}
		}();
		var patternDefs = _v0.a;
		var patternId = _v0.b;
		return _Utils_Tuple2(patternDefs, 'url(#' + (patternId + ')'));
	});
var $elm$virtual_dom$VirtualDom$mapAttribute = _VirtualDom_mapAttribute;
var $elm$html$Html$Attributes$map = $elm$virtual_dom$VirtualDom$mapAttribute;
var $author$project$Internal$Svg$withAttrs = F3(
	function (attrs, toEl, defaultAttrs) {
		return toEl(
			_Utils_ap(
				defaultAttrs,
				A2(
					$elm$core$List$map,
					$elm$html$Html$Attributes$map($elm$core$Basics$never),
					attrs)));
	});
var $author$project$Internal$Svg$bar = F3(
	function (plane, config, point) {
		var viewBar = F7(
			function (fill, fillOpacity, border, borderWidth, strokeOpacity, cmds, limits) {
				return A4(
					$author$project$Internal$Svg$withAttrs,
					config.attrs,
					$elm$svg$Svg$path,
					_List_fromArray(
						[
							$elm$svg$Svg$Attributes$class('elm-charts__bar'),
							$elm$svg$Svg$Attributes$fill(fill),
							$elm$svg$Svg$Attributes$fillOpacity(
							$elm$core$String$fromFloat(fillOpacity)),
							$elm$svg$Svg$Attributes$stroke(border),
							$elm$svg$Svg$Attributes$strokeWidth(
							$elm$core$String$fromFloat(borderWidth)),
							$elm$svg$Svg$Attributes$strokeOpacity(
							$elm$core$String$fromFloat(strokeOpacity)),
							$elm$svg$Svg$Attributes$d(
							A2($author$project$Internal$Commands$description, plane, cmds)),
							$elm$svg$Svg$Attributes$style(
							A2($author$project$Internal$Svg$clipperStyle, plane, limits))
						]),
					_List_Nil);
			});
		var highlightColor = (config.highlightColor === '') ? config.color : config.highlightColor;
		var borderWidthCarY = A2($author$project$Internal$Coordinates$scaleCartesianY, plane, config.borderWidth / 2);
		var highlightWidthCarY = borderWidthCarY + A2($author$project$Internal$Coordinates$scaleCartesianY, plane, config.highlightWidth / 2);
		var borderWidthCarX = A2($author$project$Internal$Coordinates$scaleCartesianX, plane, config.borderWidth / 2);
		var highlightWidthCarX = borderWidthCarX + A2($author$project$Internal$Coordinates$scaleCartesianX, plane, config.highlightWidth / 2);
		var pos = {
			x1: A2($elm$core$Basics$min, point.x1, point.x2) + borderWidthCarX,
			x2: A2($elm$core$Basics$max, point.x1, point.x2) - borderWidthCarX,
			y1: A2($elm$core$Basics$min, point.y1, point.y2) + borderWidthCarY,
			y2: A2($elm$core$Basics$max, point.y1, point.y2) - borderWidthCarY
		};
		var height = $elm$core$Basics$abs(pos.y2 - pos.y1);
		var highlightPos = {x1: pos.x1 - highlightWidthCarX, x2: pos.x2 + highlightWidthCarX, y1: pos.y1 - highlightWidthCarY, y2: pos.y2 + highlightWidthCarY};
		var width = $elm$core$Basics$abs(pos.x2 - pos.x1);
		var roundingBottom = (A2($author$project$Internal$Coordinates$scaleSVGX, plane, width) * 0.5) * A3($elm$core$Basics$clamp, 0, 1, config.roundBottom);
		var radiusBottomX = A2($author$project$Internal$Coordinates$scaleCartesianX, plane, roundingBottom);
		var radiusBottomY = A2($author$project$Internal$Coordinates$scaleCartesianY, plane, roundingBottom);
		var roundingTop = (A2($author$project$Internal$Coordinates$scaleSVGX, plane, width) * 0.5) * A3($elm$core$Basics$clamp, 0, 1, config.roundTop);
		var radiusTopX = A2($author$project$Internal$Coordinates$scaleCartesianX, plane, roundingTop);
		var radiusTopY = A2($author$project$Internal$Coordinates$scaleCartesianY, plane, roundingTop);
		var _v0 = ((((height - (radiusTopY * 0.8)) - (radiusBottomY * 0.8)) <= 0) || (((width - (radiusTopX * 0.8)) - (radiusBottomX * 0.8)) <= 0)) ? _Utils_Tuple2(0, 0) : _Utils_Tuple2(config.roundTop, config.roundBottom);
		var roundTop = _v0.a;
		var roundBottom = _v0.b;
		var _v1 = function () {
			if (_Utils_eq(pos.y1, pos.y2)) {
				return _Utils_Tuple3(_List_Nil, _List_Nil, highlightPos);
			} else {
				var _v2 = _Utils_Tuple2(roundTop > 0, roundBottom > 0);
				if (!_v2.a) {
					if (!_v2.b) {
						return _Utils_Tuple3(
							_List_fromArray(
								[
									A2($author$project$Internal$Commands$Move, pos.x1, pos.y1),
									A2($author$project$Internal$Commands$Line, pos.x1, pos.y2),
									A2($author$project$Internal$Commands$Line, pos.x2, pos.y2),
									A2($author$project$Internal$Commands$Line, pos.x2, pos.y1),
									A2($author$project$Internal$Commands$Line, pos.x1, pos.y1)
								]),
							_List_fromArray(
								[
									A2($author$project$Internal$Commands$Move, highlightPos.x1, pos.y1),
									A2($author$project$Internal$Commands$Line, highlightPos.x1, highlightPos.y2),
									A2($author$project$Internal$Commands$Line, highlightPos.x2, highlightPos.y2),
									A2($author$project$Internal$Commands$Line, highlightPos.x2, pos.y1),
									A2($author$project$Internal$Commands$Line, pos.x2, pos.y1),
									A2($author$project$Internal$Commands$Line, pos.x2, pos.y2),
									A2($author$project$Internal$Commands$Line, pos.x1, pos.y2),
									A2($author$project$Internal$Commands$Line, pos.x1, pos.y1)
								]),
							{x1: pos.x1 - highlightWidthCarX, x2: pos.x2 + highlightWidthCarX, y1: pos.y1, y2: pos.y2 + highlightWidthCarY});
					} else {
						return _Utils_Tuple3(
							_List_fromArray(
								[
									A2($author$project$Internal$Commands$Move, pos.x1 + radiusBottomX, pos.y1),
									A7($author$project$Internal$Commands$Arc, roundingBottom, roundingBottom, -45, false, true, pos.x1, pos.y1 + radiusBottomY),
									A2($author$project$Internal$Commands$Line, pos.x1, pos.y2),
									A2($author$project$Internal$Commands$Line, pos.x2, pos.y2),
									A2($author$project$Internal$Commands$Line, pos.x2, pos.y1 + radiusBottomY),
									A7($author$project$Internal$Commands$Arc, roundingBottom, roundingBottom, -45, false, true, pos.x2 - radiusBottomX, pos.y1),
									A2($author$project$Internal$Commands$Line, pos.x1 + radiusBottomX, pos.y1)
								]),
							_List_fromArray(
								[
									A2($author$project$Internal$Commands$Move, highlightPos.x1 + radiusBottomX, highlightPos.y1),
									A7($author$project$Internal$Commands$Arc, roundingBottom, roundingBottom, -45, false, true, highlightPos.x1, highlightPos.y1 + radiusBottomY),
									A2($author$project$Internal$Commands$Line, highlightPos.x1, highlightPos.y2),
									A2($author$project$Internal$Commands$Line, highlightPos.x2, highlightPos.y2),
									A2($author$project$Internal$Commands$Line, highlightPos.x2, highlightPos.y1 + radiusBottomY),
									A7($author$project$Internal$Commands$Arc, roundingBottom, roundingBottom, -45, false, true, highlightPos.x2 - radiusBottomX, highlightPos.y1),
									A2($author$project$Internal$Commands$Line, highlightPos.x1 + radiusBottomX, highlightPos.y1),
									A2($author$project$Internal$Commands$Line, pos.x2 - radiusBottomX, pos.y1),
									A7($author$project$Internal$Commands$Arc, roundingBottom, roundingBottom, -45, false, false, pos.x2, pos.y1 + radiusBottomY),
									A2($author$project$Internal$Commands$Line, pos.x2, pos.y2),
									A2($author$project$Internal$Commands$Line, pos.x1, pos.y2),
									A2($author$project$Internal$Commands$Line, pos.x1, pos.y1 + radiusBottomY),
									A2($author$project$Internal$Commands$Line, pos.x2, pos.y1)
								]),
							{x1: pos.x1 - highlightWidthCarX, x2: pos.x2 + highlightWidthCarX, y1: pos.y1 - highlightWidthCarY, y2: pos.y2 + highlightWidthCarY});
					}
				} else {
					if (!_v2.b) {
						return _Utils_Tuple3(
							_List_fromArray(
								[
									A2($author$project$Internal$Commands$Move, pos.x1, pos.y1),
									A2($author$project$Internal$Commands$Line, pos.x1, pos.y2 - radiusTopY),
									A7($author$project$Internal$Commands$Arc, roundingTop, roundingTop, -45, false, true, pos.x1 + radiusTopX, pos.y2),
									A2($author$project$Internal$Commands$Line, pos.x2 - radiusTopX, pos.y2),
									A7($author$project$Internal$Commands$Arc, roundingTop, roundingTop, -45, false, true, pos.x2, pos.y2 - radiusTopY),
									A2($author$project$Internal$Commands$Line, pos.x2, pos.y1),
									A2($author$project$Internal$Commands$Line, pos.x1, pos.y1)
								]),
							_List_fromArray(
								[
									A2($author$project$Internal$Commands$Move, highlightPos.x1, pos.y1),
									A2($author$project$Internal$Commands$Line, highlightPos.x1, highlightPos.y2 - radiusTopY),
									A7($author$project$Internal$Commands$Arc, roundingTop, roundingTop, -45, false, true, highlightPos.x1 + radiusTopX, highlightPos.y2),
									A2($author$project$Internal$Commands$Line, highlightPos.x2 - radiusTopX, highlightPos.y2),
									A7($author$project$Internal$Commands$Arc, roundingTop, roundingTop, -45, false, true, highlightPos.x2, highlightPos.y2 - radiusTopY),
									A2($author$project$Internal$Commands$Line, highlightPos.x2, pos.y1),
									A2($author$project$Internal$Commands$Line, pos.x2, pos.y1),
									A2($author$project$Internal$Commands$Line, pos.x2, pos.y2 - radiusTopY),
									A7($author$project$Internal$Commands$Arc, roundingTop, roundingTop, -45, false, false, pos.x2 - radiusTopX, pos.y2),
									A2($author$project$Internal$Commands$Line, pos.x1 + radiusTopX, pos.y2),
									A7($author$project$Internal$Commands$Arc, roundingTop, roundingTop, -45, false, false, pos.x1, pos.y2 - radiusTopY),
									A2($author$project$Internal$Commands$Line, pos.x1, pos.y1)
								]),
							{x1: pos.x1 - highlightWidthCarX, x2: pos.x2 + highlightWidthCarX, y1: pos.y1, y2: pos.y2 + highlightWidthCarY});
					} else {
						return _Utils_Tuple3(
							_List_fromArray(
								[
									A2($author$project$Internal$Commands$Move, pos.x1 + radiusBottomX, pos.y1),
									A7($author$project$Internal$Commands$Arc, roundingBottom, roundingBottom, -45, false, true, pos.x1, pos.y1 + radiusBottomY),
									A2($author$project$Internal$Commands$Line, pos.x1, pos.y2 - radiusTopY),
									A7($author$project$Internal$Commands$Arc, roundingTop, roundingTop, -45, false, true, pos.x1 + radiusTopX, pos.y2),
									A2($author$project$Internal$Commands$Line, pos.x2 - radiusTopX, pos.y2),
									A7($author$project$Internal$Commands$Arc, roundingTop, roundingTop, -45, false, true, pos.x2, pos.y2 - radiusTopY),
									A2($author$project$Internal$Commands$Line, pos.x2, pos.y1 + radiusBottomY),
									A7($author$project$Internal$Commands$Arc, roundingBottom, roundingBottom, -45, false, true, pos.x2 - radiusBottomX, pos.y1),
									A2($author$project$Internal$Commands$Line, pos.x1 + radiusBottomX, pos.y1)
								]),
							_List_fromArray(
								[
									A2($author$project$Internal$Commands$Move, highlightPos.x1 + radiusBottomX, highlightPos.y1),
									A7($author$project$Internal$Commands$Arc, roundingBottom, roundingBottom, -45, false, true, highlightPos.x1, highlightPos.y1 + radiusBottomY),
									A2($author$project$Internal$Commands$Line, highlightPos.x1, highlightPos.y2 - radiusTopY),
									A7($author$project$Internal$Commands$Arc, roundingTop, roundingTop, -45, false, true, highlightPos.x1 + radiusTopX, highlightPos.y2),
									A2($author$project$Internal$Commands$Line, highlightPos.x2 - radiusTopX, highlightPos.y2),
									A7($author$project$Internal$Commands$Arc, roundingTop, roundingTop, -45, false, true, highlightPos.x2, highlightPos.y2 - radiusTopY),
									A2($author$project$Internal$Commands$Line, highlightPos.x2, highlightPos.y1 + radiusBottomY),
									A7($author$project$Internal$Commands$Arc, roundingBottom, roundingBottom, -45, false, true, highlightPos.x2 - radiusBottomX, highlightPos.y1),
									A2($author$project$Internal$Commands$Line, highlightPos.x1 + radiusBottomX, highlightPos.y1),
									A2($author$project$Internal$Commands$Line, pos.x2 - radiusBottomX, pos.y1),
									A7($author$project$Internal$Commands$Arc, roundingBottom, roundingBottom, -45, false, false, pos.x2, pos.y1 + radiusBottomY),
									A2($author$project$Internal$Commands$Line, pos.x2, pos.y2 - radiusTopY),
									A7($author$project$Internal$Commands$Arc, roundingTop, roundingTop, -45, false, false, pos.x2 - radiusTopX, pos.y2),
									A2($author$project$Internal$Commands$Line, pos.x1 + radiusTopX, pos.y2),
									A7($author$project$Internal$Commands$Arc, roundingTop, roundingTop, -45, false, false, pos.x1, pos.y2 - radiusTopY),
									A2($author$project$Internal$Commands$Line, pos.x1, pos.y1 + radiusBottomY),
									A2($author$project$Internal$Commands$Line, pos.x2, pos.y1)
								]),
							{x1: pos.x1 - highlightWidthCarX, x2: pos.x2 + highlightWidthCarX, y1: pos.y1 - highlightWidthCarY, y2: pos.y2 + highlightWidthCarY});
					}
				}
			}
		}();
		var commands = _v1.a;
		var highlightCommands = _v1.b;
		var highlightCut = _v1.c;
		var viewAuraBar = function (fill) {
			return (!config.highlight) ? A7(viewBar, fill, config.opacity, config.border, config.borderWidth, 1, commands, pos) : A2(
				$elm$svg$Svg$g,
				_List_fromArray(
					[
						$elm$svg$Svg$Attributes$class('elm-charts__bar-with-highlight')
					]),
				_List_fromArray(
					[
						A7(viewBar, highlightColor, config.highlight, 'transparent', 0, 0, highlightCommands, highlightCut),
						A7(viewBar, fill, config.opacity, config.border, config.borderWidth, 1, commands, pos)
					]));
		};
		var _v3 = config.design;
		if (_v3.$ === 'Nothing') {
			return viewAuraBar(config.color);
		} else {
			var design = _v3.a;
			var _v4 = A2($author$project$Internal$Svg$toPattern, config.color, design);
			var patternDefs = _v4.a;
			var fill = _v4.b;
			return A2(
				$elm$svg$Svg$g,
				_List_fromArray(
					[
						$elm$svg$Svg$Attributes$class('elm-charts__bar-with-pattern')
					]),
				_List_fromArray(
					[
						patternDefs,
						viewAuraBar(fill)
					]));
		}
	});
var $author$project$Internal$Produce$toDefaultName = F2(
	function (index, name) {
		return A2(
			$elm$core$Maybe$withDefault,
			'Property #' + $elm$core$String$fromInt(index + 1),
			name);
	});
var $elm$html$Html$td = _VirtualDom_node('td');
var $elm$html$Html$tr = _VirtualDom_node('tr');
var $author$project$Internal$Produce$tooltipRow = F3(
	function (color, title, text) {
		return A2(
			$elm$html$Html$tr,
			_List_Nil,
			_List_fromArray(
				[
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							A2($elm$html$Html$Attributes$style, 'color', color),
							A2($elm$html$Html$Attributes$style, 'padding', '0'),
							A2($elm$html$Html$Attributes$style, 'padding-right', '3px')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(title + ':')
						])),
					A2(
					$elm$html$Html$td,
					_List_fromArray(
						[
							A2($elm$html$Html$Attributes$style, 'text-align', 'right'),
							A2($elm$html$Html$Attributes$style, 'padding', '0')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(text)
						]))
				]));
	});
var $author$project$Internal$Helpers$withSurround = F2(
	function (all, func) {
		var fold = F4(
			function (index, prev, acc, list) {
				fold:
				while (true) {
					if (list.b) {
						if (list.b.b) {
							var a = list.a;
							var _v1 = list.b;
							var b = _v1.a;
							var rest = _v1.b;
							var $temp$index = index + 1,
								$temp$prev = $elm$core$Maybe$Just(a),
								$temp$acc = _Utils_ap(
								acc,
								_List_fromArray(
									[
										A4(
										func,
										index,
										prev,
										a,
										$elm$core$Maybe$Just(b))
									])),
								$temp$list = A2($elm$core$List$cons, b, rest);
							index = $temp$index;
							prev = $temp$prev;
							acc = $temp$acc;
							list = $temp$list;
							continue fold;
						} else {
							var a = list.a;
							return _Utils_ap(
								acc,
								_List_fromArray(
									[
										A4(func, index, prev, a, $elm$core$Maybe$Nothing)
									]));
						}
					} else {
						return acc;
					}
				}
			});
		return A4(fold, 0, $elm$core$Maybe$Nothing, _List_Nil, all);
	});
var $author$project$Internal$Produce$toBarSeries = F4(
	function (elIndex, barsAttrs, properties, data) {
		var toBarConfig = function (attrs) {
			return A2($author$project$Internal$Helpers$apply, attrs, $author$project$Internal$Svg$defaultBar);
		};
		var barsConfig = A2($author$project$Internal$Helpers$apply, barsAttrs, $author$project$Internal$Produce$defaultBars);
		var toBarItem = F7(
			function (sections, barIndex, sectionIndex, section, colorIndex, dataIndex, bin) {
				var visual = section.visual(bin.datum);
				var value = section.value(bin.datum);
				var start = bin.start;
				var numOfSections = $elm$core$List$length(sections);
				var numOfBars = barsConfig.grouped ? $elm$core$List$length(properties) : 1;
				var minY = (numOfSections > 1) ? $elm$core$Basics$max(0) : $elm$core$Basics$identity;
				var y1 = minY(
					A2($elm$core$Maybe$withDefault, 0, visual) - A2($elm$core$Maybe$withDefault, 0, value));
				var y2 = minY(
					A2($elm$core$Maybe$withDefault, 0, visual));
				var isSingle = numOfSections === 1;
				var isLast = _Utils_eq(sectionIndex, numOfSections - 1);
				var roundTop = (isSingle || isLast) ? barsConfig.roundTop : 0;
				var isFirst = !sectionIndex;
				var roundBottom = (isSingle || isFirst) ? barsConfig.roundBottom : 0;
				var end = bin.end;
				var length = end - start;
				var margin = length * barsConfig.margin;
				var spacing = length * barsConfig.spacing;
				var width = ((length - (margin * 2)) - ((numOfBars - 1) * spacing)) / numOfBars;
				var offset = barsConfig.grouped ? ((barIndex * width) + (barIndex * spacing)) : 0;
				var x1 = (start + margin) + offset;
				var x2 = ((start + margin) + offset) + width;
				var defaultColor = $author$project$Internal$Helpers$toDefaultColor(colorIndex);
				var defaultAttrs = _List_fromArray(
					[
						$author$project$Chart$Attributes$roundTop(roundTop),
						$author$project$Chart$Attributes$roundBottom(roundBottom),
						$author$project$Chart$Attributes$color(defaultColor),
						$author$project$Chart$Attributes$border(defaultColor)
					]);
				var attrs = _Utils_ap(
					defaultAttrs,
					_Utils_ap(
						section.attrs,
						A5(section.extra, barIndex, sectionIndex, dataIndex, section.meta, bin.datum)));
				var productOrg = toBarConfig(attrs);
				var product = function (p) {
					return _Utils_eq(p.border, defaultColor) ? _Utils_update(
						p,
						{border: p.color}) : p;
				}(
					function (p) {
						var _v21 = p.design;
						if (((_v21.$ === 'Just') && (_v21.a.$ === 'Gradient')) && _v21.a.a.b) {
							var _v22 = _v21.a.a;
							var color = _v22.a;
							return _Utils_eq(p.color, defaultColor) ? _Utils_update(
								p,
								{color: color}) : p;
						} else {
							return p;
						}
					}(productOrg));
				return $author$project$Internal$Item$Rendered(
					{
						config: {
							product: product,
							toAny: $author$project$Internal$Item$Bar,
							tooltipInfo: {
								border: product.border,
								borderWidth: product.borderWidth,
								color: product.color,
								data: dataIndex,
								elIndex: elIndex,
								formatted: section.format(bin.datum),
								index: colorIndex,
								name: section.meta,
								property: barIndex,
								stack: sectionIndex
							},
							values: {
								datum: bin.datum,
								isReal: function () {
									if (value.$ === 'Just') {
										return true;
									} else {
										return false;
									}
								}(),
								x1: start,
								x2: end,
								y: A2($elm$core$Maybe$withDefault, 0, value)
							}
						},
						toHtml: function (c) {
							return _List_fromArray(
								[
									A3(
									$author$project$Internal$Produce$tooltipRow,
									c.tooltipInfo.color,
									A2($author$project$Internal$Produce$toDefaultName, colorIndex, c.tooltipInfo.name),
									section.format(bin.datum))
								]);
						},
						toLimits: function (config) {
							return {
								x1: x1,
								x2: x2,
								y1: A2($elm$core$Basics$min, y1, y2),
								y2: A2($elm$core$Basics$max, y1, y2)
							};
						},
						toPosition: F2(
							function (_v20, config) {
								return {x1: x1, x2: x2, y1: y1, y2: y2};
							}),
						toSvg: F3(
							function (plane, config, position) {
								return A3($author$project$Internal$Svg$bar, plane, product, position);
							})
					});
			});
		var toSeriesItem = F6(
			function (bins, sections, barIndex, sectionIndex, section, colorIndex) {
				var _v13 = A2(
					$elm$core$List$indexedMap,
					A5(toBarItem, sections, barIndex, sectionIndex, section, colorIndex),
					bins);
				if (!_v13.b) {
					return $elm$core$Maybe$Nothing;
				} else {
					var first = _v13.a;
					var rest = _v13.b;
					return $elm$core$Maybe$Just(
						$author$project$Internal$Item$Rendered(
							{
								config: {
									items: _Utils_Tuple2(first, rest)
								},
								toHtml: function (c) {
									return _List_fromArray(
										[
											A2(
											$elm$html$Html$table,
											_List_fromArray(
												[
													A2($elm$html$Html$Attributes$style, 'margin', '0')
												]),
											A2(
												$elm$core$List$concatMap,
												$author$project$Internal$Item$toHtml,
												function (_v14) {
													var x = _v14.a;
													var xs = _v14.b;
													return A2($elm$core$List$cons, x, xs);
												}(c.items)))
										]);
								},
								toLimits: function (c) {
									return A2(
										$author$project$Internal$Coordinates$foldPosition,
										$author$project$Internal$Item$getLimits,
										function (_v15) {
											var x = _v15.a;
											var xs = _v15.b;
											return A2($elm$core$List$cons, x, xs);
										}(c.items));
								},
								toPosition: F2(
									function (plane, c) {
										return A2(
											$author$project$Internal$Coordinates$foldPosition,
											$author$project$Internal$Item$getPosition(plane),
											function (_v16) {
												var x = _v16.a;
												var xs = _v16.b;
												return A2($elm$core$List$cons, x, xs);
											}(c.items));
									}),
								toSvg: F3(
									function (plane, c, _v17) {
										return A2(
											$elm$svg$Svg$g,
											_List_fromArray(
												[
													$elm$svg$Svg$Attributes$class('elm-charts__bar-series')
												]),
											A2(
												$elm$core$List$map,
												$author$project$Internal$Item$toSvg(plane),
												function (_v18) {
													var x = _v18.a;
													var xs = _v18.b;
													return A2($elm$core$List$cons, x, xs);
												}(c.items)));
									})
							}));
				}
			});
		var toBin = F4(
			function (index, prevM, curr, nextM) {
				var _v0 = _Utils_Tuple2(barsConfig.x1, barsConfig.x2);
				if (_v0.a.$ === 'Nothing') {
					if (_v0.b.$ === 'Nothing') {
						var _v1 = _v0.a;
						var _v2 = _v0.b;
						return {datum: curr, end: (index + 1) + 0.5, start: (index + 1) - 0.5};
					} else {
						var _v8 = _v0.a;
						var toEnd = _v0.b.a;
						var _v9 = _Utils_Tuple2(prevM, nextM);
						if (_v9.a.$ === 'Just') {
							var prev = _v9.a.a;
							return {
								datum: curr,
								end: toEnd(curr),
								start: toEnd(prev)
							};
						} else {
							if (_v9.b.$ === 'Just') {
								var _v10 = _v9.a;
								var next = _v9.b.a;
								return {
									datum: curr,
									end: toEnd(curr),
									start: toEnd(curr) - (toEnd(next) - toEnd(curr))
								};
							} else {
								var _v11 = _v9.a;
								var _v12 = _v9.b;
								return {
									datum: curr,
									end: toEnd(curr),
									start: toEnd(curr) - 1
								};
							}
						}
					}
				} else {
					if (_v0.b.$ === 'Nothing') {
						var toStart = _v0.a.a;
						var _v3 = _v0.b;
						var _v4 = _Utils_Tuple2(prevM, nextM);
						if (_v4.b.$ === 'Just') {
							var next = _v4.b.a;
							return {
								datum: curr,
								end: toStart(next),
								start: toStart(curr)
							};
						} else {
							if (_v4.a.$ === 'Just') {
								var prev = _v4.a.a;
								var _v5 = _v4.b;
								return {
									datum: curr,
									end: toStart(curr) + (toStart(curr) - toStart(prev)),
									start: toStart(curr)
								};
							} else {
								var _v6 = _v4.a;
								var _v7 = _v4.b;
								return {
									datum: curr,
									end: toStart(curr) + 1,
									start: toStart(curr)
								};
							}
						}
					} else {
						var toStart = _v0.a.a;
						var toEnd = _v0.b.a;
						return {
							datum: curr,
							end: toEnd(curr),
							start: toStart(curr)
						};
					}
				}
			});
		return function (bins) {
			return A2(
				$elm$core$List$filterMap,
				$elm$core$Basics$identity,
				A2(
					$elm$core$List$indexedMap,
					F2(
						function (propIndex, f) {
							return f(elIndex + propIndex);
						}),
					$elm$core$List$concat(
						A2(
							$elm$core$List$indexedMap,
							F2(
								function (barIndex, stacks) {
									return A2(
										$elm$core$List$indexedMap,
										A3(toSeriesItem, bins, stacks, barIndex),
										$elm$core$List$reverse(stacks));
								}),
							A2($elm$core$List$map, $author$project$Internal$Property$toConfigs, properties)))));
		}(
			A2($author$project$Internal$Helpers$withSurround, data, toBin));
	});
var $author$project$Chart$barsMap = F4(
	function (mapData, edits, properties, data) {
		return $author$project$Chart$Indexed(
			function (index) {
				var legends_ = A3($author$project$Internal$Legend$toBarLegends, index, edits, properties);
				var items = A4($author$project$Internal$Produce$toBarSeries, index, edits, properties, data);
				var generalized = A2(
					$elm$core$List$map,
					$author$project$Internal$Item$map(mapData),
					A2($elm$core$List$concatMap, $author$project$Internal$Many$getGenerals, items));
				var bins = A2($author$project$Chart$Item$apply, $author$project$Chart$Item$bins, generalized);
				var toLimits = A2($elm$core$List$map, $author$project$Internal$Item$getLimits, bins);
				var barsConfig = A2($author$project$Internal$Helpers$apply, edits, $author$project$Internal$Produce$defaultBars);
				var toTicks = F2(
					function (plane, acc) {
						return _Utils_update(
							acc,
							{
								xs: _Utils_ap(
									acc.xs,
									barsConfig.grid ? A2(
										$elm$core$List$concatMap,
										A2(
											$elm$core$Basics$composeR,
											$author$project$Chart$Item$getLimits,
											function (pos) {
												return _List_fromArray(
													[pos.x1, pos.x2]);
											}),
										bins) : _List_Nil)
							});
					});
				return _Utils_Tuple2(
					A5(
						$author$project$Chart$BarsElement,
						toLimits,
						generalized,
						legends_,
						toTicks,
						function (plane) {
							return A2(
								$elm$svg$Svg$map,
								$elm$core$Basics$never,
								A2(
									$elm$svg$Svg$g,
									_List_fromArray(
										[
											$elm$svg$Svg$Attributes$class('elm-charts__bar-series')
										]),
									A2(
										$elm$core$List$map,
										$author$project$Internal$Item$toSvg(plane),
										items)));
						}),
					index + $elm$core$List$length(
						A2($elm$core$List$concatMap, $author$project$Internal$Property$toConfigs, properties)));
			});
	});
var $author$project$Chart$bars = F3(
	function (edits, properties, data) {
		return A4($author$project$Chart$barsMap, $elm$core$Basics$identity, edits, properties, data);
	});
var $author$project$Internal$Many$andThen = F2(
	function (_v0, _v1) {
		var toPos2 = _v0.a;
		var func2 = _v0.b;
		var toPos1 = _v1.a;
		var func1 = _v1.b;
		return A2(
			$author$project$Internal$Many$Remodel,
			toPos2,
			function (items) {
				return func2(
					func1(items));
			});
	});
var $author$project$Chart$Item$andThen = $author$project$Internal$Many$andThen;
var $author$project$Internal$Item$isBar = function (_v0) {
	var item = _v0.a;
	var _v1 = item.config.product;
	if (_v1.$ === 'Bar') {
		var bar = _v1.a;
		return $elm$core$Maybe$Just(
			$author$project$Internal$Item$Rendered(
				{
					config: {product: bar, toAny: $author$project$Internal$Item$Bar, tooltipInfo: item.config.tooltipInfo, values: item.config.values},
					toHtml: function (c) {
						return item.toHtml(item.config);
					},
					toLimits: function (_v2) {
						return item.toLimits(item.config);
					},
					toPosition: F2(
						function (plane, _v3) {
							return A2(item.toPosition, plane, item.config);
						}),
					toSvg: F2(
						function (plane, config) {
							return A2($author$project$Internal$Svg$bar, plane, config.product);
						})
				}));
	} else {
		return $elm$core$Maybe$Nothing;
	}
};
var $author$project$Internal$Many$bars = A2(
	$author$project$Internal$Many$Remodel,
	$author$project$Internal$Item$getPosition,
	$elm$core$List$filterMap($author$project$Internal$Item$isBar));
var $author$project$Chart$Item$bars = $author$project$Internal$Many$bars;
var $author$project$Internal$Svg$defaultLabel = {anchor: $elm$core$Maybe$Nothing, attrs: _List_Nil, border: 'white', borderWidth: 0, color: '#808BAB', ellipsis: $elm$core$Maybe$Nothing, fontSize: $elm$core$Maybe$Nothing, rotate: 0, uppercase: false, xOff: 0, yOff: 0};
var $author$project$Internal$Coordinates$bottom = function (pos) {
	return {x: pos.x1 + ((pos.x2 - pos.x1) / 2), y: pos.y1};
};
var $author$project$Chart$Item$getBottom = function (p) {
	return A2(
		$elm$core$Basics$composeR,
		$author$project$Internal$Item$getPosition(p),
		$author$project$Internal$Coordinates$bottom);
};
var $author$project$Chart$defaultLabel = {anchor: $author$project$Internal$Svg$defaultLabel.anchor, attrs: $author$project$Internal$Svg$defaultLabel.attrs, border: $author$project$Internal$Svg$defaultLabel.border, borderWidth: $author$project$Internal$Svg$defaultLabel.borderWidth, color: $author$project$Internal$Svg$defaultLabel.color, ellipsis: $author$project$Internal$Svg$defaultLabel.ellipsis, fontSize: $author$project$Internal$Svg$defaultLabel.fontSize, format: $elm$core$Maybe$Nothing, position: $author$project$Chart$Item$getBottom, rotate: $author$project$Internal$Svg$defaultLabel.rotate, uppercase: $author$project$Internal$Svg$defaultLabel.uppercase, xOff: $author$project$Internal$Svg$defaultLabel.xOff, yOff: $author$project$Internal$Svg$defaultLabel.yOff};
var $author$project$Chart$SubElements = function (a) {
	return {$: 'SubElements', a: a};
};
var $author$project$Chart$eachCustom = F2(
	function (grouping, func) {
		return $author$project$Chart$SubElements(
			F2(
				function (p, items) {
					var processed = A2($author$project$Chart$Item$apply, grouping, items);
					return A2(
						$elm$core$List$concatMap,
						func(p),
						processed);
				}));
	});
var $author$project$Internal$Item$getDatum = function (_v0) {
	var item = _v0.a;
	return item.config.values.datum;
};
var $author$project$Internal$Many$getData = function (_v0) {
	var group_ = _v0.a;
	return function (_v1) {
		var x = _v1.a;
		var xs = _v1.b;
		return $author$project$Internal$Item$getDatum(x);
	}(group_.config.items);
};
var $author$project$Chart$Item$getOneData = $author$project$Internal$Many$getData;
var $elm$html$Html$Attributes$attribute = $elm$virtual_dom$VirtualDom$attribute;
var $elm$svg$Svg$foreignObject = $elm$svg$Svg$trustedNode('foreignObject');
var $elm$svg$Svg$Attributes$transform = _VirtualDom_attribute('transform');
var $author$project$Internal$Svg$position = F6(
	function (plane, rotation, x_, y_, xOff_, yOff_) {
		return $elm$svg$Svg$Attributes$transform(
			'translate(' + ($elm$core$String$fromFloat(
				A2($author$project$Internal$Coordinates$toSVGX, plane, x_) + xOff_) + (',' + ($elm$core$String$fromFloat(
				A2($author$project$Internal$Coordinates$toSVGY, plane, y_) + yOff_) + (') rotate(' + ($elm$core$String$fromFloat(rotation) + ')'))))));
	});
var $elm$svg$Svg$text_ = $elm$svg$Svg$trustedNode('text');
var $elm$svg$Svg$tspan = $elm$svg$Svg$trustedNode('tspan');
var $author$project$Internal$Svg$label = F4(
	function (plane, config, inner, point) {
		var _v0 = config.ellipsis;
		if (_v0.$ === 'Nothing') {
			var uppercaseStyle = config.uppercase ? 'text-transform: uppercase;' : '';
			var fontStyle = function () {
				var _v5 = config.fontSize;
				if (_v5.$ === 'Just') {
					var size_ = _v5.a;
					return 'font-size: ' + ($elm$core$String$fromInt(size_) + 'px;');
				} else {
					return '';
				}
			}();
			var anchorStyle = function () {
				var _v1 = config.anchor;
				if (_v1.$ === 'Nothing') {
					return 'text-anchor: middle;';
				} else {
					switch (_v1.a.$) {
						case 'End':
							var _v2 = _v1.a;
							return 'text-anchor: end;';
						case 'Start':
							var _v3 = _v1.a;
							return 'text-anchor: start;';
						default:
							var _v4 = _v1.a;
							return 'text-anchor: middle;';
					}
				}
			}();
			return A4(
				$author$project$Internal$Svg$withAttrs,
				config.attrs,
				$elm$svg$Svg$text_,
				_List_fromArray(
					[
						$elm$svg$Svg$Attributes$class('elm-charts__label'),
						$elm$svg$Svg$Attributes$stroke(config.border),
						$elm$svg$Svg$Attributes$strokeWidth(
						$elm$core$String$fromFloat(config.borderWidth)),
						$elm$svg$Svg$Attributes$fill(config.color),
						A6($author$project$Internal$Svg$position, plane, -config.rotate, point.x, point.y, config.xOff, config.yOff),
						$elm$svg$Svg$Attributes$style(
						A2(
							$elm$core$String$join,
							' ',
							_List_fromArray(
								['pointer-events: none;', fontStyle, anchorStyle, uppercaseStyle])))
					]),
				_List_fromArray(
					[
						A2($elm$svg$Svg$tspan, _List_Nil, inner)
					]));
		} else {
			var ellipsis = _v0.a;
			var xOffWithAnchor = function () {
				var _v11 = config.anchor;
				if (_v11.$ === 'Nothing') {
					return config.xOff - (ellipsis.width / 2);
				} else {
					switch (_v11.a.$) {
						case 'End':
							var _v12 = _v11.a;
							return config.xOff - ellipsis.width;
						case 'Start':
							var _v13 = _v11.a;
							return config.xOff;
						default:
							var _v14 = _v11.a;
							return config.xOff - (ellipsis.width / 2);
					}
				}
			}();
			var uppercaseStyle = config.uppercase ? A2($elm$html$Html$Attributes$style, 'text-transform', 'uppercase') : A2($elm$html$Html$Attributes$style, '', '');
			var fontStyle = function () {
				var _v10 = config.fontSize;
				if (_v10.$ === 'Just') {
					var size_ = _v10.a;
					return A2(
						$elm$html$Html$Attributes$style,
						'font-size',
						$elm$core$String$fromInt(size_) + 'px');
				} else {
					return A2($elm$html$Html$Attributes$style, '', '');
				}
			}();
			var anchorStyle = function () {
				var _v6 = config.anchor;
				if (_v6.$ === 'Nothing') {
					return A2($elm$html$Html$Attributes$style, 'text-align', 'center');
				} else {
					switch (_v6.a.$) {
						case 'End':
							var _v7 = _v6.a;
							return A2($elm$html$Html$Attributes$style, 'text-align', 'right');
						case 'Start':
							var _v8 = _v6.a;
							return A2($elm$html$Html$Attributes$style, 'text-align', 'left');
						default:
							var _v9 = _v6.a;
							return A2($elm$html$Html$Attributes$style, 'text-align', 'center');
					}
				}
			}();
			return A4(
				$author$project$Internal$Svg$withAttrs,
				config.attrs,
				$elm$svg$Svg$foreignObject,
				_List_fromArray(
					[
						$elm$svg$Svg$Attributes$class('elm-charts__label'),
						$elm$svg$Svg$Attributes$class('elm-charts__html-label'),
						$elm$svg$Svg$Attributes$width(
						$elm$core$String$fromFloat(ellipsis.width)),
						$elm$svg$Svg$Attributes$height(
						$elm$core$String$fromFloat(ellipsis.height)),
						A6($author$project$Internal$Svg$position, plane, -config.rotate, point.x, point.y, xOffWithAnchor, config.yOff - 10)
					]),
				_List_fromArray(
					[
						A2(
						$elm$html$Html$div,
						_List_fromArray(
							[
								A2($elm$html$Html$Attributes$attribute, 'xmlns', 'http://www.w3.org/1999/xhtml'),
								A2($elm$html$Html$Attributes$style, 'white-space', 'nowrap'),
								A2($elm$html$Html$Attributes$style, 'overflow', 'hidden'),
								A2($elm$html$Html$Attributes$style, 'text-overflow', 'ellipsis'),
								A2($elm$html$Html$Attributes$style, 'height', '100%'),
								A2($elm$html$Html$Attributes$style, 'pointer-events', 'none'),
								A2($elm$html$Html$Attributes$style, 'color', config.color),
								fontStyle,
								uppercaseStyle,
								anchorStyle
							]),
						inner)
					]));
		}
	});
var $author$project$Chart$SvgElement = function (a) {
	return {$: 'SvgElement', a: a};
};
var $author$project$Chart$svg = function (func) {
	return $author$project$Chart$SvgElement(
		function (p) {
			return func(p);
		});
};
var $elm$svg$Svg$text = $elm$virtual_dom$VirtualDom$text;
var $author$project$Chart$toLabelFromItemLabel = function (config) {
	return {anchor: config.anchor, attrs: config.attrs, border: config.border, borderWidth: config.borderWidth, color: config.color, ellipsis: config.ellipsis, fontSize: config.fontSize, rotate: config.rotate, uppercase: config.uppercase, xOff: config.xOff, yOff: config.yOff};
};
var $author$project$Chart$binLabels = F2(
	function (toLabel, edits) {
		return A2(
			$author$project$Chart$eachCustom,
			A2($author$project$Chart$Item$andThen, $author$project$Chart$Item$bins, $author$project$Chart$Item$bars),
			F2(
				function (p, item) {
					var config = A2($author$project$Internal$Helpers$apply, edits, $author$project$Chart$defaultLabel);
					var text = function () {
						var _v1 = config.format;
						if (_v1.$ === 'Just') {
							var formatting = _v1.a;
							return formatting(item);
						} else {
							return toLabel(
								$author$project$Chart$Item$getOneData(item));
						}
					}();
					return _List_fromArray(
						[
							$author$project$Chart$svg(
							function (_v0) {
								return A4(
									$author$project$Internal$Svg$label,
									p,
									$author$project$Chart$toLabelFromItemLabel(config),
									_List_fromArray(
										[
											$elm$svg$Svg$text(text)
										]),
									A2(config.position, p, item));
							})
						]);
				}));
	});
var $author$project$Chart$Attributes$borderWidth = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{borderWidth: v});
	});
var $author$project$Chart$Attributes$break = function (config) {
	return _Utils_update(
		config,
		{_break: true});
};
var $author$project$Internal$Svg$Event = F2(
	function (name, handler) {
		return {handler: handler, name: name};
	});
var $elm$json$Json$Decode$map3 = _Json_map3;
var $elm$json$Json$Decode$float = _Json_decodeFloat;
var $debois$elm_dom$DOM$offsetHeight = A2($elm$json$Json$Decode$field, 'offsetHeight', $elm$json$Json$Decode$float);
var $debois$elm_dom$DOM$offsetWidth = A2($elm$json$Json$Decode$field, 'offsetWidth', $elm$json$Json$Decode$float);
var $elm$json$Json$Decode$map4 = _Json_map4;
var $debois$elm_dom$DOM$offsetLeft = A2($elm$json$Json$Decode$field, 'offsetLeft', $elm$json$Json$Decode$float);
var $elm$json$Json$Decode$null = _Json_decodeNull;
var $elm$json$Json$Decode$oneOf = _Json_oneOf;
var $debois$elm_dom$DOM$offsetParent = F2(
	function (x, decoder) {
		return $elm$json$Json$Decode$oneOf(
			_List_fromArray(
				[
					A2(
					$elm$json$Json$Decode$field,
					'offsetParent',
					$elm$json$Json$Decode$null(x)),
					A2($elm$json$Json$Decode$field, 'offsetParent', decoder)
				]));
	});
var $debois$elm_dom$DOM$offsetTop = A2($elm$json$Json$Decode$field, 'offsetTop', $elm$json$Json$Decode$float);
var $debois$elm_dom$DOM$scrollLeft = A2($elm$json$Json$Decode$field, 'scrollLeft', $elm$json$Json$Decode$float);
var $debois$elm_dom$DOM$scrollTop = A2($elm$json$Json$Decode$field, 'scrollTop', $elm$json$Json$Decode$float);
var $debois$elm_dom$DOM$position = F2(
	function (x, y) {
		return A2(
			$elm$json$Json$Decode$andThen,
			function (_v0) {
				var x_ = _v0.a;
				var y_ = _v0.b;
				return A2(
					$debois$elm_dom$DOM$offsetParent,
					_Utils_Tuple2(x_, y_),
					A2($debois$elm_dom$DOM$position, x_, y_));
			},
			A5(
				$elm$json$Json$Decode$map4,
				F4(
					function (scrollLeftP, scrollTopP, offsetLeftP, offsetTopP) {
						return _Utils_Tuple2((x + offsetLeftP) - scrollLeftP, (y + offsetTopP) - scrollTopP);
					}),
				$debois$elm_dom$DOM$scrollLeft,
				$debois$elm_dom$DOM$scrollTop,
				$debois$elm_dom$DOM$offsetLeft,
				$debois$elm_dom$DOM$offsetTop));
	});
var $debois$elm_dom$DOM$boundingClientRect = A4(
	$elm$json$Json$Decode$map3,
	F3(
		function (_v0, width, height) {
			var x = _v0.a;
			var y = _v0.b;
			return {height: height, left: x, top: y, width: width};
		}),
	A2($debois$elm_dom$DOM$position, 0, 0),
	$debois$elm_dom$DOM$offsetWidth,
	$debois$elm_dom$DOM$offsetHeight);
var $elm$json$Json$Decode$lazy = function (thunk) {
	return A2(
		$elm$json$Json$Decode$andThen,
		thunk,
		$elm$json$Json$Decode$succeed(_Utils_Tuple0));
};
var $debois$elm_dom$DOM$parentElement = function (decoder) {
	return A2($elm$json$Json$Decode$field, 'parentElement', decoder);
};
function $author$project$Internal$Svg$cyclic$decodePosition() {
	return $elm$json$Json$Decode$oneOf(
		_List_fromArray(
			[
				$debois$elm_dom$DOM$boundingClientRect,
				$elm$json$Json$Decode$lazy(
				function (_v0) {
					return $debois$elm_dom$DOM$parentElement(
						$author$project$Internal$Svg$cyclic$decodePosition());
				})
			]));
}
try {
	var $author$project$Internal$Svg$decodePosition = $author$project$Internal$Svg$cyclic$decodePosition();
	$author$project$Internal$Svg$cyclic$decodePosition = function () {
		return $author$project$Internal$Svg$decodePosition;
	};
} catch ($) {
	throw 'Some top-level definitions from `Internal.Svg` are causing infinite recursion:\n\n  ┌─────┐\n  │    decodePosition\n  └─────┘\n\nThese errors are very tricky, so read https://elm-lang.org/0.19.1/bad-recursion to learn how to fix it!';}
var $author$project$Internal$Coordinates$toCartesianX = F2(
	function (plane, value) {
		return A2($author$project$Internal$Coordinates$scaleCartesianX, plane, value - plane.x.marginMin) + plane.x.min;
	});
var $author$project$Internal$Coordinates$toCartesianY = F2(
	function (plane, value) {
		return ($author$project$Internal$Coordinates$range(plane.y) - A2($author$project$Internal$Coordinates$scaleCartesianY, plane, value - plane.y.marginMin)) + plane.y.min;
	});
var $author$project$Internal$Svg$fromSvg = F2(
	function (plane, point) {
		return {
			x: A2($author$project$Internal$Coordinates$toCartesianX, plane, point.x),
			y: A2($author$project$Internal$Coordinates$toCartesianY, plane, point.y)
		};
	});
var $debois$elm_dom$DOM$target = function (decoder) {
	return A2($elm$json$Json$Decode$field, 'target', decoder);
};
var $author$project$Internal$Svg$decoder = F2(
	function (plane, toMsg) {
		var handle = F3(
			function (mouseX, mouseY, box) {
				var yPrev = plane.y;
				var xPrev = plane.x;
				var widthPercent = box.width / plane.x.length;
				var heightPercent = box.height / plane.y.length;
				var newPlane = _Utils_update(
					plane,
					{
						x: _Utils_update(
							xPrev,
							{length: box.width, marginMax: plane.x.marginMax * widthPercent, marginMin: plane.x.marginMin * widthPercent}),
						y: _Utils_update(
							yPrev,
							{length: box.height, marginMax: plane.y.marginMax * heightPercent, marginMin: plane.y.marginMin * heightPercent})
					});
				var searched = A2(
					$author$project$Internal$Svg$fromSvg,
					newPlane,
					{x: mouseX - box.left, y: mouseY - box.top});
				return A2(toMsg, newPlane, searched);
			});
		return A4(
			$elm$json$Json$Decode$map3,
			handle,
			A2($elm$json$Json$Decode$field, 'pageX', $elm$json$Json$Decode$float),
			A2($elm$json$Json$Decode$field, 'pageY', $elm$json$Json$Decode$float),
			$debois$elm_dom$DOM$target($author$project$Internal$Svg$decodePosition));
	});
var $elm$svg$Svg$Events$on = $elm$html$Html$Events$on;
var $elm$svg$Svg$rect = $elm$svg$Svg$trustedNode('rect');
var $elm$svg$Svg$Attributes$x = _VirtualDom_attribute('x');
var $author$project$Internal$Svg$container = F5(
	function (plane, config, below, chartEls, above) {
		var toEvent = function (event) {
			return A2(
				$elm$svg$Svg$Events$on,
				event.name,
				A2($author$project$Internal$Svg$decoder, plane, event.handler));
		};
		var svgAttrsSize = config.responsive ? _List_fromArray(
			[
				$elm$svg$Svg$Attributes$viewBox(
				'0 0 ' + ($elm$core$String$fromFloat(plane.x.length) + (' ' + $elm$core$String$fromFloat(plane.y.length)))),
				A2($elm$html$Html$Attributes$style, 'display', 'block')
			]) : _List_fromArray(
			[
				$elm$svg$Svg$Attributes$width(
				$elm$core$String$fromFloat(plane.x.length)),
				$elm$svg$Svg$Attributes$height(
				$elm$core$String$fromFloat(plane.y.length)),
				A2($elm$html$Html$Attributes$style, 'display', 'block')
			]);
		var htmlAttrsSize = config.responsive ? _List_fromArray(
			[
				A2($elm$html$Html$Attributes$style, 'width', '100%'),
				A2($elm$html$Html$Attributes$style, 'height', '100%')
			]) : _List_fromArray(
			[
				A2(
				$elm$html$Html$Attributes$style,
				'width',
				$elm$core$String$fromFloat(plane.x.length) + 'px'),
				A2(
				$elm$html$Html$Attributes$style,
				'height',
				$elm$core$String$fromFloat(plane.y.length) + 'px')
			]);
		var htmlAttrsDef = _List_fromArray(
			[
				$elm$html$Html$Attributes$class('elm-charts__container-inner')
			]);
		var htmlAttrs = _Utils_ap(
			config.htmlAttrs,
			_Utils_ap(htmlAttrsDef, htmlAttrsSize));
		var chartPosition = _List_fromArray(
			[
				$elm$svg$Svg$Attributes$x(
				$elm$core$String$fromFloat(plane.x.marginMin)),
				$elm$svg$Svg$Attributes$y(
				$elm$core$String$fromFloat(plane.y.marginMin)),
				$elm$svg$Svg$Attributes$width(
				$elm$core$String$fromFloat(
					$author$project$Internal$Coordinates$innerWidth(plane))),
				$elm$svg$Svg$Attributes$height(
				$elm$core$String$fromFloat(
					$author$project$Internal$Coordinates$innerHeight(plane))),
				$elm$svg$Svg$Attributes$fill('transparent')
			]);
		var catcher = A2(
			$elm$svg$Svg$rect,
			_Utils_ap(
				chartPosition,
				A2($elm$core$List$map, toEvent, config.events)),
			_List_Nil);
		var chart = A2(
			$elm$svg$Svg$svg,
			_Utils_ap(svgAttrsSize, config.attrs),
			_Utils_ap(
				chartEls,
				_List_fromArray(
					[catcher])));
		return A2(
			$elm$html$Html$div,
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class('elm-charts__container'),
					A2($elm$html$Html$Attributes$style, 'position', 'relative')
				]),
			_List_fromArray(
				[
					A2(
					$elm$html$Html$div,
					htmlAttrs,
					_Utils_ap(
						below,
						_Utils_ap(
							_List_fromArray(
								[chart]),
							above)))
				]));
	});
var $author$project$Chart$Attributes$lowest = F3(
	function (v, edit, b) {
		return _Utils_update(
			b,
			{
				min: A3(edit, v, b.min, b.dataMin)
			});
	});
var $author$project$Chart$Attributes$orLower = F3(
	function (least, real, _v0) {
		return (_Utils_cmp(real, least) > 0) ? least : real;
	});
var $author$project$Chart$definePlane = F2(
	function (config, elements) {
		var width = A2($elm$core$Basics$max, 1, (config.width - config.padding.left) - config.padding.right);
		var toLimit = F5(
			function (length, marginMin, marginMax, min, max) {
				return {dataMax: max, dataMin: min, length: length, marginMax: marginMax, marginMin: marginMin, max: max, min: min};
			});
		var height = A2($elm$core$Basics$max, 1, (config.height - config.padding.bottom) - config.padding.top);
		var fixSingles = function (bs) {
			return _Utils_eq(bs.min, bs.max) ? _Utils_update(
				bs,
				{max: bs.min + 10}) : bs;
		};
		var collectLimits = F2(
			function (el, acc) {
				switch (el.$) {
					case 'Indexed':
						return acc;
					case 'SeriesElement':
						var lims = el.a;
						return _Utils_ap(acc, lims);
					case 'BarsElement':
						var lims = el.a;
						return _Utils_ap(acc, lims);
					case 'CustomElement':
						return acc;
					case 'AxisElement':
						return acc;
					case 'TicksElement':
						return acc;
					case 'TickElement':
						return acc;
					case 'LabelsElement':
						return acc;
					case 'LabelElement':
						return acc;
					case 'GridElement':
						return acc;
					case 'SubElements':
						return acc;
					case 'ListOfElements':
						var subs = el.a;
						return A3($elm$core$List$foldl, collectLimits, acc, subs);
					case 'SvgElement':
						return acc;
					default:
						return acc;
				}
			});
		var limits_ = function (pos) {
			return function (_v3) {
				var x = _v3.x;
				var y = _v3.y;
				return {
					x: fixSingles(x),
					y: fixSingles(y)
				};
			}(
				{
					x: A5(toLimit, width, config.margin.left, config.margin.right, pos.x1, pos.x2),
					y: A5(toLimit, height, config.margin.top, config.margin.bottom, pos.y1, pos.y2)
				});
		}(
			A2(
				$author$project$Internal$Coordinates$foldPosition,
				$elm$core$Basics$identity,
				A3($elm$core$List$foldl, collectLimits, _List_Nil, elements)));
		var calcRange = function () {
			var _v2 = config.range;
			if (!_v2.b) {
				return limits_.x;
			} else {
				var some = _v2;
				return A3(
					$elm$core$List$foldl,
					F2(
						function (f, b) {
							return f(b);
						}),
					limits_.x,
					some);
			}
		}();
		var calcDomain = function () {
			var _v1 = config.domain;
			if (!_v1.b) {
				return A3($author$project$Chart$Attributes$lowest, 0, $author$project$Chart$Attributes$orLower, limits_.y);
			} else {
				var some = _v1;
				return A3(
					$elm$core$List$foldl,
					F2(
						function (f, b) {
							return f(b);
						}),
					limits_.y,
					some);
			}
		}();
		var unpadded = {x: calcRange, y: calcDomain};
		var scalePadX = $author$project$Internal$Coordinates$scaleCartesianX(unpadded);
		var xMax = calcRange.max + scalePadX(config.padding.right);
		var xMin = calcRange.min - scalePadX(config.padding.left);
		var scalePadY = $author$project$Internal$Coordinates$scaleCartesianY(unpadded);
		var yMax = calcDomain.max + scalePadY(config.padding.top);
		var yMin = calcDomain.min - scalePadY(config.padding.bottom);
		return {
			x: _Utils_update(
				calcRange,
				{
					length: config.width,
					max: A2($elm$core$Basics$max, xMin, xMax),
					min: A2($elm$core$Basics$min, xMin, xMax)
				}),
			y: _Utils_update(
				calcDomain,
				{
					length: config.height,
					max: A2($elm$core$Basics$max, yMin, yMax),
					min: A2($elm$core$Basics$min, yMin, yMax)
				})
		};
	});
var $author$project$Chart$getItems = F2(
	function (plane, elements) {
		var toItems = F2(
			function (el, acc) {
				switch (el.$) {
					case 'Indexed':
						return acc;
					case 'SeriesElement':
						var items = el.b;
						return _Utils_ap(acc, items);
					case 'BarsElement':
						var items = el.b;
						return _Utils_ap(acc, items);
					case 'CustomElement':
						var item = el.a;
						return _Utils_ap(
							acc,
							_List_fromArray(
								[item]));
					case 'AxisElement':
						var func = el.a;
						return acc;
					case 'TicksElement':
						return acc;
					case 'TickElement':
						return acc;
					case 'LabelsElement':
						return acc;
					case 'LabelElement':
						return acc;
					case 'GridElement':
						return acc;
					case 'SubElements':
						return acc;
					case 'ListOfElements':
						var subs = el.a;
						return A3($elm$core$List$foldl, toItems, acc, subs);
					case 'SvgElement':
						return acc;
					default:
						return acc;
				}
			});
		return A3($elm$core$List$foldl, toItems, _List_Nil, elements);
	});
var $author$project$Chart$getLegends = function (elements) {
	var toLegends = F2(
		function (el, acc) {
			switch (el.$) {
				case 'Indexed':
					return acc;
				case 'SeriesElement':
					var legends_ = el.c;
					return _Utils_ap(acc, legends_);
				case 'BarsElement':
					var legends_ = el.c;
					return _Utils_ap(acc, legends_);
				case 'CustomElement':
					return acc;
				case 'AxisElement':
					return acc;
				case 'TicksElement':
					return acc;
				case 'TickElement':
					return acc;
				case 'LabelsElement':
					return acc;
				case 'LabelElement':
					return acc;
				case 'GridElement':
					return acc;
				case 'SubElements':
					return acc;
				case 'ListOfElements':
					var subs = el.a;
					return A3($elm$core$List$foldl, toLegends, acc, subs);
				case 'SvgElement':
					return acc;
				default:
					return acc;
			}
		});
	return A3($elm$core$List$foldl, toLegends, _List_Nil, elements);
};
var $author$project$Chart$TickValues = F4(
	function (xAxis, yAxis, xs, ys) {
		return {xAxis: xAxis, xs: xs, yAxis: yAxis, ys: ys};
	});
var $author$project$Chart$getTickValues = F3(
	function (plane, items, elements) {
		var toValues = F2(
			function (el, acc) {
				switch (el.$) {
					case 'Indexed':
						return acc;
					case 'SeriesElement':
						return acc;
					case 'BarsElement':
						var func = el.d;
						return A2(func, plane, acc);
					case 'CustomElement':
						var func = el.b;
						return acc;
					case 'AxisElement':
						var func = el.a;
						return A2(func, plane, acc);
					case 'TicksElement':
						var func = el.a;
						return A2(func, plane, acc);
					case 'TickElement':
						var toC = el.a;
						var func = el.b;
						return A3(
							func,
							plane,
							toC(plane),
							acc);
					case 'LabelsElement':
						var toC = el.a;
						var func = el.b;
						return A3(
							func,
							plane,
							toC(plane),
							acc);
					case 'LabelElement':
						var toC = el.a;
						var func = el.b;
						return A3(
							func,
							plane,
							toC(plane),
							acc);
					case 'SubElements':
						var func = el.a;
						return A3(
							$elm$core$List$foldl,
							toValues,
							acc,
							A2(func, plane, items));
					case 'GridElement':
						return acc;
					case 'ListOfElements':
						var subs = el.a;
						return A3($elm$core$List$foldl, toValues, acc, subs);
					case 'SvgElement':
						return acc;
					default:
						return acc;
				}
			});
		return A3(
			$elm$core$List$foldl,
			toValues,
			A4($author$project$Chart$TickValues, _List_Nil, _List_Nil, _List_Nil, _List_Nil),
			elements);
	});
var $author$project$Chart$GridElement = function (a) {
	return {$: 'GridElement', a: a};
};
var $author$project$Internal$Svg$Circle = {$: 'Circle'};
var $author$project$Chart$Attributes$circle = function (config) {
	return _Utils_update(
		config,
		{
			shape: $elm$core$Maybe$Just($author$project$Internal$Svg$Circle)
		});
};
var $author$project$Internal$Helpers$darkGray = 'rgb(200 200 200)';
var $author$project$Chart$Attributes$dashed = F2(
	function (value, config) {
		return _Utils_update(
			config,
			{dashed: value});
	});
var $author$project$Internal$Svg$defaultDot = {border: '', borderWidth: 0, color: $author$project$Internal$Helpers$pink, highlight: 0, highlightColor: '', highlightWidth: 5, opacity: 1, shape: $elm$core$Maybe$Nothing, size: 6};
var $author$project$Internal$Svg$isWithinPlane = F3(
	function (plane, x, y) {
		return _Utils_eq(
			A3($elm$core$Basics$clamp, plane.x.min, plane.x.max, x),
			x) && _Utils_eq(
			A3($elm$core$Basics$clamp, plane.y.min, plane.y.max, y),
			y);
	});
var $elm$core$Basics$pi = _Basics_pi;
var $elm$core$Basics$sqrt = _Basics_sqrt;
var $author$project$Internal$Svg$plusPath = F4(
	function (area_, off, x_, y_) {
		var side = $elm$core$Basics$sqrt(area_ / 4) + off;
		var r6 = side / 2;
		var r3 = side;
		return A2(
			$elm$core$String$join,
			' ',
			_List_fromArray(
				[
					'M' + ($elm$core$String$fromFloat(x_ - r6) + (' ' + $elm$core$String$fromFloat(((y_ - r3) - r6) + off))),
					'v' + $elm$core$String$fromFloat(r3 - off),
					'h' + $elm$core$String$fromFloat((-r3) + off),
					'v' + $elm$core$String$fromFloat(r3),
					'h' + $elm$core$String$fromFloat(r3 - off),
					'v' + $elm$core$String$fromFloat(r3 - off),
					'h' + $elm$core$String$fromFloat(r3),
					'v' + $elm$core$String$fromFloat((-r3) + off),
					'h' + $elm$core$String$fromFloat(r3 - off),
					'v' + $elm$core$String$fromFloat(-r3),
					'h' + $elm$core$String$fromFloat((-r3) + off),
					'v' + $elm$core$String$fromFloat((-r3) + off),
					'h' + $elm$core$String$fromFloat(-r3),
					'v' + $elm$core$String$fromFloat(r3 - off)
				]));
	});
var $elm$core$Basics$degrees = function (angleInDegrees) {
	return (angleInDegrees * $elm$core$Basics$pi) / 180;
};
var $elm$core$Basics$tan = _Basics_tan;
var $author$project$Internal$Svg$trianglePath = F4(
	function (area_, off, x_, y_) {
		var side = $elm$core$Basics$sqrt(
			(area_ * 4) / $elm$core$Basics$sqrt(3)) + (off * $elm$core$Basics$sqrt(3));
		var height = ($elm$core$Basics$sqrt(3) * side) / 2;
		var fromMiddle = height - (($elm$core$Basics$tan(
			$elm$core$Basics$degrees(30)) * side) / 2);
		return A2(
			$elm$core$String$join,
			' ',
			_List_fromArray(
				[
					'M' + ($elm$core$String$fromFloat(x_) + (' ' + $elm$core$String$fromFloat(y_ - fromMiddle))),
					'l' + ($elm$core$String$fromFloat((-side) / 2) + (' ' + $elm$core$String$fromFloat(height))),
					'h' + $elm$core$String$fromFloat(side),
					'z'
				]));
	});
var $author$project$Internal$Svg$dot = F5(
	function (plane, toX, toY, config, datum_) {
		var y_ = A2(
			$author$project$Internal$Coordinates$toSVGY,
			plane,
			toY(datum_));
		var x_ = A2(
			$author$project$Internal$Coordinates$toSVGX,
			plane,
			toX(datum_));
		var styleAttrs = _List_fromArray(
			[
				$elm$svg$Svg$Attributes$stroke(
				(config.border === '') ? config.color : config.border),
				$elm$svg$Svg$Attributes$strokeWidth(
				$elm$core$String$fromFloat(config.borderWidth)),
				$elm$svg$Svg$Attributes$fillOpacity(
				$elm$core$String$fromFloat(config.opacity)),
				$elm$svg$Svg$Attributes$fill(config.color),
				$elm$svg$Svg$Attributes$class('elm-charts__dot')
			]);
		var highlightColor = (config.highlightColor === '') ? config.color : config.highlightColor;
		var highlightAttrs = _List_fromArray(
			[
				$elm$svg$Svg$Attributes$stroke(highlightColor),
				$elm$svg$Svg$Attributes$strokeWidth(
				$elm$core$String$fromFloat(config.highlightWidth)),
				$elm$svg$Svg$Attributes$strokeOpacity(
				$elm$core$String$fromFloat(config.highlight)),
				$elm$svg$Svg$Attributes$fill('transparent'),
				$elm$svg$Svg$Attributes$class('elm-charts__dot-highlight')
			]);
		var view = F3(
			function (toEl, highlightOff, toAttrs) {
				return (config.highlight > 0) ? A2(
					$elm$svg$Svg$g,
					_List_fromArray(
						[
							$elm$svg$Svg$Attributes$class('elm-charts__dot-container')
						]),
					_List_fromArray(
						[
							A2(
							toEl,
							_Utils_ap(
								toAttrs(highlightOff),
								highlightAttrs),
							_List_Nil),
							A2(
							toEl,
							_Utils_ap(
								toAttrs(0),
								styleAttrs),
							_List_Nil)
						])) : A2(
					toEl,
					_Utils_ap(
						toAttrs(0),
						styleAttrs),
					_List_Nil);
			});
		var area_ = (2 * $elm$core$Basics$pi) * config.size;
		if (!A3(
			$author$project$Internal$Svg$isWithinPlane,
			plane,
			toX(datum_),
			toY(datum_))) {
			return $elm$svg$Svg$text('');
		} else {
			var _v0 = config.shape;
			if (_v0.$ === 'Nothing') {
				return $elm$svg$Svg$text('');
			} else {
				switch (_v0.a.$) {
					case 'Circle':
						var _v1 = _v0.a;
						return A3(
							view,
							$elm$svg$Svg$circle,
							config.highlightWidth / 2,
							function (off) {
								var radius = $elm$core$Basics$sqrt(area_ / $elm$core$Basics$pi);
								return _List_fromArray(
									[
										$elm$svg$Svg$Attributes$cx(
										$elm$core$String$fromFloat(x_)),
										$elm$svg$Svg$Attributes$cy(
										$elm$core$String$fromFloat(y_)),
										$elm$svg$Svg$Attributes$r(
										$elm$core$String$fromFloat(radius + off))
									]);
							});
					case 'Triangle':
						var _v2 = _v0.a;
						return A3(
							view,
							$elm$svg$Svg$path,
							config.highlightWidth,
							function (off) {
								return _List_fromArray(
									[
										$elm$svg$Svg$Attributes$d(
										A4($author$project$Internal$Svg$trianglePath, area_, off, x_, y_))
									]);
							});
					case 'Square':
						var _v3 = _v0.a;
						return A3(
							view,
							$elm$svg$Svg$rect,
							config.highlightWidth,
							function (off) {
								var side = $elm$core$Basics$sqrt(area_);
								var sideOff = side + off;
								return _List_fromArray(
									[
										$elm$svg$Svg$Attributes$x(
										$elm$core$String$fromFloat(x_ - (sideOff / 2))),
										$elm$svg$Svg$Attributes$y(
										$elm$core$String$fromFloat(y_ - (sideOff / 2))),
										$elm$svg$Svg$Attributes$width(
										$elm$core$String$fromFloat(sideOff)),
										$elm$svg$Svg$Attributes$height(
										$elm$core$String$fromFloat(sideOff))
									]);
							});
					case 'Diamond':
						var _v4 = _v0.a;
						return A3(
							view,
							$elm$svg$Svg$rect,
							config.highlightWidth,
							function (off) {
								var side = $elm$core$Basics$sqrt(area_);
								var sideOff = side + off;
								return _List_fromArray(
									[
										$elm$svg$Svg$Attributes$x(
										$elm$core$String$fromFloat(x_ - (sideOff / 2))),
										$elm$svg$Svg$Attributes$y(
										$elm$core$String$fromFloat(y_ - (sideOff / 2))),
										$elm$svg$Svg$Attributes$width(
										$elm$core$String$fromFloat(sideOff)),
										$elm$svg$Svg$Attributes$height(
										$elm$core$String$fromFloat(sideOff)),
										$elm$svg$Svg$Attributes$transform(
										'rotate(45 ' + ($elm$core$String$fromFloat(x_) + (' ' + ($elm$core$String$fromFloat(y_) + ')'))))
									]);
							});
					case 'Cross':
						var _v5 = _v0.a;
						return A3(
							view,
							$elm$svg$Svg$path,
							config.highlightWidth,
							function (off) {
								return _List_fromArray(
									[
										$elm$svg$Svg$Attributes$d(
										A4($author$project$Internal$Svg$plusPath, area_, off, x_, y_)),
										$elm$svg$Svg$Attributes$transform(
										'rotate(45 ' + ($elm$core$String$fromFloat(x_) + (' ' + ($elm$core$String$fromFloat(y_) + ')'))))
									]);
							});
					default:
						var _v6 = _v0.a;
						return A3(
							view,
							$elm$svg$Svg$path,
							config.highlightWidth,
							function (off) {
								return _List_fromArray(
									[
										$elm$svg$Svg$Attributes$d(
										A4($author$project$Internal$Svg$plusPath, area_, off, x_, y_))
									]);
							});
				}
			}
		}
	});
var $author$project$Chart$Svg$dot = F4(
	function (plane, toX, toY, edits) {
		return A4(
			$author$project$Internal$Svg$dot,
			plane,
			toX,
			toY,
			A2($author$project$Internal$Helpers$apply, edits, $author$project$Internal$Svg$defaultDot));
	});
var $author$project$Internal$Helpers$gray = '#EFF2FA';
var $author$project$Internal$Svg$defaultLine = {attrs: _List_Nil, _break: false, color: 'rgb(210, 210, 210)', dashed: _List_Nil, flip: false, opacity: 1, tickDirection: -90, tickLength: 0, width: 1, x1: $elm$core$Maybe$Nothing, x2: $elm$core$Maybe$Nothing, x2Svg: $elm$core$Maybe$Nothing, xOff: 0, y1: $elm$core$Maybe$Nothing, y2: $elm$core$Maybe$Nothing, y2Svg: $elm$core$Maybe$Nothing, yOff: 0};
var $elm$core$Basics$cos = _Basics_cos;
var $author$project$Internal$Svg$lengthInCartesianX = $author$project$Internal$Coordinates$scaleCartesianX;
var $author$project$Internal$Svg$lengthInCartesianY = $author$project$Internal$Coordinates$scaleCartesianY;
var $elm$core$Basics$sin = _Basics_sin;
var $elm$svg$Svg$Attributes$strokeDasharray = _VirtualDom_attribute('stroke-dasharray');
var $author$project$Internal$Svg$line = F2(
	function (plane, config) {
		var angle = $elm$core$Basics$degrees(config.tickDirection);
		var _v0 = function () {
			var _v3 = _Utils_Tuple3(
				_Utils_Tuple2(config.x1, config.x2),
				_Utils_Tuple2(config.y1, config.y2),
				_Utils_Tuple2(config.x2Svg, config.y2Svg));
			if (_v3.a.a.$ === 'Just') {
				if (_v3.a.b.$ === 'Just') {
					if (_v3.b.a.$ === 'Nothing') {
						if (_v3.b.b.$ === 'Nothing') {
							var _v4 = _v3.a;
							var a = _v4.a.a;
							var b = _v4.b.a;
							var _v5 = _v3.b;
							var _v6 = _v5.a;
							var _v7 = _v5.b;
							return _Utils_Tuple2(
								_Utils_Tuple2(a, b),
								_Utils_Tuple2(plane.y.min, plane.y.min));
						} else {
							var _v38 = _v3.a;
							var a = _v38.a.a;
							var b = _v38.b.a;
							var _v39 = _v3.b;
							var _v40 = _v39.a;
							var c = _v39.b.a;
							return _Utils_Tuple2(
								_Utils_Tuple2(a, b),
								_Utils_Tuple2(c, c));
						}
					} else {
						if (_v3.b.b.$ === 'Nothing') {
							var _v41 = _v3.a;
							var a = _v41.a.a;
							var b = _v41.b.a;
							var _v42 = _v3.b;
							var c = _v42.a.a;
							var _v43 = _v42.b;
							return _Utils_Tuple2(
								_Utils_Tuple2(a, b),
								_Utils_Tuple2(c, c));
						} else {
							return _Utils_Tuple2(
								_Utils_Tuple2(
									A2($elm$core$Maybe$withDefault, plane.x.min, config.x1),
									A2($elm$core$Maybe$withDefault, plane.x.max, config.x2)),
								_Utils_Tuple2(
									A2($elm$core$Maybe$withDefault, plane.y.min, config.y1),
									A2($elm$core$Maybe$withDefault, plane.y.max, config.y2)));
						}
					}
				} else {
					if (_v3.b.a.$ === 'Nothing') {
						if (_v3.b.b.$ === 'Nothing') {
							var _v8 = _v3.a;
							var a = _v8.a.a;
							var _v9 = _v8.b;
							var _v10 = _v3.b;
							var _v11 = _v10.a;
							var _v12 = _v10.b;
							return _Utils_Tuple2(
								_Utils_Tuple2(a, a),
								_Utils_Tuple2(plane.y.min, plane.y.max));
						} else {
							if (_v3.c.a.$ === 'Just') {
								if (_v3.c.b.$ === 'Just') {
									var _v51 = _v3.a;
									var a = _v51.a.a;
									var _v52 = _v51.b;
									var _v53 = _v3.b;
									var _v54 = _v53.a;
									var b = _v53.b.a;
									var _v55 = _v3.c;
									var xOff = _v55.a.a;
									var yOff = _v55.b.a;
									return _Utils_Tuple2(
										_Utils_Tuple2(
											a,
											a + A2($author$project$Internal$Coordinates$scaleCartesianX, plane, xOff)),
										_Utils_Tuple2(
											b,
											b + A2($author$project$Internal$Coordinates$scaleCartesianY, plane, yOff)));
								} else {
									var _v56 = _v3.a;
									var a = _v56.a.a;
									var _v57 = _v56.b;
									var _v58 = _v3.b;
									var _v59 = _v58.a;
									var b = _v58.b.a;
									var _v60 = _v3.c;
									var xOff = _v60.a.a;
									var _v61 = _v60.b;
									return _Utils_Tuple2(
										_Utils_Tuple2(
											a,
											a + A2($author$project$Internal$Coordinates$scaleCartesianX, plane, xOff)),
										_Utils_Tuple2(b, b));
								}
							} else {
								if (_v3.c.b.$ === 'Nothing') {
									var _v44 = _v3.a;
									var a = _v44.a.a;
									var _v45 = _v44.b;
									var _v46 = _v3.b;
									var _v47 = _v46.a;
									var b = _v46.b.a;
									var _v48 = _v3.c;
									var _v49 = _v48.a;
									var _v50 = _v48.b;
									return _Utils_Tuple2(
										_Utils_Tuple2(a, plane.x.max),
										_Utils_Tuple2(b, b));
								} else {
									var _v62 = _v3.a;
									var a = _v62.a.a;
									var _v63 = _v62.b;
									var _v64 = _v3.b;
									var _v65 = _v64.a;
									var b = _v64.b.a;
									var _v66 = _v3.c;
									var _v67 = _v66.a;
									var yOff = _v66.b.a;
									return _Utils_Tuple2(
										_Utils_Tuple2(a, a),
										_Utils_Tuple2(
											b,
											b + A2($author$project$Internal$Coordinates$scaleCartesianY, plane, yOff)));
								}
							}
						}
					} else {
						if (_v3.b.b.$ === 'Just') {
							var _v35 = _v3.a;
							var c = _v35.a.a;
							var _v36 = _v35.b;
							var _v37 = _v3.b;
							var a = _v37.a.a;
							var b = _v37.b.a;
							return _Utils_Tuple2(
								_Utils_Tuple2(c, c),
								_Utils_Tuple2(a, b));
						} else {
							if (_v3.c.a.$ === 'Just') {
								if (_v3.c.b.$ === 'Just') {
									var _v75 = _v3.a;
									var a = _v75.a.a;
									var _v76 = _v75.b;
									var _v77 = _v3.b;
									var b = _v77.a.a;
									var _v78 = _v77.b;
									var _v79 = _v3.c;
									var xOff = _v79.a.a;
									var yOff = _v79.b.a;
									return _Utils_Tuple2(
										_Utils_Tuple2(
											a,
											a + A2($author$project$Internal$Coordinates$scaleCartesianX, plane, xOff)),
										_Utils_Tuple2(
											b,
											b + A2($author$project$Internal$Coordinates$scaleCartesianY, plane, yOff)));
								} else {
									var _v80 = _v3.a;
									var a = _v80.a.a;
									var _v81 = _v80.b;
									var _v82 = _v3.b;
									var b = _v82.a.a;
									var _v83 = _v82.b;
									var _v84 = _v3.c;
									var xOff = _v84.a.a;
									var _v85 = _v84.b;
									return _Utils_Tuple2(
										_Utils_Tuple2(
											a,
											a + A2($author$project$Internal$Coordinates$scaleCartesianX, plane, xOff)),
										_Utils_Tuple2(b, b));
								}
							} else {
								if (_v3.c.b.$ === 'Nothing') {
									var _v68 = _v3.a;
									var a = _v68.a.a;
									var _v69 = _v68.b;
									var _v70 = _v3.b;
									var b = _v70.a.a;
									var _v71 = _v70.b;
									var _v72 = _v3.c;
									var _v73 = _v72.a;
									var _v74 = _v72.b;
									return _Utils_Tuple2(
										_Utils_Tuple2(a, plane.x.max),
										_Utils_Tuple2(b, b));
								} else {
									var _v86 = _v3.a;
									var a = _v86.a.a;
									var _v87 = _v86.b;
									var _v88 = _v3.b;
									var b = _v88.a.a;
									var _v89 = _v88.b;
									var _v90 = _v3.c;
									var _v91 = _v90.a;
									var yOff = _v90.b.a;
									return _Utils_Tuple2(
										_Utils_Tuple2(a, a),
										_Utils_Tuple2(
											b,
											b + A2($author$project$Internal$Coordinates$scaleCartesianY, plane, yOff)));
								}
							}
						}
					}
				}
			} else {
				if (_v3.a.b.$ === 'Just') {
					if (_v3.b.a.$ === 'Nothing') {
						if (_v3.b.b.$ === 'Nothing') {
							var _v13 = _v3.a;
							var _v14 = _v13.a;
							var b = _v13.b.a;
							var _v15 = _v3.b;
							var _v16 = _v15.a;
							var _v17 = _v15.b;
							return _Utils_Tuple2(
								_Utils_Tuple2(b, b),
								_Utils_Tuple2(plane.y.min, plane.y.max));
						} else {
							if (_v3.c.a.$ === 'Just') {
								if (_v3.c.b.$ === 'Just') {
									var _v99 = _v3.a;
									var _v100 = _v99.a;
									var a = _v99.b.a;
									var _v101 = _v3.b;
									var _v102 = _v101.a;
									var b = _v101.b.a;
									var _v103 = _v3.c;
									var xOff = _v103.a.a;
									var yOff = _v103.b.a;
									return _Utils_Tuple2(
										_Utils_Tuple2(
											a,
											a + A2($author$project$Internal$Coordinates$scaleCartesianX, plane, xOff)),
										_Utils_Tuple2(
											b,
											b + A2($author$project$Internal$Coordinates$scaleCartesianY, plane, yOff)));
								} else {
									var _v104 = _v3.a;
									var _v105 = _v104.a;
									var a = _v104.b.a;
									var _v106 = _v3.b;
									var _v107 = _v106.a;
									var b = _v106.b.a;
									var _v108 = _v3.c;
									var xOff = _v108.a.a;
									var _v109 = _v108.b;
									return _Utils_Tuple2(
										_Utils_Tuple2(
											a,
											a + A2($author$project$Internal$Coordinates$scaleCartesianX, plane, xOff)),
										_Utils_Tuple2(b, b));
								}
							} else {
								if (_v3.c.b.$ === 'Nothing') {
									var _v92 = _v3.a;
									var _v93 = _v92.a;
									var a = _v92.b.a;
									var _v94 = _v3.b;
									var _v95 = _v94.a;
									var b = _v94.b.a;
									var _v96 = _v3.c;
									var _v97 = _v96.a;
									var _v98 = _v96.b;
									return _Utils_Tuple2(
										_Utils_Tuple2(a, plane.x.max),
										_Utils_Tuple2(b, b));
								} else {
									var _v110 = _v3.a;
									var _v111 = _v110.a;
									var a = _v110.b.a;
									var _v112 = _v3.b;
									var _v113 = _v112.a;
									var b = _v112.b.a;
									var _v114 = _v3.c;
									var _v115 = _v114.a;
									var yOff = _v114.b.a;
									return _Utils_Tuple2(
										_Utils_Tuple2(a, a),
										_Utils_Tuple2(
											b,
											b + A2($author$project$Internal$Coordinates$scaleCartesianY, plane, yOff)));
								}
							}
						}
					} else {
						if (_v3.b.b.$ === 'Just') {
							var _v32 = _v3.a;
							var _v33 = _v32.a;
							var c = _v32.b.a;
							var _v34 = _v3.b;
							var a = _v34.a.a;
							var b = _v34.b.a;
							return _Utils_Tuple2(
								_Utils_Tuple2(c, c),
								_Utils_Tuple2(a, b));
						} else {
							if (_v3.c.a.$ === 'Just') {
								if (_v3.c.b.$ === 'Just') {
									var _v123 = _v3.a;
									var _v124 = _v123.a;
									var a = _v123.b.a;
									var _v125 = _v3.b;
									var b = _v125.a.a;
									var _v126 = _v125.b;
									var _v127 = _v3.c;
									var xOff = _v127.a.a;
									var yOff = _v127.b.a;
									return _Utils_Tuple2(
										_Utils_Tuple2(
											a,
											a + A2($author$project$Internal$Coordinates$scaleCartesianX, plane, xOff)),
										_Utils_Tuple2(
											b,
											b + A2($author$project$Internal$Coordinates$scaleCartesianY, plane, yOff)));
								} else {
									var _v128 = _v3.a;
									var _v129 = _v128.a;
									var a = _v128.b.a;
									var _v130 = _v3.b;
									var b = _v130.a.a;
									var _v131 = _v130.b;
									var _v132 = _v3.c;
									var xOff = _v132.a.a;
									var _v133 = _v132.b;
									return _Utils_Tuple2(
										_Utils_Tuple2(
											a,
											a + A2($author$project$Internal$Coordinates$scaleCartesianX, plane, xOff)),
										_Utils_Tuple2(b, b));
								}
							} else {
								if (_v3.c.b.$ === 'Nothing') {
									var _v116 = _v3.a;
									var _v117 = _v116.a;
									var a = _v116.b.a;
									var _v118 = _v3.b;
									var b = _v118.a.a;
									var _v119 = _v118.b;
									var _v120 = _v3.c;
									var _v121 = _v120.a;
									var _v122 = _v120.b;
									return _Utils_Tuple2(
										_Utils_Tuple2(a, plane.x.max),
										_Utils_Tuple2(b, b));
								} else {
									var _v134 = _v3.a;
									var _v135 = _v134.a;
									var a = _v134.b.a;
									var _v136 = _v3.b;
									var b = _v136.a.a;
									var _v137 = _v136.b;
									var _v138 = _v3.c;
									var _v139 = _v138.a;
									var yOff = _v138.b.a;
									return _Utils_Tuple2(
										_Utils_Tuple2(a, a),
										_Utils_Tuple2(
											b,
											b + A2($author$project$Internal$Coordinates$scaleCartesianY, plane, yOff)));
								}
							}
						}
					}
				} else {
					if (_v3.b.a.$ === 'Just') {
						if (_v3.b.b.$ === 'Just') {
							var _v18 = _v3.a;
							var _v19 = _v18.a;
							var _v20 = _v18.b;
							var _v21 = _v3.b;
							var a = _v21.a.a;
							var b = _v21.b.a;
							return _Utils_Tuple2(
								_Utils_Tuple2(plane.x.min, plane.x.min),
								_Utils_Tuple2(a, b));
						} else {
							var _v22 = _v3.a;
							var _v23 = _v22.a;
							var _v24 = _v22.b;
							var _v25 = _v3.b;
							var a = _v25.a.a;
							var _v26 = _v25.b;
							return _Utils_Tuple2(
								_Utils_Tuple2(plane.x.min, plane.x.max),
								_Utils_Tuple2(a, a));
						}
					} else {
						if (_v3.b.b.$ === 'Just') {
							var _v27 = _v3.a;
							var _v28 = _v27.a;
							var _v29 = _v27.b;
							var _v30 = _v3.b;
							var _v31 = _v30.a;
							var b = _v30.b.a;
							return _Utils_Tuple2(
								_Utils_Tuple2(plane.x.min, plane.x.max),
								_Utils_Tuple2(b, b));
						} else {
							var _v140 = _v3.a;
							var _v141 = _v140.a;
							var _v142 = _v140.b;
							var _v143 = _v3.b;
							var _v144 = _v143.a;
							var _v145 = _v143.b;
							return _Utils_Tuple2(
								_Utils_Tuple2(plane.x.min, plane.x.max),
								_Utils_Tuple2(plane.y.min, plane.y.max));
						}
					}
				}
			}
		}();
		var _v1 = _v0.a;
		var x1 = _v1.a;
		var x2 = _v1.b;
		var _v2 = _v0.b;
		var y1 = _v2.a;
		var y2 = _v2.b;
		var x1_ = x1 + A2($author$project$Internal$Svg$lengthInCartesianX, plane, config.xOff);
		var x2_ = x2 + A2($author$project$Internal$Svg$lengthInCartesianX, plane, config.xOff);
		var y1_ = y1 - A2($author$project$Internal$Svg$lengthInCartesianY, plane, config.yOff);
		var y2_ = y2 - A2($author$project$Internal$Svg$lengthInCartesianY, plane, config.yOff);
		var _v146 = (config.tickLength > 0) ? _Utils_Tuple2(
			A2(
				$author$project$Internal$Svg$lengthInCartesianX,
				plane,
				$elm$core$Basics$cos(angle) * config.tickLength),
			A2(
				$author$project$Internal$Svg$lengthInCartesianY,
				plane,
				$elm$core$Basics$sin(angle) * config.tickLength)) : _Utils_Tuple2(0, 0);
		var tickOffsetX = _v146.a;
		var tickOffsetY = _v146.b;
		var cmds = config.flip ? _Utils_ap(
			(config.tickLength > 0) ? _List_fromArray(
				[
					A2($author$project$Internal$Commands$Move, x2_ + tickOffsetX, y2_ + tickOffsetY),
					A2($author$project$Internal$Commands$Line, x2_, y2_)
				]) : _List_fromArray(
				[
					A2($author$project$Internal$Commands$Move, x2_, y2_)
				]),
			_Utils_ap(
				config._break ? _List_fromArray(
					[
						A2($author$project$Internal$Commands$Line, x2_, y1_),
						A2($author$project$Internal$Commands$Line, x1_, y1_)
					]) : _List_fromArray(
					[
						A2($author$project$Internal$Commands$Line, x1_, y1_)
					]),
				(config.tickLength > 0) ? _List_fromArray(
					[
						A2($author$project$Internal$Commands$Line, x1_ + tickOffsetX, y1_ + tickOffsetY)
					]) : _List_Nil)) : _Utils_ap(
			(config.tickLength > 0) ? _List_fromArray(
				[
					A2($author$project$Internal$Commands$Move, x1_ + tickOffsetX, y1_ + tickOffsetY),
					A2($author$project$Internal$Commands$Line, x1_, y1_)
				]) : _List_fromArray(
				[
					A2($author$project$Internal$Commands$Move, x1_, y1_)
				]),
			_Utils_ap(
				config._break ? _List_fromArray(
					[
						A2($author$project$Internal$Commands$Line, x1_, y2_),
						A2($author$project$Internal$Commands$Line, x2_, y2_)
					]) : _List_fromArray(
					[
						A2($author$project$Internal$Commands$Line, x2_, y2_)
					]),
				(config.tickLength > 0) ? _List_fromArray(
					[
						A2($author$project$Internal$Commands$Line, x2_ + tickOffsetX, y2_ + tickOffsetY)
					]) : _List_Nil));
		return A4(
			$author$project$Internal$Svg$withAttrs,
			config.attrs,
			$elm$svg$Svg$path,
			_List_fromArray(
				[
					$elm$svg$Svg$Attributes$class('elm-charts__line'),
					$elm$svg$Svg$Attributes$fill('transparent'),
					$elm$svg$Svg$Attributes$stroke(config.color),
					$elm$svg$Svg$Attributes$strokeWidth(
					$elm$core$String$fromFloat(config.width)),
					$elm$svg$Svg$Attributes$strokeOpacity(
					$elm$core$String$fromFloat(config.opacity)),
					$elm$svg$Svg$Attributes$strokeDasharray(
					A2(
						$elm$core$String$join,
						' ',
						A2($elm$core$List$map, $elm$core$String$fromFloat, config.dashed))),
					$elm$svg$Svg$Attributes$d(
					A2($author$project$Internal$Commands$description, plane, cmds))
				]),
			_List_Nil);
	});
var $author$project$Chart$Svg$line = F2(
	function (plane, edits) {
		return A2(
			$author$project$Internal$Svg$line,
			plane,
			A2($author$project$Internal$Helpers$apply, edits, $author$project$Internal$Svg$defaultLine));
	});
var $elm$core$List$member = F2(
	function (x, xs) {
		return A2(
			$elm$core$List$any,
			function (a) {
				return _Utils_eq(a, x);
			},
			xs);
	});
var $author$project$Chart$Attributes$size = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{size: v});
	});
var $author$project$Chart$Attributes$width = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{width: v});
	});
var $author$project$Chart$Attributes$x1 = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{
				x1: $elm$core$Maybe$Just(v)
			});
	});
var $author$project$Chart$Attributes$y1 = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{
				y1: $elm$core$Maybe$Just(v)
			});
	});
var $author$project$Chart$grid = function (edits) {
	var config = A2(
		$author$project$Internal$Helpers$apply,
		edits,
		{color: '', dashed: _List_Nil, dotGrid: false, width: 0});
	var width = (!config.width) ? (config.dotGrid ? 0.5 : 1) : config.width;
	var color = $elm$core$String$isEmpty(config.color) ? (config.dotGrid ? $author$project$Internal$Helpers$darkGray : $author$project$Internal$Helpers$gray) : config.color;
	var toDot = F4(
		function (vs, p, x, y) {
			return (A2($elm$core$List$member, x, vs.xAxis) || A2($elm$core$List$member, y, vs.yAxis)) ? $elm$core$Maybe$Nothing : $elm$core$Maybe$Just(
				A5(
					$author$project$Chart$Svg$dot,
					p,
					function ($) {
						return $.x;
					},
					function ($) {
						return $.y;
					},
					_List_fromArray(
						[
							$author$project$Chart$Attributes$color(color),
							$author$project$Chart$Attributes$size(width),
							$author$project$Chart$Attributes$circle
						]),
					{x: x, y: y}));
		});
	var toXGrid = F3(
		function (vs, p, v) {
			return A2($elm$core$List$member, v, vs.xAxis) ? $elm$core$Maybe$Nothing : $elm$core$Maybe$Just(
				A2(
					$author$project$Chart$Svg$line,
					p,
					_List_fromArray(
						[
							$author$project$Chart$Attributes$color(color),
							$author$project$Chart$Attributes$width(width),
							$author$project$Chart$Attributes$x1(v),
							$author$project$Chart$Attributes$dashed(config.dashed)
						])));
		});
	var toYGrid = F3(
		function (vs, p, v) {
			return A2($elm$core$List$member, v, vs.yAxis) ? $elm$core$Maybe$Nothing : $elm$core$Maybe$Just(
				A2(
					$author$project$Chart$Svg$line,
					p,
					_List_fromArray(
						[
							$author$project$Chart$Attributes$color(color),
							$author$project$Chart$Attributes$width(width),
							$author$project$Chart$Attributes$y1(v),
							$author$project$Chart$Attributes$dashed(config.dashed)
						])));
		});
	return $author$project$Chart$GridElement(
		F2(
			function (p, vs) {
				return A2(
					$elm$svg$Svg$g,
					_List_fromArray(
						[
							$elm$svg$Svg$Attributes$class('elm-charts__grid')
						]),
					config.dotGrid ? A2(
						$elm$core$List$concatMap,
						function (x) {
							return A2(
								$elm$core$List$filterMap,
								A3(toDot, vs, p, x),
								vs.ys);
						},
						vs.xs) : _List_fromArray(
						[
							A2(
							$elm$svg$Svg$g,
							_List_fromArray(
								[
									$elm$svg$Svg$Attributes$class('elm-charts__x-grid')
								]),
							A2(
								$elm$core$List$filterMap,
								A2(toXGrid, vs, p),
								vs.xs)),
							A2(
							$elm$svg$Svg$g,
							_List_fromArray(
								[
									$elm$svg$Svg$Attributes$class('elm-charts__y-grid')
								]),
							A2(
								$elm$core$List$filterMap,
								A2(toYGrid, vs, p),
								vs.ys))
						]));
			}));
};
var $author$project$Chart$viewElements = F6(
	function (config, plane, tickValues, allItems, allLegends, elements) {
		var viewOne = F2(
			function (el, _v0) {
				var before = _v0.a;
				var chart_ = _v0.b;
				var after = _v0.c;
				switch (el.$) {
					case 'Indexed':
						return _Utils_Tuple3(before, chart_, after);
					case 'SeriesElement':
						var view = el.d;
						return _Utils_Tuple3(
							before,
							A2(
								$elm$core$List$cons,
								view(plane),
								chart_),
							after);
					case 'BarsElement':
						var view = el.e;
						return _Utils_Tuple3(
							before,
							A2(
								$elm$core$List$cons,
								view(plane),
								chart_),
							after);
					case 'CustomElement':
						var view = el.b;
						return _Utils_Tuple3(
							before,
							A2(
								$elm$core$List$cons,
								view(plane),
								chart_),
							after);
					case 'AxisElement':
						var view = el.b;
						return _Utils_Tuple3(
							before,
							A2(
								$elm$core$List$cons,
								view(plane),
								chart_),
							after);
					case 'TicksElement':
						var view = el.b;
						return _Utils_Tuple3(
							before,
							A2(
								$elm$core$List$cons,
								view(plane),
								chart_),
							after);
					case 'TickElement':
						var toC = el.a;
						var view = el.c;
						return _Utils_Tuple3(
							before,
							A2(
								$elm$core$List$cons,
								A2(
									view,
									plane,
									toC(plane)),
								chart_),
							after);
					case 'LabelsElement':
						var toC = el.a;
						var view = el.c;
						return _Utils_Tuple3(
							before,
							A2(
								$elm$core$List$cons,
								A2(
									view,
									plane,
									toC(plane)),
								chart_),
							after);
					case 'LabelElement':
						var toC = el.a;
						var view = el.c;
						return _Utils_Tuple3(
							before,
							A2(
								$elm$core$List$cons,
								A2(
									view,
									plane,
									toC(plane)),
								chart_),
							after);
					case 'GridElement':
						var view = el.a;
						return _Utils_Tuple3(
							before,
							A2(
								$elm$core$List$cons,
								A2(view, plane, tickValues),
								chart_),
							after);
					case 'SubElements':
						var func = el.a;
						return A3(
							$elm$core$List$foldr,
							viewOne,
							_Utils_Tuple3(before, chart_, after),
							A2(func, plane, allItems));
					case 'ListOfElements':
						var els = el.a;
						return A3(
							$elm$core$List$foldr,
							viewOne,
							_Utils_Tuple3(before, chart_, after),
							els);
					case 'SvgElement':
						var view = el.a;
						return _Utils_Tuple3(
							before,
							A2(
								$elm$core$List$cons,
								view(plane),
								chart_),
							after);
					default:
						var view = el.a;
						return _Utils_Tuple3(
							($elm$core$List$length(chart_) > 0) ? A2(
								$elm$core$List$cons,
								A2(view, plane, allLegends),
								before) : before,
							chart_,
							($elm$core$List$length(chart_) > 0) ? after : A2(
								$elm$core$List$cons,
								A2(view, plane, allLegends),
								after));
				}
			});
		return A3(
			$elm$core$List$foldr,
			viewOne,
			_Utils_Tuple3(_List_Nil, _List_Nil, _List_Nil),
			elements);
	});
var $author$project$Chart$chart = F2(
	function (edits, unindexedElements) {
		var indexedElements = function () {
			var toIndexedEl = F2(
				function (el, _v4) {
					var acc = _v4.a;
					var index = _v4.b;
					switch (el.$) {
						case 'Indexed':
							var toElAndIndex = el.a;
							var _v6 = toElAndIndex(index);
							var newEl = _v6.a;
							var newIndex = _v6.b;
							return _Utils_Tuple2(
								_Utils_ap(
									acc,
									_List_fromArray(
										[newEl])),
								newIndex);
						case 'ListOfElements':
							var els = el.a;
							return A3(
								$elm$core$List$foldl,
								toIndexedEl,
								_Utils_Tuple2(acc, index),
								els);
						default:
							return _Utils_Tuple2(
								_Utils_ap(
									acc,
									_List_fromArray(
										[el])),
								index);
					}
				});
			return A3(
				$elm$core$List$foldl,
				toIndexedEl,
				_Utils_Tuple2(_List_Nil, 0),
				unindexedElements).a;
		}();
		var elements = function () {
			var isGrid = function (el) {
				if (el.$ === 'GridElement') {
					return true;
				} else {
					return false;
				}
			};
			return A2($elm$core$List$any, isGrid, indexedElements) ? indexedElements : A2(
				$elm$core$List$cons,
				$author$project$Chart$grid(_List_Nil),
				indexedElements);
		}();
		var legends_ = $author$project$Chart$getLegends(elements);
		var config = A2(
			$author$project$Internal$Helpers$apply,
			edits,
			{
				attrs: _List_fromArray(
					[
						$elm$svg$Svg$Attributes$style('overflow: visible;')
					]),
				domain: _List_Nil,
				events: _List_Nil,
				height: 300,
				htmlAttrs: _List_Nil,
				margin: {bottom: 0, left: 0, right: 0, top: 0},
				padding: {bottom: 0, left: 0, right: 0, top: 0},
				range: _List_Nil,
				responsive: true,
				width: 300
			});
		var plane = A2($author$project$Chart$definePlane, config, elements);
		var items = A2($author$project$Chart$getItems, plane, elements);
		var toEvent = function (_v2) {
			var event_ = _v2.a;
			var _v1 = event_.decoder;
			var decoder = _v1.a;
			return A2(
				$author$project$Internal$Svg$Event,
				event_.name,
				decoder(items));
		};
		var tickValues = A3($author$project$Chart$getTickValues, plane, items, elements);
		var _v0 = A6($author$project$Chart$viewElements, config, plane, tickValues, items, legends_, elements);
		var beforeEls = _v0.a;
		var chartEls = _v0.b;
		var afterEls = _v0.c;
		return A5(
			$author$project$Internal$Svg$container,
			plane,
			{
				attrs: config.attrs,
				events: A2($elm$core$List$map, toEvent, config.events),
				htmlAttrs: config.htmlAttrs,
				responsive: config.responsive
			},
			beforeEls,
			chartEls,
			afterEls);
	});
var $author$project$Charts$Terminology$Data = F7(
	function (x, y, z, a, b, c, label) {
		return {a: a, b: b, c: c, label: label, x: x, y: y, z: z};
	});
var $author$project$Charts$Terminology$data = _List_fromArray(
	[
		A7($author$project$Charts$Terminology$Data, 1, 4, 3, 2, 1, 2, 'A'),
		A7($author$project$Charts$Terminology$Data, 2, 5, 2, 2, 2, 1, 'B'),
		A7($author$project$Charts$Terminology$Data, 3, 4, 3, 2, 1, 2, 'C'),
		A7($author$project$Charts$Terminology$Data, 4, 8, 2, 1, 2, 2, 'D')
	]);
var $author$project$Internal$Item$isReal = function (_v0) {
	var item = _v0.a;
	return item.config.values.isReal;
};
var $author$project$Internal$Many$real = A2(
	$author$project$Internal$Many$Remodel,
	$author$project$Internal$Item$getPosition,
	$elm$core$List$filter($author$project$Internal$Item$isReal));
var $author$project$Chart$Item$real = $author$project$Internal$Many$real;
var $author$project$Chart$eachBar = function (func) {
	return $author$project$Chart$SubElements(
		F2(
			function (p, is) {
				return A2(
					$elm$core$List$concatMap,
					func(p),
					A2(
						$author$project$Chart$Item$apply,
						A2($author$project$Chart$Item$andThen, $author$project$Chart$Item$real, $author$project$Chart$Item$bars),
						is));
			}));
};
var $author$project$Internal$Many$any = A2($author$project$Internal$Many$Remodel, $author$project$Internal$Item$getPosition, $elm$core$Basics$identity);
var $author$project$Chart$Item$any = $author$project$Internal$Many$any;
var $author$project$Internal$Many$stacks = A2(
	$author$project$Internal$Many$Remodel,
	$author$project$Internal$Item$getPosition,
	$author$project$Internal$Many$groupingHelp(
		{
			edits: $elm$core$Basics$identity,
			equality: F2(
				function (a, b) {
					return _Utils_eq(a.x1, b.x1) && (_Utils_eq(a.x2, b.x2) && _Utils_eq(a.property, b.property));
				}),
			shared: function (config) {
				return {property: config.tooltipInfo.property, x1: config.values.x1, x2: config.values.x2};
			}
		}));
var $author$project$Chart$Item$stacks = $author$project$Internal$Many$stacks;
var $author$project$Chart$eachStack = function (func) {
	return $author$project$Chart$SubElements(
		F2(
			function (p, is) {
				return A2(
					$elm$core$List$concatMap,
					func(p),
					A2(
						$author$project$Chart$Item$apply,
						A2(
							$author$project$Chart$Item$andThen,
							$author$project$Chart$Item$stacks,
							A2($author$project$Chart$Item$andThen, $author$project$Chart$Item$real, $author$project$Chart$Item$any)),
						is));
			}));
};
var $author$project$Chart$Attributes$flip = function (config) {
	return _Utils_update(
		config,
		{flip: true});
};
var $author$project$Chart$Item$getData = $author$project$Internal$Item$getDatum;
var $author$project$Chart$Item$getMembers = $author$project$Internal$Many$getMembers;
var $author$project$Internal$Coordinates$top = function (pos) {
	return {x: pos.x1 + ((pos.x2 - pos.x1) / 2), y: pos.y2};
};
var $author$project$Chart$Item$getTop = function (p) {
	return A2(
		$elm$core$Basics$composeR,
		$author$project$Internal$Item$getPosition(p),
		$author$project$Internal$Coordinates$top);
};
var $author$project$Internal$Item$getY = function (_v0) {
	var item = _v0.a;
	return item.config.values.y;
};
var $author$project$Chart$Item$getY = $author$project$Internal$Item$getY;
var $author$project$Chart$Attributes$height = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{height: v});
	});
var $author$project$Chart$Svg$label = F2(
	function (plane, edits) {
		return A2(
			$author$project$Internal$Svg$label,
			plane,
			A2($author$project$Internal$Helpers$apply, edits, $author$project$Internal$Svg$defaultLabel));
	});
var $author$project$Chart$label = F3(
	function (attrs, inner, point) {
		return $author$project$Chart$SvgElement(
			function (p) {
				return A4($author$project$Chart$Svg$label, p, attrs, inner, point);
			});
	});
var $author$project$Chart$line = function (attrs) {
	return $author$project$Chart$SvgElement(
		function (p) {
			return A2($author$project$Chart$Svg$line, p, attrs);
		});
};
var $author$project$Chart$Attributes$margin = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{margin: v});
	});
var $author$project$Chart$Attributes$moveDown = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{yOff: config.yOff + v});
	});
var $author$project$Chart$Attributes$moveLeft = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{xOff: config.xOff - v});
	});
var $author$project$Chart$Attributes$moveRight = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{xOff: config.xOff + v});
	});
var $author$project$Chart$Attributes$moveUp = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{yOff: config.yOff - v});
	});
var $author$project$Chart$Attributes$noArrow = function (config) {
	return _Utils_update(
		config,
		{arrow: false});
};
var $author$project$Chart$Attributes$opacity = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{opacity: v});
	});
var $author$project$Chart$Attributes$padding = F2(
	function (value, config) {
		return _Utils_update(
			config,
			{padding: value});
	});
var $author$project$Chart$Attributes$rotate = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{rotate: config.rotate + v});
	});
var $author$project$Chart$Attributes$spacing = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{spacing: v});
	});
var $author$project$Internal$Property$Stacked = function (a) {
	return {$: 'Stacked', a: a};
};
var $elm$core$List$sum = function (numbers) {
	return A3($elm$core$List$foldl, $elm$core$Basics$add, 0, numbers);
};
var $author$project$Internal$Property$stacked = function (properties) {
	var toVisual = F2(
		function (toYs_, datum) {
			var vs = A2(
				$elm$core$List$filterMap,
				function (toY) {
					return toY(datum);
				},
				toYs_);
			return (!_Utils_eq(
				$elm$core$List$length(vs),
				$elm$core$List$length(toYs_))) ? $elm$core$Maybe$Nothing : $elm$core$Maybe$Just(
				$elm$core$List$sum(vs));
		});
	var stack = F3(
		function (list, prev, result) {
			stack:
			while (true) {
				if (list.b) {
					var one = list.a;
					var rest = list.b;
					var toYs_ = A2($elm$core$List$cons, one.value, prev);
					var $temp$list = rest,
						$temp$prev = toYs_,
						$temp$result = A2(
						$elm$core$List$cons,
						_Utils_update(
							one,
							{
								visual: toVisual(toYs_)
							}),
						result);
					list = $temp$list;
					prev = $temp$prev;
					result = $temp$result;
					continue stack;
				} else {
					return result;
				}
			}
		});
	var configs = A2(
		$elm$core$List$concatMap,
		$author$project$Internal$Property$toConfigs,
		$elm$core$List$reverse(properties));
	return $author$project$Internal$Property$Stacked(
		A3(stack, configs, _List_Nil, _List_Nil));
};
var $author$project$Chart$stacked = $author$project$Internal$Property$stacked;
var $author$project$Chart$Attributes$tickDirection = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{tickDirection: v});
	});
var $author$project$Chart$Attributes$tickLength = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{tickLength: v});
	});
var $author$project$Chart$Attributes$withGrid = function (config) {
	return _Utils_update(
		config,
		{grid: true});
};
var $author$project$Chart$Attributes$x2 = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{
				x2: $elm$core$Maybe$Just(v)
			});
	});
var $author$project$Chart$Attributes$x2Svg = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{
				x2Svg: $elm$core$Maybe$Just(v)
			});
	});
var $author$project$Chart$AxisElement = F2(
	function (a, b) {
		return {$: 'AxisElement', a: a, b: b};
	});
var $elm$svg$Svg$Attributes$points = _VirtualDom_attribute('points');
var $elm$svg$Svg$polygon = $elm$svg$Svg$trustedNode('polygon');
var $author$project$Internal$Svg$arrow = F3(
	function (plane, config, point) {
		var points_ = '0,0 ' + ($elm$core$String$fromFloat(config.length) + (',' + ($elm$core$String$fromFloat(config.width) + (' 0, ' + $elm$core$String$fromFloat(config.width * 2)))));
		var commands = 'rotate(' + ($elm$core$String$fromFloat(config.rotate) + (') translate(0 ' + ($elm$core$String$fromFloat(-config.width) + ') ')));
		return A2(
			$elm$svg$Svg$g,
			_List_fromArray(
				[
					$elm$svg$Svg$Attributes$class('elm-charts__arrow'),
					A6($author$project$Internal$Svg$position, plane, 0, point.x, point.y, config.xOff, config.yOff)
				]),
			_List_fromArray(
				[
					A4(
					$author$project$Internal$Svg$withAttrs,
					config.attrs,
					$elm$svg$Svg$polygon,
					_List_fromArray(
						[
							$elm$svg$Svg$Attributes$fill(config.color),
							$elm$svg$Svg$Attributes$points(points_),
							$elm$svg$Svg$Attributes$transform(commands)
						]),
					_List_Nil)
				]));
	});
var $author$project$Internal$Svg$defaultArrow = {attrs: _List_Nil, color: 'rgb(210, 210, 210)', length: 7, rotate: 0, width: 4, xOff: 0, yOff: 0};
var $author$project$Chart$Svg$arrow = F2(
	function (plane, edits) {
		return A2(
			$author$project$Internal$Svg$arrow,
			plane,
			A2($author$project$Internal$Helpers$apply, edits, $author$project$Internal$Svg$defaultArrow));
	});
var $author$project$Chart$Attributes$zero = function (b) {
	return A3($elm$core$Basics$clamp, b.min, b.max, 0);
};
var $author$project$Chart$xAxis = function (edits) {
	var config = A2(
		$author$project$Internal$Helpers$apply,
		edits,
		{arrow: true, color: '', limits: _List_Nil, pinned: $author$project$Chart$Attributes$zero, width: 1});
	var addTickValues = F2(
		function (p, ts) {
			return _Utils_update(
				ts,
				{
					yAxis: A2(
						$elm$core$List$cons,
						config.pinned(p.y),
						ts.yAxis)
				});
		});
	return A2(
		$author$project$Chart$AxisElement,
		addTickValues,
		function (p) {
			var xLimit = A3(
				$elm$core$List$foldl,
				F2(
					function (f, x) {
						return f(x);
					}),
				p.x,
				config.limits);
			return A2(
				$elm$svg$Svg$g,
				_List_fromArray(
					[
						$elm$svg$Svg$Attributes$class('elm-charts__x-axis')
					]),
				_List_fromArray(
					[
						A2(
						$author$project$Chart$Svg$line,
						p,
						_List_fromArray(
							[
								$author$project$Chart$Attributes$color(config.color),
								$author$project$Chart$Attributes$width(config.width),
								$author$project$Chart$Attributes$y1(
								config.pinned(p.y)),
								$author$project$Chart$Attributes$x1(
								A2($elm$core$Basics$max, p.x.min, xLimit.min)),
								$author$project$Chart$Attributes$x2(
								A2($elm$core$Basics$min, p.x.max, xLimit.max))
							])),
						config.arrow ? A3(
						$author$project$Chart$Svg$arrow,
						p,
						_List_fromArray(
							[
								$author$project$Chart$Attributes$color(config.color)
							]),
						{
							x: xLimit.max,
							y: config.pinned(p.y)
						}) : $elm$svg$Svg$text('')
					]));
		});
};
var $author$project$Chart$Attributes$y2 = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{
				y2: $elm$core$Maybe$Just(v)
			});
	});
var $author$project$Chart$Attributes$y2Svg = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{
				y2Svg: $elm$core$Maybe$Just(v)
			});
	});
var $author$project$Internal$Svg$Floats = {$: 'Floats'};
var $author$project$Chart$LabelsElement = F3(
	function (a, b, c) {
		return {$: 'LabelsElement', a: a, b: b, c: c};
	});
var $author$project$Internal$Svg$Start = {$: 'Start'};
var $author$project$Internal$Svg$Generator = function (a) {
	return {$: 'Generator', a: a};
};
var $terezka$intervals$Intervals$Around = function (a) {
	return {$: 'Around', a: a};
};
var $terezka$intervals$Intervals$around = $terezka$intervals$Intervals$Around;
var $terezka$intervals$Intervals$ceilingTo = F2(
	function (prec, number) {
		return prec * $elm$core$Basics$ceiling(number / prec);
	});
var $terezka$intervals$Intervals$getBeginning = F2(
	function (min, interval) {
		var multiple = min / interval;
		return _Utils_eq(
			multiple,
			$elm$core$Basics$round(multiple)) ? min : A2($terezka$intervals$Intervals$ceilingTo, interval, min);
	});
var $elm$core$String$foldr = _String_foldr;
var $elm$core$String$toList = function (string) {
	return A3($elm$core$String$foldr, $elm$core$List$cons, _List_Nil, string);
};
var $myrho$elm_round$Round$addSign = F2(
	function (signed, str) {
		var isNotZero = A2(
			$elm$core$List$any,
			function (c) {
				return (!_Utils_eq(
					c,
					_Utils_chr('0'))) && (!_Utils_eq(
					c,
					_Utils_chr('.')));
			},
			$elm$core$String$toList(str));
		return _Utils_ap(
			(signed && isNotZero) ? '-' : '',
			str);
	});
var $elm$core$String$cons = _String_cons;
var $elm$core$Char$fromCode = _Char_fromCode;
var $myrho$elm_round$Round$increaseNum = function (_v0) {
	var head = _v0.a;
	var tail = _v0.b;
	if (_Utils_eq(
		head,
		_Utils_chr('9'))) {
		var _v1 = $elm$core$String$uncons(tail);
		if (_v1.$ === 'Nothing') {
			return '01';
		} else {
			var headtail = _v1.a;
			return A2(
				$elm$core$String$cons,
				_Utils_chr('0'),
				$myrho$elm_round$Round$increaseNum(headtail));
		}
	} else {
		var c = $elm$core$Char$toCode(head);
		return ((c >= 48) && (c < 57)) ? A2(
			$elm$core$String$cons,
			$elm$core$Char$fromCode(c + 1),
			tail) : '0';
	}
};
var $elm$core$Basics$isInfinite = _Basics_isInfinite;
var $elm$core$Basics$isNaN = _Basics_isNaN;
var $elm$core$String$fromChar = function (_char) {
	return A2($elm$core$String$cons, _char, '');
};
var $elm$core$Bitwise$shiftRightBy = _Bitwise_shiftRightBy;
var $elm$core$String$repeatHelp = F3(
	function (n, chunk, result) {
		return (n <= 0) ? result : A3(
			$elm$core$String$repeatHelp,
			n >> 1,
			_Utils_ap(chunk, chunk),
			(!(n & 1)) ? result : _Utils_ap(result, chunk));
	});
var $elm$core$String$repeat = F2(
	function (n, chunk) {
		return A3($elm$core$String$repeatHelp, n, chunk, '');
	});
var $elm$core$String$padRight = F3(
	function (n, _char, string) {
		return _Utils_ap(
			string,
			A2(
				$elm$core$String$repeat,
				n - $elm$core$String$length(string),
				$elm$core$String$fromChar(_char)));
	});
var $elm$core$String$reverse = _String_reverse;
var $myrho$elm_round$Round$splitComma = function (str) {
	var _v0 = A2($elm$core$String$split, '.', str);
	if (_v0.b) {
		if (_v0.b.b) {
			var before = _v0.a;
			var _v1 = _v0.b;
			var after = _v1.a;
			return _Utils_Tuple2(before, after);
		} else {
			var before = _v0.a;
			return _Utils_Tuple2(before, '0');
		}
	} else {
		return _Utils_Tuple2('0', '0');
	}
};
var $myrho$elm_round$Round$toDecimal = function (fl) {
	var _v0 = A2(
		$elm$core$String$split,
		'e',
		$elm$core$String$fromFloat(
			$elm$core$Basics$abs(fl)));
	if (_v0.b) {
		if (_v0.b.b) {
			var num = _v0.a;
			var _v1 = _v0.b;
			var exp = _v1.a;
			var e = A2(
				$elm$core$Maybe$withDefault,
				0,
				$elm$core$String$toInt(
					A2($elm$core$String$startsWith, '+', exp) ? A2($elm$core$String$dropLeft, 1, exp) : exp));
			var _v2 = $myrho$elm_round$Round$splitComma(num);
			var before = _v2.a;
			var after = _v2.b;
			var total = _Utils_ap(before, after);
			var zeroed = (e < 0) ? A2(
				$elm$core$Maybe$withDefault,
				'0',
				A2(
					$elm$core$Maybe$map,
					function (_v3) {
						var a = _v3.a;
						var b = _v3.b;
						return a + ('.' + b);
					},
					A2(
						$elm$core$Maybe$map,
						$elm$core$Tuple$mapFirst($elm$core$String$fromChar),
						$elm$core$String$uncons(
							_Utils_ap(
								A2(
									$elm$core$String$repeat,
									$elm$core$Basics$abs(e),
									'0'),
								total))))) : A3(
				$elm$core$String$padRight,
				e + 1,
				_Utils_chr('0'),
				total);
			return _Utils_ap(
				(fl < 0) ? '-' : '',
				zeroed);
		} else {
			var num = _v0.a;
			return _Utils_ap(
				(fl < 0) ? '-' : '',
				num);
		}
	} else {
		return '';
	}
};
var $myrho$elm_round$Round$roundFun = F3(
	function (functor, s, fl) {
		if ($elm$core$Basics$isInfinite(fl) || $elm$core$Basics$isNaN(fl)) {
			return $elm$core$String$fromFloat(fl);
		} else {
			var signed = fl < 0;
			var _v0 = $myrho$elm_round$Round$splitComma(
				$myrho$elm_round$Round$toDecimal(
					$elm$core$Basics$abs(fl)));
			var before = _v0.a;
			var after = _v0.b;
			var r = $elm$core$String$length(before) + s;
			var normalized = _Utils_ap(
				A2($elm$core$String$repeat, (-r) + 1, '0'),
				A3(
					$elm$core$String$padRight,
					r,
					_Utils_chr('0'),
					_Utils_ap(before, after)));
			var totalLen = $elm$core$String$length(normalized);
			var roundDigitIndex = A2($elm$core$Basics$max, 1, r);
			var increase = A2(
				functor,
				signed,
				A3($elm$core$String$slice, roundDigitIndex, totalLen, normalized));
			var remains = A3($elm$core$String$slice, 0, roundDigitIndex, normalized);
			var num = increase ? $elm$core$String$reverse(
				A2(
					$elm$core$Maybe$withDefault,
					'1',
					A2(
						$elm$core$Maybe$map,
						$myrho$elm_round$Round$increaseNum,
						$elm$core$String$uncons(
							$elm$core$String$reverse(remains))))) : remains;
			var numLen = $elm$core$String$length(num);
			var numZeroed = (num === '0') ? num : ((s <= 0) ? _Utils_ap(
				num,
				A2(
					$elm$core$String$repeat,
					$elm$core$Basics$abs(s),
					'0')) : ((_Utils_cmp(
				s,
				$elm$core$String$length(after)) < 0) ? (A3($elm$core$String$slice, 0, numLen - s, num) + ('.' + A3($elm$core$String$slice, numLen - s, numLen, num))) : _Utils_ap(
				before + '.',
				A3(
					$elm$core$String$padRight,
					s,
					_Utils_chr('0'),
					after))));
			return A2($myrho$elm_round$Round$addSign, signed, numZeroed);
		}
	});
var $myrho$elm_round$Round$round = $myrho$elm_round$Round$roundFun(
	F2(
		function (signed, str) {
			var _v0 = $elm$core$String$uncons(str);
			if (_v0.$ === 'Nothing') {
				return false;
			} else {
				if ('5' === _v0.a.a.valueOf()) {
					if (_v0.a.b === '') {
						var _v1 = _v0.a;
						return !signed;
					} else {
						var _v2 = _v0.a;
						return true;
					}
				} else {
					var _v3 = _v0.a;
					var _int = _v3.a;
					return function (i) {
						return ((i > 53) && signed) || ((i >= 53) && (!signed));
					}(
						$elm$core$Char$toCode(_int));
				}
			}
		}));
var $elm$core$String$toFloat = _String_toFloat;
var $terezka$intervals$Intervals$correctFloat = function (prec) {
	return A2(
		$elm$core$Basics$composeR,
		$myrho$elm_round$Round$round(prec),
		A2(
			$elm$core$Basics$composeR,
			$elm$core$String$toFloat,
			$elm$core$Maybe$withDefault(0)));
};
var $terezka$intervals$Intervals$getMultiples = F3(
	function (magnitude, allowDecimals, hasTickAmount) {
		var defaults = hasTickAmount ? _List_fromArray(
			[1, 1.2, 1.5, 2, 2.5, 3, 4, 5, 6, 8, 10]) : _List_fromArray(
			[1, 2, 2.5, 5, 10]);
		return allowDecimals ? defaults : ((magnitude === 1) ? A2(
			$elm$core$List$filter,
			function (n) {
				return _Utils_eq(
					$elm$core$Basics$round(n),
					n);
			},
			defaults) : ((magnitude <= 0.1) ? _List_fromArray(
			[1 / magnitude]) : defaults));
	});
var $terezka$intervals$Intervals$getPrecision = function (number) {
	var _v0 = A2(
		$elm$core$String$split,
		'e',
		$elm$core$String$fromFloat(number));
	if ((_v0.b && _v0.b.b) && (!_v0.b.b.b)) {
		var before = _v0.a;
		var _v1 = _v0.b;
		var after = _v1.a;
		return $elm$core$Basics$abs(
			A2(
				$elm$core$Maybe$withDefault,
				0,
				$elm$core$String$toInt(after)));
	} else {
		var _v2 = A2(
			$elm$core$String$split,
			'.',
			$elm$core$String$fromFloat(number));
		if ((_v2.b && _v2.b.b) && (!_v2.b.b.b)) {
			var before = _v2.a;
			var _v3 = _v2.b;
			var after = _v3.a;
			return $elm$core$String$length(after);
		} else {
			return 0;
		}
	}
};
var $elm$core$Basics$e = _Basics_e;
var $elm$core$Basics$pow = _Basics_pow;
var $terezka$intervals$Intervals$toMagnitude = function (num) {
	return A2(
		$elm$core$Basics$pow,
		10,
		$elm$core$Basics$floor(
			A2($elm$core$Basics$logBase, $elm$core$Basics$e, num) / A2($elm$core$Basics$logBase, $elm$core$Basics$e, 10)));
};
var $terezka$intervals$Intervals$getInterval = F3(
	function (intervalRaw, allowDecimals, hasTickAmount) {
		var magnitude = $terezka$intervals$Intervals$toMagnitude(intervalRaw);
		var multiples = A3($terezka$intervals$Intervals$getMultiples, magnitude, allowDecimals, hasTickAmount);
		var normalized = intervalRaw / magnitude;
		var findMultipleExact = function (multiples_) {
			findMultipleExact:
			while (true) {
				if (multiples_.b) {
					var m1 = multiples_.a;
					var rest = multiples_.b;
					if (_Utils_cmp(m1 * magnitude, intervalRaw) > -1) {
						return m1;
					} else {
						var $temp$multiples_ = rest;
						multiples_ = $temp$multiples_;
						continue findMultipleExact;
					}
				} else {
					return 1;
				}
			}
		};
		var findMultiple = function (multiples_) {
			findMultiple:
			while (true) {
				if (multiples_.b) {
					if (multiples_.b.b) {
						var m1 = multiples_.a;
						var _v2 = multiples_.b;
						var m2 = _v2.a;
						var rest = _v2.b;
						if (_Utils_cmp(normalized, (m1 + m2) / 2) < 1) {
							return m1;
						} else {
							var $temp$multiples_ = A2($elm$core$List$cons, m2, rest);
							multiples_ = $temp$multiples_;
							continue findMultiple;
						}
					} else {
						var m1 = multiples_.a;
						var rest = multiples_.b;
						if (_Utils_cmp(normalized, m1) < 1) {
							return m1;
						} else {
							var $temp$multiples_ = rest;
							multiples_ = $temp$multiples_;
							continue findMultiple;
						}
					}
				} else {
					return 1;
				}
			}
		};
		var multiple = hasTickAmount ? findMultipleExact(multiples) : findMultiple(multiples);
		var precision = $terezka$intervals$Intervals$getPrecision(magnitude) + $terezka$intervals$Intervals$getPrecision(multiple);
		return A2($terezka$intervals$Intervals$correctFloat, precision, multiple * magnitude);
	});
var $terezka$intervals$Intervals$positions = F5(
	function (range, beginning, interval, m, acc) {
		positions:
		while (true) {
			var nextPosition = A2(
				$terezka$intervals$Intervals$correctFloat,
				$terezka$intervals$Intervals$getPrecision(interval),
				beginning + (m * interval));
			if (_Utils_cmp(nextPosition, range.max) > 0) {
				return acc;
			} else {
				var $temp$range = range,
					$temp$beginning = beginning,
					$temp$interval = interval,
					$temp$m = m + 1,
					$temp$acc = _Utils_ap(
					acc,
					_List_fromArray(
						[nextPosition]));
				range = $temp$range;
				beginning = $temp$beginning;
				interval = $temp$interval;
				m = $temp$m;
				acc = $temp$acc;
				continue positions;
			}
		}
	});
var $terezka$intervals$Intervals$values = F4(
	function (allowDecimals, exact, amountRough, range) {
		var intervalRough = (range.max - range.min) / amountRough;
		var interval = A3($terezka$intervals$Intervals$getInterval, intervalRough, allowDecimals, exact);
		var intervalSafe = (!interval) ? 1 : interval;
		var beginning = A2($terezka$intervals$Intervals$getBeginning, range.min, intervalSafe);
		var amountRoughSafe = (!amountRough) ? 1 : amountRough;
		return A5($terezka$intervals$Intervals$positions, range, beginning, intervalSafe, 0, _List_Nil);
	});
var $terezka$intervals$Intervals$floats = function (amount) {
	if (amount.$ === 'Exactly') {
		var number = amount.a;
		return A3($terezka$intervals$Intervals$values, true, true, number);
	} else {
		var number = amount.a;
		return A3($terezka$intervals$Intervals$values, true, false, number);
	}
};
var $author$project$Internal$Svg$floats = $author$project$Internal$Svg$Generator(
	F2(
		function (i, b) {
			return A2(
				$terezka$intervals$Intervals$floats,
				$terezka$intervals$Intervals$around(i),
				{max: b.max, min: b.min});
		}));
var $author$project$Chart$Svg$floats = $author$project$Internal$Svg$floats;
var $ryannhg$date_format$DateFormat$Language$Language = F6(
	function (toMonthName, toMonthAbbreviation, toWeekdayName, toWeekdayAbbreviation, toAmPm, toOrdinalSuffix) {
		return {toAmPm: toAmPm, toMonthAbbreviation: toMonthAbbreviation, toMonthName: toMonthName, toOrdinalSuffix: toOrdinalSuffix, toWeekdayAbbreviation: toWeekdayAbbreviation, toWeekdayName: toWeekdayName};
	});
var $ryannhg$date_format$DateFormat$Language$toEnglishAmPm = function (hour) {
	return (hour > 11) ? 'pm' : 'am';
};
var $ryannhg$date_format$DateFormat$Language$toEnglishMonthName = function (month) {
	switch (month.$) {
		case 'Jan':
			return 'January';
		case 'Feb':
			return 'February';
		case 'Mar':
			return 'March';
		case 'Apr':
			return 'April';
		case 'May':
			return 'May';
		case 'Jun':
			return 'June';
		case 'Jul':
			return 'July';
		case 'Aug':
			return 'August';
		case 'Sep':
			return 'September';
		case 'Oct':
			return 'October';
		case 'Nov':
			return 'November';
		default:
			return 'December';
	}
};
var $elm$core$Basics$modBy = _Basics_modBy;
var $ryannhg$date_format$DateFormat$Language$toEnglishSuffix = function (num) {
	var _v0 = A2($elm$core$Basics$modBy, 100, num);
	switch (_v0) {
		case 11:
			return 'th';
		case 12:
			return 'th';
		case 13:
			return 'th';
		default:
			var _v1 = A2($elm$core$Basics$modBy, 10, num);
			switch (_v1) {
				case 1:
					return 'st';
				case 2:
					return 'nd';
				case 3:
					return 'rd';
				default:
					return 'th';
			}
	}
};
var $ryannhg$date_format$DateFormat$Language$toEnglishWeekdayName = function (weekday) {
	switch (weekday.$) {
		case 'Mon':
			return 'Monday';
		case 'Tue':
			return 'Tuesday';
		case 'Wed':
			return 'Wednesday';
		case 'Thu':
			return 'Thursday';
		case 'Fri':
			return 'Friday';
		case 'Sat':
			return 'Saturday';
		default:
			return 'Sunday';
	}
};
var $ryannhg$date_format$DateFormat$Language$english = A6(
	$ryannhg$date_format$DateFormat$Language$Language,
	$ryannhg$date_format$DateFormat$Language$toEnglishMonthName,
	A2(
		$elm$core$Basics$composeR,
		$ryannhg$date_format$DateFormat$Language$toEnglishMonthName,
		$elm$core$String$left(3)),
	$ryannhg$date_format$DateFormat$Language$toEnglishWeekdayName,
	A2(
		$elm$core$Basics$composeR,
		$ryannhg$date_format$DateFormat$Language$toEnglishWeekdayName,
		$elm$core$String$left(3)),
	$ryannhg$date_format$DateFormat$Language$toEnglishAmPm,
	$ryannhg$date_format$DateFormat$Language$toEnglishSuffix);
var $elm$time$Time$flooredDiv = F2(
	function (numerator, denominator) {
		return $elm$core$Basics$floor(numerator / denominator);
	});
var $elm$time$Time$posixToMillis = function (_v0) {
	var millis = _v0.a;
	return millis;
};
var $elm$time$Time$toAdjustedMinutesHelp = F3(
	function (defaultOffset, posixMinutes, eras) {
		toAdjustedMinutesHelp:
		while (true) {
			if (!eras.b) {
				return posixMinutes + defaultOffset;
			} else {
				var era = eras.a;
				var olderEras = eras.b;
				if (_Utils_cmp(era.start, posixMinutes) < 0) {
					return posixMinutes + era.offset;
				} else {
					var $temp$defaultOffset = defaultOffset,
						$temp$posixMinutes = posixMinutes,
						$temp$eras = olderEras;
					defaultOffset = $temp$defaultOffset;
					posixMinutes = $temp$posixMinutes;
					eras = $temp$eras;
					continue toAdjustedMinutesHelp;
				}
			}
		}
	});
var $elm$time$Time$toAdjustedMinutes = F2(
	function (_v0, time) {
		var defaultOffset = _v0.a;
		var eras = _v0.b;
		return A3(
			$elm$time$Time$toAdjustedMinutesHelp,
			defaultOffset,
			A2(
				$elm$time$Time$flooredDiv,
				$elm$time$Time$posixToMillis(time),
				60000),
			eras);
	});
var $elm$time$Time$toHour = F2(
	function (zone, time) {
		return A2(
			$elm$core$Basics$modBy,
			24,
			A2(
				$elm$time$Time$flooredDiv,
				A2($elm$time$Time$toAdjustedMinutes, zone, time),
				60));
	});
var $ryannhg$date_format$DateFormat$amPm = F3(
	function (language, zone, posix) {
		return language.toAmPm(
			A2($elm$time$Time$toHour, zone, posix));
	});
var $elm$time$Time$toCivil = function (minutes) {
	var rawDay = A2($elm$time$Time$flooredDiv, minutes, 60 * 24) + 719468;
	var era = (((rawDay >= 0) ? rawDay : (rawDay - 146096)) / 146097) | 0;
	var dayOfEra = rawDay - (era * 146097);
	var yearOfEra = ((((dayOfEra - ((dayOfEra / 1460) | 0)) + ((dayOfEra / 36524) | 0)) - ((dayOfEra / 146096) | 0)) / 365) | 0;
	var dayOfYear = dayOfEra - (((365 * yearOfEra) + ((yearOfEra / 4) | 0)) - ((yearOfEra / 100) | 0));
	var mp = (((5 * dayOfYear) + 2) / 153) | 0;
	var month = mp + ((mp < 10) ? 3 : (-9));
	var year = yearOfEra + (era * 400);
	return {
		day: (dayOfYear - ((((153 * mp) + 2) / 5) | 0)) + 1,
		month: month,
		year: year + ((month <= 2) ? 1 : 0)
	};
};
var $elm$time$Time$toDay = F2(
	function (zone, time) {
		return $elm$time$Time$toCivil(
			A2($elm$time$Time$toAdjustedMinutes, zone, time)).day;
	});
var $ryannhg$date_format$DateFormat$dayOfMonth = $elm$time$Time$toDay;
var $elm$time$Time$Sun = {$: 'Sun'};
var $elm$time$Time$Fri = {$: 'Fri'};
var $elm$time$Time$Mon = {$: 'Mon'};
var $elm$time$Time$Sat = {$: 'Sat'};
var $elm$time$Time$Thu = {$: 'Thu'};
var $elm$time$Time$Tue = {$: 'Tue'};
var $elm$time$Time$Wed = {$: 'Wed'};
var $ryannhg$date_format$DateFormat$days = _List_fromArray(
	[$elm$time$Time$Sun, $elm$time$Time$Mon, $elm$time$Time$Tue, $elm$time$Time$Wed, $elm$time$Time$Thu, $elm$time$Time$Fri, $elm$time$Time$Sat]);
var $elm$time$Time$toWeekday = F2(
	function (zone, time) {
		var _v0 = A2(
			$elm$core$Basics$modBy,
			7,
			A2(
				$elm$time$Time$flooredDiv,
				A2($elm$time$Time$toAdjustedMinutes, zone, time),
				60 * 24));
		switch (_v0) {
			case 0:
				return $elm$time$Time$Thu;
			case 1:
				return $elm$time$Time$Fri;
			case 2:
				return $elm$time$Time$Sat;
			case 3:
				return $elm$time$Time$Sun;
			case 4:
				return $elm$time$Time$Mon;
			case 5:
				return $elm$time$Time$Tue;
			default:
				return $elm$time$Time$Wed;
		}
	});
var $ryannhg$date_format$DateFormat$dayOfWeek = F2(
	function (zone, posix) {
		return function (_v1) {
			var i = _v1.a;
			return i;
		}(
			A2(
				$elm$core$Maybe$withDefault,
				_Utils_Tuple2(0, $elm$time$Time$Sun),
				$elm$core$List$head(
					A2(
						$elm$core$List$filter,
						function (_v0) {
							var day = _v0.b;
							return _Utils_eq(
								day,
								A2($elm$time$Time$toWeekday, zone, posix));
						},
						A2(
							$elm$core$List$indexedMap,
							F2(
								function (i, day) {
									return _Utils_Tuple2(i, day);
								}),
							$ryannhg$date_format$DateFormat$days)))));
	});
var $ryannhg$date_format$DateFormat$isLeapYear = function (year_) {
	return (!(!A2($elm$core$Basics$modBy, 4, year_))) ? false : ((!(!A2($elm$core$Basics$modBy, 100, year_))) ? true : ((!(!A2($elm$core$Basics$modBy, 400, year_))) ? false : true));
};
var $ryannhg$date_format$DateFormat$daysInMonth = F2(
	function (year_, month) {
		switch (month.$) {
			case 'Jan':
				return 31;
			case 'Feb':
				return $ryannhg$date_format$DateFormat$isLeapYear(year_) ? 29 : 28;
			case 'Mar':
				return 31;
			case 'Apr':
				return 30;
			case 'May':
				return 31;
			case 'Jun':
				return 30;
			case 'Jul':
				return 31;
			case 'Aug':
				return 31;
			case 'Sep':
				return 30;
			case 'Oct':
				return 31;
			case 'Nov':
				return 30;
			default:
				return 31;
		}
	});
var $elm$time$Time$Jan = {$: 'Jan'};
var $elm$time$Time$Apr = {$: 'Apr'};
var $elm$time$Time$Aug = {$: 'Aug'};
var $elm$time$Time$Dec = {$: 'Dec'};
var $elm$time$Time$Feb = {$: 'Feb'};
var $elm$time$Time$Jul = {$: 'Jul'};
var $elm$time$Time$Jun = {$: 'Jun'};
var $elm$time$Time$Mar = {$: 'Mar'};
var $elm$time$Time$May = {$: 'May'};
var $elm$time$Time$Nov = {$: 'Nov'};
var $elm$time$Time$Oct = {$: 'Oct'};
var $elm$time$Time$Sep = {$: 'Sep'};
var $ryannhg$date_format$DateFormat$months = _List_fromArray(
	[$elm$time$Time$Jan, $elm$time$Time$Feb, $elm$time$Time$Mar, $elm$time$Time$Apr, $elm$time$Time$May, $elm$time$Time$Jun, $elm$time$Time$Jul, $elm$time$Time$Aug, $elm$time$Time$Sep, $elm$time$Time$Oct, $elm$time$Time$Nov, $elm$time$Time$Dec]);
var $elm$time$Time$toMonth = F2(
	function (zone, time) {
		var _v0 = $elm$time$Time$toCivil(
			A2($elm$time$Time$toAdjustedMinutes, zone, time)).month;
		switch (_v0) {
			case 1:
				return $elm$time$Time$Jan;
			case 2:
				return $elm$time$Time$Feb;
			case 3:
				return $elm$time$Time$Mar;
			case 4:
				return $elm$time$Time$Apr;
			case 5:
				return $elm$time$Time$May;
			case 6:
				return $elm$time$Time$Jun;
			case 7:
				return $elm$time$Time$Jul;
			case 8:
				return $elm$time$Time$Aug;
			case 9:
				return $elm$time$Time$Sep;
			case 10:
				return $elm$time$Time$Oct;
			case 11:
				return $elm$time$Time$Nov;
			default:
				return $elm$time$Time$Dec;
		}
	});
var $ryannhg$date_format$DateFormat$monthPair = F2(
	function (zone, posix) {
		return A2(
			$elm$core$Maybe$withDefault,
			_Utils_Tuple2(0, $elm$time$Time$Jan),
			$elm$core$List$head(
				A2(
					$elm$core$List$filter,
					function (_v0) {
						var i = _v0.a;
						var m = _v0.b;
						return _Utils_eq(
							m,
							A2($elm$time$Time$toMonth, zone, posix));
					},
					A2(
						$elm$core$List$indexedMap,
						F2(
							function (a, b) {
								return _Utils_Tuple2(a, b);
							}),
						$ryannhg$date_format$DateFormat$months))));
	});
var $ryannhg$date_format$DateFormat$monthNumber_ = F2(
	function (zone, posix) {
		return 1 + function (_v0) {
			var i = _v0.a;
			var m = _v0.b;
			return i;
		}(
			A2($ryannhg$date_format$DateFormat$monthPair, zone, posix));
	});
var $elm$core$List$takeReverse = F3(
	function (n, list, kept) {
		takeReverse:
		while (true) {
			if (n <= 0) {
				return kept;
			} else {
				if (!list.b) {
					return kept;
				} else {
					var x = list.a;
					var xs = list.b;
					var $temp$n = n - 1,
						$temp$list = xs,
						$temp$kept = A2($elm$core$List$cons, x, kept);
					n = $temp$n;
					list = $temp$list;
					kept = $temp$kept;
					continue takeReverse;
				}
			}
		}
	});
var $elm$core$List$takeTailRec = F2(
	function (n, list) {
		return $elm$core$List$reverse(
			A3($elm$core$List$takeReverse, n, list, _List_Nil));
	});
var $elm$core$List$takeFast = F3(
	function (ctr, n, list) {
		if (n <= 0) {
			return _List_Nil;
		} else {
			var _v0 = _Utils_Tuple2(n, list);
			_v0$1:
			while (true) {
				_v0$5:
				while (true) {
					if (!_v0.b.b) {
						return list;
					} else {
						if (_v0.b.b.b) {
							switch (_v0.a) {
								case 1:
									break _v0$1;
								case 2:
									var _v2 = _v0.b;
									var x = _v2.a;
									var _v3 = _v2.b;
									var y = _v3.a;
									return _List_fromArray(
										[x, y]);
								case 3:
									if (_v0.b.b.b.b) {
										var _v4 = _v0.b;
										var x = _v4.a;
										var _v5 = _v4.b;
										var y = _v5.a;
										var _v6 = _v5.b;
										var z = _v6.a;
										return _List_fromArray(
											[x, y, z]);
									} else {
										break _v0$5;
									}
								default:
									if (_v0.b.b.b.b && _v0.b.b.b.b.b) {
										var _v7 = _v0.b;
										var x = _v7.a;
										var _v8 = _v7.b;
										var y = _v8.a;
										var _v9 = _v8.b;
										var z = _v9.a;
										var _v10 = _v9.b;
										var w = _v10.a;
										var tl = _v10.b;
										return (ctr > 1000) ? A2(
											$elm$core$List$cons,
											x,
											A2(
												$elm$core$List$cons,
												y,
												A2(
													$elm$core$List$cons,
													z,
													A2(
														$elm$core$List$cons,
														w,
														A2($elm$core$List$takeTailRec, n - 4, tl))))) : A2(
											$elm$core$List$cons,
											x,
											A2(
												$elm$core$List$cons,
												y,
												A2(
													$elm$core$List$cons,
													z,
													A2(
														$elm$core$List$cons,
														w,
														A3($elm$core$List$takeFast, ctr + 1, n - 4, tl)))));
									} else {
										break _v0$5;
									}
							}
						} else {
							if (_v0.a === 1) {
								break _v0$1;
							} else {
								break _v0$5;
							}
						}
					}
				}
				return list;
			}
			var _v1 = _v0.b;
			var x = _v1.a;
			return _List_fromArray(
				[x]);
		}
	});
var $elm$core$List$take = F2(
	function (n, list) {
		return A3($elm$core$List$takeFast, 0, n, list);
	});
var $elm$time$Time$toYear = F2(
	function (zone, time) {
		return $elm$time$Time$toCivil(
			A2($elm$time$Time$toAdjustedMinutes, zone, time)).year;
	});
var $ryannhg$date_format$DateFormat$dayOfYear = F2(
	function (zone, posix) {
		var monthsBeforeThisOne = A2(
			$elm$core$List$take,
			A2($ryannhg$date_format$DateFormat$monthNumber_, zone, posix) - 1,
			$ryannhg$date_format$DateFormat$months);
		var daysBeforeThisMonth = $elm$core$List$sum(
			A2(
				$elm$core$List$map,
				$ryannhg$date_format$DateFormat$daysInMonth(
					A2($elm$time$Time$toYear, zone, posix)),
				monthsBeforeThisOne));
		return daysBeforeThisMonth + A2($ryannhg$date_format$DateFormat$dayOfMonth, zone, posix);
	});
var $ryannhg$date_format$DateFormat$quarter = F2(
	function (zone, posix) {
		return (A2($ryannhg$date_format$DateFormat$monthNumber_, zone, posix) / 4) | 0;
	});
var $elm$core$String$right = F2(
	function (n, string) {
		return (n < 1) ? '' : A3(
			$elm$core$String$slice,
			-n,
			$elm$core$String$length(string),
			string);
	});
var $ryannhg$date_format$DateFormat$toFixedLength = F2(
	function (totalChars, num) {
		var numStr = $elm$core$String$fromInt(num);
		var numZerosNeeded = totalChars - $elm$core$String$length(numStr);
		var zeros = A2(
			$elm$core$String$join,
			'',
			A2(
				$elm$core$List$map,
				function (_v0) {
					return '0';
				},
				A2($elm$core$List$range, 1, numZerosNeeded)));
		return _Utils_ap(zeros, numStr);
	});
var $elm$time$Time$toMillis = F2(
	function (_v0, time) {
		return A2(
			$elm$core$Basics$modBy,
			1000,
			$elm$time$Time$posixToMillis(time));
	});
var $elm$time$Time$toMinute = F2(
	function (zone, time) {
		return A2(
			$elm$core$Basics$modBy,
			60,
			A2($elm$time$Time$toAdjustedMinutes, zone, time));
	});
var $ryannhg$date_format$DateFormat$toNonMilitary = function (num) {
	return (!num) ? 12 : ((num <= 12) ? num : (num - 12));
};
var $elm$time$Time$toSecond = F2(
	function (_v0, time) {
		return A2(
			$elm$core$Basics$modBy,
			60,
			A2(
				$elm$time$Time$flooredDiv,
				$elm$time$Time$posixToMillis(time),
				1000));
	});
var $elm$core$String$toUpper = _String_toUpper;
var $elm$time$Time$Posix = function (a) {
	return {$: 'Posix', a: a};
};
var $elm$time$Time$millisToPosix = $elm$time$Time$Posix;
var $ryannhg$date_format$DateFormat$millisecondsPerYear = $elm$core$Basics$round((((1000 * 60) * 60) * 24) * 365.25);
var $ryannhg$date_format$DateFormat$firstDayOfYear = F2(
	function (zone, time) {
		return $elm$time$Time$millisToPosix(
			$ryannhg$date_format$DateFormat$millisecondsPerYear * A2($elm$time$Time$toYear, zone, time));
	});
var $ryannhg$date_format$DateFormat$weekOfYear = F2(
	function (zone, posix) {
		var firstDay = A2($ryannhg$date_format$DateFormat$firstDayOfYear, zone, posix);
		var firstDayOffset = A2($ryannhg$date_format$DateFormat$dayOfWeek, zone, firstDay);
		var daysSoFar = A2($ryannhg$date_format$DateFormat$dayOfYear, zone, posix);
		return (((daysSoFar + firstDayOffset) / 7) | 0) + 1;
	});
var $ryannhg$date_format$DateFormat$year = F2(
	function (zone, time) {
		return $elm$core$String$fromInt(
			A2($elm$time$Time$toYear, zone, time));
	});
var $ryannhg$date_format$DateFormat$piece = F4(
	function (language, zone, posix, token) {
		switch (token.$) {
			case 'MonthNumber':
				return $elm$core$String$fromInt(
					A2($ryannhg$date_format$DateFormat$monthNumber_, zone, posix));
			case 'MonthSuffix':
				return function (num) {
					return _Utils_ap(
						$elm$core$String$fromInt(num),
						language.toOrdinalSuffix(num));
				}(
					A2($ryannhg$date_format$DateFormat$monthNumber_, zone, posix));
			case 'MonthFixed':
				return A2(
					$ryannhg$date_format$DateFormat$toFixedLength,
					2,
					A2($ryannhg$date_format$DateFormat$monthNumber_, zone, posix));
			case 'MonthNameAbbreviated':
				return language.toMonthAbbreviation(
					A2($elm$time$Time$toMonth, zone, posix));
			case 'MonthNameFull':
				return language.toMonthName(
					A2($elm$time$Time$toMonth, zone, posix));
			case 'QuarterNumber':
				return $elm$core$String$fromInt(
					1 + A2($ryannhg$date_format$DateFormat$quarter, zone, posix));
			case 'QuarterSuffix':
				return function (num) {
					return _Utils_ap(
						$elm$core$String$fromInt(num),
						language.toOrdinalSuffix(num));
				}(
					1 + A2($ryannhg$date_format$DateFormat$quarter, zone, posix));
			case 'DayOfMonthNumber':
				return $elm$core$String$fromInt(
					A2($ryannhg$date_format$DateFormat$dayOfMonth, zone, posix));
			case 'DayOfMonthSuffix':
				return function (num) {
					return _Utils_ap(
						$elm$core$String$fromInt(num),
						language.toOrdinalSuffix(num));
				}(
					A2($ryannhg$date_format$DateFormat$dayOfMonth, zone, posix));
			case 'DayOfMonthFixed':
				return A2(
					$ryannhg$date_format$DateFormat$toFixedLength,
					2,
					A2($ryannhg$date_format$DateFormat$dayOfMonth, zone, posix));
			case 'DayOfYearNumber':
				return $elm$core$String$fromInt(
					A2($ryannhg$date_format$DateFormat$dayOfYear, zone, posix));
			case 'DayOfYearSuffix':
				return function (num) {
					return _Utils_ap(
						$elm$core$String$fromInt(num),
						language.toOrdinalSuffix(num));
				}(
					A2($ryannhg$date_format$DateFormat$dayOfYear, zone, posix));
			case 'DayOfYearFixed':
				return A2(
					$ryannhg$date_format$DateFormat$toFixedLength,
					3,
					A2($ryannhg$date_format$DateFormat$dayOfYear, zone, posix));
			case 'DayOfWeekNumber':
				return $elm$core$String$fromInt(
					A2($ryannhg$date_format$DateFormat$dayOfWeek, zone, posix));
			case 'DayOfWeekSuffix':
				return function (num) {
					return _Utils_ap(
						$elm$core$String$fromInt(num),
						language.toOrdinalSuffix(num));
				}(
					A2($ryannhg$date_format$DateFormat$dayOfWeek, zone, posix));
			case 'DayOfWeekNameAbbreviated':
				return language.toWeekdayAbbreviation(
					A2($elm$time$Time$toWeekday, zone, posix));
			case 'DayOfWeekNameFull':
				return language.toWeekdayName(
					A2($elm$time$Time$toWeekday, zone, posix));
			case 'WeekOfYearNumber':
				return $elm$core$String$fromInt(
					A2($ryannhg$date_format$DateFormat$weekOfYear, zone, posix));
			case 'WeekOfYearSuffix':
				return function (num) {
					return _Utils_ap(
						$elm$core$String$fromInt(num),
						language.toOrdinalSuffix(num));
				}(
					A2($ryannhg$date_format$DateFormat$weekOfYear, zone, posix));
			case 'WeekOfYearFixed':
				return A2(
					$ryannhg$date_format$DateFormat$toFixedLength,
					2,
					A2($ryannhg$date_format$DateFormat$weekOfYear, zone, posix));
			case 'YearNumberLastTwo':
				return A2(
					$elm$core$String$right,
					2,
					A2($ryannhg$date_format$DateFormat$year, zone, posix));
			case 'YearNumber':
				return A2($ryannhg$date_format$DateFormat$year, zone, posix);
			case 'AmPmUppercase':
				return $elm$core$String$toUpper(
					A3($ryannhg$date_format$DateFormat$amPm, language, zone, posix));
			case 'AmPmLowercase':
				return $elm$core$String$toLower(
					A3($ryannhg$date_format$DateFormat$amPm, language, zone, posix));
			case 'HourMilitaryNumber':
				return $elm$core$String$fromInt(
					A2($elm$time$Time$toHour, zone, posix));
			case 'HourMilitaryFixed':
				return A2(
					$ryannhg$date_format$DateFormat$toFixedLength,
					2,
					A2($elm$time$Time$toHour, zone, posix));
			case 'HourNumber':
				return $elm$core$String$fromInt(
					$ryannhg$date_format$DateFormat$toNonMilitary(
						A2($elm$time$Time$toHour, zone, posix)));
			case 'HourFixed':
				return A2(
					$ryannhg$date_format$DateFormat$toFixedLength,
					2,
					$ryannhg$date_format$DateFormat$toNonMilitary(
						A2($elm$time$Time$toHour, zone, posix)));
			case 'HourMilitaryFromOneNumber':
				return $elm$core$String$fromInt(
					1 + A2($elm$time$Time$toHour, zone, posix));
			case 'HourMilitaryFromOneFixed':
				return A2(
					$ryannhg$date_format$DateFormat$toFixedLength,
					2,
					1 + A2($elm$time$Time$toHour, zone, posix));
			case 'MinuteNumber':
				return $elm$core$String$fromInt(
					A2($elm$time$Time$toMinute, zone, posix));
			case 'MinuteFixed':
				return A2(
					$ryannhg$date_format$DateFormat$toFixedLength,
					2,
					A2($elm$time$Time$toMinute, zone, posix));
			case 'SecondNumber':
				return $elm$core$String$fromInt(
					A2($elm$time$Time$toSecond, zone, posix));
			case 'SecondFixed':
				return A2(
					$ryannhg$date_format$DateFormat$toFixedLength,
					2,
					A2($elm$time$Time$toSecond, zone, posix));
			case 'MillisecondNumber':
				return $elm$core$String$fromInt(
					A2($elm$time$Time$toMillis, zone, posix));
			case 'MillisecondFixed':
				return A2(
					$ryannhg$date_format$DateFormat$toFixedLength,
					3,
					A2($elm$time$Time$toMillis, zone, posix));
			default:
				var string = token.a;
				return string;
		}
	});
var $ryannhg$date_format$DateFormat$formatWithLanguage = F4(
	function (language, tokens, zone, time) {
		return A2(
			$elm$core$String$join,
			'',
			A2(
				$elm$core$List$map,
				A3($ryannhg$date_format$DateFormat$piece, language, zone, time),
				tokens));
	});
var $ryannhg$date_format$DateFormat$format = $ryannhg$date_format$DateFormat$formatWithLanguage($ryannhg$date_format$DateFormat$Language$english);
var $ryannhg$date_format$DateFormat$HourMilitaryFixed = {$: 'HourMilitaryFixed'};
var $ryannhg$date_format$DateFormat$hourMilitaryFixed = $ryannhg$date_format$DateFormat$HourMilitaryFixed;
var $ryannhg$date_format$DateFormat$MinuteFixed = {$: 'MinuteFixed'};
var $ryannhg$date_format$DateFormat$minuteFixed = $ryannhg$date_format$DateFormat$MinuteFixed;
var $ryannhg$date_format$DateFormat$Text = function (a) {
	return {$: 'Text', a: a};
};
var $ryannhg$date_format$DateFormat$text = $ryannhg$date_format$DateFormat$Text;
var $author$project$Internal$Svg$formatClock = $ryannhg$date_format$DateFormat$format(
	_List_fromArray(
		[
			$ryannhg$date_format$DateFormat$hourMilitaryFixed,
			$ryannhg$date_format$DateFormat$text(':'),
			$ryannhg$date_format$DateFormat$minuteFixed
		]));
var $ryannhg$date_format$DateFormat$MillisecondFixed = {$: 'MillisecondFixed'};
var $ryannhg$date_format$DateFormat$millisecondFixed = $ryannhg$date_format$DateFormat$MillisecondFixed;
var $ryannhg$date_format$DateFormat$SecondFixed = {$: 'SecondFixed'};
var $ryannhg$date_format$DateFormat$secondFixed = $ryannhg$date_format$DateFormat$SecondFixed;
var $author$project$Internal$Svg$formatClockMillis = $ryannhg$date_format$DateFormat$format(
	_List_fromArray(
		[
			$ryannhg$date_format$DateFormat$hourMilitaryFixed,
			$ryannhg$date_format$DateFormat$text(':'),
			$ryannhg$date_format$DateFormat$minuteFixed,
			$ryannhg$date_format$DateFormat$text(':'),
			$ryannhg$date_format$DateFormat$secondFixed,
			$ryannhg$date_format$DateFormat$text(':'),
			$ryannhg$date_format$DateFormat$millisecondFixed
		]));
var $author$project$Internal$Svg$formatClockSecond = $ryannhg$date_format$DateFormat$format(
	_List_fromArray(
		[
			$ryannhg$date_format$DateFormat$hourMilitaryFixed,
			$ryannhg$date_format$DateFormat$text(':'),
			$ryannhg$date_format$DateFormat$minuteFixed,
			$ryannhg$date_format$DateFormat$text(':'),
			$ryannhg$date_format$DateFormat$secondFixed
		]));
var $ryannhg$date_format$DateFormat$DayOfMonthNumber = {$: 'DayOfMonthNumber'};
var $ryannhg$date_format$DateFormat$dayOfMonthNumber = $ryannhg$date_format$DateFormat$DayOfMonthNumber;
var $ryannhg$date_format$DateFormat$MonthNumber = {$: 'MonthNumber'};
var $ryannhg$date_format$DateFormat$monthNumber = $ryannhg$date_format$DateFormat$MonthNumber;
var $author$project$Internal$Svg$formatDate = $ryannhg$date_format$DateFormat$format(
	_List_fromArray(
		[
			$ryannhg$date_format$DateFormat$monthNumber,
			$ryannhg$date_format$DateFormat$text('/'),
			$ryannhg$date_format$DateFormat$dayOfMonthNumber
		]));
var $ryannhg$date_format$DateFormat$MonthNameAbbreviated = {$: 'MonthNameAbbreviated'};
var $ryannhg$date_format$DateFormat$monthNameAbbreviated = $ryannhg$date_format$DateFormat$MonthNameAbbreviated;
var $author$project$Internal$Svg$formatMonth = $ryannhg$date_format$DateFormat$format(
	_List_fromArray(
		[$ryannhg$date_format$DateFormat$monthNameAbbreviated]));
var $ryannhg$date_format$DateFormat$DayOfWeekNameFull = {$: 'DayOfWeekNameFull'};
var $ryannhg$date_format$DateFormat$dayOfWeekNameFull = $ryannhg$date_format$DateFormat$DayOfWeekNameFull;
var $author$project$Internal$Svg$formatWeekday = $ryannhg$date_format$DateFormat$format(
	_List_fromArray(
		[$ryannhg$date_format$DateFormat$dayOfWeekNameFull]));
var $ryannhg$date_format$DateFormat$YearNumber = {$: 'YearNumber'};
var $ryannhg$date_format$DateFormat$yearNumber = $ryannhg$date_format$DateFormat$YearNumber;
var $author$project$Internal$Svg$formatYear = $ryannhg$date_format$DateFormat$format(
	_List_fromArray(
		[$ryannhg$date_format$DateFormat$yearNumber]));
var $author$project$Internal$Svg$formatTime = F2(
	function (zone, time) {
		var _v0 = A2($elm$core$Maybe$withDefault, time.unit, time.change);
		switch (_v0.$) {
			case 'Millisecond':
				return A2($author$project$Internal$Svg$formatClockMillis, zone, time.timestamp);
			case 'Second':
				return A2($author$project$Internal$Svg$formatClockSecond, zone, time.timestamp);
			case 'Minute':
				return A2($author$project$Internal$Svg$formatClock, zone, time.timestamp);
			case 'Hour':
				return A2($author$project$Internal$Svg$formatClock, zone, time.timestamp);
			case 'Day':
				return (time.multiple === 7) ? A2($author$project$Internal$Svg$formatWeekday, zone, time.timestamp) : A2($author$project$Internal$Svg$formatDate, zone, time.timestamp);
			case 'Month':
				return A2($author$project$Internal$Svg$formatMonth, zone, time.timestamp);
			default:
				return A2($author$project$Internal$Svg$formatYear, zone, time.timestamp);
		}
	});
var $author$project$Chart$Svg$formatTime = $author$project$Internal$Svg$formatTime;
var $author$project$Internal$Svg$generate = F3(
	function (amount, _v0, limits) {
		var func = _v0.a;
		return A2(func, amount, limits);
	});
var $author$project$Chart$Svg$generate = $author$project$Internal$Svg$generate;
var $terezka$intervals$Intervals$ints = F2(
	function (amount, range) {
		return A2(
			$elm$core$List$map,
			$elm$core$Basics$round,
			function () {
				if (amount.$ === 'Exactly') {
					var number = amount.a;
					return A4($terezka$intervals$Intervals$values, false, true, number, range);
				} else {
					var number = amount.a;
					return A4($terezka$intervals$Intervals$values, false, false, number, range);
				}
			}());
	});
var $author$project$Internal$Svg$ints = $author$project$Internal$Svg$Generator(
	F2(
		function (i, b) {
			return A2(
				$terezka$intervals$Intervals$ints,
				$terezka$intervals$Intervals$around(i),
				{max: b.max, min: b.min});
		}));
var $author$project$Chart$Svg$ints = $author$project$Internal$Svg$ints;
var $terezka$intervals$Intervals$Day = {$: 'Day'};
var $terezka$intervals$Intervals$Hour = {$: 'Hour'};
var $terezka$intervals$Intervals$Millisecond = {$: 'Millisecond'};
var $terezka$intervals$Intervals$Minute = {$: 'Minute'};
var $terezka$intervals$Intervals$Month = {$: 'Month'};
var $terezka$intervals$Intervals$Second = {$: 'Second'};
var $terezka$intervals$Intervals$Year = {$: 'Year'};
var $justinmimbs$time_extra$Time$Extra$Day = {$: 'Day'};
var $justinmimbs$date$Date$Days = {$: 'Days'};
var $justinmimbs$time_extra$Time$Extra$Millisecond = {$: 'Millisecond'};
var $justinmimbs$time_extra$Time$Extra$Month = {$: 'Month'};
var $justinmimbs$date$Date$Months = {$: 'Months'};
var $justinmimbs$date$Date$RD = function (a) {
	return {$: 'RD', a: a};
};
var $justinmimbs$date$Date$isLeapYear = function (y) {
	return ((!A2($elm$core$Basics$modBy, 4, y)) && (!(!A2($elm$core$Basics$modBy, 100, y)))) || (!A2($elm$core$Basics$modBy, 400, y));
};
var $justinmimbs$date$Date$daysBeforeMonth = F2(
	function (y, m) {
		var leapDays = $justinmimbs$date$Date$isLeapYear(y) ? 1 : 0;
		switch (m.$) {
			case 'Jan':
				return 0;
			case 'Feb':
				return 31;
			case 'Mar':
				return 59 + leapDays;
			case 'Apr':
				return 90 + leapDays;
			case 'May':
				return 120 + leapDays;
			case 'Jun':
				return 151 + leapDays;
			case 'Jul':
				return 181 + leapDays;
			case 'Aug':
				return 212 + leapDays;
			case 'Sep':
				return 243 + leapDays;
			case 'Oct':
				return 273 + leapDays;
			case 'Nov':
				return 304 + leapDays;
			default:
				return 334 + leapDays;
		}
	});
var $justinmimbs$date$Date$floorDiv = F2(
	function (a, b) {
		return $elm$core$Basics$floor(a / b);
	});
var $justinmimbs$date$Date$daysBeforeYear = function (y1) {
	var y = y1 - 1;
	var leapYears = (A2($justinmimbs$date$Date$floorDiv, y, 4) - A2($justinmimbs$date$Date$floorDiv, y, 100)) + A2($justinmimbs$date$Date$floorDiv, y, 400);
	return (365 * y) + leapYears;
};
var $justinmimbs$date$Date$daysInMonth = F2(
	function (y, m) {
		switch (m.$) {
			case 'Jan':
				return 31;
			case 'Feb':
				return $justinmimbs$date$Date$isLeapYear(y) ? 29 : 28;
			case 'Mar':
				return 31;
			case 'Apr':
				return 30;
			case 'May':
				return 31;
			case 'Jun':
				return 30;
			case 'Jul':
				return 31;
			case 'Aug':
				return 31;
			case 'Sep':
				return 30;
			case 'Oct':
				return 31;
			case 'Nov':
				return 30;
			default:
				return 31;
		}
	});
var $justinmimbs$date$Date$monthToNumber = function (m) {
	switch (m.$) {
		case 'Jan':
			return 1;
		case 'Feb':
			return 2;
		case 'Mar':
			return 3;
		case 'Apr':
			return 4;
		case 'May':
			return 5;
		case 'Jun':
			return 6;
		case 'Jul':
			return 7;
		case 'Aug':
			return 8;
		case 'Sep':
			return 9;
		case 'Oct':
			return 10;
		case 'Nov':
			return 11;
		default:
			return 12;
	}
};
var $justinmimbs$date$Date$numberToMonth = function (mn) {
	var _v0 = A2($elm$core$Basics$max, 1, mn);
	switch (_v0) {
		case 1:
			return $elm$time$Time$Jan;
		case 2:
			return $elm$time$Time$Feb;
		case 3:
			return $elm$time$Time$Mar;
		case 4:
			return $elm$time$Time$Apr;
		case 5:
			return $elm$time$Time$May;
		case 6:
			return $elm$time$Time$Jun;
		case 7:
			return $elm$time$Time$Jul;
		case 8:
			return $elm$time$Time$Aug;
		case 9:
			return $elm$time$Time$Sep;
		case 10:
			return $elm$time$Time$Oct;
		case 11:
			return $elm$time$Time$Nov;
		default:
			return $elm$time$Time$Dec;
	}
};
var $justinmimbs$date$Date$toCalendarDateHelp = F3(
	function (y, m, d) {
		toCalendarDateHelp:
		while (true) {
			var monthDays = A2($justinmimbs$date$Date$daysInMonth, y, m);
			var mn = $justinmimbs$date$Date$monthToNumber(m);
			if ((mn < 12) && (_Utils_cmp(d, monthDays) > 0)) {
				var $temp$y = y,
					$temp$m = $justinmimbs$date$Date$numberToMonth(mn + 1),
					$temp$d = d - monthDays;
				y = $temp$y;
				m = $temp$m;
				d = $temp$d;
				continue toCalendarDateHelp;
			} else {
				return {day: d, month: m, year: y};
			}
		}
	});
var $justinmimbs$date$Date$divWithRemainder = F2(
	function (a, b) {
		return _Utils_Tuple2(
			A2($justinmimbs$date$Date$floorDiv, a, b),
			A2($elm$core$Basics$modBy, b, a));
	});
var $justinmimbs$date$Date$year = function (_v0) {
	var rd = _v0.a;
	var _v1 = A2($justinmimbs$date$Date$divWithRemainder, rd, 146097);
	var n400 = _v1.a;
	var r400 = _v1.b;
	var _v2 = A2($justinmimbs$date$Date$divWithRemainder, r400, 36524);
	var n100 = _v2.a;
	var r100 = _v2.b;
	var _v3 = A2($justinmimbs$date$Date$divWithRemainder, r100, 1461);
	var n4 = _v3.a;
	var r4 = _v3.b;
	var _v4 = A2($justinmimbs$date$Date$divWithRemainder, r4, 365);
	var n1 = _v4.a;
	var r1 = _v4.b;
	var n = (!r1) ? 0 : 1;
	return ((((n400 * 400) + (n100 * 100)) + (n4 * 4)) + n1) + n;
};
var $justinmimbs$date$Date$toOrdinalDate = function (_v0) {
	var rd = _v0.a;
	var y = $justinmimbs$date$Date$year(
		$justinmimbs$date$Date$RD(rd));
	return {
		ordinalDay: rd - $justinmimbs$date$Date$daysBeforeYear(y),
		year: y
	};
};
var $justinmimbs$date$Date$toCalendarDate = function (_v0) {
	var rd = _v0.a;
	var date = $justinmimbs$date$Date$toOrdinalDate(
		$justinmimbs$date$Date$RD(rd));
	return A3($justinmimbs$date$Date$toCalendarDateHelp, date.year, $elm$time$Time$Jan, date.ordinalDay);
};
var $justinmimbs$date$Date$add = F3(
	function (unit, n, _v0) {
		var rd = _v0.a;
		switch (unit.$) {
			case 'Years':
				return A3(
					$justinmimbs$date$Date$add,
					$justinmimbs$date$Date$Months,
					12 * n,
					$justinmimbs$date$Date$RD(rd));
			case 'Months':
				var date = $justinmimbs$date$Date$toCalendarDate(
					$justinmimbs$date$Date$RD(rd));
				var wholeMonths = ((12 * (date.year - 1)) + ($justinmimbs$date$Date$monthToNumber(date.month) - 1)) + n;
				var m = $justinmimbs$date$Date$numberToMonth(
					A2($elm$core$Basics$modBy, 12, wholeMonths) + 1);
				var y = A2($justinmimbs$date$Date$floorDiv, wholeMonths, 12) + 1;
				return $justinmimbs$date$Date$RD(
					($justinmimbs$date$Date$daysBeforeYear(y) + A2($justinmimbs$date$Date$daysBeforeMonth, y, m)) + A2(
						$elm$core$Basics$min,
						date.day,
						A2($justinmimbs$date$Date$daysInMonth, y, m)));
			case 'Weeks':
				return $justinmimbs$date$Date$RD(rd + (7 * n));
			default:
				return $justinmimbs$date$Date$RD(rd + n);
		}
	});
var $justinmimbs$date$Date$fromCalendarDate = F3(
	function (y, m, d) {
		return $justinmimbs$date$Date$RD(
			($justinmimbs$date$Date$daysBeforeYear(y) + A2($justinmimbs$date$Date$daysBeforeMonth, y, m)) + A3(
				$elm$core$Basics$clamp,
				1,
				A2($justinmimbs$date$Date$daysInMonth, y, m),
				d));
	});
var $justinmimbs$date$Date$fromPosix = F2(
	function (zone, posix) {
		return A3(
			$justinmimbs$date$Date$fromCalendarDate,
			A2($elm$time$Time$toYear, zone, posix),
			A2($elm$time$Time$toMonth, zone, posix),
			A2($elm$time$Time$toDay, zone, posix));
	});
var $justinmimbs$date$Date$toRataDie = function (_v0) {
	var rd = _v0.a;
	return rd;
};
var $justinmimbs$time_extra$Time$Extra$dateToMillis = function (date) {
	var daysSinceEpoch = $justinmimbs$date$Date$toRataDie(date) - 719163;
	return daysSinceEpoch * 86400000;
};
var $justinmimbs$time_extra$Time$Extra$timeFromClock = F4(
	function (hour, minute, second, millisecond) {
		return (((hour * 3600000) + (minute * 60000)) + (second * 1000)) + millisecond;
	});
var $justinmimbs$time_extra$Time$Extra$timeFromPosix = F2(
	function (zone, posix) {
		return A4(
			$justinmimbs$time_extra$Time$Extra$timeFromClock,
			A2($elm$time$Time$toHour, zone, posix),
			A2($elm$time$Time$toMinute, zone, posix),
			A2($elm$time$Time$toSecond, zone, posix),
			A2($elm$time$Time$toMillis, zone, posix));
	});
var $justinmimbs$time_extra$Time$Extra$toOffset = F2(
	function (zone, posix) {
		var millis = $elm$time$Time$posixToMillis(posix);
		var localMillis = $justinmimbs$time_extra$Time$Extra$dateToMillis(
			A2($justinmimbs$date$Date$fromPosix, zone, posix)) + A2($justinmimbs$time_extra$Time$Extra$timeFromPosix, zone, posix);
		return ((localMillis - millis) / 60000) | 0;
	});
var $justinmimbs$time_extra$Time$Extra$posixFromDateTime = F3(
	function (zone, date, time) {
		var millis = $justinmimbs$time_extra$Time$Extra$dateToMillis(date) + time;
		var offset0 = A2(
			$justinmimbs$time_extra$Time$Extra$toOffset,
			zone,
			$elm$time$Time$millisToPosix(millis));
		var posix1 = $elm$time$Time$millisToPosix(millis - (offset0 * 60000));
		var offset1 = A2($justinmimbs$time_extra$Time$Extra$toOffset, zone, posix1);
		if (_Utils_eq(offset0, offset1)) {
			return posix1;
		} else {
			var posix2 = $elm$time$Time$millisToPosix(millis - (offset1 * 60000));
			var offset2 = A2($justinmimbs$time_extra$Time$Extra$toOffset, zone, posix2);
			return _Utils_eq(offset1, offset2) ? posix2 : posix1;
		}
	});
var $justinmimbs$time_extra$Time$Extra$add = F4(
	function (interval, n, zone, posix) {
		add:
		while (true) {
			switch (interval.$) {
				case 'Millisecond':
					return $elm$time$Time$millisToPosix(
						$elm$time$Time$posixToMillis(posix) + n);
				case 'Second':
					var $temp$interval = $justinmimbs$time_extra$Time$Extra$Millisecond,
						$temp$n = n * 1000,
						$temp$zone = zone,
						$temp$posix = posix;
					interval = $temp$interval;
					n = $temp$n;
					zone = $temp$zone;
					posix = $temp$posix;
					continue add;
				case 'Minute':
					var $temp$interval = $justinmimbs$time_extra$Time$Extra$Millisecond,
						$temp$n = n * 60000,
						$temp$zone = zone,
						$temp$posix = posix;
					interval = $temp$interval;
					n = $temp$n;
					zone = $temp$zone;
					posix = $temp$posix;
					continue add;
				case 'Hour':
					var $temp$interval = $justinmimbs$time_extra$Time$Extra$Millisecond,
						$temp$n = n * 3600000,
						$temp$zone = zone,
						$temp$posix = posix;
					interval = $temp$interval;
					n = $temp$n;
					zone = $temp$zone;
					posix = $temp$posix;
					continue add;
				case 'Day':
					return A3(
						$justinmimbs$time_extra$Time$Extra$posixFromDateTime,
						zone,
						A3(
							$justinmimbs$date$Date$add,
							$justinmimbs$date$Date$Days,
							n,
							A2($justinmimbs$date$Date$fromPosix, zone, posix)),
						A2($justinmimbs$time_extra$Time$Extra$timeFromPosix, zone, posix));
				case 'Month':
					return A3(
						$justinmimbs$time_extra$Time$Extra$posixFromDateTime,
						zone,
						A3(
							$justinmimbs$date$Date$add,
							$justinmimbs$date$Date$Months,
							n,
							A2($justinmimbs$date$Date$fromPosix, zone, posix)),
						A2($justinmimbs$time_extra$Time$Extra$timeFromPosix, zone, posix));
				case 'Year':
					var $temp$interval = $justinmimbs$time_extra$Time$Extra$Month,
						$temp$n = n * 12,
						$temp$zone = zone,
						$temp$posix = posix;
					interval = $temp$interval;
					n = $temp$n;
					zone = $temp$zone;
					posix = $temp$posix;
					continue add;
				case 'Quarter':
					var $temp$interval = $justinmimbs$time_extra$Time$Extra$Month,
						$temp$n = n * 3,
						$temp$zone = zone,
						$temp$posix = posix;
					interval = $temp$interval;
					n = $temp$n;
					zone = $temp$zone;
					posix = $temp$posix;
					continue add;
				case 'Week':
					var $temp$interval = $justinmimbs$time_extra$Time$Extra$Day,
						$temp$n = n * 7,
						$temp$zone = zone,
						$temp$posix = posix;
					interval = $temp$interval;
					n = $temp$n;
					zone = $temp$zone;
					posix = $temp$posix;
					continue add;
				default:
					var weekday = interval;
					var $temp$interval = $justinmimbs$time_extra$Time$Extra$Day,
						$temp$n = n * 7,
						$temp$zone = zone,
						$temp$posix = posix;
					interval = $temp$interval;
					n = $temp$n;
					zone = $temp$zone;
					posix = $temp$posix;
					continue add;
			}
		}
	});
var $justinmimbs$time_extra$Time$Extra$Week = {$: 'Week'};
var $justinmimbs$date$Date$Day = {$: 'Day'};
var $justinmimbs$date$Date$Friday = {$: 'Friday'};
var $justinmimbs$date$Date$Monday = {$: 'Monday'};
var $justinmimbs$date$Date$Month = {$: 'Month'};
var $justinmimbs$date$Date$Quarter = {$: 'Quarter'};
var $justinmimbs$date$Date$Saturday = {$: 'Saturday'};
var $justinmimbs$date$Date$Sunday = {$: 'Sunday'};
var $justinmimbs$date$Date$Thursday = {$: 'Thursday'};
var $justinmimbs$date$Date$Tuesday = {$: 'Tuesday'};
var $justinmimbs$date$Date$Wednesday = {$: 'Wednesday'};
var $justinmimbs$date$Date$Week = {$: 'Week'};
var $justinmimbs$date$Date$Year = {$: 'Year'};
var $justinmimbs$date$Date$weekdayNumber = function (_v0) {
	var rd = _v0.a;
	var _v1 = A2($elm$core$Basics$modBy, 7, rd);
	if (!_v1) {
		return 7;
	} else {
		var n = _v1;
		return n;
	}
};
var $justinmimbs$date$Date$weekdayToNumber = function (wd) {
	switch (wd.$) {
		case 'Mon':
			return 1;
		case 'Tue':
			return 2;
		case 'Wed':
			return 3;
		case 'Thu':
			return 4;
		case 'Fri':
			return 5;
		case 'Sat':
			return 6;
		default:
			return 7;
	}
};
var $justinmimbs$date$Date$daysSincePreviousWeekday = F2(
	function (wd, date) {
		return A2(
			$elm$core$Basics$modBy,
			7,
			($justinmimbs$date$Date$weekdayNumber(date) + 7) - $justinmimbs$date$Date$weekdayToNumber(wd));
	});
var $justinmimbs$date$Date$firstOfMonth = F2(
	function (y, m) {
		return $justinmimbs$date$Date$RD(
			($justinmimbs$date$Date$daysBeforeYear(y) + A2($justinmimbs$date$Date$daysBeforeMonth, y, m)) + 1);
	});
var $justinmimbs$date$Date$firstOfYear = function (y) {
	return $justinmimbs$date$Date$RD(
		$justinmimbs$date$Date$daysBeforeYear(y) + 1);
};
var $justinmimbs$date$Date$month = A2(
	$elm$core$Basics$composeR,
	$justinmimbs$date$Date$toCalendarDate,
	function ($) {
		return $.month;
	});
var $justinmimbs$date$Date$monthToQuarter = function (m) {
	return (($justinmimbs$date$Date$monthToNumber(m) + 2) / 3) | 0;
};
var $justinmimbs$date$Date$quarter = A2($elm$core$Basics$composeR, $justinmimbs$date$Date$month, $justinmimbs$date$Date$monthToQuarter);
var $justinmimbs$date$Date$quarterToMonth = function (q) {
	return $justinmimbs$date$Date$numberToMonth((q * 3) - 2);
};
var $justinmimbs$date$Date$floor = F2(
	function (interval, date) {
		var rd = date.a;
		switch (interval.$) {
			case 'Year':
				return $justinmimbs$date$Date$firstOfYear(
					$justinmimbs$date$Date$year(date));
			case 'Quarter':
				return A2(
					$justinmimbs$date$Date$firstOfMonth,
					$justinmimbs$date$Date$year(date),
					$justinmimbs$date$Date$quarterToMonth(
						$justinmimbs$date$Date$quarter(date)));
			case 'Month':
				return A2(
					$justinmimbs$date$Date$firstOfMonth,
					$justinmimbs$date$Date$year(date),
					$justinmimbs$date$Date$month(date));
			case 'Week':
				return $justinmimbs$date$Date$RD(
					rd - A2($justinmimbs$date$Date$daysSincePreviousWeekday, $elm$time$Time$Mon, date));
			case 'Monday':
				return $justinmimbs$date$Date$RD(
					rd - A2($justinmimbs$date$Date$daysSincePreviousWeekday, $elm$time$Time$Mon, date));
			case 'Tuesday':
				return $justinmimbs$date$Date$RD(
					rd - A2($justinmimbs$date$Date$daysSincePreviousWeekday, $elm$time$Time$Tue, date));
			case 'Wednesday':
				return $justinmimbs$date$Date$RD(
					rd - A2($justinmimbs$date$Date$daysSincePreviousWeekday, $elm$time$Time$Wed, date));
			case 'Thursday':
				return $justinmimbs$date$Date$RD(
					rd - A2($justinmimbs$date$Date$daysSincePreviousWeekday, $elm$time$Time$Thu, date));
			case 'Friday':
				return $justinmimbs$date$Date$RD(
					rd - A2($justinmimbs$date$Date$daysSincePreviousWeekday, $elm$time$Time$Fri, date));
			case 'Saturday':
				return $justinmimbs$date$Date$RD(
					rd - A2($justinmimbs$date$Date$daysSincePreviousWeekday, $elm$time$Time$Sat, date));
			case 'Sunday':
				return $justinmimbs$date$Date$RD(
					rd - A2($justinmimbs$date$Date$daysSincePreviousWeekday, $elm$time$Time$Sun, date));
			default:
				return date;
		}
	});
var $justinmimbs$time_extra$Time$Extra$floorDate = F3(
	function (dateInterval, zone, posix) {
		return A3(
			$justinmimbs$time_extra$Time$Extra$posixFromDateTime,
			zone,
			A2(
				$justinmimbs$date$Date$floor,
				dateInterval,
				A2($justinmimbs$date$Date$fromPosix, zone, posix)),
			0);
	});
var $justinmimbs$time_extra$Time$Extra$floor = F3(
	function (interval, zone, posix) {
		switch (interval.$) {
			case 'Millisecond':
				return posix;
			case 'Second':
				return A3(
					$justinmimbs$time_extra$Time$Extra$posixFromDateTime,
					zone,
					A2($justinmimbs$date$Date$fromPosix, zone, posix),
					A4(
						$justinmimbs$time_extra$Time$Extra$timeFromClock,
						A2($elm$time$Time$toHour, zone, posix),
						A2($elm$time$Time$toMinute, zone, posix),
						A2($elm$time$Time$toSecond, zone, posix),
						0));
			case 'Minute':
				return A3(
					$justinmimbs$time_extra$Time$Extra$posixFromDateTime,
					zone,
					A2($justinmimbs$date$Date$fromPosix, zone, posix),
					A4(
						$justinmimbs$time_extra$Time$Extra$timeFromClock,
						A2($elm$time$Time$toHour, zone, posix),
						A2($elm$time$Time$toMinute, zone, posix),
						0,
						0));
			case 'Hour':
				return A3(
					$justinmimbs$time_extra$Time$Extra$posixFromDateTime,
					zone,
					A2($justinmimbs$date$Date$fromPosix, zone, posix),
					A4(
						$justinmimbs$time_extra$Time$Extra$timeFromClock,
						A2($elm$time$Time$toHour, zone, posix),
						0,
						0,
						0));
			case 'Day':
				return A3($justinmimbs$time_extra$Time$Extra$floorDate, $justinmimbs$date$Date$Day, zone, posix);
			case 'Month':
				return A3($justinmimbs$time_extra$Time$Extra$floorDate, $justinmimbs$date$Date$Month, zone, posix);
			case 'Year':
				return A3($justinmimbs$time_extra$Time$Extra$floorDate, $justinmimbs$date$Date$Year, zone, posix);
			case 'Quarter':
				return A3($justinmimbs$time_extra$Time$Extra$floorDate, $justinmimbs$date$Date$Quarter, zone, posix);
			case 'Week':
				return A3($justinmimbs$time_extra$Time$Extra$floorDate, $justinmimbs$date$Date$Week, zone, posix);
			case 'Monday':
				return A3($justinmimbs$time_extra$Time$Extra$floorDate, $justinmimbs$date$Date$Monday, zone, posix);
			case 'Tuesday':
				return A3($justinmimbs$time_extra$Time$Extra$floorDate, $justinmimbs$date$Date$Tuesday, zone, posix);
			case 'Wednesday':
				return A3($justinmimbs$time_extra$Time$Extra$floorDate, $justinmimbs$date$Date$Wednesday, zone, posix);
			case 'Thursday':
				return A3($justinmimbs$time_extra$Time$Extra$floorDate, $justinmimbs$date$Date$Thursday, zone, posix);
			case 'Friday':
				return A3($justinmimbs$time_extra$Time$Extra$floorDate, $justinmimbs$date$Date$Friday, zone, posix);
			case 'Saturday':
				return A3($justinmimbs$time_extra$Time$Extra$floorDate, $justinmimbs$date$Date$Saturday, zone, posix);
			default:
				return A3($justinmimbs$time_extra$Time$Extra$floorDate, $justinmimbs$date$Date$Sunday, zone, posix);
		}
	});
var $justinmimbs$time_extra$Time$Extra$ceiling = F3(
	function (interval, zone, posix) {
		var floored = A3($justinmimbs$time_extra$Time$Extra$floor, interval, zone, posix);
		return _Utils_eq(floored, posix) ? posix : A4($justinmimbs$time_extra$Time$Extra$add, interval, 1, zone, floored);
	});
var $terezka$intervals$Intervals$Time$ceilingDay = F3(
	function (zone, mult, stamp) {
		return (mult === 7) ? A3($justinmimbs$time_extra$Time$Extra$ceiling, $justinmimbs$time_extra$Time$Extra$Week, zone, stamp) : A3($justinmimbs$time_extra$Time$Extra$ceiling, $justinmimbs$time_extra$Time$Extra$Day, zone, stamp);
	});
var $justinmimbs$time_extra$Time$Extra$Hour = {$: 'Hour'};
var $justinmimbs$time_extra$Time$Extra$partsToPosix = F2(
	function (zone, _v0) {
		var year = _v0.year;
		var month = _v0.month;
		var day = _v0.day;
		var hour = _v0.hour;
		var minute = _v0.minute;
		var second = _v0.second;
		var millisecond = _v0.millisecond;
		return A3(
			$justinmimbs$time_extra$Time$Extra$posixFromDateTime,
			zone,
			A3($justinmimbs$date$Date$fromCalendarDate, year, month, day),
			A4(
				$justinmimbs$time_extra$Time$Extra$timeFromClock,
				A3($elm$core$Basics$clamp, 0, 23, hour),
				A3($elm$core$Basics$clamp, 0, 59, minute),
				A3($elm$core$Basics$clamp, 0, 59, second),
				A3($elm$core$Basics$clamp, 0, 999, millisecond)));
	});
var $justinmimbs$time_extra$Time$Extra$posixToParts = F2(
	function (zone, posix) {
		return {
			day: A2($elm$time$Time$toDay, zone, posix),
			hour: A2($elm$time$Time$toHour, zone, posix),
			millisecond: A2($elm$time$Time$toMillis, zone, posix),
			minute: A2($elm$time$Time$toMinute, zone, posix),
			month: A2($elm$time$Time$toMonth, zone, posix),
			second: A2($elm$time$Time$toSecond, zone, posix),
			year: A2($elm$time$Time$toYear, zone, posix)
		};
	});
var $terezka$intervals$Intervals$Time$ceilingHour = F3(
	function (zone, mult, stamp) {
		var parts = A2(
			$justinmimbs$time_extra$Time$Extra$posixToParts,
			zone,
			A3($justinmimbs$time_extra$Time$Extra$ceiling, $justinmimbs$time_extra$Time$Extra$Hour, zone, stamp));
		var rem = parts.hour % mult;
		return (!rem) ? A2($justinmimbs$time_extra$Time$Extra$partsToPosix, zone, parts) : A4($justinmimbs$time_extra$Time$Extra$add, $justinmimbs$time_extra$Time$Extra$Hour, mult - rem, zone, stamp);
	});
var $justinmimbs$time_extra$Time$Extra$Minute = {$: 'Minute'};
var $terezka$intervals$Intervals$Time$ceilingMinute = F3(
	function (zone, mult, stamp) {
		var parts = A2(
			$justinmimbs$time_extra$Time$Extra$posixToParts,
			zone,
			A3($justinmimbs$time_extra$Time$Extra$ceiling, $justinmimbs$time_extra$Time$Extra$Minute, zone, stamp));
		var rem = parts.minute % mult;
		return (!rem) ? A2($justinmimbs$time_extra$Time$Extra$partsToPosix, zone, parts) : A4($justinmimbs$time_extra$Time$Extra$add, $justinmimbs$time_extra$Time$Extra$Minute, mult - rem, zone, stamp);
	});
var $terezka$intervals$Intervals$Time$intAsMonth = function (_int) {
	switch (_int) {
		case 1:
			return $elm$time$Time$Jan;
		case 2:
			return $elm$time$Time$Feb;
		case 3:
			return $elm$time$Time$Mar;
		case 4:
			return $elm$time$Time$Apr;
		case 5:
			return $elm$time$Time$May;
		case 6:
			return $elm$time$Time$Jun;
		case 7:
			return $elm$time$Time$Jul;
		case 8:
			return $elm$time$Time$Aug;
		case 9:
			return $elm$time$Time$Sep;
		case 10:
			return $elm$time$Time$Oct;
		case 11:
			return $elm$time$Time$Nov;
		case 12:
			return $elm$time$Time$Dec;
		default:
			return $elm$time$Time$Dec;
	}
};
var $terezka$intervals$Intervals$Time$monthAsInt = function (month) {
	switch (month.$) {
		case 'Jan':
			return 1;
		case 'Feb':
			return 2;
		case 'Mar':
			return 3;
		case 'Apr':
			return 4;
		case 'May':
			return 5;
		case 'Jun':
			return 6;
		case 'Jul':
			return 7;
		case 'Aug':
			return 8;
		case 'Sep':
			return 9;
		case 'Oct':
			return 10;
		case 'Nov':
			return 11;
		default:
			return 12;
	}
};
var $terezka$intervals$Intervals$Time$ceilingMonth = F3(
	function (zone, mult, stamp) {
		var parts = A2(
			$justinmimbs$time_extra$Time$Extra$posixToParts,
			zone,
			A3($justinmimbs$time_extra$Time$Extra$ceiling, $justinmimbs$time_extra$Time$Extra$Month, zone, stamp));
		var monthInt = $terezka$intervals$Intervals$Time$monthAsInt(parts.month);
		var rem = (monthInt - 1) % mult;
		var newMonth = (!rem) ? monthInt : ((monthInt - rem) + mult);
		return A2(
			$justinmimbs$time_extra$Time$Extra$partsToPosix,
			zone,
			(newMonth > 12) ? _Utils_update(
				parts,
				{
					month: $terezka$intervals$Intervals$Time$intAsMonth(newMonth - 12),
					year: parts.year + 1
				}) : _Utils_update(
				parts,
				{
					month: $terezka$intervals$Intervals$Time$intAsMonth(newMonth)
				}));
	});
var $terezka$intervals$Intervals$Time$ceilingMs = F3(
	function (zone, mult, stamp) {
		var parts = A2($justinmimbs$time_extra$Time$Extra$posixToParts, zone, stamp);
		var rem = parts.millisecond % mult;
		return (!rem) ? A2($justinmimbs$time_extra$Time$Extra$partsToPosix, zone, parts) : A4($justinmimbs$time_extra$Time$Extra$add, $justinmimbs$time_extra$Time$Extra$Millisecond, mult - rem, zone, stamp);
	});
var $justinmimbs$time_extra$Time$Extra$Second = {$: 'Second'};
var $terezka$intervals$Intervals$Time$ceilingSecond = F3(
	function (zone, mult, stamp) {
		var parts = A2(
			$justinmimbs$time_extra$Time$Extra$posixToParts,
			zone,
			A3($justinmimbs$time_extra$Time$Extra$ceiling, $justinmimbs$time_extra$Time$Extra$Second, zone, stamp));
		var rem = parts.second % mult;
		return (!rem) ? A2($justinmimbs$time_extra$Time$Extra$partsToPosix, zone, parts) : A4($justinmimbs$time_extra$Time$Extra$add, $justinmimbs$time_extra$Time$Extra$Second, mult - rem, zone, stamp);
	});
var $justinmimbs$time_extra$Time$Extra$Year = {$: 'Year'};
var $terezka$intervals$Intervals$Time$ceilingYear = F3(
	function (zone, mult, stamp) {
		var parts = A2(
			$justinmimbs$time_extra$Time$Extra$posixToParts,
			zone,
			A3($justinmimbs$time_extra$Time$Extra$ceiling, $justinmimbs$time_extra$Time$Extra$Year, zone, stamp));
		var rem = parts.year % mult;
		var newYear = (!rem) ? parts.year : ((parts.year - rem) + mult);
		return A2(
			$justinmimbs$time_extra$Time$Extra$partsToPosix,
			zone,
			_Utils_update(
				parts,
				{year: newYear}));
	});
var $terezka$intervals$Intervals$Time$ceilingUnit = F3(
	function (zone, unit, mult) {
		switch (unit.$) {
			case 'Millisecond':
				return A2($terezka$intervals$Intervals$Time$ceilingMs, zone, mult);
			case 'Second':
				return A2($terezka$intervals$Intervals$Time$ceilingSecond, zone, mult);
			case 'Minute':
				return A2($terezka$intervals$Intervals$Time$ceilingMinute, zone, mult);
			case 'Hour':
				return A2($terezka$intervals$Intervals$Time$ceilingHour, zone, mult);
			case 'Day':
				return A2($terezka$intervals$Intervals$Time$ceilingDay, zone, mult);
			case 'Month':
				return A2($terezka$intervals$Intervals$Time$ceilingMonth, zone, mult);
			default:
				return A2($terezka$intervals$Intervals$Time$ceilingYear, zone, mult);
		}
	});
var $terezka$intervals$Intervals$Time$Day = {$: 'Day'};
var $terezka$intervals$Intervals$Time$Hour = {$: 'Hour'};
var $terezka$intervals$Intervals$Time$Millisecond = {$: 'Millisecond'};
var $terezka$intervals$Intervals$Time$Minute = {$: 'Minute'};
var $terezka$intervals$Intervals$Time$Month = {$: 'Month'};
var $terezka$intervals$Intervals$Time$Second = {$: 'Second'};
var $terezka$intervals$Intervals$Time$Year = {$: 'Year'};
var $terezka$intervals$Intervals$Time$getChange = F3(
	function (zone, a, b) {
		var bP = A2($justinmimbs$time_extra$Time$Extra$posixToParts, zone, b);
		var aP = A2($justinmimbs$time_extra$Time$Extra$posixToParts, zone, a);
		return (!_Utils_eq(aP.year, bP.year)) ? $terezka$intervals$Intervals$Time$Year : ((!_Utils_eq(aP.month, bP.month)) ? $terezka$intervals$Intervals$Time$Month : ((!_Utils_eq(aP.day, bP.day)) ? $terezka$intervals$Intervals$Time$Day : ((!_Utils_eq(aP.hour, bP.hour)) ? $terezka$intervals$Intervals$Time$Hour : ((!_Utils_eq(aP.minute, bP.minute)) ? $terezka$intervals$Intervals$Time$Minute : ((!_Utils_eq(aP.second, bP.second)) ? $terezka$intervals$Intervals$Time$Second : $terezka$intervals$Intervals$Time$Millisecond)))));
	});
var $danhandrea$elm_time_extra$Util$isLeapYear = function (year) {
	return (!A2($elm$core$Basics$modBy, 400, year)) || ((!(!A2($elm$core$Basics$modBy, 100, year))) && (!A2($elm$core$Basics$modBy, 4, year)));
};
var $danhandrea$elm_time_extra$Month$days = F2(
	function (year, month) {
		switch (month.$) {
			case 'Jan':
				return 31;
			case 'Feb':
				return $danhandrea$elm_time_extra$Util$isLeapYear(year) ? 29 : 28;
			case 'Mar':
				return 31;
			case 'Apr':
				return 30;
			case 'May':
				return 31;
			case 'Jun':
				return 30;
			case 'Jul':
				return 31;
			case 'Aug':
				return 31;
			case 'Sep':
				return 30;
			case 'Oct':
				return 31;
			case 'Nov':
				return 30;
			default:
				return 31;
		}
	});
var $danhandrea$elm_time_extra$TimeExtra$daysInMonth = $danhandrea$elm_time_extra$Month$days;
var $terezka$intervals$Intervals$Time$toMs = $elm$time$Time$posixToMillis;
var $terezka$intervals$Intervals$Time$getDiff = F3(
	function (zone, a, b) {
		var _v0 = (_Utils_cmp(
			$terezka$intervals$Intervals$Time$toMs(a),
			$terezka$intervals$Intervals$Time$toMs(b)) < 0) ? _Utils_Tuple2(
			A2($justinmimbs$time_extra$Time$Extra$posixToParts, zone, a),
			A2($justinmimbs$time_extra$Time$Extra$posixToParts, zone, b)) : _Utils_Tuple2(
			A2($justinmimbs$time_extra$Time$Extra$posixToParts, zone, b),
			A2($justinmimbs$time_extra$Time$Extra$posixToParts, zone, a));
		var aP = _v0.a;
		var bP = _v0.b;
		var dMsX = bP.millisecond - aP.millisecond;
		var dMs = (dMsX < 0) ? (1000 + dMsX) : dMsX;
		var dSecondX = (bP.second - aP.second) + ((dMsX < 0) ? (-1) : 0);
		var dMinuteX = (bP.minute - aP.minute) + ((dSecondX < 0) ? (-1) : 0);
		var dHourX = (bP.hour - aP.hour) + ((dMinuteX < 0) ? (-1) : 0);
		var dDayX = (bP.day - aP.day) + ((dHourX < 0) ? (-1) : 0);
		var dDay = (dDayX < 0) ? (A2($danhandrea$elm_time_extra$TimeExtra$daysInMonth, bP.year, bP.month) + dDayX) : dDayX;
		var dMonthX = ($terezka$intervals$Intervals$Time$monthAsInt(bP.month) - $terezka$intervals$Intervals$Time$monthAsInt(aP.month)) + ((dDayX < 0) ? (-1) : 0);
		var dMonth = (dMonthX < 0) ? (12 + dMonthX) : dMonthX;
		var dHour = (dHourX < 0) ? (24 + dHourX) : dHourX;
		var dMinute = (dMinuteX < 0) ? (60 + dMinuteX) : dMinuteX;
		var dSecond = (dSecondX < 0) ? (60 + dSecondX) : dSecondX;
		var dYearX = (bP.year - aP.year) + ((dMonthX < 0) ? (-1) : 0);
		var dYear = (dYearX < 0) ? ($terezka$intervals$Intervals$Time$monthAsInt(bP.month) + dYearX) : dYearX;
		return {day: dDay, hour: dHour, millisecond: dMs, minute: dMinute, month: dMonth, second: dSecond, year: dYear};
	});
var $terezka$intervals$Intervals$Time$oneSecond = 1000;
var $terezka$intervals$Intervals$Time$oneMinute = $terezka$intervals$Intervals$Time$oneSecond * 60;
var $terezka$intervals$Intervals$Time$oneHour = $terezka$intervals$Intervals$Time$oneMinute * 60;
var $terezka$intervals$Intervals$Time$oneDay = $terezka$intervals$Intervals$Time$oneHour * 24;
var $terezka$intervals$Intervals$Time$oneMs = 1;
var $terezka$intervals$Intervals$Time$getNumOfTicks = F5(
	function (zone, unit, mult, a, b) {
		var div = F2(
			function (n1, n2) {
				return $elm$core$Basics$floor(n1 / n2);
			});
		var timeDiff = function (ms) {
			var ceiled = A4($terezka$intervals$Intervals$Time$ceilingUnit, zone, unit, mult, a);
			return (_Utils_cmp(
				$terezka$intervals$Intervals$Time$toMs(ceiled),
				$terezka$intervals$Intervals$Time$toMs(b)) > 0) ? (-1) : A2(
				div,
				A2(
					div,
					$terezka$intervals$Intervals$Time$toMs(b) - $terezka$intervals$Intervals$Time$toMs(ceiled),
					ms),
				mult);
		};
		var diff = function (property) {
			var ceiled = A4($terezka$intervals$Intervals$Time$ceilingUnit, zone, unit, mult, a);
			return (_Utils_cmp(
				$terezka$intervals$Intervals$Time$toMs(ceiled),
				$terezka$intervals$Intervals$Time$toMs(b)) > 0) ? (-1) : A2(
				div,
				property(
					A3($terezka$intervals$Intervals$Time$getDiff, zone, ceiled, b)),
				mult);
		};
		switch (unit.$) {
			case 'Millisecond':
				return timeDiff($terezka$intervals$Intervals$Time$oneMs) + 1;
			case 'Second':
				return timeDiff($terezka$intervals$Intervals$Time$oneSecond) + 1;
			case 'Minute':
				return timeDiff($terezka$intervals$Intervals$Time$oneMinute) + 1;
			case 'Hour':
				return timeDiff($terezka$intervals$Intervals$Time$oneHour) + 1;
			case 'Day':
				return timeDiff($terezka$intervals$Intervals$Time$oneDay) + 1;
			case 'Month':
				return diff(
					function (d) {
						return d.month + (d.year * 12);
					}) + 1;
			default:
				return diff(
					function ($) {
						return $.year;
					}) + 1;
		}
	});
var $terezka$intervals$Intervals$Time$largerUnit = function (unit) {
	switch (unit.$) {
		case 'Millisecond':
			return $elm$core$Maybe$Just($terezka$intervals$Intervals$Time$Second);
		case 'Second':
			return $elm$core$Maybe$Just($terezka$intervals$Intervals$Time$Minute);
		case 'Minute':
			return $elm$core$Maybe$Just($terezka$intervals$Intervals$Time$Hour);
		case 'Hour':
			return $elm$core$Maybe$Just($terezka$intervals$Intervals$Time$Day);
		case 'Day':
			return $elm$core$Maybe$Just($terezka$intervals$Intervals$Time$Month);
		case 'Month':
			return $elm$core$Maybe$Just($terezka$intervals$Intervals$Time$Year);
		default:
			return $elm$core$Maybe$Nothing;
	}
};
var $terezka$intervals$Intervals$Time$niceMultiples = function (unit) {
	switch (unit.$) {
		case 'Millisecond':
			return _List_fromArray(
				[1, 2, 5, 10, 20, 25, 50, 100, 200, 500]);
		case 'Second':
			return _List_fromArray(
				[1, 2, 5, 10, 15, 30]);
		case 'Minute':
			return _List_fromArray(
				[1, 2, 5, 10, 15, 30]);
		case 'Hour':
			return _List_fromArray(
				[1, 2, 3, 4, 6, 8, 12]);
		case 'Day':
			return _List_fromArray(
				[1, 2, 3, 7, 14]);
		case 'Month':
			return _List_fromArray(
				[1, 2, 3, 4, 6]);
		default:
			return _List_fromArray(
				[1, 2, 5, 10, 20, 25, 50, 100, 200, 500, 1000, 10000, 1000000, 10000000]);
	}
};
var $terezka$intervals$Intervals$Time$toBestUnit = F4(
	function (zone, amount, min, max) {
		var toNice = function (unit) {
			toNice:
			while (true) {
				var niceNums = $terezka$intervals$Intervals$Time$niceMultiples(unit);
				var maybeNiceNum = A2(
					$elm$core$List$filter,
					function (n) {
						return _Utils_cmp(
							A5($terezka$intervals$Intervals$Time$getNumOfTicks, zone, unit, n, min, max),
							amount) < 1;
					},
					niceNums);
				var div = F2(
					function (n1, n2) {
						return $elm$core$Basics$ceiling(n1 / n2);
					});
				var _v0 = $elm$core$List$head(maybeNiceNum);
				if (_v0.$ === 'Just') {
					var niceNum = _v0.a;
					return _Utils_Tuple2(unit, niceNum);
				} else {
					var _v1 = $terezka$intervals$Intervals$Time$largerUnit(unit);
					if (_v1.$ === 'Just') {
						var larger = _v1.a;
						var $temp$unit = larger;
						unit = $temp$unit;
						continue toNice;
					} else {
						return _Utils_Tuple2($terezka$intervals$Intervals$Time$Year, 100000000);
					}
				}
			}
		};
		return toNice($terezka$intervals$Intervals$Time$Millisecond);
	});
var $terezka$intervals$Intervals$Time$toExtraUnit = function (unit) {
	switch (unit.$) {
		case 'Millisecond':
			return $justinmimbs$time_extra$Time$Extra$Millisecond;
		case 'Second':
			return $justinmimbs$time_extra$Time$Extra$Second;
		case 'Minute':
			return $justinmimbs$time_extra$Time$Extra$Minute;
		case 'Hour':
			return $justinmimbs$time_extra$Time$Extra$Hour;
		case 'Day':
			return $justinmimbs$time_extra$Time$Extra$Day;
		case 'Month':
			return $justinmimbs$time_extra$Time$Extra$Month;
		default:
			return $justinmimbs$time_extra$Time$Extra$Year;
	}
};
var $terezka$intervals$Intervals$Time$unitToInt = function (unit) {
	switch (unit.$) {
		case 'Millisecond':
			return 0;
		case 'Second':
			return 1;
		case 'Minute':
			return 2;
		case 'Hour':
			return 3;
		case 'Day':
			return 4;
		case 'Month':
			return 5;
		default:
			return 6;
	}
};
var $terezka$intervals$Intervals$Time$values = F4(
	function (zone, maxMmount, min, max) {
		var _v0 = A4($terezka$intervals$Intervals$Time$toBestUnit, zone, maxMmount, min, max);
		var unit = _v0.a;
		var mult = _v0.b;
		var amount = A5($terezka$intervals$Intervals$Time$getNumOfTicks, zone, unit, mult, min, max);
		var initial = A4($terezka$intervals$Intervals$Time$ceilingUnit, zone, unit, mult, min);
		var tUnit = $terezka$intervals$Intervals$Time$toExtraUnit(unit);
		var toTick = F3(
			function (x, timestamp, change) {
				return {
					change: (_Utils_cmp(
						$terezka$intervals$Intervals$Time$unitToInt(change),
						$terezka$intervals$Intervals$Time$unitToInt(unit)) > 0) ? $elm$core$Maybe$Just(change) : $elm$core$Maybe$Nothing,
					isFirst: !x,
					multiple: mult,
					timestamp: timestamp,
					unit: unit,
					zone: zone
				};
			});
		var toTicks = F2(
			function (xs, acc) {
				toTicks:
				while (true) {
					if (xs.b) {
						var x = xs.a;
						var rest = xs.b;
						var prev = A4($justinmimbs$time_extra$Time$Extra$add, tUnit, (x - 1) * mult, zone, initial);
						var curr = A4($justinmimbs$time_extra$Time$Extra$add, tUnit, x * mult, zone, initial);
						var change = A3($terezka$intervals$Intervals$Time$getChange, zone, prev, curr);
						var $temp$xs = rest,
							$temp$acc = A2(
							$elm$core$List$cons,
							A3(toTick, x, curr, change),
							acc);
						xs = $temp$xs;
						acc = $temp$acc;
						continue toTicks;
					} else {
						return acc;
					}
				}
			});
		return $elm$core$List$reverse(
			A2(
				toTicks,
				A2($elm$core$List$range, 0, amount - 1),
				_List_Nil));
	});
var $terezka$intervals$Intervals$times = F3(
	function (zone, amount, range) {
		var toUnit = function (unit) {
			switch (unit.$) {
				case 'Millisecond':
					return $terezka$intervals$Intervals$Millisecond;
				case 'Second':
					return $terezka$intervals$Intervals$Second;
				case 'Minute':
					return $terezka$intervals$Intervals$Minute;
				case 'Hour':
					return $terezka$intervals$Intervals$Hour;
				case 'Day':
					return $terezka$intervals$Intervals$Day;
				case 'Month':
					return $terezka$intervals$Intervals$Month;
				default:
					return $terezka$intervals$Intervals$Year;
			}
		};
		var translateUnit = function (time) {
			return {
				change: A2($elm$core$Maybe$map, toUnit, time.change),
				isFirst: time.isFirst,
				multiple: time.multiple,
				timestamp: time.timestamp,
				unit: toUnit(time.unit),
				zone: time.zone
			};
		};
		var fromMs = function (ts) {
			return $elm$time$Time$millisToPosix(
				$elm$core$Basics$round(ts));
		};
		return A2(
			$elm$core$List$map,
			translateUnit,
			A4(
				$terezka$intervals$Intervals$Time$values,
				zone,
				amount,
				fromMs(range.min),
				fromMs(range.max)));
	});
var $author$project$Internal$Svg$times = function (zone) {
	return $author$project$Internal$Svg$Generator(
		F2(
			function (i, b) {
				return A3(
					$terezka$intervals$Intervals$times,
					zone,
					i,
					{max: b.max, min: b.min});
			}));
};
var $author$project$Chart$Svg$times = $author$project$Internal$Svg$times;
var $author$project$Chart$generateValues = F4(
	function (amount, tick, maybeFormat, axis) {
		var toTickValues = F2(
			function (toValue, toString) {
				return $elm$core$List$map(
					function (i) {
						return {
							label: function () {
								if (maybeFormat.$ === 'Just') {
									var formatter = maybeFormat.a;
									return formatter(
										toValue(i));
								} else {
									return toString(i);
								}
							}(),
							value: toValue(i)
						};
					});
			});
		switch (tick.$) {
			case 'Floats':
				return A3(
					toTickValues,
					$elm$core$Basics$identity,
					$elm$core$String$fromFloat,
					A3($author$project$Chart$Svg$generate, amount, $author$project$Chart$Svg$floats, axis));
			case 'Ints':
				return A3(
					toTickValues,
					$elm$core$Basics$toFloat,
					$elm$core$String$fromInt,
					A3($author$project$Chart$Svg$generate, amount, $author$project$Chart$Svg$ints, axis));
			default:
				var zone = tick.a;
				return A3(
					toTickValues,
					A2(
						$elm$core$Basics$composeL,
						A2($elm$core$Basics$composeL, $elm$core$Basics$toFloat, $elm$time$Time$posixToMillis),
						function ($) {
							return $.timestamp;
						}),
					$author$project$Chart$Svg$formatTime(zone),
					A3(
						$author$project$Chart$Svg$generate,
						amount,
						$author$project$Chart$Svg$times(zone),
						axis));
		}
	});
var $author$project$Chart$yLabels = function (edits) {
	var toTicks = F2(
		function (p, config) {
			return A4(
				$author$project$Chart$generateValues,
				config.amount,
				config.generate,
				config.format,
				A3(
					$elm$core$List$foldl,
					F2(
						function (f, y) {
							return f(y);
						}),
					p.y,
					config.limits));
		});
	var toTickValues = F3(
		function (p, config, ts) {
			return (!config.grid) ? ts : _Utils_update(
				ts,
				{
					ys: _Utils_ap(
						ts.ys,
						A2(
							$elm$core$List$map,
							function ($) {
								return $.value;
							},
							A2(toTicks, p, config)))
				});
		});
	var toConfig = function (p) {
		return A2(
			$author$project$Internal$Helpers$apply,
			edits,
			{amount: 5, anchor: $elm$core$Maybe$Nothing, attrs: _List_Nil, color: '#808BAB', ellipsis: $elm$core$Maybe$Nothing, flip: false, fontSize: $elm$core$Maybe$Nothing, format: $elm$core$Maybe$Nothing, generate: $author$project$Internal$Svg$Floats, grid: false, limits: _List_Nil, pinned: $author$project$Chart$Attributes$zero, rotate: 0, uppercase: false, xOff: -10, yOff: 3});
	};
	return A3(
		$author$project$Chart$LabelsElement,
		toConfig,
		toTickValues,
		F2(
			function (p, config) {
				var _default = $author$project$Internal$Svg$defaultLabel;
				var toLabel = function (item) {
					return A4(
						$author$project$Internal$Svg$label,
						p,
						_Utils_update(
							_default,
							{
								anchor: function () {
									var _v0 = config.anchor;
									if (_v0.$ === 'Nothing') {
										return $elm$core$Maybe$Just(
											config.flip ? $author$project$Internal$Svg$Start : $author$project$Internal$Svg$End);
									} else {
										var anchor = _v0.a;
										return $elm$core$Maybe$Just(anchor);
									}
								}(),
								attrs: config.attrs,
								color: config.color,
								ellipsis: config.ellipsis,
								fontSize: config.fontSize,
								rotate: config.rotate,
								uppercase: config.uppercase,
								xOff: config.flip ? (-config.xOff) : config.xOff,
								yOff: config.yOff
							}),
						_List_fromArray(
							[
								$elm$svg$Svg$text(item.label)
							]),
						{
							x: config.pinned(p.x),
							y: item.value
						});
				};
				return A2(
					$elm$svg$Svg$g,
					_List_fromArray(
						[
							$elm$svg$Svg$Attributes$class('elm-charts__y-labels')
						]),
					A2(
						$elm$core$List$map,
						toLabel,
						A2(toTicks, p, config)));
			}));
};
var $author$project$Charts$Terminology$view = A2(
	$author$project$Chart$chart,
	_List_fromArray(
		[
			$author$project$Chart$Attributes$height(350),
			$author$project$Chart$Attributes$width(1000),
			$author$project$Chart$Attributes$margin(
			{bottom: 15, left: 25, right: 0, top: 0}),
			$author$project$Chart$Attributes$padding(
			{bottom: 30, left: 0, right: 0, top: 40})
		]),
	_List_fromArray(
		[
			$author$project$Chart$grid(_List_Nil),
			$author$project$Chart$yLabels(
			_List_fromArray(
				[$author$project$Chart$Attributes$withGrid])),
			$author$project$Chart$xAxis(
			_List_fromArray(
				[$author$project$Chart$Attributes$noArrow])),
			A3(
			$author$project$Chart$bars,
			_List_fromArray(
				[
					$author$project$Chart$Attributes$margin(0.2),
					$author$project$Chart$Attributes$spacing(0.15)
				]),
			_List_fromArray(
				[
					$author$project$Chart$stacked(
					_List_fromArray(
						[
							A2(
							$author$project$Chart$bar,
							function ($) {
								return $.a;
							},
							_List_fromArray(
								[
									$author$project$Chart$Attributes$opacity(0.8),
									$author$project$Chart$Attributes$borderWidth(1)
								])),
							A2(
							$author$project$Chart$bar,
							function ($) {
								return $.b;
							},
							_List_fromArray(
								[
									$author$project$Chart$Attributes$opacity(0.8),
									$author$project$Chart$Attributes$borderWidth(1)
								]))
						])),
					A2(
					$author$project$Chart$bar,
					function ($) {
						return $.c;
					},
					_List_fromArray(
						[
							$author$project$Chart$Attributes$opacity(0.8),
							$author$project$Chart$Attributes$borderWidth(1)
						]))
				]),
			$author$project$Charts$Terminology$data),
			$author$project$Chart$line(
			_List_fromArray(
				[
					$author$project$Chart$Attributes$color('#888'),
					$author$project$Chart$Attributes$tickLength(7),
					$author$project$Chart$Attributes$x1(2.5),
					$author$project$Chart$Attributes$x2(3.5),
					$author$project$Chart$Attributes$y1(4),
					$author$project$Chart$Attributes$moveDown(20)
				])),
			A3(
			$author$project$Chart$label,
			_List_fromArray(
				[
					$author$project$Chart$Attributes$moveDown(15)
				]),
			_List_fromArray(
				[
					$elm$svg$Svg$text('bin')
				]),
			{x: 3, y: 4}),
			$author$project$Chart$line(
			_List_fromArray(
				[
					$author$project$Chart$Attributes$color('#888'),
					$author$project$Chart$Attributes$tickLength(7),
					$author$project$Chart$Attributes$x1(2.5),
					$author$project$Chart$Attributes$x2(2.7),
					$author$project$Chart$Attributes$y1(3),
					$author$project$Chart$Attributes$moveUp(15)
				])),
			A3(
			$author$project$Chart$label,
			_List_fromArray(
				[
					$author$project$Chart$Attributes$moveUp(20)
				]),
			_List_fromArray(
				[
					$elm$svg$Svg$text('bin margin')
				]),
			{x: 2.6, y: 3}),
			$author$project$Chart$line(
			_List_fromArray(
				[
					$author$project$Chart$Attributes$color('#888'),
					$author$project$Chart$Attributes$tickLength(7),
					$author$project$Chart$Attributes$x1(2.925),
					$author$project$Chart$Attributes$x2(3.075),
					$author$project$Chart$Attributes$y1(3),
					$author$project$Chart$Attributes$moveUp(15)
				])),
			A3(
			$author$project$Chart$label,
			_List_fromArray(
				[
					$author$project$Chart$Attributes$moveUp(20)
				]),
			_List_fromArray(
				[
					$elm$svg$Svg$text('bin spacing')
				]),
			{x: 3, y: 3}),
			$author$project$Chart$line(
			_List_fromArray(
				[
					$author$project$Chart$Attributes$color('#888'),
					$author$project$Chart$Attributes$tickLength(7),
					$author$project$Chart$Attributes$tickDirection(360),
					$author$project$Chart$Attributes$x1(0.5),
					$author$project$Chart$Attributes$y1(0),
					$author$project$Chart$Attributes$y2(3),
					$author$project$Chart$Attributes$moveRight(26)
				])),
			A3(
			$author$project$Chart$label,
			_List_fromArray(
				[
					$author$project$Chart$Attributes$rotate(90),
					$author$project$Chart$Attributes$moveRight(18)
				]),
			_List_fromArray(
				[
					$elm$svg$Svg$text('stack')
				]),
			{x: 0.5, y: 1.5}),
			$author$project$Chart$line(
			_List_fromArray(
				[
					$author$project$Chart$Attributes$color('#888'),
					$author$project$Chart$Attributes$tickLength(7),
					$author$project$Chart$Attributes$tickDirection(360),
					$author$project$Chart$Attributes$x1(1.5),
					$author$project$Chart$Attributes$y1(0),
					$author$project$Chart$Attributes$y2(2),
					$author$project$Chart$Attributes$moveRight(26)
				])),
			A3(
			$author$project$Chart$label,
			_List_fromArray(
				[
					$author$project$Chart$Attributes$rotate(90),
					$author$project$Chart$Attributes$moveRight(18)
				]),
			_List_fromArray(
				[
					$elm$svg$Svg$text('bar #1 in stack')
				]),
			{x: 1.5, y: 1}),
			$author$project$Chart$line(
			_List_fromArray(
				[
					$author$project$Chart$Attributes$color('#888'),
					$author$project$Chart$Attributes$tickLength(7),
					$author$project$Chart$Attributes$tickDirection(360),
					$author$project$Chart$Attributes$x1(1.5),
					$author$project$Chart$Attributes$y1(2),
					$author$project$Chart$Attributes$y2(4),
					$author$project$Chart$Attributes$moveRight(26)
				])),
			A3(
			$author$project$Chart$label,
			_List_fromArray(
				[
					$author$project$Chart$Attributes$rotate(90),
					$author$project$Chart$Attributes$moveRight(18)
				]),
			_List_fromArray(
				[
					$elm$svg$Svg$text('bar #2 in stack')
				]),
			{x: 1.5, y: 3}),
			$author$project$Chart$line(
			_List_fromArray(
				[
					$author$project$Chart$Attributes$color('#888'),
					$author$project$Chart$Attributes$tickLength(7),
					$author$project$Chart$Attributes$tickDirection(360),
					$author$project$Chart$Attributes$x1(2),
					$author$project$Chart$Attributes$y1(0),
					$author$project$Chart$Attributes$y2(1),
					$author$project$Chart$Attributes$moveRight(5)
				])),
			A3(
			$author$project$Chart$label,
			_List_fromArray(
				[
					$author$project$Chart$Attributes$rotate(90)
				]),
			_List_fromArray(
				[
					$elm$svg$Svg$text('bar')
				]),
			{x: 2, y: 0.5}),
			$author$project$Chart$line(
			_List_fromArray(
				[
					$author$project$Chart$Attributes$color('#888'),
					$author$project$Chart$Attributes$x1(4),
					$author$project$Chart$Attributes$y1(0),
					$author$project$Chart$Attributes$x2Svg(-10),
					$author$project$Chart$Attributes$y2Svg(-10),
					$author$project$Chart$Attributes$break,
					$author$project$Chart$Attributes$flip,
					$author$project$Chart$Attributes$moveDown(15),
					$author$project$Chart$Attributes$moveLeft(10)
				])),
			A3(
			$author$project$Chart$label,
			_List_fromArray(
				[
					$author$project$Chart$Attributes$moveDown(37),
					$author$project$Chart$Attributes$moveLeft(25)
				]),
			_List_fromArray(
				[
					$elm$svg$Svg$text('bin label')
				]),
			{x: 4, y: 0}),
			A2(
			$author$project$Chart$binLabels,
			function ($) {
				return $.label;
			},
			_List_fromArray(
				[
					$author$project$Chart$Attributes$moveDown(20)
				])),
			$author$project$Chart$eachBar(
			F2(
				function (p, bar) {
					return ($author$project$Chart$Item$getData(bar).label === 'D') ? _List_fromArray(
						[
							A3(
							$author$project$Chart$label,
							_List_fromArray(
								[
									$author$project$Chart$Attributes$moveDown(20),
									$author$project$Chart$Attributes$color('white')
								]),
							_List_fromArray(
								[
									$elm$svg$Svg$text(
									$elm$core$String$fromFloat(
										$author$project$Chart$Item$getY(bar)))
								]),
							A2($author$project$Chart$Item$getTop, p, bar)),
							$author$project$Chart$line(
							_List_fromArray(
								[
									$author$project$Chart$Attributes$x1(
									A2($author$project$Chart$Item$getTop, p, bar).x),
									$author$project$Chart$Attributes$y1(
									A2($author$project$Chart$Item$getTop, p, bar).y),
									$author$project$Chart$Attributes$x2Svg(-25),
									$author$project$Chart$Attributes$moveDown(16),
									$author$project$Chart$Attributes$moveLeft(10),
									$author$project$Chart$Attributes$color('#888')
								])),
							A3(
							$author$project$Chart$label,
							_List_fromArray(
								[
									$author$project$Chart$Attributes$moveDown(10),
									$author$project$Chart$Attributes$moveLeft(40),
									$author$project$Chart$Attributes$alignRight,
									$author$project$Chart$Attributes$rotate(90)
								]),
							_List_fromArray(
								[
									$elm$svg$Svg$text('bar label')
								]),
							A2($author$project$Chart$Item$getTop, p, bar))
						]) : _List_Nil;
				})),
			$author$project$Chart$eachStack(
			F2(
				function (p, stack) {
					if ($author$project$Chart$Item$getOneData(stack).label === 'D') {
						var total = $elm$core$List$sum(
							A2(
								$elm$core$List$map,
								$author$project$Chart$Item$getY,
								$author$project$Chart$Item$getMembers(stack)));
						return _List_fromArray(
							[
								A3(
								$author$project$Chart$label,
								_List_fromArray(
									[
										$author$project$Chart$Attributes$moveUp(10)
									]),
								_List_fromArray(
									[
										$elm$svg$Svg$text(
										$elm$core$String$fromFloat(total))
									]),
								A2($author$project$Chart$Item$getTop, p, stack)),
								$author$project$Chart$line(
								_List_fromArray(
									[
										$author$project$Chart$Attributes$x1(
										A2($author$project$Chart$Item$getTop, p, stack).x),
										$author$project$Chart$Attributes$y1(
										A2($author$project$Chart$Item$getTop, p, stack).y),
										$author$project$Chart$Attributes$x2Svg(-15),
										$author$project$Chart$Attributes$y2Svg(10),
										$author$project$Chart$Attributes$moveUp(13),
										$author$project$Chart$Attributes$moveLeft(8),
										$author$project$Chart$Attributes$color('#888'),
										$author$project$Chart$Attributes$break,
										$author$project$Chart$Attributes$flip
									])),
								A3(
								$author$project$Chart$label,
								_List_fromArray(
									[
										$author$project$Chart$Attributes$moveUp(30)
									]),
								_List_fromArray(
									[
										$elm$svg$Svg$text('stack label')
									]),
								A2($author$project$Chart$Item$getTop, p, stack))
							]);
					} else {
						return _List_Nil;
					}
				}))
		]));
var $mdgriffith$elm_ui$Element$Background$color = function (clr) {
	return A2(
		$mdgriffith$elm_ui$Internal$Model$StyleClass,
		$mdgriffith$elm_ui$Internal$Flag$bgColor,
		A3(
			$mdgriffith$elm_ui$Internal$Model$Colored,
			'bg-' + $mdgriffith$elm_ui$Internal$Model$formatColorClass(clr),
			'background-color',
			clr));
};
var $mdgriffith$elm_ui$Internal$Flag$borderColor = $mdgriffith$elm_ui$Internal$Flag$flag(28);
var $mdgriffith$elm_ui$Element$Border$color = function (clr) {
	return A2(
		$mdgriffith$elm_ui$Internal$Model$StyleClass,
		$mdgriffith$elm_ui$Internal$Flag$borderColor,
		A3(
			$mdgriffith$elm_ui$Internal$Model$Colored,
			'bc-' + $mdgriffith$elm_ui$Internal$Model$formatColorClass(clr),
			'border-color',
			clr));
};
var $mdgriffith$elm_ui$Internal$Flag$overflow = $mdgriffith$elm_ui$Internal$Flag$flag(20);
var $mdgriffith$elm_ui$Element$scrollbarX = A2($mdgriffith$elm_ui$Internal$Model$Class, $mdgriffith$elm_ui$Internal$Flag$overflow, $mdgriffith$elm_ui$Internal$Style$classes.scrollbarsX);
var $mdgriffith$elm_ui$Internal$Model$Focus = {$: 'Focus'};
var $mdgriffith$elm_ui$Internal$Model$PseudoSelector = F2(
	function (a, b) {
		return {$: 'PseudoSelector', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Flag$focus = $mdgriffith$elm_ui$Internal$Flag$flag(31);
var $mdgriffith$elm_ui$Internal$Model$Nearby = F2(
	function (a, b) {
		return {$: 'Nearby', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Model$TransformComponent = F2(
	function (a, b) {
		return {$: 'TransformComponent', a: a, b: b};
	});
var $mdgriffith$elm_ui$Internal$Model$mapAttrFromStyle = F2(
	function (fn, attr) {
		switch (attr.$) {
			case 'NoAttribute':
				return $mdgriffith$elm_ui$Internal$Model$NoAttribute;
			case 'Describe':
				var description = attr.a;
				return $mdgriffith$elm_ui$Internal$Model$Describe(description);
			case 'AlignX':
				var x = attr.a;
				return $mdgriffith$elm_ui$Internal$Model$AlignX(x);
			case 'AlignY':
				var y = attr.a;
				return $mdgriffith$elm_ui$Internal$Model$AlignY(y);
			case 'Width':
				var x = attr.a;
				return $mdgriffith$elm_ui$Internal$Model$Width(x);
			case 'Height':
				var x = attr.a;
				return $mdgriffith$elm_ui$Internal$Model$Height(x);
			case 'Class':
				var x = attr.a;
				var y = attr.b;
				return A2($mdgriffith$elm_ui$Internal$Model$Class, x, y);
			case 'StyleClass':
				var flag = attr.a;
				var style = attr.b;
				return A2($mdgriffith$elm_ui$Internal$Model$StyleClass, flag, style);
			case 'Nearby':
				var location = attr.a;
				var elem = attr.b;
				return A2(
					$mdgriffith$elm_ui$Internal$Model$Nearby,
					location,
					A2($mdgriffith$elm_ui$Internal$Model$map, fn, elem));
			case 'Attr':
				var htmlAttr = attr.a;
				return $mdgriffith$elm_ui$Internal$Model$Attr(
					A2($elm$virtual_dom$VirtualDom$mapAttribute, fn, htmlAttr));
			default:
				var fl = attr.a;
				var trans = attr.b;
				return A2($mdgriffith$elm_ui$Internal$Model$TransformComponent, fl, trans);
		}
	});
var $mdgriffith$elm_ui$Internal$Model$removeNever = function (style) {
	return A2($mdgriffith$elm_ui$Internal$Model$mapAttrFromStyle, $elm$core$Basics$never, style);
};
var $mdgriffith$elm_ui$Internal$Model$unwrapDecsHelper = F2(
	function (attr, _v0) {
		var styles = _v0.a;
		var trans = _v0.b;
		var _v1 = $mdgriffith$elm_ui$Internal$Model$removeNever(attr);
		switch (_v1.$) {
			case 'StyleClass':
				var style = _v1.b;
				return _Utils_Tuple2(
					A2($elm$core$List$cons, style, styles),
					trans);
			case 'TransformComponent':
				var flag = _v1.a;
				var component = _v1.b;
				return _Utils_Tuple2(
					styles,
					A2($mdgriffith$elm_ui$Internal$Model$composeTransformation, trans, component));
			default:
				return _Utils_Tuple2(styles, trans);
		}
	});
var $mdgriffith$elm_ui$Internal$Model$unwrapDecorations = function (attrs) {
	var _v0 = A3(
		$elm$core$List$foldl,
		$mdgriffith$elm_ui$Internal$Model$unwrapDecsHelper,
		_Utils_Tuple2(_List_Nil, $mdgriffith$elm_ui$Internal$Model$Untransformed),
		attrs);
	var styles = _v0.a;
	var transform = _v0.b;
	return A2(
		$elm$core$List$cons,
		$mdgriffith$elm_ui$Internal$Model$Transform(transform),
		styles);
};
var $mdgriffith$elm_ui$Element$focused = function (decs) {
	return A2(
		$mdgriffith$elm_ui$Internal$Model$StyleClass,
		$mdgriffith$elm_ui$Internal$Flag$focus,
		A2(
			$mdgriffith$elm_ui$Internal$Model$PseudoSelector,
			$mdgriffith$elm_ui$Internal$Model$Focus,
			$mdgriffith$elm_ui$Internal$Model$unwrapDecorations(decs)));
};
var $mdgriffith$elm_ui$Internal$Model$Hover = {$: 'Hover'};
var $mdgriffith$elm_ui$Internal$Flag$hover = $mdgriffith$elm_ui$Internal$Flag$flag(33);
var $mdgriffith$elm_ui$Element$mouseOver = function (decs) {
	return A2(
		$mdgriffith$elm_ui$Internal$Model$StyleClass,
		$mdgriffith$elm_ui$Internal$Flag$hover,
		A2(
			$mdgriffith$elm_ui$Internal$Model$PseudoSelector,
			$mdgriffith$elm_ui$Internal$Model$Hover,
			$mdgriffith$elm_ui$Internal$Model$unwrapDecorations(decs)));
};
var $mdgriffith$elm_ui$Internal$Model$MoveY = function (a) {
	return {$: 'MoveY', a: a};
};
var $mdgriffith$elm_ui$Internal$Flag$moveY = $mdgriffith$elm_ui$Internal$Flag$flag(26);
var $mdgriffith$elm_ui$Element$moveDown = function (y) {
	return A2(
		$mdgriffith$elm_ui$Internal$Model$TransformComponent,
		$mdgriffith$elm_ui$Internal$Flag$moveY,
		$mdgriffith$elm_ui$Internal$Model$MoveY(y));
};
var $mdgriffith$elm_ui$Element$rgba255 = F4(
	function (red, green, blue, a) {
		return A4($mdgriffith$elm_ui$Internal$Model$Rgba, red / 255, green / 255, blue / 255, a);
	});
var $mdgriffith$elm_ui$Internal$Model$BorderWidth = F5(
	function (a, b, c, d, e) {
		return {$: 'BorderWidth', a: a, b: b, c: c, d: d, e: e};
	});
var $mdgriffith$elm_ui$Element$Border$width = function (v) {
	return A2(
		$mdgriffith$elm_ui$Internal$Model$StyleClass,
		$mdgriffith$elm_ui$Internal$Flag$borderWidth,
		A5(
			$mdgriffith$elm_ui$Internal$Model$BorderWidth,
			'b-' + $elm$core$String$fromInt(v),
			v,
			v,
			v,
			v));
};
var $mdgriffith$elm_ui$Element$Border$widthXY = F2(
	function (x, y) {
		return A2(
			$mdgriffith$elm_ui$Internal$Model$StyleClass,
			$mdgriffith$elm_ui$Internal$Flag$borderWidth,
			A5(
				$mdgriffith$elm_ui$Internal$Model$BorderWidth,
				'b-' + ($elm$core$String$fromInt(x) + ('-' + $elm$core$String$fromInt(y))),
				y,
				x,
				y,
				x));
	});
var $mdgriffith$elm_ui$Element$Border$widthEach = function (_v0) {
	var bottom = _v0.bottom;
	var top = _v0.top;
	var left = _v0.left;
	var right = _v0.right;
	return (_Utils_eq(top, bottom) && _Utils_eq(left, right)) ? (_Utils_eq(top, right) ? $mdgriffith$elm_ui$Element$Border$width(top) : A2($mdgriffith$elm_ui$Element$Border$widthXY, left, top)) : A2(
		$mdgriffith$elm_ui$Internal$Model$StyleClass,
		$mdgriffith$elm_ui$Internal$Flag$borderWidth,
		A5(
			$mdgriffith$elm_ui$Internal$Model$BorderWidth,
			'b-' + ($elm$core$String$fromInt(top) + ('-' + ($elm$core$String$fromInt(right) + ('-' + ($elm$core$String$fromInt(bottom) + ('-' + $elm$core$String$fromInt(left))))))),
			top,
			right,
			bottom,
			left));
};
var $author$project$Ui$Tabs$viewOne = F3(
	function (window, config, item) {
		var isSelected = _Utils_eq(
			config.selected,
			config.toUrl(item));
		var offset = function () {
			var _v0 = $author$project$Ui$Layout$screen(window);
			switch (_v0.$) {
				case 'Large':
					return isSelected ? $mdgriffith$elm_ui$Element$moveDown(1) : $mdgriffith$elm_ui$Element$moveDown(0);
				case 'Medium':
					return $mdgriffith$elm_ui$Element$moveDown(0);
				default:
					return $mdgriffith$elm_ui$Element$moveDown(0);
			}
		}();
		return A2(
			$mdgriffith$elm_ui$Element$link,
			_List_fromArray(
				[
					$mdgriffith$elm_ui$Element$Font$size(14),
					$mdgriffith$elm_ui$Element$Font$color(
					isSelected ? A3($mdgriffith$elm_ui$Element$rgb255, 123, 77, 255) : A3($mdgriffith$elm_ui$Element$rgb255, 120, 120, 120)),
					offset,
					A2($mdgriffith$elm_ui$Element$paddingXY, 25, 10),
					$mdgriffith$elm_ui$Element$Border$color(
					A3($mdgriffith$elm_ui$Element$rgb255, 123, 77, 255)),
					$mdgriffith$elm_ui$Element$Border$widthEach(
					{
						bottom: isSelected ? 1 : 0,
						left: 0,
						right: 0,
						top: 0
					}),
					$mdgriffith$elm_ui$Element$mouseOver(
					_List_fromArray(
						[
							$mdgriffith$elm_ui$Element$Background$color(
							A4($mdgriffith$elm_ui$Element$rgba255, 123, 77, 255, 0.05))
						])),
					$mdgriffith$elm_ui$Element$focused(
					_List_fromArray(
						[
							$mdgriffith$elm_ui$Element$Background$color(
							isSelected ? A4($mdgriffith$elm_ui$Element$rgba255, 123, 77, 255, 0.1) : A3($mdgriffith$elm_ui$Element$rgb255, 250, 250, 250))
						]))
				]),
			{
				label: $mdgriffith$elm_ui$Element$text(
					config.toTitle(item)),
				url: config.toUrl(item)
			});
	});
var $author$project$Ui$Tabs$view = F2(
	function (window, config) {
		var contianerAttrs = function () {
			var _v0 = $author$project$Ui$Layout$screen(window);
			switch (_v0.$) {
				case 'Large':
					return _List_fromArray(
						[
							$mdgriffith$elm_ui$Element$Border$color(
							A3($mdgriffith$elm_ui$Element$rgb255, 220, 220, 220)),
							$mdgriffith$elm_ui$Element$Border$widthEach(
							{bottom: 1, left: 0, right: 0, top: 0})
						]);
				case 'Medium':
					return _List_fromArray(
						[
							$mdgriffith$elm_ui$Element$Background$color(
							A3($mdgriffith$elm_ui$Element$rgb255, 250, 250, 250)),
							$mdgriffith$elm_ui$Element$scrollbarX
						]);
				default:
					return _List_fromArray(
						[
							$mdgriffith$elm_ui$Element$Background$color(
							A3($mdgriffith$elm_ui$Element$rgb255, 250, 250, 250)),
							$mdgriffith$elm_ui$Element$scrollbarX
						]);
			}
		}();
		return A2(
			$mdgriffith$elm_ui$Element$el,
			_List_fromArray(
				[
					$mdgriffith$elm_ui$Element$width($mdgriffith$elm_ui$Element$fill),
					$mdgriffith$elm_ui$Element$height($mdgriffith$elm_ui$Element$fill),
					A2($mdgriffith$elm_ui$Element$paddingXY, 0, 30)
				]),
			A2(
				$mdgriffith$elm_ui$Element$row,
				_Utils_ap(
					_List_fromArray(
						[
							$mdgriffith$elm_ui$Element$width($mdgriffith$elm_ui$Element$fill),
							$mdgriffith$elm_ui$Element$height($mdgriffith$elm_ui$Element$fill)
						]),
					contianerAttrs),
				A2(
					$elm$core$List$map,
					A2($author$project$Ui$Tabs$viewOne, window, config),
					A2(
						$elm$core$List$filter,
						function (a) {
							return (config.toTitle(a) !== 'Front page') && (config.toTitle(a) !== 'Basic');
						},
						config.all))));
	});
var $mdgriffith$elm_ui$Element$htmlAttribute = $mdgriffith$elm_ui$Internal$Model$Attr;
var $author$project$Ui$Thumbnail$toUrl = function (id) {
	var meta = $author$project$Examples$meta(id);
	return '/documentation/' + ($author$project$Ui$Thumbnail$urlify(meta.category) + ('/' + $author$project$Ui$Thumbnail$urlify(meta.name)));
};
var $author$project$Examples$ExampleMsg0 = function (a) {
	return {$: 'ExampleMsg0', a: a};
};
var $author$project$Examples$ExampleMsg1 = function (a) {
	return {$: 'ExampleMsg1', a: a};
};
var $author$project$Examples$ExampleMsg10 = function (a) {
	return {$: 'ExampleMsg10', a: a};
};
var $author$project$Examples$ExampleMsg100 = function (a) {
	return {$: 'ExampleMsg100', a: a};
};
var $author$project$Examples$ExampleMsg101 = function (a) {
	return {$: 'ExampleMsg101', a: a};
};
var $author$project$Examples$ExampleMsg102 = function (a) {
	return {$: 'ExampleMsg102', a: a};
};
var $author$project$Examples$ExampleMsg103 = function (a) {
	return {$: 'ExampleMsg103', a: a};
};
var $author$project$Examples$ExampleMsg104 = function (a) {
	return {$: 'ExampleMsg104', a: a};
};
var $author$project$Examples$ExampleMsg105 = function (a) {
	return {$: 'ExampleMsg105', a: a};
};
var $author$project$Examples$ExampleMsg106 = function (a) {
	return {$: 'ExampleMsg106', a: a};
};
var $author$project$Examples$ExampleMsg11 = function (a) {
	return {$: 'ExampleMsg11', a: a};
};
var $author$project$Examples$ExampleMsg12 = function (a) {
	return {$: 'ExampleMsg12', a: a};
};
var $author$project$Examples$ExampleMsg13 = function (a) {
	return {$: 'ExampleMsg13', a: a};
};
var $author$project$Examples$ExampleMsg14 = function (a) {
	return {$: 'ExampleMsg14', a: a};
};
var $author$project$Examples$ExampleMsg15 = function (a) {
	return {$: 'ExampleMsg15', a: a};
};
var $author$project$Examples$ExampleMsg16 = function (a) {
	return {$: 'ExampleMsg16', a: a};
};
var $author$project$Examples$ExampleMsg17 = function (a) {
	return {$: 'ExampleMsg17', a: a};
};
var $author$project$Examples$ExampleMsg18 = function (a) {
	return {$: 'ExampleMsg18', a: a};
};
var $author$project$Examples$ExampleMsg19 = function (a) {
	return {$: 'ExampleMsg19', a: a};
};
var $author$project$Examples$ExampleMsg2 = function (a) {
	return {$: 'ExampleMsg2', a: a};
};
var $author$project$Examples$ExampleMsg20 = function (a) {
	return {$: 'ExampleMsg20', a: a};
};
var $author$project$Examples$ExampleMsg21 = function (a) {
	return {$: 'ExampleMsg21', a: a};
};
var $author$project$Examples$ExampleMsg22 = function (a) {
	return {$: 'ExampleMsg22', a: a};
};
var $author$project$Examples$ExampleMsg23 = function (a) {
	return {$: 'ExampleMsg23', a: a};
};
var $author$project$Examples$ExampleMsg24 = function (a) {
	return {$: 'ExampleMsg24', a: a};
};
var $author$project$Examples$ExampleMsg25 = function (a) {
	return {$: 'ExampleMsg25', a: a};
};
var $author$project$Examples$ExampleMsg26 = function (a) {
	return {$: 'ExampleMsg26', a: a};
};
var $author$project$Examples$ExampleMsg27 = function (a) {
	return {$: 'ExampleMsg27', a: a};
};
var $author$project$Examples$ExampleMsg28 = function (a) {
	return {$: 'ExampleMsg28', a: a};
};
var $author$project$Examples$ExampleMsg29 = function (a) {
	return {$: 'ExampleMsg29', a: a};
};
var $author$project$Examples$ExampleMsg3 = function (a) {
	return {$: 'ExampleMsg3', a: a};
};
var $author$project$Examples$ExampleMsg30 = function (a) {
	return {$: 'ExampleMsg30', a: a};
};
var $author$project$Examples$ExampleMsg31 = function (a) {
	return {$: 'ExampleMsg31', a: a};
};
var $author$project$Examples$ExampleMsg32 = function (a) {
	return {$: 'ExampleMsg32', a: a};
};
var $author$project$Examples$ExampleMsg33 = function (a) {
	return {$: 'ExampleMsg33', a: a};
};
var $author$project$Examples$ExampleMsg34 = function (a) {
	return {$: 'ExampleMsg34', a: a};
};
var $author$project$Examples$ExampleMsg35 = function (a) {
	return {$: 'ExampleMsg35', a: a};
};
var $author$project$Examples$ExampleMsg36 = function (a) {
	return {$: 'ExampleMsg36', a: a};
};
var $author$project$Examples$ExampleMsg37 = function (a) {
	return {$: 'ExampleMsg37', a: a};
};
var $author$project$Examples$ExampleMsg38 = function (a) {
	return {$: 'ExampleMsg38', a: a};
};
var $author$project$Examples$ExampleMsg39 = function (a) {
	return {$: 'ExampleMsg39', a: a};
};
var $author$project$Examples$ExampleMsg4 = function (a) {
	return {$: 'ExampleMsg4', a: a};
};
var $author$project$Examples$ExampleMsg40 = function (a) {
	return {$: 'ExampleMsg40', a: a};
};
var $author$project$Examples$ExampleMsg41 = function (a) {
	return {$: 'ExampleMsg41', a: a};
};
var $author$project$Examples$ExampleMsg42 = function (a) {
	return {$: 'ExampleMsg42', a: a};
};
var $author$project$Examples$ExampleMsg43 = function (a) {
	return {$: 'ExampleMsg43', a: a};
};
var $author$project$Examples$ExampleMsg44 = function (a) {
	return {$: 'ExampleMsg44', a: a};
};
var $author$project$Examples$ExampleMsg45 = function (a) {
	return {$: 'ExampleMsg45', a: a};
};
var $author$project$Examples$ExampleMsg46 = function (a) {
	return {$: 'ExampleMsg46', a: a};
};
var $author$project$Examples$ExampleMsg47 = function (a) {
	return {$: 'ExampleMsg47', a: a};
};
var $author$project$Examples$ExampleMsg48 = function (a) {
	return {$: 'ExampleMsg48', a: a};
};
var $author$project$Examples$ExampleMsg49 = function (a) {
	return {$: 'ExampleMsg49', a: a};
};
var $author$project$Examples$ExampleMsg5 = function (a) {
	return {$: 'ExampleMsg5', a: a};
};
var $author$project$Examples$ExampleMsg50 = function (a) {
	return {$: 'ExampleMsg50', a: a};
};
var $author$project$Examples$ExampleMsg51 = function (a) {
	return {$: 'ExampleMsg51', a: a};
};
var $author$project$Examples$ExampleMsg52 = function (a) {
	return {$: 'ExampleMsg52', a: a};
};
var $author$project$Examples$ExampleMsg53 = function (a) {
	return {$: 'ExampleMsg53', a: a};
};
var $author$project$Examples$ExampleMsg54 = function (a) {
	return {$: 'ExampleMsg54', a: a};
};
var $author$project$Examples$ExampleMsg55 = function (a) {
	return {$: 'ExampleMsg55', a: a};
};
var $author$project$Examples$ExampleMsg56 = function (a) {
	return {$: 'ExampleMsg56', a: a};
};
var $author$project$Examples$ExampleMsg57 = function (a) {
	return {$: 'ExampleMsg57', a: a};
};
var $author$project$Examples$ExampleMsg58 = function (a) {
	return {$: 'ExampleMsg58', a: a};
};
var $author$project$Examples$ExampleMsg59 = function (a) {
	return {$: 'ExampleMsg59', a: a};
};
var $author$project$Examples$ExampleMsg6 = function (a) {
	return {$: 'ExampleMsg6', a: a};
};
var $author$project$Examples$ExampleMsg60 = function (a) {
	return {$: 'ExampleMsg60', a: a};
};
var $author$project$Examples$ExampleMsg61 = function (a) {
	return {$: 'ExampleMsg61', a: a};
};
var $author$project$Examples$ExampleMsg62 = function (a) {
	return {$: 'ExampleMsg62', a: a};
};
var $author$project$Examples$ExampleMsg63 = function (a) {
	return {$: 'ExampleMsg63', a: a};
};
var $author$project$Examples$ExampleMsg64 = function (a) {
	return {$: 'ExampleMsg64', a: a};
};
var $author$project$Examples$ExampleMsg65 = function (a) {
	return {$: 'ExampleMsg65', a: a};
};
var $author$project$Examples$ExampleMsg66 = function (a) {
	return {$: 'ExampleMsg66', a: a};
};
var $author$project$Examples$ExampleMsg67 = function (a) {
	return {$: 'ExampleMsg67', a: a};
};
var $author$project$Examples$ExampleMsg68 = function (a) {
	return {$: 'ExampleMsg68', a: a};
};
var $author$project$Examples$ExampleMsg69 = function (a) {
	return {$: 'ExampleMsg69', a: a};
};
var $author$project$Examples$ExampleMsg7 = function (a) {
	return {$: 'ExampleMsg7', a: a};
};
var $author$project$Examples$ExampleMsg70 = function (a) {
	return {$: 'ExampleMsg70', a: a};
};
var $author$project$Examples$ExampleMsg71 = function (a) {
	return {$: 'ExampleMsg71', a: a};
};
var $author$project$Examples$ExampleMsg72 = function (a) {
	return {$: 'ExampleMsg72', a: a};
};
var $author$project$Examples$ExampleMsg73 = function (a) {
	return {$: 'ExampleMsg73', a: a};
};
var $author$project$Examples$ExampleMsg74 = function (a) {
	return {$: 'ExampleMsg74', a: a};
};
var $author$project$Examples$ExampleMsg75 = function (a) {
	return {$: 'ExampleMsg75', a: a};
};
var $author$project$Examples$ExampleMsg76 = function (a) {
	return {$: 'ExampleMsg76', a: a};
};
var $author$project$Examples$ExampleMsg77 = function (a) {
	return {$: 'ExampleMsg77', a: a};
};
var $author$project$Examples$ExampleMsg78 = function (a) {
	return {$: 'ExampleMsg78', a: a};
};
var $author$project$Examples$ExampleMsg79 = function (a) {
	return {$: 'ExampleMsg79', a: a};
};
var $author$project$Examples$ExampleMsg8 = function (a) {
	return {$: 'ExampleMsg8', a: a};
};
var $author$project$Examples$ExampleMsg80 = function (a) {
	return {$: 'ExampleMsg80', a: a};
};
var $author$project$Examples$ExampleMsg81 = function (a) {
	return {$: 'ExampleMsg81', a: a};
};
var $author$project$Examples$ExampleMsg82 = function (a) {
	return {$: 'ExampleMsg82', a: a};
};
var $author$project$Examples$ExampleMsg83 = function (a) {
	return {$: 'ExampleMsg83', a: a};
};
var $author$project$Examples$ExampleMsg84 = function (a) {
	return {$: 'ExampleMsg84', a: a};
};
var $author$project$Examples$ExampleMsg85 = function (a) {
	return {$: 'ExampleMsg85', a: a};
};
var $author$project$Examples$ExampleMsg86 = function (a) {
	return {$: 'ExampleMsg86', a: a};
};
var $author$project$Examples$ExampleMsg87 = function (a) {
	return {$: 'ExampleMsg87', a: a};
};
var $author$project$Examples$ExampleMsg88 = function (a) {
	return {$: 'ExampleMsg88', a: a};
};
var $author$project$Examples$ExampleMsg89 = function (a) {
	return {$: 'ExampleMsg89', a: a};
};
var $author$project$Examples$ExampleMsg9 = function (a) {
	return {$: 'ExampleMsg9', a: a};
};
var $author$project$Examples$ExampleMsg90 = function (a) {
	return {$: 'ExampleMsg90', a: a};
};
var $author$project$Examples$ExampleMsg91 = function (a) {
	return {$: 'ExampleMsg91', a: a};
};
var $author$project$Examples$ExampleMsg92 = function (a) {
	return {$: 'ExampleMsg92', a: a};
};
var $author$project$Examples$ExampleMsg93 = function (a) {
	return {$: 'ExampleMsg93', a: a};
};
var $author$project$Examples$ExampleMsg94 = function (a) {
	return {$: 'ExampleMsg94', a: a};
};
var $author$project$Examples$ExampleMsg95 = function (a) {
	return {$: 'ExampleMsg95', a: a};
};
var $author$project$Examples$ExampleMsg96 = function (a) {
	return {$: 'ExampleMsg96', a: a};
};
var $author$project$Examples$ExampleMsg97 = function (a) {
	return {$: 'ExampleMsg97', a: a};
};
var $author$project$Examples$ExampleMsg98 = function (a) {
	return {$: 'ExampleMsg98', a: a};
};
var $author$project$Examples$ExampleMsg99 = function (a) {
	return {$: 'ExampleMsg99', a: a};
};
var $author$project$Chart$barLabels = function (edits) {
	return $author$project$Chart$eachBar(
		F2(
			function (p, item) {
				var config = A2(
					$author$project$Internal$Helpers$apply,
					edits,
					_Utils_update(
						$author$project$Chart$defaultLabel,
						{position: $author$project$Chart$Item$getTop}));
				var text = function () {
					var _v1 = config.format;
					if (_v1.$ === 'Just') {
						var formatting = _v1.a;
						return formatting(item);
					} else {
						return $elm$core$String$fromFloat(
							$author$project$Chart$Item$getY(item));
					}
				}();
				return _List_fromArray(
					[
						$author$project$Chart$svg(
						function (_v0) {
							return A4(
								$author$project$Internal$Svg$label,
								p,
								$author$project$Chart$toLabelFromItemLabel(config),
								_List_fromArray(
									[
										$elm$svg$Svg$text(text)
									]),
								A2(config.position, p, item));
						})
					]);
			}));
};
var $author$project$Examples$BarCharts$BarLabels$Datum = F9(
	function (x, x1, y, z, v, w, p, q, label) {
		return {label: label, p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$BarLabels$data = _List_fromArray(
	[
		A9($author$project$Examples$BarCharts$BarLabels$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0, 'Norway'),
		A9($author$project$Examples$BarCharts$BarLabels$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8, 'Denmark'),
		A9($author$project$Examples$BarCharts$BarLabels$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3, 'Sweden'),
		A9($author$project$Examples$BarCharts$BarLabels$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1, 'Finland')
	]);
var $author$project$Chart$xLabels = function (edits) {
	var toTicks = F2(
		function (p, config) {
			return A4(
				$author$project$Chart$generateValues,
				config.amount,
				config.generate,
				config.format,
				A3(
					$elm$core$List$foldl,
					F2(
						function (f, x) {
							return f(x);
						}),
					p.x,
					config.limits));
		});
	var toTickValues = F3(
		function (p, config, ts) {
			return (!config.grid) ? ts : _Utils_update(
				ts,
				{
					xs: _Utils_ap(
						ts.xs,
						A2(
							$elm$core$List$map,
							function ($) {
								return $.value;
							},
							A2(toTicks, p, config)))
				});
		});
	var toConfig = function (p) {
		return A2(
			$author$project$Internal$Helpers$apply,
			edits,
			{amount: 5, anchor: $elm$core$Maybe$Nothing, attrs: _List_Nil, color: '#808BAB', ellipsis: $elm$core$Maybe$Nothing, flip: false, fontSize: $elm$core$Maybe$Nothing, format: $elm$core$Maybe$Nothing, generate: $author$project$Internal$Svg$Floats, grid: false, limits: _List_Nil, pinned: $author$project$Chart$Attributes$zero, rotate: 0, uppercase: false, xOff: 0, yOff: 18});
	};
	return A3(
		$author$project$Chart$LabelsElement,
		toConfig,
		toTickValues,
		F2(
			function (p, config) {
				var _default = $author$project$Internal$Svg$defaultLabel;
				var toLabel = function (item) {
					return A4(
						$author$project$Internal$Svg$label,
						p,
						_Utils_update(
							_default,
							{
								anchor: config.anchor,
								attrs: config.attrs,
								color: config.color,
								ellipsis: config.ellipsis,
								fontSize: config.fontSize,
								rotate: config.rotate,
								uppercase: config.uppercase,
								xOff: config.xOff,
								yOff: config.flip ? ((-config.yOff) + 10) : config.yOff
							}),
						_List_fromArray(
							[
								$elm$svg$Svg$text(item.label)
							]),
						{
							x: item.value,
							y: config.pinned(p.y)
						});
				};
				return A2(
					$elm$svg$Svg$g,
					_List_fromArray(
						[
							$elm$svg$Svg$Attributes$class('elm-charts__x-labels')
						]),
					A2(
						$elm$core$List$map,
						toLabel,
						A2(toTicks, p, config)));
			}));
};
var $author$project$Examples$BarCharts$BarLabels$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.q;
						},
						_List_Nil),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.p;
						},
						_List_Nil)
					]),
				$author$project$Examples$BarCharts$BarLabels$data),
				$author$project$Chart$barLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$moveDown(15),
						$author$project$Chart$Attributes$color('white')
					]))
			]));
};
var $author$project$Examples$BarCharts$Basic$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$Basic$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$Basic$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$Basic$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$Basic$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$BarCharts$Basic$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$BarCharts$Basic$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_Nil),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_Nil)
					]),
				$author$project$Examples$BarCharts$Basic$data)
			]));
};
var $author$project$Examples$BarCharts$BinLabels$Datum = F9(
	function (x, x1, y, z, v, w, p, q, label) {
		return {label: label, p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$BinLabels$data = _List_fromArray(
	[
		A9($author$project$Examples$BarCharts$BinLabels$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0, 'Norway'),
		A9($author$project$Examples$BarCharts$BinLabels$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8, 'Denmark'),
		A9($author$project$Examples$BarCharts$BinLabels$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3, 'Sweden'),
		A9($author$project$Examples$BarCharts$BinLabels$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1, 'Finland')
	]);
var $author$project$Examples$BarCharts$BinLabels$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$grid(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A2(
				$author$project$Chart$binLabels,
				function ($) {
					return $.label;
				},
				_List_fromArray(
					[
						$author$project$Chart$Attributes$moveDown(20)
					])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.q;
						},
						_List_Nil),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.p;
						},
						_List_Nil)
					]),
				$author$project$Examples$BarCharts$BinLabels$data)
			]));
};
var $author$project$Examples$BarCharts$BinLabelsAdvanced$Datum = F4(
	function (x, y, z, label) {
		return {label: label, x: x, y: y, z: z};
	});
var $author$project$Examples$BarCharts$BinLabelsAdvanced$data = _List_fromArray(
	[
		A4($author$project$Examples$BarCharts$BinLabelsAdvanced$Datum, 1.0, 2, 4, 'Norway'),
		A4($author$project$Examples$BarCharts$BinLabelsAdvanced$Datum, 2.0, 1, 3, 'Denmark'),
		A4($author$project$Examples$BarCharts$BinLabelsAdvanced$Datum, 3.0, 3, 2, 'Sweden'),
		A4($author$project$Examples$BarCharts$BinLabelsAdvanced$Datum, 4.0, 5, 4, 'Finland')
	]);
var $author$project$Chart$eachBin = function (func) {
	return $author$project$Chart$SubElements(
		F2(
			function (p, is) {
				return A2(
					$elm$core$List$concatMap,
					func(p),
					A2(
						$author$project$Chart$Item$apply,
						A2(
							$author$project$Chart$Item$andThen,
							$author$project$Chart$Item$bins,
							A2($author$project$Chart$Item$andThen, $author$project$Chart$Item$real, $author$project$Chart$Item$any)),
						is));
			}));
};
var $author$project$Internal$Many$getMember = function (_v0) {
	var group_ = _v0.a;
	return function (_v1) {
		var x = _v1.a;
		var xs = _v1.b;
		return x;
	}(group_.config.items);
};
var $author$project$Chart$Item$getMember = $author$project$Internal$Many$getMember;
var $author$project$Chart$Item$getX1 = $author$project$Internal$Item$getX1;
var $author$project$Chart$Item$getX2 = $author$project$Internal$Item$getX2;
var $author$project$Internal$Helpers$labelGray = '#808BAB';
var $author$project$Chart$Attributes$labelGray = $author$project$Internal$Helpers$labelGray;
var $author$project$Examples$BarCharts$BinLabelsAdvanced$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				$author$project$Chart$eachBin(
				F2(
					function (p, bin) {
						var datum = $author$project$Chart$Item$getOneData(bin);
						var isSpecial = (datum.y + datum.z) > 6;
						var color = isSpecial ? 'blue' : $author$project$Chart$Attributes$labelGray;
						var bar = $author$project$Chart$Item$getMember(bin);
						var labelBasic = $elm$core$String$fromFloat(
							$author$project$Chart$Item$getX1(bar)) + (' - ' + $elm$core$String$fromFloat(
							$author$project$Chart$Item$getX2(bar)));
						var label = isSpecial ? ('→ ' + (labelBasic + ' ←')) : labelBasic;
						return _List_fromArray(
							[
								A3(
								$author$project$Chart$label,
								_List_fromArray(
									[
										$author$project$Chart$Attributes$color(color),
										$author$project$Chart$Attributes$moveDown(18)
									]),
								_List_fromArray(
									[
										$elm$svg$Svg$text(label)
									]),
								A2($author$project$Chart$Item$getBottom, p, bin))
							]);
					})),
				A3(
				$author$project$Chart$bars,
				_List_fromArray(
					[
						$author$project$Chart$Attributes$x1(
						function ($) {
							return $.x;
						})
					]),
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_Nil),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_Nil)
					]),
				$author$project$Examples$BarCharts$BinLabelsAdvanced$data)
			]));
};
var $author$project$Examples$BarCharts$Borders$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$Borders$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$Borders$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$Borders$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$Borders$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$BarCharts$Borders$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$BarCharts$Borders$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						$author$project$Chart$stacked(
						_List_fromArray(
							[
								A2(
								$author$project$Chart$bar,
								function ($) {
									return $.z;
								},
								_List_fromArray(
									[
										$author$project$Chart$Attributes$borderWidth(2),
										$author$project$Chart$Attributes$opacity(0.4)
									])),
								A2(
								$author$project$Chart$bar,
								function ($) {
									return $.y;
								},
								_List_fromArray(
									[
										$author$project$Chart$Attributes$borderWidth(2),
										$author$project$Chart$Attributes$opacity(0.4)
									]))
							]))
					]),
				$author$project$Examples$BarCharts$Borders$data)
			]));
};
var $author$project$Chart$Attributes$blue = $author$project$Internal$Helpers$blue;
var $author$project$Examples$BarCharts$Color$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$Color$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$Color$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$Color$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$Color$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$BarCharts$Color$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Chart$Attributes$green = $author$project$Internal$Helpers$green;
var $author$project$Examples$BarCharts$Color$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$color($author$project$Chart$Attributes$blue)
							])),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$color($author$project$Chart$Attributes$green)
							]))
					]),
				$author$project$Examples$BarCharts$Color$data)
			]));
};
var $author$project$Examples$BarCharts$Corners$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$Corners$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$Corners$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$Corners$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$Corners$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$BarCharts$Corners$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$BarCharts$Corners$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_fromArray(
					[
						$author$project$Chart$Attributes$roundTop(0.5)
					]),
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_Nil),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$roundBottom(0.5)
							]))
					]),
				$author$project$Examples$BarCharts$Corners$data)
			]));
};
var $author$project$Examples$BarCharts$DataDependent$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$DataDependent$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$DataDependent$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$DataDependent$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$DataDependent$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$BarCharts$DataDependent$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Internal$Svg$Striped = function (a) {
	return {$: 'Striped', a: a};
};
var $author$project$Chart$Attributes$striped = F2(
	function (attrs_, config) {
		return _Utils_update(
			config,
			{
				design: $elm$core$Maybe$Just(
					$author$project$Internal$Svg$Striped(attrs_)),
				opacity: (!config.opacity) ? 1 : config.opacity
			});
	});
var $author$project$Internal$Property$variation = F2(
	function (attrs, prop) {
		if (prop.$ === 'Property') {
			var c = prop.a;
			return $author$project$Internal$Property$Property(
				_Utils_update(
					c,
					{
						extra: F5(
							function (p, s, i, m, d) {
								return _Utils_ap(
									A5(c.extra, p, s, i, m, d),
									A5(attrs, p, s, i, m, d));
							})
					}));
		} else {
			var cs = prop.a;
			return $author$project$Internal$Property$Stacked(
				A2(
					$elm$core$List$map,
					function (c) {
						return _Utils_update(
							c,
							{
								extra: F5(
									function (p, s, i, m, d) {
										return _Utils_ap(
											A5(c.extra, p, s, i, m, d),
											A5(attrs, p, s, i, m, d));
									})
							});
					},
					cs));
		}
	});
var $author$project$Chart$variation = function (func) {
	return $author$project$Internal$Property$variation(
		F5(
			function (_v0, _v1, index, _v2, datum) {
				return A2(func, index, datum);
			}));
};
var $author$project$Examples$BarCharts$DataDependent$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						A2(
						$author$project$Chart$variation,
						F2(
							function (_v0, d) {
								return (d.x === 3) ? _List_fromArray(
									[
										$author$project$Chart$Attributes$striped(_List_Nil)
									]) : _List_Nil;
							}),
						A2(
							$author$project$Chart$bar,
							function ($) {
								return $.y;
							},
							_List_Nil)),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_Nil)
					]),
				$author$project$Examples$BarCharts$DataDependent$data)
			]));
};
var $author$project$Examples$BarCharts$Gradient$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$Gradient$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$Gradient$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$Gradient$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$Gradient$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$BarCharts$Gradient$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Internal$Svg$Gradient = function (a) {
	return {$: 'Gradient', a: a};
};
var $author$project$Chart$Attributes$gradient = F2(
	function (colors, config) {
		return _Utils_update(
			config,
			{
				design: $elm$core$Maybe$Just(
					$author$project$Internal$Svg$Gradient(colors)),
				opacity: (!config.opacity) ? 1 : config.opacity
			});
	});
var $author$project$Chart$Attributes$pink = $author$project$Internal$Helpers$pink;
var $author$project$Chart$Attributes$purple = $author$project$Internal$Helpers$purple;
var $author$project$Examples$BarCharts$Gradient$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$gradient(
								_List_fromArray(
									[$author$project$Chart$Attributes$purple, $author$project$Chart$Attributes$pink]))
							]))
					]),
				$author$project$Examples$BarCharts$Gradient$data)
			]));
};
var $author$project$Examples$BarCharts$Highlight$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Internal$Item$getDataIndex = function (_v0) {
	var item = _v0.a;
	return item.config.tooltipInfo.data;
};
var $author$project$Internal$Item$getPropertyIndex = function (_v0) {
	var item = _v0.a;
	return item.config.tooltipInfo.property;
};
var $author$project$Internal$Item$getStackIndex = function (_v0) {
	var item = _v0.a;
	return item.config.tooltipInfo.stack;
};
var $author$project$Chart$amongst = F2(
	function (inQuestion, func) {
		return $author$project$Internal$Property$variation(
			F5(
				function (p, s, i, meta, d) {
					var check = function (product) {
						return (_Utils_eq(
							$author$project$Internal$Item$getPropertyIndex(product),
							p) && (_Utils_eq(
							$author$project$Internal$Item$getStackIndex(product),
							s) && (_Utils_eq(
							$author$project$Internal$Item$getDataIndex(product),
							i) && _Utils_eq(
							$author$project$Internal$Item$getDatum(product),
							d)))) ? func(d) : _List_Nil;
					};
					return A2($elm$core$List$concatMap, check, inQuestion);
				}));
	});
var $author$project$Examples$BarCharts$Highlight$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$Highlight$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$Highlight$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$Highlight$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$Highlight$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3)
	]);
var $author$project$Chart$each = F2(
	function (items, func) {
		return $author$project$Chart$SubElements(
			F2(
				function (p, _v0) {
					return A2(
						$elm$core$List$concatMap,
						func(p),
						items);
				}));
	});
var $author$project$Internal$Events$Decoder = function (a) {
	return {$: 'Decoder', a: a};
};
var $author$project$Internal$Svg$closestPoint = F2(
	function (pos, searched) {
		return {
			x: A3($elm$core$Basics$clamp, pos.x1, pos.x2, searched.x),
			y: A3($elm$core$Basics$clamp, pos.y1, pos.y2, searched.y)
		};
	});
var $author$project$Internal$Svg$distanceX = F3(
	function (plane, searched, point) {
		return $elm$core$Basics$abs(
			A2($author$project$Internal$Coordinates$toSVGX, plane, point.x) - A2($author$project$Internal$Coordinates$toSVGX, plane, searched.x));
	});
var $author$project$Internal$Svg$distanceY = F3(
	function (plane, searched, point) {
		return $elm$core$Basics$abs(
			A2($author$project$Internal$Coordinates$toSVGY, plane, point.y) - A2($author$project$Internal$Coordinates$toSVGY, plane, searched.y));
	});
var $author$project$Internal$Svg$distanceSquared = F3(
	function (plane, searched, point) {
		return A2(
			$elm$core$Basics$pow,
			A3($author$project$Internal$Svg$distanceX, plane, searched, point),
			2) + A2(
			$elm$core$Basics$pow,
			A3($author$project$Internal$Svg$distanceY, plane, searched, point),
			2);
	});
var $author$project$Internal$Svg$keepOne = function (toPosition) {
	var toArea = function (a) {
		return function (pos) {
			return (pos.x1 - pos.x2) * (pos.y1 - pos.y2);
		}(
			toPosition(a));
	};
	var func = F2(
		function (one, acc) {
			var _v0 = $elm$core$List$head(acc);
			if (_v0.$ === 'Nothing') {
				return _List_fromArray(
					[one]);
			} else {
				var other = _v0.a;
				return _Utils_eq(
					toPosition(other),
					toPosition(one)) ? A2($elm$core$List$cons, other, acc) : ((_Utils_cmp(
					toArea(other),
					toArea(one)) > 0) ? _List_fromArray(
					[one]) : acc);
			}
		});
	return A2($elm$core$List$foldr, func, _List_Nil);
};
var $author$project$Internal$Svg$getNearestHelp = F4(
	function (toPosition, items, plane, searched) {
		var toPoint = function (i) {
			return A2(
				$author$project$Internal$Svg$closestPoint,
				toPosition(i),
				searched);
		};
		var distanceSquared_ = A2($author$project$Internal$Svg$distanceSquared, plane, searched);
		var getClosest = F2(
			function (item, allClosest) {
				var _v0 = $elm$core$List$head(allClosest);
				if (_v0.$ === 'Just') {
					var closest = _v0.a;
					return _Utils_eq(
						toPoint(closest),
						toPoint(item)) ? A2($elm$core$List$cons, item, allClosest) : ((_Utils_cmp(
						distanceSquared_(
							toPoint(closest)),
						distanceSquared_(
							toPoint(item))) > 0) ? _List_fromArray(
						[item]) : allClosest);
				} else {
					return _List_fromArray(
						[item]);
				}
			});
		return A2(
			$author$project$Internal$Svg$keepOne,
			toPosition,
			A3($elm$core$List$foldl, getClosest, _List_Nil, items));
	});
var $author$project$Internal$Svg$getNearest = F4(
	function (toPosition, items, plane, searched) {
		return A4($author$project$Internal$Svg$getNearestHelp, toPosition, items, plane, searched);
	});
var $author$project$Internal$Events$getNearest = function (grouping) {
	var toPos = grouping.a;
	return $author$project$Internal$Events$Decoder(
		F2(
			function (items, plane) {
				var groups = A2($author$project$Internal$Many$apply, grouping, items);
				return A3(
					$author$project$Internal$Svg$getNearest,
					toPos(plane),
					groups,
					plane);
			}));
};
var $author$project$Chart$Events$getNearest = $author$project$Internal$Events$getNearest;
var $author$project$Chart$Attributes$highlight = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{highlight: v});
	});
var $author$project$Internal$Events$getCoords = $author$project$Internal$Events$Decoder(
	F3(
		function (_v0, plane, searched) {
			return searched;
		}));
var $author$project$Chart$Events$getCoords = $author$project$Internal$Events$getCoords;
var $author$project$Internal$Events$map = F2(
	function (f, _v0) {
		var a = _v0.a;
		return $author$project$Internal$Events$Decoder(
			F3(
				function (ps, s, p) {
					return f(
						A3(a, ps, s, p));
				}));
	});
var $author$project$Chart$Events$map = $author$project$Internal$Events$map;
var $author$project$Internal$Events$Event = function (a) {
	return {$: 'Event', a: a};
};
var $author$project$Internal$Events$on = F3(
	function (name, decoder, config) {
		return _Utils_update(
			config,
			{
				events: A2(
					$elm$core$List$cons,
					$author$project$Internal$Events$Event(
						{decoder: decoder, name: name}),
					config.events)
			});
	});
var $author$project$Chart$Events$on = $author$project$Internal$Events$on;
var $author$project$Chart$Events$onMouseLeave = function (onMsg) {
	return A2(
		$author$project$Chart$Events$on,
		'mouseleave',
		A2(
			$author$project$Chart$Events$map,
			$elm$core$Basics$always(onMsg),
			$author$project$Chart$Events$getCoords));
};
var $author$project$Chart$Events$onMouseMove = F2(
	function (onMsg, decoder) {
		return A2(
			$author$project$Chart$Events$on,
			'mousemove',
			A2($author$project$Chart$Events$map, onMsg, decoder));
	});
var $author$project$Chart$HtmlElement = function (a) {
	return {$: 'HtmlElement', a: a};
};
var $author$project$Chart$html = function (func) {
	return $author$project$Chart$HtmlElement(
		F2(
			function (p, _v0) {
				return func(p);
			}));
};
var $author$project$Internal$Svg$defaultTooltip = {arrow: true, background: 'white', border: '#D8D8D8', direction: $elm$core$Maybe$Nothing, focal: $elm$core$Maybe$Nothing, height: 0, offset: 8, width: 0};
var $author$project$Internal$Svg$Bottom = {$: 'Bottom'};
var $author$project$Internal$Svg$Left = {$: 'Left'};
var $author$project$Internal$Svg$Right = {$: 'Right'};
var $author$project$Internal$Svg$Top = {$: 'Top'};
var $elm$core$List$all = F2(
	function (isOkay, list) {
		return !A2(
			$elm$core$List$any,
			A2($elm$core$Basics$composeL, $elm$core$Basics$not, isOkay),
			list);
	});
var $author$project$Internal$Coordinates$left = function (pos) {
	return {x: pos.x1, y: pos.y1 + ((pos.y2 - pos.y1) / 2)};
};
var $elm$html$Html$node = $elm$virtual_dom$VirtualDom$node;
var $author$project$Internal$Svg$positionHtml = F7(
	function (plane, x, y, xOff, yOff, attrs, content) {
		var yPercentage = ((A2($author$project$Internal$Coordinates$toSVGY, plane, y) - yOff) * 100) / plane.y.length;
		var xPercentage = ((A2($author$project$Internal$Coordinates$toSVGX, plane, x) + xOff) * 100) / plane.x.length;
		var posititonStyles = _List_fromArray(
			[
				A2(
				$elm$html$Html$Attributes$style,
				'left',
				$elm$core$String$fromFloat(xPercentage) + '%'),
				A2(
				$elm$html$Html$Attributes$style,
				'top',
				$elm$core$String$fromFloat(yPercentage) + '%'),
				A2($elm$html$Html$Attributes$style, 'margin-right', '-400px'),
				A2($elm$html$Html$Attributes$style, 'position', 'absolute')
			]);
		return A2(
			$elm$html$Html$div,
			_Utils_ap(posititonStyles, attrs),
			content);
	});
var $author$project$Internal$Coordinates$right = function (pos) {
	return {x: pos.x2, y: pos.y1 + ((pos.y2 - pos.y1) / 2)};
};
var $author$project$Internal$Svg$tooltipPointerStyle = F4(
	function (direction, className, background, borderColor) {
		var config = function () {
			switch (direction.$) {
				case 'Top':
					return {a: 'right', b: 'top', c: 'left'};
				case 'Bottom':
					return {a: 'right', b: 'bottom', c: 'left'};
				case 'Left':
					return {a: 'bottom', b: 'left', c: 'top'};
				case 'Right':
					return {a: 'bottom', b: 'right', c: 'top'};
				case 'LeftOrRight':
					return {a: 'bottom', b: 'left', c: 'top'};
				default:
					return {a: 'right', b: 'top', c: 'left'};
			}
		}();
		return '\n  .' + (className + (':before, .' + (className + (':after {\n    content: "";\n    position: absolute;\n    border-' + (config.c + (': 5px solid transparent;\n    border-' + (config.a + (': 5px solid transparent;\n    ' + (config.b + (': 100%;\n    ' + (config.c + (': 50%;\n    margin-' + (config.c + (': -5px;\n  }\n\n  .' + (className + (':after {\n    border-' + (config.b + (': 5px solid ' + (background + (';\n    margin-' + (config.b + (': -1px;\n    z-index: 1;\n    height: 0px;\n  }\n\n  .' + (className + (':before {\n    border-' + (config.b + (': 5px solid ' + (borderColor + ';\n    height: 0px;\n  }\n  ')))))))))))))))))))))))))));
	});
var $author$project$Internal$Svg$tooltip = F5(
	function (plane, pos, config, htmlAttrs, content) {
		var distanceTop = A2($author$project$Internal$Coordinates$toSVGY, plane, pos.y2);
		var distanceRight = plane.x.length - A2($author$project$Internal$Coordinates$toSVGX, plane, pos.x1);
		var distanceLeft = A2($author$project$Internal$Coordinates$toSVGX, plane, pos.x2);
		var distanceBottom = plane.y.length - A2($author$project$Internal$Coordinates$toSVGY, plane, pos.y1);
		var direction = function () {
			var _v5 = config.direction;
			if (_v5.$ === 'Just') {
				switch (_v5.a.$) {
					case 'LeftOrRight':
						var _v6 = _v5.a;
						return (config.width > 0) ? ((_Utils_cmp(distanceLeft, config.width + config.offset) > 0) ? $author$project$Internal$Svg$Left : $author$project$Internal$Svg$Right) : ((_Utils_cmp(distanceLeft, distanceRight) > 0) ? $author$project$Internal$Svg$Left : $author$project$Internal$Svg$Right);
					case 'TopOrBottom':
						var _v7 = _v5.a;
						return (config.height > 0) ? ((_Utils_cmp(distanceTop, config.height + config.offset) > 0) ? $author$project$Internal$Svg$Top : $author$project$Internal$Svg$Bottom) : ((_Utils_cmp(distanceTop, distanceBottom) > 0) ? $author$project$Internal$Svg$Top : $author$project$Internal$Svg$Bottom);
					default:
						var dir = _v5.a;
						return dir;
				}
			} else {
				var isLargest = function (a) {
					return $elm$core$List$all(
						function (b) {
							return _Utils_cmp(a, b) > -1;
						});
				};
				return A2(
					isLargest,
					distanceTop,
					_List_fromArray(
						[distanceBottom, distanceLeft, distanceRight])) ? $author$project$Internal$Svg$Top : (A2(
					isLargest,
					distanceBottom,
					_List_fromArray(
						[distanceTop, distanceLeft, distanceRight])) ? $author$project$Internal$Svg$Bottom : (A2(
					isLargest,
					distanceLeft,
					_List_fromArray(
						[distanceTop, distanceBottom, distanceRight])) ? $author$project$Internal$Svg$Left : $author$project$Internal$Svg$Right));
			}
		}();
		var focalPoint = function () {
			var _v2 = config.focal;
			if (_v2.$ === 'Just') {
				var focal = _v2.a;
				switch (direction.$) {
					case 'Top':
						return $author$project$Internal$Coordinates$top(
							focal(pos));
					case 'Bottom':
						return $author$project$Internal$Coordinates$bottom(
							focal(pos));
					case 'Left':
						return $author$project$Internal$Coordinates$left(
							focal(pos));
					case 'Right':
						return $author$project$Internal$Coordinates$right(
							focal(pos));
					case 'LeftOrRight':
						return $author$project$Internal$Coordinates$left(
							focal(pos));
					default:
						return $author$project$Internal$Coordinates$right(
							focal(pos));
				}
			} else {
				switch (direction.$) {
					case 'Top':
						return $author$project$Internal$Coordinates$top(pos);
					case 'Bottom':
						return $author$project$Internal$Coordinates$bottom(pos);
					case 'Left':
						return $author$project$Internal$Coordinates$left(pos);
					case 'Right':
						return $author$project$Internal$Coordinates$right(pos);
					case 'LeftOrRight':
						return $author$project$Internal$Coordinates$left(pos);
					default:
						return $author$project$Internal$Coordinates$right(pos);
				}
			}
		}();
		var arrowWidth = config.arrow ? 4 : 0;
		var _v0 = function () {
			switch (direction.$) {
				case 'Top':
					return {className: 'elm-charts__tooltip-top', transformation: 'translate(-50%, -100%)', xOff: 0, yOff: config.offset + arrowWidth};
				case 'Bottom':
					return {className: 'elm-charts__tooltip-bottom', transformation: 'translate(-50%, 0%)', xOff: 0, yOff: (-config.offset) - arrowWidth};
				case 'Left':
					return {className: 'elm-charts__tooltip-left', transformation: 'translate(-100%, -50%)', xOff: (-config.offset) - arrowWidth, yOff: 0};
				case 'Right':
					return {className: 'elm-charts__tooltip-right', transformation: 'translate(0, -50%)', xOff: config.offset + arrowWidth, yOff: 0};
				case 'LeftOrRight':
					return {className: 'elm-charts__tooltip-leftOrRight', transformation: 'translate(0, -50%)', xOff: (-config.offset) - arrowWidth, yOff: 0};
				default:
					return {className: 'elm-charts__tooltip-topOrBottom', transformation: 'translate(-50%, -100%)', xOff: 0, yOff: config.offset + arrowWidth};
			}
		}();
		var xOff = _v0.xOff;
		var yOff = _v0.yOff;
		var transformation = _v0.transformation;
		var className = _v0.className;
		var children = config.arrow ? A2(
			$elm$core$List$cons,
			A3(
				$elm$html$Html$node,
				'style',
				_List_Nil,
				_List_fromArray(
					[
						$elm$html$Html$text(
						A4($author$project$Internal$Svg$tooltipPointerStyle, direction, className, config.background, config.border))
					])),
			content) : content;
		var attributes = _Utils_ap(
			_List_fromArray(
				[
					$elm$html$Html$Attributes$class(className),
					A2($elm$html$Html$Attributes$style, 'transform', transformation),
					A2($elm$html$Html$Attributes$style, 'padding', '5px 8px'),
					A2($elm$html$Html$Attributes$style, 'background', config.background),
					A2($elm$html$Html$Attributes$style, 'border', '1px solid ' + config.border),
					A2($elm$html$Html$Attributes$style, 'border-radius', '3px'),
					A2($elm$html$Html$Attributes$style, 'pointer-events', 'none')
				]),
			htmlAttrs);
		return A2(
			$elm$html$Html$map,
			$elm$core$Basics$never,
			A7($author$project$Internal$Svg$positionHtml, plane, focalPoint.x, focalPoint.y, xOff, yOff, attributes, children));
	});
var $author$project$Chart$Svg$tooltip = F3(
	function (plane, pos, edits) {
		return A3(
			$author$project$Internal$Svg$tooltip,
			plane,
			pos,
			A2($author$project$Internal$Helpers$apply, edits, $author$project$Internal$Svg$defaultTooltip));
	});
var $author$project$Chart$tooltip = F4(
	function (i, edits, attrs_, content) {
		return $author$project$Chart$html(
			function (p) {
				var pos = $author$project$Internal$Item$getLimits(i);
				var content_ = _Utils_eq(content, _List_Nil) ? $author$project$Internal$Item$toHtml(i) : content;
				return A3($author$project$Internal$Svg$isWithinPlane, p, pos.x1, pos.y2) ? A5(
					$author$project$Chart$Svg$tooltip,
					p,
					A2($author$project$Internal$Item$getPosition, p, i),
					edits,
					attrs_,
					content_) : $elm$html$Html$text('');
			});
	});
var $author$project$Examples$BarCharts$Highlight$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$BarCharts$Highlight$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$bars)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$BarCharts$Highlight$OnHover(_List_Nil)),
				$author$project$Chart$Attributes$padding(
				{bottom: 0, left: 0, right: 0, top: 10})
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_fromArray(
					[
						$author$project$Chart$Attributes$roundTop(0.2),
						$author$project$Chart$Attributes$margin(0.1),
						$author$project$Chart$Attributes$spacing(0.15)
					]),
				_List_fromArray(
					[
						A3(
						$author$project$Chart$amongst,
						model.hovering,
						function (_v0) {
							return _List_fromArray(
								[
									$author$project$Chart$Attributes$highlight(0.25)
								]);
						},
						A2(
							$author$project$Chart$bar,
							function ($) {
								return $.z;
							},
							_List_fromArray(
								[
									$author$project$Chart$Attributes$striped(_List_Nil),
									$author$project$Chart$Attributes$borderWidth(1)
								]))),
						A3(
						$author$project$Chart$amongst,
						model.hovering,
						function (_v1) {
							return _List_fromArray(
								[
									$author$project$Chart$Attributes$highlight(0.25)
								]);
						},
						A2(
							$author$project$Chart$bar,
							function ($) {
								return $.v;
							},
							_List_Nil))
					]),
				$author$project$Examples$BarCharts$Highlight$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4($author$project$Chart$tooltip, item, _List_Nil, _List_Nil, _List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$BarCharts$Histogram$Datum = F3(
	function (start, end, y) {
		return {end: end, start: start, y: y};
	});
var $author$project$Examples$BarCharts$Histogram$data = _List_fromArray(
	[
		A3($author$project$Examples$BarCharts$Histogram$Datum, 1609459200000, 1612137600000, 2),
		A3($author$project$Examples$BarCharts$Histogram$Datum, 1612137600000, 1614556800000, 3),
		A3($author$project$Examples$BarCharts$Histogram$Datum, 1614556800000, 1617235200000, 4),
		A3($author$project$Examples$BarCharts$Histogram$Datum, 1617235200000, 1619827200000, 6)
	]);
var $author$project$Internal$Svg$Times = function (a) {
	return {$: 'Times', a: a};
};
var $author$project$Chart$Attributes$times = F2(
	function (zone, config) {
		return _Utils_update(
			config,
			{
				generate: $author$project$Internal$Svg$Times(zone)
			});
	});
var $elm$time$Time$Zone = F2(
	function (a, b) {
		return {$: 'Zone', a: a, b: b};
	});
var $elm$time$Time$utc = A2($elm$time$Time$Zone, 0, _List_Nil);
var $author$project$Examples$BarCharts$Histogram$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$times($elm$time$Time$utc)
					])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_fromArray(
					[
						$author$project$Chart$Attributes$x1(
						function ($) {
							return $.start;
						}),
						$author$project$Chart$Attributes$x2(
						function ($) {
							return $.end;
						}),
						$author$project$Chart$Attributes$margin(0.02)
					]),
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_Nil)
					]),
				$author$project$Examples$BarCharts$Histogram$data)
			]));
};
var $author$project$Internal$Svg$Column = {$: 'Column'};
var $author$project$Chart$Attributes$column = function (config) {
	return _Utils_update(
		config,
		{alignment: $author$project$Internal$Svg$Column});
};
var $author$project$Examples$BarCharts$Legends$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$Legends$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$Legends$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$Legends$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$Legends$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$BarCharts$Legends$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Internal$Coordinates$Axis = F7(
	function (length, marginMin, marginMax, dataMin, dataMax, min, max) {
		return {dataMax: dataMax, dataMin: dataMin, length: length, marginMax: marginMax, marginMin: marginMin, max: max, min: min};
	});
var $author$project$Internal$Svg$defaultContainer = {
	attrs: _List_fromArray(
		[
			$elm$svg$Svg$Attributes$style('overflow: visible;')
		]),
	events: _List_Nil,
	htmlAttrs: _List_Nil,
	responsive: true
};
var $author$project$Internal$Svg$barLegend = F2(
	function (config, barConfig) {
		var fontStyle = function () {
			var _v0 = config.fontSize;
			if (_v0.$ === 'Just') {
				var size_ = _v0.a;
				return A2(
					$elm$html$Html$Attributes$style,
					'font-size',
					$elm$core$String$fromInt(size_) + 'px');
			} else {
				return A2($elm$html$Html$Attributes$style, '', '');
			}
		}();
		var fakePlane = {
			x: A7($author$project$Internal$Coordinates$Axis, config.width, 0, 0, 0, 10, 0, 10),
			y: A7($author$project$Internal$Coordinates$Axis, config.height, 0, 0, 0, 10, 0, 10)
		};
		return A2(
			$elm$html$Html$div,
			_Utils_ap(
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('elm-charts__legend'),
						A2($elm$html$Html$Attributes$style, 'display', 'flex'),
						A2($elm$html$Html$Attributes$style, 'align-items', 'center')
					]),
				config.htmlAttrs),
			_List_fromArray(
				[
					A5(
					$author$project$Internal$Svg$container,
					fakePlane,
					_Utils_update(
						$author$project$Internal$Svg$defaultContainer,
						{responsive: false}),
					_List_Nil,
					_List_fromArray(
						[
							A3(
							$author$project$Internal$Svg$bar,
							fakePlane,
							barConfig,
							{x1: 0, x2: 10, y1: 0, y2: 10})
						]),
					_List_Nil),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							fontStyle,
							A2(
							$elm$html$Html$Attributes$style,
							'margin-left',
							$elm$core$String$fromFloat(config.spacing) + 'px')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(config.title)
						]))
				]));
	});
var $author$project$Internal$Svg$defaultBarLegend = {color: '#808BAB', fontSize: $elm$core$Maybe$Nothing, height: 10, htmlAttrs: _List_Nil, spacing: 10, title: '', width: 10, xOff: 0, yOff: 0};
var $author$project$Chart$Svg$barLegend = F2(
	function (edits, barAttrs) {
		return A2(
			$author$project$Internal$Svg$barLegend,
			A2($author$project$Internal$Helpers$apply, edits, $author$project$Internal$Svg$defaultBarLegend),
			A2($author$project$Internal$Helpers$apply, barAttrs, $author$project$Internal$Svg$defaultBar));
	});
var $author$project$Internal$Svg$Row = {$: 'Row'};
var $author$project$Internal$Svg$defaultLegends = {alignment: $author$project$Internal$Svg$Row, anchor: $elm$core$Maybe$Nothing, background: '', border: '', borderWidth: 0, htmlAttrs: _List_Nil, spacing: 10, xOff: 0, yOff: 0};
var $author$project$Internal$Svg$legendsAt = F5(
	function (plane, x, y, config, children) {
		var otherAttrs = _List_fromArray(
			[
				$elm$html$Html$Attributes$class('elm-charts__legends'),
				A2($elm$html$Html$Attributes$style, 'background', config.background),
				A2($elm$html$Html$Attributes$style, 'border-color', config.border),
				A2(
				$elm$html$Html$Attributes$style,
				'border-width',
				$elm$core$String$fromFloat(config.borderWidth) + 'px'),
				A2($elm$html$Html$Attributes$style, 'border-style', 'solid')
			]);
		var anchorAttrs = function () {
			var _v2 = config.anchor;
			if (_v2.$ === 'Nothing') {
				return _List_fromArray(
					[
						A2($elm$html$Html$Attributes$style, 'transform', 'translate(-0%, 0%)')
					]);
			} else {
				switch (_v2.a.$) {
					case 'End':
						var _v3 = _v2.a;
						return _List_fromArray(
							[
								A2($elm$html$Html$Attributes$style, 'transform', 'translate(-100%, 0%)')
							]);
					case 'Start':
						var _v4 = _v2.a;
						return _List_fromArray(
							[
								A2($elm$html$Html$Attributes$style, 'transform', 'translate(-0%, 0%)')
							]);
					default:
						var _v5 = _v2.a;
						return _List_fromArray(
							[
								A2($elm$html$Html$Attributes$style, 'transform', 'translate(-50%, 0%)')
							]);
				}
			}
		}();
		var _v0 = function () {
			var _v1 = config.alignment;
			if (_v1.$ === 'Row') {
				return _Utils_Tuple2(
					_List_fromArray(
						[
							A2($elm$html$Html$Attributes$style, 'display', 'flex'),
							A2($elm$html$Html$Attributes$style, 'align-items', 'center')
						]),
					'right');
			} else {
				return _Utils_Tuple2(
					_List_fromArray(
						[
							A2($elm$html$Html$Attributes$style, 'display', 'flex'),
							A2($elm$html$Html$Attributes$style, 'flex-direction', 'column'),
							A2($elm$html$Html$Attributes$style, 'align-items', 'baseline')
						]),
					'bottom');
			}
		}();
		var alignmentAttrs = _v0.a;
		var direction = _v0.b;
		var paddingStyle = ' .elm-charts__legends .elm-charts__legend {\n              margin-' + (direction + (':' + ($elm$core$String$fromFloat(config.spacing) + ('px;\n            }\n\n            .elm-charts__legends .elm-charts__legend:last-child {\n              margin-' + (direction + ': 0px;\n            }\n        ')))));
		return A7(
			$author$project$Internal$Svg$positionHtml,
			plane,
			x,
			y,
			config.xOff,
			-config.yOff,
			_Utils_ap(
				anchorAttrs,
				_Utils_ap(
					alignmentAttrs,
					_Utils_ap(otherAttrs, config.htmlAttrs))),
			A2(
				$elm$core$List$cons,
				A3(
					$elm$html$Html$node,
					'style',
					_List_Nil,
					_List_fromArray(
						[
							$elm$html$Html$text(paddingStyle)
						])),
				children));
	});
var $author$project$Chart$Svg$legendsAt = F4(
	function (plane, x, y, edits) {
		return A4(
			$author$project$Internal$Svg$legendsAt,
			plane,
			x,
			y,
			A2($author$project$Internal$Helpers$apply, edits, $author$project$Internal$Svg$defaultLegends));
	});
var $author$project$Internal$Svg$defaultInterpolation = {attrs: _List_Nil, color: $author$project$Internal$Helpers$pink, dashed: _List_Nil, design: $elm$core$Maybe$Nothing, method: $elm$core$Maybe$Nothing, opacity: 0, width: 1};
var $author$project$Internal$Svg$defaultLineLegend = {color: '#808BAB', fontSize: $elm$core$Maybe$Nothing, height: 16, htmlAttrs: _List_Nil, spacing: 10, title: '', width: 30, xOff: 0, yOff: 0};
var $author$project$Internal$Svg$Point = F2(
	function (x, y) {
		return {x: x, y: y};
	});
var $elm$svg$Svg$Attributes$fillRule = _VirtualDom_attribute('fill-rule');
var $author$project$Internal$Coordinates$fromProps = F3(
	function (xs, ys, data) {
		var getValues = F2(
			function (vs, datum) {
				return A2(
					$elm$core$List$filterMap,
					function (v) {
						return v(datum);
					},
					vs);
			});
		var getMin = A2(
			$elm$core$Basics$composeL,
			$elm$core$Maybe$withDefault(0),
			$elm$core$List$minimum);
		var getMax = A2(
			$elm$core$Basics$composeL,
			$elm$core$Maybe$withDefault(1),
			$elm$core$List$maximum);
		var toPosition = function (datum) {
			var vsY = A2(getValues, ys, datum);
			var vsX = A2(getValues, xs, datum);
			return {
				x1: getMin(vsX),
				x2: getMax(vsX),
				y1: getMin(vsY),
				y2: getMax(vsY)
			};
		};
		return A2($author$project$Internal$Coordinates$foldPosition, toPosition, data);
	});
var $author$project$Internal$Interpolation$linear = $elm$core$List$map(
	$elm$core$List$map(
		function (_v0) {
			var x = _v0.x;
			var y = _v0.y;
			return A2($author$project$Internal$Commands$Line, x, y);
		}));
var $author$project$Internal$Interpolation$First = {$: 'First'};
var $author$project$Internal$Interpolation$Previous = function (a) {
	return {$: 'Previous', a: a};
};
var $author$project$Internal$Interpolation$monotoneCurve = F4(
	function (point0, point1, tangent0, tangent1) {
		var dx = (point1.x - point0.x) / 3;
		return A6($author$project$Internal$Commands$CubicBeziers, point0.x + dx, point0.y + (dx * tangent0), point1.x - dx, point1.y - (dx * tangent1), point1.x, point1.y);
	});
var $author$project$Internal$Interpolation$slope2 = F3(
	function (point0, point1, t) {
		var h = point1.x - point0.x;
		return (!(!h)) ? ((((3 * (point1.y - point0.y)) / h) - t) / 2) : t;
	});
var $author$project$Internal$Interpolation$sign = function (x) {
	return (x < 0) ? (-1) : 1;
};
var $author$project$Internal$Interpolation$toH = F2(
	function (h0, h1) {
		return (!h0) ? ((h1 < 0) ? (0 * (-1)) : h1) : h0;
	});
var $author$project$Internal$Interpolation$slope3 = F3(
	function (point0, point1, point2) {
		var h1 = point2.x - point1.x;
		var h0 = point1.x - point0.x;
		var s0h = A2($author$project$Internal$Interpolation$toH, h0, h1);
		var s0 = (point1.y - point0.y) / s0h;
		var s1h = A2($author$project$Internal$Interpolation$toH, h1, h0);
		var s1 = (point2.y - point1.y) / s1h;
		var p = ((s0 * h1) + (s1 * h0)) / (h0 + h1);
		var slope = ($author$project$Internal$Interpolation$sign(s0) + $author$project$Internal$Interpolation$sign(s1)) * A2(
			$elm$core$Basics$min,
			A2(
				$elm$core$Basics$min,
				$elm$core$Basics$abs(s0),
				$elm$core$Basics$abs(s1)),
			0.5 * $elm$core$Basics$abs(p));
		return $elm$core$Basics$isNaN(slope) ? 0 : slope;
	});
var $author$project$Internal$Interpolation$monotonePart = F2(
	function (points, _v0) {
		var tangent = _v0.a;
		var commands = _v0.b;
		var _v1 = _Utils_Tuple2(tangent, points);
		_v1$4:
		while (true) {
			if (_v1.a.$ === 'First') {
				if (_v1.b.b && _v1.b.b.b) {
					if (_v1.b.b.b.b) {
						var _v2 = _v1.a;
						var _v3 = _v1.b;
						var p0 = _v3.a;
						var _v4 = _v3.b;
						var p1 = _v4.a;
						var _v5 = _v4.b;
						var p2 = _v5.a;
						var rest = _v5.b;
						var t1 = A3($author$project$Internal$Interpolation$slope3, p0, p1, p2);
						var t0 = A3($author$project$Internal$Interpolation$slope2, p0, p1, t1);
						return A2(
							$author$project$Internal$Interpolation$monotonePart,
							A2(
								$elm$core$List$cons,
								p1,
								A2($elm$core$List$cons, p2, rest)),
							_Utils_Tuple2(
								$author$project$Internal$Interpolation$Previous(t1),
								_Utils_ap(
									commands,
									_List_fromArray(
										[
											A4($author$project$Internal$Interpolation$monotoneCurve, p0, p1, t0, t1)
										]))));
					} else {
						var _v9 = _v1.a;
						var _v10 = _v1.b;
						var p0 = _v10.a;
						var _v11 = _v10.b;
						var p1 = _v11.a;
						var t1 = A3($author$project$Internal$Interpolation$slope3, p0, p1, p1);
						return _Utils_Tuple2(
							$author$project$Internal$Interpolation$Previous(t1),
							_Utils_ap(
								commands,
								_List_fromArray(
									[
										A4($author$project$Internal$Interpolation$monotoneCurve, p0, p1, t1, t1),
										A2($author$project$Internal$Commands$Line, p1.x, p1.y)
									])));
					}
				} else {
					break _v1$4;
				}
			} else {
				if (_v1.b.b && _v1.b.b.b) {
					if (_v1.b.b.b.b) {
						var t0 = _v1.a.a;
						var _v6 = _v1.b;
						var p0 = _v6.a;
						var _v7 = _v6.b;
						var p1 = _v7.a;
						var _v8 = _v7.b;
						var p2 = _v8.a;
						var rest = _v8.b;
						var t1 = A3($author$project$Internal$Interpolation$slope3, p0, p1, p2);
						return A2(
							$author$project$Internal$Interpolation$monotonePart,
							A2(
								$elm$core$List$cons,
								p1,
								A2($elm$core$List$cons, p2, rest)),
							_Utils_Tuple2(
								$author$project$Internal$Interpolation$Previous(t1),
								_Utils_ap(
									commands,
									_List_fromArray(
										[
											A4($author$project$Internal$Interpolation$monotoneCurve, p0, p1, t0, t1)
										]))));
					} else {
						var t0 = _v1.a.a;
						var _v12 = _v1.b;
						var p0 = _v12.a;
						var _v13 = _v12.b;
						var p1 = _v13.a;
						var t1 = A3($author$project$Internal$Interpolation$slope3, p0, p1, p1);
						return _Utils_Tuple2(
							$author$project$Internal$Interpolation$Previous(t1),
							_Utils_ap(
								commands,
								_List_fromArray(
									[
										A4($author$project$Internal$Interpolation$monotoneCurve, p0, p1, t0, t1),
										A2($author$project$Internal$Commands$Line, p1.x, p1.y)
									])));
					}
				} else {
					break _v1$4;
				}
			}
		}
		return _Utils_Tuple2(tangent, commands);
	});
var $author$project$Internal$Interpolation$monotoneSection = F2(
	function (points, _v0) {
		var tangent = _v0.a;
		var acc = _v0.b;
		var _v1 = function () {
			if (points.b) {
				var p0 = points.a;
				var rest = points.b;
				return A2(
					$author$project$Internal$Interpolation$monotonePart,
					A2($elm$core$List$cons, p0, rest),
					_Utils_Tuple2(
						tangent,
						_List_fromArray(
							[
								A2($author$project$Internal$Commands$Line, p0.x, p0.y)
							])));
			} else {
				return _Utils_Tuple2(tangent, _List_Nil);
			}
		}();
		var t0 = _v1.a;
		var commands = _v1.b;
		return _Utils_Tuple2(
			t0,
			A2($elm$core$List$cons, commands, acc));
	});
var $author$project$Internal$Interpolation$monotone = function (sections) {
	return A3(
		$elm$core$List$foldr,
		$author$project$Internal$Interpolation$monotoneSection,
		_Utils_Tuple2($author$project$Internal$Interpolation$First, _List_Nil),
		sections).b;
};
var $author$project$Internal$Interpolation$Point = F2(
	function (x, y) {
		return {x: x, y: y};
	});
var $author$project$Internal$Interpolation$after = F2(
	function (a, b) {
		return _List_fromArray(
			[
				a,
				A2($author$project$Internal$Interpolation$Point, b.x, a.y),
				b
			]);
	});
var $author$project$Internal$Interpolation$stepped = function (sections) {
	var expand = F2(
		function (result, section) {
			expand:
			while (true) {
				if (section.b) {
					if (section.b.b) {
						var a = section.a;
						var _v1 = section.b;
						var b = _v1.a;
						var rest = _v1.b;
						var $temp$result = _Utils_ap(
							result,
							A2($author$project$Internal$Interpolation$after, a, b)),
							$temp$section = A2($elm$core$List$cons, b, rest);
						result = $temp$result;
						section = $temp$section;
						continue expand;
					} else {
						var last = section.a;
						return result;
					}
				} else {
					return result;
				}
			}
		});
	return A2(
		$elm$core$List$map,
		A2(
			$elm$core$Basics$composeR,
			expand(_List_Nil),
			$elm$core$List$map(
				function (_v2) {
					var x = _v2.x;
					var y = _v2.y;
					return A2($author$project$Internal$Commands$Line, x, y);
				})),
		sections);
};
var $elm$core$List$drop = F2(
	function (n, list) {
		drop:
		while (true) {
			if (n <= 0) {
				return list;
			} else {
				if (!list.b) {
					return list;
				} else {
					var x = list.a;
					var xs = list.b;
					var $temp$n = n - 1,
						$temp$list = xs;
					n = $temp$n;
					list = $temp$list;
					continue drop;
				}
			}
		}
	});
var $author$project$Internal$Svg$last = function (list) {
	return $elm$core$List$head(
		A2(
			$elm$core$List$drop,
			$elm$core$List$length(list) - 1,
			list));
};
var $author$project$Internal$Svg$withBorder = F2(
	function (stuff, func) {
		if (stuff.b) {
			var first = stuff.a;
			var rest = stuff.b;
			return $elm$core$Maybe$Just(
				A2(
					func,
					first,
					A2(
						$elm$core$Maybe$withDefault,
						first,
						$author$project$Internal$Svg$last(rest))));
		} else {
			return $elm$core$Maybe$Nothing;
		}
	});
var $author$project$Internal$Svg$toCommands = F4(
	function (method, toX, toY, data) {
		var toSets = F2(
			function (ps, cmds) {
				return A2(
					$author$project$Internal$Svg$withBorder,
					ps,
					F2(
						function (first, last_) {
							return _Utils_Tuple3(first, cmds, last_);
						}));
			});
		var fold = F2(
			function (datum_, acc) {
				var _v1 = toY(datum_);
				if (_v1.$ === 'Just') {
					var y_ = _v1.a;
					if (acc.b) {
						var latest = acc.a;
						var rest = acc.b;
						return A2(
							$elm$core$List$cons,
							_Utils_ap(
								latest,
								_List_fromArray(
									[
										{
										x: toX(datum_),
										y: y_
									}
									])),
							rest);
					} else {
						return A2(
							$elm$core$List$cons,
							_List_fromArray(
								[
									{
									x: toX(datum_),
									y: y_
								}
								]),
							acc);
					}
				} else {
					return A2($elm$core$List$cons, _List_Nil, acc);
				}
			});
		var points = $elm$core$List$reverse(
			A3($elm$core$List$foldl, fold, _List_Nil, data));
		var commands = function () {
			switch (method.$) {
				case 'Linear':
					return $author$project$Internal$Interpolation$linear(points);
				case 'Monotone':
					return $author$project$Internal$Interpolation$monotone(points);
				default:
					return $author$project$Internal$Interpolation$stepped(points);
			}
		}();
		return A2(
			$elm$core$List$filterMap,
			$elm$core$Basics$identity,
			A3($elm$core$List$map2, toSets, points, commands));
	});
var $author$project$Internal$Svg$area = F6(
	function (plane, toX, toY2M, toY, config, data) {
		var limits = A3(
			$author$project$Internal$Coordinates$fromProps,
			_List_fromArray(
				[
					A2($elm$core$Basics$composeR, toX, $elm$core$Maybe$Just)
				]),
			_List_fromArray(
				[
					toY,
					A2(
					$elm$core$Maybe$withDefault,
					$elm$core$Basics$always(
						$elm$core$Maybe$Just(0)),
					toY2M)
				]),
			data);
		var _v0 = function () {
			var _v1 = config.design;
			if (_v1.$ === 'Nothing') {
				return _Utils_Tuple2(
					$elm$svg$Svg$text(''),
					config.color);
			} else {
				var design = _v1.a;
				return A2($author$project$Internal$Svg$toPattern, config.color, design);
			}
		}();
		var patternDefs = _v0.a;
		var fill = _v0.b;
		var view = function (cmds) {
			return A4(
				$author$project$Internal$Svg$withAttrs,
				config.attrs,
				$elm$svg$Svg$path,
				_List_fromArray(
					[
						$elm$svg$Svg$Attributes$class('elm-charts__area-section'),
						$elm$svg$Svg$Attributes$fill(fill),
						$elm$svg$Svg$Attributes$fillOpacity(
						$elm$core$String$fromFloat(config.opacity)),
						$elm$svg$Svg$Attributes$strokeWidth('0'),
						$elm$svg$Svg$Attributes$fillRule('evenodd'),
						$elm$svg$Svg$Attributes$d(
						A2($author$project$Internal$Commands$description, plane, cmds)),
						$elm$svg$Svg$Attributes$style(
						A2($author$project$Internal$Svg$clipperStyle, plane, limits))
					]),
				_List_Nil);
		};
		var withUnder = F2(
			function (_v5, _v6) {
				var firstBottom = _v5.a;
				var cmdsBottom = _v5.b;
				var endBottom = _v5.c;
				var firstTop = _v6.a;
				var cmdsTop = _v6.b;
				var endTop = _v6.c;
				return view(
					_Utils_ap(
						_List_fromArray(
							[
								A2($author$project$Internal$Commands$Move, firstBottom.x, firstBottom.y),
								A2($author$project$Internal$Commands$Line, firstTop.x, firstTop.y)
							]),
						_Utils_ap(
							cmdsTop,
							_Utils_ap(
								_List_fromArray(
									[
										A2($author$project$Internal$Commands$Move, firstBottom.x, firstBottom.y)
									]),
								_Utils_ap(
									cmdsBottom,
									_List_fromArray(
										[
											A2($author$project$Internal$Commands$Line, endTop.x, endTop.y)
										]))))));
			});
		var withoutUnder = function (_v4) {
			var first = _v4.a;
			var cmds = _v4.b;
			var end = _v4.c;
			return view(
				_Utils_ap(
					_List_fromArray(
						[
							A2($author$project$Internal$Commands$Move, first.x, 0),
							A2($author$project$Internal$Commands$Line, first.x, first.y)
						]),
					_Utils_ap(
						cmds,
						_List_fromArray(
							[
								A2($author$project$Internal$Commands$Line, end.x, 0)
							]))));
		};
		if (config.opacity <= 0) {
			return $elm$svg$Svg$text('');
		} else {
			var _v2 = config.method;
			if (_v2.$ === 'Nothing') {
				return $elm$svg$Svg$text('');
			} else {
				var method = _v2.a;
				return A2(
					$elm$svg$Svg$g,
					_List_fromArray(
						[
							$elm$svg$Svg$Attributes$class('elm-charts__area-sections')
						]),
					function () {
						if (toY2M.$ === 'Nothing') {
							return A2(
								$elm$core$List$cons,
								patternDefs,
								A2(
									$elm$core$List$map,
									withoutUnder,
									A4($author$project$Internal$Svg$toCommands, method, toX, toY, data)));
						} else {
							var toY2 = toY2M.a;
							return A2(
								$elm$core$List$cons,
								patternDefs,
								A3(
									$elm$core$List$map2,
									withUnder,
									A4($author$project$Internal$Svg$toCommands, method, toX, toY2, data),
									A4($author$project$Internal$Svg$toCommands, method, toX, toY, data)));
						}
					}());
			}
		}
	});
var $author$project$Internal$Svg$interpolation = F5(
	function (plane, toX, toY, config, data) {
		var limits = A3(
			$author$project$Internal$Coordinates$fromProps,
			_List_fromArray(
				[
					A2($elm$core$Basics$composeR, toX, $elm$core$Maybe$Just)
				]),
			_List_fromArray(
				[toY]),
			data);
		var view = function (_v1) {
			var first = _v1.a;
			var cmds = _v1.b;
			return A4(
				$author$project$Internal$Svg$withAttrs,
				config.attrs,
				$elm$svg$Svg$path,
				_List_fromArray(
					[
						$elm$svg$Svg$Attributes$class('elm-charts__interpolation-section'),
						$elm$svg$Svg$Attributes$fill('transparent'),
						$elm$svg$Svg$Attributes$stroke(config.color),
						$elm$svg$Svg$Attributes$strokeDasharray(
						A2(
							$elm$core$String$join,
							' ',
							A2($elm$core$List$map, $elm$core$String$fromFloat, config.dashed))),
						$elm$svg$Svg$Attributes$strokeWidth(
						$elm$core$String$fromFloat(config.width)),
						$elm$svg$Svg$Attributes$d(
						A2(
							$author$project$Internal$Commands$description,
							plane,
							A2(
								$elm$core$List$cons,
								A2($author$project$Internal$Commands$Move, first.x, first.y),
								cmds))),
						$elm$svg$Svg$Attributes$style(
						A2($author$project$Internal$Svg$clipperStyle, plane, limits))
					]),
				_List_Nil);
		};
		var _v0 = config.method;
		if (_v0.$ === 'Nothing') {
			return $elm$svg$Svg$text('');
		} else {
			var method = _v0.a;
			return A2(
				$elm$svg$Svg$g,
				_List_fromArray(
					[
						$elm$svg$Svg$Attributes$class('elm-charts__interpolation-sections')
					]),
				A2(
					$elm$core$List$map,
					view,
					A4($author$project$Internal$Svg$toCommands, method, toX, toY, data)));
		}
	});
var $author$project$Internal$Svg$toRadius = F2(
	function (size_, shape) {
		var area_ = (2 * $elm$core$Basics$pi) * size_;
		switch (shape.$) {
			case 'Circle':
				return $elm$core$Basics$sqrt(area_ / $elm$core$Basics$pi);
			case 'Triangle':
				var side = $elm$core$Basics$sqrt(
					(area_ * 4) / $elm$core$Basics$sqrt(3));
				return $elm$core$Basics$sqrt(3) * side;
			case 'Square':
				return $elm$core$Basics$sqrt(area_) / 2;
			case 'Diamond':
				return $elm$core$Basics$sqrt(area_) / 2;
			case 'Cross':
				return $elm$core$Basics$sqrt(area_ / 4);
			default:
				return $elm$core$Basics$sqrt(area_ / 4);
		}
	});
var $author$project$Internal$Svg$lineLegend = F3(
	function (config, interConfig, dotConfig) {
		var topMargin = function () {
			var _v1 = dotConfig.shape;
			if (_v1.$ === 'Just') {
				var shape = _v1.a;
				return A2($author$project$Internal$Svg$toRadius, dotConfig.size, shape);
			} else {
				return 0;
			}
		}();
		var fontStyle = function () {
			var _v0 = config.fontSize;
			if (_v0.$ === 'Just') {
				var size_ = _v0.a;
				return A2(
					$elm$html$Html$Attributes$style,
					'font-size',
					$elm$core$String$fromInt(size_) + 'px');
			} else {
				return A2($elm$html$Html$Attributes$style, '', '');
			}
		}();
		var fakePlane = {
			x: A7($author$project$Internal$Coordinates$Axis, config.width, 0, 0, 0, 10, 0, 10),
			y: A7($author$project$Internal$Coordinates$Axis, config.height, 0, 0, 0, 10, 0, 10)
		};
		var bottomMargin = (!interConfig.opacity) ? topMargin : 0;
		return A2(
			$elm$html$Html$div,
			_Utils_ap(
				_List_fromArray(
					[
						$elm$html$Html$Attributes$class('elm-charts__legend'),
						A2($elm$html$Html$Attributes$style, 'display', 'flex'),
						A2($elm$html$Html$Attributes$style, 'align-items', 'center')
					]),
				config.htmlAttrs),
			_List_fromArray(
				[
					A5(
					$author$project$Internal$Svg$container,
					fakePlane,
					_Utils_update(
						$author$project$Internal$Svg$defaultContainer,
						{responsive: false}),
					_List_Nil,
					_List_fromArray(
						[
							A5(
							$author$project$Internal$Svg$interpolation,
							fakePlane,
							function ($) {
								return $.x;
							},
							A2(
								$elm$core$Basics$composeR,
								function ($) {
									return $.y;
								},
								$elm$core$Maybe$Just),
							interConfig,
							_List_fromArray(
								[
									A2($author$project$Internal$Svg$Point, 0, 5),
									A2($author$project$Internal$Svg$Point, 10, 5)
								])),
							A6(
							$author$project$Internal$Svg$area,
							fakePlane,
							function ($) {
								return $.x;
							},
							$elm$core$Maybe$Nothing,
							A2(
								$elm$core$Basics$composeR,
								function ($) {
									return $.y;
								},
								$elm$core$Maybe$Just),
							interConfig,
							_List_fromArray(
								[
									A2($author$project$Internal$Svg$Point, 0, 5),
									A2($author$project$Internal$Svg$Point, 10, 5)
								])),
							A5(
							$author$project$Internal$Svg$dot,
							fakePlane,
							function ($) {
								return $.x;
							},
							function ($) {
								return $.y;
							},
							dotConfig,
							A2($author$project$Internal$Svg$Point, 5, 5))
						]),
					_List_Nil),
					A2(
					$elm$html$Html$div,
					_List_fromArray(
						[
							fontStyle,
							A2(
							$elm$html$Html$Attributes$style,
							'margin-left',
							$elm$core$String$fromFloat(config.spacing) + 'px')
						]),
					_List_fromArray(
						[
							$elm$html$Html$text(config.title)
						]))
				]));
	});
var $author$project$Internal$Svg$Linear = {$: 'Linear'};
var $author$project$Chart$Attributes$linear = function (config) {
	return _Utils_update(
		config,
		{
			method: $elm$core$Maybe$Just($author$project$Internal$Svg$Linear)
		});
};
var $author$project$Chart$Svg$lineLegend = F3(
	function (edits, interAttrsOrg, dotAttrsOrg) {
		var interpolationConfigOrg = A2($author$project$Internal$Helpers$apply, interAttrsOrg, $author$project$Internal$Svg$defaultInterpolation);
		var dotConfigOrg = A2($author$project$Internal$Helpers$apply, dotAttrsOrg, $author$project$Internal$Svg$defaultDot);
		var adjustWidth = function (config) {
			return _Utils_update(
				config,
				{width: 10});
		};
		var _v0 = function () {
			var _v1 = _Utils_Tuple2(interpolationConfigOrg.method, dotConfigOrg.shape);
			if (_v1.a.$ === 'Just') {
				if (_v1.b.$ === 'Nothing') {
					var _v2 = _v1.b;
					return _Utils_Tuple3(
						dotAttrsOrg,
						interAttrsOrg,
						A2(
							$elm$core$List$cons,
							$author$project$Chart$Attributes$width(10),
							edits));
				} else {
					return _Utils_Tuple3(
						dotAttrsOrg,
						A2(
							$elm$core$List$cons,
							$author$project$Chart$Attributes$opacity(0),
							interAttrsOrg),
						edits);
				}
			} else {
				if (_v1.b.$ === 'Nothing') {
					var _v3 = _v1.a;
					var _v4 = _v1.b;
					return _Utils_Tuple3(
						A2($elm$core$List$cons, $author$project$Chart$Attributes$circle, dotAttrsOrg),
						A2($elm$core$List$cons, $author$project$Chart$Attributes$linear, interAttrsOrg),
						A2(
							$elm$core$List$cons,
							$author$project$Chart$Attributes$width(10),
							edits));
				} else {
					var _v5 = _v1.a;
					return _Utils_Tuple3(
						A2($elm$core$List$cons, $author$project$Chart$Attributes$circle, dotAttrsOrg),
						interAttrsOrg,
						A2(
							$elm$core$List$cons,
							$author$project$Chart$Attributes$width(10),
							edits));
				}
			}
		}();
		var dotAttrs = _v0.a;
		var interAttrs = _v0.b;
		var lineLegendAttrs = _v0.c;
		return A3(
			$author$project$Internal$Svg$lineLegend,
			A2($author$project$Internal$Helpers$apply, lineLegendAttrs, $author$project$Internal$Svg$defaultLineLegend),
			A2($author$project$Internal$Helpers$apply, interAttrs, $author$project$Internal$Svg$defaultInterpolation),
			A2($author$project$Internal$Helpers$apply, dotAttrs, $author$project$Internal$Svg$defaultDot));
	});
var $author$project$Chart$Attributes$title = F2(
	function (value, config) {
		return _Utils_update(
			config,
			{title: value});
	});
var $author$project$Chart$legendsAt = F4(
	function (toX, toY, attrs, children) {
		return $author$project$Chart$HtmlElement(
			F2(
				function (p, legends_) {
					var viewLegend = function (legend) {
						if (legend.$ === 'BarLegend') {
							var name = legend.a;
							var barAttrs = legend.b;
							return A2(
								$author$project$Chart$Svg$barLegend,
								A2(
									$elm$core$List$cons,
									$author$project$Chart$Attributes$title(name),
									children),
								barAttrs);
						} else {
							var name = legend.a;
							var interAttrs = legend.b;
							var dotAttrs = legend.c;
							return A3(
								$author$project$Chart$Svg$lineLegend,
								A2(
									$elm$core$List$cons,
									$author$project$Chart$Attributes$title(name),
									children),
								interAttrs,
								dotAttrs);
						}
					};
					return A5(
						$author$project$Chart$Svg$legendsAt,
						p,
						toX(p.x),
						toY(p.y),
						attrs,
						A2($elm$core$List$map, viewLegend, legends_));
				}));
	});
var $author$project$Internal$Property$meta = F2(
	function (value, prop) {
		if (prop.$ === 'Property') {
			var con = prop.a;
			return $author$project$Internal$Property$Property(
				_Utils_update(
					con,
					{
						meta: $elm$core$Maybe$Just(value)
					}));
		} else {
			var cons = prop.a;
			return $author$project$Internal$Property$Stacked(
				A2(
					$elm$core$List$map,
					function (con) {
						return _Utils_update(
							con,
							{
								meta: $elm$core$Maybe$Just(value)
							});
					},
					cons));
		}
	});
var $author$project$Chart$named = function (name) {
	return $author$project$Internal$Property$meta(name);
};
var $author$project$Examples$BarCharts$Legends$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_fromArray(
					[
						$author$project$Chart$Attributes$roundTop(0.3)
					]),
				_List_fromArray(
					[
						A2(
						$author$project$Chart$named,
						'Cats',
						A2(
							$author$project$Chart$bar,
							function ($) {
								return $.z;
							},
							_List_Nil)),
						A2(
						$author$project$Chart$named,
						'Fish',
						A2(
							$author$project$Chart$bar,
							function ($) {
								return $.y;
							},
							_List_fromArray(
								[
									$author$project$Chart$Attributes$striped(_List_Nil)
								])))
					]),
				$author$project$Examples$BarCharts$Legends$data),
				A4(
				$author$project$Chart$legendsAt,
				function ($) {
					return $.max;
				},
				function ($) {
					return $.max;
				},
				_List_fromArray(
					[
						$author$project$Chart$Attributes$column,
						$author$project$Chart$Attributes$moveLeft(15),
						$author$project$Chart$Attributes$alignRight,
						$author$project$Chart$Attributes$spacing(5)
					]),
				_List_Nil)
			]));
};
var $author$project$Examples$BarCharts$Margin$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$Margin$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$Margin$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$Margin$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$Margin$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$BarCharts$Margin$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$BarCharts$Margin$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_fromArray(
					[
						$author$project$Chart$Attributes$margin(0.4)
					]),
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_Nil),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_Nil)
					]),
				$author$project$Examples$BarCharts$Margin$data)
			]));
};
var $author$project$Examples$BarCharts$Opacity$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$Opacity$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$Opacity$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$Opacity$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$Opacity$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$BarCharts$Opacity$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$BarCharts$Opacity$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$opacity(0.5)
							])),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_Nil)
					]),
				$author$project$Examples$BarCharts$Opacity$data)
			]));
};
var $author$project$Examples$BarCharts$Pattern$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$Pattern$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$Pattern$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$Pattern$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$Pattern$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$BarCharts$Pattern$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Internal$Svg$Dotted = function (a) {
	return {$: 'Dotted', a: a};
};
var $author$project$Chart$Attributes$dotted = F2(
	function (attrs_, config) {
		return _Utils_update(
			config,
			{
				design: $elm$core$Maybe$Just(
					$author$project$Internal$Svg$Dotted(attrs_)),
				opacity: (!config.opacity) ? 1 : config.opacity
			});
	});
var $author$project$Examples$BarCharts$Pattern$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$striped(
								_List_fromArray(
									[
										$author$project$Chart$Attributes$spacing(6)
									]))
							])),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$dotted(
								_List_fromArray(
									[
										$author$project$Chart$Attributes$rotate(45)
									]))
							]))
					]),
				$author$project$Examples$BarCharts$Pattern$data)
			]));
};
var $author$project$Examples$BarCharts$Spacing$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$Spacing$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$Spacing$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$Spacing$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$Spacing$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$BarCharts$Spacing$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$BarCharts$Spacing$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_fromArray(
					[
						$author$project$Chart$Attributes$spacing(0)
					]),
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_Nil),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_Nil)
					]),
				$author$project$Examples$BarCharts$Spacing$data)
			]));
};
var $author$project$Examples$BarCharts$Stacked$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$Stacked$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$Stacked$Datum, 0.0, 0.0, 1.2, 4.0, 1.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$Stacked$Datum, 2.0, 0.4, 2.2, 4.2, 3.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$Stacked$Datum, 3.0, 0.6, 1.0, 3.2, 2.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$BarCharts$Stacked$Datum, 4.0, 0.2, 1.2, 3.0, 3.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$BarCharts$Stacked$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						$author$project$Chart$stacked(
						_List_fromArray(
							[
								A2(
								$author$project$Chart$bar,
								function ($) {
									return $.y;
								},
								_List_Nil),
								A2(
								$author$project$Chart$bar,
								function ($) {
									return $.v;
								},
								_List_Nil)
							]))
					]),
				$author$project$Examples$BarCharts$Stacked$data)
			]));
};
var $author$project$Examples$BarCharts$Title$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$Title$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$Title$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$Title$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$Title$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$BarCharts$Title$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Chart$labelAt = F4(
	function (toX, toY, attrs, inner) {
		return $author$project$Chart$SvgElement(
			function (p) {
				return A4(
					$author$project$Chart$Svg$label,
					p,
					attrs,
					inner,
					{
						x: toX(p.x),
						y: toY(p.y)
					});
			});
	});
var $author$project$Chart$Attributes$middle = function (b) {
	return b.min + ((b.max - b.min) / 2);
};
var $author$project$Examples$BarCharts$Title$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A4(
				$author$project$Chart$labelAt,
				function ($) {
					return $.max;
				},
				function ($) {
					return $.max;
				},
				_List_fromArray(
					[
						$author$project$Chart$Attributes$moveLeft(8),
						$author$project$Chart$Attributes$moveDown(5),
						$author$project$Chart$Attributes$alignRight
					]),
				_List_fromArray(
					[
						$elm$svg$Svg$text('Quarterly revenue')
					])),
				A4(
				$author$project$Chart$labelAt,
				$author$project$Chart$Attributes$middle,
				function ($) {
					return $.min;
				},
				_List_fromArray(
					[
						$author$project$Chart$Attributes$moveDown(18)
					]),
				_List_fromArray(
					[
						$elm$svg$Svg$text('Quarter')
					])),
				A4(
				$author$project$Chart$labelAt,
				function ($) {
					return $.min;
				},
				$author$project$Chart$Attributes$middle,
				_List_fromArray(
					[
						$author$project$Chart$Attributes$moveLeft(25),
						$author$project$Chart$Attributes$rotate(90)
					]),
				_List_fromArray(
					[
						$elm$svg$Svg$text('Revenue')
					])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_Nil),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_Nil)
					]),
				$author$project$Examples$BarCharts$Title$data)
			]));
};
var $author$project$Examples$BarCharts$Tooltip$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$BarCharts$Tooltip$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$Tooltip$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$Tooltip$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$Tooltip$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$Tooltip$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$BarCharts$Tooltip$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$BarCharts$Tooltip$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$BarCharts$Tooltip$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$bars)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$BarCharts$Tooltip$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						$author$project$Chart$stacked(
						_List_fromArray(
							[
								A2(
								$author$project$Chart$bar,
								function ($) {
									return $.z;
								},
								_List_Nil),
								A2(
								$author$project$Chart$bar,
								function ($) {
									return $.y;
								},
								_List_Nil)
							])),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.v;
						},
						_List_Nil)
					]),
				$author$project$Examples$BarCharts$Tooltip$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4($author$project$Chart$tooltip, item, _List_Nil, _List_Nil, _List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$BarCharts$TooltipBin$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$BarCharts$TooltipBin$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$TooltipBin$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$TooltipBin$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$TooltipBin$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$TooltipBin$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$BarCharts$TooltipBin$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$BarCharts$TooltipBin$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$BarCharts$TooltipBin$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$bins)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$BarCharts$TooltipBin$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_Nil),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_Nil)
					]),
				$author$project$Examples$BarCharts$TooltipBin$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4($author$project$Chart$tooltip, item, _List_Nil, _List_Nil, _List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$BarCharts$TooltipStack$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$BarCharts$TooltipStack$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$TooltipStack$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$TooltipStack$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$TooltipStack$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$TooltipStack$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$BarCharts$TooltipStack$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$BarCharts$TooltipStack$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$BarCharts$TooltipStack$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$stacks)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$BarCharts$TooltipStack$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						$author$project$Chart$stacked(
						_List_fromArray(
							[
								A2(
								$author$project$Chart$bar,
								function ($) {
									return $.z;
								},
								_List_Nil),
								A2(
								$author$project$Chart$bar,
								function ($) {
									return $.y;
								},
								_List_Nil)
							])),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.v;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$color($author$project$Chart$Attributes$purple),
								$author$project$Chart$Attributes$striped(_List_Nil)
							]))
					]),
				$author$project$Examples$BarCharts$TooltipStack$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4($author$project$Chart$tooltip, item, _List_Nil, _List_Nil, _List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$BarCharts$Ungroup$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$BarCharts$Ungroup$data = _List_fromArray(
	[
		A8($author$project$Examples$BarCharts$Ungroup$Datum, 0.0, 0.0, 2.0, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$BarCharts$Ungroup$Datum, 1.0, 2.0, 3.0, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$BarCharts$Ungroup$Datum, 2.0, 3.0, 4.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$BarCharts$Ungroup$Datum, 3.0, 4.0, 5.0, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Chart$Attributes$ungroup = function (config) {
	return _Utils_update(
		config,
		{grouped: false});
};
var $author$project$Examples$BarCharts$Ungroup$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_fromArray(
					[$author$project$Chart$Attributes$ungroup]),
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.w;
						},
						_List_Nil),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$striped(_List_Nil)
							]))
					]),
				$author$project$Examples$BarCharts$Ungroup$data)
			]));
};
var $author$project$Examples$BarCharts$VariableWidth$Datum = F3(
	function (start, end, y) {
		return {end: end, start: start, y: y};
	});
var $author$project$Examples$BarCharts$VariableWidth$data = _List_fromArray(
	[
		A3($author$project$Examples$BarCharts$VariableWidth$Datum, 1, 2, 2),
		A3($author$project$Examples$BarCharts$VariableWidth$Datum, 2, 3, 3),
		A3($author$project$Examples$BarCharts$VariableWidth$Datum, 3, 6, 4),
		A3($author$project$Examples$BarCharts$VariableWidth$Datum, 6, 7, 6)
	]);
var $author$project$Examples$BarCharts$VariableWidth$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_fromArray(
					[
						$author$project$Chart$Attributes$x1(
						function ($) {
							return $.start;
						}),
						$author$project$Chart$Attributes$x2(
						function ($) {
							return $.end;
						}),
						$author$project$Chart$Attributes$margin(0)
					]),
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$borderWidth(0.3),
								$author$project$Chart$Attributes$opacity(0.5)
							]))
					]),
				$author$project$Examples$BarCharts$VariableWidth$data)
			]));
};
var $author$project$Chart$Attributes$amount = F2(
	function (value, config) {
		return _Utils_update(
			config,
			{amount: value});
	});
var $author$project$Chart$TicksElement = F2(
	function (a, b) {
		return {$: 'TicksElement', a: a, b: b};
	});
var $author$project$Chart$Attributes$length = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{length: v});
	});
var $author$project$Internal$Svg$defaultTick = {attrs: _List_Nil, color: 'rgb(210, 210, 210)', length: 5, width: 1};
var $author$project$Internal$Svg$tick = F4(
	function (plane, config, isX, point) {
		return A4(
			$author$project$Internal$Svg$withAttrs,
			config.attrs,
			$elm$svg$Svg$line,
			_List_fromArray(
				[
					$elm$svg$Svg$Attributes$class('elm-charts__tick'),
					$elm$svg$Svg$Attributes$stroke(config.color),
					$elm$svg$Svg$Attributes$strokeWidth(
					$elm$core$String$fromFloat(config.width)),
					$elm$svg$Svg$Attributes$x1(
					$elm$core$String$fromFloat(
						A2($author$project$Internal$Coordinates$toSVGX, plane, point.x))),
					$elm$svg$Svg$Attributes$x2(
					$elm$core$String$fromFloat(
						A2($author$project$Internal$Coordinates$toSVGX, plane, point.x) + (isX ? 0 : (-config.length)))),
					$elm$svg$Svg$Attributes$y1(
					$elm$core$String$fromFloat(
						A2($author$project$Internal$Coordinates$toSVGY, plane, point.y))),
					$elm$svg$Svg$Attributes$y2(
					$elm$core$String$fromFloat(
						A2($author$project$Internal$Coordinates$toSVGY, plane, point.y) + (isX ? config.length : 0)))
				]),
			_List_Nil);
	});
var $author$project$Internal$Svg$xTick = F3(
	function (plane, config, point) {
		return A4($author$project$Internal$Svg$tick, plane, config, true, point);
	});
var $author$project$Chart$Svg$xTick = F2(
	function (plane, edits) {
		return A2(
			$author$project$Internal$Svg$xTick,
			plane,
			A2($author$project$Internal$Helpers$apply, edits, $author$project$Internal$Svg$defaultTick));
	});
var $author$project$Chart$xTicks = function (edits) {
	var config = A2(
		$author$project$Internal$Helpers$apply,
		edits,
		{amount: 5, color: '', flip: false, generate: $author$project$Internal$Svg$Floats, grid: true, height: 5, limits: _List_Nil, pinned: $author$project$Chart$Attributes$zero, width: 1});
	var toTicks = function (p) {
		return A2(
			$elm$core$List$map,
			function ($) {
				return $.value;
			},
			A4(
				$author$project$Chart$generateValues,
				config.amount,
				config.generate,
				$elm$core$Maybe$Nothing,
				A3(
					$elm$core$List$foldl,
					F2(
						function (f, x) {
							return f(x);
						}),
					p.x,
					config.limits)));
	};
	var addTickValues = F2(
		function (p, ts) {
			return (!config.grid) ? ts : _Utils_update(
				ts,
				{
					xs: _Utils_ap(
						ts.xs,
						toTicks(p))
				});
		});
	return A2(
		$author$project$Chart$TicksElement,
		addTickValues,
		function (p) {
			var toTick = function (x) {
				return A3(
					$author$project$Chart$Svg$xTick,
					p,
					_List_fromArray(
						[
							$author$project$Chart$Attributes$color(config.color),
							$author$project$Chart$Attributes$length(
							config.flip ? (-config.height) : config.height),
							$author$project$Chart$Attributes$width(config.width)
						]),
					{
						x: x,
						y: config.pinned(p.y)
					});
			};
			return A2(
				$elm$svg$Svg$g,
				_List_fromArray(
					[
						$elm$svg$Svg$Attributes$class('elm-charts__x-ticks')
					]),
				A2(
					$elm$core$List$map,
					toTick,
					toTicks(p)));
		});
};
var $author$project$Examples$Frame$Amount$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$xTicks(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$amount(4)
					])),
				$author$project$Chart$xLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$amount(4)
					]))
			]));
};
var $author$project$Chart$Svg$positionHtml = $author$project$Internal$Svg$positionHtml;
var $author$project$Chart$htmlAt = F6(
	function (toX, toY, xOff, yOff, att, view) {
		return $author$project$Chart$HtmlElement(
			F2(
				function (p, _v0) {
					return A7(
						$author$project$Chart$Svg$positionHtml,
						p,
						toX(p.x),
						toY(p.y),
						xOff,
						yOff,
						att,
						view);
				}));
	});
var $author$project$Chart$Attributes$percent = F2(
	function (per, b) {
		return b.min + ((b.max - b.min) * (per / 100));
	});
var $author$project$Chart$Attributes$red = $author$project$Internal$Helpers$red;
var $author$project$Examples$Frame$Arbitrary$star = F2(
	function (x, y) {
		return A2(
			$elm$svg$Svg$polygon,
			_List_fromArray(
				[
					$elm$svg$Svg$Attributes$points('100,10 40,198 190,78 10,78 160,198'),
					$elm$svg$Svg$Attributes$fill($author$project$Chart$Attributes$red),
					$elm$svg$Svg$Attributes$transform(
					$elm$core$String$concat(
						_List_fromArray(
							[
								'translate(',
								$elm$core$String$fromFloat(x),
								' ',
								$elm$core$String$fromFloat(y),
								') scale(0.1 0.1)'
							])))
				]),
			_List_Nil);
	});
var $author$project$Chart$Svg$position = $author$project$Internal$Svg$position;
var $author$project$Chart$svgAt = F5(
	function (toX, toY, xOff, yOff, view) {
		return $author$project$Chart$SvgElement(
			function (p) {
				return A2(
					$elm$svg$Svg$g,
					_List_fromArray(
						[
							A6(
							$author$project$Chart$Svg$position,
							p,
							0,
							toX(p.x),
							toY(p.y),
							xOff,
							yOff)
						]),
					view);
			});
	});
var $author$project$Chart$yAxis = function (edits) {
	var config = A2(
		$author$project$Internal$Helpers$apply,
		edits,
		{arrow: true, color: '', limits: _List_Nil, pinned: $author$project$Chart$Attributes$zero, width: 1});
	var addTickValues = F2(
		function (p, ts) {
			return _Utils_update(
				ts,
				{
					xAxis: A2(
						$elm$core$List$cons,
						config.pinned(p.x),
						ts.xAxis)
				});
		});
	return A2(
		$author$project$Chart$AxisElement,
		addTickValues,
		function (p) {
			var yLimit = A3(
				$elm$core$List$foldl,
				F2(
					function (f, y) {
						return f(y);
					}),
				p.y,
				config.limits);
			return A2(
				$elm$svg$Svg$g,
				_List_fromArray(
					[
						$elm$svg$Svg$Attributes$class('elm-charts__y-axis')
					]),
				_List_fromArray(
					[
						A2(
						$author$project$Chart$Svg$line,
						p,
						_List_fromArray(
							[
								$author$project$Chart$Attributes$color(config.color),
								$author$project$Chart$Attributes$width(config.width),
								$author$project$Chart$Attributes$x1(
								config.pinned(p.x)),
								$author$project$Chart$Attributes$y1(
								A2($elm$core$Basics$max, p.y.min, yLimit.min)),
								$author$project$Chart$Attributes$y2(
								A2($elm$core$Basics$min, p.y.max, yLimit.max))
							])),
						config.arrow ? A3(
						$author$project$Chart$Svg$arrow,
						p,
						_List_fromArray(
							[
								$author$project$Chart$Attributes$color(config.color),
								$author$project$Chart$Attributes$rotate(-90)
							]),
						{
							x: config.pinned(p.x),
							y: yLimit.max
						}) : $elm$svg$Svg$text('')
					]));
		});
};
var $author$project$Internal$Svg$yTick = F3(
	function (plane, config, point) {
		return A4($author$project$Internal$Svg$tick, plane, config, false, point);
	});
var $author$project$Chart$Svg$yTick = F2(
	function (plane, edits) {
		return A2(
			$author$project$Internal$Svg$yTick,
			plane,
			A2($author$project$Internal$Helpers$apply, edits, $author$project$Internal$Svg$defaultTick));
	});
var $author$project$Chart$yTicks = function (edits) {
	var config = A2(
		$author$project$Internal$Helpers$apply,
		edits,
		{amount: 5, color: '', flip: false, generate: $author$project$Internal$Svg$Floats, grid: true, height: 5, limits: _List_Nil, pinned: $author$project$Chart$Attributes$zero, width: 1});
	var toTicks = function (p) {
		return A2(
			$elm$core$List$map,
			function ($) {
				return $.value;
			},
			A4(
				$author$project$Chart$generateValues,
				config.amount,
				config.generate,
				$elm$core$Maybe$Nothing,
				A3(
					$elm$core$List$foldl,
					F2(
						function (f, y) {
							return f(y);
						}),
					p.y,
					config.limits)));
	};
	var addTickValues = F2(
		function (p, ts) {
			return _Utils_update(
				ts,
				{
					ys: _Utils_ap(
						ts.ys,
						toTicks(p))
				});
		});
	return A2(
		$author$project$Chart$TicksElement,
		addTickValues,
		function (p) {
			var toTick = function (y) {
				return A3(
					$author$project$Chart$Svg$yTick,
					p,
					_List_fromArray(
						[
							$author$project$Chart$Attributes$color(config.color),
							$author$project$Chart$Attributes$length(
							config.flip ? (-config.height) : config.height),
							$author$project$Chart$Attributes$width(config.width)
						]),
					{
						x: config.pinned(p.x),
						y: y
					});
			};
			return A2(
				$elm$svg$Svg$g,
				_List_fromArray(
					[
						$elm$svg$Svg$Attributes$class('elm-charts__y-ticks')
					]),
				A2(
					$elm$core$List$map,
					toTick,
					toTicks(p)));
		});
};
var $author$project$Examples$Frame$Arbitrary$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$xTicks(_List_Nil),
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yAxis(_List_Nil),
				$author$project$Chart$yTicks(_List_Nil),
				$author$project$Chart$yLabels(_List_Nil),
				$author$project$Chart$svg(
				function (p) {
					return A2(
						$elm$svg$Svg$g,
						_List_Nil,
						_List_fromArray(
							[
								A2($author$project$Examples$Frame$Arbitrary$star, 200, 40),
								A2($author$project$Examples$Frame$Arbitrary$star, 250, 50)
							]));
				}),
				A5(
				$author$project$Chart$svgAt,
				$author$project$Chart$Attributes$percent(80),
				$author$project$Chart$Attributes$percent(20),
				0,
				0,
				_List_fromArray(
					[
						A2(
						$elm$svg$Svg$circle,
						_List_fromArray(
							[
								$elm$svg$Svg$Attributes$r('10'),
								$elm$svg$Svg$Attributes$fill('blue')
							]),
						_List_Nil)
					])),
				A6(
				$author$project$Chart$htmlAt,
				function ($) {
					return $.min;
				},
				$author$project$Chart$Attributes$middle,
				30,
				0,
				_List_fromArray(
					[
						A2($elm$html$Html$Attributes$style, 'border', '1px solid gray'),
						A2($elm$html$Html$Attributes$style, 'padding', '5px'),
						A2($elm$html$Html$Attributes$style, 'background', 'white')
					]),
				_List_fromArray(
					[
						$elm$html$Html$text('My arbitrary HTML')
					]))
			]));
};
var $author$project$Chart$Attributes$domain = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{domain: v});
	});
var $author$project$Chart$Attributes$highest = F3(
	function (v, edit, b) {
		return _Utils_update(
			b,
			{
				max: A3(edit, v, b.max, b.dataMax)
			});
	});
var $author$project$Chart$interpolated = F2(
	function (y, inter) {
		return A2(
			$author$project$Internal$Property$property,
			A2($elm$core$Basics$composeR, y, $elm$core$Maybe$Just),
			_Utils_ap(
				_List_fromArray(
					[$author$project$Chart$Attributes$linear]),
				inter));
	});
var $author$project$Chart$Attributes$likeData = function (b) {
	return _Utils_update(
		b,
		{max: b.dataMax, min: b.dataMin});
};
var $author$project$Chart$Attributes$limits = F2(
	function (value, config) {
		return _Utils_update(
			config,
			{limits: value});
	});
var $author$project$Chart$Attributes$orHigher = F3(
	function (most, real, _v0) {
		return (_Utils_cmp(real, most) < 0) ? most : real;
	});
var $author$project$Chart$Attributes$range = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{range: v});
	});
var $author$project$Chart$SeriesElement = F4(
	function (a, b, c, d) {
		return {$: 'SeriesElement', a: a, b: b, c: c, d: d};
	});
var $author$project$Internal$Legend$LineLegend = F3(
	function (a, b, c) {
		return {$: 'LineLegend', a: a, b: b, c: c};
	});
var $author$project$Internal$Legend$toDotLegends = F2(
	function (elIndex, properties) {
		var toInterConfig = function (attrs) {
			return A2($author$project$Internal$Helpers$apply, attrs, $author$project$Internal$Svg$defaultInterpolation);
		};
		var toDotLegend = F3(
			function (props, prop, colorIndex) {
				var defaultOpacity = ($elm$core$List$length(props) > 1) ? 0.4 : 0;
				var interAttr = _Utils_ap(
					_List_fromArray(
						[
							$author$project$Chart$Attributes$color(
							$author$project$Internal$Helpers$toDefaultColor(colorIndex)),
							$author$project$Chart$Attributes$opacity(defaultOpacity)
						]),
					prop.inter);
				var interConfig = toInterConfig(interAttr);
				var defaultName = 'Property #' + $elm$core$String$fromInt(colorIndex + 1);
				var defaultAttrs = _List_fromArray(
					[
						$author$project$Chart$Attributes$color(interConfig.color),
						$author$project$Chart$Attributes$border(interConfig.color),
						_Utils_eq(interConfig.method, $elm$core$Maybe$Nothing) ? $author$project$Chart$Attributes$circle : $elm$core$Basics$identity
					]);
				var dotAttrs = _Utils_ap(defaultAttrs, prop.attrs);
				return A3(
					$author$project$Internal$Legend$LineLegend,
					A2($elm$core$Maybe$withDefault, defaultName, prop.meta),
					interAttr,
					dotAttrs);
			});
		return A2(
			$elm$core$List$indexedMap,
			F2(
				function (propIndex, f) {
					return f(elIndex + propIndex);
				}),
			A2(
				$elm$core$List$concatMap,
				function (ps) {
					return A2(
						$elm$core$List$map,
						toDotLegend(ps),
						ps);
				},
				A2($elm$core$List$map, $author$project$Internal$Property$toConfigs, properties)));
	});
var $author$project$Internal$Item$Dot = function (a) {
	return {$: 'Dot', a: a};
};
var $elm$core$Maybe$map2 = F3(
	function (func, ma, mb) {
		if (ma.$ === 'Nothing') {
			return $elm$core$Maybe$Nothing;
		} else {
			var a = ma.a;
			if (mb.$ === 'Nothing') {
				return $elm$core$Maybe$Nothing;
			} else {
				var b = mb.a;
				return $elm$core$Maybe$Just(
					A2(func, a, b));
			}
		}
	});
var $author$project$Internal$Produce$toDotSeries = F4(
	function (elIndex, toX, properties, data) {
		var toInterConfig = function (attrs) {
			return A2($author$project$Internal$Helpers$apply, attrs, $author$project$Internal$Svg$defaultInterpolation);
		};
		var toDotConfig = function (attrs) {
			return A2($author$project$Internal$Helpers$apply, attrs, $author$project$Internal$Svg$defaultDot);
		};
		var toDotItem = F7(
			function (lineIndex, stackIndex, colorIndex, prop, interConfig, dataIndex, datum_) {
				var y_ = A2(
					$elm$core$Maybe$withDefault,
					0,
					prop.visual(datum_));
				var x_ = toX(datum_);
				var defaultAttrs = _List_fromArray(
					[
						$author$project$Chart$Attributes$color(interConfig.color),
						$author$project$Chart$Attributes$border(interConfig.color),
						_Utils_eq(interConfig.method, $elm$core$Maybe$Nothing) ? $author$project$Chart$Attributes$circle : $elm$core$Basics$identity
					]);
				var dotAttrs = _Utils_ap(
					defaultAttrs,
					_Utils_ap(
						prop.attrs,
						A5(prop.extra, lineIndex, stackIndex, dataIndex, prop.meta, datum_)));
				var config = toDotConfig(dotAttrs);
				return $author$project$Internal$Item$Rendered(
					{
						config: {
							product: config,
							toAny: $author$project$Internal$Item$Dot,
							tooltipInfo: {
								border: config.border,
								borderWidth: config.borderWidth,
								color: function () {
									var _v6 = config.color;
									if (_v6 === 'white') {
										return interConfig.color;
									} else {
										return config.color;
									}
								}(),
								data: dataIndex,
								elIndex: elIndex,
								formatted: prop.format(datum_),
								index: colorIndex,
								name: prop.meta,
								property: lineIndex,
								stack: stackIndex
							},
							values: {
								datum: datum_,
								isReal: function () {
									var _v7 = prop.value(datum_);
									if (_v7.$ === 'Just') {
										return true;
									} else {
										return false;
									}
								}(),
								x1: x_,
								x2: x_,
								y: y_
							}
						},
						toHtml: function (c) {
							return _List_fromArray(
								[
									A3(
									$author$project$Internal$Produce$tooltipRow,
									c.tooltipInfo.color,
									A2($author$project$Internal$Produce$toDefaultName, colorIndex, c.tooltipInfo.name),
									prop.format(datum_))
								]);
						},
						toLimits: function (_v8) {
							return {x1: x_, x2: x_, y1: y_, y2: y_};
						},
						toPosition: F2(
							function (plane, _v9) {
								var radius = A2(
									$elm$core$Maybe$withDefault,
									0,
									A2(
										$elm$core$Maybe$map,
										$author$project$Internal$Svg$toRadius(config.size),
										config.shape));
								var radiusX_ = A2($author$project$Internal$Coordinates$scaleCartesianX, plane, radius);
								var radiusY_ = A2($author$project$Internal$Coordinates$scaleCartesianY, plane, radius);
								return {x1: x_ - radiusX_, x2: x_ + radiusX_, y1: y_ - radiusY_, y2: y_ + radiusY_};
							}),
						toSvg: F3(
							function (plane, _v10, _v11) {
								var _v12 = prop.value(datum_);
								if (_v12.$ === 'Nothing') {
									return $elm$svg$Svg$text('');
								} else {
									return A5(
										$author$project$Internal$Svg$dot,
										plane,
										function ($) {
											return $.x;
										},
										function ($) {
											return $.y;
										},
										config,
										{x: x_, y: y_});
								}
							})
					});
			});
		var toSeriesItem = F5(
			function (lineIndex, stacks, stackIndex, prop, colorIndex) {
				var defaultOpacity = ($elm$core$List$length(stacks) > 1) ? 0.4 : 0;
				var interAttr = _Utils_ap(
					_List_fromArray(
						[
							$author$project$Chart$Attributes$color(
							$author$project$Internal$Helpers$toDefaultColor(colorIndex)),
							$author$project$Chart$Attributes$opacity(defaultOpacity)
						]),
					prop.inter);
				var interConfig = toInterConfig(interAttr);
				var dotItems = A2(
					$elm$core$List$indexedMap,
					A5(toDotItem, lineIndex, stackIndex, colorIndex, prop, interConfig),
					data);
				if (!dotItems.b) {
					return $elm$core$Maybe$Nothing;
				} else {
					var first = dotItems.a;
					var rest = dotItems.b;
					return $elm$core$Maybe$Just(
						$author$project$Internal$Item$Rendered(
							{
								config: {
									items: _Utils_Tuple2(first, rest)
								},
								toHtml: function (c) {
									return _List_fromArray(
										[
											A2(
											$elm$html$Html$table,
											_List_fromArray(
												[
													A2($elm$html$Html$Attributes$style, 'margin', '0')
												]),
											A2(
												$elm$core$List$concatMap,
												$author$project$Internal$Item$toHtml,
												function (_v1) {
													var x = _v1.a;
													var xs = _v1.b;
													return A2($elm$core$List$cons, x, xs);
												}(c.items)))
										]);
								},
								toLimits: function (c) {
									return A2(
										$author$project$Internal$Coordinates$foldPosition,
										$author$project$Internal$Item$getLimits,
										function (_v2) {
											var x = _v2.a;
											var xs = _v2.b;
											return A2($elm$core$List$cons, x, xs);
										}(c.items));
								},
								toPosition: F2(
									function (plane, c) {
										return A2(
											$author$project$Internal$Coordinates$foldPosition,
											$author$project$Internal$Item$getPosition(plane),
											function (_v3) {
												var x = _v3.a;
												var xs = _v3.b;
												return A2($elm$core$List$cons, x, xs);
											}(c.items));
									}),
								toSvg: F3(
									function (plane, _v4, _v5) {
										var toBottom = function (datum_) {
											return A3(
												$elm$core$Maybe$map2,
												F2(
													function (real, visual) {
														return visual - real;
													}),
												prop.value(datum_),
												prop.visual(datum_));
										};
										return A2(
											$elm$svg$Svg$g,
											_List_fromArray(
												[
													$elm$svg$Svg$Attributes$class('elm-charts__series')
												]),
											_List_fromArray(
												[
													A6(
													$author$project$Internal$Svg$area,
													plane,
													toX,
													$elm$core$Maybe$Just(toBottom),
													prop.visual,
													interConfig,
													data),
													A5($author$project$Internal$Svg$interpolation, plane, toX, prop.visual, interConfig, data),
													A2(
													$elm$svg$Svg$g,
													_List_fromArray(
														[
															$elm$svg$Svg$Attributes$class('elm-charts__dots')
														]),
													A2(
														$elm$core$List$map,
														$author$project$Internal$Item$toSvg(plane),
														dotItems))
												]));
									})
							}));
				}
			});
		return A2(
			$elm$core$List$filterMap,
			$elm$core$Basics$identity,
			A2(
				$elm$core$List$indexedMap,
				F2(
					function (propIndex, f) {
						return f(elIndex + propIndex);
					}),
				$elm$core$List$concat(
					A2(
						$elm$core$List$indexedMap,
						F2(
							function (lineIndex, stacks) {
								return A2(
									$elm$core$List$indexedMap,
									A2(toSeriesItem, lineIndex, stacks),
									stacks);
							}),
						A2($elm$core$List$map, $author$project$Internal$Property$toConfigs, properties)))));
	});
var $author$project$Chart$seriesMap = F4(
	function (mapData, toX, properties, data) {
		return $author$project$Chart$Indexed(
			function (index) {
				var legends_ = A2($author$project$Internal$Legend$toDotLegends, index, properties);
				var items = A4($author$project$Internal$Produce$toDotSeries, index, toX, properties, data);
				var toLimits = A2($elm$core$List$map, $author$project$Internal$Item$getLimits, items);
				var generalized = A2(
					$elm$core$List$map,
					$author$project$Internal$Item$map(mapData),
					A2($elm$core$List$concatMap, $author$project$Internal$Many$getGenerals, items));
				return _Utils_Tuple2(
					A4(
						$author$project$Chart$SeriesElement,
						toLimits,
						generalized,
						legends_,
						function (p) {
							return A2(
								$elm$svg$Svg$map,
								$elm$core$Basics$never,
								A2(
									$elm$svg$Svg$g,
									_List_fromArray(
										[
											$elm$svg$Svg$Attributes$class('elm-charts__dot-series')
										]),
									A2(
										$elm$core$List$map,
										$author$project$Internal$Item$toSvg(p),
										items)));
						}),
					index + $elm$core$List$length(
						A2($elm$core$List$concatMap, $author$project$Internal$Property$toConfigs, properties)));
			});
	});
var $author$project$Chart$series = F3(
	function (toX, properties, data) {
		return A4($author$project$Chart$seriesMap, $elm$core$Basics$identity, toX, properties, data);
	});
var $author$project$Examples$Frame$AxisLength$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				$author$project$Chart$Attributes$range(
				_List_fromArray(
					[
						A2($author$project$Chart$Attributes$lowest, 0, $author$project$Chart$Attributes$orLower),
						A2($author$project$Chart$Attributes$highest, 100, $author$project$Chart$Attributes$orHigher)
					])),
				$author$project$Chart$Attributes$domain(
				_List_fromArray(
					[
						A2($author$project$Chart$Attributes$lowest, 0, $author$project$Chart$Attributes$orLower),
						A2($author$project$Chart$Attributes$highest, 100, $author$project$Chart$Attributes$orHigher)
					]))
			]),
		_List_fromArray(
			[
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						A3(
						$author$project$Chart$interpolated,
						function ($) {
							return $.y;
						},
						_List_Nil,
						_List_Nil)
					]),
				_List_fromArray(
					[
						{x: 10, y: 20},
						{x: 85, y: 80}
					])),
				$author$project$Chart$xAxis(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$noArrow,
						$author$project$Chart$Attributes$limits(
						_List_fromArray(
							[$author$project$Chart$Attributes$likeData]))
					])),
				$author$project$Chart$xLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid]))
			]));
};
var $author$project$Chart$Attributes$htmlAttrs = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{htmlAttrs: v});
	});
var $author$project$Examples$Frame$Background$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				$author$project$Chart$Attributes$margin(
				{bottom: 30, left: 30, right: 20, top: 20}),
				$author$project$Chart$Attributes$htmlAttrs(
				_List_fromArray(
					[
						A2($elm$html$Html$Attributes$style, 'background', '#fcf9e9')
					]))
			]),
		_List_fromArray(
			[
				$author$project$Chart$grid(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$color('white')
					])),
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$yAxis(_List_Nil),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						A3(
						$author$project$Chart$interpolated,
						function ($) {
							return $.y;
						},
						_List_Nil,
						_List_Nil)
					]),
				_List_fromArray(
					[
						{x: 0, y: 0},
						{x: 10, y: 10}
					])),
				$author$project$Chart$xLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid]))
			]));
};
var $author$project$Examples$Frame$Basic$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$xTicks(_List_Nil),
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yAxis(_List_Nil),
				$author$project$Chart$yTicks(_List_Nil),
				$author$project$Chart$yLabels(_List_Nil)
			]));
};
var $author$project$Examples$Frame$Color$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$xTicks(_List_Nil),
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yAxis(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$color($author$project$Chart$Attributes$pink)
					])),
				$author$project$Chart$yTicks(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$color($author$project$Chart$Attributes$pink)
					])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$color($author$project$Chart$Attributes$pink)
					]))
			]));
};
var $author$project$Internal$Svg$fromCartesian = F2(
	function (plane, point) {
		return {
			x: A2($author$project$Internal$Coordinates$toSVGX, plane, point.x),
			y: A2($author$project$Internal$Coordinates$toSVGY, plane, point.y)
		};
	});
var $author$project$Chart$Svg$fromCartesian = $author$project$Internal$Svg$fromCartesian;
var $author$project$Chart$Svg$fromSvg = $author$project$Internal$Svg$fromSvg;
var $author$project$Examples$Frame$Coordinates$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$xTicks(_List_Nil),
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yAxis(_List_Nil),
				$author$project$Chart$yTicks(_List_Nil),
				$author$project$Chart$yLabels(_List_Nil),
				$author$project$Chart$svg(
				function (p) {
					var point = {x: 6, y: 4};
					var pointSvg = A2($author$project$Chart$Svg$fromCartesian, p, point);
					var color = _Utils_eq(
						A2($author$project$Chart$Svg$fromSvg, p, pointSvg),
						point) ? 'purple' : 'blue';
					return A2(
						$elm$svg$Svg$g,
						_List_Nil,
						_List_fromArray(
							[
								A2(
								$elm$svg$Svg$circle,
								_List_fromArray(
									[
										$elm$svg$Svg$Attributes$r('10'),
										$elm$svg$Svg$Attributes$fill(color),
										$elm$svg$Svg$Attributes$cx(
										$elm$core$String$fromFloat(pointSvg.x)),
										$elm$svg$Svg$Attributes$cy(
										$elm$core$String$fromFloat(pointSvg.y))
									]),
								_List_Nil)
							]));
				})
			]));
};
var $author$project$Examples$Frame$CustomElements$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Internal$Coordinates$center = function (pos) {
	return {x: pos.x1 + ((pos.x2 - pos.x1) / 2), y: pos.y1 + ((pos.y2 - pos.y1) / 2)};
};
var $author$project$Internal$Coordinates$pointToPosition = function (point) {
	return {x1: point.x, x2: point.x, y1: point.y, y2: point.y};
};
var $author$project$Chart$Attributes$center = function (config) {
	return _Utils_update(
		config,
		{
			focal: $elm$core$Maybe$Just(
				A2($elm$core$Basics$composeR, $author$project$Internal$Coordinates$center, $author$project$Internal$Coordinates$pointToPosition))
		});
};
var $author$project$Internal$Item$Custom = {$: 'Custom'};
var $author$project$Chart$CustomElement = F2(
	function (a, b) {
		return {$: 'CustomElement', a: a, b: b};
	});
var $author$project$Internal$Item$getGeneral = function (_v0) {
	var item = _v0.a;
	return A2(
		$author$project$Internal$Item$generalize,
		item.config.toAny,
		$author$project$Internal$Item$Rendered(item));
};
var $author$project$Chart$custom = function (config) {
	return $author$project$Chart$Indexed(
		function (elIndex) {
			var item = $author$project$Internal$Item$Rendered(
				{
					config: {
						product: _Utils_Tuple0,
						toAny: $elm$core$Basics$always($author$project$Internal$Item$Custom),
						tooltipInfo: {
							border: config.color,
							borderWidth: 0,
							color: config.color,
							data: 0,
							elIndex: elIndex,
							formatted: config.format(config.data),
							index: 0,
							name: $elm$core$Maybe$Just(config.name),
							property: 0,
							stack: 0
						},
						values: {datum: config.data, isReal: true, x1: config.position.x1, x2: config.position.x2, y: config.position.y2}
					},
					toHtml: function (c) {
						return _List_fromArray(
							[
								A3(
								$author$project$Internal$Produce$tooltipRow,
								c.tooltipInfo.color,
								A2($elm$core$Maybe$withDefault, 'Custom', c.tooltipInfo.name),
								c.tooltipInfo.formatted)
							]);
					},
					toLimits: function (_v0) {
						return config.position;
					},
					toPosition: F2(
						function (_v1, _v2) {
							return config.position;
						}),
					toSvg: F3(
						function (plane, _v3, position) {
							return config.render(plane);
						})
				});
			return _Utils_Tuple2(
				A2(
					$author$project$Chart$CustomElement,
					$author$project$Internal$Item$getGeneral(item),
					function (p) {
						return A2(
							$elm$svg$Svg$map,
							$elm$core$Basics$never,
							A2($author$project$Internal$Item$toSvg, p, item));
					}),
				elIndex + 1);
		});
};
var $author$project$Chart$ListOfElements = function (a) {
	return {$: 'ListOfElements', a: a};
};
var $author$project$Chart$list = $author$project$Chart$ListOfElements;
var $author$project$Chart$Attributes$offset = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{offset: v});
	});
var $author$project$Internal$Svg$TopOrBottom = {$: 'TopOrBottom'};
var $author$project$Chart$Attributes$onTopOrBottom = function (config) {
	return _Utils_update(
		config,
		{
			direction: $elm$core$Maybe$Just($author$project$Internal$Svg$TopOrBottom)
		});
};
var $author$project$Internal$Svg$defaultRect = {attrs: _List_Nil, border: 'rgba(210, 210, 210, 1)', borderWidth: 1, color: 'rgba(210, 210, 210, 0.5)', opacity: 1, x1: $elm$core$Maybe$Nothing, x2: $elm$core$Maybe$Nothing, y1: $elm$core$Maybe$Nothing, y2: $elm$core$Maybe$Nothing};
var $author$project$Internal$Svg$rect = F2(
	function (plane, config) {
		var _v0 = function () {
			var _v3 = _Utils_Tuple2(
				_Utils_Tuple2(config.x1, config.x2),
				_Utils_Tuple2(config.y1, config.y2));
			_v3$11:
			while (true) {
				if (_v3.a.a.$ === 'Just') {
					if (_v3.a.b.$ === 'Nothing') {
						if (_v3.b.a.$ === 'Nothing') {
							if (_v3.b.b.$ === 'Nothing') {
								var _v8 = _v3.a;
								var a = _v8.a.a;
								var _v9 = _v8.b;
								var _v10 = _v3.b;
								var _v11 = _v10.a;
								var _v12 = _v10.b;
								return _Utils_Tuple2(
									_Utils_Tuple2(a, a),
									_Utils_Tuple2(plane.y.min, plane.y.max));
							} else {
								break _v3$11;
							}
						} else {
							if (_v3.b.b.$ === 'Just') {
								var _v35 = _v3.a;
								var c = _v35.a.a;
								var _v36 = _v35.b;
								var _v37 = _v3.b;
								var a = _v37.a.a;
								var b = _v37.b.a;
								return _Utils_Tuple2(
									_Utils_Tuple2(c, c),
									_Utils_Tuple2(a, b));
							} else {
								break _v3$11;
							}
						}
					} else {
						if (_v3.b.a.$ === 'Nothing') {
							if (_v3.b.b.$ === 'Nothing') {
								var _v4 = _v3.a;
								var a = _v4.a.a;
								var b = _v4.b.a;
								var _v5 = _v3.b;
								var _v6 = _v5.a;
								var _v7 = _v5.b;
								return _Utils_Tuple2(
									_Utils_Tuple2(a, b),
									_Utils_Tuple2(plane.y.min, plane.y.max));
							} else {
								var _v38 = _v3.a;
								var a = _v38.a.a;
								var b = _v38.b.a;
								var _v39 = _v3.b;
								var _v40 = _v39.a;
								var c = _v39.b.a;
								return _Utils_Tuple2(
									_Utils_Tuple2(a, b),
									_Utils_Tuple2(c, c));
							}
						} else {
							if (_v3.b.b.$ === 'Nothing') {
								var _v41 = _v3.a;
								var a = _v41.a.a;
								var b = _v41.b.a;
								var _v42 = _v3.b;
								var c = _v42.a.a;
								var _v43 = _v42.b;
								return _Utils_Tuple2(
									_Utils_Tuple2(a, b),
									_Utils_Tuple2(c, c));
							} else {
								break _v3$11;
							}
						}
					}
				} else {
					if (_v3.a.b.$ === 'Just') {
						if (_v3.b.a.$ === 'Nothing') {
							if (_v3.b.b.$ === 'Nothing') {
								var _v13 = _v3.a;
								var _v14 = _v13.a;
								var b = _v13.b.a;
								var _v15 = _v3.b;
								var _v16 = _v15.a;
								var _v17 = _v15.b;
								return _Utils_Tuple2(
									_Utils_Tuple2(b, b),
									_Utils_Tuple2(plane.y.min, plane.y.max));
							} else {
								break _v3$11;
							}
						} else {
							if (_v3.b.b.$ === 'Just') {
								var _v32 = _v3.a;
								var _v33 = _v32.a;
								var c = _v32.b.a;
								var _v34 = _v3.b;
								var a = _v34.a.a;
								var b = _v34.b.a;
								return _Utils_Tuple2(
									_Utils_Tuple2(c, c),
									_Utils_Tuple2(a, b));
							} else {
								break _v3$11;
							}
						}
					} else {
						if (_v3.b.a.$ === 'Just') {
							if (_v3.b.b.$ === 'Just') {
								var _v18 = _v3.a;
								var _v19 = _v18.a;
								var _v20 = _v18.b;
								var _v21 = _v3.b;
								var a = _v21.a.a;
								var b = _v21.b.a;
								return _Utils_Tuple2(
									_Utils_Tuple2(plane.x.min, plane.x.min),
									_Utils_Tuple2(a, b));
							} else {
								var _v22 = _v3.a;
								var _v23 = _v22.a;
								var _v24 = _v22.b;
								var _v25 = _v3.b;
								var a = _v25.a.a;
								var _v26 = _v25.b;
								return _Utils_Tuple2(
									_Utils_Tuple2(plane.x.min, plane.x.max),
									_Utils_Tuple2(a, a));
							}
						} else {
							if (_v3.b.b.$ === 'Just') {
								var _v27 = _v3.a;
								var _v28 = _v27.a;
								var _v29 = _v27.b;
								var _v30 = _v3.b;
								var _v31 = _v30.a;
								var b = _v30.b.a;
								return _Utils_Tuple2(
									_Utils_Tuple2(plane.x.min, plane.x.max),
									_Utils_Tuple2(b, b));
							} else {
								var _v44 = _v3.a;
								var _v45 = _v44.a;
								var _v46 = _v44.b;
								var _v47 = _v3.b;
								var _v48 = _v47.a;
								var _v49 = _v47.b;
								return _Utils_Tuple2(
									_Utils_Tuple2(plane.x.min, plane.x.max),
									_Utils_Tuple2(plane.y.min, plane.y.max));
							}
						}
					}
				}
			}
			return _Utils_Tuple2(
				_Utils_Tuple2(
					A2($elm$core$Maybe$withDefault, plane.x.min, config.x1),
					A2($elm$core$Maybe$withDefault, plane.x.max, config.x2)),
				_Utils_Tuple2(
					A2($elm$core$Maybe$withDefault, plane.y.min, config.y1),
					A2($elm$core$Maybe$withDefault, plane.y.max, config.y2)));
		}();
		var _v1 = _v0.a;
		var x1_ = _v1.a;
		var x2_ = _v1.b;
		var _v2 = _v0.b;
		var y1_ = _v2.a;
		var y2_ = _v2.b;
		var cmds = _List_fromArray(
			[
				A2($author$project$Internal$Commands$Move, x1_, y1_),
				A2($author$project$Internal$Commands$Line, x1_, y1_),
				A2($author$project$Internal$Commands$Line, x2_, y1_),
				A2($author$project$Internal$Commands$Line, x2_, y2_),
				A2($author$project$Internal$Commands$Line, x1_, y2_),
				A2($author$project$Internal$Commands$Line, x1_, y1_)
			]);
		return A4(
			$author$project$Internal$Svg$withAttrs,
			config.attrs,
			$elm$svg$Svg$path,
			_List_fromArray(
				[
					$elm$svg$Svg$Attributes$class('elm-charts__rect'),
					$elm$svg$Svg$Attributes$fill(config.color),
					$elm$svg$Svg$Attributes$fillOpacity(
					$elm$core$String$fromFloat(config.opacity)),
					$elm$svg$Svg$Attributes$stroke(config.border),
					$elm$svg$Svg$Attributes$strokeWidth(
					$elm$core$String$fromFloat(config.borderWidth)),
					$elm$svg$Svg$Attributes$d(
					A2($author$project$Internal$Commands$description, plane, cmds))
				]),
			_List_Nil);
	});
var $author$project$Chart$Svg$rect = F2(
	function (plane, edits) {
		return A2(
			$author$project$Internal$Svg$rect,
			plane,
			A2($author$project$Internal$Helpers$apply, edits, $author$project$Internal$Svg$defaultRect));
	});
var $author$project$Examples$Frame$CustomElements$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Frame$CustomElements$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$any)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Frame$CustomElements$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xTicks(_List_Nil),
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yTicks(_List_Nil),
				$author$project$Chart$yLabels(_List_Nil),
				$author$project$Chart$list(
				function () {
					var heatmapItem = F2(
						function (index, value) {
							var y = ((index / 5) | 0) * 2;
							var x = (index % 5) * 2;
							var color = (value > 8) ? '#0E4D64' : ((value > 6) ? '#137177' : ((value > 4) ? '#188977' : ((value > 2) ? '#1D9A6C' : ((value > 0) ? '#74C67A' : ((!value) ? '#99D492' : '#0A2F51')))));
							return $author$project$Chart$custom(
								{
									color: color,
									data: {x: index, y: value},
									format: A2(
										$elm$core$Basics$composeR,
										function ($) {
											return $.y;
										},
										A2(
											$elm$core$Basics$composeR,
											$elm$core$String$fromFloat,
											function (v) {
												return v + ' C°';
											})),
									name: 'Temperature',
									position: {x1: x, x2: x + 2, y1: y, y2: y + 2},
									render: function (p) {
										return A2(
											$author$project$Chart$Svg$rect,
											p,
											_List_fromArray(
												[
													$author$project$Chart$Attributes$x1(x),
													$author$project$Chart$Attributes$x2(x + 2),
													$author$project$Chart$Attributes$y1(y),
													$author$project$Chart$Attributes$y2(y + 2),
													$author$project$Chart$Attributes$color(color),
													$author$project$Chart$Attributes$border('white')
												]));
									}
								});
						});
					return A2(
						$elm$core$List$indexedMap,
						heatmapItem,
						_List_fromArray(
							[2, 5, 8, 5, 3, 5, 7, 9, 0, 3, 2, 4, 6, 3, 5, 7, 9, 0, 3, 2, 4, 6, 7, 8, 10]));
				}()),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (_v0, item) {
						return _List_fromArray(
							[
								A4(
								$author$project$Chart$tooltip,
								item,
								_List_fromArray(
									[
										$author$project$Chart$Attributes$center,
										$author$project$Chart$Attributes$offset(0),
										$author$project$Chart$Attributes$onTopOrBottom
									]),
								_List_Nil,
								_List_Nil)
							]);
					}))
			]));
};
var $author$project$Chart$Attributes$format = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{
				format: $elm$core$Maybe$Just(v)
			});
	});
var $author$project$Examples$Frame$CustomFormat$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$xLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$format(
						function (x) {
							return $elm$core$String$fromFloat(x) + ' C°';
						}),
						$author$project$Chart$Attributes$withGrid
					]))
			]));
};
var $author$project$Chart$Attributes$fontSize = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{
				fontSize: $elm$core$Maybe$Just(v)
			});
	});
var $author$project$Chart$generate = F5(
	function (num, gen, limit, attrs, func) {
		return $author$project$Chart$SubElements(
			F2(
				function (p, _v0) {
					var items = A3(
						$author$project$Chart$Svg$generate,
						num,
						gen,
						A3(
							$elm$core$List$foldl,
							F2(
								function (f, x) {
									return f(x);
								}),
							limit(p),
							attrs));
					return A2(
						$elm$core$List$concatMap,
						func(p),
						items);
				}));
	});
var $author$project$Chart$Attributes$x = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{x: v});
	});
var $author$project$Chart$LabelElement = F3(
	function (a, b, c) {
		return {$: 'LabelElement', a: a, b: b, c: c};
	});
var $author$project$Chart$xLabel = F2(
	function (edits, inner) {
		var toTickValues = F3(
			function (p, config, ts) {
				return (!config.grid) ? ts : _Utils_update(
					ts,
					{
						xs: _Utils_ap(
							ts.xs,
							_List_fromArray(
								[config.x]))
					});
			});
		var toConfig = function (p) {
			return A2(
				$author$project$Internal$Helpers$apply,
				edits,
				{
					anchor: $elm$core$Maybe$Nothing,
					attrs: _List_Nil,
					border: 'white',
					borderWidth: 0.1,
					color: '#808BAB',
					ellipsis: $elm$core$Maybe$Nothing,
					flip: false,
					fontSize: $elm$core$Maybe$Nothing,
					grid: false,
					rotate: 0,
					uppercase: false,
					x: $author$project$Chart$Attributes$middle(p.x),
					xOff: 0,
					y: $author$project$Chart$Attributes$zero(p.y),
					yOff: 20
				});
		};
		return A3(
			$author$project$Chart$LabelElement,
			toConfig,
			toTickValues,
			F2(
				function (p, config) {
					var string = _Utils_eq(inner, _List_Nil) ? _List_fromArray(
						[
							$elm$svg$Svg$text(
							$elm$core$String$fromFloat(config.x))
						]) : inner;
					return A4(
						$author$project$Internal$Svg$label,
						p,
						{
							anchor: config.anchor,
							attrs: config.attrs,
							border: config.border,
							borderWidth: config.borderWidth,
							color: config.color,
							ellipsis: config.ellipsis,
							fontSize: config.fontSize,
							rotate: config.rotate,
							uppercase: config.uppercase,
							xOff: config.xOff,
							yOff: config.flip ? ((-config.yOff) + 10) : config.yOff
						},
						string,
						{x: config.x, y: config.y});
				}));
	});
var $author$project$Chart$Attributes$y = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{y: v});
	});
var $author$project$Examples$Frame$CustomLabels$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(_List_Nil),
				A5(
				$author$project$Chart$generate,
				12,
				$author$project$Chart$Svg$ints,
				function ($) {
					return $.x;
				},
				_List_Nil,
				F2(
					function (p, num) {
						var isEven = !(num % 2);
						return _List_fromArray(
							[
								A2(
								$author$project$Chart$xLabel,
								_List_fromArray(
									[
										$author$project$Chart$Attributes$x(num),
										$author$project$Chart$Attributes$withGrid,
										isEven ? $elm$core$Basics$identity : $author$project$Chart$Attributes$y(p.y.max),
										isEven ? $elm$core$Basics$identity : $author$project$Chart$Attributes$moveUp(28),
										isEven ? $elm$core$Basics$identity : $author$project$Chart$Attributes$fontSize(10),
										isEven ? $elm$core$Basics$identity : $author$project$Chart$Attributes$color($author$project$Chart$Attributes$blue)
									]),
								_List_fromArray(
									[
										$elm$svg$Svg$text(
										$elm$core$String$fromInt(num) + '°')
									]))
							]);
					}))
			]));
};
var $author$project$Examples$Frame$Dimensions$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				$author$project$Chart$Attributes$range(
				_List_fromArray(
					[
						A2($author$project$Chart$Attributes$lowest, 5, $author$project$Chart$Attributes$orLower),
						A2($author$project$Chart$Attributes$highest, 90, $author$project$Chart$Attributes$orHigher)
					])),
				$author$project$Chart$Attributes$domain(
				_List_fromArray(
					[
						A2($author$project$Chart$Attributes$lowest, 5, $author$project$Chart$Attributes$orLower),
						A2($author$project$Chart$Attributes$highest, 100, $author$project$Chart$Attributes$orHigher)
					]))
			]),
		_List_fromArray(
			[
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						A3(
						$author$project$Chart$interpolated,
						function ($) {
							return $.y;
						},
						_List_Nil,
						_List_Nil)
					]),
				_List_fromArray(
					[
						{x: 10, y: 20},
						{x: 80, y: 80}
					])),
				$author$project$Chart$xLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$amount(10),
						$author$project$Chart$Attributes$withGrid
					])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$amount(10),
						$author$project$Chart$Attributes$withGrid
					]))
			]));
};
var $author$project$Chart$Attributes$dotGrid = function (config) {
	return _Utils_update(
		config,
		{dotGrid: true});
};
var $author$project$Examples$Frame$DotGrid$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$grid(
				_List_fromArray(
					[$author$project$Chart$Attributes$dotGrid])),
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$xTicks(_List_Nil),
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yAxis(_List_Nil),
				$author$project$Chart$yTicks(_List_Nil),
				$author$project$Chart$yLabels(_List_Nil)
			]));
};
var $author$project$Chart$Attributes$ellipsis = F3(
	function (w, h, config) {
		return _Utils_update(
			config,
			{
				ellipsis: $elm$core$Maybe$Just(
					{height: h, width: w})
			});
	});
var $author$project$Examples$Frame$Ellipsis$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				$author$project$Chart$Attributes$margin(
				{bottom: 30, left: 45, right: 15, top: 10})
			]),
		_List_fromArray(
			[
				$author$project$Chart$yAxis(
				_List_fromArray(
					[$author$project$Chart$Attributes$noArrow])),
				$author$project$Chart$yTicks(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$format(
						function (y) {
							return $elm$core$String$fromFloat(y) + ' yyyyyyy';
						}),
						A2($author$project$Chart$Attributes$ellipsis, 35, 20)
					])),
				$author$project$Chart$xAxis(
				_List_fromArray(
					[$author$project$Chart$Attributes$noArrow])),
				$author$project$Chart$xTicks(_List_Nil),
				$author$project$Chart$xLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$format(
						function (x) {
							return $elm$core$String$fromFloat(x) + ' xxxxxxx';
						}),
						A2($author$project$Chart$Attributes$ellipsis, 35, 20)
					]))
			]));
};
var $author$project$Examples$Frame$GridColor$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$grid(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$color($author$project$Chart$Attributes$blue)
					])),
				$author$project$Chart$xLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid]))
			]));
};
var $author$project$Chart$Attributes$noGrid = function (config) {
	return _Utils_update(
		config,
		{grid: false});
};
var $author$project$Examples$Frame$GridFilter$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$xTicks(
				_List_fromArray(
					[$author$project$Chart$Attributes$noGrid])),
				$author$project$Chart$yLabels(_List_Nil),
				$author$project$Chart$yTicks(
				_List_fromArray(
					[$author$project$Chart$Attributes$noGrid]))
			]));
};
var $author$project$Chart$Attributes$alignLeft = function (config) {
	return _Utils_update(
		config,
		{
			anchor: $elm$core$Maybe$Just($author$project$Internal$Svg$Start)
		});
};
var $author$project$Examples$Frame$LabelWithLine$Datum = F2(
	function (age, toys) {
		return {age: age, toys: toys};
	});
var $author$project$Examples$Frame$LabelWithLine$data = _List_fromArray(
	[
		A2($author$project$Examples$Frame$LabelWithLine$Datum, 5, 6)
	]);
var $author$project$Chart$Attributes$exactly = F3(
	function (exact, _v0, _v1) {
		return exact;
	});
var $author$project$Chart$scatter = function (y) {
	return A2(
		$author$project$Internal$Property$property,
		A2($elm$core$Basics$composeR, y, $elm$core$Maybe$Just),
		_List_Nil);
};
var $author$project$Examples$Frame$LabelWithLine$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				$author$project$Chart$Attributes$padding(
				{bottom: 0, left: 10, right: 10, top: 25}),
				$author$project$Chart$Attributes$range(
				_List_fromArray(
					[
						A2($author$project$Chart$Attributes$lowest, 0, $author$project$Chart$Attributes$exactly),
						A2($author$project$Chart$Attributes$highest, 10, $author$project$Chart$Attributes$exactly)
					])),
				$author$project$Chart$Attributes$domain(
				_List_fromArray(
					[
						A2($author$project$Chart$Attributes$lowest, 0, $author$project$Chart$Attributes$exactly),
						A2($author$project$Chart$Attributes$highest, 10, $author$project$Chart$Attributes$exactly)
					]))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$xTicks(_List_Nil),
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yAxis(_List_Nil),
				$author$project$Chart$yTicks(_List_Nil),
				$author$project$Chart$yLabels(_List_Nil),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.age;
				},
				_List_fromArray(
					[
						A2(
						$author$project$Chart$scatter,
						function ($) {
							return $.toys;
						},
						_List_Nil)
					]),
				$author$project$Examples$Frame$LabelWithLine$data),
				A3(
				$author$project$Chart$label,
				_List_fromArray(
					[
						$author$project$Chart$Attributes$moveRight(14),
						$author$project$Chart$Attributes$moveUp(8),
						$author$project$Chart$Attributes$alignLeft
					]),
				_List_fromArray(
					[
						$elm$svg$Svg$text('The dot in question')
					]),
				{x: 5, y: 6}),
				$author$project$Chart$line(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$break,
						$author$project$Chart$Attributes$x1(5),
						$author$project$Chart$Attributes$y1(6),
						$author$project$Chart$Attributes$x2Svg(10),
						$author$project$Chart$Attributes$y2Svg(13),
						$author$project$Chart$Attributes$color($author$project$Chart$Attributes$purple)
					]))
			]));
};
var $author$project$Internal$Svg$Cross = {$: 'Cross'};
var $author$project$Chart$Attributes$cross = function (config) {
	return _Utils_update(
		config,
		{
			shape: $elm$core$Maybe$Just($author$project$Internal$Svg$Cross)
		});
};
var $author$project$Examples$Frame$Legends$Datum = F7(
	function (x, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, y: y, z: z};
	});
var $author$project$Examples$Frame$Legends$data = _List_fromArray(
	[
		A7($author$project$Examples$Frame$Legends$Datum, 1, 2, 1, 4.6, 6.9, 7.3, 8.0),
		A7($author$project$Examples$Frame$Legends$Datum, 2, 3, 2, 5.2, 6.2, 7.0, 8.7),
		A7($author$project$Examples$Frame$Legends$Datum, 3, 3, 4, 5.3, 5.7, 6.2, 7.8),
		A7($author$project$Examples$Frame$Legends$Datum, 4, 4, 1, 4.8, 5.4, 7.2, 8.3),
		A7($author$project$Examples$Frame$Legends$Datum, 5, 6, 3, 5.4, 3.9, 7.6, 8.5),
		A7($author$project$Examples$Frame$Legends$Datum, 6, 4, 3, 4.5, 5.3, 6.3, 7.0)
	]);
var $author$project$Chart$Attributes$pinned = F2(
	function (value, config) {
		return _Utils_update(
			config,
			{pinned: value});
	});
var $author$project$Chart$Attributes$row = function (config) {
	return _Utils_update(
		config,
		{alignment: $author$project$Internal$Svg$Row});
};
var $author$project$Examples$Frame$Legends$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				$author$project$Chart$Attributes$margin(
				{bottom: 0, left: 0, right: 0, top: 30})
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$withGrid,
						$author$project$Chart$Attributes$pinned(
						function ($) {
							return $.min;
						})
					])),
				$author$project$Chart$xLabels(_List_Nil),
				A3(
				$author$project$Chart$bars,
				_List_fromArray(
					[
						$author$project$Chart$Attributes$roundTop(0.3)
					]),
				_List_fromArray(
					[
						A2(
						$author$project$Chart$named,
						'B1',
						A2(
							$author$project$Chart$bar,
							function ($) {
								return $.z;
							},
							_List_Nil)),
						A2(
						$author$project$Chart$named,
						'B2',
						A2(
							$author$project$Chart$bar,
							function ($) {
								return $.y;
							},
							_List_fromArray(
								[
									$author$project$Chart$Attributes$striped(_List_Nil)
								])))
					]),
				$author$project$Examples$Frame$Legends$data),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						A2(
						$author$project$Chart$named,
						'A1',
						A3(
							$author$project$Chart$interpolated,
							function ($) {
								return $.p;
							},
							_List_Nil,
							_List_fromArray(
								[
									$author$project$Chart$Attributes$cross,
									$author$project$Chart$Attributes$borderWidth(2),
									$author$project$Chart$Attributes$border('white')
								]))),
						A2(
						$author$project$Chart$named,
						'A2',
						A3(
							$author$project$Chart$interpolated,
							function ($) {
								return $.q;
							},
							_List_Nil,
							_List_fromArray(
								[
									$author$project$Chart$Attributes$cross,
									$author$project$Chart$Attributes$borderWidth(2),
									$author$project$Chart$Attributes$border('white')
								])))
					]),
				$author$project$Examples$Frame$Legends$data),
				A4(
				$author$project$Chart$legendsAt,
				function ($) {
					return $.min;
				},
				function ($) {
					return $.max;
				},
				_List_fromArray(
					[
						$author$project$Chart$Attributes$row,
						$author$project$Chart$Attributes$moveRight(10),
						$author$project$Chart$Attributes$moveUp(25),
						$author$project$Chart$Attributes$spacing(15)
					]),
				_List_fromArray(
					[
						$author$project$Chart$Attributes$width(20)
					]))
			]));
};
var $author$project$Chart$withPlane = function (func) {
	return $author$project$Chart$SubElements(
		F2(
			function (p, is) {
				return func(p);
			}));
};
var $author$project$Examples$Frame$Lines$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$xTicks(_List_Nil),
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yAxis(_List_Nil),
				$author$project$Chart$yTicks(_List_Nil),
				$author$project$Chart$yLabels(_List_Nil),
				$author$project$Chart$withPlane(
				function (p) {
					return _List_fromArray(
						[
							$author$project$Chart$line(
							_List_fromArray(
								[
									$author$project$Chart$Attributes$x1(p.x.min),
									$author$project$Chart$Attributes$y1(5),
									$author$project$Chart$Attributes$x2(p.x.max),
									$author$project$Chart$Attributes$dashed(
									_List_fromArray(
										[5, 5])),
									$author$project$Chart$Attributes$color($author$project$Chart$Attributes$red)
								])),
							$author$project$Chart$line(
							_List_fromArray(
								[
									$author$project$Chart$Attributes$x1(3),
									$author$project$Chart$Attributes$y1(p.y.min),
									$author$project$Chart$Attributes$y2(p.y.max),
									$author$project$Chart$Attributes$dashed(
									_List_fromArray(
										[5, 5])),
									$author$project$Chart$Attributes$color($author$project$Chart$Attributes$blue)
								]))
						]);
				})
			]));
};
var $author$project$Examples$Frame$Margin$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				$author$project$Chart$Attributes$margin(
				{bottom: 30, left: 30, right: 20, top: 20}),
				$author$project$Chart$Attributes$htmlAttrs(
				_List_fromArray(
					[
						A2($elm$html$Html$Attributes$style, 'border', '1px solid darkgray')
					]))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$yAxis(_List_Nil),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						A3(
						$author$project$Chart$interpolated,
						function ($) {
							return $.y;
						},
						_List_Nil,
						_List_Nil)
					]),
				_List_fromArray(
					[
						{x: 0, y: 0},
						{x: 10, y: 10}
					])),
				$author$project$Chart$xLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid]))
			]));
};
var $author$project$Examples$Frame$NoArrow$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(
				_List_fromArray(
					[$author$project$Chart$Attributes$noArrow])),
				$author$project$Chart$xTicks(_List_Nil),
				$author$project$Chart$xLabels(_List_Nil)
			]));
};
var $author$project$Examples$Frame$Offset$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$moveRight(5),
						$author$project$Chart$Attributes$moveUp(20),
						$author$project$Chart$Attributes$alignLeft,
						$author$project$Chart$Attributes$withGrid
					]))
			]));
};
var $author$project$Internal$Svg$Ints = {$: 'Ints'};
var $author$project$Chart$Attributes$ints = function (config) {
	return _Utils_update(
		config,
		{generate: $author$project$Internal$Svg$Ints});
};
var $author$project$Examples$Frame$OnlyInts$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				$author$project$Chart$Attributes$range(
				_List_fromArray(
					[
						A2($author$project$Chart$Attributes$highest, 3, $author$project$Chart$Attributes$exactly),
						A2($author$project$Chart$Attributes$lowest, 0, $author$project$Chart$Attributes$exactly)
					]))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$xTicks(
				_List_fromArray(
					[$author$project$Chart$Attributes$ints])),
				$author$project$Chart$xLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$ints]))
			]));
};
var $author$project$Examples$Frame$Padding$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				$author$project$Chart$Attributes$padding(
				{bottom: 20, left: 20, right: 20, top: 20})
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$yAxis(_List_Nil),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						A3(
						$author$project$Chart$interpolated,
						function ($) {
							return $.y;
						},
						_List_Nil,
						_List_Nil)
					]),
				_List_fromArray(
					[
						{x: 0, y: 0},
						{x: 10, y: 10}
					])),
				$author$project$Chart$xLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$pinned(
						function ($) {
							return $.min;
						}),
						$author$project$Chart$Attributes$withGrid
					])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$pinned(
						function ($) {
							return $.min;
						}),
						$author$project$Chart$Attributes$withGrid
					]))
			]));
};
var $author$project$Examples$Frame$Position$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$yAxis(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$pinned(
						function ($) {
							return $.max;
						})
					])),
				$author$project$Chart$yTicks(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$pinned(
						function ($) {
							return $.max;
						}),
						$author$project$Chart$Attributes$flip
					])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$pinned(
						function ($) {
							return $.max;
						}),
						$author$project$Chart$Attributes$flip
					]))
			]));
};
var $author$project$Chart$rect = function (attrs) {
	return $author$project$Chart$SvgElement(
		function (p) {
			return A2($author$project$Chart$Svg$rect, p, attrs);
		});
};
var $author$project$Examples$Frame$Rect$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$xTicks(_List_Nil),
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yAxis(_List_Nil),
				$author$project$Chart$yTicks(_List_Nil),
				$author$project$Chart$yLabels(_List_Nil),
				$author$project$Chart$withPlane(
				function (p) {
					return _List_fromArray(
						[
							$author$project$Chart$rect(
							_List_fromArray(
								[
									$author$project$Chart$Attributes$x1(3),
									$author$project$Chart$Attributes$y1(3),
									$author$project$Chart$Attributes$x2(7),
									$author$project$Chart$Attributes$y2(9),
									$author$project$Chart$Attributes$color('rgb(210, 210, 210)'),
									$author$project$Chart$Attributes$opacity(0.3)
								]))
						]);
				})
			]));
};
var $author$project$Examples$Frame$Times$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				$author$project$Chart$Attributes$padding(
				{bottom: 0, left: 0, right: 25, top: 10}),
				$author$project$Chart$Attributes$range(
				_List_fromArray(
					[
						A2($author$project$Chart$Attributes$lowest, 1591974241000, $author$project$Chart$Attributes$exactly),
						A2($author$project$Chart$Attributes$highest, 1623510241000, $author$project$Chart$Attributes$exactly)
					]))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$xTicks(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$times($elm$time$Time$utc)
					])),
				$author$project$Chart$xLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$times($elm$time$Time$utc)
					]))
			]));
};
var $author$project$Examples$Frame$Titles$Datum = F2(
	function (age, toys) {
		return {age: age, toys: toys};
	});
var $author$project$Examples$Frame$Titles$data = _List_fromArray(
	[
		A2($author$project$Examples$Frame$Titles$Datum, 0.5, 4),
		A2($author$project$Examples$Frame$Titles$Datum, 0.8, 5),
		A2($author$project$Examples$Frame$Titles$Datum, 1.2, 6),
		A2($author$project$Examples$Frame$Titles$Datum, 1.4, 6),
		A2($author$project$Examples$Frame$Titles$Datum, 1.6, 4),
		A2($author$project$Examples$Frame$Titles$Datum, 3, 8),
		A2($author$project$Examples$Frame$Titles$Datum, 3, 9),
		A2($author$project$Examples$Frame$Titles$Datum, 3.2, 10),
		A2($author$project$Examples$Frame$Titles$Datum, 3.8, 7),
		A2($author$project$Examples$Frame$Titles$Datum, 6, 12),
		A2($author$project$Examples$Frame$Titles$Datum, 6.2, 8),
		A2($author$project$Examples$Frame$Titles$Datum, 6, 10),
		A2($author$project$Examples$Frame$Titles$Datum, 6, 9),
		A2($author$project$Examples$Frame$Titles$Datum, 9.1, 8),
		A2($author$project$Examples$Frame$Titles$Datum, 9.2, 13),
		A2($author$project$Examples$Frame$Titles$Datum, 9.8, 10),
		A2($author$project$Examples$Frame$Titles$Datum, 12, 7),
		A2($author$project$Examples$Frame$Titles$Datum, 12.5, 5),
		A2($author$project$Examples$Frame$Titles$Datum, 12.5, 2)
	]);
var $author$project$Examples$Frame$Titles$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				$author$project$Chart$Attributes$padding(
				{bottom: 0, left: 0, right: 10, top: 25}),
				$author$project$Chart$Attributes$range(
				_List_fromArray(
					[
						A2($author$project$Chart$Attributes$lowest, 0, $author$project$Chart$Attributes$exactly)
					]))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$xTicks(
				_List_fromArray(
					[$author$project$Chart$Attributes$ints])),
				$author$project$Chart$xLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$ints])),
				$author$project$Chart$yAxis(_List_Nil),
				$author$project$Chart$yTicks(
				_List_fromArray(
					[$author$project$Chart$Attributes$ints])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$ints])),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.age;
				},
				_List_fromArray(
					[
						A2(
						$author$project$Chart$scatter,
						function ($) {
							return $.toys;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$opacity(0),
								$author$project$Chart$Attributes$borderWidth(1)
							]))
					]),
				$author$project$Examples$Frame$Titles$data),
				A4(
				$author$project$Chart$labelAt,
				function ($) {
					return $.min;
				},
				$author$project$Chart$Attributes$middle,
				_List_fromArray(
					[
						$author$project$Chart$Attributes$moveLeft(35),
						$author$project$Chart$Attributes$rotate(90)
					]),
				_List_fromArray(
					[
						$elm$svg$Svg$text('Fruits')
					])),
				A4(
				$author$project$Chart$labelAt,
				$author$project$Chart$Attributes$middle,
				function ($) {
					return $.min;
				},
				_List_fromArray(
					[
						$author$project$Chart$Attributes$moveDown(30)
					]),
				_List_fromArray(
					[
						$elm$svg$Svg$text('Age')
					])),
				A4(
				$author$project$Chart$labelAt,
				$author$project$Chart$Attributes$middle,
				function ($) {
					return $.max;
				},
				_List_fromArray(
					[
						$author$project$Chart$Attributes$fontSize(14)
					]),
				_List_fromArray(
					[
						$elm$svg$Svg$text('How many fruits do children eat? (2021)')
					])),
				A4(
				$author$project$Chart$labelAt,
				$author$project$Chart$Attributes$middle,
				function ($) {
					return $.max;
				},
				_List_fromArray(
					[
						$author$project$Chart$Attributes$moveDown(15)
					]),
				_List_fromArray(
					[
						$elm$svg$Svg$text('Data from fruits.com')
					]))
			]));
};
var $author$project$Examples$Frontpage$BasicArea$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						$author$project$Chart$stacked(
						_List_fromArray(
							[
								A3(
								$author$project$Chart$interpolated,
								function ($) {
									return $.y;
								},
								_List_fromArray(
									[
										$author$project$Chart$Attributes$opacity(0.2)
									]),
								_List_Nil),
								A3(
								$author$project$Chart$interpolated,
								function ($) {
									return $.z;
								},
								_List_fromArray(
									[
										$author$project$Chart$Attributes$opacity(1),
										$author$project$Chart$Attributes$dotted(_List_Nil)
									]),
								_List_Nil)
							]))
					]),
				_List_fromArray(
					[
						{x: 1, y: 1, z: 3},
						{x: 5, y: 2, z: 1},
						{x: 10, y: 2, z: 4}
					]))
			]));
};
var $author$project$Examples$Frontpage$BasicBar$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid, $author$project$Chart$Attributes$ints])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_fromArray(
					[
						$author$project$Chart$Attributes$x1(
						function ($) {
							return $.x;
						})
					]),
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$striped(_List_Nil)
							])),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_Nil)
					]),
				_List_fromArray(
					[
						{x: 1, y: 3, z: 1},
						{x: 2, y: 2, z: 3},
						{x: 3, y: 4, z: 2}
					]))
			]));
};
var $author$project$Examples$Frontpage$BasicBubble$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				$author$project$Chart$Attributes$padding(
				{bottom: 5, left: 40, right: 40, top: 30})
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						A2(
						$author$project$Chart$variation,
						F2(
							function (_v0, data) {
								return _List_fromArray(
									[
										$author$project$Chart$Attributes$size(data.size)
									]);
							}),
						A2(
							$author$project$Chart$scatter,
							function ($) {
								return $.y;
							},
							_List_fromArray(
								[
									$author$project$Chart$Attributes$opacity(0.3),
									$author$project$Chart$Attributes$borderWidth(1)
								]))),
						A2(
						$author$project$Chart$variation,
						F2(
							function (_v1, data) {
								return _List_fromArray(
									[
										$author$project$Chart$Attributes$size(data.size)
									]);
							}),
						A2(
							$author$project$Chart$scatter,
							function ($) {
								return $.z;
							},
							_List_fromArray(
								[
									$author$project$Chart$Attributes$opacity(0.3),
									$author$project$Chart$Attributes$borderWidth(1)
								])))
					]),
				_List_fromArray(
					[
						{size: 450, x: 1, y: 2, z: 3},
						{size: 350, x: 2, y: 3, z: 5},
						{size: 150, x: 3, y: 4, z: 2},
						{size: 550, x: 4, y: 1, z: 3},
						{size: 450, x: 5, y: 4, z: 1}
					]))
			]));
};
var $author$project$Internal$Svg$Monotone = {$: 'Monotone'};
var $author$project$Chart$Attributes$monotone = function (config) {
	return _Utils_update(
		config,
		{
			method: $elm$core$Maybe$Just($author$project$Internal$Svg$Monotone)
		});
};
var $author$project$Internal$Svg$Square = {$: 'Square'};
var $author$project$Chart$Attributes$square = function (config) {
	return _Utils_update(
		config,
		{
			shape: $elm$core$Maybe$Just($author$project$Internal$Svg$Square)
		});
};
var $author$project$Examples$Frontpage$BasicLine$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				$author$project$Chart$Attributes$padding(
				{bottom: 5, left: 10, right: 10, top: 10})
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						A3(
						$author$project$Chart$interpolated,
						function ($) {
							return $.y;
						},
						_List_fromArray(
							[$author$project$Chart$Attributes$monotone]),
						_List_fromArray(
							[$author$project$Chart$Attributes$circle])),
						A3(
						$author$project$Chart$interpolated,
						function ($) {
							return $.z;
						},
						_List_fromArray(
							[$author$project$Chart$Attributes$monotone]),
						_List_fromArray(
							[$author$project$Chart$Attributes$square]))
					]),
				_List_fromArray(
					[
						{x: 1, y: 2, z: 3},
						{x: 5, y: 4, z: 1},
						{x: 10, y: 2, z: 4}
					]))
			]));
};
var $author$project$Examples$Frontpage$BasicNavigation$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300)
			]),
		_List_fromArray(
			[
				$author$project$Chart$xAxis(_List_Nil),
				$author$project$Chart$xTicks(_List_Nil),
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yAxis(_List_Nil),
				$author$project$Chart$yTicks(_List_Nil),
				$author$project$Chart$yLabels(_List_Nil)
			]));
};
var $author$project$Examples$Frontpage$BasicScatter$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				$author$project$Chart$Attributes$padding(
				{bottom: 5, left: 10, right: 10, top: 0})
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						A2(
						$author$project$Chart$scatter,
						function ($) {
							return $.y;
						},
						_List_fromArray(
							[$author$project$Chart$Attributes$circle])),
						A2(
						$author$project$Chart$scatter,
						function ($) {
							return $.z;
						},
						_List_fromArray(
							[$author$project$Chart$Attributes$square]))
					]),
				_List_fromArray(
					[
						{x: 1, y: 2, z: 3},
						{x: 2, y: 3, z: 5},
						{x: 3, y: 4, z: 2},
						{x: 4, y: 1, z: 3},
						{x: 5, y: 4, z: 1}
					]))
			]));
};
var $author$project$Examples$Frontpage$Concise$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Frontpage$Concise$blue1 = '#0f9ff0D0';
var $author$project$Examples$Frontpage$Concise$blue2 = '#0f9ff090';
var $author$project$Examples$Frontpage$Concise$Datum = F4(
	function (cats, dogs, people, country) {
		return {cats: cats, country: country, dogs: dogs, people: people};
	});
var $author$project$Examples$Frontpage$Concise$data = _List_fromArray(
	[
		A4($author$project$Examples$Frontpage$Concise$Datum, 2.4, 1.2, 5.3, 'Norway'),
		A4($author$project$Examples$Frontpage$Concise$Datum, 2.2, 2.4, 5.8, 'Denmark'),
		A4($author$project$Examples$Frontpage$Concise$Datum, 3.6, 2.2, 10.2, 'Sweden'),
		A4($author$project$Examples$Frontpage$Concise$Datum, 3.4, 1.2, 5.5, 'Finland')
	]);
var $author$project$Chart$Item$getCenter = function (p) {
	return A2(
		$elm$core$Basics$composeR,
		$author$project$Internal$Item$getPosition(p),
		$author$project$Internal$Coordinates$center);
};
var $author$project$Examples$Frontpage$Concise$mint1 = '#54c8ddD0';
var $author$project$Examples$Frontpage$Concise$mint2 = '#54c8dd90';
var $author$project$Chart$productLabel = F2(
	function (edits, item) {
		return $author$project$Chart$withPlane(
			function (p) {
				var config = A2(
					$author$project$Internal$Helpers$apply,
					edits,
					_Utils_update(
						$author$project$Chart$defaultLabel,
						{position: $author$project$Chart$Item$getTop}));
				var text = function () {
					var _v1 = config.format;
					if (_v1.$ === 'Just') {
						var formatting = _v1.a;
						return formatting(item);
					} else {
						return $elm$core$String$fromFloat(
							$author$project$Chart$Item$getY(item));
					}
				}();
				return _List_fromArray(
					[
						$author$project$Chart$svg(
						function (_v0) {
							return A4(
								$author$project$Internal$Svg$label,
								p,
								$author$project$Chart$toLabelFromItemLabel(config),
								_List_fromArray(
									[
										$elm$svg$Svg$text(text)
									]),
								A2(config.position, p, item));
						})
					]);
			});
	});
var $author$project$Examples$Frontpage$Concise$purple1 = '#653bf4B0';
var $author$project$Examples$Frontpage$Concise$purple2 = '#653bf470';
var $author$project$Examples$Frontpage$Concise$weakWhite = 'rgba(255, 255, 255, 0.7)';
var $author$project$Examples$Frontpage$Concise$white = 'white';
var $author$project$Examples$Frontpage$Concise$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(500),
				$author$project$Chart$Attributes$margin(
				{bottom: 25, left: 40, right: 0, top: 10}),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Frontpage$Concise$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$stacks)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Frontpage$Concise$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$yLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$withGrid,
						$author$project$Chart$Attributes$format(
						function (y) {
							return $elm$core$String$fromFloat(y) + 'M';
						})
					])),
				A3(
				$author$project$Chart$bars,
				_List_fromArray(
					[
						$author$project$Chart$Attributes$roundTop(0.2),
						$author$project$Chart$Attributes$roundBottom(0.2),
						$author$project$Chart$Attributes$margin(0.2),
						$author$project$Chart$Attributes$spacing(0.05),
						$author$project$Chart$Attributes$noGrid
					]),
				_List_fromArray(
					[
						$author$project$Chart$stacked(
						_List_fromArray(
							[
								A2(
								$author$project$Chart$named,
								'Cats',
								A2(
									$author$project$Chart$bar,
									function ($) {
										return $.cats;
									},
									_List_fromArray(
										[
											$author$project$Chart$Attributes$gradient(
											_List_fromArray(
												[$author$project$Examples$Frontpage$Concise$mint1, $author$project$Examples$Frontpage$Concise$mint2]))
										]))),
								A2(
								$author$project$Chart$named,
								'Dogs',
								A2(
									$author$project$Chart$bar,
									function ($) {
										return $.dogs;
									},
									_List_fromArray(
										[
											$author$project$Chart$Attributes$gradient(
											_List_fromArray(
												[$author$project$Examples$Frontpage$Concise$blue1, $author$project$Examples$Frontpage$Concise$blue2]))
										])))
							])),
						A2(
						$author$project$Chart$named,
						'People',
						A2(
							$author$project$Chart$bar,
							function ($) {
								return $.people;
							},
							_List_fromArray(
								[
									$author$project$Chart$Attributes$gradient(
									_List_fromArray(
										[$author$project$Examples$Frontpage$Concise$purple1, $author$project$Examples$Frontpage$Concise$purple2]))
								])))
					]),
				$author$project$Examples$Frontpage$Concise$data),
				A4(
				$author$project$Chart$labelAt,
				$author$project$Chart$Attributes$percent(30),
				function ($) {
					return $.max;
				},
				_List_fromArray(
					[
						$author$project$Chart$Attributes$moveDown(3),
						$author$project$Chart$Attributes$fontSize(15)
					]),
				_List_fromArray(
					[
						$elm$svg$Svg$text('Populations in Scandinavia')
					])),
				A4(
				$author$project$Chart$labelAt,
				$author$project$Chart$Attributes$percent(30),
				function ($) {
					return $.max;
				},
				_List_fromArray(
					[
						$author$project$Chart$Attributes$moveDown(20),
						$author$project$Chart$Attributes$fontSize(12)
					]),
				_List_fromArray(
					[
						$elm$svg$Svg$text('Note: Based on made up data.')
					])),
				A2(
				$author$project$Chart$binLabels,
				function ($) {
					return $.country;
				},
				_List_fromArray(
					[
						$author$project$Chart$Attributes$moveDown(18)
					])),
				$author$project$Chart$barLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$moveDown(18),
						$author$project$Chart$Attributes$color($author$project$Examples$Frontpage$Concise$weakWhite)
					])),
				A4(
				$author$project$Chart$legendsAt,
				function ($) {
					return $.max;
				},
				function ($) {
					return $.max;
				},
				_List_fromArray(
					[
						$author$project$Chart$Attributes$alignRight,
						$author$project$Chart$Attributes$column,
						$author$project$Chart$Attributes$spacing(7)
					]),
				_List_Nil),
				function () {
				var toBrightLabel = $author$project$Chart$productLabel(
					_List_fromArray(
						[
							$author$project$Chart$Attributes$moveDown(18),
							$author$project$Chart$Attributes$color($author$project$Examples$Frontpage$Concise$white)
						]));
				return A2(
					$author$project$Chart$each,
					model.hovering,
					F2(
						function (p, stack) {
							return A2(
								$elm$core$List$map,
								toBrightLabel,
								$author$project$Chart$Item$getMembers(stack));
						}));
			}(),
				$author$project$Chart$eachBin(
				F2(
					function (p, bin) {
						var yPos = A2($author$project$Chart$Item$getTop, p, bin).y;
						var xMid = A2($author$project$Chart$Item$getCenter, p, bin).x;
						var datum = $author$project$Chart$Item$getOneData(bin);
						var bar = $author$project$Chart$Item$getMember(bin);
						return (datum.country === 'Finland') ? _List_fromArray(
							[
								$author$project$Chart$line(
								_List_fromArray(
									[
										$author$project$Chart$Attributes$x1(
										$author$project$Chart$Item$getX1(bar)),
										$author$project$Chart$Attributes$x2(
										$author$project$Chart$Item$getX2(bar)),
										$author$project$Chart$Attributes$y1(yPos),
										$author$project$Chart$Attributes$moveUp(15),
										$author$project$Chart$Attributes$tickLength(5)
									])),
								A3(
								$author$project$Chart$label,
								_List_fromArray(
									[
										$author$project$Chart$Attributes$moveUp(22),
										$author$project$Chart$Attributes$fontSize(10)
									]),
								_List_fromArray(
									[
										$elm$svg$Svg$text('Most pets per person')
									]),
								{x: xMid, y: yPos})
							]) : _List_Nil;
					}))
			]));
};
var $author$project$Examples$Frontpage$Familiar$Datum = F3(
	function (x, y, z) {
		return {x: x, y: y, z: z};
	});
var $author$project$Examples$Frontpage$Familiar$data = function () {
	var toDatum = F3(
		function (e, t, y) {
			return A3($author$project$Examples$Frontpage$Familiar$Datum, t, y, y + e);
		});
	return _List_fromArray(
		[
			A3(toDatum, 5, 1622505600000, 3.2),
			A3(toDatum, 6, 1625097600000, 5.6),
			A3(toDatum, 5, 1627776000000, 4.2),
			A3(toDatum, 7, 1630454400000, 7.6),
			A3(toDatum, 6, 1633046400000, 3.2),
			A3(toDatum, 8, 1635724800000, 12.8),
			A3(toDatum, 7, 1638316800000, 6.3),
			A3(toDatum, 9, 1640995200000, 16.3),
			A3(toDatum, 12, 1643673600000, 7.8),
			A3(toDatum, 13, 1646092800000, 28.5)
		]);
}();
var $author$project$Examples$Frontpage$Familiar$viewChart = A2(
	$author$project$Chart$chart,
	_List_fromArray(
		[
			$author$project$Chart$Attributes$height(350),
			$author$project$Chart$Attributes$width(570),
			$author$project$Chart$Attributes$margin(
			{bottom: 30, left: 30, right: 10, top: 10})
		]),
	_List_fromArray(
		[
			$author$project$Chart$xLabels(
			_List_fromArray(
				[
					$author$project$Chart$Attributes$times($elm$time$Time$utc),
					$author$project$Chart$Attributes$amount(12)
				])),
			$author$project$Chart$yLabels(
			_List_fromArray(
				[
					$author$project$Chart$Attributes$withGrid,
					$author$project$Chart$Attributes$amount(6)
				])),
			$author$project$Chart$xAxis(_List_Nil),
			$author$project$Chart$yAxis(_List_Nil),
			A3(
			$author$project$Chart$series,
			function ($) {
				return $.x;
			},
			_List_fromArray(
				[
					A3(
					$author$project$Chart$interpolated,
					function ($) {
						return $.y;
					},
					_List_fromArray(
						[
							$author$project$Chart$Attributes$width(2)
						]),
					_List_Nil),
					A3(
					$author$project$Chart$interpolated,
					function ($) {
						return $.z;
					},
					_List_fromArray(
						[
							$author$project$Chart$Attributes$width(2)
						]),
					_List_Nil)
				]),
			$author$project$Examples$Frontpage$Familiar$data)
		]));
var $author$project$Examples$Frontpage$Familiar$view = function (model) {
	return $author$project$Examples$Frontpage$Familiar$viewChart;
};
var $author$project$Examples$Interactivity$Background$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Chart$Attributes$background = F2(
	function (v, config) {
		return _Utils_update(
			config,
			{background: v});
	});
var $author$project$Examples$Interactivity$Background$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$Interactivity$Background$data = _List_fromArray(
	[
		A8($author$project$Examples$Interactivity$Background$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$Interactivity$Background$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$Interactivity$Background$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$Interactivity$Background$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$Interactivity$Background$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$Background$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$bars)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$Background$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$opacity(0.3),
								$author$project$Chart$Attributes$borderWidth(1)
							])),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$opacity(0.3),
								$author$project$Chart$Attributes$borderWidth(1),
								$author$project$Chart$Attributes$striped(_List_Nil)
							]))
					]),
				$author$project$Examples$Interactivity$Background$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4(
								$author$project$Chart$tooltip,
								item,
								_List_fromArray(
									[
										$author$project$Chart$Attributes$background('#fcf9e9')
									]),
								_List_Nil,
								_List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$BasicArea$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Interactivity$BasicArea$Datum = F7(
	function (x, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, y: y, z: z};
	});
var $author$project$Examples$Interactivity$BasicArea$data = _List_fromArray(
	[
		A7($author$project$Examples$Interactivity$BasicArea$Datum, 1, 2, 1, 4.6, 6.9, 7.3, 8.0),
		A7($author$project$Examples$Interactivity$BasicArea$Datum, 2, 3, 2, 5.2, 6.2, 7.0, 8.7),
		A7($author$project$Examples$Interactivity$BasicArea$Datum, 3, 4, 3, 5.5, 5.2, 7.2, 8.1),
		A7($author$project$Examples$Interactivity$BasicArea$Datum, 4, 3, 4, 5.3, 5.7, 6.2, 7.8),
		A7($author$project$Examples$Interactivity$BasicArea$Datum, 5, 2, 3, 4.9, 5.9, 6.7, 8.2),
		A7($author$project$Examples$Interactivity$BasicArea$Datum, 6, 4, 1, 4.8, 5.4, 7.2, 8.3),
		A7($author$project$Examples$Interactivity$BasicArea$Datum, 7, 5, 2, 5.3, 5.1, 7.8, 7.1),
		A7($author$project$Examples$Interactivity$BasicArea$Datum, 8, 6, 3, 5.4, 3.9, 7.6, 8.5),
		A7($author$project$Examples$Interactivity$BasicArea$Datum, 9, 5, 4, 5.8, 4.6, 6.5, 6.9),
		A7($author$project$Examples$Interactivity$BasicArea$Datum, 10, 4, 3, 4.5, 5.3, 6.3, 7.0)
	]);
var $author$project$Examples$Interactivity$BasicArea$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$BasicArea$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$stacks)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$BasicArea$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						$author$project$Chart$stacked(
						_List_fromArray(
							[
								A3(
								$author$project$Chart$interpolated,
								function ($) {
									return $.y;
								},
								_List_fromArray(
									[
										$author$project$Chart$Attributes$monotone,
										$author$project$Chart$Attributes$opacity(0.2)
									]),
								_List_fromArray(
									[
										$author$project$Chart$Attributes$circle,
										$author$project$Chart$Attributes$color('white'),
										$author$project$Chart$Attributes$borderWidth(1)
									])),
								A3(
								$author$project$Chart$interpolated,
								function ($) {
									return $.z;
								},
								_List_fromArray(
									[
										$author$project$Chart$Attributes$monotone,
										$author$project$Chart$Attributes$opacity(0),
										$author$project$Chart$Attributes$color($author$project$Chart$Attributes$purple)
									]),
								_List_fromArray(
									[
										$author$project$Chart$Attributes$circle,
										$author$project$Chart$Attributes$color('white'),
										$author$project$Chart$Attributes$borderWidth(1)
									]))
							]))
					]),
				$author$project$Examples$Interactivity$BasicArea$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4($author$project$Chart$tooltip, item, _List_Nil, _List_Nil, _List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$BasicBar$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Interactivity$BasicBar$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$Interactivity$BasicBar$data = _List_fromArray(
	[
		A8($author$project$Examples$Interactivity$BasicBar$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$Interactivity$BasicBar$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$Interactivity$BasicBar$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$Interactivity$BasicBar$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$Interactivity$BasicBar$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$BasicBar$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$bars)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$BasicBar$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						$author$project$Chart$stacked(
						_List_fromArray(
							[
								A2(
								$author$project$Chart$bar,
								function ($) {
									return $.z;
								},
								_List_Nil),
								A2(
								$author$project$Chart$bar,
								function ($) {
									return $.y;
								},
								_List_Nil)
							])),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.v;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$dotted(_List_Nil)
							]))
					]),
				$author$project$Examples$Interactivity$BasicBar$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4($author$project$Chart$tooltip, item, _List_Nil, _List_Nil, _List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$BasicBin$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Interactivity$BasicBin$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$Interactivity$BasicBin$data = _List_fromArray(
	[
		A8($author$project$Examples$Interactivity$BasicBin$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$Interactivity$BasicBin$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$Interactivity$BasicBin$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$Interactivity$BasicBin$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$Interactivity$BasicBin$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$BasicBin$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$bins)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$BasicBin$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_Nil),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_Nil)
					]),
				$author$project$Examples$Interactivity$BasicBin$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4($author$project$Chart$tooltip, item, _List_Nil, _List_Nil, _List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$BasicLine$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Interactivity$BasicLine$Datum = F7(
	function (x, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, y: y, z: z};
	});
var $author$project$Examples$Interactivity$BasicLine$data = _List_fromArray(
	[
		A7($author$project$Examples$Interactivity$BasicLine$Datum, 1, 2, 1, 4.6, 6.9, 7.3, 8.0),
		A7($author$project$Examples$Interactivity$BasicLine$Datum, 2, 3, 2, 5.2, 6.2, 7.0, 8.7),
		A7($author$project$Examples$Interactivity$BasicLine$Datum, 3, 4, 3, 5.5, 5.2, 7.2, 8.1),
		A7($author$project$Examples$Interactivity$BasicLine$Datum, 4, 3, 4, 5.3, 5.7, 6.2, 7.8),
		A7($author$project$Examples$Interactivity$BasicLine$Datum, 5, 2, 3, 4.9, 5.9, 6.7, 8.2),
		A7($author$project$Examples$Interactivity$BasicLine$Datum, 6, 4, 1, 4.8, 5.4, 7.2, 8.3),
		A7($author$project$Examples$Interactivity$BasicLine$Datum, 7, 5, 2, 5.3, 5.1, 7.8, 7.1),
		A7($author$project$Examples$Interactivity$BasicLine$Datum, 8, 6, 3, 5.4, 3.9, 7.6, 8.5),
		A7($author$project$Examples$Interactivity$BasicLine$Datum, 9, 5, 4, 5.8, 4.6, 6.5, 6.9),
		A7($author$project$Examples$Interactivity$BasicLine$Datum, 10, 4, 3, 4.5, 5.3, 6.3, 7.0)
	]);
var $author$project$Internal$Many$fromPoint = function (point) {
	return {x1: point.x, x2: point.x, y1: point.y, y2: point.y};
};
var $author$project$Internal$Item$isDot = function (_v0) {
	var item = _v0.a;
	var _v1 = item.config.product;
	if (_v1.$ === 'Dot') {
		var dot = _v1.a;
		return $elm$core$Maybe$Just(
			$author$project$Internal$Item$Rendered(
				{
					config: {product: dot, toAny: $author$project$Internal$Item$Dot, tooltipInfo: item.config.tooltipInfo, values: item.config.values},
					toHtml: function (c) {
						return item.toHtml(item.config);
					},
					toLimits: function (_v2) {
						return item.toLimits(item.config);
					},
					toPosition: F2(
						function (plane, _v3) {
							return A2(item.toPosition, plane, item.config);
						}),
					toSvg: F3(
						function (plane, config, pos) {
							return config.values.isReal ? A5(
								$author$project$Internal$Svg$dot,
								plane,
								function ($) {
									return $.x;
								},
								function ($) {
									return $.y;
								},
								config.product,
								{x: config.values.x1, y: config.values.y}) : $elm$svg$Svg$text('');
						})
				}));
	} else {
		return $elm$core$Maybe$Nothing;
	}
};
var $author$project$Internal$Many$dots = function () {
	var centerPosition = F2(
		function (plane, item) {
			return $author$project$Internal$Many$fromPoint(
				$author$project$Internal$Coordinates$center(
					A2($author$project$Internal$Item$getPosition, plane, item)));
		});
	return A2(
		$author$project$Internal$Many$Remodel,
		centerPosition,
		$elm$core$List$filterMap($author$project$Internal$Item$isDot));
}();
var $author$project$Chart$Item$dots = $author$project$Internal$Many$dots;
var $author$project$Examples$Interactivity$BasicLine$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$BasicLine$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$dots)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$BasicLine$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						A3(
						$author$project$Chart$interpolated,
						function ($) {
							return $.y;
						},
						_List_Nil,
						_List_fromArray(
							[
								$author$project$Chart$Attributes$circle,
								$author$project$Chart$Attributes$size(3)
							])),
						A3(
						$author$project$Chart$interpolated,
						function ($) {
							return $.z;
						},
						_List_Nil,
						_List_fromArray(
							[
								$author$project$Chart$Attributes$circle,
								$author$project$Chart$Attributes$size(3)
							]))
					]),
				$author$project$Examples$Interactivity$BasicLine$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4($author$project$Chart$tooltip, item, _List_Nil, _List_Nil, _List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$BasicStack$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Interactivity$BasicStack$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$Interactivity$BasicStack$data = _List_fromArray(
	[
		A8($author$project$Examples$Interactivity$BasicStack$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$Interactivity$BasicStack$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$Interactivity$BasicStack$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$Interactivity$BasicStack$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$Interactivity$BasicStack$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$BasicStack$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$stacks)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$BasicStack$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						$author$project$Chart$stacked(
						_List_fromArray(
							[
								A2(
								$author$project$Chart$bar,
								function ($) {
									return $.z;
								},
								_List_Nil),
								A2(
								$author$project$Chart$bar,
								function ($) {
									return $.y;
								},
								_List_Nil)
							])),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.v;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$color($author$project$Chart$Attributes$purple),
								$author$project$Chart$Attributes$striped(_List_Nil)
							]))
					]),
				$author$project$Examples$Interactivity$BasicStack$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4($author$project$Chart$tooltip, item, _List_Nil, _List_Nil, _List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$Border$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Interactivity$Border$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$Interactivity$Border$data = _List_fromArray(
	[
		A8($author$project$Examples$Interactivity$Border$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$Interactivity$Border$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$Interactivity$Border$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$Interactivity$Border$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$Interactivity$Border$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$Border$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$bars)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$Border$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$opacity(0.3),
								$author$project$Chart$Attributes$borderWidth(1)
							])),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$opacity(0.3),
								$author$project$Chart$Attributes$borderWidth(1)
							]))
					]),
				$author$project$Examples$Interactivity$Border$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4(
								$author$project$Chart$tooltip,
								item,
								_List_fromArray(
									[
										$author$project$Chart$Attributes$border($author$project$Chart$Attributes$red)
									]),
								_List_Nil,
								_List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$ChangeContent$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Interactivity$ChangeContent$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$Interactivity$ChangeContent$data = _List_fromArray(
	[
		A8($author$project$Examples$Interactivity$ChangeContent$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$Interactivity$ChangeContent$Datum, 1.0, 0.3, 2.5, 3.1, 5.1, 4.9, 5.3, 7.0),
		A8($author$project$Examples$Interactivity$ChangeContent$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$Interactivity$ChangeContent$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$Interactivity$ChangeContent$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Internal$Item$getColor = function (_v0) {
	var item = _v0.a;
	return item.config.tooltipInfo.color;
};
var $author$project$Chart$Item$getColor = $author$project$Internal$Item$getColor;
var $author$project$Internal$Item$getX = function (_v0) {
	var item = _v0.a;
	return item.config.values.x1;
};
var $author$project$Chart$Item$getX = $author$project$Internal$Item$getX;
var $author$project$Examples$Interactivity$ChangeContent$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$ChangeContent$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$dots)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$ChangeContent$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						A2(
						$author$project$Chart$scatter,
						function ($) {
							return $.z;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$opacity(0.5),
								$author$project$Chart$Attributes$borderWidth(1)
							])),
						A2(
						$author$project$Chart$scatter,
						function ($) {
							return $.y;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$opacity(0.5),
								$author$project$Chart$Attributes$borderWidth(1)
							])),
						A2(
						$author$project$Chart$scatter,
						function ($) {
							return $.w;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$opacity(0.5),
								$author$project$Chart$Attributes$borderWidth(1)
							])),
						A2(
						$author$project$Chart$scatter,
						function ($) {
							return $.p;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$opacity(0.5),
								$author$project$Chart$Attributes$borderWidth(1)
							]))
					]),
				$author$project$Examples$Interactivity$ChangeContent$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, dot) {
						var y = $author$project$Chart$Item$getY(dot);
						var x = $author$project$Chart$Item$getX(dot);
						var color = $author$project$Chart$Item$getColor(dot);
						return _List_fromArray(
							[
								A4(
								$author$project$Chart$tooltip,
								dot,
								_List_Nil,
								_List_fromArray(
									[
										A2($elm$html$Html$Attributes$style, 'color', color)
									]),
								_List_fromArray(
									[
										$elm$html$Html$text('x: '),
										$elm$html$Html$text(
										$elm$core$String$fromFloat(x)),
										$elm$html$Html$text(' y: '),
										$elm$html$Html$text(
										$elm$core$String$fromFloat(y))
									]))
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$ChangeDot$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Interactivity$ChangeDot$Datum = F7(
	function (x, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, y: y, z: z};
	});
var $author$project$Examples$Interactivity$ChangeDot$data = _List_fromArray(
	[
		A7($author$project$Examples$Interactivity$ChangeDot$Datum, 1, 2, 1, 4.6, 6.9, 7.3, 8.0),
		A7($author$project$Examples$Interactivity$ChangeDot$Datum, 2, 3, 2, 5.2, 6.2, 7.0, 8.7),
		A7($author$project$Examples$Interactivity$ChangeDot$Datum, 3, 4, 3, 5.5, 5.2, 7.2, 8.1),
		A7($author$project$Examples$Interactivity$ChangeDot$Datum, 4, 3, 4, 5.3, 5.7, 6.2, 7.8),
		A7($author$project$Examples$Interactivity$ChangeDot$Datum, 5, 2, 3, 4.9, 5.9, 6.7, 8.2),
		A7($author$project$Examples$Interactivity$ChangeDot$Datum, 6, 4, 1, 4.8, 5.4, 7.2, 8.3),
		A7($author$project$Examples$Interactivity$ChangeDot$Datum, 7, 5, 2, 5.3, 5.1, 7.8, 7.1),
		A7($author$project$Examples$Interactivity$ChangeDot$Datum, 8, 6, 3, 5.4, 3.9, 7.6, 8.5),
		A7($author$project$Examples$Interactivity$ChangeDot$Datum, 9, 5, 4, 5.8, 4.6, 6.5, 6.9),
		A7($author$project$Examples$Interactivity$ChangeDot$Datum, 10, 4, 3, 4.5, 5.3, 6.3, 7.0)
	]);
var $author$project$Examples$Interactivity$ChangeDot$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$ChangeDot$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$dots)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$ChangeDot$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						A3(
						$author$project$Chart$amongst,
						model.hovering,
						function (_v0) {
							return _List_fromArray(
								[
									$author$project$Chart$Attributes$opacity(0),
									$author$project$Chart$Attributes$borderWidth(2)
								]);
						},
						A2(
							$author$project$Chart$scatter,
							function ($) {
								return $.y;
							},
							_List_fromArray(
								[
									$author$project$Chart$Attributes$circle,
									$author$project$Chart$Attributes$size(8)
								]))),
						A3(
						$author$project$Chart$amongst,
						model.hovering,
						function (_v1) {
							return _List_fromArray(
								[
									$author$project$Chart$Attributes$opacity(0),
									$author$project$Chart$Attributes$borderWidth(2)
								]);
						},
						A2(
							$author$project$Chart$scatter,
							function ($) {
								return $.z;
							},
							_List_fromArray(
								[
									$author$project$Chart$Attributes$circle,
									$author$project$Chart$Attributes$size(8)
								])))
					]),
				$author$project$Examples$Interactivity$ChangeDot$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4($author$project$Chart$tooltip, item, _List_Nil, _List_Nil, _List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$ChangeName$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Interactivity$ChangeName$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$Interactivity$ChangeName$data = _List_fromArray(
	[
		A8($author$project$Examples$Interactivity$ChangeName$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$Interactivity$ChangeName$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$Interactivity$ChangeName$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$Interactivity$ChangeName$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$Interactivity$ChangeName$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$ChangeName$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$bins)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$ChangeName$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						A2(
						$author$project$Chart$named,
						'Cats',
						A2(
							$author$project$Chart$bar,
							function ($) {
								return $.z;
							},
							_List_Nil)),
						A2(
						$author$project$Chart$named,
						'Fish',
						A2(
							$author$project$Chart$bar,
							function ($) {
								return $.y;
							},
							_List_fromArray(
								[
									$author$project$Chart$Attributes$striped(_List_Nil)
								]))),
						A2(
						$author$project$Chart$named,
						'Ants',
						A2(
							$author$project$Chart$bar,
							function ($) {
								return $.v;
							},
							_List_fromArray(
								[
									$author$project$Chart$Attributes$dotted(_List_Nil)
								])))
					]),
				$author$project$Examples$Interactivity$ChangeName$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4($author$project$Chart$tooltip, item, _List_Nil, _List_Nil, _List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$ChangeUnit$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Interactivity$ChangeUnit$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$Interactivity$ChangeUnit$data = _List_fromArray(
	[
		A8($author$project$Examples$Interactivity$ChangeUnit$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$Interactivity$ChangeUnit$Datum, 1.0, 0.3, 2.5, 3.1, 5.1, 4.9, 5.3, 7.0),
		A8($author$project$Examples$Interactivity$ChangeUnit$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$Interactivity$ChangeUnit$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$Interactivity$ChangeUnit$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Internal$Property$format = F2(
	function (value, prop) {
		if (prop.$ === 'Property') {
			var con = prop.a;
			return $author$project$Internal$Property$Property(
				_Utils_update(
					con,
					{
						format: A2($elm$core$Basics$composeR, con.value, value)
					}));
		} else {
			var cons = prop.a;
			return $author$project$Internal$Property$Stacked(
				A2(
					$elm$core$List$map,
					function (con) {
						return _Utils_update(
							con,
							{
								format: A2($elm$core$Basics$composeR, con.value, value)
							});
					},
					cons));
		}
	});
var $author$project$Chart$format = function (func) {
	return $author$project$Internal$Property$format(
		function (v) {
			if (v.$ === 'Just') {
				var v_ = v.a;
				return func(v_);
			} else {
				return 'N/A';
			}
		});
};
var $author$project$Internal$Svg$LeftOrRight = {$: 'LeftOrRight'};
var $author$project$Chart$Attributes$onLeftOrRight = function (config) {
	return _Utils_update(
		config,
		{
			direction: $elm$core$Maybe$Just($author$project$Internal$Svg$LeftOrRight)
		});
};
var $author$project$Examples$Interactivity$ChangeUnit$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$ChangeUnit$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$stacks)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$ChangeUnit$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						$author$project$Chart$stacked(
						_List_fromArray(
							[
								A2(
								$author$project$Chart$format,
								function (v) {
									return $elm$core$String$fromFloat(v) + ' m/s';
								},
								A2(
									$author$project$Chart$bar,
									function ($) {
										return $.y;
									},
									_List_fromArray(
										[
											$author$project$Chart$Attributes$opacity(0.5),
											$author$project$Chart$Attributes$borderWidth(1)
										]))),
								A2(
								$author$project$Chart$format,
								function (v) {
									return $elm$core$String$fromFloat(v) + ' m/s';
								},
								A2(
									$author$project$Chart$bar,
									function ($) {
										return $.z;
									},
									_List_fromArray(
										[
											$author$project$Chart$Attributes$opacity(0.5),
											$author$project$Chart$Attributes$borderWidth(1)
										])))
							]))
					]),
				$author$project$Examples$Interactivity$ChangeUnit$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, dot) {
						return _List_fromArray(
							[
								A4(
								$author$project$Chart$tooltip,
								dot,
								_List_fromArray(
									[$author$project$Chart$Attributes$onLeftOrRight]),
								_List_Nil,
								_List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$Coordinates$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Chart$none = $author$project$Chart$HtmlElement(
	F2(
		function (_v0, _v1) {
			return $elm$html$Html$text('');
		}));
var $author$project$Examples$Interactivity$Coordinates$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				A2($elm$core$Basics$composeL, $author$project$Examples$Interactivity$Coordinates$OnHover, $elm$core$Maybe$Just),
				$author$project$Chart$Events$getCoords),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$Coordinates$OnHover($elm$core$Maybe$Nothing)),
				$author$project$Chart$Attributes$domain(
				_List_fromArray(
					[
						A2($author$project$Chart$Attributes$lowest, 0, $author$project$Chart$Attributes$exactly),
						A2($author$project$Chart$Attributes$highest, 10, $author$project$Chart$Attributes$exactly)
					])),
				$author$project$Chart$Attributes$range(
				_List_fromArray(
					[
						A2($author$project$Chart$Attributes$lowest, 0, $author$project$Chart$Attributes$exactly),
						A2($author$project$Chart$Attributes$highest, 10, $author$project$Chart$Attributes$exactly)
					]))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				function () {
				var _v0 = model.hovering;
				if (_v0.$ === 'Just') {
					var coords = _v0.a;
					return A3(
						$author$project$Chart$series,
						function ($) {
							return $.x;
						},
						_List_fromArray(
							[
								A2(
								$author$project$Chart$scatter,
								function ($) {
									return $.y;
								},
								_List_fromArray(
									[
										$author$project$Chart$Attributes$cross,
										$author$project$Chart$Attributes$borderWidth(2),
										$author$project$Chart$Attributes$border('white'),
										$author$project$Chart$Attributes$size(12)
									]))
							]),
						_List_fromArray(
							[coords]));
				} else {
					return $author$project$Chart$none;
				}
			}(),
				function () {
				var _v1 = model.hovering;
				if (_v1.$ === 'Just') {
					var coords = _v1.a;
					return A4(
						$author$project$Chart$labelAt,
						$author$project$Chart$Attributes$middle,
						function ($) {
							return $.max;
						},
						_List_Nil,
						_List_fromArray(
							[
								$elm$svg$Svg$text(
								'x: ' + $elm$core$String$fromFloat(coords.x)),
								$elm$svg$Svg$text(
								' y: ' + $elm$core$String$fromFloat(coords.y))
							]));
				} else {
					return $author$project$Chart$none;
				}
			}()
			]));
};
var $author$project$Examples$Interactivity$Direction$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Interactivity$Direction$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$Interactivity$Direction$data = _List_fromArray(
	[
		A8($author$project$Examples$Interactivity$Direction$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$Interactivity$Direction$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$Interactivity$Direction$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$Interactivity$Direction$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$Interactivity$Direction$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$Direction$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$dots)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$Direction$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						A2(
						$author$project$Chart$scatter,
						function ($) {
							return $.y;
						},
						_List_Nil),
						A2(
						$author$project$Chart$scatter,
						function ($) {
							return $.z;
						},
						_List_Nil)
					]),
				$author$project$Examples$Interactivity$Direction$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4(
								$author$project$Chart$tooltip,
								item,
								_List_fromArray(
									[$author$project$Chart$Attributes$onTopOrBottom]),
								_List_Nil,
								_List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$DoubleSearch$OnHover = F2(
	function (a, b) {
		return {$: 'OnHover', a: a, b: b};
	});
var $author$project$Examples$Interactivity$DoubleSearch$Datum = F9(
	function (x, x1, x2, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, x2: x2, y: y, z: z};
	});
var $author$project$Examples$Interactivity$DoubleSearch$data = _List_fromArray(
	[
		A9($author$project$Examples$Interactivity$DoubleSearch$Datum, 0.0, 0.0, 1.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A9($author$project$Examples$Interactivity$DoubleSearch$Datum, 2.0, 1.0, 2.0, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A9($author$project$Examples$Interactivity$DoubleSearch$Datum, 3.0, 2.0, 3.0, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A9($author$project$Examples$Interactivity$DoubleSearch$Datum, 4.0, 3.0, 4.0, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Internal$Events$map2 = F3(
	function (f, _v0, _v1) {
		var a = _v0.a;
		var b = _v1.a;
		return $author$project$Internal$Events$Decoder(
			F3(
				function (ps, s, p) {
					return A2(
						f,
						A3(a, ps, s, p),
						A3(b, ps, s, p));
				}));
	});
var $author$project$Chart$Events$map2 = $author$project$Internal$Events$map2;
var $author$project$Examples$Interactivity$DoubleSearch$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$on,
				'mousemove',
				A3(
					$author$project$Chart$Events$map2,
					$author$project$Examples$Interactivity$DoubleSearch$OnHover,
					$author$project$Chart$Events$getNearest($author$project$Chart$Item$dots),
					$author$project$Chart$Events$getNearest($author$project$Chart$Item$bars))),
				$author$project$Chart$Events$onMouseLeave(
				A2($author$project$Examples$Interactivity$DoubleSearch$OnHover, _List_Nil, _List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						$author$project$Chart$stacked(
						_List_fromArray(
							[
								A3(
								$author$project$Chart$interpolated,
								function ($) {
									return $.p;
								},
								_List_Nil,
								_List_fromArray(
									[$author$project$Chart$Attributes$circle])),
								A3(
								$author$project$Chart$interpolated,
								function ($) {
									return $.q;
								},
								_List_Nil,
								_List_fromArray(
									[$author$project$Chart$Attributes$circle]))
							]))
					]),
				$author$project$Examples$Interactivity$DoubleSearch$data),
				A3(
				$author$project$Chart$bars,
				_List_fromArray(
					[
						$author$project$Chart$Attributes$x1(
						function ($) {
							return $.x1;
						}),
						$author$project$Chart$Attributes$x2(
						function ($) {
							return $.x2;
						})
					]),
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$color($author$project$Chart$Attributes$purple),
								$author$project$Chart$Attributes$striped(_List_Nil)
							]))
					]),
				$author$project$Examples$Interactivity$DoubleSearch$data),
				A2(
				$author$project$Chart$each,
				model.hoveringDots,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4($author$project$Chart$tooltip, item, _List_Nil, _List_Nil, _List_Nil)
							]);
					})),
				A2(
				$author$project$Chart$each,
				model.hoveringBars,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A3(
								$author$project$Chart$label,
								_List_fromArray(
									[
										$author$project$Chart$Attributes$color($author$project$Chart$Attributes$purple),
										$author$project$Chart$Attributes$moveUp(8),
										$author$project$Chart$Attributes$fontSize(14)
									]),
								_List_fromArray(
									[
										$elm$svg$Svg$text(
										$elm$core$String$fromFloat(
											$author$project$Chart$Item$getY(item)))
									]),
								A2($author$project$Chart$Item$getTop, p, item))
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$FilterSearch$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Interactivity$FilterSearch$Datum = F9(
	function (x, x1, x2, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, x2: x2, y: y, z: z};
	});
var $author$project$Examples$Interactivity$FilterSearch$data = _List_fromArray(
	[
		A9($author$project$Examples$Interactivity$FilterSearch$Datum, 0.0, 0.0, 1.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A9($author$project$Examples$Interactivity$FilterSearch$Datum, 2.0, 1.0, 2.0, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A9($author$project$Examples$Interactivity$FilterSearch$Datum, 3.0, 2.0, 3.0, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A9($author$project$Examples$Interactivity$FilterSearch$Datum, 4.0, 3.0, 4.0, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$Interactivity$FilterSearch$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				$author$project$Chart$Attributes$padding(
				{bottom: 0, left: 10, right: 10, top: 0}),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$FilterSearch$OnHover,
				$author$project$Chart$Events$getNearest(
					A2($author$project$Chart$Item$andThen, $author$project$Chart$Item$stacks, $author$project$Chart$Item$dots))),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$FilterSearch$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$withGrid,
						$author$project$Chart$Attributes$pinned(
						function ($) {
							return $.min;
						})
					])),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						$author$project$Chart$stacked(
						_List_fromArray(
							[
								A3(
								$author$project$Chart$interpolated,
								function ($) {
									return $.p;
								},
								_List_Nil,
								_List_fromArray(
									[$author$project$Chart$Attributes$circle])),
								A3(
								$author$project$Chart$interpolated,
								function ($) {
									return $.q;
								},
								_List_Nil,
								_List_fromArray(
									[$author$project$Chart$Attributes$circle]))
							]))
					]),
				$author$project$Examples$Interactivity$FilterSearch$data),
				A3(
				$author$project$Chart$bars,
				_List_fromArray(
					[
						$author$project$Chart$Attributes$x1(
						function ($) {
							return $.x1;
						}),
						$author$project$Chart$Attributes$x2(
						function ($) {
							return $.x2;
						})
					]),
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$color($author$project$Chart$Attributes$purple)
							]))
					]),
				$author$project$Examples$Interactivity$FilterSearch$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4($author$project$Chart$tooltip, item, _List_Nil, _List_Nil, _List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$Focal$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Interactivity$Focal$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$Interactivity$Focal$data = _List_fromArray(
	[
		A8($author$project$Examples$Interactivity$Focal$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$Interactivity$Focal$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$Interactivity$Focal$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$Interactivity$Focal$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Chart$Attributes$top = function (config) {
	return _Utils_update(
		config,
		{
			focal: $elm$core$Maybe$Just(
				function (pos) {
					return _Utils_update(
						pos,
						{y1: pos.y2});
				})
		});
};
var $author$project$Examples$Interactivity$Focal$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$Focal$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$bars)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$Focal$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.y;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$opacity(0.6),
								$author$project$Chart$Attributes$borderWidth(1),
								$author$project$Chart$Attributes$color($author$project$Chart$Attributes$green)
							])),
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$opacity(0.6),
								$author$project$Chart$Attributes$borderWidth(1),
								$author$project$Chart$Attributes$color($author$project$Chart$Attributes$blue)
							]))
					]),
				$author$project$Examples$Interactivity$Focal$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4(
								$author$project$Chart$tooltip,
								item,
								_List_fromArray(
									[$author$project$Chart$Attributes$onLeftOrRight, $author$project$Chart$Attributes$top]),
								_List_Nil,
								_List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$Multiple$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Interactivity$Multiple$Datum = F9(
	function (x, x1, x2, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, x2: x2, y: y, z: z};
	});
var $author$project$Examples$Interactivity$Multiple$data = _List_fromArray(
	[
		A9($author$project$Examples$Interactivity$Multiple$Datum, 0.0, 0.0, 1.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A9($author$project$Examples$Interactivity$Multiple$Datum, 2.0, 1.0, 2.0, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A9($author$project$Examples$Interactivity$Multiple$Datum, 3.0, 2.0, 3.0, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A9($author$project$Examples$Interactivity$Multiple$Datum, 4.0, 3.0, 4.0, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$Interactivity$Multiple$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$Multiple$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$any)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$Multiple$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(_List_Nil),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$bars,
				_List_fromArray(
					[
						$author$project$Chart$Attributes$x1(
						function ($) {
							return $.x1;
						}),
						$author$project$Chart$Attributes$x2(
						function ($) {
							return $.x2;
						})
					]),
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.z;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$opacity(0.3),
								$author$project$Chart$Attributes$borderWidth(1)
							]))
					]),
				$author$project$Examples$Interactivity$Multiple$data),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						A3(
						$author$project$Chart$interpolated,
						function ($) {
							return $.p;
						},
						_List_Nil,
						_List_Nil),
						A3(
						$author$project$Chart$interpolated,
						function ($) {
							return $.q;
						},
						_List_Nil,
						_List_Nil)
					]),
				$author$project$Examples$Interactivity$Multiple$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4($author$project$Chart$tooltip, item, _List_Nil, _List_Nil, _List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$NoArrow$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Interactivity$NoArrow$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$Interactivity$NoArrow$data = _List_fromArray(
	[
		A8($author$project$Examples$Interactivity$NoArrow$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$Interactivity$NoArrow$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$Interactivity$NoArrow$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$Interactivity$NoArrow$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$Interactivity$NoArrow$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$NoArrow$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$dots)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$NoArrow$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						A2(
						$author$project$Chart$scatter,
						function ($) {
							return $.y;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$color('white'),
								$author$project$Chart$Attributes$size(20),
								$author$project$Chart$Attributes$borderWidth(2)
							])),
						A2(
						$author$project$Chart$scatter,
						function ($) {
							return $.z;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$color('white'),
								$author$project$Chart$Attributes$size(20),
								$author$project$Chart$Attributes$borderWidth(2)
							]))
					]),
				$author$project$Examples$Interactivity$NoArrow$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4(
								$author$project$Chart$tooltip,
								item,
								_List_fromArray(
									[$author$project$Chart$Attributes$noArrow]),
								_List_Nil,
								_List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$Offset$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Interactivity$Offset$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$Interactivity$Offset$data = _List_fromArray(
	[
		A8($author$project$Examples$Interactivity$Offset$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$Interactivity$Offset$Datum, 2.0, 0.4, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$Interactivity$Offset$Datum, 3.0, 0.6, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$Interactivity$Offset$Datum, 4.0, 0.2, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$Interactivity$Offset$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$Offset$OnHover,
				$author$project$Chart$Events$getNearest($author$project$Chart$Item$dots)),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$Offset$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$xLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				$author$project$Chart$yLabels(
				_List_fromArray(
					[$author$project$Chart$Attributes$withGrid])),
				A3(
				$author$project$Chart$series,
				function ($) {
					return $.x;
				},
				_List_fromArray(
					[
						A2(
						$author$project$Chart$scatter,
						function ($) {
							return $.y;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$size(60),
								$author$project$Chart$Attributes$opacity(0.3),
								$author$project$Chart$Attributes$borderWidth(1)
							])),
						A2(
						$author$project$Chart$scatter,
						function ($) {
							return $.z;
						},
						_List_fromArray(
							[
								$author$project$Chart$Attributes$size(50),
								$author$project$Chart$Attributes$opacity(0.3),
								$author$project$Chart$Attributes$borderWidth(1)
							]))
					]),
				$author$project$Examples$Interactivity$Offset$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, item) {
						return _List_fromArray(
							[
								A4(
								$author$project$Chart$tooltip,
								item,
								_List_fromArray(
									[
										$author$project$Chart$Attributes$offset(0)
									]),
								_List_Nil,
								_List_Nil)
							]);
					}))
			]));
};
var $author$project$Examples$Interactivity$TrickyTooltip$OnHover = function (a) {
	return {$: 'OnHover', a: a};
};
var $author$project$Examples$Interactivity$TrickyTooltip$Datum = F8(
	function (x, x1, y, z, v, w, p, q) {
		return {p: p, q: q, v: v, w: w, x: x, x1: x1, y: y, z: z};
	});
var $author$project$Examples$Interactivity$TrickyTooltip$data = _List_fromArray(
	[
		A8($author$project$Examples$Interactivity$TrickyTooltip$Datum, 0.0, 0.0, 1.2, 4.0, 4.6, 6.9, 7.3, 8.0),
		A8($author$project$Examples$Interactivity$TrickyTooltip$Datum, 2.0, 1.0, 2.2, 4.2, 5.3, 5.7, 6.2, 7.8),
		A8($author$project$Examples$Interactivity$TrickyTooltip$Datum, 3.0, 2.0, 1.0, 3.2, 4.8, 5.4, 7.2, 8.3),
		A8($author$project$Examples$Interactivity$TrickyTooltip$Datum, 4.0, 3.0, 1.2, 3.0, 4.1, 5.5, 7.9, 8.1)
	]);
var $author$project$Examples$Interactivity$TrickyTooltip$view = function (model) {
	return A2(
		$author$project$Chart$chart,
		_List_fromArray(
			[
				$author$project$Chart$Attributes$height(300),
				$author$project$Chart$Attributes$width(300),
				$author$project$Chart$Attributes$padding(
				{bottom: 0, left: 10, right: 10, top: 0}),
				A2(
				$author$project$Chart$Events$onMouseMove,
				$author$project$Examples$Interactivity$TrickyTooltip$OnHover,
				$author$project$Chart$Events$getNearest(
					A2($author$project$Chart$Item$andThen, $author$project$Chart$Item$bins, $author$project$Chart$Item$bars))),
				$author$project$Chart$Events$onMouseLeave(
				$author$project$Examples$Interactivity$TrickyTooltip$OnHover(_List_Nil))
			]),
		_List_fromArray(
			[
				$author$project$Chart$yLabels(
				_List_fromArray(
					[
						$author$project$Chart$Attributes$withGrid,
						$author$project$Chart$Attributes$pinned(
						function ($) {
							return $.min;
						})
					])),
				$author$project$Chart$xLabels(_List_Nil),
				A3(
				$author$project$Chart$bars,
				_List_Nil,
				_List_fromArray(
					[
						A2(
						$author$project$Chart$bar,
						function ($) {
							return $.w;
						},
						_List_Nil),
						$author$project$Chart$stacked(
						_List_fromArray(
							[
								A2(
								$author$project$Chart$bar,
								function ($) {
									return $.p;
								},
								_List_Nil),
								A2(
								$author$project$Chart$bar,
								function ($) {
									return $.q;
								},
								_List_Nil)
							]))
					]),
				$author$project$Examples$Interactivity$TrickyTooltip$data),
				A2(
				$author$project$Chart$each,
				model.hovering,
				F2(
					function (p, bin) {
						var toTooltip = function (stack) {
							return A4(
								$author$project$Chart$tooltip,
								stack,
								_List_fromArray(
									[$author$project$Chart$Attributes$o