import { render, WeElement, tag } from "../../src/omi";

@tag("todo-list")
class TodoList extends WeElement {
	render(props) {
		return (
			<ul>
				{props.items.map(item => (
					<li key={item.id}>{item.text}</li>
				))}
			</ul>
		);
	}
}

@tag("todo-app")
class TodoApp extends WeElement {
	static get data() {
		return { items: [], text: "" };
	}

	render() {
		console.log(111);
		return (
			<div>
				<h3>TODO</h3>
				<todo-list items={this.data.items} />
				<form onSubmit={this.handleSubmit}>
					<input
						id="new-todo"
						onChange={this.handleChange}
						value={this.data.text}
					/>
					<button>Add #{this.data.items.length + 1}</button>
				</form>
			</div>
		);
	}

	handleChange = e => {
		this.data.text = e.target.value;
	};

	handleSubmit = e => {
		e.preventDefault();
		if (!this.data.text.trim().length) {
			return;
		}
		this.data.items.push({
			text: this.data.text,
			id: Date.now()
		});
		this.data.text = "";
		this.update();
	};
}

render(<todo-app />, "body");
