var path = require('path');
var webpack = require('webpack');

/**
 * Env
 * Get npm lifecycle event to identify the environment
 */
var ENV = process.env.npm_lifecycle_event;

var config  = {
    entry: __dirname+'/examples/' + ENV + '/main.js',
    output: {
        // path: __dirname,
        path: __dirname+'/examples/' + ENV + '/',
        filename: 'bundler.js'
    },
    module: {
        loaders: [
            {
                loader: 'babel-loader',
                test: /\.js$/,
                query: {
                    presets: ['env','omi'],
                    plugins: [
                        "transform-class-properties"
                    ]
                }
            }
        ]
    },
    plugins: [
    ],
    stats: {
        // Nice colored output
        colors: true
    },
    // Create Sourcemaps for the bundle
    // devtool: 'source-map',
};

module.exports = config;
