##机器学习(Machine Learning)&深度学习(Deep Learning)资料

* [《Brief History of Machine Learning》](http://www.erogol.com/brief-history-machine-learning/)

介绍:这是一篇介绍机器学习历史的文章，介绍很全面，从感知机、神经网络、决策树、SVM、Adaboost到随机森林、Deep Learning.


* [《Deep Learning in Neural Networks: An Overview》](http://www.idsia.ch/~juergen/DeepLearning15May2014.pdf)

介绍:这是瑞士人工智能实验室Jurgen Schmidhuber写的最新版本《神经网络与深度学习综述》本综述的特点是以时间排序，从1940年开始讲起，到60-80年代，80-90年代，一直讲到2000年后及最近几年的进展。涵盖了deep learning里各种tricks，引用非常全面.

* [《A Gentle Introduction to Scikit-Learn: A Python Machine Learning Library》](http://machinelearningmastery.com/a-gentle-introduction-to-scikit-learn-a-python-machine-learning-library/)

介绍:这是一份python机器学习库,如果您是一位python工程师而且想深入的学习机器学习.那么这篇文章或许能够帮助到你.

* [《How to Layout and Manage Your Machine Learning Project》](http://machinelearningmastery.com/how-to-layout-and-manage-your-machine-learning-project/)

介绍:这一篇介绍如果设计和管理属于你自己的机器学习项目的文章，里面提供了管理模版、数据管理与实践方法.

* [《Machine Learning is Fun!》](https://medium.com/code-poet/80ea3ec3c471)

介绍:如果你还不知道什么是机器学习，或则是刚刚学习感觉到很枯燥乏味。那么推荐一读。这篇文章已经被翻译成中文,如果有兴趣可以移步http://blog.jobbole.com/67616/


* [《R语言参考卡片》](http://cran.r-project.org/doc/contrib/Liu-R-refcard.pdf)

介绍:R语言是机器学习的主要语言,有很多的朋友想学习R语言，但是总是忘记一些函数与关键字的含义。那么这篇文章或许能够帮助到你

* [《Choosing a Machine Learning Classifier》](http://blog.echen.me/2011/04/27/choosing-a-machine-learning-classifier/)

介绍:我该如何选择机器学习算法，这篇文章比较直观的比较了Naive Bayes，Logistic Regression，SVM，决策树等方法的优劣，另外讨论了样本大小、Feature与Model权衡等问题。此外还有已经翻译了的版本:http://www.52ml.net/15063.html

* [《An Introduction to Deep Learning: From Perceptrons to Deep Networks》](http://www.toptal.com/machine-learning/an-introduction-to-deep-learning-from-perceptrons-to-deep-networks)

介绍：深度学习概述：从感知机到深度网络，作者对于例子的选择、理论的介绍都很到位，由浅入深。翻译版本：http://www.cnblogs.com/xiaowanyer/p/3701944.html

* [《The LION Way: Machine Learning plus Intelligent Optimization》](http://www.lionsolver.com/LIONbook/)

 介绍:<机器学习与优化>这是一本机器学习的小册子, 短短300多页道尽机器学习的方方面面. 图文并茂, 生动易懂, 没有一坨坨公式的烦恼. 适合新手入门打基础, 也适合老手温故而知新. 比起MLAPP/PRML等大部头, 也许这本你更需要!具体内容推荐阅读:http://intelligent-optimization.org/LIONbook/

* [《深度学习与统计学习理论》](http://1.guzili.sinaapp.com/?p=174)

介绍:作者是来自百度，不过他本人已经在2014年4月份申请离职了。但是这篇文章很不错如果你不知道深度学习与支持向量机/统计学习理论有什么联系？那么应该立即看看这篇文章.

* [《计算机科学中的数学》](http://courses.csail.mit.edu/6.042/fall13/mcs.pdf)

介绍:这本书是由谷歌公司和MIT共同出品的计算机科学中的数学：Mathematics for Computer Science，Eric Lehman et al 2013 。分为5大部分：1）证明，归纳。2）结构，数论，图。3）计数，求和，生成函数。4）概率，随机行走。5）递归。等等

* [《数据科学入门》](http://zh.scribd.com/doc/223731055/Data-Science-Book-v-2)

介绍:这是一本由雪城大学新编的第二版《数据科学入门》教材：偏实用型，浅显易懂，适合想学习R语言的同学选读。

* [《Twenty Questions for Donald Knuth》](http://www.informit.com/articles/article.aspx?p=2213858)

介绍:这并不是一篇文档或书籍。这是篇向图灵奖得主Donald Knuth提问记录稿： 近日， Charles Leiserson, Al Aho, Jon Bentley等大神向Knuth提出了20个问题，内容包括TAOCP，P/NP问题，图灵机，逻辑，以及为什么大神不用电邮等等。

* [《Automatic Construction and Natural-Language Description of Nonparametric Regression Models》](http://arxiv.org/pdf/1402.4304v2.pdf)

介绍：不会统计怎么办？不知道如何选择合适的统计模型怎么办？那这篇文章你的好好读一读了麻省理工Joshua B. Tenenbaum和剑桥Zoubin Ghahramani合作，写了一篇关于automatic statistician的文章。可以自动选择回归模型类别，还能自动写报告...

* [《ICLR 2014论文集》](http://openreview.net/venue/iclr2014)

介绍:对深度学习和representation learning最新进展有兴趣的同学可以了解一下

* [《Introduction to Information Retrieval》](http://www-nlp.stanford.edu/IR-book/)

介绍：这是一本信息检索相关的书籍，是由斯坦福Manning与谷歌副总裁Raghavan等合著的Introduction to Information Retrieval一直是北美最受欢迎的信息检索教材之一。最近作者增加了该课程的幻灯片和作业。IR相关资源：http://www-nlp.stanford.edu/IR-book/information-retrieval.html

* [《Machine learning in 10 pictures》](http://www.denizyuret.com/2014/02/machine-learning-in-5-pictures.html)

介绍:Deniz Yuret用10张漂亮的图来解释机器学习重要概念：1. Bias/Variance Tradeoff 2. Overfitting 3. Bayesian / Occam's razor 4. Feature combination 5. Irrelevant feature 6. Basis function 7. Discriminative / Generative 8. Loss function 9. Least squares 10. Sparsity.很清晰

* [《雅虎研究院的数据集汇总》](http://webscope.sandbox.yahoo.com/catalog.php?datatype=l)

介绍：雅虎研究院的数据集汇总： 包括语言类数据，图与社交类数据，评分与分类数据，计算广告学数据，图像数据，竞赛数据，以及系统类的数据。

* [《An Introduction to Statistical Learning with Applications in R》](http://www-bcf.usc.edu/~gareth/ISL/)

介绍：这是一本斯坦福统计学著名教授Trevor Hastie和Robert Tibshirani的新书，并且在2014年一月已经开课：https://class.stanford.edu/courses/HumanitiesScience/StatLearning/Winter2014/about

* [Best Machine Learning Resources for Getting Started](http://machinelearningmastery.com/best-machine-learning-resources-for-getting-started/)

介绍：机器学习最佳入门学习资料汇总是专为机器学习初学者推荐的优质学习资源，帮助初学者快速入门。而且这篇文章的介绍已经被翻译成[中文版](http://article.yeeyan.org/view/22139/410514)。如果你不怎么熟悉，那么我建议你先看一看中文的介绍。

* [My deep learning reading list](http://blog.sina.com.cn/s/blog_bda0d2f10101fpp4.html)

介绍:主要是顺着Bengio的PAMI review的文章找出来的。包括几本综述文章，将近100篇论文，各位山头们的Presentation。全部都可以在google上找到。

* [Cross-Language Information Retrieval](http://www.morganclaypool.com/doi/abs/10.2200/S00266ED1V01Y201005HLT008?journalCode=hlt)

介绍：这是一本书籍，主要介绍的是跨语言信息检索方面的知识。理论很多

* [探索推荐引擎内部的秘密，第 1 部分: 推荐引擎初探](http://www.ibm.com/developerworks/cn/web/1103_zhaoct_recommstudy1/index.html?ca=drs-)

介绍:本文共有三个系列，作者是来自IBM的工程师。它主要介绍了推荐引擎相关算法，并帮助读者高效的实现这些算法。 [探索推荐引擎内部的秘密，第 2 部分: 深度推荐引擎相关算法 - 协同过滤](http://www.ibm.com/developerworks/cn/web/1103_zhaoct_recommstudy2/index.html?ca=drs-),[探索推荐引擎内部的秘密，第 3 部分: 深度推荐引擎相关算法 - 聚类](http://www.ibm.com/developerworks/cn/web/1103_zhaoct_recommstudy3/index.html?ca=drs-)


* [《Advice for students of machine learning》](http://mimno.infosci.cornell.edu/b/articles/ml-learn/)

介绍：康奈尔大学信息科学系助理教授David Mimno写的《对机器学习初学者的一点建议》， 写的挺实际，强调实践与理论结合，最后还引用了冯 • 诺依曼的名言: "Young man, in mathematics you don't understand things. You just get used to them."

* [分布式并行处理的数据](http://web.stanford.edu/group/pdplab/pdphandbook/)

介绍：这是一本关于分布式并行处理的数据《Explorations in Parallel Distributed Processing: A Handbook of Models, Programs, and Exercises》,作者是斯坦福的James L. McClelland。着重介绍了各种神级网络算法的分布式实现,做Distributed Deep Learning 的童鞋可以参考下

* [《“机器学习”是什么？》](http://blogs.technet.com/b/machinelearning/archive/2014/07/01/what-is-machine-learning.aspx)

介绍:【“机器学习”是什么？】John Platt是微软研究院杰出科学家，17年来他一直在机器学习领域耕耘。近年来机器学习变得炙手可热，Platt和同事们遂决定开设[博客](http://blogs.technet.com/b/machinelearning/)，向公众介绍机器学习的研究进展。机器学习是什么，被应用在哪里？来看Platt的这篇[博文](http://blogs.technet.com/b/machinelearning/archive/2014/07/01/what-is-machine-learning.aspx)

* [《2014年国际机器学习大会ICML 2014 论文》](http://icml.cc/2014/index/article/15.htm)

介绍：2014年国际机器学习大会（ICML）已经于6月21-26日在国家会议中心隆重举办。本次大会由微软亚洲研究院和清华大学联手主办，是这个有着30多年历史并享誉世界的机器学习领域的盛会首次来到中国，已成功吸引海内外1200多位学者的报名参与。干货很多，值得深入学习下

* [《Machine Learning for Industry: A Case Study》](http://blogs.technet.com/b/machinelearning/archive/2014/07/11/machine-learning-for-industry-a-case-study.aspx)

介绍：这篇文章主要是以Learning to Rank为例说明企业界机器学习的具体应用，RankNet对NDCG之类不敏感，加入NDCG因素后变成了LambdaRank，同样的思想从神经网络改为应用到Boosted Tree模型就成就了LambdaMART。[Chirs Burges](http://research.microsoft.com/en-us/people/cburges/?WT.mc_id=Blog_MachLearn_General_DI)，微软的机器学习大神，Yahoo 2010 Learning to Rank Challenge第一名得主，排序模型方面有RankNet，LambdaRank，LambdaMART，尤其以LambdaMART最为突出，代表论文为：
[From RankNet to LambdaRank to LambdaMART: An Overview](http://research.microsoft.com/en-us/um/people/cburges/tech_reports/msr-tr-2010-82.pdf)
此外，Burges还有很多有名的代表作，比如：[A Tutorial on Support Vector Machines for Pattern Recognition](http://research.microsoft.com/pubs/67119/svmtutorial.pdf)    
[Some Notes on Applied Mathematics for Machine Learning](http://research.microsoft.com/en-us/um/people/cburges/tech_reports/tr-2004-56.pdf)

* [100 Best GitHub: Deep Learning](http://meta-guide.com/software-meta-guide/100-best-github-deep-learning/)

介绍:100 Best GitHub: Deep Learning

* [《UFLDL-斯坦福大学Andrew Ng教授“Deep Learning”教程》](http://www.52ml.net/12019.html)

介绍:本教程将阐述无监督特征学习和深度学习的主要观点。通过学习，你也将实现多个功能学习/深度学习算法，能看到它们为你工作，并学习如何应用/适应这些想法到新问题上。本教程假定机器学习的基本知识（特别是熟悉的监督学习，逻辑回归，梯度下降的想法），如果你不熟悉这些想法，我们建议你去这里[机器学习课程](http://openclassroom.stanford.edu/MainFolder/CoursePage.php?course=MachineLearning)，并先完成第II，III，IV章（到逻辑回归）。此外这关于这套教程的源代码在github上面已经有python版本了[ UFLDL Tutorial Code](https://github.com/jatinshah/ufldl_tutorial)

*[《Deep Learning for Natural Language Processing and Related Applications》](http://research.microsoft.com/pubs/217165/ICASSP_DeepTextLearning_v07.pdf)

介绍:这份文档来自微软研究院,精髓很多。如果需要完全理解，需要一定的机器学习基础。不过有些地方会让人眼前一亮,毛塞顿开。

* [Understanding Convolutions](https://colah.github.io/posts/2014-07-Understanding-Convolutions/)

介绍:这是一篇介绍图像卷积运算的文章，讲的已经算比较详细的了

* [《Machine Learning Summer School》](http://mlss2014.com/)

介绍：每天请一个大牛来讲座，主要涉及机器学习，大数据分析，并行计算以及人脑研究。https://www.youtube.com/user/smolix    （需翻墙）

* [《Awesome Machine Learning》](https://github.com/josephmisiti/awesome-machine-learning)

介绍：一个超级完整的机器学习开源库总结，如果你认为这个碉堡了，那后面这个列表会更让你惊讶：【Awesome Awesomeness】,国内已经有热心的朋友进行了翻译[中文介绍](http://blog.jobbole.com/73806/)

* [斯坦福《自然语言处理》课程视频](http://see.stanford.edu/see/lecturelist.aspx?coll=63480b48-8819-4efd-8412-263f1a472f5a)

介绍:ACL候任主席、斯坦福大学计算机系Chris Manning教授的《自然语言处理》课程所有视频已经可以在斯坦福公开课网站上观看了（如Chrome不行，可用IE观看） 作业与测验也可以下载。

* [《Deep Learning and Shallow Learning》](http://freemind.pluskid.org/machine-learning/deep-learning-and-shallow-learning/)

介绍:对比 Deep Learning 和 Shallow Learning 的好文，来着浙大毕业、MIT 读博的 Chiyuan Zhang 的博客。

* [《Recommending music on Spotify with deep learning》](http://benanne.github.io/2014/08/05/spotify-cnns.html)

介绍:利用卷积神经网络做音乐推荐。

* [《Neural Networks and Deep Learning》](http://neuralnetworksanddeeplearning.com/index.html)

介绍：神经网络的免费在线书，已经写了三章了，还有对应的开源代码：https://github.com/mnielsen/neural-networks-and-deep-learning爱好者的福音。

* [《Java Machine Learning》](http://machinelearningmastery.com/java-machine-learning/)

介绍：Java机器学习相关平台和开源的机器学习库，按照大数据、NLP、计算机视觉和Deep Learning分类进行了整理。看起来挺全的，Java爱好者值得收藏。

* [《Machine Learning Theory: An Introductory Primer》](http://www.oschina.net/translate/6-tips-for-writing-better-code)

介绍：机器学习最基本的入门文章，适合零基础者

* [《机器学习常见算法分类汇总》](http://www.ctocio.com/hotnews/15919.html)

介绍：机器学习的算法很多。很多时候困惑人们都是，很多算法是一类算法，而有些算法又是从其他算法中延伸出来的。这里，我们从两个方面来给大家介绍，第一个方面是学习的方式，第二个方面是算法的类似性。

* [《机器学习经典论文/survey合集》](http://suanfazu.com/discussion/68/%E6%9C%BA%E5%99%A8%E5%AD%A6%E4%B9%A0%E7%BB%8F%E5%85%B8%E8%AE%BA%E6%96%87survey%E5%90%88%E9%9B%86)

介绍：看题目你已经知道了是什么内容,没错。里面有很多经典的机器学习论文值得仔细与反复的阅读。

* [《机器学习视频库》](http://work.caltech.edu/library/)

介绍：视频由加州理工学院（Caltech）出品。需要英语底子。

* [《机器学习经典书籍》](http://suanfazu.com/discussion/109/%E6%9C%BA%E5%99%A8%E5%AD%A6%E4%B9%A0%E7%BB%8F%E5%85%B8%E4%B9%A6%E7%B1%8D)

介绍：总结了机器学习的经典书籍，包括数学基础和算法理论的书籍，可做为入门参考书单。

* [《16 Free eBooks On Machine Learning》](http://efytimes.com/e1/fullnews.asp?edid=121516)

介绍:16本机器学习的电子书，可以下载下来在pad，手机上面任意时刻去阅读。不多我建议你看完一本再下载一本。

* [《A Large set of Machine Learning Resources for Beginners to Mavens》](http://www.erogol.com/large-set-machine-learning-resources-beginners-mavens/)

介绍:标题很大，从新手到专家。不过看完上面所有资料。肯定是专家了

* [《机器学习最佳入门学习资料汇总》](http://article.yeeyan.org/view/22139/410514)

介绍：入门的书真的很多，而且我已经帮你找齐了。

* [《Sibyl》](http://users.soe.ucsc.edu/~niejiazhong/slides/chandra.pdf)

介绍：Sibyl 是一个监督式机器学习系统，用来解决预测方面的问题，比如 YouTube 的视频推荐。

* [《Deep Learning》](http://www.iro.umontreal.ca/~bengioy/dlbook/)

介绍：Yoshua Bengio, Ian Goodfellow, Aaron Courville著

* [《Neural Network & Text Mining》](http://www.slideshare.net/ssuser9cc1bd/piji-li-dltm)

介绍:关于(Deep) Neural Networks在 NLP 和 Text Mining 方面一些paper的总结

* [《前景目标检测1（总结）》](http://www.cnblogs.com/lxy2017/p/3927226.html)

介绍:计算机视觉入门之前景目标检测1（总结）

* [《行人检测》](http://www.52ml.net/17004.html)

介绍:计算机视觉入门之行人检测

* [《Deep Learning – important resources for learning and understanding》](http://www.kdnuggets.com/2014/08/deep-learning-important-resources-learning-understanding.html)

介绍:Important resources for learning and understanding . Is awesome

* [《Machine Learning Theory: An Introductory Primer》](http://www.toptal.com/machine-learning/machine-learning-theory-an-introductory-primer)

介绍:这又是一篇机器学习初学者的入门文章。值得一读

* [《Neural Networks and Deep Learning》](http://neuralnetworksanddeeplearning.com/)

介绍:在线Neural Networks and Deep Learning电子书

* [《Python 网页爬虫 & 文本处理 & 科学计算 & 机器学习 & 数据挖掘兵器谱》](http://www.52nlp.cn/python-%E7%BD%91%E9%A1%B5%E7%88%AC%E8%99%AB-%E6%96%87%E6%9C%AC%E5%A4%84%E7%90%86-%E7%A7%91%E5%AD%A6%E8%AE%A1%E7%AE%97-%E6%9C%BA%E5%99%A8%E5%AD%A6%E4%B9%A0-%E6%95%B0%E6%8D%AE%E6%8C%96%E6%8E%98)

介绍:python的17个关于机器学习的工具

* [《神奇的伽玛函数(上)》](http://www.flickering.cn/%E6%A6%82%E7%8E%87%E7%BB%9F%E8%AE%A1/2014/06/%E7%A5%9E%E5%A5%87%E7%9A%84%E4%BC%BD%E7%8E%9B%E5%87%BD%E6%95%B0%E4%B8%8A/)

介绍:下集在这里[神奇的伽玛函数(下)](http://www.flickering.cn/%E6%A6%82%E7%8E%87%E7%BB%9F%E8%AE%A1/2014/06/%E7%A5%9E%E5%A5%87%E7%9A%84%E4%BC%BD%E7%8E%9B%E5%87%BD%E6%95%B0%E4%B8%8A/)

* [《分布式机器学习的故事》](http://cxwangyi.github.io/2014/01/20/distributed-machine-learning/)

介绍:作者王益目前是腾讯广告算法总监，王益博士毕业后在google任研究。这篇文章王益博士7年来从谷歌到腾讯对于分布机器学习的所见所闻。值得细读

* [《机器学习提升之道（Level-Up Your Machine Learning）》](http://metacademy.org/roadmaps/cjrd/level-up-your-ml)

介绍:把机器学习提升的级别分为0~4级，每级需要学习的教材和掌握的知识。这样，给机器学习者提供一个上进的路线图，以免走弯路。另外，整个网站都是关于机器学习的，资源很丰富。

* [《Machine Learning Surveys》](http://www.mlsurveys.com/)

介绍:机器学习各个方向综述的网站

* [《Deep Learning Reading list》](http://deeplearning.net/reading-list/)

介绍:深度学习阅资源列表

* [《Deep Learning: Methods and Applications》](http://research.microsoft.com/pubs/219984/DeepLearningBook_RefsByLastFirstNames.pdf)

介绍：这是一本来自微的研究员 li Peng和Dong Yu所著的关于深度学习的方法和应用的电子书

* [《Machine Learning Summer School 2014》](http://pan.baidu.com/s/1pJ0ok7T)

介绍:2014年七月CMU举办的机器学习夏季课刚刚结束 有近50小时的视频、十多个PDF版幻灯片，覆盖 深度学习，贝叶斯，分布式机器学习，伸缩性 等热点话题。所有13名讲师都是牛人：包括大牛Tom Mitchell （他的［机器学习］是名校的常用教材），还有CMU李沐 .（1080P高清哟）

* [《Sibyl: 来自Google的大规模机器学习系统》](http://users.soe.ucsc.edu/~niejiazhong/slides/chandra.pdf)

介绍:在今年的IEEE/IFIP可靠系统和网络（DSN）国际会议上，Google软件工程师Tushar Chandra做了一个关于Sibyl系统的主题演讲。 Sibyl是一个监督式机器学习系统，用来解决预测方面的问题，比如YouTube的视频推荐。详情请阅读[google sibyl](http://www.infoq.com/cn/news/2014/07/google-sibyl)

* [《Building a deeper understanding of images》](http://googleresearch.blogspot.com/2014/09/building-deeper-understanding-of-images.html)

介绍:谷歌研究院的Christian Szegedy在谷歌研究院的博客上简要地介绍了他们今年参加ImageNet取得好成绩的GoogLeNet系统.是关于图像处理的。

* [《Bayesian network 与python概率编程实战入门》](https://github.com/memect/hao/blob/master/awesome/bayesian-network-python.md)

介绍:贝叶斯学习。如果不是很清可看看[概率编程语言与贝叶斯方法实践](http://www.infoq.com/cn/news/2014/07/programming-language-bayes)

* [《AMA: Michael I Jordan》](http://www.reddit.com/r/MachineLearning/comments/2fxi6v/ama_michael_i_jordan/)

介绍:网友问伯克利机器学习大牛、美国双料院士Michael I. Jordan："如果你有10亿美金，你怎么花？Jordan: "我会用这10亿美金建造一个NASA级别的自然语言处理研究项目。" 

* [《机器学习&数据挖掘笔记_16（常见面试之机器学习算法思想简单梳理）》](http://www.cnblogs.com/tornadomeet/p/3395593.html)

介绍:常见面试之机器学习算法思想简单梳理

* [《文本与数据挖掘视频汇总》](http://www.kdnuggets.com/2014/09/most-viewed-web-mining-lectures-videolectures.html)

介绍：Videolectures上最受欢迎的25个文本与数据挖掘视频汇总

* [《怎么选择深度学习的GPUs》](http://timdettmers.wordpress.com/2014/08/14/which-gpu-for-deep-learning/)

介绍:在Kaggle上经常取得不错成绩的Tim Dettmers介绍了他自己是怎么选择深度学习的GPUs, 以及个人如何构建深度学习的GPU集群: http://t.cn/RhpuD1G 

* [《对话机器学习大神Michael Jordan：深度模型》](http://www.infoq.com/cn/news/2014/09/depth-model)

介绍:对话机器学习大神Michael Jordan

* [《Deep Learning 和 Knowledge Graph 引爆大数据革命》](http://blog.sina.com.cn/s/blog_46d0a3930101fswl.html)

介绍:还有２，３部分。http://blog.sina.com.cn/s/blog_46d0a3930101gs5h.html

* [《Deep Learning 教程翻译》](http://blog.sina.com.cn/s/blog_46d0a3930101h6nf.html)

介绍:是Stanford 教授 Andrew Ng 的 Deep Learning 教程，国内的机器学习爱好者很热心的把这个教程翻译成了中文。如果你英语不好，可以看看这个

* [《Deep Learning 101》](http://markus.com/deep-learning-101/)

介绍:因为近两年来，深度学习在媒体界被炒作很厉害（就像大数据）。其实很多人都还不知道什么是深度学习。这篇文章由浅入深。告诉你深度学究竟是什么！

* [《UFLDL Tutorial》](http://ufldl.stanford.edu/wiki/index.php/UFLDL_Tutorial)

介绍:这是斯坦福大学做的一免费课程（很勉强），这个可以给你在深度学习的路上给你一个学习的思路。里面提到了一些基本的算法。而且告诉你如何去应用到实际环境中。

* [《Toronto Deep Learning Demos》](http://deeplearning.cs.toronto.edu/)

介绍:这是多伦多大学做的一个深度学习用来识别图片标签／图转文字的demo。是一个实际应用案例。有源码

* [《Deep learning from the bottom up》](http://metacademy.org/roadmaps/rgrosse/deep_learning)

介绍:机器学习模型，阅读这个内容需要有一定的基础。

