; Script generated by the HM NIS Edit Script Wizard.
SetCompressor lzma

; MUI 1.67 compatible ------
!include "MUI2.nsh"
!include "FileFunc.nsh"
!include "EnvVarUpdate.nsh"  #download http://nsis.sourceforge.net/mediawiki/images/a/ad/EnvVarUpdate.7z
!include "WinVer.nsh"
; ------------ TextTest settings ---------
!define PRODUCT_NAME "TextTest"
!define PRODUCT_PUBLISHER "TextTest"
!define PRODUCT_WEB_SITE "http://www.texttest.org"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\AppMainExe.exe"

Var TT_HOME
Var ROOT_DRIVE
Var PYTHON_PATH
Var JYTHON_PATH
Var VIRTUALENV_PATH
Var TKDIFF_PATH
Var JAVA_EXE
;Var WINMERGE_PATH

!define env_hkcu 'HKCU "Environment"'
!define env_hklm 'HKLM "SYSTEM\CurrentControlSet\Control\Session Manager\Environment"'

!ifdef WIN64
  !define ARCH "win64"
!else
  !define ARCH "win32"
!endif

!ifndef TT_BIN
  !define TT_BIN "bin"
!endif

!ifndef PYTHON_VERSION
  !DEFINE PYTHON_VERSION "2.7"
!endif
!ifndef JYTHON_VERSION
  !DEFINE JYTHON_VERSION "2.5.3"
!endif

!ifndef VIRTUAL_PYTHON
  !define VIRTUAL_PYTHON "python${PYTHON_VERSION}"
!endif
!ifndef VIRTUAL_JYTHON
  !define VIRTUAL_JYTHON "jython${JYTHON_VERSION}"
!endif

!ifndef PYTHON_INSTALLER
  !define PYTHON_INSTALLER "python-2.7.14.msi"
!endif
!ifndef JYTHON_INSTALLER
  !define JYTHON_INSTALLER "jython-installer-2.5.3.jar"
!endif
!ifndef PYGTK_INSTALLER
  !define PYGTK_INSTALLER "pygtk-all-in-one-2.24.2.win32-py2.7.msi"
!endif

!ifndef TKDIFF_INSTALLER
  !define TKDIFF_INSTALLER "tkdiffInstall.exe"
!endif
/*
!ifndef WINMERGE_INSTALLER
  !define WINMERGE_INSTALLER "WinMerge-2.12.4-exe.zip"
!endif
*/

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"

; Welcome page
;!define MUI_WELCOMEPAGE_TITLE "Please Note:"
;LoadLanguageFile "${NSISDIR}\Contrib\Language files\English.nlf"
LangString WELCOME_TEXT ${LANG_ENGLISH} "This wizard will guide you through the installation of TextTest.$\r$\n$\r$\n \
Click Next to continue.$\r$\n"
!define MUI_WELCOMEPAGE_TEXT "$(WELCOME_TEXT)"
;!define MUI_WELCOMEPAGE_TITLE_3LINES
!insertmacro MUI_PAGE_WELCOME

; Components page
!insertmacro MUI_PAGE_COMPONENTS

; Directory page
LangString TEXT_TOP ${LANG_ENGLISH} "Setup will install \
TextTest in the following folder..."
!define MUI_DIRECTORYPAGE_TEXT_TOP "$(TEXT_TOP)"
;!DEFINE MUI_DIRECTORYPAGE_VARIABLE $INSTDIR
!insertmacro MUI_PAGE_DIRECTORY

; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Texttest home page
PageEx directory
  DirVerify leave
  DirText "Select a root directory to store TextTest tests. This will set the environment variable TEXTTEST_HOME."
  DirVar $TT_HOME
PageExEnd
; Finish page
!define MUI_FINISHPAGE_SHOWREADME ""
!define MUI_FINISHPAGE_SHOWREADME_CHECKED
!define MUI_FINISHPAGE_SHOWREADME_TEXT "Create start menu and desktop shortcuts"
!define MUI_FINISHPAGE_SHOWREADME_FUNCTION makeShortcuts
!insertmacro MUI_PAGE_FINISH

; Language files
!insertmacro MUI_LANGUAGE "English"
; Reserve files
;!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

Name "${PRODUCT_NAME}"
BrandingText " "
RequestExecutionLevel user
Caption "${PRODUCT_NAME}"
OutFile "texttest-all-in-one.${ARCH}.exe"
InstallDir "C:\TextTest"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails hide

!macro SETUP_MACRO un
  Function ${un}setup
    ${GetRoot} "$PROGRAMFILES" $ROOT_DRIVE
    StrCpy $INSTDIR "$ROOT_DRIVE\${PRODUCT_NAME}"
    StrCpy $JYTHON_PATH "$INSTDIR\jython${JYTHON_VERSION}"
    StrCpy $VIRTUALENV_PATH "$INSTDIR\virtualenv"
    StrCpy $TKDIFF_PATH "$PROGRAMFILES\TkDiff"
    ;StrCpy $WINMERGE_PATH "$ROOT_DRIVE\WinMerge-2.12.4-exe"
    StrCpy $TT_HOME "$ROOT_DRIVE\Tests"
  FunctionEnd
!macroend

!insertmacro SETUP_MACRO ""
!insertmacro SETUP_MACRO "un."

Section -SETTINGS
  SetOutPath $TEMP\texttest
  SetOverwrite ifnewer
  Call initialize
  ifErrors 0 +2
  Abort
SectionEnd

Section "Python" SEC02
  ClearErrors
  File "${PYTHON_INSTALLER}"
  ExecWait '"msiexec" /i "$OUTDIR\${PYTHON_INSTALLER}" ALLUSERS=1 /passive' $0
  IfErrors onError
  Call installVirtualEnvOnPython
  IfErrors onError
  Call updatePythonPath
  IfErrors onError done
  onError:
    Abort
  done:
SectionEnd

Section "PyGtk" SEC03
  File "${PYGTK_INSTALLER}"
  ExecWait '"msiexec" /i "$OUTDIR\${PYGTK_INSTALLER}"'
  IfErrors 0 +2
    Abort
SectionEnd

SectionGroup /e "Diff tool" G1
  Section "Tkdiff" g1o1
    File "${TKDIFF_INSTALLER}"
    ExecWait '"cmd.exe" /K CD $OUTDIR & tkdiffInstall.exe && EXIT'
    IfErrors onError
    Call updateTkDiffPath
    IfErrors onError done
    onError:
    Abort
    done:
  SectionEnd
/*
  Section /o "WinMerge" g1o2
    File "${WINMERGE_INSTALLER}"
    ZipDLL::extractall "$OUTDIR\${WINMERGE_INSTALLER}" "$ROOT_DRIVE\"
    IfErrors onError
    Call updateWinMergePath
    IfErrors onError done
    onError:
    Abort
    done:
  SectionEnd
*/
SectionGroupEnd

SectionGroup /e "StoryText" G2
Section /o "" TOGGLE ;hidden section to keep track of section group's state
SectionEnd
Section /o "StoryText for Python GUI testing" SEC07
  Call configureStorytextPython
  IfErrors onError done
  onError:
    Abort
  done:
SectionEnd

SectionGroup /e "StoryText for Java" G3
Section /o "Jython" g3o1
  Call installJython
  IfErrors onError done
  onError:
    Abort
  done:
SectionEnd

Section /o "StoryText for Java GUI testing" g3o2
  Call configureStorytextJava
  IfErrors onError done
  onError:
    Abort
  done:
SectionEnd
SectionGroupEnd
SectionGroupEnd

Section "Texttest" SEC09
  Call configureTextTest
  IfErrors onError
  Call updateTexttestPath
  IfErrors onError done
  onError:
    Abort
  done:
SectionEnd

Section "Uninstall"
  Call un.install
SectionEnd

; ============== Section macros ========================
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${G2} "Installing StoryText will add support for Python GUI testing by default."
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC07} "Installing StoryText will require an internet connection."
  !insertmacro MUI_DESCRIPTION_TEXT ${G3} "Installing StoryText will require an internet connection.$\r$\n$\r$\n \
Installing StoryText for Java GUIs requires Java Runtime Environment (JRE) to be pre-installed.$\r$\n"
!insertmacro MUI_FUNCTION_DESCRIPTION_END

; ============== Fuctions ========================
Function initialize
  Call setup
  File "texttest-icon.ico"
  CreateDirectory "$INSTDIR"
  CreateDirectory "$VIRTUALENV_PATH"
  writeUninstaller "$INSTDIR\Uninstall.exe"
FunctionEnd


Function installJython
  File "${JYTHON_INSTALLER}"
  Call checkJava
  IfFileExists "$JYTHON_PATH" removeOld install
  removeOld:
    RMDir /r "$JYTHON_PATH"
  checkEmpty:
    sleep 500
    IfFileExists "$JYTHON_PATH" checkEmpty install
  install:
    ExecWait '$JAVA_EXE -jar $OUTDIR\${JYTHON_INSTALLER} -s -d "$JYTHON_PATH"'
    IfErrors onError
    Call installVirtualEnvOnJython
    IfErrors onError
    Call updateJythonPath
    IfErrors onError done
  onError:
    Abort
  done:
FunctionEnd

Function .onInstSuccess
  Call setTexttestHome
FunctionEnd

Function setTexttestHome
  IfFileExists "$TT_HOME\*.*" done
    CreateDirectory "$TT_HOME"
  done:
    ${If} ${IsWin7}
      ExecWait '"cmd.exe" /K SETX TEXTTEST_HOME $TT_HOME & EXIT'
    ${else}
      WriteRegStr ${env_hkcu} "TEXTTEST_HOME" $TT_HOME
    ${EndIf}
FunctionEnd

Function updateTexttestPath
  ${EnvVarUpdate} $0 "PATH" "P" "HKCU" "$VIRTUALENV_PATH\${VIRTUAL_PYTHON}\Scripts"
FunctionEnd

Function updatePythonPath
  ${EnvVarUpdate} $0 "PATH" "P" "HKCU" "$VIRTUALENV_PATH\${VIRTUAL_PYTHON}\bin"
  ${EnvVarUpdate} $0 "PATH" "P" "HKCU" "$VIRTUALENV_PATH\${VIRTUAL_PYTHON}\Scripts"
FunctionEnd

Function updateJythonPath
  ${EnvVarUpdate} $0 "PATH" "P" "HKCU" "$VIRTUALENV_PATH\${VIRTUAL_JYTHON}\bin"
FunctionEnd

Function updateTkDiffPath
  ${EnvVarUpdate} $0 "PATH" "P" "HKCU" "$TKDIFF_PATH"
FunctionEnd

/*
Function updateWinMergePath
  ${EnvVarUpdate} $0 "PATH" "P" "HKCU" "$WINMERGE_PATH"
FunctionEnd
*/

Function configureTextTest
  IfFileExists "$VIRTUALENV_PATH\${VIRTUAL_PYTHON}\*.*" install
  Call installVirtualEnvOnPython
  IfErrors 0 install
  MessageBox MB_OK|MB_ICONSTOP "Failed to install virtual environment on Python."
  Quit
  install:
  ifFileExists "$VIRTUALENV_PATH\${VIRTUAL_PYTHON}\Scripts\texttest*" upgrade
  ExecWait '"cmd.exe" /K CD $VIRTUALENV_PATH & ECHO Configuring texttest & ${VIRTUAL_PYTHON}\Scripts\pip install texttest & EXIT'
  IfErrors onError done
  upgrade:
  ExecWait '"cmd.exe" /K CD $VIRTUALENV_PATH & ECHO Configuring texttest & ${VIRTUAL_PYTHON}\Scripts\pip install --upgrade texttest & EXIT'
  IfErrors onError done
  onError:
    MessageBox MB_OK|MB_ICONSTOP "Failed to install TextTest."
    Quit
  done:
FunctionEnd

Function configureStorytextPython
  IfFileExists "$VIRTUALENV_PATH\${VIRTUAL_PYTHON}\*.*" install
  Call installVirtualEnvOnPython
  IfErrors 0 install
  MessageBox MB_OK|MB_ICONSTOP "Failed to install virtual environment on Python."
  Quit
  install:
  ifFileExists "$VIRTUALENV_PATH\${VIRTUAL_PYTHON}\Scripts\storytext*" upgrade
  ExecWait '"cmd.exe" /K CD $VIRTUALENV_PATH & ECHO Configuring storytext on python & ${VIRTUAL_PYTHON}\Scripts\pip install storytext & EXIT'
  IfErrors onError done
  upgrade:
  ExecWait '"cmd.exe" /K CD $VIRTUALENV_PATH & ECHO Configuring storytext on python & ${VIRTUAL_PYTHON}\Scripts\pip install --upgrade storytext & EXIT'
  IfErrors onError done
  onError:
    MessageBox MB_OK|MB_ICONSTOP "Failed to install StoryText on Python."
    Quit
  done:
FunctionEnd

Function configureStorytextJava
  IfFileExists "$VIRTUALENV_PATH\${VIRTUAL_JYTHON}\*.*" install
  Call installVirtualEnvOnPython
  IfErrors 0 install
  MessageBox MB_OK|MB_ICONSTOP "Failed to install virtual environment on Jython."
  Quit
  install:
  IfFileExists "$VIRTUALENV_PATH\${VIRTUAL_JYTHON}\bin\storytext*" upgrade
  ;ExecWait '"cmd.exe" /K CD $VIRTUALENV_PATH & ECHO Configuring storytext on jython & ${VIRTUAL_JYTHON}\bin\jython ${VIRTUAL_JYTHON}\bin\pip install storytext && EXIT'
  ExecWait '"cmd.exe" /K CD $VIRTUALENV_PATH & ECHO Configuring storytext on jython & ${VIRTUAL_JYTHON}\bin\jython ${VIRTUAL_JYTHON}\bin\easy_install storytext && EXIT'
  IfErrors onError done
  upgrade:
  ExecWait '"cmd.exe" /K CD $VIRTUALENV_PATH & ECHO Configuring storytext on jython & ${VIRTUAL_JYTHON}\bin\jython ${VIRTUAL_JYTHON}\bin\easy_install --upgrade storytext && EXIT'
  IfErrors onError done
  onError:
    MessageBox MB_OK|MB_ICONSTOP "Failed to install StoryText on Jython."
    Quit
  done:
FunctionEnd

Function checkPythonPath
  ReadRegStr $PYTHON_PATH HKCU "SOFTWARE\Python\PythonCore\${PYTHON_VERSION}\InstallPath" ""
  IfErrors 0 done
  ClearErrors
  ReadRegStr $PYTHON_PATH HKLM "SOFTWARE\Python\PythonCore\${PYTHON_VERSION}\InstallPath" ""
  IfErrors onError done
  onError:
    MessageBox MB_OK|MB_ICONSTOP "Python is not installed. Run the installer again and choose Python"
    Quit
  done:
FunctionEnd

Function checkJava
  ; Check if it's already in path
  StrCpy $JAVA_EXE "java"
  ExecWait '"cmd.exe" /K java -version & EXIT'
  IfErrors checkJavaHome done
  ; Check for JAVA_HOME
  checkJavaHome:
    ClearErrors
    ReadEnvStr $R0 "JAVA_HOME"
    StrCpy $JAVA_EXE "$R0\bin\java.exe"
    IfErrors checkRegistry
    IfFileExists $JAVA_EXE done checkRegistry

  ; Check for registry
  checkRegistry:
    ClearErrors
    ReadRegStr $R1 HKLM "SOFTWARE\JavaSoft\Java Runtime Environment" "CurrentVersion"
    ReadRegStr $R0 HKLM "SOFTWARE\JavaSoft\Java Runtime Environment\$R1" "JavaHome"
    StrCpy $JAVA_EXE "$R0\bin\java.exe"
    IfErrors onError done
  onError:
    MessageBox MB_OK|MB_ICONSTOP "Java is not installed. It must be present in order to install StoryText for java."
    Quit
  done:
FunctionEnd

Function installVirtualEnvOnPython
  Call checkPythonPath
  ExecWait '"cmd.exe" /K ECHO installing virtualenv on python & $PYTHON_PATH\Scripts\pip install virtualenv && EXIT'
  ExecWait '"cmd.exe" /K CD $VIRTUALENV_PATH & ECHO Making python virtualenv for TextTest & $PYTHON_PATH\scripts\virtualenv --system-site-packages ${VIRTUAL_PYTHON} && EXIT'
Functionend

Function installVirtualEnvOnJython
  IfFileExists "$VIRTUALENV_PATH\${VIRTUAL_JYTHON}" removeOld install
  removeOld:
    RMDir /r "$VIRTUALENV_PATH\${VIRTUAL_JYTHON}"
  checkEmpty:
    sleep 500
    IfFileExists "$VIRTUALENV_PATH\${VIRTUAL_JYTHON}" checkEmpty install
  install:
    ExecWait '"cmd.exe" /K ECHO installing virtualenv on jython & $JYTHON_PATH\bin\pip install virtualenv && EXIT'
    ExecWait '"cmd.exe" /K CD $VIRTUALENV_PATH & ECHO Making Jython virtualenv for TextTest & $JYTHON_PATH\bin\virtualenv ${VIRTUAL_JYTHON} && EXIT'
    ;ExecWait '"cmd.exe" /K CD $VIRTUALENV_PATH & ECHO installing virtualenv on jython & "$PYTHON_PATH"python virtualenv.py -p $JYTHON_PATH\bin\jython.bat ${VIRTUAL_JYTHON} && EXIT'
    ;ExecWait '"cmd.exe" /K CD $VIRTUALENV_PATH & ECHO installing virtualenv on jython & $JYTHON_PATH\bin\jython virtualenv.py --distribute ${VIRTUAL_JYTHON} && EXIT'
Functionend

Function makeShortcuts
  CreateDirectory "$SMPROGRAMS\${PRODUCT_NAME}"
  CreateShortcut "$SMPROGRAMS\${PRODUCT_NAME}\${PRODUCT_NAME}.lnk" "$VIRTUALENV_PATH\${VIRTUAL_PYTHON}\Scripts\pythonw.exe" "$VIRTUALENV_PATH\${VIRTUAL_PYTHON}\Scripts\texttest.pyw" "$OUTDIR\texttest-icon.ico" ""
  CreateShortcut "$SMPROGRAMS\${PRODUCT_NAME}\Uninstall.lnk" "$INSTDIR\Uninstall.exe"
  CreateShortcut "$DESKTOP\${PRODUCT_NAME}.lnk" "$VIRTUALENV_PATH\${VIRTUAL_PYTHON}\Scripts\pythonw.exe" "$VIRTUALENV_PATH\${VIRTUAL_PYTHON}\Scripts\texttest.pyw" "$OUTDIR\texttest-icon.ico" ""
FunctionEnd

Function .onInit
  StrCpy $1 ${g1o1}
FunctionEnd

Function .onSelChange
  !define /math SECFLAGS_SELRO ${SF_SELECTED} | ${SF_RO}
  ${IfNot} ${SectionIsSelected} ${TOGGLE}
  ${AndIf} ${SectionIsReadOnly} ${SEC07}
    !insertmacro ClearSectionFlag ${SEC07} ${SECFLAGS_SELRO}
  ${EndIf}
  ${If} ${SectionIsSelected} ${g3o1}
  ${OrIf} ${SectionIsSelected} ${g3o2}
    !insertmacro SetSectionFlag ${SEC07} ${SECFLAGS_SELRO}
  ${Else}
    !insertmacro ClearSectionFlag ${SEC07} ${SF_RO}
  ${EndIf}
  ${If} ${SectionIsSelected} ${SEC07}
    !insertmacro SelectSection ${TOGGLE}
  ${Else}
    !insertmacro UnselectSection ${TOGGLE}
  ${EndIf}
  !undef SECFLAGS_SELRO
FunctionEnd
; ============== Uninstall fuctions ========================
Function un.install
  Call un.setup
  RMDir /r "$JYTHON_PATH"
  RMDir /r "$OUTDIR"
  RMDir /r $VIRTUALENV_PATH
  RMDir /r $SMPROGRAMS\${PRODUCT_NAME}
  Delete "$DESKTOP\${PRODUCT_NAME}.lnk"
  Call un.setEnv
  Delete "$INSTDIR\Uninstall.exe"
FunctionEnd

Function un.setEnv
  DeleteRegKey "HKCU" "Environment\TEXTTEST_HOME"
  ${un.EnvVarUpdate} $0 "PATH" "R" "HKCU" "$VIRTUALENV_PATH\${VIRTUAL_PYTHON}\bin"
  ${un.EnvVarUpdate} $0 "PATH" "R" "HKCU" "$VIRTUALENV_PATH\${VIRTUAL_PYTHON}\Scripts"
  ${un.EnvVarUpdate} $0 "PATH" "R" "HKCU" "$VIRTUALENV_PATH\${VIRTUAL_JYTHON}\bin"
  ${un.EnvVarUpdate} $0 "PATH" "R" "HKCU" "$TKDIFF_PATH"
  ;${un.EnvVarUpdate} $0 "PATH" "R" "HKCU" "$WINMERGE_PATH"
FunctionEnd


/*
Function .onSelChange
  !insertmacro StartRadioButtons $1
    !insertmacro RadioButton ${g1o1}
    !insertmacro RadioButton ${g1o2}
  !insertmacro EndRadioButtons
FunctionEnd
*/
