/*
 * Decompiled with CFR 0.152.
 */
package info.mosip.keycloak.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormActionFactory;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.provider.ProviderConfigProperty;

public class CustomRegistrationProfile
implements FormAction,
FormActionFactory {
    public static final String PROVIDER_ID = "registration-profile-action";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("[a-zA-Z0-9!#$%&'*+/=?^_`{|}~.-]+@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*");
    Logger logger = Logger.getLogger(CustomRegistrationProfile.class);
    private static AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};

    public void close() {
    }

    public FormAction create(KeycloakSession session) {
        this.logger.info("Inside the create" + session);
        return new CustomRegistrationProfile();
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        this.logger.info("Inside the getIdregistration-profile-action");
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "PMS Profile Validation";
    }

    public String getReferenceCategory() {
        return null;
    }

    public boolean isConfigurable() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return true;
    }

    public String getHelpText() {
        return "Validates email, first name, and last name attributes and stores them in user data.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public void buildPage(FormContext context, LoginFormsProvider form) {
    }

    public void validate(ValidationContext context) {
        this.logger.info("Inside user validation");
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        ArrayList<FormMessage> errors = new ArrayList<FormMessage>();
        context.getEvent().detail("register_method", "form");
        String eventError = "invalid_registration";
        if (((String)formData.getFirst((Object)"user.attributes.partnerType")).isBlank()) {
            errors.add(new FormMessage("user.attributes.partnerType", "Please specify partnerType"));
        }
        if (((String)formData.getFirst((Object)"user.attributes.phoneNumber")).isBlank()) {
            errors.add(new FormMessage("user.attributes.phoneNumber", "Please specify phoneNumber"));
        }
        if (((String)formData.getFirst((Object)"user.attributes.organizationName")).isBlank()) {
            errors.add(new FormMessage("user.attributes.organizationName", "Please specify organizationName"));
        }
        if (((String)formData.getFirst((Object)"user.attributes.address")).isBlank()) {
            errors.add(new FormMessage("user.attributes.address", "Please specify address"));
        }
        if (((String)formData.getFirst((Object)"email")).isBlank()) {
            errors.add(new FormMessage("email", "Please specify email"));
        } else if (!EMAIL_PATTERN.matcher((CharSequence)formData.getFirst((Object)"email")).matches()) {
            errors.add(new FormMessage("email", "Please specify valid email"));
        } else if (context.getSession().users().getUserByEmail((String)formData.getFirst((Object)"email"), context.getRealm()) != null) {
            errors.add(new FormMessage("email", "email exists"));
        }
        if (this.isInputStringContainsSpaces((String)formData.getFirst((Object)"username"))) {
            errors.add(new FormMessage("user.attributes.username", "Username should not contain spaces"));
        }
        if (errors.size() > 0) {
            context.error(eventError);
            context.validationError(formData, errors);
            return;
        }
        context.success();
    }

    private boolean isInputStringContainsSpaces(String inputString) {
        return inputString.matches(".*\\s.*");
    }

    public void success(FormContext context) {
        this.logger.info("Entering the successregistration-profile-action");
        UserModel user = context.getUser();
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        RoleModel role = context.getRealm().getRole((String)formData.getFirst((Object)"user.attributes.partnerType"));
        this.logger.info("leaving the success" + role.getId());
        user.grantRole(role);
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return false;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void init(Config.Scope config) {
    }
}

