/*
* Copyright 2010 BetaSteward_at_googlemail.com. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without modification, are
* permitted provided that the following conditions are met:
*
*    1. Redistributions of source code must retain the above copyright notice, this list of
*       conditions and the following disclaimer.
*
*    2. Redistributions in binary form must reproduce the above copyright notice, this list
*       of conditions and the following disclaimer in the documentation and/or other materials
*       provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY BetaSteward_at_googlemail.com ``AS IS'' AND ANY EXPRESS OR IMPLIED
* WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
* FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BetaSteward_at_googlemail.com OR
* CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
* ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* The views and conclusions contained in the software and documentation are those of the
* authors and should not be interpreted as representing official policies, either expressed
* or implied, of BetaSteward_at_googlemail.com.
 */
package mage.client.table;

import java.util.UUID;
import javax.swing.JComponent;

import mage.client.MagePane;
import mage.client.SessionHandler;
import mage.client.plugins.impl.Plugins;

/**
 *
 * @author BetaSteward_at_googlemail.com
 */
public class TablesPane extends MagePane {

    /**
     * Creates new form TablesPane
     */
    public TablesPane() {
        boolean initialized = false;
        if (Plugins.instance.isThemePluginLoaded()) {
            tablesPanel = new mage.client.table.TablesPanel();
            JComponent container = Plugins.instance.updateTablePanel(tablesPanel.getUIComponents());
            if (container != null) {
                initComponents(container);
                container.add(tablesPanel);
                container.setOpaque(false);
                initialized = true;
            }
        }
        if (!initialized) {
            initComponents();
        }
    }

    public void cleanUp() {
        tablesPanel.cleanUp();
    }

    @Override
    public void changeGUISize() {
        super.changeGUISize();
        tablesPanel.changeGUISize();
    }

    public void showTables() {
        UUID roomId = SessionHandler.getSession().getMainRoomId();
        if (roomId != null) {
            this.setTitle("Tables");
            tablesPanel.showTables(roomId);
            this.repaint();
        }

    }

    public void hideTables() {
        tablesPanel.hideTables();
    }

    public void clearChat() {
        tablesPanel.getChatPanel().clear();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        tablesPanel = new mage.client.table.TablesPanel();

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(tablesPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 541, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(tablesPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 471, Short.MAX_VALUE)
        );

    }// </editor-fold>//GEN-END:initComponents

    private void initComponents(JComponent container) {
        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addComponent(container, javax.swing.GroupLayout.DEFAULT_SIZE, 541, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addComponent(container, javax.swing.GroupLayout.DEFAULT_SIZE, 471, Short.MAX_VALUE)
        );
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private mage.client.table.TablesPanel tablesPanel;
    // End of variables declaration//GEN-END:variables

    @Override
    public void activated() {
        tablesPanel.startTasks();
    }

    @Override
    public void deactivated() {
        tablesPanel.stopTasks();
    }

    public void setTableFilter() {
        if (tablesPanel != null) {
            tablesPanel.setTableFilter();
        }
    }
}
