/*
* Copyright 2011 BetaSteward_at_googlemail.com. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without modification, are
* permitted provided that the following conditions are met:
*
*    1. Redistributions of source code must retain the above copyright notice, this list of
*       conditions and the following disclaimer.
*
*    2. Redistributions in binary form must reproduce the above copyright notice, this list
*       of conditions and the following disclaimer in the documentation and/or other materials
*       provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY BetaSteward_at_googlemail.com ``AS IS'' AND ANY EXPRESS OR IMPLIED
* WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
* FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BetaSteward_at_googlemail.com OR
* CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
* ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* The views and conclusions contained in the software and documentation are those of the
* authors and should not be interpreted as representing official policies, either expressed
* or implied, of BetaSteward_at_googlemail.com.
 */
package mage.deck;

import mage.cards.ExpansionSet;
import mage.cards.Sets;
import mage.cards.decks.Constructed;
import mage.constants.SetType;

/**
 * This class implements the new casual format "Eternal", which is legacy with
 * no reserved list cards legal. Banlist taken from
 * <https://www.reddit.com/r/mtgEternal/>
 *
 * @author marthinwurer@gmail.com
 */
public class Eternal extends Constructed {

    public Eternal() {
        super("Constructed - Eternal");
        for (ExpansionSet set : Sets.getInstance().values()) {
            if (set.getSetType() != SetType.CUSTOM_SET) {
                setCodes.add(set.getCode());
            }
        }
        banned.add("Abeyance");
        banned.add("Aboroth");
        banned.add("Academy Rector");
        banned.add("Acid Rain");
        banned.add("Acidic Dagger");
        banned.add("Adun Oakenshield");
        banned.add("Advantageous Proclamation");
        banned.add("Aegis of the Meek");
        banned.add("Aeolipile");
        banned.add("Afiya Grove");
        banned.add("Aku Djinn");
        banned.add("Al-abara's Carpet");
        banned.add("Alchor's Tomb");
        banned.add("Ali from Cairo");
        banned.add("All Hallow's Eve");
        banned.add("Altar of Bone");
        banned.add("Aluren");
        banned.add("Amulet of Quoz");
        banned.add("Amulet of Unmaking");
        banned.add("An-Zerrin Ruins");
        banned.add("Anaba Ancestor");
        banned.add("Anaba Spirit Crafter");
        banned.add("Ancestral Knowledge");
        banned.add("Ancestral Recall");
        banned.add("Angus Mackenzie");
        banned.add("Anvil of Bogardan");
        banned.add("Apocalypse Chime");
        banned.add("Apocalypse");
        banned.add("Argivian Archaeologist");
        banned.add("Argothian Wurm");
        banned.add("Ashnod's Cylix");
        banned.add("Asmira, Holy Avenger");
        banned.add("Auspicious Ancestor");
        banned.add("Autumn Willow");
        banned.add("Avenging Angel");
        banned.add("Avizoa");
        banned.add("Aysen Crusader");
        banned.add("Aysen Highway");
        banned.add("Backup Plan");
        banned.add("Badlands");
        banned.add("Baki's Curse");
        banned.add("Balance");
        banned.add("Balduvian Hydra");
        banned.add("Balduvian Trading Post");
        banned.add("Balm of Restoration");
        banned.add("Baron Sengir");
        banned.add("Barreling Attack");
        banned.add("Barrin, Master Wizard");
        banned.add("Bartel Runeaxe");
        banned.add("Bayou");
        banned.add("Bazaar of Baghdad");
        banned.add("Bazaar of Wonders");
        banned.add("Beast Walkers");
        banned.add("Benthic Djinn");
        banned.add("Black Carriage");
        banned.add("Black Lotus");
        banned.add("Blaze of Glory");
        banned.add("Blizzard");
        banned.add("Bogardan Phoenix");
        banned.add("Bone Dancer");
        banned.add("Bone Mask");
        banned.add("Boris Devilboon");
        banned.add("Bosium Strip");
        banned.add("Brago's Favor");
        banned.add("Braingeyser");
        banned.add("Brand of Ill Omen");
        banned.add("Breathstealer's Crypt");
        banned.add("Bronze Tablet");
        banned.add("Brushwagg");
        banned.add("Bubble Matrix");
        banned.add("Cadaverous Bloom");
        banned.add("Call to Arms");
        banned.add("Candelabra of Tawnos");
        banned.add("Canopy Dragon");
        banned.add("Carnival of Souls");
        banned.add("Carrion");
        banned.add("Catacomb Dragon");
        banned.add("Caverns of Despair");
        banned.add("Chain Stasis");
        banned.add("Chains of Mephistopheles");
        banned.add("Channel");
        banned.add("Chaos Harlequin");
        banned.add("Chaos Orb");
        banned.add("Chaosphere");
        banned.add("Chromatic Armor");
        banned.add("Chronatog");
        banned.add("Circle of Despair");
        banned.add("Citanul Centaurs");
        banned.add("Citanul Druid");
        banned.add("City in a Bottle");
        banned.add("City of Shadows");
        banned.add("City of Solitude");
        banned.add("City of Traitors");
        banned.add("Cleanse");
        banned.add("Cleansing");
        banned.add("Commander Greven il-Vec");
        banned.add("Conch Horn");
        banned.add("Contract from Below");
        banned.add("Copy Artifact");
        banned.add("Corpse Dance");
        banned.add("Corrosion");
        banned.add("Covetous Dragon");
        banned.add("Crovax the Cursed");
        banned.add("Cursed Scroll");
        banned.add("Cycle of Life");
        banned.add("Cyclopean Tomb");
        banned.add("Damping Field");
        banned.add("Darkpact");
        banned.add("Daughter of Autumn");
        banned.add("Debt of Loyalty");
        banned.add("Delif's Cube");
        banned.add("Demonic Attorney");
        banned.add("Demonic Consultation");
        banned.add("Demonic Hordes");
        banned.add("Demonic Tutor");
        banned.add("Deranged Hermit");
        banned.add("Diamond Kaleidoscope");
        banned.add("Diamond Valley");
        banned.add("Didgeridoo");
        banned.add("Dig Through Time");
        banned.add("Discordant Spirit");
        banned.add("Disharmony");
        banned.add("Divine Intervention");
        banned.add("Divine Retribution");
        banned.add("Dominating Licid");
        banned.add("Donate");
        banned.add("Double Stroke");
        banned.add("Draconian Cylix");
        banned.add("Dream Halls");
        banned.add("Drop of Honey");
        banned.add("Dwarven Armorer");
        banned.add("Dwarven Pony");
        banned.add("Dwarven Sea Clan");
        banned.add("Dwarven Thaumaturgist");
        banned.add("Dystopia");
        banned.add("Earthcraft");
        banned.add("Earthlink");
        banned.add("Ebon Praetor");
        banned.add("Eladamri, Lord of Leaves");
        banned.add("Elder Spawn");
        banned.add("Elephant Graveyard");
        banned.add("Elkin Lair");
        banned.add("Elven Lyre");
        banned.add("Elvish Farmer");
        banned.add("Emberwilde Caliph");
        banned.add("Emberwilde Djinn");
        banned.add("Energy Bolt");
        banned.add("Energy Storm");
        banned.add("Energy Vortex");
        banned.add("Equipoise");
        banned.add("Ertai's Familiar");
        banned.add("Ertai, Wizard Adept");
        banned.add("Escaped Shapeshifter");
        banned.add("Eternal Flame");
        banned.add("Eureka");
        banned.add("Exalted Dragon");
        banned.add("Exorcist");
        banned.add("Eye of Singularity");
        banned.add("Faerie Noble");
        banned.add("Falling Star");
        banned.add("Farmstead");
        banned.add("Fastbond");
        banned.add("Fatal Lore");
        banned.add("Femeref Enchantress");
        banned.add("Field of Dreams");
        banned.add("Firestorm Hellkite");
        banned.add("Firestorm Phoenix");
        banned.add("Firestorm");
        banned.add("Flash");
        banned.add("Flooded Shoreline");
        banned.add("Floodwater Dam");
        banned.add("Flow of Maggots");
        banned.add("Forbidden Ritual");
        banned.add("Forcefield");
        banned.add("Forethought Amulet");
        banned.add("Fork");
        banned.add("Formation");
        banned.add("Forsaken Wastes");
        banned.add("Frankenstein's Monster");
        banned.add("Frantic Search");
        banned.add("Frenetic Efreet");
        banned.add("Fungal Bloom");
        banned.add("Fungus Elemental");
        banned.add("Fyndhorn Pollen");
        banned.add("Gaea's Avenger");
        banned.add("Gaea's Cradle");
        banned.add("Gallowbraid");
        banned.add("Gargantuan Gorilla");
        banned.add("Gate to Phyrexia");
        banned.add("Gauntlet of Might");
        banned.add("General Jarkeld");
        banned.add("Gilded Drake");
        banned.add("Glacial Crevasses");
        banned.add("Goblin Bomb");
        banned.add("Goblin Flotilla");
        banned.add("Goblin Recruiter");
        banned.add("Goblin Wizard");
        banned.add("Golgothian Sylex");
        banned.add("Gosta Dirk");
        banned.add("Grandmother Sengir");
        banned.add("Granite Gargoyle");
        banned.add("Grave Robbers");
        banned.add("Gravebind");
        banned.add("Gravity Sphere");
        banned.add("Great Whale");
        banned.add("Griffin Canyon");
        banned.add("Grim Feast");
        banned.add("Grim Monolith");
        banned.add("Guardian Beast");
        banned.add("Guiding Spirit");
        banned.add("Gush");
        banned.add("Gustha's Scepter");
        banned.add("Gwendlyn Di Corci");
        banned.add("Hakim, Loreweaver");
        banned.add("Halfdane");
        banned.add("Hall of Gemstone");
        banned.add("Halls of Mist");
        banned.add("Hand of Justice");
        banned.add("Harbinger of Night");
        banned.add("Hatred");
        banned.add("Haunting Wind");
        banned.add("Hazduhr the Abbot");
        banned.add("Hazezon Tamar");
        banned.add("Heart Wolf");
        banned.add("Heart of Bogardan");
        banned.add("Heart of Yavimaya");
        banned.add("Heat Stroke");
        banned.add("Hellfire");
        banned.add("Helm of Obedience");
        banned.add("Herald of Serra");
        banned.add("Hermit Druid");
        banned.add("Hidden Path");
        banned.add("Hivis of the Scale");
        banned.add("Homarid Shaman");
        banned.add("Hot Springs");
        banned.add("Humility");
        banned.add("Icatian Lieutenant");
        banned.add("Icatian Skirmishers");
        banned.add("Ice Cauldron");
        banned.add("Ifh-Biff Efreet");
        banned.add("Illusionary Mask");
        banned.add("Illusionary Presence");
        banned.add("Illusions of Grandeur");
        banned.add("Immediate Action");
        banned.add("Imperial Seal");
        banned.add("Implements of Sacrifice");
        banned.add("Imprison");
        banned.add("In the Eye of Chaos");
        banned.add("Infernal Denizen");
        banned.add("Infernal Tribute");
        banned.add("Infinite Authority");
        banned.add("Inner Sanctum");
        banned.add("Intuition");
        banned.add("Invoke Prejudice");
        banned.add("Island of Wak-Wak");
        banned.add("Iterative Analysis");
        banned.add("Ivory Gargoyle");
        banned.add("Jabari's Influence");
        banned.add("Jacques le Vert");
        banned.add("Jester's Mask");
        banned.add("Jeweled Bird");
        banned.add("Jihad");
        banned.add("Jovial Evil");
        banned.add("Jungle Patrol");
        banned.add("Juzam Djinn");
        banned.add("Kaervek's Spite");
        banned.add("Karn, Silver Golem");
        banned.add("Katabatic Winds");
        banned.add("Kaysa");
        banned.add("Keeper of Tresserhorn");
        banned.add("Khabal Ghoul");
        banned.add("King Suleiman");
        banned.add("Kjeldoran Knight");
        banned.add("Kjeldoran Outpost");
        banned.add("Kjeldoran Phalanx");
        banned.add("Knights of Thorn");
        banned.add("Knowledge Vault");
        banned.add("Kobold Overlord");
        banned.add("Kookus");
        banned.add("Koskun Falls");
        banned.add("Krovikan Horror");
        banned.add("Kudzu");
        banned.add("Kukemssa Pirates");
        banned.add("Lady Caleria");
        banned.add("Lady Evangela");
        banned.add("Lake of the Dead");
        banned.add("Land Cap");
        banned.add("Land Equilibrium");
        banned.add("Lava Tubes");
        banned.add("Leeches");
        banned.add("Leering Gargoyle");
        banned.add("Library of Alexandria");
        banned.add("Lich");
        banned.add("Lichenthrope");
        banned.add("Liege of the Hollows");
        banned.add("Life Matrix");
        banned.add("Lifeblood");
        banned.add("Lifeline");
        banned.add("Lightning Blow");
        banned.add("Lightning Cloud");
        banned.add("Lightning Dragon");
        banned.add("Lion's Eye Diamond");
        banned.add("Living Plane");
        banned.add("Livonya Silone");
        banned.add("Lodestone Bauble");
        banned.add("Lord of Tresserhorn");
        banned.add("Lotus Vale");
        banned.add("Lure of Prey");
        banned.add("Lurker");
        banned.add("Malignant Growth");
        banned.add("Mammoth Harness");
        banned.add("Mana Crypt");
        banned.add("Mana Drain");
        banned.add("Mana Matrix");
        banned.add("Mana Vault");
        banned.add("Mana Vortex");
        banned.add("Mana Web");
        banned.add("Mangara's Tome");
        banned.add("Maraxus of Keld");
        banned.add("Marjhan");
        banned.add("Marton Stromgald");
        banned.add("Martyr's Cry");
        banned.add("Martyrs of Korlis");
        banned.add("Master of the Hunt");
        banned.add("Masticore");
        banned.add("Meditate");
        banned.add("Memory Jar");
        banned.add("Mental Misstep");
        banned.add("Mercenaries");
        banned.add("Merchant Ship");
        banned.add("Mesmeric Trance");
        banned.add("Metalworker");
        banned.add("Mightstone");
        banned.add("Mind Over Matter");
        banned.add("Mind Twist");
        banned.add("Mind's Desire");
        banned.add("Mindbender Spores");
        banned.add("Minion of Tevesh Szat");
        banned.add("Mirror Universe");
        banned.add("Misers' Cage");
        banned.add("Misfortune");
        banned.add("Mishra's Workshop");
        banned.add("Mist Dragon");
        banned.add("Moat");
        banned.add("Mold Demon");
        banned.add("Morinfen");
        banned.add("Morphling");
        banned.add("Mountain Titan");
        banned.add("Mox Diamond");
        banned.add("Mox Emerald");
        banned.add("Mox Jet");
        banned.add("Mox Pearl");
        banned.add("Mox Ruby");
        banned.add("Mox Sapphire");
        banned.add("Mudslide");
        banned.add("Multani, Maro-Sorcerer");
        banned.add("Musician");
        banned.add("Muzzio's Preparations");
        banned.add("Mwonvuli Ooze");
        banned.add("Mystic Decree");
        banned.add("Mystic Might");
        banned.add("Mystical Tutor");
        banned.add("Nameless Race");
        banned.add("Narwhal");
        banned.add("Natural Balance");
        banned.add("Natural Selection");
        banned.add("Nature's Wrath");
        banned.add("Necropotence");
        banned.add("Nether Void");
        banned.add("Niall Silvain");
        banned.add("North Star");
        banned.add("Nova Pentacle");
        banned.add("Null Chamber");
        banned.add("Null Rod");
        banned.add("Oath of Druids");
        banned.add("Oath of Ghouls");
        banned.add("Ogre Enforcer");
        banned.add("Old Man of the Sea");
        banned.add("Omen of Fire");
        banned.add("Opal Archangel");
        banned.add("Opalescence");
        banned.add("Orim, Samite Healer");
        banned.add("Palinchron");
        banned.add("Paradigm Shift");
        banned.add("Paupers' Cage");
        banned.add("Peacekeeper");
        banned.add("Pendrell Mists");
        banned.add("Phantasmal Sphere");
        banned.add("Phelddagrif");
        banned.add("Phyrexian Devourer");
        banned.add("Phyrexian Dreadnought");
        banned.add("Phyrexian Marauder");
        banned.add("Phyrexian Negator");
        banned.add("Phyrexian Portal");
        banned.add("Phyrexian Purge");
        banned.add("Phyrexian Tribute");
        banned.add("Pillar Tombs of Aku");
        banned.add("Pixie Queen");
        banned.add("Planar Gate");
        banned.add("Plateau (Brudi)");
        banned.add("Plateau (Tucker)");
        banned.add("Polar Kraken");
        banned.add("Political Trickery");
        banned.add("Powder Keg");
        banned.add("Power Artifact");
        banned.add("Power Play");
        banned.add("Powerleech");
        banned.add("Preacher");
        banned.add("Preferred Selection");
        banned.add("Prismatic Lace");
        banned.add("Psychic Allergy");
        banned.add("Psychic Vortex");
        banned.add("Purgatory");
        banned.add("Purraj of Urborg");
        banned.add("Pygmy Hippo");
        banned.add("Pyramids");
        banned.add("Quarum Trench Gnomes");
        banned.add("Quirion Druid");
        banned.add("Radiant, Archangel");
        banned.add("Raging River");
        banned.add("Ragnar");
        banned.add("Rainbow Efreet");
        banned.add("Rainbow Vale");
        banned.add("Ramses Overdark");
        banned.add("Rapid Fire");
        banned.add("Rashida Scalebane");
        banned.add("Rasputin Dreamweaver");
        banned.add("Razor Pendulum");
        banned.add("Reality Twist");
        banned.add("Rebirth");
        banned.add("Recurring Nightmare");
        banned.add("Recycle");
        banned.add("Reflect Damage");
        banned.add("Reparations");
        banned.add("Replenish");
        banned.add("Retribution of the Meek");
        banned.add("Reveka, Wizard Savant");
        banned.add("Reverberation");
        banned.add("Righteous War");
        banned.add("Ring of Gix");
        banned.add("Ring of Immortals");
        banned.add("Ring of Ma'ruf");
        banned.add("Ring of Renewal");
        banned.add("Ritual of Subdual");
        banned.add("Ritual of the Machine");
        banned.add("River Delta");
        banned.add("River Merfolk");
        banned.add("Roc of Kher Ridges");
        banned.add("Rock Basilisk");
        banned.add("Rock Hydra");
        banned.add("Rofellos, Llanowar Emissary");
        banned.add("Rogue Skycaptain");
        banned.add("Rohgahh of Kher Keep");
        banned.add("Royal Decree");
        banned.add("Rysorian Badger");
        banned.add("Sandals of Abdallah");
        banned.add("Sands of Time");
        banned.add("Sarcomancy");
        banned.add("Savannah");
        banned.add("Sawback Manticore");
        banned.add("Scarwood Bandits");
        banned.add("Scorched Ruins");
        banned.add("Scrubland");
        banned.add("Season of the Witch");
        banned.add("Second Chance");
        banned.add("Secret Summoning");
        banned.add("Secrets of Paradise");
        banned.add("Sedge Troll");
        banned.add("Seeds of Innocence");
        banned.add("Selenia, Dark Angel");
        banned.add("Sentinel Dispatch");
        banned.add("Serendib Djinn");
        banned.add("Serra Aviary");
        banned.add("Serra's Sanctum");
        banned.add("Shahrazad");
        banned.add("Shallow Grave");
        banned.add("Shauku, Endbringer");
        banned.add("Sheltered Valley");
        banned.add("Shimmer");
        banned.add("Sidar Jabari");
        banned.add("Silver Wyvern");
        banned.add("Singing Tree");
        banned.add("Skeleton Ship");
        banned.add("Skullclamp");
        banned.add("Sliver Queen");
        banned.add("Snowblind");
        banned.add("Sol Ring");
        banned.add("Soldevi Digger");
        banned.add("Soldevi Excavations");
        banned.add("Soldevi Golem");
        banned.add("Soraya the Falconer");
        banned.add("Sorrow's Path");
        banned.add("Soul Echo");
        banned.add("Spectral Guardian");
        banned.add("Spinal Villain");
        banned.add("Spirit Shield");
        banned.add("Spirit of the Night");
        banned.add("Spiritual Sanctuary");
        banned.add("Splintering Wind");
        banned.add("Spoils of Evil");
        banned.add("Spoils of War");
        banned.add("Squandered Resources");
        banned.add("Stone Calendar");
        banned.add("Storm Spirit");
        banned.add("Storm World");
        banned.add("Strip Mine");
        banned.add("Su-Chi");
        banned.add("Subterranean Spirit");
        banned.add("Suleiman's Legacy");
        banned.add("Survival of the Fittest");
        banned.add("Sustaining Spirit");
        banned.add("Sword of the Ages");
        banned.add("Sworn Defender");
        banned.add("Taiga");
        banned.add("Tainted Specter");
        banned.add("Taniwha");
        banned.add("Tawnos's Coffin");
        banned.add("Teeka's Dragon");
        banned.add("Teferi's Imp");
        banned.add("Teferi's Isle");
        banned.add("Teferi's Realm");
        banned.add("Telekinesis");
        banned.add("Telim'Tor");
        banned.add("Telim'Tor's Edict");
        banned.add("Tempest Efreet");
        banned.add("Temporal Aperture");
        banned.add("Tetsuo Umezawa");
        banned.add("Thawing Glaciers");
        banned.add("The Abyss");
        banned.add("The Tabernacle at Pendrell Vale");
        banned.add("Thelon's Curse");
        banned.add("Thelonite Monk");
        banned.add("Thought Lash");
        banned.add("Thran Tome");
        banned.add("Three Wishes");
        banned.add("Thrull Champion");
        banned.add("Thunder Spirit");
        banned.add("Tidal Control");
        banned.add("Timberline Ridge");
        banned.add("Time Spiral");
        banned.add("Time Vault");
        banned.add("Time Walk");
        banned.add("Timetwister");
        banned.add("Timetwister");
        banned.add("Timmerian Fiends");
        banned.add("Tinker");
        banned.add("Tithe");
        banned.add("Tolarian Academy");
        banned.add("Tolarian Entrancer");
        banned.add("Tolarian Serpent");
        banned.add("Tombstone Stairwell");
        banned.add("Tornado");
        banned.add("Torrent of Lava");
        banned.add("Tourach's Gate");
        banned.add("Tracker");
        banned.add("Trailblazer");
        banned.add("Transmute Artifact");
        banned.add("Treachery");
        banned.add("Treasure Cruise");
        banned.add("Triangle of War");
        banned.add("Tropical Island");
        banned.add("Tuknir Deathlock");
        banned.add("Tundra");
        banned.add("Two-Headed Giant of Foriys");
        banned.add("Typhoon");
        banned.add("Underground Sea");
        banned.add("Undiscovered Paradise");
        banned.add("Unexpected Potential");
        banned.add("Unfulfilled Desires");
        banned.add("Ur-Drago");
        banned.add("Urborg Justice");
        banned.add("Urborg Stalker");
        banned.add("Urza's Miter");
        banned.add("Vampiric Tutor");
        banned.add("Varchild's War-Riders");
        banned.add("Veldrane of Sengir");
        banned.add("Veldt");
        banned.add("Ventifact Bottle");
        banned.add("Vesuvan Doppelganger");
        banned.add("Veteran Bodyguard");
        banned.add("Viashivan Dragon");
        banned.add("Vodalian Knights");
        banned.add("Vodalian War Machine");
        banned.add("Volcanic Island");
        banned.add("Volrath's Shapeshifter");
        banned.add("Volrath's Stronghold");
        banned.add("Wall of Kelp");
        banned.add("Wandering Mage");
        banned.add("Warping Wurm");
        banned.add("Wave of Terror");
        banned.add("Weakstone");
        banned.add("Weatherseed Treefolk");
        banned.add("Well of Knowledge");
        banned.add("Wellspring");
        banned.add("Wheel of Fortune");
        banned.add("Willow Priestess");
        banned.add("Willow Satyr");
        banned.add("Windfall");
        banned.add("Winding Canyons");
        banned.add("Winter Sky");
        banned.add("Winter's Chill");
        banned.add("Winter's Night");
        banned.add("Wood Elemental");
        banned.add("Word of Command");
        banned.add("Worldknit");
        banned.add("Worms of the Earth");
        banned.add("Wormwood Treefolk");
        banned.add("Xanthic Statue");
        banned.add("Yare");
        banned.add("Yavimaya Hollow");
        banned.add("Yawgmoth's Bargain");
        banned.add("Yawgmoth's Will");
        banned.add("Zelyon Sword");
        banned.add("Zephid");
        banned.add("Zhalfirin Crusader");
        banned.add("Zirilan of the Claw");
        banned.add("Zuberi, Golden Feather");
    }
}
